/*!**********************************************************************
*!
*! FILE NAME: hwregs.h
*!
*! DESCRIPTION: Interface to shadow registers.
*!
*! FUNCTIONS: none
*!
*! NOTE: This file is automatically generated, do _not_ edit.
*!       Created: Thu Oct  3 01:21:27 2002
*!       By:      Id: shadow_gen,v 1.14 2002/10/02 20:31:22 hp Exp 
*!       From:    /n/asic/projects/etrax_ng/doc/work/etrax_ng_regs.rd 1.168
*!                /n/asic/projects/etrax_ng/include//hwregs.ctrl 1.3
*!
*! MACROS: REG_GET
*!         REG_IGET
*!         REG_VGET
*!         REG_SET
*!         REG_ISET
*!         REG_VSET
*!         REG_SET_VAL
*!         REG_SET__register-name (one for each register)
*!         REG_SET__register-name__SHADOW (one for each register)
*!         REG_MASK__register-name (one for each register)
*!         REG_VAL__register-name (one for each register)
*!         REG_EQL
*!         REG_IEQL
*!         REG_VEQL
*!         REG_VAL
*!         REG_CHK_VAL
*!         REG_RD
*!         REG_IRD
*!         REG_WR
*!         REG_IWR
*!         REG_ADDR
*!         REG_BITNR
*!
*!----------------------------------------------------------------------
*! HISTORY
*!
*! DATE           NAME                 CHANGES
*! ----           ----                 -------
*! Apr 01 1998    Jan Bengtsson        Initial version
*! Oct 01 2002    Hans-Peter Nilsson   Large mechanical changes to correct
*!                                     use of the ## operator.
*!----------------------------------------------------------------------
*!
*! (C) Copyright 1998, 2002 Axis Communications AB, LUND, SWEDEN
*!
*!**********************************************************************/
/* %Z% %M% %I% %G% */

#ifndef __HWREGS_H__
#define __HWREGS_H__

/********************** INCLUDE FILES SECTION **************************/
#ifndef __ASSEMBLER__
#include "compiler.h"
#include "debug.h"
#endif /* __ASSEMBLER__ */

#include "project.h"
#include "hwregs_def.h"

#ifndef __ASSEMBLER__

#ifndef __REG_GENERAL_1_H__
#define __REG_GENERAL_1_H__

/*
** This part of hwregs.h is common to all shadow
** register modules, and should therefore only be included once to
** avoid macro redefinitions.
*/

/* REG_DEBUG is by default controlled by DEBUG from debug.h. */
#ifndef REG_DEBUG
#ifdef DEBUG
#define REG_DEBUG 1
#else
#define REG_DEBUG 0
#endif /* DEBUG */
#endif /* REG_DEBUG */

#endif /* __REG_GENERAL_1_H__ */

#endif /* __ASSEMBLER__ */

/********************** TYPE DEFINITION SECTION ************************/
#ifndef __ASSEMBLER__

#ifndef REG_NO_SHADOW

/* Only write only registers need a shadow register. */

typedef struct {
#if USE_GROUP__Bus_interface_configuration_registers
  byte R_WAITSTATES[4];
  byte R_BUS_CONFIG[4];
  byte R_DRAM_TIMING[4];
  byte R_DRAM_CONFIG[4];
#endif
#if USE_GROUP__External_DMA_registers
  byte R_EXT_DMA_0_CMD[4];
  byte R_EXT_DMA_0_ADDR[4];
  byte R_EXT_DMA_1_CMD[4];
  byte R_EXT_DMA_1_ADDR[4];
#endif
#if USE_GROUP__Timer_registers
  byte R_TIMER_CTRL[4];
  byte R_WATCHDOG[4];
#endif
#if USE_GROUP__General_config_registers
  byte R_GEN_CONFIG[4];
#endif
#if USE_GROUP__General_port_configuration_registers
  byte R_PORT_PA_SET[4];
#endif
#if USE_GROUP__General_config_registers
  byte R_GEN_CONFIG_II[4];
#endif
#if USE_GROUP__General_port_configuration_registers
  byte R_PORT_PB_SET[4];
#endif
#if USE_GROUP__DMA_registers
  byte R_SET_EOP[4];
#endif
#if USE_GROUP__ATA_interface_registers || \
    USE_GROUP__Parallel_printer_port_registers || \
    USE_GROUP__SCSI_registers || \
    USE_GROUP__Shared_RAM_interface_registers
  byte R_ATA_CTRL_DATA[4];
  byte R_ATA_CONFIG[4];
#endif
#if USE_GROUP__Parallel_printer_port_registers
  byte R_PAR0_DELAY[4];
#endif
#if USE_GROUP__Parallel_printer_port_registers || \
    USE_GROUP__SCSI_registers || \
    USE_GROUP__USB_interface_control_registers
  byte R_PAR1_CTRL_DATA[4];
#endif
#if USE_GROUP__Parallel_printer_port_registers || \
    USE_GROUP__SCSI_registers
  byte R_PAR1_CONFIG[4];
#endif
#if USE_GROUP__Parallel_printer_port_registers
  byte R_PAR1_DELAY[4];
#endif
#if USE_GROUP__Serial_port_registers
  byte R_ALT_SER_BAUDRATE[4];
  byte R_SERIAL0_CTRL[4];
  byte R_SERIAL0_XOFF[4];
#endif
#if USE_GROUP__Serial_port_registers || \
    USE_GROUP__Syncrounous_serial_port_registers || \
    USE_GROUP__USB_interface_control_registers
  byte R_SERIAL1_CTRL[4];
#endif
#if USE_GROUP__Serial_port_registers || \
    USE_GROUP__Syncrounous_serial_port_registers
  byte R_SERIAL1_XOFF[4];
#endif
#if USE_GROUP__Serial_port_registers
  byte R_SERIAL2_CTRL[4];
  byte R_SERIAL2_XOFF[4];
#endif
#if USE_GROUP__Serial_port_registers || \
    USE_GROUP__Syncrounous_serial_port_registers
  byte R_SERIAL3_CTRL[4];
  byte R_SERIAL3_XOFF[4];
#endif
#if USE_GROUP__Network_interface_registers
  byte R_NETWORK_SA_0[4];
  byte R_NETWORK_SA_1[4];
  byte R_NETWORK_SA_2[4];
  byte R_NETWORK_GA_0[4];
  byte R_NETWORK_GA_1[4];
  byte R_NETWORK_REC_CONFIG[4];
  byte R_NETWORK_GEN_CONFIG[4];
  byte R_NETWORK_TR_CTRL[4];
  byte R_NETWORK_MGM_CTRL[4];
#endif
#if USE_GROUP__Interrupt_mask_and_status_registers
  byte R_IRQ_MASK0_CLR[4];
  byte R_IRQ_MASK0_SET[4];
  byte R_IRQ_MASK1_CLR[4];
  byte R_IRQ_MASK1_SET[4];
  byte R_IRQ_MASK2_CLR[4];
  byte R_IRQ_MASK2_SET[4];
  byte R_VECT_MASK_CLR[4];
  byte R_VECT_MASK_SET[4];
#endif
#if USE_GROUP__Timer_registers
  byte R_CLOCK_PRESCALE[4];
  byte R_SYNC_SERIAL_PRESCALE[4];
#endif
#if USE_GROUP__Test_mode_registers
  byte R_TEST_MODE[4];
#endif
#if USE_GROUP__DMA_registers
  byte R_DMA_CH0_CLR_INTR[1];
  byte R_DMA_CH1_CLR_INTR[1];
  byte R_DMA_CH2_CLR_INTR[1];
  byte R_DMA_CH3_CLR_INTR[1];
  byte R_DMA_CH4_CLR_INTR[1];
  byte R_DMA_CH8_SUB0_CLR_INTR[1];
  byte R_DMA_CH5_CLR_INTR[1];
  byte R_DMA_CH8_SUB1_CLR_INTR[1];
  byte R_DMA_CH6_CLR_INTR[1];
  byte R_DMA_CH8_SUB2_CLR_INTR[1];
  byte R_DMA_CH7_CLR_INTR[1];
  byte R_DMA_CH8_SUB3_CLR_INTR[1];
  byte R_DMA_CH8_CLR_INTR[1];
  byte R_DMA_CH9_CLR_INTR[1];
#endif
#if USE_GROUP__USB_interface_control_registers
  byte R_USB_IRQ_MASK_SET[2];
  byte R_USB_IRQ_MASK_CLR[2];
#endif
#if USE_GROUP__MMU_registers
  byte R_MMU_CONFIG[4];
  byte R_MMU_KBASE_LO[4];
  byte R_MMU_KBASE_HI[4];
#endif
} reg_shadow_type__hwregs;

#else /* REG_NO_SHADOW */

typedef const udword reg_shadow_type__hwregs;

#endif /* REG_NO_SHADOW */

extern reg_shadow_type__hwregs reg_shadow__hwregs;

#if REG_DEBUG

/*
 *  Only write only registers need an initiated flag.
 *  Flag is set to all ones at startup, and cleared to
 *  zero when initiated.
 */

#ifndef REG_NO_SHADOW

typedef struct {
#if USE_GROUP__Bus_interface_configuration_registers
  byte R_WAITSTATES[4];
  byte R_BUS_CONFIG[4];
  byte R_DRAM_TIMING[4];
  byte R_DRAM_CONFIG[4];
#endif
#if USE_GROUP__External_DMA_registers
  byte R_EXT_DMA_0_CMD[4];
  byte R_EXT_DMA_0_ADDR[4];
  byte R_EXT_DMA_1_CMD[4];
  byte R_EXT_DMA_1_ADDR[4];
#endif
#if USE_GROUP__Timer_registers
  byte R_TIMER_CTRL[4];
  byte R_WATCHDOG[4];
#endif
#if USE_GROUP__General_config_registers
  byte R_GEN_CONFIG[4];
#endif
#if USE_GROUP__General_port_configuration_registers
  byte R_PORT_PA_SET[4];
#endif
#if USE_GROUP__General_config_registers
  byte R_GEN_CONFIG_II[4];
#endif
#if USE_GROUP__General_port_configuration_registers
  byte R_PORT_PB_SET[4];
#endif
#if USE_GROUP__DMA_registers
  byte R_SET_EOP[4];
#endif
#if USE_GROUP__ATA_interface_registers || \
    USE_GROUP__Parallel_printer_port_registers || \
    USE_GROUP__SCSI_registers || \
    USE_GROUP__Shared_RAM_interface_registers
  byte R_ATA_CTRL_DATA[4];
  byte R_ATA_CONFIG[4];
#endif
#if USE_GROUP__Parallel_printer_port_registers
  byte R_PAR0_DELAY[4];
#endif
#if USE_GROUP__Parallel_printer_port_registers || \
    USE_GROUP__SCSI_registers || \
    USE_GROUP__USB_interface_control_registers
  byte R_PAR1_CTRL_DATA[4];
#endif
#if USE_GROUP__Parallel_printer_port_registers || \
    USE_GROUP__SCSI_registers
  byte R_PAR1_CONFIG[4];
#endif
#if USE_GROUP__Parallel_printer_port_registers
  byte R_PAR1_DELAY[4];
#endif
#if USE_GROUP__Serial_port_registers
  byte R_ALT_SER_BAUDRATE[4];
  byte R_SERIAL0_CTRL[4];
  byte R_SERIAL0_XOFF[4];
#endif
#if USE_GROUP__Serial_port_registers || \
    USE_GROUP__Syncrounous_serial_port_registers || \
    USE_GROUP__USB_interface_control_registers
  byte R_SERIAL1_CTRL[4];
#endif
#if USE_GROUP__Serial_port_registers || \
    USE_GROUP__Syncrounous_serial_port_registers
  byte R_SERIAL1_XOFF[4];
#endif
#if USE_GROUP__Serial_port_registers
  byte R_SERIAL2_CTRL[4];
  byte R_SERIAL2_XOFF[4];
#endif
#if USE_GROUP__Serial_port_registers || \
    USE_GROUP__Syncrounous_serial_port_registers
  byte R_SERIAL3_CTRL[4];
  byte R_SERIAL3_XOFF[4];
#endif
#if USE_GROUP__Network_interface_registers
  byte R_NETWORK_SA_0[4];
  byte R_NETWORK_SA_1[4];
  byte R_NETWORK_SA_2[4];
  byte R_NETWORK_GA_0[4];
  byte R_NETWORK_GA_1[4];
  byte R_NETWORK_REC_CONFIG[4];
  byte R_NETWORK_GEN_CONFIG[4];
  byte R_NETWORK_TR_CTRL[4];
  byte R_NETWORK_MGM_CTRL[4];
#endif
#if USE_GROUP__Interrupt_mask_and_status_registers
  byte R_IRQ_MASK0_CLR[4];
  byte R_IRQ_MASK0_SET[4];
  byte R_IRQ_MASK1_CLR[4];
  byte R_IRQ_MASK1_SET[4];
  byte R_IRQ_MASK2_CLR[4];
  byte R_IRQ_MASK2_SET[4];
  byte R_VECT_MASK_CLR[4];
  byte R_VECT_MASK_SET[4];
#endif
#if USE_GROUP__Timer_registers
  byte R_CLOCK_PRESCALE[4];
  byte R_SYNC_SERIAL_PRESCALE[4];
#endif
#if USE_GROUP__Test_mode_registers
  byte R_TEST_MODE[4];
#endif
#if USE_GROUP__DMA_registers
  byte R_DMA_CH0_CLR_INTR[1];
  byte R_DMA_CH1_CLR_INTR[1];
  byte R_DMA_CH2_CLR_INTR[1];
  byte R_DMA_CH3_CLR_INTR[1];
  byte R_DMA_CH4_CLR_INTR[1];
  byte R_DMA_CH8_SUB0_CLR_INTR[1];
  byte R_DMA_CH5_CLR_INTR[1];
  byte R_DMA_CH8_SUB1_CLR_INTR[1];
  byte R_DMA_CH6_CLR_INTR[1];
  byte R_DMA_CH8_SUB2_CLR_INTR[1];
  byte R_DMA_CH7_CLR_INTR[1];
  byte R_DMA_CH8_SUB3_CLR_INTR[1];
  byte R_DMA_CH8_CLR_INTR[1];
  byte R_DMA_CH9_CLR_INTR[1];
#endif
#if USE_GROUP__USB_interface_control_registers
  byte R_USB_IRQ_MASK_SET[2];
  byte R_USB_IRQ_MASK_CLR[2];
#endif
#if USE_GROUP__MMU_registers
  byte R_MMU_CONFIG[4];
  byte R_MMU_KBASE_LO[4];
  byte R_MMU_KBASE_HI[4];
#endif
} reg_initiated_type__hwregs;

#else /* REG_NO_SHADOW */

typedef const udword reg_initiated_type__hwregs;

#endif /* REG_NO_SHADOW */

extern reg_initiated_type__hwregs reg_initiated__hwregs;

#endif /* REG_DEBUG */

extern void init_shadow__hwregs();

#endif /* __ASSEMBLER__ */


/********************** CONSTANT AND MACRO SECTION *********************/
#ifndef __REG_GENERAL_2_H__
#define __REG_GENERAL_2_H__

/*
** This part of hwregs.h is common to all shadow
** register modules, and should therefore only be included once to
** avoid macro redefinitions.
*/

#ifndef __ASSEMBLER__

/*
 *  Register type-casts
 */
#define REG_TYPECAST_UDWORD  (volatile udword*)
#define REG_TYPECAST_RO_UDWORD  (const volatile udword*)
#define REG_TYPECAST_UWORD  (volatile uword*)
#define REG_TYPECAST_RO_UWORD  (const volatile uword*)
#define REG_TYPECAST_BYTE  (volatile byte*)
#define REG_TYPECAST_RO_BYTE  (const volatile byte*)

/*
 *  Shadow register type-casts
 */
#define REG_STYPECAST_UDWORD  (udword*)
#define REG_STYPECAST_UWORD  (uword*)
#define REG_STYPECAST_BYTE  (byte*)

#else

/*
 *  Register type-casts
 */
#define REG_TYPECAST_UDWORD
#define REG_TYPECAST_RO_UDWORD
#define REG_TYPECAST_UWORD
#define REG_TYPECAST_RO_UWORD
#define REG_TYPECAST_BYTE
#define REG_TYPECAST_RO_BYTE

/*
 *  Shadow register type-casts
 */
#define REG_STYPECAST_UDWORD
#define REG_STYPECAST_UWORD
#define REG_STYPECAST_BYTE

#endif


#define REG_UDWORD udword
#define REG_UWORD uword
#define REG_BYTE byte

#define REG__on  0xffffffffU
#define REG__off 0

#endif /* __REG_GENERAL_2_H__ */

#include "hwregs_int.h"

#ifndef __REG_GENERAL_3_H__
#define __REG_GENERAL_3_H__

/*
** This part of hwregs.h is common to all shadow
** register modules, and should therefore only be included once to
** avoid macro redefinitions.
*/

/*#**********************************************************************
*#
*# MACRO NAME  : REG_GET
*#
*# PARAMETERS  : reg   : Name of a register.
*#               field : Name of a field.
*#
*# RETURNS     : Value of field field in register reg.
*#
*# SIDE EFFECTS: May evaluate REG_SERROR.
*#
*# DESCRIPTION : Read a field in a register. Also see description
*#               of REG_GET_WO, REG_GET_RO, and REG_GET_RW.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to reg and field parameters when
*#                                     passing on to other macros.
*#**********************************************************************/

#define REG_GET(reg,field) ( \
  reg##__GET(reg##_, field##_) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_IGET
*#
*# PARAMETERS  : i     : Interface number.
*#               reg   : Name of a register.
*#               field : Name of a field.
*#
*# RETURNS     : Value of field field in register reg.
*#
*# SIDE EFFECTS: May evaluate REG_SERROR, and REG_IERROR.
*#
*# DESCRIPTION : Read a field in a register for interface i.
*#               Also see description of REG_IGET_WO, REG_IGET_RO,
*#               and REG_IGET_RW.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to reg and field parameters when
*#                                     passing on to other macros.
*#**********************************************************************/

#define REG_IGET(i,reg,field) ( \
  reg##__IGET(i, reg##_, field##_) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VGET
*#
*# PARAMETERS  : reg   : Name of a register.
*#               field : Name of a field.
*#               var   : Variable or value to read from.
*#
*# RETURNS     : Value of field field in variable var.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Interprets variable var as register reg, and read field
*#               field from variable var.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*#**********************************************************************/

#define REG_VGET(reg,field,var) ( \
  ((reg##__TYPE var) & reg##__##field##__##field##__MASK) >> \
    reg##__##field##__BITNR \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET
*#
*# PARAMETERS  : reg   : Name of a register.
*#               field : Name of a field.
*#               val   : Value to write to field.
*#
*# RETURNS     : Integer value written to complete register.
*#
*# SIDE EFFECTS: May evaluate REG_SERROR and REG_VERROR.
*#
*# DESCRIPTION : Write val parameter to field field in register reg.
*#               Parameter reg must be a write only or read write
*#               register. Also see description of REG_SET_WO, and
*#               REG_SET_RW.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to reg and field parameters when
*#                                     passing on to other macros.
*#**********************************************************************/

#define REG_SET(reg,field,val) ( \
  reg##__SET(reg##_, field##_, val) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_ISET
*#
*# PARAMETERS  : i     : Interface number.
*#               reg   : Name of a register.
*#               field : Name of a field.
*#               val   : Value to write to field.
*#
*# RETURNS     : Integer value written to complete register.
*#
*# SIDE EFFECTS: May evaluate REG_IERROR, REG_SERROR, and REG_VERROR.
*#
*# DESCRIPTION : Write val parameter to field field in register reg
*#               of interface i. Parameter reg must be a write only 
*#               or read write register. Also see description of 
*#               REG_ISET_WO, and REG_ISET_RW.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to reg and field parameters when
*#                                     passing on to other macros.
*#**********************************************************************/

#define REG_ISET(i,reg,field,val) ( \
  reg##__ISET(i, reg##_, field##_, val) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VSET
*#
*# PARAMETERS  : reg   : Name of a register.
*#               field : Name of a field.
*#               val   : Value to write to field.
*#               var   : Variable to write to.
*#
*# RETURNS     : Integer value of variable var after write.
*#
*# SIDE EFFECTS: May evaluate REG_VERROR.
*#
*# DESCRIPTION : Interpret variable var as register reg, and write val 
*#               parameter to field field in variable var.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to reg and field parameters when
*#                                     passing on to other macros.
*#**********************************************************************/

#define REG_VSET(reg,field,val,var) ( \
  var = \
    ((reg##__TYPE var) & REG_IMASK (reg##_, field##_)) | \
    (reg##__##field##__##field##__VAL(reg##_, field##_, val) << \
      reg##__##field##__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET_VAL
*#
*# PARAMETERS  : reg   : Name of a register.
*#               field : Name of a field.
*#               val   : Integer value to write to symbolic field.
*#
*# RETURNS     : Integer value written to complete register.
*#
*# SIDE EFFECTS: May evaluate REG_SERROR and REG_VERROR.
*#
*# DESCRIPTION : Write val parameter to field field in register reg.
*#               Parameter reg must be a write only or read write register.
*#               Also see description of REG_SET_VAL_WO, and REG_SET_VAL_RW.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to reg and field parameters when
*#                                     passing on to other macros.
*#**********************************************************************/

#define REG_SET_VAL(reg,field,val) ( \
  reg##__SET_VAL(reg##_, field##_, val) \
)

/*
 *  See end of file for these.
 *
 *  #define REG_SET__register-name
 *  #define REG_SET__register-name__SHADOW
 *  #define REG_MASK__register-name
 *  #define REG_VAL__register-name
 */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_EQL
*#
*# PARAMETERS  : reg   : Name of a register.
*#               field : Name of a field.
*#               val   : Value to compare with field.
*#
*# RETURNS     : TRUE, FALSE
*#
*# SIDE EFFECTS: May evaluate REG_SERROR and REG_VERROR.
*#
*# DESCRIPTION : Compare val parameter with field field in register reg.
*#               Also description of REG_EQL_WO, REG_EQL_RO, and
*#               REG_EQL_RW.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to reg and field parameters when
*#                                     passing on to other macros.
*#**********************************************************************/
#define REG_EQL(reg,field,val) ( \
  reg##__EQL(reg##_, field##_, val) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_IEQL
*#
*# PARAMETERS  : i     : Interface number.
*#               reg   : Name of a register.
*#               field : Name of a field.
*#               val   : Value to compare with field.
*#
*# RETURNS     : TRUE, FALSE
*#
*# SIDE EFFECTS: May evaluate REG_VERROR, REG_IERROR, and REG_SERROR.
*#
*# DESCRIPTION : Compare val parameter with field field in register reg
*#               of interface i. Also see description of REG_IEQL_WO,
*#               REG_IEQ_RO, and REG_IEQL_RW.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to reg and field parameters when
*#                                     passing on to other macros.
*#**********************************************************************/

#define REG_IEQL(i,reg,field,val) ( \
  reg##__IEQL(i,reg##_,field##_,val) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VEQL
*#
*# PARAMETERS  : reg   : Name of a register.
*#               field : Name of a field.
*#               val   : Value to compare with field.
*#               var   : Variable (or value) to compare with.
*#
*# RETURNS     : TRUE, FALSE
*#
*# SIDE EFFECTS: May evaluate REG_VERROR.
*#
*# DESCRIPTION : Interprets variable var as register reg, and compare
*#               compare field field with parameter val.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to reg and field parameters when
*#                                     passing on to other macros.
*#**********************************************************************/

#define REG_VEQL(reg,field,val,var) ( \
  ( ((reg##__TYPE (var)) & reg##__##field##__##field##__MASK) >> \
        reg##__##field##__BITNR \
  ) == reg##__##field##__##field##__VAL(reg##_, field##_, val) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL
*#
*# PARAMETERS  : reg   : Name of a register.
*#               field : Name of a field.
*#               val   : A symbolic constant.
*#
*# RETURNS     : val or (val << REG_VERROR()) macro.
*#
*# SIDE EFFECTS: May evaluate REG_VERROR macro.
*#
*# DESCRIPTION : Convert a symbolic constant to an integer value.
*#               Intended to be used for enumerated fields. Also
*#               Also works for value fields, in which case the val
*#               parameter is checked for range and returned if OK,
*#               and if val is out of range (val << REG_VERROR) is
*#               returned. Also see description of REG_VAL_VAL, and
*#               REG_VAL_ENUM.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to reg and field parameters when
*#                                     passing on to other macros.
*#**********************************************************************/

#define REG_VAL(reg,field,val) ( \
  reg##__##field##__##field##__VAL(reg##_, field##_, val) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_CHK_VAL
*#
*# PARAMETERS  : reg   : Name of a register.
*#               field : Name of a field.
*#               val   : An integer value.
*#
*# RETURNS     : 1 if val is within allowed range for field, otherwise 0.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Check if parameter val is within the field range,
*#               and return 1 if it is, otherwise 0.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*#**********************************************************************/

#define REG_CHK_VAL(reg,field,val) ( \
  (udword)(~(val)) <= (udword)(~(reg##__##field##__MIN)) && \
  (udword)(val) <= (udword)(reg##__##field##__MAX) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_RD
*#
*# PARAMETERS  : reg   : Name of a register.
*#
*# RETURNS     : Contents of register reg.
*#
*# SIDE EFFECTS: May evaluate REG_SERROR.
*#
*# DESCRIPTION : Read contents of register reg. Also see description of
*#               REG_RD_WO, REG_RD_RO, and REG_RD_RW.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to reg parameter when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_RD(reg) ( \
  reg##__RD(reg##_) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_IRD
*#
*# PARAMETERS  : i     : Interface number.
*#               reg   : Name of a register.
*#
*# RETURNS     : Contents of register reg.
*#
*# SIDE EFFECTS: May evaluate REG_SERROR and REG_IERROR.
*#
*# DESCRIPTION : Read contents of register reg. Also see description of
*#               REG_IRD_WO, REG_IRD_RO, and REG_IRD_RW.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to reg parameter when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_IRD(i,reg) ( \
  reg##__IRD(i,reg##_) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_WR
*#
*# PARAMETERS  : reg   : Name of a register.
*#               var   : Variable (or value) to write to reg.
*#
*# RETURNS     : integer value written to register reg.
*#
*# SIDE EFFECTS: May evaluate REG_SERROR.
*#
*# DESCRIPTION : Write value of var parameter to register reg. Also see
*#               description of REG_WR_WO, and REG_WR_RW.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to reg parameter when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_WR(reg,var) ( \
  reg##__WR(reg##_,var) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_IWR
*#
*# PARAMETERS  : i     : Interface number.
*#               reg   : Name of a register.
*#               var   : Variable (or value) to write to reg.
*#
*# RETURNS     : integer value written to register reg.
*#
*# SIDE EFFECTS: May evaluate REG_SERROR.
*#
*# DESCRIPTION : Write value of var parameter to register reg of
*#               interface i. Also see description of REG_IWR_WO,
*#               and REG_IWR_RW.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to reg parameter when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_IWR(i,reg,var) ( \
  reg##__IWR(i##_, reg##_, var) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_ADDR
*#
*# PARAMETERS  : reg   : Name of a register.
*#
*# RETURNS     : Address to register reg.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Calculate address to register reg.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*#**********************************************************************/

#define REG_ADDR(reg) ( \
  reg##__ADDR \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_BITNR
*#
*# PARAMETERS  : reg   : Name of a register.
*#               field : Name of a field in register reg.
*#
*# RETURNS     : Position of least significant bit of field in reg..
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Calculate position of least significant bit of
*#               field field in register reg.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*#**********************************************************************/

#define REG_BITNR(reg,field) ( \
  reg##__##field##__BITNR \
)

#endif /* __REG_GENERAL_3_H__ */


/*
 *  R_ALT_SER_BAUDRATE
 *  - type:  WO
 *  - addr:  0xb000005c
 *  - group: Serial port registers
 */

#if USE_GROUP__Serial_port_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_ALT_SER_BAUDRATE
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_ALT_SER_BAUDRATE.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_ALT_SER_BAUDRATE. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_ALT_SER_BAUDRATE(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8) ( \
  *R_ALT_SER_BAUDRATE__SADDR = ( \
    REG_INITIATED(R_ALT_SER_BAUDRATE_) \
    REG_VAL__R_ALT_SER_BAUDRATE_(f1##_,v1,f2##_,v2,f3##_,v3,f4##_,v4,f5##_,v5,f6##_,v6,f7##_,v7,f8##_,v8) \
  ), \
  R_ALT_SER_BAUDRATE__WRITE(R_ALT_SER_BAUDRATE__ADDR, *R_ALT_SER_BAUDRATE__SADDR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_ALT_SER_BAUDRATE__SHADOW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_ALT_SER_BAUDRATE.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in the 
*#               shadow register for R_ALT_SER_BAUDRATE. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_ALT_SER_BAUDRATE__SHADOW(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8) ( \
  *R_ALT_SER_BAUDRATE__SADDR = ( \
    REG_INITIATED(R_ALT_SER_BAUDRATE_) \
    REG_VAL__R_ALT_SER_BAUDRATE_(f1##_,v1,f2##_,v2,f3##_,v3,f4##_,v4,f5##_,v5,f6##_,v6,f7##_,v7,f8##_,v8) \
  ) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_ALT_SER_BAUDRATE
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_ALT_SER_BAUDRATE(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8) ( \
  (R_ALT_SER_BAUDRATE__ser3_tr__##f1##__MASK & REG__##v1) | \
  (R_ALT_SER_BAUDRATE__ser3_rec__##f2##__MASK & REG__##v2) | \
  (R_ALT_SER_BAUDRATE__ser2_tr__##f3##__MASK & REG__##v3) | \
  (R_ALT_SER_BAUDRATE__ser2_rec__##f4##__MASK & REG__##v4) | \
  (R_ALT_SER_BAUDRATE__ser1_tr__##f5##__MASK & REG__##v5) | \
  (R_ALT_SER_BAUDRATE__ser1_rec__##f6##__MASK & REG__##v6) | \
  (R_ALT_SER_BAUDRATE__ser0_tr__##f7##__MASK & REG__##v7) | \
  (R_ALT_SER_BAUDRATE__ser0_rec__##f8##__MASK & REG__##v8) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_ALT_SER_BAUDRATE
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_ALT_SER_BAUDRATE.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_ALT_SER_BAUDRATE(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8) ( \
  (R_ALT_SER_BAUDRATE__ser3_tr__##f1##__VAL(R_ALT_SER_BAUDRATE_, ser3_tr_, v1) << R_ALT_SER_BAUDRATE__ser3_tr__BITNR) | \
  (R_ALT_SER_BAUDRATE__ser3_rec__##f2##__VAL(R_ALT_SER_BAUDRATE_, ser3_rec_, v2) << R_ALT_SER_BAUDRATE__ser3_rec__BITNR) | \
  (R_ALT_SER_BAUDRATE__ser2_tr__##f3##__VAL(R_ALT_SER_BAUDRATE_, ser2_tr_, v3) << R_ALT_SER_BAUDRATE__ser2_tr__BITNR) | \
  (R_ALT_SER_BAUDRATE__ser2_rec__##f4##__VAL(R_ALT_SER_BAUDRATE_, ser2_rec_, v4) << R_ALT_SER_BAUDRATE__ser2_rec__BITNR) | \
  (R_ALT_SER_BAUDRATE__ser1_tr__##f5##__VAL(R_ALT_SER_BAUDRATE_, ser1_tr_, v5) << R_ALT_SER_BAUDRATE__ser1_tr__BITNR) | \
  (R_ALT_SER_BAUDRATE__ser1_rec__##f6##__VAL(R_ALT_SER_BAUDRATE_, ser1_rec_, v6) << R_ALT_SER_BAUDRATE__ser1_rec__BITNR) | \
  (R_ALT_SER_BAUDRATE__ser0_tr__##f7##__VAL(R_ALT_SER_BAUDRATE_, ser0_tr_, v7) << R_ALT_SER_BAUDRATE__ser0_tr__BITNR) | \
  (R_ALT_SER_BAUDRATE__ser0_rec__##f8##__VAL(R_ALT_SER_BAUDRATE_, ser0_rec_, v8) << R_ALT_SER_BAUDRATE__ser0_rec__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_ALT_SER_BAUDRATE_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_ALT_SER_BAUDRATE.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_ALT_SER_BAUDRATE_(f1_,v1,f2_,v2,f3_,v3,f4_,v4,f5_,v5,f6_,v6,f7_,v7,f8_,v8) ( \
  (R_ALT_SER_BAUDRATE__ser3_tr__##f1_##_VAL(R_ALT_SER_BAUDRATE_, ser3_tr_, v1) << R_ALT_SER_BAUDRATE__ser3_tr__BITNR) | \
  (R_ALT_SER_BAUDRATE__ser3_rec__##f2_##_VAL(R_ALT_SER_BAUDRATE_, ser3_rec_, v2) << R_ALT_SER_BAUDRATE__ser3_rec__BITNR) | \
  (R_ALT_SER_BAUDRATE__ser2_tr__##f3_##_VAL(R_ALT_SER_BAUDRATE_, ser2_tr_, v3) << R_ALT_SER_BAUDRATE__ser2_tr__BITNR) | \
  (R_ALT_SER_BAUDRATE__ser2_rec__##f4_##_VAL(R_ALT_SER_BAUDRATE_, ser2_rec_, v4) << R_ALT_SER_BAUDRATE__ser2_rec__BITNR) | \
  (R_ALT_SER_BAUDRATE__ser1_tr__##f5_##_VAL(R_ALT_SER_BAUDRATE_, ser1_tr_, v5) << R_ALT_SER_BAUDRATE__ser1_tr__BITNR) | \
  (R_ALT_SER_BAUDRATE__ser1_rec__##f6_##_VAL(R_ALT_SER_BAUDRATE_, ser1_rec_, v6) << R_ALT_SER_BAUDRATE__ser1_rec__BITNR) | \
  (R_ALT_SER_BAUDRATE__ser0_tr__##f7_##_VAL(R_ALT_SER_BAUDRATE_, ser0_tr_, v7) << R_ALT_SER_BAUDRATE__ser0_tr__BITNR) | \
  (R_ALT_SER_BAUDRATE__ser0_rec__##f8_##_VAL(R_ALT_SER_BAUDRATE_, ser0_rec_, v8) << R_ALT_SER_BAUDRATE__ser0_rec__BITNR) \
)

#endif

/*
 *  R_ATA_CONFIG
 *  - type:  WO
 *  - addr:  0xb0000044
 *  - group: ATA interface registers
 */

#if USE_GROUP__ATA_interface_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_ATA_CONFIG
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_ATA_CONFIG.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_ATA_CONFIG. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_ATA_CONFIG(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6) ( \
  *R_ATA_CONFIG__SADDR = ( \
    REG_INITIATED(R_ATA_CONFIG_) \
    REG_VAL__R_ATA_CONFIG_(f1##_,v1,f2##_,v2,f3##_,v3,f4##_,v4,f5##_,v5,f6##_,v6) \
  ), \
  R_ATA_CONFIG__WRITE(R_ATA_CONFIG__ADDR, *R_ATA_CONFIG__SADDR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_ATA_CONFIG__SHADOW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_ATA_CONFIG.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in the 
*#               shadow register for R_ATA_CONFIG. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_ATA_CONFIG__SHADOW(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6) ( \
  *R_ATA_CONFIG__SADDR = ( \
    REG_INITIATED(R_ATA_CONFIG_) \
    REG_VAL__R_ATA_CONFIG_(f1##_,v1,f2##_,v2,f3##_,v3,f4##_,v4,f5##_,v5,f6##_,v6) \
  ) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_ATA_CONFIG
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_ATA_CONFIG(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6) ( \
  (R_ATA_CONFIG__enable__##f1##__MASK & REG__##v1) | \
  (R_ATA_CONFIG__dma_strobe__##f2##__MASK & REG__##v2) | \
  (R_ATA_CONFIG__dma_hold__##f3##__MASK & REG__##v3) | \
  (R_ATA_CONFIG__pio_setup__##f4##__MASK & REG__##v4) | \
  (R_ATA_CONFIG__pio_strobe__##f5##__MASK & REG__##v5) | \
  (R_ATA_CONFIG__pio_hold__##f6##__MASK & REG__##v6) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_ATA_CONFIG
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_ATA_CONFIG.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_ATA_CONFIG(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6) ( \
  (R_ATA_CONFIG__enable__##f1##__VAL(R_ATA_CONFIG_, enable_, v1) << R_ATA_CONFIG__enable__BITNR) | \
  (R_ATA_CONFIG__dma_strobe__##f2##__VAL(R_ATA_CONFIG_, dma_strobe_, v2) << R_ATA_CONFIG__dma_strobe__BITNR) | \
  (R_ATA_CONFIG__dma_hold__##f3##__VAL(R_ATA_CONFIG_, dma_hold_, v3) << R_ATA_CONFIG__dma_hold__BITNR) | \
  (R_ATA_CONFIG__pio_setup__##f4##__VAL(R_ATA_CONFIG_, pio_setup_, v4) << R_ATA_CONFIG__pio_setup__BITNR) | \
  (R_ATA_CONFIG__pio_strobe__##f5##__VAL(R_ATA_CONFIG_, pio_strobe_, v5) << R_ATA_CONFIG__pio_strobe__BITNR) | \
  (R_ATA_CONFIG__pio_hold__##f6##__VAL(R_ATA_CONFIG_, pio_hold_, v6) << R_ATA_CONFIG__pio_hold__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_ATA_CONFIG_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_ATA_CONFIG.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_ATA_CONFIG_(f1_,v1,f2_,v2,f3_,v3,f4_,v4,f5_,v5,f6_,v6) ( \
  (R_ATA_CONFIG__enable__##f1_##_VAL(R_ATA_CONFIG_, enable_, v1) << R_ATA_CONFIG__enable__BITNR) | \
  (R_ATA_CONFIG__dma_strobe__##f2_##_VAL(R_ATA_CONFIG_, dma_strobe_, v2) << R_ATA_CONFIG__dma_strobe__BITNR) | \
  (R_ATA_CONFIG__dma_hold__##f3_##_VAL(R_ATA_CONFIG_, dma_hold_, v3) << R_ATA_CONFIG__dma_hold__BITNR) | \
  (R_ATA_CONFIG__pio_setup__##f4_##_VAL(R_ATA_CONFIG_, pio_setup_, v4) << R_ATA_CONFIG__pio_setup__BITNR) | \
  (R_ATA_CONFIG__pio_strobe__##f5_##_VAL(R_ATA_CONFIG_, pio_strobe_, v5) << R_ATA_CONFIG__pio_strobe__BITNR) | \
  (R_ATA_CONFIG__pio_hold__##f6_##_VAL(R_ATA_CONFIG_, pio_hold_, v6) << R_ATA_CONFIG__pio_hold__BITNR) \
)

#endif

/*
 *  R_ATA_CTRL_DATA
 *  - type:  WO
 *  - addr:  0xb0000040
 *  - group: ATA interface registers
 */

#if USE_GROUP__ATA_interface_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_ATA_CTRL_DATA
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_ATA_CTRL_DATA.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_ATA_CTRL_DATA. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_ATA_CTRL_DATA(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10) ( \
  *R_ATA_CTRL_DATA__SADDR = ( \
    REG_INITIATED(R_ATA_CTRL_DATA_) \
    REG_VAL__R_ATA_CTRL_DATA_(f1##_,v1,f2##_,v2,f3##_,v3,f4##_,v4,f5##_,v5,f6##_,v6,f7##_,v7,f8##_,v8,f9##_,v9,f10##_,v10) \
  ), \
  R_ATA_CTRL_DATA__WRITE(R_ATA_CTRL_DATA__ADDR, *R_ATA_CTRL_DATA__SADDR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_ATA_CTRL_DATA__SHADOW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_ATA_CTRL_DATA.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in the 
*#               shadow register for R_ATA_CTRL_DATA. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_ATA_CTRL_DATA__SHADOW(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10) ( \
  *R_ATA_CTRL_DATA__SADDR = ( \
    REG_INITIATED(R_ATA_CTRL_DATA_) \
    REG_VAL__R_ATA_CTRL_DATA_(f1##_,v1,f2##_,v2,f3##_,v3,f4##_,v4,f5##_,v5,f6##_,v6,f7##_,v7,f8##_,v8,f9##_,v9,f10##_,v10) \
  ) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_ATA_CTRL_DATA
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_ATA_CTRL_DATA(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10) ( \
  (R_ATA_CTRL_DATA__sel__##f1##__MASK & REG__##v1) | \
  (R_ATA_CTRL_DATA__cs1__##f2##__MASK & REG__##v2) | \
  (R_ATA_CTRL_DATA__cs0__##f3##__MASK & REG__##v3) | \
  (R_ATA_CTRL_DATA__addr__##f4##__MASK & REG__##v4) | \
  (R_ATA_CTRL_DATA__rw__##f5##__MASK & REG__##v5) | \
  (R_ATA_CTRL_DATA__src_dst__##f6##__MASK & REG__##v6) | \
  (R_ATA_CTRL_DATA__handsh__##f7##__MASK & REG__##v7) | \
  (R_ATA_CTRL_DATA__multi__##f8##__MASK & REG__##v8) | \
  (R_ATA_CTRL_DATA__dma_size__##f9##__MASK & REG__##v9) | \
  (R_ATA_CTRL_DATA__data__##f10##__MASK & REG__##v10) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_ATA_CTRL_DATA
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_ATA_CTRL_DATA.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_ATA_CTRL_DATA(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10) ( \
  (R_ATA_CTRL_DATA__sel__##f1##__VAL(R_ATA_CTRL_DATA_, sel_, v1) << R_ATA_CTRL_DATA__sel__BITNR) | \
  (R_ATA_CTRL_DATA__cs1__##f2##__VAL(R_ATA_CTRL_DATA_, cs1_, v2) << R_ATA_CTRL_DATA__cs1__BITNR) | \
  (R_ATA_CTRL_DATA__cs0__##f3##__VAL(R_ATA_CTRL_DATA_, cs0_, v3) << R_ATA_CTRL_DATA__cs0__BITNR) | \
  (R_ATA_CTRL_DATA__addr__##f4##__VAL(R_ATA_CTRL_DATA_, addr_, v4) << R_ATA_CTRL_DATA__addr__BITNR) | \
  (R_ATA_CTRL_DATA__rw__##f5##__VAL(R_ATA_CTRL_DATA_, rw_, v5) << R_ATA_CTRL_DATA__rw__BITNR) | \
  (R_ATA_CTRL_DATA__src_dst__##f6##__VAL(R_ATA_CTRL_DATA_, src_dst_, v6) << R_ATA_CTRL_DATA__src_dst__BITNR) | \
  (R_ATA_CTRL_DATA__handsh__##f7##__VAL(R_ATA_CTRL_DATA_, handsh_, v7) << R_ATA_CTRL_DATA__handsh__BITNR) | \
  (R_ATA_CTRL_DATA__multi__##f8##__VAL(R_ATA_CTRL_DATA_, multi_, v8) << R_ATA_CTRL_DATA__multi__BITNR) | \
  (R_ATA_CTRL_DATA__dma_size__##f9##__VAL(R_ATA_CTRL_DATA_, dma_size_, v9) << R_ATA_CTRL_DATA__dma_size__BITNR) | \
  (R_ATA_CTRL_DATA__data__##f10##__VAL(R_ATA_CTRL_DATA_, data_, v10) << R_ATA_CTRL_DATA__data__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_ATA_CTRL_DATA_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_ATA_CTRL_DATA.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_ATA_CTRL_DATA_(f1_,v1,f2_,v2,f3_,v3,f4_,v4,f5_,v5,f6_,v6,f7_,v7,f8_,v8,f9_,v9,f10_,v10) ( \
  (R_ATA_CTRL_DATA__sel__##f1_##_VAL(R_ATA_CTRL_DATA_, sel_, v1) << R_ATA_CTRL_DATA__sel__BITNR) | \
  (R_ATA_CTRL_DATA__cs1__##f2_##_VAL(R_ATA_CTRL_DATA_, cs1_, v2) << R_ATA_CTRL_DATA__cs1__BITNR) | \
  (R_ATA_CTRL_DATA__cs0__##f3_##_VAL(R_ATA_CTRL_DATA_, cs0_, v3) << R_ATA_CTRL_DATA__cs0__BITNR) | \
  (R_ATA_CTRL_DATA__addr__##f4_##_VAL(R_ATA_CTRL_DATA_, addr_, v4) << R_ATA_CTRL_DATA__addr__BITNR) | \
  (R_ATA_CTRL_DATA__rw__##f5_##_VAL(R_ATA_CTRL_DATA_, rw_, v5) << R_ATA_CTRL_DATA__rw__BITNR) | \
  (R_ATA_CTRL_DATA__src_dst__##f6_##_VAL(R_ATA_CTRL_DATA_, src_dst_, v6) << R_ATA_CTRL_DATA__src_dst__BITNR) | \
  (R_ATA_CTRL_DATA__handsh__##f7_##_VAL(R_ATA_CTRL_DATA_, handsh_, v7) << R_ATA_CTRL_DATA__handsh__BITNR) | \
  (R_ATA_CTRL_DATA__multi__##f8_##_VAL(R_ATA_CTRL_DATA_, multi_, v8) << R_ATA_CTRL_DATA__multi__BITNR) | \
  (R_ATA_CTRL_DATA__dma_size__##f9_##_VAL(R_ATA_CTRL_DATA_, dma_size_, v9) << R_ATA_CTRL_DATA__dma_size__BITNR) | \
  (R_ATA_CTRL_DATA__data__##f10_##_VAL(R_ATA_CTRL_DATA_, data_, v10) << R_ATA_CTRL_DATA__data__BITNR) \
)

#endif

/*
 *  R_ATA_STATUS_DATA
 *  - type:  RO
 *  - addr:  0xb0000040
 *  - group: ATA interface registers
 */

#if USE_GROUP__ATA_interface_registers

/* No REG_SET__register-name for read only registers. */

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_ATA_STATUS_DATA
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_ATA_STATUS_DATA(f1,v1,f2,v2,f3,v3,f4,v4) ( \
  (R_ATA_STATUS_DATA__busy__##f1##__MASK & REG__##v1) | \
  (R_ATA_STATUS_DATA__tr_rdy__##f2##__MASK & REG__##v2) | \
  (R_ATA_STATUS_DATA__dav__##f3##__MASK & REG__##v3) | \
  (R_ATA_STATUS_DATA__data__##f4##__MASK & REG__##v4) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_ATA_STATUS_DATA
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_ATA_STATUS_DATA.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_ATA_STATUS_DATA(f1,v1,f2,v2,f3,v3,f4,v4) ( \
  (R_ATA_STATUS_DATA__busy__##f1##__VAL(R_ATA_STATUS_DATA_, busy_, v1) << R_ATA_STATUS_DATA__busy__BITNR) | \
  (R_ATA_STATUS_DATA__tr_rdy__##f2##__VAL(R_ATA_STATUS_DATA_, tr_rdy_, v2) << R_ATA_STATUS_DATA__tr_rdy__BITNR) | \
  (R_ATA_STATUS_DATA__dav__##f3##__VAL(R_ATA_STATUS_DATA_, dav_, v3) << R_ATA_STATUS_DATA__dav__BITNR) | \
  (R_ATA_STATUS_DATA__data__##f4##__VAL(R_ATA_STATUS_DATA_, data_, v4) << R_ATA_STATUS_DATA__data__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_ATA_STATUS_DATA_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_ATA_STATUS_DATA.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_ATA_STATUS_DATA_(f1_,v1,f2_,v2,f3_,v3,f4_,v4) ( \
  (R_ATA_STATUS_DATA__busy__##f1_##_VAL(R_ATA_STATUS_DATA_, busy_, v1) << R_ATA_STATUS_DATA__busy__BITNR) | \
  (R_ATA_STATUS_DATA__tr_rdy__##f2_##_VAL(R_ATA_STATUS_DATA_, tr_rdy_, v2) << R_ATA_STATUS_DATA__tr_rdy__BITNR) | \
  (R_ATA_STATUS_DATA__dav__##f3_##_VAL(R_ATA_STATUS_DATA_, dav_, v3) << R_ATA_STATUS_DATA__dav__BITNR) | \
  (R_ATA_STATUS_DATA__data__##f4_##_VAL(R_ATA_STATUS_DATA_, data_, v4) << R_ATA_STATUS_DATA__data__BITNR) \
)

#endif

/*
 *  R_ATA_TRANSFER_CNT
 *  - type:  RW
 *  - addr:  0xb0000048
 *  - group: ATA interface registers
 */

#if USE_GROUP__ATA_interface_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_ATA_TRANSFER_CNT
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_ATA_TRANSFER_CNT.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_ATA_TRANSFER_CNT. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_ATA_TRANSFER_CNT(f1,v1) ( \
  R_ATA_TRANSFER_CNT__WRITE(R_ATA_TRANSFER_CNT__ADDR, ( \
    REG_VAL__R_ATA_TRANSFER_CNT_(f1##_,v1) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_ATA_TRANSFER_CNT
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_ATA_TRANSFER_CNT(f1,v1) ( \
  (R_ATA_TRANSFER_CNT__count__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_ATA_TRANSFER_CNT
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_ATA_TRANSFER_CNT.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_ATA_TRANSFER_CNT(f1,v1) ( \
  (R_ATA_TRANSFER_CNT__count__##f1##__VAL(R_ATA_TRANSFER_CNT_, count_, v1) << R_ATA_TRANSFER_CNT__count__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_ATA_TRANSFER_CNT_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_ATA_TRANSFER_CNT.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_ATA_TRANSFER_CNT_(f1_,v1) ( \
  (R_ATA_TRANSFER_CNT__count__##f1_##_VAL(R_ATA_TRANSFER_CNT_, count_, v1) << R_ATA_TRANSFER_CNT__count__BITNR) \
)

#endif

/*
 *  R_BUS_CONFIG
 *  - type:  WO
 *  - addr:  0xb0000004
 *  - group: Bus interface configuration registers
 */

#if USE_GROUP__Bus_interface_configuration_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_BUS_CONFIG
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_BUS_CONFIG.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_BUS_CONFIG. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_BUS_CONFIG(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10) ( \
  *R_BUS_CONFIG__SADDR = ( \
    REG_INITIATED(R_BUS_CONFIG_) \
    REG_VAL__R_BUS_CONFIG_(f1##_,v1,f2##_,v2,f3##_,v3,f4##_,v4,f5##_,v5,f6##_,v6,f7##_,v7,f8##_,v8,f9##_,v9,f10##_,v10) \
  ), \
  R_BUS_CONFIG__WRITE(R_BUS_CONFIG__ADDR, *R_BUS_CONFIG__SADDR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_BUS_CONFIG__SHADOW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_BUS_CONFIG.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in the 
*#               shadow register for R_BUS_CONFIG. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_BUS_CONFIG__SHADOW(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10) ( \
  *R_BUS_CONFIG__SADDR = ( \
    REG_INITIATED(R_BUS_CONFIG_) \
    REG_VAL__R_BUS_CONFIG_(f1##_,v1,f2##_,v2,f3##_,v3,f4##_,v4,f5##_,v5,f6##_,v6,f7##_,v7,f8##_,v8,f9##_,v9,f10##_,v10) \
  ) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_BUS_CONFIG
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_BUS_CONFIG(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10) ( \
  (R_BUS_CONFIG__sram_type__##f1##__MASK & REG__##v1) | \
  (R_BUS_CONFIG__dma_burst__##f2##__MASK & REG__##v2) | \
  (R_BUS_CONFIG__pcs4_7_wr__##f3##__MASK & REG__##v3) | \
  (R_BUS_CONFIG__pcs0_3_wr__##f4##__MASK & REG__##v4) | \
  (R_BUS_CONFIG__sram_wr__##f5##__MASK & REG__##v5) | \
  (R_BUS_CONFIG__flash_wr__##f6##__MASK & REG__##v6) | \
  (R_BUS_CONFIG__pcs4_7_bw__##f7##__MASK & REG__##v7) | \
  (R_BUS_CONFIG__pcs0_3_bw__##f8##__MASK & REG__##v8) | \
  (R_BUS_CONFIG__sram_bw__##f9##__MASK & REG__##v9) | \
  (R_BUS_CONFIG__flash_bw__##f10##__MASK & REG__##v10) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_BUS_CONFIG
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_BUS_CONFIG.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_BUS_CONFIG(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10) ( \
  (R_BUS_CONFIG__sram_type__##f1##__VAL(R_BUS_CONFIG_, sram_type_, v1) << R_BUS_CONFIG__sram_type__BITNR) | \
  (R_BUS_CONFIG__dma_burst__##f2##__VAL(R_BUS_CONFIG_, dma_burst_, v2) << R_BUS_CONFIG__dma_burst__BITNR) | \
  (R_BUS_CONFIG__pcs4_7_wr__##f3##__VAL(R_BUS_CONFIG_, pcs4_7_wr_, v3) << R_BUS_CONFIG__pcs4_7_wr__BITNR) | \
  (R_BUS_CONFIG__pcs0_3_wr__##f4##__VAL(R_BUS_CONFIG_, pcs0_3_wr_, v4) << R_BUS_CONFIG__pcs0_3_wr__BITNR) | \
  (R_BUS_CONFIG__sram_wr__##f5##__VAL(R_BUS_CONFIG_, sram_wr_, v5) << R_BUS_CONFIG__sram_wr__BITNR) | \
  (R_BUS_CONFIG__flash_wr__##f6##__VAL(R_BUS_CONFIG_, flash_wr_, v6) << R_BUS_CONFIG__flash_wr__BITNR) | \
  (R_BUS_CONFIG__pcs4_7_bw__##f7##__VAL(R_BUS_CONFIG_, pcs4_7_bw_, v7) << R_BUS_CONFIG__pcs4_7_bw__BITNR) | \
  (R_BUS_CONFIG__pcs0_3_bw__##f8##__VAL(R_BUS_CONFIG_, pcs0_3_bw_, v8) << R_BUS_CONFIG__pcs0_3_bw__BITNR) | \
  (R_BUS_CONFIG__sram_bw__##f9##__VAL(R_BUS_CONFIG_, sram_bw_, v9) << R_BUS_CONFIG__sram_bw__BITNR) | \
  (R_BUS_CONFIG__flash_bw__##f10##__VAL(R_BUS_CONFIG_, flash_bw_, v10) << R_BUS_CONFIG__flash_bw__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_BUS_CONFIG_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_BUS_CONFIG.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_BUS_CONFIG_(f1_,v1,f2_,v2,f3_,v3,f4_,v4,f5_,v5,f6_,v6,f7_,v7,f8_,v8,f9_,v9,f10_,v10) ( \
  (R_BUS_CONFIG__sram_type__##f1_##_VAL(R_BUS_CONFIG_, sram_type_, v1) << R_BUS_CONFIG__sram_type__BITNR) | \
  (R_BUS_CONFIG__dma_burst__##f2_##_VAL(R_BUS_CONFIG_, dma_burst_, v2) << R_BUS_CONFIG__dma_burst__BITNR) | \
  (R_BUS_CONFIG__pcs4_7_wr__##f3_##_VAL(R_BUS_CONFIG_, pcs4_7_wr_, v3) << R_BUS_CONFIG__pcs4_7_wr__BITNR) | \
  (R_BUS_CONFIG__pcs0_3_wr__##f4_##_VAL(R_BUS_CONFIG_, pcs0_3_wr_, v4) << R_BUS_CONFIG__pcs0_3_wr__BITNR) | \
  (R_BUS_CONFIG__sram_wr__##f5_##_VAL(R_BUS_CONFIG_, sram_wr_, v5) << R_BUS_CONFIG__sram_wr__BITNR) | \
  (R_BUS_CONFIG__flash_wr__##f6_##_VAL(R_BUS_CONFIG_, flash_wr_, v6) << R_BUS_CONFIG__flash_wr__BITNR) | \
  (R_BUS_CONFIG__pcs4_7_bw__##f7_##_VAL(R_BUS_CONFIG_, pcs4_7_bw_, v7) << R_BUS_CONFIG__pcs4_7_bw__BITNR) | \
  (R_BUS_CONFIG__pcs0_3_bw__##f8_##_VAL(R_BUS_CONFIG_, pcs0_3_bw_, v8) << R_BUS_CONFIG__pcs0_3_bw__BITNR) | \
  (R_BUS_CONFIG__sram_bw__##f9_##_VAL(R_BUS_CONFIG_, sram_bw_, v9) << R_BUS_CONFIG__sram_bw__BITNR) | \
  (R_BUS_CONFIG__flash_bw__##f10_##_VAL(R_BUS_CONFIG_, flash_bw_, v10) << R_BUS_CONFIG__flash_bw__BITNR) \
)

#endif

/*
 *  R_BUS_STATUS
 *  - type:  RO
 *  - addr:  0xb0000004
 *  - group: Bus interface configuration registers
 */

#if USE_GROUP__Bus_interface_configuration_registers

/* No REG_SET__register-name for read only registers. */

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_BUS_STATUS
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_BUS_STATUS(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5) ( \
  (R_BUS_STATUS__pll_lock_tm__##f1##__MASK & REG__##v1) | \
  (R_BUS_STATUS__both_faults__##f2##__MASK & REG__##v2) | \
  (R_BUS_STATUS__bsen___##f3##__MASK & REG__##v3) | \
  (R_BUS_STATUS__boot__##f4##__MASK & REG__##v4) | \
  (R_BUS_STATUS__flashw__##f5##__MASK & REG__##v5) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_BUS_STATUS
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_BUS_STATUS.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_BUS_STATUS(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5) ( \
  (R_BUS_STATUS__pll_lock_tm__##f1##__VAL(R_BUS_STATUS_, pll_lock_tm_, v1) << R_BUS_STATUS__pll_lock_tm__BITNR) | \
  (R_BUS_STATUS__both_faults__##f2##__VAL(R_BUS_STATUS_, both_faults_, v2) << R_BUS_STATUS__both_faults__BITNR) | \
  (R_BUS_STATUS__bsen___##f3##__VAL(R_BUS_STATUS_, bsen__, v3) << R_BUS_STATUS__bsen___BITNR) | \
  (R_BUS_STATUS__boot__##f4##__VAL(R_BUS_STATUS_, boot_, v4) << R_BUS_STATUS__boot__BITNR) | \
  (R_BUS_STATUS__flashw__##f5##__VAL(R_BUS_STATUS_, flashw_, v5) << R_BUS_STATUS__flashw__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_BUS_STATUS_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_BUS_STATUS.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_BUS_STATUS_(f1_,v1,f2_,v2,f3_,v3,f4_,v4,f5_,v5) ( \
  (R_BUS_STATUS__pll_lock_tm__##f1_##_VAL(R_BUS_STATUS_, pll_lock_tm_, v1) << R_BUS_STATUS__pll_lock_tm__BITNR) | \
  (R_BUS_STATUS__both_faults__##f2_##_VAL(R_BUS_STATUS_, both_faults_, v2) << R_BUS_STATUS__both_faults__BITNR) | \
  (R_BUS_STATUS__bsen___##f3_##_VAL(R_BUS_STATUS_, bsen__, v3) << R_BUS_STATUS__bsen___BITNR) | \
  (R_BUS_STATUS__boot__##f4_##_VAL(R_BUS_STATUS_, boot_, v4) << R_BUS_STATUS__boot__BITNR) | \
  (R_BUS_STATUS__flashw__##f5_##_VAL(R_BUS_STATUS_, flashw_, v5) << R_BUS_STATUS__flashw__BITNR) \
)

#endif

/*
 *  R_CLOCK_PRESCALE
 *  - type:  WO
 *  - addr:  0xb00000f0
 *  - group: Timer registers
 */

#if USE_GROUP__Timer_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_CLOCK_PRESCALE
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_CLOCK_PRESCALE.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_CLOCK_PRESCALE. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_CLOCK_PRESCALE(f1,v1,f2,v2) ( \
  *R_CLOCK_PRESCALE__SADDR = ( \
    REG_INITIATED(R_CLOCK_PRESCALE_) \
    REG_VAL__R_CLOCK_PRESCALE_(f1##_,v1,f2##_,v2) \
  ), \
  R_CLOCK_PRESCALE__WRITE(R_CLOCK_PRESCALE__ADDR, *R_CLOCK_PRESCALE__SADDR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_CLOCK_PRESCALE__SHADOW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_CLOCK_PRESCALE.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in the 
*#               shadow register for R_CLOCK_PRESCALE. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_CLOCK_PRESCALE__SHADOW(f1,v1,f2,v2) ( \
  *R_CLOCK_PRESCALE__SADDR = ( \
    REG_INITIATED(R_CLOCK_PRESCALE_) \
    REG_VAL__R_CLOCK_PRESCALE_(f1##_,v1,f2##_,v2) \
  ) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_CLOCK_PRESCALE
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_CLOCK_PRESCALE(f1,v1,f2,v2) ( \
  (R_CLOCK_PRESCALE__ser_presc__##f1##__MASK & REG__##v1) | \
  (R_CLOCK_PRESCALE__tim_presc__##f2##__MASK & REG__##v2) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_CLOCK_PRESCALE
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_CLOCK_PRESCALE.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_CLOCK_PRESCALE(f1,v1,f2,v2) ( \
  (R_CLOCK_PRESCALE__ser_presc__##f1##__VAL(R_CLOCK_PRESCALE_, ser_presc_, v1) << R_CLOCK_PRESCALE__ser_presc__BITNR) | \
  (R_CLOCK_PRESCALE__tim_presc__##f2##__VAL(R_CLOCK_PRESCALE_, tim_presc_, v2) << R_CLOCK_PRESCALE__tim_presc__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_CLOCK_PRESCALE_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_CLOCK_PRESCALE.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_CLOCK_PRESCALE_(f1_,v1,f2_,v2) ( \
  (R_CLOCK_PRESCALE__ser_presc__##f1_##_VAL(R_CLOCK_PRESCALE_, ser_presc_, v1) << R_CLOCK_PRESCALE__ser_presc__BITNR) | \
  (R_CLOCK_PRESCALE__tim_presc__##f2_##_VAL(R_CLOCK_PRESCALE_, tim_presc_, v2) << R_CLOCK_PRESCALE__tim_presc__BITNR) \
)

#endif

/*
 *  R_DMA_CH0_BUF
 *  - type:  RW
 *  - addr:  0xb0000108
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH0_BUF
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH0_BUF.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH0_BUF. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH0_BUF(f1,v1) ( \
  R_DMA_CH0_BUF__WRITE(R_DMA_CH0_BUF__ADDR, ( \
    REG_VAL__R_DMA_CH0_BUF_(f1##_,v1) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH0_BUF
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH0_BUF(f1,v1) ( \
  (R_DMA_CH0_BUF__buf__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH0_BUF
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH0_BUF.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH0_BUF(f1,v1) ( \
  (R_DMA_CH0_BUF__buf__##f1##__VAL(R_DMA_CH0_BUF_, buf_, v1) << R_DMA_CH0_BUF__buf__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH0_BUF_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH0_BUF.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH0_BUF_(f1_,v1) ( \
  (R_DMA_CH0_BUF__buf__##f1_##_VAL(R_DMA_CH0_BUF_, buf_, v1) << R_DMA_CH0_BUF__buf__BITNR) \
)

#endif

/*
 *  R_DMA_CH0_CLR_INTR
 *  - type:  WO
 *  - addr:  0xb00001d1
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH0_CLR_INTR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH0_CLR_INTR.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH0_CLR_INTR. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH0_CLR_INTR(f1,v1,f2,v2) ( \
  *R_DMA_CH0_CLR_INTR__SADDR = ( \
    REG_INITIATED(R_DMA_CH0_CLR_INTR_) \
    REG_VAL__R_DMA_CH0_CLR_INTR_(f1##_,v1,f2##_,v2) \
  ), \
  R_DMA_CH0_CLR_INTR__WRITE(R_DMA_CH0_CLR_INTR__ADDR, *R_DMA_CH0_CLR_INTR__SADDR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH0_CLR_INTR__SHADOW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH0_CLR_INTR.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in the 
*#               shadow register for R_DMA_CH0_CLR_INTR. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH0_CLR_INTR__SHADOW(f1,v1,f2,v2) ( \
  *R_DMA_CH0_CLR_INTR__SADDR = ( \
    REG_INITIATED(R_DMA_CH0_CLR_INTR_) \
    REG_VAL__R_DMA_CH0_CLR_INTR_(f1##_,v1,f2##_,v2) \
  ) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH0_CLR_INTR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH0_CLR_INTR(f1,v1,f2,v2) ( \
  (R_DMA_CH0_CLR_INTR__clr_eop__##f1##__MASK & REG__##v1) | \
  (R_DMA_CH0_CLR_INTR__clr_descr__##f2##__MASK & REG__##v2) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH0_CLR_INTR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH0_CLR_INTR.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH0_CLR_INTR(f1,v1,f2,v2) ( \
  (R_DMA_CH0_CLR_INTR__clr_eop__##f1##__VAL(R_DMA_CH0_CLR_INTR_, clr_eop_, v1) << R_DMA_CH0_CLR_INTR__clr_eop__BITNR) | \
  (R_DMA_CH0_CLR_INTR__clr_descr__##f2##__VAL(R_DMA_CH0_CLR_INTR_, clr_descr_, v2) << R_DMA_CH0_CLR_INTR__clr_descr__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH0_CLR_INTR_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH0_CLR_INTR.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH0_CLR_INTR_(f1_,v1,f2_,v2) ( \
  (R_DMA_CH0_CLR_INTR__clr_eop__##f1_##_VAL(R_DMA_CH0_CLR_INTR_, clr_eop_, v1) << R_DMA_CH0_CLR_INTR__clr_eop__BITNR) | \
  (R_DMA_CH0_CLR_INTR__clr_descr__##f2_##_VAL(R_DMA_CH0_CLR_INTR_, clr_descr_, v2) << R_DMA_CH0_CLR_INTR__clr_descr__BITNR) \
)

#endif

/*
 *  R_DMA_CH0_CMD
 *  - type:  RW
 *  - addr:  0xb00001d0
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH0_CMD
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH0_CMD.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH0_CMD. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH0_CMD(f1,v1) ( \
  R_DMA_CH0_CMD__WRITE(R_DMA_CH0_CMD__ADDR, ( \
    REG_VAL__R_DMA_CH0_CMD_(f1##_,v1) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH0_CMD
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH0_CMD(f1,v1) ( \
  (R_DMA_CH0_CMD__cmd__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH0_CMD
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH0_CMD.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH0_CMD(f1,v1) ( \
  (R_DMA_CH0_CMD__cmd__##f1##__VAL(R_DMA_CH0_CMD_, cmd_, v1) << R_DMA_CH0_CMD__cmd__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH0_CMD_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH0_CMD.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH0_CMD_(f1_,v1) ( \
  (R_DMA_CH0_CMD__cmd__##f1_##_VAL(R_DMA_CH0_CMD_, cmd_, v1) << R_DMA_CH0_CMD__cmd__BITNR) \
)

#endif

/*
 *  R_DMA_CH0_DESCR
 *  - type:  RW
 *  - addr:  0xb000010c
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH0_DESCR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH0_DESCR.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH0_DESCR. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH0_DESCR(f1,v1) ( \
  R_DMA_CH0_DESCR__WRITE(R_DMA_CH0_DESCR__ADDR, ( \
    REG_VAL__R_DMA_CH0_DESCR_(f1##_,v1) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH0_DESCR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH0_DESCR(f1,v1) ( \
  (R_DMA_CH0_DESCR__descr__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH0_DESCR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH0_DESCR.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH0_DESCR(f1,v1) ( \
  (R_DMA_CH0_DESCR__descr__##f1##__VAL(R_DMA_CH0_DESCR_, descr_, v1) << R_DMA_CH0_DESCR__descr__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH0_DESCR_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH0_DESCR.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH0_DESCR_(f1_,v1) ( \
  (R_DMA_CH0_DESCR__descr__##f1_##_VAL(R_DMA_CH0_DESCR_, descr_, v1) << R_DMA_CH0_DESCR__descr__BITNR) \
)

#endif

/*
 *  R_DMA_CH0_FIRST
 *  - type:  RW
 *  - addr:  0xb00001a0
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH0_FIRST
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH0_FIRST.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH0_FIRST. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH0_FIRST(f1,v1) ( \
  R_DMA_CH0_FIRST__WRITE(R_DMA_CH0_FIRST__ADDR, ( \
    REG_VAL__R_DMA_CH0_FIRST_(f1##_,v1) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH0_FIRST
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH0_FIRST(f1,v1) ( \
  (R_DMA_CH0_FIRST__first__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH0_FIRST
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH0_FIRST.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH0_FIRST(f1,v1) ( \
  (R_DMA_CH0_FIRST__first__##f1##__VAL(R_DMA_CH0_FIRST_, first_, v1) << R_DMA_CH0_FIRST__first__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH0_FIRST_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH0_FIRST.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH0_FIRST_(f1_,v1) ( \
  (R_DMA_CH0_FIRST__first__##f1_##_VAL(R_DMA_CH0_FIRST_, first_, v1) << R_DMA_CH0_FIRST__first__BITNR) \
)

#endif

/*
 *  R_DMA_CH0_HWSW
 *  - type:  RW
 *  - addr:  0xb0000100
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH0_HWSW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH0_HWSW.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH0_HWSW. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH0_HWSW(f1,v1,f2,v2) ( \
  R_DMA_CH0_HWSW__WRITE(R_DMA_CH0_HWSW__ADDR, ( \
    REG_VAL__R_DMA_CH0_HWSW_(f1##_,v1,f2##_,v2) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH0_HWSW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH0_HWSW(f1,v1,f2,v2) ( \
  (R_DMA_CH0_HWSW__hw__##f1##__MASK & REG__##v1) | \
  (R_DMA_CH0_HWSW__sw__##f2##__MASK & REG__##v2) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH0_HWSW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH0_HWSW.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH0_HWSW(f1,v1,f2,v2) ( \
  (R_DMA_CH0_HWSW__hw__##f1##__VAL(R_DMA_CH0_HWSW_, hw_, v1) << R_DMA_CH0_HWSW__hw__BITNR) | \
  (R_DMA_CH0_HWSW__sw__##f2##__VAL(R_DMA_CH0_HWSW_, sw_, v2) << R_DMA_CH0_HWSW__sw__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH0_HWSW_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH0_HWSW.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH0_HWSW_(f1_,v1,f2_,v2) ( \
  (R_DMA_CH0_HWSW__hw__##f1_##_VAL(R_DMA_CH0_HWSW_, hw_, v1) << R_DMA_CH0_HWSW__hw__BITNR) | \
  (R_DMA_CH0_HWSW__sw__##f2_##_VAL(R_DMA_CH0_HWSW_, sw_, v2) << R_DMA_CH0_HWSW__sw__BITNR) \
)

#endif

/*
 *  R_DMA_CH0_NEXT
 *  - type:  RW
 *  - addr:  0xb0000104
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH0_NEXT
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH0_NEXT.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH0_NEXT. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH0_NEXT(f1,v1) ( \
  R_DMA_CH0_NEXT__WRITE(R_DMA_CH0_NEXT__ADDR, ( \
    REG_VAL__R_DMA_CH0_NEXT_(f1##_,v1) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH0_NEXT
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH0_NEXT(f1,v1) ( \
  (R_DMA_CH0_NEXT__next__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH0_NEXT
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH0_NEXT.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH0_NEXT(f1,v1) ( \
  (R_DMA_CH0_NEXT__next__##f1##__VAL(R_DMA_CH0_NEXT_, next_, v1) << R_DMA_CH0_NEXT__next__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH0_NEXT_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH0_NEXT.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH0_NEXT_(f1_,v1) ( \
  (R_DMA_CH0_NEXT__next__##f1_##_VAL(R_DMA_CH0_NEXT_, next_, v1) << R_DMA_CH0_NEXT__next__BITNR) \
)

#endif

/*
 *  R_DMA_CH0_STATUS
 *  - type:  RO
 *  - addr:  0xb00001d2
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/* No REG_SET__register-name for read only registers. */

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH0_STATUS
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH0_STATUS(f1,v1) ( \
  (R_DMA_CH0_STATUS__avail__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH0_STATUS
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH0_STATUS.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH0_STATUS(f1,v1) ( \
  (R_DMA_CH0_STATUS__avail__##f1##__VAL(R_DMA_CH0_STATUS_, avail_, v1) << R_DMA_CH0_STATUS__avail__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH0_STATUS_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH0_STATUS.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH0_STATUS_(f1_,v1) ( \
  (R_DMA_CH0_STATUS__avail__##f1_##_VAL(R_DMA_CH0_STATUS_, avail_, v1) << R_DMA_CH0_STATUS__avail__BITNR) \
)

#endif

/*
 *  R_DMA_CH1_BUF
 *  - type:  RW
 *  - addr:  0xb0000118
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH1_BUF
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH1_BUF.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH1_BUF. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH1_BUF(f1,v1) ( \
  R_DMA_CH1_BUF__WRITE(R_DMA_CH1_BUF__ADDR, ( \
    REG_VAL__R_DMA_CH1_BUF_(f1##_,v1) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH1_BUF
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH1_BUF(f1,v1) ( \
  (R_DMA_CH1_BUF__buf__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH1_BUF
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH1_BUF.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH1_BUF(f1,v1) ( \
  (R_DMA_CH1_BUF__buf__##f1##__VAL(R_DMA_CH1_BUF_, buf_, v1) << R_DMA_CH1_BUF__buf__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH1_BUF_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH1_BUF.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH1_BUF_(f1_,v1) ( \
  (R_DMA_CH1_BUF__buf__##f1_##_VAL(R_DMA_CH1_BUF_, buf_, v1) << R_DMA_CH1_BUF__buf__BITNR) \
)

#endif

/*
 *  R_DMA_CH1_CLR_INTR
 *  - type:  WO
 *  - addr:  0xb00001d5
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH1_CLR_INTR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH1_CLR_INTR.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH1_CLR_INTR. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH1_CLR_INTR(f1,v1,f2,v2) ( \
  *R_DMA_CH1_CLR_INTR__SADDR = ( \
    REG_INITIATED(R_DMA_CH1_CLR_INTR_) \
    REG_VAL__R_DMA_CH1_CLR_INTR_(f1##_,v1,f2##_,v2) \
  ), \
  R_DMA_CH1_CLR_INTR__WRITE(R_DMA_CH1_CLR_INTR__ADDR, *R_DMA_CH1_CLR_INTR__SADDR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH1_CLR_INTR__SHADOW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH1_CLR_INTR.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in the 
*#               shadow register for R_DMA_CH1_CLR_INTR. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH1_CLR_INTR__SHADOW(f1,v1,f2,v2) ( \
  *R_DMA_CH1_CLR_INTR__SADDR = ( \
    REG_INITIATED(R_DMA_CH1_CLR_INTR_) \
    REG_VAL__R_DMA_CH1_CLR_INTR_(f1##_,v1,f2##_,v2) \
  ) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH1_CLR_INTR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH1_CLR_INTR(f1,v1,f2,v2) ( \
  (R_DMA_CH1_CLR_INTR__clr_eop__##f1##__MASK & REG__##v1) | \
  (R_DMA_CH1_CLR_INTR__clr_descr__##f2##__MASK & REG__##v2) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH1_CLR_INTR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH1_CLR_INTR.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH1_CLR_INTR(f1,v1,f2,v2) ( \
  (R_DMA_CH1_CLR_INTR__clr_eop__##f1##__VAL(R_DMA_CH1_CLR_INTR_, clr_eop_, v1) << R_DMA_CH1_CLR_INTR__clr_eop__BITNR) | \
  (R_DMA_CH1_CLR_INTR__clr_descr__##f2##__VAL(R_DMA_CH1_CLR_INTR_, clr_descr_, v2) << R_DMA_CH1_CLR_INTR__clr_descr__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH1_CLR_INTR_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH1_CLR_INTR.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH1_CLR_INTR_(f1_,v1,f2_,v2) ( \
  (R_DMA_CH1_CLR_INTR__clr_eop__##f1_##_VAL(R_DMA_CH1_CLR_INTR_, clr_eop_, v1) << R_DMA_CH1_CLR_INTR__clr_eop__BITNR) | \
  (R_DMA_CH1_CLR_INTR__clr_descr__##f2_##_VAL(R_DMA_CH1_CLR_INTR_, clr_descr_, v2) << R_DMA_CH1_CLR_INTR__clr_descr__BITNR) \
)

#endif

/*
 *  R_DMA_CH1_CMD
 *  - type:  RW
 *  - addr:  0xb00001d4
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH1_CMD
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH1_CMD.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH1_CMD. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH1_CMD(f1,v1) ( \
  R_DMA_CH1_CMD__WRITE(R_DMA_CH1_CMD__ADDR, ( \
    REG_VAL__R_DMA_CH1_CMD_(f1##_,v1) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH1_CMD
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH1_CMD(f1,v1) ( \
  (R_DMA_CH1_CMD__cmd__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH1_CMD
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH1_CMD.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH1_CMD(f1,v1) ( \
  (R_DMA_CH1_CMD__cmd__##f1##__VAL(R_DMA_CH1_CMD_, cmd_, v1) << R_DMA_CH1_CMD__cmd__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH1_CMD_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH1_CMD.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH1_CMD_(f1_,v1) ( \
  (R_DMA_CH1_CMD__cmd__##f1_##_VAL(R_DMA_CH1_CMD_, cmd_, v1) << R_DMA_CH1_CMD__cmd__BITNR) \
)

#endif

/*
 *  R_DMA_CH1_DESCR
 *  - type:  RW
 *  - addr:  0xb000011c
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH1_DESCR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH1_DESCR.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH1_DESCR. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH1_DESCR(f1,v1) ( \
  R_DMA_CH1_DESCR__WRITE(R_DMA_CH1_DESCR__ADDR, ( \
    REG_VAL__R_DMA_CH1_DESCR_(f1##_,v1) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH1_DESCR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH1_DESCR(f1,v1) ( \
  (R_DMA_CH1_DESCR__descr__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH1_DESCR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH1_DESCR.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH1_DESCR(f1,v1) ( \
  (R_DMA_CH1_DESCR__descr__##f1##__VAL(R_DMA_CH1_DESCR_, descr_, v1) << R_DMA_CH1_DESCR__descr__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH1_DESCR_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH1_DESCR.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH1_DESCR_(f1_,v1) ( \
  (R_DMA_CH1_DESCR__descr__##f1_##_VAL(R_DMA_CH1_DESCR_, descr_, v1) << R_DMA_CH1_DESCR__descr__BITNR) \
)

#endif

/*
 *  R_DMA_CH1_FIRST
 *  - type:  RW
 *  - addr:  0xb00001a4
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH1_FIRST
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH1_FIRST.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH1_FIRST. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH1_FIRST(f1,v1) ( \
  R_DMA_CH1_FIRST__WRITE(R_DMA_CH1_FIRST__ADDR, ( \
    REG_VAL__R_DMA_CH1_FIRST_(f1##_,v1) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH1_FIRST
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH1_FIRST(f1,v1) ( \
  (R_DMA_CH1_FIRST__first__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH1_FIRST
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH1_FIRST.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH1_FIRST(f1,v1) ( \
  (R_DMA_CH1_FIRST__first__##f1##__VAL(R_DMA_CH1_FIRST_, first_, v1) << R_DMA_CH1_FIRST__first__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH1_FIRST_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH1_FIRST.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH1_FIRST_(f1_,v1) ( \
  (R_DMA_CH1_FIRST__first__##f1_##_VAL(R_DMA_CH1_FIRST_, first_, v1) << R_DMA_CH1_FIRST__first__BITNR) \
)

#endif

/*
 *  R_DMA_CH1_HWSW
 *  - type:  RW
 *  - addr:  0xb0000110
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH1_HWSW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH1_HWSW.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH1_HWSW. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH1_HWSW(f1,v1,f2,v2) ( \
  R_DMA_CH1_HWSW__WRITE(R_DMA_CH1_HWSW__ADDR, ( \
    REG_VAL__R_DMA_CH1_HWSW_(f1##_,v1,f2##_,v2) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH1_HWSW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH1_HWSW(f1,v1,f2,v2) ( \
  (R_DMA_CH1_HWSW__hw__##f1##__MASK & REG__##v1) | \
  (R_DMA_CH1_HWSW__sw__##f2##__MASK & REG__##v2) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH1_HWSW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH1_HWSW.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH1_HWSW(f1,v1,f2,v2) ( \
  (R_DMA_CH1_HWSW__hw__##f1##__VAL(R_DMA_CH1_HWSW_, hw_, v1) << R_DMA_CH1_HWSW__hw__BITNR) | \
  (R_DMA_CH1_HWSW__sw__##f2##__VAL(R_DMA_CH1_HWSW_, sw_, v2) << R_DMA_CH1_HWSW__sw__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH1_HWSW_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH1_HWSW.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH1_HWSW_(f1_,v1,f2_,v2) ( \
  (R_DMA_CH1_HWSW__hw__##f1_##_VAL(R_DMA_CH1_HWSW_, hw_, v1) << R_DMA_CH1_HWSW__hw__BITNR) | \
  (R_DMA_CH1_HWSW__sw__##f2_##_VAL(R_DMA_CH1_HWSW_, sw_, v2) << R_DMA_CH1_HWSW__sw__BITNR) \
)

#endif

/*
 *  R_DMA_CH1_NEXT
 *  - type:  RW
 *  - addr:  0xb0000114
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH1_NEXT
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH1_NEXT.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH1_NEXT. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH1_NEXT(f1,v1) ( \
  R_DMA_CH1_NEXT__WRITE(R_DMA_CH1_NEXT__ADDR, ( \
    REG_VAL__R_DMA_CH1_NEXT_(f1##_,v1) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH1_NEXT
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH1_NEXT(f1,v1) ( \
  (R_DMA_CH1_NEXT__next__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH1_NEXT
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH1_NEXT.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH1_NEXT(f1,v1) ( \
  (R_DMA_CH1_NEXT__next__##f1##__VAL(R_DMA_CH1_NEXT_, next_, v1) << R_DMA_CH1_NEXT__next__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH1_NEXT_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH1_NEXT.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH1_NEXT_(f1_,v1) ( \
  (R_DMA_CH1_NEXT__next__##f1_##_VAL(R_DMA_CH1_NEXT_, next_, v1) << R_DMA_CH1_NEXT__next__BITNR) \
)

#endif

/*
 *  R_DMA_CH1_STATUS
 *  - type:  RO
 *  - addr:  0xb00001d6
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/* No REG_SET__register-name for read only registers. */

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH1_STATUS
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH1_STATUS(f1,v1) ( \
  (R_DMA_CH1_STATUS__avail__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH1_STATUS
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH1_STATUS.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH1_STATUS(f1,v1) ( \
  (R_DMA_CH1_STATUS__avail__##f1##__VAL(R_DMA_CH1_STATUS_, avail_, v1) << R_DMA_CH1_STATUS__avail__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH1_STATUS_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH1_STATUS.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH1_STATUS_(f1_,v1) ( \
  (R_DMA_CH1_STATUS__avail__##f1_##_VAL(R_DMA_CH1_STATUS_, avail_, v1) << R_DMA_CH1_STATUS__avail__BITNR) \
)

#endif

/*
 *  R_DMA_CH2_BUF
 *  - type:  RW
 *  - addr:  0xb0000128
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH2_BUF
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH2_BUF.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH2_BUF. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH2_BUF(f1,v1) ( \
  R_DMA_CH2_BUF__WRITE(R_DMA_CH2_BUF__ADDR, ( \
    REG_VAL__R_DMA_CH2_BUF_(f1##_,v1) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH2_BUF
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH2_BUF(f1,v1) ( \
  (R_DMA_CH2_BUF__buf__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH2_BUF
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH2_BUF.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH2_BUF(f1,v1) ( \
  (R_DMA_CH2_BUF__buf__##f1##__VAL(R_DMA_CH2_BUF_, buf_, v1) << R_DMA_CH2_BUF__buf__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH2_BUF_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH2_BUF.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH2_BUF_(f1_,v1) ( \
  (R_DMA_CH2_BUF__buf__##f1_##_VAL(R_DMA_CH2_BUF_, buf_, v1) << R_DMA_CH2_BUF__buf__BITNR) \
)

#endif

/*
 *  R_DMA_CH2_CLR_INTR
 *  - type:  WO
 *  - addr:  0xb00001d9
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH2_CLR_INTR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH2_CLR_INTR.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH2_CLR_INTR. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH2_CLR_INTR(f1,v1,f2,v2) ( \
  *R_DMA_CH2_CLR_INTR__SADDR = ( \
    REG_INITIATED(R_DMA_CH2_CLR_INTR_) \
    REG_VAL__R_DMA_CH2_CLR_INTR_(f1##_,v1,f2##_,v2) \
  ), \
  R_DMA_CH2_CLR_INTR__WRITE(R_DMA_CH2_CLR_INTR__ADDR, *R_DMA_CH2_CLR_INTR__SADDR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH2_CLR_INTR__SHADOW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH2_CLR_INTR.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in the 
*#               shadow register for R_DMA_CH2_CLR_INTR. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH2_CLR_INTR__SHADOW(f1,v1,f2,v2) ( \
  *R_DMA_CH2_CLR_INTR__SADDR = ( \
    REG_INITIATED(R_DMA_CH2_CLR_INTR_) \
    REG_VAL__R_DMA_CH2_CLR_INTR_(f1##_,v1,f2##_,v2) \
  ) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH2_CLR_INTR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH2_CLR_INTR(f1,v1,f2,v2) ( \
  (R_DMA_CH2_CLR_INTR__clr_eop__##f1##__MASK & REG__##v1) | \
  (R_DMA_CH2_CLR_INTR__clr_descr__##f2##__MASK & REG__##v2) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH2_CLR_INTR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH2_CLR_INTR.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH2_CLR_INTR(f1,v1,f2,v2) ( \
  (R_DMA_CH2_CLR_INTR__clr_eop__##f1##__VAL(R_DMA_CH2_CLR_INTR_, clr_eop_, v1) << R_DMA_CH2_CLR_INTR__clr_eop__BITNR) | \
  (R_DMA_CH2_CLR_INTR__clr_descr__##f2##__VAL(R_DMA_CH2_CLR_INTR_, clr_descr_, v2) << R_DMA_CH2_CLR_INTR__clr_descr__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH2_CLR_INTR_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH2_CLR_INTR.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH2_CLR_INTR_(f1_,v1,f2_,v2) ( \
  (R_DMA_CH2_CLR_INTR__clr_eop__##f1_##_VAL(R_DMA_CH2_CLR_INTR_, clr_eop_, v1) << R_DMA_CH2_CLR_INTR__clr_eop__BITNR) | \
  (R_DMA_CH2_CLR_INTR__clr_descr__##f2_##_VAL(R_DMA_CH2_CLR_INTR_, clr_descr_, v2) << R_DMA_CH2_CLR_INTR__clr_descr__BITNR) \
)

#endif

/*
 *  R_DMA_CH2_CMD
 *  - type:  RW
 *  - addr:  0xb00001d8
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH2_CMD
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH2_CMD.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH2_CMD. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH2_CMD(f1,v1) ( \
  R_DMA_CH2_CMD__WRITE(R_DMA_CH2_CMD__ADDR, ( \
    REG_VAL__R_DMA_CH2_CMD_(f1##_,v1) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH2_CMD
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH2_CMD(f1,v1) ( \
  (R_DMA_CH2_CMD__cmd__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH2_CMD
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH2_CMD.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH2_CMD(f1,v1) ( \
  (R_DMA_CH2_CMD__cmd__##f1##__VAL(R_DMA_CH2_CMD_, cmd_, v1) << R_DMA_CH2_CMD__cmd__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH2_CMD_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH2_CMD.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH2_CMD_(f1_,v1) ( \
  (R_DMA_CH2_CMD__cmd__##f1_##_VAL(R_DMA_CH2_CMD_, cmd_, v1) << R_DMA_CH2_CMD__cmd__BITNR) \
)

#endif

/*
 *  R_DMA_CH2_DESCR
 *  - type:  RW
 *  - addr:  0xb000012c
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH2_DESCR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH2_DESCR.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH2_DESCR. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH2_DESCR(f1,v1) ( \
  R_DMA_CH2_DESCR__WRITE(R_DMA_CH2_DESCR__ADDR, ( \
    REG_VAL__R_DMA_CH2_DESCR_(f1##_,v1) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH2_DESCR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH2_DESCR(f1,v1) ( \
  (R_DMA_CH2_DESCR__descr__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH2_DESCR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH2_DESCR.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH2_DESCR(f1,v1) ( \
  (R_DMA_CH2_DESCR__descr__##f1##__VAL(R_DMA_CH2_DESCR_, descr_, v1) << R_DMA_CH2_DESCR__descr__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH2_DESCR_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH2_DESCR.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH2_DESCR_(f1_,v1) ( \
  (R_DMA_CH2_DESCR__descr__##f1_##_VAL(R_DMA_CH2_DESCR_, descr_, v1) << R_DMA_CH2_DESCR__descr__BITNR) \
)

#endif

/*
 *  R_DMA_CH2_FIRST
 *  - type:  RW
 *  - addr:  0xb00001a8
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH2_FIRST
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH2_FIRST.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH2_FIRST. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH2_FIRST(f1,v1) ( \
  R_DMA_CH2_FIRST__WRITE(R_DMA_CH2_FIRST__ADDR, ( \
    REG_VAL__R_DMA_CH2_FIRST_(f1##_,v1) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH2_FIRST
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH2_FIRST(f1,v1) ( \
  (R_DMA_CH2_FIRST__first__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH2_FIRST
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH2_FIRST.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH2_FIRST(f1,v1) ( \
  (R_DMA_CH2_FIRST__first__##f1##__VAL(R_DMA_CH2_FIRST_, first_, v1) << R_DMA_CH2_FIRST__first__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH2_FIRST_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH2_FIRST.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH2_FIRST_(f1_,v1) ( \
  (R_DMA_CH2_FIRST__first__##f1_##_VAL(R_DMA_CH2_FIRST_, first_, v1) << R_DMA_CH2_FIRST__first__BITNR) \
)

#endif

/*
 *  R_DMA_CH2_HWSW
 *  - type:  RW
 *  - addr:  0xb0000120
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH2_HWSW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH2_HWSW.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH2_HWSW. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH2_HWSW(f1,v1,f2,v2) ( \
  R_DMA_CH2_HWSW__WRITE(R_DMA_CH2_HWSW__ADDR, ( \
    REG_VAL__R_DMA_CH2_HWSW_(f1##_,v1,f2##_,v2) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH2_HWSW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH2_HWSW(f1,v1,f2,v2) ( \
  (R_DMA_CH2_HWSW__hw__##f1##__MASK & REG__##v1) | \
  (R_DMA_CH2_HWSW__sw__##f2##__MASK & REG__##v2) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH2_HWSW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH2_HWSW.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH2_HWSW(f1,v1,f2,v2) ( \
  (R_DMA_CH2_HWSW__hw__##f1##__VAL(R_DMA_CH2_HWSW_, hw_, v1) << R_DMA_CH2_HWSW__hw__BITNR) | \
  (R_DMA_CH2_HWSW__sw__##f2##__VAL(R_DMA_CH2_HWSW_, sw_, v2) << R_DMA_CH2_HWSW__sw__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH2_HWSW_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH2_HWSW.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH2_HWSW_(f1_,v1,f2_,v2) ( \
  (R_DMA_CH2_HWSW__hw__##f1_##_VAL(R_DMA_CH2_HWSW_, hw_, v1) << R_DMA_CH2_HWSW__hw__BITNR) | \
  (R_DMA_CH2_HWSW__sw__##f2_##_VAL(R_DMA_CH2_HWSW_, sw_, v2) << R_DMA_CH2_HWSW__sw__BITNR) \
)

#endif

/*
 *  R_DMA_CH2_NEXT
 *  - type:  RW
 *  - addr:  0xb0000124
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH2_NEXT
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH2_NEXT.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH2_NEXT. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH2_NEXT(f1,v1) ( \
  R_DMA_CH2_NEXT__WRITE(R_DMA_CH2_NEXT__ADDR, ( \
    REG_VAL__R_DMA_CH2_NEXT_(f1##_,v1) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH2_NEXT
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH2_NEXT(f1,v1) ( \
  (R_DMA_CH2_NEXT__next__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH2_NEXT
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH2_NEXT.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH2_NEXT(f1,v1) ( \
  (R_DMA_CH2_NEXT__next__##f1##__VAL(R_DMA_CH2_NEXT_, next_, v1) << R_DMA_CH2_NEXT__next__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH2_NEXT_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH2_NEXT.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH2_NEXT_(f1_,v1) ( \
  (R_DMA_CH2_NEXT__next__##f1_##_VAL(R_DMA_CH2_NEXT_, next_, v1) << R_DMA_CH2_NEXT__next__BITNR) \
)

#endif

/*
 *  R_DMA_CH2_STATUS
 *  - type:  RO
 *  - addr:  0xb00001da
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/* No REG_SET__register-name for read only registers. */

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH2_STATUS
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH2_STATUS(f1,v1) ( \
  (R_DMA_CH2_STATUS__avail__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH2_STATUS
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH2_STATUS.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH2_STATUS(f1,v1) ( \
  (R_DMA_CH2_STATUS__avail__##f1##__VAL(R_DMA_CH2_STATUS_, avail_, v1) << R_DMA_CH2_STATUS__avail__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH2_STATUS_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH2_STATUS.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH2_STATUS_(f1_,v1) ( \
  (R_DMA_CH2_STATUS__avail__##f1_##_VAL(R_DMA_CH2_STATUS_, avail_, v1) << R_DMA_CH2_STATUS__avail__BITNR) \
)

#endif

/*
 *  R_DMA_CH3_BUF
 *  - type:  RW
 *  - addr:  0xb0000138
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH3_BUF
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH3_BUF.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH3_BUF. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH3_BUF(f1,v1) ( \
  R_DMA_CH3_BUF__WRITE(R_DMA_CH3_BUF__ADDR, ( \
    REG_VAL__R_DMA_CH3_BUF_(f1##_,v1) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH3_BUF
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH3_BUF(f1,v1) ( \
  (R_DMA_CH3_BUF__buf__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH3_BUF
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH3_BUF.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH3_BUF(f1,v1) ( \
  (R_DMA_CH3_BUF__buf__##f1##__VAL(R_DMA_CH3_BUF_, buf_, v1) << R_DMA_CH3_BUF__buf__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH3_BUF_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH3_BUF.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH3_BUF_(f1_,v1) ( \
  (R_DMA_CH3_BUF__buf__##f1_##_VAL(R_DMA_CH3_BUF_, buf_, v1) << R_DMA_CH3_BUF__buf__BITNR) \
)

#endif

/*
 *  R_DMA_CH3_CLR_INTR
 *  - type:  WO
 *  - addr:  0xb00001dd
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH3_CLR_INTR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH3_CLR_INTR.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH3_CLR_INTR. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH3_CLR_INTR(f1,v1,f2,v2) ( \
  *R_DMA_CH3_CLR_INTR__SADDR = ( \
    REG_INITIATED(R_DMA_CH3_CLR_INTR_) \
    REG_VAL__R_DMA_CH3_CLR_INTR_(f1##_,v1,f2##_,v2) \
  ), \
  R_DMA_CH3_CLR_INTR__WRITE(R_DMA_CH3_CLR_INTR__ADDR, *R_DMA_CH3_CLR_INTR__SADDR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH3_CLR_INTR__SHADOW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH3_CLR_INTR.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in the 
*#               shadow register for R_DMA_CH3_CLR_INTR. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH3_CLR_INTR__SHADOW(f1,v1,f2,v2) ( \
  *R_DMA_CH3_CLR_INTR__SADDR = ( \
    REG_INITIATED(R_DMA_CH3_CLR_INTR_) \
    REG_VAL__R_DMA_CH3_CLR_INTR_(f1##_,v1,f2##_,v2) \
  ) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH3_CLR_INTR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH3_CLR_INTR(f1,v1,f2,v2) ( \
  (R_DMA_CH3_CLR_INTR__clr_eop__##f1##__MASK & REG__##v1) | \
  (R_DMA_CH3_CLR_INTR__clr_descr__##f2##__MASK & REG__##v2) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH3_CLR_INTR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH3_CLR_INTR.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH3_CLR_INTR(f1,v1,f2,v2) ( \
  (R_DMA_CH3_CLR_INTR__clr_eop__##f1##__VAL(R_DMA_CH3_CLR_INTR_, clr_eop_, v1) << R_DMA_CH3_CLR_INTR__clr_eop__BITNR) | \
  (R_DMA_CH3_CLR_INTR__clr_descr__##f2##__VAL(R_DMA_CH3_CLR_INTR_, clr_descr_, v2) << R_DMA_CH3_CLR_INTR__clr_descr__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH3_CLR_INTR_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH3_CLR_INTR.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH3_CLR_INTR_(f1_,v1,f2_,v2) ( \
  (R_DMA_CH3_CLR_INTR__clr_eop__##f1_##_VAL(R_DMA_CH3_CLR_INTR_, clr_eop_, v1) << R_DMA_CH3_CLR_INTR__clr_eop__BITNR) | \
  (R_DMA_CH3_CLR_INTR__clr_descr__##f2_##_VAL(R_DMA_CH3_CLR_INTR_, clr_descr_, v2) << R_DMA_CH3_CLR_INTR__clr_descr__BITNR) \
)

#endif

/*
 *  R_DMA_CH3_CMD
 *  - type:  RW
 *  - addr:  0xb00001dc
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH3_CMD
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH3_CMD.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH3_CMD. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH3_CMD(f1,v1) ( \
  R_DMA_CH3_CMD__WRITE(R_DMA_CH3_CMD__ADDR, ( \
    REG_VAL__R_DMA_CH3_CMD_(f1##_,v1) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH3_CMD
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH3_CMD(f1,v1) ( \
  (R_DMA_CH3_CMD__cmd__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH3_CMD
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH3_CMD.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH3_CMD(f1,v1) ( \
  (R_DMA_CH3_CMD__cmd__##f1##__VAL(R_DMA_CH3_CMD_, cmd_, v1) << R_DMA_CH3_CMD__cmd__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH3_CMD_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH3_CMD.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH3_CMD_(f1_,v1) ( \
  (R_DMA_CH3_CMD__cmd__##f1_##_VAL(R_DMA_CH3_CMD_, cmd_, v1) << R_DMA_CH3_CMD__cmd__BITNR) \
)

#endif

/*
 *  R_DMA_CH3_DESCR
 *  - type:  RW
 *  - addr:  0xb000013c
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH3_DESCR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH3_DESCR.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH3_DESCR. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH3_DESCR(f1,v1) ( \
  R_DMA_CH3_DESCR__WRITE(R_DMA_CH3_DESCR__ADDR, ( \
    REG_VAL__R_DMA_CH3_DESCR_(f1##_,v1) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH3_DESCR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH3_DESCR(f1,v1) ( \
  (R_DMA_CH3_DESCR__descr__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH3_DESCR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH3_DESCR.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH3_DESCR(f1,v1) ( \
  (R_DMA_CH3_DESCR__descr__##f1##__VAL(R_DMA_CH3_DESCR_, descr_, v1) << R_DMA_CH3_DESCR__descr__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH3_DESCR_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH3_DESCR.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH3_DESCR_(f1_,v1) ( \
  (R_DMA_CH3_DESCR__descr__##f1_##_VAL(R_DMA_CH3_DESCR_, descr_, v1) << R_DMA_CH3_DESCR__descr__BITNR) \
)

#endif

/*
 *  R_DMA_CH3_FIRST
 *  - type:  RW
 *  - addr:  0xb00001ac
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH3_FIRST
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH3_FIRST.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH3_FIRST. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH3_FIRST(f1,v1) ( \
  R_DMA_CH3_FIRST__WRITE(R_DMA_CH3_FIRST__ADDR, ( \
    REG_VAL__R_DMA_CH3_FIRST_(f1##_,v1) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH3_FIRST
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH3_FIRST(f1,v1) ( \
  (R_DMA_CH3_FIRST__first__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH3_FIRST
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH3_FIRST.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH3_FIRST(f1,v1) ( \
  (R_DMA_CH3_FIRST__first__##f1##__VAL(R_DMA_CH3_FIRST_, first_, v1) << R_DMA_CH3_FIRST__first__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH3_FIRST_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH3_FIRST.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH3_FIRST_(f1_,v1) ( \
  (R_DMA_CH3_FIRST__first__##f1_##_VAL(R_DMA_CH3_FIRST_, first_, v1) << R_DMA_CH3_FIRST__first__BITNR) \
)

#endif

/*
 *  R_DMA_CH3_HWSW
 *  - type:  RW
 *  - addr:  0xb0000130
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH3_HWSW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH3_HWSW.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH3_HWSW. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH3_HWSW(f1,v1,f2,v2) ( \
  R_DMA_CH3_HWSW__WRITE(R_DMA_CH3_HWSW__ADDR, ( \
    REG_VAL__R_DMA_CH3_HWSW_(f1##_,v1,f2##_,v2) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH3_HWSW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH3_HWSW(f1,v1,f2,v2) ( \
  (R_DMA_CH3_HWSW__hw__##f1##__MASK & REG__##v1) | \
  (R_DMA_CH3_HWSW__sw__##f2##__MASK & REG__##v2) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH3_HWSW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH3_HWSW.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH3_HWSW(f1,v1,f2,v2) ( \
  (R_DMA_CH3_HWSW__hw__##f1##__VAL(R_DMA_CH3_HWSW_, hw_, v1) << R_DMA_CH3_HWSW__hw__BITNR) | \
  (R_DMA_CH3_HWSW__sw__##f2##__VAL(R_DMA_CH3_HWSW_, sw_, v2) << R_DMA_CH3_HWSW__sw__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH3_HWSW_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH3_HWSW.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH3_HWSW_(f1_,v1,f2_,v2) ( \
  (R_DMA_CH3_HWSW__hw__##f1_##_VAL(R_DMA_CH3_HWSW_, hw_, v1) << R_DMA_CH3_HWSW__hw__BITNR) | \
  (R_DMA_CH3_HWSW__sw__##f2_##_VAL(R_DMA_CH3_HWSW_, sw_, v2) << R_DMA_CH3_HWSW__sw__BITNR) \
)

#endif

/*
 *  R_DMA_CH3_NEXT
 *  - type:  RW
 *  - addr:  0xb0000134
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH3_NEXT
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH3_NEXT.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH3_NEXT. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH3_NEXT(f1,v1) ( \
  R_DMA_CH3_NEXT__WRITE(R_DMA_CH3_NEXT__ADDR, ( \
    REG_VAL__R_DMA_CH3_NEXT_(f1##_,v1) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH3_NEXT
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH3_NEXT(f1,v1) ( \
  (R_DMA_CH3_NEXT__next__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH3_NEXT
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH3_NEXT.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH3_NEXT(f1,v1) ( \
  (R_DMA_CH3_NEXT__next__##f1##__VAL(R_DMA_CH3_NEXT_, next_, v1) << R_DMA_CH3_NEXT__next__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH3_NEXT_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH3_NEXT.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH3_NEXT_(f1_,v1) ( \
  (R_DMA_CH3_NEXT__next__##f1_##_VAL(R_DMA_CH3_NEXT_, next_, v1) << R_DMA_CH3_NEXT__next__BITNR) \
)

#endif

/*
 *  R_DMA_CH3_STATUS
 *  - type:  RO
 *  - addr:  0xb00001de
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/* No REG_SET__register-name for read only registers. */

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH3_STATUS
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH3_STATUS(f1,v1) ( \
  (R_DMA_CH3_STATUS__avail__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH3_STATUS
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH3_STATUS.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH3_STATUS(f1,v1) ( \
  (R_DMA_CH3_STATUS__avail__##f1##__VAL(R_DMA_CH3_STATUS_, avail_, v1) << R_DMA_CH3_STATUS__avail__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH3_STATUS_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH3_STATUS.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH3_STATUS_(f1_,v1) ( \
  (R_DMA_CH3_STATUS__avail__##f1_##_VAL(R_DMA_CH3_STATUS_, avail_, v1) << R_DMA_CH3_STATUS__avail__BITNR) \
)

#endif

/*
 *  R_DMA_CH4_BUF
 *  - type:  RW
 *  - addr:  0xb0000148
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH4_BUF
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH4_BUF.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH4_BUF. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH4_BUF(f1,v1) ( \
  R_DMA_CH4_BUF__WRITE(R_DMA_CH4_BUF__ADDR, ( \
    REG_VAL__R_DMA_CH4_BUF_(f1##_,v1) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH4_BUF
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH4_BUF(f1,v1) ( \
  (R_DMA_CH4_BUF__buf__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH4_BUF
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH4_BUF.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH4_BUF(f1,v1) ( \
  (R_DMA_CH4_BUF__buf__##f1##__VAL(R_DMA_CH4_BUF_, buf_, v1) << R_DMA_CH4_BUF__buf__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH4_BUF_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH4_BUF.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH4_BUF_(f1_,v1) ( \
  (R_DMA_CH4_BUF__buf__##f1_##_VAL(R_DMA_CH4_BUF_, buf_, v1) << R_DMA_CH4_BUF__buf__BITNR) \
)

#endif

/*
 *  R_DMA_CH4_CLR_INTR
 *  - type:  WO
 *  - addr:  0xb00001e1
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH4_CLR_INTR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH4_CLR_INTR.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH4_CLR_INTR. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH4_CLR_INTR(f1,v1,f2,v2) ( \
  *R_DMA_CH4_CLR_INTR__SADDR = ( \
    REG_INITIATED(R_DMA_CH4_CLR_INTR_) \
    REG_VAL__R_DMA_CH4_CLR_INTR_(f1##_,v1,f2##_,v2) \
  ), \
  R_DMA_CH4_CLR_INTR__WRITE(R_DMA_CH4_CLR_INTR__ADDR, *R_DMA_CH4_CLR_INTR__SADDR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH4_CLR_INTR__SHADOW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH4_CLR_INTR.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in the 
*#               shadow register for R_DMA_CH4_CLR_INTR. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH4_CLR_INTR__SHADOW(f1,v1,f2,v2) ( \
  *R_DMA_CH4_CLR_INTR__SADDR = ( \
    REG_INITIATED(R_DMA_CH4_CLR_INTR_) \
    REG_VAL__R_DMA_CH4_CLR_INTR_(f1##_,v1,f2##_,v2) \
  ) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH4_CLR_INTR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH4_CLR_INTR(f1,v1,f2,v2) ( \
  (R_DMA_CH4_CLR_INTR__clr_eop__##f1##__MASK & REG__##v1) | \
  (R_DMA_CH4_CLR_INTR__clr_descr__##f2##__MASK & REG__##v2) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH4_CLR_INTR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH4_CLR_INTR.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH4_CLR_INTR(f1,v1,f2,v2) ( \
  (R_DMA_CH4_CLR_INTR__clr_eop__##f1##__VAL(R_DMA_CH4_CLR_INTR_, clr_eop_, v1) << R_DMA_CH4_CLR_INTR__clr_eop__BITNR) | \
  (R_DMA_CH4_CLR_INTR__clr_descr__##f2##__VAL(R_DMA_CH4_CLR_INTR_, clr_descr_, v2) << R_DMA_CH4_CLR_INTR__clr_descr__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH4_CLR_INTR_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH4_CLR_INTR.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH4_CLR_INTR_(f1_,v1,f2_,v2) ( \
  (R_DMA_CH4_CLR_INTR__clr_eop__##f1_##_VAL(R_DMA_CH4_CLR_INTR_, clr_eop_, v1) << R_DMA_CH4_CLR_INTR__clr_eop__BITNR) | \
  (R_DMA_CH4_CLR_INTR__clr_descr__##f2_##_VAL(R_DMA_CH4_CLR_INTR_, clr_descr_, v2) << R_DMA_CH4_CLR_INTR__clr_descr__BITNR) \
)

#endif

/*
 *  R_DMA_CH4_CMD
 *  - type:  RW
 *  - addr:  0xb00001e0
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH4_CMD
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH4_CMD.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH4_CMD. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH4_CMD(f1,v1) ( \
  R_DMA_CH4_CMD__WRITE(R_DMA_CH4_CMD__ADDR, ( \
    REG_VAL__R_DMA_CH4_CMD_(f1##_,v1) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH4_CMD
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH4_CMD(f1,v1) ( \
  (R_DMA_CH4_CMD__cmd__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH4_CMD
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH4_CMD.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH4_CMD(f1,v1) ( \
  (R_DMA_CH4_CMD__cmd__##f1##__VAL(R_DMA_CH4_CMD_, cmd_, v1) << R_DMA_CH4_CMD__cmd__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH4_CMD_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH4_CMD.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH4_CMD_(f1_,v1) ( \
  (R_DMA_CH4_CMD__cmd__##f1_##_VAL(R_DMA_CH4_CMD_, cmd_, v1) << R_DMA_CH4_CMD__cmd__BITNR) \
)

#endif

/*
 *  R_DMA_CH4_DESCR
 *  - type:  RW
 *  - addr:  0xb000014c
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH4_DESCR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH4_DESCR.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH4_DESCR. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH4_DESCR(f1,v1) ( \
  R_DMA_CH4_DESCR__WRITE(R_DMA_CH4_DESCR__ADDR, ( \
    REG_VAL__R_DMA_CH4_DESCR_(f1##_,v1) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH4_DESCR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH4_DESCR(f1,v1) ( \
  (R_DMA_CH4_DESCR__descr__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH4_DESCR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH4_DESCR.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH4_DESCR(f1,v1) ( \
  (R_DMA_CH4_DESCR__descr__##f1##__VAL(R_DMA_CH4_DESCR_, descr_, v1) << R_DMA_CH4_DESCR__descr__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH4_DESCR_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH4_DESCR.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH4_DESCR_(f1_,v1) ( \
  (R_DMA_CH4_DESCR__descr__##f1_##_VAL(R_DMA_CH4_DESCR_, descr_, v1) << R_DMA_CH4_DESCR__descr__BITNR) \
)

#endif

/*
 *  R_DMA_CH4_FIRST
 *  - type:  RW
 *  - addr:  0xb00001b0
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH4_FIRST
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH4_FIRST.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH4_FIRST. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH4_FIRST(f1,v1) ( \
  R_DMA_CH4_FIRST__WRITE(R_DMA_CH4_FIRST__ADDR, ( \
    REG_VAL__R_DMA_CH4_FIRST_(f1##_,v1) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH4_FIRST
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH4_FIRST(f1,v1) ( \
  (R_DMA_CH4_FIRST__first__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH4_FIRST
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH4_FIRST.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH4_FIRST(f1,v1) ( \
  (R_DMA_CH4_FIRST__first__##f1##__VAL(R_DMA_CH4_FIRST_, first_, v1) << R_DMA_CH4_FIRST__first__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH4_FIRST_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH4_FIRST.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH4_FIRST_(f1_,v1) ( \
  (R_DMA_CH4_FIRST__first__##f1_##_VAL(R_DMA_CH4_FIRST_, first_, v1) << R_DMA_CH4_FIRST__first__BITNR) \
)

#endif

/*
 *  R_DMA_CH4_HWSW
 *  - type:  RW
 *  - addr:  0xb0000140
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH4_HWSW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH4_HWSW.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH4_HWSW. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH4_HWSW(f1,v1,f2,v2) ( \
  R_DMA_CH4_HWSW__WRITE(R_DMA_CH4_HWSW__ADDR, ( \
    REG_VAL__R_DMA_CH4_HWSW_(f1##_,v1,f2##_,v2) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH4_HWSW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH4_HWSW(f1,v1,f2,v2) ( \
  (R_DMA_CH4_HWSW__hw__##f1##__MASK & REG__##v1) | \
  (R_DMA_CH4_HWSW__sw__##f2##__MASK & REG__##v2) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH4_HWSW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH4_HWSW.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH4_HWSW(f1,v1,f2,v2) ( \
  (R_DMA_CH4_HWSW__hw__##f1##__VAL(R_DMA_CH4_HWSW_, hw_, v1) << R_DMA_CH4_HWSW__hw__BITNR) | \
  (R_DMA_CH4_HWSW__sw__##f2##__VAL(R_DMA_CH4_HWSW_, sw_, v2) << R_DMA_CH4_HWSW__sw__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH4_HWSW_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH4_HWSW.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH4_HWSW_(f1_,v1,f2_,v2) ( \
  (R_DMA_CH4_HWSW__hw__##f1_##_VAL(R_DMA_CH4_HWSW_, hw_, v1) << R_DMA_CH4_HWSW__hw__BITNR) | \
  (R_DMA_CH4_HWSW__sw__##f2_##_VAL(R_DMA_CH4_HWSW_, sw_, v2) << R_DMA_CH4_HWSW__sw__BITNR) \
)

#endif

/*
 *  R_DMA_CH4_NEXT
 *  - type:  RW
 *  - addr:  0xb0000144
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH4_NEXT
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH4_NEXT.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH4_NEXT. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH4_NEXT(f1,v1) ( \
  R_DMA_CH4_NEXT__WRITE(R_DMA_CH4_NEXT__ADDR, ( \
    REG_VAL__R_DMA_CH4_NEXT_(f1##_,v1) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH4_NEXT
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH4_NEXT(f1,v1) ( \
  (R_DMA_CH4_NEXT__next__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH4_NEXT
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH4_NEXT.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH4_NEXT(f1,v1) ( \
  (R_DMA_CH4_NEXT__next__##f1##__VAL(R_DMA_CH4_NEXT_, next_, v1) << R_DMA_CH4_NEXT__next__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH4_NEXT_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH4_NEXT.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH4_NEXT_(f1_,v1) ( \
  (R_DMA_CH4_NEXT__next__##f1_##_VAL(R_DMA_CH4_NEXT_, next_, v1) << R_DMA_CH4_NEXT__next__BITNR) \
)

#endif

/*
 *  R_DMA_CH4_STATUS
 *  - type:  RO
 *  - addr:  0xb00001e2
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/* No REG_SET__register-name for read only registers. */

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH4_STATUS
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH4_STATUS(f1,v1) ( \
  (R_DMA_CH4_STATUS__avail__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH4_STATUS
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH4_STATUS.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH4_STATUS(f1,v1) ( \
  (R_DMA_CH4_STATUS__avail__##f1##__VAL(R_DMA_CH4_STATUS_, avail_, v1) << R_DMA_CH4_STATUS__avail__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH4_STATUS_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH4_STATUS.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH4_STATUS_(f1_,v1) ( \
  (R_DMA_CH4_STATUS__avail__##f1_##_VAL(R_DMA_CH4_STATUS_, avail_, v1) << R_DMA_CH4_STATUS__avail__BITNR) \
)

#endif

/*
 *  R_DMA_CH5_BUF
 *  - type:  RW
 *  - addr:  0xb0000158
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH5_BUF
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH5_BUF.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH5_BUF. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH5_BUF(f1,v1) ( \
  R_DMA_CH5_BUF__WRITE(R_DMA_CH5_BUF__ADDR, ( \
    REG_VAL__R_DMA_CH5_BUF_(f1##_,v1) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH5_BUF
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH5_BUF(f1,v1) ( \
  (R_DMA_CH5_BUF__buf__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH5_BUF
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH5_BUF.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH5_BUF(f1,v1) ( \
  (R_DMA_CH5_BUF__buf__##f1##__VAL(R_DMA_CH5_BUF_, buf_, v1) << R_DMA_CH5_BUF__buf__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH5_BUF_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH5_BUF.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH5_BUF_(f1_,v1) ( \
  (R_DMA_CH5_BUF__buf__##f1_##_VAL(R_DMA_CH5_BUF_, buf_, v1) << R_DMA_CH5_BUF__buf__BITNR) \
)

#endif

/*
 *  R_DMA_CH5_CLR_INTR
 *  - type:  WO
 *  - addr:  0xb00001e5
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH5_CLR_INTR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH5_CLR_INTR.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH5_CLR_INTR. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH5_CLR_INTR(f1,v1,f2,v2) ( \
  *R_DMA_CH5_CLR_INTR__SADDR = ( \
    REG_INITIATED(R_DMA_CH5_CLR_INTR_) \
    REG_VAL__R_DMA_CH5_CLR_INTR_(f1##_,v1,f2##_,v2) \
  ), \
  R_DMA_CH5_CLR_INTR__WRITE(R_DMA_CH5_CLR_INTR__ADDR, *R_DMA_CH5_CLR_INTR__SADDR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH5_CLR_INTR__SHADOW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH5_CLR_INTR.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in the 
*#               shadow register for R_DMA_CH5_CLR_INTR. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH5_CLR_INTR__SHADOW(f1,v1,f2,v2) ( \
  *R_DMA_CH5_CLR_INTR__SADDR = ( \
    REG_INITIATED(R_DMA_CH5_CLR_INTR_) \
    REG_VAL__R_DMA_CH5_CLR_INTR_(f1##_,v1,f2##_,v2) \
  ) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH5_CLR_INTR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH5_CLR_INTR(f1,v1,f2,v2) ( \
  (R_DMA_CH5_CLR_INTR__clr_eop__##f1##__MASK & REG__##v1) | \
  (R_DMA_CH5_CLR_INTR__clr_descr__##f2##__MASK & REG__##v2) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH5_CLR_INTR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH5_CLR_INTR.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH5_CLR_INTR(f1,v1,f2,v2) ( \
  (R_DMA_CH5_CLR_INTR__clr_eop__##f1##__VAL(R_DMA_CH5_CLR_INTR_, clr_eop_, v1) << R_DMA_CH5_CLR_INTR__clr_eop__BITNR) | \
  (R_DMA_CH5_CLR_INTR__clr_descr__##f2##__VAL(R_DMA_CH5_CLR_INTR_, clr_descr_, v2) << R_DMA_CH5_CLR_INTR__clr_descr__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH5_CLR_INTR_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH5_CLR_INTR.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH5_CLR_INTR_(f1_,v1,f2_,v2) ( \
  (R_DMA_CH5_CLR_INTR__clr_eop__##f1_##_VAL(R_DMA_CH5_CLR_INTR_, clr_eop_, v1) << R_DMA_CH5_CLR_INTR__clr_eop__BITNR) | \
  (R_DMA_CH5_CLR_INTR__clr_descr__##f2_##_VAL(R_DMA_CH5_CLR_INTR_, clr_descr_, v2) << R_DMA_CH5_CLR_INTR__clr_descr__BITNR) \
)

#endif

/*
 *  R_DMA_CH5_CMD
 *  - type:  RW
 *  - addr:  0xb00001e4
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH5_CMD
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH5_CMD.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH5_CMD. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH5_CMD(f1,v1) ( \
  R_DMA_CH5_CMD__WRITE(R_DMA_CH5_CMD__ADDR, ( \
    REG_VAL__R_DMA_CH5_CMD_(f1##_,v1) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH5_CMD
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH5_CMD(f1,v1) ( \
  (R_DMA_CH5_CMD__cmd__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH5_CMD
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH5_CMD.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH5_CMD(f1,v1) ( \
  (R_DMA_CH5_CMD__cmd__##f1##__VAL(R_DMA_CH5_CMD_, cmd_, v1) << R_DMA_CH5_CMD__cmd__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH5_CMD_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH5_CMD.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH5_CMD_(f1_,v1) ( \
  (R_DMA_CH5_CMD__cmd__##f1_##_VAL(R_DMA_CH5_CMD_, cmd_, v1) << R_DMA_CH5_CMD__cmd__BITNR) \
)

#endif

/*
 *  R_DMA_CH5_DESCR
 *  - type:  RW
 *  - addr:  0xb000015c
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH5_DESCR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH5_DESCR.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH5_DESCR. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH5_DESCR(f1,v1) ( \
  R_DMA_CH5_DESCR__WRITE(R_DMA_CH5_DESCR__ADDR, ( \
    REG_VAL__R_DMA_CH5_DESCR_(f1##_,v1) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH5_DESCR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH5_DESCR(f1,v1) ( \
  (R_DMA_CH5_DESCR__descr__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH5_DESCR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH5_DESCR.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH5_DESCR(f1,v1) ( \
  (R_DMA_CH5_DESCR__descr__##f1##__VAL(R_DMA_CH5_DESCR_, descr_, v1) << R_DMA_CH5_DESCR__descr__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH5_DESCR_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH5_DESCR.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH5_DESCR_(f1_,v1) ( \
  (R_DMA_CH5_DESCR__descr__##f1_##_VAL(R_DMA_CH5_DESCR_, descr_, v1) << R_DMA_CH5_DESCR__descr__BITNR) \
)

#endif

/*
 *  R_DMA_CH5_FIRST
 *  - type:  RW
 *  - addr:  0xb00001b4
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH5_FIRST
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH5_FIRST.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH5_FIRST. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH5_FIRST(f1,v1) ( \
  R_DMA_CH5_FIRST__WRITE(R_DMA_CH5_FIRST__ADDR, ( \
    REG_VAL__R_DMA_CH5_FIRST_(f1##_,v1) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH5_FIRST
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH5_FIRST(f1,v1) ( \
  (R_DMA_CH5_FIRST__first__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH5_FIRST
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH5_FIRST.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH5_FIRST(f1,v1) ( \
  (R_DMA_CH5_FIRST__first__##f1##__VAL(R_DMA_CH5_FIRST_, first_, v1) << R_DMA_CH5_FIRST__first__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH5_FIRST_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH5_FIRST.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH5_FIRST_(f1_,v1) ( \
  (R_DMA_CH5_FIRST__first__##f1_##_VAL(R_DMA_CH5_FIRST_, first_, v1) << R_DMA_CH5_FIRST__first__BITNR) \
)

#endif

/*
 *  R_DMA_CH5_HWSW
 *  - type:  RW
 *  - addr:  0xb0000150
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH5_HWSW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH5_HWSW.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH5_HWSW. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH5_HWSW(f1,v1,f2,v2) ( \
  R_DMA_CH5_HWSW__WRITE(R_DMA_CH5_HWSW__ADDR, ( \
    REG_VAL__R_DMA_CH5_HWSW_(f1##_,v1,f2##_,v2) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH5_HWSW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH5_HWSW(f1,v1,f2,v2) ( \
  (R_DMA_CH5_HWSW__hw__##f1##__MASK & REG__##v1) | \
  (R_DMA_CH5_HWSW__sw__##f2##__MASK & REG__##v2) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH5_HWSW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH5_HWSW.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH5_HWSW(f1,v1,f2,v2) ( \
  (R_DMA_CH5_HWSW__hw__##f1##__VAL(R_DMA_CH5_HWSW_, hw_, v1) << R_DMA_CH5_HWSW__hw__BITNR) | \
  (R_DMA_CH5_HWSW__sw__##f2##__VAL(R_DMA_CH5_HWSW_, sw_, v2) << R_DMA_CH5_HWSW__sw__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH5_HWSW_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH5_HWSW.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH5_HWSW_(f1_,v1,f2_,v2) ( \
  (R_DMA_CH5_HWSW__hw__##f1_##_VAL(R_DMA_CH5_HWSW_, hw_, v1) << R_DMA_CH5_HWSW__hw__BITNR) | \
  (R_DMA_CH5_HWSW__sw__##f2_##_VAL(R_DMA_CH5_HWSW_, sw_, v2) << R_DMA_CH5_HWSW__sw__BITNR) \
)

#endif

/*
 *  R_DMA_CH5_NEXT
 *  - type:  RW
 *  - addr:  0xb0000154
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH5_NEXT
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH5_NEXT.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH5_NEXT. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH5_NEXT(f1,v1) ( \
  R_DMA_CH5_NEXT__WRITE(R_DMA_CH5_NEXT__ADDR, ( \
    REG_VAL__R_DMA_CH5_NEXT_(f1##_,v1) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH5_NEXT
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH5_NEXT(f1,v1) ( \
  (R_DMA_CH5_NEXT__next__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH5_NEXT
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH5_NEXT.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH5_NEXT(f1,v1) ( \
  (R_DMA_CH5_NEXT__next__##f1##__VAL(R_DMA_CH5_NEXT_, next_, v1) << R_DMA_CH5_NEXT__next__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH5_NEXT_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH5_NEXT.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH5_NEXT_(f1_,v1) ( \
  (R_DMA_CH5_NEXT__next__##f1_##_VAL(R_DMA_CH5_NEXT_, next_, v1) << R_DMA_CH5_NEXT__next__BITNR) \
)

#endif

/*
 *  R_DMA_CH5_STATUS
 *  - type:  RO
 *  - addr:  0xb00001e6
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/* No REG_SET__register-name for read only registers. */

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH5_STATUS
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH5_STATUS(f1,v1) ( \
  (R_DMA_CH5_STATUS__avail__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH5_STATUS
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH5_STATUS.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH5_STATUS(f1,v1) ( \
  (R_DMA_CH5_STATUS__avail__##f1##__VAL(R_DMA_CH5_STATUS_, avail_, v1) << R_DMA_CH5_STATUS__avail__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH5_STATUS_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH5_STATUS.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH5_STATUS_(f1_,v1) ( \
  (R_DMA_CH5_STATUS__avail__##f1_##_VAL(R_DMA_CH5_STATUS_, avail_, v1) << R_DMA_CH5_STATUS__avail__BITNR) \
)

#endif

/*
 *  R_DMA_CH6_BUF
 *  - type:  RW
 *  - addr:  0xb0000168
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH6_BUF
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH6_BUF.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH6_BUF. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH6_BUF(f1,v1) ( \
  R_DMA_CH6_BUF__WRITE(R_DMA_CH6_BUF__ADDR, ( \
    REG_VAL__R_DMA_CH6_BUF_(f1##_,v1) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH6_BUF
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH6_BUF(f1,v1) ( \
  (R_DMA_CH6_BUF__buf__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH6_BUF
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH6_BUF.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH6_BUF(f1,v1) ( \
  (R_DMA_CH6_BUF__buf__##f1##__VAL(R_DMA_CH6_BUF_, buf_, v1) << R_DMA_CH6_BUF__buf__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH6_BUF_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH6_BUF.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH6_BUF_(f1_,v1) ( \
  (R_DMA_CH6_BUF__buf__##f1_##_VAL(R_DMA_CH6_BUF_, buf_, v1) << R_DMA_CH6_BUF__buf__BITNR) \
)

#endif

/*
 *  R_DMA_CH6_CLR_INTR
 *  - type:  WO
 *  - addr:  0xb00001e9
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH6_CLR_INTR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH6_CLR_INTR.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH6_CLR_INTR. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH6_CLR_INTR(f1,v1,f2,v2) ( \
  *R_DMA_CH6_CLR_INTR__SADDR = ( \
    REG_INITIATED(R_DMA_CH6_CLR_INTR_) \
    REG_VAL__R_DMA_CH6_CLR_INTR_(f1##_,v1,f2##_,v2) \
  ), \
  R_DMA_CH6_CLR_INTR__WRITE(R_DMA_CH6_CLR_INTR__ADDR, *R_DMA_CH6_CLR_INTR__SADDR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH6_CLR_INTR__SHADOW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH6_CLR_INTR.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in the 
*#               shadow register for R_DMA_CH6_CLR_INTR. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH6_CLR_INTR__SHADOW(f1,v1,f2,v2) ( \
  *R_DMA_CH6_CLR_INTR__SADDR = ( \
    REG_INITIATED(R_DMA_CH6_CLR_INTR_) \
    REG_VAL__R_DMA_CH6_CLR_INTR_(f1##_,v1,f2##_,v2) \
  ) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH6_CLR_INTR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH6_CLR_INTR(f1,v1,f2,v2) ( \
  (R_DMA_CH6_CLR_INTR__clr_eop__##f1##__MASK & REG__##v1) | \
  (R_DMA_CH6_CLR_INTR__clr_descr__##f2##__MASK & REG__##v2) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH6_CLR_INTR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH6_CLR_INTR.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH6_CLR_INTR(f1,v1,f2,v2) ( \
  (R_DMA_CH6_CLR_INTR__clr_eop__##f1##__VAL(R_DMA_CH6_CLR_INTR_, clr_eop_, v1) << R_DMA_CH6_CLR_INTR__clr_eop__BITNR) | \
  (R_DMA_CH6_CLR_INTR__clr_descr__##f2##__VAL(R_DMA_CH6_CLR_INTR_, clr_descr_, v2) << R_DMA_CH6_CLR_INTR__clr_descr__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH6_CLR_INTR_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH6_CLR_INTR.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH6_CLR_INTR_(f1_,v1,f2_,v2) ( \
  (R_DMA_CH6_CLR_INTR__clr_eop__##f1_##_VAL(R_DMA_CH6_CLR_INTR_, clr_eop_, v1) << R_DMA_CH6_CLR_INTR__clr_eop__BITNR) | \
  (R_DMA_CH6_CLR_INTR__clr_descr__##f2_##_VAL(R_DMA_CH6_CLR_INTR_, clr_descr_, v2) << R_DMA_CH6_CLR_INTR__clr_descr__BITNR) \
)

#endif

/*
 *  R_DMA_CH6_CMD
 *  - type:  RW
 *  - addr:  0xb00001e8
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH6_CMD
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH6_CMD.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH6_CMD. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH6_CMD(f1,v1) ( \
  R_DMA_CH6_CMD__WRITE(R_DMA_CH6_CMD__ADDR, ( \
    REG_VAL__R_DMA_CH6_CMD_(f1##_,v1) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH6_CMD
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH6_CMD(f1,v1) ( \
  (R_DMA_CH6_CMD__cmd__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH6_CMD
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH6_CMD.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH6_CMD(f1,v1) ( \
  (R_DMA_CH6_CMD__cmd__##f1##__VAL(R_DMA_CH6_CMD_, cmd_, v1) << R_DMA_CH6_CMD__cmd__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH6_CMD_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH6_CMD.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH6_CMD_(f1_,v1) ( \
  (R_DMA_CH6_CMD__cmd__##f1_##_VAL(R_DMA_CH6_CMD_, cmd_, v1) << R_DMA_CH6_CMD__cmd__BITNR) \
)

#endif

/*
 *  R_DMA_CH6_DESCR
 *  - type:  RW
 *  - addr:  0xb000016c
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH6_DESCR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH6_DESCR.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH6_DESCR. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH6_DESCR(f1,v1) ( \
  R_DMA_CH6_DESCR__WRITE(R_DMA_CH6_DESCR__ADDR, ( \
    REG_VAL__R_DMA_CH6_DESCR_(f1##_,v1) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH6_DESCR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH6_DESCR(f1,v1) ( \
  (R_DMA_CH6_DESCR__descr__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH6_DESCR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH6_DESCR.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH6_DESCR(f1,v1) ( \
  (R_DMA_CH6_DESCR__descr__##f1##__VAL(R_DMA_CH6_DESCR_, descr_, v1) << R_DMA_CH6_DESCR__descr__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH6_DESCR_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH6_DESCR.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH6_DESCR_(f1_,v1) ( \
  (R_DMA_CH6_DESCR__descr__##f1_##_VAL(R_DMA_CH6_DESCR_, descr_, v1) << R_DMA_CH6_DESCR__descr__BITNR) \
)

#endif

/*
 *  R_DMA_CH6_FIRST
 *  - type:  RW
 *  - addr:  0xb00001b8
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH6_FIRST
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH6_FIRST.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH6_FIRST. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH6_FIRST(f1,v1) ( \
  R_DMA_CH6_FIRST__WRITE(R_DMA_CH6_FIRST__ADDR, ( \
    REG_VAL__R_DMA_CH6_FIRST_(f1##_,v1) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH6_FIRST
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH6_FIRST(f1,v1) ( \
  (R_DMA_CH6_FIRST__first__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH6_FIRST
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH6_FIRST.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH6_FIRST(f1,v1) ( \
  (R_DMA_CH6_FIRST__first__##f1##__VAL(R_DMA_CH6_FIRST_, first_, v1) << R_DMA_CH6_FIRST__first__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH6_FIRST_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH6_FIRST.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH6_FIRST_(f1_,v1) ( \
  (R_DMA_CH6_FIRST__first__##f1_##_VAL(R_DMA_CH6_FIRST_, first_, v1) << R_DMA_CH6_FIRST__first__BITNR) \
)

#endif

/*
 *  R_DMA_CH6_HWSW
 *  - type:  RW
 *  - addr:  0xb0000160
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH6_HWSW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH6_HWSW.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH6_HWSW. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH6_HWSW(f1,v1,f2,v2) ( \
  R_DMA_CH6_HWSW__WRITE(R_DMA_CH6_HWSW__ADDR, ( \
    REG_VAL__R_DMA_CH6_HWSW_(f1##_,v1,f2##_,v2) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH6_HWSW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH6_HWSW(f1,v1,f2,v2) ( \
  (R_DMA_CH6_HWSW__hw__##f1##__MASK & REG__##v1) | \
  (R_DMA_CH6_HWSW__sw__##f2##__MASK & REG__##v2) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH6_HWSW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH6_HWSW.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH6_HWSW(f1,v1,f2,v2) ( \
  (R_DMA_CH6_HWSW__hw__##f1##__VAL(R_DMA_CH6_HWSW_, hw_, v1) << R_DMA_CH6_HWSW__hw__BITNR) | \
  (R_DMA_CH6_HWSW__sw__##f2##__VAL(R_DMA_CH6_HWSW_, sw_, v2) << R_DMA_CH6_HWSW__sw__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH6_HWSW_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH6_HWSW.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH6_HWSW_(f1_,v1,f2_,v2) ( \
  (R_DMA_CH6_HWSW__hw__##f1_##_VAL(R_DMA_CH6_HWSW_, hw_, v1) << R_DMA_CH6_HWSW__hw__BITNR) | \
  (R_DMA_CH6_HWSW__sw__##f2_##_VAL(R_DMA_CH6_HWSW_, sw_, v2) << R_DMA_CH6_HWSW__sw__BITNR) \
)

#endif

/*
 *  R_DMA_CH6_NEXT
 *  - type:  RW
 *  - addr:  0xb0000164
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH6_NEXT
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH6_NEXT.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH6_NEXT. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH6_NEXT(f1,v1) ( \
  R_DMA_CH6_NEXT__WRITE(R_DMA_CH6_NEXT__ADDR, ( \
    REG_VAL__R_DMA_CH6_NEXT_(f1##_,v1) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH6_NEXT
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH6_NEXT(f1,v1) ( \
  (R_DMA_CH6_NEXT__next__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH6_NEXT
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH6_NEXT.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH6_NEXT(f1,v1) ( \
  (R_DMA_CH6_NEXT__next__##f1##__VAL(R_DMA_CH6_NEXT_, next_, v1) << R_DMA_CH6_NEXT__next__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH6_NEXT_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH6_NEXT.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH6_NEXT_(f1_,v1) ( \
  (R_DMA_CH6_NEXT__next__##f1_##_VAL(R_DMA_CH6_NEXT_, next_, v1) << R_DMA_CH6_NEXT__next__BITNR) \
)

#endif

/*
 *  R_DMA_CH6_STATUS
 *  - type:  RO
 *  - addr:  0xb00001ea
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/* No REG_SET__register-name for read only registers. */

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH6_STATUS
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH6_STATUS(f1,v1) ( \
  (R_DMA_CH6_STATUS__avail__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH6_STATUS
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH6_STATUS.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH6_STATUS(f1,v1) ( \
  (R_DMA_CH6_STATUS__avail__##f1##__VAL(R_DMA_CH6_STATUS_, avail_, v1) << R_DMA_CH6_STATUS__avail__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH6_STATUS_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH6_STATUS.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH6_STATUS_(f1_,v1) ( \
  (R_DMA_CH6_STATUS__avail__##f1_##_VAL(R_DMA_CH6_STATUS_, avail_, v1) << R_DMA_CH6_STATUS__avail__BITNR) \
)

#endif

/*
 *  R_DMA_CH7_BUF
 *  - type:  RW
 *  - addr:  0xb0000178
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH7_BUF
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH7_BUF.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH7_BUF. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH7_BUF(f1,v1) ( \
  R_DMA_CH7_BUF__WRITE(R_DMA_CH7_BUF__ADDR, ( \
    REG_VAL__R_DMA_CH7_BUF_(f1##_,v1) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH7_BUF
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH7_BUF(f1,v1) ( \
  (R_DMA_CH7_BUF__buf__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH7_BUF
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH7_BUF.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH7_BUF(f1,v1) ( \
  (R_DMA_CH7_BUF__buf__##f1##__VAL(R_DMA_CH7_BUF_, buf_, v1) << R_DMA_CH7_BUF__buf__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH7_BUF_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH7_BUF.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH7_BUF_(f1_,v1) ( \
  (R_DMA_CH7_BUF__buf__##f1_##_VAL(R_DMA_CH7_BUF_, buf_, v1) << R_DMA_CH7_BUF__buf__BITNR) \
)

#endif

/*
 *  R_DMA_CH7_CLR_INTR
 *  - type:  WO
 *  - addr:  0xb00001ed
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH7_CLR_INTR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH7_CLR_INTR.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH7_CLR_INTR. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH7_CLR_INTR(f1,v1,f2,v2) ( \
  *R_DMA_CH7_CLR_INTR__SADDR = ( \
    REG_INITIATED(R_DMA_CH7_CLR_INTR_) \
    REG_VAL__R_DMA_CH7_CLR_INTR_(f1##_,v1,f2##_,v2) \
  ), \
  R_DMA_CH7_CLR_INTR__WRITE(R_DMA_CH7_CLR_INTR__ADDR, *R_DMA_CH7_CLR_INTR__SADDR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH7_CLR_INTR__SHADOW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH7_CLR_INTR.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in the 
*#               shadow register for R_DMA_CH7_CLR_INTR. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH7_CLR_INTR__SHADOW(f1,v1,f2,v2) ( \
  *R_DMA_CH7_CLR_INTR__SADDR = ( \
    REG_INITIATED(R_DMA_CH7_CLR_INTR_) \
    REG_VAL__R_DMA_CH7_CLR_INTR_(f1##_,v1,f2##_,v2) \
  ) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH7_CLR_INTR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH7_CLR_INTR(f1,v1,f2,v2) ( \
  (R_DMA_CH7_CLR_INTR__clr_eop__##f1##__MASK & REG__##v1) | \
  (R_DMA_CH7_CLR_INTR__clr_descr__##f2##__MASK & REG__##v2) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH7_CLR_INTR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH7_CLR_INTR.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH7_CLR_INTR(f1,v1,f2,v2) ( \
  (R_DMA_CH7_CLR_INTR__clr_eop__##f1##__VAL(R_DMA_CH7_CLR_INTR_, clr_eop_, v1) << R_DMA_CH7_CLR_INTR__clr_eop__BITNR) | \
  (R_DMA_CH7_CLR_INTR__clr_descr__##f2##__VAL(R_DMA_CH7_CLR_INTR_, clr_descr_, v2) << R_DMA_CH7_CLR_INTR__clr_descr__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH7_CLR_INTR_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH7_CLR_INTR.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH7_CLR_INTR_(f1_,v1,f2_,v2) ( \
  (R_DMA_CH7_CLR_INTR__clr_eop__##f1_##_VAL(R_DMA_CH7_CLR_INTR_, clr_eop_, v1) << R_DMA_CH7_CLR_INTR__clr_eop__BITNR) | \
  (R_DMA_CH7_CLR_INTR__clr_descr__##f2_##_VAL(R_DMA_CH7_CLR_INTR_, clr_descr_, v2) << R_DMA_CH7_CLR_INTR__clr_descr__BITNR) \
)

#endif

/*
 *  R_DMA_CH7_CMD
 *  - type:  RW
 *  - addr:  0xb00001ec
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH7_CMD
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH7_CMD.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH7_CMD. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH7_CMD(f1,v1) ( \
  R_DMA_CH7_CMD__WRITE(R_DMA_CH7_CMD__ADDR, ( \
    REG_VAL__R_DMA_CH7_CMD_(f1##_,v1) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH7_CMD
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH7_CMD(f1,v1) ( \
  (R_DMA_CH7_CMD__cmd__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH7_CMD
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH7_CMD.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH7_CMD(f1,v1) ( \
  (R_DMA_CH7_CMD__cmd__##f1##__VAL(R_DMA_CH7_CMD_, cmd_, v1) << R_DMA_CH7_CMD__cmd__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH7_CMD_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH7_CMD.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH7_CMD_(f1_,v1) ( \
  (R_DMA_CH7_CMD__cmd__##f1_##_VAL(R_DMA_CH7_CMD_, cmd_, v1) << R_DMA_CH7_CMD__cmd__BITNR) \
)

#endif

/*
 *  R_DMA_CH7_DESCR
 *  - type:  RW
 *  - addr:  0xb000017c
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH7_DESCR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH7_DESCR.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH7_DESCR. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH7_DESCR(f1,v1) ( \
  R_DMA_CH7_DESCR__WRITE(R_DMA_CH7_DESCR__ADDR, ( \
    REG_VAL__R_DMA_CH7_DESCR_(f1##_,v1) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH7_DESCR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH7_DESCR(f1,v1) ( \
  (R_DMA_CH7_DESCR__descr__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH7_DESCR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH7_DESCR.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH7_DESCR(f1,v1) ( \
  (R_DMA_CH7_DESCR__descr__##f1##__VAL(R_DMA_CH7_DESCR_, descr_, v1) << R_DMA_CH7_DESCR__descr__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH7_DESCR_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH7_DESCR.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH7_DESCR_(f1_,v1) ( \
  (R_DMA_CH7_DESCR__descr__##f1_##_VAL(R_DMA_CH7_DESCR_, descr_, v1) << R_DMA_CH7_DESCR__descr__BITNR) \
)

#endif

/*
 *  R_DMA_CH7_FIRST
 *  - type:  RW
 *  - addr:  0xb00001bc
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH7_FIRST
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH7_FIRST.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH7_FIRST. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH7_FIRST(f1,v1) ( \
  R_DMA_CH7_FIRST__WRITE(R_DMA_CH7_FIRST__ADDR, ( \
    REG_VAL__R_DMA_CH7_FIRST_(f1##_,v1) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH7_FIRST
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH7_FIRST(f1,v1) ( \
  (R_DMA_CH7_FIRST__first__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH7_FIRST
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH7_FIRST.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH7_FIRST(f1,v1) ( \
  (R_DMA_CH7_FIRST__first__##f1##__VAL(R_DMA_CH7_FIRST_, first_, v1) << R_DMA_CH7_FIRST__first__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH7_FIRST_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH7_FIRST.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH7_FIRST_(f1_,v1) ( \
  (R_DMA_CH7_FIRST__first__##f1_##_VAL(R_DMA_CH7_FIRST_, first_, v1) << R_DMA_CH7_FIRST__first__BITNR) \
)

#endif

/*
 *  R_DMA_CH7_HWSW
 *  - type:  RW
 *  - addr:  0xb0000170
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH7_HWSW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH7_HWSW.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH7_HWSW. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH7_HWSW(f1,v1,f2,v2) ( \
  R_DMA_CH7_HWSW__WRITE(R_DMA_CH7_HWSW__ADDR, ( \
    REG_VAL__R_DMA_CH7_HWSW_(f1##_,v1,f2##_,v2) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH7_HWSW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH7_HWSW(f1,v1,f2,v2) ( \
  (R_DMA_CH7_HWSW__hw__##f1##__MASK & REG__##v1) | \
  (R_DMA_CH7_HWSW__sw__##f2##__MASK & REG__##v2) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH7_HWSW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH7_HWSW.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH7_HWSW(f1,v1,f2,v2) ( \
  (R_DMA_CH7_HWSW__hw__##f1##__VAL(R_DMA_CH7_HWSW_, hw_, v1) << R_DMA_CH7_HWSW__hw__BITNR) | \
  (R_DMA_CH7_HWSW__sw__##f2##__VAL(R_DMA_CH7_HWSW_, sw_, v2) << R_DMA_CH7_HWSW__sw__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH7_HWSW_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH7_HWSW.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH7_HWSW_(f1_,v1,f2_,v2) ( \
  (R_DMA_CH7_HWSW__hw__##f1_##_VAL(R_DMA_CH7_HWSW_, hw_, v1) << R_DMA_CH7_HWSW__hw__BITNR) | \
  (R_DMA_CH7_HWSW__sw__##f2_##_VAL(R_DMA_CH7_HWSW_, sw_, v2) << R_DMA_CH7_HWSW__sw__BITNR) \
)

#endif

/*
 *  R_DMA_CH7_NEXT
 *  - type:  RW
 *  - addr:  0xb0000174
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH7_NEXT
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH7_NEXT.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH7_NEXT. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH7_NEXT(f1,v1) ( \
  R_DMA_CH7_NEXT__WRITE(R_DMA_CH7_NEXT__ADDR, ( \
    REG_VAL__R_DMA_CH7_NEXT_(f1##_,v1) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH7_NEXT
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH7_NEXT(f1,v1) ( \
  (R_DMA_CH7_NEXT__next__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH7_NEXT
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH7_NEXT.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH7_NEXT(f1,v1) ( \
  (R_DMA_CH7_NEXT__next__##f1##__VAL(R_DMA_CH7_NEXT_, next_, v1) << R_DMA_CH7_NEXT__next__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH7_NEXT_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH7_NEXT.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH7_NEXT_(f1_,v1) ( \
  (R_DMA_CH7_NEXT__next__##f1_##_VAL(R_DMA_CH7_NEXT_, next_, v1) << R_DMA_CH7_NEXT__next__BITNR) \
)

#endif

/*
 *  R_DMA_CH7_STATUS
 *  - type:  RO
 *  - addr:  0xb00001ee
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/* No REG_SET__register-name for read only registers. */

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH7_STATUS
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH7_STATUS(f1,v1) ( \
  (R_DMA_CH7_STATUS__avail__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH7_STATUS
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH7_STATUS.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH7_STATUS(f1,v1) ( \
  (R_DMA_CH7_STATUS__avail__##f1##__VAL(R_DMA_CH7_STATUS_, avail_, v1) << R_DMA_CH7_STATUS__avail__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH7_STATUS_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH7_STATUS.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH7_STATUS_(f1_,v1) ( \
  (R_DMA_CH7_STATUS__avail__##f1_##_VAL(R_DMA_CH7_STATUS_, avail_, v1) << R_DMA_CH7_STATUS__avail__BITNR) \
)

#endif

/*
 *  R_DMA_CH8_BUF
 *  - type:  RW
 *  - addr:  0xb0000188
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH8_BUF
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH8_BUF.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH8_BUF. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH8_BUF(f1,v1) ( \
  R_DMA_CH8_BUF__WRITE(R_DMA_CH8_BUF__ADDR, ( \
    REG_VAL__R_DMA_CH8_BUF_(f1##_,v1) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH8_BUF
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH8_BUF(f1,v1) ( \
  (R_DMA_CH8_BUF__buf__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH8_BUF
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH8_BUF.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH8_BUF(f1,v1) ( \
  (R_DMA_CH8_BUF__buf__##f1##__VAL(R_DMA_CH8_BUF_, buf_, v1) << R_DMA_CH8_BUF__buf__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH8_BUF_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH8_BUF.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH8_BUF_(f1_,v1) ( \
  (R_DMA_CH8_BUF__buf__##f1_##_VAL(R_DMA_CH8_BUF_, buf_, v1) << R_DMA_CH8_BUF__buf__BITNR) \
)

#endif

/*
 *  R_DMA_CH8_CLR_INTR
 *  - type:  WO
 *  - addr:  0xb00001f1
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH8_CLR_INTR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH8_CLR_INTR.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH8_CLR_INTR. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH8_CLR_INTR(f1,v1,f2,v2) ( \
  *R_DMA_CH8_CLR_INTR__SADDR = ( \
    REG_INITIATED(R_DMA_CH8_CLR_INTR_) \
    REG_VAL__R_DMA_CH8_CLR_INTR_(f1##_,v1,f2##_,v2) \
  ), \
  R_DMA_CH8_CLR_INTR__WRITE(R_DMA_CH8_CLR_INTR__ADDR, *R_DMA_CH8_CLR_INTR__SADDR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH8_CLR_INTR__SHADOW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH8_CLR_INTR.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in the 
*#               shadow register for R_DMA_CH8_CLR_INTR. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH8_CLR_INTR__SHADOW(f1,v1,f2,v2) ( \
  *R_DMA_CH8_CLR_INTR__SADDR = ( \
    REG_INITIATED(R_DMA_CH8_CLR_INTR_) \
    REG_VAL__R_DMA_CH8_CLR_INTR_(f1##_,v1,f2##_,v2) \
  ) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH8_CLR_INTR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH8_CLR_INTR(f1,v1,f2,v2) ( \
  (R_DMA_CH8_CLR_INTR__clr_eop__##f1##__MASK & REG__##v1) | \
  (R_DMA_CH8_CLR_INTR__clr_descr__##f2##__MASK & REG__##v2) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH8_CLR_INTR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH8_CLR_INTR.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH8_CLR_INTR(f1,v1,f2,v2) ( \
  (R_DMA_CH8_CLR_INTR__clr_eop__##f1##__VAL(R_DMA_CH8_CLR_INTR_, clr_eop_, v1) << R_DMA_CH8_CLR_INTR__clr_eop__BITNR) | \
  (R_DMA_CH8_CLR_INTR__clr_descr__##f2##__VAL(R_DMA_CH8_CLR_INTR_, clr_descr_, v2) << R_DMA_CH8_CLR_INTR__clr_descr__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH8_CLR_INTR_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH8_CLR_INTR.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH8_CLR_INTR_(f1_,v1,f2_,v2) ( \
  (R_DMA_CH8_CLR_INTR__clr_eop__##f1_##_VAL(R_DMA_CH8_CLR_INTR_, clr_eop_, v1) << R_DMA_CH8_CLR_INTR__clr_eop__BITNR) | \
  (R_DMA_CH8_CLR_INTR__clr_descr__##f2_##_VAL(R_DMA_CH8_CLR_INTR_, clr_descr_, v2) << R_DMA_CH8_CLR_INTR__clr_descr__BITNR) \
)

#endif

/*
 *  R_DMA_CH8_CMD
 *  - type:  RW
 *  - addr:  0xb00001f0
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH8_CMD
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH8_CMD.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH8_CMD. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH8_CMD(f1,v1) ( \
  R_DMA_CH8_CMD__WRITE(R_DMA_CH8_CMD__ADDR, ( \
    REG_VAL__R_DMA_CH8_CMD_(f1##_,v1) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH8_CMD
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH8_CMD(f1,v1) ( \
  (R_DMA_CH8_CMD__cmd__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH8_CMD
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH8_CMD.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH8_CMD(f1,v1) ( \
  (R_DMA_CH8_CMD__cmd__##f1##__VAL(R_DMA_CH8_CMD_, cmd_, v1) << R_DMA_CH8_CMD__cmd__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH8_CMD_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH8_CMD.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH8_CMD_(f1_,v1) ( \
  (R_DMA_CH8_CMD__cmd__##f1_##_VAL(R_DMA_CH8_CMD_, cmd_, v1) << R_DMA_CH8_CMD__cmd__BITNR) \
)

#endif

/*
 *  R_DMA_CH8_DESCR
 *  - type:  RW
 *  - addr:  0xb000018c
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH8_DESCR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH8_DESCR.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH8_DESCR. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH8_DESCR(f1,v1) ( \
  R_DMA_CH8_DESCR__WRITE(R_DMA_CH8_DESCR__ADDR, ( \
    REG_VAL__R_DMA_CH8_DESCR_(f1##_,v1) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH8_DESCR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH8_DESCR(f1,v1) ( \
  (R_DMA_CH8_DESCR__descr__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH8_DESCR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH8_DESCR.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH8_DESCR(f1,v1) ( \
  (R_DMA_CH8_DESCR__descr__##f1##__VAL(R_DMA_CH8_DESCR_, descr_, v1) << R_DMA_CH8_DESCR__descr__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH8_DESCR_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH8_DESCR.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH8_DESCR_(f1_,v1) ( \
  (R_DMA_CH8_DESCR__descr__##f1_##_VAL(R_DMA_CH8_DESCR_, descr_, v1) << R_DMA_CH8_DESCR__descr__BITNR) \
)

#endif

/*
 *  R_DMA_CH8_FIRST
 *  - type:  RW
 *  - addr:  0xb00001c0
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH8_FIRST
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH8_FIRST.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH8_FIRST. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH8_FIRST(f1,v1) ( \
  R_DMA_CH8_FIRST__WRITE(R_DMA_CH8_FIRST__ADDR, ( \
    REG_VAL__R_DMA_CH8_FIRST_(f1##_,v1) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH8_FIRST
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH8_FIRST(f1,v1) ( \
  (R_DMA_CH8_FIRST__first__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH8_FIRST
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH8_FIRST.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH8_FIRST(f1,v1) ( \
  (R_DMA_CH8_FIRST__first__##f1##__VAL(R_DMA_CH8_FIRST_, first_, v1) << R_DMA_CH8_FIRST__first__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH8_FIRST_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH8_FIRST.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH8_FIRST_(f1_,v1) ( \
  (R_DMA_CH8_FIRST__first__##f1_##_VAL(R_DMA_CH8_FIRST_, first_, v1) << R_DMA_CH8_FIRST__first__BITNR) \
)

#endif

/*
 *  R_DMA_CH8_HWSW
 *  - type:  RW
 *  - addr:  0xb0000180
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH8_HWSW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH8_HWSW.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH8_HWSW. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH8_HWSW(f1,v1,f2,v2) ( \
  R_DMA_CH8_HWSW__WRITE(R_DMA_CH8_HWSW__ADDR, ( \
    REG_VAL__R_DMA_CH8_HWSW_(f1##_,v1,f2##_,v2) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH8_HWSW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH8_HWSW(f1,v1,f2,v2) ( \
  (R_DMA_CH8_HWSW__hw__##f1##__MASK & REG__##v1) | \
  (R_DMA_CH8_HWSW__sw__##f2##__MASK & REG__##v2) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH8_HWSW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH8_HWSW.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH8_HWSW(f1,v1,f2,v2) ( \
  (R_DMA_CH8_HWSW__hw__##f1##__VAL(R_DMA_CH8_HWSW_, hw_, v1) << R_DMA_CH8_HWSW__hw__BITNR) | \
  (R_DMA_CH8_HWSW__sw__##f2##__VAL(R_DMA_CH8_HWSW_, sw_, v2) << R_DMA_CH8_HWSW__sw__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH8_HWSW_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH8_HWSW.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH8_HWSW_(f1_,v1,f2_,v2) ( \
  (R_DMA_CH8_HWSW__hw__##f1_##_VAL(R_DMA_CH8_HWSW_, hw_, v1) << R_DMA_CH8_HWSW__hw__BITNR) | \
  (R_DMA_CH8_HWSW__sw__##f2_##_VAL(R_DMA_CH8_HWSW_, sw_, v2) << R_DMA_CH8_HWSW__sw__BITNR) \
)

#endif

/*
 *  R_DMA_CH8_NEP
 *  - type:  RW
 *  - addr:  0xb00001c0
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH8_NEP
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH8_NEP.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH8_NEP. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH8_NEP(f1,v1) ( \
  R_DMA_CH8_NEP__WRITE(R_DMA_CH8_NEP__ADDR, ( \
    REG_VAL__R_DMA_CH8_NEP_(f1##_,v1) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH8_NEP
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH8_NEP(f1,v1) ( \
  (R_DMA_CH8_NEP__nep__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH8_NEP
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH8_NEP.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH8_NEP(f1,v1) ( \
  (R_DMA_CH8_NEP__nep__##f1##__VAL(R_DMA_CH8_NEP_, nep_, v1) << R_DMA_CH8_NEP__nep__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH8_NEP_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH8_NEP.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH8_NEP_(f1_,v1) ( \
  (R_DMA_CH8_NEP__nep__##f1_##_VAL(R_DMA_CH8_NEP_, nep_, v1) << R_DMA_CH8_NEP__nep__BITNR) \
)

#endif

/*
 *  R_DMA_CH8_NEXT
 *  - type:  RW
 *  - addr:  0xb0000184
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH8_NEXT
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH8_NEXT.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH8_NEXT. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH8_NEXT(f1,v1) ( \
  R_DMA_CH8_NEXT__WRITE(R_DMA_CH8_NEXT__ADDR, ( \
    REG_VAL__R_DMA_CH8_NEXT_(f1##_,v1) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH8_NEXT
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH8_NEXT(f1,v1) ( \
  (R_DMA_CH8_NEXT__next__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH8_NEXT
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH8_NEXT.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH8_NEXT(f1,v1) ( \
  (R_DMA_CH8_NEXT__next__##f1##__VAL(R_DMA_CH8_NEXT_, next_, v1) << R_DMA_CH8_NEXT__next__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH8_NEXT_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH8_NEXT.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH8_NEXT_(f1_,v1) ( \
  (R_DMA_CH8_NEXT__next__##f1_##_VAL(R_DMA_CH8_NEXT_, next_, v1) << R_DMA_CH8_NEXT__next__BITNR) \
)

#endif

/*
 *  R_DMA_CH8_STATUS
 *  - type:  RO
 *  - addr:  0xb00001f2
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/* No REG_SET__register-name for read only registers. */

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH8_STATUS
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH8_STATUS(f1,v1) ( \
  (R_DMA_CH8_STATUS__avail__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH8_STATUS
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH8_STATUS.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH8_STATUS(f1,v1) ( \
  (R_DMA_CH8_STATUS__avail__##f1##__VAL(R_DMA_CH8_STATUS_, avail_, v1) << R_DMA_CH8_STATUS__avail__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH8_STATUS_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH8_STATUS.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH8_STATUS_(f1_,v1) ( \
  (R_DMA_CH8_STATUS__avail__##f1_##_VAL(R_DMA_CH8_STATUS_, avail_, v1) << R_DMA_CH8_STATUS__avail__BITNR) \
)

#endif

/*
 *  R_DMA_CH8_SUB
 *  - type:  RW
 *  - addr:  0xb000018c
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH8_SUB
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH8_SUB.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH8_SUB. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH8_SUB(f1,v1) ( \
  R_DMA_CH8_SUB__WRITE(R_DMA_CH8_SUB__ADDR, ( \
    REG_VAL__R_DMA_CH8_SUB_(f1##_,v1) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH8_SUB
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH8_SUB(f1,v1) ( \
  (R_DMA_CH8_SUB__sub__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH8_SUB
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH8_SUB.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH8_SUB(f1,v1) ( \
  (R_DMA_CH8_SUB__sub__##f1##__VAL(R_DMA_CH8_SUB_, sub_, v1) << R_DMA_CH8_SUB__sub__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH8_SUB_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH8_SUB.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH8_SUB_(f1_,v1) ( \
  (R_DMA_CH8_SUB__sub__##f1_##_VAL(R_DMA_CH8_SUB_, sub_, v1) << R_DMA_CH8_SUB__sub__BITNR) \
)

#endif

/*
 *  R_DMA_CH8_SUB0_CLR_INTR
 *  - type:  WO
 *  - addr:  0xb00001e3
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH8_SUB0_CLR_INTR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH8_SUB0_CLR_INTR.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH8_SUB0_CLR_INTR. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH8_SUB0_CLR_INTR(f1,v1) ( \
  *R_DMA_CH8_SUB0_CLR_INTR__SADDR = ( \
    REG_INITIATED(R_DMA_CH8_SUB0_CLR_INTR_) \
    REG_VAL__R_DMA_CH8_SUB0_CLR_INTR_(f1##_,v1) \
  ), \
  R_DMA_CH8_SUB0_CLR_INTR__WRITE(R_DMA_CH8_SUB0_CLR_INTR__ADDR, *R_DMA_CH8_SUB0_CLR_INTR__SADDR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH8_SUB0_CLR_INTR__SHADOW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH8_SUB0_CLR_INTR.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in the 
*#               shadow register for R_DMA_CH8_SUB0_CLR_INTR. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH8_SUB0_CLR_INTR__SHADOW(f1,v1) ( \
  *R_DMA_CH8_SUB0_CLR_INTR__SADDR = ( \
    REG_INITIATED(R_DMA_CH8_SUB0_CLR_INTR_) \
    REG_VAL__R_DMA_CH8_SUB0_CLR_INTR_(f1##_,v1) \
  ) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH8_SUB0_CLR_INTR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH8_SUB0_CLR_INTR(f1,v1) ( \
  (R_DMA_CH8_SUB0_CLR_INTR__clr_descr__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH8_SUB0_CLR_INTR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH8_SUB0_CLR_INTR.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH8_SUB0_CLR_INTR(f1,v1) ( \
  (R_DMA_CH8_SUB0_CLR_INTR__clr_descr__##f1##__VAL(R_DMA_CH8_SUB0_CLR_INTR_, clr_descr_, v1) << R_DMA_CH8_SUB0_CLR_INTR__clr_descr__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH8_SUB0_CLR_INTR_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH8_SUB0_CLR_INTR.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH8_SUB0_CLR_INTR_(f1_,v1) ( \
  (R_DMA_CH8_SUB0_CLR_INTR__clr_descr__##f1_##_VAL(R_DMA_CH8_SUB0_CLR_INTR_, clr_descr_, v1) << R_DMA_CH8_SUB0_CLR_INTR__clr_descr__BITNR) \
)

#endif

/*
 *  R_DMA_CH8_SUB0_CMD
 *  - type:  RW
 *  - addr:  0xb00001d3
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH8_SUB0_CMD
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH8_SUB0_CMD.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH8_SUB0_CMD. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH8_SUB0_CMD(f1,v1) ( \
  R_DMA_CH8_SUB0_CMD__WRITE(R_DMA_CH8_SUB0_CMD__ADDR, ( \
    REG_VAL__R_DMA_CH8_SUB0_CMD_(f1##_,v1) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH8_SUB0_CMD
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH8_SUB0_CMD(f1,v1) ( \
  (R_DMA_CH8_SUB0_CMD__cmd__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH8_SUB0_CMD
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH8_SUB0_CMD.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH8_SUB0_CMD(f1,v1) ( \
  (R_DMA_CH8_SUB0_CMD__cmd__##f1##__VAL(R_DMA_CH8_SUB0_CMD_, cmd_, v1) << R_DMA_CH8_SUB0_CMD__cmd__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH8_SUB0_CMD_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH8_SUB0_CMD.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH8_SUB0_CMD_(f1_,v1) ( \
  (R_DMA_CH8_SUB0_CMD__cmd__##f1_##_VAL(R_DMA_CH8_SUB0_CMD_, cmd_, v1) << R_DMA_CH8_SUB0_CMD__cmd__BITNR) \
)

#endif

/*
 *  R_DMA_CH8_SUB0_EP
 *  - type:  RW
 *  - addr:  0xb00001c8
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH8_SUB0_EP
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH8_SUB0_EP.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH8_SUB0_EP. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH8_SUB0_EP(f1,v1) ( \
  R_DMA_CH8_SUB0_EP__WRITE(R_DMA_CH8_SUB0_EP__ADDR, ( \
    REG_VAL__R_DMA_CH8_SUB0_EP_(f1##_,v1) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH8_SUB0_EP
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH8_SUB0_EP(f1,v1) ( \
  (R_DMA_CH8_SUB0_EP__ep__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH8_SUB0_EP
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH8_SUB0_EP.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH8_SUB0_EP(f1,v1) ( \
  (R_DMA_CH8_SUB0_EP__ep__##f1##__VAL(R_DMA_CH8_SUB0_EP_, ep_, v1) << R_DMA_CH8_SUB0_EP__ep__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH8_SUB0_EP_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH8_SUB0_EP.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH8_SUB0_EP_(f1_,v1) ( \
  (R_DMA_CH8_SUB0_EP__ep__##f1_##_VAL(R_DMA_CH8_SUB0_EP_, ep_, v1) << R_DMA_CH8_SUB0_EP__ep__BITNR) \
)

#endif

/*
 *  R_DMA_CH8_SUB1_CLR_INTR
 *  - type:  WO
 *  - addr:  0xb00001e7
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH8_SUB1_CLR_INTR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH8_SUB1_CLR_INTR.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH8_SUB1_CLR_INTR. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH8_SUB1_CLR_INTR(f1,v1) ( \
  *R_DMA_CH8_SUB1_CLR_INTR__SADDR = ( \
    REG_INITIATED(R_DMA_CH8_SUB1_CLR_INTR_) \
    REG_VAL__R_DMA_CH8_SUB1_CLR_INTR_(f1##_,v1) \
  ), \
  R_DMA_CH8_SUB1_CLR_INTR__WRITE(R_DMA_CH8_SUB1_CLR_INTR__ADDR, *R_DMA_CH8_SUB1_CLR_INTR__SADDR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH8_SUB1_CLR_INTR__SHADOW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH8_SUB1_CLR_INTR.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in the 
*#               shadow register for R_DMA_CH8_SUB1_CLR_INTR. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH8_SUB1_CLR_INTR__SHADOW(f1,v1) ( \
  *R_DMA_CH8_SUB1_CLR_INTR__SADDR = ( \
    REG_INITIATED(R_DMA_CH8_SUB1_CLR_INTR_) \
    REG_VAL__R_DMA_CH8_SUB1_CLR_INTR_(f1##_,v1) \
  ) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH8_SUB1_CLR_INTR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH8_SUB1_CLR_INTR(f1,v1) ( \
  (R_DMA_CH8_SUB1_CLR_INTR__clr_descr__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH8_SUB1_CLR_INTR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH8_SUB1_CLR_INTR.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH8_SUB1_CLR_INTR(f1,v1) ( \
  (R_DMA_CH8_SUB1_CLR_INTR__clr_descr__##f1##__VAL(R_DMA_CH8_SUB1_CLR_INTR_, clr_descr_, v1) << R_DMA_CH8_SUB1_CLR_INTR__clr_descr__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH8_SUB1_CLR_INTR_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH8_SUB1_CLR_INTR.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH8_SUB1_CLR_INTR_(f1_,v1) ( \
  (R_DMA_CH8_SUB1_CLR_INTR__clr_descr__##f1_##_VAL(R_DMA_CH8_SUB1_CLR_INTR_, clr_descr_, v1) << R_DMA_CH8_SUB1_CLR_INTR__clr_descr__BITNR) \
)

#endif

/*
 *  R_DMA_CH8_SUB1_CMD
 *  - type:  RW
 *  - addr:  0xb00001d7
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH8_SUB1_CMD
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH8_SUB1_CMD.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH8_SUB1_CMD. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH8_SUB1_CMD(f1,v1) ( \
  R_DMA_CH8_SUB1_CMD__WRITE(R_DMA_CH8_SUB1_CMD__ADDR, ( \
    REG_VAL__R_DMA_CH8_SUB1_CMD_(f1##_,v1) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH8_SUB1_CMD
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH8_SUB1_CMD(f1,v1) ( \
  (R_DMA_CH8_SUB1_CMD__cmd__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH8_SUB1_CMD
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH8_SUB1_CMD.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH8_SUB1_CMD(f1,v1) ( \
  (R_DMA_CH8_SUB1_CMD__cmd__##f1##__VAL(R_DMA_CH8_SUB1_CMD_, cmd_, v1) << R_DMA_CH8_SUB1_CMD__cmd__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH8_SUB1_CMD_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH8_SUB1_CMD.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH8_SUB1_CMD_(f1_,v1) ( \
  (R_DMA_CH8_SUB1_CMD__cmd__##f1_##_VAL(R_DMA_CH8_SUB1_CMD_, cmd_, v1) << R_DMA_CH8_SUB1_CMD__cmd__BITNR) \
)

#endif

/*
 *  R_DMA_CH8_SUB1_EP
 *  - type:  RW
 *  - addr:  0xb00001cc
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH8_SUB1_EP
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH8_SUB1_EP.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH8_SUB1_EP. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH8_SUB1_EP(f1,v1) ( \
  R_DMA_CH8_SUB1_EP__WRITE(R_DMA_CH8_SUB1_EP__ADDR, ( \
    REG_VAL__R_DMA_CH8_SUB1_EP_(f1##_,v1) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH8_SUB1_EP
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH8_SUB1_EP(f1,v1) ( \
  (R_DMA_CH8_SUB1_EP__ep__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH8_SUB1_EP
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH8_SUB1_EP.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH8_SUB1_EP(f1,v1) ( \
  (R_DMA_CH8_SUB1_EP__ep__##f1##__VAL(R_DMA_CH8_SUB1_EP_, ep_, v1) << R_DMA_CH8_SUB1_EP__ep__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH8_SUB1_EP_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH8_SUB1_EP.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH8_SUB1_EP_(f1_,v1) ( \
  (R_DMA_CH8_SUB1_EP__ep__##f1_##_VAL(R_DMA_CH8_SUB1_EP_, ep_, v1) << R_DMA_CH8_SUB1_EP__ep__BITNR) \
)

#endif

/*
 *  R_DMA_CH8_SUB2_CLR_INTR
 *  - type:  WO
 *  - addr:  0xb00001eb
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH8_SUB2_CLR_INTR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH8_SUB2_CLR_INTR.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH8_SUB2_CLR_INTR. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH8_SUB2_CLR_INTR(f1,v1) ( \
  *R_DMA_CH8_SUB2_CLR_INTR__SADDR = ( \
    REG_INITIATED(R_DMA_CH8_SUB2_CLR_INTR_) \
    REG_VAL__R_DMA_CH8_SUB2_CLR_INTR_(f1##_,v1) \
  ), \
  R_DMA_CH8_SUB2_CLR_INTR__WRITE(R_DMA_CH8_SUB2_CLR_INTR__ADDR, *R_DMA_CH8_SUB2_CLR_INTR__SADDR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH8_SUB2_CLR_INTR__SHADOW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH8_SUB2_CLR_INTR.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in the 
*#               shadow register for R_DMA_CH8_SUB2_CLR_INTR. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH8_SUB2_CLR_INTR__SHADOW(f1,v1) ( \
  *R_DMA_CH8_SUB2_CLR_INTR__SADDR = ( \
    REG_INITIATED(R_DMA_CH8_SUB2_CLR_INTR_) \
    REG_VAL__R_DMA_CH8_SUB2_CLR_INTR_(f1##_,v1) \
  ) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH8_SUB2_CLR_INTR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH8_SUB2_CLR_INTR(f1,v1) ( \
  (R_DMA_CH8_SUB2_CLR_INTR__clr_descr__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH8_SUB2_CLR_INTR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH8_SUB2_CLR_INTR.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH8_SUB2_CLR_INTR(f1,v1) ( \
  (R_DMA_CH8_SUB2_CLR_INTR__clr_descr__##f1##__VAL(R_DMA_CH8_SUB2_CLR_INTR_, clr_descr_, v1) << R_DMA_CH8_SUB2_CLR_INTR__clr_descr__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH8_SUB2_CLR_INTR_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH8_SUB2_CLR_INTR.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH8_SUB2_CLR_INTR_(f1_,v1) ( \
  (R_DMA_CH8_SUB2_CLR_INTR__clr_descr__##f1_##_VAL(R_DMA_CH8_SUB2_CLR_INTR_, clr_descr_, v1) << R_DMA_CH8_SUB2_CLR_INTR__clr_descr__BITNR) \
)

#endif

/*
 *  R_DMA_CH8_SUB2_CMD
 *  - type:  RW
 *  - addr:  0xb00001db
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH8_SUB2_CMD
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH8_SUB2_CMD.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH8_SUB2_CMD. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH8_SUB2_CMD(f1,v1) ( \
  R_DMA_CH8_SUB2_CMD__WRITE(R_DMA_CH8_SUB2_CMD__ADDR, ( \
    REG_VAL__R_DMA_CH8_SUB2_CMD_(f1##_,v1) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH8_SUB2_CMD
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH8_SUB2_CMD(f1,v1) ( \
  (R_DMA_CH8_SUB2_CMD__cmd__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH8_SUB2_CMD
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH8_SUB2_CMD.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH8_SUB2_CMD(f1,v1) ( \
  (R_DMA_CH8_SUB2_CMD__cmd__##f1##__VAL(R_DMA_CH8_SUB2_CMD_, cmd_, v1) << R_DMA_CH8_SUB2_CMD__cmd__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH8_SUB2_CMD_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH8_SUB2_CMD.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH8_SUB2_CMD_(f1_,v1) ( \
  (R_DMA_CH8_SUB2_CMD__cmd__##f1_##_VAL(R_DMA_CH8_SUB2_CMD_, cmd_, v1) << R_DMA_CH8_SUB2_CMD__cmd__BITNR) \
)

#endif

/*
 *  R_DMA_CH8_SUB2_EP
 *  - type:  RW
 *  - addr:  0xb00001f8
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH8_SUB2_EP
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH8_SUB2_EP.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH8_SUB2_EP. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH8_SUB2_EP(f1,v1) ( \
  R_DMA_CH8_SUB2_EP__WRITE(R_DMA_CH8_SUB2_EP__ADDR, ( \
    REG_VAL__R_DMA_CH8_SUB2_EP_(f1##_,v1) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH8_SUB2_EP
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH8_SUB2_EP(f1,v1) ( \
  (R_DMA_CH8_SUB2_EP__ep__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH8_SUB2_EP
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH8_SUB2_EP.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH8_SUB2_EP(f1,v1) ( \
  (R_DMA_CH8_SUB2_EP__ep__##f1##__VAL(R_DMA_CH8_SUB2_EP_, ep_, v1) << R_DMA_CH8_SUB2_EP__ep__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH8_SUB2_EP_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH8_SUB2_EP.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH8_SUB2_EP_(f1_,v1) ( \
  (R_DMA_CH8_SUB2_EP__ep__##f1_##_VAL(R_DMA_CH8_SUB2_EP_, ep_, v1) << R_DMA_CH8_SUB2_EP__ep__BITNR) \
)

#endif

/*
 *  R_DMA_CH8_SUB3_CLR_INTR
 *  - type:  WO
 *  - addr:  0xb00001ef
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH8_SUB3_CLR_INTR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH8_SUB3_CLR_INTR.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH8_SUB3_CLR_INTR. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH8_SUB3_CLR_INTR(f1,v1) ( \
  *R_DMA_CH8_SUB3_CLR_INTR__SADDR = ( \
    REG_INITIATED(R_DMA_CH8_SUB3_CLR_INTR_) \
    REG_VAL__R_DMA_CH8_SUB3_CLR_INTR_(f1##_,v1) \
  ), \
  R_DMA_CH8_SUB3_CLR_INTR__WRITE(R_DMA_CH8_SUB3_CLR_INTR__ADDR, *R_DMA_CH8_SUB3_CLR_INTR__SADDR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH8_SUB3_CLR_INTR__SHADOW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH8_SUB3_CLR_INTR.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in the 
*#               shadow register for R_DMA_CH8_SUB3_CLR_INTR. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH8_SUB3_CLR_INTR__SHADOW(f1,v1) ( \
  *R_DMA_CH8_SUB3_CLR_INTR__SADDR = ( \
    REG_INITIATED(R_DMA_CH8_SUB3_CLR_INTR_) \
    REG_VAL__R_DMA_CH8_SUB3_CLR_INTR_(f1##_,v1) \
  ) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH8_SUB3_CLR_INTR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH8_SUB3_CLR_INTR(f1,v1) ( \
  (R_DMA_CH8_SUB3_CLR_INTR__clr_descr__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH8_SUB3_CLR_INTR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH8_SUB3_CLR_INTR.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH8_SUB3_CLR_INTR(f1,v1) ( \
  (R_DMA_CH8_SUB3_CLR_INTR__clr_descr__##f1##__VAL(R_DMA_CH8_SUB3_CLR_INTR_, clr_descr_, v1) << R_DMA_CH8_SUB3_CLR_INTR__clr_descr__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH8_SUB3_CLR_INTR_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH8_SUB3_CLR_INTR.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH8_SUB3_CLR_INTR_(f1_,v1) ( \
  (R_DMA_CH8_SUB3_CLR_INTR__clr_descr__##f1_##_VAL(R_DMA_CH8_SUB3_CLR_INTR_, clr_descr_, v1) << R_DMA_CH8_SUB3_CLR_INTR__clr_descr__BITNR) \
)

#endif

/*
 *  R_DMA_CH8_SUB3_CMD
 *  - type:  RW
 *  - addr:  0xb00001df
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH8_SUB3_CMD
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH8_SUB3_CMD.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH8_SUB3_CMD. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH8_SUB3_CMD(f1,v1) ( \
  R_DMA_CH8_SUB3_CMD__WRITE(R_DMA_CH8_SUB3_CMD__ADDR, ( \
    REG_VAL__R_DMA_CH8_SUB3_CMD_(f1##_,v1) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH8_SUB3_CMD
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH8_SUB3_CMD(f1,v1) ( \
  (R_DMA_CH8_SUB3_CMD__cmd__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH8_SUB3_CMD
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH8_SUB3_CMD.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH8_SUB3_CMD(f1,v1) ( \
  (R_DMA_CH8_SUB3_CMD__cmd__##f1##__VAL(R_DMA_CH8_SUB3_CMD_, cmd_, v1) << R_DMA_CH8_SUB3_CMD__cmd__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH8_SUB3_CMD_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH8_SUB3_CMD.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH8_SUB3_CMD_(f1_,v1) ( \
  (R_DMA_CH8_SUB3_CMD__cmd__##f1_##_VAL(R_DMA_CH8_SUB3_CMD_, cmd_, v1) << R_DMA_CH8_SUB3_CMD__cmd__BITNR) \
)

#endif

/*
 *  R_DMA_CH8_SUB3_EP
 *  - type:  RW
 *  - addr:  0xb00001fc
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH8_SUB3_EP
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH8_SUB3_EP.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH8_SUB3_EP. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH8_SUB3_EP(f1,v1) ( \
  R_DMA_CH8_SUB3_EP__WRITE(R_DMA_CH8_SUB3_EP__ADDR, ( \
    REG_VAL__R_DMA_CH8_SUB3_EP_(f1##_,v1) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH8_SUB3_EP
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH8_SUB3_EP(f1,v1) ( \
  (R_DMA_CH8_SUB3_EP__ep__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH8_SUB3_EP
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH8_SUB3_EP.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH8_SUB3_EP(f1,v1) ( \
  (R_DMA_CH8_SUB3_EP__ep__##f1##__VAL(R_DMA_CH8_SUB3_EP_, ep_, v1) << R_DMA_CH8_SUB3_EP__ep__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH8_SUB3_EP_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH8_SUB3_EP.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH8_SUB3_EP_(f1_,v1) ( \
  (R_DMA_CH8_SUB3_EP__ep__##f1_##_VAL(R_DMA_CH8_SUB3_EP_, ep_, v1) << R_DMA_CH8_SUB3_EP__ep__BITNR) \
)

#endif

/*
 *  R_DMA_CH9_BUF
 *  - type:  RW
 *  - addr:  0xb0000198
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH9_BUF
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH9_BUF.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH9_BUF. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH9_BUF(f1,v1) ( \
  R_DMA_CH9_BUF__WRITE(R_DMA_CH9_BUF__ADDR, ( \
    REG_VAL__R_DMA_CH9_BUF_(f1##_,v1) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH9_BUF
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH9_BUF(f1,v1) ( \
  (R_DMA_CH9_BUF__buf__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH9_BUF
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH9_BUF.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH9_BUF(f1,v1) ( \
  (R_DMA_CH9_BUF__buf__##f1##__VAL(R_DMA_CH9_BUF_, buf_, v1) << R_DMA_CH9_BUF__buf__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH9_BUF_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH9_BUF.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH9_BUF_(f1_,v1) ( \
  (R_DMA_CH9_BUF__buf__##f1_##_VAL(R_DMA_CH9_BUF_, buf_, v1) << R_DMA_CH9_BUF__buf__BITNR) \
)

#endif

/*
 *  R_DMA_CH9_CLR_INTR
 *  - type:  WO
 *  - addr:  0xb00001f5
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH9_CLR_INTR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH9_CLR_INTR.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH9_CLR_INTR. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH9_CLR_INTR(f1,v1,f2,v2) ( \
  *R_DMA_CH9_CLR_INTR__SADDR = ( \
    REG_INITIATED(R_DMA_CH9_CLR_INTR_) \
    REG_VAL__R_DMA_CH9_CLR_INTR_(f1##_,v1,f2##_,v2) \
  ), \
  R_DMA_CH9_CLR_INTR__WRITE(R_DMA_CH9_CLR_INTR__ADDR, *R_DMA_CH9_CLR_INTR__SADDR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH9_CLR_INTR__SHADOW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH9_CLR_INTR.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in the 
*#               shadow register for R_DMA_CH9_CLR_INTR. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH9_CLR_INTR__SHADOW(f1,v1,f2,v2) ( \
  *R_DMA_CH9_CLR_INTR__SADDR = ( \
    REG_INITIATED(R_DMA_CH9_CLR_INTR_) \
    REG_VAL__R_DMA_CH9_CLR_INTR_(f1##_,v1,f2##_,v2) \
  ) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH9_CLR_INTR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH9_CLR_INTR(f1,v1,f2,v2) ( \
  (R_DMA_CH9_CLR_INTR__clr_eop__##f1##__MASK & REG__##v1) | \
  (R_DMA_CH9_CLR_INTR__clr_descr__##f2##__MASK & REG__##v2) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH9_CLR_INTR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH9_CLR_INTR.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH9_CLR_INTR(f1,v1,f2,v2) ( \
  (R_DMA_CH9_CLR_INTR__clr_eop__##f1##__VAL(R_DMA_CH9_CLR_INTR_, clr_eop_, v1) << R_DMA_CH9_CLR_INTR__clr_eop__BITNR) | \
  (R_DMA_CH9_CLR_INTR__clr_descr__##f2##__VAL(R_DMA_CH9_CLR_INTR_, clr_descr_, v2) << R_DMA_CH9_CLR_INTR__clr_descr__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH9_CLR_INTR_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH9_CLR_INTR.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH9_CLR_INTR_(f1_,v1,f2_,v2) ( \
  (R_DMA_CH9_CLR_INTR__clr_eop__##f1_##_VAL(R_DMA_CH9_CLR_INTR_, clr_eop_, v1) << R_DMA_CH9_CLR_INTR__clr_eop__BITNR) | \
  (R_DMA_CH9_CLR_INTR__clr_descr__##f2_##_VAL(R_DMA_CH9_CLR_INTR_, clr_descr_, v2) << R_DMA_CH9_CLR_INTR__clr_descr__BITNR) \
)

#endif

/*
 *  R_DMA_CH9_CMD
 *  - type:  RW
 *  - addr:  0xb00001f4
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH9_CMD
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH9_CMD.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH9_CMD. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH9_CMD(f1,v1) ( \
  R_DMA_CH9_CMD__WRITE(R_DMA_CH9_CMD__ADDR, ( \
    REG_VAL__R_DMA_CH9_CMD_(f1##_,v1) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH9_CMD
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH9_CMD(f1,v1) ( \
  (R_DMA_CH9_CMD__cmd__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH9_CMD
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH9_CMD.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH9_CMD(f1,v1) ( \
  (R_DMA_CH9_CMD__cmd__##f1##__VAL(R_DMA_CH9_CMD_, cmd_, v1) << R_DMA_CH9_CMD__cmd__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH9_CMD_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH9_CMD.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH9_CMD_(f1_,v1) ( \
  (R_DMA_CH9_CMD__cmd__##f1_##_VAL(R_DMA_CH9_CMD_, cmd_, v1) << R_DMA_CH9_CMD__cmd__BITNR) \
)

#endif

/*
 *  R_DMA_CH9_DESCR
 *  - type:  RW
 *  - addr:  0xb000019c
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH9_DESCR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH9_DESCR.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH9_DESCR. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH9_DESCR(f1,v1) ( \
  R_DMA_CH9_DESCR__WRITE(R_DMA_CH9_DESCR__ADDR, ( \
    REG_VAL__R_DMA_CH9_DESCR_(f1##_,v1) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH9_DESCR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH9_DESCR(f1,v1) ( \
  (R_DMA_CH9_DESCR__descr__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH9_DESCR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH9_DESCR.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH9_DESCR(f1,v1) ( \
  (R_DMA_CH9_DESCR__descr__##f1##__VAL(R_DMA_CH9_DESCR_, descr_, v1) << R_DMA_CH9_DESCR__descr__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH9_DESCR_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH9_DESCR.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH9_DESCR_(f1_,v1) ( \
  (R_DMA_CH9_DESCR__descr__##f1_##_VAL(R_DMA_CH9_DESCR_, descr_, v1) << R_DMA_CH9_DESCR__descr__BITNR) \
)

#endif

/*
 *  R_DMA_CH9_FIRST
 *  - type:  RW
 *  - addr:  0xb00001c4
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH9_FIRST
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH9_FIRST.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH9_FIRST. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH9_FIRST(f1,v1) ( \
  R_DMA_CH9_FIRST__WRITE(R_DMA_CH9_FIRST__ADDR, ( \
    REG_VAL__R_DMA_CH9_FIRST_(f1##_,v1) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH9_FIRST
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH9_FIRST(f1,v1) ( \
  (R_DMA_CH9_FIRST__first__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH9_FIRST
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH9_FIRST.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH9_FIRST(f1,v1) ( \
  (R_DMA_CH9_FIRST__first__##f1##__VAL(R_DMA_CH9_FIRST_, first_, v1) << R_DMA_CH9_FIRST__first__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH9_FIRST_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH9_FIRST.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH9_FIRST_(f1_,v1) ( \
  (R_DMA_CH9_FIRST__first__##f1_##_VAL(R_DMA_CH9_FIRST_, first_, v1) << R_DMA_CH9_FIRST__first__BITNR) \
)

#endif

/*
 *  R_DMA_CH9_HWSW
 *  - type:  RW
 *  - addr:  0xb0000190
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH9_HWSW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH9_HWSW.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH9_HWSW. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH9_HWSW(f1,v1,f2,v2) ( \
  R_DMA_CH9_HWSW__WRITE(R_DMA_CH9_HWSW__ADDR, ( \
    REG_VAL__R_DMA_CH9_HWSW_(f1##_,v1,f2##_,v2) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH9_HWSW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH9_HWSW(f1,v1,f2,v2) ( \
  (R_DMA_CH9_HWSW__hw__##f1##__MASK & REG__##v1) | \
  (R_DMA_CH9_HWSW__sw__##f2##__MASK & REG__##v2) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH9_HWSW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH9_HWSW.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH9_HWSW(f1,v1,f2,v2) ( \
  (R_DMA_CH9_HWSW__hw__##f1##__VAL(R_DMA_CH9_HWSW_, hw_, v1) << R_DMA_CH9_HWSW__hw__BITNR) | \
  (R_DMA_CH9_HWSW__sw__##f2##__VAL(R_DMA_CH9_HWSW_, sw_, v2) << R_DMA_CH9_HWSW__sw__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH9_HWSW_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH9_HWSW.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH9_HWSW_(f1_,v1,f2_,v2) ( \
  (R_DMA_CH9_HWSW__hw__##f1_##_VAL(R_DMA_CH9_HWSW_, hw_, v1) << R_DMA_CH9_HWSW__hw__BITNR) | \
  (R_DMA_CH9_HWSW__sw__##f2_##_VAL(R_DMA_CH9_HWSW_, sw_, v2) << R_DMA_CH9_HWSW__sw__BITNR) \
)

#endif

/*
 *  R_DMA_CH9_NEXT
 *  - type:  RW
 *  - addr:  0xb0000194
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DMA_CH9_NEXT
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DMA_CH9_NEXT.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DMA_CH9_NEXT. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DMA_CH9_NEXT(f1,v1) ( \
  R_DMA_CH9_NEXT__WRITE(R_DMA_CH9_NEXT__ADDR, ( \
    REG_VAL__R_DMA_CH9_NEXT_(f1##_,v1) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH9_NEXT
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH9_NEXT(f1,v1) ( \
  (R_DMA_CH9_NEXT__next__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH9_NEXT
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH9_NEXT.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH9_NEXT(f1,v1) ( \
  (R_DMA_CH9_NEXT__next__##f1##__VAL(R_DMA_CH9_NEXT_, next_, v1) << R_DMA_CH9_NEXT__next__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH9_NEXT_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH9_NEXT.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH9_NEXT_(f1_,v1) ( \
  (R_DMA_CH9_NEXT__next__##f1_##_VAL(R_DMA_CH9_NEXT_, next_, v1) << R_DMA_CH9_NEXT__next__BITNR) \
)

#endif

/*
 *  R_DMA_CH9_STATUS
 *  - type:  RO
 *  - addr:  0xb00001f6
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

/* No REG_SET__register-name for read only registers. */

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DMA_CH9_STATUS
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DMA_CH9_STATUS(f1,v1) ( \
  (R_DMA_CH9_STATUS__avail__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH9_STATUS
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH9_STATUS.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DMA_CH9_STATUS(f1,v1) ( \
  (R_DMA_CH9_STATUS__avail__##f1##__VAL(R_DMA_CH9_STATUS_, avail_, v1) << R_DMA_CH9_STATUS__avail__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DMA_CH9_STATUS_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DMA_CH9_STATUS.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DMA_CH9_STATUS_(f1_,v1) ( \
  (R_DMA_CH9_STATUS__avail__##f1_##_VAL(R_DMA_CH9_STATUS_, avail_, v1) << R_DMA_CH9_STATUS__avail__BITNR) \
)

#endif

/*
 *  R_DRAM_CONFIG
 *  - type:  WO
 *  - addr:  0xb000000c
 *  - group: Bus interface configuration registers
 */

#if USE_GROUP__Bus_interface_configuration_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DRAM_CONFIG
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DRAM_CONFIG.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DRAM_CONFIG. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DRAM_CONFIG(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11,f12,v12) ( \
  *R_DRAM_CONFIG__SADDR = ( \
    REG_INITIATED(R_DRAM_CONFIG_) \
    REG_VAL__R_DRAM_CONFIG_(f1##_,v1,f2##_,v2,f3##_,v3,f4##_,v4,f5##_,v5,f6##_,v6,f7##_,v7,f8##_,v8,f9##_,v9,f10##_,v10,f11##_,v11,f12##_,v12) \
  ), \
  R_DRAM_CONFIG__WRITE(R_DRAM_CONFIG__ADDR, *R_DRAM_CONFIG__SADDR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DRAM_CONFIG__SHADOW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DRAM_CONFIG.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in the 
*#               shadow register for R_DRAM_CONFIG. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DRAM_CONFIG__SHADOW(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11,f12,v12) ( \
  *R_DRAM_CONFIG__SADDR = ( \
    REG_INITIATED(R_DRAM_CONFIG_) \
    REG_VAL__R_DRAM_CONFIG_(f1##_,v1,f2##_,v2,f3##_,v3,f4##_,v4,f5##_,v5,f6##_,v6,f7##_,v7,f8##_,v8,f9##_,v9,f10##_,v10,f11##_,v11,f12##_,v12) \
  ) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DRAM_CONFIG
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DRAM_CONFIG(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11,f12,v12) ( \
  (R_DRAM_CONFIG__wmm1__##f1##__MASK & REG__##v1) | \
  (R_DRAM_CONFIG__wmm0__##f2##__MASK & REG__##v2) | \
  (R_DRAM_CONFIG__sh1__##f3##__MASK & REG__##v3) | \
  (R_DRAM_CONFIG__sh0__##f4##__MASK & REG__##v4) | \
  (R_DRAM_CONFIG__w__##f5##__MASK & REG__##v5) | \
  (R_DRAM_CONFIG__c__##f6##__MASK & REG__##v6) | \
  (R_DRAM_CONFIG__e__##f7##__MASK & REG__##v7) | \
  (R_DRAM_CONFIG__group_sel__##f8##__MASK & REG__##v8) | \
  (R_DRAM_CONFIG__ca1__##f9##__MASK & REG__##v9) | \
  (R_DRAM_CONFIG__bank23sel__##f10##__MASK & REG__##v10) | \
  (R_DRAM_CONFIG__ca0__##f11##__MASK & REG__##v11) | \
  (R_DRAM_CONFIG__bank01sel__##f12##__MASK & REG__##v12) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DRAM_CONFIG
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DRAM_CONFIG.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DRAM_CONFIG(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11,f12,v12) ( \
  (R_DRAM_CONFIG__wmm1__##f1##__VAL(R_DRAM_CONFIG_, wmm1_, v1) << R_DRAM_CONFIG__wmm1__BITNR) | \
  (R_DRAM_CONFIG__wmm0__##f2##__VAL(R_DRAM_CONFIG_, wmm0_, v2) << R_DRAM_CONFIG__wmm0__BITNR) | \
  (R_DRAM_CONFIG__sh1__##f3##__VAL(R_DRAM_CONFIG_, sh1_, v3) << R_DRAM_CONFIG__sh1__BITNR) | \
  (R_DRAM_CONFIG__sh0__##f4##__VAL(R_DRAM_CONFIG_, sh0_, v4) << R_DRAM_CONFIG__sh0__BITNR) | \
  (R_DRAM_CONFIG__w__##f5##__VAL(R_DRAM_CONFIG_, w_, v5) << R_DRAM_CONFIG__w__BITNR) | \
  (R_DRAM_CONFIG__c__##f6##__VAL(R_DRAM_CONFIG_, c_, v6) << R_DRAM_CONFIG__c__BITNR) | \
  (R_DRAM_CONFIG__e__##f7##__VAL(R_DRAM_CONFIG_, e_, v7) << R_DRAM_CONFIG__e__BITNR) | \
  (R_DRAM_CONFIG__group_sel__##f8##__VAL(R_DRAM_CONFIG_, group_sel_, v8) << R_DRAM_CONFIG__group_sel__BITNR) | \
  (R_DRAM_CONFIG__ca1__##f9##__VAL(R_DRAM_CONFIG_, ca1_, v9) << R_DRAM_CONFIG__ca1__BITNR) | \
  (R_DRAM_CONFIG__bank23sel__##f10##__VAL(R_DRAM_CONFIG_, bank23sel_, v10) << R_DRAM_CONFIG__bank23sel__BITNR) | \
  (R_DRAM_CONFIG__ca0__##f11##__VAL(R_DRAM_CONFIG_, ca0_, v11) << R_DRAM_CONFIG__ca0__BITNR) | \
  (R_DRAM_CONFIG__bank01sel__##f12##__VAL(R_DRAM_CONFIG_, bank01sel_, v12) << R_DRAM_CONFIG__bank01sel__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DRAM_CONFIG_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DRAM_CONFIG.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DRAM_CONFIG_(f1_,v1,f2_,v2,f3_,v3,f4_,v4,f5_,v5,f6_,v6,f7_,v7,f8_,v8,f9_,v9,f10_,v10,f11_,v11,f12_,v12) ( \
  (R_DRAM_CONFIG__wmm1__##f1_##_VAL(R_DRAM_CONFIG_, wmm1_, v1) << R_DRAM_CONFIG__wmm1__BITNR) | \
  (R_DRAM_CONFIG__wmm0__##f2_##_VAL(R_DRAM_CONFIG_, wmm0_, v2) << R_DRAM_CONFIG__wmm0__BITNR) | \
  (R_DRAM_CONFIG__sh1__##f3_##_VAL(R_DRAM_CONFIG_, sh1_, v3) << R_DRAM_CONFIG__sh1__BITNR) | \
  (R_DRAM_CONFIG__sh0__##f4_##_VAL(R_DRAM_CONFIG_, sh0_, v4) << R_DRAM_CONFIG__sh0__BITNR) | \
  (R_DRAM_CONFIG__w__##f5_##_VAL(R_DRAM_CONFIG_, w_, v5) << R_DRAM_CONFIG__w__BITNR) | \
  (R_DRAM_CONFIG__c__##f6_##_VAL(R_DRAM_CONFIG_, c_, v6) << R_DRAM_CONFIG__c__BITNR) | \
  (R_DRAM_CONFIG__e__##f7_##_VAL(R_DRAM_CONFIG_, e_, v7) << R_DRAM_CONFIG__e__BITNR) | \
  (R_DRAM_CONFIG__group_sel__##f8_##_VAL(R_DRAM_CONFIG_, group_sel_, v8) << R_DRAM_CONFIG__group_sel__BITNR) | \
  (R_DRAM_CONFIG__ca1__##f9_##_VAL(R_DRAM_CONFIG_, ca1_, v9) << R_DRAM_CONFIG__ca1__BITNR) | \
  (R_DRAM_CONFIG__bank23sel__##f10_##_VAL(R_DRAM_CONFIG_, bank23sel_, v10) << R_DRAM_CONFIG__bank23sel__BITNR) | \
  (R_DRAM_CONFIG__ca0__##f11_##_VAL(R_DRAM_CONFIG_, ca0_, v11) << R_DRAM_CONFIG__ca0__BITNR) | \
  (R_DRAM_CONFIG__bank01sel__##f12_##_VAL(R_DRAM_CONFIG_, bank01sel_, v12) << R_DRAM_CONFIG__bank01sel__BITNR) \
)

#endif

/*
 *  R_DRAM_TIMING
 *  - type:  WO
 *  - addr:  0xb0000008
 *  - group: Bus interface configuration registers
 */

#if USE_GROUP__Bus_interface_configuration_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DRAM_TIMING
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DRAM_TIMING.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_DRAM_TIMING. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DRAM_TIMING(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10) ( \
  *R_DRAM_TIMING__SADDR = ( \
    REG_INITIATED(R_DRAM_TIMING_) \
    REG_VAL__R_DRAM_TIMING_(f1##_,v1,f2##_,v2,f3##_,v3,f4##_,v4,f5##_,v5,f6##_,v6,f7##_,v7,f8##_,v8,f9##_,v9,f10##_,v10) \
  ), \
  R_DRAM_TIMING__WRITE(R_DRAM_TIMING__ADDR, *R_DRAM_TIMING__SADDR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_DRAM_TIMING__SHADOW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_DRAM_TIMING.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in the 
*#               shadow register for R_DRAM_TIMING. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_DRAM_TIMING__SHADOW(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10) ( \
  *R_DRAM_TIMING__SADDR = ( \
    REG_INITIATED(R_DRAM_TIMING_) \
    REG_VAL__R_DRAM_TIMING_(f1##_,v1,f2##_,v2,f3##_,v3,f4##_,v4,f5##_,v5,f6##_,v6,f7##_,v7,f8##_,v8,f9##_,v9,f10##_,v10) \
  ) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_DRAM_TIMING
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_DRAM_TIMING(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10) ( \
  (R_DRAM_TIMING__sdram__##f1##__MASK & REG__##v1) | \
  (R_DRAM_TIMING__ref__##f2##__MASK & REG__##v2) | \
  (R_DRAM_TIMING__rp__##f3##__MASK & REG__##v3) | \
  (R_DRAM_TIMING__rs__##f4##__MASK & REG__##v4) | \
  (R_DRAM_TIMING__rh__##f5##__MASK & REG__##v5) | \
  (R_DRAM_TIMING__w__##f6##__MASK & REG__##v6) | \
  (R_DRAM_TIMING__c__##f7##__MASK & REG__##v7) | \
  (R_DRAM_TIMING__cz__##f8##__MASK & REG__##v8) | \
  (R_DRAM_TIMING__cp__##f9##__MASK & REG__##v9) | \
  (R_DRAM_TIMING__cw__##f10##__MASK & REG__##v10) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DRAM_TIMING
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DRAM_TIMING.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_DRAM_TIMING(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10) ( \
  (R_DRAM_TIMING__sdram__##f1##__VAL(R_DRAM_TIMING_, sdram_, v1) << R_DRAM_TIMING__sdram__BITNR) | \
  (R_DRAM_TIMING__ref__##f2##__VAL(R_DRAM_TIMING_, ref_, v2) << R_DRAM_TIMING__ref__BITNR) | \
  (R_DRAM_TIMING__rp__##f3##__VAL(R_DRAM_TIMING_, rp_, v3) << R_DRAM_TIMING__rp__BITNR) | \
  (R_DRAM_TIMING__rs__##f4##__VAL(R_DRAM_TIMING_, rs_, v4) << R_DRAM_TIMING__rs__BITNR) | \
  (R_DRAM_TIMING__rh__##f5##__VAL(R_DRAM_TIMING_, rh_, v5) << R_DRAM_TIMING__rh__BITNR) | \
  (R_DRAM_TIMING__w__##f6##__VAL(R_DRAM_TIMING_, w_, v6) << R_DRAM_TIMING__w__BITNR) | \
  (R_DRAM_TIMING__c__##f7##__VAL(R_DRAM_TIMING_, c_, v7) << R_DRAM_TIMING__c__BITNR) | \
  (R_DRAM_TIMING__cz__##f8##__VAL(R_DRAM_TIMING_, cz_, v8) << R_DRAM_TIMING__cz__BITNR) | \
  (R_DRAM_TIMING__cp__##f9##__VAL(R_DRAM_TIMING_, cp_, v9) << R_DRAM_TIMING__cp__BITNR) | \
  (R_DRAM_TIMING__cw__##f10##__VAL(R_DRAM_TIMING_, cw_, v10) << R_DRAM_TIMING__cw__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_DRAM_TIMING_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_DRAM_TIMING.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_DRAM_TIMING_(f1_,v1,f2_,v2,f3_,v3,f4_,v4,f5_,v5,f6_,v6,f7_,v7,f8_,v8,f9_,v9,f10_,v10) ( \
  (R_DRAM_TIMING__sdram__##f1_##_VAL(R_DRAM_TIMING_, sdram_, v1) << R_DRAM_TIMING__sdram__BITNR) | \
  (R_DRAM_TIMING__ref__##f2_##_VAL(R_DRAM_TIMING_, ref_, v2) << R_DRAM_TIMING__ref__BITNR) | \
  (R_DRAM_TIMING__rp__##f3_##_VAL(R_DRAM_TIMING_, rp_, v3) << R_DRAM_TIMING__rp__BITNR) | \
  (R_DRAM_TIMING__rs__##f4_##_VAL(R_DRAM_TIMING_, rs_, v4) << R_DRAM_TIMING__rs__BITNR) | \
  (R_DRAM_TIMING__rh__##f5_##_VAL(R_DRAM_TIMING_, rh_, v5) << R_DRAM_TIMING__rh__BITNR) | \
  (R_DRAM_TIMING__w__##f6_##_VAL(R_DRAM_TIMING_, w_, v6) << R_DRAM_TIMING__w__BITNR) | \
  (R_DRAM_TIMING__c__##f7_##_VAL(R_DRAM_TIMING_, c_, v7) << R_DRAM_TIMING__c__BITNR) | \
  (R_DRAM_TIMING__cz__##f8_##_VAL(R_DRAM_TIMING_, cz_, v8) << R_DRAM_TIMING__cz__BITNR) | \
  (R_DRAM_TIMING__cp__##f9_##_VAL(R_DRAM_TIMING_, cp_, v9) << R_DRAM_TIMING__cp__BITNR) | \
  (R_DRAM_TIMING__cw__##f10_##_VAL(R_DRAM_TIMING_, cw_, v10) << R_DRAM_TIMING__cw__BITNR) \
)

#endif

/*
 *  R_EXT_DMA_0_ADDR
 *  - type:  WO
 *  - addr:  0xb0000014
 *  - group: External DMA registers
 */

#if USE_GROUP__External_DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_EXT_DMA_0_ADDR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_EXT_DMA_0_ADDR.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_EXT_DMA_0_ADDR. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_EXT_DMA_0_ADDR(f1,v1) ( \
  *R_EXT_DMA_0_ADDR__SADDR = ( \
    REG_INITIATED(R_EXT_DMA_0_ADDR_) \
    REG_VAL__R_EXT_DMA_0_ADDR_(f1##_,v1) \
  ), \
  R_EXT_DMA_0_ADDR__WRITE(R_EXT_DMA_0_ADDR__ADDR, *R_EXT_DMA_0_ADDR__SADDR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_EXT_DMA_0_ADDR__SHADOW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_EXT_DMA_0_ADDR.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in the 
*#               shadow register for R_EXT_DMA_0_ADDR. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_EXT_DMA_0_ADDR__SHADOW(f1,v1) ( \
  *R_EXT_DMA_0_ADDR__SADDR = ( \
    REG_INITIATED(R_EXT_DMA_0_ADDR_) \
    REG_VAL__R_EXT_DMA_0_ADDR_(f1##_,v1) \
  ) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_EXT_DMA_0_ADDR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_EXT_DMA_0_ADDR(f1,v1) ( \
  (R_EXT_DMA_0_ADDR__ext0_addr__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_EXT_DMA_0_ADDR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_EXT_DMA_0_ADDR.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_EXT_DMA_0_ADDR(f1,v1) ( \
  (R_EXT_DMA_0_ADDR__ext0_addr__##f1##__VAL(R_EXT_DMA_0_ADDR_, ext0_addr_, v1) << R_EXT_DMA_0_ADDR__ext0_addr__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_EXT_DMA_0_ADDR_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_EXT_DMA_0_ADDR.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_EXT_DMA_0_ADDR_(f1_,v1) ( \
  (R_EXT_DMA_0_ADDR__ext0_addr__##f1_##_VAL(R_EXT_DMA_0_ADDR_, ext0_addr_, v1) << R_EXT_DMA_0_ADDR__ext0_addr__BITNR) \
)

#endif

/*
 *  R_EXT_DMA_0_CMD
 *  - type:  WO
 *  - addr:  0xb0000010
 *  - group: External DMA registers
 */

#if USE_GROUP__External_DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_EXT_DMA_0_CMD
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_EXT_DMA_0_CMD.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_EXT_DMA_0_CMD. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_EXT_DMA_0_CMD(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8) ( \
  *R_EXT_DMA_0_CMD__SADDR = ( \
    REG_INITIATED(R_EXT_DMA_0_CMD_) \
    REG_VAL__R_EXT_DMA_0_CMD_(f1##_,v1,f2##_,v2,f3##_,v3,f4##_,v4,f5##_,v5,f6##_,v6,f7##_,v7,f8##_,v8) \
  ), \
  R_EXT_DMA_0_CMD__WRITE(R_EXT_DMA_0_CMD__ADDR, *R_EXT_DMA_0_CMD__SADDR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_EXT_DMA_0_CMD__SHADOW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_EXT_DMA_0_CMD.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in the 
*#               shadow register for R_EXT_DMA_0_CMD. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_EXT_DMA_0_CMD__SHADOW(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8) ( \
  *R_EXT_DMA_0_CMD__SADDR = ( \
    REG_INITIATED(R_EXT_DMA_0_CMD_) \
    REG_VAL__R_EXT_DMA_0_CMD_(f1##_,v1,f2##_,v2,f3##_,v3,f4##_,v4,f5##_,v5,f6##_,v6,f7##_,v7,f8##_,v8) \
  ) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_EXT_DMA_0_CMD
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_EXT_DMA_0_CMD(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8) ( \
  (R_EXT_DMA_0_CMD__cnt__##f1##__MASK & REG__##v1) | \
  (R_EXT_DMA_0_CMD__rqpol__##f2##__MASK & REG__##v2) | \
  (R_EXT_DMA_0_CMD__apol__##f3##__MASK & REG__##v3) | \
  (R_EXT_DMA_0_CMD__rq_ack__##f4##__MASK & REG__##v4) | \
  (R_EXT_DMA_0_CMD__wid__##f5##__MASK & REG__##v5) | \
  (R_EXT_DMA_0_CMD__dir__##f6##__MASK & REG__##v6) | \
  (R_EXT_DMA_0_CMD__run__##f7##__MASK & REG__##v7) | \
  (R_EXT_DMA_0_CMD__trf_count__##f8##__MASK & REG__##v8) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_EXT_DMA_0_CMD
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_EXT_DMA_0_CMD.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_EXT_DMA_0_CMD(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8) ( \
  (R_EXT_DMA_0_CMD__cnt__##f1##__VAL(R_EXT_DMA_0_CMD_, cnt_, v1) << R_EXT_DMA_0_CMD__cnt__BITNR) | \
  (R_EXT_DMA_0_CMD__rqpol__##f2##__VAL(R_EXT_DMA_0_CMD_, rqpol_, v2) << R_EXT_DMA_0_CMD__rqpol__BITNR) | \
  (R_EXT_DMA_0_CMD__apol__##f3##__VAL(R_EXT_DMA_0_CMD_, apol_, v3) << R_EXT_DMA_0_CMD__apol__BITNR) | \
  (R_EXT_DMA_0_CMD__rq_ack__##f4##__VAL(R_EXT_DMA_0_CMD_, rq_ack_, v4) << R_EXT_DMA_0_CMD__rq_ack__BITNR) | \
  (R_EXT_DMA_0_CMD__wid__##f5##__VAL(R_EXT_DMA_0_CMD_, wid_, v5) << R_EXT_DMA_0_CMD__wid__BITNR) | \
  (R_EXT_DMA_0_CMD__dir__##f6##__VAL(R_EXT_DMA_0_CMD_, dir_, v6) << R_EXT_DMA_0_CMD__dir__BITNR) | \
  (R_EXT_DMA_0_CMD__run__##f7##__VAL(R_EXT_DMA_0_CMD_, run_, v7) << R_EXT_DMA_0_CMD__run__BITNR) | \
  (R_EXT_DMA_0_CMD__trf_count__##f8##__VAL(R_EXT_DMA_0_CMD_, trf_count_, v8) << R_EXT_DMA_0_CMD__trf_count__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_EXT_DMA_0_CMD_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_EXT_DMA_0_CMD.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_EXT_DMA_0_CMD_(f1_,v1,f2_,v2,f3_,v3,f4_,v4,f5_,v5,f6_,v6,f7_,v7,f8_,v8) ( \
  (R_EXT_DMA_0_CMD__cnt__##f1_##_VAL(R_EXT_DMA_0_CMD_, cnt_, v1) << R_EXT_DMA_0_CMD__cnt__BITNR) | \
  (R_EXT_DMA_0_CMD__rqpol__##f2_##_VAL(R_EXT_DMA_0_CMD_, rqpol_, v2) << R_EXT_DMA_0_CMD__rqpol__BITNR) | \
  (R_EXT_DMA_0_CMD__apol__##f3_##_VAL(R_EXT_DMA_0_CMD_, apol_, v3) << R_EXT_DMA_0_CMD__apol__BITNR) | \
  (R_EXT_DMA_0_CMD__rq_ack__##f4_##_VAL(R_EXT_DMA_0_CMD_, rq_ack_, v4) << R_EXT_DMA_0_CMD__rq_ack__BITNR) | \
  (R_EXT_DMA_0_CMD__wid__##f5_##_VAL(R_EXT_DMA_0_CMD_, wid_, v5) << R_EXT_DMA_0_CMD__wid__BITNR) | \
  (R_EXT_DMA_0_CMD__dir__##f6_##_VAL(R_EXT_DMA_0_CMD_, dir_, v6) << R_EXT_DMA_0_CMD__dir__BITNR) | \
  (R_EXT_DMA_0_CMD__run__##f7_##_VAL(R_EXT_DMA_0_CMD_, run_, v7) << R_EXT_DMA_0_CMD__run__BITNR) | \
  (R_EXT_DMA_0_CMD__trf_count__##f8_##_VAL(R_EXT_DMA_0_CMD_, trf_count_, v8) << R_EXT_DMA_0_CMD__trf_count__BITNR) \
)

#endif

/*
 *  R_EXT_DMA_0_STAT
 *  - type:  RO
 *  - addr:  0xb0000010
 *  - group: External DMA registers
 */

#if USE_GROUP__External_DMA_registers

/* No REG_SET__register-name for read only registers. */

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_EXT_DMA_0_STAT
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_EXT_DMA_0_STAT(f1,v1,f2,v2) ( \
  (R_EXT_DMA_0_STAT__run__##f1##__MASK & REG__##v1) | \
  (R_EXT_DMA_0_STAT__trf_count__##f2##__MASK & REG__##v2) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_EXT_DMA_0_STAT
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_EXT_DMA_0_STAT.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_EXT_DMA_0_STAT(f1,v1,f2,v2) ( \
  (R_EXT_DMA_0_STAT__run__##f1##__VAL(R_EXT_DMA_0_STAT_, run_, v1) << R_EXT_DMA_0_STAT__run__BITNR) | \
  (R_EXT_DMA_0_STAT__trf_count__##f2##__VAL(R_EXT_DMA_0_STAT_, trf_count_, v2) << R_EXT_DMA_0_STAT__trf_count__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_EXT_DMA_0_STAT_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_EXT_DMA_0_STAT.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_EXT_DMA_0_STAT_(f1_,v1,f2_,v2) ( \
  (R_EXT_DMA_0_STAT__run__##f1_##_VAL(R_EXT_DMA_0_STAT_, run_, v1) << R_EXT_DMA_0_STAT__run__BITNR) | \
  (R_EXT_DMA_0_STAT__trf_count__##f2_##_VAL(R_EXT_DMA_0_STAT_, trf_count_, v2) << R_EXT_DMA_0_STAT__trf_count__BITNR) \
)

#endif

/*
 *  R_EXT_DMA_1_ADDR
 *  - type:  WO
 *  - addr:  0xb000001c
 *  - group: External DMA registers
 */

#if USE_GROUP__External_DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_EXT_DMA_1_ADDR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_EXT_DMA_1_ADDR.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_EXT_DMA_1_ADDR. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_EXT_DMA_1_ADDR(f1,v1) ( \
  *R_EXT_DMA_1_ADDR__SADDR = ( \
    REG_INITIATED(R_EXT_DMA_1_ADDR_) \
    REG_VAL__R_EXT_DMA_1_ADDR_(f1##_,v1) \
  ), \
  R_EXT_DMA_1_ADDR__WRITE(R_EXT_DMA_1_ADDR__ADDR, *R_EXT_DMA_1_ADDR__SADDR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_EXT_DMA_1_ADDR__SHADOW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_EXT_DMA_1_ADDR.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in the 
*#               shadow register for R_EXT_DMA_1_ADDR. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_EXT_DMA_1_ADDR__SHADOW(f1,v1) ( \
  *R_EXT_DMA_1_ADDR__SADDR = ( \
    REG_INITIATED(R_EXT_DMA_1_ADDR_) \
    REG_VAL__R_EXT_DMA_1_ADDR_(f1##_,v1) \
  ) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_EXT_DMA_1_ADDR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_EXT_DMA_1_ADDR(f1,v1) ( \
  (R_EXT_DMA_1_ADDR__ext0_addr__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_EXT_DMA_1_ADDR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_EXT_DMA_1_ADDR.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_EXT_DMA_1_ADDR(f1,v1) ( \
  (R_EXT_DMA_1_ADDR__ext0_addr__##f1##__VAL(R_EXT_DMA_1_ADDR_, ext0_addr_, v1) << R_EXT_DMA_1_ADDR__ext0_addr__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_EXT_DMA_1_ADDR_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_EXT_DMA_1_ADDR.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_EXT_DMA_1_ADDR_(f1_,v1) ( \
  (R_EXT_DMA_1_ADDR__ext0_addr__##f1_##_VAL(R_EXT_DMA_1_ADDR_, ext0_addr_, v1) << R_EXT_DMA_1_ADDR__ext0_addr__BITNR) \
)

#endif

/*
 *  R_EXT_DMA_1_CMD
 *  - type:  WO
 *  - addr:  0xb0000018
 *  - group: External DMA registers
 */

#if USE_GROUP__External_DMA_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_EXT_DMA_1_CMD
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_EXT_DMA_1_CMD.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_EXT_DMA_1_CMD. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_EXT_DMA_1_CMD(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8) ( \
  *R_EXT_DMA_1_CMD__SADDR = ( \
    REG_INITIATED(R_EXT_DMA_1_CMD_) \
    REG_VAL__R_EXT_DMA_1_CMD_(f1##_,v1,f2##_,v2,f3##_,v3,f4##_,v4,f5##_,v5,f6##_,v6,f7##_,v7,f8##_,v8) \
  ), \
  R_EXT_DMA_1_CMD__WRITE(R_EXT_DMA_1_CMD__ADDR, *R_EXT_DMA_1_CMD__SADDR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_EXT_DMA_1_CMD__SHADOW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_EXT_DMA_1_CMD.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in the 
*#               shadow register for R_EXT_DMA_1_CMD. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_EXT_DMA_1_CMD__SHADOW(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8) ( \
  *R_EXT_DMA_1_CMD__SADDR = ( \
    REG_INITIATED(R_EXT_DMA_1_CMD_) \
    REG_VAL__R_EXT_DMA_1_CMD_(f1##_,v1,f2##_,v2,f3##_,v3,f4##_,v4,f5##_,v5,f6##_,v6,f7##_,v7,f8##_,v8) \
  ) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_EXT_DMA_1_CMD
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_EXT_DMA_1_CMD(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8) ( \
  (R_EXT_DMA_1_CMD__cnt__##f1##__MASK & REG__##v1) | \
  (R_EXT_DMA_1_CMD__rqpol__##f2##__MASK & REG__##v2) | \
  (R_EXT_DMA_1_CMD__apol__##f3##__MASK & REG__##v3) | \
  (R_EXT_DMA_1_CMD__rq_ack__##f4##__MASK & REG__##v4) | \
  (R_EXT_DMA_1_CMD__wid__##f5##__MASK & REG__##v5) | \
  (R_EXT_DMA_1_CMD__dir__##f6##__MASK & REG__##v6) | \
  (R_EXT_DMA_1_CMD__run__##f7##__MASK & REG__##v7) | \
  (R_EXT_DMA_1_CMD__trf_count__##f8##__MASK & REG__##v8) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_EXT_DMA_1_CMD
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_EXT_DMA_1_CMD.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_EXT_DMA_1_CMD(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8) ( \
  (R_EXT_DMA_1_CMD__cnt__##f1##__VAL(R_EXT_DMA_1_CMD_, cnt_, v1) << R_EXT_DMA_1_CMD__cnt__BITNR) | \
  (R_EXT_DMA_1_CMD__rqpol__##f2##__VAL(R_EXT_DMA_1_CMD_, rqpol_, v2) << R_EXT_DMA_1_CMD__rqpol__BITNR) | \
  (R_EXT_DMA_1_CMD__apol__##f3##__VAL(R_EXT_DMA_1_CMD_, apol_, v3) << R_EXT_DMA_1_CMD__apol__BITNR) | \
  (R_EXT_DMA_1_CMD__rq_ack__##f4##__VAL(R_EXT_DMA_1_CMD_, rq_ack_, v4) << R_EXT_DMA_1_CMD__rq_ack__BITNR) | \
  (R_EXT_DMA_1_CMD__wid__##f5##__VAL(R_EXT_DMA_1_CMD_, wid_, v5) << R_EXT_DMA_1_CMD__wid__BITNR) | \
  (R_EXT_DMA_1_CMD__dir__##f6##__VAL(R_EXT_DMA_1_CMD_, dir_, v6) << R_EXT_DMA_1_CMD__dir__BITNR) | \
  (R_EXT_DMA_1_CMD__run__##f7##__VAL(R_EXT_DMA_1_CMD_, run_, v7) << R_EXT_DMA_1_CMD__run__BITNR) | \
  (R_EXT_DMA_1_CMD__trf_count__##f8##__VAL(R_EXT_DMA_1_CMD_, trf_count_, v8) << R_EXT_DMA_1_CMD__trf_count__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_EXT_DMA_1_CMD_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_EXT_DMA_1_CMD.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_EXT_DMA_1_CMD_(f1_,v1,f2_,v2,f3_,v3,f4_,v4,f5_,v5,f6_,v6,f7_,v7,f8_,v8) ( \
  (R_EXT_DMA_1_CMD__cnt__##f1_##_VAL(R_EXT_DMA_1_CMD_, cnt_, v1) << R_EXT_DMA_1_CMD__cnt__BITNR) | \
  (R_EXT_DMA_1_CMD__rqpol__##f2_##_VAL(R_EXT_DMA_1_CMD_, rqpol_, v2) << R_EXT_DMA_1_CMD__rqpol__BITNR) | \
  (R_EXT_DMA_1_CMD__apol__##f3_##_VAL(R_EXT_DMA_1_CMD_, apol_, v3) << R_EXT_DMA_1_CMD__apol__BITNR) | \
  (R_EXT_DMA_1_CMD__rq_ack__##f4_##_VAL(R_EXT_DMA_1_CMD_, rq_ack_, v4) << R_EXT_DMA_1_CMD__rq_ack__BITNR) | \
  (R_EXT_DMA_1_CMD__wid__##f5_##_VAL(R_EXT_DMA_1_CMD_, wid_, v5) << R_EXT_DMA_1_CMD__wid__BITNR) | \
  (R_EXT_DMA_1_CMD__dir__##f6_##_VAL(R_EXT_DMA_1_CMD_, dir_, v6) << R_EXT_DMA_1_CMD__dir__BITNR) | \
  (R_EXT_DMA_1_CMD__run__##f7_##_VAL(R_EXT_DMA_1_CMD_, run_, v7) << R_EXT_DMA_1_CMD__run__BITNR) | \
  (R_EXT_DMA_1_CMD__trf_count__##f8_##_VAL(R_EXT_DMA_1_CMD_, trf_count_, v8) << R_EXT_DMA_1_CMD__trf_count__BITNR) \
)

#endif

/*
 *  R_EXT_DMA_1_STAT
 *  - type:  RO
 *  - addr:  0xb0000018
 *  - group: External DMA registers
 */

#if USE_GROUP__External_DMA_registers

/* No REG_SET__register-name for read only registers. */

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_EXT_DMA_1_STAT
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_EXT_DMA_1_STAT(f1,v1,f2,v2) ( \
  (R_EXT_DMA_1_STAT__run__##f1##__MASK & REG__##v1) | \
  (R_EXT_DMA_1_STAT__trf_count__##f2##__MASK & REG__##v2) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_EXT_DMA_1_STAT
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_EXT_DMA_1_STAT.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_EXT_DMA_1_STAT(f1,v1,f2,v2) ( \
  (R_EXT_DMA_1_STAT__run__##f1##__VAL(R_EXT_DMA_1_STAT_, run_, v1) << R_EXT_DMA_1_STAT__run__BITNR) | \
  (R_EXT_DMA_1_STAT__trf_count__##f2##__VAL(R_EXT_DMA_1_STAT_, trf_count_, v2) << R_EXT_DMA_1_STAT__trf_count__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_EXT_DMA_1_STAT_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_EXT_DMA_1_STAT.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_EXT_DMA_1_STAT_(f1_,v1,f2_,v2) ( \
  (R_EXT_DMA_1_STAT__run__##f1_##_VAL(R_EXT_DMA_1_STAT_, run_, v1) << R_EXT_DMA_1_STAT__run__BITNR) | \
  (R_EXT_DMA_1_STAT__trf_count__##f2_##_VAL(R_EXT_DMA_1_STAT_, trf_count_, v2) << R_EXT_DMA_1_STAT__trf_count__BITNR) \
)

#endif

/*
 *  R_GEN_CONFIG
 *  - type:  WO
 *  - addr:  0xb000002c
 *  - group: General config registers
 */

#if USE_GROUP__General_config_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_GEN_CONFIG
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_GEN_CONFIG.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_GEN_CONFIG. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_GEN_CONFIG(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11,f12,v12,f13,v13,f14,v14,f15,v15,f16,v16,f17,v17,f18,v18,f19,v19,f20,v20,f21,v21,f22,v22,f23,v23,f24,v24,f25,v25) ( \
  *R_GEN_CONFIG__SADDR = ( \
    REG_INITIATED(R_GEN_CONFIG_) \
    REG_VAL__R_GEN_CONFIG_(f1##_,v1,f2##_,v2,f3##_,v3,f4##_,v4,f5##_,v5,f6##_,v6,f7##_,v7,f8##_,v8,f9##_,v9,f10##_,v10,f11##_,v11,f12##_,v12,f13##_,v13,f14##_,v14,f15##_,v15,f16##_,v16,f17##_,v17,f18##_,v18,f19##_,v19,f20##_,v20,f21##_,v21,f22##_,v22,f23##_,v23,f24##_,v24,f25##_,v25) \
  ), \
  R_GEN_CONFIG__WRITE(R_GEN_CONFIG__ADDR, *R_GEN_CONFIG__SADDR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_GEN_CONFIG__SHADOW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_GEN_CONFIG.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in the 
*#               shadow register for R_GEN_CONFIG. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_GEN_CONFIG__SHADOW(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11,f12,v12,f13,v13,f14,v14,f15,v15,f16,v16,f17,v17,f18,v18,f19,v19,f20,v20,f21,v21,f22,v22,f23,v23,f24,v24,f25,v25) ( \
  *R_GEN_CONFIG__SADDR = ( \
    REG_INITIATED(R_GEN_CONFIG_) \
    REG_VAL__R_GEN_CONFIG_(f1##_,v1,f2##_,v2,f3##_,v3,f4##_,v4,f5##_,v5,f6##_,v6,f7##_,v7,f8##_,v8,f9##_,v9,f10##_,v10,f11##_,v11,f12##_,v12,f13##_,v13,f14##_,v14,f15##_,v15,f16##_,v16,f17##_,v17,f18##_,v18,f19##_,v19,f20##_,v20,f21##_,v21,f22##_,v22,f23##_,v23,f24##_,v24,f25##_,v25) \
  ) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_GEN_CONFIG
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_GEN_CONFIG(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11,f12,v12,f13,v13,f14,v14,f15,v15,f16,v16,f17,v17,f18,v18,f19,v19,f20,v20,f21,v21,f22,v22,f23,v23,f24,v24,f25,v25) ( \
  (R_GEN_CONFIG__par_w__##f1##__MASK & REG__##v1) | \
  (R_GEN_CONFIG__usb2__##f2##__MASK & REG__##v2) | \
  (R_GEN_CONFIG__usb1__##f3##__MASK & REG__##v3) | \
  (R_GEN_CONFIG__g24dir__##f4##__MASK & REG__##v4) | \
  (R_GEN_CONFIG__g16_23dir__##f5##__MASK & REG__##v5) | \
  (R_GEN_CONFIG__g8_15dir__##f6##__MASK & REG__##v6) | \
  (R_GEN_CONFIG__g0dir__##f7##__MASK & REG__##v7) | \
  (R_GEN_CONFIG__dma9__##f8##__MASK & REG__##v8) | \
  (R_GEN_CONFIG__dma8__##f9##__MASK & REG__##v9) | \
  (R_GEN_CONFIG__dma7__##f10##__MASK & REG__##v10) | \
  (R_GEN_CONFIG__dma6__##f11##__MASK & REG__##v11) | \
  (R_GEN_CONFIG__dma5__##f12##__MASK & REG__##v12) | \
  (R_GEN_CONFIG__dma4__##f13##__MASK & REG__##v13) | \
  (R_GEN_CONFIG__dma3__##f14##__MASK & REG__##v14) | \
  (R_GEN_CONFIG__dma2__##f15##__MASK & REG__##v15) | \
  (R_GEN_CONFIG__mio_w__##f16##__MASK & REG__##v16) | \
  (R_GEN_CONFIG__ser3__##f17##__MASK & REG__##v17) | \
  (R_GEN_CONFIG__par1__##f18##__MASK & REG__##v18) | \
  (R_GEN_CONFIG__scsi0w__##f19##__MASK & REG__##v19) | \
  (R_GEN_CONFIG__scsi1__##f20##__MASK & REG__##v20) | \
  (R_GEN_CONFIG__mio__##f21##__MASK & REG__##v21) | \
  (R_GEN_CONFIG__ser2__##f22##__MASK & REG__##v22) | \
  (R_GEN_CONFIG__par0__##f23##__MASK & REG__##v23) | \
  (R_GEN_CONFIG__ata__##f24##__MASK & REG__##v24) | \
  (R_GEN_CONFIG__scsi0__##f25##__MASK & REG__##v25) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_GEN_CONFIG
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_GEN_CONFIG.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_GEN_CONFIG(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11,f12,v12,f13,v13,f14,v14,f15,v15,f16,v16,f17,v17,f18,v18,f19,v19,f20,v20,f21,v21,f22,v22,f23,v23,f24,v24,f25,v25) ( \
  (R_GEN_CONFIG__par_w__##f1##__VAL(R_GEN_CONFIG_, par_w_, v1) << R_GEN_CONFIG__par_w__BITNR) | \
  (R_GEN_CONFIG__usb2__##f2##__VAL(R_GEN_CONFIG_, usb2_, v2) << R_GEN_CONFIG__usb2__BITNR) | \
  (R_GEN_CONFIG__usb1__##f3##__VAL(R_GEN_CONFIG_, usb1_, v3) << R_GEN_CONFIG__usb1__BITNR) | \
  (R_GEN_CONFIG__g24dir__##f4##__VAL(R_GEN_CONFIG_, g24dir_, v4) << R_GEN_CONFIG__g24dir__BITNR) | \
  (R_GEN_CONFIG__g16_23dir__##f5##__VAL(R_GEN_CONFIG_, g16_23dir_, v5) << R_GEN_CONFIG__g16_23dir__BITNR) | \
  (R_GEN_CONFIG__g8_15dir__##f6##__VAL(R_GEN_CONFIG_, g8_15dir_, v6) << R_GEN_CONFIG__g8_15dir__BITNR) | \
  (R_GEN_CONFIG__g0dir__##f7##__VAL(R_GEN_CONFIG_, g0dir_, v7) << R_GEN_CONFIG__g0dir__BITNR) | \
  (R_GEN_CONFIG__dma9__##f8##__VAL(R_GEN_CONFIG_, dma9_, v8) << R_GEN_CONFIG__dma9__BITNR) | \
  (R_GEN_CONFIG__dma8__##f9##__VAL(R_GEN_CONFIG_, dma8_, v9) << R_GEN_CONFIG__dma8__BITNR) | \
  (R_GEN_CONFIG__dma7__##f10##__VAL(R_GEN_CONFIG_, dma7_, v10) << R_GEN_CONFIG__dma7__BITNR) | \
  (R_GEN_CONFIG__dma6__##f11##__VAL(R_GEN_CONFIG_, dma6_, v11) << R_GEN_CONFIG__dma6__BITNR) | \
  (R_GEN_CONFIG__dma5__##f12##__VAL(R_GEN_CONFIG_, dma5_, v12) << R_GEN_CONFIG__dma5__BITNR) | \
  (R_GEN_CONFIG__dma4__##f13##__VAL(R_GEN_CONFIG_, dma4_, v13) << R_GEN_CONFIG__dma4__BITNR) | \
  (R_GEN_CONFIG__dma3__##f14##__VAL(R_GEN_CONFIG_, dma3_, v14) << R_GEN_CONFIG__dma3__BITNR) | \
  (R_GEN_CONFIG__dma2__##f15##__VAL(R_GEN_CONFIG_, dma2_, v15) << R_GEN_CONFIG__dma2__BITNR) | \
  (R_GEN_CONFIG__mio_w__##f16##__VAL(R_GEN_CONFIG_, mio_w_, v16) << R_GEN_CONFIG__mio_w__BITNR) | \
  (R_GEN_CONFIG__ser3__##f17##__VAL(R_GEN_CONFIG_, ser3_, v17) << R_GEN_CONFIG__ser3__BITNR) | \
  (R_GEN_CONFIG__par1__##f18##__VAL(R_GEN_CONFIG_, par1_, v18) << R_GEN_CONFIG__par1__BITNR) | \
  (R_GEN_CONFIG__scsi0w__##f19##__VAL(R_GEN_CONFIG_, scsi0w_, v19) << R_GEN_CONFIG__scsi0w__BITNR) | \
  (R_GEN_CONFIG__scsi1__##f20##__VAL(R_GEN_CONFIG_, scsi1_, v20) << R_GEN_CONFIG__scsi1__BITNR) | \
  (R_GEN_CONFIG__mio__##f21##__VAL(R_GEN_CONFIG_, mio_, v21) << R_GEN_CONFIG__mio__BITNR) | \
  (R_GEN_CONFIG__ser2__##f22##__VAL(R_GEN_CONFIG_, ser2_, v22) << R_GEN_CONFIG__ser2__BITNR) | \
  (R_GEN_CONFIG__par0__##f23##__VAL(R_GEN_CONFIG_, par0_, v23) << R_GEN_CONFIG__par0__BITNR) | \
  (R_GEN_CONFIG__ata__##f24##__VAL(R_GEN_CONFIG_, ata_, v24) << R_GEN_CONFIG__ata__BITNR) | \
  (R_GEN_CONFIG__scsi0__##f25##__VAL(R_GEN_CONFIG_, scsi0_, v25) << R_GEN_CONFIG__scsi0__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_GEN_CONFIG_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_GEN_CONFIG.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_GEN_CONFIG_(f1_,v1,f2_,v2,f3_,v3,f4_,v4,f5_,v5,f6_,v6,f7_,v7,f8_,v8,f9_,v9,f10_,v10,f11_,v11,f12_,v12,f13_,v13,f14_,v14,f15_,v15,f16_,v16,f17_,v17,f18_,v18,f19_,v19,f20_,v20,f21_,v21,f22_,v22,f23_,v23,f24_,v24,f25_,v25) ( \
  (R_GEN_CONFIG__par_w__##f1_##_VAL(R_GEN_CONFIG_, par_w_, v1) << R_GEN_CONFIG__par_w__BITNR) | \
  (R_GEN_CONFIG__usb2__##f2_##_VAL(R_GEN_CONFIG_, usb2_, v2) << R_GEN_CONFIG__usb2__BITNR) | \
  (R_GEN_CONFIG__usb1__##f3_##_VAL(R_GEN_CONFIG_, usb1_, v3) << R_GEN_CONFIG__usb1__BITNR) | \
  (R_GEN_CONFIG__g24dir__##f4_##_VAL(R_GEN_CONFIG_, g24dir_, v4) << R_GEN_CONFIG__g24dir__BITNR) | \
  (R_GEN_CONFIG__g16_23dir__##f5_##_VAL(R_GEN_CONFIG_, g16_23dir_, v5) << R_GEN_CONFIG__g16_23dir__BITNR) | \
  (R_GEN_CONFIG__g8_15dir__##f6_##_VAL(R_GEN_CONFIG_, g8_15dir_, v6) << R_GEN_CONFIG__g8_15dir__BITNR) | \
  (R_GEN_CONFIG__g0dir__##f7_##_VAL(R_GEN_CONFIG_, g0dir_, v7) << R_GEN_CONFIG__g0dir__BITNR) | \
  (R_GEN_CONFIG__dma9__##f8_##_VAL(R_GEN_CONFIG_, dma9_, v8) << R_GEN_CONFIG__dma9__BITNR) | \
  (R_GEN_CONFIG__dma8__##f9_##_VAL(R_GEN_CONFIG_, dma8_, v9) << R_GEN_CONFIG__dma8__BITNR) | \
  (R_GEN_CONFIG__dma7__##f10_##_VAL(R_GEN_CONFIG_, dma7_, v10) << R_GEN_CONFIG__dma7__BITNR) | \
  (R_GEN_CONFIG__dma6__##f11_##_VAL(R_GEN_CONFIG_, dma6_, v11) << R_GEN_CONFIG__dma6__BITNR) | \
  (R_GEN_CONFIG__dma5__##f12_##_VAL(R_GEN_CONFIG_, dma5_, v12) << R_GEN_CONFIG__dma5__BITNR) | \
  (R_GEN_CONFIG__dma4__##f13_##_VAL(R_GEN_CONFIG_, dma4_, v13) << R_GEN_CONFIG__dma4__BITNR) | \
  (R_GEN_CONFIG__dma3__##f14_##_VAL(R_GEN_CONFIG_, dma3_, v14) << R_GEN_CONFIG__dma3__BITNR) | \
  (R_GEN_CONFIG__dma2__##f15_##_VAL(R_GEN_CONFIG_, dma2_, v15) << R_GEN_CONFIG__dma2__BITNR) | \
  (R_GEN_CONFIG__mio_w__##f16_##_VAL(R_GEN_CONFIG_, mio_w_, v16) << R_GEN_CONFIG__mio_w__BITNR) | \
  (R_GEN_CONFIG__ser3__##f17_##_VAL(R_GEN_CONFIG_, ser3_, v17) << R_GEN_CONFIG__ser3__BITNR) | \
  (R_GEN_CONFIG__par1__##f18_##_VAL(R_GEN_CONFIG_, par1_, v18) << R_GEN_CONFIG__par1__BITNR) | \
  (R_GEN_CONFIG__scsi0w__##f19_##_VAL(R_GEN_CONFIG_, scsi0w_, v19) << R_GEN_CONFIG__scsi0w__BITNR) | \
  (R_GEN_CONFIG__scsi1__##f20_##_VAL(R_GEN_CONFIG_, scsi1_, v20) << R_GEN_CONFIG__scsi1__BITNR) | \
  (R_GEN_CONFIG__mio__##f21_##_VAL(R_GEN_CONFIG_, mio_, v21) << R_GEN_CONFIG__mio__BITNR) | \
  (R_GEN_CONFIG__ser2__##f22_##_VAL(R_GEN_CONFIG_, ser2_, v22) << R_GEN_CONFIG__ser2__BITNR) | \
  (R_GEN_CONFIG__par0__##f23_##_VAL(R_GEN_CONFIG_, par0_, v23) << R_GEN_CONFIG__par0__BITNR) | \
  (R_GEN_CONFIG__ata__##f24_##_VAL(R_GEN_CONFIG_, ata_, v24) << R_GEN_CONFIG__ata__BITNR) | \
  (R_GEN_CONFIG__scsi0__##f25_##_VAL(R_GEN_CONFIG_, scsi0_, v25) << R_GEN_CONFIG__scsi0__BITNR) \
)

#endif

/*
 *  R_GEN_CONFIG_II
 *  - type:  WO
 *  - addr:  0xb0000034
 *  - group: General config registers
 */

#if USE_GROUP__General_config_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_GEN_CONFIG_II
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_GEN_CONFIG_II.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_GEN_CONFIG_II. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_GEN_CONFIG_II(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5) ( \
  *R_GEN_CONFIG_II__SADDR = ( \
    REG_INITIATED(R_GEN_CONFIG_II_) \
    REG_VAL__R_GEN_CONFIG_II_(f1##_,v1,f2##_,v2,f3##_,v3,f4##_,v4,f5##_,v5) \
  ), \
  R_GEN_CONFIG_II__WRITE(R_GEN_CONFIG_II__ADDR, *R_GEN_CONFIG_II__SADDR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_GEN_CONFIG_II__SHADOW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_GEN_CONFIG_II.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in the 
*#               shadow register for R_GEN_CONFIG_II. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_GEN_CONFIG_II__SHADOW(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5) ( \
  *R_GEN_CONFIG_II__SADDR = ( \
    REG_INITIATED(R_GEN_CONFIG_II_) \
    REG_VAL__R_GEN_CONFIG_II_(f1##_,v1,f2##_,v2,f3##_,v3,f4##_,v4,f5##_,v5) \
  ) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_GEN_CONFIG_II
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_GEN_CONFIG_II(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5) ( \
  (R_GEN_CONFIG_II__sermode3__##f1##__MASK & REG__##v1) | \
  (R_GEN_CONFIG_II__sermode1__##f2##__MASK & REG__##v2) | \
  (R_GEN_CONFIG_II__ext_clk__##f3##__MASK & REG__##v3) | \
  (R_GEN_CONFIG_II__ser3__##f4##__MASK & REG__##v4) | \
  (R_GEN_CONFIG_II__ser2__##f5##__MASK & REG__##v5) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_GEN_CONFIG_II
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_GEN_CONFIG_II.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_GEN_CONFIG_II(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5) ( \
  (R_GEN_CONFIG_II__sermode3__##f1##__VAL(R_GEN_CONFIG_II_, sermode3_, v1) << R_GEN_CONFIG_II__sermode3__BITNR) | \
  (R_GEN_CONFIG_II__sermode1__##f2##__VAL(R_GEN_CONFIG_II_, sermode1_, v2) << R_GEN_CONFIG_II__sermode1__BITNR) | \
  (R_GEN_CONFIG_II__ext_clk__##f3##__VAL(R_GEN_CONFIG_II_, ext_clk_, v3) << R_GEN_CONFIG_II__ext_clk__BITNR) | \
  (R_GEN_CONFIG_II__ser3__##f4##__VAL(R_GEN_CONFIG_II_, ser3_, v4) << R_GEN_CONFIG_II__ser3__BITNR) | \
  (R_GEN_CONFIG_II__ser2__##f5##__VAL(R_GEN_CONFIG_II_, ser2_, v5) << R_GEN_CONFIG_II__ser2__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_GEN_CONFIG_II_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_GEN_CONFIG_II.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_GEN_CONFIG_II_(f1_,v1,f2_,v2,f3_,v3,f4_,v4,f5_,v5) ( \
  (R_GEN_CONFIG_II__sermode3__##f1_##_VAL(R_GEN_CONFIG_II_, sermode3_, v1) << R_GEN_CONFIG_II__sermode3__BITNR) | \
  (R_GEN_CONFIG_II__sermode1__##f2_##_VAL(R_GEN_CONFIG_II_, sermode1_, v2) << R_GEN_CONFIG_II__sermode1__BITNR) | \
  (R_GEN_CONFIG_II__ext_clk__##f3_##_VAL(R_GEN_CONFIG_II_, ext_clk_, v3) << R_GEN_CONFIG_II__ext_clk__BITNR) | \
  (R_GEN_CONFIG_II__ser3__##f4_##_VAL(R_GEN_CONFIG_II_, ser3_, v4) << R_GEN_CONFIG_II__ser3__BITNR) | \
  (R_GEN_CONFIG_II__ser2__##f5_##_VAL(R_GEN_CONFIG_II_, ser2_, v5) << R_GEN_CONFIG_II__ser2__BITNR) \
)

#endif

/*
 *  R_IRQ_MASK0_CLR
 *  - type:  WO
 *  - addr:  0xb00000c0
 *  - group: Interrupt mask and status registers
 */

#if USE_GROUP__Interrupt_mask_and_status_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_IRQ_MASK0_CLR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_IRQ_MASK0_CLR.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_IRQ_MASK0_CLR. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_IRQ_MASK0_CLR(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11,f12,v12,f13,v13,f14,v14,f15,v15,f16,v16,f17,v17,f18,v18,f19,v19,f20,v20,f21,v21,f22,v22,f23,v23,f24,v24,f25,v25,f26,v26,f27,v27,f28,v28,f29,v29,f30,v30,f31,v31) ( \
  *R_IRQ_MASK0_CLR__SADDR = ( \
    REG_INITIATED(R_IRQ_MASK0_CLR_) \
    REG_VAL__R_IRQ_MASK0_CLR_(f1##_,v1,f2##_,v2,f3##_,v3,f4##_,v4,f5##_,v5,f6##_,v6,f7##_,v7,f8##_,v8,f9##_,v9,f10##_,v10,f11##_,v11,f12##_,v12,f13##_,v13,f14##_,v14,f15##_,v15,f16##_,v16,f17##_,v17,f18##_,v18,f19##_,v19,f20##_,v20,f21##_,v21,f22##_,v22,f23##_,v23,f24##_,v24,f25##_,v25,f26##_,v26,f27##_,v27,f28##_,v28,f29##_,v29,f30##_,v30,f31##_,v31) \
  ), \
  R_IRQ_MASK0_CLR__WRITE(R_IRQ_MASK0_CLR__ADDR, *R_IRQ_MASK0_CLR__SADDR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_IRQ_MASK0_CLR__SHADOW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_IRQ_MASK0_CLR.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in the 
*#               shadow register for R_IRQ_MASK0_CLR. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_IRQ_MASK0_CLR__SHADOW(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11,f12,v12,f13,v13,f14,v14,f15,v15,f16,v16,f17,v17,f18,v18,f19,v19,f20,v20,f21,v21,f22,v22,f23,v23,f24,v24,f25,v25,f26,v26,f27,v27,f28,v28,f29,v29,f30,v30,f31,v31) ( \
  *R_IRQ_MASK0_CLR__SADDR = ( \
    REG_INITIATED(R_IRQ_MASK0_CLR_) \
    REG_VAL__R_IRQ_MASK0_CLR_(f1##_,v1,f2##_,v2,f3##_,v3,f4##_,v4,f5##_,v5,f6##_,v6,f7##_,v7,f8##_,v8,f9##_,v9,f10##_,v10,f11##_,v11,f12##_,v12,f13##_,v13,f14##_,v14,f15##_,v15,f16##_,v16,f17##_,v17,f18##_,v18,f19##_,v19,f20##_,v20,f21##_,v21,f22##_,v22,f23##_,v23,f24##_,v24,f25##_,v25,f26##_,v26,f27##_,v27,f28##_,v28,f29##_,v29,f30##_,v30,f31##_,v31) \
  ) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_IRQ_MASK0_CLR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_IRQ_MASK0_CLR(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11,f12,v12,f13,v13,f14,v14,f15,v15,f16,v16,f17,v17,f18,v18,f19,v19,f20,v20,f21,v21,f22,v22,f23,v23,f24,v24,f25,v25,f26,v26,f27,v27,f28,v28,f29,v29,f30,v30,f31,v31) ( \
  (R_IRQ_MASK0_CLR__nmi_pin__##f1##__MASK & REG__##v1) | \
  (R_IRQ_MASK0_CLR__watchdog_nmi__##f2##__MASK & REG__##v2) | \
  (R_IRQ_MASK0_CLR__sqe_test_error__##f3##__MASK & REG__##v3) | \
  (R_IRQ_MASK0_CLR__carrier_loss__##f4##__MASK & REG__##v4) | \
  (R_IRQ_MASK0_CLR__deferred__##f5##__MASK & REG__##v5) | \
  (R_IRQ_MASK0_CLR__late_col__##f6##__MASK & REG__##v6) | \
  (R_IRQ_MASK0_CLR__multiple_col__##f7##__MASK & REG__##v7) | \
  (R_IRQ_MASK0_CLR__single_col__##f8##__MASK & REG__##v8) | \
  (R_IRQ_MASK0_CLR__congestion__##f9##__MASK & REG__##v9) | \
  (R_IRQ_MASK0_CLR__oversize__##f10##__MASK & REG__##v10) | \
  (R_IRQ_MASK0_CLR__alignment_error__##f11##__MASK & REG__##v11) | \
  (R_IRQ_MASK0_CLR__crc_error__##f12##__MASK & REG__##v12) | \
  (R_IRQ_MASK0_CLR__overrun__##f13##__MASK & REG__##v13) | \
  (R_IRQ_MASK0_CLR__underrun__##f14##__MASK & REG__##v14) | \
  (R_IRQ_MASK0_CLR__excessive_col__##f15##__MASK & REG__##v15) | \
  (R_IRQ_MASK0_CLR__mdio__##f16##__MASK & REG__##v16) | \
  (R_IRQ_MASK0_CLR__ata_drq3__##f17##__MASK & REG__##v17) | \
  (R_IRQ_MASK0_CLR__ata_drq2__##f18##__MASK & REG__##v18) | \
  (R_IRQ_MASK0_CLR__ata_drq1__##f19##__MASK & REG__##v19) | \
  (R_IRQ_MASK0_CLR__ata_drq0__##f20##__MASK & REG__##v20) | \
  (R_IRQ_MASK0_CLR__par0_ecp_cmd__##f21##__MASK & REG__##v21) | \
  (R_IRQ_MASK0_CLR__par0_peri__##f22##__MASK & REG__##v22) | \
  (R_IRQ_MASK0_CLR__par0_data__##f23##__MASK & REG__##v23) | \
  (R_IRQ_MASK0_CLR__par0_ready__##f24##__MASK & REG__##v24) | \
  (R_IRQ_MASK0_CLR__ata_dmaend__##f25##__MASK & REG__##v25) | \
  (R_IRQ_MASK0_CLR__irq_ext_vector_nr__##f26##__MASK & REG__##v26) | \
  (R_IRQ_MASK0_CLR__irq_int_vector_nr__##f27##__MASK & REG__##v27) | \
  (R_IRQ_MASK0_CLR__ext_dma1__##f28##__MASK & REG__##v28) | \
  (R_IRQ_MASK0_CLR__ext_dma0__##f29##__MASK & REG__##v29) | \
  (R_IRQ_MASK0_CLR__timer1__##f30##__MASK & REG__##v30) | \
  (R_IRQ_MASK0_CLR__timer0__##f31##__MASK & REG__##v31) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_IRQ_MASK0_CLR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_IRQ_MASK0_CLR.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_IRQ_MASK0_CLR(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11,f12,v12,f13,v13,f14,v14,f15,v15,f16,v16,f17,v17,f18,v18,f19,v19,f20,v20,f21,v21,f22,v22,f23,v23,f24,v24,f25,v25,f26,v26,f27,v27,f28,v28,f29,v29,f30,v30,f31,v31) ( \
  (R_IRQ_MASK0_CLR__nmi_pin__##f1##__VAL(R_IRQ_MASK0_CLR_, nmi_pin_, v1) << R_IRQ_MASK0_CLR__nmi_pin__BITNR) | \
  (R_IRQ_MASK0_CLR__watchdog_nmi__##f2##__VAL(R_IRQ_MASK0_CLR_, watchdog_nmi_, v2) << R_IRQ_MASK0_CLR__watchdog_nmi__BITNR) | \
  (R_IRQ_MASK0_CLR__sqe_test_error__##f3##__VAL(R_IRQ_MASK0_CLR_, sqe_test_error_, v3) << R_IRQ_MASK0_CLR__sqe_test_error__BITNR) | \
  (R_IRQ_MASK0_CLR__carrier_loss__##f4##__VAL(R_IRQ_MASK0_CLR_, carrier_loss_, v4) << R_IRQ_MASK0_CLR__carrier_loss__BITNR) | \
  (R_IRQ_MASK0_CLR__deferred__##f5##__VAL(R_IRQ_MASK0_CLR_, deferred_, v5) << R_IRQ_MASK0_CLR__deferred__BITNR) | \
  (R_IRQ_MASK0_CLR__late_col__##f6##__VAL(R_IRQ_MASK0_CLR_, late_col_, v6) << R_IRQ_MASK0_CLR__late_col__BITNR) | \
  (R_IRQ_MASK0_CLR__multiple_col__##f7##__VAL(R_IRQ_MASK0_CLR_, multiple_col_, v7) << R_IRQ_MASK0_CLR__multiple_col__BITNR) | \
  (R_IRQ_MASK0_CLR__single_col__##f8##__VAL(R_IRQ_MASK0_CLR_, single_col_, v8) << R_IRQ_MASK0_CLR__single_col__BITNR) | \
  (R_IRQ_MASK0_CLR__congestion__##f9##__VAL(R_IRQ_MASK0_CLR_, congestion_, v9) << R_IRQ_MASK0_CLR__congestion__BITNR) | \
  (R_IRQ_MASK0_CLR__oversize__##f10##__VAL(R_IRQ_MASK0_CLR_, oversize_, v10) << R_IRQ_MASK0_CLR__oversize__BITNR) | \
  (R_IRQ_MASK0_CLR__alignment_error__##f11##__VAL(R_IRQ_MASK0_CLR_, alignment_error_, v11) << R_IRQ_MASK0_CLR__alignment_error__BITNR) | \
  (R_IRQ_MASK0_CLR__crc_error__##f12##__VAL(R_IRQ_MASK0_CLR_, crc_error_, v12) << R_IRQ_MASK0_CLR__crc_error__BITNR) | \
  (R_IRQ_MASK0_CLR__overrun__##f13##__VAL(R_IRQ_MASK0_CLR_, overrun_, v13) << R_IRQ_MASK0_CLR__overrun__BITNR) | \
  (R_IRQ_MASK0_CLR__underrun__##f14##__VAL(R_IRQ_MASK0_CLR_, underrun_, v14) << R_IRQ_MASK0_CLR__underrun__BITNR) | \
  (R_IRQ_MASK0_CLR__excessive_col__##f15##__VAL(R_IRQ_MASK0_CLR_, excessive_col_, v15) << R_IRQ_MASK0_CLR__excessive_col__BITNR) | \
  (R_IRQ_MASK0_CLR__mdio__##f16##__VAL(R_IRQ_MASK0_CLR_, mdio_, v16) << R_IRQ_MASK0_CLR__mdio__BITNR) | \
  (R_IRQ_MASK0_CLR__ata_drq3__##f17##__VAL(R_IRQ_MASK0_CLR_, ata_drq3_, v17) << R_IRQ_MASK0_CLR__ata_drq3__BITNR) | \
  (R_IRQ_MASK0_CLR__ata_drq2__##f18##__VAL(R_IRQ_MASK0_CLR_, ata_drq2_, v18) << R_IRQ_MASK0_CLR__ata_drq2__BITNR) | \
  (R_IRQ_MASK0_CLR__ata_drq1__##f19##__VAL(R_IRQ_MASK0_CLR_, ata_drq1_, v19) << R_IRQ_MASK0_CLR__ata_drq1__BITNR) | \
  (R_IRQ_MASK0_CLR__ata_drq0__##f20##__VAL(R_IRQ_MASK0_CLR_, ata_drq0_, v20) << R_IRQ_MASK0_CLR__ata_drq0__BITNR) | \
  (R_IRQ_MASK0_CLR__par0_ecp_cmd__##f21##__VAL(R_IRQ_MASK0_CLR_, par0_ecp_cmd_, v21) << R_IRQ_MASK0_CLR__par0_ecp_cmd__BITNR) | \
  (R_IRQ_MASK0_CLR__par0_peri__##f22##__VAL(R_IRQ_MASK0_CLR_, par0_peri_, v22) << R_IRQ_MASK0_CLR__par0_peri__BITNR) | \
  (R_IRQ_MASK0_CLR__par0_data__##f23##__VAL(R_IRQ_MASK0_CLR_, par0_data_, v23) << R_IRQ_MASK0_CLR__par0_data__BITNR) | \
  (R_IRQ_MASK0_CLR__par0_ready__##f24##__VAL(R_IRQ_MASK0_CLR_, par0_ready_, v24) << R_IRQ_MASK0_CLR__par0_ready__BITNR) | \
  (R_IRQ_MASK0_CLR__ata_dmaend__##f25##__VAL(R_IRQ_MASK0_CLR_, ata_dmaend_, v25) << R_IRQ_MASK0_CLR__ata_dmaend__BITNR) | \
  (R_IRQ_MASK0_CLR__irq_ext_vector_nr__##f26##__VAL(R_IRQ_MASK0_CLR_, irq_ext_vector_nr_, v26) << R_IRQ_MASK0_CLR__irq_ext_vector_nr__BITNR) | \
  (R_IRQ_MASK0_CLR__irq_int_vector_nr__##f27##__VAL(R_IRQ_MASK0_CLR_, irq_int_vector_nr_, v27) << R_IRQ_MASK0_CLR__irq_int_vector_nr__BITNR) | \
  (R_IRQ_MASK0_CLR__ext_dma1__##f28##__VAL(R_IRQ_MASK0_CLR_, ext_dma1_, v28) << R_IRQ_MASK0_CLR__ext_dma1__BITNR) | \
  (R_IRQ_MASK0_CLR__ext_dma0__##f29##__VAL(R_IRQ_MASK0_CLR_, ext_dma0_, v29) << R_IRQ_MASK0_CLR__ext_dma0__BITNR) | \
  (R_IRQ_MASK0_CLR__timer1__##f30##__VAL(R_IRQ_MASK0_CLR_, timer1_, v30) << R_IRQ_MASK0_CLR__timer1__BITNR) | \
  (R_IRQ_MASK0_CLR__timer0__##f31##__VAL(R_IRQ_MASK0_CLR_, timer0_, v31) << R_IRQ_MASK0_CLR__timer0__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_IRQ_MASK0_CLR_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_IRQ_MASK0_CLR.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_IRQ_MASK0_CLR_(f1_,v1,f2_,v2,f3_,v3,f4_,v4,f5_,v5,f6_,v6,f7_,v7,f8_,v8,f9_,v9,f10_,v10,f11_,v11,f12_,v12,f13_,v13,f14_,v14,f15_,v15,f16_,v16,f17_,v17,f18_,v18,f19_,v19,f20_,v20,f21_,v21,f22_,v22,f23_,v23,f24_,v24,f25_,v25,f26_,v26,f27_,v27,f28_,v28,f29_,v29,f30_,v30,f31_,v31) ( \
  (R_IRQ_MASK0_CLR__nmi_pin__##f1_##_VAL(R_IRQ_MASK0_CLR_, nmi_pin_, v1) << R_IRQ_MASK0_CLR__nmi_pin__BITNR) | \
  (R_IRQ_MASK0_CLR__watchdog_nmi__##f2_##_VAL(R_IRQ_MASK0_CLR_, watchdog_nmi_, v2) << R_IRQ_MASK0_CLR__watchdog_nmi__BITNR) | \
  (R_IRQ_MASK0_CLR__sqe_test_error__##f3_##_VAL(R_IRQ_MASK0_CLR_, sqe_test_error_, v3) << R_IRQ_MASK0_CLR__sqe_test_error__BITNR) | \
  (R_IRQ_MASK0_CLR__carrier_loss__##f4_##_VAL(R_IRQ_MASK0_CLR_, carrier_loss_, v4) << R_IRQ_MASK0_CLR__carrier_loss__BITNR) | \
  (R_IRQ_MASK0_CLR__deferred__##f5_##_VAL(R_IRQ_MASK0_CLR_, deferred_, v5) << R_IRQ_MASK0_CLR__deferred__BITNR) | \
  (R_IRQ_MASK0_CLR__late_col__##f6_##_VAL(R_IRQ_MASK0_CLR_, late_col_, v6) << R_IRQ_MASK0_CLR__late_col__BITNR) | \
  (R_IRQ_MASK0_CLR__multiple_col__##f7_##_VAL(R_IRQ_MASK0_CLR_, multiple_col_, v7) << R_IRQ_MASK0_CLR__multiple_col__BITNR) | \
  (R_IRQ_MASK0_CLR__single_col__##f8_##_VAL(R_IRQ_MASK0_CLR_, single_col_, v8) << R_IRQ_MASK0_CLR__single_col__BITNR) | \
  (R_IRQ_MASK0_CLR__congestion__##f9_##_VAL(R_IRQ_MASK0_CLR_, congestion_, v9) << R_IRQ_MASK0_CLR__congestion__BITNR) | \
  (R_IRQ_MASK0_CLR__oversize__##f10_##_VAL(R_IRQ_MASK0_CLR_, oversize_, v10) << R_IRQ_MASK0_CLR__oversize__BITNR) | \
  (R_IRQ_MASK0_CLR__alignment_error__##f11_##_VAL(R_IRQ_MASK0_CLR_, alignment_error_, v11) << R_IRQ_MASK0_CLR__alignment_error__BITNR) | \
  (R_IRQ_MASK0_CLR__crc_error__##f12_##_VAL(R_IRQ_MASK0_CLR_, crc_error_, v12) << R_IRQ_MASK0_CLR__crc_error__BITNR) | \
  (R_IRQ_MASK0_CLR__overrun__##f13_##_VAL(R_IRQ_MASK0_CLR_, overrun_, v13) << R_IRQ_MASK0_CLR__overrun__BITNR) | \
  (R_IRQ_MASK0_CLR__underrun__##f14_##_VAL(R_IRQ_MASK0_CLR_, underrun_, v14) << R_IRQ_MASK0_CLR__underrun__BITNR) | \
  (R_IRQ_MASK0_CLR__excessive_col__##f15_##_VAL(R_IRQ_MASK0_CLR_, excessive_col_, v15) << R_IRQ_MASK0_CLR__excessive_col__BITNR) | \
  (R_IRQ_MASK0_CLR__mdio__##f16_##_VAL(R_IRQ_MASK0_CLR_, mdio_, v16) << R_IRQ_MASK0_CLR__mdio__BITNR) | \
  (R_IRQ_MASK0_CLR__ata_drq3__##f17_##_VAL(R_IRQ_MASK0_CLR_, ata_drq3_, v17) << R_IRQ_MASK0_CLR__ata_drq3__BITNR) | \
  (R_IRQ_MASK0_CLR__ata_drq2__##f18_##_VAL(R_IRQ_MASK0_CLR_, ata_drq2_, v18) << R_IRQ_MASK0_CLR__ata_drq2__BITNR) | \
  (R_IRQ_MASK0_CLR__ata_drq1__##f19_##_VAL(R_IRQ_MASK0_CLR_, ata_drq1_, v19) << R_IRQ_MASK0_CLR__ata_drq1__BITNR) | \
  (R_IRQ_MASK0_CLR__ata_drq0__##f20_##_VAL(R_IRQ_MASK0_CLR_, ata_drq0_, v20) << R_IRQ_MASK0_CLR__ata_drq0__BITNR) | \
  (R_IRQ_MASK0_CLR__par0_ecp_cmd__##f21_##_VAL(R_IRQ_MASK0_CLR_, par0_ecp_cmd_, v21) << R_IRQ_MASK0_CLR__par0_ecp_cmd__BITNR) | \
  (R_IRQ_MASK0_CLR__par0_peri__##f22_##_VAL(R_IRQ_MASK0_CLR_, par0_peri_, v22) << R_IRQ_MASK0_CLR__par0_peri__BITNR) | \
  (R_IRQ_MASK0_CLR__par0_data__##f23_##_VAL(R_IRQ_MASK0_CLR_, par0_data_, v23) << R_IRQ_MASK0_CLR__par0_data__BITNR) | \
  (R_IRQ_MASK0_CLR__par0_ready__##f24_##_VAL(R_IRQ_MASK0_CLR_, par0_ready_, v24) << R_IRQ_MASK0_CLR__par0_ready__BITNR) | \
  (R_IRQ_MASK0_CLR__ata_dmaend__##f25_##_VAL(R_IRQ_MASK0_CLR_, ata_dmaend_, v25) << R_IRQ_MASK0_CLR__ata_dmaend__BITNR) | \
  (R_IRQ_MASK0_CLR__irq_ext_vector_nr__##f26_##_VAL(R_IRQ_MASK0_CLR_, irq_ext_vector_nr_, v26) << R_IRQ_MASK0_CLR__irq_ext_vector_nr__BITNR) | \
  (R_IRQ_MASK0_CLR__irq_int_vector_nr__##f27_##_VAL(R_IRQ_MASK0_CLR_, irq_int_vector_nr_, v27) << R_IRQ_MASK0_CLR__irq_int_vector_nr__BITNR) | \
  (R_IRQ_MASK0_CLR__ext_dma1__##f28_##_VAL(R_IRQ_MASK0_CLR_, ext_dma1_, v28) << R_IRQ_MASK0_CLR__ext_dma1__BITNR) | \
  (R_IRQ_MASK0_CLR__ext_dma0__##f29_##_VAL(R_IRQ_MASK0_CLR_, ext_dma0_, v29) << R_IRQ_MASK0_CLR__ext_dma0__BITNR) | \
  (R_IRQ_MASK0_CLR__timer1__##f30_##_VAL(R_IRQ_MASK0_CLR_, timer1_, v30) << R_IRQ_MASK0_CLR__timer1__BITNR) | \
  (R_IRQ_MASK0_CLR__timer0__##f31_##_VAL(R_IRQ_MASK0_CLR_, timer0_, v31) << R_IRQ_MASK0_CLR__timer0__BITNR) \
)

#endif

/*
 *  R_IRQ_MASK0_RD
 *  - type:  RO
 *  - addr:  0xb00000c0
 *  - group: Interrupt mask and status registers
 */

#if USE_GROUP__Interrupt_mask_and_status_registers

/* No REG_SET__register-name for read only registers. */

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_IRQ_MASK0_RD
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_IRQ_MASK0_RD(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11,f12,v12,f13,v13,f14,v14,f15,v15,f16,v16,f17,v17,f18,v18,f19,v19,f20,v20,f21,v21,f22,v22,f23,v23,f24,v24,f25,v25,f26,v26,f27,v27,f28,v28,f29,v29,f30,v30,f31,v31) ( \
  (R_IRQ_MASK0_RD__nmi_pin__##f1##__MASK & REG__##v1) | \
  (R_IRQ_MASK0_RD__watchdog_nmi__##f2##__MASK & REG__##v2) | \
  (R_IRQ_MASK0_RD__sqe_test_error__##f3##__MASK & REG__##v3) | \
  (R_IRQ_MASK0_RD__carrier_loss__##f4##__MASK & REG__##v4) | \
  (R_IRQ_MASK0_RD__deferred__##f5##__MASK & REG__##v5) | \
  (R_IRQ_MASK0_RD__late_col__##f6##__MASK & REG__##v6) | \
  (R_IRQ_MASK0_RD__multiple_col__##f7##__MASK & REG__##v7) | \
  (R_IRQ_MASK0_RD__single_col__##f8##__MASK & REG__##v8) | \
  (R_IRQ_MASK0_RD__congestion__##f9##__MASK & REG__##v9) | \
  (R_IRQ_MASK0_RD__oversize__##f10##__MASK & REG__##v10) | \
  (R_IRQ_MASK0_RD__alignment_error__##f11##__MASK & REG__##v11) | \
  (R_IRQ_MASK0_RD__crc_error__##f12##__MASK & REG__##v12) | \
  (R_IRQ_MASK0_RD__overrun__##f13##__MASK & REG__##v13) | \
  (R_IRQ_MASK0_RD__underrun__##f14##__MASK & REG__##v14) | \
  (R_IRQ_MASK0_RD__excessive_col__##f15##__MASK & REG__##v15) | \
  (R_IRQ_MASK0_RD__mdio__##f16##__MASK & REG__##v16) | \
  (R_IRQ_MASK0_RD__ata_drq3__##f17##__MASK & REG__##v17) | \
  (R_IRQ_MASK0_RD__ata_drq2__##f18##__MASK & REG__##v18) | \
  (R_IRQ_MASK0_RD__ata_drq1__##f19##__MASK & REG__##v19) | \
  (R_IRQ_MASK0_RD__ata_drq0__##f20##__MASK & REG__##v20) | \
  (R_IRQ_MASK0_RD__par0_ecp_cmd__##f21##__MASK & REG__##v21) | \
  (R_IRQ_MASK0_RD__par0_peri__##f22##__MASK & REG__##v22) | \
  (R_IRQ_MASK0_RD__par0_data__##f23##__MASK & REG__##v23) | \
  (R_IRQ_MASK0_RD__par0_ready__##f24##__MASK & REG__##v24) | \
  (R_IRQ_MASK0_RD__ata_dmaend__##f25##__MASK & REG__##v25) | \
  (R_IRQ_MASK0_RD__irq_ext_vector_nr__##f26##__MASK & REG__##v26) | \
  (R_IRQ_MASK0_RD__irq_int_vector_nr__##f27##__MASK & REG__##v27) | \
  (R_IRQ_MASK0_RD__ext_dma1__##f28##__MASK & REG__##v28) | \
  (R_IRQ_MASK0_RD__ext_dma0__##f29##__MASK & REG__##v29) | \
  (R_IRQ_MASK0_RD__timer1__##f30##__MASK & REG__##v30) | \
  (R_IRQ_MASK0_RD__timer0__##f31##__MASK & REG__##v31) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_IRQ_MASK0_RD
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_IRQ_MASK0_RD.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_IRQ_MASK0_RD(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11,f12,v12,f13,v13,f14,v14,f15,v15,f16,v16,f17,v17,f18,v18,f19,v19,f20,v20,f21,v21,f22,v22,f23,v23,f24,v24,f25,v25,f26,v26,f27,v27,f28,v28,f29,v29,f30,v30,f31,v31) ( \
  (R_IRQ_MASK0_RD__nmi_pin__##f1##__VAL(R_IRQ_MASK0_RD_, nmi_pin_, v1) << R_IRQ_MASK0_RD__nmi_pin__BITNR) | \
  (R_IRQ_MASK0_RD__watchdog_nmi__##f2##__VAL(R_IRQ_MASK0_RD_, watchdog_nmi_, v2) << R_IRQ_MASK0_RD__watchdog_nmi__BITNR) | \
  (R_IRQ_MASK0_RD__sqe_test_error__##f3##__VAL(R_IRQ_MASK0_RD_, sqe_test_error_, v3) << R_IRQ_MASK0_RD__sqe_test_error__BITNR) | \
  (R_IRQ_MASK0_RD__carrier_loss__##f4##__VAL(R_IRQ_MASK0_RD_, carrier_loss_, v4) << R_IRQ_MASK0_RD__carrier_loss__BITNR) | \
  (R_IRQ_MASK0_RD__deferred__##f5##__VAL(R_IRQ_MASK0_RD_, deferred_, v5) << R_IRQ_MASK0_RD__deferred__BITNR) | \
  (R_IRQ_MASK0_RD__late_col__##f6##__VAL(R_IRQ_MASK0_RD_, late_col_, v6) << R_IRQ_MASK0_RD__late_col__BITNR) | \
  (R_IRQ_MASK0_RD__multiple_col__##f7##__VAL(R_IRQ_MASK0_RD_, multiple_col_, v7) << R_IRQ_MASK0_RD__multiple_col__BITNR) | \
  (R_IRQ_MASK0_RD__single_col__##f8##__VAL(R_IRQ_MASK0_RD_, single_col_, v8) << R_IRQ_MASK0_RD__single_col__BITNR) | \
  (R_IRQ_MASK0_RD__congestion__##f9##__VAL(R_IRQ_MASK0_RD_, congestion_, v9) << R_IRQ_MASK0_RD__congestion__BITNR) | \
  (R_IRQ_MASK0_RD__oversize__##f10##__VAL(R_IRQ_MASK0_RD_, oversize_, v10) << R_IRQ_MASK0_RD__oversize__BITNR) | \
  (R_IRQ_MASK0_RD__alignment_error__##f11##__VAL(R_IRQ_MASK0_RD_, alignment_error_, v11) << R_IRQ_MASK0_RD__alignment_error__BITNR) | \
  (R_IRQ_MASK0_RD__crc_error__##f12##__VAL(R_IRQ_MASK0_RD_, crc_error_, v12) << R_IRQ_MASK0_RD__crc_error__BITNR) | \
  (R_IRQ_MASK0_RD__overrun__##f13##__VAL(R_IRQ_MASK0_RD_, overrun_, v13) << R_IRQ_MASK0_RD__overrun__BITNR) | \
  (R_IRQ_MASK0_RD__underrun__##f14##__VAL(R_IRQ_MASK0_RD_, underrun_, v14) << R_IRQ_MASK0_RD__underrun__BITNR) | \
  (R_IRQ_MASK0_RD__excessive_col__##f15##__VAL(R_IRQ_MASK0_RD_, excessive_col_, v15) << R_IRQ_MASK0_RD__excessive_col__BITNR) | \
  (R_IRQ_MASK0_RD__mdio__##f16##__VAL(R_IRQ_MASK0_RD_, mdio_, v16) << R_IRQ_MASK0_RD__mdio__BITNR) | \
  (R_IRQ_MASK0_RD__ata_drq3__##f17##__VAL(R_IRQ_MASK0_RD_, ata_drq3_, v17) << R_IRQ_MASK0_RD__ata_drq3__BITNR) | \
  (R_IRQ_MASK0_RD__ata_drq2__##f18##__VAL(R_IRQ_MASK0_RD_, ata_drq2_, v18) << R_IRQ_MASK0_RD__ata_drq2__BITNR) | \
  (R_IRQ_MASK0_RD__ata_drq1__##f19##__VAL(R_IRQ_MASK0_RD_, ata_drq1_, v19) << R_IRQ_MASK0_RD__ata_drq1__BITNR) | \
  (R_IRQ_MASK0_RD__ata_drq0__##f20##__VAL(R_IRQ_MASK0_RD_, ata_drq0_, v20) << R_IRQ_MASK0_RD__ata_drq0__BITNR) | \
  (R_IRQ_MASK0_RD__par0_ecp_cmd__##f21##__VAL(R_IRQ_MASK0_RD_, par0_ecp_cmd_, v21) << R_IRQ_MASK0_RD__par0_ecp_cmd__BITNR) | \
  (R_IRQ_MASK0_RD__par0_peri__##f22##__VAL(R_IRQ_MASK0_RD_, par0_peri_, v22) << R_IRQ_MASK0_RD__par0_peri__BITNR) | \
  (R_IRQ_MASK0_RD__par0_data__##f23##__VAL(R_IRQ_MASK0_RD_, par0_data_, v23) << R_IRQ_MASK0_RD__par0_data__BITNR) | \
  (R_IRQ_MASK0_RD__par0_ready__##f24##__VAL(R_IRQ_MASK0_RD_, par0_ready_, v24) << R_IRQ_MASK0_RD__par0_ready__BITNR) | \
  (R_IRQ_MASK0_RD__ata_dmaend__##f25##__VAL(R_IRQ_MASK0_RD_, ata_dmaend_, v25) << R_IRQ_MASK0_RD__ata_dmaend__BITNR) | \
  (R_IRQ_MASK0_RD__irq_ext_vector_nr__##f26##__VAL(R_IRQ_MASK0_RD_, irq_ext_vector_nr_, v26) << R_IRQ_MASK0_RD__irq_ext_vector_nr__BITNR) | \
  (R_IRQ_MASK0_RD__irq_int_vector_nr__##f27##__VAL(R_IRQ_MASK0_RD_, irq_int_vector_nr_, v27) << R_IRQ_MASK0_RD__irq_int_vector_nr__BITNR) | \
  (R_IRQ_MASK0_RD__ext_dma1__##f28##__VAL(R_IRQ_MASK0_RD_, ext_dma1_, v28) << R_IRQ_MASK0_RD__ext_dma1__BITNR) | \
  (R_IRQ_MASK0_RD__ext_dma0__##f29##__VAL(R_IRQ_MASK0_RD_, ext_dma0_, v29) << R_IRQ_MASK0_RD__ext_dma0__BITNR) | \
  (R_IRQ_MASK0_RD__timer1__##f30##__VAL(R_IRQ_MASK0_RD_, timer1_, v30) << R_IRQ_MASK0_RD__timer1__BITNR) | \
  (R_IRQ_MASK0_RD__timer0__##f31##__VAL(R_IRQ_MASK0_RD_, timer0_, v31) << R_IRQ_MASK0_RD__timer0__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_IRQ_MASK0_RD_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_IRQ_MASK0_RD.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_IRQ_MASK0_RD_(f1_,v1,f2_,v2,f3_,v3,f4_,v4,f5_,v5,f6_,v6,f7_,v7,f8_,v8,f9_,v9,f10_,v10,f11_,v11,f12_,v12,f13_,v13,f14_,v14,f15_,v15,f16_,v16,f17_,v17,f18_,v18,f19_,v19,f20_,v20,f21_,v21,f22_,v22,f23_,v23,f24_,v24,f25_,v25,f26_,v26,f27_,v27,f28_,v28,f29_,v29,f30_,v30,f31_,v31) ( \
  (R_IRQ_MASK0_RD__nmi_pin__##f1_##_VAL(R_IRQ_MASK0_RD_, nmi_pin_, v1) << R_IRQ_MASK0_RD__nmi_pin__BITNR) | \
  (R_IRQ_MASK0_RD__watchdog_nmi__##f2_##_VAL(R_IRQ_MASK0_RD_, watchdog_nmi_, v2) << R_IRQ_MASK0_RD__watchdog_nmi__BITNR) | \
  (R_IRQ_MASK0_RD__sqe_test_error__##f3_##_VAL(R_IRQ_MASK0_RD_, sqe_test_error_, v3) << R_IRQ_MASK0_RD__sqe_test_error__BITNR) | \
  (R_IRQ_MASK0_RD__carrier_loss__##f4_##_VAL(R_IRQ_MASK0_RD_, carrier_loss_, v4) << R_IRQ_MASK0_RD__carrier_loss__BITNR) | \
  (R_IRQ_MASK0_RD__deferred__##f5_##_VAL(R_IRQ_MASK0_RD_, deferred_, v5) << R_IRQ_MASK0_RD__deferred__BITNR) | \
  (R_IRQ_MASK0_RD__late_col__##f6_##_VAL(R_IRQ_MASK0_RD_, late_col_, v6) << R_IRQ_MASK0_RD__late_col__BITNR) | \
  (R_IRQ_MASK0_RD__multiple_col__##f7_##_VAL(R_IRQ_MASK0_RD_, multiple_col_, v7) << R_IRQ_MASK0_RD__multiple_col__BITNR) | \
  (R_IRQ_MASK0_RD__single_col__##f8_##_VAL(R_IRQ_MASK0_RD_, single_col_, v8) << R_IRQ_MASK0_RD__single_col__BITNR) | \
  (R_IRQ_MASK0_RD__congestion__##f9_##_VAL(R_IRQ_MASK0_RD_, congestion_, v9) << R_IRQ_MASK0_RD__congestion__BITNR) | \
  (R_IRQ_MASK0_RD__oversize__##f10_##_VAL(R_IRQ_MASK0_RD_, oversize_, v10) << R_IRQ_MASK0_RD__oversize__BITNR) | \
  (R_IRQ_MASK0_RD__alignment_error__##f11_##_VAL(R_IRQ_MASK0_RD_, alignment_error_, v11) << R_IRQ_MASK0_RD__alignment_error__BITNR) | \
  (R_IRQ_MASK0_RD__crc_error__##f12_##_VAL(R_IRQ_MASK0_RD_, crc_error_, v12) << R_IRQ_MASK0_RD__crc_error__BITNR) | \
  (R_IRQ_MASK0_RD__overrun__##f13_##_VAL(R_IRQ_MASK0_RD_, overrun_, v13) << R_IRQ_MASK0_RD__overrun__BITNR) | \
  (R_IRQ_MASK0_RD__underrun__##f14_##_VAL(R_IRQ_MASK0_RD_, underrun_, v14) << R_IRQ_MASK0_RD__underrun__BITNR) | \
  (R_IRQ_MASK0_RD__excessive_col__##f15_##_VAL(R_IRQ_MASK0_RD_, excessive_col_, v15) << R_IRQ_MASK0_RD__excessive_col__BITNR) | \
  (R_IRQ_MASK0_RD__mdio__##f16_##_VAL(R_IRQ_MASK0_RD_, mdio_, v16) << R_IRQ_MASK0_RD__mdio__BITNR) | \
  (R_IRQ_MASK0_RD__ata_drq3__##f17_##_VAL(R_IRQ_MASK0_RD_, ata_drq3_, v17) << R_IRQ_MASK0_RD__ata_drq3__BITNR) | \
  (R_IRQ_MASK0_RD__ata_drq2__##f18_##_VAL(R_IRQ_MASK0_RD_, ata_drq2_, v18) << R_IRQ_MASK0_RD__ata_drq2__BITNR) | \
  (R_IRQ_MASK0_RD__ata_drq1__##f19_##_VAL(R_IRQ_MASK0_RD_, ata_drq1_, v19) << R_IRQ_MASK0_RD__ata_drq1__BITNR) | \
  (R_IRQ_MASK0_RD__ata_drq0__##f20_##_VAL(R_IRQ_MASK0_RD_, ata_drq0_, v20) << R_IRQ_MASK0_RD__ata_drq0__BITNR) | \
  (R_IRQ_MASK0_RD__par0_ecp_cmd__##f21_##_VAL(R_IRQ_MASK0_RD_, par0_ecp_cmd_, v21) << R_IRQ_MASK0_RD__par0_ecp_cmd__BITNR) | \
  (R_IRQ_MASK0_RD__par0_peri__##f22_##_VAL(R_IRQ_MASK0_RD_, par0_peri_, v22) << R_IRQ_MASK0_RD__par0_peri__BITNR) | \
  (R_IRQ_MASK0_RD__par0_data__##f23_##_VAL(R_IRQ_MASK0_RD_, par0_data_, v23) << R_IRQ_MASK0_RD__par0_data__BITNR) | \
  (R_IRQ_MASK0_RD__par0_ready__##f24_##_VAL(R_IRQ_MASK0_RD_, par0_ready_, v24) << R_IRQ_MASK0_RD__par0_ready__BITNR) | \
  (R_IRQ_MASK0_RD__ata_dmaend__##f25_##_VAL(R_IRQ_MASK0_RD_, ata_dmaend_, v25) << R_IRQ_MASK0_RD__ata_dmaend__BITNR) | \
  (R_IRQ_MASK0_RD__irq_ext_vector_nr__##f26_##_VAL(R_IRQ_MASK0_RD_, irq_ext_vector_nr_, v26) << R_IRQ_MASK0_RD__irq_ext_vector_nr__BITNR) | \
  (R_IRQ_MASK0_RD__irq_int_vector_nr__##f27_##_VAL(R_IRQ_MASK0_RD_, irq_int_vector_nr_, v27) << R_IRQ_MASK0_RD__irq_int_vector_nr__BITNR) | \
  (R_IRQ_MASK0_RD__ext_dma1__##f28_##_VAL(R_IRQ_MASK0_RD_, ext_dma1_, v28) << R_IRQ_MASK0_RD__ext_dma1__BITNR) | \
  (R_IRQ_MASK0_RD__ext_dma0__##f29_##_VAL(R_IRQ_MASK0_RD_, ext_dma0_, v29) << R_IRQ_MASK0_RD__ext_dma0__BITNR) | \
  (R_IRQ_MASK0_RD__timer1__##f30_##_VAL(R_IRQ_MASK0_RD_, timer1_, v30) << R_IRQ_MASK0_RD__timer1__BITNR) | \
  (R_IRQ_MASK0_RD__timer0__##f31_##_VAL(R_IRQ_MASK0_RD_, timer0_, v31) << R_IRQ_MASK0_RD__timer0__BITNR) \
)

#endif

/*
 *  R_IRQ_MASK0_SET
 *  - type:  WO
 *  - addr:  0xb00000c4
 *  - group: Interrupt mask and status registers
 */

#if USE_GROUP__Interrupt_mask_and_status_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_IRQ_MASK0_SET
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_IRQ_MASK0_SET.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_IRQ_MASK0_SET. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_IRQ_MASK0_SET(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11,f12,v12,f13,v13,f14,v14,f15,v15,f16,v16,f17,v17,f18,v18,f19,v19,f20,v20,f21,v21,f22,v22,f23,v23,f24,v24,f25,v25,f26,v26,f27,v27,f28,v28,f29,v29,f30,v30,f31,v31) ( \
  *R_IRQ_MASK0_SET__SADDR = ( \
    REG_INITIATED(R_IRQ_MASK0_SET_) \
    REG_VAL__R_IRQ_MASK0_SET_(f1##_,v1,f2##_,v2,f3##_,v3,f4##_,v4,f5##_,v5,f6##_,v6,f7##_,v7,f8##_,v8,f9##_,v9,f10##_,v10,f11##_,v11,f12##_,v12,f13##_,v13,f14##_,v14,f15##_,v15,f16##_,v16,f17##_,v17,f18##_,v18,f19##_,v19,f20##_,v20,f21##_,v21,f22##_,v22,f23##_,v23,f24##_,v24,f25##_,v25,f26##_,v26,f27##_,v27,f28##_,v28,f29##_,v29,f30##_,v30,f31##_,v31) \
  ), \
  R_IRQ_MASK0_SET__WRITE(R_IRQ_MASK0_SET__ADDR, *R_IRQ_MASK0_SET__SADDR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_IRQ_MASK0_SET__SHADOW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_IRQ_MASK0_SET.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in the 
*#               shadow register for R_IRQ_MASK0_SET. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_IRQ_MASK0_SET__SHADOW(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11,f12,v12,f13,v13,f14,v14,f15,v15,f16,v16,f17,v17,f18,v18,f19,v19,f20,v20,f21,v21,f22,v22,f23,v23,f24,v24,f25,v25,f26,v26,f27,v27,f28,v28,f29,v29,f30,v30,f31,v31) ( \
  *R_IRQ_MASK0_SET__SADDR = ( \
    REG_INITIATED(R_IRQ_MASK0_SET_) \
    REG_VAL__R_IRQ_MASK0_SET_(f1##_,v1,f2##_,v2,f3##_,v3,f4##_,v4,f5##_,v5,f6##_,v6,f7##_,v7,f8##_,v8,f9##_,v9,f10##_,v10,f11##_,v11,f12##_,v12,f13##_,v13,f14##_,v14,f15##_,v15,f16##_,v16,f17##_,v17,f18##_,v18,f19##_,v19,f20##_,v20,f21##_,v21,f22##_,v22,f23##_,v23,f24##_,v24,f25##_,v25,f26##_,v26,f27##_,v27,f28##_,v28,f29##_,v29,f30##_,v30,f31##_,v31) \
  ) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_IRQ_MASK0_SET
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_IRQ_MASK0_SET(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11,f12,v12,f13,v13,f14,v14,f15,v15,f16,v16,f17,v17,f18,v18,f19,v19,f20,v20,f21,v21,f22,v22,f23,v23,f24,v24,f25,v25,f26,v26,f27,v27,f28,v28,f29,v29,f30,v30,f31,v31) ( \
  (R_IRQ_MASK0_SET__nmi_pin__##f1##__MASK & REG__##v1) | \
  (R_IRQ_MASK0_SET__watchdog_nmi__##f2##__MASK & REG__##v2) | \
  (R_IRQ_MASK0_SET__sqe_test_error__##f3##__MASK & REG__##v3) | \
  (R_IRQ_MASK0_SET__carrier_loss__##f4##__MASK & REG__##v4) | \
  (R_IRQ_MASK0_SET__deferred__##f5##__MASK & REG__##v5) | \
  (R_IRQ_MASK0_SET__late_col__##f6##__MASK & REG__##v6) | \
  (R_IRQ_MASK0_SET__multiple_col__##f7##__MASK & REG__##v7) | \
  (R_IRQ_MASK0_SET__single_col__##f8##__MASK & REG__##v8) | \
  (R_IRQ_MASK0_SET__congestion__##f9##__MASK & REG__##v9) | \
  (R_IRQ_MASK0_SET__oversize__##f10##__MASK & REG__##v10) | \
  (R_IRQ_MASK0_SET__alignment_error__##f11##__MASK & REG__##v11) | \
  (R_IRQ_MASK0_SET__crc_error__##f12##__MASK & REG__##v12) | \
  (R_IRQ_MASK0_SET__overrun__##f13##__MASK & REG__##v13) | \
  (R_IRQ_MASK0_SET__underrun__##f14##__MASK & REG__##v14) | \
  (R_IRQ_MASK0_SET__excessive_col__##f15##__MASK & REG__##v15) | \
  (R_IRQ_MASK0_SET__mdio__##f16##__MASK & REG__##v16) | \
  (R_IRQ_MASK0_SET__ata_drq3__##f17##__MASK & REG__##v17) | \
  (R_IRQ_MASK0_SET__ata_drq2__##f18##__MASK & REG__##v18) | \
  (R_IRQ_MASK0_SET__ata_drq1__##f19##__MASK & REG__##v19) | \
  (R_IRQ_MASK0_SET__ata_drq0__##f20##__MASK & REG__##v20) | \
  (R_IRQ_MASK0_SET__par0_ecp_cmd__##f21##__MASK & REG__##v21) | \
  (R_IRQ_MASK0_SET__par0_peri__##f22##__MASK & REG__##v22) | \
  (R_IRQ_MASK0_SET__par0_data__##f23##__MASK & REG__##v23) | \
  (R_IRQ_MASK0_SET__par0_ready__##f24##__MASK & REG__##v24) | \
  (R_IRQ_MASK0_SET__ata_dmaend__##f25##__MASK & REG__##v25) | \
  (R_IRQ_MASK0_SET__irq_ext_vector_nr__##f26##__MASK & REG__##v26) | \
  (R_IRQ_MASK0_SET__irq_int_vector_nr__##f27##__MASK & REG__##v27) | \
  (R_IRQ_MASK0_SET__ext_dma1__##f28##__MASK & REG__##v28) | \
  (R_IRQ_MASK0_SET__ext_dma0__##f29##__MASK & REG__##v29) | \
  (R_IRQ_MASK0_SET__timer1__##f30##__MASK & REG__##v30) | \
  (R_IRQ_MASK0_SET__timer0__##f31##__MASK & REG__##v31) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_IRQ_MASK0_SET
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_IRQ_MASK0_SET.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_IRQ_MASK0_SET(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11,f12,v12,f13,v13,f14,v14,f15,v15,f16,v16,f17,v17,f18,v18,f19,v19,f20,v20,f21,v21,f22,v22,f23,v23,f24,v24,f25,v25,f26,v26,f27,v27,f28,v28,f29,v29,f30,v30,f31,v31) ( \
  (R_IRQ_MASK0_SET__nmi_pin__##f1##__VAL(R_IRQ_MASK0_SET_, nmi_pin_, v1) << R_IRQ_MASK0_SET__nmi_pin__BITNR) | \
  (R_IRQ_MASK0_SET__watchdog_nmi__##f2##__VAL(R_IRQ_MASK0_SET_, watchdog_nmi_, v2) << R_IRQ_MASK0_SET__watchdog_nmi__BITNR) | \
  (R_IRQ_MASK0_SET__sqe_test_error__##f3##__VAL(R_IRQ_MASK0_SET_, sqe_test_error_, v3) << R_IRQ_MASK0_SET__sqe_test_error__BITNR) | \
  (R_IRQ_MASK0_SET__carrier_loss__##f4##__VAL(R_IRQ_MASK0_SET_, carrier_loss_, v4) << R_IRQ_MASK0_SET__carrier_loss__BITNR) | \
  (R_IRQ_MASK0_SET__deferred__##f5##__VAL(R_IRQ_MASK0_SET_, deferred_, v5) << R_IRQ_MASK0_SET__deferred__BITNR) | \
  (R_IRQ_MASK0_SET__late_col__##f6##__VAL(R_IRQ_MASK0_SET_, late_col_, v6) << R_IRQ_MASK0_SET__late_col__BITNR) | \
  (R_IRQ_MASK0_SET__multiple_col__##f7##__VAL(R_IRQ_MASK0_SET_, multiple_col_, v7) << R_IRQ_MASK0_SET__multiple_col__BITNR) | \
  (R_IRQ_MASK0_SET__single_col__##f8##__VAL(R_IRQ_MASK0_SET_, single_col_, v8) << R_IRQ_MASK0_SET__single_col__BITNR) | \
  (R_IRQ_MASK0_SET__congestion__##f9##__VAL(R_IRQ_MASK0_SET_, congestion_, v9) << R_IRQ_MASK0_SET__congestion__BITNR) | \
  (R_IRQ_MASK0_SET__oversize__##f10##__VAL(R_IRQ_MASK0_SET_, oversize_, v10) << R_IRQ_MASK0_SET__oversize__BITNR) | \
  (R_IRQ_MASK0_SET__alignment_error__##f11##__VAL(R_IRQ_MASK0_SET_, alignment_error_, v11) << R_IRQ_MASK0_SET__alignment_error__BITNR) | \
  (R_IRQ_MASK0_SET__crc_error__##f12##__VAL(R_IRQ_MASK0_SET_, crc_error_, v12) << R_IRQ_MASK0_SET__crc_error__BITNR) | \
  (R_IRQ_MASK0_SET__overrun__##f13##__VAL(R_IRQ_MASK0_SET_, overrun_, v13) << R_IRQ_MASK0_SET__overrun__BITNR) | \
  (R_IRQ_MASK0_SET__underrun__##f14##__VAL(R_IRQ_MASK0_SET_, underrun_, v14) << R_IRQ_MASK0_SET__underrun__BITNR) | \
  (R_IRQ_MASK0_SET__excessive_col__##f15##__VAL(R_IRQ_MASK0_SET_, excessive_col_, v15) << R_IRQ_MASK0_SET__excessive_col__BITNR) | \
  (R_IRQ_MASK0_SET__mdio__##f16##__VAL(R_IRQ_MASK0_SET_, mdio_, v16) << R_IRQ_MASK0_SET__mdio__BITNR) | \
  (R_IRQ_MASK0_SET__ata_drq3__##f17##__VAL(R_IRQ_MASK0_SET_, ata_drq3_, v17) << R_IRQ_MASK0_SET__ata_drq3__BITNR) | \
  (R_IRQ_MASK0_SET__ata_drq2__##f18##__VAL(R_IRQ_MASK0_SET_, ata_drq2_, v18) << R_IRQ_MASK0_SET__ata_drq2__BITNR) | \
  (R_IRQ_MASK0_SET__ata_drq1__##f19##__VAL(R_IRQ_MASK0_SET_, ata_drq1_, v19) << R_IRQ_MASK0_SET__ata_drq1__BITNR) | \
  (R_IRQ_MASK0_SET__ata_drq0__##f20##__VAL(R_IRQ_MASK0_SET_, ata_drq0_, v20) << R_IRQ_MASK0_SET__ata_drq0__BITNR) | \
  (R_IRQ_MASK0_SET__par0_ecp_cmd__##f21##__VAL(R_IRQ_MASK0_SET_, par0_ecp_cmd_, v21) << R_IRQ_MASK0_SET__par0_ecp_cmd__BITNR) | \
  (R_IRQ_MASK0_SET__par0_peri__##f22##__VAL(R_IRQ_MASK0_SET_, par0_peri_, v22) << R_IRQ_MASK0_SET__par0_peri__BITNR) | \
  (R_IRQ_MASK0_SET__par0_data__##f23##__VAL(R_IRQ_MASK0_SET_, par0_data_, v23) << R_IRQ_MASK0_SET__par0_data__BITNR) | \
  (R_IRQ_MASK0_SET__par0_ready__##f24##__VAL(R_IRQ_MASK0_SET_, par0_ready_, v24) << R_IRQ_MASK0_SET__par0_ready__BITNR) | \
  (R_IRQ_MASK0_SET__ata_dmaend__##f25##__VAL(R_IRQ_MASK0_SET_, ata_dmaend_, v25) << R_IRQ_MASK0_SET__ata_dmaend__BITNR) | \
  (R_IRQ_MASK0_SET__irq_ext_vector_nr__##f26##__VAL(R_IRQ_MASK0_SET_, irq_ext_vector_nr_, v26) << R_IRQ_MASK0_SET__irq_ext_vector_nr__BITNR) | \
  (R_IRQ_MASK0_SET__irq_int_vector_nr__##f27##__VAL(R_IRQ_MASK0_SET_, irq_int_vector_nr_, v27) << R_IRQ_MASK0_SET__irq_int_vector_nr__BITNR) | \
  (R_IRQ_MASK0_SET__ext_dma1__##f28##__VAL(R_IRQ_MASK0_SET_, ext_dma1_, v28) << R_IRQ_MASK0_SET__ext_dma1__BITNR) | \
  (R_IRQ_MASK0_SET__ext_dma0__##f29##__VAL(R_IRQ_MASK0_SET_, ext_dma0_, v29) << R_IRQ_MASK0_SET__ext_dma0__BITNR) | \
  (R_IRQ_MASK0_SET__timer1__##f30##__VAL(R_IRQ_MASK0_SET_, timer1_, v30) << R_IRQ_MASK0_SET__timer1__BITNR) | \
  (R_IRQ_MASK0_SET__timer0__##f31##__VAL(R_IRQ_MASK0_SET_, timer0_, v31) << R_IRQ_MASK0_SET__timer0__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_IRQ_MASK0_SET_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_IRQ_MASK0_SET.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_IRQ_MASK0_SET_(f1_,v1,f2_,v2,f3_,v3,f4_,v4,f5_,v5,f6_,v6,f7_,v7,f8_,v8,f9_,v9,f10_,v10,f11_,v11,f12_,v12,f13_,v13,f14_,v14,f15_,v15,f16_,v16,f17_,v17,f18_,v18,f19_,v19,f20_,v20,f21_,v21,f22_,v22,f23_,v23,f24_,v24,f25_,v25,f26_,v26,f27_,v27,f28_,v28,f29_,v29,f30_,v30,f31_,v31) ( \
  (R_IRQ_MASK0_SET__nmi_pin__##f1_##_VAL(R_IRQ_MASK0_SET_, nmi_pin_, v1) << R_IRQ_MASK0_SET__nmi_pin__BITNR) | \
  (R_IRQ_MASK0_SET__watchdog_nmi__##f2_##_VAL(R_IRQ_MASK0_SET_, watchdog_nmi_, v2) << R_IRQ_MASK0_SET__watchdog_nmi__BITNR) | \
  (R_IRQ_MASK0_SET__sqe_test_error__##f3_##_VAL(R_IRQ_MASK0_SET_, sqe_test_error_, v3) << R_IRQ_MASK0_SET__sqe_test_error__BITNR) | \
  (R_IRQ_MASK0_SET__carrier_loss__##f4_##_VAL(R_IRQ_MASK0_SET_, carrier_loss_, v4) << R_IRQ_MASK0_SET__carrier_loss__BITNR) | \
  (R_IRQ_MASK0_SET__deferred__##f5_##_VAL(R_IRQ_MASK0_SET_, deferred_, v5) << R_IRQ_MASK0_SET__deferred__BITNR) | \
  (R_IRQ_MASK0_SET__late_col__##f6_##_VAL(R_IRQ_MASK0_SET_, late_col_, v6) << R_IRQ_MASK0_SET__late_col__BITNR) | \
  (R_IRQ_MASK0_SET__multiple_col__##f7_##_VAL(R_IRQ_MASK0_SET_, multiple_col_, v7) << R_IRQ_MASK0_SET__multiple_col__BITNR) | \
  (R_IRQ_MASK0_SET__single_col__##f8_##_VAL(R_IRQ_MASK0_SET_, single_col_, v8) << R_IRQ_MASK0_SET__single_col__BITNR) | \
  (R_IRQ_MASK0_SET__congestion__##f9_##_VAL(R_IRQ_MASK0_SET_, congestion_, v9) << R_IRQ_MASK0_SET__congestion__BITNR) | \
  (R_IRQ_MASK0_SET__oversize__##f10_##_VAL(R_IRQ_MASK0_SET_, oversize_, v10) << R_IRQ_MASK0_SET__oversize__BITNR) | \
  (R_IRQ_MASK0_SET__alignment_error__##f11_##_VAL(R_IRQ_MASK0_SET_, alignment_error_, v11) << R_IRQ_MASK0_SET__alignment_error__BITNR) | \
  (R_IRQ_MASK0_SET__crc_error__##f12_##_VAL(R_IRQ_MASK0_SET_, crc_error_, v12) << R_IRQ_MASK0_SET__crc_error__BITNR) | \
  (R_IRQ_MASK0_SET__overrun__##f13_##_VAL(R_IRQ_MASK0_SET_, overrun_, v13) << R_IRQ_MASK0_SET__overrun__BITNR) | \
  (R_IRQ_MASK0_SET__underrun__##f14_##_VAL(R_IRQ_MASK0_SET_, underrun_, v14) << R_IRQ_MASK0_SET__underrun__BITNR) | \
  (R_IRQ_MASK0_SET__excessive_col__##f15_##_VAL(R_IRQ_MASK0_SET_, excessive_col_, v15) << R_IRQ_MASK0_SET__excessive_col__BITNR) | \
  (R_IRQ_MASK0_SET__mdio__##f16_##_VAL(R_IRQ_MASK0_SET_, mdio_, v16) << R_IRQ_MASK0_SET__mdio__BITNR) | \
  (R_IRQ_MASK0_SET__ata_drq3__##f17_##_VAL(R_IRQ_MASK0_SET_, ata_drq3_, v17) << R_IRQ_MASK0_SET__ata_drq3__BITNR) | \
  (R_IRQ_MASK0_SET__ata_drq2__##f18_##_VAL(R_IRQ_MASK0_SET_, ata_drq2_, v18) << R_IRQ_MASK0_SET__ata_drq2__BITNR) | \
  (R_IRQ_MASK0_SET__ata_drq1__##f19_##_VAL(R_IRQ_MASK0_SET_, ata_drq1_, v19) << R_IRQ_MASK0_SET__ata_drq1__BITNR) | \
  (R_IRQ_MASK0_SET__ata_drq0__##f20_##_VAL(R_IRQ_MASK0_SET_, ata_drq0_, v20) << R_IRQ_MASK0_SET__ata_drq0__BITNR) | \
  (R_IRQ_MASK0_SET__par0_ecp_cmd__##f21_##_VAL(R_IRQ_MASK0_SET_, par0_ecp_cmd_, v21) << R_IRQ_MASK0_SET__par0_ecp_cmd__BITNR) | \
  (R_IRQ_MASK0_SET__par0_peri__##f22_##_VAL(R_IRQ_MASK0_SET_, par0_peri_, v22) << R_IRQ_MASK0_SET__par0_peri__BITNR) | \
  (R_IRQ_MASK0_SET__par0_data__##f23_##_VAL(R_IRQ_MASK0_SET_, par0_data_, v23) << R_IRQ_MASK0_SET__par0_data__BITNR) | \
  (R_IRQ_MASK0_SET__par0_ready__##f24_##_VAL(R_IRQ_MASK0_SET_, par0_ready_, v24) << R_IRQ_MASK0_SET__par0_ready__BITNR) | \
  (R_IRQ_MASK0_SET__ata_dmaend__##f25_##_VAL(R_IRQ_MASK0_SET_, ata_dmaend_, v25) << R_IRQ_MASK0_SET__ata_dmaend__BITNR) | \
  (R_IRQ_MASK0_SET__irq_ext_vector_nr__##f26_##_VAL(R_IRQ_MASK0_SET_, irq_ext_vector_nr_, v26) << R_IRQ_MASK0_SET__irq_ext_vector_nr__BITNR) | \
  (R_IRQ_MASK0_SET__irq_int_vector_nr__##f27_##_VAL(R_IRQ_MASK0_SET_, irq_int_vector_nr_, v27) << R_IRQ_MASK0_SET__irq_int_vector_nr__BITNR) | \
  (R_IRQ_MASK0_SET__ext_dma1__##f28_##_VAL(R_IRQ_MASK0_SET_, ext_dma1_, v28) << R_IRQ_MASK0_SET__ext_dma1__BITNR) | \
  (R_IRQ_MASK0_SET__ext_dma0__##f29_##_VAL(R_IRQ_MASK0_SET_, ext_dma0_, v29) << R_IRQ_MASK0_SET__ext_dma0__BITNR) | \
  (R_IRQ_MASK0_SET__timer1__##f30_##_VAL(R_IRQ_MASK0_SET_, timer1_, v30) << R_IRQ_MASK0_SET__timer1__BITNR) | \
  (R_IRQ_MASK0_SET__timer0__##f31_##_VAL(R_IRQ_MASK0_SET_, timer0_, v31) << R_IRQ_MASK0_SET__timer0__BITNR) \
)

#endif

/*
 *  R_IRQ_MASK1_CLR
 *  - type:  WO
 *  - addr:  0xb00000c8
 *  - group: Interrupt mask and status registers
 */

#if USE_GROUP__Interrupt_mask_and_status_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_IRQ_MASK1_CLR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_IRQ_MASK1_CLR.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_IRQ_MASK1_CLR. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_IRQ_MASK1_CLR(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11,f12,v12,f13,v13,f14,v14,f15,v15,f16,v16,f17,v17,f18,v18,f19,v19,f20,v20,f21,v21,f22,v22,f23,v23,f24,v24,f25,v25,f26,v26,f27,v27,f28,v28) ( \
  *R_IRQ_MASK1_CLR__SADDR = ( \
    REG_INITIATED(R_IRQ_MASK1_CLR_) \
    REG_VAL__R_IRQ_MASK1_CLR_(f1##_,v1,f2##_,v2,f3##_,v3,f4##_,v4,f5##_,v5,f6##_,v6,f7##_,v7,f8##_,v8,f9##_,v9,f10##_,v10,f11##_,v11,f12##_,v12,f13##_,v13,f14##_,v14,f15##_,v15,f16##_,v16,f17##_,v17,f18##_,v18,f19##_,v19,f20##_,v20,f21##_,v21,f22##_,v22,f23##_,v23,f24##_,v24,f25##_,v25,f26##_,v26,f27##_,v27,f28##_,v28) \
  ), \
  R_IRQ_MASK1_CLR__WRITE(R_IRQ_MASK1_CLR__ADDR, *R_IRQ_MASK1_CLR__SADDR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_IRQ_MASK1_CLR__SHADOW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_IRQ_MASK1_CLR.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in the 
*#               shadow register for R_IRQ_MASK1_CLR. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_IRQ_MASK1_CLR__SHADOW(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11,f12,v12,f13,v13,f14,v14,f15,v15,f16,v16,f17,v17,f18,v18,f19,v19,f20,v20,f21,v21,f22,v22,f23,v23,f24,v24,f25,v25,f26,v26,f27,v27,f28,v28) ( \
  *R_IRQ_MASK1_CLR__SADDR = ( \
    REG_INITIATED(R_IRQ_MASK1_CLR_) \
    REG_VAL__R_IRQ_MASK1_CLR_(f1##_,v1,f2##_,v2,f3##_,v3,f4##_,v4,f5##_,v5,f6##_,v6,f7##_,v7,f8##_,v8,f9##_,v9,f10##_,v10,f11##_,v11,f12##_,v12,f13##_,v13,f14##_,v14,f15##_,v15,f16##_,v16,f17##_,v17,f18##_,v18,f19##_,v19,f20##_,v20,f21##_,v21,f22##_,v22,f23##_,v23,f24##_,v24,f25##_,v25,f26##_,v26,f27##_,v27,f28##_,v28) \
  ) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_IRQ_MASK1_CLR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_IRQ_MASK1_CLR(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11,f12,v12,f13,v13,f14,v14,f15,v15,f16,v16,f17,v17,f18,v18,f19,v19,f20,v20,f21,v21,f22,v22,f23,v23,f24,v24,f25,v25,f26,v26,f27,v27,f28,v28) ( \
  (R_IRQ_MASK1_CLR__sw_int7__##f1##__MASK & REG__##v1) | \
  (R_IRQ_MASK1_CLR__sw_int6__##f2##__MASK & REG__##v2) | \
  (R_IRQ_MASK1_CLR__sw_int5__##f3##__MASK & REG__##v3) | \
  (R_IRQ_MASK1_CLR__sw_int4__##f4##__MASK & REG__##v4) | \
  (R_IRQ_MASK1_CLR__sw_int3__##f5##__MASK & REG__##v5) | \
  (R_IRQ_MASK1_CLR__sw_int2__##f6##__MASK & REG__##v6) | \
  (R_IRQ_MASK1_CLR__sw_int1__##f7##__MASK & REG__##v7) | \
  (R_IRQ_MASK1_CLR__sw_int0__##f8##__MASK & REG__##v8) | \
  (R_IRQ_MASK1_CLR__par1_ecp_cmd__##f9##__MASK & REG__##v9) | \
  (R_IRQ_MASK1_CLR__par1_peri__##f10##__MASK & REG__##v10) | \
  (R_IRQ_MASK1_CLR__par1_data__##f11##__MASK & REG__##v11) | \
  (R_IRQ_MASK1_CLR__par1_ready__##f12##__MASK & REG__##v12) | \
  (R_IRQ_MASK1_CLR__ser3_ready__##f13##__MASK & REG__##v13) | \
  (R_IRQ_MASK1_CLR__ser3_data__##f14##__MASK & REG__##v14) | \
  (R_IRQ_MASK1_CLR__ser2_ready__##f15##__MASK & REG__##v15) | \
  (R_IRQ_MASK1_CLR__ser2_data__##f16##__MASK & REG__##v16) | \
  (R_IRQ_MASK1_CLR__ser1_ready__##f17##__MASK & REG__##v17) | \
  (R_IRQ_MASK1_CLR__ser1_data__##f18##__MASK & REG__##v18) | \
  (R_IRQ_MASK1_CLR__ser0_ready__##f19##__MASK & REG__##v19) | \
  (R_IRQ_MASK1_CLR__ser0_data__##f20##__MASK & REG__##v20) | \
  (R_IRQ_MASK1_CLR__pa7__##f21##__MASK & REG__##v21) | \
  (R_IRQ_MASK1_CLR__pa6__##f22##__MASK & REG__##v22) | \
  (R_IRQ_MASK1_CLR__pa5__##f23##__MASK & REG__##v23) | \
  (R_IRQ_MASK1_CLR__pa4__##f24##__MASK & REG__##v24) | \
  (R_IRQ_MASK1_CLR__pa3__##f25##__MASK & REG__##v25) | \
  (R_IRQ_MASK1_CLR__pa2__##f26##__MASK & REG__##v26) | \
  (R_IRQ_MASK1_CLR__pa1__##f27##__MASK & REG__##v27) | \
  (R_IRQ_MASK1_CLR__pa0__##f28##__MASK & REG__##v28) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_IRQ_MASK1_CLR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_IRQ_MASK1_CLR.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_IRQ_MASK1_CLR(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11,f12,v12,f13,v13,f14,v14,f15,v15,f16,v16,f17,v17,f18,v18,f19,v19,f20,v20,f21,v21,f22,v22,f23,v23,f24,v24,f25,v25,f26,v26,f27,v27,f28,v28) ( \
  (R_IRQ_MASK1_CLR__sw_int7__##f1##__VAL(R_IRQ_MASK1_CLR_, sw_int7_, v1) << R_IRQ_MASK1_CLR__sw_int7__BITNR) | \
  (R_IRQ_MASK1_CLR__sw_int6__##f2##__VAL(R_IRQ_MASK1_CLR_, sw_int6_, v2) << R_IRQ_MASK1_CLR__sw_int6__BITNR) | \
  (R_IRQ_MASK1_CLR__sw_int5__##f3##__VAL(R_IRQ_MASK1_CLR_, sw_int5_, v3) << R_IRQ_MASK1_CLR__sw_int5__BITNR) | \
  (R_IRQ_MASK1_CLR__sw_int4__##f4##__VAL(R_IRQ_MASK1_CLR_, sw_int4_, v4) << R_IRQ_MASK1_CLR__sw_int4__BITNR) | \
  (R_IRQ_MASK1_CLR__sw_int3__##f5##__VAL(R_IRQ_MASK1_CLR_, sw_int3_, v5) << R_IRQ_MASK1_CLR__sw_int3__BITNR) | \
  (R_IRQ_MASK1_CLR__sw_int2__##f6##__VAL(R_IRQ_MASK1_CLR_, sw_int2_, v6) << R_IRQ_MASK1_CLR__sw_int2__BITNR) | \
  (R_IRQ_MASK1_CLR__sw_int1__##f7##__VAL(R_IRQ_MASK1_CLR_, sw_int1_, v7) << R_IRQ_MASK1_CLR__sw_int1__BITNR) | \
  (R_IRQ_MASK1_CLR__sw_int0__##f8##__VAL(R_IRQ_MASK1_CLR_, sw_int0_, v8) << R_IRQ_MASK1_CLR__sw_int0__BITNR) | \
  (R_IRQ_MASK1_CLR__par1_ecp_cmd__##f9##__VAL(R_IRQ_MASK1_CLR_, par1_ecp_cmd_, v9) << R_IRQ_MASK1_CLR__par1_ecp_cmd__BITNR) | \
  (R_IRQ_MASK1_CLR__par1_peri__##f10##__VAL(R_IRQ_MASK1_CLR_, par1_peri_, v10) << R_IRQ_MASK1_CLR__par1_peri__BITNR) | \
  (R_IRQ_MASK1_CLR__par1_data__##f11##__VAL(R_IRQ_MASK1_CLR_, par1_data_, v11) << R_IRQ_MASK1_CLR__par1_data__BITNR) | \
  (R_IRQ_MASK1_CLR__par1_ready__##f12##__VAL(R_IRQ_MASK1_CLR_, par1_ready_, v12) << R_IRQ_MASK1_CLR__par1_ready__BITNR) | \
  (R_IRQ_MASK1_CLR__ser3_ready__##f13##__VAL(R_IRQ_MASK1_CLR_, ser3_ready_, v13) << R_IRQ_MASK1_CLR__ser3_ready__BITNR) | \
  (R_IRQ_MASK1_CLR__ser3_data__##f14##__VAL(R_IRQ_MASK1_CLR_, ser3_data_, v14) << R_IRQ_MASK1_CLR__ser3_data__BITNR) | \
  (R_IRQ_MASK1_CLR__ser2_ready__##f15##__VAL(R_IRQ_MASK1_CLR_, ser2_ready_, v15) << R_IRQ_MASK1_CLR__ser2_ready__BITNR) | \
  (R_IRQ_MASK1_CLR__ser2_data__##f16##__VAL(R_IRQ_MASK1_CLR_, ser2_data_, v16) << R_IRQ_MASK1_CLR__ser2_data__BITNR) | \
  (R_IRQ_MASK1_CLR__ser1_ready__##f17##__VAL(R_IRQ_MASK1_CLR_, ser1_ready_, v17) << R_IRQ_MASK1_CLR__ser1_ready__BITNR) | \
  (R_IRQ_MASK1_CLR__ser1_data__##f18##__VAL(R_IRQ_MASK1_CLR_, ser1_data_, v18) << R_IRQ_MASK1_CLR__ser1_data__BITNR) | \
  (R_IRQ_MASK1_CLR__ser0_ready__##f19##__VAL(R_IRQ_MASK1_CLR_, ser0_ready_, v19) << R_IRQ_MASK1_CLR__ser0_ready__BITNR) | \
  (R_IRQ_MASK1_CLR__ser0_data__##f20##__VAL(R_IRQ_MASK1_CLR_, ser0_data_, v20) << R_IRQ_MASK1_CLR__ser0_data__BITNR) | \
  (R_IRQ_MASK1_CLR__pa7__##f21##__VAL(R_IRQ_MASK1_CLR_, pa7_, v21) << R_IRQ_MASK1_CLR__pa7__BITNR) | \
  (R_IRQ_MASK1_CLR__pa6__##f22##__VAL(R_IRQ_MASK1_CLR_, pa6_, v22) << R_IRQ_MASK1_CLR__pa6__BITNR) | \
  (R_IRQ_MASK1_CLR__pa5__##f23##__VAL(R_IRQ_MASK1_CLR_, pa5_, v23) << R_IRQ_MASK1_CLR__pa5__BITNR) | \
  (R_IRQ_MASK1_CLR__pa4__##f24##__VAL(R_IRQ_MASK1_CLR_, pa4_, v24) << R_IRQ_MASK1_CLR__pa4__BITNR) | \
  (R_IRQ_MASK1_CLR__pa3__##f25##__VAL(R_IRQ_MASK1_CLR_, pa3_, v25) << R_IRQ_MASK1_CLR__pa3__BITNR) | \
  (R_IRQ_MASK1_CLR__pa2__##f26##__VAL(R_IRQ_MASK1_CLR_, pa2_, v26) << R_IRQ_MASK1_CLR__pa2__BITNR) | \
  (R_IRQ_MASK1_CLR__pa1__##f27##__VAL(R_IRQ_MASK1_CLR_, pa1_, v27) << R_IRQ_MASK1_CLR__pa1__BITNR) | \
  (R_IRQ_MASK1_CLR__pa0__##f28##__VAL(R_IRQ_MASK1_CLR_, pa0_, v28) << R_IRQ_MASK1_CLR__pa0__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_IRQ_MASK1_CLR_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_IRQ_MASK1_CLR.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_IRQ_MASK1_CLR_(f1_,v1,f2_,v2,f3_,v3,f4_,v4,f5_,v5,f6_,v6,f7_,v7,f8_,v8,f9_,v9,f10_,v10,f11_,v11,f12_,v12,f13_,v13,f14_,v14,f15_,v15,f16_,v16,f17_,v17,f18_,v18,f19_,v19,f20_,v20,f21_,v21,f22_,v22,f23_,v23,f24_,v24,f25_,v25,f26_,v26,f27_,v27,f28_,v28) ( \
  (R_IRQ_MASK1_CLR__sw_int7__##f1_##_VAL(R_IRQ_MASK1_CLR_, sw_int7_, v1) << R_IRQ_MASK1_CLR__sw_int7__BITNR) | \
  (R_IRQ_MASK1_CLR__sw_int6__##f2_##_VAL(R_IRQ_MASK1_CLR_, sw_int6_, v2) << R_IRQ_MASK1_CLR__sw_int6__BITNR) | \
  (R_IRQ_MASK1_CLR__sw_int5__##f3_##_VAL(R_IRQ_MASK1_CLR_, sw_int5_, v3) << R_IRQ_MASK1_CLR__sw_int5__BITNR) | \
  (R_IRQ_MASK1_CLR__sw_int4__##f4_##_VAL(R_IRQ_MASK1_CLR_, sw_int4_, v4) << R_IRQ_MASK1_CLR__sw_int4__BITNR) | \
  (R_IRQ_MASK1_CLR__sw_int3__##f5_##_VAL(R_IRQ_MASK1_CLR_, sw_int3_, v5) << R_IRQ_MASK1_CLR__sw_int3__BITNR) | \
  (R_IRQ_MASK1_CLR__sw_int2__##f6_##_VAL(R_IRQ_MASK1_CLR_, sw_int2_, v6) << R_IRQ_MASK1_CLR__sw_int2__BITNR) | \
  (R_IRQ_MASK1_CLR__sw_int1__##f7_##_VAL(R_IRQ_MASK1_CLR_, sw_int1_, v7) << R_IRQ_MASK1_CLR__sw_int1__BITNR) | \
  (R_IRQ_MASK1_CLR__sw_int0__##f8_##_VAL(R_IRQ_MASK1_CLR_, sw_int0_, v8) << R_IRQ_MASK1_CLR__sw_int0__BITNR) | \
  (R_IRQ_MASK1_CLR__par1_ecp_cmd__##f9_##_VAL(R_IRQ_MASK1_CLR_, par1_ecp_cmd_, v9) << R_IRQ_MASK1_CLR__par1_ecp_cmd__BITNR) | \
  (R_IRQ_MASK1_CLR__par1_peri__##f10_##_VAL(R_IRQ_MASK1_CLR_, par1_peri_, v10) << R_IRQ_MASK1_CLR__par1_peri__BITNR) | \
  (R_IRQ_MASK1_CLR__par1_data__##f11_##_VAL(R_IRQ_MASK1_CLR_, par1_data_, v11) << R_IRQ_MASK1_CLR__par1_data__BITNR) | \
  (R_IRQ_MASK1_CLR__par1_ready__##f12_##_VAL(R_IRQ_MASK1_CLR_, par1_ready_, v12) << R_IRQ_MASK1_CLR__par1_ready__BITNR) | \
  (R_IRQ_MASK1_CLR__ser3_ready__##f13_##_VAL(R_IRQ_MASK1_CLR_, ser3_ready_, v13) << R_IRQ_MASK1_CLR__ser3_ready__BITNR) | \
  (R_IRQ_MASK1_CLR__ser3_data__##f14_##_VAL(R_IRQ_MASK1_CLR_, ser3_data_, v14) << R_IRQ_MASK1_CLR__ser3_data__BITNR) | \
  (R_IRQ_MASK1_CLR__ser2_ready__##f15_##_VAL(R_IRQ_MASK1_CLR_, ser2_ready_, v15) << R_IRQ_MASK1_CLR__ser2_ready__BITNR) | \
  (R_IRQ_MASK1_CLR__ser2_data__##f16_##_VAL(R_IRQ_MASK1_CLR_, ser2_data_, v16) << R_IRQ_MASK1_CLR__ser2_data__BITNR) | \
  (R_IRQ_MASK1_CLR__ser1_ready__##f17_##_VAL(R_IRQ_MASK1_CLR_, ser1_ready_, v17) << R_IRQ_MASK1_CLR__ser1_ready__BITNR) | \
  (R_IRQ_MASK1_CLR__ser1_data__##f18_##_VAL(R_IRQ_MASK1_CLR_, ser1_data_, v18) << R_IRQ_MASK1_CLR__ser1_data__BITNR) | \
  (R_IRQ_MASK1_CLR__ser0_ready__##f19_##_VAL(R_IRQ_MASK1_CLR_, ser0_ready_, v19) << R_IRQ_MASK1_CLR__ser0_ready__BITNR) | \
  (R_IRQ_MASK1_CLR__ser0_data__##f20_##_VAL(R_IRQ_MASK1_CLR_, ser0_data_, v20) << R_IRQ_MASK1_CLR__ser0_data__BITNR) | \
  (R_IRQ_MASK1_CLR__pa7__##f21_##_VAL(R_IRQ_MASK1_CLR_, pa7_, v21) << R_IRQ_MASK1_CLR__pa7__BITNR) | \
  (R_IRQ_MASK1_CLR__pa6__##f22_##_VAL(R_IRQ_MASK1_CLR_, pa6_, v22) << R_IRQ_MASK1_CLR__pa6__BITNR) | \
  (R_IRQ_MASK1_CLR__pa5__##f23_##_VAL(R_IRQ_MASK1_CLR_, pa5_, v23) << R_IRQ_MASK1_CLR__pa5__BITNR) | \
  (R_IRQ_MASK1_CLR__pa4__##f24_##_VAL(R_IRQ_MASK1_CLR_, pa4_, v24) << R_IRQ_MASK1_CLR__pa4__BITNR) | \
  (R_IRQ_MASK1_CLR__pa3__##f25_##_VAL(R_IRQ_MASK1_CLR_, pa3_, v25) << R_IRQ_MASK1_CLR__pa3__BITNR) | \
  (R_IRQ_MASK1_CLR__pa2__##f26_##_VAL(R_IRQ_MASK1_CLR_, pa2_, v26) << R_IRQ_MASK1_CLR__pa2__BITNR) | \
  (R_IRQ_MASK1_CLR__pa1__##f27_##_VAL(R_IRQ_MASK1_CLR_, pa1_, v27) << R_IRQ_MASK1_CLR__pa1__BITNR) | \
  (R_IRQ_MASK1_CLR__pa0__##f28_##_VAL(R_IRQ_MASK1_CLR_, pa0_, v28) << R_IRQ_MASK1_CLR__pa0__BITNR) \
)

#endif

/*
 *  R_IRQ_MASK1_RD
 *  - type:  RO
 *  - addr:  0xb00000c8
 *  - group: Interrupt mask and status registers
 */

#if USE_GROUP__Interrupt_mask_and_status_registers

/* No REG_SET__register-name for read only registers. */

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_IRQ_MASK1_RD
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_IRQ_MASK1_RD(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11,f12,v12,f13,v13,f14,v14,f15,v15,f16,v16,f17,v17,f18,v18,f19,v19,f20,v20,f21,v21,f22,v22,f23,v23,f24,v24,f25,v25,f26,v26,f27,v27,f28,v28) ( \
  (R_IRQ_MASK1_RD__sw_int7__##f1##__MASK & REG__##v1) | \
  (R_IRQ_MASK1_RD__sw_int6__##f2##__MASK & REG__##v2) | \
  (R_IRQ_MASK1_RD__sw_int5__##f3##__MASK & REG__##v3) | \
  (R_IRQ_MASK1_RD__sw_int4__##f4##__MASK & REG__##v4) | \
  (R_IRQ_MASK1_RD__sw_int3__##f5##__MASK & REG__##v5) | \
  (R_IRQ_MASK1_RD__sw_int2__##f6##__MASK & REG__##v6) | \
  (R_IRQ_MASK1_RD__sw_int1__##f7##__MASK & REG__##v7) | \
  (R_IRQ_MASK1_RD__sw_int0__##f8##__MASK & REG__##v8) | \
  (R_IRQ_MASK1_RD__par1_ecp_cmd__##f9##__MASK & REG__##v9) | \
  (R_IRQ_MASK1_RD__par1_peri__##f10##__MASK & REG__##v10) | \
  (R_IRQ_MASK1_RD__par1_data__##f11##__MASK & REG__##v11) | \
  (R_IRQ_MASK1_RD__par1_ready__##f12##__MASK & REG__##v12) | \
  (R_IRQ_MASK1_RD__ser3_ready__##f13##__MASK & REG__##v13) | \
  (R_IRQ_MASK1_RD__ser3_data__##f14##__MASK & REG__##v14) | \
  (R_IRQ_MASK1_RD__ser2_ready__##f15##__MASK & REG__##v15) | \
  (R_IRQ_MASK1_RD__ser2_data__##f16##__MASK & REG__##v16) | \
  (R_IRQ_MASK1_RD__ser1_ready__##f17##__MASK & REG__##v17) | \
  (R_IRQ_MASK1_RD__ser1_data__##f18##__MASK & REG__##v18) | \
  (R_IRQ_MASK1_RD__ser0_ready__##f19##__MASK & REG__##v19) | \
  (R_IRQ_MASK1_RD__ser0_data__##f20##__MASK & REG__##v20) | \
  (R_IRQ_MASK1_RD__pa7__##f21##__MASK & REG__##v21) | \
  (R_IRQ_MASK1_RD__pa6__##f22##__MASK & REG__##v22) | \
  (R_IRQ_MASK1_RD__pa5__##f23##__MASK & REG__##v23) | \
  (R_IRQ_MASK1_RD__pa4__##f24##__MASK & REG__##v24) | \
  (R_IRQ_MASK1_RD__pa3__##f25##__MASK & REG__##v25) | \
  (R_IRQ_MASK1_RD__pa2__##f26##__MASK & REG__##v26) | \
  (R_IRQ_MASK1_RD__pa1__##f27##__MASK & REG__##v27) | \
  (R_IRQ_MASK1_RD__pa0__##f28##__MASK & REG__##v28) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_IRQ_MASK1_RD
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_IRQ_MASK1_RD.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_IRQ_MASK1_RD(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11,f12,v12,f13,v13,f14,v14,f15,v15,f16,v16,f17,v17,f18,v18,f19,v19,f20,v20,f21,v21,f22,v22,f23,v23,f24,v24,f25,v25,f26,v26,f27,v27,f28,v28) ( \
  (R_IRQ_MASK1_RD__sw_int7__##f1##__VAL(R_IRQ_MASK1_RD_, sw_int7_, v1) << R_IRQ_MASK1_RD__sw_int7__BITNR) | \
  (R_IRQ_MASK1_RD__sw_int6__##f2##__VAL(R_IRQ_MASK1_RD_, sw_int6_, v2) << R_IRQ_MASK1_RD__sw_int6__BITNR) | \
  (R_IRQ_MASK1_RD__sw_int5__##f3##__VAL(R_IRQ_MASK1_RD_, sw_int5_, v3) << R_IRQ_MASK1_RD__sw_int5__BITNR) | \
  (R_IRQ_MASK1_RD__sw_int4__##f4##__VAL(R_IRQ_MASK1_RD_, sw_int4_, v4) << R_IRQ_MASK1_RD__sw_int4__BITNR) | \
  (R_IRQ_MASK1_RD__sw_int3__##f5##__VAL(R_IRQ_MASK1_RD_, sw_int3_, v5) << R_IRQ_MASK1_RD__sw_int3__BITNR) | \
  (R_IRQ_MASK1_RD__sw_int2__##f6##__VAL(R_IRQ_MASK1_RD_, sw_int2_, v6) << R_IRQ_MASK1_RD__sw_int2__BITNR) | \
  (R_IRQ_MASK1_RD__sw_int1__##f7##__VAL(R_IRQ_MASK1_RD_, sw_int1_, v7) << R_IRQ_MASK1_RD__sw_int1__BITNR) | \
  (R_IRQ_MASK1_RD__sw_int0__##f8##__VAL(R_IRQ_MASK1_RD_, sw_int0_, v8) << R_IRQ_MASK1_RD__sw_int0__BITNR) | \
  (R_IRQ_MASK1_RD__par1_ecp_cmd__##f9##__VAL(R_IRQ_MASK1_RD_, par1_ecp_cmd_, v9) << R_IRQ_MASK1_RD__par1_ecp_cmd__BITNR) | \
  (R_IRQ_MASK1_RD__par1_peri__##f10##__VAL(R_IRQ_MASK1_RD_, par1_peri_, v10) << R_IRQ_MASK1_RD__par1_peri__BITNR) | \
  (R_IRQ_MASK1_RD__par1_data__##f11##__VAL(R_IRQ_MASK1_RD_, par1_data_, v11) << R_IRQ_MASK1_RD__par1_data__BITNR) | \
  (R_IRQ_MASK1_RD__par1_ready__##f12##__VAL(R_IRQ_MASK1_RD_, par1_ready_, v12) << R_IRQ_MASK1_RD__par1_ready__BITNR) | \
  (R_IRQ_MASK1_RD__ser3_ready__##f13##__VAL(R_IRQ_MASK1_RD_, ser3_ready_, v13) << R_IRQ_MASK1_RD__ser3_ready__BITNR) | \
  (R_IRQ_MASK1_RD__ser3_data__##f14##__VAL(R_IRQ_MASK1_RD_, ser3_data_, v14) << R_IRQ_MASK1_RD__ser3_data__BITNR) | \
  (R_IRQ_MASK1_RD__ser2_ready__##f15##__VAL(R_IRQ_MASK1_RD_, ser2_ready_, v15) << R_IRQ_MASK1_RD__ser2_ready__BITNR) | \
  (R_IRQ_MASK1_RD__ser2_data__##f16##__VAL(R_IRQ_MASK1_RD_, ser2_data_, v16) << R_IRQ_MASK1_RD__ser2_data__BITNR) | \
  (R_IRQ_MASK1_RD__ser1_ready__##f17##__VAL(R_IRQ_MASK1_RD_, ser1_ready_, v17) << R_IRQ_MASK1_RD__ser1_ready__BITNR) | \
  (R_IRQ_MASK1_RD__ser1_data__##f18##__VAL(R_IRQ_MASK1_RD_, ser1_data_, v18) << R_IRQ_MASK1_RD__ser1_data__BITNR) | \
  (R_IRQ_MASK1_RD__ser0_ready__##f19##__VAL(R_IRQ_MASK1_RD_, ser0_ready_, v19) << R_IRQ_MASK1_RD__ser0_ready__BITNR) | \
  (R_IRQ_MASK1_RD__ser0_data__##f20##__VAL(R_IRQ_MASK1_RD_, ser0_data_, v20) << R_IRQ_MASK1_RD__ser0_data__BITNR) | \
  (R_IRQ_MASK1_RD__pa7__##f21##__VAL(R_IRQ_MASK1_RD_, pa7_, v21) << R_IRQ_MASK1_RD__pa7__BITNR) | \
  (R_IRQ_MASK1_RD__pa6__##f22##__VAL(R_IRQ_MASK1_RD_, pa6_, v22) << R_IRQ_MASK1_RD__pa6__BITNR) | \
  (R_IRQ_MASK1_RD__pa5__##f23##__VAL(R_IRQ_MASK1_RD_, pa5_, v23) << R_IRQ_MASK1_RD__pa5__BITNR) | \
  (R_IRQ_MASK1_RD__pa4__##f24##__VAL(R_IRQ_MASK1_RD_, pa4_, v24) << R_IRQ_MASK1_RD__pa4__BITNR) | \
  (R_IRQ_MASK1_RD__pa3__##f25##__VAL(R_IRQ_MASK1_RD_, pa3_, v25) << R_IRQ_MASK1_RD__pa3__BITNR) | \
  (R_IRQ_MASK1_RD__pa2__##f26##__VAL(R_IRQ_MASK1_RD_, pa2_, v26) << R_IRQ_MASK1_RD__pa2__BITNR) | \
  (R_IRQ_MASK1_RD__pa1__##f27##__VAL(R_IRQ_MASK1_RD_, pa1_, v27) << R_IRQ_MASK1_RD__pa1__BITNR) | \
  (R_IRQ_MASK1_RD__pa0__##f28##__VAL(R_IRQ_MASK1_RD_, pa0_, v28) << R_IRQ_MASK1_RD__pa0__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_IRQ_MASK1_RD_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_IRQ_MASK1_RD.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_IRQ_MASK1_RD_(f1_,v1,f2_,v2,f3_,v3,f4_,v4,f5_,v5,f6_,v6,f7_,v7,f8_,v8,f9_,v9,f10_,v10,f11_,v11,f12_,v12,f13_,v13,f14_,v14,f15_,v15,f16_,v16,f17_,v17,f18_,v18,f19_,v19,f20_,v20,f21_,v21,f22_,v22,f23_,v23,f24_,v24,f25_,v25,f26_,v26,f27_,v27,f28_,v28) ( \
  (R_IRQ_MASK1_RD__sw_int7__##f1_##_VAL(R_IRQ_MASK1_RD_, sw_int7_, v1) << R_IRQ_MASK1_RD__sw_int7__BITNR) | \
  (R_IRQ_MASK1_RD__sw_int6__##f2_##_VAL(R_IRQ_MASK1_RD_, sw_int6_, v2) << R_IRQ_MASK1_RD__sw_int6__BITNR) | \
  (R_IRQ_MASK1_RD__sw_int5__##f3_##_VAL(R_IRQ_MASK1_RD_, sw_int5_, v3) << R_IRQ_MASK1_RD__sw_int5__BITNR) | \
  (R_IRQ_MASK1_RD__sw_int4__##f4_##_VAL(R_IRQ_MASK1_RD_, sw_int4_, v4) << R_IRQ_MASK1_RD__sw_int4__BITNR) | \
  (R_IRQ_MASK1_RD__sw_int3__##f5_##_VAL(R_IRQ_MASK1_RD_, sw_int3_, v5) << R_IRQ_MASK1_RD__sw_int3__BITNR) | \
  (R_IRQ_MASK1_RD__sw_int2__##f6_##_VAL(R_IRQ_MASK1_RD_, sw_int2_, v6) << R_IRQ_MASK1_RD__sw_int2__BITNR) | \
  (R_IRQ_MASK1_RD__sw_int1__##f7_##_VAL(R_IRQ_MASK1_RD_, sw_int1_, v7) << R_IRQ_MASK1_RD__sw_int1__BITNR) | \
  (R_IRQ_MASK1_RD__sw_int0__##f8_##_VAL(R_IRQ_MASK1_RD_, sw_int0_, v8) << R_IRQ_MASK1_RD__sw_int0__BITNR) | \
  (R_IRQ_MASK1_RD__par1_ecp_cmd__##f9_##_VAL(R_IRQ_MASK1_RD_, par1_ecp_cmd_, v9) << R_IRQ_MASK1_RD__par1_ecp_cmd__BITNR) | \
  (R_IRQ_MASK1_RD__par1_peri__##f10_##_VAL(R_IRQ_MASK1_RD_, par1_peri_, v10) << R_IRQ_MASK1_RD__par1_peri__BITNR) | \
  (R_IRQ_MASK1_RD__par1_data__##f11_##_VAL(R_IRQ_MASK1_RD_, par1_data_, v11) << R_IRQ_MASK1_RD__par1_data__BITNR) | \
  (R_IRQ_MASK1_RD__par1_ready__##f12_##_VAL(R_IRQ_MASK1_RD_, par1_ready_, v12) << R_IRQ_MASK1_RD__par1_ready__BITNR) | \
  (R_IRQ_MASK1_RD__ser3_ready__##f13_##_VAL(R_IRQ_MASK1_RD_, ser3_ready_, v13) << R_IRQ_MASK1_RD__ser3_ready__BITNR) | \
  (R_IRQ_MASK1_RD__ser3_data__##f14_##_VAL(R_IRQ_MASK1_RD_, ser3_data_, v14) << R_IRQ_MASK1_RD__ser3_data__BITNR) | \
  (R_IRQ_MASK1_RD__ser2_ready__##f15_##_VAL(R_IRQ_MASK1_RD_, ser2_ready_, v15) << R_IRQ_MASK1_RD__ser2_ready__BITNR) | \
  (R_IRQ_MASK1_RD__ser2_data__##f16_##_VAL(R_IRQ_MASK1_RD_, ser2_data_, v16) << R_IRQ_MASK1_RD__ser2_data__BITNR) | \
  (R_IRQ_MASK1_RD__ser1_ready__##f17_##_VAL(R_IRQ_MASK1_RD_, ser1_ready_, v17) << R_IRQ_MASK1_RD__ser1_ready__BITNR) | \
  (R_IRQ_MASK1_RD__ser1_data__##f18_##_VAL(R_IRQ_MASK1_RD_, ser1_data_, v18) << R_IRQ_MASK1_RD__ser1_data__BITNR) | \
  (R_IRQ_MASK1_RD__ser0_ready__##f19_##_VAL(R_IRQ_MASK1_RD_, ser0_ready_, v19) << R_IRQ_MASK1_RD__ser0_ready__BITNR) | \
  (R_IRQ_MASK1_RD__ser0_data__##f20_##_VAL(R_IRQ_MASK1_RD_, ser0_data_, v20) << R_IRQ_MASK1_RD__ser0_data__BITNR) | \
  (R_IRQ_MASK1_RD__pa7__##f21_##_VAL(R_IRQ_MASK1_RD_, pa7_, v21) << R_IRQ_MASK1_RD__pa7__BITNR) | \
  (R_IRQ_MASK1_RD__pa6__##f22_##_VAL(R_IRQ_MASK1_RD_, pa6_, v22) << R_IRQ_MASK1_RD__pa6__BITNR) | \
  (R_IRQ_MASK1_RD__pa5__##f23_##_VAL(R_IRQ_MASK1_RD_, pa5_, v23) << R_IRQ_MASK1_RD__pa5__BITNR) | \
  (R_IRQ_MASK1_RD__pa4__##f24_##_VAL(R_IRQ_MASK1_RD_, pa4_, v24) << R_IRQ_MASK1_RD__pa4__BITNR) | \
  (R_IRQ_MASK1_RD__pa3__##f25_##_VAL(R_IRQ_MASK1_RD_, pa3_, v25) << R_IRQ_MASK1_RD__pa3__BITNR) | \
  (R_IRQ_MASK1_RD__pa2__##f26_##_VAL(R_IRQ_MASK1_RD_, pa2_, v26) << R_IRQ_MASK1_RD__pa2__BITNR) | \
  (R_IRQ_MASK1_RD__pa1__##f27_##_VAL(R_IRQ_MASK1_RD_, pa1_, v27) << R_IRQ_MASK1_RD__pa1__BITNR) | \
  (R_IRQ_MASK1_RD__pa0__##f28_##_VAL(R_IRQ_MASK1_RD_, pa0_, v28) << R_IRQ_MASK1_RD__pa0__BITNR) \
)

#endif

/*
 *  R_IRQ_MASK1_SET
 *  - type:  WO
 *  - addr:  0xb00000cc
 *  - group: Interrupt mask and status registers
 */

#if USE_GROUP__Interrupt_mask_and_status_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_IRQ_MASK1_SET
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_IRQ_MASK1_SET.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_IRQ_MASK1_SET. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_IRQ_MASK1_SET(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11,f12,v12,f13,v13,f14,v14,f15,v15,f16,v16,f17,v17,f18,v18,f19,v19,f20,v20,f21,v21,f22,v22,f23,v23,f24,v24,f25,v25,f26,v26,f27,v27,f28,v28) ( \
  *R_IRQ_MASK1_SET__SADDR = ( \
    REG_INITIATED(R_IRQ_MASK1_SET_) \
    REG_VAL__R_IRQ_MASK1_SET_(f1##_,v1,f2##_,v2,f3##_,v3,f4##_,v4,f5##_,v5,f6##_,v6,f7##_,v7,f8##_,v8,f9##_,v9,f10##_,v10,f11##_,v11,f12##_,v12,f13##_,v13,f14##_,v14,f15##_,v15,f16##_,v16,f17##_,v17,f18##_,v18,f19##_,v19,f20##_,v20,f21##_,v21,f22##_,v22,f23##_,v23,f24##_,v24,f25##_,v25,f26##_,v26,f27##_,v27,f28##_,v28) \
  ), \
  R_IRQ_MASK1_SET__WRITE(R_IRQ_MASK1_SET__ADDR, *R_IRQ_MASK1_SET__SADDR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_IRQ_MASK1_SET__SHADOW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_IRQ_MASK1_SET.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in the 
*#               shadow register for R_IRQ_MASK1_SET. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_IRQ_MASK1_SET__SHADOW(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11,f12,v12,f13,v13,f14,v14,f15,v15,f16,v16,f17,v17,f18,v18,f19,v19,f20,v20,f21,v21,f22,v22,f23,v23,f24,v24,f25,v25,f26,v26,f27,v27,f28,v28) ( \
  *R_IRQ_MASK1_SET__SADDR = ( \
    REG_INITIATED(R_IRQ_MASK1_SET_) \
    REG_VAL__R_IRQ_MASK1_SET_(f1##_,v1,f2##_,v2,f3##_,v3,f4##_,v4,f5##_,v5,f6##_,v6,f7##_,v7,f8##_,v8,f9##_,v9,f10##_,v10,f11##_,v11,f12##_,v12,f13##_,v13,f14##_,v14,f15##_,v15,f16##_,v16,f17##_,v17,f18##_,v18,f19##_,v19,f20##_,v20,f21##_,v21,f22##_,v22,f23##_,v23,f24##_,v24,f25##_,v25,f26##_,v26,f27##_,v27,f28##_,v28) \
  ) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_IRQ_MASK1_SET
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_IRQ_MASK1_SET(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11,f12,v12,f13,v13,f14,v14,f15,v15,f16,v16,f17,v17,f18,v18,f19,v19,f20,v20,f21,v21,f22,v22,f23,v23,f24,v24,f25,v25,f26,v26,f27,v27,f28,v28) ( \
  (R_IRQ_MASK1_SET__sw_int7__##f1##__MASK & REG__##v1) | \
  (R_IRQ_MASK1_SET__sw_int6__##f2##__MASK & REG__##v2) | \
  (R_IRQ_MASK1_SET__sw_int5__##f3##__MASK & REG__##v3) | \
  (R_IRQ_MASK1_SET__sw_int4__##f4##__MASK & REG__##v4) | \
  (R_IRQ_MASK1_SET__sw_int3__##f5##__MASK & REG__##v5) | \
  (R_IRQ_MASK1_SET__sw_int2__##f6##__MASK & REG__##v6) | \
  (R_IRQ_MASK1_SET__sw_int1__##f7##__MASK & REG__##v7) | \
  (R_IRQ_MASK1_SET__sw_int0__##f8##__MASK & REG__##v8) | \
  (R_IRQ_MASK1_SET__par1_ecp_cmd__##f9##__MASK & REG__##v9) | \
  (R_IRQ_MASK1_SET__par1_peri__##f10##__MASK & REG__##v10) | \
  (R_IRQ_MASK1_SET__par1_data__##f11##__MASK & REG__##v11) | \
  (R_IRQ_MASK1_SET__par1_ready__##f12##__MASK & REG__##v12) | \
  (R_IRQ_MASK1_SET__ser3_ready__##f13##__MASK & REG__##v13) | \
  (R_IRQ_MASK1_SET__ser3_data__##f14##__MASK & REG__##v14) | \
  (R_IRQ_MASK1_SET__ser2_ready__##f15##__MASK & REG__##v15) | \
  (R_IRQ_MASK1_SET__ser2_data__##f16##__MASK & REG__##v16) | \
  (R_IRQ_MASK1_SET__ser1_ready__##f17##__MASK & REG__##v17) | \
  (R_IRQ_MASK1_SET__ser1_data__##f18##__MASK & REG__##v18) | \
  (R_IRQ_MASK1_SET__ser0_ready__##f19##__MASK & REG__##v19) | \
  (R_IRQ_MASK1_SET__ser0_data__##f20##__MASK & REG__##v20) | \
  (R_IRQ_MASK1_SET__pa7__##f21##__MASK & REG__##v21) | \
  (R_IRQ_MASK1_SET__pa6__##f22##__MASK & REG__##v22) | \
  (R_IRQ_MASK1_SET__pa5__##f23##__MASK & REG__##v23) | \
  (R_IRQ_MASK1_SET__pa4__##f24##__MASK & REG__##v24) | \
  (R_IRQ_MASK1_SET__pa3__##f25##__MASK & REG__##v25) | \
  (R_IRQ_MASK1_SET__pa2__##f26##__MASK & REG__##v26) | \
  (R_IRQ_MASK1_SET__pa1__##f27##__MASK & REG__##v27) | \
  (R_IRQ_MASK1_SET__pa0__##f28##__MASK & REG__##v28) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_IRQ_MASK1_SET
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_IRQ_MASK1_SET.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_IRQ_MASK1_SET(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11,f12,v12,f13,v13,f14,v14,f15,v15,f16,v16,f17,v17,f18,v18,f19,v19,f20,v20,f21,v21,f22,v22,f23,v23,f24,v24,f25,v25,f26,v26,f27,v27,f28,v28) ( \
  (R_IRQ_MASK1_SET__sw_int7__##f1##__VAL(R_IRQ_MASK1_SET_, sw_int7_, v1) << R_IRQ_MASK1_SET__sw_int7__BITNR) | \
  (R_IRQ_MASK1_SET__sw_int6__##f2##__VAL(R_IRQ_MASK1_SET_, sw_int6_, v2) << R_IRQ_MASK1_SET__sw_int6__BITNR) | \
  (R_IRQ_MASK1_SET__sw_int5__##f3##__VAL(R_IRQ_MASK1_SET_, sw_int5_, v3) << R_IRQ_MASK1_SET__sw_int5__BITNR) | \
  (R_IRQ_MASK1_SET__sw_int4__##f4##__VAL(R_IRQ_MASK1_SET_, sw_int4_, v4) << R_IRQ_MASK1_SET__sw_int4__BITNR) | \
  (R_IRQ_MASK1_SET__sw_int3__##f5##__VAL(R_IRQ_MASK1_SET_, sw_int3_, v5) << R_IRQ_MASK1_SET__sw_int3__BITNR) | \
  (R_IRQ_MASK1_SET__sw_int2__##f6##__VAL(R_IRQ_MASK1_SET_, sw_int2_, v6) << R_IRQ_MASK1_SET__sw_int2__BITNR) | \
  (R_IRQ_MASK1_SET__sw_int1__##f7##__VAL(R_IRQ_MASK1_SET_, sw_int1_, v7) << R_IRQ_MASK1_SET__sw_int1__BITNR) | \
  (R_IRQ_MASK1_SET__sw_int0__##f8##__VAL(R_IRQ_MASK1_SET_, sw_int0_, v8) << R_IRQ_MASK1_SET__sw_int0__BITNR) | \
  (R_IRQ_MASK1_SET__par1_ecp_cmd__##f9##__VAL(R_IRQ_MASK1_SET_, par1_ecp_cmd_, v9) << R_IRQ_MASK1_SET__par1_ecp_cmd__BITNR) | \
  (R_IRQ_MASK1_SET__par1_peri__##f10##__VAL(R_IRQ_MASK1_SET_, par1_peri_, v10) << R_IRQ_MASK1_SET__par1_peri__BITNR) | \
  (R_IRQ_MASK1_SET__par1_data__##f11##__VAL(R_IRQ_MASK1_SET_, par1_data_, v11) << R_IRQ_MASK1_SET__par1_data__BITNR) | \
  (R_IRQ_MASK1_SET__par1_ready__##f12##__VAL(R_IRQ_MASK1_SET_, par1_ready_, v12) << R_IRQ_MASK1_SET__par1_ready__BITNR) | \
  (R_IRQ_MASK1_SET__ser3_ready__##f13##__VAL(R_IRQ_MASK1_SET_, ser3_ready_, v13) << R_IRQ_MASK1_SET__ser3_ready__BITNR) | \
  (R_IRQ_MASK1_SET__ser3_data__##f14##__VAL(R_IRQ_MASK1_SET_, ser3_data_, v14) << R_IRQ_MASK1_SET__ser3_data__BITNR) | \
  (R_IRQ_MASK1_SET__ser2_ready__##f15##__VAL(R_IRQ_MASK1_SET_, ser2_ready_, v15) << R_IRQ_MASK1_SET__ser2_ready__BITNR) | \
  (R_IRQ_MASK1_SET__ser2_data__##f16##__VAL(R_IRQ_MASK1_SET_, ser2_data_, v16) << R_IRQ_MASK1_SET__ser2_data__BITNR) | \
  (R_IRQ_MASK1_SET__ser1_ready__##f17##__VAL(R_IRQ_MASK1_SET_, ser1_ready_, v17) << R_IRQ_MASK1_SET__ser1_ready__BITNR) | \
  (R_IRQ_MASK1_SET__ser1_data__##f18##__VAL(R_IRQ_MASK1_SET_, ser1_data_, v18) << R_IRQ_MASK1_SET__ser1_data__BITNR) | \
  (R_IRQ_MASK1_SET__ser0_ready__##f19##__VAL(R_IRQ_MASK1_SET_, ser0_ready_, v19) << R_IRQ_MASK1_SET__ser0_ready__BITNR) | \
  (R_IRQ_MASK1_SET__ser0_data__##f20##__VAL(R_IRQ_MASK1_SET_, ser0_data_, v20) << R_IRQ_MASK1_SET__ser0_data__BITNR) | \
  (R_IRQ_MASK1_SET__pa7__##f21##__VAL(R_IRQ_MASK1_SET_, pa7_, v21) << R_IRQ_MASK1_SET__pa7__BITNR) | \
  (R_IRQ_MASK1_SET__pa6__##f22##__VAL(R_IRQ_MASK1_SET_, pa6_, v22) << R_IRQ_MASK1_SET__pa6__BITNR) | \
  (R_IRQ_MASK1_SET__pa5__##f23##__VAL(R_IRQ_MASK1_SET_, pa5_, v23) << R_IRQ_MASK1_SET__pa5__BITNR) | \
  (R_IRQ_MASK1_SET__pa4__##f24##__VAL(R_IRQ_MASK1_SET_, pa4_, v24) << R_IRQ_MASK1_SET__pa4__BITNR) | \
  (R_IRQ_MASK1_SET__pa3__##f25##__VAL(R_IRQ_MASK1_SET_, pa3_, v25) << R_IRQ_MASK1_SET__pa3__BITNR) | \
  (R_IRQ_MASK1_SET__pa2__##f26##__VAL(R_IRQ_MASK1_SET_, pa2_, v26) << R_IRQ_MASK1_SET__pa2__BITNR) | \
  (R_IRQ_MASK1_SET__pa1__##f27##__VAL(R_IRQ_MASK1_SET_, pa1_, v27) << R_IRQ_MASK1_SET__pa1__BITNR) | \
  (R_IRQ_MASK1_SET__pa0__##f28##__VAL(R_IRQ_MASK1_SET_, pa0_, v28) << R_IRQ_MASK1_SET__pa0__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_IRQ_MASK1_SET_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_IRQ_MASK1_SET.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_IRQ_MASK1_SET_(f1_,v1,f2_,v2,f3_,v3,f4_,v4,f5_,v5,f6_,v6,f7_,v7,f8_,v8,f9_,v9,f10_,v10,f11_,v11,f12_,v12,f13_,v13,f14_,v14,f15_,v15,f16_,v16,f17_,v17,f18_,v18,f19_,v19,f20_,v20,f21_,v21,f22_,v22,f23_,v23,f24_,v24,f25_,v25,f26_,v26,f27_,v27,f28_,v28) ( \
  (R_IRQ_MASK1_SET__sw_int7__##f1_##_VAL(R_IRQ_MASK1_SET_, sw_int7_, v1) << R_IRQ_MASK1_SET__sw_int7__BITNR) | \
  (R_IRQ_MASK1_SET__sw_int6__##f2_##_VAL(R_IRQ_MASK1_SET_, sw_int6_, v2) << R_IRQ_MASK1_SET__sw_int6__BITNR) | \
  (R_IRQ_MASK1_SET__sw_int5__##f3_##_VAL(R_IRQ_MASK1_SET_, sw_int5_, v3) << R_IRQ_MASK1_SET__sw_int5__BITNR) | \
  (R_IRQ_MASK1_SET__sw_int4__##f4_##_VAL(R_IRQ_MASK1_SET_, sw_int4_, v4) << R_IRQ_MASK1_SET__sw_int4__BITNR) | \
  (R_IRQ_MASK1_SET__sw_int3__##f5_##_VAL(R_IRQ_MASK1_SET_, sw_int3_, v5) << R_IRQ_MASK1_SET__sw_int3__BITNR) | \
  (R_IRQ_MASK1_SET__sw_int2__##f6_##_VAL(R_IRQ_MASK1_SET_, sw_int2_, v6) << R_IRQ_MASK1_SET__sw_int2__BITNR) | \
  (R_IRQ_MASK1_SET__sw_int1__##f7_##_VAL(R_IRQ_MASK1_SET_, sw_int1_, v7) << R_IRQ_MASK1_SET__sw_int1__BITNR) | \
  (R_IRQ_MASK1_SET__sw_int0__##f8_##_VAL(R_IRQ_MASK1_SET_, sw_int0_, v8) << R_IRQ_MASK1_SET__sw_int0__BITNR) | \
  (R_IRQ_MASK1_SET__par1_ecp_cmd__##f9_##_VAL(R_IRQ_MASK1_SET_, par1_ecp_cmd_, v9) << R_IRQ_MASK1_SET__par1_ecp_cmd__BITNR) | \
  (R_IRQ_MASK1_SET__par1_peri__##f10_##_VAL(R_IRQ_MASK1_SET_, par1_peri_, v10) << R_IRQ_MASK1_SET__par1_peri__BITNR) | \
  (R_IRQ_MASK1_SET__par1_data__##f11_##_VAL(R_IRQ_MASK1_SET_, par1_data_, v11) << R_IRQ_MASK1_SET__par1_data__BITNR) | \
  (R_IRQ_MASK1_SET__par1_ready__##f12_##_VAL(R_IRQ_MASK1_SET_, par1_ready_, v12) << R_IRQ_MASK1_SET__par1_ready__BITNR) | \
  (R_IRQ_MASK1_SET__ser3_ready__##f13_##_VAL(R_IRQ_MASK1_SET_, ser3_ready_, v13) << R_IRQ_MASK1_SET__ser3_ready__BITNR) | \
  (R_IRQ_MASK1_SET__ser3_data__##f14_##_VAL(R_IRQ_MASK1_SET_, ser3_data_, v14) << R_IRQ_MASK1_SET__ser3_data__BITNR) | \
  (R_IRQ_MASK1_SET__ser2_ready__##f15_##_VAL(R_IRQ_MASK1_SET_, ser2_ready_, v15) << R_IRQ_MASK1_SET__ser2_ready__BITNR) | \
  (R_IRQ_MASK1_SET__ser2_data__##f16_##_VAL(R_IRQ_MASK1_SET_, ser2_data_, v16) << R_IRQ_MASK1_SET__ser2_data__BITNR) | \
  (R_IRQ_MASK1_SET__ser1_ready__##f17_##_VAL(R_IRQ_MASK1_SET_, ser1_ready_, v17) << R_IRQ_MASK1_SET__ser1_ready__BITNR) | \
  (R_IRQ_MASK1_SET__ser1_data__##f18_##_VAL(R_IRQ_MASK1_SET_, ser1_data_, v18) << R_IRQ_MASK1_SET__ser1_data__BITNR) | \
  (R_IRQ_MASK1_SET__ser0_ready__##f19_##_VAL(R_IRQ_MASK1_SET_, ser0_ready_, v19) << R_IRQ_MASK1_SET__ser0_ready__BITNR) | \
  (R_IRQ_MASK1_SET__ser0_data__##f20_##_VAL(R_IRQ_MASK1_SET_, ser0_data_, v20) << R_IRQ_MASK1_SET__ser0_data__BITNR) | \
  (R_IRQ_MASK1_SET__pa7__##f21_##_VAL(R_IRQ_MASK1_SET_, pa7_, v21) << R_IRQ_MASK1_SET__pa7__BITNR) | \
  (R_IRQ_MASK1_SET__pa6__##f22_##_VAL(R_IRQ_MASK1_SET_, pa6_, v22) << R_IRQ_MASK1_SET__pa6__BITNR) | \
  (R_IRQ_MASK1_SET__pa5__##f23_##_VAL(R_IRQ_MASK1_SET_, pa5_, v23) << R_IRQ_MASK1_SET__pa5__BITNR) | \
  (R_IRQ_MASK1_SET__pa4__##f24_##_VAL(R_IRQ_MASK1_SET_, pa4_, v24) << R_IRQ_MASK1_SET__pa4__BITNR) | \
  (R_IRQ_MASK1_SET__pa3__##f25_##_VAL(R_IRQ_MASK1_SET_, pa3_, v25) << R_IRQ_MASK1_SET__pa3__BITNR) | \
  (R_IRQ_MASK1_SET__pa2__##f26_##_VAL(R_IRQ_MASK1_SET_, pa2_, v26) << R_IRQ_MASK1_SET__pa2__BITNR) | \
  (R_IRQ_MASK1_SET__pa1__##f27_##_VAL(R_IRQ_MASK1_SET_, pa1_, v27) << R_IRQ_MASK1_SET__pa1__BITNR) | \
  (R_IRQ_MASK1_SET__pa0__##f28_##_VAL(R_IRQ_MASK1_SET_, pa0_, v28) << R_IRQ_MASK1_SET__pa0__BITNR) \
)

#endif

/*
 *  R_IRQ_MASK2_CLR
 *  - type:  WO
 *  - addr:  0xb00000d0
 *  - group: Interrupt mask and status registers
 */

#if USE_GROUP__Interrupt_mask_and_status_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_IRQ_MASK2_CLR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_IRQ_MASK2_CLR.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_IRQ_MASK2_CLR. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_IRQ_MASK2_CLR(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11,f12,v12,f13,v13,f14,v14,f15,v15,f16,v16,f17,v17,f18,v18,f19,v19,f20,v20,f21,v21,f22,v22,f23,v23,f24,v24) ( \
  *R_IRQ_MASK2_CLR__SADDR = ( \
    REG_INITIATED(R_IRQ_MASK2_CLR_) \
    REG_VAL__R_IRQ_MASK2_CLR_(f1##_,v1,f2##_,v2,f3##_,v3,f4##_,v4,f5##_,v5,f6##_,v6,f7##_,v7,f8##_,v8,f9##_,v9,f10##_,v10,f11##_,v11,f12##_,v12,f13##_,v13,f14##_,v14,f15##_,v15,f16##_,v16,f17##_,v17,f18##_,v18,f19##_,v19,f20##_,v20,f21##_,v21,f22##_,v22,f23##_,v23,f24##_,v24) \
  ), \
  R_IRQ_MASK2_CLR__WRITE(R_IRQ_MASK2_CLR__ADDR, *R_IRQ_MASK2_CLR__SADDR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_IRQ_MASK2_CLR__SHADOW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_IRQ_MASK2_CLR.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in the 
*#               shadow register for R_IRQ_MASK2_CLR. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_IRQ_MASK2_CLR__SHADOW(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11,f12,v12,f13,v13,f14,v14,f15,v15,f16,v16,f17,v17,f18,v18,f19,v19,f20,v20,f21,v21,f22,v22,f23,v23,f24,v24) ( \
  *R_IRQ_MASK2_CLR__SADDR = ( \
    REG_INITIATED(R_IRQ_MASK2_CLR_) \
    REG_VAL__R_IRQ_MASK2_CLR_(f1##_,v1,f2##_,v2,f3##_,v3,f4##_,v4,f5##_,v5,f6##_,v6,f7##_,v7,f8##_,v8,f9##_,v9,f10##_,v10,f11##_,v11,f12##_,v12,f13##_,v13,f14##_,v14,f15##_,v15,f16##_,v16,f17##_,v17,f18##_,v18,f19##_,v19,f20##_,v20,f21##_,v21,f22##_,v22,f23##_,v23,f24##_,v24) \
  ) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_IRQ_MASK2_CLR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_IRQ_MASK2_CLR(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11,f12,v12,f13,v13,f14,v14,f15,v15,f16,v16,f17,v17,f18,v18,f19,v19,f20,v20,f21,v21,f22,v22,f23,v23,f24,v24) ( \
  (R_IRQ_MASK2_CLR__dma8_sub3_descr__##f1##__MASK & REG__##v1) | \
  (R_IRQ_MASK2_CLR__dma8_sub2_descr__##f2##__MASK & REG__##v2) | \
  (R_IRQ_MASK2_CLR__dma8_sub1_descr__##f3##__MASK & REG__##v3) | \
  (R_IRQ_MASK2_CLR__dma8_sub0_descr__##f4##__MASK & REG__##v4) | \
  (R_IRQ_MASK2_CLR__dma9_eop__##f5##__MASK & REG__##v5) | \
  (R_IRQ_MASK2_CLR__dma9_descr__##f6##__MASK & REG__##v6) | \
  (R_IRQ_MASK2_CLR__dma8_eop__##f7##__MASK & REG__##v7) | \
  (R_IRQ_MASK2_CLR__dma8_descr__##f8##__MASK & REG__##v8) | \
  (R_IRQ_MASK2_CLR__dma7_eop__##f9##__MASK & REG__##v9) | \
  (R_IRQ_MASK2_CLR__dma7_descr__##f10##__MASK & REG__##v10) | \
  (R_IRQ_MASK2_CLR__dma6_eop__##f11##__MASK & REG__##v11) | \
  (R_IRQ_MASK2_CLR__dma6_descr__##f12##__MASK & REG__##v12) | \
  (R_IRQ_MASK2_CLR__dma5_eop__##f13##__MASK & REG__##v13) | \
  (R_IRQ_MASK2_CLR__dma5_descr__##f14##__MASK & REG__##v14) | \
  (R_IRQ_MASK2_CLR__dma4_eop__##f15##__MASK & REG__##v15) | \
  (R_IRQ_MASK2_CLR__dma4_descr__##f16##__MASK & REG__##v16) | \
  (R_IRQ_MASK2_CLR__dma3_eop__##f17##__MASK & REG__##v17) | \
  (R_IRQ_MASK2_CLR__dma3_descr__##f18##__MASK & REG__##v18) | \
  (R_IRQ_MASK2_CLR__dma2_eop__##f19##__MASK & REG__##v19) | \
  (R_IRQ_MASK2_CLR__dma2_descr__##f20##__MASK & REG__##v20) | \
  (R_IRQ_MASK2_CLR__dma1_eop__##f21##__MASK & REG__##v21) | \
  (R_IRQ_MASK2_CLR__dma1_descr__##f22##__MASK & REG__##v22) | \
  (R_IRQ_MASK2_CLR__dma0_eop__##f23##__MASK & REG__##v23) | \
  (R_IRQ_MASK2_CLR__dma0_descr__##f24##__MASK & REG__##v24) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_IRQ_MASK2_CLR
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_IRQ_MASK2_CLR.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_IRQ_MASK2_CLR(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11,f12,v12,f13,v13,f14,v14,f15,v15,f16,v16,f17,v17,f18,v18,f19,v19,f20,v20,f21,v21,f22,v22,f23,v23,f24,v24) ( \
  (R_IRQ_MASK2_CLR__dma8_sub3_descr__##f1##__VAL(R_IRQ_MASK2_CLR_, dma8_sub3_descr_, v1) << R_IRQ_MASK2_CLR__dma8_sub3_descr__BITNR) | \
  (R_IRQ_MASK2_CLR__dma8_sub2_descr__##f2##__VAL(R_IRQ_MASK2_CLR_, dma8_sub2_descr_, v2) << R_IRQ_MASK2_CLR__dma8_sub2_descr__BITNR) | \
  (R_IRQ_MASK2_CLR__dma8_sub1_descr__##f3##__VAL(R_IRQ_MASK2_CLR_, dma8_sub1_descr_, v3) << R_IRQ_MASK2_CLR__dma8_sub1_descr__BITNR) | \
  (R_IRQ_MASK2_CLR__dma8_sub0_descr__##f4##__VAL(R_IRQ_MASK2_CLR_, dma8_sub0_descr_, v4) << R_IRQ_MASK2_CLR__dma8_sub0_descr__BITNR) | \
  (R_IRQ_MASK2_CLR__dma9_eop__##f5##__VAL(R_IRQ_MASK2_CLR_, dma9_eop_, v5) << R_IRQ_MASK2_CLR__dma9_eop__BITNR) | \
  (R_IRQ_MASK2_CLR__dma9_descr__##f6##__VAL(R_IRQ_MASK2_CLR_, dma9_descr_, v6) << R_IRQ_MASK2_CLR__dma9_descr__BITNR) | \
  (R_IRQ_MASK2_CLR__dma8_eop__##f7##__VAL(R_IRQ_MASK2_CLR_, dma8_eop_, v7) << R_IRQ_MASK2_CLR__dma8_eop__BITNR) | \
  (R_IRQ_MASK2_CLR__dma8_descr__##f8##__VAL(R_IRQ_MASK2_CLR_, dma8_descr_, v8) << R_IRQ_MASK2_CLR__dma8_descr__BITNR) | \
  (R_IRQ_MASK2_CLR__dma7_eop__##f9##__VAL(R_IRQ_MASK2_CLR_, dma7_eop_, v9) << R_IRQ_MASK2_CLR__dma7_eop__BITNR) | \
  (R_IRQ_MASK2_CLR__dma7_descr__##f10##__VAL(R_IRQ_MASK2_CLR_, dma7_descr_, v10) << R_IRQ_MASK2_CLR__dma7_descr__BITNR) | \
  (R_IRQ_MASK2_CLR__dma6_eop__##f11##__VAL(R_IRQ_MASK2_CLR_, dma6_eop_, v11) << R_IRQ_MASK2_CLR__dma6_eop__BITNR) | \
  (R_IRQ_MASK2_CLR__dma6_descr__##f12##__VAL(R_IRQ_MASK2_CLR_, dma6_descr_, v12) << R_IRQ_MASK2_CLR__dma6_descr__BITNR) | \
  (R_IRQ_MASK2_CLR__dma5_eop__##f13##__VAL(R_IRQ_MASK2_CLR_, dma5_eop_, v13) << R_IRQ_MASK2_CLR__dma5_eop__BITNR) | \
  (R_IRQ_MASK2_CLR__dma5_descr__##f14##__VAL(R_IRQ_MASK2_CLR_, dma5_descr_, v14) << R_IRQ_MASK2_CLR__dma5_descr__BITNR) | \
  (R_IRQ_MASK2_CLR__dma4_eop__##f15##__VAL(R_IRQ_MASK2_CLR_, dma4_eop_, v15) << R_IRQ_MASK2_CLR__dma4_eop__BITNR) | \
  (R_IRQ_MASK2_CLR__dma4_descr__##f16##__VAL(R_IRQ_MASK2_CLR_, dma4_descr_, v16) << R_IRQ_MASK2_CLR__dma4_descr__BITNR) | \
  (R_IRQ_MASK2_CLR__dma3_eop__##f17##__VAL(R_IRQ_MASK2_CLR_, dma3_eop_, v17) << R_IRQ_MASK2_CLR__dma3_eop__BITNR) | \
  (R_IRQ_MASK2_CLR__dma3_descr__##f18##__VAL(R_IRQ_MASK2_CLR_, dma3_descr_, v18) << R_IRQ_MASK2_CLR__dma3_descr__BITNR) | \
  (R_IRQ_MASK2_CLR__dma2_eop__##f19##__VAL(R_IRQ_MASK2_CLR_, dma2_eop_, v19) << R_IRQ_MASK2_CLR__dma2_eop__BITNR) | \
  (R_IRQ_MASK2_CLR__dma2_descr__##f20##__VAL(R_IRQ_MASK2_CLR_, dma2_descr_, v20) << R_IRQ_MASK2_CLR__dma2_descr__BITNR) | \
  (R_IRQ_MASK2_CLR__dma1_eop__##f21##__VAL(R_IRQ_MASK2_CLR_, dma1_eop_, v21) << R_IRQ_MASK2_CLR__dma1_eop__BITNR) | \
  (R_IRQ_MASK2_CLR__dma1_descr__##f22##__VAL(R_IRQ_MASK2_CLR_, dma1_descr_, v22) << R_IRQ_MASK2_CLR__dma1_descr__BITNR) | \
  (R_IRQ_MASK2_CLR__dma0_eop__##f23##__VAL(R_IRQ_MASK2_CLR_, dma0_eop_, v23) << R_IRQ_MASK2_CLR__dma0_eop__BITNR) | \
  (R_IRQ_MASK2_CLR__dma0_descr__##f24##__VAL(R_IRQ_MASK2_CLR_, dma0_descr_, v24) << R_IRQ_MASK2_CLR__dma0_descr__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_IRQ_MASK2_CLR_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_IRQ_MASK2_CLR.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_IRQ_MASK2_CLR_(f1_,v1,f2_,v2,f3_,v3,f4_,v4,f5_,v5,f6_,v6,f7_,v7,f8_,v8,f9_,v9,f10_,v10,f11_,v11,f12_,v12,f13_,v13,f14_,v14,f15_,v15,f16_,v16,f17_,v17,f18_,v18,f19_,v19,f20_,v20,f21_,v21,f22_,v22,f23_,v23,f24_,v24) ( \
  (R_IRQ_MASK2_CLR__dma8_sub3_descr__##f1_##_VAL(R_IRQ_MASK2_CLR_, dma8_sub3_descr_, v1) << R_IRQ_MASK2_CLR__dma8_sub3_descr__BITNR) | \
  (R_IRQ_MASK2_CLR__dma8_sub2_descr__##f2_##_VAL(R_IRQ_MASK2_CLR_, dma8_sub2_descr_, v2) << R_IRQ_MASK2_CLR__dma8_sub2_descr__BITNR) | \
  (R_IRQ_MASK2_CLR__dma8_sub1_descr__##f3_##_VAL(R_IRQ_MASK2_CLR_, dma8_sub1_descr_, v3) << R_IRQ_MASK2_CLR__dma8_sub1_descr__BITNR) | \
  (R_IRQ_MASK2_CLR__dma8_sub0_descr__##f4_##_VAL(R_IRQ_MASK2_CLR_, dma8_sub0_descr_, v4) << R_IRQ_MASK2_CLR__dma8_sub0_descr__BITNR) | \
  (R_IRQ_MASK2_CLR__dma9_eop__##f5_##_VAL(R_IRQ_MASK2_CLR_, dma9_eop_, v5) << R_IRQ_MASK2_CLR__dma9_eop__BITNR) | \
  (R_IRQ_MASK2_CLR__dma9_descr__##f6_##_VAL(R_IRQ_MASK2_CLR_, dma9_descr_, v6) << R_IRQ_MASK2_CLR__dma9_descr__BITNR) | \
  (R_IRQ_MASK2_CLR__dma8_eop__##f7_##_VAL(R_IRQ_MASK2_CLR_, dma8_eop_, v7) << R_IRQ_MASK2_CLR__dma8_eop__BITNR) | \
  (R_IRQ_MASK2_CLR__dma8_descr__##f8_##_VAL(R_IRQ_MASK2_CLR_, dma8_descr_, v8) << R_IRQ_MASK2_CLR__dma8_descr__BITNR) | \
  (R_IRQ_MASK2_CLR__dma7_eop__##f9_##_VAL(R_IRQ_MASK2_CLR_, dma7_eop_, v9) << R_IRQ_MASK2_CLR__dma7_eop__BITNR) | \
  (R_IRQ_MASK2_CLR__dma7_descr__##f10_##_VAL(R_IRQ_MASK2_CLR_, dma7_descr_, v10) << R_IRQ_MASK2_CLR__dma7_descr__BITNR) | \
  (R_IRQ_MASK2_CLR__dma6_eop__##f11_##_VAL(R_IRQ_MASK2_CLR_, dma6_eop_, v11) << R_IRQ_MASK2_CLR__dma6_eop__BITNR) | \
  (R_IRQ_MASK2_CLR__dma6_descr__##f12_##_VAL(R_IRQ_MASK2_CLR_, dma6_descr_, v12) << R_IRQ_MASK2_CLR__dma6_descr__BITNR) | \
  (R_IRQ_MASK2_CLR__dma5_eop__##f13_##_VAL(R_IRQ_MASK2_CLR_, dma5_eop_, v13) << R_IRQ_MASK2_CLR__dma5_eop__BITNR) | \
  (R_IRQ_MASK2_CLR__dma5_descr__##f14_##_VAL(R_IRQ_MASK2_CLR_, dma5_descr_, v14) << R_IRQ_MASK2_CLR__dma5_descr__BITNR) | \
  (R_IRQ_MASK2_CLR__dma4_eop__##f15_##_VAL(R_IRQ_MASK2_CLR_, dma4_eop_, v15) << R_IRQ_MASK2_CLR__dma4_eop__BITNR) | \
  (R_IRQ_MASK2_CLR__dma4_descr__##f16_##_VAL(R_IRQ_MASK2_CLR_, dma4_descr_, v16) << R_IRQ_MASK2_CLR__dma4_descr__BITNR) | \
  (R_IRQ_MASK2_CLR__dma3_eop__##f17_##_VAL(R_IRQ_MASK2_CLR_, dma3_eop_, v17) << R_IRQ_MASK2_CLR__dma3_eop__BITNR) | \
  (R_IRQ_MASK2_CLR__dma3_descr__##f18_##_VAL(R_IRQ_MASK2_CLR_, dma3_descr_, v18) << R_IRQ_MASK2_CLR__dma3_descr__BITNR) | \
  (R_IRQ_MASK2_CLR__dma2_eop__##f19_##_VAL(R_IRQ_MASK2_CLR_, dma2_eop_, v19) << R_IRQ_MASK2_CLR__dma2_eop__BITNR) | \
  (R_IRQ_MASK2_CLR__dma2_descr__##f20_##_VAL(R_IRQ_MASK2_CLR_, dma2_descr_, v20) << R_IRQ_MASK2_CLR__dma2_descr__BITNR) | \
  (R_IRQ_MASK2_CLR__dma1_eop__##f21_##_VAL(R_IRQ_MASK2_CLR_, dma1_eop_, v21) << R_IRQ_MASK2_CLR__dma1_eop__BITNR) | \
  (R_IRQ_MASK2_CLR__dma1_descr__##f22_##_VAL(R_IRQ_MASK2_CLR_, dma1_descr_, v22) << R_IRQ_MASK2_CLR__dma1_descr__BITNR) | \
  (R_IRQ_MASK2_CLR__dma0_eop__##f23_##_VAL(R_IRQ_MASK2_CLR_, dma0_eop_, v23) << R_IRQ_MASK2_CLR__dma0_eop__BITNR) | \
  (R_IRQ_MASK2_CLR__dma0_descr__##f24_##_VAL(R_IRQ_MASK2_CLR_, dma0_descr_, v24) << R_IRQ_MASK2_CLR__dma0_descr__BITNR) \
)

#endif

/*
 *  R_IRQ_MASK2_RD
 *  - type:  RO
 *  - addr:  0xb00000d0
 *  - group: Interrupt mask and status registers
 */

#if USE_GROUP__Interrupt_mask_and_status_registers

/* No REG_SET__register-name for read only registers. */

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_IRQ_MASK2_RD
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_IRQ_MASK2_RD(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11,f12,v12,f13,v13,f14,v14,f15,v15,f16,v16,f17,v17,f18,v18,f19,v19,f20,v20,f21,v21,f22,v22,f23,v23,f24,v24) ( \
  (R_IRQ_MASK2_RD__dma8_sub3_descr__##f1##__MASK & REG__##v1) | \
  (R_IRQ_MASK2_RD__dma8_sub2_descr__##f2##__MASK & REG__##v2) | \
  (R_IRQ_MASK2_RD__dma8_sub1_descr__##f3##__MASK & REG__##v3) | \
  (R_IRQ_MASK2_RD__dma8_sub0_descr__##f4##__MASK & REG__##v4) | \
  (R_IRQ_MASK2_RD__dma9_eop__##f5##__MASK & REG__##v5) | \
  (R_IRQ_MASK2_RD__dma9_descr__##f6##__MASK & REG__##v6) | \
  (R_IRQ_MASK2_RD__dma8_eop__##f7##__MASK & REG__##v7) | \
  (R_IRQ_MASK2_RD__dma8_descr__##f8##__MASK & REG__##v8) | \
  (R_IRQ_MASK2_RD__dma7_eop__##f9##__MASK & REG__##v9) | \
  (R_IRQ_MASK2_RD__dma7_descr__##f10##__MASK & REG__##v10) | \
  (R_IRQ_MASK2_RD__dma6_eop__##f11##__MASK & REG__##v11) | \
  (R_IRQ_MASK2_RD__dma6_descr__##f12##__MASK & REG__##v12) | \
  (R_IRQ_MASK2_RD__dma5_eop__##f13##__MASK & REG__##v13) | \
  (R_IRQ_MASK2_RD__dma5_descr__##f14##__MASK & REG__##v14) | \
  (R_IRQ_MASK2_RD__dma4_eop__##f15##__MASK & REG__##v15) | \
  (R_IRQ_MASK2_RD__dma4_descr__##f16##__MASK & REG__##v16) | \
  (R_IRQ_MASK2_RD__dma3_eop__##f17##__MASK & REG__##v17) | \
  (R_IRQ_MASK2_RD__dma3_descr__##f18##__MASK & REG__##v18) | \
  (R_IRQ_MASK2_RD__dma2_eop__##f19##__MASK & REG__##v19) | \
  (R_IRQ_MASK2_RD__dma2_descr__##f20##__MASK & REG__##v20) | \
  (R_IRQ_MASK2_RD__dma1_eop__##f21##__MASK & REG__##v21) | \
  (R_IRQ_MASK2_RD__dma1_descr__##f22##__MASK & REG__##v22) | \
  (R_IRQ_MASK2_RD__dma0_eop__##f23##__MASK & REG__##v23) | \
  (R_IRQ_MASK2_RD__dma0_descr__##f24##__MASK & REG__##v24) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_IRQ_MASK2_RD
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_IRQ_MASK2_RD.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_IRQ_MASK2_RD(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11,f12,v12,f13,v13,f14,v14,f15,v15,f16,v16,f17,v17,f18,v18,f19,v19,f20,v20,f21,v21,f22,v22,f23,v23,f24,v24) ( \
  (R_IRQ_MASK2_RD__dma8_sub3_descr__##f1##__VAL(R_IRQ_MASK2_RD_, dma8_sub3_descr_, v1) << R_IRQ_MASK2_RD__dma8_sub3_descr__BITNR) | \
  (R_IRQ_MASK2_RD__dma8_sub2_descr__##f2##__VAL(R_IRQ_MASK2_RD_, dma8_sub2_descr_, v2) << R_IRQ_MASK2_RD__dma8_sub2_descr__BITNR) | \
  (R_IRQ_MASK2_RD__dma8_sub1_descr__##f3##__VAL(R_IRQ_MASK2_RD_, dma8_sub1_descr_, v3) << R_IRQ_MASK2_RD__dma8_sub1_descr__BITNR) | \
  (R_IRQ_MASK2_RD__dma8_sub0_descr__##f4##__VAL(R_IRQ_MASK2_RD_, dma8_sub0_descr_, v4) << R_IRQ_MASK2_RD__dma8_sub0_descr__BITNR) | \
  (R_IRQ_MASK2_RD__dma9_eop__##f5##__VAL(R_IRQ_MASK2_RD_, dma9_eop_, v5) << R_IRQ_MASK2_RD__dma9_eop__BITNR) | \
  (R_IRQ_MASK2_RD__dma9_descr__##f6##__VAL(R_IRQ_MASK2_RD_, dma9_descr_, v6) << R_IRQ_MASK2_RD__dma9_descr__BITNR) | \
  (R_IRQ_MASK2_RD__dma8_eop__##f7##__VAL(R_IRQ_MASK2_RD_, dma8_eop_, v7) << R_IRQ_MASK2_RD__dma8_eop__BITNR) | \
  (R_IRQ_MASK2_RD__dma8_descr__##f8##__VAL(R_IRQ_MASK2_RD_, dma8_descr_, v8) << R_IRQ_MASK2_RD__dma8_descr__BITNR) | \
  (R_IRQ_MASK2_RD__dma7_eop__##f9##__VAL(R_IRQ_MASK2_RD_, dma7_eop_, v9) << R_IRQ_MASK2_RD__dma7_eop__BITNR) | \
  (R_IRQ_MASK2_RD__dma7_descr__##f10##__VAL(R_IRQ_MASK2_RD_, dma7_descr_, v10) << R_IRQ_MASK2_RD__dma7_descr__BITNR) | \
  (R_IRQ_MASK2_RD__dma6_eop__##f11##__VAL(R_IRQ_MASK2_RD_, dma6_eop_, v11) << R_IRQ_MASK2_RD__dma6_eop__BITNR) | \
  (R_IRQ_MASK2_RD__dma6_descr__##f12##__VAL(R_IRQ_MASK2_RD_, dma6_descr_, v12) << R_IRQ_MASK2_RD__dma6_descr__BITNR) | \
  (R_IRQ_MASK2_RD__dma5_eop__##f13##__VAL(R_IRQ_MASK2_RD_, dma5_eop_, v13) << R_IRQ_MASK2_RD__dma5_eop__BITNR) | \
  (R_IRQ_MASK2_RD__dma5_descr__##f14##__VAL(R_IRQ_MASK2_RD_, dma5_descr_, v14) << R_IRQ_MASK2_RD__dma5_descr__BITNR) | \
  (R_IRQ_MASK2_RD__dma4_eop__##f15##__VAL(R_IRQ_MASK2_RD_, dma4_eop_, v15) << R_IRQ_MASK2_RD__dma4_eop__BITNR) | \
  (R_IRQ_MASK2_RD__dma4_descr__##f16##__VAL(R_IRQ_MASK2_RD_, dma4_descr_, v16) << R_IRQ_MASK2_RD__dma4_descr__BITNR) | \
  (R_IRQ_MASK2_RD__dma3_eop__##f17##__VAL(R_IRQ_MASK2_RD_, dma3_eop_, v17) << R_IRQ_MASK2_RD__dma3_eop__BITNR) | \
  (R_IRQ_MASK2_RD__dma3_descr__##f18##__VAL(R_IRQ_MASK2_RD_, dma3_descr_, v18) << R_IRQ_MASK2_RD__dma3_descr__BITNR) | \
  (R_IRQ_MASK2_RD__dma2_eop__##f19##__VAL(R_IRQ_MASK2_RD_, dma2_eop_, v19) << R_IRQ_MASK2_RD__dma2_eop__BITNR) | \
  (R_IRQ_MASK2_RD__dma2_descr__##f20##__VAL(R_IRQ_MASK2_RD_, dma2_descr_, v20) << R_IRQ_MASK2_RD__dma2_descr__BITNR) | \
  (R_IRQ_MASK2_RD__dma1_eop__##f21##__VAL(R_IRQ_MASK2_RD_, dma1_eop_, v21) << R_IRQ_MASK2_RD__dma1_eop__BITNR) | \
  (R_IRQ_MASK2_RD__dma1_descr__##f22##__VAL(R_IRQ_MASK2_RD_, dma1_descr_, v22) << R_IRQ_MASK2_RD__dma1_descr__BITNR) | \
  (R_IRQ_MASK2_RD__dma0_eop__##f23##__VAL(R_IRQ_MASK2_RD_, dma0_eop_, v23) << R_IRQ_MASK2_RD__dma0_eop__BITNR) | \
  (R_IRQ_MASK2_RD__dma0_descr__##f24##__VAL(R_IRQ_MASK2_RD_, dma0_descr_, v24) << R_IRQ_MASK2_RD__dma0_descr__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_IRQ_MASK2_RD_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_IRQ_MASK2_RD.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_IRQ_MASK2_RD_(f1_,v1,f2_,v2,f3_,v3,f4_,v4,f5_,v5,f6_,v6,f7_,v7,f8_,v8,f9_,v9,f10_,v10,f11_,v11,f12_,v12,f13_,v13,f14_,v14,f15_,v15,f16_,v16,f17_,v17,f18_,v18,f19_,v19,f20_,v20,f21_,v21,f22_,v22,f23_,v23,f24_,v24) ( \
  (R_IRQ_MASK2_RD__dma8_sub3_descr__##f1_##_VAL(R_IRQ_MASK2_RD_, dma8_sub3_descr_, v1) << R_IRQ_MASK2_RD__dma8_sub3_descr__BITNR) | \
  (R_IRQ_MASK2_RD__dma8_sub2_descr__##f2_##_VAL(R_IRQ_MASK2_RD_, dma8_sub2_descr_, v2) << R_IRQ_MASK2_RD__dma8_sub2_descr__BITNR) | \
  (R_IRQ_MASK2_RD__dma8_sub1_descr__##f3_##_VAL(R_IRQ_MASK2_RD_, dma8_sub1_descr_, v3) << R_IRQ_MASK2_RD__dma8_sub1_descr__BITNR) | \
  (R_IRQ_MASK2_RD__dma8_sub0_descr__##f4_##_VAL(R_IRQ_MASK2_RD_, dma8_sub0_descr_, v4) << R_IRQ_MASK2_RD__dma8_sub0_descr__BITNR) | \
  (R_IRQ_MASK2_RD__dma9_eop__##f5_##_VAL(R_IRQ_MASK2_RD_, dma9_eop_, v5) << R_IRQ_MASK2_RD__dma9_eop__BITNR) | \
  (R_IRQ_MASK2_RD__dma9_descr__##f6_##_VAL(R_IRQ_MASK2_RD_, dma9_descr_, v6) << R_IRQ_MASK2_RD__dma9_descr__BITNR) | \
  (R_IRQ_MASK2_RD__dma8_eop__##f7_##_VAL(R_IRQ_MASK2_RD_, dma8_eop_, v7) << R_IRQ_MASK2_RD__dma8_eop__BITNR) | \
  (R_IRQ_MASK2_RD__dma8_descr__##f8_##_VAL(R_IRQ_MASK2_RD_, dma8_descr_, v8) << R_IRQ_MASK2_RD__dma8_descr__BITNR) | \
  (R_IRQ_MASK2_RD__dma7_eop__##f9_##_VAL(R_IRQ_MASK2_RD_, dma7_eop_, v9) << R_IRQ_MASK2_RD__dma7_eop__BITNR) | \
  (R_IRQ_MASK2_RD__dma7_descr__##f10_##_VAL(R_IRQ_MASK2_RD_, dma7_descr_, v10) << R_IRQ_MASK2_RD__dma7_descr__BITNR) | \
  (R_IRQ_MASK2_RD__dma6_eop__##f11_##_VAL(R_IRQ_MASK2_RD_, dma6_eop_, v11) << R_IRQ_MASK2_RD__dma6_eop__BITNR) | \
  (R_IRQ_MASK2_RD__dma6_descr__##f12_##_VAL(R_IRQ_MASK2_RD_, dma6_descr_, v12) << R_IRQ_MASK2_RD__dma6_descr__BITNR) | \
  (R_IRQ_MASK2_RD__dma5_eop__##f13_##_VAL(R_IRQ_MASK2_RD_, dma5_eop_, v13) << R_IRQ_MASK2_RD__dma5_eop__BITNR) | \
  (R_IRQ_MASK2_RD__dma5_descr__##f14_##_VAL(R_IRQ_MASK2_RD_, dma5_descr_, v14) << R_IRQ_MASK2_RD__dma5_descr__BITNR) | \
  (R_IRQ_MASK2_RD__dma4_eop__##f15_##_VAL(R_IRQ_MASK2_RD_, dma4_eop_, v15) << R_IRQ_MASK2_RD__dma4_eop__BITNR) | \
  (R_IRQ_MASK2_RD__dma4_descr__##f16_##_VAL(R_IRQ_MASK2_RD_, dma4_descr_, v16) << R_IRQ_MASK2_RD__dma4_descr__BITNR) | \
  (R_IRQ_MASK2_RD__dma3_eop__##f17_##_VAL(R_IRQ_MASK2_RD_, dma3_eop_, v17) << R_IRQ_MASK2_RD__dma3_eop__BITNR) | \
  (R_IRQ_MASK2_RD__dma3_descr__##f18_##_VAL(R_IRQ_MASK2_RD_, dma3_descr_, v18) << R_IRQ_MASK2_RD__dma3_descr__BITNR) | \
  (R_IRQ_MASK2_RD__dma2_eop__##f19_##_VAL(R_IRQ_MASK2_RD_, dma2_eop_, v19) << R_IRQ_MASK2_RD__dma2_eop__BITNR) | \
  (R_IRQ_MASK2_RD__dma2_descr__##f20_##_VAL(R_IRQ_MASK2_RD_, dma2_descr_, v20) << R_IRQ_MASK2_RD__dma2_descr__BITNR) | \
  (R_IRQ_MASK2_RD__dma1_eop__##f21_##_VAL(R_IRQ_MASK2_RD_, dma1_eop_, v21) << R_IRQ_MASK2_RD__dma1_eop__BITNR) | \
  (R_IRQ_MASK2_RD__dma1_descr__##f22_##_VAL(R_IRQ_MASK2_RD_, dma1_descr_, v22) << R_IRQ_MASK2_RD__dma1_descr__BITNR) | \
  (R_IRQ_MASK2_RD__dma0_eop__##f23_##_VAL(R_IRQ_MASK2_RD_, dma0_eop_, v23) << R_IRQ_MASK2_RD__dma0_eop__BITNR) | \
  (R_IRQ_MASK2_RD__dma0_descr__##f24_##_VAL(R_IRQ_MASK2_RD_, dma0_descr_, v24) << R_IRQ_MASK2_RD__dma0_descr__BITNR) \
)

#endif

/*
 *  R_IRQ_MASK2_SET
 *  - type:  WO
 *  - addr:  0xb00000d4
 *  - group: Interrupt mask and status registers
 */

#if USE_GROUP__Interrupt_mask_and_status_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_IRQ_MASK2_SET
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_IRQ_MASK2_SET.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_IRQ_MASK2_SET. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_IRQ_MASK2_SET(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11,f12,v12,f13,v13,f14,v14,f15,v15,f16,v16,f17,v17,f18,v18,f19,v19,f20,v20,f21,v21,f22,v22,f23,v23,f24,v24) ( \
  *R_IRQ_MASK2_SET__SADDR = ( \
    REG_INITIATED(R_IRQ_MASK2_SET_) \
    REG_VAL__R_IRQ_MASK2_SET_(f1##_,v1,f2##_,v2,f3##_,v3,f4##_,v4,f5##_,v5,f6##_,v6,f7##_,v7,f8##_,v8,f9##_,v9,f10##_,v10,f11##_,v11,f12##_,v12,f13##_,v13,f14##_,v14,f15##_,v15,f16##_,v16,f17##_,v17,f18##_,v18,f19##_,v19,f20##_,v20,f21##_,v21,f22##_,v22,f23##_,v23,f24##_,v24) \
  ), \
  R_IRQ_MASK2_SET__WRITE(R_IRQ_MASK2_SET__ADDR, *R_IRQ_MASK2_SET__SADDR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_IRQ_MASK2_SET__SHADOW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_IRQ_MASK2_SET.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in the 
*#               shadow register for R_IRQ_MASK2_SET. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_IRQ_MASK2_SET__SHADOW(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11,f12,v12,f13,v13,f14,v14,f15,v15,f16,v16,f17,v17,f18,v18,f19,v19,f20,v20,f21,v21,f22,v22,f23,v23,f24,v24) ( \
  *R_IRQ_MASK2_SET__SADDR = ( \
    REG_INITIATED(R_IRQ_MASK2_SET_) \
    REG_VAL__R_IRQ_MASK2_SET_(f1##_,v1,f2##_,v2,f3##_,v3,f4##_,v4,f5##_,v5,f6##_,v6,f7##_,v7,f8##_,v8,f9##_,v9,f10##_,v10,f11##_,v11,f12##_,v12,f13##_,v13,f14##_,v14,f15##_,v15,f16##_,v16,f17##_,v17,f18##_,v18,f19##_,v19,f20##_,v20,f21##_,v21,f22##_,v22,f23##_,v23,f24##_,v24) \
  ) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_IRQ_MASK2_SET
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_IRQ_MASK2_SET(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11,f12,v12,f13,v13,f14,v14,f15,v15,f16,v16,f17,v17,f18,v18,f19,v19,f20,v20,f21,v21,f22,v22,f23,v23,f24,v24) ( \
  (R_IRQ_MASK2_SET__dma8_sub3_descr__##f1##__MASK & REG__##v1) | \
  (R_IRQ_MASK2_SET__dma8_sub2_descr__##f2##__MASK & REG__##v2) | \
  (R_IRQ_MASK2_SET__dma8_sub1_descr__##f3##__MASK & REG__##v3) | \
  (R_IRQ_MASK2_SET__dma8_sub0_descr__##f4##__MASK & REG__##v4) | \
  (R_IRQ_MASK2_SET__dma9_eop__##f5##__MASK & REG__##v5) | \
  (R_IRQ_MASK2_SET__dma9_descr__##f6##__MASK & REG__##v6) | \
  (R_IRQ_MASK2_SET__dma8_eop__##f7##__MASK & REG__##v7) | \
  (R_IRQ_MASK2_SET__dma8_descr__##f8##__MASK & REG__##v8) | \
  (R_IRQ_MASK2_SET__dma7_eop__##f9##__MASK & REG__##v9) | \
  (R_IRQ_MASK2_SET__dma7_descr__##f10##__MASK & REG__##v10) | \
  (R_IRQ_MASK2_SET__dma6_eop__##f11##__MASK & REG__##v11) | \
  (R_IRQ_MASK2_SET__dma6_descr__##f12##__MASK & REG__##v12) | \
  (R_IRQ_MASK2_SET__dma5_eop__##f13##__MASK & REG__##v13) | \
  (R_IRQ_MASK2_SET__dma5_descr__##f14##__MASK & REG__##v14) | \
  (R_IRQ_MASK2_SET__dma4_eop__##f15##__MASK & REG__##v15) | \
  (R_IRQ_MASK2_SET__dma4_descr__##f16##__MASK & REG__##v16) | \
  (R_IRQ_MASK2_SET__dma3_eop__##f17##__MASK & REG__##v17) | \
  (R_IRQ_MASK2_SET__dma3_descr__##f18##__MASK & REG__##v18) | \
  (R_IRQ_MASK2_SET__dma2_eop__##f19##__MASK & REG__##v19) | \
  (R_IRQ_MASK2_SET__dma2_descr__##f20##__MASK & REG__##v20) | \
  (R_IRQ_MASK2_SET__dma1_eop__##f21##__MASK & REG__##v21) | \
  (R_IRQ_MASK2_SET__dma1_descr__##f22##__MASK & REG__##v22) | \
  (R_IRQ_MASK2_SET__dma0_eop__##f23##__MASK & REG__##v23) | \
  (R_IRQ_MASK2_SET__dma0_descr__##f24##__MASK & REG__##v24) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_IRQ_MASK2_SET
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_IRQ_MASK2_SET.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_IRQ_MASK2_SET(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11,f12,v12,f13,v13,f14,v14,f15,v15,f16,v16,f17,v17,f18,v18,f19,v19,f20,v20,f21,v21,f22,v22,f23,v23,f24,v24) ( \
  (R_IRQ_MASK2_SET__dma8_sub3_descr__##f1##__VAL(R_IRQ_MASK2_SET_, dma8_sub3_descr_, v1) << R_IRQ_MASK2_SET__dma8_sub3_descr__BITNR) | \
  (R_IRQ_MASK2_SET__dma8_sub2_descr__##f2##__VAL(R_IRQ_MASK2_SET_, dma8_sub2_descr_, v2) << R_IRQ_MASK2_SET__dma8_sub2_descr__BITNR) | \
  (R_IRQ_MASK2_SET__dma8_sub1_descr__##f3##__VAL(R_IRQ_MASK2_SET_, dma8_sub1_descr_, v3) << R_IRQ_MASK2_SET__dma8_sub1_descr__BITNR) | \
  (R_IRQ_MASK2_SET__dma8_sub0_descr__##f4##__VAL(R_IRQ_MASK2_SET_, dma8_sub0_descr_, v4) << R_IRQ_MASK2_SET__dma8_sub0_descr__BITNR) | \
  (R_IRQ_MASK2_SET__dma9_eop__##f5##__VAL(R_IRQ_MASK2_SET_, dma9_eop_, v5) << R_IRQ_MASK2_SET__dma9_eop__BITNR) | \
  (R_IRQ_MASK2_SET__dma9_descr__##f6##__VAL(R_IRQ_MASK2_SET_, dma9_descr_, v6) << R_IRQ_MASK2_SET__dma9_descr__BITNR) | \
  (R_IRQ_MASK2_SET__dma8_eop__##f7##__VAL(R_IRQ_MASK2_SET_, dma8_eop_, v7) << R_IRQ_MASK2_SET__dma8_eop__BITNR) | \
  (R_IRQ_MASK2_SET__dma8_descr__##f8##__VAL(R_IRQ_MASK2_SET_, dma8_descr_, v8) << R_IRQ_MASK2_SET__dma8_descr__BITNR) | \
  (R_IRQ_MASK2_SET__dma7_eop__##f9##__VAL(R_IRQ_MASK2_SET_, dma7_eop_, v9) << R_IRQ_MASK2_SET__dma7_eop__BITNR) | \
  (R_IRQ_MASK2_SET__dma7_descr__##f10##__VAL(R_IRQ_MASK2_SET_, dma7_descr_, v10) << R_IRQ_MASK2_SET__dma7_descr__BITNR) | \
  (R_IRQ_MASK2_SET__dma6_eop__##f11##__VAL(R_IRQ_MASK2_SET_, dma6_eop_, v11) << R_IRQ_MASK2_SET__dma6_eop__BITNR) | \
  (R_IRQ_MASK2_SET__dma6_descr__##f12##__VAL(R_IRQ_MASK2_SET_, dma6_descr_, v12) << R_IRQ_MASK2_SET__dma6_descr__BITNR) | \
  (R_IRQ_MASK2_SET__dma5_eop__##f13##__VAL(R_IRQ_MASK2_SET_, dma5_eop_, v13) << R_IRQ_MASK2_SET__dma5_eop__BITNR) | \
  (R_IRQ_MASK2_SET__dma5_descr__##f14##__VAL(R_IRQ_MASK2_SET_, dma5_descr_, v14) << R_IRQ_MASK2_SET__dma5_descr__BITNR) | \
  (R_IRQ_MASK2_SET__dma4_eop__##f15##__VAL(R_IRQ_MASK2_SET_, dma4_eop_, v15) << R_IRQ_MASK2_SET__dma4_eop__BITNR) | \
  (R_IRQ_MASK2_SET__dma4_descr__##f16##__VAL(R_IRQ_MASK2_SET_, dma4_descr_, v16) << R_IRQ_MASK2_SET__dma4_descr__BITNR) | \
  (R_IRQ_MASK2_SET__dma3_eop__##f17##__VAL(R_IRQ_MASK2_SET_, dma3_eop_, v17) << R_IRQ_MASK2_SET__dma3_eop__BITNR) | \
  (R_IRQ_MASK2_SET__dma3_descr__##f18##__VAL(R_IRQ_MASK2_SET_, dma3_descr_, v18) << R_IRQ_MASK2_SET__dma3_descr__BITNR) | \
  (R_IRQ_MASK2_SET__dma2_eop__##f19##__VAL(R_IRQ_MASK2_SET_, dma2_eop_, v19) << R_IRQ_MASK2_SET__dma2_eop__BITNR) | \
  (R_IRQ_MASK2_SET__dma2_descr__##f20##__VAL(R_IRQ_MASK2_SET_, dma2_descr_, v20) << R_IRQ_MASK2_SET__dma2_descr__BITNR) | \
  (R_IRQ_MASK2_SET__dma1_eop__##f21##__VAL(R_IRQ_MASK2_SET_, dma1_eop_, v21) << R_IRQ_MASK2_SET__dma1_eop__BITNR) | \
  (R_IRQ_MASK2_SET__dma1_descr__##f22##__VAL(R_IRQ_MASK2_SET_, dma1_descr_, v22) << R_IRQ_MASK2_SET__dma1_descr__BITNR) | \
  (R_IRQ_MASK2_SET__dma0_eop__##f23##__VAL(R_IRQ_MASK2_SET_, dma0_eop_, v23) << R_IRQ_MASK2_SET__dma0_eop__BITNR) | \
  (R_IRQ_MASK2_SET__dma0_descr__##f24##__VAL(R_IRQ_MASK2_SET_, dma0_descr_, v24) << R_IRQ_MASK2_SET__dma0_descr__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_IRQ_MASK2_SET_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_IRQ_MASK2_SET.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_IRQ_MASK2_SET_(f1_,v1,f2_,v2,f3_,v3,f4_,v4,f5_,v5,f6_,v6,f7_,v7,f8_,v8,f9_,v9,f10_,v10,f11_,v11,f12_,v12,f13_,v13,f14_,v14,f15_,v15,f16_,v16,f17_,v17,f18_,v18,f19_,v19,f20_,v20,f21_,v21,f22_,v22,f23_,v23,f24_,v24) ( \
  (R_IRQ_MASK2_SET__dma8_sub3_descr__##f1_##_VAL(R_IRQ_MASK2_SET_, dma8_sub3_descr_, v1) << R_IRQ_MASK2_SET__dma8_sub3_descr__BITNR) | \
  (R_IRQ_MASK2_SET__dma8_sub2_descr__##f2_##_VAL(R_IRQ_MASK2_SET_, dma8_sub2_descr_, v2) << R_IRQ_MASK2_SET__dma8_sub2_descr__BITNR) | \
  (R_IRQ_MASK2_SET__dma8_sub1_descr__##f3_##_VAL(R_IRQ_MASK2_SET_, dma8_sub1_descr_, v3) << R_IRQ_MASK2_SET__dma8_sub1_descr__BITNR) | \
  (R_IRQ_MASK2_SET__dma8_sub0_descr__##f4_##_VAL(R_IRQ_MASK2_SET_, dma8_sub0_descr_, v4) << R_IRQ_MASK2_SET__dma8_sub0_descr__BITNR) | \
  (R_IRQ_MASK2_SET__dma9_eop__##f5_##_VAL(R_IRQ_MASK2_SET_, dma9_eop_, v5) << R_IRQ_MASK2_SET__dma9_eop__BITNR) | \
  (R_IRQ_MASK2_SET__dma9_descr__##f6_##_VAL(R_IRQ_MASK2_SET_, dma9_descr_, v6) << R_IRQ_MASK2_SET__dma9_descr__BITNR) | \
  (R_IRQ_MASK2_SET__dma8_eop__##f7_##_VAL(R_IRQ_MASK2_SET_, dma8_eop_, v7) << R_IRQ_MASK2_SET__dma8_eop__BITNR) | \
  (R_IRQ_MASK2_SET__dma8_descr__##f8_##_VAL(R_IRQ_MASK2_SET_, dma8_descr_, v8) << R_IRQ_MASK2_SET__dma8_descr__BITNR) | \
  (R_IRQ_MASK2_SET__dma7_eop__##f9_##_VAL(R_IRQ_MASK2_SET_, dma7_eop_, v9) << R_IRQ_MASK2_SET__dma7_eop__BITNR) | \
  (R_IRQ_MASK2_SET__dma7_descr__##f10_##_VAL(R_IRQ_MASK2_SET_, dma7_descr_, v10) << R_IRQ_MASK2_SET__dma7_descr__BITNR) | \
  (R_IRQ_MASK2_SET__dma6_eop__##f11_##_VAL(R_IRQ_MASK2_SET_, dma6_eop_, v11) << R_IRQ_MASK2_SET__dma6_eop__BITNR) | \
  (R_IRQ_MASK2_SET__dma6_descr__##f12_##_VAL(R_IRQ_MASK2_SET_, dma6_descr_, v12) << R_IRQ_MASK2_SET__dma6_descr__BITNR) | \
  (R_IRQ_MASK2_SET__dma5_eop__##f13_##_VAL(R_IRQ_MASK2_SET_, dma5_eop_, v13) << R_IRQ_MASK2_SET__dma5_eop__BITNR) | \
  (R_IRQ_MASK2_SET__dma5_descr__##f14_##_VAL(R_IRQ_MASK2_SET_, dma5_descr_, v14) << R_IRQ_MASK2_SET__dma5_descr__BITNR) | \
  (R_IRQ_MASK2_SET__dma4_eop__##f15_##_VAL(R_IRQ_MASK2_SET_, dma4_eop_, v15) << R_IRQ_MASK2_SET__dma4_eop__BITNR) | \
  (R_IRQ_MASK2_SET__dma4_descr__##f16_##_VAL(R_IRQ_MASK2_SET_, dma4_descr_, v16) << R_IRQ_MASK2_SET__dma4_descr__BITNR) | \
  (R_IRQ_MASK2_SET__dma3_eop__##f17_##_VAL(R_IRQ_MASK2_SET_, dma3_eop_, v17) << R_IRQ_MASK2_SET__dma3_eop__BITNR) | \
  (R_IRQ_MASK2_SET__dma3_descr__##f18_##_VAL(R_IRQ_MASK2_SET_, dma3_descr_, v18) << R_IRQ_MASK2_SET__dma3_descr__BITNR) | \
  (R_IRQ_MASK2_SET__dma2_eop__##f19_##_VAL(R_IRQ_MASK2_SET_, dma2_eop_, v19) << R_IRQ_MASK2_SET__dma2_eop__BITNR) | \
  (R_IRQ_MASK2_SET__dma2_descr__##f20_##_VAL(R_IRQ_MASK2_SET_, dma2_descr_, v20) << R_IRQ_MASK2_SET__dma2_descr__BITNR) | \
  (R_IRQ_MASK2_SET__dma1_eop__##f21_##_VAL(R_IRQ_MASK2_SET_, dma1_eop_, v21) << R_IRQ_MASK2_SET__dma1_eop__BITNR) | \
  (R_IRQ_MASK2_SET__dma1_descr__##f22_##_VAL(R_IRQ_MASK2_SET_, dma1_descr_, v22) << R_IRQ_MASK2_SET__dma1_descr__BITNR) | \
  (R_IRQ_MASK2_SET__dma0_eop__##f23_##_VAL(R_IRQ_MASK2_SET_, dma0_eop_, v23) << R_IRQ_MASK2_SET__dma0_eop__BITNR) | \
  (R_IRQ_MASK2_SET__dma0_descr__##f24_##_VAL(R_IRQ_MASK2_SET_, dma0_descr_, v24) << R_IRQ_MASK2_SET__dma0_descr__BITNR) \
)

#endif

/*
 *  R_IRQ_READ0
 *  - type:  RO
 *  - addr:  0xb00000c4
 *  - group: Interrupt mask and status registers
 */

#if USE_GROUP__Interrupt_mask_and_status_registers

/* No REG_SET__register-name for read only registers. */

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_IRQ_READ0
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_IRQ_READ0(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11,f12,v12,f13,v13,f14,v14,f15,v15,f16,v16,f17,v17,f18,v18,f19,v19,f20,v20,f21,v21,f22,v22,f23,v23,f24,v24,f25,v25,f26,v26,f27,v27,f28,v28,f29,v29,f30,v30,f31,v31) ( \
  (R_IRQ_READ0__nmi_pin__##f1##__MASK & REG__##v1) | \
  (R_IRQ_READ0__watchdog_nmi__##f2##__MASK & REG__##v2) | \
  (R_IRQ_READ0__sqe_test_error__##f3##__MASK & REG__##v3) | \
  (R_IRQ_READ0__carrier_loss__##f4##__MASK & REG__##v4) | \
  (R_IRQ_READ0__deferred__##f5##__MASK & REG__##v5) | \
  (R_IRQ_READ0__late_col__##f6##__MASK & REG__##v6) | \
  (R_IRQ_READ0__multiple_col__##f7##__MASK & REG__##v7) | \
  (R_IRQ_READ0__single_col__##f8##__MASK & REG__##v8) | \
  (R_IRQ_READ0__congestion__##f9##__MASK & REG__##v9) | \
  (R_IRQ_READ0__oversize__##f10##__MASK & REG__##v10) | \
  (R_IRQ_READ0__alignment_error__##f11##__MASK & REG__##v11) | \
  (R_IRQ_READ0__crc_error__##f12##__MASK & REG__##v12) | \
  (R_IRQ_READ0__overrun__##f13##__MASK & REG__##v13) | \
  (R_IRQ_READ0__underrun__##f14##__MASK & REG__##v14) | \
  (R_IRQ_READ0__excessive_col__##f15##__MASK & REG__##v15) | \
  (R_IRQ_READ0__mdio__##f16##__MASK & REG__##v16) | \
  (R_IRQ_READ0__ata_drq3__##f17##__MASK & REG__##v17) | \
  (R_IRQ_READ0__ata_drq2__##f18##__MASK & REG__##v18) | \
  (R_IRQ_READ0__ata_drq1__##f19##__MASK & REG__##v19) | \
  (R_IRQ_READ0__ata_drq0__##f20##__MASK & REG__##v20) | \
  (R_IRQ_READ0__par0_ecp_cmd__##f21##__MASK & REG__##v21) | \
  (R_IRQ_READ0__par0_peri__##f22##__MASK & REG__##v22) | \
  (R_IRQ_READ0__par0_data__##f23##__MASK & REG__##v23) | \
  (R_IRQ_READ0__par0_ready__##f24##__MASK & REG__##v24) | \
  (R_IRQ_READ0__ata_dmaend__##f25##__MASK & REG__##v25) | \
  (R_IRQ_READ0__irq_ext_vector_nr__##f26##__MASK & REG__##v26) | \
  (R_IRQ_READ0__irq_int_vector_nr__##f27##__MASK & REG__##v27) | \
  (R_IRQ_READ0__ext_dma1__##f28##__MASK & REG__##v28) | \
  (R_IRQ_READ0__ext_dma0__##f29##__MASK & REG__##v29) | \
  (R_IRQ_READ0__timer1__##f30##__MASK & REG__##v30) | \
  (R_IRQ_READ0__timer0__##f31##__MASK & REG__##v31) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_IRQ_READ0
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_IRQ_READ0.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_IRQ_READ0(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11,f12,v12,f13,v13,f14,v14,f15,v15,f16,v16,f17,v17,f18,v18,f19,v19,f20,v20,f21,v21,f22,v22,f23,v23,f24,v24,f25,v25,f26,v26,f27,v27,f28,v28,f29,v29,f30,v30,f31,v31) ( \
  (R_IRQ_READ0__nmi_pin__##f1##__VAL(R_IRQ_READ0_, nmi_pin_, v1) << R_IRQ_READ0__nmi_pin__BITNR) | \
  (R_IRQ_READ0__watchdog_nmi__##f2##__VAL(R_IRQ_READ0_, watchdog_nmi_, v2) << R_IRQ_READ0__watchdog_nmi__BITNR) | \
  (R_IRQ_READ0__sqe_test_error__##f3##__VAL(R_IRQ_READ0_, sqe_test_error_, v3) << R_IRQ_READ0__sqe_test_error__BITNR) | \
  (R_IRQ_READ0__carrier_loss__##f4##__VAL(R_IRQ_READ0_, carrier_loss_, v4) << R_IRQ_READ0__carrier_loss__BITNR) | \
  (R_IRQ_READ0__deferred__##f5##__VAL(R_IRQ_READ0_, deferred_, v5) << R_IRQ_READ0__deferred__BITNR) | \
  (R_IRQ_READ0__late_col__##f6##__VAL(R_IRQ_READ0_, late_col_, v6) << R_IRQ_READ0__late_col__BITNR) | \
  (R_IRQ_READ0__multiple_col__##f7##__VAL(R_IRQ_READ0_, multiple_col_, v7) << R_IRQ_READ0__multiple_col__BITNR) | \
  (R_IRQ_READ0__single_col__##f8##__VAL(R_IRQ_READ0_, single_col_, v8) << R_IRQ_READ0__single_col__BITNR) | \
  (R_IRQ_READ0__congestion__##f9##__VAL(R_IRQ_READ0_, congestion_, v9) << R_IRQ_READ0__congestion__BITNR) | \
  (R_IRQ_READ0__oversize__##f10##__VAL(R_IRQ_READ0_, oversize_, v10) << R_IRQ_READ0__oversize__BITNR) | \
  (R_IRQ_READ0__alignment_error__##f11##__VAL(R_IRQ_READ0_, alignment_error_, v11) << R_IRQ_READ0__alignment_error__BITNR) | \
  (R_IRQ_READ0__crc_error__##f12##__VAL(R_IRQ_READ0_, crc_error_, v12) << R_IRQ_READ0__crc_error__BITNR) | \
  (R_IRQ_READ0__overrun__##f13##__VAL(R_IRQ_READ0_, overrun_, v13) << R_IRQ_READ0__overrun__BITNR) | \
  (R_IRQ_READ0__underrun__##f14##__VAL(R_IRQ_READ0_, underrun_, v14) << R_IRQ_READ0__underrun__BITNR) | \
  (R_IRQ_READ0__excessive_col__##f15##__VAL(R_IRQ_READ0_, excessive_col_, v15) << R_IRQ_READ0__excessive_col__BITNR) | \
  (R_IRQ_READ0__mdio__##f16##__VAL(R_IRQ_READ0_, mdio_, v16) << R_IRQ_READ0__mdio__BITNR) | \
  (R_IRQ_READ0__ata_drq3__##f17##__VAL(R_IRQ_READ0_, ata_drq3_, v17) << R_IRQ_READ0__ata_drq3__BITNR) | \
  (R_IRQ_READ0__ata_drq2__##f18##__VAL(R_IRQ_READ0_, ata_drq2_, v18) << R_IRQ_READ0__ata_drq2__BITNR) | \
  (R_IRQ_READ0__ata_drq1__##f19##__VAL(R_IRQ_READ0_, ata_drq1_, v19) << R_IRQ_READ0__ata_drq1__BITNR) | \
  (R_IRQ_READ0__ata_drq0__##f20##__VAL(R_IRQ_READ0_, ata_drq0_, v20) << R_IRQ_READ0__ata_drq0__BITNR) | \
  (R_IRQ_READ0__par0_ecp_cmd__##f21##__VAL(R_IRQ_READ0_, par0_ecp_cmd_, v21) << R_IRQ_READ0__par0_ecp_cmd__BITNR) | \
  (R_IRQ_READ0__par0_peri__##f22##__VAL(R_IRQ_READ0_, par0_peri_, v22) << R_IRQ_READ0__par0_peri__BITNR) | \
  (R_IRQ_READ0__par0_data__##f23##__VAL(R_IRQ_READ0_, par0_data_, v23) << R_IRQ_READ0__par0_data__BITNR) | \
  (R_IRQ_READ0__par0_ready__##f24##__VAL(R_IRQ_READ0_, par0_ready_, v24) << R_IRQ_READ0__par0_ready__BITNR) | \
  (R_IRQ_READ0__ata_dmaend__##f25##__VAL(R_IRQ_READ0_, ata_dmaend_, v25) << R_IRQ_READ0__ata_dmaend__BITNR) | \
  (R_IRQ_READ0__irq_ext_vector_nr__##f26##__VAL(R_IRQ_READ0_, irq_ext_vector_nr_, v26) << R_IRQ_READ0__irq_ext_vector_nr__BITNR) | \
  (R_IRQ_READ0__irq_int_vector_nr__##f27##__VAL(R_IRQ_READ0_, irq_int_vector_nr_, v27) << R_IRQ_READ0__irq_int_vector_nr__BITNR) | \
  (R_IRQ_READ0__ext_dma1__##f28##__VAL(R_IRQ_READ0_, ext_dma1_, v28) << R_IRQ_READ0__ext_dma1__BITNR) | \
  (R_IRQ_READ0__ext_dma0__##f29##__VAL(R_IRQ_READ0_, ext_dma0_, v29) << R_IRQ_READ0__ext_dma0__BITNR) | \
  (R_IRQ_READ0__timer1__##f30##__VAL(R_IRQ_READ0_, timer1_, v30) << R_IRQ_READ0__timer1__BITNR) | \
  (R_IRQ_READ0__timer0__##f31##__VAL(R_IRQ_READ0_, timer0_, v31) << R_IRQ_READ0__timer0__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_IRQ_READ0_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_IRQ_READ0.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_IRQ_READ0_(f1_,v1,f2_,v2,f3_,v3,f4_,v4,f5_,v5,f6_,v6,f7_,v7,f8_,v8,f9_,v9,f10_,v10,f11_,v11,f12_,v12,f13_,v13,f14_,v14,f15_,v15,f16_,v16,f17_,v17,f18_,v18,f19_,v19,f20_,v20,f21_,v21,f22_,v22,f23_,v23,f24_,v24,f25_,v25,f26_,v26,f27_,v27,f28_,v28,f29_,v29,f30_,v30,f31_,v31) ( \
  (R_IRQ_READ0__nmi_pin__##f1_##_VAL(R_IRQ_READ0_, nmi_pin_, v1) << R_IRQ_READ0__nmi_pin__BITNR) | \
  (R_IRQ_READ0__watchdog_nmi__##f2_##_VAL(R_IRQ_READ0_, watchdog_nmi_, v2) << R_IRQ_READ0__watchdog_nmi__BITNR) | \
  (R_IRQ_READ0__sqe_test_error__##f3_##_VAL(R_IRQ_READ0_, sqe_test_error_, v3) << R_IRQ_READ0__sqe_test_error__BITNR) | \
  (R_IRQ_READ0__carrier_loss__##f4_##_VAL(R_IRQ_READ0_, carrier_loss_, v4) << R_IRQ_READ0__carrier_loss__BITNR) | \
  (R_IRQ_READ0__deferred__##f5_##_VAL(R_IRQ_READ0_, deferred_, v5) << R_IRQ_READ0__deferred__BITNR) | \
  (R_IRQ_READ0__late_col__##f6_##_VAL(R_IRQ_READ0_, late_col_, v6) << R_IRQ_READ0__late_col__BITNR) | \
  (R_IRQ_READ0__multiple_col__##f7_##_VAL(R_IRQ_READ0_, multiple_col_, v7) << R_IRQ_READ0__multiple_col__BITNR) | \
  (R_IRQ_READ0__single_col__##f8_##_VAL(R_IRQ_READ0_, single_col_, v8) << R_IRQ_READ0__single_col__BITNR) | \
  (R_IRQ_READ0__congestion__##f9_##_VAL(R_IRQ_READ0_, congestion_, v9) << R_IRQ_READ0__congestion__BITNR) | \
  (R_IRQ_READ0__oversize__##f10_##_VAL(R_IRQ_READ0_, oversize_, v10) << R_IRQ_READ0__oversize__BITNR) | \
  (R_IRQ_READ0__alignment_error__##f11_##_VAL(R_IRQ_READ0_, alignment_error_, v11) << R_IRQ_READ0__alignment_error__BITNR) | \
  (R_IRQ_READ0__crc_error__##f12_##_VAL(R_IRQ_READ0_, crc_error_, v12) << R_IRQ_READ0__crc_error__BITNR) | \
  (R_IRQ_READ0__overrun__##f13_##_VAL(R_IRQ_READ0_, overrun_, v13) << R_IRQ_READ0__overrun__BITNR) | \
  (R_IRQ_READ0__underrun__##f14_##_VAL(R_IRQ_READ0_, underrun_, v14) << R_IRQ_READ0__underrun__BITNR) | \
  (R_IRQ_READ0__excessive_col__##f15_##_VAL(R_IRQ_READ0_, excessive_col_, v15) << R_IRQ_READ0__excessive_col__BITNR) | \
  (R_IRQ_READ0__mdio__##f16_##_VAL(R_IRQ_READ0_, mdio_, v16) << R_IRQ_READ0__mdio__BITNR) | \
  (R_IRQ_READ0__ata_drq3__##f17_##_VAL(R_IRQ_READ0_, ata_drq3_, v17) << R_IRQ_READ0__ata_drq3__BITNR) | \
  (R_IRQ_READ0__ata_drq2__##f18_##_VAL(R_IRQ_READ0_, ata_drq2_, v18) << R_IRQ_READ0__ata_drq2__BITNR) | \
  (R_IRQ_READ0__ata_drq1__##f19_##_VAL(R_IRQ_READ0_, ata_drq1_, v19) << R_IRQ_READ0__ata_drq1__BITNR) | \
  (R_IRQ_READ0__ata_drq0__##f20_##_VAL(R_IRQ_READ0_, ata_drq0_, v20) << R_IRQ_READ0__ata_drq0__BITNR) | \
  (R_IRQ_READ0__par0_ecp_cmd__##f21_##_VAL(R_IRQ_READ0_, par0_ecp_cmd_, v21) << R_IRQ_READ0__par0_ecp_cmd__BITNR) | \
  (R_IRQ_READ0__par0_peri__##f22_##_VAL(R_IRQ_READ0_, par0_peri_, v22) << R_IRQ_READ0__par0_peri__BITNR) | \
  (R_IRQ_READ0__par0_data__##f23_##_VAL(R_IRQ_READ0_, par0_data_, v23) << R_IRQ_READ0__par0_data__BITNR) | \
  (R_IRQ_READ0__par0_ready__##f24_##_VAL(R_IRQ_READ0_, par0_ready_, v24) << R_IRQ_READ0__par0_ready__BITNR) | \
  (R_IRQ_READ0__ata_dmaend__##f25_##_VAL(R_IRQ_READ0_, ata_dmaend_, v25) << R_IRQ_READ0__ata_dmaend__BITNR) | \
  (R_IRQ_READ0__irq_ext_vector_nr__##f26_##_VAL(R_IRQ_READ0_, irq_ext_vector_nr_, v26) << R_IRQ_READ0__irq_ext_vector_nr__BITNR) | \
  (R_IRQ_READ0__irq_int_vector_nr__##f27_##_VAL(R_IRQ_READ0_, irq_int_vector_nr_, v27) << R_IRQ_READ0__irq_int_vector_nr__BITNR) | \
  (R_IRQ_READ0__ext_dma1__##f28_##_VAL(R_IRQ_READ0_, ext_dma1_, v28) << R_IRQ_READ0__ext_dma1__BITNR) | \
  (R_IRQ_READ0__ext_dma0__##f29_##_VAL(R_IRQ_READ0_, ext_dma0_, v29) << R_IRQ_READ0__ext_dma0__BITNR) | \
  (R_IRQ_READ0__timer1__##f30_##_VAL(R_IRQ_READ0_, timer1_, v30) << R_IRQ_READ0__timer1__BITNR) | \
  (R_IRQ_READ0__timer0__##f31_##_VAL(R_IRQ_READ0_, timer0_, v31) << R_IRQ_READ0__timer0__BITNR) \
)

#endif

/*
 *  R_IRQ_READ1
 *  - type:  RO
 *  - addr:  0xb00000cc
 *  - group: Interrupt mask and status registers
 */

#if USE_GROUP__Interrupt_mask_and_status_registers

/* No REG_SET__register-name for read only registers. */

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_IRQ_READ1
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_IRQ_READ1(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11,f12,v12,f13,v13,f14,v14,f15,v15,f16,v16,f17,v17,f18,v18,f19,v19,f20,v20,f21,v21,f22,v22,f23,v23,f24,v24,f25,v25,f26,v26,f27,v27,f28,v28) ( \
  (R_IRQ_READ1__sw_int7__##f1##__MASK & REG__##v1) | \
  (R_IRQ_READ1__sw_int6__##f2##__MASK & REG__##v2) | \
  (R_IRQ_READ1__sw_int5__##f3##__MASK & REG__##v3) | \
  (R_IRQ_READ1__sw_int4__##f4##__MASK & REG__##v4) | \
  (R_IRQ_READ1__sw_int3__##f5##__MASK & REG__##v5) | \
  (R_IRQ_READ1__sw_int2__##f6##__MASK & REG__##v6) | \
  (R_IRQ_READ1__sw_int1__##f7##__MASK & REG__##v7) | \
  (R_IRQ_READ1__sw_int0__##f8##__MASK & REG__##v8) | \
  (R_IRQ_READ1__par1_ecp_cmd__##f9##__MASK & REG__##v9) | \
  (R_IRQ_READ1__par1_peri__##f10##__MASK & REG__##v10) | \
  (R_IRQ_READ1__par1_data__##f11##__MASK & REG__##v11) | \
  (R_IRQ_READ1__par1_ready__##f12##__MASK & REG__##v12) | \
  (R_IRQ_READ1__ser3_ready__##f13##__MASK & REG__##v13) | \
  (R_IRQ_READ1__ser3_data__##f14##__MASK & REG__##v14) | \
  (R_IRQ_READ1__ser2_ready__##f15##__MASK & REG__##v15) | \
  (R_IRQ_READ1__ser2_data__##f16##__MASK & REG__##v16) | \
  (R_IRQ_READ1__ser1_ready__##f17##__MASK & REG__##v17) | \
  (R_IRQ_READ1__ser1_data__##f18##__MASK & REG__##v18) | \
  (R_IRQ_READ1__ser0_ready__##f19##__MASK & REG__##v19) | \
  (R_IRQ_READ1__ser0_data__##f20##__MASK & REG__##v20) | \
  (R_IRQ_READ1__pa7__##f21##__MASK & REG__##v21) | \
  (R_IRQ_READ1__pa6__##f22##__MASK & REG__##v22) | \
  (R_IRQ_READ1__pa5__##f23##__MASK & REG__##v23) | \
  (R_IRQ_READ1__pa4__##f24##__MASK & REG__##v24) | \
  (R_IRQ_READ1__pa3__##f25##__MASK & REG__##v25) | \
  (R_IRQ_READ1__pa2__##f26##__MASK & REG__##v26) | \
  (R_IRQ_READ1__pa1__##f27##__MASK & REG__##v27) | \
  (R_IRQ_READ1__pa0__##f28##__MASK & REG__##v28) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_IRQ_READ1
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_IRQ_READ1.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_IRQ_READ1(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11,f12,v12,f13,v13,f14,v14,f15,v15,f16,v16,f17,v17,f18,v18,f19,v19,f20,v20,f21,v21,f22,v22,f23,v23,f24,v24,f25,v25,f26,v26,f27,v27,f28,v28) ( \
  (R_IRQ_READ1__sw_int7__##f1##__VAL(R_IRQ_READ1_, sw_int7_, v1) << R_IRQ_READ1__sw_int7__BITNR) | \
  (R_IRQ_READ1__sw_int6__##f2##__VAL(R_IRQ_READ1_, sw_int6_, v2) << R_IRQ_READ1__sw_int6__BITNR) | \
  (R_IRQ_READ1__sw_int5__##f3##__VAL(R_IRQ_READ1_, sw_int5_, v3) << R_IRQ_READ1__sw_int5__BITNR) | \
  (R_IRQ_READ1__sw_int4__##f4##__VAL(R_IRQ_READ1_, sw_int4_, v4) << R_IRQ_READ1__sw_int4__BITNR) | \
  (R_IRQ_READ1__sw_int3__##f5##__VAL(R_IRQ_READ1_, sw_int3_, v5) << R_IRQ_READ1__sw_int3__BITNR) | \
  (R_IRQ_READ1__sw_int2__##f6##__VAL(R_IRQ_READ1_, sw_int2_, v6) << R_IRQ_READ1__sw_int2__BITNR) | \
  (R_IRQ_READ1__sw_int1__##f7##__VAL(R_IRQ_READ1_, sw_int1_, v7) << R_IRQ_READ1__sw_int1__BITNR) | \
  (R_IRQ_READ1__sw_int0__##f8##__VAL(R_IRQ_READ1_, sw_int0_, v8) << R_IRQ_READ1__sw_int0__BITNR) | \
  (R_IRQ_READ1__par1_ecp_cmd__##f9##__VAL(R_IRQ_READ1_, par1_ecp_cmd_, v9) << R_IRQ_READ1__par1_ecp_cmd__BITNR) | \
  (R_IRQ_READ1__par1_peri__##f10##__VAL(R_IRQ_READ1_, par1_peri_, v10) << R_IRQ_READ1__par1_peri__BITNR) | \
  (R_IRQ_READ1__par1_data__##f11##__VAL(R_IRQ_READ1_, par1_data_, v11) << R_IRQ_READ1__par1_data__BITNR) | \
  (R_IRQ_READ1__par1_ready__##f12##__VAL(R_IRQ_READ1_, par1_ready_, v12) << R_IRQ_READ1__par1_ready__BITNR) | \
  (R_IRQ_READ1__ser3_ready__##f13##__VAL(R_IRQ_READ1_, ser3_ready_, v13) << R_IRQ_READ1__ser3_ready__BITNR) | \
  (R_IRQ_READ1__ser3_data__##f14##__VAL(R_IRQ_READ1_, ser3_data_, v14) << R_IRQ_READ1__ser3_data__BITNR) | \
  (R_IRQ_READ1__ser2_ready__##f15##__VAL(R_IRQ_READ1_, ser2_ready_, v15) << R_IRQ_READ1__ser2_ready__BITNR) | \
  (R_IRQ_READ1__ser2_data__##f16##__VAL(R_IRQ_READ1_, ser2_data_, v16) << R_IRQ_READ1__ser2_data__BITNR) | \
  (R_IRQ_READ1__ser1_ready__##f17##__VAL(R_IRQ_READ1_, ser1_ready_, v17) << R_IRQ_READ1__ser1_ready__BITNR) | \
  (R_IRQ_READ1__ser1_data__##f18##__VAL(R_IRQ_READ1_, ser1_data_, v18) << R_IRQ_READ1__ser1_data__BITNR) | \
  (R_IRQ_READ1__ser0_ready__##f19##__VAL(R_IRQ_READ1_, ser0_ready_, v19) << R_IRQ_READ1__ser0_ready__BITNR) | \
  (R_IRQ_READ1__ser0_data__##f20##__VAL(R_IRQ_READ1_, ser0_data_, v20) << R_IRQ_READ1__ser0_data__BITNR) | \
  (R_IRQ_READ1__pa7__##f21##__VAL(R_IRQ_READ1_, pa7_, v21) << R_IRQ_READ1__pa7__BITNR) | \
  (R_IRQ_READ1__pa6__##f22##__VAL(R_IRQ_READ1_, pa6_, v22) << R_IRQ_READ1__pa6__BITNR) | \
  (R_IRQ_READ1__pa5__##f23##__VAL(R_IRQ_READ1_, pa5_, v23) << R_IRQ_READ1__pa5__BITNR) | \
  (R_IRQ_READ1__pa4__##f24##__VAL(R_IRQ_READ1_, pa4_, v24) << R_IRQ_READ1__pa4__BITNR) | \
  (R_IRQ_READ1__pa3__##f25##__VAL(R_IRQ_READ1_, pa3_, v25) << R_IRQ_READ1__pa3__BITNR) | \
  (R_IRQ_READ1__pa2__##f26##__VAL(R_IRQ_READ1_, pa2_, v26) << R_IRQ_READ1__pa2__BITNR) | \
  (R_IRQ_READ1__pa1__##f27##__VAL(R_IRQ_READ1_, pa1_, v27) << R_IRQ_READ1__pa1__BITNR) | \
  (R_IRQ_READ1__pa0__##f28##__VAL(R_IRQ_READ1_, pa0_, v28) << R_IRQ_READ1__pa0__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_IRQ_READ1_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_IRQ_READ1.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_IRQ_READ1_(f1_,v1,f2_,v2,f3_,v3,f4_,v4,f5_,v5,f6_,v6,f7_,v7,f8_,v8,f9_,v9,f10_,v10,f11_,v11,f12_,v12,f13_,v13,f14_,v14,f15_,v15,f16_,v16,f17_,v17,f18_,v18,f19_,v19,f20_,v20,f21_,v21,f22_,v22,f23_,v23,f24_,v24,f25_,v25,f26_,v26,f27_,v27,f28_,v28) ( \
  (R_IRQ_READ1__sw_int7__##f1_##_VAL(R_IRQ_READ1_, sw_int7_, v1) << R_IRQ_READ1__sw_int7__BITNR) | \
  (R_IRQ_READ1__sw_int6__##f2_##_VAL(R_IRQ_READ1_, sw_int6_, v2) << R_IRQ_READ1__sw_int6__BITNR) | \
  (R_IRQ_READ1__sw_int5__##f3_##_VAL(R_IRQ_READ1_, sw_int5_, v3) << R_IRQ_READ1__sw_int5__BITNR) | \
  (R_IRQ_READ1__sw_int4__##f4_##_VAL(R_IRQ_READ1_, sw_int4_, v4) << R_IRQ_READ1__sw_int4__BITNR) | \
  (R_IRQ_READ1__sw_int3__##f5_##_VAL(R_IRQ_READ1_, sw_int3_, v5) << R_IRQ_READ1__sw_int3__BITNR) | \
  (R_IRQ_READ1__sw_int2__##f6_##_VAL(R_IRQ_READ1_, sw_int2_, v6) << R_IRQ_READ1__sw_int2__BITNR) | \
  (R_IRQ_READ1__sw_int1__##f7_##_VAL(R_IRQ_READ1_, sw_int1_, v7) << R_IRQ_READ1__sw_int1__BITNR) | \
  (R_IRQ_READ1__sw_int0__##f8_##_VAL(R_IRQ_READ1_, sw_int0_, v8) << R_IRQ_READ1__sw_int0__BITNR) | \
  (R_IRQ_READ1__par1_ecp_cmd__##f9_##_VAL(R_IRQ_READ1_, par1_ecp_cmd_, v9) << R_IRQ_READ1__par1_ecp_cmd__BITNR) | \
  (R_IRQ_READ1__par1_peri__##f10_##_VAL(R_IRQ_READ1_, par1_peri_, v10) << R_IRQ_READ1__par1_peri__BITNR) | \
  (R_IRQ_READ1__par1_data__##f11_##_VAL(R_IRQ_READ1_, par1_data_, v11) << R_IRQ_READ1__par1_data__BITNR) | \
  (R_IRQ_READ1__par1_ready__##f12_##_VAL(R_IRQ_READ1_, par1_ready_, v12) << R_IRQ_READ1__par1_ready__BITNR) | \
  (R_IRQ_READ1__ser3_ready__##f13_##_VAL(R_IRQ_READ1_, ser3_ready_, v13) << R_IRQ_READ1__ser3_ready__BITNR) | \
  (R_IRQ_READ1__ser3_data__##f14_##_VAL(R_IRQ_READ1_, ser3_data_, v14) << R_IRQ_READ1__ser3_data__BITNR) | \
  (R_IRQ_READ1__ser2_ready__##f15_##_VAL(R_IRQ_READ1_, ser2_ready_, v15) << R_IRQ_READ1__ser2_ready__BITNR) | \
  (R_IRQ_READ1__ser2_data__##f16_##_VAL(R_IRQ_READ1_, ser2_data_, v16) << R_IRQ_READ1__ser2_data__BITNR) | \
  (R_IRQ_READ1__ser1_ready__##f17_##_VAL(R_IRQ_READ1_, ser1_ready_, v17) << R_IRQ_READ1__ser1_ready__BITNR) | \
  (R_IRQ_READ1__ser1_data__##f18_##_VAL(R_IRQ_READ1_, ser1_data_, v18) << R_IRQ_READ1__ser1_data__BITNR) | \
  (R_IRQ_READ1__ser0_ready__##f19_##_VAL(R_IRQ_READ1_, ser0_ready_, v19) << R_IRQ_READ1__ser0_ready__BITNR) | \
  (R_IRQ_READ1__ser0_data__##f20_##_VAL(R_IRQ_READ1_, ser0_data_, v20) << R_IRQ_READ1__ser0_data__BITNR) | \
  (R_IRQ_READ1__pa7__##f21_##_VAL(R_IRQ_READ1_, pa7_, v21) << R_IRQ_READ1__pa7__BITNR) | \
  (R_IRQ_READ1__pa6__##f22_##_VAL(R_IRQ_READ1_, pa6_, v22) << R_IRQ_READ1__pa6__BITNR) | \
  (R_IRQ_READ1__pa5__##f23_##_VAL(R_IRQ_READ1_, pa5_, v23) << R_IRQ_READ1__pa5__BITNR) | \
  (R_IRQ_READ1__pa4__##f24_##_VAL(R_IRQ_READ1_, pa4_, v24) << R_IRQ_READ1__pa4__BITNR) | \
  (R_IRQ_READ1__pa3__##f25_##_VAL(R_IRQ_READ1_, pa3_, v25) << R_IRQ_READ1__pa3__BITNR) | \
  (R_IRQ_READ1__pa2__##f26_##_VAL(R_IRQ_READ1_, pa2_, v26) << R_IRQ_READ1__pa2__BITNR) | \
  (R_IRQ_READ1__pa1__##f27_##_VAL(R_IRQ_READ1_, pa1_, v27) << R_IRQ_READ1__pa1__BITNR) | \
  (R_IRQ_READ1__pa0__##f28_##_VAL(R_IRQ_READ1_, pa0_, v28) << R_IRQ_READ1__pa0__BITNR) \
)

#endif

/*
 *  R_IRQ_READ2
 *  - type:  RO
 *  - addr:  0xb00000d4
 *  - group: Interrupt mask and status registers
 */

#if USE_GROUP__Interrupt_mask_and_status_registers

/* No REG_SET__register-name for read only registers. */

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_IRQ_READ2
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_IRQ_READ2(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11,f12,v12,f13,v13,f14,v14,f15,v15,f16,v16,f17,v17,f18,v18,f19,v19,f20,v20,f21,v21,f22,v22,f23,v23,f24,v24) ( \
  (R_IRQ_READ2__dma8_sub3_descr__##f1##__MASK & REG__##v1) | \
  (R_IRQ_READ2__dma8_sub2_descr__##f2##__MASK & REG__##v2) | \
  (R_IRQ_READ2__dma8_sub1_descr__##f3##__MASK & REG__##v3) | \
  (R_IRQ_READ2__dma8_sub0_descr__##f4##__MASK & REG__##v4) | \
  (R_IRQ_READ2__dma9_eop__##f5##__MASK & REG__##v5) | \
  (R_IRQ_READ2__dma9_descr__##f6##__MASK & REG__##v6) | \
  (R_IRQ_READ2__dma8_eop__##f7##__MASK & REG__##v7) | \
  (R_IRQ_READ2__dma8_descr__##f8##__MASK & REG__##v8) | \
  (R_IRQ_READ2__dma7_eop__##f9##__MASK & REG__##v9) | \
  (R_IRQ_READ2__dma7_descr__##f10##__MASK & REG__##v10) | \
  (R_IRQ_READ2__dma6_eop__##f11##__MASK & REG__##v11) | \
  (R_IRQ_READ2__dma6_descr__##f12##__MASK & REG__##v12) | \
  (R_IRQ_READ2__dma5_eop__##f13##__MASK & REG__##v13) | \
  (R_IRQ_READ2__dma5_descr__##f14##__MASK & REG__##v14) | \
  (R_IRQ_READ2__dma4_eop__##f15##__MASK & REG__##v15) | \
  (R_IRQ_READ2__dma4_descr__##f16##__MASK & REG__##v16) | \
  (R_IRQ_READ2__dma3_eop__##f17##__MASK & REG__##v17) | \
  (R_IRQ_READ2__dma3_descr__##f18##__MASK & REG__##v18) | \
  (R_IRQ_READ2__dma2_eop__##f19##__MASK & REG__##v19) | \
  (R_IRQ_READ2__dma2_descr__##f20##__MASK & REG__##v20) | \
  (R_IRQ_READ2__dma1_eop__##f21##__MASK & REG__##v21) | \
  (R_IRQ_READ2__dma1_descr__##f22##__MASK & REG__##v22) | \
  (R_IRQ_READ2__dma0_eop__##f23##__MASK & REG__##v23) | \
  (R_IRQ_READ2__dma0_descr__##f24##__MASK & REG__##v24) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_IRQ_READ2
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_IRQ_READ2.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_IRQ_READ2(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11,f12,v12,f13,v13,f14,v14,f15,v15,f16,v16,f17,v17,f18,v18,f19,v19,f20,v20,f21,v21,f22,v22,f23,v23,f24,v24) ( \
  (R_IRQ_READ2__dma8_sub3_descr__##f1##__VAL(R_IRQ_READ2_, dma8_sub3_descr_, v1) << R_IRQ_READ2__dma8_sub3_descr__BITNR) | \
  (R_IRQ_READ2__dma8_sub2_descr__##f2##__VAL(R_IRQ_READ2_, dma8_sub2_descr_, v2) << R_IRQ_READ2__dma8_sub2_descr__BITNR) | \
  (R_IRQ_READ2__dma8_sub1_descr__##f3##__VAL(R_IRQ_READ2_, dma8_sub1_descr_, v3) << R_IRQ_READ2__dma8_sub1_descr__BITNR) | \
  (R_IRQ_READ2__dma8_sub0_descr__##f4##__VAL(R_IRQ_READ2_, dma8_sub0_descr_, v4) << R_IRQ_READ2__dma8_sub0_descr__BITNR) | \
  (R_IRQ_READ2__dma9_eop__##f5##__VAL(R_IRQ_READ2_, dma9_eop_, v5) << R_IRQ_READ2__dma9_eop__BITNR) | \
  (R_IRQ_READ2__dma9_descr__##f6##__VAL(R_IRQ_READ2_, dma9_descr_, v6) << R_IRQ_READ2__dma9_descr__BITNR) | \
  (R_IRQ_READ2__dma8_eop__##f7##__VAL(R_IRQ_READ2_, dma8_eop_, v7) << R_IRQ_READ2__dma8_eop__BITNR) | \
  (R_IRQ_READ2__dma8_descr__##f8##__VAL(R_IRQ_READ2_, dma8_descr_, v8) << R_IRQ_READ2__dma8_descr__BITNR) | \
  (R_IRQ_READ2__dma7_eop__##f9##__VAL(R_IRQ_READ2_, dma7_eop_, v9) << R_IRQ_READ2__dma7_eop__BITNR) | \
  (R_IRQ_READ2__dma7_descr__##f10##__VAL(R_IRQ_READ2_, dma7_descr_, v10) << R_IRQ_READ2__dma7_descr__BITNR) | \
  (R_IRQ_READ2__dma6_eop__##f11##__VAL(R_IRQ_READ2_, dma6_eop_, v11) << R_IRQ_READ2__dma6_eop__BITNR) | \
  (R_IRQ_READ2__dma6_descr__##f12##__VAL(R_IRQ_READ2_, dma6_descr_, v12) << R_IRQ_READ2__dma6_descr__BITNR) | \
  (R_IRQ_READ2__dma5_eop__##f13##__VAL(R_IRQ_READ2_, dma5_eop_, v13) << R_IRQ_READ2__dma5_eop__BITNR) | \
  (R_IRQ_READ2__dma5_descr__##f14##__VAL(R_IRQ_READ2_, dma5_descr_, v14) << R_IRQ_READ2__dma5_descr__BITNR) | \
  (R_IRQ_READ2__dma4_eop__##f15##__VAL(R_IRQ_READ2_, dma4_eop_, v15) << R_IRQ_READ2__dma4_eop__BITNR) | \
  (R_IRQ_READ2__dma4_descr__##f16##__VAL(R_IRQ_READ2_, dma4_descr_, v16) << R_IRQ_READ2__dma4_descr__BITNR) | \
  (R_IRQ_READ2__dma3_eop__##f17##__VAL(R_IRQ_READ2_, dma3_eop_, v17) << R_IRQ_READ2__dma3_eop__BITNR) | \
  (R_IRQ_READ2__dma3_descr__##f18##__VAL(R_IRQ_READ2_, dma3_descr_, v18) << R_IRQ_READ2__dma3_descr__BITNR) | \
  (R_IRQ_READ2__dma2_eop__##f19##__VAL(R_IRQ_READ2_, dma2_eop_, v19) << R_IRQ_READ2__dma2_eop__BITNR) | \
  (R_IRQ_READ2__dma2_descr__##f20##__VAL(R_IRQ_READ2_, dma2_descr_, v20) << R_IRQ_READ2__dma2_descr__BITNR) | \
  (R_IRQ_READ2__dma1_eop__##f21##__VAL(R_IRQ_READ2_, dma1_eop_, v21) << R_IRQ_READ2__dma1_eop__BITNR) | \
  (R_IRQ_READ2__dma1_descr__##f22##__VAL(R_IRQ_READ2_, dma1_descr_, v22) << R_IRQ_READ2__dma1_descr__BITNR) | \
  (R_IRQ_READ2__dma0_eop__##f23##__VAL(R_IRQ_READ2_, dma0_eop_, v23) << R_IRQ_READ2__dma0_eop__BITNR) | \
  (R_IRQ_READ2__dma0_descr__##f24##__VAL(R_IRQ_READ2_, dma0_descr_, v24) << R_IRQ_READ2__dma0_descr__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_IRQ_READ2_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_IRQ_READ2.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_IRQ_READ2_(f1_,v1,f2_,v2,f3_,v3,f4_,v4,f5_,v5,f6_,v6,f7_,v7,f8_,v8,f9_,v9,f10_,v10,f11_,v11,f12_,v12,f13_,v13,f14_,v14,f15_,v15,f16_,v16,f17_,v17,f18_,v18,f19_,v19,f20_,v20,f21_,v21,f22_,v22,f23_,v23,f24_,v24) ( \
  (R_IRQ_READ2__dma8_sub3_descr__##f1_##_VAL(R_IRQ_READ2_, dma8_sub3_descr_, v1) << R_IRQ_READ2__dma8_sub3_descr__BITNR) | \
  (R_IRQ_READ2__dma8_sub2_descr__##f2_##_VAL(R_IRQ_READ2_, dma8_sub2_descr_, v2) << R_IRQ_READ2__dma8_sub2_descr__BITNR) | \
  (R_IRQ_READ2__dma8_sub1_descr__##f3_##_VAL(R_IRQ_READ2_, dma8_sub1_descr_, v3) << R_IRQ_READ2__dma8_sub1_descr__BITNR) | \
  (R_IRQ_READ2__dma8_sub0_descr__##f4_##_VAL(R_IRQ_READ2_, dma8_sub0_descr_, v4) << R_IRQ_READ2__dma8_sub0_descr__BITNR) | \
  (R_IRQ_READ2__dma9_eop__##f5_##_VAL(R_IRQ_READ2_, dma9_eop_, v5) << R_IRQ_READ2__dma9_eop__BITNR) | \
  (R_IRQ_READ2__dma9_descr__##f6_##_VAL(R_IRQ_READ2_, dma9_descr_, v6) << R_IRQ_READ2__dma9_descr__BITNR) | \
  (R_IRQ_READ2__dma8_eop__##f7_##_VAL(R_IRQ_READ2_, dma8_eop_, v7) << R_IRQ_READ2__dma8_eop__BITNR) | \
  (R_IRQ_READ2__dma8_descr__##f8_##_VAL(R_IRQ_READ2_, dma8_descr_, v8) << R_IRQ_READ2__dma8_descr__BITNR) | \
  (R_IRQ_READ2__dma7_eop__##f9_##_VAL(R_IRQ_READ2_, dma7_eop_, v9) << R_IRQ_READ2__dma7_eop__BITNR) | \
  (R_IRQ_READ2__dma7_descr__##f10_##_VAL(R_IRQ_READ2_, dma7_descr_, v10) << R_IRQ_READ2__dma7_descr__BITNR) | \
  (R_IRQ_READ2__dma6_eop__##f11_##_VAL(R_IRQ_READ2_, dma6_eop_, v11) << R_IRQ_READ2__dma6_eop__BITNR) | \
  (R_IRQ_READ2__dma6_descr__##f12_##_VAL(R_IRQ_READ2_, dma6_descr_, v12) << R_IRQ_READ2__dma6_descr__BITNR) | \
  (R_IRQ_READ2__dma5_eop__##f13_##_VAL(R_IRQ_READ2_, dma5_eop_, v13) << R_IRQ_READ2__dma5_eop__BITNR) | \
  (R_IRQ_READ2__dma5_descr__##f14_##_VAL(R_IRQ_READ2_, dma5_descr_, v14) << R_IRQ_READ2__dma5_descr__BITNR) | \
  (R_IRQ_READ2__dma4_eop__##f15_##_VAL(R_IRQ_READ2_, dma4_eop_, v15) << R_IRQ_READ2__dma4_eop__BITNR) | \
  (R_IRQ_READ2__dma4_descr__##f16_##_VAL(R_IRQ_READ2_, dma4_descr_, v16) << R_IRQ_READ2__dma4_descr__BITNR) | \
  (R_IRQ_READ2__dma3_eop__##f17_##_VAL(R_IRQ_READ2_, dma3_eop_, v17) << R_IRQ_READ2__dma3_eop__BITNR) | \
  (R_IRQ_READ2__dma3_descr__##f18_##_VAL(R_IRQ_READ2_, dma3_descr_, v18) << R_IRQ_READ2__dma3_descr__BITNR) | \
  (R_IRQ_READ2__dma2_eop__##f19_##_VAL(R_IRQ_READ2_, dma2_eop_, v19) << R_IRQ_READ2__dma2_eop__BITNR) | \
  (R_IRQ_READ2__dma2_descr__##f20_##_VAL(R_IRQ_READ2_, dma2_descr_, v20) << R_IRQ_READ2__dma2_descr__BITNR) | \
  (R_IRQ_READ2__dma1_eop__##f21_##_VAL(R_IRQ_READ2_, dma1_eop_, v21) << R_IRQ_READ2__dma1_eop__BITNR) | \
  (R_IRQ_READ2__dma1_descr__##f22_##_VAL(R_IRQ_READ2_, dma1_descr_, v22) << R_IRQ_READ2__dma1_descr__BITNR) | \
  (R_IRQ_READ2__dma0_eop__##f23_##_VAL(R_IRQ_READ2_, dma0_eop_, v23) << R_IRQ_READ2__dma0_eop__BITNR) | \
  (R_IRQ_READ2__dma0_descr__##f24_##_VAL(R_IRQ_READ2_, dma0_descr_, v24) << R_IRQ_READ2__dma0_descr__BITNR) \
)

#endif

/*
 *  R_MMU_CAUSE
 *  - type:  RO
 *  - addr:  0xb0000250
 *  - group: MMU registers
 */

#if USE_GROUP__MMU_registers

/* No REG_SET__register-name for read only registers. */

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_MMU_CAUSE
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_MMU_CAUSE(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7) ( \
  (R_MMU_CAUSE__vpn__##f1##__MASK & REG__##v1) | \
  (R_MMU_CAUSE__miss_excp__##f2##__MASK & REG__##v2) | \
  (R_MMU_CAUSE__inv_excp__##f3##__MASK & REG__##v3) | \
  (R_MMU_CAUSE__acc_excp__##f4##__MASK & REG__##v4) | \
  (R_MMU_CAUSE__we_excp__##f5##__MASK & REG__##v5) | \
  (R_MMU_CAUSE__wr_rd__##f6##__MASK & REG__##v6) | \
  (R_MMU_CAUSE__page_id__##f7##__MASK & REG__##v7) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_MMU_CAUSE
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_MMU_CAUSE.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_MMU_CAUSE(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7) ( \
  (R_MMU_CAUSE__vpn__##f1##__VAL(R_MMU_CAUSE_, vpn_, v1) << R_MMU_CAUSE__vpn__BITNR) | \
  (R_MMU_CAUSE__miss_excp__##f2##__VAL(R_MMU_CAUSE_, miss_excp_, v2) << R_MMU_CAUSE__miss_excp__BITNR) | \
  (R_MMU_CAUSE__inv_excp__##f3##__VAL(R_MMU_CAUSE_, inv_excp_, v3) << R_MMU_CAUSE__inv_excp__BITNR) | \
  (R_MMU_CAUSE__acc_excp__##f4##__VAL(R_MMU_CAUSE_, acc_excp_, v4) << R_MMU_CAUSE__acc_excp__BITNR) | \
  (R_MMU_CAUSE__we_excp__##f5##__VAL(R_MMU_CAUSE_, we_excp_, v5) << R_MMU_CAUSE__we_excp__BITNR) | \
  (R_MMU_CAUSE__wr_rd__##f6##__VAL(R_MMU_CAUSE_, wr_rd_, v6) << R_MMU_CAUSE__wr_rd__BITNR) | \
  (R_MMU_CAUSE__page_id__##f7##__VAL(R_MMU_CAUSE_, page_id_, v7) << R_MMU_CAUSE__page_id__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_MMU_CAUSE_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_MMU_CAUSE.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_MMU_CAUSE_(f1_,v1,f2_,v2,f3_,v3,f4_,v4,f5_,v5,f6_,v6,f7_,v7) ( \
  (R_MMU_CAUSE__vpn__##f1_##_VAL(R_MMU_CAUSE_, vpn_, v1) << R_MMU_CAUSE__vpn__BITNR) | \
  (R_MMU_CAUSE__miss_excp__##f2_##_VAL(R_MMU_CAUSE_, miss_excp_, v2) << R_MMU_CAUSE__miss_excp__BITNR) | \
  (R_MMU_CAUSE__inv_excp__##f3_##_VAL(R_MMU_CAUSE_, inv_excp_, v3) << R_MMU_CAUSE__inv_excp__BITNR) | \
  (R_MMU_CAUSE__acc_excp__##f4_##_VAL(R_MMU_CAUSE_, acc_excp_, v4) << R_MMU_CAUSE__acc_excp__BITNR) | \
  (R_MMU_CAUSE__we_excp__##f5_##_VAL(R_MMU_CAUSE_, we_excp_, v5) << R_MMU_CAUSE__we_excp__BITNR) | \
  (R_MMU_CAUSE__wr_rd__##f6_##_VAL(R_MMU_CAUSE_, wr_rd_, v6) << R_MMU_CAUSE__wr_rd__BITNR) | \
  (R_MMU_CAUSE__page_id__##f7_##_VAL(R_MMU_CAUSE_, page_id_, v7) << R_MMU_CAUSE__page_id__BITNR) \
)

#endif

/*
 *  R_MMU_CONFIG
 *  - type:  WO
 *  - addr:  0xb0000240
 *  - group: MMU registers
 */

#if USE_GROUP__MMU_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_MMU_CONFIG
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_MMU_CONFIG.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_MMU_CONFIG. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_MMU_CONFIG(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11,f12,v12,f13,v13,f14,v14,f15,v15,f16,v16,f17,v17,f18,v18,f19,v19,f20,v20) ( \
  *R_MMU_CONFIG__SADDR = ( \
    REG_INITIATED(R_MMU_CONFIG_) \
    REG_VAL__R_MMU_CONFIG_(f1##_,v1,f2##_,v2,f3##_,v3,f4##_,v4,f5##_,v5,f6##_,v6,f7##_,v7,f8##_,v8,f9##_,v9,f10##_,v10,f11##_,v11,f12##_,v12,f13##_,v13,f14##_,v14,f15##_,v15,f16##_,v16,f17##_,v17,f18##_,v18,f19##_,v19,f20##_,v20) \
  ), \
  R_MMU_CONFIG__WRITE(R_MMU_CONFIG__ADDR, *R_MMU_CONFIG__SADDR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_MMU_CONFIG__SHADOW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_MMU_CONFIG.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in the 
*#               shadow register for R_MMU_CONFIG. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_MMU_CONFIG__SHADOW(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11,f12,v12,f13,v13,f14,v14,f15,v15,f16,v16,f17,v17,f18,v18,f19,v19,f20,v20) ( \
  *R_MMU_CONFIG__SADDR = ( \
    REG_INITIATED(R_MMU_CONFIG_) \
    REG_VAL__R_MMU_CONFIG_(f1##_,v1,f2##_,v2,f3##_,v3,f4##_,v4,f5##_,v5,f6##_,v6,f7##_,v7,f8##_,v8,f9##_,v9,f10##_,v10,f11##_,v11,f12##_,v12,f13##_,v13,f14##_,v14,f15##_,v15,f16##_,v16,f17##_,v17,f18##_,v18,f19##_,v19,f20##_,v20) \
  ) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_MMU_CONFIG
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_MMU_CONFIG(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11,f12,v12,f13,v13,f14,v14,f15,v15,f16,v16,f17,v17,f18,v18,f19,v19,f20,v20) ( \
  (R_MMU_CONFIG__mmu_enable__##f1##__MASK & REG__##v1) | \
  (R_MMU_CONFIG__inv_excp__##f2##__MASK & REG__##v2) | \
  (R_MMU_CONFIG__acc_excp__##f3##__MASK & REG__##v3) | \
  (R_MMU_CONFIG__we_excp__##f4##__MASK & REG__##v4) | \
  (R_MMU_CONFIG__seg_f__##f5##__MASK & REG__##v5) | \
  (R_MMU_CONFIG__seg_e__##f6##__MASK & REG__##v6) | \
  (R_MMU_CONFIG__seg_d__##f7##__MASK & REG__##v7) | \
  (R_MMU_CONFIG__seg_c__##f8##__MASK & REG__##v8) | \
  (R_MMU_CONFIG__seg_b__##f9##__MASK & REG__##v9) | \
  (R_MMU_CONFIG__seg_a__##f10##__MASK & REG__##v10) | \
  (R_MMU_CONFIG__seg_9__##f11##__MASK & REG__##v11) | \
  (R_MMU_CONFIG__seg_8__##f12##__MASK & REG__##v12) | \
  (R_MMU_CONFIG__seg_7__##f13##__MASK & REG__##v13) | \
  (R_MMU_CONFIG__seg_6__##f14##__MASK & REG__##v14) | \
  (R_MMU_CONFIG__seg_5__##f15##__MASK & REG__##v15) | \
  (R_MMU_CONFIG__seg_4__##f16##__MASK & REG__##v16) | \
  (R_MMU_CONFIG__seg_3__##f17##__MASK & REG__##v17) | \
  (R_MMU_CONFIG__seg_2__##f18##__MASK & REG__##v18) | \
  (R_MMU_CONFIG__seg_1__##f19##__MASK & REG__##v19) | \
  (R_MMU_CONFIG__seg_0__##f20##__MASK & REG__##v20) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_MMU_CONFIG
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_MMU_CONFIG.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_MMU_CONFIG(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11,f12,v12,f13,v13,f14,v14,f15,v15,f16,v16,f17,v17,f18,v18,f19,v19,f20,v20) ( \
  (R_MMU_CONFIG__mmu_enable__##f1##__VAL(R_MMU_CONFIG_, mmu_enable_, v1) << R_MMU_CONFIG__mmu_enable__BITNR) | \
  (R_MMU_CONFIG__inv_excp__##f2##__VAL(R_MMU_CONFIG_, inv_excp_, v2) << R_MMU_CONFIG__inv_excp__BITNR) | \
  (R_MMU_CONFIG__acc_excp__##f3##__VAL(R_MMU_CONFIG_, acc_excp_, v3) << R_MMU_CONFIG__acc_excp__BITNR) | \
  (R_MMU_CONFIG__we_excp__##f4##__VAL(R_MMU_CONFIG_, we_excp_, v4) << R_MMU_CONFIG__we_excp__BITNR) | \
  (R_MMU_CONFIG__seg_f__##f5##__VAL(R_MMU_CONFIG_, seg_f_, v5) << R_MMU_CONFIG__seg_f__BITNR) | \
  (R_MMU_CONFIG__seg_e__##f6##__VAL(R_MMU_CONFIG_, seg_e_, v6) << R_MMU_CONFIG__seg_e__BITNR) | \
  (R_MMU_CONFIG__seg_d__##f7##__VAL(R_MMU_CONFIG_, seg_d_, v7) << R_MMU_CONFIG__seg_d__BITNR) | \
  (R_MMU_CONFIG__seg_c__##f8##__VAL(R_MMU_CONFIG_, seg_c_, v8) << R_MMU_CONFIG__seg_c__BITNR) | \
  (R_MMU_CONFIG__seg_b__##f9##__VAL(R_MMU_CONFIG_, seg_b_, v9) << R_MMU_CONFIG__seg_b__BITNR) | \
  (R_MMU_CONFIG__seg_a__##f10##__VAL(R_MMU_CONFIG_, seg_a_, v10) << R_MMU_CONFIG__seg_a__BITNR) | \
  (R_MMU_CONFIG__seg_9__##f11##__VAL(R_MMU_CONFIG_, seg_9_, v11) << R_MMU_CONFIG__seg_9__BITNR) | \
  (R_MMU_CONFIG__seg_8__##f12##__VAL(R_MMU_CONFIG_, seg_8_, v12) << R_MMU_CONFIG__seg_8__BITNR) | \
  (R_MMU_CONFIG__seg_7__##f13##__VAL(R_MMU_CONFIG_, seg_7_, v13) << R_MMU_CONFIG__seg_7__BITNR) | \
  (R_MMU_CONFIG__seg_6__##f14##__VAL(R_MMU_CONFIG_, seg_6_, v14) << R_MMU_CONFIG__seg_6__BITNR) | \
  (R_MMU_CONFIG__seg_5__##f15##__VAL(R_MMU_CONFIG_, seg_5_, v15) << R_MMU_CONFIG__seg_5__BITNR) | \
  (R_MMU_CONFIG__seg_4__##f16##__VAL(R_MMU_CONFIG_, seg_4_, v16) << R_MMU_CONFIG__seg_4__BITNR) | \
  (R_MMU_CONFIG__seg_3__##f17##__VAL(R_MMU_CONFIG_, seg_3_, v17) << R_MMU_CONFIG__seg_3__BITNR) | \
  (R_MMU_CONFIG__seg_2__##f18##__VAL(R_MMU_CONFIG_, seg_2_, v18) << R_MMU_CONFIG__seg_2__BITNR) | \
  (R_MMU_CONFIG__seg_1__##f19##__VAL(R_MMU_CONFIG_, seg_1_, v19) << R_MMU_CONFIG__seg_1__BITNR) | \
  (R_MMU_CONFIG__seg_0__##f20##__VAL(R_MMU_CONFIG_, seg_0_, v20) << R_MMU_CONFIG__seg_0__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_MMU_CONFIG_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_MMU_CONFIG.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_MMU_CONFIG_(f1_,v1,f2_,v2,f3_,v3,f4_,v4,f5_,v5,f6_,v6,f7_,v7,f8_,v8,f9_,v9,f10_,v10,f11_,v11,f12_,v12,f13_,v13,f14_,v14,f15_,v15,f16_,v16,f17_,v17,f18_,v18,f19_,v19,f20_,v20) ( \
  (R_MMU_CONFIG__mmu_enable__##f1_##_VAL(R_MMU_CONFIG_, mmu_enable_, v1) << R_MMU_CONFIG__mmu_enable__BITNR) | \
  (R_MMU_CONFIG__inv_excp__##f2_##_VAL(R_MMU_CONFIG_, inv_excp_, v2) << R_MMU_CONFIG__inv_excp__BITNR) | \
  (R_MMU_CONFIG__acc_excp__##f3_##_VAL(R_MMU_CONFIG_, acc_excp_, v3) << R_MMU_CONFIG__acc_excp__BITNR) | \
  (R_MMU_CONFIG__we_excp__##f4_##_VAL(R_MMU_CONFIG_, we_excp_, v4) << R_MMU_CONFIG__we_excp__BITNR) | \
  (R_MMU_CONFIG__seg_f__##f5_##_VAL(R_MMU_CONFIG_, seg_f_, v5) << R_MMU_CONFIG__seg_f__BITNR) | \
  (R_MMU_CONFIG__seg_e__##f6_##_VAL(R_MMU_CONFIG_, seg_e_, v6) << R_MMU_CONFIG__seg_e__BITNR) | \
  (R_MMU_CONFIG__seg_d__##f7_##_VAL(R_MMU_CONFIG_, seg_d_, v7) << R_MMU_CONFIG__seg_d__BITNR) | \
  (R_MMU_CONFIG__seg_c__##f8_##_VAL(R_MMU_CONFIG_, seg_c_, v8) << R_MMU_CONFIG__seg_c__BITNR) | \
  (R_MMU_CONFIG__seg_b__##f9_##_VAL(R_MMU_CONFIG_, seg_b_, v9) << R_MMU_CONFIG__seg_b__BITNR) | \
  (R_MMU_CONFIG__seg_a__##f10_##_VAL(R_MMU_CONFIG_, seg_a_, v10) << R_MMU_CONFIG__seg_a__BITNR) | \
  (R_MMU_CONFIG__seg_9__##f11_##_VAL(R_MMU_CONFIG_, seg_9_, v11) << R_MMU_CONFIG__seg_9__BITNR) | \
  (R_MMU_CONFIG__seg_8__##f12_##_VAL(R_MMU_CONFIG_, seg_8_, v12) << R_MMU_CONFIG__seg_8__BITNR) | \
  (R_MMU_CONFIG__seg_7__##f13_##_VAL(R_MMU_CONFIG_, seg_7_, v13) << R_MMU_CONFIG__seg_7__BITNR) | \
  (R_MMU_CONFIG__seg_6__##f14_##_VAL(R_MMU_CONFIG_, seg_6_, v14) << R_MMU_CONFIG__seg_6__BITNR) | \
  (R_MMU_CONFIG__seg_5__##f15_##_VAL(R_MMU_CONFIG_, seg_5_, v15) << R_MMU_CONFIG__seg_5__BITNR) | \
  (R_MMU_CONFIG__seg_4__##f16_##_VAL(R_MMU_CONFIG_, seg_4_, v16) << R_MMU_CONFIG__seg_4__BITNR) | \
  (R_MMU_CONFIG__seg_3__##f17_##_VAL(R_MMU_CONFIG_, seg_3_, v17) << R_MMU_CONFIG__seg_3__BITNR) | \
  (R_MMU_CONFIG__seg_2__##f18_##_VAL(R_MMU_CONFIG_, seg_2_, v18) << R_MMU_CONFIG__seg_2__BITNR) | \
  (R_MMU_CONFIG__seg_1__##f19_##_VAL(R_MMU_CONFIG_, seg_1_, v19) << R_MMU_CONFIG__seg_1__BITNR) | \
  (R_MMU_CONFIG__seg_0__##f20_##_VAL(R_MMU_CONFIG_, seg_0_, v20) << R_MMU_CONFIG__seg_0__BITNR) \
)

#endif

/*
 *  R_MMU_CONTEXT
 *  - type:  RW
 *  - addr:  0xb000024c
 *  - group: MMU registers
 */

#if USE_GROUP__MMU_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_MMU_CONTEXT
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_MMU_CONTEXT.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_MMU_CONTEXT. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_MMU_CONTEXT(f1,v1) ( \
  R_MMU_CONTEXT__WRITE(R_MMU_CONTEXT__ADDR, ( \
    REG_VAL__R_MMU_CONTEXT_(f1##_,v1) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_MMU_CONTEXT
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_MMU_CONTEXT(f1,v1) ( \
  (R_MMU_CONTEXT__page_id__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_MMU_CONTEXT
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_MMU_CONTEXT.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_MMU_CONTEXT(f1,v1) ( \
  (R_MMU_CONTEXT__page_id__##f1##__VAL(R_MMU_CONTEXT_, page_id_, v1) << R_MMU_CONTEXT__page_id__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_MMU_CONTEXT_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_MMU_CONTEXT.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_MMU_CONTEXT_(f1_,v1) ( \
  (R_MMU_CONTEXT__page_id__##f1_##_VAL(R_MMU_CONTEXT_, page_id_, v1) << R_MMU_CONTEXT__page_id__BITNR) \
)

#endif

/*
 *  R_MMU_CTRL
 *  - type:  WO
 *  - addr:  0xb0000242
 *  - group: MMU registers
 */

#if USE_GROUP__MMU_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_MMU_CTRL
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_MMU_CTRL.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_MMU_CTRL. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_MMU_CTRL(f1,v1,f2,v2,f3,v3) ( \
  *R_MMU_CTRL__SADDR = ( \
    REG_INITIATED(R_MMU_CTRL_) \
    REG_VAL__R_MMU_CTRL_(f1##_,v1,f2##_,v2,f3##_,v3) \
  ), \
  R_MMU_CTRL__WRITE(R_MMU_CTRL__ADDR, *R_MMU_CTRL__SADDR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_MMU_CTRL__SHADOW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_MMU_CTRL.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in the 
*#               shadow register for R_MMU_CTRL. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_MMU_CTRL__SHADOW(f1,v1,f2,v2,f3,v3) ( \
  *R_MMU_CTRL__SADDR = ( \
    REG_INITIATED(R_MMU_CTRL_) \
    REG_VAL__R_MMU_CTRL_(f1##_,v1,f2##_,v2,f3##_,v3) \
  ) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_MMU_CTRL
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_MMU_CTRL(f1,v1,f2,v2,f3,v3) ( \
  (R_MMU_CTRL__inv_excp__##f1##__MASK & REG__##v1) | \
  (R_MMU_CTRL__acc_excp__##f2##__MASK & REG__##v2) | \
  (R_MMU_CTRL__we_excp__##f3##__MASK & REG__##v3) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_MMU_CTRL
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_MMU_CTRL.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_MMU_CTRL(f1,v1,f2,v2,f3,v3) ( \
  (R_MMU_CTRL__inv_excp__##f1##__VAL(R_MMU_CTRL_, inv_excp_, v1) << R_MMU_CTRL__inv_excp__BITNR) | \
  (R_MMU_CTRL__acc_excp__##f2##__VAL(R_MMU_CTRL_, acc_excp_, v2) << R_MMU_CTRL__acc_excp__BITNR) | \
  (R_MMU_CTRL__we_excp__##f3##__VAL(R_MMU_CTRL_, we_excp_, v3) << R_MMU_CTRL__we_excp__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_MMU_CTRL_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_MMU_CTRL.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_MMU_CTRL_(f1_,v1,f2_,v2,f3_,v3) ( \
  (R_MMU_CTRL__inv_excp__##f1_##_VAL(R_MMU_CTRL_, inv_excp_, v1) << R_MMU_CTRL__inv_excp__BITNR) | \
  (R_MMU_CTRL__acc_excp__##f2_##_VAL(R_MMU_CTRL_, acc_excp_, v2) << R_MMU_CTRL__acc_excp__BITNR) | \
  (R_MMU_CTRL__we_excp__##f3_##_VAL(R_MMU_CTRL_, we_excp_, v3) << R_MMU_CTRL__we_excp__BITNR) \
)

#endif

/*
 *  R_MMU_ENABLE
 *  - type:  WO
 *  - addr:  0xb0000243
 *  - group: MMU registers
 */

#if USE_GROUP__MMU_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_MMU_ENABLE
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_MMU_ENABLE.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_MMU_ENABLE. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_MMU_ENABLE(f1,v1) ( \
  *R_MMU_ENABLE__SADDR = ( \
    REG_INITIATED(R_MMU_ENABLE_) \
    REG_VAL__R_MMU_ENABLE_(f1##_,v1) \
  ), \
  R_MMU_ENABLE__WRITE(R_MMU_ENABLE__ADDR, *R_MMU_ENABLE__SADDR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_MMU_ENABLE__SHADOW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_MMU_ENABLE.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in the 
*#               shadow register for R_MMU_ENABLE. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_MMU_ENABLE__SHADOW(f1,v1) ( \
  *R_MMU_ENABLE__SADDR = ( \
    REG_INITIATED(R_MMU_ENABLE_) \
    REG_VAL__R_MMU_ENABLE_(f1##_,v1) \
  ) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_MMU_ENABLE
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_MMU_ENABLE(f1,v1) ( \
  (R_MMU_ENABLE__mmu_enable__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_MMU_ENABLE
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_MMU_ENABLE.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_MMU_ENABLE(f1,v1) ( \
  (R_MMU_ENABLE__mmu_enable__##f1##__VAL(R_MMU_ENABLE_, mmu_enable_, v1) << R_MMU_ENABLE__mmu_enable__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_MMU_ENABLE_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_MMU_ENABLE.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_MMU_ENABLE_(f1_,v1) ( \
  (R_MMU_ENABLE__mmu_enable__##f1_##_VAL(R_MMU_ENABLE_, mmu_enable_, v1) << R_MMU_ENABLE__mmu_enable__BITNR) \
)

#endif

/*
 *  R_MMU_KBASE_HI
 *  - type:  WO
 *  - addr:  0xb0000248
 *  - group: MMU registers
 */

#if USE_GROUP__MMU_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_MMU_KBASE_HI
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_MMU_KBASE_HI.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_MMU_KBASE_HI. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_MMU_KBASE_HI(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8) ( \
  *R_MMU_KBASE_HI__SADDR = ( \
    REG_INITIATED(R_MMU_KBASE_HI_) \
    REG_VAL__R_MMU_KBASE_HI_(f1##_,v1,f2##_,v2,f3##_,v3,f4##_,v4,f5##_,v5,f6##_,v6,f7##_,v7,f8##_,v8) \
  ), \
  R_MMU_KBASE_HI__WRITE(R_MMU_KBASE_HI__ADDR, *R_MMU_KBASE_HI__SADDR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_MMU_KBASE_HI__SHADOW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_MMU_KBASE_HI.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in the 
*#               shadow register for R_MMU_KBASE_HI. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_MMU_KBASE_HI__SHADOW(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8) ( \
  *R_MMU_KBASE_HI__SADDR = ( \
    REG_INITIATED(R_MMU_KBASE_HI_) \
    REG_VAL__R_MMU_KBASE_HI_(f1##_,v1,f2##_,v2,f3##_,v3,f4##_,v4,f5##_,v5,f6##_,v6,f7##_,v7,f8##_,v8) \
  ) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_MMU_KBASE_HI
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_MMU_KBASE_HI(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8) ( \
  (R_MMU_KBASE_HI__base_f__##f1##__MASK & REG__##v1) | \
  (R_MMU_KBASE_HI__base_e__##f2##__MASK & REG__##v2) | \
  (R_MMU_KBASE_HI__base_d__##f3##__MASK & REG__##v3) | \
  (R_MMU_KBASE_HI__base_c__##f4##__MASK & REG__##v4) | \
  (R_MMU_KBASE_HI__base_b__##f5##__MASK & REG__##v5) | \
  (R_MMU_KBASE_HI__base_a__##f6##__MASK & REG__##v6) | \
  (R_MMU_KBASE_HI__base_9__##f7##__MASK & REG__##v7) | \
  (R_MMU_KBASE_HI__base_8__##f8##__MASK & REG__##v8) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_MMU_KBASE_HI
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_MMU_KBASE_HI.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_MMU_KBASE_HI(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8) ( \
  (R_MMU_KBASE_HI__base_f__##f1##__VAL(R_MMU_KBASE_HI_, base_f_, v1) << R_MMU_KBASE_HI__base_f__BITNR) | \
  (R_MMU_KBASE_HI__base_e__##f2##__VAL(R_MMU_KBASE_HI_, base_e_, v2) << R_MMU_KBASE_HI__base_e__BITNR) | \
  (R_MMU_KBASE_HI__base_d__##f3##__VAL(R_MMU_KBASE_HI_, base_d_, v3) << R_MMU_KBASE_HI__base_d__BITNR) | \
  (R_MMU_KBASE_HI__base_c__##f4##__VAL(R_MMU_KBASE_HI_, base_c_, v4) << R_MMU_KBASE_HI__base_c__BITNR) | \
  (R_MMU_KBASE_HI__base_b__##f5##__VAL(R_MMU_KBASE_HI_, base_b_, v5) << R_MMU_KBASE_HI__base_b__BITNR) | \
  (R_MMU_KBASE_HI__base_a__##f6##__VAL(R_MMU_KBASE_HI_, base_a_, v6) << R_MMU_KBASE_HI__base_a__BITNR) | \
  (R_MMU_KBASE_HI__base_9__##f7##__VAL(R_MMU_KBASE_HI_, base_9_, v7) << R_MMU_KBASE_HI__base_9__BITNR) | \
  (R_MMU_KBASE_HI__base_8__##f8##__VAL(R_MMU_KBASE_HI_, base_8_, v8) << R_MMU_KBASE_HI__base_8__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_MMU_KBASE_HI_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_MMU_KBASE_HI.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_MMU_KBASE_HI_(f1_,v1,f2_,v2,f3_,v3,f4_,v4,f5_,v5,f6_,v6,f7_,v7,f8_,v8) ( \
  (R_MMU_KBASE_HI__base_f__##f1_##_VAL(R_MMU_KBASE_HI_, base_f_, v1) << R_MMU_KBASE_HI__base_f__BITNR) | \
  (R_MMU_KBASE_HI__base_e__##f2_##_VAL(R_MMU_KBASE_HI_, base_e_, v2) << R_MMU_KBASE_HI__base_e__BITNR) | \
  (R_MMU_KBASE_HI__base_d__##f3_##_VAL(R_MMU_KBASE_HI_, base_d_, v3) << R_MMU_KBASE_HI__base_d__BITNR) | \
  (R_MMU_KBASE_HI__base_c__##f4_##_VAL(R_MMU_KBASE_HI_, base_c_, v4) << R_MMU_KBASE_HI__base_c__BITNR) | \
  (R_MMU_KBASE_HI__base_b__##f5_##_VAL(R_MMU_KBASE_HI_, base_b_, v5) << R_MMU_KBASE_HI__base_b__BITNR) | \
  (R_MMU_KBASE_HI__base_a__##f6_##_VAL(R_MMU_KBASE_HI_, base_a_, v6) << R_MMU_KBASE_HI__base_a__BITNR) | \
  (R_MMU_KBASE_HI__base_9__##f7_##_VAL(R_MMU_KBASE_HI_, base_9_, v7) << R_MMU_KBASE_HI__base_9__BITNR) | \
  (R_MMU_KBASE_HI__base_8__##f8_##_VAL(R_MMU_KBASE_HI_, base_8_, v8) << R_MMU_KBASE_HI__base_8__BITNR) \
)

#endif

/*
 *  R_MMU_KBASE_LO
 *  - type:  WO
 *  - addr:  0xb0000244
 *  - group: MMU registers
 */

#if USE_GROUP__MMU_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_MMU_KBASE_LO
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_MMU_KBASE_LO.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_MMU_KBASE_LO. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_MMU_KBASE_LO(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8) ( \
  *R_MMU_KBASE_LO__SADDR = ( \
    REG_INITIATED(R_MMU_KBASE_LO_) \
    REG_VAL__R_MMU_KBASE_LO_(f1##_,v1,f2##_,v2,f3##_,v3,f4##_,v4,f5##_,v5,f6##_,v6,f7##_,v7,f8##_,v8) \
  ), \
  R_MMU_KBASE_LO__WRITE(R_MMU_KBASE_LO__ADDR, *R_MMU_KBASE_LO__SADDR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_MMU_KBASE_LO__SHADOW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_MMU_KBASE_LO.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in the 
*#               shadow register for R_MMU_KBASE_LO. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_MMU_KBASE_LO__SHADOW(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8) ( \
  *R_MMU_KBASE_LO__SADDR = ( \
    REG_INITIATED(R_MMU_KBASE_LO_) \
    REG_VAL__R_MMU_KBASE_LO_(f1##_,v1,f2##_,v2,f3##_,v3,f4##_,v4,f5##_,v5,f6##_,v6,f7##_,v7,f8##_,v8) \
  ) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_MMU_KBASE_LO
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_MMU_KBASE_LO(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8) ( \
  (R_MMU_KBASE_LO__base_7__##f1##__MASK & REG__##v1) | \
  (R_MMU_KBASE_LO__base_6__##f2##__MASK & REG__##v2) | \
  (R_MMU_KBASE_LO__base_5__##f3##__MASK & REG__##v3) | \
  (R_MMU_KBASE_LO__base_4__##f4##__MASK & REG__##v4) | \
  (R_MMU_KBASE_LO__base_3__##f5##__MASK & REG__##v5) | \
  (R_MMU_KBASE_LO__base_2__##f6##__MASK & REG__##v6) | \
  (R_MMU_KBASE_LO__base_1__##f7##__MASK & REG__##v7) | \
  (R_MMU_KBASE_LO__base_0__##f8##__MASK & REG__##v8) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_MMU_KBASE_LO
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_MMU_KBASE_LO.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_MMU_KBASE_LO(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8) ( \
  (R_MMU_KBASE_LO__base_7__##f1##__VAL(R_MMU_KBASE_LO_, base_7_, v1) << R_MMU_KBASE_LO__base_7__BITNR) | \
  (R_MMU_KBASE_LO__base_6__##f2##__VAL(R_MMU_KBASE_LO_, base_6_, v2) << R_MMU_KBASE_LO__base_6__BITNR) | \
  (R_MMU_KBASE_LO__base_5__##f3##__VAL(R_MMU_KBASE_LO_, base_5_, v3) << R_MMU_KBASE_LO__base_5__BITNR) | \
  (R_MMU_KBASE_LO__base_4__##f4##__VAL(R_MMU_KBASE_LO_, base_4_, v4) << R_MMU_KBASE_LO__base_4__BITNR) | \
  (R_MMU_KBASE_LO__base_3__##f5##__VAL(R_MMU_KBASE_LO_, base_3_, v5) << R_MMU_KBASE_LO__base_3__BITNR) | \
  (R_MMU_KBASE_LO__base_2__##f6##__VAL(R_MMU_KBASE_LO_, base_2_, v6) << R_MMU_KBASE_LO__base_2__BITNR) | \
  (R_MMU_KBASE_LO__base_1__##f7##__VAL(R_MMU_KBASE_LO_, base_1_, v7) << R_MMU_KBASE_LO__base_1__BITNR) | \
  (R_MMU_KBASE_LO__base_0__##f8##__VAL(R_MMU_KBASE_LO_, base_0_, v8) << R_MMU_KBASE_LO__base_0__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_MMU_KBASE_LO_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_MMU_KBASE_LO.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_MMU_KBASE_LO_(f1_,v1,f2_,v2,f3_,v3,f4_,v4,f5_,v5,f6_,v6,f7_,v7,f8_,v8) ( \
  (R_MMU_KBASE_LO__base_7__##f1_##_VAL(R_MMU_KBASE_LO_, base_7_, v1) << R_MMU_KBASE_LO__base_7__BITNR) | \
  (R_MMU_KBASE_LO__base_6__##f2_##_VAL(R_MMU_KBASE_LO_, base_6_, v2) << R_MMU_KBASE_LO__base_6__BITNR) | \
  (R_MMU_KBASE_LO__base_5__##f3_##_VAL(R_MMU_KBASE_LO_, base_5_, v3) << R_MMU_KBASE_LO__base_5__BITNR) | \
  (R_MMU_KBASE_LO__base_4__##f4_##_VAL(R_MMU_KBASE_LO_, base_4_, v4) << R_MMU_KBASE_LO__base_4__BITNR) | \
  (R_MMU_KBASE_LO__base_3__##f5_##_VAL(R_MMU_KBASE_LO_, base_3_, v5) << R_MMU_KBASE_LO__base_3__BITNR) | \
  (R_MMU_KBASE_LO__base_2__##f6_##_VAL(R_MMU_KBASE_LO_, base_2_, v6) << R_MMU_KBASE_LO__base_2__BITNR) | \
  (R_MMU_KBASE_LO__base_1__##f7_##_VAL(R_MMU_KBASE_LO_, base_1_, v7) << R_MMU_KBASE_LO__base_1__BITNR) | \
  (R_MMU_KBASE_LO__base_0__##f8_##_VAL(R_MMU_KBASE_LO_, base_0_, v8) << R_MMU_KBASE_LO__base_0__BITNR) \
)

#endif

/*
 *  R_MMU_KSEG
 *  - type:  WO
 *  - addr:  0xb0000240
 *  - group: MMU registers
 */

#if USE_GROUP__MMU_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_MMU_KSEG
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_MMU_KSEG.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_MMU_KSEG. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_MMU_KSEG(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11,f12,v12,f13,v13,f14,v14,f15,v15,f16,v16) ( \
  *R_MMU_KSEG__SADDR = ( \
    REG_INITIATED(R_MMU_KSEG_) \
    REG_VAL__R_MMU_KSEG_(f1##_,v1,f2##_,v2,f3##_,v3,f4##_,v4,f5##_,v5,f6##_,v6,f7##_,v7,f8##_,v8,f9##_,v9,f10##_,v10,f11##_,v11,f12##_,v12,f13##_,v13,f14##_,v14,f15##_,v15,f16##_,v16) \
  ), \
  R_MMU_KSEG__WRITE(R_MMU_KSEG__ADDR, *R_MMU_KSEG__SADDR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_MMU_KSEG__SHADOW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_MMU_KSEG.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in the 
*#               shadow register for R_MMU_KSEG. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_MMU_KSEG__SHADOW(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11,f12,v12,f13,v13,f14,v14,f15,v15,f16,v16) ( \
  *R_MMU_KSEG__SADDR = ( \
    REG_INITIATED(R_MMU_KSEG_) \
    REG_VAL__R_MMU_KSEG_(f1##_,v1,f2##_,v2,f3##_,v3,f4##_,v4,f5##_,v5,f6##_,v6,f7##_,v7,f8##_,v8,f9##_,v9,f10##_,v10,f11##_,v11,f12##_,v12,f13##_,v13,f14##_,v14,f15##_,v15,f16##_,v16) \
  ) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_MMU_KSEG
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_MMU_KSEG(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11,f12,v12,f13,v13,f14,v14,f15,v15,f16,v16) ( \
  (R_MMU_KSEG__seg_f__##f1##__MASK & REG__##v1) | \
  (R_MMU_KSEG__seg_e__##f2##__MASK & REG__##v2) | \
  (R_MMU_KSEG__seg_d__##f3##__MASK & REG__##v3) | \
  (R_MMU_KSEG__seg_c__##f4##__MASK & REG__##v4) | \
  (R_MMU_KSEG__seg_b__##f5##__MASK & REG__##v5) | \
  (R_MMU_KSEG__seg_a__##f6##__MASK & REG__##v6) | \
  (R_MMU_KSEG__seg_9__##f7##__MASK & REG__##v7) | \
  (R_MMU_KSEG__seg_8__##f8##__MASK & REG__##v8) | \
  (R_MMU_KSEG__seg_7__##f9##__MASK & REG__##v9) | \
  (R_MMU_KSEG__seg_6__##f10##__MASK & REG__##v10) | \
  (R_MMU_KSEG__seg_5__##f11##__MASK & REG__##v11) | \
  (R_MMU_KSEG__seg_4__##f12##__MASK & REG__##v12) | \
  (R_MMU_KSEG__seg_3__##f13##__MASK & REG__##v13) | \
  (R_MMU_KSEG__seg_2__##f14##__MASK & REG__##v14) | \
  (R_MMU_KSEG__seg_1__##f15##__MASK & REG__##v15) | \
  (R_MMU_KSEG__seg_0__##f16##__MASK & REG__##v16) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_MMU_KSEG
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_MMU_KSEG.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_MMU_KSEG(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11,f12,v12,f13,v13,f14,v14,f15,v15,f16,v16) ( \
  (R_MMU_KSEG__seg_f__##f1##__VAL(R_MMU_KSEG_, seg_f_, v1) << R_MMU_KSEG__seg_f__BITNR) | \
  (R_MMU_KSEG__seg_e__##f2##__VAL(R_MMU_KSEG_, seg_e_, v2) << R_MMU_KSEG__seg_e__BITNR) | \
  (R_MMU_KSEG__seg_d__##f3##__VAL(R_MMU_KSEG_, seg_d_, v3) << R_MMU_KSEG__seg_d__BITNR) | \
  (R_MMU_KSEG__seg_c__##f4##__VAL(R_MMU_KSEG_, seg_c_, v4) << R_MMU_KSEG__seg_c__BITNR) | \
  (R_MMU_KSEG__seg_b__##f5##__VAL(R_MMU_KSEG_, seg_b_, v5) << R_MMU_KSEG__seg_b__BITNR) | \
  (R_MMU_KSEG__seg_a__##f6##__VAL(R_MMU_KSEG_, seg_a_, v6) << R_MMU_KSEG__seg_a__BITNR) | \
  (R_MMU_KSEG__seg_9__##f7##__VAL(R_MMU_KSEG_, seg_9_, v7) << R_MMU_KSEG__seg_9__BITNR) | \
  (R_MMU_KSEG__seg_8__##f8##__VAL(R_MMU_KSEG_, seg_8_, v8) << R_MMU_KSEG__seg_8__BITNR) | \
  (R_MMU_KSEG__seg_7__##f9##__VAL(R_MMU_KSEG_, seg_7_, v9) << R_MMU_KSEG__seg_7__BITNR) | \
  (R_MMU_KSEG__seg_6__##f10##__VAL(R_MMU_KSEG_, seg_6_, v10) << R_MMU_KSEG__seg_6__BITNR) | \
  (R_MMU_KSEG__seg_5__##f11##__VAL(R_MMU_KSEG_, seg_5_, v11) << R_MMU_KSEG__seg_5__BITNR) | \
  (R_MMU_KSEG__seg_4__##f12##__VAL(R_MMU_KSEG_, seg_4_, v12) << R_MMU_KSEG__seg_4__BITNR) | \
  (R_MMU_KSEG__seg_3__##f13##__VAL(R_MMU_KSEG_, seg_3_, v13) << R_MMU_KSEG__seg_3__BITNR) | \
  (R_MMU_KSEG__seg_2__##f14##__VAL(R_MMU_KSEG_, seg_2_, v14) << R_MMU_KSEG__seg_2__BITNR) | \
  (R_MMU_KSEG__seg_1__##f15##__VAL(R_MMU_KSEG_, seg_1_, v15) << R_MMU_KSEG__seg_1__BITNR) | \
  (R_MMU_KSEG__seg_0__##f16##__VAL(R_MMU_KSEG_, seg_0_, v16) << R_MMU_KSEG__seg_0__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_MMU_KSEG_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_MMU_KSEG.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_MMU_KSEG_(f1_,v1,f2_,v2,f3_,v3,f4_,v4,f5_,v5,f6_,v6,f7_,v7,f8_,v8,f9_,v9,f10_,v10,f11_,v11,f12_,v12,f13_,v13,f14_,v14,f15_,v15,f16_,v16) ( \
  (R_MMU_KSEG__seg_f__##f1_##_VAL(R_MMU_KSEG_, seg_f_, v1) << R_MMU_KSEG__seg_f__BITNR) | \
  (R_MMU_KSEG__seg_e__##f2_##_VAL(R_MMU_KSEG_, seg_e_, v2) << R_MMU_KSEG__seg_e__BITNR) | \
  (R_MMU_KSEG__seg_d__##f3_##_VAL(R_MMU_KSEG_, seg_d_, v3) << R_MMU_KSEG__seg_d__BITNR) | \
  (R_MMU_KSEG__seg_c__##f4_##_VAL(R_MMU_KSEG_, seg_c_, v4) << R_MMU_KSEG__seg_c__BITNR) | \
  (R_MMU_KSEG__seg_b__##f5_##_VAL(R_MMU_KSEG_, seg_b_, v5) << R_MMU_KSEG__seg_b__BITNR) | \
  (R_MMU_KSEG__seg_a__##f6_##_VAL(R_MMU_KSEG_, seg_a_, v6) << R_MMU_KSEG__seg_a__BITNR) | \
  (R_MMU_KSEG__seg_9__##f7_##_VAL(R_MMU_KSEG_, seg_9_, v7) << R_MMU_KSEG__seg_9__BITNR) | \
  (R_MMU_KSEG__seg_8__##f8_##_VAL(R_MMU_KSEG_, seg_8_, v8) << R_MMU_KSEG__seg_8__BITNR) | \
  (R_MMU_KSEG__seg_7__##f9_##_VAL(R_MMU_KSEG_, seg_7_, v9) << R_MMU_KSEG__seg_7__BITNR) | \
  (R_MMU_KSEG__seg_6__##f10_##_VAL(R_MMU_KSEG_, seg_6_, v10) << R_MMU_KSEG__seg_6__BITNR) | \
  (R_MMU_KSEG__seg_5__##f11_##_VAL(R_MMU_KSEG_, seg_5_, v11) << R_MMU_KSEG__seg_5__BITNR) | \
  (R_MMU_KSEG__seg_4__##f12_##_VAL(R_MMU_KSEG_, seg_4_, v12) << R_MMU_KSEG__seg_4__BITNR) | \
  (R_MMU_KSEG__seg_3__##f13_##_VAL(R_MMU_KSEG_, seg_3_, v13) << R_MMU_KSEG__seg_3__BITNR) | \
  (R_MMU_KSEG__seg_2__##f14_##_VAL(R_MMU_KSEG_, seg_2_, v14) << R_MMU_KSEG__seg_2__BITNR) | \
  (R_MMU_KSEG__seg_1__##f15_##_VAL(R_MMU_KSEG_, seg_1_, v15) << R_MMU_KSEG__seg_1__BITNR) | \
  (R_MMU_KSEG__seg_0__##f16_##_VAL(R_MMU_KSEG_, seg_0_, v16) << R_MMU_KSEG__seg_0__BITNR) \
)

#endif

/*
 *  R_NETWORK_GA_0
 *  - type:  WO
 *  - addr:  0xb000008c
 *  - group: Network interface registers
 */

#if USE_GROUP__Network_interface_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_NETWORK_GA_0
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_NETWORK_GA_0.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_NETWORK_GA_0. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_NETWORK_GA_0(f1,v1) ( \
  *R_NETWORK_GA_0__SADDR = ( \
    REG_INITIATED(R_NETWORK_GA_0_) \
    REG_VAL__R_NETWORK_GA_0_(f1##_,v1) \
  ), \
  R_NETWORK_GA_0__WRITE(R_NETWORK_GA_0__ADDR, *R_NETWORK_GA_0__SADDR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_NETWORK_GA_0__SHADOW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_NETWORK_GA_0.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in the 
*#               shadow register for R_NETWORK_GA_0. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_NETWORK_GA_0__SHADOW(f1,v1) ( \
  *R_NETWORK_GA_0__SADDR = ( \
    REG_INITIATED(R_NETWORK_GA_0_) \
    REG_VAL__R_NETWORK_GA_0_(f1##_,v1) \
  ) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_NETWORK_GA_0
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_NETWORK_GA_0(f1,v1) ( \
  (R_NETWORK_GA_0__ga_low__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_NETWORK_GA_0
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_NETWORK_GA_0.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_NETWORK_GA_0(f1,v1) ( \
  (R_NETWORK_GA_0__ga_low__##f1##__VAL(R_NETWORK_GA_0_, ga_low_, v1) << R_NETWORK_GA_0__ga_low__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_NETWORK_GA_0_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_NETWORK_GA_0.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_NETWORK_GA_0_(f1_,v1) ( \
  (R_NETWORK_GA_0__ga_low__##f1_##_VAL(R_NETWORK_GA_0_, ga_low_, v1) << R_NETWORK_GA_0__ga_low__BITNR) \
)

#endif

/*
 *  R_NETWORK_GA_1
 *  - type:  WO
 *  - addr:  0xb0000090
 *  - group: Network interface registers
 */

#if USE_GROUP__Network_interface_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_NETWORK_GA_1
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_NETWORK_GA_1.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_NETWORK_GA_1. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_NETWORK_GA_1(f1,v1) ( \
  *R_NETWORK_GA_1__SADDR = ( \
    REG_INITIATED(R_NETWORK_GA_1_) \
    REG_VAL__R_NETWORK_GA_1_(f1##_,v1) \
  ), \
  R_NETWORK_GA_1__WRITE(R_NETWORK_GA_1__ADDR, *R_NETWORK_GA_1__SADDR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_NETWORK_GA_1__SHADOW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_NETWORK_GA_1.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in the 
*#               shadow register for R_NETWORK_GA_1. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_NETWORK_GA_1__SHADOW(f1,v1) ( \
  *R_NETWORK_GA_1__SADDR = ( \
    REG_INITIATED(R_NETWORK_GA_1_) \
    REG_VAL__R_NETWORK_GA_1_(f1##_,v1) \
  ) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_NETWORK_GA_1
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_NETWORK_GA_1(f1,v1) ( \
  (R_NETWORK_GA_1__ga_high__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_NETWORK_GA_1
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_NETWORK_GA_1.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_NETWORK_GA_1(f1,v1) ( \
  (R_NETWORK_GA_1__ga_high__##f1##__VAL(R_NETWORK_GA_1_, ga_high_, v1) << R_NETWORK_GA_1__ga_high__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_NETWORK_GA_1_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_NETWORK_GA_1.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_NETWORK_GA_1_(f1_,v1) ( \
  (R_NETWORK_GA_1__ga_high__##f1_##_VAL(R_NETWORK_GA_1_, ga_high_, v1) << R_NETWORK_GA_1__ga_high__BITNR) \
)

#endif

/*
 *  R_NETWORK_GEN_CONFIG
 *  - type:  WO
 *  - addr:  0xb0000098
 *  - group: Network interface registers
 */

#if USE_GROUP__Network_interface_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_NETWORK_GEN_CONFIG
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_NETWORK_GEN_CONFIG.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_NETWORK_GEN_CONFIG. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_NETWORK_GEN_CONFIG(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5) ( \
  *R_NETWORK_GEN_CONFIG__SADDR = ( \
    REG_INITIATED(R_NETWORK_GEN_CONFIG_) \
    REG_VAL__R_NETWORK_GEN_CONFIG_(f1##_,v1,f2##_,v2,f3##_,v3,f4##_,v4,f5##_,v5) \
  ), \
  R_NETWORK_GEN_CONFIG__WRITE(R_NETWORK_GEN_CONFIG__ADDR, *R_NETWORK_GEN_CONFIG__SADDR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_NETWORK_GEN_CONFIG__SHADOW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_NETWORK_GEN_CONFIG.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in the 
*#               shadow register for R_NETWORK_GEN_CONFIG. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_NETWORK_GEN_CONFIG__SHADOW(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5) ( \
  *R_NETWORK_GEN_CONFIG__SADDR = ( \
    REG_INITIATED(R_NETWORK_GEN_CONFIG_) \
    REG_VAL__R_NETWORK_GEN_CONFIG_(f1##_,v1,f2##_,v2,f3##_,v3,f4##_,v4,f5##_,v5) \
  ) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_NETWORK_GEN_CONFIG
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_NETWORK_GEN_CONFIG(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5) ( \
  (R_NETWORK_GEN_CONFIG__loopback__##f1##__MASK & REG__##v1) | \
  (R_NETWORK_GEN_CONFIG__frame__##f2##__MASK & REG__##v2) | \
  (R_NETWORK_GEN_CONFIG__vg__##f3##__MASK & REG__##v3) | \
  (R_NETWORK_GEN_CONFIG__phy__##f4##__MASK & REG__##v4) | \
  (R_NETWORK_GEN_CONFIG__enable__##f5##__MASK & REG__##v5) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_NETWORK_GEN_CONFIG
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_NETWORK_GEN_CONFIG.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_NETWORK_GEN_CONFIG(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5) ( \
  (R_NETWORK_GEN_CONFIG__loopback__##f1##__VAL(R_NETWORK_GEN_CONFIG_, loopback_, v1) << R_NETWORK_GEN_CONFIG__loopback__BITNR) | \
  (R_NETWORK_GEN_CONFIG__frame__##f2##__VAL(R_NETWORK_GEN_CONFIG_, frame_, v2) << R_NETWORK_GEN_CONFIG__frame__BITNR) | \
  (R_NETWORK_GEN_CONFIG__vg__##f3##__VAL(R_NETWORK_GEN_CONFIG_, vg_, v3) << R_NETWORK_GEN_CONFIG__vg__BITNR) | \
  (R_NETWORK_GEN_CONFIG__phy__##f4##__VAL(R_NETWORK_GEN_CONFIG_, phy_, v4) << R_NETWORK_GEN_CONFIG__phy__BITNR) | \
  (R_NETWORK_GEN_CONFIG__enable__##f5##__VAL(R_NETWORK_GEN_CONFIG_, enable_, v5) << R_NETWORK_GEN_CONFIG__enable__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_NETWORK_GEN_CONFIG_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_NETWORK_GEN_CONFIG.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_NETWORK_GEN_CONFIG_(f1_,v1,f2_,v2,f3_,v3,f4_,v4,f5_,v5) ( \
  (R_NETWORK_GEN_CONFIG__loopback__##f1_##_VAL(R_NETWORK_GEN_CONFIG_, loopback_, v1) << R_NETWORK_GEN_CONFIG__loopback__BITNR) | \
  (R_NETWORK_GEN_CONFIG__frame__##f2_##_VAL(R_NETWORK_GEN_CONFIG_, frame_, v2) << R_NETWORK_GEN_CONFIG__frame__BITNR) | \
  (R_NETWORK_GEN_CONFIG__vg__##f3_##_VAL(R_NETWORK_GEN_CONFIG_, vg_, v3) << R_NETWORK_GEN_CONFIG__vg__BITNR) | \
  (R_NETWORK_GEN_CONFIG__phy__##f4_##_VAL(R_NETWORK_GEN_CONFIG_, phy_, v4) << R_NETWORK_GEN_CONFIG__phy__BITNR) | \
  (R_NETWORK_GEN_CONFIG__enable__##f5_##_VAL(R_NETWORK_GEN_CONFIG_, enable_, v5) << R_NETWORK_GEN_CONFIG__enable__BITNR) \
)

#endif

/*
 *  R_NETWORK_MGM_CTRL
 *  - type:  WO
 *  - addr:  0xb00000a0
 *  - group: Network interface registers
 */

#if USE_GROUP__Network_interface_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_NETWORK_MGM_CTRL
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_NETWORK_MGM_CTRL.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_NETWORK_MGM_CTRL. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_NETWORK_MGM_CTRL(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5) ( \
  *R_NETWORK_MGM_CTRL__SADDR = ( \
    REG_INITIATED(R_NETWORK_MGM_CTRL_) \
    REG_VAL__R_NETWORK_MGM_CTRL_(f1##_,v1,f2##_,v2,f3##_,v3,f4##_,v4,f5##_,v5) \
  ), \
  R_NETWORK_MGM_CTRL__WRITE(R_NETWORK_MGM_CTRL__ADDR, *R_NETWORK_MGM_CTRL__SADDR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_NETWORK_MGM_CTRL__SHADOW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_NETWORK_MGM_CTRL.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in the 
*#               shadow register for R_NETWORK_MGM_CTRL. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_NETWORK_MGM_CTRL__SHADOW(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5) ( \
  *R_NETWORK_MGM_CTRL__SADDR = ( \
    REG_INITIATED(R_NETWORK_MGM_CTRL_) \
    REG_VAL__R_NETWORK_MGM_CTRL_(f1##_,v1,f2##_,v2,f3##_,v3,f4##_,v4,f5##_,v5) \
  ) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_NETWORK_MGM_CTRL
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_NETWORK_MGM_CTRL(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5) ( \
  (R_NETWORK_MGM_CTRL__txd_pins__##f1##__MASK & REG__##v1) | \
  (R_NETWORK_MGM_CTRL__txer_pin__##f2##__MASK & REG__##v2) | \
  (R_NETWORK_MGM_CTRL__mdck__##f3##__MASK & REG__##v3) | \
  (R_NETWORK_MGM_CTRL__mdoe__##f4##__MASK & REG__##v4) | \
  (R_NETWORK_MGM_CTRL__mdio__##f5##__MASK & REG__##v5) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_NETWORK_MGM_CTRL
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_NETWORK_MGM_CTRL.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_NETWORK_MGM_CTRL(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5) ( \
  (R_NETWORK_MGM_CTRL__txd_pins__##f1##__VAL(R_NETWORK_MGM_CTRL_, txd_pins_, v1) << R_NETWORK_MGM_CTRL__txd_pins__BITNR) | \
  (R_NETWORK_MGM_CTRL__txer_pin__##f2##__VAL(R_NETWORK_MGM_CTRL_, txer_pin_, v2) << R_NETWORK_MGM_CTRL__txer_pin__BITNR) | \
  (R_NETWORK_MGM_CTRL__mdck__##f3##__VAL(R_NETWORK_MGM_CTRL_, mdck_, v3) << R_NETWORK_MGM_CTRL__mdck__BITNR) | \
  (R_NETWORK_MGM_CTRL__mdoe__##f4##__VAL(R_NETWORK_MGM_CTRL_, mdoe_, v4) << R_NETWORK_MGM_CTRL__mdoe__BITNR) | \
  (R_NETWORK_MGM_CTRL__mdio__##f5##__VAL(R_NETWORK_MGM_CTRL_, mdio_, v5) << R_NETWORK_MGM_CTRL__mdio__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_NETWORK_MGM_CTRL_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_NETWORK_MGM_CTRL.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_NETWORK_MGM_CTRL_(f1_,v1,f2_,v2,f3_,v3,f4_,v4,f5_,v5) ( \
  (R_NETWORK_MGM_CTRL__txd_pins__##f1_##_VAL(R_NETWORK_MGM_CTRL_, txd_pins_, v1) << R_NETWORK_MGM_CTRL__txd_pins__BITNR) | \
  (R_NETWORK_MGM_CTRL__txer_pin__##f2_##_VAL(R_NETWORK_MGM_CTRL_, txer_pin_, v2) << R_NETWORK_MGM_CTRL__txer_pin__BITNR) | \
  (R_NETWORK_MGM_CTRL__mdck__##f3_##_VAL(R_NETWORK_MGM_CTRL_, mdck_, v3) << R_NETWORK_MGM_CTRL__mdck__BITNR) | \
  (R_NETWORK_MGM_CTRL__mdoe__##f4_##_VAL(R_NETWORK_MGM_CTRL_, mdoe_, v4) << R_NETWORK_MGM_CTRL__mdoe__BITNR) | \
  (R_NETWORK_MGM_CTRL__mdio__##f5_##_VAL(R_NETWORK_MGM_CTRL_, mdio_, v5) << R_NETWORK_MGM_CTRL__mdio__BITNR) \
)

#endif

/*
 *  R_NETWORK_REC_CONFIG
 *  - type:  WO
 *  - addr:  0xb0000094
 *  - group: Network interface registers
 */

#if USE_GROUP__Network_interface_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_NETWORK_REC_CONFIG
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_NETWORK_REC_CONFIG.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_NETWORK_REC_CONFIG. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_NETWORK_REC_CONFIG(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11) ( \
  *R_NETWORK_REC_CONFIG__SADDR = ( \
    REG_INITIATED(R_NETWORK_REC_CONFIG_) \
    REG_VAL__R_NETWORK_REC_CONFIG_(f1##_,v1,f2##_,v2,f3##_,v3,f4##_,v4,f5##_,v5,f6##_,v6,f7##_,v7,f8##_,v8,f9##_,v9,f10##_,v10,f11##_,v11) \
  ), \
  R_NETWORK_REC_CONFIG__WRITE(R_NETWORK_REC_CONFIG__ADDR, *R_NETWORK_REC_CONFIG__SADDR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_NETWORK_REC_CONFIG__SHADOW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_NETWORK_REC_CONFIG.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in the 
*#               shadow register for R_NETWORK_REC_CONFIG. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_NETWORK_REC_CONFIG__SHADOW(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11) ( \
  *R_NETWORK_REC_CONFIG__SADDR = ( \
    REG_INITIATED(R_NETWORK_REC_CONFIG_) \
    REG_VAL__R_NETWORK_REC_CONFIG_(f1##_,v1,f2##_,v2,f3##_,v3,f4##_,v4,f5##_,v5,f6##_,v6,f7##_,v7,f8##_,v8,f9##_,v9,f10##_,v10,f11##_,v11) \
  ) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_NETWORK_REC_CONFIG
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_NETWORK_REC_CONFIG(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11) ( \
  (R_NETWORK_REC_CONFIG__max_size__##f1##__MASK & REG__##v1) | \
  (R_NETWORK_REC_CONFIG__duplex__##f2##__MASK & REG__##v2) | \
  (R_NETWORK_REC_CONFIG__bad_crc__##f3##__MASK & REG__##v3) | \
  (R_NETWORK_REC_CONFIG__oversize__##f4##__MASK & REG__##v4) | \
  (R_NETWORK_REC_CONFIG__undersize__##f5##__MASK & REG__##v5) | \
  (R_NETWORK_REC_CONFIG__all_roots__##f6##__MASK & REG__##v6) | \
  (R_NETWORK_REC_CONFIG__tr_broadcast__##f7##__MASK & REG__##v7) | \
  (R_NETWORK_REC_CONFIG__broadcast__##f8##__MASK & REG__##v8) | \
  (R_NETWORK_REC_CONFIG__individual__##f9##__MASK & REG__##v9) | \
  (R_NETWORK_REC_CONFIG__ma1__##f10##__MASK & REG__##v10) | \
  (R_NETWORK_REC_CONFIG__ma0__##f11##__MASK & REG__##v11) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_NETWORK_REC_CONFIG
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_NETWORK_REC_CONFIG.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_NETWORK_REC_CONFIG(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11) ( \
  (R_NETWORK_REC_CONFIG__max_size__##f1##__VAL(R_NETWORK_REC_CONFIG_, max_size_, v1) << R_NETWORK_REC_CONFIG__max_size__BITNR) | \
  (R_NETWORK_REC_CONFIG__duplex__##f2##__VAL(R_NETWORK_REC_CONFIG_, duplex_, v2) << R_NETWORK_REC_CONFIG__duplex__BITNR) | \
  (R_NETWORK_REC_CONFIG__bad_crc__##f3##__VAL(R_NETWORK_REC_CONFIG_, bad_crc_, v3) << R_NETWORK_REC_CONFIG__bad_crc__BITNR) | \
  (R_NETWORK_REC_CONFIG__oversize__##f4##__VAL(R_NETWORK_REC_CONFIG_, oversize_, v4) << R_NETWORK_REC_CONFIG__oversize__BITNR) | \
  (R_NETWORK_REC_CONFIG__undersize__##f5##__VAL(R_NETWORK_REC_CONFIG_, undersize_, v5) << R_NETWORK_REC_CONFIG__undersize__BITNR) | \
  (R_NETWORK_REC_CONFIG__all_roots__##f6##__VAL(R_NETWORK_REC_CONFIG_, all_roots_, v6) << R_NETWORK_REC_CONFIG__all_roots__BITNR) | \
  (R_NETWORK_REC_CONFIG__tr_broadcast__##f7##__VAL(R_NETWORK_REC_CONFIG_, tr_broadcast_, v7) << R_NETWORK_REC_CONFIG__tr_broadcast__BITNR) | \
  (R_NETWORK_REC_CONFIG__broadcast__##f8##__VAL(R_NETWORK_REC_CONFIG_, broadcast_, v8) << R_NETWORK_REC_CONFIG__broadcast__BITNR) | \
  (R_NETWORK_REC_CONFIG__individual__##f9##__VAL(R_NETWORK_REC_CONFIG_, individual_, v9) << R_NETWORK_REC_CONFIG__individual__BITNR) | \
  (R_NETWORK_REC_CONFIG__ma1__##f10##__VAL(R_NETWORK_REC_CONFIG_, ma1_, v10) << R_NETWORK_REC_CONFIG__ma1__BITNR) | \
  (R_NETWORK_REC_CONFIG__ma0__##f11##__VAL(R_NETWORK_REC_CONFIG_, ma0_, v11) << R_NETWORK_REC_CONFIG__ma0__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_NETWORK_REC_CONFIG_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_NETWORK_REC_CONFIG.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_NETWORK_REC_CONFIG_(f1_,v1,f2_,v2,f3_,v3,f4_,v4,f5_,v5,f6_,v6,f7_,v7,f8_,v8,f9_,v9,f10_,v10,f11_,v11) ( \
  (R_NETWORK_REC_CONFIG__max_size__##f1_##_VAL(R_NETWORK_REC_CONFIG_, max_size_, v1) << R_NETWORK_REC_CONFIG__max_size__BITNR) | \
  (R_NETWORK_REC_CONFIG__duplex__##f2_##_VAL(R_NETWORK_REC_CONFIG_, duplex_, v2) << R_NETWORK_REC_CONFIG__duplex__BITNR) | \
  (R_NETWORK_REC_CONFIG__bad_crc__##f3_##_VAL(R_NETWORK_REC_CONFIG_, bad_crc_, v3) << R_NETWORK_REC_CONFIG__bad_crc__BITNR) | \
  (R_NETWORK_REC_CONFIG__oversize__##f4_##_VAL(R_NETWORK_REC_CONFIG_, oversize_, v4) << R_NETWORK_REC_CONFIG__oversize__BITNR) | \
  (R_NETWORK_REC_CONFIG__undersize__##f5_##_VAL(R_NETWORK_REC_CONFIG_, undersize_, v5) << R_NETWORK_REC_CONFIG__undersize__BITNR) | \
  (R_NETWORK_REC_CONFIG__all_roots__##f6_##_VAL(R_NETWORK_REC_CONFIG_, all_roots_, v6) << R_NETWORK_REC_CONFIG__all_roots__BITNR) | \
  (R_NETWORK_REC_CONFIG__tr_broadcast__##f7_##_VAL(R_NETWORK_REC_CONFIG_, tr_broadcast_, v7) << R_NETWORK_REC_CONFIG__tr_broadcast__BITNR) | \
  (R_NETWORK_REC_CONFIG__broadcast__##f8_##_VAL(R_NETWORK_REC_CONFIG_, broadcast_, v8) << R_NETWORK_REC_CONFIG__broadcast__BITNR) | \
  (R_NETWORK_REC_CONFIG__individual__##f9_##_VAL(R_NETWORK_REC_CONFIG_, individual_, v9) << R_NETWORK_REC_CONFIG__individual__BITNR) | \
  (R_NETWORK_REC_CONFIG__ma1__##f10_##_VAL(R_NETWORK_REC_CONFIG_, ma1_, v10) << R_NETWORK_REC_CONFIG__ma1__BITNR) | \
  (R_NETWORK_REC_CONFIG__ma0__##f11_##_VAL(R_NETWORK_REC_CONFIG_, ma0_, v11) << R_NETWORK_REC_CONFIG__ma0__BITNR) \
)

#endif

/*
 *  R_NETWORK_SA_0
 *  - type:  WO
 *  - addr:  0xb0000080
 *  - group: Network interface registers
 */

#if USE_GROUP__Network_interface_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_NETWORK_SA_0
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_NETWORK_SA_0.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_NETWORK_SA_0. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_NETWORK_SA_0(f1,v1) ( \
  *R_NETWORK_SA_0__SADDR = ( \
    REG_INITIATED(R_NETWORK_SA_0_) \
    REG_VAL__R_NETWORK_SA_0_(f1##_,v1) \
  ), \
  R_NETWORK_SA_0__WRITE(R_NETWORK_SA_0__ADDR, *R_NETWORK_SA_0__SADDR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_NETWORK_SA_0__SHADOW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_NETWORK_SA_0.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in the 
*#               shadow register for R_NETWORK_SA_0. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_NETWORK_SA_0__SHADOW(f1,v1) ( \
  *R_NETWORK_SA_0__SADDR = ( \
    REG_INITIATED(R_NETWORK_SA_0_) \
    REG_VAL__R_NETWORK_SA_0_(f1##_,v1) \
  ) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_NETWORK_SA_0
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_NETWORK_SA_0(f1,v1) ( \
  (R_NETWORK_SA_0__ma0_low__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_NETWORK_SA_0
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_NETWORK_SA_0.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_NETWORK_SA_0(f1,v1) ( \
  (R_NETWORK_SA_0__ma0_low__##f1##__VAL(R_NETWORK_SA_0_, ma0_low_, v1) << R_NETWORK_SA_0__ma0_low__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_NETWORK_SA_0_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_NETWORK_SA_0.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_NETWORK_SA_0_(f1_,v1) ( \
  (R_NETWORK_SA_0__ma0_low__##f1_##_VAL(R_NETWORK_SA_0_, ma0_low_, v1) << R_NETWORK_SA_0__ma0_low__BITNR) \
)

#endif

/*
 *  R_NETWORK_SA_1
 *  - type:  WO
 *  - addr:  0xb0000084
 *  - group: Network interface registers
 */

#if USE_GROUP__Network_interface_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_NETWORK_SA_1
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_NETWORK_SA_1.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_NETWORK_SA_1. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_NETWORK_SA_1(f1,v1,f2,v2) ( \
  *R_NETWORK_SA_1__SADDR = ( \
    REG_INITIATED(R_NETWORK_SA_1_) \
    REG_VAL__R_NETWORK_SA_1_(f1##_,v1,f2##_,v2) \
  ), \
  R_NETWORK_SA_1__WRITE(R_NETWORK_SA_1__ADDR, *R_NETWORK_SA_1__SADDR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_NETWORK_SA_1__SHADOW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_NETWORK_SA_1.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in the 
*#               shadow register for R_NETWORK_SA_1. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_NETWORK_SA_1__SHADOW(f1,v1,f2,v2) ( \
  *R_NETWORK_SA_1__SADDR = ( \
    REG_INITIATED(R_NETWORK_SA_1_) \
    REG_VAL__R_NETWORK_SA_1_(f1##_,v1,f2##_,v2) \
  ) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_NETWORK_SA_1
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_NETWORK_SA_1(f1,v1,f2,v2) ( \
  (R_NETWORK_SA_1__ma1_low__##f1##__MASK & REG__##v1) | \
  (R_NETWORK_SA_1__ma0_high__##f2##__MASK & REG__##v2) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_NETWORK_SA_1
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_NETWORK_SA_1.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_NETWORK_SA_1(f1,v1,f2,v2) ( \
  (R_NETWORK_SA_1__ma1_low__##f1##__VAL(R_NETWORK_SA_1_, ma1_low_, v1) << R_NETWORK_SA_1__ma1_low__BITNR) | \
  (R_NETWORK_SA_1__ma0_high__##f2##__VAL(R_NETWORK_SA_1_, ma0_high_, v2) << R_NETWORK_SA_1__ma0_high__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_NETWORK_SA_1_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_NETWORK_SA_1.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_NETWORK_SA_1_(f1_,v1,f2_,v2) ( \
  (R_NETWORK_SA_1__ma1_low__##f1_##_VAL(R_NETWORK_SA_1_, ma1_low_, v1) << R_NETWORK_SA_1__ma1_low__BITNR) | \
  (R_NETWORK_SA_1__ma0_high__##f2_##_VAL(R_NETWORK_SA_1_, ma0_high_, v2) << R_NETWORK_SA_1__ma0_high__BITNR) \
)

#endif

/*
 *  R_NETWORK_SA_2
 *  - type:  WO
 *  - addr:  0xb0000088
 *  - group: Network interface registers
 */

#if USE_GROUP__Network_interface_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_NETWORK_SA_2
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_NETWORK_SA_2.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_NETWORK_SA_2. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_NETWORK_SA_2(f1,v1) ( \
  *R_NETWORK_SA_2__SADDR = ( \
    REG_INITIATED(R_NETWORK_SA_2_) \
    REG_VAL__R_NETWORK_SA_2_(f1##_,v1) \
  ), \
  R_NETWORK_SA_2__WRITE(R_NETWORK_SA_2__ADDR, *R_NETWORK_SA_2__SADDR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_NETWORK_SA_2__SHADOW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_NETWORK_SA_2.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in the 
*#               shadow register for R_NETWORK_SA_2. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_NETWORK_SA_2__SHADOW(f1,v1) ( \
  *R_NETWORK_SA_2__SADDR = ( \
    REG_INITIATED(R_NETWORK_SA_2_) \
    REG_VAL__R_NETWORK_SA_2_(f1##_,v1) \
  ) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_NETWORK_SA_2
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_NETWORK_SA_2(f1,v1) ( \
  (R_NETWORK_SA_2__ma1_high__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_NETWORK_SA_2
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_NETWORK_SA_2.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_NETWORK_SA_2(f1,v1) ( \
  (R_NETWORK_SA_2__ma1_high__##f1##__VAL(R_NETWORK_SA_2_, ma1_high_, v1) << R_NETWORK_SA_2__ma1_high__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_NETWORK_SA_2_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_NETWORK_SA_2.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_NETWORK_SA_2_(f1_,v1) ( \
  (R_NETWORK_SA_2__ma1_high__##f1_##_VAL(R_NETWORK_SA_2_, ma1_high_, v1) << R_NETWORK_SA_2__ma1_high__BITNR) \
)

#endif

/*
 *  R_NETWORK_STAT
 *  - type:  RO
 *  - addr:  0xb00000a0
 *  - group: Network interface registers
 */

#if USE_GROUP__Network_interface_registers

/* No REG_SET__register-name for read only registers. */

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_NETWORK_STAT
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_NETWORK_STAT(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5) ( \
  (R_NETWORK_STAT__rxd_pins__##f1##__MASK & REG__##v1) | \
  (R_NETWORK_STAT__rxer__##f2##__MASK & REG__##v2) | \
  (R_NETWORK_STAT__underrun__##f3##__MASK & REG__##v3) | \
  (R_NETWORK_STAT__exc_col__##f4##__MASK & REG__##v4) | \
  (R_NETWORK_STAT__mdio__##f5##__MASK & REG__##v5) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_NETWORK_STAT
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_NETWORK_STAT.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_NETWORK_STAT(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5) ( \
  (R_NETWORK_STAT__rxd_pins__##f1##__VAL(R_NETWORK_STAT_, rxd_pins_, v1) << R_NETWORK_STAT__rxd_pins__BITNR) | \
  (R_NETWORK_STAT__rxer__##f2##__VAL(R_NETWORK_STAT_, rxer_, v2) << R_NETWORK_STAT__rxer__BITNR) | \
  (R_NETWORK_STAT__underrun__##f3##__VAL(R_NETWORK_STAT_, underrun_, v3) << R_NETWORK_STAT__underrun__BITNR) | \
  (R_NETWORK_STAT__exc_col__##f4##__VAL(R_NETWORK_STAT_, exc_col_, v4) << R_NETWORK_STAT__exc_col__BITNR) | \
  (R_NETWORK_STAT__mdio__##f5##__VAL(R_NETWORK_STAT_, mdio_, v5) << R_NETWORK_STAT__mdio__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_NETWORK_STAT_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_NETWORK_STAT.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_NETWORK_STAT_(f1_,v1,f2_,v2,f3_,v3,f4_,v4,f5_,v5) ( \
  (R_NETWORK_STAT__rxd_pins__##f1_##_VAL(R_NETWORK_STAT_, rxd_pins_, v1) << R_NETWORK_STAT__rxd_pins__BITNR) | \
  (R_NETWORK_STAT__rxer__##f2_##_VAL(R_NETWORK_STAT_, rxer_, v2) << R_NETWORK_STAT__rxer__BITNR) | \
  (R_NETWORK_STAT__underrun__##f3_##_VAL(R_NETWORK_STAT_, underrun_, v3) << R_NETWORK_STAT__underrun__BITNR) | \
  (R_NETWORK_STAT__exc_col__##f4_##_VAL(R_NETWORK_STAT_, exc_col_, v4) << R_NETWORK_STAT__exc_col__BITNR) | \
  (R_NETWORK_STAT__mdio__##f5_##_VAL(R_NETWORK_STAT_, mdio_, v5) << R_NETWORK_STAT__mdio__BITNR) \
)

#endif

/*
 *  R_NETWORK_TR_CTRL
 *  - type:  WO
 *  - addr:  0xb000009c
 *  - group: Network interface registers
 */

#if USE_GROUP__Network_interface_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_NETWORK_TR_CTRL
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_NETWORK_TR_CTRL.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_NETWORK_TR_CTRL. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_NETWORK_TR_CTRL(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7) ( \
  *R_NETWORK_TR_CTRL__SADDR = ( \
    REG_INITIATED(R_NETWORK_TR_CTRL_) \
    REG_VAL__R_NETWORK_TR_CTRL_(f1##_,v1,f2##_,v2,f3##_,v3,f4##_,v4,f5##_,v5,f6##_,v6,f7##_,v7) \
  ), \
  R_NETWORK_TR_CTRL__WRITE(R_NETWORK_TR_CTRL__ADDR, *R_NETWORK_TR_CTRL__SADDR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_NETWORK_TR_CTRL__SHADOW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_NETWORK_TR_CTRL.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in the 
*#               shadow register for R_NETWORK_TR_CTRL. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_NETWORK_TR_CTRL__SHADOW(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7) ( \
  *R_NETWORK_TR_CTRL__SADDR = ( \
    REG_INITIATED(R_NETWORK_TR_CTRL_) \
    REG_VAL__R_NETWORK_TR_CTRL_(f1##_,v1,f2##_,v2,f3##_,v3,f4##_,v4,f5##_,v5,f6##_,v6,f7##_,v7) \
  ) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_NETWORK_TR_CTRL
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_NETWORK_TR_CTRL(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7) ( \
  (R_NETWORK_TR_CTRL__clr_error__##f1##__MASK & REG__##v1) | \
  (R_NETWORK_TR_CTRL__delay__##f2##__MASK & REG__##v2) | \
  (R_NETWORK_TR_CTRL__cancel__##f3##__MASK & REG__##v3) | \
  (R_NETWORK_TR_CTRL__cd__##f4##__MASK & REG__##v4) | \
  (R_NETWORK_TR_CTRL__retry__##f5##__MASK & REG__##v5) | \
  (R_NETWORK_TR_CTRL__pad__##f6##__MASK & REG__##v6) | \
  (R_NETWORK_TR_CTRL__crc__##f7##__MASK & REG__##v7) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_NETWORK_TR_CTRL
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_NETWORK_TR_CTRL.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_NETWORK_TR_CTRL(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7) ( \
  (R_NETWORK_TR_CTRL__clr_error__##f1##__VAL(R_NETWORK_TR_CTRL_, clr_error_, v1) << R_NETWORK_TR_CTRL__clr_error__BITNR) | \
  (R_NETWORK_TR_CTRL__delay__##f2##__VAL(R_NETWORK_TR_CTRL_, delay_, v2) << R_NETWORK_TR_CTRL__delay__BITNR) | \
  (R_NETWORK_TR_CTRL__cancel__##f3##__VAL(R_NETWORK_TR_CTRL_, cancel_, v3) << R_NETWORK_TR_CTRL__cancel__BITNR) | \
  (R_NETWORK_TR_CTRL__cd__##f4##__VAL(R_NETWORK_TR_CTRL_, cd_, v4) << R_NETWORK_TR_CTRL__cd__BITNR) | \
  (R_NETWORK_TR_CTRL__retry__##f5##__VAL(R_NETWORK_TR_CTRL_, retry_, v5) << R_NETWORK_TR_CTRL__retry__BITNR) | \
  (R_NETWORK_TR_CTRL__pad__##f6##__VAL(R_NETWORK_TR_CTRL_, pad_, v6) << R_NETWORK_TR_CTRL__pad__BITNR) | \
  (R_NETWORK_TR_CTRL__crc__##f7##__VAL(R_NETWORK_TR_CTRL_, crc_, v7) << R_NETWORK_TR_CTRL__crc__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_NETWORK_TR_CTRL_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_NETWORK_TR_CTRL.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_NETWORK_TR_CTRL_(f1_,v1,f2_,v2,f3_,v3,f4_,v4,f5_,v5,f6_,v6,f7_,v7) ( \
  (R_NETWORK_TR_CTRL__clr_error__##f1_##_VAL(R_NETWORK_TR_CTRL_, clr_error_, v1) << R_NETWORK_TR_CTRL__clr_error__BITNR) | \
  (R_NETWORK_TR_CTRL__delay__##f2_##_VAL(R_NETWORK_TR_CTRL_, delay_, v2) << R_NETWORK_TR_CTRL__delay__BITNR) | \
  (R_NETWORK_TR_CTRL__cancel__##f3_##_VAL(R_NETWORK_TR_CTRL_, cancel_, v3) << R_NETWORK_TR_CTRL__cancel__BITNR) | \
  (R_NETWORK_TR_CTRL__cd__##f4_##_VAL(R_NETWORK_TR_CTRL_, cd_, v4) << R_NETWORK_TR_CTRL__cd__BITNR) | \
  (R_NETWORK_TR_CTRL__retry__##f5_##_VAL(R_NETWORK_TR_CTRL_, retry_, v5) << R_NETWORK_TR_CTRL__retry__BITNR) | \
  (R_NETWORK_TR_CTRL__pad__##f6_##_VAL(R_NETWORK_TR_CTRL_, pad_, v6) << R_NETWORK_TR_CTRL__pad__BITNR) | \
  (R_NETWORK_TR_CTRL__crc__##f7_##_VAL(R_NETWORK_TR_CTRL_, crc_, v7) << R_NETWORK_TR_CTRL__crc__BITNR) \
)

#endif

/*
 *  R_PAR0_CONFIG
 *  - type:  WO
 *  - addr:  0xb0000044
 *  - group: Parallel printer port registers
 */

#if USE_GROUP__Parallel_printer_port_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_PAR0_CONFIG
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_PAR0_CONFIG.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_PAR0_CONFIG. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_PAR0_CONFIG(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11,f12,v12,f13,v13,f14,v14,f15,v15,f16,v16,f17,v17,f18,v18,f19,v19,f20,v20) ( \
  *R_PAR0_CONFIG__SADDR = ( \
    REG_INITIATED(R_PAR0_CONFIG_) \
    REG_VAL__R_PAR0_CONFIG_(f1##_,v1,f2##_,v2,f3##_,v3,f4##_,v4,f5##_,v5,f6##_,v6,f7##_,v7,f8##_,v8,f9##_,v9,f10##_,v10,f11##_,v11,f12##_,v12,f13##_,v13,f14##_,v14,f15##_,v15,f16##_,v16,f17##_,v17,f18##_,v18,f19##_,v19,f20##_,v20) \
  ), \
  R_PAR0_CONFIG__WRITE(R_PAR0_CONFIG__ADDR, *R_PAR0_CONFIG__SADDR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_PAR0_CONFIG__SHADOW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_PAR0_CONFIG.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in the 
*#               shadow register for R_PAR0_CONFIG. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_PAR0_CONFIG__SHADOW(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11,f12,v12,f13,v13,f14,v14,f15,v15,f16,v16,f17,v17,f18,v18,f19,v19,f20,v20) ( \
  *R_PAR0_CONFIG__SADDR = ( \
    REG_INITIATED(R_PAR0_CONFIG_) \
    REG_VAL__R_PAR0_CONFIG_(f1##_,v1,f2##_,v2,f3##_,v3,f4##_,v4,f5##_,v5,f6##_,v6,f7##_,v7,f8##_,v8,f9##_,v9,f10##_,v10,f11##_,v11,f12##_,v12,f13##_,v13,f14##_,v14,f15##_,v15,f16##_,v16,f17##_,v17,f18##_,v18,f19##_,v19,f20##_,v20) \
  ) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_PAR0_CONFIG
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_PAR0_CONFIG(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11,f12,v12,f13,v13,f14,v14,f15,v15,f16,v16,f17,v17,f18,v18,f19,v19,f20,v20) ( \
  (R_PAR0_CONFIG__ioe__##f1##__MASK & REG__##v1) | \
  (R_PAR0_CONFIG__iseli__##f2##__MASK & REG__##v2) | \
  (R_PAR0_CONFIG__iautofd__##f3##__MASK & REG__##v3) | \
  (R_PAR0_CONFIG__istrb__##f4##__MASK & REG__##v4) | \
  (R_PAR0_CONFIG__iinit__##f5##__MASK & REG__##v5) | \
  (R_PAR0_CONFIG__iperr__##f6##__MASK & REG__##v6) | \
  (R_PAR0_CONFIG__iack__##f7##__MASK & REG__##v7) | \
  (R_PAR0_CONFIG__ibusy__##f8##__MASK & REG__##v8) | \
  (R_PAR0_CONFIG__ifault__##f9##__MASK & REG__##v9) | \
  (R_PAR0_CONFIG__isel__##f10##__MASK & REG__##v10) | \
  (R_PAR0_CONFIG__ext_mode__##f11##__MASK & REG__##v11) | \
  (R_PAR0_CONFIG__wide__##f12##__MASK & REG__##v12) | \
  (R_PAR0_CONFIG__dma__##f13##__MASK & REG__##v13) | \
  (R_PAR0_CONFIG__rle_in__##f14##__MASK & REG__##v14) | \
  (R_PAR0_CONFIG__rle_out__##f15##__MASK & REG__##v15) | \
  (R_PAR0_CONFIG__enable__##f16##__MASK & REG__##v16) | \
  (R_PAR0_CONFIG__force__##f17##__MASK & REG__##v17) | \
  (R_PAR0_CONFIG__ign_ack__##f18##__MASK & REG__##v18) | \
  (R_PAR0_CONFIG__oe_ack__##f19##__MASK & REG__##v19) | \
  (R_PAR0_CONFIG__mode__##f20##__MASK & REG__##v20) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_PAR0_CONFIG
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_PAR0_CONFIG.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_PAR0_CONFIG(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11,f12,v12,f13,v13,f14,v14,f15,v15,f16,v16,f17,v17,f18,v18,f19,v19,f20,v20) ( \
  (R_PAR0_CONFIG__ioe__##f1##__VAL(R_PAR0_CONFIG_, ioe_, v1) << R_PAR0_CONFIG__ioe__BITNR) | \
  (R_PAR0_CONFIG__iseli__##f2##__VAL(R_PAR0_CONFIG_, iseli_, v2) << R_PAR0_CONFIG__iseli__BITNR) | \
  (R_PAR0_CONFIG__iautofd__##f3##__VAL(R_PAR0_CONFIG_, iautofd_, v3) << R_PAR0_CONFIG__iautofd__BITNR) | \
  (R_PAR0_CONFIG__istrb__##f4##__VAL(R_PAR0_CONFIG_, istrb_, v4) << R_PAR0_CONFIG__istrb__BITNR) | \
  (R_PAR0_CONFIG__iinit__##f5##__VAL(R_PAR0_CONFIG_, iinit_, v5) << R_PAR0_CONFIG__iinit__BITNR) | \
  (R_PAR0_CONFIG__iperr__##f6##__VAL(R_PAR0_CONFIG_, iperr_, v6) << R_PAR0_CONFIG__iperr__BITNR) | \
  (R_PAR0_CONFIG__iack__##f7##__VAL(R_PAR0_CONFIG_, iack_, v7) << R_PAR0_CONFIG__iack__BITNR) | \
  (R_PAR0_CONFIG__ibusy__##f8##__VAL(R_PAR0_CONFIG_, ibusy_, v8) << R_PAR0_CONFIG__ibusy__BITNR) | \
  (R_PAR0_CONFIG__ifault__##f9##__VAL(R_PAR0_CONFIG_, ifault_, v9) << R_PAR0_CONFIG__ifault__BITNR) | \
  (R_PAR0_CONFIG__isel__##f10##__VAL(R_PAR0_CONFIG_, isel_, v10) << R_PAR0_CONFIG__isel__BITNR) | \
  (R_PAR0_CONFIG__ext_mode__##f11##__VAL(R_PAR0_CONFIG_, ext_mode_, v11) << R_PAR0_CONFIG__ext_mode__BITNR) | \
  (R_PAR0_CONFIG__wide__##f12##__VAL(R_PAR0_CONFIG_, wide_, v12) << R_PAR0_CONFIG__wide__BITNR) | \
  (R_PAR0_CONFIG__dma__##f13##__VAL(R_PAR0_CONFIG_, dma_, v13) << R_PAR0_CONFIG__dma__BITNR) | \
  (R_PAR0_CONFIG__rle_in__##f14##__VAL(R_PAR0_CONFIG_, rle_in_, v14) << R_PAR0_CONFIG__rle_in__BITNR) | \
  (R_PAR0_CONFIG__rle_out__##f15##__VAL(R_PAR0_CONFIG_, rle_out_, v15) << R_PAR0_CONFIG__rle_out__BITNR) | \
  (R_PAR0_CONFIG__enable__##f16##__VAL(R_PAR0_CONFIG_, enable_, v16) << R_PAR0_CONFIG__enable__BITNR) | \
  (R_PAR0_CONFIG__force__##f17##__VAL(R_PAR0_CONFIG_, force_, v17) << R_PAR0_CONFIG__force__BITNR) | \
  (R_PAR0_CONFIG__ign_ack__##f18##__VAL(R_PAR0_CONFIG_, ign_ack_, v18) << R_PAR0_CONFIG__ign_ack__BITNR) | \
  (R_PAR0_CONFIG__oe_ack__##f19##__VAL(R_PAR0_CONFIG_, oe_ack_, v19) << R_PAR0_CONFIG__oe_ack__BITNR) | \
  (R_PAR0_CONFIG__mode__##f20##__VAL(R_PAR0_CONFIG_, mode_, v20) << R_PAR0_CONFIG__mode__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_PAR0_CONFIG_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_PAR0_CONFIG.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_PAR0_CONFIG_(f1_,v1,f2_,v2,f3_,v3,f4_,v4,f5_,v5,f6_,v6,f7_,v7,f8_,v8,f9_,v9,f10_,v10,f11_,v11,f12_,v12,f13_,v13,f14_,v14,f15_,v15,f16_,v16,f17_,v17,f18_,v18,f19_,v19,f20_,v20) ( \
  (R_PAR0_CONFIG__ioe__##f1_##_VAL(R_PAR0_CONFIG_, ioe_, v1) << R_PAR0_CONFIG__ioe__BITNR) | \
  (R_PAR0_CONFIG__iseli__##f2_##_VAL(R_PAR0_CONFIG_, iseli_, v2) << R_PAR0_CONFIG__iseli__BITNR) | \
  (R_PAR0_CONFIG__iautofd__##f3_##_VAL(R_PAR0_CONFIG_, iautofd_, v3) << R_PAR0_CONFIG__iautofd__BITNR) | \
  (R_PAR0_CONFIG__istrb__##f4_##_VAL(R_PAR0_CONFIG_, istrb_, v4) << R_PAR0_CONFIG__istrb__BITNR) | \
  (R_PAR0_CONFIG__iinit__##f5_##_VAL(R_PAR0_CONFIG_, iinit_, v5) << R_PAR0_CONFIG__iinit__BITNR) | \
  (R_PAR0_CONFIG__iperr__##f6_##_VAL(R_PAR0_CONFIG_, iperr_, v6) << R_PAR0_CONFIG__iperr__BITNR) | \
  (R_PAR0_CONFIG__iack__##f7_##_VAL(R_PAR0_CONFIG_, iack_, v7) << R_PAR0_CONFIG__iack__BITNR) | \
  (R_PAR0_CONFIG__ibusy__##f8_##_VAL(R_PAR0_CONFIG_, ibusy_, v8) << R_PAR0_CONFIG__ibusy__BITNR) | \
  (R_PAR0_CONFIG__ifault__##f9_##_VAL(R_PAR0_CONFIG_, ifault_, v9) << R_PAR0_CONFIG__ifault__BITNR) | \
  (R_PAR0_CONFIG__isel__##f10_##_VAL(R_PAR0_CONFIG_, isel_, v10) << R_PAR0_CONFIG__isel__BITNR) | \
  (R_PAR0_CONFIG__ext_mode__##f11_##_VAL(R_PAR0_CONFIG_, ext_mode_, v11) << R_PAR0_CONFIG__ext_mode__BITNR) | \
  (R_PAR0_CONFIG__wide__##f12_##_VAL(R_PAR0_CONFIG_, wide_, v12) << R_PAR0_CONFIG__wide__BITNR) | \
  (R_PAR0_CONFIG__dma__##f13_##_VAL(R_PAR0_CONFIG_, dma_, v13) << R_PAR0_CONFIG__dma__BITNR) | \
  (R_PAR0_CONFIG__rle_in__##f14_##_VAL(R_PAR0_CONFIG_, rle_in_, v14) << R_PAR0_CONFIG__rle_in__BITNR) | \
  (R_PAR0_CONFIG__rle_out__##f15_##_VAL(R_PAR0_CONFIG_, rle_out_, v15) << R_PAR0_CONFIG__rle_out__BITNR) | \
  (R_PAR0_CONFIG__enable__##f16_##_VAL(R_PAR0_CONFIG_, enable_, v16) << R_PAR0_CONFIG__enable__BITNR) | \
  (R_PAR0_CONFIG__force__##f17_##_VAL(R_PAR0_CONFIG_, force_, v17) << R_PAR0_CONFIG__force__BITNR) | \
  (R_PAR0_CONFIG__ign_ack__##f18_##_VAL(R_PAR0_CONFIG_, ign_ack_, v18) << R_PAR0_CONFIG__ign_ack__BITNR) | \
  (R_PAR0_CONFIG__oe_ack__##f19_##_VAL(R_PAR0_CONFIG_, oe_ack_, v19) << R_PAR0_CONFIG__oe_ack__BITNR) | \
  (R_PAR0_CONFIG__mode__##f20_##_VAL(R_PAR0_CONFIG_, mode_, v20) << R_PAR0_CONFIG__mode__BITNR) \
)

#endif

/*
 *  R_PAR0_CTRL
 *  - type:  WO
 *  - addr:  0xb0000042
 *  - group: Parallel printer port registers
 */

#if USE_GROUP__Parallel_printer_port_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_PAR0_CTRL
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_PAR0_CTRL.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_PAR0_CTRL. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_PAR0_CTRL(f1,v1) ( \
  *R_PAR0_CTRL__SADDR = ( \
    REG_INITIATED(R_PAR0_CTRL_) \
    REG_VAL__R_PAR0_CTRL_(f1##_,v1) \
  ), \
  R_PAR0_CTRL__WRITE(R_PAR0_CTRL__ADDR, *R_PAR0_CTRL__SADDR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_PAR0_CTRL__SHADOW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_PAR0_CTRL.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in the 
*#               shadow register for R_PAR0_CTRL. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_PAR0_CTRL__SHADOW(f1,v1) ( \
  *R_PAR0_CTRL__SADDR = ( \
    REG_INITIATED(R_PAR0_CTRL_) \
    REG_VAL__R_PAR0_CTRL_(f1##_,v1) \
  ) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_PAR0_CTRL
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_PAR0_CTRL(f1,v1) ( \
  (R_PAR0_CTRL__ctrl__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_PAR0_CTRL
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_PAR0_CTRL.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_PAR0_CTRL(f1,v1) ( \
  (R_PAR0_CTRL__ctrl__##f1##__VAL(R_PAR0_CTRL_, ctrl_, v1) << R_PAR0_CTRL__ctrl__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_PAR0_CTRL_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_PAR0_CTRL.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_PAR0_CTRL_(f1_,v1) ( \
  (R_PAR0_CTRL__ctrl__##f1_##_VAL(R_PAR0_CTRL_, ctrl_, v1) << R_PAR0_CTRL__ctrl__BITNR) \
)

#endif

/*
 *  R_PAR0_CTRL_DATA
 *  - type:  WO
 *  - addr:  0xb0000040
 *  - group: Parallel printer port registers
 */

#if USE_GROUP__Parallel_printer_port_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_PAR0_CTRL_DATA
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_PAR0_CTRL_DATA.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_PAR0_CTRL_DATA. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_PAR0_CTRL_DATA(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8) ( \
  *R_PAR0_CTRL_DATA__SADDR = ( \
    REG_INITIATED(R_PAR0_CTRL_DATA_) \
    REG_VAL__R_PAR0_CTRL_DATA_(f1##_,v1,f2##_,v2,f3##_,v3,f4##_,v4,f5##_,v5,f6##_,v6,f7##_,v7,f8##_,v8) \
  ), \
  R_PAR0_CTRL_DATA__WRITE(R_PAR0_CTRL_DATA__ADDR, *R_PAR0_CTRL_DATA__SADDR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_PAR0_CTRL_DATA__SHADOW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_PAR0_CTRL_DATA.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in the 
*#               shadow register for R_PAR0_CTRL_DATA. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_PAR0_CTRL_DATA__SHADOW(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8) ( \
  *R_PAR0_CTRL_DATA__SADDR = ( \
    REG_INITIATED(R_PAR0_CTRL_DATA_) \
    REG_VAL__R_PAR0_CTRL_DATA_(f1##_,v1,f2##_,v2,f3##_,v3,f4##_,v4,f5##_,v5,f6##_,v6,f7##_,v7,f8##_,v8) \
  ) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_PAR0_CTRL_DATA
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_PAR0_CTRL_DATA(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8) ( \
  (R_PAR0_CTRL_DATA__peri_int__##f1##__MASK & REG__##v1) | \
  (R_PAR0_CTRL_DATA__oe__##f2##__MASK & REG__##v2) | \
  (R_PAR0_CTRL_DATA__seli__##f3##__MASK & REG__##v3) | \
  (R_PAR0_CTRL_DATA__autofd__##f4##__MASK & REG__##v4) | \
  (R_PAR0_CTRL_DATA__strb__##f5##__MASK & REG__##v5) | \
  (R_PAR0_CTRL_DATA__init__##f6##__MASK & REG__##v6) | \
  (R_PAR0_CTRL_DATA__ecp_cmd__##f7##__MASK & REG__##v7) | \
  (R_PAR0_CTRL_DATA__data__##f8##__MASK & REG__##v8) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_PAR0_CTRL_DATA
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_PAR0_CTRL_DATA.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_PAR0_CTRL_DATA(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8) ( \
  (R_PAR0_CTRL_DATA__peri_int__##f1##__VAL(R_PAR0_CTRL_DATA_, peri_int_, v1) << R_PAR0_CTRL_DATA__peri_int__BITNR) | \
  (R_PAR0_CTRL_DATA__oe__##f2##__VAL(R_PAR0_CTRL_DATA_, oe_, v2) << R_PAR0_CTRL_DATA__oe__BITNR) | \
  (R_PAR0_CTRL_DATA__seli__##f3##__VAL(R_PAR0_CTRL_DATA_, seli_, v3) << R_PAR0_CTRL_DATA__seli__BITNR) | \
  (R_PAR0_CTRL_DATA__autofd__##f4##__VAL(R_PAR0_CTRL_DATA_, autofd_, v4) << R_PAR0_CTRL_DATA__autofd__BITNR) | \
  (R_PAR0_CTRL_DATA__strb__##f5##__VAL(R_PAR0_CTRL_DATA_, strb_, v5) << R_PAR0_CTRL_DATA__strb__BITNR) | \
  (R_PAR0_CTRL_DATA__init__##f6##__VAL(R_PAR0_CTRL_DATA_, init_, v6) << R_PAR0_CTRL_DATA__init__BITNR) | \
  (R_PAR0_CTRL_DATA__ecp_cmd__##f7##__VAL(R_PAR0_CTRL_DATA_, ecp_cmd_, v7) << R_PAR0_CTRL_DATA__ecp_cmd__BITNR) | \
  (R_PAR0_CTRL_DATA__data__##f8##__VAL(R_PAR0_CTRL_DATA_, data_, v8) << R_PAR0_CTRL_DATA__data__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_PAR0_CTRL_DATA_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_PAR0_CTRL_DATA.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_PAR0_CTRL_DATA_(f1_,v1,f2_,v2,f3_,v3,f4_,v4,f5_,v5,f6_,v6,f7_,v7,f8_,v8) ( \
  (R_PAR0_CTRL_DATA__peri_int__##f1_##_VAL(R_PAR0_CTRL_DATA_, peri_int_, v1) << R_PAR0_CTRL_DATA__peri_int__BITNR) | \
  (R_PAR0_CTRL_DATA__oe__##f2_##_VAL(R_PAR0_CTRL_DATA_, oe_, v2) << R_PAR0_CTRL_DATA__oe__BITNR) | \
  (R_PAR0_CTRL_DATA__seli__##f3_##_VAL(R_PAR0_CTRL_DATA_, seli_, v3) << R_PAR0_CTRL_DATA__seli__BITNR) | \
  (R_PAR0_CTRL_DATA__autofd__##f4_##_VAL(R_PAR0_CTRL_DATA_, autofd_, v4) << R_PAR0_CTRL_DATA__autofd__BITNR) | \
  (R_PAR0_CTRL_DATA__strb__##f5_##_VAL(R_PAR0_CTRL_DATA_, strb_, v5) << R_PAR0_CTRL_DATA__strb__BITNR) | \
  (R_PAR0_CTRL_DATA__init__##f6_##_VAL(R_PAR0_CTRL_DATA_, init_, v6) << R_PAR0_CTRL_DATA__init__BITNR) | \
  (R_PAR0_CTRL_DATA__ecp_cmd__##f7_##_VAL(R_PAR0_CTRL_DATA_, ecp_cmd_, v7) << R_PAR0_CTRL_DATA__ecp_cmd__BITNR) | \
  (R_PAR0_CTRL_DATA__data__##f8_##_VAL(R_PAR0_CTRL_DATA_, data_, v8) << R_PAR0_CTRL_DATA__data__BITNR) \
)

#endif

/*
 *  R_PAR0_DELAY
 *  - type:  WO
 *  - addr:  0xb0000048
 *  - group: Parallel printer port registers
 */

#if USE_GROUP__Parallel_printer_port_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_PAR0_DELAY
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_PAR0_DELAY.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_PAR0_DELAY. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_PAR0_DELAY(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6) ( \
  *R_PAR0_DELAY__SADDR = ( \
    REG_INITIATED(R_PAR0_DELAY_) \
    REG_VAL__R_PAR0_DELAY_(f1##_,v1,f2##_,v2,f3##_,v3,f4##_,v4,f5##_,v5,f6##_,v6) \
  ), \
  R_PAR0_DELAY__WRITE(R_PAR0_DELAY__ADDR, *R_PAR0_DELAY__SADDR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_PAR0_DELAY__SHADOW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_PAR0_DELAY.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in the 
*#               shadow register for R_PAR0_DELAY. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_PAR0_DELAY__SHADOW(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6) ( \
  *R_PAR0_DELAY__SADDR = ( \
    REG_INITIATED(R_PAR0_DELAY_) \
    REG_VAL__R_PAR0_DELAY_(f1##_,v1,f2##_,v2,f3##_,v3,f4##_,v4,f5##_,v5,f6##_,v6) \
  ) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_PAR0_DELAY
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_PAR0_DELAY(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6) ( \
  (R_PAR0_DELAY__fine_hold__##f1##__MASK & REG__##v1) | \
  (R_PAR0_DELAY__hold__##f2##__MASK & REG__##v2) | \
  (R_PAR0_DELAY__fine_strb__##f3##__MASK & REG__##v3) | \
  (R_PAR0_DELAY__strobe__##f4##__MASK & REG__##v4) | \
  (R_PAR0_DELAY__fine_setup__##f5##__MASK & REG__##v5) | \
  (R_PAR0_DELAY__setup__##f6##__MASK & REG__##v6) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_PAR0_DELAY
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_PAR0_DELAY.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_PAR0_DELAY(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6) ( \
  (R_PAR0_DELAY__fine_hold__##f1##__VAL(R_PAR0_DELAY_, fine_hold_, v1) << R_PAR0_DELAY__fine_hold__BITNR) | \
  (R_PAR0_DELAY__hold__##f2##__VAL(R_PAR0_DELAY_, hold_, v2) << R_PAR0_DELAY__hold__BITNR) | \
  (R_PAR0_DELAY__fine_strb__##f3##__VAL(R_PAR0_DELAY_, fine_strb_, v3) << R_PAR0_DELAY__fine_strb__BITNR) | \
  (R_PAR0_DELAY__strobe__##f4##__VAL(R_PAR0_DELAY_, strobe_, v4) << R_PAR0_DELAY__strobe__BITNR) | \
  (R_PAR0_DELAY__fine_setup__##f5##__VAL(R_PAR0_DELAY_, fine_setup_, v5) << R_PAR0_DELAY__fine_setup__BITNR) | \
  (R_PAR0_DELAY__setup__##f6##__VAL(R_PAR0_DELAY_, setup_, v6) << R_PAR0_DELAY__setup__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_PAR0_DELAY_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_PAR0_DELAY.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_PAR0_DELAY_(f1_,v1,f2_,v2,f3_,v3,f4_,v4,f5_,v5,f6_,v6) ( \
  (R_PAR0_DELAY__fine_hold__##f1_##_VAL(R_PAR0_DELAY_, fine_hold_, v1) << R_PAR0_DELAY__fine_hold__BITNR) | \
  (R_PAR0_DELAY__hold__##f2_##_VAL(R_PAR0_DELAY_, hold_, v2) << R_PAR0_DELAY__hold__BITNR) | \
  (R_PAR0_DELAY__fine_strb__##f3_##_VAL(R_PAR0_DELAY_, fine_strb_, v3) << R_PAR0_DELAY__fine_strb__BITNR) | \
  (R_PAR0_DELAY__strobe__##f4_##_VAL(R_PAR0_DELAY_, strobe_, v4) << R_PAR0_DELAY__strobe__BITNR) | \
  (R_PAR0_DELAY__fine_setup__##f5_##_VAL(R_PAR0_DELAY_, fine_setup_, v5) << R_PAR0_DELAY__fine_setup__BITNR) | \
  (R_PAR0_DELAY__setup__##f6_##_VAL(R_PAR0_DELAY_, setup_, v6) << R_PAR0_DELAY__setup__BITNR) \
)

#endif

/*
 *  R_PAR0_STATUS
 *  - type:  RO
 *  - addr:  0xb0000042
 *  - group: Parallel printer port registers
 */

#if USE_GROUP__Parallel_printer_port_registers

/* No REG_SET__register-name for read only registers. */

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_PAR0_STATUS
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_PAR0_STATUS(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10) ( \
  (R_PAR0_STATUS__mode__##f1##__MASK & REG__##v1) | \
  (R_PAR0_STATUS__perr__##f2##__MASK & REG__##v2) | \
  (R_PAR0_STATUS__ack__##f3##__MASK & REG__##v3) | \
  (R_PAR0_STATUS__busy__##f4##__MASK & REG__##v4) | \
  (R_PAR0_STATUS__fault__##f5##__MASK & REG__##v5) | \
  (R_PAR0_STATUS__sel__##f6##__MASK & REG__##v6) | \
  (R_PAR0_STATUS__ext_mode__##f7##__MASK & REG__##v7) | \
  (R_PAR0_STATUS__ecp_16__##f8##__MASK & REG__##v8) | \
  (R_PAR0_STATUS__tr_rdy__##f9##__MASK & REG__##v9) | \
  (R_PAR0_STATUS__dav__##f10##__MASK & REG__##v10) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_PAR0_STATUS
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_PAR0_STATUS.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_PAR0_STATUS(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10) ( \
  (R_PAR0_STATUS__mode__##f1##__VAL(R_PAR0_STATUS_, mode_, v1) << R_PAR0_STATUS__mode__BITNR) | \
  (R_PAR0_STATUS__perr__##f2##__VAL(R_PAR0_STATUS_, perr_, v2) << R_PAR0_STATUS__perr__BITNR) | \
  (R_PAR0_STATUS__ack__##f3##__VAL(R_PAR0_STATUS_, ack_, v3) << R_PAR0_STATUS__ack__BITNR) | \
  (R_PAR0_STATUS__busy__##f4##__VAL(R_PAR0_STATUS_, busy_, v4) << R_PAR0_STATUS__busy__BITNR) | \
  (R_PAR0_STATUS__fault__##f5##__VAL(R_PAR0_STATUS_, fault_, v5) << R_PAR0_STATUS__fault__BITNR) | \
  (R_PAR0_STATUS__sel__##f6##__VAL(R_PAR0_STATUS_, sel_, v6) << R_PAR0_STATUS__sel__BITNR) | \
  (R_PAR0_STATUS__ext_mode__##f7##__VAL(R_PAR0_STATUS_, ext_mode_, v7) << R_PAR0_STATUS__ext_mode__BITNR) | \
  (R_PAR0_STATUS__ecp_16__##f8##__VAL(R_PAR0_STATUS_, ecp_16_, v8) << R_PAR0_STATUS__ecp_16__BITNR) | \
  (R_PAR0_STATUS__tr_rdy__##f9##__VAL(R_PAR0_STATUS_, tr_rdy_, v9) << R_PAR0_STATUS__tr_rdy__BITNR) | \
  (R_PAR0_STATUS__dav__##f10##__VAL(R_PAR0_STATUS_, dav_, v10) << R_PAR0_STATUS__dav__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_PAR0_STATUS_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_PAR0_STATUS.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_PAR0_STATUS_(f1_,v1,f2_,v2,f3_,v3,f4_,v4,f5_,v5,f6_,v6,f7_,v7,f8_,v8,f9_,v9,f10_,v10) ( \
  (R_PAR0_STATUS__mode__##f1_##_VAL(R_PAR0_STATUS_, mode_, v1) << R_PAR0_STATUS__mode__BITNR) | \
  (R_PAR0_STATUS__perr__##f2_##_VAL(R_PAR0_STATUS_, perr_, v2) << R_PAR0_STATUS__perr__BITNR) | \
  (R_PAR0_STATUS__ack__##f3_##_VAL(R_PAR0_STATUS_, ack_, v3) << R_PAR0_STATUS__ack__BITNR) | \
  (R_PAR0_STATUS__busy__##f4_##_VAL(R_PAR0_STATUS_, busy_, v4) << R_PAR0_STATUS__busy__BITNR) | \
  (R_PAR0_STATUS__fault__##f5_##_VAL(R_PAR0_STATUS_, fault_, v5) << R_PAR0_STATUS__fault__BITNR) | \
  (R_PAR0_STATUS__sel__##f6_##_VAL(R_PAR0_STATUS_, sel_, v6) << R_PAR0_STATUS__sel__BITNR) | \
  (R_PAR0_STATUS__ext_mode__##f7_##_VAL(R_PAR0_STATUS_, ext_mode_, v7) << R_PAR0_STATUS__ext_mode__BITNR) | \
  (R_PAR0_STATUS__ecp_16__##f8_##_VAL(R_PAR0_STATUS_, ecp_16_, v8) << R_PAR0_STATUS__ecp_16__BITNR) | \
  (R_PAR0_STATUS__tr_rdy__##f9_##_VAL(R_PAR0_STATUS_, tr_rdy_, v9) << R_PAR0_STATUS__tr_rdy__BITNR) | \
  (R_PAR0_STATUS__dav__##f10_##_VAL(R_PAR0_STATUS_, dav_, v10) << R_PAR0_STATUS__dav__BITNR) \
)

#endif

/*
 *  R_PAR0_STATUS_DATA
 *  - type:  RO
 *  - addr:  0xb0000040
 *  - group: Parallel printer port registers
 */

#if USE_GROUP__Parallel_printer_port_registers

/* No REG_SET__register-name for read only registers. */

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_PAR0_STATUS_DATA
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_PAR0_STATUS_DATA(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11,f12,v12) ( \
  (R_PAR0_STATUS_DATA__mode__##f1##__MASK & REG__##v1) | \
  (R_PAR0_STATUS_DATA__perr__##f2##__MASK & REG__##v2) | \
  (R_PAR0_STATUS_DATA__ack__##f3##__MASK & REG__##v3) | \
  (R_PAR0_STATUS_DATA__busy__##f4##__MASK & REG__##v4) | \
  (R_PAR0_STATUS_DATA__fault__##f5##__MASK & REG__##v5) | \
  (R_PAR0_STATUS_DATA__sel__##f6##__MASK & REG__##v6) | \
  (R_PAR0_STATUS_DATA__ext_mode__##f7##__MASK & REG__##v7) | \
  (R_PAR0_STATUS_DATA__ecp_16__##f8##__MASK & REG__##v8) | \
  (R_PAR0_STATUS_DATA__tr_rdy__##f9##__MASK & REG__##v9) | \
  (R_PAR0_STATUS_DATA__dav__##f10##__MASK & REG__##v10) | \
  (R_PAR0_STATUS_DATA__ecp_cmd__##f11##__MASK & REG__##v11) | \
  (R_PAR0_STATUS_DATA__data__##f12##__MASK & REG__##v12) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_PAR0_STATUS_DATA
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_PAR0_STATUS_DATA.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_PAR0_STATUS_DATA(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11,f12,v12) ( \
  (R_PAR0_STATUS_DATA__mode__##f1##__VAL(R_PAR0_STATUS_DATA_, mode_, v1) << R_PAR0_STATUS_DATA__mode__BITNR) | \
  (R_PAR0_STATUS_DATA__perr__##f2##__VAL(R_PAR0_STATUS_DATA_, perr_, v2) << R_PAR0_STATUS_DATA__perr__BITNR) | \
  (R_PAR0_STATUS_DATA__ack__##f3##__VAL(R_PAR0_STATUS_DATA_, ack_, v3) << R_PAR0_STATUS_DATA__ack__BITNR) | \
  (R_PAR0_STATUS_DATA__busy__##f4##__VAL(R_PAR0_STATUS_DATA_, busy_, v4) << R_PAR0_STATUS_DATA__busy__BITNR) | \
  (R_PAR0_STATUS_DATA__fault__##f5##__VAL(R_PAR0_STATUS_DATA_, fault_, v5) << R_PAR0_STATUS_DATA__fault__BITNR) | \
  (R_PAR0_STATUS_DATA__sel__##f6##__VAL(R_PAR0_STATUS_DATA_, sel_, v6) << R_PAR0_STATUS_DATA__sel__BITNR) | \
  (R_PAR0_STATUS_DATA__ext_mode__##f7##__VAL(R_PAR0_STATUS_DATA_, ext_mode_, v7) << R_PAR0_STATUS_DATA__ext_mode__BITNR) | \
  (R_PAR0_STATUS_DATA__ecp_16__##f8##__VAL(R_PAR0_STATUS_DATA_, ecp_16_, v8) << R_PAR0_STATUS_DATA__ecp_16__BITNR) | \
  (R_PAR0_STATUS_DATA__tr_rdy__##f9##__VAL(R_PAR0_STATUS_DATA_, tr_rdy_, v9) << R_PAR0_STATUS_DATA__tr_rdy__BITNR) | \
  (R_PAR0_STATUS_DATA__dav__##f10##__VAL(R_PAR0_STATUS_DATA_, dav_, v10) << R_PAR0_STATUS_DATA__dav__BITNR) | \
  (R_PAR0_STATUS_DATA__ecp_cmd__##f11##__VAL(R_PAR0_STATUS_DATA_, ecp_cmd_, v11) << R_PAR0_STATUS_DATA__ecp_cmd__BITNR) | \
  (R_PAR0_STATUS_DATA__data__##f12##__VAL(R_PAR0_STATUS_DATA_, data_, v12) << R_PAR0_STATUS_DATA__data__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_PAR0_STATUS_DATA_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_PAR0_STATUS_DATA.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_PAR0_STATUS_DATA_(f1_,v1,f2_,v2,f3_,v3,f4_,v4,f5_,v5,f6_,v6,f7_,v7,f8_,v8,f9_,v9,f10_,v10,f11_,v11,f12_,v12) ( \
  (R_PAR0_STATUS_DATA__mode__##f1_##_VAL(R_PAR0_STATUS_DATA_, mode_, v1) << R_PAR0_STATUS_DATA__mode__BITNR) | \
  (R_PAR0_STATUS_DATA__perr__##f2_##_VAL(R_PAR0_STATUS_DATA_, perr_, v2) << R_PAR0_STATUS_DATA__perr__BITNR) | \
  (R_PAR0_STATUS_DATA__ack__##f3_##_VAL(R_PAR0_STATUS_DATA_, ack_, v3) << R_PAR0_STATUS_DATA__ack__BITNR) | \
  (R_PAR0_STATUS_DATA__busy__##f4_##_VAL(R_PAR0_STATUS_DATA_, busy_, v4) << R_PAR0_STATUS_DATA__busy__BITNR) | \
  (R_PAR0_STATUS_DATA__fault__##f5_##_VAL(R_PAR0_STATUS_DATA_, fault_, v5) << R_PAR0_STATUS_DATA__fault__BITNR) | \
  (R_PAR0_STATUS_DATA__sel__##f6_##_VAL(R_PAR0_STATUS_DATA_, sel_, v6) << R_PAR0_STATUS_DATA__sel__BITNR) | \
  (R_PAR0_STATUS_DATA__ext_mode__##f7_##_VAL(R_PAR0_STATUS_DATA_, ext_mode_, v7) << R_PAR0_STATUS_DATA__ext_mode__BITNR) | \
  (R_PAR0_STATUS_DATA__ecp_16__##f8_##_VAL(R_PAR0_STATUS_DATA_, ecp_16_, v8) << R_PAR0_STATUS_DATA__ecp_16__BITNR) | \
  (R_PAR0_STATUS_DATA__tr_rdy__##f9_##_VAL(R_PAR0_STATUS_DATA_, tr_rdy_, v9) << R_PAR0_STATUS_DATA__tr_rdy__BITNR) | \
  (R_PAR0_STATUS_DATA__dav__##f10_##_VAL(R_PAR0_STATUS_DATA_, dav_, v10) << R_PAR0_STATUS_DATA__dav__BITNR) | \
  (R_PAR0_STATUS_DATA__ecp_cmd__##f11_##_VAL(R_PAR0_STATUS_DATA_, ecp_cmd_, v11) << R_PAR0_STATUS_DATA__ecp_cmd__BITNR) | \
  (R_PAR0_STATUS_DATA__data__##f12_##_VAL(R_PAR0_STATUS_DATA_, data_, v12) << R_PAR0_STATUS_DATA__data__BITNR) \
)

#endif

/*
 *  R_PAR1_CONFIG
 *  - type:  WO
 *  - addr:  0xb0000054
 *  - group: Parallel printer port registers
 */

#if USE_GROUP__Parallel_printer_port_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_PAR1_CONFIG
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_PAR1_CONFIG.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_PAR1_CONFIG. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_PAR1_CONFIG(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11,f12,v12,f13,v13,f14,v14,f15,v15,f16,v16,f17,v17,f18,v18,f19,v19) ( \
  *R_PAR1_CONFIG__SADDR = ( \
    REG_INITIATED(R_PAR1_CONFIG_) \
    REG_VAL__R_PAR1_CONFIG_(f1##_,v1,f2##_,v2,f3##_,v3,f4##_,v4,f5##_,v5,f6##_,v6,f7##_,v7,f8##_,v8,f9##_,v9,f10##_,v10,f11##_,v11,f12##_,v12,f13##_,v13,f14##_,v14,f15##_,v15,f16##_,v16,f17##_,v17,f18##_,v18,f19##_,v19) \
  ), \
  R_PAR1_CONFIG__WRITE(R_PAR1_CONFIG__ADDR, *R_PAR1_CONFIG__SADDR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_PAR1_CONFIG__SHADOW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_PAR1_CONFIG.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in the 
*#               shadow register for R_PAR1_CONFIG. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_PAR1_CONFIG__SHADOW(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11,f12,v12,f13,v13,f14,v14,f15,v15,f16,v16,f17,v17,f18,v18,f19,v19) ( \
  *R_PAR1_CONFIG__SADDR = ( \
    REG_INITIATED(R_PAR1_CONFIG_) \
    REG_VAL__R_PAR1_CONFIG_(f1##_,v1,f2##_,v2,f3##_,v3,f4##_,v4,f5##_,v5,f6##_,v6,f7##_,v7,f8##_,v8,f9##_,v9,f10##_,v10,f11##_,v11,f12##_,v12,f13##_,v13,f14##_,v14,f15##_,v15,f16##_,v16,f17##_,v17,f18##_,v18,f19##_,v19) \
  ) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_PAR1_CONFIG
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_PAR1_CONFIG(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11,f12,v12,f13,v13,f14,v14,f15,v15,f16,v16,f17,v17,f18,v18,f19,v19) ( \
  (R_PAR1_CONFIG__ioe__##f1##__MASK & REG__##v1) | \
  (R_PAR1_CONFIG__iseli__##f2##__MASK & REG__##v2) | \
  (R_PAR1_CONFIG__iautofd__##f3##__MASK & REG__##v3) | \
  (R_PAR1_CONFIG__istrb__##f4##__MASK & REG__##v4) | \
  (R_PAR1_CONFIG__iinit__##f5##__MASK & REG__##v5) | \
  (R_PAR1_CONFIG__iperr__##f6##__MASK & REG__##v6) | \
  (R_PAR1_CONFIG__iack__##f7##__MASK & REG__##v7) | \
  (R_PAR1_CONFIG__ibusy__##f8##__MASK & REG__##v8) | \
  (R_PAR1_CONFIG__ifault__##f9##__MASK & REG__##v9) | \
  (R_PAR1_CONFIG__isel__##f10##__MASK & REG__##v10) | \
  (R_PAR1_CONFIG__ext_mode__##f11##__MASK & REG__##v11) | \
  (R_PAR1_CONFIG__dma__##f12##__MASK & REG__##v12) | \
  (R_PAR1_CONFIG__rle_in__##f13##__MASK & REG__##v13) | \
  (R_PAR1_CONFIG__rle_out__##f14##__MASK & REG__##v14) | \
  (R_PAR1_CONFIG__enable__##f15##__MASK & REG__##v15) | \
  (R_PAR1_CONFIG__force__##f16##__MASK & REG__##v16) | \
  (R_PAR1_CONFIG__ign_ack__##f17##__MASK & REG__##v17) | \
  (R_PAR1_CONFIG__oe_ack__##f18##__MASK & REG__##v18) | \
  (R_PAR1_CONFIG__mode__##f19##__MASK & REG__##v19) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_PAR1_CONFIG
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_PAR1_CONFIG.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_PAR1_CONFIG(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11,f12,v12,f13,v13,f14,v14,f15,v15,f16,v16,f17,v17,f18,v18,f19,v19) ( \
  (R_PAR1_CONFIG__ioe__##f1##__VAL(R_PAR1_CONFIG_, ioe_, v1) << R_PAR1_CONFIG__ioe__BITNR) | \
  (R_PAR1_CONFIG__iseli__##f2##__VAL(R_PAR1_CONFIG_, iseli_, v2) << R_PAR1_CONFIG__iseli__BITNR) | \
  (R_PAR1_CONFIG__iautofd__##f3##__VAL(R_PAR1_CONFIG_, iautofd_, v3) << R_PAR1_CONFIG__iautofd__BITNR) | \
  (R_PAR1_CONFIG__istrb__##f4##__VAL(R_PAR1_CONFIG_, istrb_, v4) << R_PAR1_CONFIG__istrb__BITNR) | \
  (R_PAR1_CONFIG__iinit__##f5##__VAL(R_PAR1_CONFIG_, iinit_, v5) << R_PAR1_CONFIG__iinit__BITNR) | \
  (R_PAR1_CONFIG__iperr__##f6##__VAL(R_PAR1_CONFIG_, iperr_, v6) << R_PAR1_CONFIG__iperr__BITNR) | \
  (R_PAR1_CONFIG__iack__##f7##__VAL(R_PAR1_CONFIG_, iack_, v7) << R_PAR1_CONFIG__iack__BITNR) | \
  (R_PAR1_CONFIG__ibusy__##f8##__VAL(R_PAR1_CONFIG_, ibusy_, v8) << R_PAR1_CONFIG__ibusy__BITNR) | \
  (R_PAR1_CONFIG__ifault__##f9##__VAL(R_PAR1_CONFIG_, ifault_, v9) << R_PAR1_CONFIG__ifault__BITNR) | \
  (R_PAR1_CONFIG__isel__##f10##__VAL(R_PAR1_CONFIG_, isel_, v10) << R_PAR1_CONFIG__isel__BITNR) | \
  (R_PAR1_CONFIG__ext_mode__##f11##__VAL(R_PAR1_CONFIG_, ext_mode_, v11) << R_PAR1_CONFIG__ext_mode__BITNR) | \
  (R_PAR1_CONFIG__dma__##f12##__VAL(R_PAR1_CONFIG_, dma_, v12) << R_PAR1_CONFIG__dma__BITNR) | \
  (R_PAR1_CONFIG__rle_in__##f13##__VAL(R_PAR1_CONFIG_, rle_in_, v13) << R_PAR1_CONFIG__rle_in__BITNR) | \
  (R_PAR1_CONFIG__rle_out__##f14##__VAL(R_PAR1_CONFIG_, rle_out_, v14) << R_PAR1_CONFIG__rle_out__BITNR) | \
  (R_PAR1_CONFIG__enable__##f15##__VAL(R_PAR1_CONFIG_, enable_, v15) << R_PAR1_CONFIG__enable__BITNR) | \
  (R_PAR1_CONFIG__force__##f16##__VAL(R_PAR1_CONFIG_, force_, v16) << R_PAR1_CONFIG__force__BITNR) | \
  (R_PAR1_CONFIG__ign_ack__##f17##__VAL(R_PAR1_CONFIG_, ign_ack_, v17) << R_PAR1_CONFIG__ign_ack__BITNR) | \
  (R_PAR1_CONFIG__oe_ack__##f18##__VAL(R_PAR1_CONFIG_, oe_ack_, v18) << R_PAR1_CONFIG__oe_ack__BITNR) | \
  (R_PAR1_CONFIG__mode__##f19##__VAL(R_PAR1_CONFIG_, mode_, v19) << R_PAR1_CONFIG__mode__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_PAR1_CONFIG_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_PAR1_CONFIG.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_PAR1_CONFIG_(f1_,v1,f2_,v2,f3_,v3,f4_,v4,f5_,v5,f6_,v6,f7_,v7,f8_,v8,f9_,v9,f10_,v10,f11_,v11,f12_,v12,f13_,v13,f14_,v14,f15_,v15,f16_,v16,f17_,v17,f18_,v18,f19_,v19) ( \
  (R_PAR1_CONFIG__ioe__##f1_##_VAL(R_PAR1_CONFIG_, ioe_, v1) << R_PAR1_CONFIG__ioe__BITNR) | \
  (R_PAR1_CONFIG__iseli__##f2_##_VAL(R_PAR1_CONFIG_, iseli_, v2) << R_PAR1_CONFIG__iseli__BITNR) | \
  (R_PAR1_CONFIG__iautofd__##f3_##_VAL(R_PAR1_CONFIG_, iautofd_, v3) << R_PAR1_CONFIG__iautofd__BITNR) | \
  (R_PAR1_CONFIG__istrb__##f4_##_VAL(R_PAR1_CONFIG_, istrb_, v4) << R_PAR1_CONFIG__istrb__BITNR) | \
  (R_PAR1_CONFIG__iinit__##f5_##_VAL(R_PAR1_CONFIG_, iinit_, v5) << R_PAR1_CONFIG__iinit__BITNR) | \
  (R_PAR1_CONFIG__iperr__##f6_##_VAL(R_PAR1_CONFIG_, iperr_, v6) << R_PAR1_CONFIG__iperr__BITNR) | \
  (R_PAR1_CONFIG__iack__##f7_##_VAL(R_PAR1_CONFIG_, iack_, v7) << R_PAR1_CONFIG__iack__BITNR) | \
  (R_PAR1_CONFIG__ibusy__##f8_##_VAL(R_PAR1_CONFIG_, ibusy_, v8) << R_PAR1_CONFIG__ibusy__BITNR) | \
  (R_PAR1_CONFIG__ifault__##f9_##_VAL(R_PAR1_CONFIG_, ifault_, v9) << R_PAR1_CONFIG__ifault__BITNR) | \
  (R_PAR1_CONFIG__isel__##f10_##_VAL(R_PAR1_CONFIG_, isel_, v10) << R_PAR1_CONFIG__isel__BITNR) | \
  (R_PAR1_CONFIG__ext_mode__##f11_##_VAL(R_PAR1_CONFIG_, ext_mode_, v11) << R_PAR1_CONFIG__ext_mode__BITNR) | \
  (R_PAR1_CONFIG__dma__##f12_##_VAL(R_PAR1_CONFIG_, dma_, v12) << R_PAR1_CONFIG__dma__BITNR) | \
  (R_PAR1_CONFIG__rle_in__##f13_##_VAL(R_PAR1_CONFIG_, rle_in_, v13) << R_PAR1_CONFIG__rle_in__BITNR) | \
  (R_PAR1_CONFIG__rle_out__##f14_##_VAL(R_PAR1_CONFIG_, rle_out_, v14) << R_PAR1_CONFIG__rle_out__BITNR) | \
  (R_PAR1_CONFIG__enable__##f15_##_VAL(R_PAR1_CONFIG_, enable_, v15) << R_PAR1_CONFIG__enable__BITNR) | \
  (R_PAR1_CONFIG__force__##f16_##_VAL(R_PAR1_CONFIG_, force_, v16) << R_PAR1_CONFIG__force__BITNR) | \
  (R_PAR1_CONFIG__ign_ack__##f17_##_VAL(R_PAR1_CONFIG_, ign_ack_, v17) << R_PAR1_CONFIG__ign_ack__BITNR) | \
  (R_PAR1_CONFIG__oe_ack__##f18_##_VAL(R_PAR1_CONFIG_, oe_ack_, v18) << R_PAR1_CONFIG__oe_ack__BITNR) | \
  (R_PAR1_CONFIG__mode__##f19_##_VAL(R_PAR1_CONFIG_, mode_, v19) << R_PAR1_CONFIG__mode__BITNR) \
)

#endif

/*
 *  R_PAR1_CTRL
 *  - type:  WO
 *  - addr:  0xb0000052
 *  - group: Parallel printer port registers
 */

#if USE_GROUP__Parallel_printer_port_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_PAR1_CTRL
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_PAR1_CTRL.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_PAR1_CTRL. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_PAR1_CTRL(f1,v1) ( \
  *R_PAR1_CTRL__SADDR = ( \
    REG_INITIATED(R_PAR1_CTRL_) \
    REG_VAL__R_PAR1_CTRL_(f1##_,v1) \
  ), \
  R_PAR1_CTRL__WRITE(R_PAR1_CTRL__ADDR, *R_PAR1_CTRL__SADDR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_PAR1_CTRL__SHADOW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_PAR1_CTRL.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in the 
*#               shadow register for R_PAR1_CTRL. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_PAR1_CTRL__SHADOW(f1,v1) ( \
  *R_PAR1_CTRL__SADDR = ( \
    REG_INITIATED(R_PAR1_CTRL_) \
    REG_VAL__R_PAR1_CTRL_(f1##_,v1) \
  ) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_PAR1_CTRL
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_PAR1_CTRL(f1,v1) ( \
  (R_PAR1_CTRL__ctrl__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_PAR1_CTRL
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_PAR1_CTRL.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_PAR1_CTRL(f1,v1) ( \
  (R_PAR1_CTRL__ctrl__##f1##__VAL(R_PAR1_CTRL_, ctrl_, v1) << R_PAR1_CTRL__ctrl__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_PAR1_CTRL_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_PAR1_CTRL.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_PAR1_CTRL_(f1_,v1) ( \
  (R_PAR1_CTRL__ctrl__##f1_##_VAL(R_PAR1_CTRL_, ctrl_, v1) << R_PAR1_CTRL__ctrl__BITNR) \
)

#endif

/*
 *  R_PAR1_CTRL_DATA
 *  - type:  WO
 *  - addr:  0xb0000050
 *  - group: Parallel printer port registers
 */

#if USE_GROUP__Parallel_printer_port_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_PAR1_CTRL_DATA
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_PAR1_CTRL_DATA.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_PAR1_CTRL_DATA. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_PAR1_CTRL_DATA(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8) ( \
  *R_PAR1_CTRL_DATA__SADDR = ( \
    REG_INITIATED(R_PAR1_CTRL_DATA_) \
    REG_VAL__R_PAR1_CTRL_DATA_(f1##_,v1,f2##_,v2,f3##_,v3,f4##_,v4,f5##_,v5,f6##_,v6,f7##_,v7,f8##_,v8) \
  ), \
  R_PAR1_CTRL_DATA__WRITE(R_PAR1_CTRL_DATA__ADDR, *R_PAR1_CTRL_DATA__SADDR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_PAR1_CTRL_DATA__SHADOW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_PAR1_CTRL_DATA.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in the 
*#               shadow register for R_PAR1_CTRL_DATA. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_PAR1_CTRL_DATA__SHADOW(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8) ( \
  *R_PAR1_CTRL_DATA__SADDR = ( \
    REG_INITIATED(R_PAR1_CTRL_DATA_) \
    REG_VAL__R_PAR1_CTRL_DATA_(f1##_,v1,f2##_,v2,f3##_,v3,f4##_,v4,f5##_,v5,f6##_,v6,f7##_,v7,f8##_,v8) \
  ) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_PAR1_CTRL_DATA
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_PAR1_CTRL_DATA(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8) ( \
  (R_PAR1_CTRL_DATA__peri_int__##f1##__MASK & REG__##v1) | \
  (R_PAR1_CTRL_DATA__oe__##f2##__MASK & REG__##v2) | \
  (R_PAR1_CTRL_DATA__seli__##f3##__MASK & REG__##v3) | \
  (R_PAR1_CTRL_DATA__autofd__##f4##__MASK & REG__##v4) | \
  (R_PAR1_CTRL_DATA__strb__##f5##__MASK & REG__##v5) | \
  (R_PAR1_CTRL_DATA__init__##f6##__MASK & REG__##v6) | \
  (R_PAR1_CTRL_DATA__ecp_cmd__##f7##__MASK & REG__##v7) | \
  (R_PAR1_CTRL_DATA__data__##f8##__MASK & REG__##v8) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_PAR1_CTRL_DATA
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_PAR1_CTRL_DATA.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_PAR1_CTRL_DATA(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8) ( \
  (R_PAR1_CTRL_DATA__peri_int__##f1##__VAL(R_PAR1_CTRL_DATA_, peri_int_, v1) << R_PAR1_CTRL_DATA__peri_int__BITNR) | \
  (R_PAR1_CTRL_DATA__oe__##f2##__VAL(R_PAR1_CTRL_DATA_, oe_, v2) << R_PAR1_CTRL_DATA__oe__BITNR) | \
  (R_PAR1_CTRL_DATA__seli__##f3##__VAL(R_PAR1_CTRL_DATA_, seli_, v3) << R_PAR1_CTRL_DATA__seli__BITNR) | \
  (R_PAR1_CTRL_DATA__autofd__##f4##__VAL(R_PAR1_CTRL_DATA_, autofd_, v4) << R_PAR1_CTRL_DATA__autofd__BITNR) | \
  (R_PAR1_CTRL_DATA__strb__##f5##__VAL(R_PAR1_CTRL_DATA_, strb_, v5) << R_PAR1_CTRL_DATA__strb__BITNR) | \
  (R_PAR1_CTRL_DATA__init__##f6##__VAL(R_PAR1_CTRL_DATA_, init_, v6) << R_PAR1_CTRL_DATA__init__BITNR) | \
  (R_PAR1_CTRL_DATA__ecp_cmd__##f7##__VAL(R_PAR1_CTRL_DATA_, ecp_cmd_, v7) << R_PAR1_CTRL_DATA__ecp_cmd__BITNR) | \
  (R_PAR1_CTRL_DATA__data__##f8##__VAL(R_PAR1_CTRL_DATA_, data_, v8) << R_PAR1_CTRL_DATA__data__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_PAR1_CTRL_DATA_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_PAR1_CTRL_DATA.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_PAR1_CTRL_DATA_(f1_,v1,f2_,v2,f3_,v3,f4_,v4,f5_,v5,f6_,v6,f7_,v7,f8_,v8) ( \
  (R_PAR1_CTRL_DATA__peri_int__##f1_##_VAL(R_PAR1_CTRL_DATA_, peri_int_, v1) << R_PAR1_CTRL_DATA__peri_int__BITNR) | \
  (R_PAR1_CTRL_DATA__oe__##f2_##_VAL(R_PAR1_CTRL_DATA_, oe_, v2) << R_PAR1_CTRL_DATA__oe__BITNR) | \
  (R_PAR1_CTRL_DATA__seli__##f3_##_VAL(R_PAR1_CTRL_DATA_, seli_, v3) << R_PAR1_CTRL_DATA__seli__BITNR) | \
  (R_PAR1_CTRL_DATA__autofd__##f4_##_VAL(R_PAR1_CTRL_DATA_, autofd_, v4) << R_PAR1_CTRL_DATA__autofd__BITNR) | \
  (R_PAR1_CTRL_DATA__strb__##f5_##_VAL(R_PAR1_CTRL_DATA_, strb_, v5) << R_PAR1_CTRL_DATA__strb__BITNR) | \
  (R_PAR1_CTRL_DATA__init__##f6_##_VAL(R_PAR1_CTRL_DATA_, init_, v6) << R_PAR1_CTRL_DATA__init__BITNR) | \
  (R_PAR1_CTRL_DATA__ecp_cmd__##f7_##_VAL(R_PAR1_CTRL_DATA_, ecp_cmd_, v7) << R_PAR1_CTRL_DATA__ecp_cmd__BITNR) | \
  (R_PAR1_CTRL_DATA__data__##f8_##_VAL(R_PAR1_CTRL_DATA_, data_, v8) << R_PAR1_CTRL_DATA__data__BITNR) \
)

#endif

/*
 *  R_PAR1_DELAY
 *  - type:  WO
 *  - addr:  0xb0000058
 *  - group: Parallel printer port registers
 */

#if USE_GROUP__Parallel_printer_port_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_PAR1_DELAY
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_PAR1_DELAY.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_PAR1_DELAY. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_PAR1_DELAY(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6) ( \
  *R_PAR1_DELAY__SADDR = ( \
    REG_INITIATED(R_PAR1_DELAY_) \
    REG_VAL__R_PAR1_DELAY_(f1##_,v1,f2##_,v2,f3##_,v3,f4##_,v4,f5##_,v5,f6##_,v6) \
  ), \
  R_PAR1_DELAY__WRITE(R_PAR1_DELAY__ADDR, *R_PAR1_DELAY__SADDR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_PAR1_DELAY__SHADOW
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_PAR1_DELAY.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in the 
*#               shadow register for R_PAR1_DELAY. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_PAR1_DELAY__SHADOW(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6) ( \
  *R_PAR1_DELAY__SADDR = ( \
    REG_INITIATED(R_PAR1_DELAY_) \
    REG_VAL__R_PAR1_DELAY_(f1##_,v1,f2##_,v2,f3##_,v3,f4##_,v4,f5##_,v5,f6##_,v6) \
  ) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_PAR1_DELAY
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_PAR1_DELAY(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6) ( \
  (R_PAR1_DELAY__fine_hold__##f1##__MASK & REG__##v1) | \
  (R_PAR1_DELAY__hold__##f2##__MASK & REG__##v2) | \
  (R_PAR1_DELAY__fine_strb__##f3##__MASK & REG__##v3) | \
  (R_PAR1_DELAY__strobe__##f4##__MASK & REG__##v4) | \
  (R_PAR1_DELAY__fine_setup__##f5##__MASK & REG__##v5) | \
  (R_PAR1_DELAY__setup__##f6##__MASK & REG__##v6) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_PAR1_DELAY
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_PAR1_DELAY.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_PAR1_DELAY(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6) ( \
  (R_PAR1_DELAY__fine_hold__##f1##__VAL(R_PAR1_DELAY_, fine_hold_, v1) << R_PAR1_DELAY__fine_hold__BITNR) | \
  (R_PAR1_DELAY__hold__##f2##__VAL(R_PAR1_DELAY_, hold_, v2) << R_PAR1_DELAY__hold__BITNR) | \
  (R_PAR1_DELAY__fine_strb__##f3##__VAL(R_PAR1_DELAY_, fine_strb_, v3) << R_PAR1_DELAY__fine_strb__BITNR) | \
  (R_PAR1_DELAY__strobe__##f4##__VAL(R_PAR1_DELAY_, strobe_, v4) << R_PAR1_DELAY__strobe__BITNR) | \
  (R_PAR1_DELAY__fine_setup__##f5##__VAL(R_PAR1_DELAY_, fine_setup_, v5) << R_PAR1_DELAY__fine_setup__BITNR) | \
  (R_PAR1_DELAY__setup__##f6##__VAL(R_PAR1_DELAY_, setup_, v6) << R_PAR1_DELAY__setup__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_PAR1_DELAY_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_PAR1_DELAY.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_PAR1_DELAY_(f1_,v1,f2_,v2,f3_,v3,f4_,v4,f5_,v5,f6_,v6) ( \
  (R_PAR1_DELAY__fine_hold__##f1_##_VAL(R_PAR1_DELAY_, fine_hold_, v1) << R_PAR1_DELAY__fine_hold__BITNR) | \
  (R_PAR1_DELAY__hold__##f2_##_VAL(R_PAR1_DELAY_, hold_, v2) << R_PAR1_DELAY__hold__BITNR) | \
  (R_PAR1_DELAY__fine_strb__##f3_##_VAL(R_PAR1_DELAY_, fine_strb_, v3) << R_PAR1_DELAY__fine_strb__BITNR) | \
  (R_PAR1_DELAY__strobe__##f4_##_VAL(R_PAR1_DELAY_, strobe_, v4) << R_PAR1_DELAY__strobe__BITNR) | \
  (R_PAR1_DELAY__fine_setup__##f5_##_VAL(R_PAR1_DELAY_, fine_setup_, v5) << R_PAR1_DELAY__fine_setup__BITNR) | \
  (R_PAR1_DELAY__setup__##f6_##_VAL(R_PAR1_DELAY_, setup_, v6) << R_PAR1_DELAY__setup__BITNR) \
)

#endif

/*
 *  R_PAR1_STATUS
 *  - type:  RO
 *  - addr:  0xb0000052
 *  - group: Parallel printer port registers
 */

#if USE_GROUP__Parallel_printer_port_registers

/* No REG_SET__register-name for read only registers. */

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_PAR1_STATUS
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_PAR1_STATUS(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9) ( \
  (R_PAR1_STATUS__mode__##f1##__MASK & REG__##v1) | \
  (R_PAR1_STATUS__perr__##f2##__MASK & REG__##v2) | \
  (R_PAR1_STATUS__ack__##f3##__MASK & REG__##v3) | \
  (R_PAR1_STATUS__busy__##f4##__MASK & REG__##v4) | \
  (R_PAR1_STATUS__fault__##f5##__MASK & REG__##v5) | \
  (R_PAR1_STATUS__sel__##f6##__MASK & REG__##v6) | \
  (R_PAR1_STATUS__ext_mode__##f7##__MASK & REG__##v7) | \
  (R_PAR1_STATUS__tr_rdy__##f8##__MASK & REG__##v8) | \
  (R_PAR1_STATUS__dav__##f9##__MASK & REG__##v9) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_PAR1_STATUS
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_PAR1_STATUS.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_PAR1_STATUS(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9) ( \
  (R_PAR1_STATUS__mode__##f1##__VAL(R_PAR1_STATUS_, mode_, v1) << R_PAR1_STATUS__mode__BITNR) | \
  (R_PAR1_STATUS__perr__##f2##__VAL(R_PAR1_STATUS_, perr_, v2) << R_PAR1_STATUS__perr__BITNR) | \
  (R_PAR1_STATUS__ack__##f3##__VAL(R_PAR1_STATUS_, ack_, v3) << R_PAR1_STATUS__ack__BITNR) | \
  (R_PAR1_STATUS__busy__##f4##__VAL(R_PAR1_STATUS_, busy_, v4) << R_PAR1_STATUS__busy__BITNR) | \
  (R_PAR1_STATUS__fault__##f5##__VAL(R_PAR1_STATUS_, fault_, v5) << R_PAR1_STATUS__fault__BITNR) | \
  (R_PAR1_STATUS__sel__##f6##__VAL(R_PAR1_STATUS_, sel_, v6) << R_PAR1_STATUS__sel__BITNR) | \
  (R_PAR1_STATUS__ext_mode__##f7##__VAL(R_PAR1_STATUS_, ext_mode_, v7) << R_PAR1_STATUS__ext_mode__BITNR) | \
  (R_PAR1_STATUS__tr_rdy__##f8##__VAL(R_PAR1_STATUS_, tr_rdy_, v8) << R_PAR1_STATUS__tr_rdy__BITNR) | \
  (R_PAR1_STATUS__dav__##f9##__VAL(R_PAR1_STATUS_, dav_, v9) << R_PAR1_STATUS__dav__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_PAR1_STATUS_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_PAR1_STATUS.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_PAR1_STATUS_(f1_,v1,f2_,v2,f3_,v3,f4_,v4,f5_,v5,f6_,v6,f7_,v7,f8_,v8,f9_,v9) ( \
  (R_PAR1_STATUS__mode__##f1_##_VAL(R_PAR1_STATUS_, mode_, v1) << R_PAR1_STATUS__mode__BITNR) | \
  (R_PAR1_STATUS__perr__##f2_##_VAL(R_PAR1_STATUS_, perr_, v2) << R_PAR1_STATUS__perr__BITNR) | \
  (R_PAR1_STATUS__ack__##f3_##_VAL(R_PAR1_STATUS_, ack_, v3) << R_PAR1_STATUS__ack__BITNR) | \
  (R_PAR1_STATUS__busy__##f4_##_VAL(R_PAR1_STATUS_, busy_, v4) << R_PAR1_STATUS__busy__BITNR) | \
  (R_PAR1_STATUS__fault__##f5_##_VAL(R_PAR1_STATUS_, fault_, v5) << R_PAR1_STATUS__fault__BITNR) | \
  (R_PAR1_STATUS__sel__##f6_##_VAL(R_PAR1_STATUS_, sel_, v6) << R_PAR1_STATUS__sel__BITNR) | \
  (R_PAR1_STATUS__ext_mode__##f7_##_VAL(R_PAR1_STATUS_, ext_mode_, v7) << R_PAR1_STATUS__ext_mode__BITNR) | \
  (R_PAR1_STATUS__tr_rdy__##f8_##_VAL(R_PAR1_STATUS_, tr_rdy_, v8) << R_PAR1_STATUS__tr_rdy__BITNR) | \
  (R_PAR1_STATUS__dav__##f9_##_VAL(R_PAR1_STATUS_, dav_, v9) << R_PAR1_STATUS__dav__BITNR) \
)

#endif

/*
 *  R_PAR1_STATUS_DATA
 *  - type:  RO
 *  - addr:  0xb0000050
 *  - group: Parallel printer port registers
 */

#if USE_GROUP__Parallel_printer_port_registers

/* No REG_SET__register-name for read only registers. */

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_PAR1_STATUS_DATA
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_PAR1_STATUS_DATA(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11) ( \
  (R_PAR1_STATUS_DATA__mode__##f1##__MASK & REG__##v1) | \
  (R_PAR1_STATUS_DATA__perr__##f2##__MASK & REG__##v2) | \
  (R_PAR1_STATUS_DATA__ack__##f3##__MASK & REG__##v3) | \
  (R_PAR1_STATUS_DATA__busy__##f4##__MASK & REG__##v4) | \
  (R_PAR1_STATUS_DATA__fault__##f5##__MASK & REG__##v5) | \
  (R_PAR1_STATUS_DATA__sel__##f6##__MASK & REG__##v6) | \
  (R_PAR1_STATUS_DATA__ext_mode__##f7##__MASK & REG__##v7) | \
  (R_PAR1_STATUS_DATA__tr_rdy__##f8##__MASK & REG__##v8) | \
  (R_PAR1_STATUS_DATA__dav__##f9##__MASK & REG__##v9) | \
  (R_PAR1_STATUS_DATA__ecp_cmd__##f10##__MASK & REG__##v10) | \
  (R_PAR1_STATUS_DATA__data__##f11##__MASK & REG__##v11) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_PAR1_STATUS_DATA
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_PAR1_STATUS_DATA.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_PAR1_STATUS_DATA(f1,v1,f2,v2,f3,v3,f4,v4,f5,v5,f6,v6,f7,v7,f8,v8,f9,v9,f10,v10,f11,v11) ( \
  (R_PAR1_STATUS_DATA__mode__##f1##__VAL(R_PAR1_STATUS_DATA_, mode_, v1) << R_PAR1_STATUS_DATA__mode__BITNR) | \
  (R_PAR1_STATUS_DATA__perr__##f2##__VAL(R_PAR1_STATUS_DATA_, perr_, v2) << R_PAR1_STATUS_DATA__perr__BITNR) | \
  (R_PAR1_STATUS_DATA__ack__##f3##__VAL(R_PAR1_STATUS_DATA_, ack_, v3) << R_PAR1_STATUS_DATA__ack__BITNR) | \
  (R_PAR1_STATUS_DATA__busy__##f4##__VAL(R_PAR1_STATUS_DATA_, busy_, v4) << R_PAR1_STATUS_DATA__busy__BITNR) | \
  (R_PAR1_STATUS_DATA__fault__##f5##__VAL(R_PAR1_STATUS_DATA_, fault_, v5) << R_PAR1_STATUS_DATA__fault__BITNR) | \
  (R_PAR1_STATUS_DATA__sel__##f6##__VAL(R_PAR1_STATUS_DATA_, sel_, v6) << R_PAR1_STATUS_DATA__sel__BITNR) | \
  (R_PAR1_STATUS_DATA__ext_mode__##f7##__VAL(R_PAR1_STATUS_DATA_, ext_mode_, v7) << R_PAR1_STATUS_DATA__ext_mode__BITNR) | \
  (R_PAR1_STATUS_DATA__tr_rdy__##f8##__VAL(R_PAR1_STATUS_DATA_, tr_rdy_, v8) << R_PAR1_STATUS_DATA__tr_rdy__BITNR) | \
  (R_PAR1_STATUS_DATA__dav__##f9##__VAL(R_PAR1_STATUS_DATA_, dav_, v9) << R_PAR1_STATUS_DATA__dav__BITNR) | \
  (R_PAR1_STATUS_DATA__ecp_cmd__##f10##__VAL(R_PAR1_STATUS_DATA_, ecp_cmd_, v10) << R_PAR1_STATUS_DATA__ecp_cmd__BITNR) | \
  (R_PAR1_STATUS_DATA__data__##f11##__VAL(R_PAR1_STATUS_DATA_, data_, v11) << R_PAR1_STATUS_DATA__data__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_PAR1_STATUS_DATA_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_PAR1_STATUS_DATA.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_PAR1_STATUS_DATA_(f1_,v1,f2_,v2,f3_,v3,f4_,v4,f5_,v5,f6_,v6,f7_,v7,f8_,v8,f9_,v9,f10_,v10,f11_,v11) ( \
  (R_PAR1_STATUS_DATA__mode__##f1_##_VAL(R_PAR1_STATUS_DATA_, mode_, v1) << R_PAR1_STATUS_DATA__mode__BITNR) | \
  (R_PAR1_STATUS_DATA__perr__##f2_##_VAL(R_PAR1_STATUS_DATA_, perr_, v2) << R_PAR1_STATUS_DATA__perr__BITNR) | \
  (R_PAR1_STATUS_DATA__ack__##f3_##_VAL(R_PAR1_STATUS_DATA_, ack_, v3) << R_PAR1_STATUS_DATA__ack__BITNR) | \
  (R_PAR1_STATUS_DATA__busy__##f4_##_VAL(R_PAR1_STATUS_DATA_, busy_, v4) << R_PAR1_STATUS_DATA__busy__BITNR) | \
  (R_PAR1_STATUS_DATA__fault__##f5_##_VAL(R_PAR1_STATUS_DATA_, fault_, v5) << R_PAR1_STATUS_DATA__fault__BITNR) | \
  (R_PAR1_STATUS_DATA__sel__##f6_##_VAL(R_PAR1_STATUS_DATA_, sel_, v6) << R_PAR1_STATUS_DATA__sel__BITNR) | \
  (R_PAR1_STATUS_DATA__ext_mode__##f7_##_VAL(R_PAR1_STATUS_DATA_, ext_mode_, v7) << R_PAR1_STATUS_DATA__ext_mode__BITNR) | \
  (R_PAR1_STATUS_DATA__tr_rdy__##f8_##_VAL(R_PAR1_STATUS_DATA_, tr_rdy_, v8) << R_PAR1_STATUS_DATA__tr_rdy__BITNR) | \
  (R_PAR1_STATUS_DATA__dav__##f9_##_VAL(R_PAR1_STATUS_DATA_, dav_, v9) << R_PAR1_STATUS_DATA__dav__BITNR) | \
  (R_PAR1_STATUS_DATA__ecp_cmd__##f10_##_VAL(R_PAR1_STATUS_DATA_, ecp_cmd_, v10) << R_PAR1_STATUS_DATA__ecp_cmd__BITNR) | \
  (R_PAR1_STATUS_DATA__data__##f11_##_VAL(R_PAR1_STATUS_DATA_, data_, v11) << R_PAR1_STATUS_DATA__data__BITNR) \
)

#endif

/*
 *  R_PAR_ECP16_DATA
 *  - type:  RW
 *  - addr:  0xb0000040
 *  - group: Parallel printer port registers
 */

#if USE_GROUP__Parallel_printer_port_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_PAR_ECP16_DATA
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_PAR_ECP16_DATA.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_PAR_ECP16_DATA. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_PAR_ECP16_DATA(f1,v1) ( \
  R_PAR_ECP16_DATA__WRITE(R_PAR_ECP16_DATA__ADDR, ( \
    REG_VAL__R_PAR_ECP16_DATA_(f1##_,v1) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_PAR_ECP16_DATA
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_PAR_ECP16_DATA(f1,v1) ( \
  (R_PAR_ECP16_DATA__data__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_PAR_ECP16_DATA
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_PAR_ECP16_DATA.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_PAR_ECP16_DATA(f1,v1) ( \
  (R_PAR_ECP16_DATA__data__##f1##__VAL(R_PAR_ECP16_DATA_, data_, v1) << R_PAR_ECP16_DATA__data__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_PAR_ECP16_DATA_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_PAR_ECP16_DATA.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_PAR_ECP16_DATA_(f1_,v1) ( \
  (R_PAR_ECP16_DATA__data__##f1_##_VAL(R_PAR_ECP16_DATA_, data_, v1) << R_PAR_ECP16_DATA__data__BITNR) \
)

#endif

/*
 *  R_PHY_COUNTERS
 *  - type:  RO
 *  - addr:  0xb00000ac
 *  - group: Network interface registers
 */

#if USE_GROUP__Network_interface_registers

/* No REG_SET__register-name for read only registers. */

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_PHY_COUNTERS
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_PHY_COUNTERS(f1,v1,f2,v2) ( \
  (R_PHY_COUNTERS__sqe_test_error__##f1##__MASK & REG__##v1) | \
  (R_PHY_COUNTERS__carrier_loss__##f2##__MASK & REG__##v2) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_PHY_COUNTERS
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_PHY_COUNTERS.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_PHY_COUNTERS(f1,v1,f2,v2) ( \
  (R_PHY_COUNTERS__sqe_test_error__##f1##__VAL(R_PHY_COUNTERS_, sqe_test_error_, v1) << R_PHY_COUNTERS__sqe_test_error__BITNR) | \
  (R_PHY_COUNTERS__carrier_loss__##f2##__VAL(R_PHY_COUNTERS_, carrier_loss_, v2) << R_PHY_COUNTERS__carrier_loss__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_PHY_COUNTERS_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_PHY_COUNTERS.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_PHY_COUNTERS_(f1_,v1,f2_,v2) ( \
  (R_PHY_COUNTERS__sqe_test_error__##f1_##_VAL(R_PHY_COUNTERS_, sqe_test_error_, v1) << R_PHY_COUNTERS__sqe_test_error__BITNR) | \
  (R_PHY_COUNTERS__carrier_loss__##f2_##_VAL(R_PHY_COUNTERS_, carrier_loss_, v2) << R_PHY_COUNTERS__carrier_loss__BITNR) \
)

#endif

/*
 *  R_PORT_G_DATA
 *  - type:  RW
 *  - addr:  0xb0000028
 *  - group: General config registers
 */

#if USE_GROUP__General_config_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_PORT_G_DATA
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_PORT_G_DATA.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of vn parameters to fields fn in register 
*#               R_PORT_G_DATA. 
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_SET__R_PORT_G_DATA(f1,v1) ( \
  R_PORT_G_DATA__WRITE(R_PORT_G_DATA__ADDR, ( \
    REG_VAL__R_PORT_G_DATA_(f1##_,v1) ) \
  ) \
)

/* No REG_SET__register-name__SHADOW for read only and read write registers. */

/*#**********************************************************************
*#
*# MACRO NAME  : REG_MASK__R_PORT_G_DATA
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : REG__on, or REG__off
*#
*# RETURNS     : Integer value with 1s in all on-fields, 
*#               and 0s in all off-fields.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Create a mask with 1s in all fields with vn == REG__on,
*#               and 0s in fields with vn == REG_off.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Only put ## where necessary to stop
*#                                     premature macro evaluation.
*#**********************************************************************/

#define REG_MASK__R_PORT_G_DATA(f1,v1) ( \
  (R_PORT_G_DATA__data__##f1##__MASK & REG__##v1) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_PORT_G_DATA
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_PORT_G_DATA.
*#               Parameters vn are checked for validity.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   To stop premature evaluation, append
*#                                     _ to fn parameters when passing
*#                                     on to other macros.
*#**********************************************************************/

#define REG_VAL__R_PORT_G_DATA(f1,v1) ( \
  (R_PORT_G_DATA__data__##f1##__VAL(R_PORT_G_DATA_, data_, v1) << R_PORT_G_DATA__data__BITNR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL__R_PORT_G_DATA_
*#
*# PARAMETERS  : fn_   : Name of field N, with "_" appended.
*#               vn    : Value in field N.
*#
*# RETURNS     : Integer value.
*#
*# SIDE EFFECTS: REG_VERROR may be evaluated.
*#
*# DESCRIPTION : Create a value by combining the vn parameters according
*#               to the fields in register R_PORT_G_DATA.
*#               Parameters vn are checked for validity.
*#               INTERNAL: for use by other macros in this file only.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Sep 30 2002    Hans-Peter Nilsson   Initial version
*#**********************************************************************/

#define REG_VAL__R_PORT_G_DATA_(f1_,v1) ( \
  (R_PORT_G_DATA__data__##f1_##_VAL(R_PORT_G_DATA_, data_, v1) << R_PORT_G_DATA__data__BITNR) \
)

#endif

/*
 *  R_PORT_PA_DATA
 *  - type:  WO
 *  - addr:  0xb0000030
 *  - group: General port configuration registers
 */

#if USE_GROUP__General_port_configuration_registers

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET__R_PORT_PA_DATA
*#
*# PARAMETERS  : fn    : Name of field N.
*#               vn    : Integer value to write to field N.
*#
*# RETURNS     : integer value written to register R_PORT_PA_DATA.
*#
*# SIDE EFFECTS: REG_INITIATED evaluated.
*#
*# DESCRIPTION : Write value of vn parameter