/*!**********************************************************************
*!
*! FILE NAME: hwregs_int.h
*!
*! DESCRIPTION: Internal shadow register implementation.
*!              Not intended for general use.
*!              This file is include in hwregs.h
*!
*! FUNCTIONS: none
*!
*! NOTE: This file is automatically generated, do _not_ edit.
*!       Created: Thu Oct  3 01:21:27 2002
*!       By:      Id: shadow_gen,v 1.14 2002/10/02 20:31:22 hp Exp 
*!       From:    /n/asic/projects/etrax_ng/doc/work/etrax_ng_regs.rd 1.168
*!                /n/asic/projects/etrax_ng/include//hwregs.ctrl 1.3
*!
*! MACROS: REG_INITIATED
*!         REG_CHECK_INIT
*!         REG_ICHECK_INIT
*!         REG_CHECK_INR
*!         REG_VAL_VAL
*!         REG_SVAL
*!         REG_SVAL_ZERO
*!         REG_SVAL_SHADOW
*!         REG_SVAL_I
*!         REG_SVAL_I_ZERO
*!         REG_SVAL_I_SHADOW
*!
*!         REG_IMASK
*!         REG_ADDR_I
*!         REG_SADDR_I
*!         REG_IADDR_I
*!         REG_VAL_ENUM
*!         REG_GET_WO
*!         REG_GET_RO
*!         REG_GET_RW
*!         REG_IGET_WO
*!         REG_IGET_RO
*!         REG_IGET_RW
*!         REG_SET_WO
*!         REG_ISET_WO
*!         REG_SET_VAL_WO
*!         REG_SET_RW
*!         REG_ISET_RW
*!         REG_SET_VAL_RW
*!         REG_EQL_WO
*!         REG_EQL_RO
*!         REG_EQL_RW
*!         REG_IEQL_WO
*!         REG_IEQL_RO
*!         REG_IEQL_RW
*!         REG_RD_WO
*!         REG_RD_RO
*!         REG_RD_RW
*!         REG_IRD_WO
*!         REG_IRD_RO
*!         REG_IRD_RW
*!         REG_WR_WO
*!         REG_WR_RW
*!         REG_IWR_WO
*!         REG_IWR_RW
*!
*!----------------------------------------------------------------------
*! HISTORY
*!
*! DATE           NAME                 CHANGES
*! ----           ----                 -------
*! Apr 01 1998    Jan Bengtsson        Initial version
*! Oct 01 2002    Hans-Peter Nilsson   Large mechanical changes to correct
*!                                     use of the ## operator.
*!----------------------------------------------------------------------
*!
*! (C) Copyright 1998, 2002 Axis Communications AB, LUND, SWEDEN
*!
*!**********************************************************************/
/* %Z% %M% %I% %G% */

#ifndef __HWREGS_INT_H__
#define __HWREGS_INT_H__

/********************** INCLUDE FILES SECTION **************************/

/********************** CONSTANT AND MACRO SECTION *********************/
#ifndef __REG_GENERAL_INT_H__
#define __REG_GENERAL_INT_H__

/*
** The first part of hwregs_int.h is common to all shadow
** register modules, and should therefore only be included once to
** avoid macro redefinitions.
*/

#if REG_DEBUG && !defined(__ASSEMBLER__)

#ifndef REG_SERROR
#define REG_SERROR(ok,reg)  \
  assert( ok ),
#endif

#ifndef REG_VERROR
#define REG_VERROR(ok,val) \
  assert( ok ),
#endif

#ifndef REG_IERROR
#define REG_IERROR(ok,i,reg) \
  assert( ok ),
#endif

/*#**********************************************************************
*#
*# MACRO NAME  : REG_INITIATED
*#
*# PARAMETERS  : reg_ : Name of a register, with "_" appended.
*#
*# RETURNS     : 0
*#
*# SIDE EFFECTS: Clears initiated flag in reg_initiated_type struct.
*#
*# DESCRIPTION : Clears initiated flag in reg_initiated_type struct.
*#
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Parameter now has "_" appended.
*#**********************************************************************/

#define REG_INITIATED(reg_) \
  *reg_##_IADDR = 0,

/*#**********************************************************************
*#
*# MACRO NAME  : REG_CHECK_INIT
*#
*# PARAMETERS  : reg_ : Name of a register, with "_" appended.
*#
*# RETURNS     : Value of REG_SERROR macro.
*#
*# SIDE EFFECTS: Evaluates REG_SERROR macro.
*#
*# DESCRIPTION : Check that shadow is initiated, by
*#               evaluating REG_SERROR macro.
*#
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Parameter now has "_" appended.
*#                                     Correct stringization.
*#**********************************************************************/

#define REG_CHECK_INIT(reg_) \
  REG_SERROR(*reg_##_IADDR == 0, #reg_)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_ICHECK_INIT
*#
*# PARAMETERS  : i   : Interface number.
*#               reg_: Name of a register, with "_" appended.
*#
*# RETURNS     : Value of REG_SERROR macro.
*#
*# SIDE EFFECTS: Evaluates REG_SERROR macro.
*#
*# DESCRIPTION : Check that shadow is initiated, by
*#               evaluating REG_SERROR macro.
*#
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Reg parameter now has "_" appended.
*#                                     Correct stringization.
*#**********************************************************************/

#define REG_ICHECK_INIT(i, reg_) \
  REG_SERROR(*REG_IADDR_I(i, reg_) == 0, #reg_)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_CHECK_INR
*#
*# PARAMETERS  : i   : Interface number.
*#               reg_: Name of a register, with "_" appended.
*#
*# RETURNS     : Value of REG_IERROR macro.
*#
*# SIDE EFFECTS: Evaluates REG_IERROR macro.
*#
*# DESCRIPTION : Check that interface number is valid.
*#               If an invalid interface number is found at compile
*#               time gcc report the following warning:
*#                  'warning: right shift count >= width of type'
*#               If an invalid interface number is found at run time
*#               the REG_IERROR macro is evaluated.
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Reg parameter now has "_" appended.
*#                                     Correct stringization.
*#**********************************************************************/

#define REG_CHECK_INR(i, reg_) \
  REG_IERROR( \
    1 >> ( \
      ( \
        (udword)(~(i)) > (udword)(~(reg_##_FIRST)) || \
        (udword)(i) > (udword)(reg_##_LAST) \
      ) ? 32 : 0 \
    ), \
    i, #reg_ \
  )

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL_VAL
*#
*# PARAMETERS  : reg_  : Name of a register, with "_" appended.
*#               field_: Name of a field, with "_" appended.
*#               val   : Integer value
*#
*# RETURNS     : val
*#
*# SIDE EFFECTS: Evaluate REG_VERROR macro.
*#
*# DESCRIPTION : Check that an integer value is within field range.
*#               If val parameter is found to be out of range at compile
*#               time gcc report the following warning:
*#                  'left shift count >= width of type'
*#               If an invalid integer value is found at run time
*#               the REG_VERROR macro is evaluated.
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Reg and field name parameters now
*#                                     have "_" appended.
*#**********************************************************************/

#define REG_VAL_VAL(reg_, field_, val) ( \
  REG_VERROR( \
    1 << ( \
      ( \
        (udword)(~(val)) > (udword)(~(reg_##_##field_##_MIN)) || \
        (udword)(val) > (udword)(reg_##_##field_##_MAX) \
      ) ? 32 : 0 \
    ), \
    val \
  ) \
  val \
)

#else /* ! REG_DEBUG || __ASSEMBER__ */

/* Checks only done in debug mode. */
/* No need for REG_VERROR, REG_SERROR, and REG_IERROR. */

#define REG_INITIATED(reg)
#define REG_CHECK_INIT(reg)
#define REG_ICHECK_INIT(i,reg)
#define REG_CHECK_INR(i,reg)
#define REG_VAL_VAL(reg,field,val) (val)

#endif

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SVAL
*#
*# PARAMETERS  : reg_  : Name of a register, with "_" appended.
*#
*# RETURNS     : Value of shadow register associated with a WO register,
*#               or 0.
*#
*# SIDE EFFECTS: None
*#
*# DESCRIPTION : Read contents of a shadow register. By using this macro
*#               it's possible to force special values for some registers,
*#               e.g. zero for set/clr registers.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Reg parameter now has "_" appended.
*#**********************************************************************/
#define REG_SVAL(reg_) ( \
  reg_##_SVAL(reg_) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SVAL_ZERO
*#
*# PARAMETERS  : reg   : Name of a register.
*#
*# RETURNS     : Zero.
*#
*# SIDE EFFECTS: None
*#
*# DESCRIPTION : Force contents of shadow register to zero, used by
*#               the set/clr registers.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*#**********************************************************************/
#define REG_SVAL_ZERO(reg) ( \
  0 \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SVAL_SHADOW
*#
*# PARAMETERS  : reg_  : Name of a register, with "_" appended.
*#
*# RETURNS     : Value of shadow register associated with a WO register.
*#
*# SIDE EFFECTS: None
*#
*# DESCRIPTION : Read shadow register contents.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Reg parameter now has "_" appended.
*#**********************************************************************/
#define REG_SVAL_SHADOW(reg_) ( \
  *reg_##_SADDR \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SVAL_I
*#
*# PARAMETERS  : reg_  : Name of a register, with "_" appended.
*#               i     : Interface number.
*#
*# RETURNS     : Value of shadow register associated with a WO register,
*#               or 0, for interface i.
*#
*# SIDE EFFECTS: None
*#
*# DESCRIPTION : Read contents of a shadow register. By using this macro
*#               it's possible to force special values for some registers,
*#               e.g. zero for set/clr registers.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Reg parameter now has "_" appended.
*#**********************************************************************/
#define REG_SVAL_I(i, reg_) ( \
  reg_##_SVAL_I(i, reg_) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SVAL_I_ZERO
*#
*# PARAMETERS  : reg_  : Name of a register, with "_" appended.
*#               i     : Interface number.
*#
*# RETURNS     : Zero.
*#
*# SIDE EFFECTS: None
*#
*# DESCRIPTION : Force contents of shadow register to zero, used by
*#               the set/clr registers, for interface i.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Reg parameter now has "_" appended.
*#**********************************************************************/
#define REG_SVAL_I_ZERO(i,reg) ( \
  0 \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SVAL_I_SHADOW
*#
*# PARAMETERS  : reg_  : Name of a register.
*#               i     : Interface number.
*#
*# RETURNS     : Value of shadow register associated with a WO register,
*#               for interface i.
*#
*# SIDE EFFECTS: None
*#
*# DESCRIPTION : Read shadow register contents, of interface i.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Reg parameter now has "_" appended.
*#**********************************************************************/
#define REG_SVAL_I_SHADOW(i, reg_) ( \
  *REG_SADDR_I(i, reg_) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_IMASK
*#
*# PARAMETERS  : reg_   : Name of a register, with "_" appended.
*#               field_ : Name of a field, with "_" appended.
*#
*# RETURNS     : Inverse of field mask.
*#
*# SIDE EFFECTS: none
*#
*# DESCRIPTION : Create a mask with zeros matching the field,
*#               and ones matching the rest.
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Reg and field name parameters now
*#                                     have "_" appended.
*#**********************************************************************/

#define REG_IMASK(reg_, field_) ( \
  ~reg_##_##field_##_##field_##_MASK \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_ADDR_I
*#
*# PARAMETERS  : i     : interface number.
*#               reg_  : Name of a register, with "_" appended.
*#
*# RETURNS     : Address to reg for interface i.
*#
*# SIDE EFFECTS: May evaluate REG_IERROR.
*#
*# DESCRIPTION : Calculate address to reg for interface i.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Reg parameter now has "_" appended.
*#**********************************************************************/

#define REG_ADDR_I(i, reg_) ( \
  reg_##_TYPECAST ( \
    REG_CHECK_INR(i, reg_) \
    ((udword) reg_##_ADDR) + reg_##_OFFSET * (i) \
  ) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SADDR_I
*#
*# PARAMETERS  : i     : interface number.
*#               reg_  : Name of a register, with "_" appended.
*#
*# RETURNS     : Address to shadow register for interface i.
*#
*# SIDE EFFECTS: May evaluate REG_IERROR.
*#
*# DESCRIPTION : Calculate address to shadow register for interface i.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Reg parameter now has "_" appended.
*#**********************************************************************/

#define REG_SADDR_I(i, reg_) ( \
  reg_##_STYPECAST ( \
    REG_CHECK_INR(i, reg_) \
    ((udword) reg_##_SADDR) + reg_##_SOFFSET * (i) \
  ) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_IADDR_I
*#
*# PARAMETERS  : i     : interface number.
*#               reg_  : Name of a register, with "_" appended.
*#
*# RETURNS     : Address to initiated flag for interface i.
*#
*# SIDE EFFECTS: May evaluate REG_IERROR.
*#
*# DESCRIPTION : Calculate address to initiated flag for interface i.
*#               The reg_initiated_type struct has the same layout as
*#               the reg_shadow_type struct, i.e. it's possible to use
*#               <reg>__SOFFSET here to.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Reg parameter now has "_" appended.
*#**********************************************************************/

#define REG_IADDR_I(i, reg_) ( \
  reg_##_STYPECAST ( \
    REG_CHECK_INR(i, reg_) \
    ((udword) reg_##_IADDR) + reg_##_SOFFSET * (i) \
  ) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_VAL_ENUM
*#
*# PARAMETERS  : reg_  : Name of a register, with "_" appended.
*#               field_: Name of a field, with "_" appended.
*#               sym   : Symbolic value.
*#
*# RETURNS     : Integer value for sym.
*#
*# SIDE EFFECTS: none
*#
*# DESCRIPTION : Convert symbolic value to an integer value.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Reg and field name parameters now
*#                                     have "_" appended.
*#**********************************************************************/

#define REG_VAL_ENUM(reg_, field_, sym) ( \
  reg_##_##field_##_##field_##_##sym \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_GET_WO
*#
*# PARAMETERS  : reg_   : Name of a register, with "_" appended.
*#               field_ : Name of a field, with "_" appended.
*#
*# RETURNS     : Value of field field in register reg.
*#
*# SIDE EFFECTS: May evaluate REG_SERROR.
*#
*# DESCRIPTION : Read a field in a write only shadow register,
*#               i.e. from the shadow register. If the shadow register
*#               isn't initiated the REG_SERROR macro is evaluated.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Reg and field name parameters now
*#                                     have "_" appended.
*#**********************************************************************/

#define REG_GET_WO(reg_, field_) ( \
  REG_CHECK_INIT(reg_) \
  (REG_SVAL(reg_) & reg_##_##field_##_##field_##_MASK) >> \
    reg_##_##field_##_BITNR \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_GET_RO, REG_GET_RW
*#
*# PARAMETERS  : reg_   : Name of a register, with "_" appended.
*#               field_ : Name of a field, with "_" appended.
*#
*# RETURNS     : Value of field field in register reg.
*#
*# SIDE EFFECTS: none
*#
*# DESCRIPTION : Read a field in a read only or read write shadow register.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Reg and field name parameters now
*#                                     have "_" appended.
*#**********************************************************************/

#define REG_GET_RO(reg_, field_) ( \
  (reg_##_READ(reg_##_ADDR) & reg_##_##field_##_##field_##_MASK) >> \
    reg_##_##field_##_BITNR \
)

#define REG_GET_RW REG_GET_RO

/*#**********************************************************************
*#
*# MACRO NAME  : REG_IGET_WO
*#
*# PARAMETERS  : i     : Interface number.
*#               reg_  : Name of a register, with "_" appended.
*#               field_: Name of a field, with "_" appended.
*#
*# RETURNS     : Value of field field in register reg.
*#
*# SIDE EFFECTS: May evaluate REG_SERROR, and REG_IERROR.
*#
*# DESCRIPTION : Read a field in a write only register for interface i, 
*#               i.e. from the shadow register. If the shadow register
*#               isn't initiated the REG_SERROR macro is evaluated,
*#               and if i is out of range REG_IERROR is evaluated.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Reg and field name parameters now
*#                                     have "_" appended.
*#**********************************************************************/

#define REG_IGET_WO(i, reg_, field_) ( \
  REG_ICHECK_INIT(i, reg_) \
  (REG_SVAL_I(i, reg_) & reg_##_##field_##_##field_##_MASK) >> \
  reg_##_##field_##_BITNR \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_IGET_RO, REG_IGET_RW
*#
*# PARAMETERS  : i     : Interface number.
*#               reg_  : Name of a register, with "_" appended.
*#               field_: Name of a field, with "_" appended.
*#
*# RETURNS     : Value of field field in register reg.
*#
*# SIDE EFFECTS: May evaluate REG_IERROR.
*#
*# DESCRIPTION : Read a field in a read only or read write register for
*#               interface i. If i is out of range REG_IERROR is evaluated.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Reg and field name parameters now
*#                                     have "_" appended.
*#**********************************************************************/

#define REG_IGET_RO(i, reg_, field_) ( \
  (reg_##_READ(REG_ADDR_I(i, reg_) ) & \
   reg_##_##field_##_##field_##_MASK) >> reg_##_##field_##_BITNR \
)

#define REG_IGET_RW REG_IGET_RO

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET_WO
*#
*# PARAMETERS  : reg_  : Name of a register, with "_" appended.
*#               field_: Name of a field, with "_" appended.
*#               val   : Value to write to field.
*#
*# RETURNS     : Integer value written to complete register.
*#
*# SIDE EFFECTS: May evaluate REG_SERROR and REG_VERROR.
*#
*# DESCRIPTION : Write val parameter to field field in write only register
*#               reg and in the shadow register. If the shadow register
*#               isn't initiated REG_SERROR is evaluated, and if the
*#               val parameter is out of range REG_VERROR is evaluated.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Reg and field name parameters now
*#                                     have "_" appended.
*#**********************************************************************/

#define REG_SET_WO(reg_, field_, val) ( \
  *reg_##_SADDR = ( \
    REG_CHECK_INIT(reg_) \
    (REG_SVAL(reg_) & REG_IMASK(reg_, field_)) | \
    (reg_##_##field_##_##field_##_VAL(reg_, field_, val) << \
      reg_##_##field_##_BITNR) \
  ), \
  reg_##_WRITE(reg_##_ADDR, *reg_##_SADDR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_ISET_WO
*#
*# PARAMETERS  : i     : Interface number.
*#               reg_  : Name of a register, with "_" appended.
*#               field_: Name of a field, with "_" appended.
*#               val   : Value to write to field.
*#
*# RETURNS     : Integer value written to complete register.
*#
*# SIDE EFFECTS: May evaluate REG_IERROR, REG_SERROR, and REG_VERROR.
*#
*# DESCRIPTION : Write val parameter to field field in write only register
*#               reg of interface i and in the shadow register. If the 
*#               shadow register isn't initiated REG_SERROR is evaluated, 
*#               and if the val parameter is out of range REG_VERROR is
*#               evaluated, and if the interface number is out of range
*#               REG_IERROR is evaluated.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Reg and field name parameters now
*#                                     have "_" appended.
*#**********************************************************************/

#define REG_ISET_WO(i, reg_, field_, val) ( \
  *REG_SADDR_I(i, reg_) = ( \
    REG_ICHECK_INIT(i, reg_) \
    (REG_SVAL_I(i, reg_) & REG_IMASK(reg_, field_)) | \
    (reg_##_##field_##_##field_##_VAL(reg_, field_, val) << \
      reg_##_##field_##_BITNR) \
  ), \
  reg_##_WRITE(REG_ADDR_I(i, reg_), *REG_SADDR_I(i, reg_)) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET_VAL_WO
*#
*# PARAMETERS  : reg_  : Name of a register, with "_" appended.
*#               field_: Name of a field, with "_" appended.
*#               val   : Integer value to write to symbolic field.
*#
*# RETURNS     : Integer value written to complete register.
*#
*# SIDE EFFECTS: May evaluate REG_SERROR and REG_VERROR.
*#
*# DESCRIPTION : Write val parameter to field field in write only register
*#               reg and in the shadow register. If the shadow register
*#               isn't initiated REG_SERROR is evaluated, and if the
*#               val parameter is out of range REG_VERROR is evaluated.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Reg and field name parameters now
*#                                     have "_" appended.
*#**********************************************************************/

#define REG_SET_VAL_WO(reg_, field_, val) ( \
  *reg_##_SADDR = ( \
    REG_CHECK_INIT(reg_) \
    (REG_SVAL(reg_) & REG_IMASK(reg_, field_)) | \
    (REG_VAL_VAL(reg_, field_, val) << reg_##_##field_##_BITNR) \
  ), \
  reg_##_WRITE(reg_##_ADDR, *reg_##_SADDR) \
)

/*#**********************************************************************
*#  Can't write to a read only register, i.e.  NO  REG_SET_RO, REG_ISET_RO,
*#  and REG_SET_VAL_RO macros.
*#**********************************************************************/


/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET_RW
*#
*# PARAMETERS  : reg_  : Name of a register, with "_" appended.
*#               field_: Name of a field, with "_" appended.
*#               val   : Value to write to field.
*#
*# RETURNS     : Integer value written to complete register.
*#
*# SIDE EFFECTS: May evaluate REG_VERROR.
*#
*# DESCRIPTION : Write val parameter to field field in read write register
*#               reg. If the val parameter is out of range REG_VERROR is
*#               evaluated.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Reg and field name parameters now
*#                                     have "_" appended.
*#**********************************************************************/

#define REG_SET_RW(reg_, field_, val) ( \
  reg_##_WRITE(reg_##_ADDR, ( \
    (reg_##_READ(reg_##_ADDR) & REG_IMASK(reg_, field_)) | \
    (reg_##_##field_##_##field_##_VAL(reg_, field_, val) << \
      reg_##_##field_##_BITNR) ) \
  ) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_ISET_RW
*#
*# PARAMETERS  : i     : Interface number.
*#               reg_  : Name of a register, with "_" appended.
*#               field_: Name of a field, with "_" appended.
*#               val   : Value to write to field.
*#
*# RETURNS     : Integer value written to complete register.
*#
*# SIDE EFFECTS: May evaluate REG_VERROR and REG_IERROR.
*#
*# DESCRIPTION : Write val parameter to field field in read write register
*#               reg of interface i. If the val parameter is out of range
*#               REG_VERROR is evaluated, and if the interface number is
*#               out of range REG_IERROR is evaluated.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Reg and field name parameters now
*#                                     have "_" appended.
*#**********************************************************************/

#define REG_ISET_RW(i, reg_, field_, val) ( \
  reg_##_WRITE(REG_ADDR_I(i, reg_), ( \
    (reg_##_READ(REG_ADDR_I(i, reg_)) & REG_IMASK(reg_, field_))\
    | (reg_##_##field_##_##field_##_VAL(reg_, field_, val) << \
       reg_##_##field_##_BITNR) ) \
  ) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_SET_VAL_RW
*#
*# PARAMETERS  : reg_  : Name of a register, with "_" appended.
*#               field_: Name of a field, with "_" appended.
*#               val   : Integer value to write to symbolic field.
*#
*# RETURNS     : Integer value written to complete register.
*#
*# SIDE EFFECTS: May evaluate REG_VERROR.
*#
*# DESCRIPTION : Write val parameter to field field in read write register
*#               reg. If the val parameter is out of range REG_VERROR is
*#               evaluated.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Reg and field name parameters now
*#                                     have "_" appended.
*#**********************************************************************/

#define REG_SET_VAL_RW(reg_, field_, val) ( \
  reg_##_WRITE(reg_##_ADDR, ( \
    (reg_##_READ(reg_##_ADDR) & REG_IMASK(reg_, field_)) | \
    (REG_VAL_VAL(reg_, field_, val) << reg_##_##field_##_BITNR) ) \
  ) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_EQL_WO
*#
*# PARAMETERS  : reg_  : Name of a register, with "_" appended.
*#               field_: Name of a field, with "_" appended.
*#               val   : Value to compare with field.
*#
*# RETURNS     : TRUE, FALSE
*#
*# SIDE EFFECTS: May evaluate REG_SERROR and REG_VERROR.
*#
*# DESCRIPTION : Compare val parameter with field field in write only
*#               register reg. If the val parameter is out of range 
*#               REG_VERROR is evaluated, and if the shadow register
*#               isn't initiated REG_SERROR is evaluated.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Reg and field name parameters now
*#                                     have "_" appended.
*#**********************************************************************/

#define REG_EQL_WO(reg_, field_, val) ( \
  REG_CHECK_INIT(reg_) \
  ( (REG_SVAL(reg_)  & reg_##_##field_##_##field_##_MASK) >> \
       reg_##_##field_##_BITNR \
  ) == reg_##_##field_##_##field_##_VAL(reg_, field_, val) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_EQL_RO, REG_EQL_RW
*#
*# PARAMETERS  : reg_  : Name of a register, with "_" appended.
*#               field_: Name of a field, with "_" appended.
*#               val   : Value to compare with field.
*#
*# RETURNS     : TRUE, FALSE
*#
*# SIDE EFFECTS: May evaluate REG_VERROR.
*#
*# DESCRIPTION : Compare val parameter with field field in read only
*#               or read write register reg. If the val parameter is
*#               out of range REG_VERROR is evaluated.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Reg and field name parameters now
*#                                     have "_" appended.
*#**********************************************************************/

#define REG_EQL_RO(reg_, field_, val) ( \
  ( (reg_##_READ(reg_##_ADDR) & reg_##_##field_##_##field_##_MASK) >> \
       reg_##_##field_##_BITNR \
  ) == reg_##_##field_##_##field_##_VAL(reg_, field_, val) \
)

#define REG_EQL_RW REG_EQL_RO

/*#**********************************************************************
*#
*# MACRO NAME  : REG_IEQL_WO
*#
*# PARAMETERS  : i     : Interface number.
*#               reg_  : Name of a register, with "_" appended.
*#               field_: Name of a field, with "_" appended.
*#               val   : Value to compare with field.
*#
*# RETURNS     : TRUE, FALSE
*#
*# SIDE EFFECTS: May evaluate REG_VERROR, REG_IERROR, and REG_SERROR.
*#
*# DESCRIPTION : Compare val parameter with field field in write only
*#               register reg of interface i. If the val parameter is
*#               out of range REG_VERROR is evaluated, and if the
*#               interface number is out of range REG_IERROR is evaluated,
*#               and if the shadow register isn't initiated REG_SERROR
*#               is evaluated.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Reg and field name parameters now
*#                                     have "_" appended.
*#**********************************************************************/

#define REG_IEQL_WO(i, reg_, field_, val) ( \
  REG_ICHECK_INIT(i, reg_) \
  ( (REG_SVAL_I(i, reg_) & reg_##_##field_##_##field_##_MASK) >> \
       reg_##_##field_##_BITNR \
  ) == reg_##_##field_##_##field_##_VAL(reg_, field_, val) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_IEQL_RO, REG_IEQL_RW
*#
*# PARAMETERS  : i     : Interface number.
*#               reg_  : Name of a register.
*#               field_: Name of a field.
*#               val   : Value to compare with field.
*#
*# RETURNS     : TRUE, FALSE
*#
*# SIDE EFFECTS: May evaluate REG_VERROR and REG_IERROR.
*#
*# DESCRIPTION : Compare val parameter with field field in read only
*#               or read write register reg of interface i. If the val
*#               parameter is out of range REG_VERROR is evaluated, and
*#               if the interface number is out of range REG_IERROR is
*#               evaluated.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Reg and field name parameters now
*#                                     have "_" appended.
*#**********************************************************************/

#define REG_IEQL_RO(i, reg_, field_, val) ( \
  ( (reg_##_READ(REG_ADDR_I(i, reg_)) & \
     reg_##_##field_##_##field_##_MASK) >> reg_##_##field_##_BITNR \
  ) ==  reg_##_##field_##_##field_##_VAL(reg_, field_, val) \
)

#define REG_IEQL_RW REG_IEQL_RO

/*#**********************************************************************
*#
*# MACRO NAME  : REG_RD_WO
*#
*# PARAMETERS  : reg_  : Name of a register, with "_" appended.
*#
*# RETURNS     : Contents of register reg.
*#
*# SIDE EFFECTS: May evaluate REG_SERROR.
*#
*# DESCRIPTION : Read contents of write only register reg, i.e. read
*#               the shadow register. If the shadow register isn't
*#               initiated REG_SERROR is evaluated.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Reg parameter now has "_" appended.
*#**********************************************************************/

#define REG_RD_WO(reg_) ( \
  REG_CHECK_INIT(reg_) \
  REG_SVAL(reg_) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_RD_RO, REG_RD_RW
*#
*# PARAMETERS  : reg_  : Name of a register, with "_" appended.
*#
*# RETURNS     : Contents of register reg.
*#
*# SIDE EFFECTS: none
*#
*# DESCRIPTION : Read contents of read only or read write register reg.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Reg parameter now has "_" appended.
*#**********************************************************************/

#define REG_RD_RO(reg_) ( \
  reg_##_READ(reg_##_ADDR) \
)

#define REG_RD_RW REG_RD_RO

/*#**********************************************************************
*#
*# MACRO NAME  : REG_IRD_WO
*#
*# PARAMETERS  : i     : Interface number.
*#               reg_  : Name of a register, with "_" appended.
*#
*# RETURNS     : Contents of register reg.
*#
*# SIDE EFFECTS: May evaluate REG_SERROR and REG_IERROR.
*#
*# DESCRIPTION : Read contents of write only register reg, i.e. read
*#               the shadow register of interface i. If the shadow register
*#               isn't initiated REG_SERROR is evaluated, and if the
*#               interface number is out of range REG_IERROR is evaluated.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Reg parameter now has "_" appended.
*#**********************************************************************/

#define REG_IRD_WO(i, reg_) ( \
  REG_ICHECK_INIT(i, reg_) \
  REG_SVAL_I(i, reg_) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_IRD_RO, REG_IRD_RW
*#
*# PARAMETERS  : i     : Interface number.
*#               reg_  : Name of a register.
*#
*# RETURNS     : Contents of register reg.
*#
*# SIDE EFFECTS: none
*#
*# DESCRIPTION : Read contents of read only or read write register reg
*#               of interface i.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Reg parameter now has "_" appended.
*#**********************************************************************/

#define REG_IRD_RO(i, reg_) ( \
  reg_##_READ(REG_ADDR_I(i, reg_)) \
)

#define REG_IRD_RW REG_IRD_RO

/*#**********************************************************************
*#
*# MACRO NAME  : REG_WR_WO
*#
*# PARAMETERS  : reg_  : Name of a register, with "_" appended.
*#               var   : Variable (or value) to write to reg.
*#
*# RETURNS     : integer value written to register reg.
*#
*# SIDE EFFECTS: May evaluate REG_SERROR.
*#
*# DESCRIPTION : Write value of var parameter to register reg and to
*#               the shadow register. If the shadow register
*#               isn't initiated REG_SERROR is evaluated.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Reg parameter now has "_" appended.
*#**********************************************************************/

#define REG_WR_WO(reg_, var) ( \
  *reg_##_SADDR = ( \
    REG_CHECK_INIT(reg_) \
    (reg_##_TYPE var) \
  ), \
  reg_##_WRITE(reg_##_ADDR, *reg_##_SADDR) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_WR_RW
*#
*# PARAMETERS  : reg_  : Name of a register, with "_" appended.
*#               var   : Variable (or value) to write to reg.
*#
*# RETURNS     : integer value written to register reg.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of var parameter to register reg.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Reg parameter now has "_" appended.
*#**********************************************************************/

#define REG_WR_RW(reg_, var) ( \
  reg_##_WRITE(reg_##_ADDR, (reg_##_TYPE (var))) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_IWR_WO
*#
*# PARAMETERS  : i     : Interface number.
*#               reg_  : Name of a register, with "_" appended.
*#               var   : Variable (or value) to write to reg.
*#
*# RETURNS     : integer value written to register reg.
*#
*# SIDE EFFECTS: May evaluate REG_SERROR.
*#
*# DESCRIPTION : Write value of var parameter to register reg and to
*#               the shadow register of interface i. If the shadow
*#               register isn't initiated REG_SERROR is evaluated.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Reg parameter now has "_" appended.
*#**********************************************************************/

#define REG_IWR_WO(i, reg_, var) ( \
  *REG_SADDR_I(i, reg_) = ( \
    REG_ICHECK_INIT(i, reg_) \
    reg_##_TYPE (var) \
  ), \
  reg_##_WRITE(REG_ADDR_I(i, reg_), *REG_SADDR_I(i, reg_)) \
)

/*#**********************************************************************
*#
*# MACRO NAME  : REG_IWR_RW
*#
*# PARAMETERS  : i     : Interface number.
*#               reg_  : Name of a register.
*#               var   : Variable (or value) to write to reg.
*#
*# RETURNS     : integer value written to register reg.
*#
*# SIDE EFFECTS: None.
*#
*# DESCRIPTION : Write value of var parameter to register reg of
*#               interface i.
*#               
*#----------------------------------------------------------------------
*# HISTORY
*#
*# DATE           NAME                 CHANGES
*# ----           ----                 -------
*# Apr 01 1998    Jan Bengtsson        Initial version
*# Oct 01 2002    Hans-Peter Nilsson   Reg parameter now has "_" appended.
*#**********************************************************************/

#define REG_IWR_RW(i, reg_, var) ( \
  reg_##_WRITE(REG_ADDR_I(i, reg_), (reg_##_TYPE (var))) \
)

/*
 *  Can't write to a read only register, i.e.  NO  REG_WR_RO, REG_IWR_RO
 *  macros.
 */

#endif /* __REG_GENERAL_INT_H__ */

/*
 *  R_ALT_SER_BAUDRATE
 *  - type:  WO
 *  - addr:  0xb000005c
 *  - group: Serial port registers
 */

#if USE_GROUP__Serial_port_registers

#define R_ALT_SER_BAUDRATE__ADDR      (REG_TYPECAST_UDWORD  0xb000005c)

#ifndef REG_NO_SHADOW
#define R_ALT_SER_BAUDRATE__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_ALT_SER_BAUDRATE + 0))
#define R_ALT_SER_BAUDRATE__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_ALT_SER_BAUDRATE + 0))
#else /* REG_NO_SHADOW */
#define R_ALT_SER_BAUDRATE__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_ALT_SER_BAUDRATE__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_ALT_SER_BAUDRATE__STYPECAST REG_STYPECAST_UDWORD
#define R_ALT_SER_BAUDRATE__SVAL      REG_SVAL_SHADOW
#define R_ALT_SER_BAUDRATE__SVAL_I    REG_SVAL_I_SHADOW
#define R_ALT_SER_BAUDRATE__TYPECAST  REG_TYPECAST_UDWORD
#define R_ALT_SER_BAUDRATE__TYPE      (REG_UDWORD)
#define R_ALT_SER_BAUDRATE__GET       REG_GET_WO
#define R_ALT_SER_BAUDRATE__IGET      REG_IGET_WO
#define R_ALT_SER_BAUDRATE__SET       REG_SET_WO
#define R_ALT_SER_BAUDRATE__ISET      REG_ISET_WO
#define R_ALT_SER_BAUDRATE__SET_VAL   REG_SET_VAL_WO
#define R_ALT_SER_BAUDRATE__EQL       REG_EQL_WO
#define R_ALT_SER_BAUDRATE__IEQL      REG_IEQL_WO
#define R_ALT_SER_BAUDRATE__RD        REG_RD_WO
#define R_ALT_SER_BAUDRATE__IRD       REG_IRD_WO
#define R_ALT_SER_BAUDRATE__WR        REG_WR_WO
#define R_ALT_SER_BAUDRATE__IWR       REG_IWR_WO

#define R_ALT_SER_BAUDRATE__WRITE(addr,value) \
  (*(addr) = (value))

#define R_ALT_SER_BAUDRATE__ser3_tr__ser3_tr__MASK 0x30000000U
#define R_ALT_SER_BAUDRATE__ser3_rec__ser3_rec__MASK 0x03000000U
#define R_ALT_SER_BAUDRATE__ser2_tr__ser2_tr__MASK 0x00300000U
#define R_ALT_SER_BAUDRATE__ser2_rec__ser2_rec__MASK 0x00030000U
#define R_ALT_SER_BAUDRATE__ser1_tr__ser1_tr__MASK 0x00003000U
#define R_ALT_SER_BAUDRATE__ser1_rec__ser1_rec__MASK 0x00000300U
#define R_ALT_SER_BAUDRATE__ser0_tr__ser0_tr__MASK 0x00000030U
#define R_ALT_SER_BAUDRATE__ser0_rec__ser0_rec__MASK 0x00000003U

#define R_ALT_SER_BAUDRATE__ser3_tr__MAX 0x3
#define R_ALT_SER_BAUDRATE__ser3_rec__MAX 0x3
#define R_ALT_SER_BAUDRATE__ser2_tr__MAX 0x3
#define R_ALT_SER_BAUDRATE__ser2_rec__MAX 0x3
#define R_ALT_SER_BAUDRATE__ser1_tr__MAX 0x3
#define R_ALT_SER_BAUDRATE__ser1_rec__MAX 0x3
#define R_ALT_SER_BAUDRATE__ser0_tr__MAX 0x3
#define R_ALT_SER_BAUDRATE__ser0_rec__MAX 0x3

#define R_ALT_SER_BAUDRATE__ser3_tr__MIN 0
#define R_ALT_SER_BAUDRATE__ser3_rec__MIN 0
#define R_ALT_SER_BAUDRATE__ser2_tr__MIN 0
#define R_ALT_SER_BAUDRATE__ser2_rec__MIN 0
#define R_ALT_SER_BAUDRATE__ser1_tr__MIN 0
#define R_ALT_SER_BAUDRATE__ser1_rec__MIN 0
#define R_ALT_SER_BAUDRATE__ser0_tr__MIN 0
#define R_ALT_SER_BAUDRATE__ser0_rec__MIN 0

#define R_ALT_SER_BAUDRATE__ser3_tr__BITNR 28
#define R_ALT_SER_BAUDRATE__ser3_rec__BITNR 24
#define R_ALT_SER_BAUDRATE__ser2_tr__BITNR 20
#define R_ALT_SER_BAUDRATE__ser2_rec__BITNR 16
#define R_ALT_SER_BAUDRATE__ser1_tr__BITNR 12
#define R_ALT_SER_BAUDRATE__ser1_rec__BITNR 8
#define R_ALT_SER_BAUDRATE__ser0_tr__BITNR 4
#define R_ALT_SER_BAUDRATE__ser0_rec__BITNR 0

#define R_ALT_SER_BAUDRATE__ser3_tr__ser3_tr__VAL REG_VAL_ENUM
#define R_ALT_SER_BAUDRATE__ser3_rec__ser3_rec__VAL REG_VAL_ENUM
#define R_ALT_SER_BAUDRATE__ser2_tr__ser2_tr__VAL REG_VAL_ENUM
#define R_ALT_SER_BAUDRATE__ser2_rec__ser2_rec__VAL REG_VAL_ENUM
#define R_ALT_SER_BAUDRATE__ser1_tr__ser1_tr__VAL REG_VAL_ENUM
#define R_ALT_SER_BAUDRATE__ser1_rec__ser1_rec__VAL REG_VAL_ENUM
#define R_ALT_SER_BAUDRATE__ser0_tr__ser0_tr__VAL REG_VAL_ENUM
#define R_ALT_SER_BAUDRATE__ser0_rec__ser0_rec__VAL REG_VAL_ENUM

#define R_ALT_SER_BAUDRATE__ser3_tr__ser3_tr__extern 2
#define R_ALT_SER_BAUDRATE__ser3_tr__ser3_tr__normal 0
#define R_ALT_SER_BAUDRATE__ser3_tr__ser3_tr__prescale 1
#define R_ALT_SER_BAUDRATE__ser3_tr__ser3_tr__timer 3
#define R_ALT_SER_BAUDRATE__ser3_rec__ser3_rec__extern 2
#define R_ALT_SER_BAUDRATE__ser3_rec__ser3_rec__normal 0
#define R_ALT_SER_BAUDRATE__ser3_rec__ser3_rec__prescale 1
#define R_ALT_SER_BAUDRATE__ser3_rec__ser3_rec__timer 3
#define R_ALT_SER_BAUDRATE__ser2_tr__ser2_tr__extern 2
#define R_ALT_SER_BAUDRATE__ser2_tr__ser2_tr__normal 0
#define R_ALT_SER_BAUDRATE__ser2_tr__ser2_tr__prescale 1
#define R_ALT_SER_BAUDRATE__ser2_tr__ser2_tr__timer 3
#define R_ALT_SER_BAUDRATE__ser2_rec__ser2_rec__extern 2
#define R_ALT_SER_BAUDRATE__ser2_rec__ser2_rec__normal 0
#define R_ALT_SER_BAUDRATE__ser2_rec__ser2_rec__prescale 1
#define R_ALT_SER_BAUDRATE__ser2_rec__ser2_rec__timer 3
#define R_ALT_SER_BAUDRATE__ser1_tr__ser1_tr__extern 2
#define R_ALT_SER_BAUDRATE__ser1_tr__ser1_tr__normal 0
#define R_ALT_SER_BAUDRATE__ser1_tr__ser1_tr__prescale 1
#define R_ALT_SER_BAUDRATE__ser1_tr__ser1_tr__timer 3
#define R_ALT_SER_BAUDRATE__ser1_rec__ser1_rec__extern 2
#define R_ALT_SER_BAUDRATE__ser1_rec__ser1_rec__normal 0
#define R_ALT_SER_BAUDRATE__ser1_rec__ser1_rec__prescale 1
#define R_ALT_SER_BAUDRATE__ser1_rec__ser1_rec__timer 3
#define R_ALT_SER_BAUDRATE__ser0_tr__ser0_tr__extern 2
#define R_ALT_SER_BAUDRATE__ser0_tr__ser0_tr__normal 0
#define R_ALT_SER_BAUDRATE__ser0_tr__ser0_tr__prescale 1
#define R_ALT_SER_BAUDRATE__ser0_tr__ser0_tr__timer 3
#define R_ALT_SER_BAUDRATE__ser0_rec__ser0_rec__extern 2
#define R_ALT_SER_BAUDRATE__ser0_rec__ser0_rec__normal 0
#define R_ALT_SER_BAUDRATE__ser0_rec__ser0_rec__prescale 1
#define R_ALT_SER_BAUDRATE__ser0_rec__ser0_rec__timer 3

#endif

/*
 *  R_ATA_CONFIG
 *  - type:  WO
 *  - addr:  0xb0000044
 *  - group: ATA interface registers
 */

#if USE_GROUP__ATA_interface_registers

#define R_ATA_CONFIG__ADDR      (REG_TYPECAST_UDWORD  0xb0000044)

#ifndef REG_NO_SHADOW
#define R_ATA_CONFIG__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_ATA_CONFIG + 0))
#define R_ATA_CONFIG__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_ATA_CONFIG + 0))
#else /* REG_NO_SHADOW */
#define R_ATA_CONFIG__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_ATA_CONFIG__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_ATA_CONFIG__STYPECAST REG_STYPECAST_UDWORD
#define R_ATA_CONFIG__SVAL      REG_SVAL_SHADOW
#define R_ATA_CONFIG__SVAL_I    REG_SVAL_I_SHADOW
#define R_ATA_CONFIG__TYPECAST  REG_TYPECAST_UDWORD
#define R_ATA_CONFIG__TYPE      (REG_UDWORD)
#define R_ATA_CONFIG__GET       REG_GET_WO
#define R_ATA_CONFIG__IGET      REG_IGET_WO
#define R_ATA_CONFIG__SET       REG_SET_WO
#define R_ATA_CONFIG__ISET      REG_ISET_WO
#define R_ATA_CONFIG__SET_VAL   REG_SET_VAL_WO
#define R_ATA_CONFIG__EQL       REG_EQL_WO
#define R_ATA_CONFIG__IEQL      REG_IEQL_WO
#define R_ATA_CONFIG__RD        REG_RD_WO
#define R_ATA_CONFIG__IRD       REG_IRD_WO
#define R_ATA_CONFIG__WR        REG_WR_WO
#define R_ATA_CONFIG__IWR       REG_IWR_WO

#define R_ATA_CONFIG__WRITE(addr,value) \
  (*(addr) = (value))

#define R_ATA_CONFIG__enable__enable__MASK 0x02000000U
#define R_ATA_CONFIG__dma_strobe__dma_strobe__MASK 0x01f00000U
#define R_ATA_CONFIG__dma_hold__dma_hold__MASK 0x000f8000U
#define R_ATA_CONFIG__pio_setup__pio_setup__MASK 0x00007c00U
#define R_ATA_CONFIG__pio_strobe__pio_strobe__MASK 0x000003e0U
#define R_ATA_CONFIG__pio_hold__pio_hold__MASK 0x0000001fU

#define R_ATA_CONFIG__enable__MAX 0x1
#define R_ATA_CONFIG__dma_strobe__MAX 31
#define R_ATA_CONFIG__dma_hold__MAX 31
#define R_ATA_CONFIG__pio_setup__MAX 31
#define R_ATA_CONFIG__pio_strobe__MAX 31
#define R_ATA_CONFIG__pio_hold__MAX 31

#define R_ATA_CONFIG__enable__MIN 0
#define R_ATA_CONFIG__dma_strobe__MIN 0
#define R_ATA_CONFIG__dma_hold__MIN 0
#define R_ATA_CONFIG__pio_setup__MIN 0
#define R_ATA_CONFIG__pio_strobe__MIN 0
#define R_ATA_CONFIG__pio_hold__MIN 0

#define R_ATA_CONFIG__enable__BITNR 25
#define R_ATA_CONFIG__dma_strobe__BITNR 20
#define R_ATA_CONFIG__dma_hold__BITNR 15
#define R_ATA_CONFIG__pio_setup__BITNR 10
#define R_ATA_CONFIG__pio_strobe__BITNR 5
#define R_ATA_CONFIG__pio_hold__BITNR 0

#define R_ATA_CONFIG__enable__enable__VAL REG_VAL_ENUM
#define R_ATA_CONFIG__dma_strobe__dma_strobe__VAL REG_VAL_VAL
#define R_ATA_CONFIG__dma_hold__dma_hold__VAL REG_VAL_VAL
#define R_ATA_CONFIG__pio_setup__pio_setup__VAL REG_VAL_VAL
#define R_ATA_CONFIG__pio_strobe__pio_strobe__VAL REG_VAL_VAL
#define R_ATA_CONFIG__pio_hold__pio_hold__VAL REG_VAL_VAL

#define R_ATA_CONFIG__enable__enable__off 0
#define R_ATA_CONFIG__enable__enable__on 1

#endif

/*
 *  R_ATA_CTRL_DATA
 *  - type:  WO
 *  - addr:  0xb0000040
 *  - group: ATA interface registers
 */

#if USE_GROUP__ATA_interface_registers

#define R_ATA_CTRL_DATA__ADDR      (REG_TYPECAST_UDWORD  0xb0000040)

#ifndef REG_NO_SHADOW
#define R_ATA_CTRL_DATA__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_ATA_CTRL_DATA + 0))
#define R_ATA_CTRL_DATA__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_ATA_CTRL_DATA + 0))
#else /* REG_NO_SHADOW */
#define R_ATA_CTRL_DATA__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_ATA_CTRL_DATA__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_ATA_CTRL_DATA__STYPECAST REG_STYPECAST_UDWORD
#define R_ATA_CTRL_DATA__SVAL      REG_SVAL_SHADOW
#define R_ATA_CTRL_DATA__SVAL_I    REG_SVAL_I_SHADOW
#define R_ATA_CTRL_DATA__TYPECAST  REG_TYPECAST_UDWORD
#define R_ATA_CTRL_DATA__TYPE      (REG_UDWORD)
#define R_ATA_CTRL_DATA__GET       REG_GET_WO
#define R_ATA_CTRL_DATA__IGET      REG_IGET_WO
#define R_ATA_CTRL_DATA__SET       REG_SET_WO
#define R_ATA_CTRL_DATA__ISET      REG_ISET_WO
#define R_ATA_CTRL_DATA__SET_VAL   REG_SET_VAL_WO
#define R_ATA_CTRL_DATA__EQL       REG_EQL_WO
#define R_ATA_CTRL_DATA__IEQL      REG_IEQL_WO
#define R_ATA_CTRL_DATA__RD        REG_RD_WO
#define R_ATA_CTRL_DATA__IRD       REG_IRD_WO
#define R_ATA_CTRL_DATA__WR        REG_WR_WO
#define R_ATA_CTRL_DATA__IWR       REG_IWR_WO

#define R_ATA_CTRL_DATA__WRITE(addr,value) \
  (*(addr) = (value))

#define R_ATA_CTRL_DATA__sel__sel__MASK 0xc0000000U
#define R_ATA_CTRL_DATA__cs1__cs1__MASK 0x20000000U
#define R_ATA_CTRL_DATA__cs0__cs0__MASK 0x10000000U
#define R_ATA_CTRL_DATA__addr__addr__MASK 0x0e000000U
#define R_ATA_CTRL_DATA__rw__rw__MASK 0x01000000U
#define R_ATA_CTRL_DATA__src_dst__src_dst__MASK 0x00800000U
#define R_ATA_CTRL_DATA__handsh__handsh__MASK 0x00400000U
#define R_ATA_CTRL_DATA__multi__multi__MASK 0x00200000U
#define R_ATA_CTRL_DATA__dma_size__dma_size__MASK 0x00100000U
#define R_ATA_CTRL_DATA__data__data__MASK 0x0000ffffU

#define R_ATA_CTRL_DATA__sel__MAX 3
#define R_ATA_CTRL_DATA__cs1__MAX 0x1
#define R_ATA_CTRL_DATA__cs0__MAX 0x1
#define R_ATA_CTRL_DATA__addr__MAX 7
#define R_ATA_CTRL_DATA__rw__MAX 0x1
#define R_ATA_CTRL_DATA__src_dst__MAX 0x1
#define R_ATA_CTRL_DATA__handsh__MAX 0x1
#define R_ATA_CTRL_DATA__multi__MAX 0x1
#define R_ATA_CTRL_DATA__dma_size__MAX 0x1
#define R_ATA_CTRL_DATA__data__MAX 0xffff

#define R_ATA_CTRL_DATA__sel__MIN 0
#define R_ATA_CTRL_DATA__cs1__MIN 0
#define R_ATA_CTRL_DATA__cs0__MIN 0
#define R_ATA_CTRL_DATA__addr__MIN 0
#define R_ATA_CTRL_DATA__rw__MIN 0
#define R_ATA_CTRL_DATA__src_dst__MIN 0
#define R_ATA_CTRL_DATA__handsh__MIN 0
#define R_ATA_CTRL_DATA__multi__MIN 0
#define R_ATA_CTRL_DATA__dma_size__MIN 0
#define R_ATA_CTRL_DATA__data__MIN 0

#define R_ATA_CTRL_DATA__sel__BITNR 30
#define R_ATA_CTRL_DATA__cs1__BITNR 29
#define R_ATA_CTRL_DATA__cs0__BITNR 28
#define R_ATA_CTRL_DATA__addr__BITNR 25
#define R_ATA_CTRL_DATA__rw__BITNR 24
#define R_ATA_CTRL_DATA__src_dst__BITNR 23
#define R_ATA_CTRL_DATA__handsh__BITNR 22
#define R_ATA_CTRL_DATA__multi__BITNR 21
#define R_ATA_CTRL_DATA__dma_size__BITNR 20
#define R_ATA_CTRL_DATA__data__BITNR 0

#define R_ATA_CTRL_DATA__sel__sel__VAL REG_VAL_VAL
#define R_ATA_CTRL_DATA__cs1__cs1__VAL REG_VAL_ENUM
#define R_ATA_CTRL_DATA__cs0__cs0__VAL REG_VAL_ENUM
#define R_ATA_CTRL_DATA__addr__addr__VAL REG_VAL_VAL
#define R_ATA_CTRL_DATA__rw__rw__VAL REG_VAL_ENUM
#define R_ATA_CTRL_DATA__src_dst__src_dst__VAL REG_VAL_ENUM
#define R_ATA_CTRL_DATA__handsh__handsh__VAL REG_VAL_ENUM
#define R_ATA_CTRL_DATA__multi__multi__VAL REG_VAL_ENUM
#define R_ATA_CTRL_DATA__dma_size__dma_size__VAL REG_VAL_ENUM
#define R_ATA_CTRL_DATA__data__data__VAL REG_VAL_VAL

#define R_ATA_CTRL_DATA__cs1__cs1__active 1
#define R_ATA_CTRL_DATA__cs1__cs1__inactive 0
#define R_ATA_CTRL_DATA__cs0__cs0__active 1
#define R_ATA_CTRL_DATA__cs0__cs0__inactive 0
#define R_ATA_CTRL_DATA__rw__rw__read 1
#define R_ATA_CTRL_DATA__rw__rw__write 0
#define R_ATA_CTRL_DATA__src_dst__src_dst__dma 1
#define R_ATA_CTRL_DATA__src_dst__src_dst__register 0
#define R_ATA_CTRL_DATA__handsh__handsh__dma 1
#define R_ATA_CTRL_DATA__handsh__handsh__pio 0
#define R_ATA_CTRL_DATA__multi__multi__off 0
#define R_ATA_CTRL_DATA__multi__multi__on 1
#define R_ATA_CTRL_DATA__dma_size__dma_size__byte 1
#define R_ATA_CTRL_DATA__dma_size__dma_size__word 0

#endif

/*
 *  R_ATA_STATUS_DATA
 *  - type:  RO
 *  - addr:  0xb0000040
 *  - group: ATA interface registers
 */

#if USE_GROUP__ATA_interface_registers

#define R_ATA_STATUS_DATA__ADDR      (REG_TYPECAST_UDWORD  0xb0000040)
#define R_ATA_STATUS_DATA__SVAL      REG_SVAL_SHADOW
#define R_ATA_STATUS_DATA__SVAL_I    REG_SVAL_I_SHADOW
#define R_ATA_STATUS_DATA__TYPECAST  REG_TYPECAST_UDWORD
#define R_ATA_STATUS_DATA__TYPE      (REG_UDWORD)
#define R_ATA_STATUS_DATA__GET       REG_GET_RO
#define R_ATA_STATUS_DATA__IGET      REG_IGET_RO
#define R_ATA_STATUS_DATA__SET       REG_SET_RO
#define R_ATA_STATUS_DATA__ISET      REG_ISET_RO
#define R_ATA_STATUS_DATA__SET_VAL   REG_SET_VAL_RO
#define R_ATA_STATUS_DATA__EQL       REG_EQL_RO
#define R_ATA_STATUS_DATA__IEQL      REG_IEQL_RO
#define R_ATA_STATUS_DATA__RD        REG_RD_RO
#define R_ATA_STATUS_DATA__IRD       REG_IRD_RO
#define R_ATA_STATUS_DATA__WR        REG_WR_RO
#define R_ATA_STATUS_DATA__IWR       REG_IWR_RO

#define R_ATA_STATUS_DATA__READ(addr) \
  (*(addr))

#define R_ATA_STATUS_DATA__busy__busy__MASK 0x00040000U
#define R_ATA_STATUS_DATA__tr_rdy__tr_rdy__MASK 0x00020000U
#define R_ATA_STATUS_DATA__dav__dav__MASK 0x00010000U
#define R_ATA_STATUS_DATA__data__data__MASK 0x0000ffffU

#define R_ATA_STATUS_DATA__busy__MAX 0x1
#define R_ATA_STATUS_DATA__tr_rdy__MAX 0x1
#define R_ATA_STATUS_DATA__dav__MAX 0x1
#define R_ATA_STATUS_DATA__data__MAX 0xffff

#define R_ATA_STATUS_DATA__busy__MIN 0
#define R_ATA_STATUS_DATA__tr_rdy__MIN 0
#define R_ATA_STATUS_DATA__dav__MIN 0
#define R_ATA_STATUS_DATA__data__MIN 0

#define R_ATA_STATUS_DATA__busy__BITNR 18
#define R_ATA_STATUS_DATA__tr_rdy__BITNR 17
#define R_ATA_STATUS_DATA__dav__BITNR 16
#define R_ATA_STATUS_DATA__data__BITNR 0

#define R_ATA_STATUS_DATA__busy__busy__VAL REG_VAL_ENUM
#define R_ATA_STATUS_DATA__tr_rdy__tr_rdy__VAL REG_VAL_ENUM
#define R_ATA_STATUS_DATA__dav__dav__VAL REG_VAL_ENUM
#define R_ATA_STATUS_DATA__data__data__VAL REG_VAL_VAL

#define R_ATA_STATUS_DATA__busy__busy__no 0
#define R_ATA_STATUS_DATA__busy__busy__yes 1
#define R_ATA_STATUS_DATA__tr_rdy__tr_rdy__busy 0
#define R_ATA_STATUS_DATA__tr_rdy__tr_rdy__ready 1
#define R_ATA_STATUS_DATA__dav__dav__data 1
#define R_ATA_STATUS_DATA__dav__dav__nodata 0

#endif

/*
 *  R_ATA_TRANSFER_CNT
 *  - type:  RW
 *  - addr:  0xb0000048
 *  - group: ATA interface registers
 */

#if USE_GROUP__ATA_interface_registers

#define R_ATA_TRANSFER_CNT__ADDR      (REG_TYPECAST_UDWORD  0xb0000048)
#define R_ATA_TRANSFER_CNT__SVAL      REG_SVAL_SHADOW
#define R_ATA_TRANSFER_CNT__SVAL_I    REG_SVAL_I_SHADOW
#define R_ATA_TRANSFER_CNT__TYPECAST  REG_TYPECAST_UDWORD
#define R_ATA_TRANSFER_CNT__TYPE      (REG_UDWORD)
#define R_ATA_TRANSFER_CNT__GET       REG_GET_RW
#define R_ATA_TRANSFER_CNT__IGET      REG_IGET_RW
#define R_ATA_TRANSFER_CNT__SET       REG_SET_RW
#define R_ATA_TRANSFER_CNT__ISET      REG_ISET_RW
#define R_ATA_TRANSFER_CNT__SET_VAL   REG_SET_VAL_RW
#define R_ATA_TRANSFER_CNT__EQL       REG_EQL_RW
#define R_ATA_TRANSFER_CNT__IEQL      REG_IEQL_RW
#define R_ATA_TRANSFER_CNT__RD        REG_RD_RW
#define R_ATA_TRANSFER_CNT__IRD       REG_IRD_RW
#define R_ATA_TRANSFER_CNT__WR        REG_WR_RW
#define R_ATA_TRANSFER_CNT__IWR       REG_IWR_RW

#define R_ATA_TRANSFER_CNT__WRITE(addr,value) \
  (*(addr) = (value))
#define R_ATA_TRANSFER_CNT__READ(addr) \
  (*(addr))

#define R_ATA_TRANSFER_CNT__count__count__MASK 0x0001ffffU

#define R_ATA_TRANSFER_CNT__count__MAX 0x1ffff

#define R_ATA_TRANSFER_CNT__count__MIN 0

#define R_ATA_TRANSFER_CNT__count__BITNR 0

#define R_ATA_TRANSFER_CNT__count__count__VAL REG_VAL_VAL


#endif

/*
 *  R_BUS_CONFIG
 *  - type:  WO
 *  - addr:  0xb0000004
 *  - group: Bus interface configuration registers
 */

#if USE_GROUP__Bus_interface_configuration_registers

#define R_BUS_CONFIG__ADDR      (REG_TYPECAST_UDWORD  0xb0000004)

#ifndef REG_NO_SHADOW
#define R_BUS_CONFIG__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_BUS_CONFIG + 0))
#define R_BUS_CONFIG__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_BUS_CONFIG + 0))
#else /* REG_NO_SHADOW */
#define R_BUS_CONFIG__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_BUS_CONFIG__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_BUS_CONFIG__STYPECAST REG_STYPECAST_UDWORD
#define R_BUS_CONFIG__SVAL      REG_SVAL_SHADOW
#define R_BUS_CONFIG__SVAL_I    REG_SVAL_I_SHADOW
#define R_BUS_CONFIG__TYPECAST  REG_TYPECAST_UDWORD
#define R_BUS_CONFIG__TYPE      (REG_UDWORD)
#define R_BUS_CONFIG__GET       REG_GET_WO
#define R_BUS_CONFIG__IGET      REG_IGET_WO
#define R_BUS_CONFIG__SET       REG_SET_WO
#define R_BUS_CONFIG__ISET      REG_ISET_WO
#define R_BUS_CONFIG__SET_VAL   REG_SET_VAL_WO
#define R_BUS_CONFIG__EQL       REG_EQL_WO
#define R_BUS_CONFIG__IEQL      REG_IEQL_WO
#define R_BUS_CONFIG__RD        REG_RD_WO
#define R_BUS_CONFIG__IRD       REG_IRD_WO
#define R_BUS_CONFIG__WR        REG_WR_WO
#define R_BUS_CONFIG__IWR       REG_IWR_WO

#define R_BUS_CONFIG__WRITE(addr,value) \
  (*(addr) = (value))

#define R_BUS_CONFIG__sram_type__sram_type__MASK 0x00000200U
#define R_BUS_CONFIG__dma_burst__dma_burst__MASK 0x00000100U
#define R_BUS_CONFIG__pcs4_7_wr__pcs4_7_wr__MASK 0x00000080U
#define R_BUS_CONFIG__pcs0_3_wr__pcs0_3_wr__MASK 0x00000040U
#define R_BUS_CONFIG__sram_wr__sram_wr__MASK 0x00000020U
#define R_BUS_CONFIG__flash_wr__flash_wr__MASK 0x00000010U
#define R_BUS_CONFIG__pcs4_7_bw__pcs4_7_bw__MASK 0x00000008U
#define R_BUS_CONFIG__pcs0_3_bw__pcs0_3_bw__MASK 0x00000004U
#define R_BUS_CONFIG__sram_bw__sram_bw__MASK 0x00000002U
#define R_BUS_CONFIG__flash_bw__flash_bw__MASK 0x00000001U

#define R_BUS_CONFIG__sram_type__MAX 0x1
#define R_BUS_CONFIG__dma_burst__MAX 0x1
#define R_BUS_CONFIG__pcs4_7_wr__MAX 0x1
#define R_BUS_CONFIG__pcs0_3_wr__MAX 0x1
#define R_BUS_CONFIG__sram_wr__MAX 0x1
#define R_BUS_CONFIG__flash_wr__MAX 0x1
#define R_BUS_CONFIG__pcs4_7_bw__MAX 0x1
#define R_BUS_CONFIG__pcs0_3_bw__MAX 0x1
#define R_BUS_CONFIG__sram_bw__MAX 0x1
#define R_BUS_CONFIG__flash_bw__MAX 0x1

#define R_BUS_CONFIG__sram_type__MIN 0
#define R_BUS_CONFIG__dma_burst__MIN 0
#define R_BUS_CONFIG__pcs4_7_wr__MIN 0
#define R_BUS_CONFIG__pcs0_3_wr__MIN 0
#define R_BUS_CONFIG__sram_wr__MIN 0
#define R_BUS_CONFIG__flash_wr__MIN 0
#define R_BUS_CONFIG__pcs4_7_bw__MIN 0
#define R_BUS_CONFIG__pcs0_3_bw__MIN 0
#define R_BUS_CONFIG__sram_bw__MIN 0
#define R_BUS_CONFIG__flash_bw__MIN 0

#define R_BUS_CONFIG__sram_type__BITNR 9
#define R_BUS_CONFIG__dma_burst__BITNR 8
#define R_BUS_CONFIG__pcs4_7_wr__BITNR 7
#define R_BUS_CONFIG__pcs0_3_wr__BITNR 6
#define R_BUS_CONFIG__sram_wr__BITNR 5
#define R_BUS_CONFIG__flash_wr__BITNR 4
#define R_BUS_CONFIG__pcs4_7_bw__BITNR 3
#define R_BUS_CONFIG__pcs0_3_bw__BITNR 2
#define R_BUS_CONFIG__sram_bw__BITNR 1
#define R_BUS_CONFIG__flash_bw__BITNR 0

#define R_BUS_CONFIG__sram_type__sram_type__VAL REG_VAL_ENUM
#define R_BUS_CONFIG__dma_burst__dma_burst__VAL REG_VAL_ENUM
#define R_BUS_CONFIG__pcs4_7_wr__pcs4_7_wr__VAL REG_VAL_ENUM
#define R_BUS_CONFIG__pcs0_3_wr__pcs0_3_wr__VAL REG_VAL_ENUM
#define R_BUS_CONFIG__sram_wr__sram_wr__VAL REG_VAL_ENUM
#define R_BUS_CONFIG__flash_wr__flash_wr__VAL REG_VAL_ENUM
#define R_BUS_CONFIG__pcs4_7_bw__pcs4_7_bw__VAL REG_VAL_ENUM
#define R_BUS_CONFIG__pcs0_3_bw__pcs0_3_bw__VAL REG_VAL_ENUM
#define R_BUS_CONFIG__sram_bw__sram_bw__VAL REG_VAL_ENUM
#define R_BUS_CONFIG__flash_bw__flash_bw__VAL REG_VAL_ENUM

#define R_BUS_CONFIG__sram_type__sram_type__bwe 0
#define R_BUS_CONFIG__sram_type__sram_type__cwe 1
#define R_BUS_CONFIG__dma_burst__dma_burst__burst16 1
#define R_BUS_CONFIG__dma_burst__dma_burst__burst32 0
#define R_BUS_CONFIG__pcs4_7_wr__pcs4_7_wr__ext 1
#define R_BUS_CONFIG__pcs4_7_wr__pcs4_7_wr__norm 0
#define R_BUS_CONFIG__pcs0_3_wr__pcs0_3_wr__ext 1
#define R_BUS_CONFIG__pcs0_3_wr__pcs0_3_wr__norm 0
#define R_BUS_CONFIG__sram_wr__sram_wr__ext 1
#define R_BUS_CONFIG__sram_wr__sram_wr__norm 0
#define R_BUS_CONFIG__flash_wr__flash_wr__ext 1
#define R_BUS_CONFIG__flash_wr__flash_wr__norm 0
#define R_BUS_CONFIG__pcs4_7_bw__pcs4_7_bw__bw16 0
#define R_BUS_CONFIG__pcs4_7_bw__pcs4_7_bw__bw32 1
#define R_BUS_CONFIG__pcs0_3_bw__pcs0_3_bw__bw16 0
#define R_BUS_CONFIG__pcs0_3_bw__pcs0_3_bw__bw32 1
#define R_BUS_CONFIG__sram_bw__sram_bw__bw16 0
#define R_BUS_CONFIG__sram_bw__sram_bw__bw32 1
#define R_BUS_CONFIG__flash_bw__flash_bw__bw16 0
#define R_BUS_CONFIG__flash_bw__flash_bw__bw32 1

#endif

/*
 *  R_BUS_STATUS
 *  - type:  RO
 *  - addr:  0xb0000004
 *  - group: Bus interface configuration registers
 */

#if USE_GROUP__Bus_interface_configuration_registers

#define R_BUS_STATUS__ADDR      (REG_TYPECAST_UDWORD  0xb0000004)
#define R_BUS_STATUS__SVAL      REG_SVAL_SHADOW
#define R_BUS_STATUS__SVAL_I    REG_SVAL_I_SHADOW
#define R_BUS_STATUS__TYPECAST  REG_TYPECAST_UDWORD
#define R_BUS_STATUS__TYPE      (REG_UDWORD)
#define R_BUS_STATUS__GET       REG_GET_RO
#define R_BUS_STATUS__IGET      REG_IGET_RO
#define R_BUS_STATUS__SET       REG_SET_RO
#define R_BUS_STATUS__ISET      REG_ISET_RO
#define R_BUS_STATUS__SET_VAL   REG_SET_VAL_RO
#define R_BUS_STATUS__EQL       REG_EQL_RO
#define R_BUS_STATUS__IEQL      REG_IEQL_RO
#define R_BUS_STATUS__RD        REG_RD_RO
#define R_BUS_STATUS__IRD       REG_IRD_RO
#define R_BUS_STATUS__WR        REG_WR_RO
#define R_BUS_STATUS__IWR       REG_IWR_RO

#define R_BUS_STATUS__READ(addr) \
  (*(addr))

#define R_BUS_STATUS__pll_lock_tm__pll_lock_tm__MASK 0x00000020U
#define R_BUS_STATUS__both_faults__both_faults__MASK 0x00000010U
#define R_BUS_STATUS__bsen___bsen___MASK 0x00000008U
#define R_BUS_STATUS__boot__boot__MASK 0x00000006U
#define R_BUS_STATUS__flashw__flashw__MASK 0x00000001U

#define R_BUS_STATUS__pll_lock_tm__MAX 0x1
#define R_BUS_STATUS__both_faults__MAX 0x1
#define R_BUS_STATUS__bsen___MAX 0x1
#define R_BUS_STATUS__boot__MAX 0x3
#define R_BUS_STATUS__flashw__MAX 0x1

#define R_BUS_STATUS__pll_lock_tm__MIN 0
#define R_BUS_STATUS__both_faults__MIN 0
#define R_BUS_STATUS__bsen___MIN 0
#define R_BUS_STATUS__boot__MIN 0
#define R_BUS_STATUS__flashw__MIN 0

#define R_BUS_STATUS__pll_lock_tm__BITNR 5
#define R_BUS_STATUS__both_faults__BITNR 4
#define R_BUS_STATUS__bsen___BITNR 3
#define R_BUS_STATUS__boot__BITNR 1
#define R_BUS_STATUS__flashw__BITNR 0

#define R_BUS_STATUS__pll_lock_tm__pll_lock_tm__VAL REG_VAL_ENUM
#define R_BUS_STATUS__both_faults__both_faults__VAL REG_VAL_ENUM
#define R_BUS_STATUS__bsen___bsen___VAL REG_VAL_ENUM
#define R_BUS_STATUS__boot__boot__VAL REG_VAL_ENUM
#define R_BUS_STATUS__flashw__flashw__VAL REG_VAL_ENUM

#define R_BUS_STATUS__pll_lock_tm__pll_lock_tm__counting 1
#define R_BUS_STATUS__pll_lock_tm__pll_lock_tm__expired 0
#define R_BUS_STATUS__both_faults__both_faults__no 0
#define R_BUS_STATUS__both_faults__both_faults__yes 1
#define R_BUS_STATUS__bsen___bsen___disable 1
#define R_BUS_STATUS__bsen___bsen___enable 0
#define R_BUS_STATUS__boot__boot__network 2
#define R_BUS_STATUS__boot__boot__parallel 3
#define R_BUS_STATUS__boot__boot__serial 1
#define R_BUS_STATUS__boot__boot__uncached 0
#define R_BUS_STATUS__flashw__flashw__bw16 0
#define R_BUS_STATUS__flashw__flashw__bw32 1

#endif

/*
 *  R_CLOCK_PRESCALE
 *  - type:  WO
 *  - addr:  0xb00000f0
 *  - group: Timer registers
 */

#if USE_GROUP__Timer_registers

#define R_CLOCK_PRESCALE__ADDR      (REG_TYPECAST_UDWORD  0xb00000f0)

#ifndef REG_NO_SHADOW
#define R_CLOCK_PRESCALE__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_CLOCK_PRESCALE + 0))
#define R_CLOCK_PRESCALE__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_CLOCK_PRESCALE + 0))
#else /* REG_NO_SHADOW */
#define R_CLOCK_PRESCALE__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_CLOCK_PRESCALE__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_CLOCK_PRESCALE__STYPECAST REG_STYPECAST_UDWORD
#define R_CLOCK_PRESCALE__SVAL      REG_SVAL_SHADOW
#define R_CLOCK_PRESCALE__SVAL_I    REG_SVAL_I_SHADOW
#define R_CLOCK_PRESCALE__TYPECAST  REG_TYPECAST_UDWORD
#define R_CLOCK_PRESCALE__TYPE      (REG_UDWORD)
#define R_CLOCK_PRESCALE__GET       REG_GET_WO
#define R_CLOCK_PRESCALE__IGET      REG_IGET_WO
#define R_CLOCK_PRESCALE__SET       REG_SET_WO
#define R_CLOCK_PRESCALE__ISET      REG_ISET_WO
#define R_CLOCK_PRESCALE__SET_VAL   REG_SET_VAL_WO
#define R_CLOCK_PRESCALE__EQL       REG_EQL_WO
#define R_CLOCK_PRESCALE__IEQL      REG_IEQL_WO
#define R_CLOCK_PRESCALE__RD        REG_RD_WO
#define R_CLOCK_PRESCALE__IRD       REG_IRD_WO
#define R_CLOCK_PRESCALE__WR        REG_WR_WO
#define R_CLOCK_PRESCALE__IWR       REG_IWR_WO

#define R_CLOCK_PRESCALE__WRITE(addr,value) \
  (*(addr) = (value))

#define R_CLOCK_PRESCALE__ser_presc__ser_presc__MASK 0xffff0000U
#define R_CLOCK_PRESCALE__tim_presc__tim_presc__MASK 0x0000ffffU

#define R_CLOCK_PRESCALE__ser_presc__MAX 0xffff
#define R_CLOCK_PRESCALE__tim_presc__MAX 0xffff

#define R_CLOCK_PRESCALE__ser_presc__MIN 0
#define R_CLOCK_PRESCALE__tim_presc__MIN 0

#define R_CLOCK_PRESCALE__ser_presc__BITNR 16
#define R_CLOCK_PRESCALE__tim_presc__BITNR 0

#define R_CLOCK_PRESCALE__ser_presc__ser_presc__VAL REG_VAL_VAL
#define R_CLOCK_PRESCALE__tim_presc__tim_presc__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH0_BUF
 *  - type:  RW
 *  - addr:  0xb0000108
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH0_BUF__ADDR      (REG_TYPECAST_UDWORD  0xb0000108)
#define R_DMA_CH0_BUF__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH0_BUF__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH0_BUF__TYPECAST  REG_TYPECAST_UDWORD
#define R_DMA_CH0_BUF__TYPE      (REG_UDWORD)
#define R_DMA_CH0_BUF__GET       REG_GET_RW
#define R_DMA_CH0_BUF__IGET      REG_IGET_RW
#define R_DMA_CH0_BUF__SET       REG_SET_RW
#define R_DMA_CH0_BUF__ISET      REG_ISET_RW
#define R_DMA_CH0_BUF__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH0_BUF__EQL       REG_EQL_RW
#define R_DMA_CH0_BUF__IEQL      REG_IEQL_RW
#define R_DMA_CH0_BUF__RD        REG_RD_RW
#define R_DMA_CH0_BUF__IRD       REG_IRD_RW
#define R_DMA_CH0_BUF__WR        REG_WR_RW
#define R_DMA_CH0_BUF__IWR       REG_IWR_RW

#define R_DMA_CH0_BUF__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH0_BUF__READ(addr) \
  (*(addr))

/* From control-file '/n/asic/projects/etrax_ng/include//hwregs.ctrl' */
#define R_DMA_CH0_BUF__FIRST 0
#define R_DMA_CH0_BUF__LAST 9
#define R_DMA_CH0_BUF__OFFSET 16
/* end */

#define R_DMA_CH0_BUF__buf__buf__MASK 0xffffffffU

#define R_DMA_CH0_BUF__buf__MAX 0xffffffff

#define R_DMA_CH0_BUF__buf__MIN 0

#define R_DMA_CH0_BUF__buf__BITNR 0

#define R_DMA_CH0_BUF__buf__buf__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH0_CLR_INTR
 *  - type:  WO
 *  - addr:  0xb00001d1
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH0_CLR_INTR__ADDR      (REG_TYPECAST_BYTE  0xb00001d1)

#ifndef REG_NO_SHADOW
#define R_DMA_CH0_CLR_INTR__SADDR     (REG_STYPECAST_BYTE (reg_shadow__hwregs.R_DMA_CH0_CLR_INTR + 0))
#define R_DMA_CH0_CLR_INTR__IADDR     (REG_STYPECAST_BYTE (reg_initiated__hwregs.R_DMA_CH0_CLR_INTR + 0))
#else /* REG_NO_SHADOW */
#define R_DMA_CH0_CLR_INTR__SADDR     (REG_STYPECAST_BYTE (&reg_shadow__hwregs))
#define R_DMA_CH0_CLR_INTR__IADDR     (REG_STYPECAST_BYTE (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_DMA_CH0_CLR_INTR__STYPECAST REG_STYPECAST_BYTE
#define R_DMA_CH0_CLR_INTR__SVAL REG_SVAL_ZERO
#define R_DMA_CH0_CLR_INTR__SVAL_I REG_SVAL_I_ZERO
#define R_DMA_CH0_CLR_INTR__TYPECAST  REG_TYPECAST_BYTE
#define R_DMA_CH0_CLR_INTR__TYPE      (REG_BYTE)
#define R_DMA_CH0_CLR_INTR__GET       REG_GET_WO
#define R_DMA_CH0_CLR_INTR__IGET      REG_IGET_WO
#define R_DMA_CH0_CLR_INTR__SET       REG_SET_WO
#define R_DMA_CH0_CLR_INTR__ISET      REG_ISET_WO
#define R_DMA_CH0_CLR_INTR__SET_VAL   REG_SET_VAL_WO
#define R_DMA_CH0_CLR_INTR__EQL       REG_EQL_WO
#define R_DMA_CH0_CLR_INTR__IEQL      REG_IEQL_WO
#define R_DMA_CH0_CLR_INTR__RD        REG_RD_WO
#define R_DMA_CH0_CLR_INTR__IRD       REG_IRD_WO
#define R_DMA_CH0_CLR_INTR__WR        REG_WR_WO
#define R_DMA_CH0_CLR_INTR__IWR       REG_IWR_WO

#define R_DMA_CH0_CLR_INTR__WRITE(addr,value) \
  (*(addr) = (value))

/* From control-file '/n/asic/projects/etrax_ng/include//hwregs.ctrl' */
#define R_DMA_CH0_CLR_INTR__FIRST 0
#define R_DMA_CH0_CLR_INTR__IOFFSET 0
#define R_DMA_CH0_CLR_INTR__LAST 9
#define R_DMA_CH0_CLR_INTR__OFFSET 4
#define R_DMA_CH0_CLR_INTR__SOFFSET 0
/* end */

#define R_DMA_CH0_CLR_INTR__clr_eop__clr_eop__MASK 0x00000002U
#define R_DMA_CH0_CLR_INTR__clr_descr__clr_descr__MASK 0x00000001U

#define R_DMA_CH0_CLR_INTR__clr_eop__MAX 0x1
#define R_DMA_CH0_CLR_INTR__clr_descr__MAX 0x1

#define R_DMA_CH0_CLR_INTR__clr_eop__MIN 0
#define R_DMA_CH0_CLR_INTR__clr_descr__MIN 0

#define R_DMA_CH0_CLR_INTR__clr_eop__BITNR 1
#define R_DMA_CH0_CLR_INTR__clr_descr__BITNR 0

#define R_DMA_CH0_CLR_INTR__clr_eop__clr_eop__VAL REG_VAL_ENUM
#define R_DMA_CH0_CLR_INTR__clr_descr__clr_descr__VAL REG_VAL_ENUM

#define R_DMA_CH0_CLR_INTR__clr_eop__clr_eop__do 1
#define R_DMA_CH0_CLR_INTR__clr_eop__clr_eop__dont 0
#define R_DMA_CH0_CLR_INTR__clr_descr__clr_descr__do 1
#define R_DMA_CH0_CLR_INTR__clr_descr__clr_descr__dont 0

#endif

/*
 *  R_DMA_CH0_CMD
 *  - type:  RW
 *  - addr:  0xb00001d0
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH0_CMD__ADDR      (REG_TYPECAST_BYTE  0xb00001d0)
#define R_DMA_CH0_CMD__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH0_CMD__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH0_CMD__TYPECAST  REG_TYPECAST_BYTE
#define R_DMA_CH0_CMD__TYPE      (REG_BYTE)
#define R_DMA_CH0_CMD__GET       REG_GET_RW
#define R_DMA_CH0_CMD__IGET      REG_IGET_RW
#define R_DMA_CH0_CMD__SET       REG_SET_RW
#define R_DMA_CH0_CMD__ISET      REG_ISET_RW
#define R_DMA_CH0_CMD__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH0_CMD__EQL       REG_EQL_RW
#define R_DMA_CH0_CMD__IEQL      REG_IEQL_RW
#define R_DMA_CH0_CMD__RD        REG_RD_RW
#define R_DMA_CH0_CMD__IRD       REG_IRD_RW
#define R_DMA_CH0_CMD__WR        REG_WR_RW
#define R_DMA_CH0_CMD__IWR       REG_IWR_RW

#define R_DMA_CH0_CMD__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH0_CMD__READ(addr) \
  (*(addr))

/* From control-file '/n/asic/projects/etrax_ng/include//hwregs.ctrl' */
#define R_DMA_CH0_CMD__FIRST 0
#define R_DMA_CH0_CMD__LAST 9
#define R_DMA_CH0_CMD__OFFSET 4
/* end */

#define R_DMA_CH0_CMD__cmd__cmd__MASK 0x00000007U

#define R_DMA_CH0_CMD__cmd__MAX 0x7

#define R_DMA_CH0_CMD__cmd__MIN 0

#define R_DMA_CH0_CMD__cmd__BITNR 0

#define R_DMA_CH0_CMD__cmd__cmd__VAL REG_VAL_ENUM

#define R_DMA_CH0_CMD__cmd__cmd__continue 3
#define R_DMA_CH0_CMD__cmd__cmd__hold 0
#define R_DMA_CH0_CMD__cmd__cmd__reset 4
#define R_DMA_CH0_CMD__cmd__cmd__restart 3
#define R_DMA_CH0_CMD__cmd__cmd__start 1

#endif

/*
 *  R_DMA_CH0_DESCR
 *  - type:  RW
 *  - addr:  0xb000010c
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH0_DESCR__ADDR      (REG_TYPECAST_UDWORD  0xb000010c)
#define R_DMA_CH0_DESCR__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH0_DESCR__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH0_DESCR__TYPECAST  REG_TYPECAST_UDWORD
#define R_DMA_CH0_DESCR__TYPE      (REG_UDWORD)
#define R_DMA_CH0_DESCR__GET       REG_GET_RW
#define R_DMA_CH0_DESCR__IGET      REG_IGET_RW
#define R_DMA_CH0_DESCR__SET       REG_SET_RW
#define R_DMA_CH0_DESCR__ISET      REG_ISET_RW
#define R_DMA_CH0_DESCR__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH0_DESCR__EQL       REG_EQL_RW
#define R_DMA_CH0_DESCR__IEQL      REG_IEQL_RW
#define R_DMA_CH0_DESCR__RD        REG_RD_RW
#define R_DMA_CH0_DESCR__IRD       REG_IRD_RW
#define R_DMA_CH0_DESCR__WR        REG_WR_RW
#define R_DMA_CH0_DESCR__IWR       REG_IWR_RW

#define R_DMA_CH0_DESCR__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH0_DESCR__READ(addr) \
  (*(addr))

/* From control-file '/n/asic/projects/etrax_ng/include//hwregs.ctrl' */
#define R_DMA_CH0_DESCR__FIRST 0
#define R_DMA_CH0_DESCR__LAST 9
#define R_DMA_CH0_DESCR__OFFSET 16
/* end */

#define R_DMA_CH0_DESCR__descr__descr__MASK 0xffffffffU

#define R_DMA_CH0_DESCR__descr__MAX 0xffffffff

#define R_DMA_CH0_DESCR__descr__MIN 0

#define R_DMA_CH0_DESCR__descr__BITNR 0

#define R_DMA_CH0_DESCR__descr__descr__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH0_FIRST
 *  - type:  RW
 *  - addr:  0xb00001a0
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH0_FIRST__ADDR      (REG_TYPECAST_UDWORD  0xb00001a0)
#define R_DMA_CH0_FIRST__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH0_FIRST__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH0_FIRST__TYPECAST  REG_TYPECAST_UDWORD
#define R_DMA_CH0_FIRST__TYPE      (REG_UDWORD)
#define R_DMA_CH0_FIRST__GET       REG_GET_RW
#define R_DMA_CH0_FIRST__IGET      REG_IGET_RW
#define R_DMA_CH0_FIRST__SET       REG_SET_RW
#define R_DMA_CH0_FIRST__ISET      REG_ISET_RW
#define R_DMA_CH0_FIRST__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH0_FIRST__EQL       REG_EQL_RW
#define R_DMA_CH0_FIRST__IEQL      REG_IEQL_RW
#define R_DMA_CH0_FIRST__RD        REG_RD_RW
#define R_DMA_CH0_FIRST__IRD       REG_IRD_RW
#define R_DMA_CH0_FIRST__WR        REG_WR_RW
#define R_DMA_CH0_FIRST__IWR       REG_IWR_RW

#define R_DMA_CH0_FIRST__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH0_FIRST__READ(addr) \
  (*(addr))

/* From control-file '/n/asic/projects/etrax_ng/include//hwregs.ctrl' */
#define R_DMA_CH0_FIRST__FIRST 0
#define R_DMA_CH0_FIRST__LAST 9
#define R_DMA_CH0_FIRST__OFFSET 4
/* end */

#define R_DMA_CH0_FIRST__first__first__MASK 0xffffffffU

#define R_DMA_CH0_FIRST__first__MAX 0xffffffff

#define R_DMA_CH0_FIRST__first__MIN 0

#define R_DMA_CH0_FIRST__first__BITNR 0

#define R_DMA_CH0_FIRST__first__first__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH0_HWSW
 *  - type:  RW
 *  - addr:  0xb0000100
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH0_HWSW__ADDR      (REG_TYPECAST_UDWORD  0xb0000100)
#define R_DMA_CH0_HWSW__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH0_HWSW__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH0_HWSW__TYPECAST  REG_TYPECAST_UDWORD
#define R_DMA_CH0_HWSW__TYPE      (REG_UDWORD)
#define R_DMA_CH0_HWSW__GET       REG_GET_RW
#define R_DMA_CH0_HWSW__IGET      REG_IGET_RW
#define R_DMA_CH0_HWSW__SET       REG_SET_RW
#define R_DMA_CH0_HWSW__ISET      REG_ISET_RW
#define R_DMA_CH0_HWSW__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH0_HWSW__EQL       REG_EQL_RW
#define R_DMA_CH0_HWSW__IEQL      REG_IEQL_RW
#define R_DMA_CH0_HWSW__RD        REG_RD_RW
#define R_DMA_CH0_HWSW__IRD       REG_IRD_RW
#define R_DMA_CH0_HWSW__WR        REG_WR_RW
#define R_DMA_CH0_HWSW__IWR       REG_IWR_RW

#define R_DMA_CH0_HWSW__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH0_HWSW__READ(addr) \
  (*(addr))

/* From control-file '/n/asic/projects/etrax_ng/include//hwregs.ctrl' */
#define R_DMA_CH0_HWSW__FIRST 0
#define R_DMA_CH0_HWSW__LAST 9
#define R_DMA_CH0_HWSW__OFFSET 16
/* end */

#define R_DMA_CH0_HWSW__hw__hw__MASK 0xffff0000U
#define R_DMA_CH0_HWSW__sw__sw__MASK 0x0000ffffU

#define R_DMA_CH0_HWSW__hw__MAX 0xffff
#define R_DMA_CH0_HWSW__sw__MAX 0xffff

#define R_DMA_CH0_HWSW__hw__MIN 0
#define R_DMA_CH0_HWSW__sw__MIN 0

#define R_DMA_CH0_HWSW__hw__BITNR 16
#define R_DMA_CH0_HWSW__sw__BITNR 0

#define R_DMA_CH0_HWSW__hw__hw__VAL REG_VAL_VAL
#define R_DMA_CH0_HWSW__sw__sw__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH0_NEXT
 *  - type:  RW
 *  - addr:  0xb0000104
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH0_NEXT__ADDR      (REG_TYPECAST_UDWORD  0xb0000104)
#define R_DMA_CH0_NEXT__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH0_NEXT__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH0_NEXT__TYPECAST  REG_TYPECAST_UDWORD
#define R_DMA_CH0_NEXT__TYPE      (REG_UDWORD)
#define R_DMA_CH0_NEXT__GET       REG_GET_RW
#define R_DMA_CH0_NEXT__IGET      REG_IGET_RW
#define R_DMA_CH0_NEXT__SET       REG_SET_RW
#define R_DMA_CH0_NEXT__ISET      REG_ISET_RW
#define R_DMA_CH0_NEXT__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH0_NEXT__EQL       REG_EQL_RW
#define R_DMA_CH0_NEXT__IEQL      REG_IEQL_RW
#define R_DMA_CH0_NEXT__RD        REG_RD_RW
#define R_DMA_CH0_NEXT__IRD       REG_IRD_RW
#define R_DMA_CH0_NEXT__WR        REG_WR_RW
#define R_DMA_CH0_NEXT__IWR       REG_IWR_RW

#define R_DMA_CH0_NEXT__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH0_NEXT__READ(addr) \
  (*(addr))

/* From control-file '/n/asic/projects/etrax_ng/include//hwregs.ctrl' */
#define R_DMA_CH0_NEXT__FIRST 0
#define R_DMA_CH0_NEXT__LAST 9
#define R_DMA_CH0_NEXT__OFFSET 16
/* end */

#define R_DMA_CH0_NEXT__next__next__MASK 0xffffffffU

#define R_DMA_CH0_NEXT__next__MAX 0xffffffff

#define R_DMA_CH0_NEXT__next__MIN 0

#define R_DMA_CH0_NEXT__next__BITNR 0

#define R_DMA_CH0_NEXT__next__next__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH0_STATUS
 *  - type:  RO
 *  - addr:  0xb00001d2
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH0_STATUS__ADDR      (REG_TYPECAST_BYTE  0xb00001d2)
#define R_DMA_CH0_STATUS__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH0_STATUS__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH0_STATUS__TYPECAST  REG_TYPECAST_BYTE
#define R_DMA_CH0_STATUS__TYPE      (REG_BYTE)
#define R_DMA_CH0_STATUS__GET       REG_GET_RO
#define R_DMA_CH0_STATUS__IGET      REG_IGET_RO
#define R_DMA_CH0_STATUS__SET       REG_SET_RO
#define R_DMA_CH0_STATUS__ISET      REG_ISET_RO
#define R_DMA_CH0_STATUS__SET_VAL   REG_SET_VAL_RO
#define R_DMA_CH0_STATUS__EQL       REG_EQL_RO
#define R_DMA_CH0_STATUS__IEQL      REG_IEQL_RO
#define R_DMA_CH0_STATUS__RD        REG_RD_RO
#define R_DMA_CH0_STATUS__IRD       REG_IRD_RO
#define R_DMA_CH0_STATUS__WR        REG_WR_RO
#define R_DMA_CH0_STATUS__IWR       REG_IWR_RO

#define R_DMA_CH0_STATUS__READ(addr) \
  (*(addr))

/* From control-file '/n/asic/projects/etrax_ng/include//hwregs.ctrl' */
#define R_DMA_CH0_STATUS__FIRST 0
#define R_DMA_CH0_STATUS__LAST 9
#define R_DMA_CH0_STATUS__OFFSET 4
/* end */

#define R_DMA_CH0_STATUS__avail__avail__MASK 0x0000007fU

#define R_DMA_CH0_STATUS__avail__MAX 0x7f

#define R_DMA_CH0_STATUS__avail__MIN 0

#define R_DMA_CH0_STATUS__avail__BITNR 0

#define R_DMA_CH0_STATUS__avail__avail__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH1_BUF
 *  - type:  RW
 *  - addr:  0xb0000118
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH1_BUF__ADDR      (REG_TYPECAST_UDWORD  0xb0000118)
#define R_DMA_CH1_BUF__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH1_BUF__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH1_BUF__TYPECAST  REG_TYPECAST_UDWORD
#define R_DMA_CH1_BUF__TYPE      (REG_UDWORD)
#define R_DMA_CH1_BUF__GET       REG_GET_RW
#define R_DMA_CH1_BUF__IGET      REG_IGET_RW
#define R_DMA_CH1_BUF__SET       REG_SET_RW
#define R_DMA_CH1_BUF__ISET      REG_ISET_RW
#define R_DMA_CH1_BUF__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH1_BUF__EQL       REG_EQL_RW
#define R_DMA_CH1_BUF__IEQL      REG_IEQL_RW
#define R_DMA_CH1_BUF__RD        REG_RD_RW
#define R_DMA_CH1_BUF__IRD       REG_IRD_RW
#define R_DMA_CH1_BUF__WR        REG_WR_RW
#define R_DMA_CH1_BUF__IWR       REG_IWR_RW

#define R_DMA_CH1_BUF__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH1_BUF__READ(addr) \
  (*(addr))

#define R_DMA_CH1_BUF__buf__buf__MASK 0xffffffffU

#define R_DMA_CH1_BUF__buf__MAX 0xffffffff

#define R_DMA_CH1_BUF__buf__MIN 0

#define R_DMA_CH1_BUF__buf__BITNR 0

#define R_DMA_CH1_BUF__buf__buf__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH1_CLR_INTR
 *  - type:  WO
 *  - addr:  0xb00001d5
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH1_CLR_INTR__ADDR      (REG_TYPECAST_BYTE  0xb00001d5)

#ifndef REG_NO_SHADOW
#define R_DMA_CH1_CLR_INTR__SADDR     (REG_STYPECAST_BYTE (reg_shadow__hwregs.R_DMA_CH1_CLR_INTR + 0))
#define R_DMA_CH1_CLR_INTR__IADDR     (REG_STYPECAST_BYTE (reg_initiated__hwregs.R_DMA_CH1_CLR_INTR + 0))
#else /* REG_NO_SHADOW */
#define R_DMA_CH1_CLR_INTR__SADDR     (REG_STYPECAST_BYTE (&reg_shadow__hwregs))
#define R_DMA_CH1_CLR_INTR__IADDR     (REG_STYPECAST_BYTE (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_DMA_CH1_CLR_INTR__STYPECAST REG_STYPECAST_BYTE
#define R_DMA_CH1_CLR_INTR__SVAL REG_SVAL_ZERO
#define R_DMA_CH1_CLR_INTR__SVAL_I REG_SVAL_I_ZERO
#define R_DMA_CH1_CLR_INTR__TYPECAST  REG_TYPECAST_BYTE
#define R_DMA_CH1_CLR_INTR__TYPE      (REG_BYTE)
#define R_DMA_CH1_CLR_INTR__GET       REG_GET_WO
#define R_DMA_CH1_CLR_INTR__IGET      REG_IGET_WO
#define R_DMA_CH1_CLR_INTR__SET       REG_SET_WO
#define R_DMA_CH1_CLR_INTR__ISET      REG_ISET_WO
#define R_DMA_CH1_CLR_INTR__SET_VAL   REG_SET_VAL_WO
#define R_DMA_CH1_CLR_INTR__EQL       REG_EQL_WO
#define R_DMA_CH1_CLR_INTR__IEQL      REG_IEQL_WO
#define R_DMA_CH1_CLR_INTR__RD        REG_RD_WO
#define R_DMA_CH1_CLR_INTR__IRD       REG_IRD_WO
#define R_DMA_CH1_CLR_INTR__WR        REG_WR_WO
#define R_DMA_CH1_CLR_INTR__IWR       REG_IWR_WO

#define R_DMA_CH1_CLR_INTR__WRITE(addr,value) \
  (*(addr) = (value))

#define R_DMA_CH1_CLR_INTR__clr_eop__clr_eop__MASK 0x00000002U
#define R_DMA_CH1_CLR_INTR__clr_descr__clr_descr__MASK 0x00000001U

#define R_DMA_CH1_CLR_INTR__clr_eop__MAX 0x1
#define R_DMA_CH1_CLR_INTR__clr_descr__MAX 0x1

#define R_DMA_CH1_CLR_INTR__clr_eop__MIN 0
#define R_DMA_CH1_CLR_INTR__clr_descr__MIN 0

#define R_DMA_CH1_CLR_INTR__clr_eop__BITNR 1
#define R_DMA_CH1_CLR_INTR__clr_descr__BITNR 0

#define R_DMA_CH1_CLR_INTR__clr_eop__clr_eop__VAL REG_VAL_ENUM
#define R_DMA_CH1_CLR_INTR__clr_descr__clr_descr__VAL REG_VAL_ENUM

#define R_DMA_CH1_CLR_INTR__clr_eop__clr_eop__do 1
#define R_DMA_CH1_CLR_INTR__clr_eop__clr_eop__dont 0
#define R_DMA_CH1_CLR_INTR__clr_descr__clr_descr__do 1
#define R_DMA_CH1_CLR_INTR__clr_descr__clr_descr__dont 0

#endif

/*
 *  R_DMA_CH1_CMD
 *  - type:  RW
 *  - addr:  0xb00001d4
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH1_CMD__ADDR      (REG_TYPECAST_BYTE  0xb00001d4)
#define R_DMA_CH1_CMD__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH1_CMD__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH1_CMD__TYPECAST  REG_TYPECAST_BYTE
#define R_DMA_CH1_CMD__TYPE      (REG_BYTE)
#define R_DMA_CH1_CMD__GET       REG_GET_RW
#define R_DMA_CH1_CMD__IGET      REG_IGET_RW
#define R_DMA_CH1_CMD__SET       REG_SET_RW
#define R_DMA_CH1_CMD__ISET      REG_ISET_RW
#define R_DMA_CH1_CMD__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH1_CMD__EQL       REG_EQL_RW
#define R_DMA_CH1_CMD__IEQL      REG_IEQL_RW
#define R_DMA_CH1_CMD__RD        REG_RD_RW
#define R_DMA_CH1_CMD__IRD       REG_IRD_RW
#define R_DMA_CH1_CMD__WR        REG_WR_RW
#define R_DMA_CH1_CMD__IWR       REG_IWR_RW

#define R_DMA_CH1_CMD__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH1_CMD__READ(addr) \
  (*(addr))

#define R_DMA_CH1_CMD__cmd__cmd__MASK 0x00000007U

#define R_DMA_CH1_CMD__cmd__MAX 0x7

#define R_DMA_CH1_CMD__cmd__MIN 0

#define R_DMA_CH1_CMD__cmd__BITNR 0

#define R_DMA_CH1_CMD__cmd__cmd__VAL REG_VAL_ENUM

#define R_DMA_CH1_CMD__cmd__cmd__continue 3
#define R_DMA_CH1_CMD__cmd__cmd__hold 0
#define R_DMA_CH1_CMD__cmd__cmd__reset 4
#define R_DMA_CH1_CMD__cmd__cmd__restart 3
#define R_DMA_CH1_CMD__cmd__cmd__start 1

#endif

/*
 *  R_DMA_CH1_DESCR
 *  - type:  RW
 *  - addr:  0xb000011c
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH1_DESCR__ADDR      (REG_TYPECAST_UDWORD  0xb000011c)
#define R_DMA_CH1_DESCR__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH1_DESCR__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH1_DESCR__TYPECAST  REG_TYPECAST_UDWORD
#define R_DMA_CH1_DESCR__TYPE      (REG_UDWORD)
#define R_DMA_CH1_DESCR__GET       REG_GET_RW
#define R_DMA_CH1_DESCR__IGET      REG_IGET_RW
#define R_DMA_CH1_DESCR__SET       REG_SET_RW
#define R_DMA_CH1_DESCR__ISET      REG_ISET_RW
#define R_DMA_CH1_DESCR__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH1_DESCR__EQL       REG_EQL_RW
#define R_DMA_CH1_DESCR__IEQL      REG_IEQL_RW
#define R_DMA_CH1_DESCR__RD        REG_RD_RW
#define R_DMA_CH1_DESCR__IRD       REG_IRD_RW
#define R_DMA_CH1_DESCR__WR        REG_WR_RW
#define R_DMA_CH1_DESCR__IWR       REG_IWR_RW

#define R_DMA_CH1_DESCR__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH1_DESCR__READ(addr) \
  (*(addr))

#define R_DMA_CH1_DESCR__descr__descr__MASK 0xffffffffU

#define R_DMA_CH1_DESCR__descr__MAX 0xffffffff

#define R_DMA_CH1_DESCR__descr__MIN 0

#define R_DMA_CH1_DESCR__descr__BITNR 0

#define R_DMA_CH1_DESCR__descr__descr__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH1_FIRST
 *  - type:  RW
 *  - addr:  0xb00001a4
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH1_FIRST__ADDR      (REG_TYPECAST_UDWORD  0xb00001a4)
#define R_DMA_CH1_FIRST__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH1_FIRST__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH1_FIRST__TYPECAST  REG_TYPECAST_UDWORD
#define R_DMA_CH1_FIRST__TYPE      (REG_UDWORD)
#define R_DMA_CH1_FIRST__GET       REG_GET_RW
#define R_DMA_CH1_FIRST__IGET      REG_IGET_RW
#define R_DMA_CH1_FIRST__SET       REG_SET_RW
#define R_DMA_CH1_FIRST__ISET      REG_ISET_RW
#define R_DMA_CH1_FIRST__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH1_FIRST__EQL       REG_EQL_RW
#define R_DMA_CH1_FIRST__IEQL      REG_IEQL_RW
#define R_DMA_CH1_FIRST__RD        REG_RD_RW
#define R_DMA_CH1_FIRST__IRD       REG_IRD_RW
#define R_DMA_CH1_FIRST__WR        REG_WR_RW
#define R_DMA_CH1_FIRST__IWR       REG_IWR_RW

#define R_DMA_CH1_FIRST__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH1_FIRST__READ(addr) \
  (*(addr))

#define R_DMA_CH1_FIRST__first__first__MASK 0xffffffffU

#define R_DMA_CH1_FIRST__first__MAX 0xffffffff

#define R_DMA_CH1_FIRST__first__MIN 0

#define R_DMA_CH1_FIRST__first__BITNR 0

#define R_DMA_CH1_FIRST__first__first__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH1_HWSW
 *  - type:  RW
 *  - addr:  0xb0000110
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH1_HWSW__ADDR      (REG_TYPECAST_UDWORD  0xb0000110)
#define R_DMA_CH1_HWSW__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH1_HWSW__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH1_HWSW__TYPECAST  REG_TYPECAST_UDWORD
#define R_DMA_CH1_HWSW__TYPE      (REG_UDWORD)
#define R_DMA_CH1_HWSW__GET       REG_GET_RW
#define R_DMA_CH1_HWSW__IGET      REG_IGET_RW
#define R_DMA_CH1_HWSW__SET       REG_SET_RW
#define R_DMA_CH1_HWSW__ISET      REG_ISET_RW
#define R_DMA_CH1_HWSW__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH1_HWSW__EQL       REG_EQL_RW
#define R_DMA_CH1_HWSW__IEQL      REG_IEQL_RW
#define R_DMA_CH1_HWSW__RD        REG_RD_RW
#define R_DMA_CH1_HWSW__IRD       REG_IRD_RW
#define R_DMA_CH1_HWSW__WR        REG_WR_RW
#define R_DMA_CH1_HWSW__IWR       REG_IWR_RW

#define R_DMA_CH1_HWSW__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH1_HWSW__READ(addr) \
  (*(addr))

#define R_DMA_CH1_HWSW__hw__hw__MASK 0xffff0000U
#define R_DMA_CH1_HWSW__sw__sw__MASK 0x0000ffffU

#define R_DMA_CH1_HWSW__hw__MAX 0xffff
#define R_DMA_CH1_HWSW__sw__MAX 0xffff

#define R_DMA_CH1_HWSW__hw__MIN 0
#define R_DMA_CH1_HWSW__sw__MIN 0

#define R_DMA_CH1_HWSW__hw__BITNR 16
#define R_DMA_CH1_HWSW__sw__BITNR 0

#define R_DMA_CH1_HWSW__hw__hw__VAL REG_VAL_VAL
#define R_DMA_CH1_HWSW__sw__sw__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH1_NEXT
 *  - type:  RW
 *  - addr:  0xb0000114
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH1_NEXT__ADDR      (REG_TYPECAST_UDWORD  0xb0000114)
#define R_DMA_CH1_NEXT__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH1_NEXT__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH1_NEXT__TYPECAST  REG_TYPECAST_UDWORD
#define R_DMA_CH1_NEXT__TYPE      (REG_UDWORD)
#define R_DMA_CH1_NEXT__GET       REG_GET_RW
#define R_DMA_CH1_NEXT__IGET      REG_IGET_RW
#define R_DMA_CH1_NEXT__SET       REG_SET_RW
#define R_DMA_CH1_NEXT__ISET      REG_ISET_RW
#define R_DMA_CH1_NEXT__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH1_NEXT__EQL       REG_EQL_RW
#define R_DMA_CH1_NEXT__IEQL      REG_IEQL_RW
#define R_DMA_CH1_NEXT__RD        REG_RD_RW
#define R_DMA_CH1_NEXT__IRD       REG_IRD_RW
#define R_DMA_CH1_NEXT__WR        REG_WR_RW
#define R_DMA_CH1_NEXT__IWR       REG_IWR_RW

#define R_DMA_CH1_NEXT__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH1_NEXT__READ(addr) \
  (*(addr))

#define R_DMA_CH1_NEXT__next__next__MASK 0xffffffffU

#define R_DMA_CH1_NEXT__next__MAX 0xffffffff

#define R_DMA_CH1_NEXT__next__MIN 0

#define R_DMA_CH1_NEXT__next__BITNR 0

#define R_DMA_CH1_NEXT__next__next__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH1_STATUS
 *  - type:  RO
 *  - addr:  0xb00001d6
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH1_STATUS__ADDR      (REG_TYPECAST_BYTE  0xb00001d6)
#define R_DMA_CH1_STATUS__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH1_STATUS__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH1_STATUS__TYPECAST  REG_TYPECAST_BYTE
#define R_DMA_CH1_STATUS__TYPE      (REG_BYTE)
#define R_DMA_CH1_STATUS__GET       REG_GET_RO
#define R_DMA_CH1_STATUS__IGET      REG_IGET_RO
#define R_DMA_CH1_STATUS__SET       REG_SET_RO
#define R_DMA_CH1_STATUS__ISET      REG_ISET_RO
#define R_DMA_CH1_STATUS__SET_VAL   REG_SET_VAL_RO
#define R_DMA_CH1_STATUS__EQL       REG_EQL_RO
#define R_DMA_CH1_STATUS__IEQL      REG_IEQL_RO
#define R_DMA_CH1_STATUS__RD        REG_RD_RO
#define R_DMA_CH1_STATUS__IRD       REG_IRD_RO
#define R_DMA_CH1_STATUS__WR        REG_WR_RO
#define R_DMA_CH1_STATUS__IWR       REG_IWR_RO

#define R_DMA_CH1_STATUS__READ(addr) \
  (*(addr))

#define R_DMA_CH1_STATUS__avail__avail__MASK 0x0000007fU

#define R_DMA_CH1_STATUS__avail__MAX 0x7f

#define R_DMA_CH1_STATUS__avail__MIN 0

#define R_DMA_CH1_STATUS__avail__BITNR 0

#define R_DMA_CH1_STATUS__avail__avail__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH2_BUF
 *  - type:  RW
 *  - addr:  0xb0000128
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH2_BUF__ADDR      (REG_TYPECAST_UDWORD  0xb0000128)
#define R_DMA_CH2_BUF__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH2_BUF__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH2_BUF__TYPECAST  REG_TYPECAST_UDWORD
#define R_DMA_CH2_BUF__TYPE      (REG_UDWORD)
#define R_DMA_CH2_BUF__GET       REG_GET_RW
#define R_DMA_CH2_BUF__IGET      REG_IGET_RW
#define R_DMA_CH2_BUF__SET       REG_SET_RW
#define R_DMA_CH2_BUF__ISET      REG_ISET_RW
#define R_DMA_CH2_BUF__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH2_BUF__EQL       REG_EQL_RW
#define R_DMA_CH2_BUF__IEQL      REG_IEQL_RW
#define R_DMA_CH2_BUF__RD        REG_RD_RW
#define R_DMA_CH2_BUF__IRD       REG_IRD_RW
#define R_DMA_CH2_BUF__WR        REG_WR_RW
#define R_DMA_CH2_BUF__IWR       REG_IWR_RW

#define R_DMA_CH2_BUF__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH2_BUF__READ(addr) \
  (*(addr))

#define R_DMA_CH2_BUF__buf__buf__MASK 0xffffffffU

#define R_DMA_CH2_BUF__buf__MAX 0xffffffff

#define R_DMA_CH2_BUF__buf__MIN 0

#define R_DMA_CH2_BUF__buf__BITNR 0

#define R_DMA_CH2_BUF__buf__buf__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH2_CLR_INTR
 *  - type:  WO
 *  - addr:  0xb00001d9
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH2_CLR_INTR__ADDR      (REG_TYPECAST_BYTE  0xb00001d9)

#ifndef REG_NO_SHADOW
#define R_DMA_CH2_CLR_INTR__SADDR     (REG_STYPECAST_BYTE (reg_shadow__hwregs.R_DMA_CH2_CLR_INTR + 0))
#define R_DMA_CH2_CLR_INTR__IADDR     (REG_STYPECAST_BYTE (reg_initiated__hwregs.R_DMA_CH2_CLR_INTR + 0))
#else /* REG_NO_SHADOW */
#define R_DMA_CH2_CLR_INTR__SADDR     (REG_STYPECAST_BYTE (&reg_shadow__hwregs))
#define R_DMA_CH2_CLR_INTR__IADDR     (REG_STYPECAST_BYTE (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_DMA_CH2_CLR_INTR__STYPECAST REG_STYPECAST_BYTE
#define R_DMA_CH2_CLR_INTR__SVAL REG_SVAL_ZERO
#define R_DMA_CH2_CLR_INTR__SVAL_I REG_SVAL_I_ZERO
#define R_DMA_CH2_CLR_INTR__TYPECAST  REG_TYPECAST_BYTE
#define R_DMA_CH2_CLR_INTR__TYPE      (REG_BYTE)
#define R_DMA_CH2_CLR_INTR__GET       REG_GET_WO
#define R_DMA_CH2_CLR_INTR__IGET      REG_IGET_WO
#define R_DMA_CH2_CLR_INTR__SET       REG_SET_WO
#define R_DMA_CH2_CLR_INTR__ISET      REG_ISET_WO
#define R_DMA_CH2_CLR_INTR__SET_VAL   REG_SET_VAL_WO
#define R_DMA_CH2_CLR_INTR__EQL       REG_EQL_WO
#define R_DMA_CH2_CLR_INTR__IEQL      REG_IEQL_WO
#define R_DMA_CH2_CLR_INTR__RD        REG_RD_WO
#define R_DMA_CH2_CLR_INTR__IRD       REG_IRD_WO
#define R_DMA_CH2_CLR_INTR__WR        REG_WR_WO
#define R_DMA_CH2_CLR_INTR__IWR       REG_IWR_WO

#define R_DMA_CH2_CLR_INTR__WRITE(addr,value) \
  (*(addr) = (value))

#define R_DMA_CH2_CLR_INTR__clr_eop__clr_eop__MASK 0x00000002U
#define R_DMA_CH2_CLR_INTR__clr_descr__clr_descr__MASK 0x00000001U

#define R_DMA_CH2_CLR_INTR__clr_eop__MAX 0x1
#define R_DMA_CH2_CLR_INTR__clr_descr__MAX 0x1

#define R_DMA_CH2_CLR_INTR__clr_eop__MIN 0
#define R_DMA_CH2_CLR_INTR__clr_descr__MIN 0

#define R_DMA_CH2_CLR_INTR__clr_eop__BITNR 1
#define R_DMA_CH2_CLR_INTR__clr_descr__BITNR 0

#define R_DMA_CH2_CLR_INTR__clr_eop__clr_eop__VAL REG_VAL_ENUM
#define R_DMA_CH2_CLR_INTR__clr_descr__clr_descr__VAL REG_VAL_ENUM

#define R_DMA_CH2_CLR_INTR__clr_eop__clr_eop__do 1
#define R_DMA_CH2_CLR_INTR__clr_eop__clr_eop__dont 0
#define R_DMA_CH2_CLR_INTR__clr_descr__clr_descr__do 1
#define R_DMA_CH2_CLR_INTR__clr_descr__clr_descr__dont 0

#endif

/*
 *  R_DMA_CH2_CMD
 *  - type:  RW
 *  - addr:  0xb00001d8
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH2_CMD__ADDR      (REG_TYPECAST_BYTE  0xb00001d8)
#define R_DMA_CH2_CMD__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH2_CMD__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH2_CMD__TYPECAST  REG_TYPECAST_BYTE
#define R_DMA_CH2_CMD__TYPE      (REG_BYTE)
#define R_DMA_CH2_CMD__GET       REG_GET_RW
#define R_DMA_CH2_CMD__IGET      REG_IGET_RW
#define R_DMA_CH2_CMD__SET       REG_SET_RW
#define R_DMA_CH2_CMD__ISET      REG_ISET_RW
#define R_DMA_CH2_CMD__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH2_CMD__EQL       REG_EQL_RW
#define R_DMA_CH2_CMD__IEQL      REG_IEQL_RW
#define R_DMA_CH2_CMD__RD        REG_RD_RW
#define R_DMA_CH2_CMD__IRD       REG_IRD_RW
#define R_DMA_CH2_CMD__WR        REG_WR_RW
#define R_DMA_CH2_CMD__IWR       REG_IWR_RW

#define R_DMA_CH2_CMD__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH2_CMD__READ(addr) \
  (*(addr))

#define R_DMA_CH2_CMD__cmd__cmd__MASK 0x00000007U

#define R_DMA_CH2_CMD__cmd__MAX 0x7

#define R_DMA_CH2_CMD__cmd__MIN 0

#define R_DMA_CH2_CMD__cmd__BITNR 0

#define R_DMA_CH2_CMD__cmd__cmd__VAL REG_VAL_ENUM

#define R_DMA_CH2_CMD__cmd__cmd__continue 3
#define R_DMA_CH2_CMD__cmd__cmd__hold 0
#define R_DMA_CH2_CMD__cmd__cmd__reset 4
#define R_DMA_CH2_CMD__cmd__cmd__restart 3
#define R_DMA_CH2_CMD__cmd__cmd__start 1

#endif

/*
 *  R_DMA_CH2_DESCR
 *  - type:  RW
 *  - addr:  0xb000012c
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH2_DESCR__ADDR      (REG_TYPECAST_UDWORD  0xb000012c)
#define R_DMA_CH2_DESCR__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH2_DESCR__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH2_DESCR__TYPECAST  REG_TYPECAST_UDWORD
#define R_DMA_CH2_DESCR__TYPE      (REG_UDWORD)
#define R_DMA_CH2_DESCR__GET       REG_GET_RW
#define R_DMA_CH2_DESCR__IGET      REG_IGET_RW
#define R_DMA_CH2_DESCR__SET       REG_SET_RW
#define R_DMA_CH2_DESCR__ISET      REG_ISET_RW
#define R_DMA_CH2_DESCR__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH2_DESCR__EQL       REG_EQL_RW
#define R_DMA_CH2_DESCR__IEQL      REG_IEQL_RW
#define R_DMA_CH2_DESCR__RD        REG_RD_RW
#define R_DMA_CH2_DESCR__IRD       REG_IRD_RW
#define R_DMA_CH2_DESCR__WR        REG_WR_RW
#define R_DMA_CH2_DESCR__IWR       REG_IWR_RW

#define R_DMA_CH2_DESCR__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH2_DESCR__READ(addr) \
  (*(addr))

#define R_DMA_CH2_DESCR__descr__descr__MASK 0xffffffffU

#define R_DMA_CH2_DESCR__descr__MAX 0xffffffff

#define R_DMA_CH2_DESCR__descr__MIN 0

#define R_DMA_CH2_DESCR__descr__BITNR 0

#define R_DMA_CH2_DESCR__descr__descr__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH2_FIRST
 *  - type:  RW
 *  - addr:  0xb00001a8
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH2_FIRST__ADDR      (REG_TYPECAST_UDWORD  0xb00001a8)
#define R_DMA_CH2_FIRST__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH2_FIRST__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH2_FIRST__TYPECAST  REG_TYPECAST_UDWORD
#define R_DMA_CH2_FIRST__TYPE      (REG_UDWORD)
#define R_DMA_CH2_FIRST__GET       REG_GET_RW
#define R_DMA_CH2_FIRST__IGET      REG_IGET_RW
#define R_DMA_CH2_FIRST__SET       REG_SET_RW
#define R_DMA_CH2_FIRST__ISET      REG_ISET_RW
#define R_DMA_CH2_FIRST__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH2_FIRST__EQL       REG_EQL_RW
#define R_DMA_CH2_FIRST__IEQL      REG_IEQL_RW
#define R_DMA_CH2_FIRST__RD        REG_RD_RW
#define R_DMA_CH2_FIRST__IRD       REG_IRD_RW
#define R_DMA_CH2_FIRST__WR        REG_WR_RW
#define R_DMA_CH2_FIRST__IWR       REG_IWR_RW

#define R_DMA_CH2_FIRST__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH2_FIRST__READ(addr) \
  (*(addr))

#define R_DMA_CH2_FIRST__first__first__MASK 0xffffffffU

#define R_DMA_CH2_FIRST__first__MAX 0xffffffff

#define R_DMA_CH2_FIRST__first__MIN 0

#define R_DMA_CH2_FIRST__first__BITNR 0

#define R_DMA_CH2_FIRST__first__first__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH2_HWSW
 *  - type:  RW
 *  - addr:  0xb0000120
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH2_HWSW__ADDR      (REG_TYPECAST_UDWORD  0xb0000120)
#define R_DMA_CH2_HWSW__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH2_HWSW__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH2_HWSW__TYPECAST  REG_TYPECAST_UDWORD
#define R_DMA_CH2_HWSW__TYPE      (REG_UDWORD)
#define R_DMA_CH2_HWSW__GET       REG_GET_RW
#define R_DMA_CH2_HWSW__IGET      REG_IGET_RW
#define R_DMA_CH2_HWSW__SET       REG_SET_RW
#define R_DMA_CH2_HWSW__ISET      REG_ISET_RW
#define R_DMA_CH2_HWSW__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH2_HWSW__EQL       REG_EQL_RW
#define R_DMA_CH2_HWSW__IEQL      REG_IEQL_RW
#define R_DMA_CH2_HWSW__RD        REG_RD_RW
#define R_DMA_CH2_HWSW__IRD       REG_IRD_RW
#define R_DMA_CH2_HWSW__WR        REG_WR_RW
#define R_DMA_CH2_HWSW__IWR       REG_IWR_RW

#define R_DMA_CH2_HWSW__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH2_HWSW__READ(addr) \
  (*(addr))

#define R_DMA_CH2_HWSW__hw__hw__MASK 0xffff0000U
#define R_DMA_CH2_HWSW__sw__sw__MASK 0x0000ffffU

#define R_DMA_CH2_HWSW__hw__MAX 0xffff
#define R_DMA_CH2_HWSW__sw__MAX 0xffff

#define R_DMA_CH2_HWSW__hw__MIN 0
#define R_DMA_CH2_HWSW__sw__MIN 0

#define R_DMA_CH2_HWSW__hw__BITNR 16
#define R_DMA_CH2_HWSW__sw__BITNR 0

#define R_DMA_CH2_HWSW__hw__hw__VAL REG_VAL_VAL
#define R_DMA_CH2_HWSW__sw__sw__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH2_NEXT
 *  - type:  RW
 *  - addr:  0xb0000124
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH2_NEXT__ADDR      (REG_TYPECAST_UDWORD  0xb0000124)
#define R_DMA_CH2_NEXT__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH2_NEXT__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH2_NEXT__TYPECAST  REG_TYPECAST_UDWORD
#define R_DMA_CH2_NEXT__TYPE      (REG_UDWORD)
#define R_DMA_CH2_NEXT__GET       REG_GET_RW
#define R_DMA_CH2_NEXT__IGET      REG_IGET_RW
#define R_DMA_CH2_NEXT__SET       REG_SET_RW
#define R_DMA_CH2_NEXT__ISET      REG_ISET_RW
#define R_DMA_CH2_NEXT__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH2_NEXT__EQL       REG_EQL_RW
#define R_DMA_CH2_NEXT__IEQL      REG_IEQL_RW
#define R_DMA_CH2_NEXT__RD        REG_RD_RW
#define R_DMA_CH2_NEXT__IRD       REG_IRD_RW
#define R_DMA_CH2_NEXT__WR        REG_WR_RW
#define R_DMA_CH2_NEXT__IWR       REG_IWR_RW

#define R_DMA_CH2_NEXT__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH2_NEXT__READ(addr) \
  (*(addr))

#define R_DMA_CH2_NEXT__next__next__MASK 0xffffffffU

#define R_DMA_CH2_NEXT__next__MAX 0xffffffff

#define R_DMA_CH2_NEXT__next__MIN 0

#define R_DMA_CH2_NEXT__next__BITNR 0

#define R_DMA_CH2_NEXT__next__next__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH2_STATUS
 *  - type:  RO
 *  - addr:  0xb00001da
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH2_STATUS__ADDR      (REG_TYPECAST_BYTE  0xb00001da)
#define R_DMA_CH2_STATUS__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH2_STATUS__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH2_STATUS__TYPECAST  REG_TYPECAST_BYTE
#define R_DMA_CH2_STATUS__TYPE      (REG_BYTE)
#define R_DMA_CH2_STATUS__GET       REG_GET_RO
#define R_DMA_CH2_STATUS__IGET      REG_IGET_RO
#define R_DMA_CH2_STATUS__SET       REG_SET_RO
#define R_DMA_CH2_STATUS__ISET      REG_ISET_RO
#define R_DMA_CH2_STATUS__SET_VAL   REG_SET_VAL_RO
#define R_DMA_CH2_STATUS__EQL       REG_EQL_RO
#define R_DMA_CH2_STATUS__IEQL      REG_IEQL_RO
#define R_DMA_CH2_STATUS__RD        REG_RD_RO
#define R_DMA_CH2_STATUS__IRD       REG_IRD_RO
#define R_DMA_CH2_STATUS__WR        REG_WR_RO
#define R_DMA_CH2_STATUS__IWR       REG_IWR_RO

#define R_DMA_CH2_STATUS__READ(addr) \
  (*(addr))

#define R_DMA_CH2_STATUS__avail__avail__MASK 0x0000007fU

#define R_DMA_CH2_STATUS__avail__MAX 0x7f

#define R_DMA_CH2_STATUS__avail__MIN 0

#define R_DMA_CH2_STATUS__avail__BITNR 0

#define R_DMA_CH2_STATUS__avail__avail__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH3_BUF
 *  - type:  RW
 *  - addr:  0xb0000138
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH3_BUF__ADDR      (REG_TYPECAST_UDWORD  0xb0000138)
#define R_DMA_CH3_BUF__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH3_BUF__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH3_BUF__TYPECAST  REG_TYPECAST_UDWORD
#define R_DMA_CH3_BUF__TYPE      (REG_UDWORD)
#define R_DMA_CH3_BUF__GET       REG_GET_RW
#define R_DMA_CH3_BUF__IGET      REG_IGET_RW
#define R_DMA_CH3_BUF__SET       REG_SET_RW
#define R_DMA_CH3_BUF__ISET      REG_ISET_RW
#define R_DMA_CH3_BUF__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH3_BUF__EQL       REG_EQL_RW
#define R_DMA_CH3_BUF__IEQL      REG_IEQL_RW
#define R_DMA_CH3_BUF__RD        REG_RD_RW
#define R_DMA_CH3_BUF__IRD       REG_IRD_RW
#define R_DMA_CH3_BUF__WR        REG_WR_RW
#define R_DMA_CH3_BUF__IWR       REG_IWR_RW

#define R_DMA_CH3_BUF__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH3_BUF__READ(addr) \
  (*(addr))

#define R_DMA_CH3_BUF__buf__buf__MASK 0xffffffffU

#define R_DMA_CH3_BUF__buf__MAX 0xffffffff

#define R_DMA_CH3_BUF__buf__MIN 0

#define R_DMA_CH3_BUF__buf__BITNR 0

#define R_DMA_CH3_BUF__buf__buf__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH3_CLR_INTR
 *  - type:  WO
 *  - addr:  0xb00001dd
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH3_CLR_INTR__ADDR      (REG_TYPECAST_BYTE  0xb00001dd)

#ifndef REG_NO_SHADOW
#define R_DMA_CH3_CLR_INTR__SADDR     (REG_STYPECAST_BYTE (reg_shadow__hwregs.R_DMA_CH3_CLR_INTR + 0))
#define R_DMA_CH3_CLR_INTR__IADDR     (REG_STYPECAST_BYTE (reg_initiated__hwregs.R_DMA_CH3_CLR_INTR + 0))
#else /* REG_NO_SHADOW */
#define R_DMA_CH3_CLR_INTR__SADDR     (REG_STYPECAST_BYTE (&reg_shadow__hwregs))
#define R_DMA_CH3_CLR_INTR__IADDR     (REG_STYPECAST_BYTE (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_DMA_CH3_CLR_INTR__STYPECAST REG_STYPECAST_BYTE
#define R_DMA_CH3_CLR_INTR__SVAL REG_SVAL_ZERO
#define R_DMA_CH3_CLR_INTR__SVAL_I REG_SVAL_I_ZERO
#define R_DMA_CH3_CLR_INTR__TYPECAST  REG_TYPECAST_BYTE
#define R_DMA_CH3_CLR_INTR__TYPE      (REG_BYTE)
#define R_DMA_CH3_CLR_INTR__GET       REG_GET_WO
#define R_DMA_CH3_CLR_INTR__IGET      REG_IGET_WO
#define R_DMA_CH3_CLR_INTR__SET       REG_SET_WO
#define R_DMA_CH3_CLR_INTR__ISET      REG_ISET_WO
#define R_DMA_CH3_CLR_INTR__SET_VAL   REG_SET_VAL_WO
#define R_DMA_CH3_CLR_INTR__EQL       REG_EQL_WO
#define R_DMA_CH3_CLR_INTR__IEQL      REG_IEQL_WO
#define R_DMA_CH3_CLR_INTR__RD        REG_RD_WO
#define R_DMA_CH3_CLR_INTR__IRD       REG_IRD_WO
#define R_DMA_CH3_CLR_INTR__WR        REG_WR_WO
#define R_DMA_CH3_CLR_INTR__IWR       REG_IWR_WO

#define R_DMA_CH3_CLR_INTR__WRITE(addr,value) \
  (*(addr) = (value))

#define R_DMA_CH3_CLR_INTR__clr_eop__clr_eop__MASK 0x00000002U
#define R_DMA_CH3_CLR_INTR__clr_descr__clr_descr__MASK 0x00000001U

#define R_DMA_CH3_CLR_INTR__clr_eop__MAX 0x1
#define R_DMA_CH3_CLR_INTR__clr_descr__MAX 0x1

#define R_DMA_CH3_CLR_INTR__clr_eop__MIN 0
#define R_DMA_CH3_CLR_INTR__clr_descr__MIN 0

#define R_DMA_CH3_CLR_INTR__clr_eop__BITNR 1
#define R_DMA_CH3_CLR_INTR__clr_descr__BITNR 0

#define R_DMA_CH3_CLR_INTR__clr_eop__clr_eop__VAL REG_VAL_ENUM
#define R_DMA_CH3_CLR_INTR__clr_descr__clr_descr__VAL REG_VAL_ENUM

#define R_DMA_CH3_CLR_INTR__clr_eop__clr_eop__do 1
#define R_DMA_CH3_CLR_INTR__clr_eop__clr_eop__dont 0
#define R_DMA_CH3_CLR_INTR__clr_descr__clr_descr__do 1
#define R_DMA_CH3_CLR_INTR__clr_descr__clr_descr__dont 0

#endif

/*
 *  R_DMA_CH3_CMD
 *  - type:  RW
 *  - addr:  0xb00001dc
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH3_CMD__ADDR      (REG_TYPECAST_BYTE  0xb00001dc)
#define R_DMA_CH3_CMD__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH3_CMD__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH3_CMD__TYPECAST  REG_TYPECAST_BYTE
#define R_DMA_CH3_CMD__TYPE      (REG_BYTE)
#define R_DMA_CH3_CMD__GET       REG_GET_RW
#define R_DMA_CH3_CMD__IGET      REG_IGET_RW
#define R_DMA_CH3_CMD__SET       REG_SET_RW
#define R_DMA_CH3_CMD__ISET      REG_ISET_RW
#define R_DMA_CH3_CMD__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH3_CMD__EQL       REG_EQL_RW
#define R_DMA_CH3_CMD__IEQL      REG_IEQL_RW
#define R_DMA_CH3_CMD__RD        REG_RD_RW
#define R_DMA_CH3_CMD__IRD       REG_IRD_RW
#define R_DMA_CH3_CMD__WR        REG_WR_RW
#define R_DMA_CH3_CMD__IWR       REG_IWR_RW

#define R_DMA_CH3_CMD__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH3_CMD__READ(addr) \
  (*(addr))

#define R_DMA_CH3_CMD__cmd__cmd__MASK 0x00000007U

#define R_DMA_CH3_CMD__cmd__MAX 0x7

#define R_DMA_CH3_CMD__cmd__MIN 0

#define R_DMA_CH3_CMD__cmd__BITNR 0

#define R_DMA_CH3_CMD__cmd__cmd__VAL REG_VAL_ENUM

#define R_DMA_CH3_CMD__cmd__cmd__continue 3
#define R_DMA_CH3_CMD__cmd__cmd__hold 0
#define R_DMA_CH3_CMD__cmd__cmd__reset 4
#define R_DMA_CH3_CMD__cmd__cmd__restart 3
#define R_DMA_CH3_CMD__cmd__cmd__start 1

#endif

/*
 *  R_DMA_CH3_DESCR
 *  - type:  RW
 *  - addr:  0xb000013c
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH3_DESCR__ADDR      (REG_TYPECAST_UDWORD  0xb000013c)
#define R_DMA_CH3_DESCR__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH3_DESCR__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH3_DESCR__TYPECAST  REG_TYPECAST_UDWORD
#define R_DMA_CH3_DESCR__TYPE      (REG_UDWORD)
#define R_DMA_CH3_DESCR__GET       REG_GET_RW
#define R_DMA_CH3_DESCR__IGET      REG_IGET_RW
#define R_DMA_CH3_DESCR__SET       REG_SET_RW
#define R_DMA_CH3_DESCR__ISET      REG_ISET_RW
#define R_DMA_CH3_DESCR__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH3_DESCR__EQL       REG_EQL_RW
#define R_DMA_CH3_DESCR__IEQL      REG_IEQL_RW
#define R_DMA_CH3_DESCR__RD        REG_RD_RW
#define R_DMA_CH3_DESCR__IRD       REG_IRD_RW
#define R_DMA_CH3_DESCR__WR        REG_WR_RW
#define R_DMA_CH3_DESCR__IWR       REG_IWR_RW

#define R_DMA_CH3_DESCR__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH3_DESCR__READ(addr) \
  (*(addr))

#define R_DMA_CH3_DESCR__descr__descr__MASK 0xffffffffU

#define R_DMA_CH3_DESCR__descr__MAX 0xffffffff

#define R_DMA_CH3_DESCR__descr__MIN 0

#define R_DMA_CH3_DESCR__descr__BITNR 0

#define R_DMA_CH3_DESCR__descr__descr__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH3_FIRST
 *  - type:  RW
 *  - addr:  0xb00001ac
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH3_FIRST__ADDR      (REG_TYPECAST_UDWORD  0xb00001ac)
#define R_DMA_CH3_FIRST__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH3_FIRST__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH3_FIRST__TYPECAST  REG_TYPECAST_UDWORD
#define R_DMA_CH3_FIRST__TYPE      (REG_UDWORD)
#define R_DMA_CH3_FIRST__GET       REG_GET_RW
#define R_DMA_CH3_FIRST__IGET      REG_IGET_RW
#define R_DMA_CH3_FIRST__SET       REG_SET_RW
#define R_DMA_CH3_FIRST__ISET      REG_ISET_RW
#define R_DMA_CH3_FIRST__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH3_FIRST__EQL       REG_EQL_RW
#define R_DMA_CH3_FIRST__IEQL      REG_IEQL_RW
#define R_DMA_CH3_FIRST__RD        REG_RD_RW
#define R_DMA_CH3_FIRST__IRD       REG_IRD_RW
#define R_DMA_CH3_FIRST__WR        REG_WR_RW
#define R_DMA_CH3_FIRST__IWR       REG_IWR_RW

#define R_DMA_CH3_FIRST__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH3_FIRST__READ(addr) \
  (*(addr))

#define R_DMA_CH3_FIRST__first__first__MASK 0xffffffffU

#define R_DMA_CH3_FIRST__first__MAX 0xffffffff

#define R_DMA_CH3_FIRST__first__MIN 0

#define R_DMA_CH3_FIRST__first__BITNR 0

#define R_DMA_CH3_FIRST__first__first__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH3_HWSW
 *  - type:  RW
 *  - addr:  0xb0000130
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH3_HWSW__ADDR      (REG_TYPECAST_UDWORD  0xb0000130)
#define R_DMA_CH3_HWSW__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH3_HWSW__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH3_HWSW__TYPECAST  REG_TYPECAST_UDWORD
#define R_DMA_CH3_HWSW__TYPE      (REG_UDWORD)
#define R_DMA_CH3_HWSW__GET       REG_GET_RW
#define R_DMA_CH3_HWSW__IGET      REG_IGET_RW
#define R_DMA_CH3_HWSW__SET       REG_SET_RW
#define R_DMA_CH3_HWSW__ISET      REG_ISET_RW
#define R_DMA_CH3_HWSW__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH3_HWSW__EQL       REG_EQL_RW
#define R_DMA_CH3_HWSW__IEQL      REG_IEQL_RW
#define R_DMA_CH3_HWSW__RD        REG_RD_RW
#define R_DMA_CH3_HWSW__IRD       REG_IRD_RW
#define R_DMA_CH3_HWSW__WR        REG_WR_RW
#define R_DMA_CH3_HWSW__IWR       REG_IWR_RW

#define R_DMA_CH3_HWSW__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH3_HWSW__READ(addr) \
  (*(addr))

#define R_DMA_CH3_HWSW__hw__hw__MASK 0xffff0000U
#define R_DMA_CH3_HWSW__sw__sw__MASK 0x0000ffffU

#define R_DMA_CH3_HWSW__hw__MAX 0xffff
#define R_DMA_CH3_HWSW__sw__MAX 0xffff

#define R_DMA_CH3_HWSW__hw__MIN 0
#define R_DMA_CH3_HWSW__sw__MIN 0

#define R_DMA_CH3_HWSW__hw__BITNR 16
#define R_DMA_CH3_HWSW__sw__BITNR 0

#define R_DMA_CH3_HWSW__hw__hw__VAL REG_VAL_VAL
#define R_DMA_CH3_HWSW__sw__sw__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH3_NEXT
 *  - type:  RW
 *  - addr:  0xb0000134
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH3_NEXT__ADDR      (REG_TYPECAST_UDWORD  0xb0000134)
#define R_DMA_CH3_NEXT__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH3_NEXT__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH3_NEXT__TYPECAST  REG_TYPECAST_UDWORD
#define R_DMA_CH3_NEXT__TYPE      (REG_UDWORD)
#define R_DMA_CH3_NEXT__GET       REG_GET_RW
#define R_DMA_CH3_NEXT__IGET      REG_IGET_RW
#define R_DMA_CH3_NEXT__SET       REG_SET_RW
#define R_DMA_CH3_NEXT__ISET      REG_ISET_RW
#define R_DMA_CH3_NEXT__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH3_NEXT__EQL       REG_EQL_RW
#define R_DMA_CH3_NEXT__IEQL      REG_IEQL_RW
#define R_DMA_CH3_NEXT__RD        REG_RD_RW
#define R_DMA_CH3_NEXT__IRD       REG_IRD_RW
#define R_DMA_CH3_NEXT__WR        REG_WR_RW
#define R_DMA_CH3_NEXT__IWR       REG_IWR_RW

#define R_DMA_CH3_NEXT__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH3_NEXT__READ(addr) \
  (*(addr))

#define R_DMA_CH3_NEXT__next__next__MASK 0xffffffffU

#define R_DMA_CH3_NEXT__next__MAX 0xffffffff

#define R_DMA_CH3_NEXT__next__MIN 0

#define R_DMA_CH3_NEXT__next__BITNR 0

#define R_DMA_CH3_NEXT__next__next__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH3_STATUS
 *  - type:  RO
 *  - addr:  0xb00001de
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH3_STATUS__ADDR      (REG_TYPECAST_BYTE  0xb00001de)
#define R_DMA_CH3_STATUS__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH3_STATUS__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH3_STATUS__TYPECAST  REG_TYPECAST_BYTE
#define R_DMA_CH3_STATUS__TYPE      (REG_BYTE)
#define R_DMA_CH3_STATUS__GET       REG_GET_RO
#define R_DMA_CH3_STATUS__IGET      REG_IGET_RO
#define R_DMA_CH3_STATUS__SET       REG_SET_RO
#define R_DMA_CH3_STATUS__ISET      REG_ISET_RO
#define R_DMA_CH3_STATUS__SET_VAL   REG_SET_VAL_RO
#define R_DMA_CH3_STATUS__EQL       REG_EQL_RO
#define R_DMA_CH3_STATUS__IEQL      REG_IEQL_RO
#define R_DMA_CH3_STATUS__RD        REG_RD_RO
#define R_DMA_CH3_STATUS__IRD       REG_IRD_RO
#define R_DMA_CH3_STATUS__WR        REG_WR_RO
#define R_DMA_CH3_STATUS__IWR       REG_IWR_RO

#define R_DMA_CH3_STATUS__READ(addr) \
  (*(addr))

#define R_DMA_CH3_STATUS__avail__avail__MASK 0x0000007fU

#define R_DMA_CH3_STATUS__avail__MAX 0x7f

#define R_DMA_CH3_STATUS__avail__MIN 0

#define R_DMA_CH3_STATUS__avail__BITNR 0

#define R_DMA_CH3_STATUS__avail__avail__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH4_BUF
 *  - type:  RW
 *  - addr:  0xb0000148
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH4_BUF__ADDR      (REG_TYPECAST_UDWORD  0xb0000148)
#define R_DMA_CH4_BUF__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH4_BUF__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH4_BUF__TYPECAST  REG_TYPECAST_UDWORD
#define R_DMA_CH4_BUF__TYPE      (REG_UDWORD)
#define R_DMA_CH4_BUF__GET       REG_GET_RW
#define R_DMA_CH4_BUF__IGET      REG_IGET_RW
#define R_DMA_CH4_BUF__SET       REG_SET_RW
#define R_DMA_CH4_BUF__ISET      REG_ISET_RW
#define R_DMA_CH4_BUF__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH4_BUF__EQL       REG_EQL_RW
#define R_DMA_CH4_BUF__IEQL      REG_IEQL_RW
#define R_DMA_CH4_BUF__RD        REG_RD_RW
#define R_DMA_CH4_BUF__IRD       REG_IRD_RW
#define R_DMA_CH4_BUF__WR        REG_WR_RW
#define R_DMA_CH4_BUF__IWR       REG_IWR_RW

#define R_DMA_CH4_BUF__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH4_BUF__READ(addr) \
  (*(addr))

#define R_DMA_CH4_BUF__buf__buf__MASK 0xffffffffU

#define R_DMA_CH4_BUF__buf__MAX 0xffffffff

#define R_DMA_CH4_BUF__buf__MIN 0

#define R_DMA_CH4_BUF__buf__BITNR 0

#define R_DMA_CH4_BUF__buf__buf__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH4_CLR_INTR
 *  - type:  WO
 *  - addr:  0xb00001e1
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH4_CLR_INTR__ADDR      (REG_TYPECAST_BYTE  0xb00001e1)

#ifndef REG_NO_SHADOW
#define R_DMA_CH4_CLR_INTR__SADDR     (REG_STYPECAST_BYTE (reg_shadow__hwregs.R_DMA_CH4_CLR_INTR + 0))
#define R_DMA_CH4_CLR_INTR__IADDR     (REG_STYPECAST_BYTE (reg_initiated__hwregs.R_DMA_CH4_CLR_INTR + 0))
#else /* REG_NO_SHADOW */
#define R_DMA_CH4_CLR_INTR__SADDR     (REG_STYPECAST_BYTE (&reg_shadow__hwregs))
#define R_DMA_CH4_CLR_INTR__IADDR     (REG_STYPECAST_BYTE (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_DMA_CH4_CLR_INTR__STYPECAST REG_STYPECAST_BYTE
#define R_DMA_CH4_CLR_INTR__SVAL REG_SVAL_ZERO
#define R_DMA_CH4_CLR_INTR__SVAL_I REG_SVAL_I_ZERO
#define R_DMA_CH4_CLR_INTR__TYPECAST  REG_TYPECAST_BYTE
#define R_DMA_CH4_CLR_INTR__TYPE      (REG_BYTE)
#define R_DMA_CH4_CLR_INTR__GET       REG_GET_WO
#define R_DMA_CH4_CLR_INTR__IGET      REG_IGET_WO
#define R_DMA_CH4_CLR_INTR__SET       REG_SET_WO
#define R_DMA_CH4_CLR_INTR__ISET      REG_ISET_WO
#define R_DMA_CH4_CLR_INTR__SET_VAL   REG_SET_VAL_WO
#define R_DMA_CH4_CLR_INTR__EQL       REG_EQL_WO
#define R_DMA_CH4_CLR_INTR__IEQL      REG_IEQL_WO
#define R_DMA_CH4_CLR_INTR__RD        REG_RD_WO
#define R_DMA_CH4_CLR_INTR__IRD       REG_IRD_WO
#define R_DMA_CH4_CLR_INTR__WR        REG_WR_WO
#define R_DMA_CH4_CLR_INTR__IWR       REG_IWR_WO

#define R_DMA_CH4_CLR_INTR__WRITE(addr,value) \
  (*(addr) = (value))

#define R_DMA_CH4_CLR_INTR__clr_eop__clr_eop__MASK 0x00000002U
#define R_DMA_CH4_CLR_INTR__clr_descr__clr_descr__MASK 0x00000001U

#define R_DMA_CH4_CLR_INTR__clr_eop__MAX 0x1
#define R_DMA_CH4_CLR_INTR__clr_descr__MAX 0x1

#define R_DMA_CH4_CLR_INTR__clr_eop__MIN 0
#define R_DMA_CH4_CLR_INTR__clr_descr__MIN 0

#define R_DMA_CH4_CLR_INTR__clr_eop__BITNR 1
#define R_DMA_CH4_CLR_INTR__clr_descr__BITNR 0

#define R_DMA_CH4_CLR_INTR__clr_eop__clr_eop__VAL REG_VAL_ENUM
#define R_DMA_CH4_CLR_INTR__clr_descr__clr_descr__VAL REG_VAL_ENUM

#define R_DMA_CH4_CLR_INTR__clr_eop__clr_eop__do 1
#define R_DMA_CH4_CLR_INTR__clr_eop__clr_eop__dont 0
#define R_DMA_CH4_CLR_INTR__clr_descr__clr_descr__do 1
#define R_DMA_CH4_CLR_INTR__clr_descr__clr_descr__dont 0

#endif

/*
 *  R_DMA_CH4_CMD
 *  - type:  RW
 *  - addr:  0xb00001e0
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH4_CMD__ADDR      (REG_TYPECAST_BYTE  0xb00001e0)
#define R_DMA_CH4_CMD__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH4_CMD__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH4_CMD__TYPECAST  REG_TYPECAST_BYTE
#define R_DMA_CH4_CMD__TYPE      (REG_BYTE)
#define R_DMA_CH4_CMD__GET       REG_GET_RW
#define R_DMA_CH4_CMD__IGET      REG_IGET_RW
#define R_DMA_CH4_CMD__SET       REG_SET_RW
#define R_DMA_CH4_CMD__ISET      REG_ISET_RW
#define R_DMA_CH4_CMD__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH4_CMD__EQL       REG_EQL_RW
#define R_DMA_CH4_CMD__IEQL      REG_IEQL_RW
#define R_DMA_CH4_CMD__RD        REG_RD_RW
#define R_DMA_CH4_CMD__IRD       REG_IRD_RW
#define R_DMA_CH4_CMD__WR        REG_WR_RW
#define R_DMA_CH4_CMD__IWR       REG_IWR_RW

#define R_DMA_CH4_CMD__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH4_CMD__READ(addr) \
  (*(addr))

#define R_DMA_CH4_CMD__cmd__cmd__MASK 0x00000007U

#define R_DMA_CH4_CMD__cmd__MAX 0x7

#define R_DMA_CH4_CMD__cmd__MIN 0

#define R_DMA_CH4_CMD__cmd__BITNR 0

#define R_DMA_CH4_CMD__cmd__cmd__VAL REG_VAL_ENUM

#define R_DMA_CH4_CMD__cmd__cmd__continue 3
#define R_DMA_CH4_CMD__cmd__cmd__hold 0
#define R_DMA_CH4_CMD__cmd__cmd__reset 4
#define R_DMA_CH4_CMD__cmd__cmd__restart 3
#define R_DMA_CH4_CMD__cmd__cmd__start 1

#endif

/*
 *  R_DMA_CH4_DESCR
 *  - type:  RW
 *  - addr:  0xb000014c
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH4_DESCR__ADDR      (REG_TYPECAST_UDWORD  0xb000014c)
#define R_DMA_CH4_DESCR__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH4_DESCR__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH4_DESCR__TYPECAST  REG_TYPECAST_UDWORD
#define R_DMA_CH4_DESCR__TYPE      (REG_UDWORD)
#define R_DMA_CH4_DESCR__GET       REG_GET_RW
#define R_DMA_CH4_DESCR__IGET      REG_IGET_RW
#define R_DMA_CH4_DESCR__SET       REG_SET_RW
#define R_DMA_CH4_DESCR__ISET      REG_ISET_RW
#define R_DMA_CH4_DESCR__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH4_DESCR__EQL       REG_EQL_RW
#define R_DMA_CH4_DESCR__IEQL      REG_IEQL_RW
#define R_DMA_CH4_DESCR__RD        REG_RD_RW
#define R_DMA_CH4_DESCR__IRD       REG_IRD_RW
#define R_DMA_CH4_DESCR__WR        REG_WR_RW
#define R_DMA_CH4_DESCR__IWR       REG_IWR_RW

#define R_DMA_CH4_DESCR__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH4_DESCR__READ(addr) \
  (*(addr))

#define R_DMA_CH4_DESCR__descr__descr__MASK 0xffffffffU

#define R_DMA_CH4_DESCR__descr__MAX 0xffffffff

#define R_DMA_CH4_DESCR__descr__MIN 0

#define R_DMA_CH4_DESCR__descr__BITNR 0

#define R_DMA_CH4_DESCR__descr__descr__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH4_FIRST
 *  - type:  RW
 *  - addr:  0xb00001b0
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH4_FIRST__ADDR      (REG_TYPECAST_UDWORD  0xb00001b0)
#define R_DMA_CH4_FIRST__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH4_FIRST__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH4_FIRST__TYPECAST  REG_TYPECAST_UDWORD
#define R_DMA_CH4_FIRST__TYPE      (REG_UDWORD)
#define R_DMA_CH4_FIRST__GET       REG_GET_RW
#define R_DMA_CH4_FIRST__IGET      REG_IGET_RW
#define R_DMA_CH4_FIRST__SET       REG_SET_RW
#define R_DMA_CH4_FIRST__ISET      REG_ISET_RW
#define R_DMA_CH4_FIRST__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH4_FIRST__EQL       REG_EQL_RW
#define R_DMA_CH4_FIRST__IEQL      REG_IEQL_RW
#define R_DMA_CH4_FIRST__RD        REG_RD_RW
#define R_DMA_CH4_FIRST__IRD       REG_IRD_RW
#define R_DMA_CH4_FIRST__WR        REG_WR_RW
#define R_DMA_CH4_FIRST__IWR       REG_IWR_RW

#define R_DMA_CH4_FIRST__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH4_FIRST__READ(addr) \
  (*(addr))

#define R_DMA_CH4_FIRST__first__first__MASK 0xffffffffU

#define R_DMA_CH4_FIRST__first__MAX 0xffffffff

#define R_DMA_CH4_FIRST__first__MIN 0

#define R_DMA_CH4_FIRST__first__BITNR 0

#define R_DMA_CH4_FIRST__first__first__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH4_HWSW
 *  - type:  RW
 *  - addr:  0xb0000140
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH4_HWSW__ADDR      (REG_TYPECAST_UDWORD  0xb0000140)
#define R_DMA_CH4_HWSW__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH4_HWSW__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH4_HWSW__TYPECAST  REG_TYPECAST_UDWORD
#define R_DMA_CH4_HWSW__TYPE      (REG_UDWORD)
#define R_DMA_CH4_HWSW__GET       REG_GET_RW
#define R_DMA_CH4_HWSW__IGET      REG_IGET_RW
#define R_DMA_CH4_HWSW__SET       REG_SET_RW
#define R_DMA_CH4_HWSW__ISET      REG_ISET_RW
#define R_DMA_CH4_HWSW__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH4_HWSW__EQL       REG_EQL_RW
#define R_DMA_CH4_HWSW__IEQL      REG_IEQL_RW
#define R_DMA_CH4_HWSW__RD        REG_RD_RW
#define R_DMA_CH4_HWSW__IRD       REG_IRD_RW
#define R_DMA_CH4_HWSW__WR        REG_WR_RW
#define R_DMA_CH4_HWSW__IWR       REG_IWR_RW

#define R_DMA_CH4_HWSW__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH4_HWSW__READ(addr) \
  (*(addr))

#define R_DMA_CH4_HWSW__hw__hw__MASK 0xffff0000U
#define R_DMA_CH4_HWSW__sw__sw__MASK 0x0000ffffU

#define R_DMA_CH4_HWSW__hw__MAX 0xffff
#define R_DMA_CH4_HWSW__sw__MAX 0xffff

#define R_DMA_CH4_HWSW__hw__MIN 0
#define R_DMA_CH4_HWSW__sw__MIN 0

#define R_DMA_CH4_HWSW__hw__BITNR 16
#define R_DMA_CH4_HWSW__sw__BITNR 0

#define R_DMA_CH4_HWSW__hw__hw__VAL REG_VAL_VAL
#define R_DMA_CH4_HWSW__sw__sw__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH4_NEXT
 *  - type:  RW
 *  - addr:  0xb0000144
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH4_NEXT__ADDR      (REG_TYPECAST_UDWORD  0xb0000144)
#define R_DMA_CH4_NEXT__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH4_NEXT__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH4_NEXT__TYPECAST  REG_TYPECAST_UDWORD
#define R_DMA_CH4_NEXT__TYPE      (REG_UDWORD)
#define R_DMA_CH4_NEXT__GET       REG_GET_RW
#define R_DMA_CH4_NEXT__IGET      REG_IGET_RW
#define R_DMA_CH4_NEXT__SET       REG_SET_RW
#define R_DMA_CH4_NEXT__ISET      REG_ISET_RW
#define R_DMA_CH4_NEXT__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH4_NEXT__EQL       REG_EQL_RW
#define R_DMA_CH4_NEXT__IEQL      REG_IEQL_RW
#define R_DMA_CH4_NEXT__RD        REG_RD_RW
#define R_DMA_CH4_NEXT__IRD       REG_IRD_RW
#define R_DMA_CH4_NEXT__WR        REG_WR_RW
#define R_DMA_CH4_NEXT__IWR       REG_IWR_RW

#define R_DMA_CH4_NEXT__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH4_NEXT__READ(addr) \
  (*(addr))

#define R_DMA_CH4_NEXT__next__next__MASK 0xffffffffU

#define R_DMA_CH4_NEXT__next__MAX 0xffffffff

#define R_DMA_CH4_NEXT__next__MIN 0

#define R_DMA_CH4_NEXT__next__BITNR 0

#define R_DMA_CH4_NEXT__next__next__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH4_STATUS
 *  - type:  RO
 *  - addr:  0xb00001e2
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH4_STATUS__ADDR      (REG_TYPECAST_BYTE  0xb00001e2)
#define R_DMA_CH4_STATUS__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH4_STATUS__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH4_STATUS__TYPECAST  REG_TYPECAST_BYTE
#define R_DMA_CH4_STATUS__TYPE      (REG_BYTE)
#define R_DMA_CH4_STATUS__GET       REG_GET_RO
#define R_DMA_CH4_STATUS__IGET      REG_IGET_RO
#define R_DMA_CH4_STATUS__SET       REG_SET_RO
#define R_DMA_CH4_STATUS__ISET      REG_ISET_RO
#define R_DMA_CH4_STATUS__SET_VAL   REG_SET_VAL_RO
#define R_DMA_CH4_STATUS__EQL       REG_EQL_RO
#define R_DMA_CH4_STATUS__IEQL      REG_IEQL_RO
#define R_DMA_CH4_STATUS__RD        REG_RD_RO
#define R_DMA_CH4_STATUS__IRD       REG_IRD_RO
#define R_DMA_CH4_STATUS__WR        REG_WR_RO
#define R_DMA_CH4_STATUS__IWR       REG_IWR_RO

#define R_DMA_CH4_STATUS__READ(addr) \
  (*(addr))

#define R_DMA_CH4_STATUS__avail__avail__MASK 0x0000007fU

#define R_DMA_CH4_STATUS__avail__MAX 0x7f

#define R_DMA_CH4_STATUS__avail__MIN 0

#define R_DMA_CH4_STATUS__avail__BITNR 0

#define R_DMA_CH4_STATUS__avail__avail__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH5_BUF
 *  - type:  RW
 *  - addr:  0xb0000158
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH5_BUF__ADDR      (REG_TYPECAST_UDWORD  0xb0000158)
#define R_DMA_CH5_BUF__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH5_BUF__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH5_BUF__TYPECAST  REG_TYPECAST_UDWORD
#define R_DMA_CH5_BUF__TYPE      (REG_UDWORD)
#define R_DMA_CH5_BUF__GET       REG_GET_RW
#define R_DMA_CH5_BUF__IGET      REG_IGET_RW
#define R_DMA_CH5_BUF__SET       REG_SET_RW
#define R_DMA_CH5_BUF__ISET      REG_ISET_RW
#define R_DMA_CH5_BUF__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH5_BUF__EQL       REG_EQL_RW
#define R_DMA_CH5_BUF__IEQL      REG_IEQL_RW
#define R_DMA_CH5_BUF__RD        REG_RD_RW
#define R_DMA_CH5_BUF__IRD       REG_IRD_RW
#define R_DMA_CH5_BUF__WR        REG_WR_RW
#define R_DMA_CH5_BUF__IWR       REG_IWR_RW

#define R_DMA_CH5_BUF__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH5_BUF__READ(addr) \
  (*(addr))

#define R_DMA_CH5_BUF__buf__buf__MASK 0xffffffffU

#define R_DMA_CH5_BUF__buf__MAX 0xffffffff

#define R_DMA_CH5_BUF__buf__MIN 0

#define R_DMA_CH5_BUF__buf__BITNR 0

#define R_DMA_CH5_BUF__buf__buf__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH5_CLR_INTR
 *  - type:  WO
 *  - addr:  0xb00001e5
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH5_CLR_INTR__ADDR      (REG_TYPECAST_BYTE  0xb00001e5)

#ifndef REG_NO_SHADOW
#define R_DMA_CH5_CLR_INTR__SADDR     (REG_STYPECAST_BYTE (reg_shadow__hwregs.R_DMA_CH5_CLR_INTR + 0))
#define R_DMA_CH5_CLR_INTR__IADDR     (REG_STYPECAST_BYTE (reg_initiated__hwregs.R_DMA_CH5_CLR_INTR + 0))
#else /* REG_NO_SHADOW */
#define R_DMA_CH5_CLR_INTR__SADDR     (REG_STYPECAST_BYTE (&reg_shadow__hwregs))
#define R_DMA_CH5_CLR_INTR__IADDR     (REG_STYPECAST_BYTE (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_DMA_CH5_CLR_INTR__STYPECAST REG_STYPECAST_BYTE
#define R_DMA_CH5_CLR_INTR__SVAL REG_SVAL_ZERO
#define R_DMA_CH5_CLR_INTR__SVAL_I REG_SVAL_I_ZERO
#define R_DMA_CH5_CLR_INTR__TYPECAST  REG_TYPECAST_BYTE
#define R_DMA_CH5_CLR_INTR__TYPE      (REG_BYTE)
#define R_DMA_CH5_CLR_INTR__GET       REG_GET_WO
#define R_DMA_CH5_CLR_INTR__IGET      REG_IGET_WO
#define R_DMA_CH5_CLR_INTR__SET       REG_SET_WO
#define R_DMA_CH5_CLR_INTR__ISET      REG_ISET_WO
#define R_DMA_CH5_CLR_INTR__SET_VAL   REG_SET_VAL_WO
#define R_DMA_CH5_CLR_INTR__EQL       REG_EQL_WO
#define R_DMA_CH5_CLR_INTR__IEQL      REG_IEQL_WO
#define R_DMA_CH5_CLR_INTR__RD        REG_RD_WO
#define R_DMA_CH5_CLR_INTR__IRD       REG_IRD_WO
#define R_DMA_CH5_CLR_INTR__WR        REG_WR_WO
#define R_DMA_CH5_CLR_INTR__IWR       REG_IWR_WO

#define R_DMA_CH5_CLR_INTR__WRITE(addr,value) \
  (*(addr) = (value))

#define R_DMA_CH5_CLR_INTR__clr_eop__clr_eop__MASK 0x00000002U
#define R_DMA_CH5_CLR_INTR__clr_descr__clr_descr__MASK 0x00000001U

#define R_DMA_CH5_CLR_INTR__clr_eop__MAX 0x1
#define R_DMA_CH5_CLR_INTR__clr_descr__MAX 0x1

#define R_DMA_CH5_CLR_INTR__clr_eop__MIN 0
#define R_DMA_CH5_CLR_INTR__clr_descr__MIN 0

#define R_DMA_CH5_CLR_INTR__clr_eop__BITNR 1
#define R_DMA_CH5_CLR_INTR__clr_descr__BITNR 0

#define R_DMA_CH5_CLR_INTR__clr_eop__clr_eop__VAL REG_VAL_ENUM
#define R_DMA_CH5_CLR_INTR__clr_descr__clr_descr__VAL REG_VAL_ENUM

#define R_DMA_CH5_CLR_INTR__clr_eop__clr_eop__do 1
#define R_DMA_CH5_CLR_INTR__clr_eop__clr_eop__dont 0
#define R_DMA_CH5_CLR_INTR__clr_descr__clr_descr__do 1
#define R_DMA_CH5_CLR_INTR__clr_descr__clr_descr__dont 0

#endif

/*
 *  R_DMA_CH5_CMD
 *  - type:  RW
 *  - addr:  0xb00001e4
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH5_CMD__ADDR      (REG_TYPECAST_BYTE  0xb00001e4)
#define R_DMA_CH5_CMD__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH5_CMD__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH5_CMD__TYPECAST  REG_TYPECAST_BYTE
#define R_DMA_CH5_CMD__TYPE      (REG_BYTE)
#define R_DMA_CH5_CMD__GET       REG_GET_RW
#define R_DMA_CH5_CMD__IGET      REG_IGET_RW
#define R_DMA_CH5_CMD__SET       REG_SET_RW
#define R_DMA_CH5_CMD__ISET      REG_ISET_RW
#define R_DMA_CH5_CMD__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH5_CMD__EQL       REG_EQL_RW
#define R_DMA_CH5_CMD__IEQL      REG_IEQL_RW
#define R_DMA_CH5_CMD__RD        REG_RD_RW
#define R_DMA_CH5_CMD__IRD       REG_IRD_RW
#define R_DMA_CH5_CMD__WR        REG_WR_RW
#define R_DMA_CH5_CMD__IWR       REG_IWR_RW

#define R_DMA_CH5_CMD__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH5_CMD__READ(addr) \
  (*(addr))

#define R_DMA_CH5_CMD__cmd__cmd__MASK 0x00000007U

#define R_DMA_CH5_CMD__cmd__MAX 0x7

#define R_DMA_CH5_CMD__cmd__MIN 0

#define R_DMA_CH5_CMD__cmd__BITNR 0

#define R_DMA_CH5_CMD__cmd__cmd__VAL REG_VAL_ENUM

#define R_DMA_CH5_CMD__cmd__cmd__continue 3
#define R_DMA_CH5_CMD__cmd__cmd__hold 0
#define R_DMA_CH5_CMD__cmd__cmd__reset 4
#define R_DMA_CH5_CMD__cmd__cmd__restart 3
#define R_DMA_CH5_CMD__cmd__cmd__start 1

#endif

/*
 *  R_DMA_CH5_DESCR
 *  - type:  RW
 *  - addr:  0xb000015c
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH5_DESCR__ADDR      (REG_TYPECAST_UDWORD  0xb000015c)
#define R_DMA_CH5_DESCR__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH5_DESCR__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH5_DESCR__TYPECAST  REG_TYPECAST_UDWORD
#define R_DMA_CH5_DESCR__TYPE      (REG_UDWORD)
#define R_DMA_CH5_DESCR__GET       REG_GET_RW
#define R_DMA_CH5_DESCR__IGET      REG_IGET_RW
#define R_DMA_CH5_DESCR__SET       REG_SET_RW
#define R_DMA_CH5_DESCR__ISET      REG_ISET_RW
#define R_DMA_CH5_DESCR__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH5_DESCR__EQL       REG_EQL_RW
#define R_DMA_CH5_DESCR__IEQL      REG_IEQL_RW
#define R_DMA_CH5_DESCR__RD        REG_RD_RW
#define R_DMA_CH5_DESCR__IRD       REG_IRD_RW
#define R_DMA_CH5_DESCR__WR        REG_WR_RW
#define R_DMA_CH5_DESCR__IWR       REG_IWR_RW

#define R_DMA_CH5_DESCR__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH5_DESCR__READ(addr) \
  (*(addr))

#define R_DMA_CH5_DESCR__descr__descr__MASK 0xffffffffU

#define R_DMA_CH5_DESCR__descr__MAX 0xffffffff

#define R_DMA_CH5_DESCR__descr__MIN 0

#define R_DMA_CH5_DESCR__descr__BITNR 0

#define R_DMA_CH5_DESCR__descr__descr__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH5_FIRST
 *  - type:  RW
 *  - addr:  0xb00001b4
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH5_FIRST__ADDR      (REG_TYPECAST_UDWORD  0xb00001b4)
#define R_DMA_CH5_FIRST__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH5_FIRST__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH5_FIRST__TYPECAST  REG_TYPECAST_UDWORD
#define R_DMA_CH5_FIRST__TYPE      (REG_UDWORD)
#define R_DMA_CH5_FIRST__GET       REG_GET_RW
#define R_DMA_CH5_FIRST__IGET      REG_IGET_RW
#define R_DMA_CH5_FIRST__SET       REG_SET_RW
#define R_DMA_CH5_FIRST__ISET      REG_ISET_RW
#define R_DMA_CH5_FIRST__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH5_FIRST__EQL       REG_EQL_RW
#define R_DMA_CH5_FIRST__IEQL      REG_IEQL_RW
#define R_DMA_CH5_FIRST__RD        REG_RD_RW
#define R_DMA_CH5_FIRST__IRD       REG_IRD_RW
#define R_DMA_CH5_FIRST__WR        REG_WR_RW
#define R_DMA_CH5_FIRST__IWR       REG_IWR_RW

#define R_DMA_CH5_FIRST__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH5_FIRST__READ(addr) \
  (*(addr))

#define R_DMA_CH5_FIRST__first__first__MASK 0xffffffffU

#define R_DMA_CH5_FIRST__first__MAX 0xffffffff

#define R_DMA_CH5_FIRST__first__MIN 0

#define R_DMA_CH5_FIRST__first__BITNR 0

#define R_DMA_CH5_FIRST__first__first__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH5_HWSW
 *  - type:  RW
 *  - addr:  0xb0000150
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH5_HWSW__ADDR      (REG_TYPECAST_UDWORD  0xb0000150)
#define R_DMA_CH5_HWSW__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH5_HWSW__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH5_HWSW__TYPECAST  REG_TYPECAST_UDWORD
#define R_DMA_CH5_HWSW__TYPE      (REG_UDWORD)
#define R_DMA_CH5_HWSW__GET       REG_GET_RW
#define R_DMA_CH5_HWSW__IGET      REG_IGET_RW
#define R_DMA_CH5_HWSW__SET       REG_SET_RW
#define R_DMA_CH5_HWSW__ISET      REG_ISET_RW
#define R_DMA_CH5_HWSW__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH5_HWSW__EQL       REG_EQL_RW
#define R_DMA_CH5_HWSW__IEQL      REG_IEQL_RW
#define R_DMA_CH5_HWSW__RD        REG_RD_RW
#define R_DMA_CH5_HWSW__IRD       REG_IRD_RW
#define R_DMA_CH5_HWSW__WR        REG_WR_RW
#define R_DMA_CH5_HWSW__IWR       REG_IWR_RW

#define R_DMA_CH5_HWSW__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH5_HWSW__READ(addr) \
  (*(addr))

#define R_DMA_CH5_HWSW__hw__hw__MASK 0xffff0000U
#define R_DMA_CH5_HWSW__sw__sw__MASK 0x0000ffffU

#define R_DMA_CH5_HWSW__hw__MAX 0xffff
#define R_DMA_CH5_HWSW__sw__MAX 0xffff

#define R_DMA_CH5_HWSW__hw__MIN 0
#define R_DMA_CH5_HWSW__sw__MIN 0

#define R_DMA_CH5_HWSW__hw__BITNR 16
#define R_DMA_CH5_HWSW__sw__BITNR 0

#define R_DMA_CH5_HWSW__hw__hw__VAL REG_VAL_VAL
#define R_DMA_CH5_HWSW__sw__sw__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH5_NEXT
 *  - type:  RW
 *  - addr:  0xb0000154
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH5_NEXT__ADDR      (REG_TYPECAST_UDWORD  0xb0000154)
#define R_DMA_CH5_NEXT__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH5_NEXT__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH5_NEXT__TYPECAST  REG_TYPECAST_UDWORD
#define R_DMA_CH5_NEXT__TYPE      (REG_UDWORD)
#define R_DMA_CH5_NEXT__GET       REG_GET_RW
#define R_DMA_CH5_NEXT__IGET      REG_IGET_RW
#define R_DMA_CH5_NEXT__SET       REG_SET_RW
#define R_DMA_CH5_NEXT__ISET      REG_ISET_RW
#define R_DMA_CH5_NEXT__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH5_NEXT__EQL       REG_EQL_RW
#define R_DMA_CH5_NEXT__IEQL      REG_IEQL_RW
#define R_DMA_CH5_NEXT__RD        REG_RD_RW
#define R_DMA_CH5_NEXT__IRD       REG_IRD_RW
#define R_DMA_CH5_NEXT__WR        REG_WR_RW
#define R_DMA_CH5_NEXT__IWR       REG_IWR_RW

#define R_DMA_CH5_NEXT__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH5_NEXT__READ(addr) \
  (*(addr))

#define R_DMA_CH5_NEXT__next__next__MASK 0xffffffffU

#define R_DMA_CH5_NEXT__next__MAX 0xffffffff

#define R_DMA_CH5_NEXT__next__MIN 0

#define R_DMA_CH5_NEXT__next__BITNR 0

#define R_DMA_CH5_NEXT__next__next__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH5_STATUS
 *  - type:  RO
 *  - addr:  0xb00001e6
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH5_STATUS__ADDR      (REG_TYPECAST_BYTE  0xb00001e6)
#define R_DMA_CH5_STATUS__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH5_STATUS__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH5_STATUS__TYPECAST  REG_TYPECAST_BYTE
#define R_DMA_CH5_STATUS__TYPE      (REG_BYTE)
#define R_DMA_CH5_STATUS__GET       REG_GET_RO
#define R_DMA_CH5_STATUS__IGET      REG_IGET_RO
#define R_DMA_CH5_STATUS__SET       REG_SET_RO
#define R_DMA_CH5_STATUS__ISET      REG_ISET_RO
#define R_DMA_CH5_STATUS__SET_VAL   REG_SET_VAL_RO
#define R_DMA_CH5_STATUS__EQL       REG_EQL_RO
#define R_DMA_CH5_STATUS__IEQL      REG_IEQL_RO
#define R_DMA_CH5_STATUS__RD        REG_RD_RO
#define R_DMA_CH5_STATUS__IRD       REG_IRD_RO
#define R_DMA_CH5_STATUS__WR        REG_WR_RO
#define R_DMA_CH5_STATUS__IWR       REG_IWR_RO

#define R_DMA_CH5_STATUS__READ(addr) \
  (*(addr))

#define R_DMA_CH5_STATUS__avail__avail__MASK 0x0000007fU

#define R_DMA_CH5_STATUS__avail__MAX 0x7f

#define R_DMA_CH5_STATUS__avail__MIN 0

#define R_DMA_CH5_STATUS__avail__BITNR 0

#define R_DMA_CH5_STATUS__avail__avail__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH6_BUF
 *  - type:  RW
 *  - addr:  0xb0000168
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH6_BUF__ADDR      (REG_TYPECAST_UDWORD  0xb0000168)
#define R_DMA_CH6_BUF__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH6_BUF__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH6_BUF__TYPECAST  REG_TYPECAST_UDWORD
#define R_DMA_CH6_BUF__TYPE      (REG_UDWORD)
#define R_DMA_CH6_BUF__GET       REG_GET_RW
#define R_DMA_CH6_BUF__IGET      REG_IGET_RW
#define R_DMA_CH6_BUF__SET       REG_SET_RW
#define R_DMA_CH6_BUF__ISET      REG_ISET_RW
#define R_DMA_CH6_BUF__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH6_BUF__EQL       REG_EQL_RW
#define R_DMA_CH6_BUF__IEQL      REG_IEQL_RW
#define R_DMA_CH6_BUF__RD        REG_RD_RW
#define R_DMA_CH6_BUF__IRD       REG_IRD_RW
#define R_DMA_CH6_BUF__WR        REG_WR_RW
#define R_DMA_CH6_BUF__IWR       REG_IWR_RW

#define R_DMA_CH6_BUF__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH6_BUF__READ(addr) \
  (*(addr))

#define R_DMA_CH6_BUF__buf__buf__MASK 0xffffffffU

#define R_DMA_CH6_BUF__buf__MAX 0xffffffff

#define R_DMA_CH6_BUF__buf__MIN 0

#define R_DMA_CH6_BUF__buf__BITNR 0

#define R_DMA_CH6_BUF__buf__buf__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH6_CLR_INTR
 *  - type:  WO
 *  - addr:  0xb00001e9
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH6_CLR_INTR__ADDR      (REG_TYPECAST_BYTE  0xb00001e9)

#ifndef REG_NO_SHADOW
#define R_DMA_CH6_CLR_INTR__SADDR     (REG_STYPECAST_BYTE (reg_shadow__hwregs.R_DMA_CH6_CLR_INTR + 0))
#define R_DMA_CH6_CLR_INTR__IADDR     (REG_STYPECAST_BYTE (reg_initiated__hwregs.R_DMA_CH6_CLR_INTR + 0))
#else /* REG_NO_SHADOW */
#define R_DMA_CH6_CLR_INTR__SADDR     (REG_STYPECAST_BYTE (&reg_shadow__hwregs))
#define R_DMA_CH6_CLR_INTR__IADDR     (REG_STYPECAST_BYTE (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_DMA_CH6_CLR_INTR__STYPECAST REG_STYPECAST_BYTE
#define R_DMA_CH6_CLR_INTR__SVAL REG_SVAL_ZERO
#define R_DMA_CH6_CLR_INTR__SVAL_I REG_SVAL_I_ZERO
#define R_DMA_CH6_CLR_INTR__TYPECAST  REG_TYPECAST_BYTE
#define R_DMA_CH6_CLR_INTR__TYPE      (REG_BYTE)
#define R_DMA_CH6_CLR_INTR__GET       REG_GET_WO
#define R_DMA_CH6_CLR_INTR__IGET      REG_IGET_WO
#define R_DMA_CH6_CLR_INTR__SET       REG_SET_WO
#define R_DMA_CH6_CLR_INTR__ISET      REG_ISET_WO
#define R_DMA_CH6_CLR_INTR__SET_VAL   REG_SET_VAL_WO
#define R_DMA_CH6_CLR_INTR__EQL       REG_EQL_WO
#define R_DMA_CH6_CLR_INTR__IEQL      REG_IEQL_WO
#define R_DMA_CH6_CLR_INTR__RD        REG_RD_WO
#define R_DMA_CH6_CLR_INTR__IRD       REG_IRD_WO
#define R_DMA_CH6_CLR_INTR__WR        REG_WR_WO
#define R_DMA_CH6_CLR_INTR__IWR       REG_IWR_WO

#define R_DMA_CH6_CLR_INTR__WRITE(addr,value) \
  (*(addr) = (value))

#define R_DMA_CH6_CLR_INTR__clr_eop__clr_eop__MASK 0x00000002U
#define R_DMA_CH6_CLR_INTR__clr_descr__clr_descr__MASK 0x00000001U

#define R_DMA_CH6_CLR_INTR__clr_eop__MAX 0x1
#define R_DMA_CH6_CLR_INTR__clr_descr__MAX 0x1

#define R_DMA_CH6_CLR_INTR__clr_eop__MIN 0
#define R_DMA_CH6_CLR_INTR__clr_descr__MIN 0

#define R_DMA_CH6_CLR_INTR__clr_eop__BITNR 1
#define R_DMA_CH6_CLR_INTR__clr_descr__BITNR 0

#define R_DMA_CH6_CLR_INTR__clr_eop__clr_eop__VAL REG_VAL_ENUM
#define R_DMA_CH6_CLR_INTR__clr_descr__clr_descr__VAL REG_VAL_ENUM

#define R_DMA_CH6_CLR_INTR__clr_eop__clr_eop__do 1
#define R_DMA_CH6_CLR_INTR__clr_eop__clr_eop__dont 0
#define R_DMA_CH6_CLR_INTR__clr_descr__clr_descr__do 1
#define R_DMA_CH6_CLR_INTR__clr_descr__clr_descr__dont 0

#endif

/*
 *  R_DMA_CH6_CMD
 *  - type:  RW
 *  - addr:  0xb00001e8
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH6_CMD__ADDR      (REG_TYPECAST_BYTE  0xb00001e8)
#define R_DMA_CH6_CMD__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH6_CMD__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH6_CMD__TYPECAST  REG_TYPECAST_BYTE
#define R_DMA_CH6_CMD__TYPE      (REG_BYTE)
#define R_DMA_CH6_CMD__GET       REG_GET_RW
#define R_DMA_CH6_CMD__IGET      REG_IGET_RW
#define R_DMA_CH6_CMD__SET       REG_SET_RW
#define R_DMA_CH6_CMD__ISET      REG_ISET_RW
#define R_DMA_CH6_CMD__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH6_CMD__EQL       REG_EQL_RW
#define R_DMA_CH6_CMD__IEQL      REG_IEQL_RW
#define R_DMA_CH6_CMD__RD        REG_RD_RW
#define R_DMA_CH6_CMD__IRD       REG_IRD_RW
#define R_DMA_CH6_CMD__WR        REG_WR_RW
#define R_DMA_CH6_CMD__IWR       REG_IWR_RW

#define R_DMA_CH6_CMD__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH6_CMD__READ(addr) \
  (*(addr))

#define R_DMA_CH6_CMD__cmd__cmd__MASK 0x00000007U

#define R_DMA_CH6_CMD__cmd__MAX 0x7

#define R_DMA_CH6_CMD__cmd__MIN 0

#define R_DMA_CH6_CMD__cmd__BITNR 0

#define R_DMA_CH6_CMD__cmd__cmd__VAL REG_VAL_ENUM

#define R_DMA_CH6_CMD__cmd__cmd__continue 3
#define R_DMA_CH6_CMD__cmd__cmd__hold 0
#define R_DMA_CH6_CMD__cmd__cmd__reset 4
#define R_DMA_CH6_CMD__cmd__cmd__restart 3
#define R_DMA_CH6_CMD__cmd__cmd__start 1

#endif

/*
 *  R_DMA_CH6_DESCR
 *  - type:  RW
 *  - addr:  0xb000016c
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH6_DESCR__ADDR      (REG_TYPECAST_UDWORD  0xb000016c)
#define R_DMA_CH6_DESCR__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH6_DESCR__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH6_DESCR__TYPECAST  REG_TYPECAST_UDWORD
#define R_DMA_CH6_DESCR__TYPE      (REG_UDWORD)
#define R_DMA_CH6_DESCR__GET       REG_GET_RW
#define R_DMA_CH6_DESCR__IGET      REG_IGET_RW
#define R_DMA_CH6_DESCR__SET       REG_SET_RW
#define R_DMA_CH6_DESCR__ISET      REG_ISET_RW
#define R_DMA_CH6_DESCR__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH6_DESCR__EQL       REG_EQL_RW
#define R_DMA_CH6_DESCR__IEQL      REG_IEQL_RW
#define R_DMA_CH6_DESCR__RD        REG_RD_RW
#define R_DMA_CH6_DESCR__IRD       REG_IRD_RW
#define R_DMA_CH6_DESCR__WR        REG_WR_RW
#define R_DMA_CH6_DESCR__IWR       REG_IWR_RW

#define R_DMA_CH6_DESCR__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH6_DESCR__READ(addr) \
  (*(addr))

#define R_DMA_CH6_DESCR__descr__descr__MASK 0xffffffffU

#define R_DMA_CH6_DESCR__descr__MAX 0xffffffff

#define R_DMA_CH6_DESCR__descr__MIN 0

#define R_DMA_CH6_DESCR__descr__BITNR 0

#define R_DMA_CH6_DESCR__descr__descr__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH6_FIRST
 *  - type:  RW
 *  - addr:  0xb00001b8
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH6_FIRST__ADDR      (REG_TYPECAST_UDWORD  0xb00001b8)
#define R_DMA_CH6_FIRST__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH6_FIRST__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH6_FIRST__TYPECAST  REG_TYPECAST_UDWORD
#define R_DMA_CH6_FIRST__TYPE      (REG_UDWORD)
#define R_DMA_CH6_FIRST__GET       REG_GET_RW
#define R_DMA_CH6_FIRST__IGET      REG_IGET_RW
#define R_DMA_CH6_FIRST__SET       REG_SET_RW
#define R_DMA_CH6_FIRST__ISET      REG_ISET_RW
#define R_DMA_CH6_FIRST__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH6_FIRST__EQL       REG_EQL_RW
#define R_DMA_CH6_FIRST__IEQL      REG_IEQL_RW
#define R_DMA_CH6_FIRST__RD        REG_RD_RW
#define R_DMA_CH6_FIRST__IRD       REG_IRD_RW
#define R_DMA_CH6_FIRST__WR        REG_WR_RW
#define R_DMA_CH6_FIRST__IWR       REG_IWR_RW

#define R_DMA_CH6_FIRST__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH6_FIRST__READ(addr) \
  (*(addr))

#define R_DMA_CH6_FIRST__first__first__MASK 0xffffffffU

#define R_DMA_CH6_FIRST__first__MAX 0xffffffff

#define R_DMA_CH6_FIRST__first__MIN 0

#define R_DMA_CH6_FIRST__first__BITNR 0

#define R_DMA_CH6_FIRST__first__first__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH6_HWSW
 *  - type:  RW
 *  - addr:  0xb0000160
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH6_HWSW__ADDR      (REG_TYPECAST_UDWORD  0xb0000160)
#define R_DMA_CH6_HWSW__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH6_HWSW__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH6_HWSW__TYPECAST  REG_TYPECAST_UDWORD
#define R_DMA_CH6_HWSW__TYPE      (REG_UDWORD)
#define R_DMA_CH6_HWSW__GET       REG_GET_RW
#define R_DMA_CH6_HWSW__IGET      REG_IGET_RW
#define R_DMA_CH6_HWSW__SET       REG_SET_RW
#define R_DMA_CH6_HWSW__ISET      REG_ISET_RW
#define R_DMA_CH6_HWSW__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH6_HWSW__EQL       REG_EQL_RW
#define R_DMA_CH6_HWSW__IEQL      REG_IEQL_RW
#define R_DMA_CH6_HWSW__RD        REG_RD_RW
#define R_DMA_CH6_HWSW__IRD       REG_IRD_RW
#define R_DMA_CH6_HWSW__WR        REG_WR_RW
#define R_DMA_CH6_HWSW__IWR       REG_IWR_RW

#define R_DMA_CH6_HWSW__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH6_HWSW__READ(addr) \
  (*(addr))

#define R_DMA_CH6_HWSW__hw__hw__MASK 0xffff0000U
#define R_DMA_CH6_HWSW__sw__sw__MASK 0x0000ffffU

#define R_DMA_CH6_HWSW__hw__MAX 0xffff
#define R_DMA_CH6_HWSW__sw__MAX 0xffff

#define R_DMA_CH6_HWSW__hw__MIN 0
#define R_DMA_CH6_HWSW__sw__MIN 0

#define R_DMA_CH6_HWSW__hw__BITNR 16
#define R_DMA_CH6_HWSW__sw__BITNR 0

#define R_DMA_CH6_HWSW__hw__hw__VAL REG_VAL_VAL
#define R_DMA_CH6_HWSW__sw__sw__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH6_NEXT
 *  - type:  RW
 *  - addr:  0xb0000164
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH6_NEXT__ADDR      (REG_TYPECAST_UDWORD  0xb0000164)
#define R_DMA_CH6_NEXT__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH6_NEXT__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH6_NEXT__TYPECAST  REG_TYPECAST_UDWORD
#define R_DMA_CH6_NEXT__TYPE      (REG_UDWORD)
#define R_DMA_CH6_NEXT__GET       REG_GET_RW
#define R_DMA_CH6_NEXT__IGET      REG_IGET_RW
#define R_DMA_CH6_NEXT__SET       REG_SET_RW
#define R_DMA_CH6_NEXT__ISET      REG_ISET_RW
#define R_DMA_CH6_NEXT__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH6_NEXT__EQL       REG_EQL_RW
#define R_DMA_CH6_NEXT__IEQL      REG_IEQL_RW
#define R_DMA_CH6_NEXT__RD        REG_RD_RW
#define R_DMA_CH6_NEXT__IRD       REG_IRD_RW
#define R_DMA_CH6_NEXT__WR        REG_WR_RW
#define R_DMA_CH6_NEXT__IWR       REG_IWR_RW

#define R_DMA_CH6_NEXT__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH6_NEXT__READ(addr) \
  (*(addr))

#define R_DMA_CH6_NEXT__next__next__MASK 0xffffffffU

#define R_DMA_CH6_NEXT__next__MAX 0xffffffff

#define R_DMA_CH6_NEXT__next__MIN 0

#define R_DMA_CH6_NEXT__next__BITNR 0

#define R_DMA_CH6_NEXT__next__next__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH6_STATUS
 *  - type:  RO
 *  - addr:  0xb00001ea
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH6_STATUS__ADDR      (REG_TYPECAST_BYTE  0xb00001ea)
#define R_DMA_CH6_STATUS__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH6_STATUS__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH6_STATUS__TYPECAST  REG_TYPECAST_BYTE
#define R_DMA_CH6_STATUS__TYPE      (REG_BYTE)
#define R_DMA_CH6_STATUS__GET       REG_GET_RO
#define R_DMA_CH6_STATUS__IGET      REG_IGET_RO
#define R_DMA_CH6_STATUS__SET       REG_SET_RO
#define R_DMA_CH6_STATUS__ISET      REG_ISET_RO
#define R_DMA_CH6_STATUS__SET_VAL   REG_SET_VAL_RO
#define R_DMA_CH6_STATUS__EQL       REG_EQL_RO
#define R_DMA_CH6_STATUS__IEQL      REG_IEQL_RO
#define R_DMA_CH6_STATUS__RD        REG_RD_RO
#define R_DMA_CH6_STATUS__IRD       REG_IRD_RO
#define R_DMA_CH6_STATUS__WR        REG_WR_RO
#define R_DMA_CH6_STATUS__IWR       REG_IWR_RO

#define R_DMA_CH6_STATUS__READ(addr) \
  (*(addr))

#define R_DMA_CH6_STATUS__avail__avail__MASK 0x0000007fU

#define R_DMA_CH6_STATUS__avail__MAX 0x7f

#define R_DMA_CH6_STATUS__avail__MIN 0

#define R_DMA_CH6_STATUS__avail__BITNR 0

#define R_DMA_CH6_STATUS__avail__avail__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH7_BUF
 *  - type:  RW
 *  - addr:  0xb0000178
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH7_BUF__ADDR      (REG_TYPECAST_UDWORD  0xb0000178)
#define R_DMA_CH7_BUF__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH7_BUF__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH7_BUF__TYPECAST  REG_TYPECAST_UDWORD
#define R_DMA_CH7_BUF__TYPE      (REG_UDWORD)
#define R_DMA_CH7_BUF__GET       REG_GET_RW
#define R_DMA_CH7_BUF__IGET      REG_IGET_RW
#define R_DMA_CH7_BUF__SET       REG_SET_RW
#define R_DMA_CH7_BUF__ISET      REG_ISET_RW
#define R_DMA_CH7_BUF__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH7_BUF__EQL       REG_EQL_RW
#define R_DMA_CH7_BUF__IEQL      REG_IEQL_RW
#define R_DMA_CH7_BUF__RD        REG_RD_RW
#define R_DMA_CH7_BUF__IRD       REG_IRD_RW
#define R_DMA_CH7_BUF__WR        REG_WR_RW
#define R_DMA_CH7_BUF__IWR       REG_IWR_RW

#define R_DMA_CH7_BUF__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH7_BUF__READ(addr) \
  (*(addr))

#define R_DMA_CH7_BUF__buf__buf__MASK 0xffffffffU

#define R_DMA_CH7_BUF__buf__MAX 0xffffffff

#define R_DMA_CH7_BUF__buf__MIN 0

#define R_DMA_CH7_BUF__buf__BITNR 0

#define R_DMA_CH7_BUF__buf__buf__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH7_CLR_INTR
 *  - type:  WO
 *  - addr:  0xb00001ed
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH7_CLR_INTR__ADDR      (REG_TYPECAST_BYTE  0xb00001ed)

#ifndef REG_NO_SHADOW
#define R_DMA_CH7_CLR_INTR__SADDR     (REG_STYPECAST_BYTE (reg_shadow__hwregs.R_DMA_CH7_CLR_INTR + 0))
#define R_DMA_CH7_CLR_INTR__IADDR     (REG_STYPECAST_BYTE (reg_initiated__hwregs.R_DMA_CH7_CLR_INTR + 0))
#else /* REG_NO_SHADOW */
#define R_DMA_CH7_CLR_INTR__SADDR     (REG_STYPECAST_BYTE (&reg_shadow__hwregs))
#define R_DMA_CH7_CLR_INTR__IADDR     (REG_STYPECAST_BYTE (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_DMA_CH7_CLR_INTR__STYPECAST REG_STYPECAST_BYTE
#define R_DMA_CH7_CLR_INTR__SVAL REG_SVAL_ZERO
#define R_DMA_CH7_CLR_INTR__SVAL_I REG_SVAL_I_ZERO
#define R_DMA_CH7_CLR_INTR__TYPECAST  REG_TYPECAST_BYTE
#define R_DMA_CH7_CLR_INTR__TYPE      (REG_BYTE)
#define R_DMA_CH7_CLR_INTR__GET       REG_GET_WO
#define R_DMA_CH7_CLR_INTR__IGET      REG_IGET_WO
#define R_DMA_CH7_CLR_INTR__SET       REG_SET_WO
#define R_DMA_CH7_CLR_INTR__ISET      REG_ISET_WO
#define R_DMA_CH7_CLR_INTR__SET_VAL   REG_SET_VAL_WO
#define R_DMA_CH7_CLR_INTR__EQL       REG_EQL_WO
#define R_DMA_CH7_CLR_INTR__IEQL      REG_IEQL_WO
#define R_DMA_CH7_CLR_INTR__RD        REG_RD_WO
#define R_DMA_CH7_CLR_INTR__IRD       REG_IRD_WO
#define R_DMA_CH7_CLR_INTR__WR        REG_WR_WO
#define R_DMA_CH7_CLR_INTR__IWR       REG_IWR_WO

#define R_DMA_CH7_CLR_INTR__WRITE(addr,value) \
  (*(addr) = (value))

#define R_DMA_CH7_CLR_INTR__clr_eop__clr_eop__MASK 0x00000002U
#define R_DMA_CH7_CLR_INTR__clr_descr__clr_descr__MASK 0x00000001U

#define R_DMA_CH7_CLR_INTR__clr_eop__MAX 0x1
#define R_DMA_CH7_CLR_INTR__clr_descr__MAX 0x1

#define R_DMA_CH7_CLR_INTR__clr_eop__MIN 0
#define R_DMA_CH7_CLR_INTR__clr_descr__MIN 0

#define R_DMA_CH7_CLR_INTR__clr_eop__BITNR 1
#define R_DMA_CH7_CLR_INTR__clr_descr__BITNR 0

#define R_DMA_CH7_CLR_INTR__clr_eop__clr_eop__VAL REG_VAL_ENUM
#define R_DMA_CH7_CLR_INTR__clr_descr__clr_descr__VAL REG_VAL_ENUM

#define R_DMA_CH7_CLR_INTR__clr_eop__clr_eop__do 1
#define R_DMA_CH7_CLR_INTR__clr_eop__clr_eop__dont 0
#define R_DMA_CH7_CLR_INTR__clr_descr__clr_descr__do 1
#define R_DMA_CH7_CLR_INTR__clr_descr__clr_descr__dont 0

#endif

/*
 *  R_DMA_CH7_CMD
 *  - type:  RW
 *  - addr:  0xb00001ec
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH7_CMD__ADDR      (REG_TYPECAST_BYTE  0xb00001ec)
#define R_DMA_CH7_CMD__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH7_CMD__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH7_CMD__TYPECAST  REG_TYPECAST_BYTE
#define R_DMA_CH7_CMD__TYPE      (REG_BYTE)
#define R_DMA_CH7_CMD__GET       REG_GET_RW
#define R_DMA_CH7_CMD__IGET      REG_IGET_RW
#define R_DMA_CH7_CMD__SET       REG_SET_RW
#define R_DMA_CH7_CMD__ISET      REG_ISET_RW
#define R_DMA_CH7_CMD__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH7_CMD__EQL       REG_EQL_RW
#define R_DMA_CH7_CMD__IEQL      REG_IEQL_RW
#define R_DMA_CH7_CMD__RD        REG_RD_RW
#define R_DMA_CH7_CMD__IRD       REG_IRD_RW
#define R_DMA_CH7_CMD__WR        REG_WR_RW
#define R_DMA_CH7_CMD__IWR       REG_IWR_RW

#define R_DMA_CH7_CMD__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH7_CMD__READ(addr) \
  (*(addr))

#define R_DMA_CH7_CMD__cmd__cmd__MASK 0x00000007U

#define R_DMA_CH7_CMD__cmd__MAX 0x7

#define R_DMA_CH7_CMD__cmd__MIN 0

#define R_DMA_CH7_CMD__cmd__BITNR 0

#define R_DMA_CH7_CMD__cmd__cmd__VAL REG_VAL_ENUM

#define R_DMA_CH7_CMD__cmd__cmd__continue 3
#define R_DMA_CH7_CMD__cmd__cmd__hold 0
#define R_DMA_CH7_CMD__cmd__cmd__reset 4
#define R_DMA_CH7_CMD__cmd__cmd__restart 3
#define R_DMA_CH7_CMD__cmd__cmd__start 1

#endif

/*
 *  R_DMA_CH7_DESCR
 *  - type:  RW
 *  - addr:  0xb000017c
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH7_DESCR__ADDR      (REG_TYPECAST_UDWORD  0xb000017c)
#define R_DMA_CH7_DESCR__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH7_DESCR__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH7_DESCR__TYPECAST  REG_TYPECAST_UDWORD
#define R_DMA_CH7_DESCR__TYPE      (REG_UDWORD)
#define R_DMA_CH7_DESCR__GET       REG_GET_RW
#define R_DMA_CH7_DESCR__IGET      REG_IGET_RW
#define R_DMA_CH7_DESCR__SET       REG_SET_RW
#define R_DMA_CH7_DESCR__ISET      REG_ISET_RW
#define R_DMA_CH7_DESCR__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH7_DESCR__EQL       REG_EQL_RW
#define R_DMA_CH7_DESCR__IEQL      REG_IEQL_RW
#define R_DMA_CH7_DESCR__RD        REG_RD_RW
#define R_DMA_CH7_DESCR__IRD       REG_IRD_RW
#define R_DMA_CH7_DESCR__WR        REG_WR_RW
#define R_DMA_CH7_DESCR__IWR       REG_IWR_RW

#define R_DMA_CH7_DESCR__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH7_DESCR__READ(addr) \
  (*(addr))

#define R_DMA_CH7_DESCR__descr__descr__MASK 0xffffffffU

#define R_DMA_CH7_DESCR__descr__MAX 0xffffffff

#define R_DMA_CH7_DESCR__descr__MIN 0

#define R_DMA_CH7_DESCR__descr__BITNR 0

#define R_DMA_CH7_DESCR__descr__descr__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH7_FIRST
 *  - type:  RW
 *  - addr:  0xb00001bc
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH7_FIRST__ADDR      (REG_TYPECAST_UDWORD  0xb00001bc)
#define R_DMA_CH7_FIRST__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH7_FIRST__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH7_FIRST__TYPECAST  REG_TYPECAST_UDWORD
#define R_DMA_CH7_FIRST__TYPE      (REG_UDWORD)
#define R_DMA_CH7_FIRST__GET       REG_GET_RW
#define R_DMA_CH7_FIRST__IGET      REG_IGET_RW
#define R_DMA_CH7_FIRST__SET       REG_SET_RW
#define R_DMA_CH7_FIRST__ISET      REG_ISET_RW
#define R_DMA_CH7_FIRST__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH7_FIRST__EQL       REG_EQL_RW
#define R_DMA_CH7_FIRST__IEQL      REG_IEQL_RW
#define R_DMA_CH7_FIRST__RD        REG_RD_RW
#define R_DMA_CH7_FIRST__IRD       REG_IRD_RW
#define R_DMA_CH7_FIRST__WR        REG_WR_RW
#define R_DMA_CH7_FIRST__IWR       REG_IWR_RW

#define R_DMA_CH7_FIRST__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH7_FIRST__READ(addr) \
  (*(addr))

#define R_DMA_CH7_FIRST__first__first__MASK 0xffffffffU

#define R_DMA_CH7_FIRST__first__MAX 0xffffffff

#define R_DMA_CH7_FIRST__first__MIN 0

#define R_DMA_CH7_FIRST__first__BITNR 0

#define R_DMA_CH7_FIRST__first__first__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH7_HWSW
 *  - type:  RW
 *  - addr:  0xb0000170
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH7_HWSW__ADDR      (REG_TYPECAST_UDWORD  0xb0000170)
#define R_DMA_CH7_HWSW__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH7_HWSW__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH7_HWSW__TYPECAST  REG_TYPECAST_UDWORD
#define R_DMA_CH7_HWSW__TYPE      (REG_UDWORD)
#define R_DMA_CH7_HWSW__GET       REG_GET_RW
#define R_DMA_CH7_HWSW__IGET      REG_IGET_RW
#define R_DMA_CH7_HWSW__SET       REG_SET_RW
#define R_DMA_CH7_HWSW__ISET      REG_ISET_RW
#define R_DMA_CH7_HWSW__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH7_HWSW__EQL       REG_EQL_RW
#define R_DMA_CH7_HWSW__IEQL      REG_IEQL_RW
#define R_DMA_CH7_HWSW__RD        REG_RD_RW
#define R_DMA_CH7_HWSW__IRD       REG_IRD_RW
#define R_DMA_CH7_HWSW__WR        REG_WR_RW
#define R_DMA_CH7_HWSW__IWR       REG_IWR_RW

#define R_DMA_CH7_HWSW__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH7_HWSW__READ(addr) \
  (*(addr))

#define R_DMA_CH7_HWSW__hw__hw__MASK 0xffff0000U
#define R_DMA_CH7_HWSW__sw__sw__MASK 0x0000ffffU

#define R_DMA_CH7_HWSW__hw__MAX 0xffff
#define R_DMA_CH7_HWSW__sw__MAX 0xffff

#define R_DMA_CH7_HWSW__hw__MIN 0
#define R_DMA_CH7_HWSW__sw__MIN 0

#define R_DMA_CH7_HWSW__hw__BITNR 16
#define R_DMA_CH7_HWSW__sw__BITNR 0

#define R_DMA_CH7_HWSW__hw__hw__VAL REG_VAL_VAL
#define R_DMA_CH7_HWSW__sw__sw__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH7_NEXT
 *  - type:  RW
 *  - addr:  0xb0000174
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH7_NEXT__ADDR      (REG_TYPECAST_UDWORD  0xb0000174)
#define R_DMA_CH7_NEXT__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH7_NEXT__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH7_NEXT__TYPECAST  REG_TYPECAST_UDWORD
#define R_DMA_CH7_NEXT__TYPE      (REG_UDWORD)
#define R_DMA_CH7_NEXT__GET       REG_GET_RW
#define R_DMA_CH7_NEXT__IGET      REG_IGET_RW
#define R_DMA_CH7_NEXT__SET       REG_SET_RW
#define R_DMA_CH7_NEXT__ISET      REG_ISET_RW
#define R_DMA_CH7_NEXT__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH7_NEXT__EQL       REG_EQL_RW
#define R_DMA_CH7_NEXT__IEQL      REG_IEQL_RW
#define R_DMA_CH7_NEXT__RD        REG_RD_RW
#define R_DMA_CH7_NEXT__IRD       REG_IRD_RW
#define R_DMA_CH7_NEXT__WR        REG_WR_RW
#define R_DMA_CH7_NEXT__IWR       REG_IWR_RW

#define R_DMA_CH7_NEXT__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH7_NEXT__READ(addr) \
  (*(addr))

#define R_DMA_CH7_NEXT__next__next__MASK 0xffffffffU

#define R_DMA_CH7_NEXT__next__MAX 0xffffffff

#define R_DMA_CH7_NEXT__next__MIN 0

#define R_DMA_CH7_NEXT__next__BITNR 0

#define R_DMA_CH7_NEXT__next__next__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH7_STATUS
 *  - type:  RO
 *  - addr:  0xb00001ee
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH7_STATUS__ADDR      (REG_TYPECAST_BYTE  0xb00001ee)
#define R_DMA_CH7_STATUS__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH7_STATUS__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH7_STATUS__TYPECAST  REG_TYPECAST_BYTE
#define R_DMA_CH7_STATUS__TYPE      (REG_BYTE)
#define R_DMA_CH7_STATUS__GET       REG_GET_RO
#define R_DMA_CH7_STATUS__IGET      REG_IGET_RO
#define R_DMA_CH7_STATUS__SET       REG_SET_RO
#define R_DMA_CH7_STATUS__ISET      REG_ISET_RO
#define R_DMA_CH7_STATUS__SET_VAL   REG_SET_VAL_RO
#define R_DMA_CH7_STATUS__EQL       REG_EQL_RO
#define R_DMA_CH7_STATUS__IEQL      REG_IEQL_RO
#define R_DMA_CH7_STATUS__RD        REG_RD_RO
#define R_DMA_CH7_STATUS__IRD       REG_IRD_RO
#define R_DMA_CH7_STATUS__WR        REG_WR_RO
#define R_DMA_CH7_STATUS__IWR       REG_IWR_RO

#define R_DMA_CH7_STATUS__READ(addr) \
  (*(addr))

#define R_DMA_CH7_STATUS__avail__avail__MASK 0x0000007fU

#define R_DMA_CH7_STATUS__avail__MAX 0x7f

#define R_DMA_CH7_STATUS__avail__MIN 0

#define R_DMA_CH7_STATUS__avail__BITNR 0

#define R_DMA_CH7_STATUS__avail__avail__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH8_BUF
 *  - type:  RW
 *  - addr:  0xb0000188
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH8_BUF__ADDR      (REG_TYPECAST_UDWORD  0xb0000188)
#define R_DMA_CH8_BUF__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH8_BUF__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH8_BUF__TYPECAST  REG_TYPECAST_UDWORD
#define R_DMA_CH8_BUF__TYPE      (REG_UDWORD)
#define R_DMA_CH8_BUF__GET       REG_GET_RW
#define R_DMA_CH8_BUF__IGET      REG_IGET_RW
#define R_DMA_CH8_BUF__SET       REG_SET_RW
#define R_DMA_CH8_BUF__ISET      REG_ISET_RW
#define R_DMA_CH8_BUF__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH8_BUF__EQL       REG_EQL_RW
#define R_DMA_CH8_BUF__IEQL      REG_IEQL_RW
#define R_DMA_CH8_BUF__RD        REG_RD_RW
#define R_DMA_CH8_BUF__IRD       REG_IRD_RW
#define R_DMA_CH8_BUF__WR        REG_WR_RW
#define R_DMA_CH8_BUF__IWR       REG_IWR_RW

#define R_DMA_CH8_BUF__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH8_BUF__READ(addr) \
  (*(addr))

#define R_DMA_CH8_BUF__buf__buf__MASK 0xffffffffU

#define R_DMA_CH8_BUF__buf__MAX 0xffffffff

#define R_DMA_CH8_BUF__buf__MIN 0

#define R_DMA_CH8_BUF__buf__BITNR 0

#define R_DMA_CH8_BUF__buf__buf__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH8_CLR_INTR
 *  - type:  WO
 *  - addr:  0xb00001f1
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH8_CLR_INTR__ADDR      (REG_TYPECAST_BYTE  0xb00001f1)

#ifndef REG_NO_SHADOW
#define R_DMA_CH8_CLR_INTR__SADDR     (REG_STYPECAST_BYTE (reg_shadow__hwregs.R_DMA_CH8_CLR_INTR + 0))
#define R_DMA_CH8_CLR_INTR__IADDR     (REG_STYPECAST_BYTE (reg_initiated__hwregs.R_DMA_CH8_CLR_INTR + 0))
#else /* REG_NO_SHADOW */
#define R_DMA_CH8_CLR_INTR__SADDR     (REG_STYPECAST_BYTE (&reg_shadow__hwregs))
#define R_DMA_CH8_CLR_INTR__IADDR     (REG_STYPECAST_BYTE (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_DMA_CH8_CLR_INTR__STYPECAST REG_STYPECAST_BYTE
#define R_DMA_CH8_CLR_INTR__SVAL REG_SVAL_ZERO
#define R_DMA_CH8_CLR_INTR__SVAL_I REG_SVAL_I_ZERO
#define R_DMA_CH8_CLR_INTR__TYPECAST  REG_TYPECAST_BYTE
#define R_DMA_CH8_CLR_INTR__TYPE      (REG_BYTE)
#define R_DMA_CH8_CLR_INTR__GET       REG_GET_WO
#define R_DMA_CH8_CLR_INTR__IGET      REG_IGET_WO
#define R_DMA_CH8_CLR_INTR__SET       REG_SET_WO
#define R_DMA_CH8_CLR_INTR__ISET      REG_ISET_WO
#define R_DMA_CH8_CLR_INTR__SET_VAL   REG_SET_VAL_WO
#define R_DMA_CH8_CLR_INTR__EQL       REG_EQL_WO
#define R_DMA_CH8_CLR_INTR__IEQL      REG_IEQL_WO
#define R_DMA_CH8_CLR_INTR__RD        REG_RD_WO
#define R_DMA_CH8_CLR_INTR__IRD       REG_IRD_WO
#define R_DMA_CH8_CLR_INTR__WR        REG_WR_WO
#define R_DMA_CH8_CLR_INTR__IWR       REG_IWR_WO

#define R_DMA_CH8_CLR_INTR__WRITE(addr,value) \
  (*(addr) = (value))

#define R_DMA_CH8_CLR_INTR__clr_eop__clr_eop__MASK 0x00000002U
#define R_DMA_CH8_CLR_INTR__clr_descr__clr_descr__MASK 0x00000001U

#define R_DMA_CH8_CLR_INTR__clr_eop__MAX 0x1
#define R_DMA_CH8_CLR_INTR__clr_descr__MAX 0x1

#define R_DMA_CH8_CLR_INTR__clr_eop__MIN 0
#define R_DMA_CH8_CLR_INTR__clr_descr__MIN 0

#define R_DMA_CH8_CLR_INTR__clr_eop__BITNR 1
#define R_DMA_CH8_CLR_INTR__clr_descr__BITNR 0

#define R_DMA_CH8_CLR_INTR__clr_eop__clr_eop__VAL REG_VAL_ENUM
#define R_DMA_CH8_CLR_INTR__clr_descr__clr_descr__VAL REG_VAL_ENUM

#define R_DMA_CH8_CLR_INTR__clr_eop__clr_eop__do 1
#define R_DMA_CH8_CLR_INTR__clr_eop__clr_eop__dont 0
#define R_DMA_CH8_CLR_INTR__clr_descr__clr_descr__do 1
#define R_DMA_CH8_CLR_INTR__clr_descr__clr_descr__dont 0

#endif

/*
 *  R_DMA_CH8_CMD
 *  - type:  RW
 *  - addr:  0xb00001f0
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH8_CMD__ADDR      (REG_TYPECAST_BYTE  0xb00001f0)
#define R_DMA_CH8_CMD__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH8_CMD__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH8_CMD__TYPECAST  REG_TYPECAST_BYTE
#define R_DMA_CH8_CMD__TYPE      (REG_BYTE)
#define R_DMA_CH8_CMD__GET       REG_GET_RW
#define R_DMA_CH8_CMD__IGET      REG_IGET_RW
#define R_DMA_CH8_CMD__SET       REG_SET_RW
#define R_DMA_CH8_CMD__ISET      REG_ISET_RW
#define R_DMA_CH8_CMD__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH8_CMD__EQL       REG_EQL_RW
#define R_DMA_CH8_CMD__IEQL      REG_IEQL_RW
#define R_DMA_CH8_CMD__RD        REG_RD_RW
#define R_DMA_CH8_CMD__IRD       REG_IRD_RW
#define R_DMA_CH8_CMD__WR        REG_WR_RW
#define R_DMA_CH8_CMD__IWR       REG_IWR_RW

#define R_DMA_CH8_CMD__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH8_CMD__READ(addr) \
  (*(addr))

#define R_DMA_CH8_CMD__cmd__cmd__MASK 0x00000007U

#define R_DMA_CH8_CMD__cmd__MAX 0x7

#define R_DMA_CH8_CMD__cmd__MIN 0

#define R_DMA_CH8_CMD__cmd__BITNR 0

#define R_DMA_CH8_CMD__cmd__cmd__VAL REG_VAL_ENUM

#define R_DMA_CH8_CMD__cmd__cmd__continue 3
#define R_DMA_CH8_CMD__cmd__cmd__hold 0
#define R_DMA_CH8_CMD__cmd__cmd__reset 4
#define R_DMA_CH8_CMD__cmd__cmd__restart 3
#define R_DMA_CH8_CMD__cmd__cmd__start 1

#endif

/*
 *  R_DMA_CH8_DESCR
 *  - type:  RW
 *  - addr:  0xb000018c
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH8_DESCR__ADDR      (REG_TYPECAST_UDWORD  0xb000018c)
#define R_DMA_CH8_DESCR__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH8_DESCR__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH8_DESCR__TYPECAST  REG_TYPECAST_UDWORD
#define R_DMA_CH8_DESCR__TYPE      (REG_UDWORD)
#define R_DMA_CH8_DESCR__GET       REG_GET_RW
#define R_DMA_CH8_DESCR__IGET      REG_IGET_RW
#define R_DMA_CH8_DESCR__SET       REG_SET_RW
#define R_DMA_CH8_DESCR__ISET      REG_ISET_RW
#define R_DMA_CH8_DESCR__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH8_DESCR__EQL       REG_EQL_RW
#define R_DMA_CH8_DESCR__IEQL      REG_IEQL_RW
#define R_DMA_CH8_DESCR__RD        REG_RD_RW
#define R_DMA_CH8_DESCR__IRD       REG_IRD_RW
#define R_DMA_CH8_DESCR__WR        REG_WR_RW
#define R_DMA_CH8_DESCR__IWR       REG_IWR_RW

#define R_DMA_CH8_DESCR__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH8_DESCR__READ(addr) \
  (*(addr))

#define R_DMA_CH8_DESCR__descr__descr__MASK 0xffffffffU

#define R_DMA_CH8_DESCR__descr__MAX 0xffffffff

#define R_DMA_CH8_DESCR__descr__MIN 0

#define R_DMA_CH8_DESCR__descr__BITNR 0

#define R_DMA_CH8_DESCR__descr__descr__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH8_FIRST
 *  - type:  RW
 *  - addr:  0xb00001c0
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH8_FIRST__ADDR      (REG_TYPECAST_UDWORD  0xb00001c0)
#define R_DMA_CH8_FIRST__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH8_FIRST__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH8_FIRST__TYPECAST  REG_TYPECAST_UDWORD
#define R_DMA_CH8_FIRST__TYPE      (REG_UDWORD)
#define R_DMA_CH8_FIRST__GET       REG_GET_RW
#define R_DMA_CH8_FIRST__IGET      REG_IGET_RW
#define R_DMA_CH8_FIRST__SET       REG_SET_RW
#define R_DMA_CH8_FIRST__ISET      REG_ISET_RW
#define R_DMA_CH8_FIRST__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH8_FIRST__EQL       REG_EQL_RW
#define R_DMA_CH8_FIRST__IEQL      REG_IEQL_RW
#define R_DMA_CH8_FIRST__RD        REG_RD_RW
#define R_DMA_CH8_FIRST__IRD       REG_IRD_RW
#define R_DMA_CH8_FIRST__WR        REG_WR_RW
#define R_DMA_CH8_FIRST__IWR       REG_IWR_RW

#define R_DMA_CH8_FIRST__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH8_FIRST__READ(addr) \
  (*(addr))

#define R_DMA_CH8_FIRST__first__first__MASK 0xffffffffU

#define R_DMA_CH8_FIRST__first__MAX 0xffffffff

#define R_DMA_CH8_FIRST__first__MIN 0

#define R_DMA_CH8_FIRST__first__BITNR 0

#define R_DMA_CH8_FIRST__first__first__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH8_HWSW
 *  - type:  RW
 *  - addr:  0xb0000180
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH8_HWSW__ADDR      (REG_TYPECAST_UDWORD  0xb0000180)
#define R_DMA_CH8_HWSW__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH8_HWSW__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH8_HWSW__TYPECAST  REG_TYPECAST_UDWORD
#define R_DMA_CH8_HWSW__TYPE      (REG_UDWORD)
#define R_DMA_CH8_HWSW__GET       REG_GET_RW
#define R_DMA_CH8_HWSW__IGET      REG_IGET_RW
#define R_DMA_CH8_HWSW__SET       REG_SET_RW
#define R_DMA_CH8_HWSW__ISET      REG_ISET_RW
#define R_DMA_CH8_HWSW__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH8_HWSW__EQL       REG_EQL_RW
#define R_DMA_CH8_HWSW__IEQL      REG_IEQL_RW
#define R_DMA_CH8_HWSW__RD        REG_RD_RW
#define R_DMA_CH8_HWSW__IRD       REG_IRD_RW
#define R_DMA_CH8_HWSW__WR        REG_WR_RW
#define R_DMA_CH8_HWSW__IWR       REG_IWR_RW

#define R_DMA_CH8_HWSW__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH8_HWSW__READ(addr) \
  (*(addr))

#define R_DMA_CH8_HWSW__hw__hw__MASK 0xffff0000U
#define R_DMA_CH8_HWSW__sw__sw__MASK 0x0000ffffU

#define R_DMA_CH8_HWSW__hw__MAX 0xffff
#define R_DMA_CH8_HWSW__sw__MAX 0xffff

#define R_DMA_CH8_HWSW__hw__MIN 0
#define R_DMA_CH8_HWSW__sw__MIN 0

#define R_DMA_CH8_HWSW__hw__BITNR 16
#define R_DMA_CH8_HWSW__sw__BITNR 0

#define R_DMA_CH8_HWSW__hw__hw__VAL REG_VAL_VAL
#define R_DMA_CH8_HWSW__sw__sw__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH8_NEP
 *  - type:  RW
 *  - addr:  0xb00001c0
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH8_NEP__ADDR      (REG_TYPECAST_UDWORD  0xb00001c0)
#define R_DMA_CH8_NEP__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH8_NEP__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH8_NEP__TYPECAST  REG_TYPECAST_UDWORD
#define R_DMA_CH8_NEP__TYPE      (REG_UDWORD)
#define R_DMA_CH8_NEP__GET       REG_GET_RW
#define R_DMA_CH8_NEP__IGET      REG_IGET_RW
#define R_DMA_CH8_NEP__SET       REG_SET_RW
#define R_DMA_CH8_NEP__ISET      REG_ISET_RW
#define R_DMA_CH8_NEP__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH8_NEP__EQL       REG_EQL_RW
#define R_DMA_CH8_NEP__IEQL      REG_IEQL_RW
#define R_DMA_CH8_NEP__RD        REG_RD_RW
#define R_DMA_CH8_NEP__IRD       REG_IRD_RW
#define R_DMA_CH8_NEP__WR        REG_WR_RW
#define R_DMA_CH8_NEP__IWR       REG_IWR_RW

#define R_DMA_CH8_NEP__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH8_NEP__READ(addr) \
  (*(addr))

#define R_DMA_CH8_NEP__nep__nep__MASK 0xffffffffU

#define R_DMA_CH8_NEP__nep__MAX 0xffffffff

#define R_DMA_CH8_NEP__nep__MIN 0

#define R_DMA_CH8_NEP__nep__BITNR 0

#define R_DMA_CH8_NEP__nep__nep__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH8_NEXT
 *  - type:  RW
 *  - addr:  0xb0000184
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH8_NEXT__ADDR      (REG_TYPECAST_UDWORD  0xb0000184)
#define R_DMA_CH8_NEXT__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH8_NEXT__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH8_NEXT__TYPECAST  REG_TYPECAST_UDWORD
#define R_DMA_CH8_NEXT__TYPE      (REG_UDWORD)
#define R_DMA_CH8_NEXT__GET       REG_GET_RW
#define R_DMA_CH8_NEXT__IGET      REG_IGET_RW
#define R_DMA_CH8_NEXT__SET       REG_SET_RW
#define R_DMA_CH8_NEXT__ISET      REG_ISET_RW
#define R_DMA_CH8_NEXT__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH8_NEXT__EQL       REG_EQL_RW
#define R_DMA_CH8_NEXT__IEQL      REG_IEQL_RW
#define R_DMA_CH8_NEXT__RD        REG_RD_RW
#define R_DMA_CH8_NEXT__IRD       REG_IRD_RW
#define R_DMA_CH8_NEXT__WR        REG_WR_RW
#define R_DMA_CH8_NEXT__IWR       REG_IWR_RW

#define R_DMA_CH8_NEXT__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH8_NEXT__READ(addr) \
  (*(addr))

#define R_DMA_CH8_NEXT__next__next__MASK 0xffffffffU

#define R_DMA_CH8_NEXT__next__MAX 0xffffffff

#define R_DMA_CH8_NEXT__next__MIN 0

#define R_DMA_CH8_NEXT__next__BITNR 0

#define R_DMA_CH8_NEXT__next__next__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH8_STATUS
 *  - type:  RO
 *  - addr:  0xb00001f2
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH8_STATUS__ADDR      (REG_TYPECAST_BYTE  0xb00001f2)
#define R_DMA_CH8_STATUS__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH8_STATUS__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH8_STATUS__TYPECAST  REG_TYPECAST_BYTE
#define R_DMA_CH8_STATUS__TYPE      (REG_BYTE)
#define R_DMA_CH8_STATUS__GET       REG_GET_RO
#define R_DMA_CH8_STATUS__IGET      REG_IGET_RO
#define R_DMA_CH8_STATUS__SET       REG_SET_RO
#define R_DMA_CH8_STATUS__ISET      REG_ISET_RO
#define R_DMA_CH8_STATUS__SET_VAL   REG_SET_VAL_RO
#define R_DMA_CH8_STATUS__EQL       REG_EQL_RO
#define R_DMA_CH8_STATUS__IEQL      REG_IEQL_RO
#define R_DMA_CH8_STATUS__RD        REG_RD_RO
#define R_DMA_CH8_STATUS__IRD       REG_IRD_RO
#define R_DMA_CH8_STATUS__WR        REG_WR_RO
#define R_DMA_CH8_STATUS__IWR       REG_IWR_RO

#define R_DMA_CH8_STATUS__READ(addr) \
  (*(addr))

#define R_DMA_CH8_STATUS__avail__avail__MASK 0x0000007fU

#define R_DMA_CH8_STATUS__avail__MAX 0x7f

#define R_DMA_CH8_STATUS__avail__MIN 0

#define R_DMA_CH8_STATUS__avail__BITNR 0

#define R_DMA_CH8_STATUS__avail__avail__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH8_SUB
 *  - type:  RW
 *  - addr:  0xb000018c
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH8_SUB__ADDR      (REG_TYPECAST_UDWORD  0xb000018c)
#define R_DMA_CH8_SUB__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH8_SUB__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH8_SUB__TYPECAST  REG_TYPECAST_UDWORD
#define R_DMA_CH8_SUB__TYPE      (REG_UDWORD)
#define R_DMA_CH8_SUB__GET       REG_GET_RW
#define R_DMA_CH8_SUB__IGET      REG_IGET_RW
#define R_DMA_CH8_SUB__SET       REG_SET_RW
#define R_DMA_CH8_SUB__ISET      REG_ISET_RW
#define R_DMA_CH8_SUB__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH8_SUB__EQL       REG_EQL_RW
#define R_DMA_CH8_SUB__IEQL      REG_IEQL_RW
#define R_DMA_CH8_SUB__RD        REG_RD_RW
#define R_DMA_CH8_SUB__IRD       REG_IRD_RW
#define R_DMA_CH8_SUB__WR        REG_WR_RW
#define R_DMA_CH8_SUB__IWR       REG_IWR_RW

#define R_DMA_CH8_SUB__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH8_SUB__READ(addr) \
  (*(addr))

#define R_DMA_CH8_SUB__sub__sub__MASK 0xffffffffU

#define R_DMA_CH8_SUB__sub__MAX 0xffffffff

#define R_DMA_CH8_SUB__sub__MIN 0

#define R_DMA_CH8_SUB__sub__BITNR 0

#define R_DMA_CH8_SUB__sub__sub__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH8_SUB0_CLR_INTR
 *  - type:  WO
 *  - addr:  0xb00001e3
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH8_SUB0_CLR_INTR__ADDR      (REG_TYPECAST_BYTE  0xb00001e3)

#ifndef REG_NO_SHADOW
#define R_DMA_CH8_SUB0_CLR_INTR__SADDR     (REG_STYPECAST_BYTE (reg_shadow__hwregs.R_DMA_CH8_SUB0_CLR_INTR + 0))
#define R_DMA_CH8_SUB0_CLR_INTR__IADDR     (REG_STYPECAST_BYTE (reg_initiated__hwregs.R_DMA_CH8_SUB0_CLR_INTR + 0))
#else /* REG_NO_SHADOW */
#define R_DMA_CH8_SUB0_CLR_INTR__SADDR     (REG_STYPECAST_BYTE (&reg_shadow__hwregs))
#define R_DMA_CH8_SUB0_CLR_INTR__IADDR     (REG_STYPECAST_BYTE (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_DMA_CH8_SUB0_CLR_INTR__STYPECAST REG_STYPECAST_BYTE
#define R_DMA_CH8_SUB0_CLR_INTR__SVAL REG_SVAL_ZERO
#define R_DMA_CH8_SUB0_CLR_INTR__SVAL_I REG_SVAL_I_ZERO
#define R_DMA_CH8_SUB0_CLR_INTR__TYPECAST  REG_TYPECAST_BYTE
#define R_DMA_CH8_SUB0_CLR_INTR__TYPE      (REG_BYTE)
#define R_DMA_CH8_SUB0_CLR_INTR__GET       REG_GET_WO
#define R_DMA_CH8_SUB0_CLR_INTR__IGET      REG_IGET_WO
#define R_DMA_CH8_SUB0_CLR_INTR__SET       REG_SET_WO
#define R_DMA_CH8_SUB0_CLR_INTR__ISET      REG_ISET_WO
#define R_DMA_CH8_SUB0_CLR_INTR__SET_VAL   REG_SET_VAL_WO
#define R_DMA_CH8_SUB0_CLR_INTR__EQL       REG_EQL_WO
#define R_DMA_CH8_SUB0_CLR_INTR__IEQL      REG_IEQL_WO
#define R_DMA_CH8_SUB0_CLR_INTR__RD        REG_RD_WO
#define R_DMA_CH8_SUB0_CLR_INTR__IRD       REG_IRD_WO
#define R_DMA_CH8_SUB0_CLR_INTR__WR        REG_WR_WO
#define R_DMA_CH8_SUB0_CLR_INTR__IWR       REG_IWR_WO

#define R_DMA_CH8_SUB0_CLR_INTR__WRITE(addr,value) \
  (*(addr) = (value))

#define R_DMA_CH8_SUB0_CLR_INTR__clr_descr__clr_descr__MASK 0x00000001U

#define R_DMA_CH8_SUB0_CLR_INTR__clr_descr__MAX 0x1

#define R_DMA_CH8_SUB0_CLR_INTR__clr_descr__MIN 0

#define R_DMA_CH8_SUB0_CLR_INTR__clr_descr__BITNR 0

#define R_DMA_CH8_SUB0_CLR_INTR__clr_descr__clr_descr__VAL REG_VAL_ENUM

#define R_DMA_CH8_SUB0_CLR_INTR__clr_descr__clr_descr__do 1
#define R_DMA_CH8_SUB0_CLR_INTR__clr_descr__clr_descr__dont 0

#endif

/*
 *  R_DMA_CH8_SUB0_CMD
 *  - type:  RW
 *  - addr:  0xb00001d3
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH8_SUB0_CMD__ADDR      (REG_TYPECAST_BYTE  0xb00001d3)
#define R_DMA_CH8_SUB0_CMD__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH8_SUB0_CMD__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH8_SUB0_CMD__TYPECAST  REG_TYPECAST_BYTE
#define R_DMA_CH8_SUB0_CMD__TYPE      (REG_BYTE)
#define R_DMA_CH8_SUB0_CMD__GET       REG_GET_RW
#define R_DMA_CH8_SUB0_CMD__IGET      REG_IGET_RW
#define R_DMA_CH8_SUB0_CMD__SET       REG_SET_RW
#define R_DMA_CH8_SUB0_CMD__ISET      REG_ISET_RW
#define R_DMA_CH8_SUB0_CMD__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH8_SUB0_CMD__EQL       REG_EQL_RW
#define R_DMA_CH8_SUB0_CMD__IEQL      REG_IEQL_RW
#define R_DMA_CH8_SUB0_CMD__RD        REG_RD_RW
#define R_DMA_CH8_SUB0_CMD__IRD       REG_IRD_RW
#define R_DMA_CH8_SUB0_CMD__WR        REG_WR_RW
#define R_DMA_CH8_SUB0_CMD__IWR       REG_IWR_RW

#define R_DMA_CH8_SUB0_CMD__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH8_SUB0_CMD__READ(addr) \
  (*(addr))

#define R_DMA_CH8_SUB0_CMD__cmd__cmd__MASK 0x00000001U

#define R_DMA_CH8_SUB0_CMD__cmd__MAX 0x1

#define R_DMA_CH8_SUB0_CMD__cmd__MIN 0

#define R_DMA_CH8_SUB0_CMD__cmd__BITNR 0

#define R_DMA_CH8_SUB0_CMD__cmd__cmd__VAL REG_VAL_ENUM

#define R_DMA_CH8_SUB0_CMD__cmd__cmd__start 1
#define R_DMA_CH8_SUB0_CMD__cmd__cmd__stop 0

#endif

/*
 *  R_DMA_CH8_SUB0_EP
 *  - type:  RW
 *  - addr:  0xb00001c8
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH8_SUB0_EP__ADDR      (REG_TYPECAST_UDWORD  0xb00001c8)
#define R_DMA_CH8_SUB0_EP__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH8_SUB0_EP__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH8_SUB0_EP__TYPECAST  REG_TYPECAST_UDWORD
#define R_DMA_CH8_SUB0_EP__TYPE      (REG_UDWORD)
#define R_DMA_CH8_SUB0_EP__GET       REG_GET_RW
#define R_DMA_CH8_SUB0_EP__IGET      REG_IGET_RW
#define R_DMA_CH8_SUB0_EP__SET       REG_SET_RW
#define R_DMA_CH8_SUB0_EP__ISET      REG_ISET_RW
#define R_DMA_CH8_SUB0_EP__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH8_SUB0_EP__EQL       REG_EQL_RW
#define R_DMA_CH8_SUB0_EP__IEQL      REG_IEQL_RW
#define R_DMA_CH8_SUB0_EP__RD        REG_RD_RW
#define R_DMA_CH8_SUB0_EP__IRD       REG_IRD_RW
#define R_DMA_CH8_SUB0_EP__WR        REG_WR_RW
#define R_DMA_CH8_SUB0_EP__IWR       REG_IWR_RW

#define R_DMA_CH8_SUB0_EP__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH8_SUB0_EP__READ(addr) \
  (*(addr))

#define R_DMA_CH8_SUB0_EP__ep__ep__MASK 0xffffffffU

#define R_DMA_CH8_SUB0_EP__ep__MAX 0xffffffff

#define R_DMA_CH8_SUB0_EP__ep__MIN 0

#define R_DMA_CH8_SUB0_EP__ep__BITNR 0

#define R_DMA_CH8_SUB0_EP__ep__ep__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH8_SUB1_CLR_INTR
 *  - type:  WO
 *  - addr:  0xb00001e7
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH8_SUB1_CLR_INTR__ADDR      (REG_TYPECAST_BYTE  0xb00001e7)

#ifndef REG_NO_SHADOW
#define R_DMA_CH8_SUB1_CLR_INTR__SADDR     (REG_STYPECAST_BYTE (reg_shadow__hwregs.R_DMA_CH8_SUB1_CLR_INTR + 0))
#define R_DMA_CH8_SUB1_CLR_INTR__IADDR     (REG_STYPECAST_BYTE (reg_initiated__hwregs.R_DMA_CH8_SUB1_CLR_INTR + 0))
#else /* REG_NO_SHADOW */
#define R_DMA_CH8_SUB1_CLR_INTR__SADDR     (REG_STYPECAST_BYTE (&reg_shadow__hwregs))
#define R_DMA_CH8_SUB1_CLR_INTR__IADDR     (REG_STYPECAST_BYTE (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_DMA_CH8_SUB1_CLR_INTR__STYPECAST REG_STYPECAST_BYTE
#define R_DMA_CH8_SUB1_CLR_INTR__SVAL REG_SVAL_ZERO
#define R_DMA_CH8_SUB1_CLR_INTR__SVAL_I REG_SVAL_I_ZERO
#define R_DMA_CH8_SUB1_CLR_INTR__TYPECAST  REG_TYPECAST_BYTE
#define R_DMA_CH8_SUB1_CLR_INTR__TYPE      (REG_BYTE)
#define R_DMA_CH8_SUB1_CLR_INTR__GET       REG_GET_WO
#define R_DMA_CH8_SUB1_CLR_INTR__IGET      REG_IGET_WO
#define R_DMA_CH8_SUB1_CLR_INTR__SET       REG_SET_WO
#define R_DMA_CH8_SUB1_CLR_INTR__ISET      REG_ISET_WO
#define R_DMA_CH8_SUB1_CLR_INTR__SET_VAL   REG_SET_VAL_WO
#define R_DMA_CH8_SUB1_CLR_INTR__EQL       REG_EQL_WO
#define R_DMA_CH8_SUB1_CLR_INTR__IEQL      REG_IEQL_WO
#define R_DMA_CH8_SUB1_CLR_INTR__RD        REG_RD_WO
#define R_DMA_CH8_SUB1_CLR_INTR__IRD       REG_IRD_WO
#define R_DMA_CH8_SUB1_CLR_INTR__WR        REG_WR_WO
#define R_DMA_CH8_SUB1_CLR_INTR__IWR       REG_IWR_WO

#define R_DMA_CH8_SUB1_CLR_INTR__WRITE(addr,value) \
  (*(addr) = (value))

#define R_DMA_CH8_SUB1_CLR_INTR__clr_descr__clr_descr__MASK 0x00000001U

#define R_DMA_CH8_SUB1_CLR_INTR__clr_descr__MAX 0x1

#define R_DMA_CH8_SUB1_CLR_INTR__clr_descr__MIN 0

#define R_DMA_CH8_SUB1_CLR_INTR__clr_descr__BITNR 0

#define R_DMA_CH8_SUB1_CLR_INTR__clr_descr__clr_descr__VAL REG_VAL_ENUM

#define R_DMA_CH8_SUB1_CLR_INTR__clr_descr__clr_descr__do 1
#define R_DMA_CH8_SUB1_CLR_INTR__clr_descr__clr_descr__dont 0

#endif

/*
 *  R_DMA_CH8_SUB1_CMD
 *  - type:  RW
 *  - addr:  0xb00001d7
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH8_SUB1_CMD__ADDR      (REG_TYPECAST_BYTE  0xb00001d7)
#define R_DMA_CH8_SUB1_CMD__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH8_SUB1_CMD__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH8_SUB1_CMD__TYPECAST  REG_TYPECAST_BYTE
#define R_DMA_CH8_SUB1_CMD__TYPE      (REG_BYTE)
#define R_DMA_CH8_SUB1_CMD__GET       REG_GET_RW
#define R_DMA_CH8_SUB1_CMD__IGET      REG_IGET_RW
#define R_DMA_CH8_SUB1_CMD__SET       REG_SET_RW
#define R_DMA_CH8_SUB1_CMD__ISET      REG_ISET_RW
#define R_DMA_CH8_SUB1_CMD__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH8_SUB1_CMD__EQL       REG_EQL_RW
#define R_DMA_CH8_SUB1_CMD__IEQL      REG_IEQL_RW
#define R_DMA_CH8_SUB1_CMD__RD        REG_RD_RW
#define R_DMA_CH8_SUB1_CMD__IRD       REG_IRD_RW
#define R_DMA_CH8_SUB1_CMD__WR        REG_WR_RW
#define R_DMA_CH8_SUB1_CMD__IWR       REG_IWR_RW

#define R_DMA_CH8_SUB1_CMD__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH8_SUB1_CMD__READ(addr) \
  (*(addr))

#define R_DMA_CH8_SUB1_CMD__cmd__cmd__MASK 0x00000001U

#define R_DMA_CH8_SUB1_CMD__cmd__MAX 0x1

#define R_DMA_CH8_SUB1_CMD__cmd__MIN 0

#define R_DMA_CH8_SUB1_CMD__cmd__BITNR 0

#define R_DMA_CH8_SUB1_CMD__cmd__cmd__VAL REG_VAL_ENUM

#define R_DMA_CH8_SUB1_CMD__cmd__cmd__start 1
#define R_DMA_CH8_SUB1_CMD__cmd__cmd__stop 0

#endif

/*
 *  R_DMA_CH8_SUB1_EP
 *  - type:  RW
 *  - addr:  0xb00001cc
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH8_SUB1_EP__ADDR      (REG_TYPECAST_UDWORD  0xb00001cc)
#define R_DMA_CH8_SUB1_EP__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH8_SUB1_EP__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH8_SUB1_EP__TYPECAST  REG_TYPECAST_UDWORD
#define R_DMA_CH8_SUB1_EP__TYPE      (REG_UDWORD)
#define R_DMA_CH8_SUB1_EP__GET       REG_GET_RW
#define R_DMA_CH8_SUB1_EP__IGET      REG_IGET_RW
#define R_DMA_CH8_SUB1_EP__SET       REG_SET_RW
#define R_DMA_CH8_SUB1_EP__ISET      REG_ISET_RW
#define R_DMA_CH8_SUB1_EP__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH8_SUB1_EP__EQL       REG_EQL_RW
#define R_DMA_CH8_SUB1_EP__IEQL      REG_IEQL_RW
#define R_DMA_CH8_SUB1_EP__RD        REG_RD_RW
#define R_DMA_CH8_SUB1_EP__IRD       REG_IRD_RW
#define R_DMA_CH8_SUB1_EP__WR        REG_WR_RW
#define R_DMA_CH8_SUB1_EP__IWR       REG_IWR_RW

#define R_DMA_CH8_SUB1_EP__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH8_SUB1_EP__READ(addr) \
  (*(addr))

#define R_DMA_CH8_SUB1_EP__ep__ep__MASK 0xffffffffU

#define R_DMA_CH8_SUB1_EP__ep__MAX 0xffffffff

#define R_DMA_CH8_SUB1_EP__ep__MIN 0

#define R_DMA_CH8_SUB1_EP__ep__BITNR 0

#define R_DMA_CH8_SUB1_EP__ep__ep__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH8_SUB2_CLR_INTR
 *  - type:  WO
 *  - addr:  0xb00001eb
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH8_SUB2_CLR_INTR__ADDR      (REG_TYPECAST_BYTE  0xb00001eb)

#ifndef REG_NO_SHADOW
#define R_DMA_CH8_SUB2_CLR_INTR__SADDR     (REG_STYPECAST_BYTE (reg_shadow__hwregs.R_DMA_CH8_SUB2_CLR_INTR + 0))
#define R_DMA_CH8_SUB2_CLR_INTR__IADDR     (REG_STYPECAST_BYTE (reg_initiated__hwregs.R_DMA_CH8_SUB2_CLR_INTR + 0))
#else /* REG_NO_SHADOW */
#define R_DMA_CH8_SUB2_CLR_INTR__SADDR     (REG_STYPECAST_BYTE (&reg_shadow__hwregs))
#define R_DMA_CH8_SUB2_CLR_INTR__IADDR     (REG_STYPECAST_BYTE (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_DMA_CH8_SUB2_CLR_INTR__STYPECAST REG_STYPECAST_BYTE
#define R_DMA_CH8_SUB2_CLR_INTR__SVAL REG_SVAL_ZERO
#define R_DMA_CH8_SUB2_CLR_INTR__SVAL_I REG_SVAL_I_ZERO
#define R_DMA_CH8_SUB2_CLR_INTR__TYPECAST  REG_TYPECAST_BYTE
#define R_DMA_CH8_SUB2_CLR_INTR__TYPE      (REG_BYTE)
#define R_DMA_CH8_SUB2_CLR_INTR__GET       REG_GET_WO
#define R_DMA_CH8_SUB2_CLR_INTR__IGET      REG_IGET_WO
#define R_DMA_CH8_SUB2_CLR_INTR__SET       REG_SET_WO
#define R_DMA_CH8_SUB2_CLR_INTR__ISET      REG_ISET_WO
#define R_DMA_CH8_SUB2_CLR_INTR__SET_VAL   REG_SET_VAL_WO
#define R_DMA_CH8_SUB2_CLR_INTR__EQL       REG_EQL_WO
#define R_DMA_CH8_SUB2_CLR_INTR__IEQL      REG_IEQL_WO
#define R_DMA_CH8_SUB2_CLR_INTR__RD        REG_RD_WO
#define R_DMA_CH8_SUB2_CLR_INTR__IRD       REG_IRD_WO
#define R_DMA_CH8_SUB2_CLR_INTR__WR        REG_WR_WO
#define R_DMA_CH8_SUB2_CLR_INTR__IWR       REG_IWR_WO

#define R_DMA_CH8_SUB2_CLR_INTR__WRITE(addr,value) \
  (*(addr) = (value))

#define R_DMA_CH8_SUB2_CLR_INTR__clr_descr__clr_descr__MASK 0x00000001U

#define R_DMA_CH8_SUB2_CLR_INTR__clr_descr__MAX 0x1

#define R_DMA_CH8_SUB2_CLR_INTR__clr_descr__MIN 0

#define R_DMA_CH8_SUB2_CLR_INTR__clr_descr__BITNR 0

#define R_DMA_CH8_SUB2_CLR_INTR__clr_descr__clr_descr__VAL REG_VAL_ENUM

#define R_DMA_CH8_SUB2_CLR_INTR__clr_descr__clr_descr__do 1
#define R_DMA_CH8_SUB2_CLR_INTR__clr_descr__clr_descr__dont 0

#endif

/*
 *  R_DMA_CH8_SUB2_CMD
 *  - type:  RW
 *  - addr:  0xb00001db
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH8_SUB2_CMD__ADDR      (REG_TYPECAST_BYTE  0xb00001db)
#define R_DMA_CH8_SUB2_CMD__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH8_SUB2_CMD__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH8_SUB2_CMD__TYPECAST  REG_TYPECAST_BYTE
#define R_DMA_CH8_SUB2_CMD__TYPE      (REG_BYTE)
#define R_DMA_CH8_SUB2_CMD__GET       REG_GET_RW
#define R_DMA_CH8_SUB2_CMD__IGET      REG_IGET_RW
#define R_DMA_CH8_SUB2_CMD__SET       REG_SET_RW
#define R_DMA_CH8_SUB2_CMD__ISET      REG_ISET_RW
#define R_DMA_CH8_SUB2_CMD__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH8_SUB2_CMD__EQL       REG_EQL_RW
#define R_DMA_CH8_SUB2_CMD__IEQL      REG_IEQL_RW
#define R_DMA_CH8_SUB2_CMD__RD        REG_RD_RW
#define R_DMA_CH8_SUB2_CMD__IRD       REG_IRD_RW
#define R_DMA_CH8_SUB2_CMD__WR        REG_WR_RW
#define R_DMA_CH8_SUB2_CMD__IWR       REG_IWR_RW

#define R_DMA_CH8_SUB2_CMD__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH8_SUB2_CMD__READ(addr) \
  (*(addr))

#define R_DMA_CH8_SUB2_CMD__cmd__cmd__MASK 0x00000001U

#define R_DMA_CH8_SUB2_CMD__cmd__MAX 0x1

#define R_DMA_CH8_SUB2_CMD__cmd__MIN 0

#define R_DMA_CH8_SUB2_CMD__cmd__BITNR 0

#define R_DMA_CH8_SUB2_CMD__cmd__cmd__VAL REG_VAL_ENUM

#define R_DMA_CH8_SUB2_CMD__cmd__cmd__start 1
#define R_DMA_CH8_SUB2_CMD__cmd__cmd__stop 0

#endif

/*
 *  R_DMA_CH8_SUB2_EP
 *  - type:  RW
 *  - addr:  0xb00001f8
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH8_SUB2_EP__ADDR      (REG_TYPECAST_UDWORD  0xb00001f8)
#define R_DMA_CH8_SUB2_EP__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH8_SUB2_EP__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH8_SUB2_EP__TYPECAST  REG_TYPECAST_UDWORD
#define R_DMA_CH8_SUB2_EP__TYPE      (REG_UDWORD)
#define R_DMA_CH8_SUB2_EP__GET       REG_GET_RW
#define R_DMA_CH8_SUB2_EP__IGET      REG_IGET_RW
#define R_DMA_CH8_SUB2_EP__SET       REG_SET_RW
#define R_DMA_CH8_SUB2_EP__ISET      REG_ISET_RW
#define R_DMA_CH8_SUB2_EP__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH8_SUB2_EP__EQL       REG_EQL_RW
#define R_DMA_CH8_SUB2_EP__IEQL      REG_IEQL_RW
#define R_DMA_CH8_SUB2_EP__RD        REG_RD_RW
#define R_DMA_CH8_SUB2_EP__IRD       REG_IRD_RW
#define R_DMA_CH8_SUB2_EP__WR        REG_WR_RW
#define R_DMA_CH8_SUB2_EP__IWR       REG_IWR_RW

#define R_DMA_CH8_SUB2_EP__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH8_SUB2_EP__READ(addr) \
  (*(addr))

#define R_DMA_CH8_SUB2_EP__ep__ep__MASK 0xffffffffU

#define R_DMA_CH8_SUB2_EP__ep__MAX 0xffffffff

#define R_DMA_CH8_SUB2_EP__ep__MIN 0

#define R_DMA_CH8_SUB2_EP__ep__BITNR 0

#define R_DMA_CH8_SUB2_EP__ep__ep__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH8_SUB3_CLR_INTR
 *  - type:  WO
 *  - addr:  0xb00001ef
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH8_SUB3_CLR_INTR__ADDR      (REG_TYPECAST_BYTE  0xb00001ef)

#ifndef REG_NO_SHADOW
#define R_DMA_CH8_SUB3_CLR_INTR__SADDR     (REG_STYPECAST_BYTE (reg_shadow__hwregs.R_DMA_CH8_SUB3_CLR_INTR + 0))
#define R_DMA_CH8_SUB3_CLR_INTR__IADDR     (REG_STYPECAST_BYTE (reg_initiated__hwregs.R_DMA_CH8_SUB3_CLR_INTR + 0))
#else /* REG_NO_SHADOW */
#define R_DMA_CH8_SUB3_CLR_INTR__SADDR     (REG_STYPECAST_BYTE (&reg_shadow__hwregs))
#define R_DMA_CH8_SUB3_CLR_INTR__IADDR     (REG_STYPECAST_BYTE (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_DMA_CH8_SUB3_CLR_INTR__STYPECAST REG_STYPECAST_BYTE
#define R_DMA_CH8_SUB3_CLR_INTR__SVAL REG_SVAL_ZERO
#define R_DMA_CH8_SUB3_CLR_INTR__SVAL_I REG_SVAL_I_ZERO
#define R_DMA_CH8_SUB3_CLR_INTR__TYPECAST  REG_TYPECAST_BYTE
#define R_DMA_CH8_SUB3_CLR_INTR__TYPE      (REG_BYTE)
#define R_DMA_CH8_SUB3_CLR_INTR__GET       REG_GET_WO
#define R_DMA_CH8_SUB3_CLR_INTR__IGET      REG_IGET_WO
#define R_DMA_CH8_SUB3_CLR_INTR__SET       REG_SET_WO
#define R_DMA_CH8_SUB3_CLR_INTR__ISET      REG_ISET_WO
#define R_DMA_CH8_SUB3_CLR_INTR__SET_VAL   REG_SET_VAL_WO
#define R_DMA_CH8_SUB3_CLR_INTR__EQL       REG_EQL_WO
#define R_DMA_CH8_SUB3_CLR_INTR__IEQL      REG_IEQL_WO
#define R_DMA_CH8_SUB3_CLR_INTR__RD        REG_RD_WO
#define R_DMA_CH8_SUB3_CLR_INTR__IRD       REG_IRD_WO
#define R_DMA_CH8_SUB3_CLR_INTR__WR        REG_WR_WO
#define R_DMA_CH8_SUB3_CLR_INTR__IWR       REG_IWR_WO

#define R_DMA_CH8_SUB3_CLR_INTR__WRITE(addr,value) \
  (*(addr) = (value))

#define R_DMA_CH8_SUB3_CLR_INTR__clr_descr__clr_descr__MASK 0x00000001U

#define R_DMA_CH8_SUB3_CLR_INTR__clr_descr__MAX 0x1

#define R_DMA_CH8_SUB3_CLR_INTR__clr_descr__MIN 0

#define R_DMA_CH8_SUB3_CLR_INTR__clr_descr__BITNR 0

#define R_DMA_CH8_SUB3_CLR_INTR__clr_descr__clr_descr__VAL REG_VAL_ENUM

#define R_DMA_CH8_SUB3_CLR_INTR__clr_descr__clr_descr__do 1
#define R_DMA_CH8_SUB3_CLR_INTR__clr_descr__clr_descr__dont 0

#endif

/*
 *  R_DMA_CH8_SUB3_CMD
 *  - type:  RW
 *  - addr:  0xb00001df
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH8_SUB3_CMD__ADDR      (REG_TYPECAST_BYTE  0xb00001df)
#define R_DMA_CH8_SUB3_CMD__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH8_SUB3_CMD__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH8_SUB3_CMD__TYPECAST  REG_TYPECAST_BYTE
#define R_DMA_CH8_SUB3_CMD__TYPE      (REG_BYTE)
#define R_DMA_CH8_SUB3_CMD__GET       REG_GET_RW
#define R_DMA_CH8_SUB3_CMD__IGET      REG_IGET_RW
#define R_DMA_CH8_SUB3_CMD__SET       REG_SET_RW
#define R_DMA_CH8_SUB3_CMD__ISET      REG_ISET_RW
#define R_DMA_CH8_SUB3_CMD__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH8_SUB3_CMD__EQL       REG_EQL_RW
#define R_DMA_CH8_SUB3_CMD__IEQL      REG_IEQL_RW
#define R_DMA_CH8_SUB3_CMD__RD        REG_RD_RW
#define R_DMA_CH8_SUB3_CMD__IRD       REG_IRD_RW
#define R_DMA_CH8_SUB3_CMD__WR        REG_WR_RW
#define R_DMA_CH8_SUB3_CMD__IWR       REG_IWR_RW

#define R_DMA_CH8_SUB3_CMD__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH8_SUB3_CMD__READ(addr) \
  (*(addr))

#define R_DMA_CH8_SUB3_CMD__cmd__cmd__MASK 0x00000001U

#define R_DMA_CH8_SUB3_CMD__cmd__MAX 0x1

#define R_DMA_CH8_SUB3_CMD__cmd__MIN 0

#define R_DMA_CH8_SUB3_CMD__cmd__BITNR 0

#define R_DMA_CH8_SUB3_CMD__cmd__cmd__VAL REG_VAL_ENUM

#define R_DMA_CH8_SUB3_CMD__cmd__cmd__start 1
#define R_DMA_CH8_SUB3_CMD__cmd__cmd__stop 0

#endif

/*
 *  R_DMA_CH8_SUB3_EP
 *  - type:  RW
 *  - addr:  0xb00001fc
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH8_SUB3_EP__ADDR      (REG_TYPECAST_UDWORD  0xb00001fc)
#define R_DMA_CH8_SUB3_EP__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH8_SUB3_EP__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH8_SUB3_EP__TYPECAST  REG_TYPECAST_UDWORD
#define R_DMA_CH8_SUB3_EP__TYPE      (REG_UDWORD)
#define R_DMA_CH8_SUB3_EP__GET       REG_GET_RW
#define R_DMA_CH8_SUB3_EP__IGET      REG_IGET_RW
#define R_DMA_CH8_SUB3_EP__SET       REG_SET_RW
#define R_DMA_CH8_SUB3_EP__ISET      REG_ISET_RW
#define R_DMA_CH8_SUB3_EP__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH8_SUB3_EP__EQL       REG_EQL_RW
#define R_DMA_CH8_SUB3_EP__IEQL      REG_IEQL_RW
#define R_DMA_CH8_SUB3_EP__RD        REG_RD_RW
#define R_DMA_CH8_SUB3_EP__IRD       REG_IRD_RW
#define R_DMA_CH8_SUB3_EP__WR        REG_WR_RW
#define R_DMA_CH8_SUB3_EP__IWR       REG_IWR_RW

#define R_DMA_CH8_SUB3_EP__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH8_SUB3_EP__READ(addr) \
  (*(addr))

#define R_DMA_CH8_SUB3_EP__ep__ep__MASK 0xffffffffU

#define R_DMA_CH8_SUB3_EP__ep__MAX 0xffffffff

#define R_DMA_CH8_SUB3_EP__ep__MIN 0

#define R_DMA_CH8_SUB3_EP__ep__BITNR 0

#define R_DMA_CH8_SUB3_EP__ep__ep__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH9_BUF
 *  - type:  RW
 *  - addr:  0xb0000198
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH9_BUF__ADDR      (REG_TYPECAST_UDWORD  0xb0000198)
#define R_DMA_CH9_BUF__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH9_BUF__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH9_BUF__TYPECAST  REG_TYPECAST_UDWORD
#define R_DMA_CH9_BUF__TYPE      (REG_UDWORD)
#define R_DMA_CH9_BUF__GET       REG_GET_RW
#define R_DMA_CH9_BUF__IGET      REG_IGET_RW
#define R_DMA_CH9_BUF__SET       REG_SET_RW
#define R_DMA_CH9_BUF__ISET      REG_ISET_RW
#define R_DMA_CH9_BUF__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH9_BUF__EQL       REG_EQL_RW
#define R_DMA_CH9_BUF__IEQL      REG_IEQL_RW
#define R_DMA_CH9_BUF__RD        REG_RD_RW
#define R_DMA_CH9_BUF__IRD       REG_IRD_RW
#define R_DMA_CH9_BUF__WR        REG_WR_RW
#define R_DMA_CH9_BUF__IWR       REG_IWR_RW

#define R_DMA_CH9_BUF__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH9_BUF__READ(addr) \
  (*(addr))

#define R_DMA_CH9_BUF__buf__buf__MASK 0xffffffffU

#define R_DMA_CH9_BUF__buf__MAX 0xffffffff

#define R_DMA_CH9_BUF__buf__MIN 0

#define R_DMA_CH9_BUF__buf__BITNR 0

#define R_DMA_CH9_BUF__buf__buf__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH9_CLR_INTR
 *  - type:  WO
 *  - addr:  0xb00001f5
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH9_CLR_INTR__ADDR      (REG_TYPECAST_BYTE  0xb00001f5)

#ifndef REG_NO_SHADOW
#define R_DMA_CH9_CLR_INTR__SADDR     (REG_STYPECAST_BYTE (reg_shadow__hwregs.R_DMA_CH9_CLR_INTR + 0))
#define R_DMA_CH9_CLR_INTR__IADDR     (REG_STYPECAST_BYTE (reg_initiated__hwregs.R_DMA_CH9_CLR_INTR + 0))
#else /* REG_NO_SHADOW */
#define R_DMA_CH9_CLR_INTR__SADDR     (REG_STYPECAST_BYTE (&reg_shadow__hwregs))
#define R_DMA_CH9_CLR_INTR__IADDR     (REG_STYPECAST_BYTE (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_DMA_CH9_CLR_INTR__STYPECAST REG_STYPECAST_BYTE
#define R_DMA_CH9_CLR_INTR__SVAL REG_SVAL_ZERO
#define R_DMA_CH9_CLR_INTR__SVAL_I REG_SVAL_I_ZERO
#define R_DMA_CH9_CLR_INTR__TYPECAST  REG_TYPECAST_BYTE
#define R_DMA_CH9_CLR_INTR__TYPE      (REG_BYTE)
#define R_DMA_CH9_CLR_INTR__GET       REG_GET_WO
#define R_DMA_CH9_CLR_INTR__IGET      REG_IGET_WO
#define R_DMA_CH9_CLR_INTR__SET       REG_SET_WO
#define R_DMA_CH9_CLR_INTR__ISET      REG_ISET_WO
#define R_DMA_CH9_CLR_INTR__SET_VAL   REG_SET_VAL_WO
#define R_DMA_CH9_CLR_INTR__EQL       REG_EQL_WO
#define R_DMA_CH9_CLR_INTR__IEQL      REG_IEQL_WO
#define R_DMA_CH9_CLR_INTR__RD        REG_RD_WO
#define R_DMA_CH9_CLR_INTR__IRD       REG_IRD_WO
#define R_DMA_CH9_CLR_INTR__WR        REG_WR_WO
#define R_DMA_CH9_CLR_INTR__IWR       REG_IWR_WO

#define R_DMA_CH9_CLR_INTR__WRITE(addr,value) \
  (*(addr) = (value))

#define R_DMA_CH9_CLR_INTR__clr_eop__clr_eop__MASK 0x00000002U
#define R_DMA_CH9_CLR_INTR__clr_descr__clr_descr__MASK 0x00000001U

#define R_DMA_CH9_CLR_INTR__clr_eop__MAX 0x1
#define R_DMA_CH9_CLR_INTR__clr_descr__MAX 0x1

#define R_DMA_CH9_CLR_INTR__clr_eop__MIN 0
#define R_DMA_CH9_CLR_INTR__clr_descr__MIN 0

#define R_DMA_CH9_CLR_INTR__clr_eop__BITNR 1
#define R_DMA_CH9_CLR_INTR__clr_descr__BITNR 0

#define R_DMA_CH9_CLR_INTR__clr_eop__clr_eop__VAL REG_VAL_ENUM
#define R_DMA_CH9_CLR_INTR__clr_descr__clr_descr__VAL REG_VAL_ENUM

#define R_DMA_CH9_CLR_INTR__clr_eop__clr_eop__do 1
#define R_DMA_CH9_CLR_INTR__clr_eop__clr_eop__dont 0
#define R_DMA_CH9_CLR_INTR__clr_descr__clr_descr__do 1
#define R_DMA_CH9_CLR_INTR__clr_descr__clr_descr__dont 0

#endif

/*
 *  R_DMA_CH9_CMD
 *  - type:  RW
 *  - addr:  0xb00001f4
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH9_CMD__ADDR      (REG_TYPECAST_BYTE  0xb00001f4)
#define R_DMA_CH9_CMD__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH9_CMD__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH9_CMD__TYPECAST  REG_TYPECAST_BYTE
#define R_DMA_CH9_CMD__TYPE      (REG_BYTE)
#define R_DMA_CH9_CMD__GET       REG_GET_RW
#define R_DMA_CH9_CMD__IGET      REG_IGET_RW
#define R_DMA_CH9_CMD__SET       REG_SET_RW
#define R_DMA_CH9_CMD__ISET      REG_ISET_RW
#define R_DMA_CH9_CMD__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH9_CMD__EQL       REG_EQL_RW
#define R_DMA_CH9_CMD__IEQL      REG_IEQL_RW
#define R_DMA_CH9_CMD__RD        REG_RD_RW
#define R_DMA_CH9_CMD__IRD       REG_IRD_RW
#define R_DMA_CH9_CMD__WR        REG_WR_RW
#define R_DMA_CH9_CMD__IWR       REG_IWR_RW

#define R_DMA_CH9_CMD__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH9_CMD__READ(addr) \
  (*(addr))

#define R_DMA_CH9_CMD__cmd__cmd__MASK 0x00000007U

#define R_DMA_CH9_CMD__cmd__MAX 0x7

#define R_DMA_CH9_CMD__cmd__MIN 0

#define R_DMA_CH9_CMD__cmd__BITNR 0

#define R_DMA_CH9_CMD__cmd__cmd__VAL REG_VAL_ENUM

#define R_DMA_CH9_CMD__cmd__cmd__continue 3
#define R_DMA_CH9_CMD__cmd__cmd__hold 0
#define R_DMA_CH9_CMD__cmd__cmd__reset 4
#define R_DMA_CH9_CMD__cmd__cmd__restart 3
#define R_DMA_CH9_CMD__cmd__cmd__start 1

#endif

/*
 *  R_DMA_CH9_DESCR
 *  - type:  RW
 *  - addr:  0xb000019c
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH9_DESCR__ADDR      (REG_TYPECAST_UDWORD  0xb000019c)
#define R_DMA_CH9_DESCR__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH9_DESCR__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH9_DESCR__TYPECAST  REG_TYPECAST_UDWORD
#define R_DMA_CH9_DESCR__TYPE      (REG_UDWORD)
#define R_DMA_CH9_DESCR__GET       REG_GET_RW
#define R_DMA_CH9_DESCR__IGET      REG_IGET_RW
#define R_DMA_CH9_DESCR__SET       REG_SET_RW
#define R_DMA_CH9_DESCR__ISET      REG_ISET_RW
#define R_DMA_CH9_DESCR__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH9_DESCR__EQL       REG_EQL_RW
#define R_DMA_CH9_DESCR__IEQL      REG_IEQL_RW
#define R_DMA_CH9_DESCR__RD        REG_RD_RW
#define R_DMA_CH9_DESCR__IRD       REG_IRD_RW
#define R_DMA_CH9_DESCR__WR        REG_WR_RW
#define R_DMA_CH9_DESCR__IWR       REG_IWR_RW

#define R_DMA_CH9_DESCR__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH9_DESCR__READ(addr) \
  (*(addr))

#define R_DMA_CH9_DESCR__descr__descr__MASK 0xffffffffU

#define R_DMA_CH9_DESCR__descr__MAX 0xffffffff

#define R_DMA_CH9_DESCR__descr__MIN 0

#define R_DMA_CH9_DESCR__descr__BITNR 0

#define R_DMA_CH9_DESCR__descr__descr__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH9_FIRST
 *  - type:  RW
 *  - addr:  0xb00001c4
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH9_FIRST__ADDR      (REG_TYPECAST_UDWORD  0xb00001c4)
#define R_DMA_CH9_FIRST__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH9_FIRST__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH9_FIRST__TYPECAST  REG_TYPECAST_UDWORD
#define R_DMA_CH9_FIRST__TYPE      (REG_UDWORD)
#define R_DMA_CH9_FIRST__GET       REG_GET_RW
#define R_DMA_CH9_FIRST__IGET      REG_IGET_RW
#define R_DMA_CH9_FIRST__SET       REG_SET_RW
#define R_DMA_CH9_FIRST__ISET      REG_ISET_RW
#define R_DMA_CH9_FIRST__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH9_FIRST__EQL       REG_EQL_RW
#define R_DMA_CH9_FIRST__IEQL      REG_IEQL_RW
#define R_DMA_CH9_FIRST__RD        REG_RD_RW
#define R_DMA_CH9_FIRST__IRD       REG_IRD_RW
#define R_DMA_CH9_FIRST__WR        REG_WR_RW
#define R_DMA_CH9_FIRST__IWR       REG_IWR_RW

#define R_DMA_CH9_FIRST__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH9_FIRST__READ(addr) \
  (*(addr))

#define R_DMA_CH9_FIRST__first__first__MASK 0xffffffffU

#define R_DMA_CH9_FIRST__first__MAX 0xffffffff

#define R_DMA_CH9_FIRST__first__MIN 0

#define R_DMA_CH9_FIRST__first__BITNR 0

#define R_DMA_CH9_FIRST__first__first__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH9_HWSW
 *  - type:  RW
 *  - addr:  0xb0000190
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH9_HWSW__ADDR      (REG_TYPECAST_UDWORD  0xb0000190)
#define R_DMA_CH9_HWSW__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH9_HWSW__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH9_HWSW__TYPECAST  REG_TYPECAST_UDWORD
#define R_DMA_CH9_HWSW__TYPE      (REG_UDWORD)
#define R_DMA_CH9_HWSW__GET       REG_GET_RW
#define R_DMA_CH9_HWSW__IGET      REG_IGET_RW
#define R_DMA_CH9_HWSW__SET       REG_SET_RW
#define R_DMA_CH9_HWSW__ISET      REG_ISET_RW
#define R_DMA_CH9_HWSW__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH9_HWSW__EQL       REG_EQL_RW
#define R_DMA_CH9_HWSW__IEQL      REG_IEQL_RW
#define R_DMA_CH9_HWSW__RD        REG_RD_RW
#define R_DMA_CH9_HWSW__IRD       REG_IRD_RW
#define R_DMA_CH9_HWSW__WR        REG_WR_RW
#define R_DMA_CH9_HWSW__IWR       REG_IWR_RW

#define R_DMA_CH9_HWSW__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH9_HWSW__READ(addr) \
  (*(addr))

#define R_DMA_CH9_HWSW__hw__hw__MASK 0xffff0000U
#define R_DMA_CH9_HWSW__sw__sw__MASK 0x0000ffffU

#define R_DMA_CH9_HWSW__hw__MAX 0xffff
#define R_DMA_CH9_HWSW__sw__MAX 0xffff

#define R_DMA_CH9_HWSW__hw__MIN 0
#define R_DMA_CH9_HWSW__sw__MIN 0

#define R_DMA_CH9_HWSW__hw__BITNR 16
#define R_DMA_CH9_HWSW__sw__BITNR 0

#define R_DMA_CH9_HWSW__hw__hw__VAL REG_VAL_VAL
#define R_DMA_CH9_HWSW__sw__sw__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH9_NEXT
 *  - type:  RW
 *  - addr:  0xb0000194
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH9_NEXT__ADDR      (REG_TYPECAST_UDWORD  0xb0000194)
#define R_DMA_CH9_NEXT__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH9_NEXT__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH9_NEXT__TYPECAST  REG_TYPECAST_UDWORD
#define R_DMA_CH9_NEXT__TYPE      (REG_UDWORD)
#define R_DMA_CH9_NEXT__GET       REG_GET_RW
#define R_DMA_CH9_NEXT__IGET      REG_IGET_RW
#define R_DMA_CH9_NEXT__SET       REG_SET_RW
#define R_DMA_CH9_NEXT__ISET      REG_ISET_RW
#define R_DMA_CH9_NEXT__SET_VAL   REG_SET_VAL_RW
#define R_DMA_CH9_NEXT__EQL       REG_EQL_RW
#define R_DMA_CH9_NEXT__IEQL      REG_IEQL_RW
#define R_DMA_CH9_NEXT__RD        REG_RD_RW
#define R_DMA_CH9_NEXT__IRD       REG_IRD_RW
#define R_DMA_CH9_NEXT__WR        REG_WR_RW
#define R_DMA_CH9_NEXT__IWR       REG_IWR_RW

#define R_DMA_CH9_NEXT__WRITE(addr,value) \
  (*(addr) = (value))
#define R_DMA_CH9_NEXT__READ(addr) \
  (*(addr))

#define R_DMA_CH9_NEXT__next__next__MASK 0xffffffffU

#define R_DMA_CH9_NEXT__next__MAX 0xffffffff

#define R_DMA_CH9_NEXT__next__MIN 0

#define R_DMA_CH9_NEXT__next__BITNR 0

#define R_DMA_CH9_NEXT__next__next__VAL REG_VAL_VAL


#endif

/*
 *  R_DMA_CH9_STATUS
 *  - type:  RO
 *  - addr:  0xb00001f6
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_DMA_CH9_STATUS__ADDR      (REG_TYPECAST_BYTE  0xb00001f6)
#define R_DMA_CH9_STATUS__SVAL      REG_SVAL_SHADOW
#define R_DMA_CH9_STATUS__SVAL_I    REG_SVAL_I_SHADOW
#define R_DMA_CH9_STATUS__TYPECAST  REG_TYPECAST_BYTE
#define R_DMA_CH9_STATUS__TYPE      (REG_BYTE)
#define R_DMA_CH9_STATUS__GET       REG_GET_RO
#define R_DMA_CH9_STATUS__IGET      REG_IGET_RO
#define R_DMA_CH9_STATUS__SET       REG_SET_RO
#define R_DMA_CH9_STATUS__ISET      REG_ISET_RO
#define R_DMA_CH9_STATUS__SET_VAL   REG_SET_VAL_RO
#define R_DMA_CH9_STATUS__EQL       REG_EQL_RO
#define R_DMA_CH9_STATUS__IEQL      REG_IEQL_RO
#define R_DMA_CH9_STATUS__RD        REG_RD_RO
#define R_DMA_CH9_STATUS__IRD       REG_IRD_RO
#define R_DMA_CH9_STATUS__WR        REG_WR_RO
#define R_DMA_CH9_STATUS__IWR       REG_IWR_RO

#define R_DMA_CH9_STATUS__READ(addr) \
  (*(addr))

#define R_DMA_CH9_STATUS__avail__avail__MASK 0x0000007fU

#define R_DMA_CH9_STATUS__avail__MAX 0x7f

#define R_DMA_CH9_STATUS__avail__MIN 0

#define R_DMA_CH9_STATUS__avail__BITNR 0

#define R_DMA_CH9_STATUS__avail__avail__VAL REG_VAL_VAL


#endif

/*
 *  R_DRAM_CONFIG
 *  - type:  WO
 *  - addr:  0xb000000c
 *  - group: Bus interface configuration registers
 */

#if USE_GROUP__Bus_interface_configuration_registers

#define R_DRAM_CONFIG__ADDR      (REG_TYPECAST_UDWORD  0xb000000c)

#ifndef REG_NO_SHADOW
#define R_DRAM_CONFIG__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_DRAM_CONFIG + 0))
#define R_DRAM_CONFIG__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_DRAM_CONFIG + 0))
#else /* REG_NO_SHADOW */
#define R_DRAM_CONFIG__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_DRAM_CONFIG__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_DRAM_CONFIG__STYPECAST REG_STYPECAST_UDWORD
#define R_DRAM_CONFIG__SVAL      REG_SVAL_SHADOW
#define R_DRAM_CONFIG__SVAL_I    REG_SVAL_I_SHADOW
#define R_DRAM_CONFIG__TYPECAST  REG_TYPECAST_UDWORD
#define R_DRAM_CONFIG__TYPE      (REG_UDWORD)
#define R_DRAM_CONFIG__GET       REG_GET_WO
#define R_DRAM_CONFIG__IGET      REG_IGET_WO
#define R_DRAM_CONFIG__SET       REG_SET_WO
#define R_DRAM_CONFIG__ISET      REG_ISET_WO
#define R_DRAM_CONFIG__SET_VAL   REG_SET_VAL_WO
#define R_DRAM_CONFIG__EQL       REG_EQL_WO
#define R_DRAM_CONFIG__IEQL      REG_IEQL_WO
#define R_DRAM_CONFIG__RD        REG_RD_WO
#define R_DRAM_CONFIG__IRD       REG_IRD_WO
#define R_DRAM_CONFIG__WR        REG_WR_WO
#define R_DRAM_CONFIG__IWR       REG_IWR_WO

#define R_DRAM_CONFIG__WRITE(addr,value) \
  (*(addr) = (value))

#define R_DRAM_CONFIG__wmm1__wmm1__MASK 0x80000000U
#define R_DRAM_CONFIG__wmm0__wmm0__MASK 0x40000000U
#define R_DRAM_CONFIG__sh1__sh1__MASK 0x38000000U
#define R_DRAM_CONFIG__sh0__sh0__MASK 0x07000000U
#define R_DRAM_CONFIG__w__w__MASK 0x00800000U
#define R_DRAM_CONFIG__c__c__MASK 0x00400000U
#define R_DRAM_CONFIG__e__e__MASK 0x00200000U
#define R_DRAM_CONFIG__group_sel__group_sel__MASK 0x001f0000U
#define R_DRAM_CONFIG__ca1__ca1__MASK 0x0000e000U
#define R_DRAM_CONFIG__bank23sel__bank23sel__MASK 0x00001f00U
#define R_DRAM_CONFIG__ca0__ca0__MASK 0x000000e0U
#define R_DRAM_CONFIG__bank01sel__bank01sel__MASK 0x0000001fU

#define R_DRAM_CONFIG__wmm1__MAX 0x1
#define R_DRAM_CONFIG__wmm0__MAX 0x1
#define R_DRAM_CONFIG__sh1__MAX 7
#define R_DRAM_CONFIG__sh0__MAX 7
#define R_DRAM_CONFIG__w__MAX 0x1
#define R_DRAM_CONFIG__c__MAX 0x1
#define R_DRAM_CONFIG__e__MAX 0x1
#define R_DRAM_CONFIG__group_sel__MAX 0x1f
#define R_DRAM_CONFIG__ca1__MAX 7
#define R_DRAM_CONFIG__bank23sel__MAX 0x1f
#define R_DRAM_CONFIG__ca0__MAX 7
#define R_DRAM_CONFIG__bank01sel__MAX 0x1f

#define R_DRAM_CONFIG__wmm1__MIN 0
#define R_DRAM_CONFIG__wmm0__MIN 0
#define R_DRAM_CONFIG__sh1__MIN 0
#define R_DRAM_CONFIG__sh0__MIN 0
#define R_DRAM_CONFIG__w__MIN 0
#define R_DRAM_CONFIG__c__MIN 0
#define R_DRAM_CONFIG__e__MIN 0
#define R_DRAM_CONFIG__group_sel__MIN 0
#define R_DRAM_CONFIG__ca1__MIN 0
#define R_DRAM_CONFIG__bank23sel__MIN 0
#define R_DRAM_CONFIG__ca0__MIN 0
#define R_DRAM_CONFIG__bank01sel__MIN 0

#define R_DRAM_CONFIG__wmm1__BITNR 31
#define R_DRAM_CONFIG__wmm0__BITNR 30
#define R_DRAM_CONFIG__sh1__BITNR 27
#define R_DRAM_CONFIG__sh0__BITNR 24
#define R_DRAM_CONFIG__w__BITNR 23
#define R_DRAM_CONFIG__c__BITNR 22
#define R_DRAM_CONFIG__e__BITNR 21
#define R_DRAM_CONFIG__group_sel__BITNR 16
#define R_DRAM_CONFIG__ca1__BITNR 13
#define R_DRAM_CONFIG__bank23sel__BITNR 8
#define R_DRAM_CONFIG__ca0__BITNR 5
#define R_DRAM_CONFIG__bank01sel__BITNR 0

#define R_DRAM_CONFIG__wmm1__wmm1__VAL REG_VAL_ENUM
#define R_DRAM_CONFIG__wmm0__wmm0__VAL REG_VAL_ENUM
#define R_DRAM_CONFIG__sh1__sh1__VAL REG_VAL_VAL
#define R_DRAM_CONFIG__sh0__sh0__VAL REG_VAL_VAL
#define R_DRAM_CONFIG__w__w__VAL REG_VAL_ENUM
#define R_DRAM_CONFIG__c__c__VAL REG_VAL_ENUM
#define R_DRAM_CONFIG__e__e__VAL REG_VAL_ENUM
#define R_DRAM_CONFIG__group_sel__group_sel__VAL REG_VAL_ENUM
#define R_DRAM_CONFIG__ca1__ca1__VAL REG_VAL_VAL
#define R_DRAM_CONFIG__bank23sel__bank23sel__VAL REG_VAL_ENUM
#define R_DRAM_CONFIG__ca0__ca0__VAL REG_VAL_VAL
#define R_DRAM_CONFIG__bank01sel__bank01sel__VAL REG_VAL_ENUM

#define R_DRAM_CONFIG__wmm1__wmm1__norm 0
#define R_DRAM_CONFIG__wmm1__wmm1__wmm 1
#define R_DRAM_CONFIG__wmm0__wmm0__norm 0
#define R_DRAM_CONFIG__wmm0__wmm0__wmm 1
#define R_DRAM_CONFIG__w__w__bw16 0
#define R_DRAM_CONFIG__w__w__bw32 1
#define R_DRAM_CONFIG__c__c__bank 1
#define R_DRAM_CONFIG__c__c__byte 0
#define R_DRAM_CONFIG__e__e__edo 1
#define R_DRAM_CONFIG__e__e__fast 0
#define R_DRAM_CONFIG__group_sel__group_sel__bit10 10
#define R_DRAM_CONFIG__group_sel__group_sel__bit11 11
#define R_DRAM_CONFIG__group_sel__group_sel__bit12 12
#define R_DRAM_CONFIG__group_sel__group_sel__bit13 13
#define R_DRAM_CONFIG__group_sel__group_sel__bit14 14
#define R_DRAM_CONFIG__group_sel__group_sel__bit15 15
#define R_DRAM_CONFIG__group_sel__group_sel__bit16 16
#define R_DRAM_CONFIG__group_sel__group_sel__bit17 17
#define R_DRAM_CONFIG__group_sel__group_sel__bit18 18
#define R_DRAM_CONFIG__group_sel__group_sel__bit19 19
#define R_DRAM_CONFIG__group_sel__group_sel__bit20 20
#define R_DRAM_CONFIG__group_sel__group_sel__bit21 21
#define R_DRAM_CONFIG__group_sel__group_sel__bit22 22
#define R_DRAM_CONFIG__group_sel__group_sel__bit23 23
#define R_DRAM_CONFIG__group_sel__group_sel__bit24 24
#define R_DRAM_CONFIG__group_sel__group_sel__bit25 25
#define R_DRAM_CONFIG__group_sel__group_sel__bit26 26
#define R_DRAM_CONFIG__group_sel__group_sel__bit27 27
#define R_DRAM_CONFIG__group_sel__group_sel__bit28 28
#define R_DRAM_CONFIG__group_sel__group_sel__bit29 29
#define R_DRAM_CONFIG__group_sel__group_sel__bit9 9
#define R_DRAM_CONFIG__group_sel__group_sel__grp0 0
#define R_DRAM_CONFIG__group_sel__group_sel__grp1 1
#define R_DRAM_CONFIG__bank23sel__bank23sel__bank0 0
#define R_DRAM_CONFIG__bank23sel__bank23sel__bank1 1
#define R_DRAM_CONFIG__bank23sel__bank23sel__bit10 10
#define R_DRAM_CONFIG__bank23sel__bank23sel__bit11 11
#define R_DRAM_CONFIG__bank23sel__bank23sel__bit12 12
#define R_DRAM_CONFIG__bank23sel__bank23sel__bit13 13
#define R_DRAM_CONFIG__bank23sel__bank23sel__bit14 14
#define R_DRAM_CONFIG__bank23sel__bank23sel__bit15 15
#define R_DRAM_CONFIG__bank23sel__bank23sel__bit16 16
#define R_DRAM_CONFIG__bank23sel__bank23sel__bit17 17
#define R_DRAM_CONFIG__bank23sel__bank23sel__bit18 18
#define R_DRAM_CONFIG__bank23sel__bank23sel__bit19 19
#define R_DRAM_CONFIG__bank23sel__bank23sel__bit20 20
#define R_DRAM_CONFIG__bank23sel__bank23sel__bit21 21
#define R_DRAM_CONFIG__bank23sel__bank23sel__bit22 22
#define R_DRAM_CONFIG__bank23sel__bank23sel__bit23 23
#define R_DRAM_CONFIG__bank23sel__bank23sel__bit24 24
#define R_DRAM_CONFIG__bank23sel__bank23sel__bit25 25
#define R_DRAM_CONFIG__bank23sel__bank23sel__bit26 26
#define R_DRAM_CONFIG__bank23sel__bank23sel__bit27 27
#define R_DRAM_CONFIG__bank23sel__bank23sel__bit28 28
#define R_DRAM_CONFIG__bank23sel__bank23sel__bit29 29
#define R_DRAM_CONFIG__bank23sel__bank23sel__bit9 9
#define R_DRAM_CONFIG__bank01sel__bank01sel__bank0 0
#define R_DRAM_CONFIG__bank01sel__bank01sel__bank1 1
#define R_DRAM_CONFIG__bank01sel__bank01sel__bit10 10
#define R_DRAM_CONFIG__bank01sel__bank01sel__bit11 11
#define R_DRAM_CONFIG__bank01sel__bank01sel__bit12 12
#define R_DRAM_CONFIG__bank01sel__bank01sel__bit13 13
#define R_DRAM_CONFIG__bank01sel__bank01sel__bit14 14
#define R_DRAM_CONFIG__bank01sel__bank01sel__bit15 15
#define R_DRAM_CONFIG__bank01sel__bank01sel__bit16 16
#define R_DRAM_CONFIG__bank01sel__bank01sel__bit17 17
#define R_DRAM_CONFIG__bank01sel__bank01sel__bit18 18
#define R_DRAM_CONFIG__bank01sel__bank01sel__bit19 19
#define R_DRAM_CONFIG__bank01sel__bank01sel__bit20 20
#define R_DRAM_CONFIG__bank01sel__bank01sel__bit21 21
#define R_DRAM_CONFIG__bank01sel__bank01sel__bit22 22
#define R_DRAM_CONFIG__bank01sel__bank01sel__bit23 23
#define R_DRAM_CONFIG__bank01sel__bank01sel__bit24 24
#define R_DRAM_CONFIG__bank01sel__bank01sel__bit25 25
#define R_DRAM_CONFIG__bank01sel__bank01sel__bit26 26
#define R_DRAM_CONFIG__bank01sel__bank01sel__bit27 27
#define R_DRAM_CONFIG__bank01sel__bank01sel__bit28 28
#define R_DRAM_CONFIG__bank01sel__bank01sel__bit29 29
#define R_DRAM_CONFIG__bank01sel__bank01sel__bit9 9

#endif

/*
 *  R_DRAM_TIMING
 *  - type:  WO
 *  - addr:  0xb0000008
 *  - group: Bus interface configuration registers
 */

#if USE_GROUP__Bus_interface_configuration_registers

#define R_DRAM_TIMING__ADDR      (REG_TYPECAST_UDWORD  0xb0000008)

#ifndef REG_NO_SHADOW
#define R_DRAM_TIMING__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_DRAM_TIMING + 0))
#define R_DRAM_TIMING__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_DRAM_TIMING + 0))
#else /* REG_NO_SHADOW */
#define R_DRAM_TIMING__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_DRAM_TIMING__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_DRAM_TIMING__STYPECAST REG_STYPECAST_UDWORD
#define R_DRAM_TIMING__SVAL      REG_SVAL_SHADOW
#define R_DRAM_TIMING__SVAL_I    REG_SVAL_I_SHADOW
#define R_DRAM_TIMING__TYPECAST  REG_TYPECAST_UDWORD
#define R_DRAM_TIMING__TYPE      (REG_UDWORD)
#define R_DRAM_TIMING__GET       REG_GET_WO
#define R_DRAM_TIMING__IGET      REG_IGET_WO
#define R_DRAM_TIMING__SET       REG_SET_WO
#define R_DRAM_TIMING__ISET      REG_ISET_WO
#define R_DRAM_TIMING__SET_VAL   REG_SET_VAL_WO
#define R_DRAM_TIMING__EQL       REG_EQL_WO
#define R_DRAM_TIMING__IEQL      REG_IEQL_WO
#define R_DRAM_TIMING__RD        REG_RD_WO
#define R_DRAM_TIMING__IRD       REG_IRD_WO
#define R_DRAM_TIMING__WR        REG_WR_WO
#define R_DRAM_TIMING__IWR       REG_IWR_WO

#define R_DRAM_TIMING__WRITE(addr,value) \
  (*(addr) = (value))

#define R_DRAM_TIMING__sdram__sdram__MASK 0x80000000U
#define R_DRAM_TIMING__ref__ref__MASK 0x0000c000U
#define R_DRAM_TIMING__rp__rp__MASK 0x00003000U
#define R_DRAM_TIMING__rs__rs__MASK 0x00000c00U
#define R_DRAM_TIMING__rh__rh__MASK 0x00000300U
#define R_DRAM_TIMING__w__w__MASK 0x00000080U
#define R_DRAM_TIMING__c__c__MASK 0x00000040U
#define R_DRAM_TIMING__cz__cz__MASK 0x00000030U
#define R_DRAM_TIMING__cp__cp__MASK 0x0000000cU
#define R_DRAM_TIMING__cw__cw__MASK 0x00000003U

#define R_DRAM_TIMING__sdram__MAX 0x1
#define R_DRAM_TIMING__ref__MAX 0x3
#define R_DRAM_TIMING__rp__MAX 3
#define R_DRAM_TIMING__rs__MAX 3
#define R_DRAM_TIMING__rh__MAX 3
#define R_DRAM_TIMING__w__MAX 0x1
#define R_DRAM_TIMING__c__MAX 0x1
#define R_DRAM_TIMING__cz__MAX 3
#define R_DRAM_TIMING__cp__MAX 3
#define R_DRAM_TIMING__cw__MAX 3

#define R_DRAM_TIMING__sdram__MIN 0
#define R_DRAM_TIMING__ref__MIN 0
#define R_DRAM_TIMING__rp__MIN 0
#define R_DRAM_TIMING__rs__MIN 0
#define R_DRAM_TIMING__rh__MIN 0
#define R_DRAM_TIMING__w__MIN 0
#define R_DRAM_TIMING__c__MIN 0
#define R_DRAM_TIMING__cz__MIN 0
#define R_DRAM_TIMING__cp__MIN 0
#define R_DRAM_TIMING__cw__MIN 0

#define R_DRAM_TIMING__sdram__BITNR 31
#define R_DRAM_TIMING__ref__BITNR 14
#define R_DRAM_TIMING__rp__BITNR 12
#define R_DRAM_TIMING__rs__BITNR 10
#define R_DRAM_TIMING__rh__BITNR 8
#define R_DRAM_TIMING__w__BITNR 7
#define R_DRAM_TIMING__c__BITNR 6
#define R_DRAM_TIMING__cz__BITNR 4
#define R_DRAM_TIMING__cp__BITNR 2
#define R_DRAM_TIMING__cw__BITNR 0

#define R_DRAM_TIMING__sdram__sdram__VAL REG_VAL_ENUM
#define R_DRAM_TIMING__ref__ref__VAL REG_VAL_ENUM
#define R_DRAM_TIMING__rp__rp__VAL REG_VAL_VAL
#define R_DRAM_TIMING__rs__rs__VAL REG_VAL_VAL
#define R_DRAM_TIMING__rh__rh__VAL REG_VAL_VAL
#define R_DRAM_TIMING__w__w__VAL REG_VAL_ENUM
#define R_DRAM_TIMING__c__c__VAL REG_VAL_ENUM
#define R_DRAM_TIMING__cz__cz__VAL REG_VAL_VAL
#define R_DRAM_TIMING__cp__cp__VAL REG_VAL_VAL
#define R_DRAM_TIMING__cw__cw__VAL REG_VAL_VAL

#define R_DRAM_TIMING__sdram__sdram__disable 0
#define R_DRAM_TIMING__sdram__sdram__enable 1
#define R_DRAM_TIMING__ref__ref__disable 3
#define R_DRAM_TIMING__ref__ref__e13us 1
#define R_DRAM_TIMING__ref__ref__e52us 0
#define R_DRAM_TIMING__ref__ref__e8700ns 2
#define R_DRAM_TIMING__w__w__ext 1
#define R_DRAM_TIMING__w__w__norm 0
#define R_DRAM_TIMING__c__c__ext 1
#define R_DRAM_TIMING__c__c__norm 0

#endif

/*
 *  R_EXT_DMA_0_ADDR
 *  - type:  WO
 *  - addr:  0xb0000014
 *  - group: External DMA registers
 */

#if USE_GROUP__External_DMA_registers

#define R_EXT_DMA_0_ADDR__ADDR      (REG_TYPECAST_UDWORD  0xb0000014)

#ifndef REG_NO_SHADOW
#define R_EXT_DMA_0_ADDR__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_EXT_DMA_0_ADDR + 0))
#define R_EXT_DMA_0_ADDR__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_EXT_DMA_0_ADDR + 0))
#else /* REG_NO_SHADOW */
#define R_EXT_DMA_0_ADDR__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_EXT_DMA_0_ADDR__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_EXT_DMA_0_ADDR__STYPECAST REG_STYPECAST_UDWORD
#define R_EXT_DMA_0_ADDR__SVAL      REG_SVAL_SHADOW
#define R_EXT_DMA_0_ADDR__SVAL_I    REG_SVAL_I_SHADOW
#define R_EXT_DMA_0_ADDR__TYPECAST  REG_TYPECAST_UDWORD
#define R_EXT_DMA_0_ADDR__TYPE      (REG_UDWORD)
#define R_EXT_DMA_0_ADDR__GET       REG_GET_WO
#define R_EXT_DMA_0_ADDR__IGET      REG_IGET_WO
#define R_EXT_DMA_0_ADDR__SET       REG_SET_WO
#define R_EXT_DMA_0_ADDR__ISET      REG_ISET_WO
#define R_EXT_DMA_0_ADDR__SET_VAL   REG_SET_VAL_WO
#define R_EXT_DMA_0_ADDR__EQL       REG_EQL_WO
#define R_EXT_DMA_0_ADDR__IEQL      REG_IEQL_WO
#define R_EXT_DMA_0_ADDR__RD        REG_RD_WO
#define R_EXT_DMA_0_ADDR__IRD       REG_IRD_WO
#define R_EXT_DMA_0_ADDR__WR        REG_WR_WO
#define R_EXT_DMA_0_ADDR__IWR       REG_IWR_WO

#define R_EXT_DMA_0_ADDR__WRITE(addr,value) \
  (*(addr) = (value))

/* From control-file '/n/asic/projects/etrax_ng/include//hwregs.ctrl' */
#define R_EXT_DMA_0_ADDR__FIRST 0
#define R_EXT_DMA_0_ADDR__IOFFSET 8
#define R_EXT_DMA_0_ADDR__LAST 1
#define R_EXT_DMA_0_ADDR__OFFSET 8
#define R_EXT_DMA_0_ADDR__SOFFSET 8
/* end */

#define R_EXT_DMA_0_ADDR__ext0_addr__ext0_addr__MASK 0x3ffffffcU

#define R_EXT_DMA_0_ADDR__ext0_addr__MAX 0xfffffff

#define R_EXT_DMA_0_ADDR__ext0_addr__MIN 0

#define R_EXT_DMA_0_ADDR__ext0_addr__BITNR 2

#define R_EXT_DMA_0_ADDR__ext0_addr__ext0_addr__VAL REG_VAL_VAL


#endif

/*
 *  R_EXT_DMA_0_CMD
 *  - type:  WO
 *  - addr:  0xb0000010
 *  - group: External DMA registers
 */

#if USE_GROUP__External_DMA_registers

#define R_EXT_DMA_0_CMD__ADDR      (REG_TYPECAST_UDWORD  0xb0000010)

#ifndef REG_NO_SHADOW
#define R_EXT_DMA_0_CMD__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_EXT_DMA_0_CMD + 0))
#define R_EXT_DMA_0_CMD__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_EXT_DMA_0_CMD + 0))
#else /* REG_NO_SHADOW */
#define R_EXT_DMA_0_CMD__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_EXT_DMA_0_CMD__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_EXT_DMA_0_CMD__STYPECAST REG_STYPECAST_UDWORD
#define R_EXT_DMA_0_CMD__SVAL      REG_SVAL_SHADOW
#define R_EXT_DMA_0_CMD__SVAL_I    REG_SVAL_I_SHADOW
#define R_EXT_DMA_0_CMD__TYPECAST  REG_TYPECAST_UDWORD
#define R_EXT_DMA_0_CMD__TYPE      (REG_UDWORD)
#define R_EXT_DMA_0_CMD__GET       REG_GET_WO
#define R_EXT_DMA_0_CMD__IGET      REG_IGET_WO
#define R_EXT_DMA_0_CMD__SET       REG_SET_WO
#define R_EXT_DMA_0_CMD__ISET      REG_ISET_WO
#define R_EXT_DMA_0_CMD__SET_VAL   REG_SET_VAL_WO
#define R_EXT_DMA_0_CMD__EQL       REG_EQL_WO
#define R_EXT_DMA_0_CMD__IEQL      REG_IEQL_WO
#define R_EXT_DMA_0_CMD__RD        REG_RD_WO
#define R_EXT_DMA_0_CMD__IRD       REG_IRD_WO
#define R_EXT_DMA_0_CMD__WR        REG_WR_WO
#define R_EXT_DMA_0_CMD__IWR       REG_IWR_WO

#define R_EXT_DMA_0_CMD__WRITE(addr,value) \
  (*(addr) = (value))

/* From control-file '/n/asic/projects/etrax_ng/include//hwregs.ctrl' */
#define R_EXT_DMA_0_CMD__FIRST 0
#define R_EXT_DMA_0_CMD__IOFFSET 8
#define R_EXT_DMA_0_CMD__LAST 1
#define R_EXT_DMA_0_CMD__OFFSET 8
#define R_EXT_DMA_0_CMD__SOFFSET 8
/* end */

#define R_EXT_DMA_0_CMD__cnt__cnt__MASK 0x00800000U
#define R_EXT_DMA_0_CMD__rqpol__rqpol__MASK 0x00400000U
#define R_EXT_DMA_0_CMD__apol__apol__MASK 0x00200000U
#define R_EXT_DMA_0_CMD__rq_ack__rq_ack__MASK 0x00100000U
#define R_EXT_DMA_0_CMD__wid__wid__MASK 0x000c0000U
#define R_EXT_DMA_0_CMD__dir__dir__MASK 0x00020000U
#define R_EXT_DMA_0_CMD__run__run__MASK 0x00010000U
#define R_EXT_DMA_0_CMD__trf_count__trf_count__MASK 0x0000ffffU

#define R_EXT_DMA_0_CMD__cnt__MAX 0x1
#define R_EXT_DMA_0_CMD__rqpol__MAX 0x1
#define R_EXT_DMA_0_CMD__apol__MAX 0x1
#define R_EXT_DMA_0_CMD__rq_ack__MAX 0x1
#define R_EXT_DMA_0_CMD__wid__MAX 0x3
#define R_EXT_DMA_0_CMD__dir__MAX 0x1
#define R_EXT_DMA_0_CMD__run__MAX 0x1
#define R_EXT_DMA_0_CMD__trf_count__MAX 0xffff

#define R_EXT_DMA_0_CMD__cnt__MIN 0
#define R_EXT_DMA_0_CMD__rqpol__MIN 0
#define R_EXT_DMA_0_CMD__apol__MIN 0
#define R_EXT_DMA_0_CMD__rq_ack__MIN 0
#define R_EXT_DMA_0_CMD__wid__MIN 0
#define R_EXT_DMA_0_CMD__dir__MIN 0
#define R_EXT_DMA_0_CMD__run__MIN 0
#define R_EXT_DMA_0_CMD__trf_count__MIN 0

#define R_EXT_DMA_0_CMD__cnt__BITNR 23
#define R_EXT_DMA_0_CMD__rqpol__BITNR 22
#define R_EXT_DMA_0_CMD__apol__BITNR 21
#define R_EXT_DMA_0_CMD__rq_ack__BITNR 20
#define R_EXT_DMA_0_CMD__wid__BITNR 18
#define R_EXT_DMA_0_CMD__dir__BITNR 17
#define R_EXT_DMA_0_CMD__run__BITNR 16
#define R_EXT_DMA_0_CMD__trf_count__BITNR 0

#define R_EXT_DMA_0_CMD__cnt__cnt__VAL REG_VAL_ENUM
#define R_EXT_DMA_0_CMD__rqpol__rqpol__VAL REG_VAL_ENUM
#define R_EXT_DMA_0_CMD__apol__apol__VAL REG_VAL_ENUM
#define R_EXT_DMA_0_CMD__rq_ack__rq_ack__VAL REG_VAL_ENUM
#define R_EXT_DMA_0_CMD__wid__wid__VAL REG_VAL_ENUM
#define R_EXT_DMA_0_CMD__dir__dir__VAL REG_VAL_ENUM
#define R_EXT_DMA_0_CMD__run__run__VAL REG_VAL_ENUM
#define R_EXT_DMA_0_CMD__trf_count__trf_count__VAL REG_VAL_VAL

#define R_EXT_DMA_0_CMD__cnt__cnt__disable 0
#define R_EXT_DMA_0_CMD__cnt__cnt__enable 1
#define R_EXT_DMA_0_CMD__rqpol__rqpol__ahigh 0
#define R_EXT_DMA_0_CMD__rqpol__rqpol__alow 1
#define R_EXT_DMA_0_CMD__apol__apol__ahigh 0
#define R_EXT_DMA_0_CMD__apol__apol__alow 1
#define R_EXT_DMA_0_CMD__rq_ack__rq_ack__burst 0
#define R_EXT_DMA_0_CMD__rq_ack__rq_ack__handsh 1
#define R_EXT_DMA_0_CMD__wid__wid__byte 0
#define R_EXT_DMA_0_CMD__wid__wid__dword 2
#define R_EXT_DMA_0_CMD__wid__wid__word 1
#define R_EXT_DMA_0_CMD__dir__dir__input 0
#define R_EXT_DMA_0_CMD__dir__dir__output 1
#define R_EXT_DMA_0_CMD__run__run__start 1
#define R_EXT_DMA_0_CMD__run__run__stop 0

#endif

/*
 *  R_EXT_DMA_0_STAT
 *  - type:  RO
 *  - addr:  0xb0000010
 *  - group: External DMA registers
 */

#if USE_GROUP__External_DMA_registers

#define R_EXT_DMA_0_STAT__ADDR      (REG_TYPECAST_UDWORD  0xb0000010)
#define R_EXT_DMA_0_STAT__SVAL      REG_SVAL_SHADOW
#define R_EXT_DMA_0_STAT__SVAL_I    REG_SVAL_I_SHADOW
#define R_EXT_DMA_0_STAT__TYPECAST  REG_TYPECAST_UDWORD
#define R_EXT_DMA_0_STAT__TYPE      (REG_UDWORD)
#define R_EXT_DMA_0_STAT__GET       REG_GET_RO
#define R_EXT_DMA_0_STAT__IGET      REG_IGET_RO
#define R_EXT_DMA_0_STAT__SET       REG_SET_RO
#define R_EXT_DMA_0_STAT__ISET      REG_ISET_RO
#define R_EXT_DMA_0_STAT__SET_VAL   REG_SET_VAL_RO
#define R_EXT_DMA_0_STAT__EQL       REG_EQL_RO
#define R_EXT_DMA_0_STAT__IEQL      REG_IEQL_RO
#define R_EXT_DMA_0_STAT__RD        REG_RD_RO
#define R_EXT_DMA_0_STAT__IRD       REG_IRD_RO
#define R_EXT_DMA_0_STAT__WR        REG_WR_RO
#define R_EXT_DMA_0_STAT__IWR       REG_IWR_RO

#define R_EXT_DMA_0_STAT__READ(addr) \
  (*(addr))

/* From control-file '/n/asic/projects/etrax_ng/include//hwregs.ctrl' */
#define R_EXT_DMA_0_STAT__FIRST 0
#define R_EXT_DMA_0_STAT__LAST 1
#define R_EXT_DMA_0_STAT__OFFSET 8
/* end */

#define R_EXT_DMA_0_STAT__run__run__MASK 0x00010000U
#define R_EXT_DMA_0_STAT__trf_count__trf_count__MASK 0x0000ffffU

#define R_EXT_DMA_0_STAT__run__MAX 0x1
#define R_EXT_DMA_0_STAT__trf_count__MAX 0xffff

#define R_EXT_DMA_0_STAT__run__MIN 0
#define R_EXT_DMA_0_STAT__trf_count__MIN 0

#define R_EXT_DMA_0_STAT__run__BITNR 16
#define R_EXT_DMA_0_STAT__trf_count__BITNR 0

#define R_EXT_DMA_0_STAT__run__run__VAL REG_VAL_ENUM
#define R_EXT_DMA_0_STAT__trf_count__trf_count__VAL REG_VAL_VAL

#define R_EXT_DMA_0_STAT__run__run__start 1
#define R_EXT_DMA_0_STAT__run__run__stop 0

#endif

/*
 *  R_EXT_DMA_1_ADDR
 *  - type:  WO
 *  - addr:  0xb000001c
 *  - group: External DMA registers
 */

#if USE_GROUP__External_DMA_registers

#define R_EXT_DMA_1_ADDR__ADDR      (REG_TYPECAST_UDWORD  0xb000001c)

#ifndef REG_NO_SHADOW
#define R_EXT_DMA_1_ADDR__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_EXT_DMA_1_ADDR + 0))
#define R_EXT_DMA_1_ADDR__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_EXT_DMA_1_ADDR + 0))
#else /* REG_NO_SHADOW */
#define R_EXT_DMA_1_ADDR__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_EXT_DMA_1_ADDR__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_EXT_DMA_1_ADDR__STYPECAST REG_STYPECAST_UDWORD
#define R_EXT_DMA_1_ADDR__SVAL      REG_SVAL_SHADOW
#define R_EXT_DMA_1_ADDR__SVAL_I    REG_SVAL_I_SHADOW
#define R_EXT_DMA_1_ADDR__TYPECAST  REG_TYPECAST_UDWORD
#define R_EXT_DMA_1_ADDR__TYPE      (REG_UDWORD)
#define R_EXT_DMA_1_ADDR__GET       REG_GET_WO
#define R_EXT_DMA_1_ADDR__IGET      REG_IGET_WO
#define R_EXT_DMA_1_ADDR__SET       REG_SET_WO
#define R_EXT_DMA_1_ADDR__ISET      REG_ISET_WO
#define R_EXT_DMA_1_ADDR__SET_VAL   REG_SET_VAL_WO
#define R_EXT_DMA_1_ADDR__EQL       REG_EQL_WO
#define R_EXT_DMA_1_ADDR__IEQL      REG_IEQL_WO
#define R_EXT_DMA_1_ADDR__RD        REG_RD_WO
#define R_EXT_DMA_1_ADDR__IRD       REG_IRD_WO
#define R_EXT_DMA_1_ADDR__WR        REG_WR_WO
#define R_EXT_DMA_1_ADDR__IWR       REG_IWR_WO

#define R_EXT_DMA_1_ADDR__WRITE(addr,value) \
  (*(addr) = (value))

#define R_EXT_DMA_1_ADDR__ext0_addr__ext0_addr__MASK 0x3ffffffcU

#define R_EXT_DMA_1_ADDR__ext0_addr__MAX 0xfffffff

#define R_EXT_DMA_1_ADDR__ext0_addr__MIN 0

#define R_EXT_DMA_1_ADDR__ext0_addr__BITNR 2

#define R_EXT_DMA_1_ADDR__ext0_addr__ext0_addr__VAL REG_VAL_VAL


#endif

/*
 *  R_EXT_DMA_1_CMD
 *  - type:  WO
 *  - addr:  0xb0000018
 *  - group: External DMA registers
 */

#if USE_GROUP__External_DMA_registers

#define R_EXT_DMA_1_CMD__ADDR      (REG_TYPECAST_UDWORD  0xb0000018)

#ifndef REG_NO_SHADOW
#define R_EXT_DMA_1_CMD__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_EXT_DMA_1_CMD + 0))
#define R_EXT_DMA_1_CMD__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_EXT_DMA_1_CMD + 0))
#else /* REG_NO_SHADOW */
#define R_EXT_DMA_1_CMD__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_EXT_DMA_1_CMD__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_EXT_DMA_1_CMD__STYPECAST REG_STYPECAST_UDWORD
#define R_EXT_DMA_1_CMD__SVAL      REG_SVAL_SHADOW
#define R_EXT_DMA_1_CMD__SVAL_I    REG_SVAL_I_SHADOW
#define R_EXT_DMA_1_CMD__TYPECAST  REG_TYPECAST_UDWORD
#define R_EXT_DMA_1_CMD__TYPE      (REG_UDWORD)
#define R_EXT_DMA_1_CMD__GET       REG_GET_WO
#define R_EXT_DMA_1_CMD__IGET      REG_IGET_WO
#define R_EXT_DMA_1_CMD__SET       REG_SET_WO
#define R_EXT_DMA_1_CMD__ISET      REG_ISET_WO
#define R_EXT_DMA_1_CMD__SET_VAL   REG_SET_VAL_WO
#define R_EXT_DMA_1_CMD__EQL       REG_EQL_WO
#define R_EXT_DMA_1_CMD__IEQL      REG_IEQL_WO
#define R_EXT_DMA_1_CMD__RD        REG_RD_WO
#define R_EXT_DMA_1_CMD__IRD       REG_IRD_WO
#define R_EXT_DMA_1_CMD__WR        REG_WR_WO
#define R_EXT_DMA_1_CMD__IWR       REG_IWR_WO

#define R_EXT_DMA_1_CMD__WRITE(addr,value) \
  (*(addr) = (value))

#define R_EXT_DMA_1_CMD__cnt__cnt__MASK 0x00800000U
#define R_EXT_DMA_1_CMD__rqpol__rqpol__MASK 0x00400000U
#define R_EXT_DMA_1_CMD__apol__apol__MASK 0x00200000U
#define R_EXT_DMA_1_CMD__rq_ack__rq_ack__MASK 0x00100000U
#define R_EXT_DMA_1_CMD__wid__wid__MASK 0x000c0000U
#define R_EXT_DMA_1_CMD__dir__dir__MASK 0x00020000U
#define R_EXT_DMA_1_CMD__run__run__MASK 0x00010000U
#define R_EXT_DMA_1_CMD__trf_count__trf_count__MASK 0x0000ffffU

#define R_EXT_DMA_1_CMD__cnt__MAX 0x1
#define R_EXT_DMA_1_CMD__rqpol__MAX 0x1
#define R_EXT_DMA_1_CMD__apol__MAX 0x1
#define R_EXT_DMA_1_CMD__rq_ack__MAX 0x1
#define R_EXT_DMA_1_CMD__wid__MAX 0x3
#define R_EXT_DMA_1_CMD__dir__MAX 0x1
#define R_EXT_DMA_1_CMD__run__MAX 0x1
#define R_EXT_DMA_1_CMD__trf_count__MAX 0xffff

#define R_EXT_DMA_1_CMD__cnt__MIN 0
#define R_EXT_DMA_1_CMD__rqpol__MIN 0
#define R_EXT_DMA_1_CMD__apol__MIN 0
#define R_EXT_DMA_1_CMD__rq_ack__MIN 0
#define R_EXT_DMA_1_CMD__wid__MIN 0
#define R_EXT_DMA_1_CMD__dir__MIN 0
#define R_EXT_DMA_1_CMD__run__MIN 0
#define R_EXT_DMA_1_CMD__trf_count__MIN 0

#define R_EXT_DMA_1_CMD__cnt__BITNR 23
#define R_EXT_DMA_1_CMD__rqpol__BITNR 22
#define R_EXT_DMA_1_CMD__apol__BITNR 21
#define R_EXT_DMA_1_CMD__rq_ack__BITNR 20
#define R_EXT_DMA_1_CMD__wid__BITNR 18
#define R_EXT_DMA_1_CMD__dir__BITNR 17
#define R_EXT_DMA_1_CMD__run__BITNR 16
#define R_EXT_DMA_1_CMD__trf_count__BITNR 0

#define R_EXT_DMA_1_CMD__cnt__cnt__VAL REG_VAL_ENUM
#define R_EXT_DMA_1_CMD__rqpol__rqpol__VAL REG_VAL_ENUM
#define R_EXT_DMA_1_CMD__apol__apol__VAL REG_VAL_ENUM
#define R_EXT_DMA_1_CMD__rq_ack__rq_ack__VAL REG_VAL_ENUM
#define R_EXT_DMA_1_CMD__wid__wid__VAL REG_VAL_ENUM
#define R_EXT_DMA_1_CMD__dir__dir__VAL REG_VAL_ENUM
#define R_EXT_DMA_1_CMD__run__run__VAL REG_VAL_ENUM
#define R_EXT_DMA_1_CMD__trf_count__trf_count__VAL REG_VAL_VAL

#define R_EXT_DMA_1_CMD__cnt__cnt__disable 0
#define R_EXT_DMA_1_CMD__cnt__cnt__enable 1
#define R_EXT_DMA_1_CMD__rqpol__rqpol__ahigh 0
#define R_EXT_DMA_1_CMD__rqpol__rqpol__alow 1
#define R_EXT_DMA_1_CMD__apol__apol__ahigh 0
#define R_EXT_DMA_1_CMD__apol__apol__alow 1
#define R_EXT_DMA_1_CMD__rq_ack__rq_ack__burst 0
#define R_EXT_DMA_1_CMD__rq_ack__rq_ack__handsh 1
#define R_EXT_DMA_1_CMD__wid__wid__byte 0
#define R_EXT_DMA_1_CMD__wid__wid__dword 2
#define R_EXT_DMA_1_CMD__wid__wid__word 1
#define R_EXT_DMA_1_CMD__dir__dir__input 0
#define R_EXT_DMA_1_CMD__dir__dir__output 1
#define R_EXT_DMA_1_CMD__run__run__start 1
#define R_EXT_DMA_1_CMD__run__run__stop 0

#endif

/*
 *  R_EXT_DMA_1_STAT
 *  - type:  RO
 *  - addr:  0xb0000018
 *  - group: External DMA registers
 */

#if USE_GROUP__External_DMA_registers

#define R_EXT_DMA_1_STAT__ADDR      (REG_TYPECAST_UDWORD  0xb0000018)
#define R_EXT_DMA_1_STAT__SVAL      REG_SVAL_SHADOW
#define R_EXT_DMA_1_STAT__SVAL_I    REG_SVAL_I_SHADOW
#define R_EXT_DMA_1_STAT__TYPECAST  REG_TYPECAST_UDWORD
#define R_EXT_DMA_1_STAT__TYPE      (REG_UDWORD)
#define R_EXT_DMA_1_STAT__GET       REG_GET_RO
#define R_EXT_DMA_1_STAT__IGET      REG_IGET_RO
#define R_EXT_DMA_1_STAT__SET       REG_SET_RO
#define R_EXT_DMA_1_STAT__ISET      REG_ISET_RO
#define R_EXT_DMA_1_STAT__SET_VAL   REG_SET_VAL_RO
#define R_EXT_DMA_1_STAT__EQL       REG_EQL_RO
#define R_EXT_DMA_1_STAT__IEQL      REG_IEQL_RO
#define R_EXT_DMA_1_STAT__RD        REG_RD_RO
#define R_EXT_DMA_1_STAT__IRD       REG_IRD_RO
#define R_EXT_DMA_1_STAT__WR        REG_WR_RO
#define R_EXT_DMA_1_STAT__IWR       REG_IWR_RO

#define R_EXT_DMA_1_STAT__READ(addr) \
  (*(addr))

#define R_EXT_DMA_1_STAT__run__run__MASK 0x00010000U
#define R_EXT_DMA_1_STAT__trf_count__trf_count__MASK 0x0000ffffU

#define R_EXT_DMA_1_STAT__run__MAX 0x1
#define R_EXT_DMA_1_STAT__trf_count__MAX 0xffff

#define R_EXT_DMA_1_STAT__run__MIN 0
#define R_EXT_DMA_1_STAT__trf_count__MIN 0

#define R_EXT_DMA_1_STAT__run__BITNR 16
#define R_EXT_DMA_1_STAT__trf_count__BITNR 0

#define R_EXT_DMA_1_STAT__run__run__VAL REG_VAL_ENUM
#define R_EXT_DMA_1_STAT__trf_count__trf_count__VAL REG_VAL_VAL

#define R_EXT_DMA_1_STAT__run__run__start 1
#define R_EXT_DMA_1_STAT__run__run__stop 0

#endif

/*
 *  R_GEN_CONFIG
 *  - type:  WO
 *  - addr:  0xb000002c
 *  - group: General config registers
 */

#if USE_GROUP__General_config_registers

#define R_GEN_CONFIG__ADDR      (REG_TYPECAST_UDWORD  0xb000002c)

#ifndef REG_NO_SHADOW
#define R_GEN_CONFIG__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_GEN_CONFIG + 0))
#define R_GEN_CONFIG__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_GEN_CONFIG + 0))
#else /* REG_NO_SHADOW */
#define R_GEN_CONFIG__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_GEN_CONFIG__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_GEN_CONFIG__STYPECAST REG_STYPECAST_UDWORD
#define R_GEN_CONFIG__SVAL      REG_SVAL_SHADOW
#define R_GEN_CONFIG__SVAL_I    REG_SVAL_I_SHADOW
#define R_GEN_CONFIG__TYPECAST  REG_TYPECAST_UDWORD
#define R_GEN_CONFIG__TYPE      (REG_UDWORD)
#define R_GEN_CONFIG__GET       REG_GET_WO
#define R_GEN_CONFIG__IGET      REG_IGET_WO
#define R_GEN_CONFIG__SET       REG_SET_WO
#define R_GEN_CONFIG__ISET      REG_ISET_WO
#define R_GEN_CONFIG__SET_VAL   REG_SET_VAL_WO
#define R_GEN_CONFIG__EQL       REG_EQL_WO
#define R_GEN_CONFIG__IEQL      REG_IEQL_WO
#define R_GEN_CONFIG__RD        REG_RD_WO
#define R_GEN_CONFIG__IRD       REG_IRD_WO
#define R_GEN_CONFIG__WR        REG_WR_WO
#define R_GEN_CONFIG__IWR       REG_IWR_WO

#define R_GEN_CONFIG__WRITE(addr,value) \
  (*(addr) = (value))

#define R_GEN_CONFIG__par_w__par_w__MASK 0x80000000U
#define R_GEN_CONFIG__usb2__usb2__MASK 0x40000000U
#define R_GEN_CONFIG__usb1__usb1__MASK 0x20000000U
#define R_GEN_CONFIG__g24dir__g24dir__MASK 0x08000000U
#define R_GEN_CONFIG__g16_23dir__g16_23dir__MASK 0x04000000U
#define R_GEN_CONFIG__g16_20dir__g16_20dir__MASK 0x04000000U
#define R_GEN_CONFIG__g16_23dir__g16_20dir__MASK 0x04000000U
#define R_GEN_CONFIG__g8_15dir__g8_15dir__MASK 0x02000000U
#define R_GEN_CONFIG__g0dir__g0dir__MASK 0x01000000U
#define R_GEN_CONFIG__dma9__dma9__MASK 0x00800000U
#define R_GEN_CONFIG__dma8__dma8__MASK 0x00400000U
#define R_GEN_CONFIG__dma7__dma7__MASK 0x00300000U
#define R_GEN_CONFIG__dma6__dma6__MASK 0x000c0000U
#define R_GEN_CONFIG__dma5__dma5__MASK 0x00030000U
#define R_GEN_CONFIG__dma4__dma4__MASK 0x0000c000U
#define R_GEN_CONFIG__dma3__dma3__MASK 0x00003000U
#define R_GEN_CONFIG__dma2__dma2__MASK 0x00000c00U
#define R_GEN_CONFIG__mio_w__mio_w__MASK 0x00000200U
#define R_GEN_CONFIG__ser3__ser3__MASK 0x00000100U
#define R_GEN_CONFIG__par1__par1__MASK 0x00000080U
#define R_GEN_CONFIG__scsi0w__scsi0w__MASK 0x00000040U
#define R_GEN_CONFIG__scsi1__scsi1__MASK 0x00000020U
#define R_GEN_CONFIG__mio__mio__MASK 0x00000010U
#define R_GEN_CONFIG__ser2__ser2__MASK 0x00000008U
#define R_GEN_CONFIG__par0__par0__MASK 0x00000004U
#define R_GEN_CONFIG__ata__ata__MASK 0x00000002U
#define R_GEN_CONFIG__scsi0__scsi0__MASK 0x00000001U

#define R_GEN_CONFIG__par_w__MAX 0x1
#define R_GEN_CONFIG__usb2__MAX 0x1
#define R_GEN_CONFIG__usb1__MAX 0x1
#define R_GEN_CONFIG__g24dir__MAX 0x1
#define R_GEN_CONFIG__g16_23dir__MAX 0x1
#define R_GEN_CONFIG__g16_20dir__MAX 0x1
#define R_GEN_CONFIG__g8_15dir__MAX 0x1
#define R_GEN_CONFIG__g0dir__MAX 0x1
#define R_GEN_CONFIG__dma9__MAX 0x1
#define R_GEN_CONFIG__dma8__MAX 0x1
#define R_GEN_CONFIG__dma7__MAX 0x3
#define R_GEN_CONFIG__dma6__MAX 0x3
#define R_GEN_CONFIG__dma5__MAX 0x3
#define R_GEN_CONFIG__dma4__MAX 0x3
#define R_GEN_CONFIG__dma3__MAX 0x3
#define R_GEN_CONFIG__dma2__MAX 0x3
#define R_GEN_CONFIG__mio_w__MAX 0x1
#define R_GEN_CONFIG__ser3__MAX 0x1
#define R_GEN_CONFIG__par1__MAX 0x1
#define R_GEN_CONFIG__scsi0w__MAX 0x1
#define R_GEN_CONFIG__scsi1__MAX 0x1
#define R_GEN_CONFIG__mio__MAX 0x1
#define R_GEN_CONFIG__ser2__MAX 0x1
#define R_GEN_CONFIG__par0__MAX 0x1
#define R_GEN_CONFIG__ata__MAX 0x1
#define R_GEN_CONFIG__scsi0__MAX 0x1

#define R_GEN_CONFIG__par_w__MIN 0
#define R_GEN_CONFIG__usb2__MIN 0
#define R_GEN_CONFIG__usb1__MIN 0
#define R_GEN_CONFIG__g24dir__MIN 0
#define R_GEN_CONFIG__g16_23dir__MIN 0
#define R_GEN_CONFIG__g16_20dir__MIN 0
#define R_GEN_CONFIG__g8_15dir__MIN 0
#define R_GEN_CONFIG__g0dir__MIN 0
#define R_GEN_CONFIG__dma9__MIN 0
#define R_GEN_CONFIG__dma8__MIN 0
#define R_GEN_CONFIG__dma7__MIN 0
#define R_GEN_CONFIG__dma6__MIN 0
#define R_GEN_CONFIG__dma5__MIN 0
#define R_GEN_CONFIG__dma4__MIN 0
#define R_GEN_CONFIG__dma3__MIN 0
#define R_GEN_CONFIG__dma2__MIN 0
#define R_GEN_CONFIG__mio_w__MIN 0
#define R_GEN_CONFIG__ser3__MIN 0
#define R_GEN_CONFIG__par1__MIN 0
#define R_GEN_CONFIG__scsi0w__MIN 0
#define R_GEN_CONFIG__scsi1__MIN 0
#define R_GEN_CONFIG__mio__MIN 0
#define R_GEN_CONFIG__ser2__MIN 0
#define R_GEN_CONFIG__par0__MIN 0
#define R_GEN_CONFIG__ata__MIN 0
#define R_GEN_CONFIG__scsi0__MIN 0

#define R_GEN_CONFIG__par_w__BITNR 31
#define R_GEN_CONFIG__usb2__BITNR 30
#define R_GEN_CONFIG__usb1__BITNR 29
#define R_GEN_CONFIG__g24dir__BITNR 27
#define R_GEN_CONFIG__g16_23dir__BITNR 26
#define R_GEN_CONFIG__g16_20dir__BITNR 26
#define R_GEN_CONFIG__g8_15dir__BITNR 25
#define R_GEN_CONFIG__g0dir__BITNR 24
#define R_GEN_CONFIG__dma9__BITNR 23
#define R_GEN_CONFIG__dma8__BITNR 22
#define R_GEN_CONFIG__dma7__BITNR 20
#define R_GEN_CONFIG__dma6__BITNR 18
#define R_GEN_CONFIG__dma5__BITNR 16
#define R_GEN_CONFIG__dma4__BITNR 14
#define R_GEN_CONFIG__dma3__BITNR 12
#define R_GEN_CONFIG__dma2__BITNR 10
#define R_GEN_CONFIG__mio_w__BITNR 9
#define R_GEN_CONFIG__ser3__BITNR 8
#define R_GEN_CONFIG__par1__BITNR 7
#define R_GEN_CONFIG__scsi0w__BITNR 6
#define R_GEN_CONFIG__scsi1__BITNR 5
#define R_GEN_CONFIG__mio__BITNR 4
#define R_GEN_CONFIG__ser2__BITNR 3
#define R_GEN_CONFIG__par0__BITNR 2
#define R_GEN_CONFIG__ata__BITNR 1
#define R_GEN_CONFIG__scsi0__BITNR 0

#define R_GEN_CONFIG__par_w__par_w__VAL REG_VAL_ENUM
#define R_GEN_CONFIG__usb2__usb2__VAL REG_VAL_ENUM
#define R_GEN_CONFIG__usb1__usb1__VAL REG_VAL_ENUM
#define R_GEN_CONFIG__g24dir__g24dir__VAL REG_VAL_ENUM
#define R_GEN_CONFIG__g16_23dir__g16_23dir__VAL REG_VAL_ENUM
#define R_GEN_CONFIG__g16_20dir__g16_20dir__VAL REG_VAL_ENUM
#define R_GEN_CONFIG__g16_23dir__g16_20dir__VAL REG_VAL_ENUM
#define R_GEN_CONFIG__g8_15dir__g8_15dir__VAL REG_VAL_ENUM
#define R_GEN_CONFIG__g0dir__g0dir__VAL REG_VAL_ENUM
#define R_GEN_CONFIG__dma9__dma9__VAL REG_VAL_ENUM
#define R_GEN_CONFIG__dma8__dma8__VAL REG_VAL_ENUM
#define R_GEN_CONFIG__dma7__dma7__VAL REG_VAL_ENUM
#define R_GEN_CONFIG__dma6__dma6__VAL REG_VAL_ENUM
#define R_GEN_CONFIG__dma5__dma5__VAL REG_VAL_ENUM
#define R_GEN_CONFIG__dma4__dma4__VAL REG_VAL_ENUM
#define R_GEN_CONFIG__dma3__dma3__VAL REG_VAL_ENUM
#define R_GEN_CONFIG__dma2__dma2__VAL REG_VAL_ENUM
#define R_GEN_CONFIG__mio_w__mio_w__VAL REG_VAL_ENUM
#define R_GEN_CONFIG__ser3__ser3__VAL REG_VAL_ENUM
#define R_GEN_CONFIG__par1__par1__VAL REG_VAL_ENUM
#define R_GEN_CONFIG__scsi0w__scsi0w__VAL REG_VAL_ENUM
#define R_GEN_CONFIG__scsi1__scsi1__VAL REG_VAL_ENUM
#define R_GEN_CONFIG__mio__mio__VAL REG_VAL_ENUM
#define R_GEN_CONFIG__ser2__ser2__VAL REG_VAL_ENUM
#define R_GEN_CONFIG__par0__par0__VAL REG_VAL_ENUM
#define R_GEN_CONFIG__ata__ata__VAL REG_VAL_ENUM
#define R_GEN_CONFIG__scsi0__scsi0__VAL REG_VAL_ENUM

#define R_GEN_CONFIG__par_w__par_w__disable 0
#define R_GEN_CONFIG__par_w__par_w__select 1
#define R_GEN_CONFIG__usb2__usb2__disable 0
#define R_GEN_CONFIG__usb2__usb2__select 1
#define R_GEN_CONFIG__usb1__usb1__disable 0
#define R_GEN_CONFIG__usb1__usb1__select 1
#define R_GEN_CONFIG__g24dir__g24dir__in 0
#define R_GEN_CONFIG__g24dir__g24dir__out 1
#define R_GEN_CONFIG__g16_23dir__g16_23dir__in 0
#define R_GEN_CONFIG__g16_23dir__g16_23dir__out 1
#define R_GEN_CONFIG__g16_20dir__g16_20dir__in 0
#define R_GEN_CONFIG__g16_20dir__g16_20dir__out 1
#define R_GEN_CONFIG__g8_15dir__g8_15dir__in 0
#define R_GEN_CONFIG__g8_15dir__g8_15dir__out 1
#define R_GEN_CONFIG__g0dir__g0dir__in 0
#define R_GEN_CONFIG__g0dir__g0dir__out 1
#define R_GEN_CONFIG__dma9__dma9__serial1 1
#define R_GEN_CONFIG__dma9__dma9__usb 0
#define R_GEN_CONFIG__dma8__dma8__serial1 1
#define R_GEN_CONFIG__dma8__dma8__usb 0
#define R_GEN_CONFIG__dma7__dma7__extdma1 2
#define R_GEN_CONFIG__dma7__dma7__intdma6 3
#define R_GEN_CONFIG__dma7__dma7__serial0 1
#define R_GEN_CONFIG__dma7__dma7__unused 0
#define R_GEN_CONFIG__dma6__dma6__extdma1 2
#define R_GEN_CONFIG__dma6__dma6__intdma7 3
#define R_GEN_CONFIG__dma6__dma6__serial0 1
#define R_GEN_CONFIG__dma6__dma6__unused 0
#define R_GEN_CONFIG__dma5__dma5__extdma0 3
#define R_GEN_CONFIG__dma5__dma5__par1 0
#define R_GEN_CONFIG__dma5__dma5__scsi1 1
#define R_GEN_CONFIG__dma5__dma5__serial3 2
#define R_GEN_CONFIG__dma4__dma4__extdma0 3
#define R_GEN_CONFIG__dma4__dma4__par1 0
#define R_GEN_CONFIG__dma4__dma4__scsi1 1
#define R_GEN_CONFIG__dma4__dma4__serial3 2
#define R_GEN_CONFIG__dma3__dma3__ata 3
#define R_GEN_CONFIG__dma3__dma3__par0 0
#define R_GEN_CONFIG__dma3__dma3__scsi0 1
#define R_GEN_CONFIG__dma3__dma3__serial2 2
#define R_GEN_CONFIG__dma2__dma2__ata 3
#define R_GEN_CONFIG__dma2__dma2__par0 0
#define R_GEN_CONFIG__dma2__dma2__scsi0 1
#define R_GEN_CONFIG__dma2__dma2__serial2 2
#define R_GEN_CONFIG__mio_w__mio_w__disable 0
#define R_GEN_CONFIG__mio_w__mio_w__select 1
#define R_GEN_CONFIG__ser3__ser3__disable 0
#define R_GEN_CONFIG__ser3__ser3__select 1
#define R_GEN_CONFIG__par1__par1__disable 0
#define R_GEN_CONFIG__par1__par1__select 1
#define R_GEN_CONFIG__scsi0w__scsi0w__disable 0
#define R_GEN_CONFIG__scsi0w__scsi0w__select 1
#define R_GEN_CONFIG__scsi1__scsi1__disable 0
#define R_GEN_CONFIG__scsi1__scsi1__select 1
#define R_GEN_CONFIG__mio__mio__disable 0
#define R_GEN_CONFIG__mio__mio__select 1
#define R_GEN_CONFIG__ser2__ser2__disable 0
#define R_GEN_CONFIG__ser2__ser2__select 1
#define R_GEN_CONFIG__par0__par0__disable 0
#define R_GEN_CONFIG__par0__par0__select 1
#define R_GEN_CONFIG__ata__ata__disable 0
#define R_GEN_CONFIG__ata__ata__select 1
#define R_GEN_CONFIG__scsi0__scsi0__disable 0
#define R_GEN_CONFIG__scsi0__scsi0__select 1

#endif

/*
 *  R_GEN_CONFIG_II
 *  - type:  WO
 *  - addr:  0xb0000034
 *  - group: General config registers
 */

#if USE_GROUP__General_config_registers

#define R_GEN_CONFIG_II__ADDR      (REG_TYPECAST_UDWORD  0xb0000034)

#ifndef REG_NO_SHADOW
#define R_GEN_CONFIG_II__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_GEN_CONFIG_II + 0))
#define R_GEN_CONFIG_II__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_GEN_CONFIG_II + 0))
#else /* REG_NO_SHADOW */
#define R_GEN_CONFIG_II__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_GEN_CONFIG_II__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_GEN_CONFIG_II__STYPECAST REG_STYPECAST_UDWORD
#define R_GEN_CONFIG_II__SVAL      REG_SVAL_SHADOW
#define R_GEN_CONFIG_II__SVAL_I    REG_SVAL_I_SHADOW
#define R_GEN_CONFIG_II__TYPECAST  REG_TYPECAST_UDWORD
#define R_GEN_CONFIG_II__TYPE      (REG_UDWORD)
#define R_GEN_CONFIG_II__GET       REG_GET_WO
#define R_GEN_CONFIG_II__IGET      REG_IGET_WO
#define R_GEN_CONFIG_II__SET       REG_SET_WO
#define R_GEN_CONFIG_II__ISET      REG_ISET_WO
#define R_GEN_CONFIG_II__SET_VAL   REG_SET_VAL_WO
#define R_GEN_CONFIG_II__EQL       REG_EQL_WO
#define R_GEN_CONFIG_II__IEQL      REG_IEQL_WO
#define R_GEN_CONFIG_II__RD        REG_RD_WO
#define R_GEN_CONFIG_II__IRD       REG_IRD_WO
#define R_GEN_CONFIG_II__WR        REG_WR_WO
#define R_GEN_CONFIG_II__IWR       REG_IWR_WO

#define R_GEN_CONFIG_II__WRITE(addr,value) \
  (*(addr) = (value))

#define R_GEN_CONFIG_II__sermode3__sermode3__MASK 0x00000040U
#define R_GEN_CONFIG_II__sermode1__sermode1__MASK 0x00000010U
#define R_GEN_CONFIG_II__ext_clk__ext_clk__MASK 0x00000004U
#define R_GEN_CONFIG_II__ser3__ser3__MASK 0x00000002U
#define R_GEN_CONFIG_II__ser2__ser2__MASK 0x00000001U

#define R_GEN_CONFIG_II__sermode3__MAX 0x1
#define R_GEN_CONFIG_II__sermode1__MAX 0x1
#define R_GEN_CONFIG_II__ext_clk__MAX 0x1
#define R_GEN_CONFIG_II__ser3__MAX 0x1
#define R_GEN_CONFIG_II__ser2__MAX 0x1

#define R_GEN_CONFIG_II__sermode3__MIN 0
#define R_GEN_CONFIG_II__sermode1__MIN 0
#define R_GEN_CONFIG_II__ext_clk__MIN 0
#define R_GEN_CONFIG_II__ser3__MIN 0
#define R_GEN_CONFIG_II__ser2__MIN 0

#define R_GEN_CONFIG_II__sermode3__BITNR 6
#define R_GEN_CONFIG_II__sermode1__BITNR 4
#define R_GEN_CONFIG_II__ext_clk__BITNR 2
#define R_GEN_CONFIG_II__ser3__BITNR 1
#define R_GEN_CONFIG_II__ser2__BITNR 0

#define R_GEN_CONFIG_II__sermode3__sermode3__VAL REG_VAL_ENUM
#define R_GEN_CONFIG_II__sermode1__sermode1__VAL REG_VAL_ENUM
#define R_GEN_CONFIG_II__ext_clk__ext_clk__VAL REG_VAL_ENUM
#define R_GEN_CONFIG_II__ser3__ser3__VAL REG_VAL_ENUM
#define R_GEN_CONFIG_II__ser2__ser2__VAL REG_VAL_ENUM

#define R_GEN_CONFIG_II__sermode3__sermode3__async 0
#define R_GEN_CONFIG_II__sermode3__sermode3__sync 1
#define R_GEN_CONFIG_II__sermode1__sermode1__async 0
#define R_GEN_CONFIG_II__sermode1__sermode1__sync 1
#define R_GEN_CONFIG_II__ext_clk__ext_clk__disable 0
#define R_GEN_CONFIG_II__ext_clk__ext_clk__select 1
#define R_GEN_CONFIG_II__ser3__ser3__disable 0
#define R_GEN_CONFIG_II__ser3__ser3__select 1
#define R_GEN_CONFIG_II__ser2__ser2__disable 0
#define R_GEN_CONFIG_II__ser2__ser2__select 1

#endif

/*
 *  R_IRQ_MASK0_CLR
 *  - type:  WO
 *  - addr:  0xb00000c0
 *  - group: Interrupt mask and status registers
 */

#if USE_GROUP__Interrupt_mask_and_status_registers

#define R_IRQ_MASK0_CLR__ADDR      (REG_TYPECAST_UDWORD  0xb00000c0)

#ifndef REG_NO_SHADOW
#define R_IRQ_MASK0_CLR__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_IRQ_MASK0_CLR + 0))
#define R_IRQ_MASK0_CLR__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_IRQ_MASK0_CLR + 0))
#else /* REG_NO_SHADOW */
#define R_IRQ_MASK0_CLR__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_IRQ_MASK0_CLR__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_IRQ_MASK0_CLR__STYPECAST REG_STYPECAST_UDWORD
#define R_IRQ_MASK0_CLR__SVAL REG_SVAL_ZERO
#define R_IRQ_MASK0_CLR__SVAL_I REG_SVAL_I_ZERO
#define R_IRQ_MASK0_CLR__TYPECAST  REG_TYPECAST_UDWORD
#define R_IRQ_MASK0_CLR__TYPE      (REG_UDWORD)
#define R_IRQ_MASK0_CLR__GET       REG_GET_WO
#define R_IRQ_MASK0_CLR__IGET      REG_IGET_WO
#define R_IRQ_MASK0_CLR__SET       REG_SET_WO
#define R_IRQ_MASK0_CLR__ISET      REG_ISET_WO
#define R_IRQ_MASK0_CLR__SET_VAL   REG_SET_VAL_WO
#define R_IRQ_MASK0_CLR__EQL       REG_EQL_WO
#define R_IRQ_MASK0_CLR__IEQL      REG_IEQL_WO
#define R_IRQ_MASK0_CLR__RD        REG_RD_WO
#define R_IRQ_MASK0_CLR__IRD       REG_IRD_WO
#define R_IRQ_MASK0_CLR__WR        REG_WR_WO
#define R_IRQ_MASK0_CLR__IWR       REG_IWR_WO

#define R_IRQ_MASK0_CLR__WRITE(addr,value) \
  (*(addr) = (value))

#define R_IRQ_MASK0_CLR__nmi_pin__nmi_pin__MASK 0x80000000U
#define R_IRQ_MASK0_CLR__watchdog_nmi__watchdog_nmi__MASK 0x40000000U
#define R_IRQ_MASK0_CLR__sqe_test_error__sqe_test_error__MASK 0x20000000U
#define R_IRQ_MASK0_CLR__carrier_loss__carrier_loss__MASK 0x10000000U
#define R_IRQ_MASK0_CLR__deferred__deferred__MASK 0x08000000U
#define R_IRQ_MASK0_CLR__late_col__late_col__MASK 0x04000000U
#define R_IRQ_MASK0_CLR__multiple_col__multiple_col__MASK 0x02000000U
#define R_IRQ_MASK0_CLR__single_col__single_col__MASK 0x01000000U
#define R_IRQ_MASK0_CLR__congestion__congestion__MASK 0x00800000U
#define R_IRQ_MASK0_CLR__oversize__oversize__MASK 0x00400000U
#define R_IRQ_MASK0_CLR__alignment_error__alignment_error__MASK 0x00200000U
#define R_IRQ_MASK0_CLR__crc_error__crc_error__MASK 0x00100000U
#define R_IRQ_MASK0_CLR__overrun__overrun__MASK 0x00080000U
#define R_IRQ_MASK0_CLR__underrun__underrun__MASK 0x00040000U
#define R_IRQ_MASK0_CLR__excessive_col__excessive_col__MASK 0x00020000U
#define R_IRQ_MASK0_CLR__mdio__mdio__MASK 0x00010000U
#define R_IRQ_MASK0_CLR__ata_drq3__ata_drq3__MASK 0x00008000U
#define R_IRQ_MASK0_CLR__ata_drq2__ata_drq2__MASK 0x00004000U
#define R_IRQ_MASK0_CLR__ata_drq1__ata_drq1__MASK 0x00002000U
#define R_IRQ_MASK0_CLR__ata_drq0__ata_drq0__MASK 0x00001000U
#define R_IRQ_MASK0_CLR__par0_ecp_cmd__par0_ecp_cmd__MASK 0x00000800U
#define R_IRQ_MASK0_CLR__ata_irq3__ata_irq3__MASK 0x00000800U
#define R_IRQ_MASK0_CLR__par0_ecp_cmd__ata_irq3__MASK 0x00000800U
#define R_IRQ_MASK0_CLR__par0_peri__par0_peri__MASK 0x00000400U
#define R_IRQ_MASK0_CLR__ata_irq2__ata_irq2__MASK 0x00000400U
#define R_IRQ_MASK0_CLR__par0_peri__ata_irq2__MASK 0x00000400U
#define R_IRQ_MASK0_CLR__par0_data__par0_data__MASK 0x00000200U
#define R_IRQ_MASK0_CLR__ata_irq1__ata_irq1__MASK 0x00000200U
#define R_IRQ_MASK0_CLR__par0_data__ata_irq1__MASK 0x00000200U
#define R_IRQ_MASK0_CLR__par0_ready__par0_ready__MASK 0x00000100U
#define R_IRQ_MASK0_CLR__ata_irq0__ata_irq0__MASK 0x00000100U
#define R_IRQ_MASK0_CLR__par0_ready__ata_irq0__MASK 0x00000100U
#define R_IRQ_MASK0_CLR__mio__mio__MASK 0x00000100U
#define R_IRQ_MASK0_CLR__par0_ready__mio__MASK 0x00000100U
#define R_IRQ_MASK0_CLR__scsi0__scsi0__MASK 0x00000100U
#define R_IRQ_MASK0_CLR__par0_ready__scsi0__MASK 0x00000100U
#define R_IRQ_MASK0_CLR__ata_dmaend__ata_dmaend__MASK 0x00000080U
#define R_IRQ_MASK0_CLR__irq_ext_vector_nr__irq_ext_vector_nr__MASK 0x00000020U
#define R_IRQ_MASK0_CLR__irq_int_vector_nr__irq_int_vector_nr__MASK 0x00000010U
#define R_IRQ_MASK0_CLR__ext_dma1__ext_dma1__MASK 0x00000008U
#define R_IRQ_MASK0_CLR__ext_dma0__ext_dma0__MASK 0x00000004U
#define R_IRQ_MASK0_CLR__timer1__timer1__MASK 0x00000002U
#define R_IRQ_MASK0_CLR__timer0__timer0__MASK 0x00000001U

#define R_IRQ_MASK0_CLR__nmi_pin__MAX 0x1
#define R_IRQ_MASK0_CLR__watchdog_nmi__MAX 0x1
#define R_IRQ_MASK0_CLR__sqe_test_error__MAX 0x1
#define R_IRQ_MASK0_CLR__carrier_loss__MAX 0x1
#define R_IRQ_MASK0_CLR__deferred__MAX 0x1
#define R_IRQ_MASK0_CLR__late_col__MAX 0x1
#define R_IRQ_MASK0_CLR__multiple_col__MAX 0x1
#define R_IRQ_MASK0_CLR__single_col__MAX 0x1
#define R_IRQ_MASK0_CLR__congestion__MAX 0x1
#define R_IRQ_MASK0_CLR__oversize__MAX 0x1
#define R_IRQ_MASK0_CLR__alignment_error__MAX 0x1
#define R_IRQ_MASK0_CLR__crc_error__MAX 0x1
#define R_IRQ_MASK0_CLR__overrun__MAX 0x1
#define R_IRQ_MASK0_CLR__underrun__MAX 0x1
#define R_IRQ_MASK0_CLR__excessive_col__MAX 0x1
#define R_IRQ_MASK0_CLR__mdio__MAX 0x1
#define R_IRQ_MASK0_CLR__ata_drq3__MAX 0x1
#define R_IRQ_MASK0_CLR__ata_drq2__MAX 0x1
#define R_IRQ_MASK0_CLR__ata_drq1__MAX 0x1
#define R_IRQ_MASK0_CLR__ata_drq0__MAX 0x1
#define R_IRQ_MASK0_CLR__par0_ecp_cmd__MAX 0x1
#define R_IRQ_MASK0_CLR__ata_irq3__MAX 0x1
#define R_IRQ_MASK0_CLR__par0_peri__MAX 0x1
#define R_IRQ_MASK0_CLR__ata_irq2__MAX 0x1
#define R_IRQ_MASK0_CLR__par0_data__MAX 0x1
#define R_IRQ_MASK0_CLR__ata_irq1__MAX 0x1
#define R_IRQ_MASK0_CLR__par0_ready__MAX 0x1
#define R_IRQ_MASK0_CLR__ata_irq0__MAX 0x1
#define R_IRQ_MASK0_CLR__mio__MAX 0x1
#define R_IRQ_MASK0_CLR__scsi0__MAX 0x1
#define R_IRQ_MASK0_CLR__ata_dmaend__MAX 0x1
#define R_IRQ_MASK0_CLR__irq_ext_vector_nr__MAX 0x1
#define R_IRQ_MASK0_CLR__irq_int_vector_nr__MAX 0x1
#define R_IRQ_MASK0_CLR__ext_dma1__MAX 0x1
#define R_IRQ_MASK0_CLR__ext_dma0__MAX 0x1
#define R_IRQ_MASK0_CLR__timer1__MAX 0x1
#define R_IRQ_MASK0_CLR__timer0__MAX 0x1

#define R_IRQ_MASK0_CLR__nmi_pin__MIN 0
#define R_IRQ_MASK0_CLR__watchdog_nmi__MIN 0
#define R_IRQ_MASK0_CLR__sqe_test_error__MIN 0
#define R_IRQ_MASK0_CLR__carrier_loss__MIN 0
#define R_IRQ_MASK0_CLR__deferred__MIN 0
#define R_IRQ_MASK0_CLR__late_col__MIN 0
#define R_IRQ_MASK0_CLR__multiple_col__MIN 0
#define R_IRQ_MASK0_CLR__single_col__MIN 0
#define R_IRQ_MASK0_CLR__congestion__MIN 0
#define R_IRQ_MASK0_CLR__oversize__MIN 0
#define R_IRQ_MASK0_CLR__alignment_error__MIN 0
#define R_IRQ_MASK0_CLR__crc_error__MIN 0
#define R_IRQ_MASK0_CLR__overrun__MIN 0
#define R_IRQ_MASK0_CLR__underrun__MIN 0
#define R_IRQ_MASK0_CLR__excessive_col__MIN 0
#define R_IRQ_MASK0_CLR__mdio__MIN 0
#define R_IRQ_MASK0_CLR__ata_drq3__MIN 0
#define R_IRQ_MASK0_CLR__ata_drq2__MIN 0
#define R_IRQ_MASK0_CLR__ata_drq1__MIN 0
#define R_IRQ_MASK0_CLR__ata_drq0__MIN 0
#define R_IRQ_MASK0_CLR__par0_ecp_cmd__MIN 0
#define R_IRQ_MASK0_CLR__ata_irq3__MIN 0
#define R_IRQ_MASK0_CLR__par0_peri__MIN 0
#define R_IRQ_MASK0_CLR__ata_irq2__MIN 0
#define R_IRQ_MASK0_CLR__par0_data__MIN 0
#define R_IRQ_MASK0_CLR__ata_irq1__MIN 0
#define R_IRQ_MASK0_CLR__par0_ready__MIN 0
#define R_IRQ_MASK0_CLR__ata_irq0__MIN 0
#define R_IRQ_MASK0_CLR__mio__MIN 0
#define R_IRQ_MASK0_CLR__scsi0__MIN 0
#define R_IRQ_MASK0_CLR__ata_dmaend__MIN 0
#define R_IRQ_MASK0_CLR__irq_ext_vector_nr__MIN 0
#define R_IRQ_MASK0_CLR__irq_int_vector_nr__MIN 0
#define R_IRQ_MASK0_CLR__ext_dma1__MIN 0
#define R_IRQ_MASK0_CLR__ext_dma0__MIN 0
#define R_IRQ_MASK0_CLR__timer1__MIN 0
#define R_IRQ_MASK0_CLR__timer0__MIN 0

#define R_IRQ_MASK0_CLR__nmi_pin__BITNR 31
#define R_IRQ_MASK0_CLR__watchdog_nmi__BITNR 30
#define R_IRQ_MASK0_CLR__sqe_test_error__BITNR 29
#define R_IRQ_MASK0_CLR__carrier_loss__BITNR 28
#define R_IRQ_MASK0_CLR__deferred__BITNR 27
#define R_IRQ_MASK0_CLR__late_col__BITNR 26
#define R_IRQ_MASK0_CLR__multiple_col__BITNR 25
#define R_IRQ_MASK0_CLR__single_col__BITNR 24
#define R_IRQ_MASK0_CLR__congestion__BITNR 23
#define R_IRQ_MASK0_CLR__oversize__BITNR 22
#define R_IRQ_MASK0_CLR__alignment_error__BITNR 21
#define R_IRQ_MASK0_CLR__crc_error__BITNR 20
#define R_IRQ_MASK0_CLR__overrun__BITNR 19
#define R_IRQ_MASK0_CLR__underrun__BITNR 18
#define R_IRQ_MASK0_CLR__excessive_col__BITNR 17
#define R_IRQ_MASK0_CLR__mdio__BITNR 16
#define R_IRQ_MASK0_CLR__ata_drq3__BITNR 15
#define R_IRQ_MASK0_CLR__ata_drq2__BITNR 14
#define R_IRQ_MASK0_CLR__ata_drq1__BITNR 13
#define R_IRQ_MASK0_CLR__ata_drq0__BITNR 12
#define R_IRQ_MASK0_CLR__par0_ecp_cmd__BITNR 11
#define R_IRQ_MASK0_CLR__ata_irq3__BITNR 11
#define R_IRQ_MASK0_CLR__par0_peri__BITNR 10
#define R_IRQ_MASK0_CLR__ata_irq2__BITNR 10
#define R_IRQ_MASK0_CLR__par0_data__BITNR 9
#define R_IRQ_MASK0_CLR__ata_irq1__BITNR 9
#define R_IRQ_MASK0_CLR__par0_ready__BITNR 8
#define R_IRQ_MASK0_CLR__ata_irq0__BITNR 8
#define R_IRQ_MASK0_CLR__mio__BITNR 8
#define R_IRQ_MASK0_CLR__scsi0__BITNR 8
#define R_IRQ_MASK0_CLR__ata_dmaend__BITNR 7
#define R_IRQ_MASK0_CLR__irq_ext_vector_nr__BITNR 5
#define R_IRQ_MASK0_CLR__irq_int_vector_nr__BITNR 4
#define R_IRQ_MASK0_CLR__ext_dma1__BITNR 3
#define R_IRQ_MASK0_CLR__ext_dma0__BITNR 2
#define R_IRQ_MASK0_CLR__timer1__BITNR 1
#define R_IRQ_MASK0_CLR__timer0__BITNR 0

#define R_IRQ_MASK0_CLR__nmi_pin__nmi_pin__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_CLR__watchdog_nmi__watchdog_nmi__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_CLR__sqe_test_error__sqe_test_error__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_CLR__carrier_loss__carrier_loss__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_CLR__deferred__deferred__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_CLR__late_col__late_col__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_CLR__multiple_col__multiple_col__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_CLR__single_col__single_col__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_CLR__congestion__congestion__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_CLR__oversize__oversize__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_CLR__alignment_error__alignment_error__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_CLR__crc_error__crc_error__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_CLR__overrun__overrun__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_CLR__underrun__underrun__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_CLR__excessive_col__excessive_col__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_CLR__mdio__mdio__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_CLR__ata_drq3__ata_drq3__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_CLR__ata_drq2__ata_drq2__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_CLR__ata_drq1__ata_drq1__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_CLR__ata_drq0__ata_drq0__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_CLR__par0_ecp_cmd__par0_ecp_cmd__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_CLR__ata_irq3__ata_irq3__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_CLR__par0_ecp_cmd__ata_irq3__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_CLR__par0_peri__par0_peri__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_CLR__ata_irq2__ata_irq2__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_CLR__par0_peri__ata_irq2__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_CLR__par0_data__par0_data__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_CLR__ata_irq1__ata_irq1__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_CLR__par0_data__ata_irq1__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_CLR__par0_ready__par0_ready__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_CLR__ata_irq0__ata_irq0__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_CLR__par0_ready__ata_irq0__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_CLR__mio__mio__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_CLR__par0_ready__mio__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_CLR__scsi0__scsi0__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_CLR__par0_ready__scsi0__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_CLR__ata_dmaend__ata_dmaend__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_CLR__irq_ext_vector_nr__irq_ext_vector_nr__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_CLR__irq_int_vector_nr__irq_int_vector_nr__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_CLR__ext_dma1__ext_dma1__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_CLR__ext_dma0__ext_dma0__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_CLR__timer1__timer1__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_CLR__timer0__timer0__VAL REG_VAL_ENUM

#define R_IRQ_MASK0_CLR__nmi_pin__nmi_pin__clr 1
#define R_IRQ_MASK0_CLR__nmi_pin__nmi_pin__nop 0
#define R_IRQ_MASK0_CLR__watchdog_nmi__watchdog_nmi__clr 1
#define R_IRQ_MASK0_CLR__watchdog_nmi__watchdog_nmi__nop 0
#define R_IRQ_MASK0_CLR__sqe_test_error__sqe_test_error__clr 1
#define R_IRQ_MASK0_CLR__sqe_test_error__sqe_test_error__nop 0
#define R_IRQ_MASK0_CLR__carrier_loss__carrier_loss__clr 1
#define R_IRQ_MASK0_CLR__carrier_loss__carrier_loss__nop 0
#define R_IRQ_MASK0_CLR__deferred__deferred__clr 1
#define R_IRQ_MASK0_CLR__deferred__deferred__nop 0
#define R_IRQ_MASK0_CLR__late_col__late_col__clr 1
#define R_IRQ_MASK0_CLR__late_col__late_col__nop 0
#define R_IRQ_MASK0_CLR__multiple_col__multiple_col__clr 1
#define R_IRQ_MASK0_CLR__multiple_col__multiple_col__nop 0
#define R_IRQ_MASK0_CLR__single_col__single_col__clr 1
#define R_IRQ_MASK0_CLR__single_col__single_col__nop 0
#define R_IRQ_MASK0_CLR__congestion__congestion__clr 1
#define R_IRQ_MASK0_CLR__congestion__congestion__nop 0
#define R_IRQ_MASK0_CLR__oversize__oversize__clr 1
#define R_IRQ_MASK0_CLR__oversize__oversize__nop 0
#define R_IRQ_MASK0_CLR__alignment_error__alignment_error__clr 1
#define R_IRQ_MASK0_CLR__alignment_error__alignment_error__nop 0
#define R_IRQ_MASK0_CLR__crc_error__crc_error__clr 1
#define R_IRQ_MASK0_CLR__crc_error__crc_error__nop 0
#define R_IRQ_MASK0_CLR__overrun__overrun__clr 1
#define R_IRQ_MASK0_CLR__overrun__overrun__nop 0
#define R_IRQ_MASK0_CLR__underrun__underrun__clr 1
#define R_IRQ_MASK0_CLR__underrun__underrun__nop 0
#define R_IRQ_MASK0_CLR__excessive_col__excessive_col__clr 1
#define R_IRQ_MASK0_CLR__excessive_col__excessive_col__nop 0
#define R_IRQ_MASK0_CLR__mdio__mdio__clr 1
#define R_IRQ_MASK0_CLR__mdio__mdio__nop 0
#define R_IRQ_MASK0_CLR__ata_drq3__ata_drq3__clr 1
#define R_IRQ_MASK0_CLR__ata_drq3__ata_drq3__nop 0
#define R_IRQ_MASK0_CLR__ata_drq2__ata_drq2__clr 1
#define R_IRQ_MASK0_CLR__ata_drq2__ata_drq2__nop 0
#define R_IRQ_MASK0_CLR__ata_drq1__ata_drq1__clr 1
#define R_IRQ_MASK0_CLR__ata_drq1__ata_drq1__nop 0
#define R_IRQ_MASK0_CLR__ata_drq0__ata_drq0__clr 1
#define R_IRQ_MASK0_CLR__ata_drq0__ata_drq0__nop 0
#define R_IRQ_MASK0_CLR__par0_ecp_cmd__par0_ecp_cmd__clr 1
#define R_IRQ_MASK0_CLR__par0_ecp_cmd__par0_ecp_cmd__nop 0
#define R_IRQ_MASK0_CLR__ata_irq3__ata_irq3__clr 1
#define R_IRQ_MASK0_CLR__ata_irq3__ata_irq3__nop 0
#define R_IRQ_MASK0_CLR__par0_peri__par0_peri__clr 1
#define R_IRQ_MASK0_CLR__par0_peri__par0_peri__nop 0
#define R_IRQ_MASK0_CLR__ata_irq2__ata_irq2__clr 1
#define R_IRQ_MASK0_CLR__ata_irq2__ata_irq2__nop 0
#define R_IRQ_MASK0_CLR__par0_data__par0_data__clr 1
#define R_IRQ_MASK0_CLR__par0_data__par0_data__nop 0
#define R_IRQ_MASK0_CLR__ata_irq1__ata_irq1__clr 1
#define R_IRQ_MASK0_CLR__ata_irq1__ata_irq1__nop 0
#define R_IRQ_MASK0_CLR__par0_ready__par0_ready__clr 1
#define R_IRQ_MASK0_CLR__par0_ready__par0_ready__nop 0
#define R_IRQ_MASK0_CLR__ata_irq0__ata_irq0__clr 1
#define R_IRQ_MASK0_CLR__ata_irq0__ata_irq0__nop 0
#define R_IRQ_MASK0_CLR__mio__mio__clr 1
#define R_IRQ_MASK0_CLR__mio__mio__nop 0
#define R_IRQ_MASK0_CLR__scsi0__scsi0__clr 1
#define R_IRQ_MASK0_CLR__scsi0__scsi0__nop 0
#define R_IRQ_MASK0_CLR__ata_dmaend__ata_dmaend__clr 1
#define R_IRQ_MASK0_CLR__ata_dmaend__ata_dmaend__nop 0
#define R_IRQ_MASK0_CLR__irq_ext_vector_nr__irq_ext_vector_nr__clr 1
#define R_IRQ_MASK0_CLR__irq_ext_vector_nr__irq_ext_vector_nr__nop 0
#define R_IRQ_MASK0_CLR__irq_int_vector_nr__irq_int_vector_nr__clr 1
#define R_IRQ_MASK0_CLR__irq_int_vector_nr__irq_int_vector_nr__nop 0
#define R_IRQ_MASK0_CLR__ext_dma1__ext_dma1__clr 1
#define R_IRQ_MASK0_CLR__ext_dma1__ext_dma1__nop 0
#define R_IRQ_MASK0_CLR__ext_dma0__ext_dma0__clr 1
#define R_IRQ_MASK0_CLR__ext_dma0__ext_dma0__nop 0
#define R_IRQ_MASK0_CLR__timer1__timer1__clr 1
#define R_IRQ_MASK0_CLR__timer1__timer1__nop 0
#define R_IRQ_MASK0_CLR__timer0__timer0__clr 1
#define R_IRQ_MASK0_CLR__timer0__timer0__nop 0

#endif

/*
 *  R_IRQ_MASK0_RD
 *  - type:  RO
 *  - addr:  0xb00000c0
 *  - group: Interrupt mask and status registers
 */

#if USE_GROUP__Interrupt_mask_and_status_registers

#define R_IRQ_MASK0_RD__ADDR      (REG_TYPECAST_UDWORD  0xb00000c0)
#define R_IRQ_MASK0_RD__SVAL      REG_SVAL_SHADOW
#define R_IRQ_MASK0_RD__SVAL_I    REG_SVAL_I_SHADOW
#define R_IRQ_MASK0_RD__TYPECAST  REG_TYPECAST_UDWORD
#define R_IRQ_MASK0_RD__TYPE      (REG_UDWORD)
#define R_IRQ_MASK0_RD__GET       REG_GET_RO
#define R_IRQ_MASK0_RD__IGET      REG_IGET_RO
#define R_IRQ_MASK0_RD__SET       REG_SET_RO
#define R_IRQ_MASK0_RD__ISET      REG_ISET_RO
#define R_IRQ_MASK0_RD__SET_VAL   REG_SET_VAL_RO
#define R_IRQ_MASK0_RD__EQL       REG_EQL_RO
#define R_IRQ_MASK0_RD__IEQL      REG_IEQL_RO
#define R_IRQ_MASK0_RD__RD        REG_RD_RO
#define R_IRQ_MASK0_RD__IRD       REG_IRD_RO
#define R_IRQ_MASK0_RD__WR        REG_WR_RO
#define R_IRQ_MASK0_RD__IWR       REG_IWR_RO

#define R_IRQ_MASK0_RD__READ(addr) \
  (*(addr))

#define R_IRQ_MASK0_RD__nmi_pin__nmi_pin__MASK 0x80000000U
#define R_IRQ_MASK0_RD__watchdog_nmi__watchdog_nmi__MASK 0x40000000U
#define R_IRQ_MASK0_RD__sqe_test_error__sqe_test_error__MASK 0x20000000U
#define R_IRQ_MASK0_RD__carrier_loss__carrier_loss__MASK 0x10000000U
#define R_IRQ_MASK0_RD__deferred__deferred__MASK 0x08000000U
#define R_IRQ_MASK0_RD__late_col__late_col__MASK 0x04000000U
#define R_IRQ_MASK0_RD__multiple_col__multiple_col__MASK 0x02000000U
#define R_IRQ_MASK0_RD__single_col__single_col__MASK 0x01000000U
#define R_IRQ_MASK0_RD__congestion__congestion__MASK 0x00800000U
#define R_IRQ_MASK0_RD__oversize__oversize__MASK 0x00400000U
#define R_IRQ_MASK0_RD__alignment_error__alignment_error__MASK 0x00200000U
#define R_IRQ_MASK0_RD__crc_error__crc_error__MASK 0x00100000U
#define R_IRQ_MASK0_RD__overrun__overrun__MASK 0x00080000U
#define R_IRQ_MASK0_RD__underrun__underrun__MASK 0x00040000U
#define R_IRQ_MASK0_RD__excessive_col__excessive_col__MASK 0x00020000U
#define R_IRQ_MASK0_RD__mdio__mdio__MASK 0x00010000U
#define R_IRQ_MASK0_RD__ata_drq3__ata_drq3__MASK 0x00008000U
#define R_IRQ_MASK0_RD__ata_drq2__ata_drq2__MASK 0x00004000U
#define R_IRQ_MASK0_RD__ata_drq1__ata_drq1__MASK 0x00002000U
#define R_IRQ_MASK0_RD__ata_drq0__ata_drq0__MASK 0x00001000U
#define R_IRQ_MASK0_RD__par0_ecp_cmd__par0_ecp_cmd__MASK 0x00000800U
#define R_IRQ_MASK0_RD__ata_irq3__ata_irq3__MASK 0x00000800U
#define R_IRQ_MASK0_RD__par0_ecp_cmd__ata_irq3__MASK 0x00000800U
#define R_IRQ_MASK0_RD__par0_peri__par0_peri__MASK 0x00000400U
#define R_IRQ_MASK0_RD__ata_irq2__ata_irq2__MASK 0x00000400U
#define R_IRQ_MASK0_RD__par0_peri__ata_irq2__MASK 0x00000400U
#define R_IRQ_MASK0_RD__par0_data__par0_data__MASK 0x00000200U
#define R_IRQ_MASK0_RD__ata_irq1__ata_irq1__MASK 0x00000200U
#define R_IRQ_MASK0_RD__par0_data__ata_irq1__MASK 0x00000200U
#define R_IRQ_MASK0_RD__par0_ready__par0_ready__MASK 0x00000100U
#define R_IRQ_MASK0_RD__ata_irq0__ata_irq0__MASK 0x00000100U
#define R_IRQ_MASK0_RD__par0_ready__ata_irq0__MASK 0x00000100U
#define R_IRQ_MASK0_RD__mio__mio__MASK 0x00000100U
#define R_IRQ_MASK0_RD__par0_ready__mio__MASK 0x00000100U
#define R_IRQ_MASK0_RD__scsi0__scsi0__MASK 0x00000100U
#define R_IRQ_MASK0_RD__par0_ready__scsi0__MASK 0x00000100U
#define R_IRQ_MASK0_RD__ata_dmaend__ata_dmaend__MASK 0x00000080U
#define R_IRQ_MASK0_RD__irq_ext_vector_nr__irq_ext_vector_nr__MASK 0x00000020U
#define R_IRQ_MASK0_RD__irq_int_vector_nr__irq_int_vector_nr__MASK 0x00000010U
#define R_IRQ_MASK0_RD__ext_dma1__ext_dma1__MASK 0x00000008U
#define R_IRQ_MASK0_RD__ext_dma0__ext_dma0__MASK 0x00000004U
#define R_IRQ_MASK0_RD__timer1__timer1__MASK 0x00000002U
#define R_IRQ_MASK0_RD__timer0__timer0__MASK 0x00000001U

#define R_IRQ_MASK0_RD__nmi_pin__MAX 0x1
#define R_IRQ_MASK0_RD__watchdog_nmi__MAX 0x1
#define R_IRQ_MASK0_RD__sqe_test_error__MAX 0x1
#define R_IRQ_MASK0_RD__carrier_loss__MAX 0x1
#define R_IRQ_MASK0_RD__deferred__MAX 0x1
#define R_IRQ_MASK0_RD__late_col__MAX 0x1
#define R_IRQ_MASK0_RD__multiple_col__MAX 0x1
#define R_IRQ_MASK0_RD__single_col__MAX 0x1
#define R_IRQ_MASK0_RD__congestion__MAX 0x1
#define R_IRQ_MASK0_RD__oversize__MAX 0x1
#define R_IRQ_MASK0_RD__alignment_error__MAX 0x1
#define R_IRQ_MASK0_RD__crc_error__MAX 0x1
#define R_IRQ_MASK0_RD__overrun__MAX 0x1
#define R_IRQ_MASK0_RD__underrun__MAX 0x1
#define R_IRQ_MASK0_RD__excessive_col__MAX 0x1
#define R_IRQ_MASK0_RD__mdio__MAX 0x1
#define R_IRQ_MASK0_RD__ata_drq3__MAX 0x1
#define R_IRQ_MASK0_RD__ata_drq2__MAX 0x1
#define R_IRQ_MASK0_RD__ata_drq1__MAX 0x1
#define R_IRQ_MASK0_RD__ata_drq0__MAX 0x1
#define R_IRQ_MASK0_RD__par0_ecp_cmd__MAX 0x1
#define R_IRQ_MASK0_RD__ata_irq3__MAX 0x1
#define R_IRQ_MASK0_RD__par0_peri__MAX 0x1
#define R_IRQ_MASK0_RD__ata_irq2__MAX 0x1
#define R_IRQ_MASK0_RD__par0_data__MAX 0x1
#define R_IRQ_MASK0_RD__ata_irq1__MAX 0x1
#define R_IRQ_MASK0_RD__par0_ready__MAX 0x1
#define R_IRQ_MASK0_RD__ata_irq0__MAX 0x1
#define R_IRQ_MASK0_RD__mio__MAX 0x1
#define R_IRQ_MASK0_RD__scsi0__MAX 0x1
#define R_IRQ_MASK0_RD__ata_dmaend__MAX 0x1
#define R_IRQ_MASK0_RD__irq_ext_vector_nr__MAX 0x1
#define R_IRQ_MASK0_RD__irq_int_vector_nr__MAX 0x1
#define R_IRQ_MASK0_RD__ext_dma1__MAX 0x1
#define R_IRQ_MASK0_RD__ext_dma0__MAX 0x1
#define R_IRQ_MASK0_RD__timer1__MAX 0x1
#define R_IRQ_MASK0_RD__timer0__MAX 0x1

#define R_IRQ_MASK0_RD__nmi_pin__MIN 0
#define R_IRQ_MASK0_RD__watchdog_nmi__MIN 0
#define R_IRQ_MASK0_RD__sqe_test_error__MIN 0
#define R_IRQ_MASK0_RD__carrier_loss__MIN 0
#define R_IRQ_MASK0_RD__deferred__MIN 0
#define R_IRQ_MASK0_RD__late_col__MIN 0
#define R_IRQ_MASK0_RD__multiple_col__MIN 0
#define R_IRQ_MASK0_RD__single_col__MIN 0
#define R_IRQ_MASK0_RD__congestion__MIN 0
#define R_IRQ_MASK0_RD__oversize__MIN 0
#define R_IRQ_MASK0_RD__alignment_error__MIN 0
#define R_IRQ_MASK0_RD__crc_error__MIN 0
#define R_IRQ_MASK0_RD__overrun__MIN 0
#define R_IRQ_MASK0_RD__underrun__MIN 0
#define R_IRQ_MASK0_RD__excessive_col__MIN 0
#define R_IRQ_MASK0_RD__mdio__MIN 0
#define R_IRQ_MASK0_RD__ata_drq3__MIN 0
#define R_IRQ_MASK0_RD__ata_drq2__MIN 0
#define R_IRQ_MASK0_RD__ata_drq1__MIN 0
#define R_IRQ_MASK0_RD__ata_drq0__MIN 0
#define R_IRQ_MASK0_RD__par0_ecp_cmd__MIN 0
#define R_IRQ_MASK0_RD__ata_irq3__MIN 0
#define R_IRQ_MASK0_RD__par0_peri__MIN 0
#define R_IRQ_MASK0_RD__ata_irq2__MIN 0
#define R_IRQ_MASK0_RD__par0_data__MIN 0
#define R_IRQ_MASK0_RD__ata_irq1__MIN 0
#define R_IRQ_MASK0_RD__par0_ready__MIN 0
#define R_IRQ_MASK0_RD__ata_irq0__MIN 0
#define R_IRQ_MASK0_RD__mio__MIN 0
#define R_IRQ_MASK0_RD__scsi0__MIN 0
#define R_IRQ_MASK0_RD__ata_dmaend__MIN 0
#define R_IRQ_MASK0_RD__irq_ext_vector_nr__MIN 0
#define R_IRQ_MASK0_RD__irq_int_vector_nr__MIN 0
#define R_IRQ_MASK0_RD__ext_dma1__MIN 0
#define R_IRQ_MASK0_RD__ext_dma0__MIN 0
#define R_IRQ_MASK0_RD__timer1__MIN 0
#define R_IRQ_MASK0_RD__timer0__MIN 0

#define R_IRQ_MASK0_RD__nmi_pin__BITNR 31
#define R_IRQ_MASK0_RD__watchdog_nmi__BITNR 30
#define R_IRQ_MASK0_RD__sqe_test_error__BITNR 29
#define R_IRQ_MASK0_RD__carrier_loss__BITNR 28
#define R_IRQ_MASK0_RD__deferred__BITNR 27
#define R_IRQ_MASK0_RD__late_col__BITNR 26
#define R_IRQ_MASK0_RD__multiple_col__BITNR 25
#define R_IRQ_MASK0_RD__single_col__BITNR 24
#define R_IRQ_MASK0_RD__congestion__BITNR 23
#define R_IRQ_MASK0_RD__oversize__BITNR 22
#define R_IRQ_MASK0_RD__alignment_error__BITNR 21
#define R_IRQ_MASK0_RD__crc_error__BITNR 20
#define R_IRQ_MASK0_RD__overrun__BITNR 19
#define R_IRQ_MASK0_RD__underrun__BITNR 18
#define R_IRQ_MASK0_RD__excessive_col__BITNR 17
#define R_IRQ_MASK0_RD__mdio__BITNR 16
#define R_IRQ_MASK0_RD__ata_drq3__BITNR 15
#define R_IRQ_MASK0_RD__ata_drq2__BITNR 14
#define R_IRQ_MASK0_RD__ata_drq1__BITNR 13
#define R_IRQ_MASK0_RD__ata_drq0__BITNR 12
#define R_IRQ_MASK0_RD__par0_ecp_cmd__BITNR 11
#define R_IRQ_MASK0_RD__ata_irq3__BITNR 11
#define R_IRQ_MASK0_RD__par0_peri__BITNR 10
#define R_IRQ_MASK0_RD__ata_irq2__BITNR 10
#define R_IRQ_MASK0_RD__par0_data__BITNR 9
#define R_IRQ_MASK0_RD__ata_irq1__BITNR 9
#define R_IRQ_MASK0_RD__par0_ready__BITNR 8
#define R_IRQ_MASK0_RD__ata_irq0__BITNR 8
#define R_IRQ_MASK0_RD__mio__BITNR 8
#define R_IRQ_MASK0_RD__scsi0__BITNR 8
#define R_IRQ_MASK0_RD__ata_dmaend__BITNR 7
#define R_IRQ_MASK0_RD__irq_ext_vector_nr__BITNR 5
#define R_IRQ_MASK0_RD__irq_int_vector_nr__BITNR 4
#define R_IRQ_MASK0_RD__ext_dma1__BITNR 3
#define R_IRQ_MASK0_RD__ext_dma0__BITNR 2
#define R_IRQ_MASK0_RD__timer1__BITNR 1
#define R_IRQ_MASK0_RD__timer0__BITNR 0

#define R_IRQ_MASK0_RD__nmi_pin__nmi_pin__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_RD__watchdog_nmi__watchdog_nmi__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_RD__sqe_test_error__sqe_test_error__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_RD__carrier_loss__carrier_loss__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_RD__deferred__deferred__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_RD__late_col__late_col__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_RD__multiple_col__multiple_col__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_RD__single_col__single_col__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_RD__congestion__congestion__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_RD__oversize__oversize__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_RD__alignment_error__alignment_error__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_RD__crc_error__crc_error__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_RD__overrun__overrun__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_RD__underrun__underrun__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_RD__excessive_col__excessive_col__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_RD__mdio__mdio__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_RD__ata_drq3__ata_drq3__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_RD__ata_drq2__ata_drq2__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_RD__ata_drq1__ata_drq1__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_RD__ata_drq0__ata_drq0__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_RD__par0_ecp_cmd__par0_ecp_cmd__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_RD__ata_irq3__ata_irq3__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_RD__par0_ecp_cmd__ata_irq3__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_RD__par0_peri__par0_peri__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_RD__ata_irq2__ata_irq2__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_RD__par0_peri__ata_irq2__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_RD__par0_data__par0_data__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_RD__ata_irq1__ata_irq1__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_RD__par0_data__ata_irq1__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_RD__par0_ready__par0_ready__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_RD__ata_irq0__ata_irq0__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_RD__par0_ready__ata_irq0__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_RD__mio__mio__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_RD__par0_ready__mio__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_RD__scsi0__scsi0__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_RD__par0_ready__scsi0__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_RD__ata_dmaend__ata_dmaend__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_RD__irq_ext_vector_nr__irq_ext_vector_nr__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_RD__irq_int_vector_nr__irq_int_vector_nr__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_RD__ext_dma1__ext_dma1__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_RD__ext_dma0__ext_dma0__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_RD__timer1__timer1__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_RD__timer0__timer0__VAL REG_VAL_ENUM

#define R_IRQ_MASK0_RD__nmi_pin__nmi_pin__active 1
#define R_IRQ_MASK0_RD__nmi_pin__nmi_pin__inactive 0
#define R_IRQ_MASK0_RD__watchdog_nmi__watchdog_nmi__active 1
#define R_IRQ_MASK0_RD__watchdog_nmi__watchdog_nmi__inactive 0
#define R_IRQ_MASK0_RD__sqe_test_error__sqe_test_error__active 1
#define R_IRQ_MASK0_RD__sqe_test_error__sqe_test_error__inactive 0
#define R_IRQ_MASK0_RD__carrier_loss__carrier_loss__active 1
#define R_IRQ_MASK0_RD__carrier_loss__carrier_loss__inactive 0
#define R_IRQ_MASK0_RD__deferred__deferred__active 1
#define R_IRQ_MASK0_RD__deferred__deferred__inactive 0
#define R_IRQ_MASK0_RD__late_col__late_col__active 1
#define R_IRQ_MASK0_RD__late_col__late_col__inactive 0
#define R_IRQ_MASK0_RD__multiple_col__multiple_col__active 1
#define R_IRQ_MASK0_RD__multiple_col__multiple_col__inactive 0
#define R_IRQ_MASK0_RD__single_col__single_col__active 1
#define R_IRQ_MASK0_RD__single_col__single_col__inactive 0
#define R_IRQ_MASK0_RD__congestion__congestion__active 1
#define R_IRQ_MASK0_RD__congestion__congestion__inactive 0
#define R_IRQ_MASK0_RD__oversize__oversize__active 1
#define R_IRQ_MASK0_RD__oversize__oversize__inactive 0
#define R_IRQ_MASK0_RD__alignment_error__alignment_error__active 1
#define R_IRQ_MASK0_RD__alignment_error__alignment_error__inactive 0
#define R_IRQ_MASK0_RD__crc_error__crc_error__active 1
#define R_IRQ_MASK0_RD__crc_error__crc_error__inactive 0
#define R_IRQ_MASK0_RD__overrun__overrun__active 1
#define R_IRQ_MASK0_RD__overrun__overrun__inactive 0
#define R_IRQ_MASK0_RD__underrun__underrun__active 1
#define R_IRQ_MASK0_RD__underrun__underrun__inactive 0
#define R_IRQ_MASK0_RD__excessive_col__excessive_col__active 1
#define R_IRQ_MASK0_RD__excessive_col__excessive_col__inactive 0
#define R_IRQ_MASK0_RD__mdio__mdio__active 1
#define R_IRQ_MASK0_RD__mdio__mdio__inactive 0
#define R_IRQ_MASK0_RD__ata_drq3__ata_drq3__active 1
#define R_IRQ_MASK0_RD__ata_drq3__ata_drq3__inactive 0
#define R_IRQ_MASK0_RD__ata_drq2__ata_drq2__active 1
#define R_IRQ_MASK0_RD__ata_drq2__ata_drq2__inactive 0
#define R_IRQ_MASK0_RD__ata_drq1__ata_drq1__active 1
#define R_IRQ_MASK0_RD__ata_drq1__ata_drq1__inactive 0
#define R_IRQ_MASK0_RD__ata_drq0__ata_drq0__active 1
#define R_IRQ_MASK0_RD__ata_drq0__ata_drq0__inactive 0
#define R_IRQ_MASK0_RD__par0_ecp_cmd__par0_ecp_cmd__active 1
#define R_IRQ_MASK0_RD__par0_ecp_cmd__par0_ecp_cmd__inactive 0
#define R_IRQ_MASK0_RD__ata_irq3__ata_irq3__active 1
#define R_IRQ_MASK0_RD__ata_irq3__ata_irq3__inactive 0
#define R_IRQ_MASK0_RD__par0_peri__par0_peri__active 1
#define R_IRQ_MASK0_RD__par0_peri__par0_peri__inactive 0
#define R_IRQ_MASK0_RD__ata_irq2__ata_irq2__active 1
#define R_IRQ_MASK0_RD__ata_irq2__ata_irq2__inactive 0
#define R_IRQ_MASK0_RD__par0_data__par0_data__active 1
#define R_IRQ_MASK0_RD__par0_data__par0_data__inactive 0
#define R_IRQ_MASK0_RD__ata_irq1__ata_irq1__active 1
#define R_IRQ_MASK0_RD__ata_irq1__ata_irq1__inactive 0
#define R_IRQ_MASK0_RD__par0_ready__par0_ready__active 1
#define R_IRQ_MASK0_RD__par0_ready__par0_ready__inactive 0
#define R_IRQ_MASK0_RD__ata_irq0__ata_irq0__active 1
#define R_IRQ_MASK0_RD__ata_irq0__ata_irq0__inactive 0
#define R_IRQ_MASK0_RD__mio__mio__active 1
#define R_IRQ_MASK0_RD__mio__mio__inactive 0
#define R_IRQ_MASK0_RD__scsi0__scsi0__active 1
#define R_IRQ_MASK0_RD__scsi0__scsi0__inactive 0
#define R_IRQ_MASK0_RD__ata_dmaend__ata_dmaend__active 1
#define R_IRQ_MASK0_RD__ata_dmaend__ata_dmaend__inactive 0
#define R_IRQ_MASK0_RD__irq_ext_vector_nr__irq_ext_vector_nr__active 1
#define R_IRQ_MASK0_RD__irq_ext_vector_nr__irq_ext_vector_nr__inactive 0
#define R_IRQ_MASK0_RD__irq_int_vector_nr__irq_int_vector_nr__active 1
#define R_IRQ_MASK0_RD__irq_int_vector_nr__irq_int_vector_nr__inactive 0
#define R_IRQ_MASK0_RD__ext_dma1__ext_dma1__active 1
#define R_IRQ_MASK0_RD__ext_dma1__ext_dma1__inactive 0
#define R_IRQ_MASK0_RD__ext_dma0__ext_dma0__active 1
#define R_IRQ_MASK0_RD__ext_dma0__ext_dma0__inactive 0
#define R_IRQ_MASK0_RD__timer1__timer1__active 1
#define R_IRQ_MASK0_RD__timer1__timer1__inactive 0
#define R_IRQ_MASK0_RD__timer0__timer0__active 1
#define R_IRQ_MASK0_RD__timer0__timer0__inactive 0

#endif

/*
 *  R_IRQ_MASK0_SET
 *  - type:  WO
 *  - addr:  0xb00000c4
 *  - group: Interrupt mask and status registers
 */

#if USE_GROUP__Interrupt_mask_and_status_registers

#define R_IRQ_MASK0_SET__ADDR      (REG_TYPECAST_UDWORD  0xb00000c4)

#ifndef REG_NO_SHADOW
#define R_IRQ_MASK0_SET__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_IRQ_MASK0_SET + 0))
#define R_IRQ_MASK0_SET__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_IRQ_MASK0_SET + 0))
#else /* REG_NO_SHADOW */
#define R_IRQ_MASK0_SET__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_IRQ_MASK0_SET__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_IRQ_MASK0_SET__STYPECAST REG_STYPECAST_UDWORD
#define R_IRQ_MASK0_SET__SVAL REG_SVAL_ZERO
#define R_IRQ_MASK0_SET__SVAL_I REG_SVAL_I_ZERO
#define R_IRQ_MASK0_SET__TYPECAST  REG_TYPECAST_UDWORD
#define R_IRQ_MASK0_SET__TYPE      (REG_UDWORD)
#define R_IRQ_MASK0_SET__GET       REG_GET_WO
#define R_IRQ_MASK0_SET__IGET      REG_IGET_WO
#define R_IRQ_MASK0_SET__SET       REG_SET_WO
#define R_IRQ_MASK0_SET__ISET      REG_ISET_WO
#define R_IRQ_MASK0_SET__SET_VAL   REG_SET_VAL_WO
#define R_IRQ_MASK0_SET__EQL       REG_EQL_WO
#define R_IRQ_MASK0_SET__IEQL      REG_IEQL_WO
#define R_IRQ_MASK0_SET__RD        REG_RD_WO
#define R_IRQ_MASK0_SET__IRD       REG_IRD_WO
#define R_IRQ_MASK0_SET__WR        REG_WR_WO
#define R_IRQ_MASK0_SET__IWR       REG_IWR_WO

#define R_IRQ_MASK0_SET__WRITE(addr,value) \
  (*(addr) = (value))

#define R_IRQ_MASK0_SET__nmi_pin__nmi_pin__MASK 0x80000000U
#define R_IRQ_MASK0_SET__watchdog_nmi__watchdog_nmi__MASK 0x40000000U
#define R_IRQ_MASK0_SET__sqe_test_error__sqe_test_error__MASK 0x20000000U
#define R_IRQ_MASK0_SET__carrier_loss__carrier_loss__MASK 0x10000000U
#define R_IRQ_MASK0_SET__deferred__deferred__MASK 0x08000000U
#define R_IRQ_MASK0_SET__late_col__late_col__MASK 0x04000000U
#define R_IRQ_MASK0_SET__multiple_col__multiple_col__MASK 0x02000000U
#define R_IRQ_MASK0_SET__single_col__single_col__MASK 0x01000000U
#define R_IRQ_MASK0_SET__congestion__congestion__MASK 0x00800000U
#define R_IRQ_MASK0_SET__oversize__oversize__MASK 0x00400000U
#define R_IRQ_MASK0_SET__alignment_error__alignment_error__MASK 0x00200000U
#define R_IRQ_MASK0_SET__crc_error__crc_error__MASK 0x00100000U
#define R_IRQ_MASK0_SET__overrun__overrun__MASK 0x00080000U
#define R_IRQ_MASK0_SET__underrun__underrun__MASK 0x00040000U
#define R_IRQ_MASK0_SET__excessive_col__excessive_col__MASK 0x00020000U
#define R_IRQ_MASK0_SET__mdio__mdio__MASK 0x00010000U
#define R_IRQ_MASK0_SET__ata_drq3__ata_drq3__MASK 0x00008000U
#define R_IRQ_MASK0_SET__ata_drq2__ata_drq2__MASK 0x00004000U
#define R_IRQ_MASK0_SET__ata_drq1__ata_drq1__MASK 0x00002000U
#define R_IRQ_MASK0_SET__ata_drq0__ata_drq0__MASK 0x00001000U
#define R_IRQ_MASK0_SET__par0_ecp_cmd__par0_ecp_cmd__MASK 0x00000800U
#define R_IRQ_MASK0_SET__ata_irq3__ata_irq3__MASK 0x00000800U
#define R_IRQ_MASK0_SET__par0_ecp_cmd__ata_irq3__MASK 0x00000800U
#define R_IRQ_MASK0_SET__par0_peri__par0_peri__MASK 0x00000400U
#define R_IRQ_MASK0_SET__ata_irq2__ata_irq2__MASK 0x00000400U
#define R_IRQ_MASK0_SET__par0_peri__ata_irq2__MASK 0x00000400U
#define R_IRQ_MASK0_SET__par0_data__par0_data__MASK 0x00000200U
#define R_IRQ_MASK0_SET__ata_irq1__ata_irq1__MASK 0x00000200U
#define R_IRQ_MASK0_SET__par0_data__ata_irq1__MASK 0x00000200U
#define R_IRQ_MASK0_SET__par0_ready__par0_ready__MASK 0x00000100U
#define R_IRQ_MASK0_SET__ata_irq0__ata_irq0__MASK 0x00000100U
#define R_IRQ_MASK0_SET__par0_ready__ata_irq0__MASK 0x00000100U
#define R_IRQ_MASK0_SET__mio__mio__MASK 0x00000100U
#define R_IRQ_MASK0_SET__par0_ready__mio__MASK 0x00000100U
#define R_IRQ_MASK0_SET__scsi0__scsi0__MASK 0x00000100U
#define R_IRQ_MASK0_SET__par0_ready__scsi0__MASK 0x00000100U
#define R_IRQ_MASK0_SET__ata_dmaend__ata_dmaend__MASK 0x00000080U
#define R_IRQ_MASK0_SET__irq_ext_vector_nr__irq_ext_vector_nr__MASK 0x00000020U
#define R_IRQ_MASK0_SET__irq_int_vector_nr__irq_int_vector_nr__MASK 0x00000010U
#define R_IRQ_MASK0_SET__ext_dma1__ext_dma1__MASK 0x00000008U
#define R_IRQ_MASK0_SET__ext_dma0__ext_dma0__MASK 0x00000004U
#define R_IRQ_MASK0_SET__timer1__timer1__MASK 0x00000002U
#define R_IRQ_MASK0_SET__timer0__timer0__MASK 0x00000001U

#define R_IRQ_MASK0_SET__nmi_pin__MAX 0x1
#define R_IRQ_MASK0_SET__watchdog_nmi__MAX 0x1
#define R_IRQ_MASK0_SET__sqe_test_error__MAX 0x1
#define R_IRQ_MASK0_SET__carrier_loss__MAX 0x1
#define R_IRQ_MASK0_SET__deferred__MAX 0x1
#define R_IRQ_MASK0_SET__late_col__MAX 0x1
#define R_IRQ_MASK0_SET__multiple_col__MAX 0x1
#define R_IRQ_MASK0_SET__single_col__MAX 0x1
#define R_IRQ_MASK0_SET__congestion__MAX 0x1
#define R_IRQ_MASK0_SET__oversize__MAX 0x1
#define R_IRQ_MASK0_SET__alignment_error__MAX 0x1
#define R_IRQ_MASK0_SET__crc_error__MAX 0x1
#define R_IRQ_MASK0_SET__overrun__MAX 0x1
#define R_IRQ_MASK0_SET__underrun__MAX 0x1
#define R_IRQ_MASK0_SET__excessive_col__MAX 0x1
#define R_IRQ_MASK0_SET__mdio__MAX 0x1
#define R_IRQ_MASK0_SET__ata_drq3__MAX 0x1
#define R_IRQ_MASK0_SET__ata_drq2__MAX 0x1
#define R_IRQ_MASK0_SET__ata_drq1__MAX 0x1
#define R_IRQ_MASK0_SET__ata_drq0__MAX 0x1
#define R_IRQ_MASK0_SET__par0_ecp_cmd__MAX 0x1
#define R_IRQ_MASK0_SET__ata_irq3__MAX 0x1
#define R_IRQ_MASK0_SET__par0_peri__MAX 0x1
#define R_IRQ_MASK0_SET__ata_irq2__MAX 0x1
#define R_IRQ_MASK0_SET__par0_data__MAX 0x1
#define R_IRQ_MASK0_SET__ata_irq1__MAX 0x1
#define R_IRQ_MASK0_SET__par0_ready__MAX 0x1
#define R_IRQ_MASK0_SET__ata_irq0__MAX 0x1
#define R_IRQ_MASK0_SET__mio__MAX 0x1
#define R_IRQ_MASK0_SET__scsi0__MAX 0x1
#define R_IRQ_MASK0_SET__ata_dmaend__MAX 0x1
#define R_IRQ_MASK0_SET__irq_ext_vector_nr__MAX 0x1
#define R_IRQ_MASK0_SET__irq_int_vector_nr__MAX 0x1
#define R_IRQ_MASK0_SET__ext_dma1__MAX 0x1
#define R_IRQ_MASK0_SET__ext_dma0__MAX 0x1
#define R_IRQ_MASK0_SET__timer1__MAX 0x1
#define R_IRQ_MASK0_SET__timer0__MAX 0x1

#define R_IRQ_MASK0_SET__nmi_pin__MIN 0
#define R_IRQ_MASK0_SET__watchdog_nmi__MIN 0
#define R_IRQ_MASK0_SET__sqe_test_error__MIN 0
#define R_IRQ_MASK0_SET__carrier_loss__MIN 0
#define R_IRQ_MASK0_SET__deferred__MIN 0
#define R_IRQ_MASK0_SET__late_col__MIN 0
#define R_IRQ_MASK0_SET__multiple_col__MIN 0
#define R_IRQ_MASK0_SET__single_col__MIN 0
#define R_IRQ_MASK0_SET__congestion__MIN 0
#define R_IRQ_MASK0_SET__oversize__MIN 0
#define R_IRQ_MASK0_SET__alignment_error__MIN 0
#define R_IRQ_MASK0_SET__crc_error__MIN 0
#define R_IRQ_MASK0_SET__overrun__MIN 0
#define R_IRQ_MASK0_SET__underrun__MIN 0
#define R_IRQ_MASK0_SET__excessive_col__MIN 0
#define R_IRQ_MASK0_SET__mdio__MIN 0
#define R_IRQ_MASK0_SET__ata_drq3__MIN 0
#define R_IRQ_MASK0_SET__ata_drq2__MIN 0
#define R_IRQ_MASK0_SET__ata_drq1__MIN 0
#define R_IRQ_MASK0_SET__ata_drq0__MIN 0
#define R_IRQ_MASK0_SET__par0_ecp_cmd__MIN 0
#define R_IRQ_MASK0_SET__ata_irq3__MIN 0
#define R_IRQ_MASK0_SET__par0_peri__MIN 0
#define R_IRQ_MASK0_SET__ata_irq2__MIN 0
#define R_IRQ_MASK0_SET__par0_data__MIN 0
#define R_IRQ_MASK0_SET__ata_irq1__MIN 0
#define R_IRQ_MASK0_SET__par0_ready__MIN 0
#define R_IRQ_MASK0_SET__ata_irq0__MIN 0
#define R_IRQ_MASK0_SET__mio__MIN 0
#define R_IRQ_MASK0_SET__scsi0__MIN 0
#define R_IRQ_MASK0_SET__ata_dmaend__MIN 0
#define R_IRQ_MASK0_SET__irq_ext_vector_nr__MIN 0
#define R_IRQ_MASK0_SET__irq_int_vector_nr__MIN 0
#define R_IRQ_MASK0_SET__ext_dma1__MIN 0
#define R_IRQ_MASK0_SET__ext_dma0__MIN 0
#define R_IRQ_MASK0_SET__timer1__MIN 0
#define R_IRQ_MASK0_SET__timer0__MIN 0

#define R_IRQ_MASK0_SET__nmi_pin__BITNR 31
#define R_IRQ_MASK0_SET__watchdog_nmi__BITNR 30
#define R_IRQ_MASK0_SET__sqe_test_error__BITNR 29
#define R_IRQ_MASK0_SET__carrier_loss__BITNR 28
#define R_IRQ_MASK0_SET__deferred__BITNR 27
#define R_IRQ_MASK0_SET__late_col__BITNR 26
#define R_IRQ_MASK0_SET__multiple_col__BITNR 25
#define R_IRQ_MASK0_SET__single_col__BITNR 24
#define R_IRQ_MASK0_SET__congestion__BITNR 23
#define R_IRQ_MASK0_SET__oversize__BITNR 22
#define R_IRQ_MASK0_SET__alignment_error__BITNR 21
#define R_IRQ_MASK0_SET__crc_error__BITNR 20
#define R_IRQ_MASK0_SET__overrun__BITNR 19
#define R_IRQ_MASK0_SET__underrun__BITNR 18
#define R_IRQ_MASK0_SET__excessive_col__BITNR 17
#define R_IRQ_MASK0_SET__mdio__BITNR 16
#define R_IRQ_MASK0_SET__ata_drq3__BITNR 15
#define R_IRQ_MASK0_SET__ata_drq2__BITNR 14
#define R_IRQ_MASK0_SET__ata_drq1__BITNR 13
#define R_IRQ_MASK0_SET__ata_drq0__BITNR 12
#define R_IRQ_MASK0_SET__par0_ecp_cmd__BITNR 11
#define R_IRQ_MASK0_SET__ata_irq3__BITNR 11
#define R_IRQ_MASK0_SET__par0_peri__BITNR 10
#define R_IRQ_MASK0_SET__ata_irq2__BITNR 10
#define R_IRQ_MASK0_SET__par0_data__BITNR 9
#define R_IRQ_MASK0_SET__ata_irq1__BITNR 9
#define R_IRQ_MASK0_SET__par0_ready__BITNR 8
#define R_IRQ_MASK0_SET__ata_irq0__BITNR 8
#define R_IRQ_MASK0_SET__mio__BITNR 8
#define R_IRQ_MASK0_SET__scsi0__BITNR 8
#define R_IRQ_MASK0_SET__ata_dmaend__BITNR 7
#define R_IRQ_MASK0_SET__irq_ext_vector_nr__BITNR 5
#define R_IRQ_MASK0_SET__irq_int_vector_nr__BITNR 4
#define R_IRQ_MASK0_SET__ext_dma1__BITNR 3
#define R_IRQ_MASK0_SET__ext_dma0__BITNR 2
#define R_IRQ_MASK0_SET__timer1__BITNR 1
#define R_IRQ_MASK0_SET__timer0__BITNR 0

#define R_IRQ_MASK0_SET__nmi_pin__nmi_pin__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_SET__watchdog_nmi__watchdog_nmi__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_SET__sqe_test_error__sqe_test_error__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_SET__carrier_loss__carrier_loss__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_SET__deferred__deferred__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_SET__late_col__late_col__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_SET__multiple_col__multiple_col__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_SET__single_col__single_col__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_SET__congestion__congestion__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_SET__oversize__oversize__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_SET__alignment_error__alignment_error__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_SET__crc_error__crc_error__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_SET__overrun__overrun__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_SET__underrun__underrun__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_SET__excessive_col__excessive_col__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_SET__mdio__mdio__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_SET__ata_drq3__ata_drq3__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_SET__ata_drq2__ata_drq2__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_SET__ata_drq1__ata_drq1__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_SET__ata_drq0__ata_drq0__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_SET__par0_ecp_cmd__par0_ecp_cmd__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_SET__ata_irq3__ata_irq3__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_SET__par0_ecp_cmd__ata_irq3__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_SET__par0_peri__par0_peri__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_SET__ata_irq2__ata_irq2__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_SET__par0_peri__ata_irq2__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_SET__par0_data__par0_data__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_SET__ata_irq1__ata_irq1__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_SET__par0_data__ata_irq1__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_SET__par0_ready__par0_ready__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_SET__ata_irq0__ata_irq0__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_SET__par0_ready__ata_irq0__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_SET__mio__mio__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_SET__par0_ready__mio__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_SET__scsi0__scsi0__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_SET__par0_ready__scsi0__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_SET__ata_dmaend__ata_dmaend__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_SET__irq_ext_vector_nr__irq_ext_vector_nr__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_SET__irq_int_vector_nr__irq_int_vector_nr__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_SET__ext_dma1__ext_dma1__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_SET__ext_dma0__ext_dma0__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_SET__timer1__timer1__VAL REG_VAL_ENUM
#define R_IRQ_MASK0_SET__timer0__timer0__VAL REG_VAL_ENUM

#define R_IRQ_MASK0_SET__nmi_pin__nmi_pin__nop 0
#define R_IRQ_MASK0_SET__nmi_pin__nmi_pin__set 1
#define R_IRQ_MASK0_SET__watchdog_nmi__watchdog_nmi__nop 0
#define R_IRQ_MASK0_SET__watchdog_nmi__watchdog_nmi__set 1
#define R_IRQ_MASK0_SET__sqe_test_error__sqe_test_error__nop 0
#define R_IRQ_MASK0_SET__sqe_test_error__sqe_test_error__set 1
#define R_IRQ_MASK0_SET__carrier_loss__carrier_loss__nop 0
#define R_IRQ_MASK0_SET__carrier_loss__carrier_loss__set 1
#define R_IRQ_MASK0_SET__deferred__deferred__nop 0
#define R_IRQ_MASK0_SET__deferred__deferred__set 1
#define R_IRQ_MASK0_SET__late_col__late_col__nop 0
#define R_IRQ_MASK0_SET__late_col__late_col__set 1
#define R_IRQ_MASK0_SET__multiple_col__multiple_col__nop 0
#define R_IRQ_MASK0_SET__multiple_col__multiple_col__set 1
#define R_IRQ_MASK0_SET__single_col__single_col__nop 0
#define R_IRQ_MASK0_SET__single_col__single_col__set 1
#define R_IRQ_MASK0_SET__congestion__congestion__nop 0
#define R_IRQ_MASK0_SET__congestion__congestion__set 1
#define R_IRQ_MASK0_SET__oversize__oversize__nop 0
#define R_IRQ_MASK0_SET__oversize__oversize__set 1
#define R_IRQ_MASK0_SET__alignment_error__alignment_error__nop 0
#define R_IRQ_MASK0_SET__alignment_error__alignment_error__set 1
#define R_IRQ_MASK0_SET__crc_error__crc_error__nop 0
#define R_IRQ_MASK0_SET__crc_error__crc_error__set 1
#define R_IRQ_MASK0_SET__overrun__overrun__nop 0
#define R_IRQ_MASK0_SET__overrun__overrun__set 1
#define R_IRQ_MASK0_SET__underrun__underrun__nop 0
#define R_IRQ_MASK0_SET__underrun__underrun__set 1
#define R_IRQ_MASK0_SET__excessive_col__excessive_col__nop 0
#define R_IRQ_MASK0_SET__excessive_col__excessive_col__set 1
#define R_IRQ_MASK0_SET__mdio__mdio__nop 0
#define R_IRQ_MASK0_SET__mdio__mdio__set 1
#define R_IRQ_MASK0_SET__ata_drq3__ata_drq3__nop 0
#define R_IRQ_MASK0_SET__ata_drq3__ata_drq3__set 1
#define R_IRQ_MASK0_SET__ata_drq2__ata_drq2__nop 0
#define R_IRQ_MASK0_SET__ata_drq2__ata_drq2__set 1
#define R_IRQ_MASK0_SET__ata_drq1__ata_drq1__nop 0
#define R_IRQ_MASK0_SET__ata_drq1__ata_drq1__set 1
#define R_IRQ_MASK0_SET__ata_drq0__ata_drq0__nop 0
#define R_IRQ_MASK0_SET__ata_drq0__ata_drq0__set 1
#define R_IRQ_MASK0_SET__par0_ecp_cmd__par0_ecp_cmd__nop 0
#define R_IRQ_MASK0_SET__par0_ecp_cmd__par0_ecp_cmd__set 1
#define R_IRQ_MASK0_SET__ata_irq3__ata_irq3__nop 0
#define R_IRQ_MASK0_SET__ata_irq3__ata_irq3__set 1
#define R_IRQ_MASK0_SET__par0_peri__par0_peri__nop 0
#define R_IRQ_MASK0_SET__par0_peri__par0_peri__set 1
#define R_IRQ_MASK0_SET__ata_irq2__ata_irq2__nop 0
#define R_IRQ_MASK0_SET__ata_irq2__ata_irq2__set 1
#define R_IRQ_MASK0_SET__par0_data__par0_data__nop 0
#define R_IRQ_MASK0_SET__par0_data__par0_data__set 1
#define R_IRQ_MASK0_SET__ata_irq1__ata_irq1__nop 0
#define R_IRQ_MASK0_SET__ata_irq1__ata_irq1__set 1
#define R_IRQ_MASK0_SET__par0_ready__par0_ready__nop 0
#define R_IRQ_MASK0_SET__par0_ready__par0_ready__set 1
#define R_IRQ_MASK0_SET__ata_irq0__ata_irq0__nop 0
#define R_IRQ_MASK0_SET__ata_irq0__ata_irq0__set 1
#define R_IRQ_MASK0_SET__mio__mio__nop 0
#define R_IRQ_MASK0_SET__mio__mio__set 1
#define R_IRQ_MASK0_SET__scsi0__scsi0__nop 0
#define R_IRQ_MASK0_SET__scsi0__scsi0__set 1
#define R_IRQ_MASK0_SET__ata_dmaend__ata_dmaend__nop 0
#define R_IRQ_MASK0_SET__ata_dmaend__ata_dmaend__set 1
#define R_IRQ_MASK0_SET__irq_ext_vector_nr__irq_ext_vector_nr__nop 0
#define R_IRQ_MASK0_SET__irq_ext_vector_nr__irq_ext_vector_nr__set 1
#define R_IRQ_MASK0_SET__irq_int_vector_nr__irq_int_vector_nr__nop 0
#define R_IRQ_MASK0_SET__irq_int_vector_nr__irq_int_vector_nr__set 1
#define R_IRQ_MASK0_SET__ext_dma1__ext_dma1__nop 0
#define R_IRQ_MASK0_SET__ext_dma1__ext_dma1__set 1
#define R_IRQ_MASK0_SET__ext_dma0__ext_dma0__nop 0
#define R_IRQ_MASK0_SET__ext_dma0__ext_dma0__set 1
#define R_IRQ_MASK0_SET__timer1__timer1__nop 0
#define R_IRQ_MASK0_SET__timer1__timer1__set 1
#define R_IRQ_MASK0_SET__timer0__timer0__nop 0
#define R_IRQ_MASK0_SET__timer0__timer0__set 1

#endif

/*
 *  R_IRQ_MASK1_CLR
 *  - type:  WO
 *  - addr:  0xb00000c8
 *  - group: Interrupt mask and status registers
 */

#if USE_GROUP__Interrupt_mask_and_status_registers

#define R_IRQ_MASK1_CLR__ADDR      (REG_TYPECAST_UDWORD  0xb00000c8)

#ifndef REG_NO_SHADOW
#define R_IRQ_MASK1_CLR__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_IRQ_MASK1_CLR + 0))
#define R_IRQ_MASK1_CLR__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_IRQ_MASK1_CLR + 0))
#else /* REG_NO_SHADOW */
#define R_IRQ_MASK1_CLR__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_IRQ_MASK1_CLR__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_IRQ_MASK1_CLR__STYPECAST REG_STYPECAST_UDWORD
#define R_IRQ_MASK1_CLR__SVAL REG_SVAL_ZERO
#define R_IRQ_MASK1_CLR__SVAL_I REG_SVAL_I_ZERO
#define R_IRQ_MASK1_CLR__TYPECAST  REG_TYPECAST_UDWORD
#define R_IRQ_MASK1_CLR__TYPE      (REG_UDWORD)
#define R_IRQ_MASK1_CLR__GET       REG_GET_WO
#define R_IRQ_MASK1_CLR__IGET      REG_IGET_WO
#define R_IRQ_MASK1_CLR__SET       REG_SET_WO
#define R_IRQ_MASK1_CLR__ISET      REG_ISET_WO
#define R_IRQ_MASK1_CLR__SET_VAL   REG_SET_VAL_WO
#define R_IRQ_MASK1_CLR__EQL       REG_EQL_WO
#define R_IRQ_MASK1_CLR__IEQL      REG_IEQL_WO
#define R_IRQ_MASK1_CLR__RD        REG_RD_WO
#define R_IRQ_MASK1_CLR__IRD       REG_IRD_WO
#define R_IRQ_MASK1_CLR__WR        REG_WR_WO
#define R_IRQ_MASK1_CLR__IWR       REG_IWR_WO

#define R_IRQ_MASK1_CLR__WRITE(addr,value) \
  (*(addr) = (value))

#define R_IRQ_MASK1_CLR__sw_int7__sw_int7__MASK 0x80000000U
#define R_IRQ_MASK1_CLR__sw_int6__sw_int6__MASK 0x40000000U
#define R_IRQ_MASK1_CLR__sw_int5__sw_int5__MASK 0x20000000U
#define R_IRQ_MASK1_CLR__sw_int4__sw_int4__MASK 0x10000000U
#define R_IRQ_MASK1_CLR__sw_int3__sw_int3__MASK 0x08000000U
#define R_IRQ_MASK1_CLR__sw_int2__sw_int2__MASK 0x04000000U
#define R_IRQ_MASK1_CLR__sw_int1__sw_int1__MASK 0x02000000U
#define R_IRQ_MASK1_CLR__sw_int0__sw_int0__MASK 0x01000000U
#define R_IRQ_MASK1_CLR__par1_ecp_cmd__par1_ecp_cmd__MASK 0x00080000U
#define R_IRQ_MASK1_CLR__par1_peri__par1_peri__MASK 0x00040000U
#define R_IRQ_MASK1_CLR__par1_data__par1_data__MASK 0x00020000U
#define R_IRQ_MASK1_CLR__par1_ready__par1_ready__MASK 0x00010000U
#define R_IRQ_MASK1_CLR__scsi1__scsi1__MASK 0x00010000U
#define R_IRQ_MASK1_CLR__par1_ready__scsi1__MASK 0x00010000U
#define R_IRQ_MASK1_CLR__ser3_ready__ser3_ready__MASK 0x00008000U
#define R_IRQ_MASK1_CLR__ser3_data__ser3_data__MASK 0x00004000U
#define R_IRQ_MASK1_CLR__ser2_ready__ser2_ready__MASK 0x00002000U
#define R_IRQ_MASK1_CLR__ser2_data__ser2_data__MASK 0x00001000U
#define R_IRQ_MASK1_CLR__ser1_ready__ser1_ready__MASK 0x00000800U
#define R_IRQ_MASK1_CLR__ser1_data__ser1_data__MASK 0x00000400U
#define R_IRQ_MASK1_CLR__ser0_ready__ser0_ready__MASK 0x00000200U
#define R_IRQ_MASK1_CLR__ser0_data__ser0_data__MASK 0x00000100U
#define R_IRQ_MASK1_CLR__pa7__pa7__MASK 0x00000080U
#define R_IRQ_MASK1_CLR__pa6__pa6__MASK 0x00000040U
#define R_IRQ_MASK1_CLR__pa5__pa5__MASK 0x00000020U
#define R_IRQ_MASK1_CLR__pa4__pa4__MASK 0x00000010U
#define R_IRQ_MASK1_CLR__pa3__pa3__MASK 0x00000008U
#define R_IRQ_MASK1_CLR__pa2__pa2__MASK 0x00000004U
#define R_IRQ_MASK1_CLR__pa1__pa1__MASK 0x00000002U
#define R_IRQ_MASK1_CLR__pa0__pa0__MASK 0x00000001U

#define R_IRQ_MASK1_CLR__sw_int7__MAX 0x1
#define R_IRQ_MASK1_CLR__sw_int6__MAX 0x1
#define R_IRQ_MASK1_CLR__sw_int5__MAX 0x1
#define R_IRQ_MASK1_CLR__sw_int4__MAX 0x1
#define R_IRQ_MASK1_CLR__sw_int3__MAX 0x1
#define R_IRQ_MASK1_CLR__sw_int2__MAX 0x1
#define R_IRQ_MASK1_CLR__sw_int1__MAX 0x1
#define R_IRQ_MASK1_CLR__sw_int0__MAX 0x1
#define R_IRQ_MASK1_CLR__par1_ecp_cmd__MAX 0x1
#define R_IRQ_MASK1_CLR__par1_peri__MAX 0x1
#define R_IRQ_MASK1_CLR__par1_data__MAX 0x1
#define R_IRQ_MASK1_CLR__par1_ready__MAX 0x1
#define R_IRQ_MASK1_CLR__scsi1__MAX 0x1
#define R_IRQ_MASK1_CLR__ser3_ready__MAX 0x1
#define R_IRQ_MASK1_CLR__ser3_data__MAX 0x1
#define R_IRQ_MASK1_CLR__ser2_ready__MAX 0x1
#define R_IRQ_MASK1_CLR__ser2_data__MAX 0x1
#define R_IRQ_MASK1_CLR__ser1_ready__MAX 0x1
#define R_IRQ_MASK1_CLR__ser1_data__MAX 0x1
#define R_IRQ_MASK1_CLR__ser0_ready__MAX 0x1
#define R_IRQ_MASK1_CLR__ser0_data__MAX 0x1
#define R_IRQ_MASK1_CLR__pa7__MAX 0x1
#define R_IRQ_MASK1_CLR__pa6__MAX 0x1
#define R_IRQ_MASK1_CLR__pa5__MAX 0x1
#define R_IRQ_MASK1_CLR__pa4__MAX 0x1
#define R_IRQ_MASK1_CLR__pa3__MAX 0x1
#define R_IRQ_MASK1_CLR__pa2__MAX 0x1
#define R_IRQ_MASK1_CLR__pa1__MAX 0x1
#define R_IRQ_MASK1_CLR__pa0__MAX 0x1

#define R_IRQ_MASK1_CLR__sw_int7__MIN 0
#define R_IRQ_MASK1_CLR__sw_int6__MIN 0
#define R_IRQ_MASK1_CLR__sw_int5__MIN 0
#define R_IRQ_MASK1_CLR__sw_int4__MIN 0
#define R_IRQ_MASK1_CLR__sw_int3__MIN 0
#define R_IRQ_MASK1_CLR__sw_int2__MIN 0
#define R_IRQ_MASK1_CLR__sw_int1__MIN 0
#define R_IRQ_MASK1_CLR__sw_int0__MIN 0
#define R_IRQ_MASK1_CLR__par1_ecp_cmd__MIN 0
#define R_IRQ_MASK1_CLR__par1_peri__MIN 0
#define R_IRQ_MASK1_CLR__par1_data__MIN 0
#define R_IRQ_MASK1_CLR__par1_ready__MIN 0
#define R_IRQ_MASK1_CLR__scsi1__MIN 0
#define R_IRQ_MASK1_CLR__ser3_ready__MIN 0
#define R_IRQ_MASK1_CLR__ser3_data__MIN 0
#define R_IRQ_MASK1_CLR__ser2_ready__MIN 0
#define R_IRQ_MASK1_CLR__ser2_data__MIN 0
#define R_IRQ_MASK1_CLR__ser1_ready__MIN 0
#define R_IRQ_MASK1_CLR__ser1_data__MIN 0
#define R_IRQ_MASK1_CLR__ser0_ready__MIN 0
#define R_IRQ_MASK1_CLR__ser0_data__MIN 0
#define R_IRQ_MASK1_CLR__pa7__MIN 0
#define R_IRQ_MASK1_CLR__pa6__MIN 0
#define R_IRQ_MASK1_CLR__pa5__MIN 0
#define R_IRQ_MASK1_CLR__pa4__MIN 0
#define R_IRQ_MASK1_CLR__pa3__MIN 0
#define R_IRQ_MASK1_CLR__pa2__MIN 0
#define R_IRQ_MASK1_CLR__pa1__MIN 0
#define R_IRQ_MASK1_CLR__pa0__MIN 0

#define R_IRQ_MASK1_CLR__sw_int7__BITNR 31
#define R_IRQ_MASK1_CLR__sw_int6__BITNR 30
#define R_IRQ_MASK1_CLR__sw_int5__BITNR 29
#define R_IRQ_MASK1_CLR__sw_int4__BITNR 28
#define R_IRQ_MASK1_CLR__sw_int3__BITNR 27
#define R_IRQ_MASK1_CLR__sw_int2__BITNR 26
#define R_IRQ_MASK1_CLR__sw_int1__BITNR 25
#define R_IRQ_MASK1_CLR__sw_int0__BITNR 24
#define R_IRQ_MASK1_CLR__par1_ecp_cmd__BITNR 19
#define R_IRQ_MASK1_CLR__par1_peri__BITNR 18
#define R_IRQ_MASK1_CLR__par1_data__BITNR 17
#define R_IRQ_MASK1_CLR__par1_ready__BITNR 16
#define R_IRQ_MASK1_CLR__scsi1__BITNR 16
#define R_IRQ_MASK1_CLR__ser3_ready__BITNR 15
#define R_IRQ_MASK1_CLR__ser3_data__BITNR 14
#define R_IRQ_MASK1_CLR__ser2_ready__BITNR 13
#define R_IRQ_MASK1_CLR__ser2_data__BITNR 12
#define R_IRQ_MASK1_CLR__ser1_ready__BITNR 11
#define R_IRQ_MASK1_CLR__ser1_data__BITNR 10
#define R_IRQ_MASK1_CLR__ser0_ready__BITNR 9
#define R_IRQ_MASK1_CLR__ser0_data__BITNR 8
#define R_IRQ_MASK1_CLR__pa7__BITNR 7
#define R_IRQ_MASK1_CLR__pa6__BITNR 6
#define R_IRQ_MASK1_CLR__pa5__BITNR 5
#define R_IRQ_MASK1_CLR__pa4__BITNR 4
#define R_IRQ_MASK1_CLR__pa3__BITNR 3
#define R_IRQ_MASK1_CLR__pa2__BITNR 2
#define R_IRQ_MASK1_CLR__pa1__BITNR 1
#define R_IRQ_MASK1_CLR__pa0__BITNR 0

#define R_IRQ_MASK1_CLR__sw_int7__sw_int7__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_CLR__sw_int6__sw_int6__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_CLR__sw_int5__sw_int5__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_CLR__sw_int4__sw_int4__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_CLR__sw_int3__sw_int3__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_CLR__sw_int2__sw_int2__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_CLR__sw_int1__sw_int1__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_CLR__sw_int0__sw_int0__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_CLR__par1_ecp_cmd__par1_ecp_cmd__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_CLR__par1_peri__par1_peri__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_CLR__par1_data__par1_data__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_CLR__par1_ready__par1_ready__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_CLR__scsi1__scsi1__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_CLR__par1_ready__scsi1__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_CLR__ser3_ready__ser3_ready__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_CLR__ser3_data__ser3_data__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_CLR__ser2_ready__ser2_ready__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_CLR__ser2_data__ser2_data__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_CLR__ser1_ready__ser1_ready__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_CLR__ser1_data__ser1_data__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_CLR__ser0_ready__ser0_ready__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_CLR__ser0_data__ser0_data__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_CLR__pa7__pa7__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_CLR__pa6__pa6__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_CLR__pa5__pa5__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_CLR__pa4__pa4__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_CLR__pa3__pa3__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_CLR__pa2__pa2__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_CLR__pa1__pa1__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_CLR__pa0__pa0__VAL REG_VAL_ENUM

#define R_IRQ_MASK1_CLR__sw_int7__sw_int7__clr 1
#define R_IRQ_MASK1_CLR__sw_int7__sw_int7__nop 0
#define R_IRQ_MASK1_CLR__sw_int6__sw_int6__clr 1
#define R_IRQ_MASK1_CLR__sw_int6__sw_int6__nop 0
#define R_IRQ_MASK1_CLR__sw_int5__sw_int5__clr 1
#define R_IRQ_MASK1_CLR__sw_int5__sw_int5__nop 0
#define R_IRQ_MASK1_CLR__sw_int4__sw_int4__clr 1
#define R_IRQ_MASK1_CLR__sw_int4__sw_int4__nop 0
#define R_IRQ_MASK1_CLR__sw_int3__sw_int3__clr 1
#define R_IRQ_MASK1_CLR__sw_int3__sw_int3__nop 0
#define R_IRQ_MASK1_CLR__sw_int2__sw_int2__clr 1
#define R_IRQ_MASK1_CLR__sw_int2__sw_int2__nop 0
#define R_IRQ_MASK1_CLR__sw_int1__sw_int1__clr 1
#define R_IRQ_MASK1_CLR__sw_int1__sw_int1__nop 0
#define R_IRQ_MASK1_CLR__sw_int0__sw_int0__clr 1
#define R_IRQ_MASK1_CLR__sw_int0__sw_int0__nop 0
#define R_IRQ_MASK1_CLR__par1_ecp_cmd__par1_ecp_cmd__clr 1
#define R_IRQ_MASK1_CLR__par1_ecp_cmd__par1_ecp_cmd__nop 0
#define R_IRQ_MASK1_CLR__par1_peri__par1_peri__clr 1
#define R_IRQ_MASK1_CLR__par1_peri__par1_peri__nop 0
#define R_IRQ_MASK1_CLR__par1_data__par1_data__clr 1
#define R_IRQ_MASK1_CLR__par1_data__par1_data__nop 0
#define R_IRQ_MASK1_CLR__par1_ready__par1_ready__clr 1
#define R_IRQ_MASK1_CLR__par1_ready__par1_ready__nop 0
#define R_IRQ_MASK1_CLR__scsi1__scsi1__clr 1
#define R_IRQ_MASK1_CLR__scsi1__scsi1__nop 0
#define R_IRQ_MASK1_CLR__ser3_ready__ser3_ready__clr 1
#define R_IRQ_MASK1_CLR__ser3_ready__ser3_ready__nop 0
#define R_IRQ_MASK1_CLR__ser3_data__ser3_data__clr 1
#define R_IRQ_MASK1_CLR__ser3_data__ser3_data__nop 0
#define R_IRQ_MASK1_CLR__ser2_ready__ser2_ready__clr 1
#define R_IRQ_MASK1_CLR__ser2_ready__ser2_ready__nop 0
#define R_IRQ_MASK1_CLR__ser2_data__ser2_data__clr 1
#define R_IRQ_MASK1_CLR__ser2_data__ser2_data__nop 0
#define R_IRQ_MASK1_CLR__ser1_ready__ser1_ready__clr 1
#define R_IRQ_MASK1_CLR__ser1_ready__ser1_ready__nop 0
#define R_IRQ_MASK1_CLR__ser1_data__ser1_data__clr 1
#define R_IRQ_MASK1_CLR__ser1_data__ser1_data__nop 0
#define R_IRQ_MASK1_CLR__ser0_ready__ser0_ready__clr 1
#define R_IRQ_MASK1_CLR__ser0_ready__ser0_ready__nop 0
#define R_IRQ_MASK1_CLR__ser0_data__ser0_data__clr 1
#define R_IRQ_MASK1_CLR__ser0_data__ser0_data__nop 0
#define R_IRQ_MASK1_CLR__pa7__pa7__clr 1
#define R_IRQ_MASK1_CLR__pa7__pa7__nop 0
#define R_IRQ_MASK1_CLR__pa6__pa6__clr 1
#define R_IRQ_MASK1_CLR__pa6__pa6__nop 0
#define R_IRQ_MASK1_CLR__pa5__pa5__clr 1
#define R_IRQ_MASK1_CLR__pa5__pa5__nop 0
#define R_IRQ_MASK1_CLR__pa4__pa4__clr 1
#define R_IRQ_MASK1_CLR__pa4__pa4__nop 0
#define R_IRQ_MASK1_CLR__pa3__pa3__clr 1
#define R_IRQ_MASK1_CLR__pa3__pa3__nop 0
#define R_IRQ_MASK1_CLR__pa2__pa2__clr 1
#define R_IRQ_MASK1_CLR__pa2__pa2__nop 0
#define R_IRQ_MASK1_CLR__pa1__pa1__clr 1
#define R_IRQ_MASK1_CLR__pa1__pa1__nop 0
#define R_IRQ_MASK1_CLR__pa0__pa0__clr 1
#define R_IRQ_MASK1_CLR__pa0__pa0__nop 0

#endif

/*
 *  R_IRQ_MASK1_RD
 *  - type:  RO
 *  - addr:  0xb00000c8
 *  - group: Interrupt mask and status registers
 */

#if USE_GROUP__Interrupt_mask_and_status_registers

#define R_IRQ_MASK1_RD__ADDR      (REG_TYPECAST_UDWORD  0xb00000c8)
#define R_IRQ_MASK1_RD__SVAL      REG_SVAL_SHADOW
#define R_IRQ_MASK1_RD__SVAL_I    REG_SVAL_I_SHADOW
#define R_IRQ_MASK1_RD__TYPECAST  REG_TYPECAST_UDWORD
#define R_IRQ_MASK1_RD__TYPE      (REG_UDWORD)
#define R_IRQ_MASK1_RD__GET       REG_GET_RO
#define R_IRQ_MASK1_RD__IGET      REG_IGET_RO
#define R_IRQ_MASK1_RD__SET       REG_SET_RO
#define R_IRQ_MASK1_RD__ISET      REG_ISET_RO
#define R_IRQ_MASK1_RD__SET_VAL   REG_SET_VAL_RO
#define R_IRQ_MASK1_RD__EQL       REG_EQL_RO
#define R_IRQ_MASK1_RD__IEQL      REG_IEQL_RO
#define R_IRQ_MASK1_RD__RD        REG_RD_RO
#define R_IRQ_MASK1_RD__IRD       REG_IRD_RO
#define R_IRQ_MASK1_RD__WR        REG_WR_RO
#define R_IRQ_MASK1_RD__IWR       REG_IWR_RO

#define R_IRQ_MASK1_RD__READ(addr) \
  (*(addr))

#define R_IRQ_MASK1_RD__sw_int7__sw_int7__MASK 0x80000000U
#define R_IRQ_MASK1_RD__sw_int6__sw_int6__MASK 0x40000000U
#define R_IRQ_MASK1_RD__sw_int5__sw_int5__MASK 0x20000000U
#define R_IRQ_MASK1_RD__sw_int4__sw_int4__MASK 0x10000000U
#define R_IRQ_MASK1_RD__sw_int3__sw_int3__MASK 0x08000000U
#define R_IRQ_MASK1_RD__sw_int2__sw_int2__MASK 0x04000000U
#define R_IRQ_MASK1_RD__sw_int1__sw_int1__MASK 0x02000000U
#define R_IRQ_MASK1_RD__sw_int0__sw_int0__MASK 0x01000000U
#define R_IRQ_MASK1_RD__par1_ecp_cmd__par1_ecp_cmd__MASK 0x00080000U
#define R_IRQ_MASK1_RD__par1_peri__par1_peri__MASK 0x00040000U
#define R_IRQ_MASK1_RD__par1_data__par1_data__MASK 0x00020000U
#define R_IRQ_MASK1_RD__par1_ready__par1_ready__MASK 0x00010000U
#define R_IRQ_MASK1_RD__scsi1__scsi1__MASK 0x00010000U
#define R_IRQ_MASK1_RD__par1_ready__scsi1__MASK 0x00010000U
#define R_IRQ_MASK1_RD__ser3_ready__ser3_ready__MASK 0x00008000U
#define R_IRQ_MASK1_RD__ser3_data__ser3_data__MASK 0x00004000U
#define R_IRQ_MASK1_RD__ser2_ready__ser2_ready__MASK 0x00002000U
#define R_IRQ_MASK1_RD__ser2_data__ser2_data__MASK 0x00001000U
#define R_IRQ_MASK1_RD__ser1_ready__ser1_ready__MASK 0x00000800U
#define R_IRQ_MASK1_RD__ser1_data__ser1_data__MASK 0x00000400U
#define R_IRQ_MASK1_RD__ser0_ready__ser0_ready__MASK 0x00000200U
#define R_IRQ_MASK1_RD__ser0_data__ser0_data__MASK 0x00000100U
#define R_IRQ_MASK1_RD__pa7__pa7__MASK 0x00000080U
#define R_IRQ_MASK1_RD__pa6__pa6__MASK 0x00000040U
#define R_IRQ_MASK1_RD__pa5__pa5__MASK 0x00000020U
#define R_IRQ_MASK1_RD__pa4__pa4__MASK 0x00000010U
#define R_IRQ_MASK1_RD__pa3__pa3__MASK 0x00000008U
#define R_IRQ_MASK1_RD__pa2__pa2__MASK 0x00000004U
#define R_IRQ_MASK1_RD__pa1__pa1__MASK 0x00000002U
#define R_IRQ_MASK1_RD__pa0__pa0__MASK 0x00000001U

#define R_IRQ_MASK1_RD__sw_int7__MAX 0x1
#define R_IRQ_MASK1_RD__sw_int6__MAX 0x1
#define R_IRQ_MASK1_RD__sw_int5__MAX 0x1
#define R_IRQ_MASK1_RD__sw_int4__MAX 0x1
#define R_IRQ_MASK1_RD__sw_int3__MAX 0x1
#define R_IRQ_MASK1_RD__sw_int2__MAX 0x1
#define R_IRQ_MASK1_RD__sw_int1__MAX 0x1
#define R_IRQ_MASK1_RD__sw_int0__MAX 0x1
#define R_IRQ_MASK1_RD__par1_ecp_cmd__MAX 0x1
#define R_IRQ_MASK1_RD__par1_peri__MAX 0x1
#define R_IRQ_MASK1_RD__par1_data__MAX 0x1
#define R_IRQ_MASK1_RD__par1_ready__MAX 0x1
#define R_IRQ_MASK1_RD__scsi1__MAX 0x1
#define R_IRQ_MASK1_RD__ser3_ready__MAX 0x1
#define R_IRQ_MASK1_RD__ser3_data__MAX 0x1
#define R_IRQ_MASK1_RD__ser2_ready__MAX 0x1
#define R_IRQ_MASK1_RD__ser2_data__MAX 0x1
#define R_IRQ_MASK1_RD__ser1_ready__MAX 0x1
#define R_IRQ_MASK1_RD__ser1_data__MAX 0x1
#define R_IRQ_MASK1_RD__ser0_ready__MAX 0x1
#define R_IRQ_MASK1_RD__ser0_data__MAX 0x1
#define R_IRQ_MASK1_RD__pa7__MAX 0x1
#define R_IRQ_MASK1_RD__pa6__MAX 0x1
#define R_IRQ_MASK1_RD__pa5__MAX 0x1
#define R_IRQ_MASK1_RD__pa4__MAX 0x1
#define R_IRQ_MASK1_RD__pa3__MAX 0x1
#define R_IRQ_MASK1_RD__pa2__MAX 0x1
#define R_IRQ_MASK1_RD__pa1__MAX 0x1
#define R_IRQ_MASK1_RD__pa0__MAX 0x1

#define R_IRQ_MASK1_RD__sw_int7__MIN 0
#define R_IRQ_MASK1_RD__sw_int6__MIN 0
#define R_IRQ_MASK1_RD__sw_int5__MIN 0
#define R_IRQ_MASK1_RD__sw_int4__MIN 0
#define R_IRQ_MASK1_RD__sw_int3__MIN 0
#define R_IRQ_MASK1_RD__sw_int2__MIN 0
#define R_IRQ_MASK1_RD__sw_int1__MIN 0
#define R_IRQ_MASK1_RD__sw_int0__MIN 0
#define R_IRQ_MASK1_RD__par1_ecp_cmd__MIN 0
#define R_IRQ_MASK1_RD__par1_peri__MIN 0
#define R_IRQ_MASK1_RD__par1_data__MIN 0
#define R_IRQ_MASK1_RD__par1_ready__MIN 0
#define R_IRQ_MASK1_RD__scsi1__MIN 0
#define R_IRQ_MASK1_RD__ser3_ready__MIN 0
#define R_IRQ_MASK1_RD__ser3_data__MIN 0
#define R_IRQ_MASK1_RD__ser2_ready__MIN 0
#define R_IRQ_MASK1_RD__ser2_data__MIN 0
#define R_IRQ_MASK1_RD__ser1_ready__MIN 0
#define R_IRQ_MASK1_RD__ser1_data__MIN 0
#define R_IRQ_MASK1_RD__ser0_ready__MIN 0
#define R_IRQ_MASK1_RD__ser0_data__MIN 0
#define R_IRQ_MASK1_RD__pa7__MIN 0
#define R_IRQ_MASK1_RD__pa6__MIN 0
#define R_IRQ_MASK1_RD__pa5__MIN 0
#define R_IRQ_MASK1_RD__pa4__MIN 0
#define R_IRQ_MASK1_RD__pa3__MIN 0
#define R_IRQ_MASK1_RD__pa2__MIN 0
#define R_IRQ_MASK1_RD__pa1__MIN 0
#define R_IRQ_MASK1_RD__pa0__MIN 0

#define R_IRQ_MASK1_RD__sw_int7__BITNR 31
#define R_IRQ_MASK1_RD__sw_int6__BITNR 30
#define R_IRQ_MASK1_RD__sw_int5__BITNR 29
#define R_IRQ_MASK1_RD__sw_int4__BITNR 28
#define R_IRQ_MASK1_RD__sw_int3__BITNR 27
#define R_IRQ_MASK1_RD__sw_int2__BITNR 26
#define R_IRQ_MASK1_RD__sw_int1__BITNR 25
#define R_IRQ_MASK1_RD__sw_int0__BITNR 24
#define R_IRQ_MASK1_RD__par1_ecp_cmd__BITNR 19
#define R_IRQ_MASK1_RD__par1_peri__BITNR 18
#define R_IRQ_MASK1_RD__par1_data__BITNR 17
#define R_IRQ_MASK1_RD__par1_ready__BITNR 16
#define R_IRQ_MASK1_RD__scsi1__BITNR 16
#define R_IRQ_MASK1_RD__ser3_ready__BITNR 15
#define R_IRQ_MASK1_RD__ser3_data__BITNR 14
#define R_IRQ_MASK1_RD__ser2_ready__BITNR 13
#define R_IRQ_MASK1_RD__ser2_data__BITNR 12
#define R_IRQ_MASK1_RD__ser1_ready__BITNR 11
#define R_IRQ_MASK1_RD__ser1_data__BITNR 10
#define R_IRQ_MASK1_RD__ser0_ready__BITNR 9
#define R_IRQ_MASK1_RD__ser0_data__BITNR 8
#define R_IRQ_MASK1_RD__pa7__BITNR 7
#define R_IRQ_MASK1_RD__pa6__BITNR 6
#define R_IRQ_MASK1_RD__pa5__BITNR 5
#define R_IRQ_MASK1_RD__pa4__BITNR 4
#define R_IRQ_MASK1_RD__pa3__BITNR 3
#define R_IRQ_MASK1_RD__pa2__BITNR 2
#define R_IRQ_MASK1_RD__pa1__BITNR 1
#define R_IRQ_MASK1_RD__pa0__BITNR 0

#define R_IRQ_MASK1_RD__sw_int7__sw_int7__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_RD__sw_int6__sw_int6__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_RD__sw_int5__sw_int5__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_RD__sw_int4__sw_int4__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_RD__sw_int3__sw_int3__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_RD__sw_int2__sw_int2__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_RD__sw_int1__sw_int1__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_RD__sw_int0__sw_int0__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_RD__par1_ecp_cmd__par1_ecp_cmd__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_RD__par1_peri__par1_peri__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_RD__par1_data__par1_data__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_RD__par1_ready__par1_ready__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_RD__scsi1__scsi1__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_RD__par1_ready__scsi1__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_RD__ser3_ready__ser3_ready__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_RD__ser3_data__ser3_data__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_RD__ser2_ready__ser2_ready__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_RD__ser2_data__ser2_data__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_RD__ser1_ready__ser1_ready__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_RD__ser1_data__ser1_data__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_RD__ser0_ready__ser0_ready__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_RD__ser0_data__ser0_data__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_RD__pa7__pa7__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_RD__pa6__pa6__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_RD__pa5__pa5__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_RD__pa4__pa4__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_RD__pa3__pa3__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_RD__pa2__pa2__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_RD__pa1__pa1__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_RD__pa0__pa0__VAL REG_VAL_ENUM

#define R_IRQ_MASK1_RD__sw_int7__sw_int7__active 1
#define R_IRQ_MASK1_RD__sw_int7__sw_int7__inactive 0
#define R_IRQ_MASK1_RD__sw_int6__sw_int6__active 1
#define R_IRQ_MASK1_RD__sw_int6__sw_int6__inactive 0
#define R_IRQ_MASK1_RD__sw_int5__sw_int5__active 1
#define R_IRQ_MASK1_RD__sw_int5__sw_int5__inactive 0
#define R_IRQ_MASK1_RD__sw_int4__sw_int4__active 1
#define R_IRQ_MASK1_RD__sw_int4__sw_int4__inactive 0
#define R_IRQ_MASK1_RD__sw_int3__sw_int3__active 1
#define R_IRQ_MASK1_RD__sw_int3__sw_int3__inactive 0
#define R_IRQ_MASK1_RD__sw_int2__sw_int2__active 1
#define R_IRQ_MASK1_RD__sw_int2__sw_int2__inactive 0
#define R_IRQ_MASK1_RD__sw_int1__sw_int1__active 1
#define R_IRQ_MASK1_RD__sw_int1__sw_int1__inactive 0
#define R_IRQ_MASK1_RD__sw_int0__sw_int0__active 1
#define R_IRQ_MASK1_RD__sw_int0__sw_int0__inactive 0
#define R_IRQ_MASK1_RD__par1_ecp_cmd__par1_ecp_cmd__active 1
#define R_IRQ_MASK1_RD__par1_ecp_cmd__par1_ecp_cmd__inactive 0
#define R_IRQ_MASK1_RD__par1_peri__par1_peri__active 1
#define R_IRQ_MASK1_RD__par1_peri__par1_peri__inactive 0
#define R_IRQ_MASK1_RD__par1_data__par1_data__active 1
#define R_IRQ_MASK1_RD__par1_data__par1_data__inactive 0
#define R_IRQ_MASK1_RD__par1_ready__par1_ready__active 1
#define R_IRQ_MASK1_RD__par1_ready__par1_ready__inactive 0
#define R_IRQ_MASK1_RD__scsi1__scsi1__active 1
#define R_IRQ_MASK1_RD__scsi1__scsi1__inactive 0
#define R_IRQ_MASK1_RD__ser3_ready__ser3_ready__active 1
#define R_IRQ_MASK1_RD__ser3_ready__ser3_ready__inactive 0
#define R_IRQ_MASK1_RD__ser3_data__ser3_data__active 1
#define R_IRQ_MASK1_RD__ser3_data__ser3_data__inactive 0
#define R_IRQ_MASK1_RD__ser2_ready__ser2_ready__active 1
#define R_IRQ_MASK1_RD__ser2_ready__ser2_ready__inactive 0
#define R_IRQ_MASK1_RD__ser2_data__ser2_data__active 1
#define R_IRQ_MASK1_RD__ser2_data__ser2_data__inactive 0
#define R_IRQ_MASK1_RD__ser1_ready__ser1_ready__active 1
#define R_IRQ_MASK1_RD__ser1_ready__ser1_ready__inactive 0
#define R_IRQ_MASK1_RD__ser1_data__ser1_data__active 1
#define R_IRQ_MASK1_RD__ser1_data__ser1_data__inactive 0
#define R_IRQ_MASK1_RD__ser0_ready__ser0_ready__active 1
#define R_IRQ_MASK1_RD__ser0_ready__ser0_ready__inactive 0
#define R_IRQ_MASK1_RD__ser0_data__ser0_data__active 1
#define R_IRQ_MASK1_RD__ser0_data__ser0_data__inactive 0
#define R_IRQ_MASK1_RD__pa7__pa7__active 1
#define R_IRQ_MASK1_RD__pa7__pa7__inactive 0
#define R_IRQ_MASK1_RD__pa6__pa6__active 1
#define R_IRQ_MASK1_RD__pa6__pa6__inactive 0
#define R_IRQ_MASK1_RD__pa5__pa5__active 1
#define R_IRQ_MASK1_RD__pa5__pa5__inactive 0
#define R_IRQ_MASK1_RD__pa4__pa4__active 1
#define R_IRQ_MASK1_RD__pa4__pa4__inactive 0
#define R_IRQ_MASK1_RD__pa3__pa3__active 1
#define R_IRQ_MASK1_RD__pa3__pa3__inactive 0
#define R_IRQ_MASK1_RD__pa2__pa2__active 1
#define R_IRQ_MASK1_RD__pa2__pa2__inactive 0
#define R_IRQ_MASK1_RD__pa1__pa1__active 1
#define R_IRQ_MASK1_RD__pa1__pa1__inactive 0
#define R_IRQ_MASK1_RD__pa0__pa0__active 1
#define R_IRQ_MASK1_RD__pa0__pa0__inactive 0

#endif

/*
 *  R_IRQ_MASK1_SET
 *  - type:  WO
 *  - addr:  0xb00000cc
 *  - group: Interrupt mask and status registers
 */

#if USE_GROUP__Interrupt_mask_and_status_registers

#define R_IRQ_MASK1_SET__ADDR      (REG_TYPECAST_UDWORD  0xb00000cc)

#ifndef REG_NO_SHADOW
#define R_IRQ_MASK1_SET__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_IRQ_MASK1_SET + 0))
#define R_IRQ_MASK1_SET__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_IRQ_MASK1_SET + 0))
#else /* REG_NO_SHADOW */
#define R_IRQ_MASK1_SET__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_IRQ_MASK1_SET__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_IRQ_MASK1_SET__STYPECAST REG_STYPECAST_UDWORD
#define R_IRQ_MASK1_SET__SVAL REG_SVAL_ZERO
#define R_IRQ_MASK1_SET__SVAL_I REG_SVAL_I_ZERO
#define R_IRQ_MASK1_SET__TYPECAST  REG_TYPECAST_UDWORD
#define R_IRQ_MASK1_SET__TYPE      (REG_UDWORD)
#define R_IRQ_MASK1_SET__GET       REG_GET_WO
#define R_IRQ_MASK1_SET__IGET      REG_IGET_WO
#define R_IRQ_MASK1_SET__SET       REG_SET_WO
#define R_IRQ_MASK1_SET__ISET      REG_ISET_WO
#define R_IRQ_MASK1_SET__SET_VAL   REG_SET_VAL_WO
#define R_IRQ_MASK1_SET__EQL       REG_EQL_WO
#define R_IRQ_MASK1_SET__IEQL      REG_IEQL_WO
#define R_IRQ_MASK1_SET__RD        REG_RD_WO
#define R_IRQ_MASK1_SET__IRD       REG_IRD_WO
#define R_IRQ_MASK1_SET__WR        REG_WR_WO
#define R_IRQ_MASK1_SET__IWR       REG_IWR_WO

#define R_IRQ_MASK1_SET__WRITE(addr,value) \
  (*(addr) = (value))

#define R_IRQ_MASK1_SET__sw_int7__sw_int7__MASK 0x80000000U
#define R_IRQ_MASK1_SET__sw_int6__sw_int6__MASK 0x40000000U
#define R_IRQ_MASK1_SET__sw_int5__sw_int5__MASK 0x20000000U
#define R_IRQ_MASK1_SET__sw_int4__sw_int4__MASK 0x10000000U
#define R_IRQ_MASK1_SET__sw_int3__sw_int3__MASK 0x08000000U
#define R_IRQ_MASK1_SET__sw_int2__sw_int2__MASK 0x04000000U
#define R_IRQ_MASK1_SET__sw_int1__sw_int1__MASK 0x02000000U
#define R_IRQ_MASK1_SET__sw_int0__sw_int0__MASK 0x01000000U
#define R_IRQ_MASK1_SET__par1_ecp_cmd__par1_ecp_cmd__MASK 0x00080000U
#define R_IRQ_MASK1_SET__par1_peri__par1_peri__MASK 0x00040000U
#define R_IRQ_MASK1_SET__par1_data__par1_data__MASK 0x00020000U
#define R_IRQ_MASK1_SET__par1_ready__par1_ready__MASK 0x00010000U
#define R_IRQ_MASK1_SET__scsi1__scsi1__MASK 0x00010000U
#define R_IRQ_MASK1_SET__par1_ready__scsi1__MASK 0x00010000U
#define R_IRQ_MASK1_SET__ser3_ready__ser3_ready__MASK 0x00008000U
#define R_IRQ_MASK1_SET__ser3_data__ser3_data__MASK 0x00004000U
#define R_IRQ_MASK1_SET__ser2_ready__ser2_ready__MASK 0x00002000U
#define R_IRQ_MASK1_SET__ser2_data__ser2_data__MASK 0x00001000U
#define R_IRQ_MASK1_SET__ser1_ready__ser1_ready__MASK 0x00000800U
#define R_IRQ_MASK1_SET__ser1_data__ser1_data__MASK 0x00000400U
#define R_IRQ_MASK1_SET__ser0_ready__ser0_ready__MASK 0x00000200U
#define R_IRQ_MASK1_SET__ser0_data__ser0_data__MASK 0x00000100U
#define R_IRQ_MASK1_SET__pa7__pa7__MASK 0x00000080U
#define R_IRQ_MASK1_SET__pa6__pa6__MASK 0x00000040U
#define R_IRQ_MASK1_SET__pa5__pa5__MASK 0x00000020U
#define R_IRQ_MASK1_SET__pa4__pa4__MASK 0x00000010U
#define R_IRQ_MASK1_SET__pa3__pa3__MASK 0x00000008U
#define R_IRQ_MASK1_SET__pa2__pa2__MASK 0x00000004U
#define R_IRQ_MASK1_SET__pa1__pa1__MASK 0x00000002U
#define R_IRQ_MASK1_SET__pa0__pa0__MASK 0x00000001U

#define R_IRQ_MASK1_SET__sw_int7__MAX 0x1
#define R_IRQ_MASK1_SET__sw_int6__MAX 0x1
#define R_IRQ_MASK1_SET__sw_int5__MAX 0x1
#define R_IRQ_MASK1_SET__sw_int4__MAX 0x1
#define R_IRQ_MASK1_SET__sw_int3__MAX 0x1
#define R_IRQ_MASK1_SET__sw_int2__MAX 0x1
#define R_IRQ_MASK1_SET__sw_int1__MAX 0x1
#define R_IRQ_MASK1_SET__sw_int0__MAX 0x1
#define R_IRQ_MASK1_SET__par1_ecp_cmd__MAX 0x1
#define R_IRQ_MASK1_SET__par1_peri__MAX 0x1
#define R_IRQ_MASK1_SET__par1_data__MAX 0x1
#define R_IRQ_MASK1_SET__par1_ready__MAX 0x1
#define R_IRQ_MASK1_SET__scsi1__MAX 0x1
#define R_IRQ_MASK1_SET__ser3_ready__MAX 0x1
#define R_IRQ_MASK1_SET__ser3_data__MAX 0x1
#define R_IRQ_MASK1_SET__ser2_ready__MAX 0x1
#define R_IRQ_MASK1_SET__ser2_data__MAX 0x1
#define R_IRQ_MASK1_SET__ser1_ready__MAX 0x1
#define R_IRQ_MASK1_SET__ser1_data__MAX 0x1
#define R_IRQ_MASK1_SET__ser0_ready__MAX 0x1
#define R_IRQ_MASK1_SET__ser0_data__MAX 0x1
#define R_IRQ_MASK1_SET__pa7__MAX 0x1
#define R_IRQ_MASK1_SET__pa6__MAX 0x1
#define R_IRQ_MASK1_SET__pa5__MAX 0x1
#define R_IRQ_MASK1_SET__pa4__MAX 0x1
#define R_IRQ_MASK1_SET__pa3__MAX 0x1
#define R_IRQ_MASK1_SET__pa2__MAX 0x1
#define R_IRQ_MASK1_SET__pa1__MAX 0x1
#define R_IRQ_MASK1_SET__pa0__MAX 0x1

#define R_IRQ_MASK1_SET__sw_int7__MIN 0
#define R_IRQ_MASK1_SET__sw_int6__MIN 0
#define R_IRQ_MASK1_SET__sw_int5__MIN 0
#define R_IRQ_MASK1_SET__sw_int4__MIN 0
#define R_IRQ_MASK1_SET__sw_int3__MIN 0
#define R_IRQ_MASK1_SET__sw_int2__MIN 0
#define R_IRQ_MASK1_SET__sw_int1__MIN 0
#define R_IRQ_MASK1_SET__sw_int0__MIN 0
#define R_IRQ_MASK1_SET__par1_ecp_cmd__MIN 0
#define R_IRQ_MASK1_SET__par1_peri__MIN 0
#define R_IRQ_MASK1_SET__par1_data__MIN 0
#define R_IRQ_MASK1_SET__par1_ready__MIN 0
#define R_IRQ_MASK1_SET__scsi1__MIN 0
#define R_IRQ_MASK1_SET__ser3_ready__MIN 0
#define R_IRQ_MASK1_SET__ser3_data__MIN 0
#define R_IRQ_MASK1_SET__ser2_ready__MIN 0
#define R_IRQ_MASK1_SET__ser2_data__MIN 0
#define R_IRQ_MASK1_SET__ser1_ready__MIN 0
#define R_IRQ_MASK1_SET__ser1_data__MIN 0
#define R_IRQ_MASK1_SET__ser0_ready__MIN 0
#define R_IRQ_MASK1_SET__ser0_data__MIN 0
#define R_IRQ_MASK1_SET__pa7__MIN 0
#define R_IRQ_MASK1_SET__pa6__MIN 0
#define R_IRQ_MASK1_SET__pa5__MIN 0
#define R_IRQ_MASK1_SET__pa4__MIN 0
#define R_IRQ_MASK1_SET__pa3__MIN 0
#define R_IRQ_MASK1_SET__pa2__MIN 0
#define R_IRQ_MASK1_SET__pa1__MIN 0
#define R_IRQ_MASK1_SET__pa0__MIN 0

#define R_IRQ_MASK1_SET__sw_int7__BITNR 31
#define R_IRQ_MASK1_SET__sw_int6__BITNR 30
#define R_IRQ_MASK1_SET__sw_int5__BITNR 29
#define R_IRQ_MASK1_SET__sw_int4__BITNR 28
#define R_IRQ_MASK1_SET__sw_int3__BITNR 27
#define R_IRQ_MASK1_SET__sw_int2__BITNR 26
#define R_IRQ_MASK1_SET__sw_int1__BITNR 25
#define R_IRQ_MASK1_SET__sw_int0__BITNR 24
#define R_IRQ_MASK1_SET__par1_ecp_cmd__BITNR 19
#define R_IRQ_MASK1_SET__par1_peri__BITNR 18
#define R_IRQ_MASK1_SET__par1_data__BITNR 17
#define R_IRQ_MASK1_SET__par1_ready__BITNR 16
#define R_IRQ_MASK1_SET__scsi1__BITNR 16
#define R_IRQ_MASK1_SET__ser3_ready__BITNR 15
#define R_IRQ_MASK1_SET__ser3_data__BITNR 14
#define R_IRQ_MASK1_SET__ser2_ready__BITNR 13
#define R_IRQ_MASK1_SET__ser2_data__BITNR 12
#define R_IRQ_MASK1_SET__ser1_ready__BITNR 11
#define R_IRQ_MASK1_SET__ser1_data__BITNR 10
#define R_IRQ_MASK1_SET__ser0_ready__BITNR 9
#define R_IRQ_MASK1_SET__ser0_data__BITNR 8
#define R_IRQ_MASK1_SET__pa7__BITNR 7
#define R_IRQ_MASK1_SET__pa6__BITNR 6
#define R_IRQ_MASK1_SET__pa5__BITNR 5
#define R_IRQ_MASK1_SET__pa4__BITNR 4
#define R_IRQ_MASK1_SET__pa3__BITNR 3
#define R_IRQ_MASK1_SET__pa2__BITNR 2
#define R_IRQ_MASK1_SET__pa1__BITNR 1
#define R_IRQ_MASK1_SET__pa0__BITNR 0

#define R_IRQ_MASK1_SET__sw_int7__sw_int7__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_SET__sw_int6__sw_int6__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_SET__sw_int5__sw_int5__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_SET__sw_int4__sw_int4__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_SET__sw_int3__sw_int3__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_SET__sw_int2__sw_int2__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_SET__sw_int1__sw_int1__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_SET__sw_int0__sw_int0__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_SET__par1_ecp_cmd__par1_ecp_cmd__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_SET__par1_peri__par1_peri__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_SET__par1_data__par1_data__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_SET__par1_ready__par1_ready__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_SET__scsi1__scsi1__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_SET__par1_ready__scsi1__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_SET__ser3_ready__ser3_ready__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_SET__ser3_data__ser3_data__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_SET__ser2_ready__ser2_ready__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_SET__ser2_data__ser2_data__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_SET__ser1_ready__ser1_ready__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_SET__ser1_data__ser1_data__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_SET__ser0_ready__ser0_ready__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_SET__ser0_data__ser0_data__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_SET__pa7__pa7__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_SET__pa6__pa6__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_SET__pa5__pa5__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_SET__pa4__pa4__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_SET__pa3__pa3__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_SET__pa2__pa2__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_SET__pa1__pa1__VAL REG_VAL_ENUM
#define R_IRQ_MASK1_SET__pa0__pa0__VAL REG_VAL_ENUM

#define R_IRQ_MASK1_SET__sw_int7__sw_int7__nop 0
#define R_IRQ_MASK1_SET__sw_int7__sw_int7__set 1
#define R_IRQ_MASK1_SET__sw_int6__sw_int6__nop 0
#define R_IRQ_MASK1_SET__sw_int6__sw_int6__set 1
#define R_IRQ_MASK1_SET__sw_int5__sw_int5__nop 0
#define R_IRQ_MASK1_SET__sw_int5__sw_int5__set 1
#define R_IRQ_MASK1_SET__sw_int4__sw_int4__nop 0
#define R_IRQ_MASK1_SET__sw_int4__sw_int4__set 1
#define R_IRQ_MASK1_SET__sw_int3__sw_int3__nop 0
#define R_IRQ_MASK1_SET__sw_int3__sw_int3__set 1
#define R_IRQ_MASK1_SET__sw_int2__sw_int2__nop 0
#define R_IRQ_MASK1_SET__sw_int2__sw_int2__set 1
#define R_IRQ_MASK1_SET__sw_int1__sw_int1__nop 0
#define R_IRQ_MASK1_SET__sw_int1__sw_int1__set 1
#define R_IRQ_MASK1_SET__sw_int0__sw_int0__nop 0
#define R_IRQ_MASK1_SET__sw_int0__sw_int0__set 1
#define R_IRQ_MASK1_SET__par1_ecp_cmd__par1_ecp_cmd__nop 0
#define R_IRQ_MASK1_SET__par1_ecp_cmd__par1_ecp_cmd__set 1
#define R_IRQ_MASK1_SET__par1_peri__par1_peri__nop 0
#define R_IRQ_MASK1_SET__par1_peri__par1_peri__set 1
#define R_IRQ_MASK1_SET__par1_data__par1_data__nop 0
#define R_IRQ_MASK1_SET__par1_data__par1_data__set 1
#define R_IRQ_MASK1_SET__par1_ready__par1_ready__nop 0
#define R_IRQ_MASK1_SET__par1_ready__par1_ready__set 1
#define R_IRQ_MASK1_SET__scsi1__scsi1__nop 0
#define R_IRQ_MASK1_SET__scsi1__scsi1__set 1
#define R_IRQ_MASK1_SET__ser3_ready__ser3_ready__nop 0
#define R_IRQ_MASK1_SET__ser3_ready__ser3_ready__set 1
#define R_IRQ_MASK1_SET__ser3_data__ser3_data__nop 0
#define R_IRQ_MASK1_SET__ser3_data__ser3_data__set 1
#define R_IRQ_MASK1_SET__ser2_ready__ser2_ready__nop 0
#define R_IRQ_MASK1_SET__ser2_ready__ser2_ready__set 1
#define R_IRQ_MASK1_SET__ser2_data__ser2_data__nop 0
#define R_IRQ_MASK1_SET__ser2_data__ser2_data__set 1
#define R_IRQ_MASK1_SET__ser1_ready__ser1_ready__nop 0
#define R_IRQ_MASK1_SET__ser1_ready__ser1_ready__set 1
#define R_IRQ_MASK1_SET__ser1_data__ser1_data__nop 0
#define R_IRQ_MASK1_SET__ser1_data__ser1_data__set 1
#define R_IRQ_MASK1_SET__ser0_ready__ser0_ready__nop 0
#define R_IRQ_MASK1_SET__ser0_ready__ser0_ready__set 1
#define R_IRQ_MASK1_SET__ser0_data__ser0_data__nop 0
#define R_IRQ_MASK1_SET__ser0_data__ser0_data__set 1
#define R_IRQ_MASK1_SET__pa7__pa7__nop 0
#define R_IRQ_MASK1_SET__pa7__pa7__set 1
#define R_IRQ_MASK1_SET__pa6__pa6__nop 0
#define R_IRQ_MASK1_SET__pa6__pa6__set 1
#define R_IRQ_MASK1_SET__pa5__pa5__nop 0
#define R_IRQ_MASK1_SET__pa5__pa5__set 1
#define R_IRQ_MASK1_SET__pa4__pa4__nop 0
#define R_IRQ_MASK1_SET__pa4__pa4__set 1
#define R_IRQ_MASK1_SET__pa3__pa3__nop 0
#define R_IRQ_MASK1_SET__pa3__pa3__set 1
#define R_IRQ_MASK1_SET__pa2__pa2__nop 0
#define R_IRQ_MASK1_SET__pa2__pa2__set 1
#define R_IRQ_MASK1_SET__pa1__pa1__nop 0
#define R_IRQ_MASK1_SET__pa1__pa1__set 1
#define R_IRQ_MASK1_SET__pa0__pa0__nop 0
#define R_IRQ_MASK1_SET__pa0__pa0__set 1

#endif

/*
 *  R_IRQ_MASK2_CLR
 *  - type:  WO
 *  - addr:  0xb00000d0
 *  - group: Interrupt mask and status registers
 */

#if USE_GROUP__Interrupt_mask_and_status_registers

#define R_IRQ_MASK2_CLR__ADDR      (REG_TYPECAST_UDWORD  0xb00000d0)

#ifndef REG_NO_SHADOW
#define R_IRQ_MASK2_CLR__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_IRQ_MASK2_CLR + 0))
#define R_IRQ_MASK2_CLR__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_IRQ_MASK2_CLR + 0))
#else /* REG_NO_SHADOW */
#define R_IRQ_MASK2_CLR__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_IRQ_MASK2_CLR__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_IRQ_MASK2_CLR__STYPECAST REG_STYPECAST_UDWORD
#define R_IRQ_MASK2_CLR__SVAL REG_SVAL_ZERO
#define R_IRQ_MASK2_CLR__SVAL_I REG_SVAL_I_ZERO
#define R_IRQ_MASK2_CLR__TYPECAST  REG_TYPECAST_UDWORD
#define R_IRQ_MASK2_CLR__TYPE      (REG_UDWORD)
#define R_IRQ_MASK2_CLR__GET       REG_GET_WO
#define R_IRQ_MASK2_CLR__IGET      REG_IGET_WO
#define R_IRQ_MASK2_CLR__SET       REG_SET_WO
#define R_IRQ_MASK2_CLR__ISET      REG_ISET_WO
#define R_IRQ_MASK2_CLR__SET_VAL   REG_SET_VAL_WO
#define R_IRQ_MASK2_CLR__EQL       REG_EQL_WO
#define R_IRQ_MASK2_CLR__IEQL      REG_IEQL_WO
#define R_IRQ_MASK2_CLR__RD        REG_RD_WO
#define R_IRQ_MASK2_CLR__IRD       REG_IRD_WO
#define R_IRQ_MASK2_CLR__WR        REG_WR_WO
#define R_IRQ_MASK2_CLR__IWR       REG_IWR_WO

#define R_IRQ_MASK2_CLR__WRITE(addr,value) \
  (*(addr) = (value))

#define R_IRQ_MASK2_CLR__dma8_sub3_descr__dma8_sub3_descr__MASK 0x00800000U
#define R_IRQ_MASK2_CLR__dma8_sub2_descr__dma8_sub2_descr__MASK 0x00400000U
#define R_IRQ_MASK2_CLR__dma8_sub1_descr__dma8_sub1_descr__MASK 0x00200000U
#define R_IRQ_MASK2_CLR__dma8_sub0_descr__dma8_sub0_descr__MASK 0x00100000U
#define R_IRQ_MASK2_CLR__dma9_eop__dma9_eop__MASK 0x00080000U
#define R_IRQ_MASK2_CLR__dma9_descr__dma9_descr__MASK 0x00040000U
#define R_IRQ_MASK2_CLR__dma8_eop__dma8_eop__MASK 0x00020000U
#define R_IRQ_MASK2_CLR__dma8_descr__dma8_descr__MASK 0x00010000U
#define R_IRQ_MASK2_CLR__dma7_eop__dma7_eop__MASK 0x00008000U
#define R_IRQ_MASK2_CLR__dma7_descr__dma7_descr__MASK 0x00004000U
#define R_IRQ_MASK2_CLR__dma6_eop__dma6_eop__MASK 0x00002000U
#define R_IRQ_MASK2_CLR__dma6_descr__dma6_descr__MASK 0x00001000U
#define R_IRQ_MASK2_CLR__dma5_eop__dma5_eop__MASK 0x00000800U
#define R_IRQ_MASK2_CLR__dma5_descr__dma5_descr__MASK 0x00000400U
#define R_IRQ_MASK2_CLR__dma4_eop__dma4_eop__MASK 0x00000200U
#define R_IRQ_MASK2_CLR__dma4_descr__dma4_descr__MASK 0x00000100U
#define R_IRQ_MASK2_CLR__dma3_eop__dma3_eop__MASK 0x00000080U
#define R_IRQ_MASK2_CLR__dma3_descr__dma3_descr__MASK 0x00000040U
#define R_IRQ_MASK2_CLR__dma2_eop__dma2_eop__MASK 0x00000020U
#define R_IRQ_MASK2_CLR__dma2_descr__dma2_descr__MASK 0x00000010U
#define R_IRQ_MASK2_CLR__dma1_eop__dma1_eop__MASK 0x00000008U
#define R_IRQ_MASK2_CLR__dma1_descr__dma1_descr__MASK 0x00000004U
#define R_IRQ_MASK2_CLR__dma0_eop__dma0_eop__MASK 0x00000002U
#define R_IRQ_MASK2_CLR__dma0_descr__dma0_descr__MASK 0x00000001U

#define R_IRQ_MASK2_CLR__dma8_sub3_descr__MAX 0x1
#define R_IRQ_MASK2_CLR__dma8_sub2_descr__MAX 0x1
#define R_IRQ_MASK2_CLR__dma8_sub1_descr__MAX 0x1
#define R_IRQ_MASK2_CLR__dma8_sub0_descr__MAX 0x1
#define R_IRQ_MASK2_CLR__dma9_eop__MAX 0x1
#define R_IRQ_MASK2_CLR__dma9_descr__MAX 0x1
#define R_IRQ_MASK2_CLR__dma8_eop__MAX 0x1
#define R_IRQ_MASK2_CLR__dma8_descr__MAX 0x1
#define R_IRQ_MASK2_CLR__dma7_eop__MAX 0x1
#define R_IRQ_MASK2_CLR__dma7_descr__MAX 0x1
#define R_IRQ_MASK2_CLR__dma6_eop__MAX 0x1
#define R_IRQ_MASK2_CLR__dma6_descr__MAX 0x1
#define R_IRQ_MASK2_CLR__dma5_eop__MAX 0x1
#define R_IRQ_MASK2_CLR__dma5_descr__MAX 0x1
#define R_IRQ_MASK2_CLR__dma4_eop__MAX 0x1
#define R_IRQ_MASK2_CLR__dma4_descr__MAX 0x1
#define R_IRQ_MASK2_CLR__dma3_eop__MAX 0x1
#define R_IRQ_MASK2_CLR__dma3_descr__MAX 0x1
#define R_IRQ_MASK2_CLR__dma2_eop__MAX 0x1
#define R_IRQ_MASK2_CLR__dma2_descr__MAX 0x1
#define R_IRQ_MASK2_CLR__dma1_eop__MAX 0x1
#define R_IRQ_MASK2_CLR__dma1_descr__MAX 0x1
#define R_IRQ_MASK2_CLR__dma0_eop__MAX 0x1
#define R_IRQ_MASK2_CLR__dma0_descr__MAX 0x1

#define R_IRQ_MASK2_CLR__dma8_sub3_descr__MIN 0
#define R_IRQ_MASK2_CLR__dma8_sub2_descr__MIN 0
#define R_IRQ_MASK2_CLR__dma8_sub1_descr__MIN 0
#define R_IRQ_MASK2_CLR__dma8_sub0_descr__MIN 0
#define R_IRQ_MASK2_CLR__dma9_eop__MIN 0
#define R_IRQ_MASK2_CLR__dma9_descr__MIN 0
#define R_IRQ_MASK2_CLR__dma8_eop__MIN 0
#define R_IRQ_MASK2_CLR__dma8_descr__MIN 0
#define R_IRQ_MASK2_CLR__dma7_eop__MIN 0
#define R_IRQ_MASK2_CLR__dma7_descr__MIN 0
#define R_IRQ_MASK2_CLR__dma6_eop__MIN 0
#define R_IRQ_MASK2_CLR__dma6_descr__MIN 0
#define R_IRQ_MASK2_CLR__dma5_eop__MIN 0
#define R_IRQ_MASK2_CLR__dma5_descr__MIN 0
#define R_IRQ_MASK2_CLR__dma4_eop__MIN 0
#define R_IRQ_MASK2_CLR__dma4_descr__MIN 0
#define R_IRQ_MASK2_CLR__dma3_eop__MIN 0
#define R_IRQ_MASK2_CLR__dma3_descr__MIN 0
#define R_IRQ_MASK2_CLR__dma2_eop__MIN 0
#define R_IRQ_MASK2_CLR__dma2_descr__MIN 0
#define R_IRQ_MASK2_CLR__dma1_eop__MIN 0
#define R_IRQ_MASK2_CLR__dma1_descr__MIN 0
#define R_IRQ_MASK2_CLR__dma0_eop__MIN 0
#define R_IRQ_MASK2_CLR__dma0_descr__MIN 0

#define R_IRQ_MASK2_CLR__dma8_sub3_descr__BITNR 23
#define R_IRQ_MASK2_CLR__dma8_sub2_descr__BITNR 22
#define R_IRQ_MASK2_CLR__dma8_sub1_descr__BITNR 21
#define R_IRQ_MASK2_CLR__dma8_sub0_descr__BITNR 20
#define R_IRQ_MASK2_CLR__dma9_eop__BITNR 19
#define R_IRQ_MASK2_CLR__dma9_descr__BITNR 18
#define R_IRQ_MASK2_CLR__dma8_eop__BITNR 17
#define R_IRQ_MASK2_CLR__dma8_descr__BITNR 16
#define R_IRQ_MASK2_CLR__dma7_eop__BITNR 15
#define R_IRQ_MASK2_CLR__dma7_descr__BITNR 14
#define R_IRQ_MASK2_CLR__dma6_eop__BITNR 13
#define R_IRQ_MASK2_CLR__dma6_descr__BITNR 12
#define R_IRQ_MASK2_CLR__dma5_eop__BITNR 11
#define R_IRQ_MASK2_CLR__dma5_descr__BITNR 10
#define R_IRQ_MASK2_CLR__dma4_eop__BITNR 9
#define R_IRQ_MASK2_CLR__dma4_descr__BITNR 8
#define R_IRQ_MASK2_CLR__dma3_eop__BITNR 7
#define R_IRQ_MASK2_CLR__dma3_descr__BITNR 6
#define R_IRQ_MASK2_CLR__dma2_eop__BITNR 5
#define R_IRQ_MASK2_CLR__dma2_descr__BITNR 4
#define R_IRQ_MASK2_CLR__dma1_eop__BITNR 3
#define R_IRQ_MASK2_CLR__dma1_descr__BITNR 2
#define R_IRQ_MASK2_CLR__dma0_eop__BITNR 1
#define R_IRQ_MASK2_CLR__dma0_descr__BITNR 0

#define R_IRQ_MASK2_CLR__dma8_sub3_descr__dma8_sub3_descr__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_CLR__dma8_sub2_descr__dma8_sub2_descr__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_CLR__dma8_sub1_descr__dma8_sub1_descr__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_CLR__dma8_sub0_descr__dma8_sub0_descr__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_CLR__dma9_eop__dma9_eop__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_CLR__dma9_descr__dma9_descr__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_CLR__dma8_eop__dma8_eop__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_CLR__dma8_descr__dma8_descr__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_CLR__dma7_eop__dma7_eop__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_CLR__dma7_descr__dma7_descr__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_CLR__dma6_eop__dma6_eop__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_CLR__dma6_descr__dma6_descr__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_CLR__dma5_eop__dma5_eop__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_CLR__dma5_descr__dma5_descr__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_CLR__dma4_eop__dma4_eop__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_CLR__dma4_descr__dma4_descr__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_CLR__dma3_eop__dma3_eop__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_CLR__dma3_descr__dma3_descr__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_CLR__dma2_eop__dma2_eop__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_CLR__dma2_descr__dma2_descr__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_CLR__dma1_eop__dma1_eop__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_CLR__dma1_descr__dma1_descr__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_CLR__dma0_eop__dma0_eop__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_CLR__dma0_descr__dma0_descr__VAL REG_VAL_ENUM

#define R_IRQ_MASK2_CLR__dma8_sub3_descr__dma8_sub3_descr__clr 1
#define R_IRQ_MASK2_CLR__dma8_sub3_descr__dma8_sub3_descr__nop 0
#define R_IRQ_MASK2_CLR__dma8_sub2_descr__dma8_sub2_descr__clr 1
#define R_IRQ_MASK2_CLR__dma8_sub2_descr__dma8_sub2_descr__nop 0
#define R_IRQ_MASK2_CLR__dma8_sub1_descr__dma8_sub1_descr__clr 1
#define R_IRQ_MASK2_CLR__dma8_sub1_descr__dma8_sub1_descr__nop 0
#define R_IRQ_MASK2_CLR__dma8_sub0_descr__dma8_sub0_descr__clr 1
#define R_IRQ_MASK2_CLR__dma8_sub0_descr__dma8_sub0_descr__nop 0
#define R_IRQ_MASK2_CLR__dma9_eop__dma9_eop__clr 1
#define R_IRQ_MASK2_CLR__dma9_eop__dma9_eop__nop 0
#define R_IRQ_MASK2_CLR__dma9_descr__dma9_descr__clr 1
#define R_IRQ_MASK2_CLR__dma9_descr__dma9_descr__nop 0
#define R_IRQ_MASK2_CLR__dma8_eop__dma8_eop__clr 1
#define R_IRQ_MASK2_CLR__dma8_eop__dma8_eop__nop 0
#define R_IRQ_MASK2_CLR__dma8_descr__dma8_descr__clr 1
#define R_IRQ_MASK2_CLR__dma8_descr__dma8_descr__nop 0
#define R_IRQ_MASK2_CLR__dma7_eop__dma7_eop__clr 1
#define R_IRQ_MASK2_CLR__dma7_eop__dma7_eop__nop 0
#define R_IRQ_MASK2_CLR__dma7_descr__dma7_descr__clr 1
#define R_IRQ_MASK2_CLR__dma7_descr__dma7_descr__nop 0
#define R_IRQ_MASK2_CLR__dma6_eop__dma6_eop__clr 1
#define R_IRQ_MASK2_CLR__dma6_eop__dma6_eop__nop 0
#define R_IRQ_MASK2_CLR__dma6_descr__dma6_descr__clr 1
#define R_IRQ_MASK2_CLR__dma6_descr__dma6_descr__nop 0
#define R_IRQ_MASK2_CLR__dma5_eop__dma5_eop__clr 1
#define R_IRQ_MASK2_CLR__dma5_eop__dma5_eop__nop 0
#define R_IRQ_MASK2_CLR__dma5_descr__dma5_descr__clr 1
#define R_IRQ_MASK2_CLR__dma5_descr__dma5_descr__nop 0
#define R_IRQ_MASK2_CLR__dma4_eop__dma4_eop__clr 1
#define R_IRQ_MASK2_CLR__dma4_eop__dma4_eop__nop 0
#define R_IRQ_MASK2_CLR__dma4_descr__dma4_descr__clr 1
#define R_IRQ_MASK2_CLR__dma4_descr__dma4_descr__nop 0
#define R_IRQ_MASK2_CLR__dma3_eop__dma3_eop__clr 1
#define R_IRQ_MASK2_CLR__dma3_eop__dma3_eop__nop 0
#define R_IRQ_MASK2_CLR__dma3_descr__dma3_descr__clr 1
#define R_IRQ_MASK2_CLR__dma3_descr__dma3_descr__nop 0
#define R_IRQ_MASK2_CLR__dma2_eop__dma2_eop__clr 1
#define R_IRQ_MASK2_CLR__dma2_eop__dma2_eop__nop 0
#define R_IRQ_MASK2_CLR__dma2_descr__dma2_descr__clr 1
#define R_IRQ_MASK2_CLR__dma2_descr__dma2_descr__nop 0
#define R_IRQ_MASK2_CLR__dma1_eop__dma1_eop__clr 1
#define R_IRQ_MASK2_CLR__dma1_eop__dma1_eop__nop 0
#define R_IRQ_MASK2_CLR__dma1_descr__dma1_descr__clr 1
#define R_IRQ_MASK2_CLR__dma1_descr__dma1_descr__nop 0
#define R_IRQ_MASK2_CLR__dma0_eop__dma0_eop__clr 1
#define R_IRQ_MASK2_CLR__dma0_eop__dma0_eop__nop 0
#define R_IRQ_MASK2_CLR__dma0_descr__dma0_descr__clr 1
#define R_IRQ_MASK2_CLR__dma0_descr__dma0_descr__nop 0

#endif

/*
 *  R_IRQ_MASK2_RD
 *  - type:  RO
 *  - addr:  0xb00000d0
 *  - group: Interrupt mask and status registers
 */

#if USE_GROUP__Interrupt_mask_and_status_registers

#define R_IRQ_MASK2_RD__ADDR      (REG_TYPECAST_UDWORD  0xb00000d0)
#define R_IRQ_MASK2_RD__SVAL      REG_SVAL_SHADOW
#define R_IRQ_MASK2_RD__SVAL_I    REG_SVAL_I_SHADOW
#define R_IRQ_MASK2_RD__TYPECAST  REG_TYPECAST_UDWORD
#define R_IRQ_MASK2_RD__TYPE      (REG_UDWORD)
#define R_IRQ_MASK2_RD__GET       REG_GET_RO
#define R_IRQ_MASK2_RD__IGET      REG_IGET_RO
#define R_IRQ_MASK2_RD__SET       REG_SET_RO
#define R_IRQ_MASK2_RD__ISET      REG_ISET_RO
#define R_IRQ_MASK2_RD__SET_VAL   REG_SET_VAL_RO
#define R_IRQ_MASK2_RD__EQL       REG_EQL_RO
#define R_IRQ_MASK2_RD__IEQL      REG_IEQL_RO
#define R_IRQ_MASK2_RD__RD        REG_RD_RO
#define R_IRQ_MASK2_RD__IRD       REG_IRD_RO
#define R_IRQ_MASK2_RD__WR        REG_WR_RO
#define R_IRQ_MASK2_RD__IWR       REG_IWR_RO

#define R_IRQ_MASK2_RD__READ(addr) \
  (*(addr))

#define R_IRQ_MASK2_RD__dma8_sub3_descr__dma8_sub3_descr__MASK 0x00800000U
#define R_IRQ_MASK2_RD__dma8_sub2_descr__dma8_sub2_descr__MASK 0x00400000U
#define R_IRQ_MASK2_RD__dma8_sub1_descr__dma8_sub1_descr__MASK 0x00200000U
#define R_IRQ_MASK2_RD__dma8_sub0_descr__dma8_sub0_descr__MASK 0x00100000U
#define R_IRQ_MASK2_RD__dma9_eop__dma9_eop__MASK 0x00080000U
#define R_IRQ_MASK2_RD__dma9_descr__dma9_descr__MASK 0x00040000U
#define R_IRQ_MASK2_RD__dma8_eop__dma8_eop__MASK 0x00020000U
#define R_IRQ_MASK2_RD__dma8_descr__dma8_descr__MASK 0x00010000U
#define R_IRQ_MASK2_RD__dma7_eop__dma7_eop__MASK 0x00008000U
#define R_IRQ_MASK2_RD__dma7_descr__dma7_descr__MASK 0x00004000U
#define R_IRQ_MASK2_RD__dma6_eop__dma6_eop__MASK 0x00002000U
#define R_IRQ_MASK2_RD__dma6_descr__dma6_descr__MASK 0x00001000U
#define R_IRQ_MASK2_RD__dma5_eop__dma5_eop__MASK 0x00000800U
#define R_IRQ_MASK2_RD__dma5_descr__dma5_descr__MASK 0x00000400U
#define R_IRQ_MASK2_RD__dma4_eop__dma4_eop__MASK 0x00000200U
#define R_IRQ_MASK2_RD__dma4_descr__dma4_descr__MASK 0x00000100U
#define R_IRQ_MASK2_RD__dma3_eop__dma3_eop__MASK 0x00000080U
#define R_IRQ_MASK2_RD__dma3_descr__dma3_descr__MASK 0x00000040U
#define R_IRQ_MASK2_RD__dma2_eop__dma2_eop__MASK 0x00000020U
#define R_IRQ_MASK2_RD__dma2_descr__dma2_descr__MASK 0x00000010U
#define R_IRQ_MASK2_RD__dma1_eop__dma1_eop__MASK 0x00000008U
#define R_IRQ_MASK2_RD__dma1_descr__dma1_descr__MASK 0x00000004U
#define R_IRQ_MASK2_RD__dma0_eop__dma0_eop__MASK 0x00000002U
#define R_IRQ_MASK2_RD__dma0_descr__dma0_descr__MASK 0x00000001U

#define R_IRQ_MASK2_RD__dma8_sub3_descr__MAX 0x1
#define R_IRQ_MASK2_RD__dma8_sub2_descr__MAX 0x1
#define R_IRQ_MASK2_RD__dma8_sub1_descr__MAX 0x1
#define R_IRQ_MASK2_RD__dma8_sub0_descr__MAX 0x1
#define R_IRQ_MASK2_RD__dma9_eop__MAX 0x1
#define R_IRQ_MASK2_RD__dma9_descr__MAX 0x1
#define R_IRQ_MASK2_RD__dma8_eop__MAX 0x1
#define R_IRQ_MASK2_RD__dma8_descr__MAX 0x1
#define R_IRQ_MASK2_RD__dma7_eop__MAX 0x1
#define R_IRQ_MASK2_RD__dma7_descr__MAX 0x1
#define R_IRQ_MASK2_RD__dma6_eop__MAX 0x1
#define R_IRQ_MASK2_RD__dma6_descr__MAX 0x1
#define R_IRQ_MASK2_RD__dma5_eop__MAX 0x1
#define R_IRQ_MASK2_RD__dma5_descr__MAX 0x1
#define R_IRQ_MASK2_RD__dma4_eop__MAX 0x1
#define R_IRQ_MASK2_RD__dma4_descr__MAX 0x1
#define R_IRQ_MASK2_RD__dma3_eop__MAX 0x1
#define R_IRQ_MASK2_RD__dma3_descr__MAX 0x1
#define R_IRQ_MASK2_RD__dma2_eop__MAX 0x1
#define R_IRQ_MASK2_RD__dma2_descr__MAX 0x1
#define R_IRQ_MASK2_RD__dma1_eop__MAX 0x1
#define R_IRQ_MASK2_RD__dma1_descr__MAX 0x1
#define R_IRQ_MASK2_RD__dma0_eop__MAX 0x1
#define R_IRQ_MASK2_RD__dma0_descr__MAX 0x1

#define R_IRQ_MASK2_RD__dma8_sub3_descr__MIN 0
#define R_IRQ_MASK2_RD__dma8_sub2_descr__MIN 0
#define R_IRQ_MASK2_RD__dma8_sub1_descr__MIN 0
#define R_IRQ_MASK2_RD__dma8_sub0_descr__MIN 0
#define R_IRQ_MASK2_RD__dma9_eop__MIN 0
#define R_IRQ_MASK2_RD__dma9_descr__MIN 0
#define R_IRQ_MASK2_RD__dma8_eop__MIN 0
#define R_IRQ_MASK2_RD__dma8_descr__MIN 0
#define R_IRQ_MASK2_RD__dma7_eop__MIN 0
#define R_IRQ_MASK2_RD__dma7_descr__MIN 0
#define R_IRQ_MASK2_RD__dma6_eop__MIN 0
#define R_IRQ_MASK2_RD__dma6_descr__MIN 0
#define R_IRQ_MASK2_RD__dma5_eop__MIN 0
#define R_IRQ_MASK2_RD__dma5_descr__MIN 0
#define R_IRQ_MASK2_RD__dma4_eop__MIN 0
#define R_IRQ_MASK2_RD__dma4_descr__MIN 0
#define R_IRQ_MASK2_RD__dma3_eop__MIN 0
#define R_IRQ_MASK2_RD__dma3_descr__MIN 0
#define R_IRQ_MASK2_RD__dma2_eop__MIN 0
#define R_IRQ_MASK2_RD__dma2_descr__MIN 0
#define R_IRQ_MASK2_RD__dma1_eop__MIN 0
#define R_IRQ_MASK2_RD__dma1_descr__MIN 0
#define R_IRQ_MASK2_RD__dma0_eop__MIN 0
#define R_IRQ_MASK2_RD__dma0_descr__MIN 0

#define R_IRQ_MASK2_RD__dma8_sub3_descr__BITNR 23
#define R_IRQ_MASK2_RD__dma8_sub2_descr__BITNR 22
#define R_IRQ_MASK2_RD__dma8_sub1_descr__BITNR 21
#define R_IRQ_MASK2_RD__dma8_sub0_descr__BITNR 20
#define R_IRQ_MASK2_RD__dma9_eop__BITNR 19
#define R_IRQ_MASK2_RD__dma9_descr__BITNR 18
#define R_IRQ_MASK2_RD__dma8_eop__BITNR 17
#define R_IRQ_MASK2_RD__dma8_descr__BITNR 16
#define R_IRQ_MASK2_RD__dma7_eop__BITNR 15
#define R_IRQ_MASK2_RD__dma7_descr__BITNR 14
#define R_IRQ_MASK2_RD__dma6_eop__BITNR 13
#define R_IRQ_MASK2_RD__dma6_descr__BITNR 12
#define R_IRQ_MASK2_RD__dma5_eop__BITNR 11
#define R_IRQ_MASK2_RD__dma5_descr__BITNR 10
#define R_IRQ_MASK2_RD__dma4_eop__BITNR 9
#define R_IRQ_MASK2_RD__dma4_descr__BITNR 8
#define R_IRQ_MASK2_RD__dma3_eop__BITNR 7
#define R_IRQ_MASK2_RD__dma3_descr__BITNR 6
#define R_IRQ_MASK2_RD__dma2_eop__BITNR 5
#define R_IRQ_MASK2_RD__dma2_descr__BITNR 4
#define R_IRQ_MASK2_RD__dma1_eop__BITNR 3
#define R_IRQ_MASK2_RD__dma1_descr__BITNR 2
#define R_IRQ_MASK2_RD__dma0_eop__BITNR 1
#define R_IRQ_MASK2_RD__dma0_descr__BITNR 0

#define R_IRQ_MASK2_RD__dma8_sub3_descr__dma8_sub3_descr__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_RD__dma8_sub2_descr__dma8_sub2_descr__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_RD__dma8_sub1_descr__dma8_sub1_descr__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_RD__dma8_sub0_descr__dma8_sub0_descr__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_RD__dma9_eop__dma9_eop__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_RD__dma9_descr__dma9_descr__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_RD__dma8_eop__dma8_eop__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_RD__dma8_descr__dma8_descr__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_RD__dma7_eop__dma7_eop__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_RD__dma7_descr__dma7_descr__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_RD__dma6_eop__dma6_eop__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_RD__dma6_descr__dma6_descr__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_RD__dma5_eop__dma5_eop__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_RD__dma5_descr__dma5_descr__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_RD__dma4_eop__dma4_eop__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_RD__dma4_descr__dma4_descr__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_RD__dma3_eop__dma3_eop__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_RD__dma3_descr__dma3_descr__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_RD__dma2_eop__dma2_eop__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_RD__dma2_descr__dma2_descr__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_RD__dma1_eop__dma1_eop__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_RD__dma1_descr__dma1_descr__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_RD__dma0_eop__dma0_eop__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_RD__dma0_descr__dma0_descr__VAL REG_VAL_ENUM

#define R_IRQ_MASK2_RD__dma8_sub3_descr__dma8_sub3_descr__active 1
#define R_IRQ_MASK2_RD__dma8_sub3_descr__dma8_sub3_descr__inactive 0
#define R_IRQ_MASK2_RD__dma8_sub2_descr__dma8_sub2_descr__active 1
#define R_IRQ_MASK2_RD__dma8_sub2_descr__dma8_sub2_descr__inactive 0
#define R_IRQ_MASK2_RD__dma8_sub1_descr__dma8_sub1_descr__active 1
#define R_IRQ_MASK2_RD__dma8_sub1_descr__dma8_sub1_descr__inactive 0
#define R_IRQ_MASK2_RD__dma8_sub0_descr__dma8_sub0_descr__active 1
#define R_IRQ_MASK2_RD__dma8_sub0_descr__dma8_sub0_descr__inactive 0
#define R_IRQ_MASK2_RD__dma9_eop__dma9_eop__active 1
#define R_IRQ_MASK2_RD__dma9_eop__dma9_eop__inactive 0
#define R_IRQ_MASK2_RD__dma9_descr__dma9_descr__active 1
#define R_IRQ_MASK2_RD__dma9_descr__dma9_descr__inactive 0
#define R_IRQ_MASK2_RD__dma8_eop__dma8_eop__active 1
#define R_IRQ_MASK2_RD__dma8_eop__dma8_eop__inactive 0
#define R_IRQ_MASK2_RD__dma8_descr__dma8_descr__active 1
#define R_IRQ_MASK2_RD__dma8_descr__dma8_descr__inactive 0
#define R_IRQ_MASK2_RD__dma7_eop__dma7_eop__active 1
#define R_IRQ_MASK2_RD__dma7_eop__dma7_eop__inactive 0
#define R_IRQ_MASK2_RD__dma7_descr__dma7_descr__active 1
#define R_IRQ_MASK2_RD__dma7_descr__dma7_descr__inactive 0
#define R_IRQ_MASK2_RD__dma6_eop__dma6_eop__active 1
#define R_IRQ_MASK2_RD__dma6_eop__dma6_eop__inactive 0
#define R_IRQ_MASK2_RD__dma6_descr__dma6_descr__active 1
#define R_IRQ_MASK2_RD__dma6_descr__dma6_descr__inactive 0
#define R_IRQ_MASK2_RD__dma5_eop__dma5_eop__active 1
#define R_IRQ_MASK2_RD__dma5_eop__dma5_eop__inactive 0
#define R_IRQ_MASK2_RD__dma5_descr__dma5_descr__active 1
#define R_IRQ_MASK2_RD__dma5_descr__dma5_descr__inactive 0
#define R_IRQ_MASK2_RD__dma4_eop__dma4_eop__active 1
#define R_IRQ_MASK2_RD__dma4_eop__dma4_eop__inactive 0
#define R_IRQ_MASK2_RD__dma4_descr__dma4_descr__active 1
#define R_IRQ_MASK2_RD__dma4_descr__dma4_descr__inactive 0
#define R_IRQ_MASK2_RD__dma3_eop__dma3_eop__active 1
#define R_IRQ_MASK2_RD__dma3_eop__dma3_eop__inactive 0
#define R_IRQ_MASK2_RD__dma3_descr__dma3_descr__active 1
#define R_IRQ_MASK2_RD__dma3_descr__dma3_descr__inactive 0
#define R_IRQ_MASK2_RD__dma2_eop__dma2_eop__active 1
#define R_IRQ_MASK2_RD__dma2_eop__dma2_eop__inactive 0
#define R_IRQ_MASK2_RD__dma2_descr__dma2_descr__active 1
#define R_IRQ_MASK2_RD__dma2_descr__dma2_descr__inactive 0
#define R_IRQ_MASK2_RD__dma1_eop__dma1_eop__active 1
#define R_IRQ_MASK2_RD__dma1_eop__dma1_eop__inactive 0
#define R_IRQ_MASK2_RD__dma1_descr__dma1_descr__active 1
#define R_IRQ_MASK2_RD__dma1_descr__dma1_descr__inactive 0
#define R_IRQ_MASK2_RD__dma0_eop__dma0_eop__active 1
#define R_IRQ_MASK2_RD__dma0_eop__dma0_eop__inactive 0
#define R_IRQ_MASK2_RD__dma0_descr__dma0_descr__active 1
#define R_IRQ_MASK2_RD__dma0_descr__dma0_descr__inactive 0

#endif

/*
 *  R_IRQ_MASK2_SET
 *  - type:  WO
 *  - addr:  0xb00000d4
 *  - group: Interrupt mask and status registers
 */

#if USE_GROUP__Interrupt_mask_and_status_registers

#define R_IRQ_MASK2_SET__ADDR      (REG_TYPECAST_UDWORD  0xb00000d4)

#ifndef REG_NO_SHADOW
#define R_IRQ_MASK2_SET__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_IRQ_MASK2_SET + 0))
#define R_IRQ_MASK2_SET__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_IRQ_MASK2_SET + 0))
#else /* REG_NO_SHADOW */
#define R_IRQ_MASK2_SET__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_IRQ_MASK2_SET__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_IRQ_MASK2_SET__STYPECAST REG_STYPECAST_UDWORD
#define R_IRQ_MASK2_SET__SVAL REG_SVAL_ZERO
#define R_IRQ_MASK2_SET__SVAL_I REG_SVAL_I_ZERO
#define R_IRQ_MASK2_SET__TYPECAST  REG_TYPECAST_UDWORD
#define R_IRQ_MASK2_SET__TYPE      (REG_UDWORD)
#define R_IRQ_MASK2_SET__GET       REG_GET_WO
#define R_IRQ_MASK2_SET__IGET      REG_IGET_WO
#define R_IRQ_MASK2_SET__SET       REG_SET_WO
#define R_IRQ_MASK2_SET__ISET      REG_ISET_WO
#define R_IRQ_MASK2_SET__SET_VAL   REG_SET_VAL_WO
#define R_IRQ_MASK2_SET__EQL       REG_EQL_WO
#define R_IRQ_MASK2_SET__IEQL      REG_IEQL_WO
#define R_IRQ_MASK2_SET__RD        REG_RD_WO
#define R_IRQ_MASK2_SET__IRD       REG_IRD_WO
#define R_IRQ_MASK2_SET__WR        REG_WR_WO
#define R_IRQ_MASK2_SET__IWR       REG_IWR_WO

#define R_IRQ_MASK2_SET__WRITE(addr,value) \
  (*(addr) = (value))

#define R_IRQ_MASK2_SET__dma8_sub3_descr__dma8_sub3_descr__MASK 0x00800000U
#define R_IRQ_MASK2_SET__dma8_sub2_descr__dma8_sub2_descr__MASK 0x00400000U
#define R_IRQ_MASK2_SET__dma8_sub1_descr__dma8_sub1_descr__MASK 0x00200000U
#define R_IRQ_MASK2_SET__dma8_sub0_descr__dma8_sub0_descr__MASK 0x00100000U
#define R_IRQ_MASK2_SET__dma9_eop__dma9_eop__MASK 0x00080000U
#define R_IRQ_MASK2_SET__dma9_descr__dma9_descr__MASK 0x00040000U
#define R_IRQ_MASK2_SET__dma8_eop__dma8_eop__MASK 0x00020000U
#define R_IRQ_MASK2_SET__dma8_descr__dma8_descr__MASK 0x00010000U
#define R_IRQ_MASK2_SET__dma7_eop__dma7_eop__MASK 0x00008000U
#define R_IRQ_MASK2_SET__dma7_descr__dma7_descr__MASK 0x00004000U
#define R_IRQ_MASK2_SET__dma6_eop__dma6_eop__MASK 0x00002000U
#define R_IRQ_MASK2_SET__dma6_descr__dma6_descr__MASK 0x00001000U
#define R_IRQ_MASK2_SET__dma5_eop__dma5_eop__MASK 0x00000800U
#define R_IRQ_MASK2_SET__dma5_descr__dma5_descr__MASK 0x00000400U
#define R_IRQ_MASK2_SET__dma4_eop__dma4_eop__MASK 0x00000200U
#define R_IRQ_MASK2_SET__dma4_descr__dma4_descr__MASK 0x00000100U
#define R_IRQ_MASK2_SET__dma3_eop__dma3_eop__MASK 0x00000080U
#define R_IRQ_MASK2_SET__dma3_descr__dma3_descr__MASK 0x00000040U
#define R_IRQ_MASK2_SET__dma2_eop__dma2_eop__MASK 0x00000020U
#define R_IRQ_MASK2_SET__dma2_descr__dma2_descr__MASK 0x00000010U
#define R_IRQ_MASK2_SET__dma1_eop__dma1_eop__MASK 0x00000008U
#define R_IRQ_MASK2_SET__dma1_descr__dma1_descr__MASK 0x00000004U
#define R_IRQ_MASK2_SET__dma0_eop__dma0_eop__MASK 0x00000002U
#define R_IRQ_MASK2_SET__dma0_descr__dma0_descr__MASK 0x00000001U

#define R_IRQ_MASK2_SET__dma8_sub3_descr__MAX 0x1
#define R_IRQ_MASK2_SET__dma8_sub2_descr__MAX 0x1
#define R_IRQ_MASK2_SET__dma8_sub1_descr__MAX 0x1
#define R_IRQ_MASK2_SET__dma8_sub0_descr__MAX 0x1
#define R_IRQ_MASK2_SET__dma9_eop__MAX 0x1
#define R_IRQ_MASK2_SET__dma9_descr__MAX 0x1
#define R_IRQ_MASK2_SET__dma8_eop__MAX 0x1
#define R_IRQ_MASK2_SET__dma8_descr__MAX 0x1
#define R_IRQ_MASK2_SET__dma7_eop__MAX 0x1
#define R_IRQ_MASK2_SET__dma7_descr__MAX 0x1
#define R_IRQ_MASK2_SET__dma6_eop__MAX 0x1
#define R_IRQ_MASK2_SET__dma6_descr__MAX 0x1
#define R_IRQ_MASK2_SET__dma5_eop__MAX 0x1
#define R_IRQ_MASK2_SET__dma5_descr__MAX 0x1
#define R_IRQ_MASK2_SET__dma4_eop__MAX 0x1
#define R_IRQ_MASK2_SET__dma4_descr__MAX 0x1
#define R_IRQ_MASK2_SET__dma3_eop__MAX 0x1
#define R_IRQ_MASK2_SET__dma3_descr__MAX 0x1
#define R_IRQ_MASK2_SET__dma2_eop__MAX 0x1
#define R_IRQ_MASK2_SET__dma2_descr__MAX 0x1
#define R_IRQ_MASK2_SET__dma1_eop__MAX 0x1
#define R_IRQ_MASK2_SET__dma1_descr__MAX 0x1
#define R_IRQ_MASK2_SET__dma0_eop__MAX 0x1
#define R_IRQ_MASK2_SET__dma0_descr__MAX 0x1

#define R_IRQ_MASK2_SET__dma8_sub3_descr__MIN 0
#define R_IRQ_MASK2_SET__dma8_sub2_descr__MIN 0
#define R_IRQ_MASK2_SET__dma8_sub1_descr__MIN 0
#define R_IRQ_MASK2_SET__dma8_sub0_descr__MIN 0
#define R_IRQ_MASK2_SET__dma9_eop__MIN 0
#define R_IRQ_MASK2_SET__dma9_descr__MIN 0
#define R_IRQ_MASK2_SET__dma8_eop__MIN 0
#define R_IRQ_MASK2_SET__dma8_descr__MIN 0
#define R_IRQ_MASK2_SET__dma7_eop__MIN 0
#define R_IRQ_MASK2_SET__dma7_descr__MIN 0
#define R_IRQ_MASK2_SET__dma6_eop__MIN 0
#define R_IRQ_MASK2_SET__dma6_descr__MIN 0
#define R_IRQ_MASK2_SET__dma5_eop__MIN 0
#define R_IRQ_MASK2_SET__dma5_descr__MIN 0
#define R_IRQ_MASK2_SET__dma4_eop__MIN 0
#define R_IRQ_MASK2_SET__dma4_descr__MIN 0
#define R_IRQ_MASK2_SET__dma3_eop__MIN 0
#define R_IRQ_MASK2_SET__dma3_descr__MIN 0
#define R_IRQ_MASK2_SET__dma2_eop__MIN 0
#define R_IRQ_MASK2_SET__dma2_descr__MIN 0
#define R_IRQ_MASK2_SET__dma1_eop__MIN 0
#define R_IRQ_MASK2_SET__dma1_descr__MIN 0
#define R_IRQ_MASK2_SET__dma0_eop__MIN 0
#define R_IRQ_MASK2_SET__dma0_descr__MIN 0

#define R_IRQ_MASK2_SET__dma8_sub3_descr__BITNR 23
#define R_IRQ_MASK2_SET__dma8_sub2_descr__BITNR 22
#define R_IRQ_MASK2_SET__dma8_sub1_descr__BITNR 21
#define R_IRQ_MASK2_SET__dma8_sub0_descr__BITNR 20
#define R_IRQ_MASK2_SET__dma9_eop__BITNR 19
#define R_IRQ_MASK2_SET__dma9_descr__BITNR 18
#define R_IRQ_MASK2_SET__dma8_eop__BITNR 17
#define R_IRQ_MASK2_SET__dma8_descr__BITNR 16
#define R_IRQ_MASK2_SET__dma7_eop__BITNR 15
#define R_IRQ_MASK2_SET__dma7_descr__BITNR 14
#define R_IRQ_MASK2_SET__dma6_eop__BITNR 13
#define R_IRQ_MASK2_SET__dma6_descr__BITNR 12
#define R_IRQ_MASK2_SET__dma5_eop__BITNR 11
#define R_IRQ_MASK2_SET__dma5_descr__BITNR 10
#define R_IRQ_MASK2_SET__dma4_eop__BITNR 9
#define R_IRQ_MASK2_SET__dma4_descr__BITNR 8
#define R_IRQ_MASK2_SET__dma3_eop__BITNR 7
#define R_IRQ_MASK2_SET__dma3_descr__BITNR 6
#define R_IRQ_MASK2_SET__dma2_eop__BITNR 5
#define R_IRQ_MASK2_SET__dma2_descr__BITNR 4
#define R_IRQ_MASK2_SET__dma1_eop__BITNR 3
#define R_IRQ_MASK2_SET__dma1_descr__BITNR 2
#define R_IRQ_MASK2_SET__dma0_eop__BITNR 1
#define R_IRQ_MASK2_SET__dma0_descr__BITNR 0

#define R_IRQ_MASK2_SET__dma8_sub3_descr__dma8_sub3_descr__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_SET__dma8_sub2_descr__dma8_sub2_descr__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_SET__dma8_sub1_descr__dma8_sub1_descr__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_SET__dma8_sub0_descr__dma8_sub0_descr__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_SET__dma9_eop__dma9_eop__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_SET__dma9_descr__dma9_descr__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_SET__dma8_eop__dma8_eop__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_SET__dma8_descr__dma8_descr__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_SET__dma7_eop__dma7_eop__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_SET__dma7_descr__dma7_descr__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_SET__dma6_eop__dma6_eop__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_SET__dma6_descr__dma6_descr__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_SET__dma5_eop__dma5_eop__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_SET__dma5_descr__dma5_descr__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_SET__dma4_eop__dma4_eop__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_SET__dma4_descr__dma4_descr__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_SET__dma3_eop__dma3_eop__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_SET__dma3_descr__dma3_descr__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_SET__dma2_eop__dma2_eop__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_SET__dma2_descr__dma2_descr__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_SET__dma1_eop__dma1_eop__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_SET__dma1_descr__dma1_descr__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_SET__dma0_eop__dma0_eop__VAL REG_VAL_ENUM
#define R_IRQ_MASK2_SET__dma0_descr__dma0_descr__VAL REG_VAL_ENUM

#define R_IRQ_MASK2_SET__dma8_sub3_descr__dma8_sub3_descr__nop 0
#define R_IRQ_MASK2_SET__dma8_sub3_descr__dma8_sub3_descr__set 1
#define R_IRQ_MASK2_SET__dma8_sub2_descr__dma8_sub2_descr__nop 0
#define R_IRQ_MASK2_SET__dma8_sub2_descr__dma8_sub2_descr__set 1
#define R_IRQ_MASK2_SET__dma8_sub1_descr__dma8_sub1_descr__nop 0
#define R_IRQ_MASK2_SET__dma8_sub1_descr__dma8_sub1_descr__set 1
#define R_IRQ_MASK2_SET__dma8_sub0_descr__dma8_sub0_descr__nop 0
#define R_IRQ_MASK2_SET__dma8_sub0_descr__dma8_sub0_descr__set 1
#define R_IRQ_MASK2_SET__dma9_eop__dma9_eop__nop 0
#define R_IRQ_MASK2_SET__dma9_eop__dma9_eop__set 1
#define R_IRQ_MASK2_SET__dma9_descr__dma9_descr__nop 0
#define R_IRQ_MASK2_SET__dma9_descr__dma9_descr__set 1
#define R_IRQ_MASK2_SET__dma8_eop__dma8_eop__nop 0
#define R_IRQ_MASK2_SET__dma8_eop__dma8_eop__set 1
#define R_IRQ_MASK2_SET__dma8_descr__dma8_descr__nop 0
#define R_IRQ_MASK2_SET__dma8_descr__dma8_descr__set 1
#define R_IRQ_MASK2_SET__dma7_eop__dma7_eop__nop 0
#define R_IRQ_MASK2_SET__dma7_eop__dma7_eop__set 1
#define R_IRQ_MASK2_SET__dma7_descr__dma7_descr__nop 0
#define R_IRQ_MASK2_SET__dma7_descr__dma7_descr__set 1
#define R_IRQ_MASK2_SET__dma6_eop__dma6_eop__nop 0
#define R_IRQ_MASK2_SET__dma6_eop__dma6_eop__set 1
#define R_IRQ_MASK2_SET__dma6_descr__dma6_descr__nop 0
#define R_IRQ_MASK2_SET__dma6_descr__dma6_descr__set 1
#define R_IRQ_MASK2_SET__dma5_eop__dma5_eop__nop 0
#define R_IRQ_MASK2_SET__dma5_eop__dma5_eop__set 1
#define R_IRQ_MASK2_SET__dma5_descr__dma5_descr__nop 0
#define R_IRQ_MASK2_SET__dma5_descr__dma5_descr__set 1
#define R_IRQ_MASK2_SET__dma4_eop__dma4_eop__nop 0
#define R_IRQ_MASK2_SET__dma4_eop__dma4_eop__set 1
#define R_IRQ_MASK2_SET__dma4_descr__dma4_descr__nop 0
#define R_IRQ_MASK2_SET__dma4_descr__dma4_descr__set 1
#define R_IRQ_MASK2_SET__dma3_eop__dma3_eop__nop 0
#define R_IRQ_MASK2_SET__dma3_eop__dma3_eop__set 1
#define R_IRQ_MASK2_SET__dma3_descr__dma3_descr__nop 0
#define R_IRQ_MASK2_SET__dma3_descr__dma3_descr__set 1
#define R_IRQ_MASK2_SET__dma2_eop__dma2_eop__nop 0
#define R_IRQ_MASK2_SET__dma2_eop__dma2_eop__set 1
#define R_IRQ_MASK2_SET__dma2_descr__dma2_descr__nop 0
#define R_IRQ_MASK2_SET__dma2_descr__dma2_descr__set 1
#define R_IRQ_MASK2_SET__dma1_eop__dma1_eop__nop 0
#define R_IRQ_MASK2_SET__dma1_eop__dma1_eop__set 1
#define R_IRQ_MASK2_SET__dma1_descr__dma1_descr__nop 0
#define R_IRQ_MASK2_SET__dma1_descr__dma1_descr__set 1
#define R_IRQ_MASK2_SET__dma0_eop__dma0_eop__nop 0
#define R_IRQ_MASK2_SET__dma0_eop__dma0_eop__set 1
#define R_IRQ_MASK2_SET__dma0_descr__dma0_descr__nop 0
#define R_IRQ_MASK2_SET__dma0_descr__dma0_descr__set 1

#endif

/*
 *  R_IRQ_READ0
 *  - type:  RO
 *  - addr:  0xb00000c4
 *  - group: Interrupt mask and status registers
 */

#if USE_GROUP__Interrupt_mask_and_status_registers

#define R_IRQ_READ0__ADDR      (REG_TYPECAST_UDWORD  0xb00000c4)
#define R_IRQ_READ0__SVAL      REG_SVAL_SHADOW
#define R_IRQ_READ0__SVAL_I    REG_SVAL_I_SHADOW
#define R_IRQ_READ0__TYPECAST  REG_TYPECAST_UDWORD
#define R_IRQ_READ0__TYPE      (REG_UDWORD)
#define R_IRQ_READ0__GET       REG_GET_RO
#define R_IRQ_READ0__IGET      REG_IGET_RO
#define R_IRQ_READ0__SET       REG_SET_RO
#define R_IRQ_READ0__ISET      REG_ISET_RO
#define R_IRQ_READ0__SET_VAL   REG_SET_VAL_RO
#define R_IRQ_READ0__EQL       REG_EQL_RO
#define R_IRQ_READ0__IEQL      REG_IEQL_RO
#define R_IRQ_READ0__RD        REG_RD_RO
#define R_IRQ_READ0__IRD       REG_IRD_RO
#define R_IRQ_READ0__WR        REG_WR_RO
#define R_IRQ_READ0__IWR       REG_IWR_RO

#define R_IRQ_READ0__READ(addr) \
  (*(addr))

#define R_IRQ_READ0__nmi_pin__nmi_pin__MASK 0x80000000U
#define R_IRQ_READ0__watchdog_nmi__watchdog_nmi__MASK 0x40000000U
#define R_IRQ_READ0__sqe_test_error__sqe_test_error__MASK 0x20000000U
#define R_IRQ_READ0__carrier_loss__carrier_loss__MASK 0x10000000U
#define R_IRQ_READ0__deferred__deferred__MASK 0x08000000U
#define R_IRQ_READ0__late_col__late_col__MASK 0x04000000U
#define R_IRQ_READ0__multiple_col__multiple_col__MASK 0x02000000U
#define R_IRQ_READ0__single_col__single_col__MASK 0x01000000U
#define R_IRQ_READ0__congestion__congestion__MASK 0x00800000U
#define R_IRQ_READ0__oversize__oversize__MASK 0x00400000U
#define R_IRQ_READ0__alignment_error__alignment_error__MASK 0x00200000U
#define R_IRQ_READ0__crc_error__crc_error__MASK 0x00100000U
#define R_IRQ_READ0__overrun__overrun__MASK 0x00080000U
#define R_IRQ_READ0__underrun__underrun__MASK 0x00040000U
#define R_IRQ_READ0__excessive_col__excessive_col__MASK 0x00020000U
#define R_IRQ_READ0__mdio__mdio__MASK 0x00010000U
#define R_IRQ_READ0__ata_drq3__ata_drq3__MASK 0x00008000U
#define R_IRQ_READ0__ata_drq2__ata_drq2__MASK 0x00004000U
#define R_IRQ_READ0__ata_drq1__ata_drq1__MASK 0x00002000U
#define R_IRQ_READ0__ata_drq0__ata_drq0__MASK 0x00001000U
#define R_IRQ_READ0__par0_ecp_cmd__par0_ecp_cmd__MASK 0x00000800U
#define R_IRQ_READ0__ata_irq3__ata_irq3__MASK 0x00000800U
#define R_IRQ_READ0__par0_ecp_cmd__ata_irq3__MASK 0x00000800U
#define R_IRQ_READ0__par0_peri__par0_peri__MASK 0x00000400U
#define R_IRQ_READ0__ata_irq2__ata_irq2__MASK 0x00000400U
#define R_IRQ_READ0__par0_peri__ata_irq2__MASK 0x00000400U
#define R_IRQ_READ0__par0_data__par0_data__MASK 0x00000200U
#define R_IRQ_READ0__ata_irq1__ata_irq1__MASK 0x00000200U
#define R_IRQ_READ0__par0_data__ata_irq1__MASK 0x00000200U
#define R_IRQ_READ0__par0_ready__par0_ready__MASK 0x00000100U
#define R_IRQ_READ0__ata_irq0__ata_irq0__MASK 0x00000100U
#define R_IRQ_READ0__par0_ready__ata_irq0__MASK 0x00000100U
#define R_IRQ_READ0__mio__mio__MASK 0x00000100U
#define R_IRQ_READ0__par0_ready__mio__MASK 0x00000100U
#define R_IRQ_READ0__scsi0__scsi0__MASK 0x00000100U
#define R_IRQ_READ0__par0_ready__scsi0__MASK 0x00000100U
#define R_IRQ_READ0__ata_dmaend__ata_dmaend__MASK 0x00000080U
#define R_IRQ_READ0__irq_ext_vector_nr__irq_ext_vector_nr__MASK 0x00000020U
#define R_IRQ_READ0__irq_int_vector_nr__irq_int_vector_nr__MASK 0x00000010U
#define R_IRQ_READ0__ext_dma1__ext_dma1__MASK 0x00000008U
#define R_IRQ_READ0__ext_dma0__ext_dma0__MASK 0x00000004U
#define R_IRQ_READ0__timer1__timer1__MASK 0x00000002U
#define R_IRQ_READ0__timer0__timer0__MASK 0x00000001U

#define R_IRQ_READ0__nmi_pin__MAX 0x1
#define R_IRQ_READ0__watchdog_nmi__MAX 0x1
#define R_IRQ_READ0__sqe_test_error__MAX 0x1
#define R_IRQ_READ0__carrier_loss__MAX 0x1
#define R_IRQ_READ0__deferred__MAX 0x1
#define R_IRQ_READ0__late_col__MAX 0x1
#define R_IRQ_READ0__multiple_col__MAX 0x1
#define R_IRQ_READ0__single_col__MAX 0x1
#define R_IRQ_READ0__congestion__MAX 0x1
#define R_IRQ_READ0__oversize__MAX 0x1
#define R_IRQ_READ0__alignment_error__MAX 0x1
#define R_IRQ_READ0__crc_error__MAX 0x1
#define R_IRQ_READ0__overrun__MAX 0x1
#define R_IRQ_READ0__underrun__MAX 0x1
#define R_IRQ_READ0__excessive_col__MAX 0x1
#define R_IRQ_READ0__mdio__MAX 0x1
#define R_IRQ_READ0__ata_drq3__MAX 0x1
#define R_IRQ_READ0__ata_drq2__MAX 0x1
#define R_IRQ_READ0__ata_drq1__MAX 0x1
#define R_IRQ_READ0__ata_drq0__MAX 0x1
#define R_IRQ_READ0__par0_ecp_cmd__MAX 0x1
#define R_IRQ_READ0__ata_irq3__MAX 0x1
#define R_IRQ_READ0__par0_peri__MAX 0x1
#define R_IRQ_READ0__ata_irq2__MAX 0x1
#define R_IRQ_READ0__par0_data__MAX 0x1
#define R_IRQ_READ0__ata_irq1__MAX 0x1
#define R_IRQ_READ0__par0_ready__MAX 0x1
#define R_IRQ_READ0__ata_irq0__MAX 0x1
#define R_IRQ_READ0__mio__MAX 0x1
#define R_IRQ_READ0__scsi0__MAX 0x1
#define R_IRQ_READ0__ata_dmaend__MAX 0x1
#define R_IRQ_READ0__irq_ext_vector_nr__MAX 0x1
#define R_IRQ_READ0__irq_int_vector_nr__MAX 0x1
#define R_IRQ_READ0__ext_dma1__MAX 0x1
#define R_IRQ_READ0__ext_dma0__MAX 0x1
#define R_IRQ_READ0__timer1__MAX 0x1
#define R_IRQ_READ0__timer0__MAX 0x1

#define R_IRQ_READ0__nmi_pin__MIN 0
#define R_IRQ_READ0__watchdog_nmi__MIN 0
#define R_IRQ_READ0__sqe_test_error__MIN 0
#define R_IRQ_READ0__carrier_loss__MIN 0
#define R_IRQ_READ0__deferred__MIN 0
#define R_IRQ_READ0__late_col__MIN 0
#define R_IRQ_READ0__multiple_col__MIN 0
#define R_IRQ_READ0__single_col__MIN 0
#define R_IRQ_READ0__congestion__MIN 0
#define R_IRQ_READ0__oversize__MIN 0
#define R_IRQ_READ0__alignment_error__MIN 0
#define R_IRQ_READ0__crc_error__MIN 0
#define R_IRQ_READ0__overrun__MIN 0
#define R_IRQ_READ0__underrun__MIN 0
#define R_IRQ_READ0__excessive_col__MIN 0
#define R_IRQ_READ0__mdio__MIN 0
#define R_IRQ_READ0__ata_drq3__MIN 0
#define R_IRQ_READ0__ata_drq2__MIN 0
#define R_IRQ_READ0__ata_drq1__MIN 0
#define R_IRQ_READ0__ata_drq0__MIN 0
#define R_IRQ_READ0__par0_ecp_cmd__MIN 0
#define R_IRQ_READ0__ata_irq3__MIN 0
#define R_IRQ_READ0__par0_peri__MIN 0
#define R_IRQ_READ0__ata_irq2__MIN 0
#define R_IRQ_READ0__par0_data__MIN 0
#define R_IRQ_READ0__ata_irq1__MIN 0
#define R_IRQ_READ0__par0_ready__MIN 0
#define R_IRQ_READ0__ata_irq0__MIN 0
#define R_IRQ_READ0__mio__MIN 0
#define R_IRQ_READ0__scsi0__MIN 0
#define R_IRQ_READ0__ata_dmaend__MIN 0
#define R_IRQ_READ0__irq_ext_vector_nr__MIN 0
#define R_IRQ_READ0__irq_int_vector_nr__MIN 0
#define R_IRQ_READ0__ext_dma1__MIN 0
#define R_IRQ_READ0__ext_dma0__MIN 0
#define R_IRQ_READ0__timer1__MIN 0
#define R_IRQ_READ0__timer0__MIN 0

#define R_IRQ_READ0__nmi_pin__BITNR 31
#define R_IRQ_READ0__watchdog_nmi__BITNR 30
#define R_IRQ_READ0__sqe_test_error__BITNR 29
#define R_IRQ_READ0__carrier_loss__BITNR 28
#define R_IRQ_READ0__deferred__BITNR 27
#define R_IRQ_READ0__late_col__BITNR 26
#define R_IRQ_READ0__multiple_col__BITNR 25
#define R_IRQ_READ0__single_col__BITNR 24
#define R_IRQ_READ0__congestion__BITNR 23
#define R_IRQ_READ0__oversize__BITNR 22
#define R_IRQ_READ0__alignment_error__BITNR 21
#define R_IRQ_READ0__crc_error__BITNR 20
#define R_IRQ_READ0__overrun__BITNR 19
#define R_IRQ_READ0__underrun__BITNR 18
#define R_IRQ_READ0__excessive_col__BITNR 17
#define R_IRQ_READ0__mdio__BITNR 16
#define R_IRQ_READ0__ata_drq3__BITNR 15
#define R_IRQ_READ0__ata_drq2__BITNR 14
#define R_IRQ_READ0__ata_drq1__BITNR 13
#define R_IRQ_READ0__ata_drq0__BITNR 12
#define R_IRQ_READ0__par0_ecp_cmd__BITNR 11
#define R_IRQ_READ0__ata_irq3__BITNR 11
#define R_IRQ_READ0__par0_peri__BITNR 10
#define R_IRQ_READ0__ata_irq2__BITNR 10
#define R_IRQ_READ0__par0_data__BITNR 9
#define R_IRQ_READ0__ata_irq1__BITNR 9
#define R_IRQ_READ0__par0_ready__BITNR 8
#define R_IRQ_READ0__ata_irq0__BITNR 8
#define R_IRQ_READ0__mio__BITNR 8
#define R_IRQ_READ0__scsi0__BITNR 8
#define R_IRQ_READ0__ata_dmaend__BITNR 7
#define R_IRQ_READ0__irq_ext_vector_nr__BITNR 5
#define R_IRQ_READ0__irq_int_vector_nr__BITNR 4
#define R_IRQ_READ0__ext_dma1__BITNR 3
#define R_IRQ_READ0__ext_dma0__BITNR 2
#define R_IRQ_READ0__timer1__BITNR 1
#define R_IRQ_READ0__timer0__BITNR 0

#define R_IRQ_READ0__nmi_pin__nmi_pin__VAL REG_VAL_ENUM
#define R_IRQ_READ0__watchdog_nmi__watchdog_nmi__VAL REG_VAL_ENUM
#define R_IRQ_READ0__sqe_test_error__sqe_test_error__VAL REG_VAL_ENUM
#define R_IRQ_READ0__carrier_loss__carrier_loss__VAL REG_VAL_ENUM
#define R_IRQ_READ0__deferred__deferred__VAL REG_VAL_ENUM
#define R_IRQ_READ0__late_col__late_col__VAL REG_VAL_ENUM
#define R_IRQ_READ0__multiple_col__multiple_col__VAL REG_VAL_ENUM
#define R_IRQ_READ0__single_col__single_col__VAL REG_VAL_ENUM
#define R_IRQ_READ0__congestion__congestion__VAL REG_VAL_ENUM
#define R_IRQ_READ0__oversize__oversize__VAL REG_VAL_ENUM
#define R_IRQ_READ0__alignment_error__alignment_error__VAL REG_VAL_ENUM
#define R_IRQ_READ0__crc_error__crc_error__VAL REG_VAL_ENUM
#define R_IRQ_READ0__overrun__overrun__VAL REG_VAL_ENUM
#define R_IRQ_READ0__underrun__underrun__VAL REG_VAL_ENUM
#define R_IRQ_READ0__excessive_col__excessive_col__VAL REG_VAL_ENUM
#define R_IRQ_READ0__mdio__mdio__VAL REG_VAL_ENUM
#define R_IRQ_READ0__ata_drq3__ata_drq3__VAL REG_VAL_ENUM
#define R_IRQ_READ0__ata_drq2__ata_drq2__VAL REG_VAL_ENUM
#define R_IRQ_READ0__ata_drq1__ata_drq1__VAL REG_VAL_ENUM
#define R_IRQ_READ0__ata_drq0__ata_drq0__VAL REG_VAL_ENUM
#define R_IRQ_READ0__par0_ecp_cmd__par0_ecp_cmd__VAL REG_VAL_ENUM
#define R_IRQ_READ0__ata_irq3__ata_irq3__VAL REG_VAL_ENUM
#define R_IRQ_READ0__par0_ecp_cmd__ata_irq3__VAL REG_VAL_ENUM
#define R_IRQ_READ0__par0_peri__par0_peri__VAL REG_VAL_ENUM
#define R_IRQ_READ0__ata_irq2__ata_irq2__VAL REG_VAL_ENUM
#define R_IRQ_READ0__par0_peri__ata_irq2__VAL REG_VAL_ENUM
#define R_IRQ_READ0__par0_data__par0_data__VAL REG_VAL_ENUM
#define R_IRQ_READ0__ata_irq1__ata_irq1__VAL REG_VAL_ENUM
#define R_IRQ_READ0__par0_data__ata_irq1__VAL REG_VAL_ENUM
#define R_IRQ_READ0__par0_ready__par0_ready__VAL REG_VAL_ENUM
#define R_IRQ_READ0__ata_irq0__ata_irq0__VAL REG_VAL_ENUM
#define R_IRQ_READ0__par0_ready__ata_irq0__VAL REG_VAL_ENUM
#define R_IRQ_READ0__mio__mio__VAL REG_VAL_ENUM
#define R_IRQ_READ0__par0_ready__mio__VAL REG_VAL_ENUM
#define R_IRQ_READ0__scsi0__scsi0__VAL REG_VAL_ENUM
#define R_IRQ_READ0__par0_ready__scsi0__VAL REG_VAL_ENUM
#define R_IRQ_READ0__ata_dmaend__ata_dmaend__VAL REG_VAL_ENUM
#define R_IRQ_READ0__irq_ext_vector_nr__irq_ext_vector_nr__VAL REG_VAL_ENUM
#define R_IRQ_READ0__irq_int_vector_nr__irq_int_vector_nr__VAL REG_VAL_ENUM
#define R_IRQ_READ0__ext_dma1__ext_dma1__VAL REG_VAL_ENUM
#define R_IRQ_READ0__ext_dma0__ext_dma0__VAL REG_VAL_ENUM
#define R_IRQ_READ0__timer1__timer1__VAL REG_VAL_ENUM
#define R_IRQ_READ0__timer0__timer0__VAL REG_VAL_ENUM

#define R_IRQ_READ0__nmi_pin__nmi_pin__active 1
#define R_IRQ_READ0__nmi_pin__nmi_pin__inactive 0
#define R_IRQ_READ0__watchdog_nmi__watchdog_nmi__active 1
#define R_IRQ_READ0__watchdog_nmi__watchdog_nmi__inactive 0
#define R_IRQ_READ0__sqe_test_error__sqe_test_error__active 1
#define R_IRQ_READ0__sqe_test_error__sqe_test_error__inactive 0
#define R_IRQ_READ0__carrier_loss__carrier_loss__active 1
#define R_IRQ_READ0__carrier_loss__carrier_loss__inactive 0
#define R_IRQ_READ0__deferred__deferred__active 1
#define R_IRQ_READ0__deferred__deferred__inactive 0
#define R_IRQ_READ0__late_col__late_col__active 1
#define R_IRQ_READ0__late_col__late_col__inactive 0
#define R_IRQ_READ0__multiple_col__multiple_col__active 1
#define R_IRQ_READ0__multiple_col__multiple_col__inactive 0
#define R_IRQ_READ0__single_col__single_col__active 1
#define R_IRQ_READ0__single_col__single_col__inactive 0
#define R_IRQ_READ0__congestion__congestion__active 1
#define R_IRQ_READ0__congestion__congestion__inactive 0
#define R_IRQ_READ0__oversize__oversize__active 1
#define R_IRQ_READ0__oversize__oversize__inactive 0
#define R_IRQ_READ0__alignment_error__alignment_error__active 1
#define R_IRQ_READ0__alignment_error__alignment_error__inactive 0
#define R_IRQ_READ0__crc_error__crc_error__active 1
#define R_IRQ_READ0__crc_error__crc_error__inactive 0
#define R_IRQ_READ0__overrun__overrun__active 1
#define R_IRQ_READ0__overrun__overrun__inactive 0
#define R_IRQ_READ0__underrun__underrun__active 1
#define R_IRQ_READ0__underrun__underrun__inactive 0
#define R_IRQ_READ0__excessive_col__excessive_col__active 1
#define R_IRQ_READ0__excessive_col__excessive_col__inactive 0
#define R_IRQ_READ0__mdio__mdio__active 1
#define R_IRQ_READ0__mdio__mdio__inactive 0
#define R_IRQ_READ0__ata_drq3__ata_drq3__active 1
#define R_IRQ_READ0__ata_drq3__ata_drq3__inactive 0
#define R_IRQ_READ0__ata_drq2__ata_drq2__active 1
#define R_IRQ_READ0__ata_drq2__ata_drq2__inactive 0
#define R_IRQ_READ0__ata_drq1__ata_drq1__active 1
#define R_IRQ_READ0__ata_drq1__ata_drq1__inactive 0
#define R_IRQ_READ0__ata_drq0__ata_drq0__active 1
#define R_IRQ_READ0__ata_drq0__ata_drq0__inactive 0
#define R_IRQ_READ0__par0_ecp_cmd__par0_ecp_cmd__active 1
#define R_IRQ_READ0__par0_ecp_cmd__par0_ecp_cmd__inactive 0
#define R_IRQ_READ0__ata_irq3__ata_irq3__active 1
#define R_IRQ_READ0__ata_irq3__ata_irq3__inactive 0
#define R_IRQ_READ0__par0_peri__par0_peri__active 1
#define R_IRQ_READ0__par0_peri__par0_peri__inactive 0
#define R_IRQ_READ0__ata_irq2__ata_irq2__active 1
#define R_IRQ_READ0__ata_irq2__ata_irq2__inactive 0
#define R_IRQ_READ0__par0_data__par0_data__active 1
#define R_IRQ_READ0__par0_data__par0_data__inactive 0
#define R_IRQ_READ0__ata_irq1__ata_irq1__active 1
#define R_IRQ_READ0__ata_irq1__ata_irq1__inactive 0
#define R_IRQ_READ0__par0_ready__par0_ready__active 1
#define R_IRQ_READ0__par0_ready__par0_ready__inactive 0
#define R_IRQ_READ0__ata_irq0__ata_irq0__active 1
#define R_IRQ_READ0__ata_irq0__ata_irq0__inactive 0
#define R_IRQ_READ0__mio__mio__active 1
#define R_IRQ_READ0__mio__mio__inactive 0
#define R_IRQ_READ0__scsi0__scsi0__active 1
#define R_IRQ_READ0__scsi0__scsi0__inactive 0
#define R_IRQ_READ0__ata_dmaend__ata_dmaend__active 1
#define R_IRQ_READ0__ata_dmaend__ata_dmaend__inactive 0
#define R_IRQ_READ0__irq_ext_vector_nr__irq_ext_vector_nr__active 1
#define R_IRQ_READ0__irq_ext_vector_nr__irq_ext_vector_nr__inactive 0
#define R_IRQ_READ0__irq_int_vector_nr__irq_int_vector_nr__active 1
#define R_IRQ_READ0__irq_int_vector_nr__irq_int_vector_nr__inactive 0
#define R_IRQ_READ0__ext_dma1__ext_dma1__active 1
#define R_IRQ_READ0__ext_dma1__ext_dma1__inactive 0
#define R_IRQ_READ0__ext_dma0__ext_dma0__active 1
#define R_IRQ_READ0__ext_dma0__ext_dma0__inactive 0
#define R_IRQ_READ0__timer1__timer1__active 1
#define R_IRQ_READ0__timer1__timer1__inactive 0
#define R_IRQ_READ0__timer0__timer0__active 1
#define R_IRQ_READ0__timer0__timer0__inactive 0

#endif

/*
 *  R_IRQ_READ1
 *  - type:  RO
 *  - addr:  0xb00000cc
 *  - group: Interrupt mask and status registers
 */

#if USE_GROUP__Interrupt_mask_and_status_registers

#define R_IRQ_READ1__ADDR      (REG_TYPECAST_UDWORD  0xb00000cc)
#define R_IRQ_READ1__SVAL      REG_SVAL_SHADOW
#define R_IRQ_READ1__SVAL_I    REG_SVAL_I_SHADOW
#define R_IRQ_READ1__TYPECAST  REG_TYPECAST_UDWORD
#define R_IRQ_READ1__TYPE      (REG_UDWORD)
#define R_IRQ_READ1__GET       REG_GET_RO
#define R_IRQ_READ1__IGET      REG_IGET_RO
#define R_IRQ_READ1__SET       REG_SET_RO
#define R_IRQ_READ1__ISET      REG_ISET_RO
#define R_IRQ_READ1__SET_VAL   REG_SET_VAL_RO
#define R_IRQ_READ1__EQL       REG_EQL_RO
#define R_IRQ_READ1__IEQL      REG_IEQL_RO
#define R_IRQ_READ1__RD        REG_RD_RO
#define R_IRQ_READ1__IRD       REG_IRD_RO
#define R_IRQ_READ1__WR        REG_WR_RO
#define R_IRQ_READ1__IWR       REG_IWR_RO

#define R_IRQ_READ1__READ(addr) \
  (*(addr))

#define R_IRQ_READ1__sw_int7__sw_int7__MASK 0x80000000U
#define R_IRQ_READ1__sw_int6__sw_int6__MASK 0x40000000U
#define R_IRQ_READ1__sw_int5__sw_int5__MASK 0x20000000U
#define R_IRQ_READ1__sw_int4__sw_int4__MASK 0x10000000U
#define R_IRQ_READ1__sw_int3__sw_int3__MASK 0x08000000U
#define R_IRQ_READ1__sw_int2__sw_int2__MASK 0x04000000U
#define R_IRQ_READ1__sw_int1__sw_int1__MASK 0x02000000U
#define R_IRQ_READ1__sw_int0__sw_int0__MASK 0x01000000U
#define R_IRQ_READ1__par1_ecp_cmd__par1_ecp_cmd__MASK 0x00080000U
#define R_IRQ_READ1__par1_peri__par1_peri__MASK 0x00040000U
#define R_IRQ_READ1__par1_data__par1_data__MASK 0x00020000U
#define R_IRQ_READ1__par1_ready__par1_ready__MASK 0x00010000U
#define R_IRQ_READ1__scsi1__scsi1__MASK 0x00010000U
#define R_IRQ_READ1__par1_ready__scsi1__MASK 0x00010000U
#define R_IRQ_READ1__ser3_ready__ser3_ready__MASK 0x00008000U
#define R_IRQ_READ1__ser3_data__ser3_data__MASK 0x00004000U
#define R_IRQ_READ1__ser2_ready__ser2_ready__MASK 0x00002000U
#define R_IRQ_READ1__ser2_data__ser2_data__MASK 0x00001000U
#define R_IRQ_READ1__ser1_ready__ser1_ready__MASK 0x00000800U
#define R_IRQ_READ1__ser1_data__ser1_data__MASK 0x00000400U
#define R_IRQ_READ1__ser0_ready__ser0_ready__MASK 0x00000200U
#define R_IRQ_READ1__ser0_data__ser0_data__MASK 0x00000100U
#define R_IRQ_READ1__pa7__pa7__MASK 0x00000080U
#define R_IRQ_READ1__pa6__pa6__MASK 0x00000040U
#define R_IRQ_READ1__pa5__pa5__MASK 0x00000020U
#define R_IRQ_READ1__pa4__pa4__MASK 0x00000010U
#define R_IRQ_READ1__pa3__pa3__MASK 0x00000008U
#define R_IRQ_READ1__pa2__pa2__MASK 0x00000004U
#define R_IRQ_READ1__pa1__pa1__MASK 0x00000002U
#define R_IRQ_READ1__pa0__pa0__MASK 0x00000001U

#define R_IRQ_READ1__sw_int7__MAX 0x1
#define R_IRQ_READ1__sw_int6__MAX 0x1
#define R_IRQ_READ1__sw_int5__MAX 0x1
#define R_IRQ_READ1__sw_int4__MAX 0x1
#define R_IRQ_READ1__sw_int3__MAX 0x1
#define R_IRQ_READ1__sw_int2__MAX 0x1
#define R_IRQ_READ1__sw_int1__MAX 0x1
#define R_IRQ_READ1__sw_int0__MAX 0x1
#define R_IRQ_READ1__par1_ecp_cmd__MAX 0x1
#define R_IRQ_READ1__par1_peri__MAX 0x1
#define R_IRQ_READ1__par1_data__MAX 0x1
#define R_IRQ_READ1__par1_ready__MAX 0x1
#define R_IRQ_READ1__scsi1__MAX 0x1
#define R_IRQ_READ1__ser3_ready__MAX 0x1
#define R_IRQ_READ1__ser3_data__MAX 0x1
#define R_IRQ_READ1__ser2_ready__MAX 0x1
#define R_IRQ_READ1__ser2_data__MAX 0x1
#define R_IRQ_READ1__ser1_ready__MAX 0x1
#define R_IRQ_READ1__ser1_data__MAX 0x1
#define R_IRQ_READ1__ser0_ready__MAX 0x1
#define R_IRQ_READ1__ser0_data__MAX 0x1
#define R_IRQ_READ1__pa7__MAX 0x1
#define R_IRQ_READ1__pa6__MAX 0x1
#define R_IRQ_READ1__pa5__MAX 0x1
#define R_IRQ_READ1__pa4__MAX 0x1
#define R_IRQ_READ1__pa3__MAX 0x1
#define R_IRQ_READ1__pa2__MAX 0x1
#define R_IRQ_READ1__pa1__MAX 0x1
#define R_IRQ_READ1__pa0__MAX 0x1

#define R_IRQ_READ1__sw_int7__MIN 0
#define R_IRQ_READ1__sw_int6__MIN 0
#define R_IRQ_READ1__sw_int5__MIN 0
#define R_IRQ_READ1__sw_int4__MIN 0
#define R_IRQ_READ1__sw_int3__MIN 0
#define R_IRQ_READ1__sw_int2__MIN 0
#define R_IRQ_READ1__sw_int1__MIN 0
#define R_IRQ_READ1__sw_int0__MIN 0
#define R_IRQ_READ1__par1_ecp_cmd__MIN 0
#define R_IRQ_READ1__par1_peri__MIN 0
#define R_IRQ_READ1__par1_data__MIN 0
#define R_IRQ_READ1__par1_ready__MIN 0
#define R_IRQ_READ1__scsi1__MIN 0
#define R_IRQ_READ1__ser3_ready__MIN 0
#define R_IRQ_READ1__ser3_data__MIN 0
#define R_IRQ_READ1__ser2_ready__MIN 0
#define R_IRQ_READ1__ser2_data__MIN 0
#define R_IRQ_READ1__ser1_ready__MIN 0
#define R_IRQ_READ1__ser1_data__MIN 0
#define R_IRQ_READ1__ser0_ready__MIN 0
#define R_IRQ_READ1__ser0_data__MIN 0
#define R_IRQ_READ1__pa7__MIN 0
#define R_IRQ_READ1__pa6__MIN 0
#define R_IRQ_READ1__pa5__MIN 0
#define R_IRQ_READ1__pa4__MIN 0
#define R_IRQ_READ1__pa3__MIN 0
#define R_IRQ_READ1__pa2__MIN 0
#define R_IRQ_READ1__pa1__MIN 0
#define R_IRQ_READ1__pa0__MIN 0

#define R_IRQ_READ1__sw_int7__BITNR 31
#define R_IRQ_READ1__sw_int6__BITNR 30
#define R_IRQ_READ1__sw_int5__BITNR 29
#define R_IRQ_READ1__sw_int4__BITNR 28
#define R_IRQ_READ1__sw_int3__BITNR 27
#define R_IRQ_READ1__sw_int2__BITNR 26
#define R_IRQ_READ1__sw_int1__BITNR 25
#define R_IRQ_READ1__sw_int0__BITNR 24
#define R_IRQ_READ1__par1_ecp_cmd__BITNR 19
#define R_IRQ_READ1__par1_peri__BITNR 18
#define R_IRQ_READ1__par1_data__BITNR 17
#define R_IRQ_READ1__par1_ready__BITNR 16
#define R_IRQ_READ1__scsi1__BITNR 16
#define R_IRQ_READ1__ser3_ready__BITNR 15
#define R_IRQ_READ1__ser3_data__BITNR 14
#define R_IRQ_READ1__ser2_ready__BITNR 13
#define R_IRQ_READ1__ser2_data__BITNR 12
#define R_IRQ_READ1__ser1_ready__BITNR 11
#define R_IRQ_READ1__ser1_data__BITNR 10
#define R_IRQ_READ1__ser0_ready__BITNR 9
#define R_IRQ_READ1__ser0_data__BITNR 8
#define R_IRQ_READ1__pa7__BITNR 7
#define R_IRQ_READ1__pa6__BITNR 6
#define R_IRQ_READ1__pa5__BITNR 5
#define R_IRQ_READ1__pa4__BITNR 4
#define R_IRQ_READ1__pa3__BITNR 3
#define R_IRQ_READ1__pa2__BITNR 2
#define R_IRQ_READ1__pa1__BITNR 1
#define R_IRQ_READ1__pa0__BITNR 0

#define R_IRQ_READ1__sw_int7__sw_int7__VAL REG_VAL_ENUM
#define R_IRQ_READ1__sw_int6__sw_int6__VAL REG_VAL_ENUM
#define R_IRQ_READ1__sw_int5__sw_int5__VAL REG_VAL_ENUM
#define R_IRQ_READ1__sw_int4__sw_int4__VAL REG_VAL_ENUM
#define R_IRQ_READ1__sw_int3__sw_int3__VAL REG_VAL_ENUM
#define R_IRQ_READ1__sw_int2__sw_int2__VAL REG_VAL_ENUM
#define R_IRQ_READ1__sw_int1__sw_int1__VAL REG_VAL_ENUM
#define R_IRQ_READ1__sw_int0__sw_int0__VAL REG_VAL_ENUM
#define R_IRQ_READ1__par1_ecp_cmd__par1_ecp_cmd__VAL REG_VAL_ENUM
#define R_IRQ_READ1__par1_peri__par1_peri__VAL REG_VAL_ENUM
#define R_IRQ_READ1__par1_data__par1_data__VAL REG_VAL_ENUM
#define R_IRQ_READ1__par1_ready__par1_ready__VAL REG_VAL_ENUM
#define R_IRQ_READ1__scsi1__scsi1__VAL REG_VAL_ENUM
#define R_IRQ_READ1__par1_ready__scsi1__VAL REG_VAL_ENUM
#define R_IRQ_READ1__ser3_ready__ser3_ready__VAL REG_VAL_ENUM
#define R_IRQ_READ1__ser3_data__ser3_data__VAL REG_VAL_ENUM
#define R_IRQ_READ1__ser2_ready__ser2_ready__VAL REG_VAL_ENUM
#define R_IRQ_READ1__ser2_data__ser2_data__VAL REG_VAL_ENUM
#define R_IRQ_READ1__ser1_ready__ser1_ready__VAL REG_VAL_ENUM
#define R_IRQ_READ1__ser1_data__ser1_data__VAL REG_VAL_ENUM
#define R_IRQ_READ1__ser0_ready__ser0_ready__VAL REG_VAL_ENUM
#define R_IRQ_READ1__ser0_data__ser0_data__VAL REG_VAL_ENUM
#define R_IRQ_READ1__pa7__pa7__VAL REG_VAL_ENUM
#define R_IRQ_READ1__pa6__pa6__VAL REG_VAL_ENUM
#define R_IRQ_READ1__pa5__pa5__VAL REG_VAL_ENUM
#define R_IRQ_READ1__pa4__pa4__VAL REG_VAL_ENUM
#define R_IRQ_READ1__pa3__pa3__VAL REG_VAL_ENUM
#define R_IRQ_READ1__pa2__pa2__VAL REG_VAL_ENUM
#define R_IRQ_READ1__pa1__pa1__VAL REG_VAL_ENUM
#define R_IRQ_READ1__pa0__pa0__VAL REG_VAL_ENUM

#define R_IRQ_READ1__sw_int7__sw_int7__active 1
#define R_IRQ_READ1__sw_int7__sw_int7__inactive 0
#define R_IRQ_READ1__sw_int6__sw_int6__active 1
#define R_IRQ_READ1__sw_int6__sw_int6__inactive 0
#define R_IRQ_READ1__sw_int5__sw_int5__active 1
#define R_IRQ_READ1__sw_int5__sw_int5__inactive 0
#define R_IRQ_READ1__sw_int4__sw_int4__active 1
#define R_IRQ_READ1__sw_int4__sw_int4__inactive 0
#define R_IRQ_READ1__sw_int3__sw_int3__active 1
#define R_IRQ_READ1__sw_int3__sw_int3__inactive 0
#define R_IRQ_READ1__sw_int2__sw_int2__active 1
#define R_IRQ_READ1__sw_int2__sw_int2__inactive 0
#define R_IRQ_READ1__sw_int1__sw_int1__active 1
#define R_IRQ_READ1__sw_int1__sw_int1__inactive 0
#define R_IRQ_READ1__sw_int0__sw_int0__active 1
#define R_IRQ_READ1__sw_int0__sw_int0__inactive 0
#define R_IRQ_READ1__par1_ecp_cmd__par1_ecp_cmd__active 1
#define R_IRQ_READ1__par1_ecp_cmd__par1_ecp_cmd__inactive 0
#define R_IRQ_READ1__par1_peri__par1_peri__active 1
#define R_IRQ_READ1__par1_peri__par1_peri__inactive 0
#define R_IRQ_READ1__par1_data__par1_data__active 1
#define R_IRQ_READ1__par1_data__par1_data__inactive 0
#define R_IRQ_READ1__par1_ready__par1_ready__active 1
#define R_IRQ_READ1__par1_ready__par1_ready__inactive 0
#define R_IRQ_READ1__scsi1__scsi1__active 1
#define R_IRQ_READ1__scsi1__scsi1__inactive 0
#define R_IRQ_READ1__ser3_ready__ser3_ready__active 1
#define R_IRQ_READ1__ser3_ready__ser3_ready__inactive 0
#define R_IRQ_READ1__ser3_data__ser3_data__active 1
#define R_IRQ_READ1__ser3_data__ser3_data__inactive 0
#define R_IRQ_READ1__ser2_ready__ser2_ready__active 1
#define R_IRQ_READ1__ser2_ready__ser2_ready__inactive 0
#define R_IRQ_READ1__ser2_data__ser2_data__active 1
#define R_IRQ_READ1__ser2_data__ser2_data__inactive 0
#define R_IRQ_READ1__ser1_ready__ser1_ready__active 1
#define R_IRQ_READ1__ser1_ready__ser1_ready__inactive 0
#define R_IRQ_READ1__ser1_data__ser1_data__active 1
#define R_IRQ_READ1__ser1_data__ser1_data__inactive 0
#define R_IRQ_READ1__ser0_ready__ser0_ready__active 1
#define R_IRQ_READ1__ser0_ready__ser0_ready__inactive 0
#define R_IRQ_READ1__ser0_data__ser0_data__active 1
#define R_IRQ_READ1__ser0_data__ser0_data__inactive 0
#define R_IRQ_READ1__pa7__pa7__active 1
#define R_IRQ_READ1__pa7__pa7__inactive 0
#define R_IRQ_READ1__pa6__pa6__active 1
#define R_IRQ_READ1__pa6__pa6__inactive 0
#define R_IRQ_READ1__pa5__pa5__active 1
#define R_IRQ_READ1__pa5__pa5__inactive 0
#define R_IRQ_READ1__pa4__pa4__active 1
#define R_IRQ_READ1__pa4__pa4__inactive 0
#define R_IRQ_READ1__pa3__pa3__active 1
#define R_IRQ_READ1__pa3__pa3__inactive 0
#define R_IRQ_READ1__pa2__pa2__active 1
#define R_IRQ_READ1__pa2__pa2__inactive 0
#define R_IRQ_READ1__pa1__pa1__active 1
#define R_IRQ_READ1__pa1__pa1__inactive 0
#define R_IRQ_READ1__pa0__pa0__active 1
#define R_IRQ_READ1__pa0__pa0__inactive 0

#endif

/*
 *  R_IRQ_READ2
 *  - type:  RO
 *  - addr:  0xb00000d4
 *  - group: Interrupt mask and status registers
 */

#if USE_GROUP__Interrupt_mask_and_status_registers

#define R_IRQ_READ2__ADDR      (REG_TYPECAST_UDWORD  0xb00000d4)
#define R_IRQ_READ2__SVAL      REG_SVAL_SHADOW
#define R_IRQ_READ2__SVAL_I    REG_SVAL_I_SHADOW
#define R_IRQ_READ2__TYPECAST  REG_TYPECAST_UDWORD
#define R_IRQ_READ2__TYPE      (REG_UDWORD)
#define R_IRQ_READ2__GET       REG_GET_RO
#define R_IRQ_READ2__IGET      REG_IGET_RO
#define R_IRQ_READ2__SET       REG_SET_RO
#define R_IRQ_READ2__ISET      REG_ISET_RO
#define R_IRQ_READ2__SET_VAL   REG_SET_VAL_RO
#define R_IRQ_READ2__EQL       REG_EQL_RO
#define R_IRQ_READ2__IEQL      REG_IEQL_RO
#define R_IRQ_READ2__RD        REG_RD_RO
#define R_IRQ_READ2__IRD       REG_IRD_RO
#define R_IRQ_READ2__WR        REG_WR_RO
#define R_IRQ_READ2__IWR       REG_IWR_RO

#define R_IRQ_READ2__READ(addr) \
  (*(addr))

#define R_IRQ_READ2__dma8_sub3_descr__dma8_sub3_descr__MASK 0x00800000U
#define R_IRQ_READ2__dma8_sub2_descr__dma8_sub2_descr__MASK 0x00400000U
#define R_IRQ_READ2__dma8_sub1_descr__dma8_sub1_descr__MASK 0x00200000U
#define R_IRQ_READ2__dma8_sub0_descr__dma8_sub0_descr__MASK 0x00100000U
#define R_IRQ_READ2__dma9_eop__dma9_eop__MASK 0x00080000U
#define R_IRQ_READ2__dma9_descr__dma9_descr__MASK 0x00040000U
#define R_IRQ_READ2__dma8_eop__dma8_eop__MASK 0x00020000U
#define R_IRQ_READ2__dma8_descr__dma8_descr__MASK 0x00010000U
#define R_IRQ_READ2__dma7_eop__dma7_eop__MASK 0x00008000U
#define R_IRQ_READ2__dma7_descr__dma7_descr__MASK 0x00004000U
#define R_IRQ_READ2__dma6_eop__dma6_eop__MASK 0x00002000U
#define R_IRQ_READ2__dma6_descr__dma6_descr__MASK 0x00001000U
#define R_IRQ_READ2__dma5_eop__dma5_eop__MASK 0x00000800U
#define R_IRQ_READ2__dma5_descr__dma5_descr__MASK 0x00000400U
#define R_IRQ_READ2__dma4_eop__dma4_eop__MASK 0x00000200U
#define R_IRQ_READ2__dma4_descr__dma4_descr__MASK 0x00000100U
#define R_IRQ_READ2__dma3_eop__dma3_eop__MASK 0x00000080U
#define R_IRQ_READ2__dma3_descr__dma3_descr__MASK 0x00000040U
#define R_IRQ_READ2__dma2_eop__dma2_eop__MASK 0x00000020U
#define R_IRQ_READ2__dma2_descr__dma2_descr__MASK 0x00000010U
#define R_IRQ_READ2__dma1_eop__dma1_eop__MASK 0x00000008U
#define R_IRQ_READ2__dma1_descr__dma1_descr__MASK 0x00000004U
#define R_IRQ_READ2__dma0_eop__dma0_eop__MASK 0x00000002U
#define R_IRQ_READ2__dma0_descr__dma0_descr__MASK 0x00000001U

#define R_IRQ_READ2__dma8_sub3_descr__MAX 0x1
#define R_IRQ_READ2__dma8_sub2_descr__MAX 0x1
#define R_IRQ_READ2__dma8_sub1_descr__MAX 0x1
#define R_IRQ_READ2__dma8_sub0_descr__MAX 0x1
#define R_IRQ_READ2__dma9_eop__MAX 0x1
#define R_IRQ_READ2__dma9_descr__MAX 0x1
#define R_IRQ_READ2__dma8_eop__MAX 0x1
#define R_IRQ_READ2__dma8_descr__MAX 0x1
#define R_IRQ_READ2__dma7_eop__MAX 0x1
#define R_IRQ_READ2__dma7_descr__MAX 0x1
#define R_IRQ_READ2__dma6_eop__MAX 0x1
#define R_IRQ_READ2__dma6_descr__MAX 0x1
#define R_IRQ_READ2__dma5_eop__MAX 0x1
#define R_IRQ_READ2__dma5_descr__MAX 0x1
#define R_IRQ_READ2__dma4_eop__MAX 0x1
#define R_IRQ_READ2__dma4_descr__MAX 0x1
#define R_IRQ_READ2__dma3_eop__MAX 0x1
#define R_IRQ_READ2__dma3_descr__MAX 0x1
#define R_IRQ_READ2__dma2_eop__MAX 0x1
#define R_IRQ_READ2__dma2_descr__MAX 0x1
#define R_IRQ_READ2__dma1_eop__MAX 0x1
#define R_IRQ_READ2__dma1_descr__MAX 0x1
#define R_IRQ_READ2__dma0_eop__MAX 0x1
#define R_IRQ_READ2__dma0_descr__MAX 0x1

#define R_IRQ_READ2__dma8_sub3_descr__MIN 0
#define R_IRQ_READ2__dma8_sub2_descr__MIN 0
#define R_IRQ_READ2__dma8_sub1_descr__MIN 0
#define R_IRQ_READ2__dma8_sub0_descr__MIN 0
#define R_IRQ_READ2__dma9_eop__MIN 0
#define R_IRQ_READ2__dma9_descr__MIN 0
#define R_IRQ_READ2__dma8_eop__MIN 0
#define R_IRQ_READ2__dma8_descr__MIN 0
#define R_IRQ_READ2__dma7_eop__MIN 0
#define R_IRQ_READ2__dma7_descr__MIN 0
#define R_IRQ_READ2__dma6_eop__MIN 0
#define R_IRQ_READ2__dma6_descr__MIN 0
#define R_IRQ_READ2__dma5_eop__MIN 0
#define R_IRQ_READ2__dma5_descr__MIN 0
#define R_IRQ_READ2__dma4_eop__MIN 0
#define R_IRQ_READ2__dma4_descr__MIN 0
#define R_IRQ_READ2__dma3_eop__MIN 0
#define R_IRQ_READ2__dma3_descr__MIN 0
#define R_IRQ_READ2__dma2_eop__MIN 0
#define R_IRQ_READ2__dma2_descr__MIN 0
#define R_IRQ_READ2__dma1_eop__MIN 0
#define R_IRQ_READ2__dma1_descr__MIN 0
#define R_IRQ_READ2__dma0_eop__MIN 0
#define R_IRQ_READ2__dma0_descr__MIN 0

#define R_IRQ_READ2__dma8_sub3_descr__BITNR 23
#define R_IRQ_READ2__dma8_sub2_descr__BITNR 22
#define R_IRQ_READ2__dma8_sub1_descr__BITNR 21
#define R_IRQ_READ2__dma8_sub0_descr__BITNR 20
#define R_IRQ_READ2__dma9_eop__BITNR 19
#define R_IRQ_READ2__dma9_descr__BITNR 18
#define R_IRQ_READ2__dma8_eop__BITNR 17
#define R_IRQ_READ2__dma8_descr__BITNR 16
#define R_IRQ_READ2__dma7_eop__BITNR 15
#define R_IRQ_READ2__dma7_descr__BITNR 14
#define R_IRQ_READ2__dma6_eop__BITNR 13
#define R_IRQ_READ2__dma6_descr__BITNR 12
#define R_IRQ_READ2__dma5_eop__BITNR 11
#define R_IRQ_READ2__dma5_descr__BITNR 10
#define R_IRQ_READ2__dma4_eop__BITNR 9
#define R_IRQ_READ2__dma4_descr__BITNR 8
#define R_IRQ_READ2__dma3_eop__BITNR 7
#define R_IRQ_READ2__dma3_descr__BITNR 6
#define R_IRQ_READ2__dma2_eop__BITNR 5
#define R_IRQ_READ2__dma2_descr__BITNR 4
#define R_IRQ_READ2__dma1_eop__BITNR 3
#define R_IRQ_READ2__dma1_descr__BITNR 2
#define R_IRQ_READ2__dma0_eop__BITNR 1
#define R_IRQ_READ2__dma0_descr__BITNR 0

#define R_IRQ_READ2__dma8_sub3_descr__dma8_sub3_descr__VAL REG_VAL_ENUM
#define R_IRQ_READ2__dma8_sub2_descr__dma8_sub2_descr__VAL REG_VAL_ENUM
#define R_IRQ_READ2__dma8_sub1_descr__dma8_sub1_descr__VAL REG_VAL_ENUM
#define R_IRQ_READ2__dma8_sub0_descr__dma8_sub0_descr__VAL REG_VAL_ENUM
#define R_IRQ_READ2__dma9_eop__dma9_eop__VAL REG_VAL_ENUM
#define R_IRQ_READ2__dma9_descr__dma9_descr__VAL REG_VAL_ENUM
#define R_IRQ_READ2__dma8_eop__dma8_eop__VAL REG_VAL_ENUM
#define R_IRQ_READ2__dma8_descr__dma8_descr__VAL REG_VAL_ENUM
#define R_IRQ_READ2__dma7_eop__dma7_eop__VAL REG_VAL_ENUM
#define R_IRQ_READ2__dma7_descr__dma7_descr__VAL REG_VAL_ENUM
#define R_IRQ_READ2__dma6_eop__dma6_eop__VAL REG_VAL_ENUM
#define R_IRQ_READ2__dma6_descr__dma6_descr__VAL REG_VAL_ENUM
#define R_IRQ_READ2__dma5_eop__dma5_eop__VAL REG_VAL_ENUM
#define R_IRQ_READ2__dma5_descr__dma5_descr__VAL REG_VAL_ENUM
#define R_IRQ_READ2__dma4_eop__dma4_eop__VAL REG_VAL_ENUM
#define R_IRQ_READ2__dma4_descr__dma4_descr__VAL REG_VAL_ENUM
#define R_IRQ_READ2__dma3_eop__dma3_eop__VAL REG_VAL_ENUM
#define R_IRQ_READ2__dma3_descr__dma3_descr__VAL REG_VAL_ENUM
#define R_IRQ_READ2__dma2_eop__dma2_eop__VAL REG_VAL_ENUM
#define R_IRQ_READ2__dma2_descr__dma2_descr__VAL REG_VAL_ENUM
#define R_IRQ_READ2__dma1_eop__dma1_eop__VAL REG_VAL_ENUM
#define R_IRQ_READ2__dma1_descr__dma1_descr__VAL REG_VAL_ENUM
#define R_IRQ_READ2__dma0_eop__dma0_eop__VAL REG_VAL_ENUM
#define R_IRQ_READ2__dma0_descr__dma0_descr__VAL REG_VAL_ENUM

#define R_IRQ_READ2__dma8_sub3_descr__dma8_sub3_descr__active 1
#define R_IRQ_READ2__dma8_sub3_descr__dma8_sub3_descr__inactive 0
#define R_IRQ_READ2__dma8_sub2_descr__dma8_sub2_descr__active 1
#define R_IRQ_READ2__dma8_sub2_descr__dma8_sub2_descr__inactive 0
#define R_IRQ_READ2__dma8_sub1_descr__dma8_sub1_descr__active 1
#define R_IRQ_READ2__dma8_sub1_descr__dma8_sub1_descr__inactive 0
#define R_IRQ_READ2__dma8_sub0_descr__dma8_sub0_descr__active 1
#define R_IRQ_READ2__dma8_sub0_descr__dma8_sub0_descr__inactive 0
#define R_IRQ_READ2__dma9_eop__dma9_eop__active 1
#define R_IRQ_READ2__dma9_eop__dma9_eop__inactive 0
#define R_IRQ_READ2__dma9_descr__dma9_descr__active 1
#define R_IRQ_READ2__dma9_descr__dma9_descr__inactive 0
#define R_IRQ_READ2__dma8_eop__dma8_eop__active 1
#define R_IRQ_READ2__dma8_eop__dma8_eop__inactive 0
#define R_IRQ_READ2__dma8_descr__dma8_descr__active 1
#define R_IRQ_READ2__dma8_descr__dma8_descr__inactive 0
#define R_IRQ_READ2__dma7_eop__dma7_eop__active 1
#define R_IRQ_READ2__dma7_eop__dma7_eop__inactive 0
#define R_IRQ_READ2__dma7_descr__dma7_descr__active 1
#define R_IRQ_READ2__dma7_descr__dma7_descr__inactive 0
#define R_IRQ_READ2__dma6_eop__dma6_eop__active 1
#define R_IRQ_READ2__dma6_eop__dma6_eop__inactive 0
#define R_IRQ_READ2__dma6_descr__dma6_descr__active 1
#define R_IRQ_READ2__dma6_descr__dma6_descr__inactive 0
#define R_IRQ_READ2__dma5_eop__dma5_eop__active 1
#define R_IRQ_READ2__dma5_eop__dma5_eop__inactive 0
#define R_IRQ_READ2__dma5_descr__dma5_descr__active 1
#define R_IRQ_READ2__dma5_descr__dma5_descr__inactive 0
#define R_IRQ_READ2__dma4_eop__dma4_eop__active 1
#define R_IRQ_READ2__dma4_eop__dma4_eop__inactive 0
#define R_IRQ_READ2__dma4_descr__dma4_descr__active 1
#define R_IRQ_READ2__dma4_descr__dma4_descr__inactive 0
#define R_IRQ_READ2__dma3_eop__dma3_eop__active 1
#define R_IRQ_READ2__dma3_eop__dma3_eop__inactive 0
#define R_IRQ_READ2__dma3_descr__dma3_descr__active 1
#define R_IRQ_READ2__dma3_descr__dma3_descr__inactive 0
#define R_IRQ_READ2__dma2_eop__dma2_eop__active 1
#define R_IRQ_READ2__dma2_eop__dma2_eop__inactive 0
#define R_IRQ_READ2__dma2_descr__dma2_descr__active 1
#define R_IRQ_READ2__dma2_descr__dma2_descr__inactive 0
#define R_IRQ_READ2__dma1_eop__dma1_eop__active 1
#define R_IRQ_READ2__dma1_eop__dma1_eop__inactive 0
#define R_IRQ_READ2__dma1_descr__dma1_descr__active 1
#define R_IRQ_READ2__dma1_descr__dma1_descr__inactive 0
#define R_IRQ_READ2__dma0_eop__dma0_eop__active 1
#define R_IRQ_READ2__dma0_eop__dma0_eop__inactive 0
#define R_IRQ_READ2__dma0_descr__dma0_descr__active 1
#define R_IRQ_READ2__dma0_descr__dma0_descr__inactive 0

#endif

/*
 *  R_MMU_CAUSE
 *  - type:  RO
 *  - addr:  0xb0000250
 *  - group: MMU registers
 */

#if USE_GROUP__MMU_registers

#define R_MMU_CAUSE__ADDR      (REG_TYPECAST_UDWORD  0xb0000250)
#define R_MMU_CAUSE__SVAL      REG_SVAL_SHADOW
#define R_MMU_CAUSE__SVAL_I    REG_SVAL_I_SHADOW
#define R_MMU_CAUSE__TYPECAST  REG_TYPECAST_UDWORD
#define R_MMU_CAUSE__TYPE      (REG_UDWORD)
#define R_MMU_CAUSE__GET       REG_GET_RO
#define R_MMU_CAUSE__IGET      REG_IGET_RO
#define R_MMU_CAUSE__SET       REG_SET_RO
#define R_MMU_CAUSE__ISET      REG_ISET_RO
#define R_MMU_CAUSE__SET_VAL   REG_SET_VAL_RO
#define R_MMU_CAUSE__EQL       REG_EQL_RO
#define R_MMU_CAUSE__IEQL      REG_IEQL_RO
#define R_MMU_CAUSE__RD        REG_RD_RO
#define R_MMU_CAUSE__IRD       REG_IRD_RO
#define R_MMU_CAUSE__WR        REG_WR_RO
#define R_MMU_CAUSE__IWR       REG_IWR_RO

#define R_MMU_CAUSE__READ(addr) \
  (*(addr))

#define R_MMU_CAUSE__vpn__vpn__MASK 0xffffe000U
#define R_MMU_CAUSE__miss_excp__miss_excp__MASK 0x00001000U
#define R_MMU_CAUSE__inv_excp__inv_excp__MASK 0x00000800U
#define R_MMU_CAUSE__acc_excp__acc_excp__MASK 0x00000400U
#define R_MMU_CAUSE__we_excp__we_excp__MASK 0x00000200U
#define R_MMU_CAUSE__wr_rd__wr_rd__MASK 0x00000100U
#define R_MMU_CAUSE__page_id__page_id__MASK 0x0000003fU

#define R_MMU_CAUSE__vpn__MAX 0x7ffff
#define R_MMU_CAUSE__miss_excp__MAX 0x1
#define R_MMU_CAUSE__inv_excp__MAX 0x1
#define R_MMU_CAUSE__acc_excp__MAX 0x1
#define R_MMU_CAUSE__we_excp__MAX 0x1
#define R_MMU_CAUSE__wr_rd__MAX 0x1
#define R_MMU_CAUSE__page_id__MAX 63

#define R_MMU_CAUSE__vpn__MIN 0
#define R_MMU_CAUSE__miss_excp__MIN 0
#define R_MMU_CAUSE__inv_excp__MIN 0
#define R_MMU_CAUSE__acc_excp__MIN 0
#define R_MMU_CAUSE__we_excp__MIN 0
#define R_MMU_CAUSE__wr_rd__MIN 0
#define R_MMU_CAUSE__page_id__MIN 0

#define R_MMU_CAUSE__vpn__BITNR 13
#define R_MMU_CAUSE__miss_excp__BITNR 12
#define R_MMU_CAUSE__inv_excp__BITNR 11
#define R_MMU_CAUSE__acc_excp__BITNR 10
#define R_MMU_CAUSE__we_excp__BITNR 9
#define R_MMU_CAUSE__wr_rd__BITNR 8
#define R_MMU_CAUSE__page_id__BITNR 0

#define R_MMU_CAUSE__vpn__vpn__VAL REG_VAL_VAL
#define R_MMU_CAUSE__miss_excp__miss_excp__VAL REG_VAL_ENUM
#define R_MMU_CAUSE__inv_excp__inv_excp__VAL REG_VAL_ENUM
#define R_MMU_CAUSE__acc_excp__acc_excp__VAL REG_VAL_ENUM
#define R_MMU_CAUSE__we_excp__we_excp__VAL REG_VAL_ENUM
#define R_MMU_CAUSE__wr_rd__wr_rd__VAL REG_VAL_ENUM
#define R_MMU_CAUSE__page_id__page_id__VAL REG_VAL_VAL

#define R_MMU_CAUSE__miss_excp__miss_excp__no 0
#define R_MMU_CAUSE__miss_excp__miss_excp__yes 1
#define R_MMU_CAUSE__inv_excp__inv_excp__no 0
#define R_MMU_CAUSE__inv_excp__inv_excp__yes 1
#define R_MMU_CAUSE__acc_excp__acc_excp__no 0
#define R_MMU_CAUSE__acc_excp__acc_excp__yes 1
#define R_MMU_CAUSE__we_excp__we_excp__no 0
#define R_MMU_CAUSE__we_excp__we_excp__yes 1
#define R_MMU_CAUSE__wr_rd__wr_rd__read 0
#define R_MMU_CAUSE__wr_rd__wr_rd__write 1

#endif

/*
 *  R_MMU_CONFIG
 *  - type:  WO
 *  - addr:  0xb0000240
 *  - group: MMU registers
 */

#if USE_GROUP__MMU_registers

#define R_MMU_CONFIG__ADDR      (REG_TYPECAST_UDWORD  0xb0000240)

#ifndef REG_NO_SHADOW
#define R_MMU_CONFIG__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_MMU_CONFIG + 2))
#define R_MMU_CONFIG__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_MMU_CONFIG + 2))
#else /* REG_NO_SHADOW */
#define R_MMU_CONFIG__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_MMU_CONFIG__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_MMU_CONFIG__STYPECAST REG_STYPECAST_UDWORD
#define R_MMU_CONFIG__SVAL      REG_SVAL_SHADOW
#define R_MMU_CONFIG__SVAL_I    REG_SVAL_I_SHADOW
#define R_MMU_CONFIG__TYPECAST  REG_TYPECAST_UDWORD
#define R_MMU_CONFIG__TYPE      (REG_UDWORD)
#define R_MMU_CONFIG__GET       REG_GET_WO
#define R_MMU_CONFIG__IGET      REG_IGET_WO
#define R_MMU_CONFIG__SET       REG_SET_WO
#define R_MMU_CONFIG__ISET      REG_ISET_WO
#define R_MMU_CONFIG__SET_VAL   REG_SET_VAL_WO
#define R_MMU_CONFIG__EQL       REG_EQL_WO
#define R_MMU_CONFIG__IEQL      REG_IEQL_WO
#define R_MMU_CONFIG__RD        REG_RD_WO
#define R_MMU_CONFIG__IRD       REG_IRD_WO
#define R_MMU_CONFIG__WR        REG_WR_WO
#define R_MMU_CONFIG__IWR       REG_IWR_WO

#define R_MMU_CONFIG__WRITE(addr,value) \
  (*(addr) = (value))

#define R_MMU_CONFIG__mmu_enable__mmu_enable__MASK 0x80000000U
#define R_MMU_CONFIG__inv_excp__inv_excp__MASK 0x00040000U
#define R_MMU_CONFIG__acc_excp__acc_excp__MASK 0x00020000U
#define R_MMU_CONFIG__we_excp__we_excp__MASK 0x00010000U
#define R_MMU_CONFIG__seg_f__seg_f__MASK 0x00008000U
#define R_MMU_CONFIG__seg_e__seg_e__MASK 0x00004000U
#define R_MMU_CONFIG__seg_d__seg_d__MASK 0x00002000U
#define R_MMU_CONFIG__seg_c__seg_c__MASK 0x00001000U
#define R_MMU_CONFIG__seg_b__seg_b__MASK 0x00000800U
#define R_MMU_CONFIG__seg_a__seg_a__MASK 0x00000400U
#define R_MMU_CONFIG__seg_9__seg_9__MASK 0x00000200U
#define R_MMU_CONFIG__seg_8__seg_8__MASK 0x00000100U
#define R_MMU_CONFIG__seg_7__seg_7__MASK 0x00000080U
#define R_MMU_CONFIG__seg_6__seg_6__MASK 0x00000040U
#define R_MMU_CONFIG__seg_5__seg_5__MASK 0x00000020U
#define R_MMU_CONFIG__seg_4__seg_4__MASK 0x00000010U
#define R_MMU_CONFIG__seg_3__seg_3__MASK 0x00000008U
#define R_MMU_CONFIG__seg_2__seg_2__MASK 0x00000004U
#define R_MMU_CONFIG__seg_1__seg_1__MASK 0x00000002U
#define R_MMU_CONFIG__seg_0__seg_0__MASK 0x00000001U

#define R_MMU_CONFIG__mmu_enable__MAX 0x1
#define R_MMU_CONFIG__inv_excp__MAX 0x1
#define R_MMU_CONFIG__acc_excp__MAX 0x1
#define R_MMU_CONFIG__we_excp__MAX 0x1
#define R_MMU_CONFIG__seg_f__MAX 0x1
#define R_MMU_CONFIG__seg_e__MAX 0x1
#define R_MMU_CONFIG__seg_d__MAX 0x1
#define R_MMU_CONFIG__seg_c__MAX 0x1
#define R_MMU_CONFIG__seg_b__MAX 0x1
#define R_MMU_CONFIG__seg_a__MAX 0x1
#define R_MMU_CONFIG__seg_9__MAX 0x1
#define R_MMU_CONFIG__seg_8__MAX 0x1
#define R_MMU_CONFIG__seg_7__MAX 0x1
#define R_MMU_CONFIG__seg_6__MAX 0x1
#define R_MMU_CONFIG__seg_5__MAX 0x1
#define R_MMU_CONFIG__seg_4__MAX 0x1
#define R_MMU_CONFIG__seg_3__MAX 0x1
#define R_MMU_CONFIG__seg_2__MAX 0x1
#define R_MMU_CONFIG__seg_1__MAX 0x1
#define R_MMU_CONFIG__seg_0__MAX 0x1

#define R_MMU_CONFIG__mmu_enable__MIN 0
#define R_MMU_CONFIG__inv_excp__MIN 0
#define R_MMU_CONFIG__acc_excp__MIN 0
#define R_MMU_CONFIG__we_excp__MIN 0
#define R_MMU_CONFIG__seg_f__MIN 0
#define R_MMU_CONFIG__seg_e__MIN 0
#define R_MMU_CONFIG__seg_d__MIN 0
#define R_MMU_CONFIG__seg_c__MIN 0
#define R_MMU_CONFIG__seg_b__MIN 0
#define R_MMU_CONFIG__seg_a__MIN 0
#define R_MMU_CONFIG__seg_9__MIN 0
#define R_MMU_CONFIG__seg_8__MIN 0
#define R_MMU_CONFIG__seg_7__MIN 0
#define R_MMU_CONFIG__seg_6__MIN 0
#define R_MMU_CONFIG__seg_5__MIN 0
#define R_MMU_CONFIG__seg_4__MIN 0
#define R_MMU_CONFIG__seg_3__MIN 0
#define R_MMU_CONFIG__seg_2__MIN 0
#define R_MMU_CONFIG__seg_1__MIN 0
#define R_MMU_CONFIG__seg_0__MIN 0

#define R_MMU_CONFIG__mmu_enable__BITNR 31
#define R_MMU_CONFIG__inv_excp__BITNR 18
#define R_MMU_CONFIG__acc_excp__BITNR 17
#define R_MMU_CONFIG__we_excp__BITNR 16
#define R_MMU_CONFIG__seg_f__BITNR 15
#define R_MMU_CONFIG__seg_e__BITNR 14
#define R_MMU_CONFIG__seg_d__BITNR 13
#define R_MMU_CONFIG__seg_c__BITNR 12
#define R_MMU_CONFIG__seg_b__BITNR 11
#define R_MMU_CONFIG__seg_a__BITNR 10
#define R_MMU_CONFIG__seg_9__BITNR 9
#define R_MMU_CONFIG__seg_8__BITNR 8
#define R_MMU_CONFIG__seg_7__BITNR 7
#define R_MMU_CONFIG__seg_6__BITNR 6
#define R_MMU_CONFIG__seg_5__BITNR 5
#define R_MMU_CONFIG__seg_4__BITNR 4
#define R_MMU_CONFIG__seg_3__BITNR 3
#define R_MMU_CONFIG__seg_2__BITNR 2
#define R_MMU_CONFIG__seg_1__BITNR 1
#define R_MMU_CONFIG__seg_0__BITNR 0

#define R_MMU_CONFIG__mmu_enable__mmu_enable__VAL REG_VAL_ENUM
#define R_MMU_CONFIG__inv_excp__inv_excp__VAL REG_VAL_ENUM
#define R_MMU_CONFIG__acc_excp__acc_excp__VAL REG_VAL_ENUM
#define R_MMU_CONFIG__we_excp__we_excp__VAL REG_VAL_ENUM
#define R_MMU_CONFIG__seg_f__seg_f__VAL REG_VAL_ENUM
#define R_MMU_CONFIG__seg_e__seg_e__VAL REG_VAL_ENUM
#define R_MMU_CONFIG__seg_d__seg_d__VAL REG_VAL_ENUM
#define R_MMU_CONFIG__seg_c__seg_c__VAL REG_VAL_ENUM
#define R_MMU_CONFIG__seg_b__seg_b__VAL REG_VAL_ENUM
#define R_MMU_CONFIG__seg_a__seg_a__VAL REG_VAL_ENUM
#define R_MMU_CONFIG__seg_9__seg_9__VAL REG_VAL_ENUM
#define R_MMU_CONFIG__seg_8__seg_8__VAL REG_VAL_ENUM
#define R_MMU_CONFIG__seg_7__seg_7__VAL REG_VAL_ENUM
#define R_MMU_CONFIG__seg_6__seg_6__VAL REG_VAL_ENUM
#define R_MMU_CONFIG__seg_5__seg_5__VAL REG_VAL_ENUM
#define R_MMU_CONFIG__seg_4__seg_4__VAL REG_VAL_ENUM
#define R_MMU_CONFIG__seg_3__seg_3__VAL REG_VAL_ENUM
#define R_MMU_CONFIG__seg_2__seg_2__VAL REG_VAL_ENUM
#define R_MMU_CONFIG__seg_1__seg_1__VAL REG_VAL_ENUM
#define R_MMU_CONFIG__seg_0__seg_0__VAL REG_VAL_ENUM

#define R_MMU_CONFIG__mmu_enable__mmu_enable__disable 0
#define R_MMU_CONFIG__mmu_enable__mmu_enable__enable 1
#define R_MMU_CONFIG__inv_excp__inv_excp__disable 0
#define R_MMU_CONFIG__inv_excp__inv_excp__enable 1
#define R_MMU_CONFIG__acc_excp__acc_excp__disable 0
#define R_MMU_CONFIG__acc_excp__acc_excp__enable 1
#define R_MMU_CONFIG__we_excp__we_excp__disable 0
#define R_MMU_CONFIG__we_excp__we_excp__enable 1
#define R_MMU_CONFIG__seg_f__seg_f__page 0
#define R_MMU_CONFIG__seg_f__seg_f__seg 1
#define R_MMU_CONFIG__seg_e__seg_e__page 0
#define R_MMU_CONFIG__seg_e__seg_e__seg 1
#define R_MMU_CONFIG__seg_d__seg_d__page 0
#define R_MMU_CONFIG__seg_d__seg_d__seg 1
#define R_MMU_CONFIG__seg_c__seg_c__page 0
#define R_MMU_CONFIG__seg_c__seg_c__seg 1
#define R_MMU_CONFIG__seg_b__seg_b__page 0
#define R_MMU_CONFIG__seg_b__seg_b__seg 1
#define R_MMU_CONFIG__seg_a__seg_a__page 0
#define R_MMU_CONFIG__seg_a__seg_a__seg 1
#define R_MMU_CONFIG__seg_9__seg_9__page 0
#define R_MMU_CONFIG__seg_9__seg_9__seg 1
#define R_MMU_CONFIG__seg_8__seg_8__page 0
#define R_MMU_CONFIG__seg_8__seg_8__seg 1
#define R_MMU_CONFIG__seg_7__seg_7__page 0
#define R_MMU_CONFIG__seg_7__seg_7__seg 1
#define R_MMU_CONFIG__seg_6__seg_6__page 0
#define R_MMU_CONFIG__seg_6__seg_6__seg 1
#define R_MMU_CONFIG__seg_5__seg_5__page 0
#define R_MMU_CONFIG__seg_5__seg_5__seg 1
#define R_MMU_CONFIG__seg_4__seg_4__page 0
#define R_MMU_CONFIG__seg_4__seg_4__seg 1
#define R_MMU_CONFIG__seg_3__seg_3__page 0
#define R_MMU_CONFIG__seg_3__seg_3__seg 1
#define R_MMU_CONFIG__seg_2__seg_2__page 0
#define R_MMU_CONFIG__seg_2__seg_2__seg 1
#define R_MMU_CONFIG__seg_1__seg_1__page 0
#define R_MMU_CONFIG__seg_1__seg_1__seg 1
#define R_MMU_CONFIG__seg_0__seg_0__page 0
#define R_MMU_CONFIG__seg_0__seg_0__seg 1

#endif

/*
 *  R_MMU_CONTEXT
 *  - type:  RW
 *  - addr:  0xb000024c
 *  - group: MMU registers
 */

#if USE_GROUP__MMU_registers

#define R_MMU_CONTEXT__ADDR      (REG_TYPECAST_BYTE  0xb000024c)
#define R_MMU_CONTEXT__SVAL      REG_SVAL_SHADOW
#define R_MMU_CONTEXT__SVAL_I    REG_SVAL_I_SHADOW
#define R_MMU_CONTEXT__TYPECAST  REG_TYPECAST_BYTE
#define R_MMU_CONTEXT__TYPE      (REG_BYTE)
#define R_MMU_CONTEXT__GET       REG_GET_RW
#define R_MMU_CONTEXT__IGET      REG_IGET_RW
#define R_MMU_CONTEXT__SET       REG_SET_RW
#define R_MMU_CONTEXT__ISET      REG_ISET_RW
#define R_MMU_CONTEXT__SET_VAL   REG_SET_VAL_RW
#define R_MMU_CONTEXT__EQL       REG_EQL_RW
#define R_MMU_CONTEXT__IEQL      REG_IEQL_RW
#define R_MMU_CONTEXT__RD        REG_RD_RW
#define R_MMU_CONTEXT__IRD       REG_IRD_RW
#define R_MMU_CONTEXT__WR        REG_WR_RW
#define R_MMU_CONTEXT__IWR       REG_IWR_RW

#define R_MMU_CONTEXT__WRITE(addr,value) \
  (*(addr) = (value))
#define R_MMU_CONTEXT__READ(addr) \
  (*(addr))

#define R_MMU_CONTEXT__page_id__page_id__MASK 0x0000003fU

#define R_MMU_CONTEXT__page_id__MAX 63

#define R_MMU_CONTEXT__page_id__MIN 0

#define R_MMU_CONTEXT__page_id__BITNR 0

#define R_MMU_CONTEXT__page_id__page_id__VAL REG_VAL_VAL


#endif

/*
 *  R_MMU_CTRL
 *  - type:  WO
 *  - addr:  0xb0000242
 *  - group: MMU registers
 */

#if USE_GROUP__MMU_registers

#define R_MMU_CTRL__ADDR      (REG_TYPECAST_BYTE  0xb0000242)

#ifndef REG_NO_SHADOW
#define R_MMU_CTRL__SADDR     (REG_STYPECAST_BYTE (reg_shadow__hwregs.R_MMU_CONFIG + 0))
#define R_MMU_CTRL__IADDR     (REG_STYPECAST_BYTE (reg_initiated__hwregs.R_MMU_CONFIG + 0))
#else /* REG_NO_SHADOW */
#define R_MMU_CTRL__SADDR     (REG_STYPECAST_BYTE (&reg_shadow__hwregs))
#define R_MMU_CTRL__IADDR     (REG_STYPECAST_BYTE (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_MMU_CTRL__STYPECAST REG_STYPECAST_BYTE
#define R_MMU_CTRL__SVAL      REG_SVAL_SHADOW
#define R_MMU_CTRL__SVAL_I    REG_SVAL_I_SHADOW
#define R_MMU_CTRL__TYPECAST  REG_TYPECAST_BYTE
#define R_MMU_CTRL__TYPE      (REG_BYTE)
#define R_MMU_CTRL__GET       REG_GET_WO
#define R_MMU_CTRL__IGET      REG_IGET_WO
#define R_MMU_CTRL__SET       REG_SET_WO
#define R_MMU_CTRL__ISET      REG_ISET_WO
#define R_MMU_CTRL__SET_VAL   REG_SET_VAL_WO
#define R_MMU_CTRL__EQL       REG_EQL_WO
#define R_MMU_CTRL__IEQL      REG_IEQL_WO
#define R_MMU_CTRL__RD        REG_RD_WO
#define R_MMU_CTRL__IRD       REG_IRD_WO
#define R_MMU_CTRL__WR        REG_WR_WO
#define R_MMU_CTRL__IWR       REG_IWR_WO

#define R_MMU_CTRL__WRITE(addr,value) \
  (*(addr) = (value))

#define R_MMU_CTRL__inv_excp__inv_excp__MASK 0x00000004U
#define R_MMU_CTRL__acc_excp__acc_excp__MASK 0x00000002U
#define R_MMU_CTRL__we_excp__we_excp__MASK 0x00000001U

#define R_MMU_CTRL__inv_excp__MAX 0x1
#define R_MMU_CTRL__acc_excp__MAX 0x1
#define R_MMU_CTRL__we_excp__MAX 0x1

#define R_MMU_CTRL__inv_excp__MIN 0
#define R_MMU_CTRL__acc_excp__MIN 0
#define R_MMU_CTRL__we_excp__MIN 0

#define R_MMU_CTRL__inv_excp__BITNR 2
#define R_MMU_CTRL__acc_excp__BITNR 1
#define R_MMU_CTRL__we_excp__BITNR 0

#define R_MMU_CTRL__inv_excp__inv_excp__VAL REG_VAL_ENUM
#define R_MMU_CTRL__acc_excp__acc_excp__VAL REG_VAL_ENUM
#define R_MMU_CTRL__we_excp__we_excp__VAL REG_VAL_ENUM

#define R_MMU_CTRL__inv_excp__inv_excp__disable 0
#define R_MMU_CTRL__inv_excp__inv_excp__enable 1
#define R_MMU_CTRL__acc_excp__acc_excp__disable 0
#define R_MMU_CTRL__acc_excp__acc_excp__enable 1
#define R_MMU_CTRL__we_excp__we_excp__disable 0
#define R_MMU_CTRL__we_excp__we_excp__enable 1

#endif

/*
 *  R_MMU_ENABLE
 *  - type:  WO
 *  - addr:  0xb0000243
 *  - group: MMU registers
 */

#if USE_GROUP__MMU_registers

#define R_MMU_ENABLE__ADDR      (REG_TYPECAST_BYTE  0xb0000243)

#ifndef REG_NO_SHADOW
#define R_MMU_ENABLE__SADDR     (REG_STYPECAST_BYTE (reg_shadow__hwregs.R_MMU_CONFIG + 1))
#define R_MMU_ENABLE__IADDR     (REG_STYPECAST_BYTE (reg_initiated__hwregs.R_MMU_CONFIG + 1))
#else /* REG_NO_SHADOW */
#define R_MMU_ENABLE__SADDR     (REG_STYPECAST_BYTE (&reg_shadow__hwregs))
#define R_MMU_ENABLE__IADDR     (REG_STYPECAST_BYTE (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_MMU_ENABLE__STYPECAST REG_STYPECAST_BYTE
#define R_MMU_ENABLE__SVAL      REG_SVAL_SHADOW
#define R_MMU_ENABLE__SVAL_I    REG_SVAL_I_SHADOW
#define R_MMU_ENABLE__TYPECAST  REG_TYPECAST_BYTE
#define R_MMU_ENABLE__TYPE      (REG_BYTE)
#define R_MMU_ENABLE__GET       REG_GET_WO
#define R_MMU_ENABLE__IGET      REG_IGET_WO
#define R_MMU_ENABLE__SET       REG_SET_WO
#define R_MMU_ENABLE__ISET      REG_ISET_WO
#define R_MMU_ENABLE__SET_VAL   REG_SET_VAL_WO
#define R_MMU_ENABLE__EQL       REG_EQL_WO
#define R_MMU_ENABLE__IEQL      REG_IEQL_WO
#define R_MMU_ENABLE__RD        REG_RD_WO
#define R_MMU_ENABLE__IRD       REG_IRD_WO
#define R_MMU_ENABLE__WR        REG_WR_WO
#define R_MMU_ENABLE__IWR       REG_IWR_WO

#define R_MMU_ENABLE__WRITE(addr,value) \
  (*(addr) = (value))

#define R_MMU_ENABLE__mmu_enable__mmu_enable__MASK 0x00000080U

#define R_MMU_ENABLE__mmu_enable__MAX 0x1

#define R_MMU_ENABLE__mmu_enable__MIN 0

#define R_MMU_ENABLE__mmu_enable__BITNR 7

#define R_MMU_ENABLE__mmu_enable__mmu_enable__VAL REG_VAL_ENUM

#define R_MMU_ENABLE__mmu_enable__mmu_enable__disable 0
#define R_MMU_ENABLE__mmu_enable__mmu_enable__enable 1

#endif

/*
 *  R_MMU_KBASE_HI
 *  - type:  WO
 *  - addr:  0xb0000248
 *  - group: MMU registers
 */

#if USE_GROUP__MMU_registers

#define R_MMU_KBASE_HI__ADDR      (REG_TYPECAST_UDWORD  0xb0000248)

#ifndef REG_NO_SHADOW
#define R_MMU_KBASE_HI__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_MMU_KBASE_HI + 2))
#define R_MMU_KBASE_HI__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_MMU_KBASE_HI + 2))
#else /* REG_NO_SHADOW */
#define R_MMU_KBASE_HI__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_MMU_KBASE_HI__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_MMU_KBASE_HI__STYPECAST REG_STYPECAST_UDWORD
#define R_MMU_KBASE_HI__SVAL      REG_SVAL_SHADOW
#define R_MMU_KBASE_HI__SVAL_I    REG_SVAL_I_SHADOW
#define R_MMU_KBASE_HI__TYPECAST  REG_TYPECAST_UDWORD
#define R_MMU_KBASE_HI__TYPE      (REG_UDWORD)
#define R_MMU_KBASE_HI__GET       REG_GET_WO
#define R_MMU_KBASE_HI__IGET      REG_IGET_WO
#define R_MMU_KBASE_HI__SET       REG_SET_WO
#define R_MMU_KBASE_HI__ISET      REG_ISET_WO
#define R_MMU_KBASE_HI__SET_VAL   REG_SET_VAL_WO
#define R_MMU_KBASE_HI__EQL       REG_EQL_WO
#define R_MMU_KBASE_HI__IEQL      REG_IEQL_WO
#define R_MMU_KBASE_HI__RD        REG_RD_WO
#define R_MMU_KBASE_HI__IRD       REG_IRD_WO
#define R_MMU_KBASE_HI__WR        REG_WR_WO
#define R_MMU_KBASE_HI__IWR       REG_IWR_WO

#define R_MMU_KBASE_HI__WRITE(addr,value) \
  (*(addr) = (value))

#define R_MMU_KBASE_HI__base_f__base_f__MASK 0xf0000000U
#define R_MMU_KBASE_HI__base_e__base_e__MASK 0x0f000000U
#define R_MMU_KBASE_HI__base_d__base_d__MASK 0x00f00000U
#define R_MMU_KBASE_HI__base_c__base_c__MASK 0x000f0000U
#define R_MMU_KBASE_HI__base_b__base_b__MASK 0x0000f000U
#define R_MMU_KBASE_HI__base_a__base_a__MASK 0x00000f00U
#define R_MMU_KBASE_HI__base_9__base_9__MASK 0x000000f0U
#define R_MMU_KBASE_HI__base_8__base_8__MASK 0x0000000fU

#define R_MMU_KBASE_HI__base_f__MAX 15
#define R_MMU_KBASE_HI__base_e__MAX 15
#define R_MMU_KBASE_HI__base_d__MAX 15
#define R_MMU_KBASE_HI__base_c__MAX 15
#define R_MMU_KBASE_HI__base_b__MAX 15
#define R_MMU_KBASE_HI__base_a__MAX 15
#define R_MMU_KBASE_HI__base_9__MAX 15
#define R_MMU_KBASE_HI__base_8__MAX 15

#define R_MMU_KBASE_HI__base_f__MIN 0
#define R_MMU_KBASE_HI__base_e__MIN 0
#define R_MMU_KBASE_HI__base_d__MIN 0
#define R_MMU_KBASE_HI__base_c__MIN 0
#define R_MMU_KBASE_HI__base_b__MIN 0
#define R_MMU_KBASE_HI__base_a__MIN 0
#define R_MMU_KBASE_HI__base_9__MIN 0
#define R_MMU_KBASE_HI__base_8__MIN 0

#define R_MMU_KBASE_HI__base_f__BITNR 28
#define R_MMU_KBASE_HI__base_e__BITNR 24
#define R_MMU_KBASE_HI__base_d__BITNR 20
#define R_MMU_KBASE_HI__base_c__BITNR 16
#define R_MMU_KBASE_HI__base_b__BITNR 12
#define R_MMU_KBASE_HI__base_a__BITNR 8
#define R_MMU_KBASE_HI__base_9__BITNR 4
#define R_MMU_KBASE_HI__base_8__BITNR 0

#define R_MMU_KBASE_HI__base_f__base_f__VAL REG_VAL_VAL
#define R_MMU_KBASE_HI__base_e__base_e__VAL REG_VAL_VAL
#define R_MMU_KBASE_HI__base_d__base_d__VAL REG_VAL_VAL
#define R_MMU_KBASE_HI__base_c__base_c__VAL REG_VAL_VAL
#define R_MMU_KBASE_HI__base_b__base_b__VAL REG_VAL_VAL
#define R_MMU_KBASE_HI__base_a__base_a__VAL REG_VAL_VAL
#define R_MMU_KBASE_HI__base_9__base_9__VAL REG_VAL_VAL
#define R_MMU_KBASE_HI__base_8__base_8__VAL REG_VAL_VAL


#endif

/*
 *  R_MMU_KBASE_LO
 *  - type:  WO
 *  - addr:  0xb0000244
 *  - group: MMU registers
 */

#if USE_GROUP__MMU_registers

#define R_MMU_KBASE_LO__ADDR      (REG_TYPECAST_UDWORD  0xb0000244)

#ifndef REG_NO_SHADOW
#define R_MMU_KBASE_LO__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_MMU_KBASE_LO + 2))
#define R_MMU_KBASE_LO__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_MMU_KBASE_LO + 2))
#else /* REG_NO_SHADOW */
#define R_MMU_KBASE_LO__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_MMU_KBASE_LO__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_MMU_KBASE_LO__STYPECAST REG_STYPECAST_UDWORD
#define R_MMU_KBASE_LO__SVAL      REG_SVAL_SHADOW
#define R_MMU_KBASE_LO__SVAL_I    REG_SVAL_I_SHADOW
#define R_MMU_KBASE_LO__TYPECAST  REG_TYPECAST_UDWORD
#define R_MMU_KBASE_LO__TYPE      (REG_UDWORD)
#define R_MMU_KBASE_LO__GET       REG_GET_WO
#define R_MMU_KBASE_LO__IGET      REG_IGET_WO
#define R_MMU_KBASE_LO__SET       REG_SET_WO
#define R_MMU_KBASE_LO__ISET      REG_ISET_WO
#define R_MMU_KBASE_LO__SET_VAL   REG_SET_VAL_WO
#define R_MMU_KBASE_LO__EQL       REG_EQL_WO
#define R_MMU_KBASE_LO__IEQL      REG_IEQL_WO
#define R_MMU_KBASE_LO__RD        REG_RD_WO
#define R_MMU_KBASE_LO__IRD       REG_IRD_WO
#define R_MMU_KBASE_LO__WR        REG_WR_WO
#define R_MMU_KBASE_LO__IWR       REG_IWR_WO

#define R_MMU_KBASE_LO__WRITE(addr,value) \
  (*(addr) = (value))

#define R_MMU_KBASE_LO__base_7__base_7__MASK 0xf0000000U
#define R_MMU_KBASE_LO__base_6__base_6__MASK 0x0f000000U
#define R_MMU_KBASE_LO__base_5__base_5__MASK 0x00f00000U
#define R_MMU_KBASE_LO__base_4__base_4__MASK 0x000f0000U
#define R_MMU_KBASE_LO__base_3__base_3__MASK 0x0000f000U
#define R_MMU_KBASE_LO__base_2__base_2__MASK 0x00000f00U
#define R_MMU_KBASE_LO__base_1__base_1__MASK 0x000000f0U
#define R_MMU_KBASE_LO__base_0__base_0__MASK 0x0000000fU

#define R_MMU_KBASE_LO__base_7__MAX 15
#define R_MMU_KBASE_LO__base_6__MAX 15
#define R_MMU_KBASE_LO__base_5__MAX 15
#define R_MMU_KBASE_LO__base_4__MAX 15
#define R_MMU_KBASE_LO__base_3__MAX 15
#define R_MMU_KBASE_LO__base_2__MAX 15
#define R_MMU_KBASE_LO__base_1__MAX 15
#define R_MMU_KBASE_LO__base_0__MAX 15

#define R_MMU_KBASE_LO__base_7__MIN 0
#define R_MMU_KBASE_LO__base_6__MIN 0
#define R_MMU_KBASE_LO__base_5__MIN 0
#define R_MMU_KBASE_LO__base_4__MIN 0
#define R_MMU_KBASE_LO__base_3__MIN 0
#define R_MMU_KBASE_LO__base_2__MIN 0
#define R_MMU_KBASE_LO__base_1__MIN 0
#define R_MMU_KBASE_LO__base_0__MIN 0

#define R_MMU_KBASE_LO__base_7__BITNR 28
#define R_MMU_KBASE_LO__base_6__BITNR 24
#define R_MMU_KBASE_LO__base_5__BITNR 20
#define R_MMU_KBASE_LO__base_4__BITNR 16
#define R_MMU_KBASE_LO__base_3__BITNR 12
#define R_MMU_KBASE_LO__base_2__BITNR 8
#define R_MMU_KBASE_LO__base_1__BITNR 4
#define R_MMU_KBASE_LO__base_0__BITNR 0

#define R_MMU_KBASE_LO__base_7__base_7__VAL REG_VAL_VAL
#define R_MMU_KBASE_LO__base_6__base_6__VAL REG_VAL_VAL
#define R_MMU_KBASE_LO__base_5__base_5__VAL REG_VAL_VAL
#define R_MMU_KBASE_LO__base_4__base_4__VAL REG_VAL_VAL
#define R_MMU_KBASE_LO__base_3__base_3__VAL REG_VAL_VAL
#define R_MMU_KBASE_LO__base_2__base_2__VAL REG_VAL_VAL
#define R_MMU_KBASE_LO__base_1__base_1__VAL REG_VAL_VAL
#define R_MMU_KBASE_LO__base_0__base_0__VAL REG_VAL_VAL


#endif

/*
 *  R_MMU_KSEG
 *  - type:  WO
 *  - addr:  0xb0000240
 *  - group: MMU registers
 */

#if USE_GROUP__MMU_registers

#define R_MMU_KSEG__ADDR      (REG_TYPECAST_UWORD  0xb0000240)

#ifndef REG_NO_SHADOW
#define R_MMU_KSEG__SADDR     (REG_STYPECAST_UWORD (reg_shadow__hwregs.R_MMU_CONFIG + 2))
#define R_MMU_KSEG__IADDR     (REG_STYPECAST_UWORD (reg_initiated__hwregs.R_MMU_CONFIG + 2))
#else /* REG_NO_SHADOW */
#define R_MMU_KSEG__SADDR     (REG_STYPECAST_UWORD (&reg_shadow__hwregs))
#define R_MMU_KSEG__IADDR     (REG_STYPECAST_UWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_MMU_KSEG__STYPECAST REG_STYPECAST_UWORD
#define R_MMU_KSEG__SVAL      REG_SVAL_SHADOW
#define R_MMU_KSEG__SVAL_I    REG_SVAL_I_SHADOW
#define R_MMU_KSEG__TYPECAST  REG_TYPECAST_UWORD
#define R_MMU_KSEG__TYPE      (REG_UWORD)
#define R_MMU_KSEG__GET       REG_GET_WO
#define R_MMU_KSEG__IGET      REG_IGET_WO
#define R_MMU_KSEG__SET       REG_SET_WO
#define R_MMU_KSEG__ISET      REG_ISET_WO
#define R_MMU_KSEG__SET_VAL   REG_SET_VAL_WO
#define R_MMU_KSEG__EQL       REG_EQL_WO
#define R_MMU_KSEG__IEQL      REG_IEQL_WO
#define R_MMU_KSEG__RD        REG_RD_WO
#define R_MMU_KSEG__IRD       REG_IRD_WO
#define R_MMU_KSEG__WR        REG_WR_WO
#define R_MMU_KSEG__IWR       REG_IWR_WO

#define R_MMU_KSEG__WRITE(addr,value) \
  (*(addr) = (value))

#define R_MMU_KSEG__seg_f__seg_f__MASK 0x00008000U
#define R_MMU_KSEG__seg_e__seg_e__MASK 0x00004000U
#define R_MMU_KSEG__seg_d__seg_d__MASK 0x00002000U
#define R_MMU_KSEG__seg_c__seg_c__MASK 0x00001000U
#define R_MMU_KSEG__seg_b__seg_b__MASK 0x00000800U
#define R_MMU_KSEG__seg_a__seg_a__MASK 0x00000400U
#define R_MMU_KSEG__seg_9__seg_9__MASK 0x00000200U
#define R_MMU_KSEG__seg_8__seg_8__MASK 0x00000100U
#define R_MMU_KSEG__seg_7__seg_7__MASK 0x00000080U
#define R_MMU_KSEG__seg_6__seg_6__MASK 0x00000040U
#define R_MMU_KSEG__seg_5__seg_5__MASK 0x00000020U
#define R_MMU_KSEG__seg_4__seg_4__MASK 0x00000010U
#define R_MMU_KSEG__seg_3__seg_3__MASK 0x00000008U
#define R_MMU_KSEG__seg_2__seg_2__MASK 0x00000004U
#define R_MMU_KSEG__seg_1__seg_1__MASK 0x00000002U
#define R_MMU_KSEG__seg_0__seg_0__MASK 0x00000001U

#define R_MMU_KSEG__seg_f__MAX 0x1
#define R_MMU_KSEG__seg_e__MAX 0x1
#define R_MMU_KSEG__seg_d__MAX 0x1
#define R_MMU_KSEG__seg_c__MAX 0x1
#define R_MMU_KSEG__seg_b__MAX 0x1
#define R_MMU_KSEG__seg_a__MAX 0x1
#define R_MMU_KSEG__seg_9__MAX 0x1
#define R_MMU_KSEG__seg_8__MAX 0x1
#define R_MMU_KSEG__seg_7__MAX 0x1
#define R_MMU_KSEG__seg_6__MAX 0x1
#define R_MMU_KSEG__seg_5__MAX 0x1
#define R_MMU_KSEG__seg_4__MAX 0x1
#define R_MMU_KSEG__seg_3__MAX 0x1
#define R_MMU_KSEG__seg_2__MAX 0x1
#define R_MMU_KSEG__seg_1__MAX 0x1
#define R_MMU_KSEG__seg_0__MAX 0x1

#define R_MMU_KSEG__seg_f__MIN 0
#define R_MMU_KSEG__seg_e__MIN 0
#define R_MMU_KSEG__seg_d__MIN 0
#define R_MMU_KSEG__seg_c__MIN 0
#define R_MMU_KSEG__seg_b__MIN 0
#define R_MMU_KSEG__seg_a__MIN 0
#define R_MMU_KSEG__seg_9__MIN 0
#define R_MMU_KSEG__seg_8__MIN 0
#define R_MMU_KSEG__seg_7__MIN 0
#define R_MMU_KSEG__seg_6__MIN 0
#define R_MMU_KSEG__seg_5__MIN 0
#define R_MMU_KSEG__seg_4__MIN 0
#define R_MMU_KSEG__seg_3__MIN 0
#define R_MMU_KSEG__seg_2__MIN 0
#define R_MMU_KSEG__seg_1__MIN 0
#define R_MMU_KSEG__seg_0__MIN 0

#define R_MMU_KSEG__seg_f__BITNR 15
#define R_MMU_KSEG__seg_e__BITNR 14
#define R_MMU_KSEG__seg_d__BITNR 13
#define R_MMU_KSEG__seg_c__BITNR 12
#define R_MMU_KSEG__seg_b__BITNR 11
#define R_MMU_KSEG__seg_a__BITNR 10
#define R_MMU_KSEG__seg_9__BITNR 9
#define R_MMU_KSEG__seg_8__BITNR 8
#define R_MMU_KSEG__seg_7__BITNR 7
#define R_MMU_KSEG__seg_6__BITNR 6
#define R_MMU_KSEG__seg_5__BITNR 5
#define R_MMU_KSEG__seg_4__BITNR 4
#define R_MMU_KSEG__seg_3__BITNR 3
#define R_MMU_KSEG__seg_2__BITNR 2
#define R_MMU_KSEG__seg_1__BITNR 1
#define R_MMU_KSEG__seg_0__BITNR 0

#define R_MMU_KSEG__seg_f__seg_f__VAL REG_VAL_ENUM
#define R_MMU_KSEG__seg_e__seg_e__VAL REG_VAL_ENUM
#define R_MMU_KSEG__seg_d__seg_d__VAL REG_VAL_ENUM
#define R_MMU_KSEG__seg_c__seg_c__VAL REG_VAL_ENUM
#define R_MMU_KSEG__seg_b__seg_b__VAL REG_VAL_ENUM
#define R_MMU_KSEG__seg_a__seg_a__VAL REG_VAL_ENUM
#define R_MMU_KSEG__seg_9__seg_9__VAL REG_VAL_ENUM
#define R_MMU_KSEG__seg_8__seg_8__VAL REG_VAL_ENUM
#define R_MMU_KSEG__seg_7__seg_7__VAL REG_VAL_ENUM
#define R_MMU_KSEG__seg_6__seg_6__VAL REG_VAL_ENUM
#define R_MMU_KSEG__seg_5__seg_5__VAL REG_VAL_ENUM
#define R_MMU_KSEG__seg_4__seg_4__VAL REG_VAL_ENUM
#define R_MMU_KSEG__seg_3__seg_3__VAL REG_VAL_ENUM
#define R_MMU_KSEG__seg_2__seg_2__VAL REG_VAL_ENUM
#define R_MMU_KSEG__seg_1__seg_1__VAL REG_VAL_ENUM
#define R_MMU_KSEG__seg_0__seg_0__VAL REG_VAL_ENUM

#define R_MMU_KSEG__seg_f__seg_f__page 0
#define R_MMU_KSEG__seg_f__seg_f__seg 1
#define R_MMU_KSEG__seg_e__seg_e__page 0
#define R_MMU_KSEG__seg_e__seg_e__seg 1
#define R_MMU_KSEG__seg_d__seg_d__page 0
#define R_MMU_KSEG__seg_d__seg_d__seg 1
#define R_MMU_KSEG__seg_c__seg_c__page 0
#define R_MMU_KSEG__seg_c__seg_c__seg 1
#define R_MMU_KSEG__seg_b__seg_b__page 0
#define R_MMU_KSEG__seg_b__seg_b__seg 1
#define R_MMU_KSEG__seg_a__seg_a__page 0
#define R_MMU_KSEG__seg_a__seg_a__seg 1
#define R_MMU_KSEG__seg_9__seg_9__page 0
#define R_MMU_KSEG__seg_9__seg_9__seg 1
#define R_MMU_KSEG__seg_8__seg_8__page 0
#define R_MMU_KSEG__seg_8__seg_8__seg 1
#define R_MMU_KSEG__seg_7__seg_7__page 0
#define R_MMU_KSEG__seg_7__seg_7__seg 1
#define R_MMU_KSEG__seg_6__seg_6__page 0
#define R_MMU_KSEG__seg_6__seg_6__seg 1
#define R_MMU_KSEG__seg_5__seg_5__page 0
#define R_MMU_KSEG__seg_5__seg_5__seg 1
#define R_MMU_KSEG__seg_4__seg_4__page 0
#define R_MMU_KSEG__seg_4__seg_4__seg 1
#define R_MMU_KSEG__seg_3__seg_3__page 0
#define R_MMU_KSEG__seg_3__seg_3__seg 1
#define R_MMU_KSEG__seg_2__seg_2__page 0
#define R_MMU_KSEG__seg_2__seg_2__seg 1
#define R_MMU_KSEG__seg_1__seg_1__page 0
#define R_MMU_KSEG__seg_1__seg_1__seg 1
#define R_MMU_KSEG__seg_0__seg_0__page 0
#define R_MMU_KSEG__seg_0__seg_0__seg 1

#endif

/*
 *  R_NETWORK_GA_0
 *  - type:  WO
 *  - addr:  0xb000008c
 *  - group: Network interface registers
 */

#if USE_GROUP__Network_interface_registers

#define R_NETWORK_GA_0__ADDR      (REG_TYPECAST_UDWORD  0xb000008c)

#ifndef REG_NO_SHADOW
#define R_NETWORK_GA_0__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_NETWORK_GA_0 + 0))
#define R_NETWORK_GA_0__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_NETWORK_GA_0 + 0))
#else /* REG_NO_SHADOW */
#define R_NETWORK_GA_0__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_NETWORK_GA_0__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_NETWORK_GA_0__STYPECAST REG_STYPECAST_UDWORD
#define R_NETWORK_GA_0__SVAL      REG_SVAL_SHADOW
#define R_NETWORK_GA_0__SVAL_I    REG_SVAL_I_SHADOW
#define R_NETWORK_GA_0__TYPECAST  REG_TYPECAST_UDWORD
#define R_NETWORK_GA_0__TYPE      (REG_UDWORD)
#define R_NETWORK_GA_0__GET       REG_GET_WO
#define R_NETWORK_GA_0__IGET      REG_IGET_WO
#define R_NETWORK_GA_0__SET       REG_SET_WO
#define R_NETWORK_GA_0__ISET      REG_ISET_WO
#define R_NETWORK_GA_0__SET_VAL   REG_SET_VAL_WO
#define R_NETWORK_GA_0__EQL       REG_EQL_WO
#define R_NETWORK_GA_0__IEQL      REG_IEQL_WO
#define R_NETWORK_GA_0__RD        REG_RD_WO
#define R_NETWORK_GA_0__IRD       REG_IRD_WO
#define R_NETWORK_GA_0__WR        REG_WR_WO
#define R_NETWORK_GA_0__IWR       REG_IWR_WO

#define R_NETWORK_GA_0__WRITE(addr,value) \
  (*(addr) = (value))

#define R_NETWORK_GA_0__ga_low__ga_low__MASK 0xffffffffU

#define R_NETWORK_GA_0__ga_low__MAX 0xffffffff

#define R_NETWORK_GA_0__ga_low__MIN 0

#define R_NETWORK_GA_0__ga_low__BITNR 0

#define R_NETWORK_GA_0__ga_low__ga_low__VAL REG_VAL_VAL


#endif

/*
 *  R_NETWORK_GA_1
 *  - type:  WO
 *  - addr:  0xb0000090
 *  - group: Network interface registers
 */

#if USE_GROUP__Network_interface_registers

#define R_NETWORK_GA_1__ADDR      (REG_TYPECAST_UDWORD  0xb0000090)

#ifndef REG_NO_SHADOW
#define R_NETWORK_GA_1__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_NETWORK_GA_1 + 0))
#define R_NETWORK_GA_1__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_NETWORK_GA_1 + 0))
#else /* REG_NO_SHADOW */
#define R_NETWORK_GA_1__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_NETWORK_GA_1__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_NETWORK_GA_1__STYPECAST REG_STYPECAST_UDWORD
#define R_NETWORK_GA_1__SVAL      REG_SVAL_SHADOW
#define R_NETWORK_GA_1__SVAL_I    REG_SVAL_I_SHADOW
#define R_NETWORK_GA_1__TYPECAST  REG_TYPECAST_UDWORD
#define R_NETWORK_GA_1__TYPE      (REG_UDWORD)
#define R_NETWORK_GA_1__GET       REG_GET_WO
#define R_NETWORK_GA_1__IGET      REG_IGET_WO
#define R_NETWORK_GA_1__SET       REG_SET_WO
#define R_NETWORK_GA_1__ISET      REG_ISET_WO
#define R_NETWORK_GA_1__SET_VAL   REG_SET_VAL_WO
#define R_NETWORK_GA_1__EQL       REG_EQL_WO
#define R_NETWORK_GA_1__IEQL      REG_IEQL_WO
#define R_NETWORK_GA_1__RD        REG_RD_WO
#define R_NETWORK_GA_1__IRD       REG_IRD_WO
#define R_NETWORK_GA_1__WR        REG_WR_WO
#define R_NETWORK_GA_1__IWR       REG_IWR_WO

#define R_NETWORK_GA_1__WRITE(addr,value) \
  (*(addr) = (value))

#define R_NETWORK_GA_1__ga_high__ga_high__MASK 0xffffffffU

#define R_NETWORK_GA_1__ga_high__MAX 0xffffffff

#define R_NETWORK_GA_1__ga_high__MIN 0

#define R_NETWORK_GA_1__ga_high__BITNR 0

#define R_NETWORK_GA_1__ga_high__ga_high__VAL REG_VAL_VAL


#endif

/*
 *  R_NETWORK_GEN_CONFIG
 *  - type:  WO
 *  - addr:  0xb0000098
 *  - group: Network interface registers
 */

#if USE_GROUP__Network_interface_registers

#define R_NETWORK_GEN_CONFIG__ADDR      (REG_TYPECAST_UDWORD  0xb0000098)

#ifndef REG_NO_SHADOW
#define R_NETWORK_GEN_CONFIG__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_NETWORK_GEN_CONFIG + 0))
#define R_NETWORK_GEN_CONFIG__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_NETWORK_GEN_CONFIG + 0))
#else /* REG_NO_SHADOW */
#define R_NETWORK_GEN_CONFIG__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_NETWORK_GEN_CONFIG__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_NETWORK_GEN_CONFIG__STYPECAST REG_STYPECAST_UDWORD
#define R_NETWORK_GEN_CONFIG__SVAL      REG_SVAL_SHADOW
#define R_NETWORK_GEN_CONFIG__SVAL_I    REG_SVAL_I_SHADOW
#define R_NETWORK_GEN_CONFIG__TYPECAST  REG_TYPECAST_UDWORD
#define R_NETWORK_GEN_CONFIG__TYPE      (REG_UDWORD)
#define R_NETWORK_GEN_CONFIG__GET       REG_GET_WO
#define R_NETWORK_GEN_CONFIG__IGET      REG_IGET_WO
#define R_NETWORK_GEN_CONFIG__SET       REG_SET_WO
#define R_NETWORK_GEN_CONFIG__ISET      REG_ISET_WO
#define R_NETWORK_GEN_CONFIG__SET_VAL   REG_SET_VAL_WO
#define R_NETWORK_GEN_CONFIG__EQL       REG_EQL_WO
#define R_NETWORK_GEN_CONFIG__IEQL      REG_IEQL_WO
#define R_NETWORK_GEN_CONFIG__RD        REG_RD_WO
#define R_NETWORK_GEN_CONFIG__IRD       REG_IRD_WO
#define R_NETWORK_GEN_CONFIG__WR        REG_WR_WO
#define R_NETWORK_GEN_CONFIG__IWR       REG_IWR_WO

#define R_NETWORK_GEN_CONFIG__WRITE(addr,value) \
  (*(addr) = (value))

#define R_NETWORK_GEN_CONFIG__loopback__loopback__MASK 0x00000020U
#define R_NETWORK_GEN_CONFIG__frame__frame__MASK 0x00000010U
#define R_NETWORK_GEN_CONFIG__vg__vg__MASK 0x00000008U
#define R_NETWORK_GEN_CONFIG__phy__phy__MASK 0x00000006U
#define R_NETWORK_GEN_CONFIG__enable__enable__MASK 0x00000001U

#define R_NETWORK_GEN_CONFIG__loopback__MAX 0x1
#define R_NETWORK_GEN_CONFIG__frame__MAX 0x1
#define R_NETWORK_GEN_CONFIG__vg__MAX 0x1
#define R_NETWORK_GEN_CONFIG__phy__MAX 0x3
#define R_NETWORK_GEN_CONFIG__enable__MAX 0x1

#define R_NETWORK_GEN_CONFIG__loopback__MIN 0
#define R_NETWORK_GEN_CONFIG__frame__MIN 0
#define R_NETWORK_GEN_CONFIG__vg__MIN 0
#define R_NETWORK_GEN_CONFIG__phy__MIN 0
#define R_NETWORK_GEN_CONFIG__enable__MIN 0

#define R_NETWORK_GEN_CONFIG__loopback__BITNR 5
#define R_NETWORK_GEN_CONFIG__frame__BITNR 4
#define R_NETWORK_GEN_CONFIG__vg__BITNR 3
#define R_NETWORK_GEN_CONFIG__phy__BITNR 1
#define R_NETWORK_GEN_CONFIG__enable__BITNR 0

#define R_NETWORK_GEN_CONFIG__loopback__loopback__VAL REG_VAL_ENUM
#define R_NETWORK_GEN_CONFIG__frame__frame__VAL REG_VAL_ENUM
#define R_NETWORK_GEN_CONFIG__vg__vg__VAL REG_VAL_ENUM
#define R_NETWORK_GEN_CONFIG__phy__phy__VAL REG_VAL_ENUM
#define R_NETWORK_GEN_CONFIG__enable__enable__VAL REG_VAL_ENUM

#define R_NETWORK_GEN_CONFIG__loopback__loopback__off 0
#define R_NETWORK_GEN_CONFIG__loopback__loopback__on 1
#define R_NETWORK_GEN_CONFIG__frame__frame__ether 0
#define R_NETWORK_GEN_CONFIG__frame__frame__tokenr 1
#define R_NETWORK_GEN_CONFIG__vg__vg__off 0
#define R_NETWORK_GEN_CONFIG__vg__vg__on 1
#define R_NETWORK_GEN_CONFIG__phy__phy__mii_clk 1
#define R_NETWORK_GEN_CONFIG__phy__phy__mii_err 2
#define R_NETWORK_GEN_CONFIG__phy__phy__mii_req 3
#define R_NETWORK_GEN_CONFIG__phy__phy__sni 0
#define R_NETWORK_GEN_CONFIG__enable__enable__off 0
#define R_NETWORK_GEN_CONFIG__enable__enable__on 1

#endif

/*
 *  R_NETWORK_MGM_CTRL
 *  - type:  WO
 *  - addr:  0xb00000a0
 *  - group: Network interface registers
 */

#if USE_GROUP__Network_interface_registers

#define R_NETWORK_MGM_CTRL__ADDR      (REG_TYPECAST_UDWORD  0xb00000a0)

#ifndef REG_NO_SHADOW
#define R_NETWORK_MGM_CTRL__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_NETWORK_MGM_CTRL + 0))
#define R_NETWORK_MGM_CTRL__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_NETWORK_MGM_CTRL + 0))
#else /* REG_NO_SHADOW */
#define R_NETWORK_MGM_CTRL__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_NETWORK_MGM_CTRL__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_NETWORK_MGM_CTRL__STYPECAST REG_STYPECAST_UDWORD
#define R_NETWORK_MGM_CTRL__SVAL      REG_SVAL_SHADOW
#define R_NETWORK_MGM_CTRL__SVAL_I    REG_SVAL_I_SHADOW
#define R_NETWORK_MGM_CTRL__TYPECAST  REG_TYPECAST_UDWORD
#define R_NETWORK_MGM_CTRL__TYPE      (REG_UDWORD)
#define R_NETWORK_MGM_CTRL__GET       REG_GET_WO
#define R_NETWORK_MGM_CTRL__IGET      REG_IGET_WO
#define R_NETWORK_MGM_CTRL__SET       REG_SET_WO
#define R_NETWORK_MGM_CTRL__ISET      REG_ISET_WO
#define R_NETWORK_MGM_CTRL__SET_VAL   REG_SET_VAL_WO
#define R_NETWORK_MGM_CTRL__EQL       REG_EQL_WO
#define R_NETWORK_MGM_CTRL__IEQL      REG_IEQL_WO
#define R_NETWORK_MGM_CTRL__RD        REG_RD_WO
#define R_NETWORK_MGM_CTRL__IRD       REG_IRD_WO
#define R_NETWORK_MGM_CTRL__WR        REG_WR_WO
#define R_NETWORK_MGM_CTRL__IWR       REG_IWR_WO

#define R_NETWORK_MGM_CTRL__WRITE(addr,value) \
  (*(addr) = (value))

#define R_NETWORK_MGM_CTRL__txd_pins__txd_pins__MASK 0x000000f0U
#define R_NETWORK_MGM_CTRL__txer_pin__txer_pin__MASK 0x00000008U
#define R_NETWORK_MGM_CTRL__mdck__mdck__MASK 0x00000004U
#define R_NETWORK_MGM_CTRL__mdoe__mdoe__MASK 0x00000002U
#define R_NETWORK_MGM_CTRL__mdio__mdio__MASK 0x00000001U

#define R_NETWORK_MGM_CTRL__txd_pins__MAX 0xf
#define R_NETWORK_MGM_CTRL__txer_pin__MAX 0x1
#define R_NETWORK_MGM_CTRL__mdck__MAX 0x1
#define R_NETWORK_MGM_CTRL__mdoe__MAX 0x1
#define R_NETWORK_MGM_CTRL__mdio__MAX 0x1

#define R_NETWORK_MGM_CTRL__txd_pins__MIN 0
#define R_NETWORK_MGM_CTRL__txer_pin__MIN 0
#define R_NETWORK_MGM_CTRL__mdck__MIN 0
#define R_NETWORK_MGM_CTRL__mdoe__MIN 0
#define R_NETWORK_MGM_CTRL__mdio__MIN 0

#define R_NETWORK_MGM_CTRL__txd_pins__BITNR 4
#define R_NETWORK_MGM_CTRL__txer_pin__BITNR 3
#define R_NETWORK_MGM_CTRL__mdck__BITNR 2
#define R_NETWORK_MGM_CTRL__mdoe__BITNR 1
#define R_NETWORK_MGM_CTRL__mdio__BITNR 0

#define R_NETWORK_MGM_CTRL__txd_pins__txd_pins__VAL REG_VAL_VAL
#define R_NETWORK_MGM_CTRL__txer_pin__txer_pin__VAL REG_VAL_VAL
#define R_NETWORK_MGM_CTRL__mdck__mdck__VAL REG_VAL_VAL
#define R_NETWORK_MGM_CTRL__mdoe__mdoe__VAL REG_VAL_ENUM
#define R_NETWORK_MGM_CTRL__mdio__mdio__VAL REG_VAL_VAL

#define R_NETWORK_MGM_CTRL__mdoe__mdoe__disable 0
#define R_NETWORK_MGM_CTRL__mdoe__mdoe__enable 1

#endif

/*
 *  R_NETWORK_REC_CONFIG
 *  - type:  WO
 *  - addr:  0xb0000094
 *  - group: Network interface registers
 */

#if USE_GROUP__Network_interface_registers

#define R_NETWORK_REC_CONFIG__ADDR      (REG_TYPECAST_UDWORD  0xb0000094)

#ifndef REG_NO_SHADOW
#define R_NETWORK_REC_CONFIG__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_NETWORK_REC_CONFIG + 0))
#define R_NETWORK_REC_CONFIG__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_NETWORK_REC_CONFIG + 0))
#else /* REG_NO_SHADOW */
#define R_NETWORK_REC_CONFIG__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_NETWORK_REC_CONFIG__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_NETWORK_REC_CONFIG__STYPECAST REG_STYPECAST_UDWORD
#define R_NETWORK_REC_CONFIG__SVAL      REG_SVAL_SHADOW
#define R_NETWORK_REC_CONFIG__SVAL_I    REG_SVAL_I_SHADOW
#define R_NETWORK_REC_CONFIG__TYPECAST  REG_TYPECAST_UDWORD
#define R_NETWORK_REC_CONFIG__TYPE      (REG_UDWORD)
#define R_NETWORK_REC_CONFIG__GET       REG_GET_WO
#define R_NETWORK_REC_CONFIG__IGET      REG_IGET_WO
#define R_NETWORK_REC_CONFIG__SET       REG_SET_WO
#define R_NETWORK_REC_CONFIG__ISET      REG_ISET_WO
#define R_NETWORK_REC_CONFIG__SET_VAL   REG_SET_VAL_WO
#define R_NETWORK_REC_CONFIG__EQL       REG_EQL_WO
#define R_NETWORK_REC_CONFIG__IEQL      REG_IEQL_WO
#define R_NETWORK_REC_CONFIG__RD        REG_RD_WO
#define R_NETWORK_REC_CONFIG__IRD       REG_IRD_WO
#define R_NETWORK_REC_CONFIG__WR        REG_WR_WO
#define R_NETWORK_REC_CONFIG__IWR       REG_IWR_WO

#define R_NETWORK_REC_CONFIG__WRITE(addr,value) \
  (*(addr) = (value))

#define R_NETWORK_REC_CONFIG__max_size__max_size__MASK 0x00000400U
#define R_NETWORK_REC_CONFIG__duplex__duplex__MASK 0x00000200U
#define R_NETWORK_REC_CONFIG__bad_crc__bad_crc__MASK 0x00000100U
#define R_NETWORK_REC_CONFIG__oversize__oversize__MASK 0x00000080U
#define R_NETWORK_REC_CONFIG__undersize__undersize__MASK 0x00000040U
#define R_NETWORK_REC_CONFIG__all_roots__all_roots__MASK 0x00000020U
#define R_NETWORK_REC_CONFIG__tr_broadcast__tr_broadcast__MASK 0x00000010U
#define R_NETWORK_REC_CONFIG__broadcast__broadcast__MASK 0x00000008U
#define R_NETWORK_REC_CONFIG__individual__individual__MASK 0x00000004U
#define R_NETWORK_REC_CONFIG__ma1__ma1__MASK 0x00000002U
#define R_NETWORK_REC_CONFIG__ma0__ma0__MASK 0x00000001U

#define R_NETWORK_REC_CONFIG__max_size__MAX 0x1
#define R_NETWORK_REC_CONFIG__duplex__MAX 0x1
#define R_NETWORK_REC_CONFIG__bad_crc__MAX 0x1
#define R_NETWORK_REC_CONFIG__oversize__MAX 0x1
#define R_NETWORK_REC_CONFIG__undersize__MAX 0x1
#define R_NETWORK_REC_CONFIG__all_roots__MAX 0x1
#define R_NETWORK_REC_CONFIG__tr_broadcast__MAX 0x1
#define R_NETWORK_REC_CONFIG__broadcast__MAX 0x1
#define R_NETWORK_REC_CONFIG__individual__MAX 0x1
#define R_NETWORK_REC_CONFIG__ma1__MAX 0x1
#define R_NETWORK_REC_CONFIG__ma0__MAX 0x1

#define R_NETWORK_REC_CONFIG__max_size__MIN 0
#define R_NETWORK_REC_CONFIG__duplex__MIN 0
#define R_NETWORK_REC_CONFIG__bad_crc__MIN 0
#define R_NETWORK_REC_CONFIG__oversize__MIN 0
#define R_NETWORK_REC_CONFIG__undersize__MIN 0
#define R_NETWORK_REC_CONFIG__all_roots__MIN 0
#define R_NETWORK_REC_CONFIG__tr_broadcast__MIN 0
#define R_NETWORK_REC_CONFIG__broadcast__MIN 0
#define R_NETWORK_REC_CONFIG__individual__MIN 0
#define R_NETWORK_REC_CONFIG__ma1__MIN 0
#define R_NETWORK_REC_CONFIG__ma0__MIN 0

#define R_NETWORK_REC_CONFIG__max_size__BITNR 10
#define R_NETWORK_REC_CONFIG__duplex__BITNR 9
#define R_NETWORK_REC_CONFIG__bad_crc__BITNR 8
#define R_NETWORK_REC_CONFIG__oversize__BITNR 7
#define R_NETWORK_REC_CONFIG__undersize__BITNR 6
#define R_NETWORK_REC_CONFIG__all_roots__BITNR 5
#define R_NETWORK_REC_CONFIG__tr_broadcast__BITNR 4
#define R_NETWORK_REC_CONFIG__broadcast__BITNR 3
#define R_NETWORK_REC_CONFIG__individual__BITNR 2
#define R_NETWORK_REC_CONFIG__ma1__BITNR 1
#define R_NETWORK_REC_CONFIG__ma0__BITNR 0

#define R_NETWORK_REC_CONFIG__max_size__max_size__VAL REG_VAL_ENUM
#define R_NETWORK_REC_CONFIG__duplex__duplex__VAL REG_VAL_ENUM
#define R_NETWORK_REC_CONFIG__bad_crc__bad_crc__VAL REG_VAL_ENUM
#define R_NETWORK_REC_CONFIG__oversize__oversize__VAL REG_VAL_ENUM
#define R_NETWORK_REC_CONFIG__undersize__undersize__VAL REG_VAL_ENUM
#define R_NETWORK_REC_CONFIG__all_roots__all_roots__VAL REG_VAL_ENUM
#define R_NETWORK_REC_CONFIG__tr_broadcast__tr_broadcast__VAL REG_VAL_ENUM
#define R_NETWORK_REC_CONFIG__broadcast__broadcast__VAL REG_VAL_ENUM
#define R_NETWORK_REC_CONFIG__individual__individual__VAL REG_VAL_ENUM
#define R_NETWORK_REC_CONFIG__ma1__ma1__VAL REG_VAL_ENUM
#define R_NETWORK_REC_CONFIG__ma0__ma0__VAL REG_VAL_ENUM

#define R_NETWORK_REC_CONFIG__max_size__max_size__size1518 0
#define R_NETWORK_REC_CONFIG__max_size__max_size__size1522 1
#define R_NETWORK_REC_CONFIG__duplex__duplex__full 1
#define R_NETWORK_REC_CONFIG__duplex__duplex__half 0
#define R_NETWORK_REC_CONFIG__bad_crc__bad_crc__discard 0
#define R_NETWORK_REC_CONFIG__bad_crc__bad_crc__receive 1
#define R_NETWORK_REC_CONFIG__oversize__oversize__discard 0
#define R_NETWORK_REC_CONFIG__oversize__oversize__receive 1
#define R_NETWORK_REC_CONFIG__undersize__undersize__discard 0
#define R_NETWORK_REC_CONFIG__undersize__undersize__receive 1
#define R_NETWORK_REC_CONFIG__all_roots__all_roots__discard 0
#define R_NETWORK_REC_CONFIG__all_roots__all_roots__receive 1
#define R_NETWORK_REC_CONFIG__tr_broadcast__tr_broadcast__discard 0
#define R_NETWORK_REC_CONFIG__tr_broadcast__tr_broadcast__receive 1
#define R_NETWORK_REC_CONFIG__broadcast__broadcast__discard 0
#define R_NETWORK_REC_CONFIG__broadcast__broadcast__receive 1
#define R_NETWORK_REC_CONFIG__individual__individual__discard 0
#define R_NETWORK_REC_CONFIG__individual__individual__receive 1
#define R_NETWORK_REC_CONFIG__ma1__ma1__disable 0
#define R_NETWORK_REC_CONFIG__ma1__ma1__enable 1
#define R_NETWORK_REC_CONFIG__ma0__ma0__disable 0
#define R_NETWORK_REC_CONFIG__ma0__ma0__enable 1

#endif

/*
 *  R_NETWORK_SA_0
 *  - type:  WO
 *  - addr:  0xb0000080
 *  - group: Network interface registers
 */

#if USE_GROUP__Network_interface_registers

#define R_NETWORK_SA_0__ADDR      (REG_TYPECAST_UDWORD  0xb0000080)

#ifndef REG_NO_SHADOW
#define R_NETWORK_SA_0__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_NETWORK_SA_0 + 0))
#define R_NETWORK_SA_0__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_NETWORK_SA_0 + 0))
#else /* REG_NO_SHADOW */
#define R_NETWORK_SA_0__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_NETWORK_SA_0__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_NETWORK_SA_0__STYPECAST REG_STYPECAST_UDWORD
#define R_NETWORK_SA_0__SVAL      REG_SVAL_SHADOW
#define R_NETWORK_SA_0__SVAL_I    REG_SVAL_I_SHADOW
#define R_NETWORK_SA_0__TYPECAST  REG_TYPECAST_UDWORD
#define R_NETWORK_SA_0__TYPE      (REG_UDWORD)
#define R_NETWORK_SA_0__GET       REG_GET_WO
#define R_NETWORK_SA_0__IGET      REG_IGET_WO
#define R_NETWORK_SA_0__SET       REG_SET_WO
#define R_NETWORK_SA_0__ISET      REG_ISET_WO
#define R_NETWORK_SA_0__SET_VAL   REG_SET_VAL_WO
#define R_NETWORK_SA_0__EQL       REG_EQL_WO
#define R_NETWORK_SA_0__IEQL      REG_IEQL_WO
#define R_NETWORK_SA_0__RD        REG_RD_WO
#define R_NETWORK_SA_0__IRD       REG_IRD_WO
#define R_NETWORK_SA_0__WR        REG_WR_WO
#define R_NETWORK_SA_0__IWR       REG_IWR_WO

#define R_NETWORK_SA_0__WRITE(addr,value) \
  (*(addr) = (value))

#define R_NETWORK_SA_0__ma0_low__ma0_low__MASK 0xffffffffU

#define R_NETWORK_SA_0__ma0_low__MAX 0xffffffff

#define R_NETWORK_SA_0__ma0_low__MIN 0

#define R_NETWORK_SA_0__ma0_low__BITNR 0

#define R_NETWORK_SA_0__ma0_low__ma0_low__VAL REG_VAL_VAL


#endif

/*
 *  R_NETWORK_SA_1
 *  - type:  WO
 *  - addr:  0xb0000084
 *  - group: Network interface registers
 */

#if USE_GROUP__Network_interface_registers

#define R_NETWORK_SA_1__ADDR      (REG_TYPECAST_UDWORD  0xb0000084)

#ifndef REG_NO_SHADOW
#define R_NETWORK_SA_1__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_NETWORK_SA_1 + 0))
#define R_NETWORK_SA_1__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_NETWORK_SA_1 + 0))
#else /* REG_NO_SHADOW */
#define R_NETWORK_SA_1__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_NETWORK_SA_1__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_NETWORK_SA_1__STYPECAST REG_STYPECAST_UDWORD
#define R_NETWORK_SA_1__SVAL      REG_SVAL_SHADOW
#define R_NETWORK_SA_1__SVAL_I    REG_SVAL_I_SHADOW
#define R_NETWORK_SA_1__TYPECAST  REG_TYPECAST_UDWORD
#define R_NETWORK_SA_1__TYPE      (REG_UDWORD)
#define R_NETWORK_SA_1__GET       REG_GET_WO
#define R_NETWORK_SA_1__IGET      REG_IGET_WO
#define R_NETWORK_SA_1__SET       REG_SET_WO
#define R_NETWORK_SA_1__ISET      REG_ISET_WO
#define R_NETWORK_SA_1__SET_VAL   REG_SET_VAL_WO
#define R_NETWORK_SA_1__EQL       REG_EQL_WO
#define R_NETWORK_SA_1__IEQL      REG_IEQL_WO
#define R_NETWORK_SA_1__RD        REG_RD_WO
#define R_NETWORK_SA_1__IRD       REG_IRD_WO
#define R_NETWORK_SA_1__WR        REG_WR_WO
#define R_NETWORK_SA_1__IWR       REG_IWR_WO

#define R_NETWORK_SA_1__WRITE(addr,value) \
  (*(addr) = (value))

#define R_NETWORK_SA_1__ma1_low__ma1_low__MASK 0xffff0000U
#define R_NETWORK_SA_1__ma0_high__ma0_high__MASK 0x0000ffffU

#define R_NETWORK_SA_1__ma1_low__MAX 0xffff
#define R_NETWORK_SA_1__ma0_high__MAX 0xffff

#define R_NETWORK_SA_1__ma1_low__MIN 0
#define R_NETWORK_SA_1__ma0_high__MIN 0

#define R_NETWORK_SA_1__ma1_low__BITNR 16
#define R_NETWORK_SA_1__ma0_high__BITNR 0

#define R_NETWORK_SA_1__ma1_low__ma1_low__VAL REG_VAL_VAL
#define R_NETWORK_SA_1__ma0_high__ma0_high__VAL REG_VAL_VAL


#endif

/*
 *  R_NETWORK_SA_2
 *  - type:  WO
 *  - addr:  0xb0000088
 *  - group: Network interface registers
 */

#if USE_GROUP__Network_interface_registers

#define R_NETWORK_SA_2__ADDR      (REG_TYPECAST_UDWORD  0xb0000088)

#ifndef REG_NO_SHADOW
#define R_NETWORK_SA_2__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_NETWORK_SA_2 + 0))
#define R_NETWORK_SA_2__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_NETWORK_SA_2 + 0))
#else /* REG_NO_SHADOW */
#define R_NETWORK_SA_2__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_NETWORK_SA_2__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_NETWORK_SA_2__STYPECAST REG_STYPECAST_UDWORD
#define R_NETWORK_SA_2__SVAL      REG_SVAL_SHADOW
#define R_NETWORK_SA_2__SVAL_I    REG_SVAL_I_SHADOW
#define R_NETWORK_SA_2__TYPECAST  REG_TYPECAST_UDWORD
#define R_NETWORK_SA_2__TYPE      (REG_UDWORD)
#define R_NETWORK_SA_2__GET       REG_GET_WO
#define R_NETWORK_SA_2__IGET      REG_IGET_WO
#define R_NETWORK_SA_2__SET       REG_SET_WO
#define R_NETWORK_SA_2__ISET      REG_ISET_WO
#define R_NETWORK_SA_2__SET_VAL   REG_SET_VAL_WO
#define R_NETWORK_SA_2__EQL       REG_EQL_WO
#define R_NETWORK_SA_2__IEQL      REG_IEQL_WO
#define R_NETWORK_SA_2__RD        REG_RD_WO
#define R_NETWORK_SA_2__IRD       REG_IRD_WO
#define R_NETWORK_SA_2__WR        REG_WR_WO
#define R_NETWORK_SA_2__IWR       REG_IWR_WO

#define R_NETWORK_SA_2__WRITE(addr,value) \
  (*(addr) = (value))

#define R_NETWORK_SA_2__ma1_high__ma1_high__MASK 0xffffffffU

#define R_NETWORK_SA_2__ma1_high__MAX 0xffffffff

#define R_NETWORK_SA_2__ma1_high__MIN 0

#define R_NETWORK_SA_2__ma1_high__BITNR 0

#define R_NETWORK_SA_2__ma1_high__ma1_high__VAL REG_VAL_VAL


#endif

/*
 *  R_NETWORK_STAT
 *  - type:  RO
 *  - addr:  0xb00000a0
 *  - group: Network interface registers
 */

#if USE_GROUP__Network_interface_registers

#define R_NETWORK_STAT__ADDR      (REG_TYPECAST_UDWORD  0xb00000a0)
#define R_NETWORK_STAT__SVAL      REG_SVAL_SHADOW
#define R_NETWORK_STAT__SVAL_I    REG_SVAL_I_SHADOW
#define R_NETWORK_STAT__TYPECAST  REG_TYPECAST_UDWORD
#define R_NETWORK_STAT__TYPE      (REG_UDWORD)
#define R_NETWORK_STAT__GET       REG_GET_RO
#define R_NETWORK_STAT__IGET      REG_IGET_RO
#define R_NETWORK_STAT__SET       REG_SET_RO
#define R_NETWORK_STAT__ISET      REG_ISET_RO
#define R_NETWORK_STAT__SET_VAL   REG_SET_VAL_RO
#define R_NETWORK_STAT__EQL       REG_EQL_RO
#define R_NETWORK_STAT__IEQL      REG_IEQL_RO
#define R_NETWORK_STAT__RD        REG_RD_RO
#define R_NETWORK_STAT__IRD       REG_IRD_RO
#define R_NETWORK_STAT__WR        REG_WR_RO
#define R_NETWORK_STAT__IWR       REG_IWR_RO

#define R_NETWORK_STAT__READ(addr) \
  (*(addr))

#define R_NETWORK_STAT__rxd_pins__rxd_pins__MASK 0x000000f0U
#define R_NETWORK_STAT__rxer__rxer__MASK 0x00000008U
#define R_NETWORK_STAT__underrun__underrun__MASK 0x00000004U
#define R_NETWORK_STAT__exc_col__exc_col__MASK 0x00000002U
#define R_NETWORK_STAT__mdio__mdio__MASK 0x00000001U

#define R_NETWORK_STAT__rxd_pins__MAX 0xf
#define R_NETWORK_STAT__rxer__MAX 0x1
#define R_NETWORK_STAT__underrun__MAX 0x1
#define R_NETWORK_STAT__exc_col__MAX 0x1
#define R_NETWORK_STAT__mdio__MAX 0x1

#define R_NETWORK_STAT__rxd_pins__MIN 0
#define R_NETWORK_STAT__rxer__MIN 0
#define R_NETWORK_STAT__underrun__MIN 0
#define R_NETWORK_STAT__exc_col__MIN 0
#define R_NETWORK_STAT__mdio__MIN 0

#define R_NETWORK_STAT__rxd_pins__BITNR 4
#define R_NETWORK_STAT__rxer__BITNR 3
#define R_NETWORK_STAT__underrun__BITNR 2
#define R_NETWORK_STAT__exc_col__BITNR 1
#define R_NETWORK_STAT__mdio__BITNR 0

#define R_NETWORK_STAT__rxd_pins__rxd_pins__VAL REG_VAL_VAL
#define R_NETWORK_STAT__rxer__rxer__VAL REG_VAL_VAL
#define R_NETWORK_STAT__underrun__underrun__VAL REG_VAL_ENUM
#define R_NETWORK_STAT__exc_col__exc_col__VAL REG_VAL_ENUM
#define R_NETWORK_STAT__mdio__mdio__VAL REG_VAL_VAL

#define R_NETWORK_STAT__underrun__underrun__no 0
#define R_NETWORK_STAT__underrun__underrun__yes 1
#define R_NETWORK_STAT__exc_col__exc_col__no 0
#define R_NETWORK_STAT__exc_col__exc_col__yes 1

#endif

/*
 *  R_NETWORK_TR_CTRL
 *  - type:  WO
 *  - addr:  0xb000009c
 *  - group: Network interface registers
 */

#if USE_GROUP__Network_interface_registers

#define R_NETWORK_TR_CTRL__ADDR      (REG_TYPECAST_UDWORD  0xb000009c)

#ifndef REG_NO_SHADOW
#define R_NETWORK_TR_CTRL__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_NETWORK_TR_CTRL + 0))
#define R_NETWORK_TR_CTRL__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_NETWORK_TR_CTRL + 0))
#else /* REG_NO_SHADOW */
#define R_NETWORK_TR_CTRL__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_NETWORK_TR_CTRL__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_NETWORK_TR_CTRL__STYPECAST REG_STYPECAST_UDWORD
#define R_NETWORK_TR_CTRL__SVAL      REG_SVAL_SHADOW
#define R_NETWORK_TR_CTRL__SVAL_I    REG_SVAL_I_SHADOW
#define R_NETWORK_TR_CTRL__TYPECAST  REG_TYPECAST_UDWORD
#define R_NETWORK_TR_CTRL__TYPE      (REG_UDWORD)
#define R_NETWORK_TR_CTRL__GET       REG_GET_WO
#define R_NETWORK_TR_CTRL__IGET      REG_IGET_WO
#define R_NETWORK_TR_CTRL__SET       REG_SET_WO
#define R_NETWORK_TR_CTRL__ISET      REG_ISET_WO
#define R_NETWORK_TR_CTRL__SET_VAL   REG_SET_VAL_WO
#define R_NETWORK_TR_CTRL__EQL       REG_EQL_WO
#define R_NETWORK_TR_CTRL__IEQL      REG_IEQL_WO
#define R_NETWORK_TR_CTRL__RD        REG_RD_WO
#define R_NETWORK_TR_CTRL__IRD       REG_IRD_WO
#define R_NETWORK_TR_CTRL__WR        REG_WR_WO
#define R_NETWORK_TR_CTRL__IWR       REG_IWR_WO

#define R_NETWORK_TR_CTRL__WRITE(addr,value) \
  (*(addr) = (value))

#define R_NETWORK_TR_CTRL__clr_error__clr_error__MASK 0x00000100U
#define R_NETWORK_TR_CTRL__delay__delay__MASK 0x00000020U
#define R_NETWORK_TR_CTRL__cancel__cancel__MASK 0x00000010U
#define R_NETWORK_TR_CTRL__cd__cd__MASK 0x00000008U
#define R_NETWORK_TR_CTRL__retry__retry__MASK 0x00000004U
#define R_NETWORK_TR_CTRL__pad__pad__MASK 0x00000002U
#define R_NETWORK_TR_CTRL__crc__crc__MASK 0x00000001U

#define R_NETWORK_TR_CTRL__clr_error__MAX 0x1
#define R_NETWORK_TR_CTRL__delay__MAX 0x1
#define R_NETWORK_TR_CTRL__cancel__MAX 0x1
#define R_NETWORK_TR_CTRL__cd__MAX 0x1
#define R_NETWORK_TR_CTRL__retry__MAX 0x1
#define R_NETWORK_TR_CTRL__pad__MAX 0x1
#define R_NETWORK_TR_CTRL__crc__MAX 0x1

#define R_NETWORK_TR_CTRL__clr_error__MIN 0
#define R_NETWORK_TR_CTRL__delay__MIN 0
#define R_NETWORK_TR_CTRL__cancel__MIN 0
#define R_NETWORK_TR_CTRL__cd__MIN 0
#define R_NETWORK_TR_CTRL__retry__MIN 0
#define R_NETWORK_TR_CTRL__pad__MIN 0
#define R_NETWORK_TR_CTRL__crc__MIN 0

#define R_NETWORK_TR_CTRL__clr_error__BITNR 8
#define R_NETWORK_TR_CTRL__delay__BITNR 5
#define R_NETWORK_TR_CTRL__cancel__BITNR 4
#define R_NETWORK_TR_CTRL__cd__BITNR 3
#define R_NETWORK_TR_CTRL__retry__BITNR 2
#define R_NETWORK_TR_CTRL__pad__BITNR 1
#define R_NETWORK_TR_CTRL__crc__BITNR 0

#define R_NETWORK_TR_CTRL__clr_error__clr_error__VAL REG_VAL_ENUM
#define R_NETWORK_TR_CTRL__delay__delay__VAL REG_VAL_ENUM
#define R_NETWORK_TR_CTRL__cancel__cancel__VAL REG_VAL_ENUM
#define R_NETWORK_TR_CTRL__cd__cd__VAL REG_VAL_ENUM
#define R_NETWORK_TR_CTRL__retry__retry__VAL REG_VAL_ENUM
#define R_NETWORK_TR_CTRL__pad__pad__VAL REG_VAL_ENUM
#define R_NETWORK_TR_CTRL__crc__crc__VAL REG_VAL_ENUM

#define R_NETWORK_TR_CTRL__clr_error__clr_error__clr 1
#define R_NETWORK_TR_CTRL__clr_error__clr_error__nop 0
#define R_NETWORK_TR_CTRL__delay__delay__d2us 1
#define R_NETWORK_TR_CTRL__delay__delay__none 0
#define R_NETWORK_TR_CTRL__cancel__cancel__do 1
#define R_NETWORK_TR_CTRL__cancel__cancel__dont 0
#define R_NETWORK_TR_CTRL__cd__cd__ack_col 0
#define R_NETWORK_TR_CTRL__cd__cd__ack_crs 1
#define R_NETWORK_TR_CTRL__cd__cd__disable 1
#define R_NETWORK_TR_CTRL__cd__cd__enable 0
#define R_NETWORK_TR_CTRL__retry__retry__disable 1
#define R_NETWORK_TR_CTRL__retry__retry__enable 0
#define R_NETWORK_TR_CTRL__pad__pad__disable 0
#define R_NETWORK_TR_CTRL__pad__pad__enable 1
#define R_NETWORK_TR_CTRL__crc__crc__disable 1
#define R_NETWORK_TR_CTRL__crc__crc__enable 0

#endif

/*
 *  R_PAR0_CONFIG
 *  - type:  WO
 *  - addr:  0xb0000044
 *  - group: Parallel printer port registers
 */

#if USE_GROUP__Parallel_printer_port_registers

#define R_PAR0_CONFIG__ADDR      (REG_TYPECAST_UDWORD  0xb0000044)

#ifndef REG_NO_SHADOW
#define R_PAR0_CONFIG__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_ATA_CONFIG + 0))
#define R_PAR0_CONFIG__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_ATA_CONFIG + 0))
#else /* REG_NO_SHADOW */
#define R_PAR0_CONFIG__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_PAR0_CONFIG__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_PAR0_CONFIG__STYPECAST REG_STYPECAST_UDWORD
#define R_PAR0_CONFIG__SVAL      REG_SVAL_SHADOW
#define R_PAR0_CONFIG__SVAL_I    REG_SVAL_I_SHADOW
#define R_PAR0_CONFIG__TYPECAST  REG_TYPECAST_UDWORD
#define R_PAR0_CONFIG__TYPE      (REG_UDWORD)
#define R_PAR0_CONFIG__GET       REG_GET_WO
#define R_PAR0_CONFIG__IGET      REG_IGET_WO
#define R_PAR0_CONFIG__SET       REG_SET_WO
#define R_PAR0_CONFIG__ISET      REG_ISET_WO
#define R_PAR0_CONFIG__SET_VAL   REG_SET_VAL_WO
#define R_PAR0_CONFIG__EQL       REG_EQL_WO
#define R_PAR0_CONFIG__IEQL      REG_IEQL_WO
#define R_PAR0_CONFIG__RD        REG_RD_WO
#define R_PAR0_CONFIG__IRD       REG_IRD_WO
#define R_PAR0_CONFIG__WR        REG_WR_WO
#define R_PAR0_CONFIG__IWR       REG_IWR_WO

#define R_PAR0_CONFIG__WRITE(addr,value) \
  (*(addr) = (value))

/* From control-file '/n/asic/projects/etrax_ng/include//hwregs.ctrl' */
#define R_PAR0_CONFIG__FIRST 0
#define R_PAR0_CONFIG__IOFFSET 12
#define R_PAR0_CONFIG__LAST 1
#define R_PAR0_CONFIG__OFFSET 16
#define R_PAR0_CONFIG__SOFFSET 12
/* end */

#define R_PAR0_CONFIG__ioe__ioe__MASK 0x02000000U
#define R_PAR0_CONFIG__iseli__iseli__MASK 0x01000000U
#define R_PAR0_CONFIG__iautofd__iautofd__MASK 0x00800000U
#define R_PAR0_CONFIG__istrb__istrb__MASK 0x00400000U
#define R_PAR0_CONFIG__iinit__iinit__MASK 0x00200000U
#define R_PAR0_CONFIG__iperr__iperr__MASK 0x00100000U
#define R_PAR0_CONFIG__iack__iack__MASK 0x00080000U
#define R_PAR0_CONFIG__ibusy__ibusy__MASK 0x00040000U
#define R_PAR0_CONFIG__ifault__ifault__MASK 0x00020000U
#define R_PAR0_CONFIG__isel__isel__MASK 0x00010000U
#define R_PAR0_CONFIG__ext_mode__ext_mode__MASK 0x00000800U
#define R_PAR0_CONFIG__wide__wide__MASK 0x00000400U
#define R_PAR0_CONFIG__dma__dma__MASK 0x00000200U
#define R_PAR0_CONFIG__rle_in__rle_in__MASK 0x00000100U
#define R_PAR0_CONFIG__rle_out__rle_out__MASK 0x00000080U
#define R_PAR0_CONFIG__enable__enable__MASK 0x00000040U
#define R_PAR0_CONFIG__force__force__MASK 0x00000020U
#define R_PAR0_CONFIG__ign_ack__ign_ack__MASK 0x00000010U
#define R_PAR0_CONFIG__oe_ack__oe_ack__MASK 0x00000008U
#define R_PAR0_CONFIG__epp_addr_data__epp_addr_data__MASK 0x00000008U
#define R_PAR0_CONFIG__oe_ack__epp_addr_data__MASK 0x00000008U
#define R_PAR0_CONFIG__mode__mode__MASK 0x00000007U

#define R_PAR0_CONFIG__ioe__MAX 0x1
#define R_PAR0_CONFIG__iseli__MAX 0x1
#define R_PAR0_CONFIG__iautofd__MAX 0x1
#define R_PAR0_CONFIG__istrb__MAX 0x1
#define R_PAR0_CONFIG__iinit__MAX 0x1
#define R_PAR0_CONFIG__iperr__MAX 0x1
#define R_PAR0_CONFIG__iack__MAX 0x1
#define R_PAR0_CONFIG__ibusy__MAX 0x1
#define R_PAR0_CONFIG__ifault__MAX 0x1
#define R_PAR0_CONFIG__isel__MAX 0x1
#define R_PAR0_CONFIG__ext_mode__MAX 0x1
#define R_PAR0_CONFIG__wide__MAX 0x1
#define R_PAR0_CONFIG__dma__MAX 0x1
#define R_PAR0_CONFIG__rle_in__MAX 0x1
#define R_PAR0_CONFIG__rle_out__MAX 0x1
#define R_PAR0_CONFIG__enable__MAX 0x1
#define R_PAR0_CONFIG__force__MAX 0x1
#define R_PAR0_CONFIG__ign_ack__MAX 0x1
#define R_PAR0_CONFIG__oe_ack__MAX 0x1
#define R_PAR0_CONFIG__epp_addr_data__MAX 0x1
#define R_PAR0_CONFIG__mode__MAX 0x7

#define R_PAR0_CONFIG__ioe__MIN 0
#define R_PAR0_CONFIG__iseli__MIN 0
#define R_PAR0_CONFIG__iautofd__MIN 0
#define R_PAR0_CONFIG__istrb__MIN 0
#define R_PAR0_CONFIG__iinit__MIN 0
#define R_PAR0_CONFIG__iperr__MIN 0
#define R_PAR0_CONFIG__iack__MIN 0
#define R_PAR0_CONFIG__ibusy__MIN 0
#define R_PAR0_CONFIG__ifault__MIN 0
#define R_PAR0_CONFIG__isel__MIN 0
#define R_PAR0_CONFIG__ext_mode__MIN 0
#define R_PAR0_CONFIG__wide__MIN 0
#define R_PAR0_CONFIG__dma__MIN 0
#define R_PAR0_CONFIG__rle_in__MIN 0
#define R_PAR0_CONFIG__rle_out__MIN 0
#define R_PAR0_CONFIG__enable__MIN 0
#define R_PAR0_CONFIG__force__MIN 0
#define R_PAR0_CONFIG__ign_ack__MIN 0
#define R_PAR0_CONFIG__oe_ack__MIN 0
#define R_PAR0_CONFIG__epp_addr_data__MIN 0
#define R_PAR0_CONFIG__mode__MIN 0

#define R_PAR0_CONFIG__ioe__BITNR 25
#define R_PAR0_CONFIG__iseli__BITNR 24
#define R_PAR0_CONFIG__iautofd__BITNR 23
#define R_PAR0_CONFIG__istrb__BITNR 22
#define R_PAR0_CONFIG__iinit__BITNR 21
#define R_PAR0_CONFIG__iperr__BITNR 20
#define R_PAR0_CONFIG__iack__BITNR 19
#define R_PAR0_CONFIG__ibusy__BITNR 18
#define R_PAR0_CONFIG__ifault__BITNR 17
#define R_PAR0_CONFIG__isel__BITNR 16
#define R_PAR0_CONFIG__ext_mode__BITNR 11
#define R_PAR0_CONFIG__wide__BITNR 10
#define R_PAR0_CONFIG__dma__BITNR 9
#define R_PAR0_CONFIG__rle_in__BITNR 8
#define R_PAR0_CONFIG__rle_out__BITNR 7
#define R_PAR0_CONFIG__enable__BITNR 6
#define R_PAR0_CONFIG__force__BITNR 5
#define R_PAR0_CONFIG__ign_ack__BITNR 4
#define R_PAR0_CONFIG__oe_ack__BITNR 3
#define R_PAR0_CONFIG__epp_addr_data__BITNR 3
#define R_PAR0_CONFIG__mode__BITNR 0

#define R_PAR0_CONFIG__ioe__ioe__VAL REG_VAL_ENUM
#define R_PAR0_CONFIG__iseli__iseli__VAL REG_VAL_ENUM
#define R_PAR0_CONFIG__iautofd__iautofd__VAL REG_VAL_ENUM
#define R_PAR0_CONFIG__istrb__istrb__VAL REG_VAL_ENUM
#define R_PAR0_CONFIG__iinit__iinit__VAL REG_VAL_ENUM
#define R_PAR0_CONFIG__iperr__iperr__VAL REG_VAL_ENUM
#define R_PAR0_CONFIG__iack__iack__VAL REG_VAL_ENUM
#define R_PAR0_CONFIG__ibusy__ibusy__VAL REG_VAL_ENUM
#define R_PAR0_CONFIG__ifault__ifault__VAL REG_VAL_ENUM
#define R_PAR0_CONFIG__isel__isel__VAL REG_VAL_ENUM
#define R_PAR0_CONFIG__ext_mode__ext_mode__VAL REG_VAL_ENUM
#define R_PAR0_CONFIG__wide__wide__VAL REG_VAL_ENUM
#define R_PAR0_CONFIG__dma__dma__VAL REG_VAL_ENUM
#define R_PAR0_CONFIG__rle_in__rle_in__VAL REG_VAL_ENUM
#define R_PAR0_CONFIG__rle_out__rle_out__VAL REG_VAL_ENUM
#define R_PAR0_CONFIG__enable__enable__VAL REG_VAL_ENUM
#define R_PAR0_CONFIG__force__force__VAL REG_VAL_ENUM
#define R_PAR0_CONFIG__ign_ack__ign_ack__VAL REG_VAL_ENUM
#define R_PAR0_CONFIG__oe_ack__oe_ack__VAL REG_VAL_ENUM
#define R_PAR0_CONFIG__epp_addr_data__epp_addr_data__VAL REG_VAL_ENUM
#define R_PAR0_CONFIG__oe_ack__epp_addr_data__VAL REG_VAL_ENUM
#define R_PAR0_CONFIG__mode__mode__VAL REG_VAL_ENUM

#define R_PAR0_CONFIG__ioe__ioe__inv 1
#define R_PAR0_CONFIG__ioe__ioe__noninv 0
#define R_PAR0_CONFIG__iseli__iseli__inv 1
#define R_PAR0_CONFIG__iseli__iseli__noninv 0
#define R_PAR0_CONFIG__iautofd__iautofd__inv 1
#define R_PAR0_CONFIG__iautofd__iautofd__noninv 0
#define R_PAR0_CONFIG__istrb__istrb__inv 1
#define R_PAR0_CONFIG__istrb__istrb__noninv 0
#define R_PAR0_CONFIG__iinit__iinit__inv 1
#define R_PAR0_CONFIG__iinit__iinit__noninv 0
#define R_PAR0_CONFIG__iperr__iperr__inv 1
#define R_PAR0_CONFIG__iperr__iperr__noninv 0
#define R_PAR0_CONFIG__iack__iack__inv 1
#define R_PAR0_CONFIG__iack__iack__noninv 0
#define R_PAR0_CONFIG__ibusy__ibusy__inv 1
#define R_PAR0_CONFIG__ibusy__ibusy__noninv 0
#define R_PAR0_CONFIG__ifault__ifault__inv 1
#define R_PAR0_CONFIG__ifault__ifault__noninv 0
#define R_PAR0_CONFIG__isel__isel__inv 1
#define R_PAR0_CONFIG__isel__isel__noninv 0
#define R_PAR0_CONFIG__ext_mode__ext_mode__disable 0
#define R_PAR0_CONFIG__ext_mode__ext_mode__enable 1
#define R_PAR0_CONFIG__wide__wide__disable 0
#define R_PAR0_CONFIG__wide__wide__enable 1
#define R_PAR0_CONFIG__dma__dma__disable 0
#define R_PAR0_CONFIG__dma__dma__enable 1
#define R_PAR0_CONFIG__rle_in__rle_in__disable 0
#define R_PAR0_CONFIG__rle_in__rle_in__enable 1
#define R_PAR0_CONFIG__rle_out__rle_out__disable 0
#define R_PAR0_CONFIG__rle_out__rle_out__enable 1
#define R_PAR0_CONFIG__enable__enable__on 1
#define R_PAR0_CONFIG__enable__enable__reset 0
#define R_PAR0_CONFIG__force__force__off 0
#define R_PAR0_CONFIG__force__force__on 1
#define R_PAR0_CONFIG__ign_ack__ign_ack__ignore 1
#define R_PAR0_CONFIG__ign_ack__ign_ack__wait 0
#define R_PAR0_CONFIG__oe_ack__oe_ack__dont_wait 0
#define R_PAR0_CONFIG__oe_ack__oe_ack__epp_addr 1
#define R_PAR0_CONFIG__oe_ack__oe_ack__epp_data 0
#define R_PAR0_CONFIG__oe_ack__oe_ack__wait_oe 1
#define R_PAR0_CONFIG__epp_addr_data__epp_addr_data__dont_wait 0
#define R_PAR0_CONFIG__epp_addr_data__epp_addr_data__epp_addr 1
#define R_PAR0_CONFIG__epp_addr_data__epp_addr_data__epp_data 0
#define R_PAR0_CONFIG__epp_addr_data__epp_addr_data__wait_oe 1
#define R_PAR0_CONFIG__mode__mode__byte 4
#define R_PAR0_CONFIG__mode__mode__centronics 1
#define R_PAR0_CONFIG__mode__mode__ecp_fwd 5
#define R_PAR0_CONFIG__mode__mode__ecp_rev 6
#define R_PAR0_CONFIG__mode__mode__epp_rd 0
#define R_PAR0_CONFIG__mode__mode__epp_wr1 5
#define R_PAR0_CONFIG__mode__mode__epp_wr2 6
#define R_PAR0_CONFIG__mode__mode__epp_wr3 7
#define R_PAR0_CONFIG__mode__mode__fastbyte 2
#define R_PAR0_CONFIG__mode__mode__manual 0
#define R_PAR0_CONFIG__mode__mode__nibble 3
#define R_PAR0_CONFIG__mode__mode__off 7

#endif

/*
 *  R_PAR0_CTRL
 *  - type:  WO
 *  - addr:  0xb0000042
 *  - group: Parallel printer port registers
 */

#if USE_GROUP__Parallel_printer_port_registers

#define R_PAR0_CTRL__ADDR      (REG_TYPECAST_BYTE  0xb0000042)

#ifndef REG_NO_SHADOW
#define R_PAR0_CTRL__SADDR     (REG_STYPECAST_BYTE (reg_shadow__hwregs.R_ATA_CTRL_DATA + 2))
#define R_PAR0_CTRL__IADDR     (REG_STYPECAST_BYTE (reg_initiated__hwregs.R_ATA_CTRL_DATA + 2))
#else /* REG_NO_SHADOW */
#define R_PAR0_CTRL__SADDR     (REG_STYPECAST_BYTE (&reg_shadow__hwregs))
#define R_PAR0_CTRL__IADDR     (REG_STYPECAST_BYTE (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_PAR0_CTRL__STYPECAST REG_STYPECAST_BYTE
#define R_PAR0_CTRL__SVAL      REG_SVAL_SHADOW
#define R_PAR0_CTRL__SVAL_I    REG_SVAL_I_SHADOW
#define R_PAR0_CTRL__TYPECAST  REG_TYPECAST_BYTE
#define R_PAR0_CTRL__TYPE      (REG_BYTE)
#define R_PAR0_CTRL__GET       REG_GET_WO
#define R_PAR0_CTRL__IGET      REG_IGET_WO
#define R_PAR0_CTRL__SET       REG_SET_WO
#define R_PAR0_CTRL__ISET      REG_ISET_WO
#define R_PAR0_CTRL__SET_VAL   REG_SET_VAL_WO
#define R_PAR0_CTRL__EQL       REG_EQL_WO
#define R_PAR0_CTRL__IEQL      REG_IEQL_WO
#define R_PAR0_CTRL__RD        REG_RD_WO
#define R_PAR0_CTRL__IRD       REG_IRD_WO
#define R_PAR0_CTRL__WR        REG_WR_WO
#define R_PAR0_CTRL__IWR       REG_IWR_WO

#define R_PAR0_CTRL__WRITE(addr,value) \
  (*(addr) = (value))

/* From control-file '/n/asic/projects/etrax_ng/include//hwregs.ctrl' */
#define R_PAR0_CTRL__FIRST 0
#define R_PAR0_CTRL__IOFFSET 12
#define R_PAR0_CTRL__LAST 1
#define R_PAR0_CTRL__OFFSET 16
#define R_PAR0_CTRL__SOFFSET 12
/* end */

#define R_PAR0_CTRL__ctrl__ctrl__MASK 0x0000001fU

#define R_PAR0_CTRL__ctrl__MAX 31

#define R_PAR0_CTRL__ctrl__MIN 0

#define R_PAR0_CTRL__ctrl__BITNR 0

#define R_PAR0_CTRL__ctrl__ctrl__VAL REG_VAL_VAL


#endif

/*
 *  R_PAR0_CTRL_DATA
 *  - type:  WO
 *  - addr:  0xb0000040
 *  - group: Parallel printer port registers
 */

#if USE_GROUP__Parallel_printer_port_registers

#define R_PAR0_CTRL_DATA__ADDR      (REG_TYPECAST_UDWORD  0xb0000040)

#ifndef REG_NO_SHADOW
#define R_PAR0_CTRL_DATA__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_ATA_CTRL_DATA + 0))
#define R_PAR0_CTRL_DATA__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_ATA_CTRL_DATA + 0))
#else /* REG_NO_SHADOW */
#define R_PAR0_CTRL_DATA__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_PAR0_CTRL_DATA__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_PAR0_CTRL_DATA__STYPECAST REG_STYPECAST_UDWORD
#define R_PAR0_CTRL_DATA__SVAL      REG_SVAL_SHADOW
#define R_PAR0_CTRL_DATA__SVAL_I    REG_SVAL_I_SHADOW
#define R_PAR0_CTRL_DATA__TYPECAST  REG_TYPECAST_UDWORD
#define R_PAR0_CTRL_DATA__TYPE      (REG_UDWORD)
#define R_PAR0_CTRL_DATA__GET       REG_GET_WO
#define R_PAR0_CTRL_DATA__IGET      REG_IGET_WO
#define R_PAR0_CTRL_DATA__SET       REG_SET_WO
#define R_PAR0_CTRL_DATA__ISET      REG_ISET_WO
#define R_PAR0_CTRL_DATA__SET_VAL   REG_SET_VAL_WO
#define R_PAR0_CTRL_DATA__EQL       REG_EQL_WO
#define R_PAR0_CTRL_DATA__IEQL      REG_IEQL_WO
#define R_PAR0_CTRL_DATA__RD        REG_RD_WO
#define R_PAR0_CTRL_DATA__IRD       REG_IRD_WO
#define R_PAR0_CTRL_DATA__WR        REG_WR_WO
#define R_PAR0_CTRL_DATA__IWR       REG_IWR_WO

#define R_PAR0_CTRL_DATA__WRITE(addr,value) \
  (*(addr) = (value))

/* From control-file '/n/asic/projects/etrax_ng/include//hwregs.ctrl' */
#define R_PAR0_CTRL_DATA__FIRST 0
#define R_PAR0_CTRL_DATA__IOFFSET 12
#define R_PAR0_CTRL_DATA__LAST 1
#define R_PAR0_CTRL_DATA__OFFSET 16
#define R_PAR0_CTRL_DATA__SOFFSET 12
/* end */

#define R_PAR0_CTRL_DATA__peri_int__peri_int__MASK 0x01000000U
#define R_PAR0_CTRL_DATA__oe__oe__MASK 0x00100000U
#define R_PAR0_CTRL_DATA__seli__seli__MASK 0x00080000U
#define R_PAR0_CTRL_DATA__autofd__autofd__MASK 0x00040000U
#define R_PAR0_CTRL_DATA__strb__strb__MASK 0x00020000U
#define R_PAR0_CTRL_DATA__init__init__MASK 0x00010000U
#define R_PAR0_CTRL_DATA__ecp_cmd__ecp_cmd__MASK 0x00000100U
#define R_PAR0_CTRL_DATA__data__data__MASK 0x000000ffU

#define R_PAR0_CTRL_DATA__peri_int__MAX 0x1
#define R_PAR0_CTRL_DATA__oe__MAX 0x1
#define R_PAR0_CTRL_DATA__seli__MAX 0x1
#define R_PAR0_CTRL_DATA__autofd__MAX 0x1
#define R_PAR0_CTRL_DATA__strb__MAX 0x1
#define R_PAR0_CTRL_DATA__init__MAX 0x1
#define R_PAR0_CTRL_DATA__ecp_cmd__MAX 0x1
#define R_PAR0_CTRL_DATA__data__MAX 0xff

#define R_PAR0_CTRL_DATA__peri_int__MIN 0
#define R_PAR0_CTRL_DATA__oe__MIN 0
#define R_PAR0_CTRL_DATA__seli__MIN 0
#define R_PAR0_CTRL_DATA__autofd__MIN 0
#define R_PAR0_CTRL_DATA__strb__MIN 0
#define R_PAR0_CTRL_DATA__init__MIN 0
#define R_PAR0_CTRL_DATA__ecp_cmd__MIN 0
#define R_PAR0_CTRL_DATA__data__MIN 0

#define R_PAR0_CTRL_DATA__peri_int__BITNR 24
#define R_PAR0_CTRL_DATA__oe__BITNR 20
#define R_PAR0_CTRL_DATA__seli__BITNR 19
#define R_PAR0_CTRL_DATA__autofd__BITNR 18
#define R_PAR0_CTRL_DATA__strb__BITNR 17
#define R_PAR0_CTRL_DATA__init__BITNR 16
#define R_PAR0_CTRL_DATA__ecp_cmd__BITNR 8
#define R_PAR0_CTRL_DATA__data__BITNR 0

#define R_PAR0_CTRL_DATA__peri_int__peri_int__VAL REG_VAL_ENUM
#define R_PAR0_CTRL_DATA__oe__oe__VAL REG_VAL_ENUM
#define R_PAR0_CTRL_DATA__seli__seli__VAL REG_VAL_ENUM
#define R_PAR0_CTRL_DATA__autofd__autofd__VAL REG_VAL_ENUM
#define R_PAR0_CTRL_DATA__strb__strb__VAL REG_VAL_ENUM
#define R_PAR0_CTRL_DATA__init__init__VAL REG_VAL_ENUM
#define R_PAR0_CTRL_DATA__ecp_cmd__ecp_cmd__VAL REG_VAL_ENUM
#define R_PAR0_CTRL_DATA__data__data__VAL REG_VAL_VAL

#define R_PAR0_CTRL_DATA__peri_int__peri_int__ack 1
#define R_PAR0_CTRL_DATA__peri_int__peri_int__nop 0
#define R_PAR0_CTRL_DATA__oe__oe__disable 0
#define R_PAR0_CTRL_DATA__oe__oe__enable 1
#define R_PAR0_CTRL_DATA__seli__seli__active 1
#define R_PAR0_CTRL_DATA__seli__seli__inactive 0
#define R_PAR0_CTRL_DATA__autofd__autofd__active 1
#define R_PAR0_CTRL_DATA__autofd__autofd__inactive 0
#define R_PAR0_CTRL_DATA__strb__strb__active 1
#define R_PAR0_CTRL_DATA__strb__strb__inactive 0
#define R_PAR0_CTRL_DATA__init__init__active 1
#define R_PAR0_CTRL_DATA__init__init__inactive 0
#define R_PAR0_CTRL_DATA__ecp_cmd__ecp_cmd__command 1
#define R_PAR0_CTRL_DATA__ecp_cmd__ecp_cmd__data 0

#endif

/*
 *  R_PAR0_DELAY
 *  - type:  WO
 *  - addr:  0xb0000048
 *  - group: Parallel printer port registers
 */

#if USE_GROUP__Parallel_printer_port_registers

#define R_PAR0_DELAY__ADDR      (REG_TYPECAST_UDWORD  0xb0000048)

#ifndef REG_NO_SHADOW
#define R_PAR0_DELAY__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_PAR0_DELAY + 0))
#define R_PAR0_DELAY__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_PAR0_DELAY + 0))
#else /* REG_NO_SHADOW */
#define R_PAR0_DELAY__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_PAR0_DELAY__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_PAR0_DELAY__STYPECAST REG_STYPECAST_UDWORD
#define R_PAR0_DELAY__SVAL      REG_SVAL_SHADOW
#define R_PAR0_DELAY__SVAL_I    REG_SVAL_I_SHADOW
#define R_PAR0_DELAY__TYPECAST  REG_TYPECAST_UDWORD
#define R_PAR0_DELAY__TYPE      (REG_UDWORD)
#define R_PAR0_DELAY__GET       REG_GET_WO
#define R_PAR0_DELAY__IGET      REG_IGET_WO
#define R_PAR0_DELAY__SET       REG_SET_WO
#define R_PAR0_DELAY__ISET      REG_ISET_WO
#define R_PAR0_DELAY__SET_VAL   REG_SET_VAL_WO
#define R_PAR0_DELAY__EQL       REG_EQL_WO
#define R_PAR0_DELAY__IEQL      REG_IEQL_WO
#define R_PAR0_DELAY__RD        REG_RD_WO
#define R_PAR0_DELAY__IRD       REG_IRD_WO
#define R_PAR0_DELAY__WR        REG_WR_WO
#define R_PAR0_DELAY__IWR       REG_IWR_WO

#define R_PAR0_DELAY__WRITE(addr,value) \
  (*(addr) = (value))

/* From control-file '/n/asic/projects/etrax_ng/include//hwregs.ctrl' */
#define R_PAR0_DELAY__FIRST 0
#define R_PAR0_DELAY__IOFFSET 12
#define R_PAR0_DELAY__LAST 1
#define R_PAR0_DELAY__OFFSET 16
#define R_PAR0_DELAY__SOFFSET 12
/* end */

#define R_PAR0_DELAY__fine_hold__fine_hold__MASK 0x00e00000U
#define R_PAR0_DELAY__hold__hold__MASK 0x001f0000U
#define R_PAR0_DELAY__fine_strb__fine_strb__MASK 0x0000e000U
#define R_PAR0_DELAY__strobe__strobe__MASK 0x00001f00U
#define R_PAR0_DELAY__fine_setup__fine_setup__MASK 0x000000e0U
#define R_PAR0_DELAY__setup__setup__MASK 0x0000001fU

#define R_PAR0_DELAY__fine_hold__MAX 0x7
#define R_PAR0_DELAY__hold__MAX 0x1f
#define R_PAR0_DELAY__fine_strb__MAX 0x7
#define R_PAR0_DELAY__strobe__MAX 0x1f
#define R_PAR0_DELAY__fine_setup__MAX 0x7
#define R_PAR0_DELAY__setup__MAX 0x1f

#define R_PAR0_DELAY__fine_hold__MIN 0
#define R_PAR0_DELAY__hold__MIN 0
#define R_PAR0_DELAY__fine_strb__MIN 0
#define R_PAR0_DELAY__strobe__MIN 0
#define R_PAR0_DELAY__fine_setup__MIN 0
#define R_PAR0_DELAY__setup__MIN 0

#define R_PAR0_DELAY__fine_hold__BITNR 21
#define R_PAR0_DELAY__hold__BITNR 16
#define R_PAR0_DELAY__fine_strb__BITNR 13
#define R_PAR0_DELAY__strobe__BITNR 8
#define R_PAR0_DELAY__fine_setup__BITNR 5
#define R_PAR0_DELAY__setup__BITNR 0

#define R_PAR0_DELAY__fine_hold__fine_hold__VAL REG_VAL_VAL
#define R_PAR0_DELAY__hold__hold__VAL REG_VAL_VAL
#define R_PAR0_DELAY__fine_strb__fine_strb__VAL REG_VAL_VAL
#define R_PAR0_DELAY__strobe__strobe__VAL REG_VAL_VAL
#define R_PAR0_DELAY__fine_setup__fine_setup__VAL REG_VAL_VAL
#define R_PAR0_DELAY__setup__setup__VAL REG_VAL_VAL


#endif

/*
 *  R_PAR0_STATUS
 *  - type:  RO
 *  - addr:  0xb0000042
 *  - group: Parallel printer port registers
 */

#if USE_GROUP__Parallel_printer_port_registers

#define R_PAR0_STATUS__ADDR      (REG_TYPECAST_UWORD  0xb0000042)
#define R_PAR0_STATUS__SVAL      REG_SVAL_SHADOW
#define R_PAR0_STATUS__SVAL_I    REG_SVAL_I_SHADOW
#define R_PAR0_STATUS__TYPECAST  REG_TYPECAST_UWORD
#define R_PAR0_STATUS__TYPE      (REG_UWORD)
#define R_PAR0_STATUS__GET       REG_GET_RO
#define R_PAR0_STATUS__IGET      REG_IGET_RO
#define R_PAR0_STATUS__SET       REG_SET_RO
#define R_PAR0_STATUS__ISET      REG_ISET_RO
#define R_PAR0_STATUS__SET_VAL   REG_SET_VAL_RO
#define R_PAR0_STATUS__EQL       REG_EQL_RO
#define R_PAR0_STATUS__IEQL      REG_IEQL_RO
#define R_PAR0_STATUS__RD        REG_RD_RO
#define R_PAR0_STATUS__IRD       REG_IRD_RO
#define R_PAR0_STATUS__WR        REG_WR_RO
#define R_PAR0_STATUS__IWR       REG_IWR_RO

#define R_PAR0_STATUS__READ(addr) \
  (*(addr))

#define R_PAR0_STATUS__mode__mode__MASK 0x0000e000U
#define R_PAR0_STATUS__perr__perr__MASK 0x00001000U
#define R_PAR0_STATUS__ack__ack__MASK 0x00000800U
#define R_PAR0_STATUS__busy__busy__MASK 0x00000400U
#define R_PAR0_STATUS__fault__fault__MASK 0x00000200U
#define R_PAR0_STATUS__sel__sel__MASK 0x00000100U
#define R_PAR0_STATUS__ext_mode__ext_mode__MASK 0x00000080U
#define R_PAR0_STATUS__ecp_16__ecp_16__MASK 0x00000040U
#define R_PAR0_STATUS__tr_rdy__tr_rdy__MASK 0x00000002U
#define R_PAR0_STATUS__dav__dav__MASK 0x00000001U

#define R_PAR0_STATUS__mode__MAX 0x7
#define R_PAR0_STATUS__perr__MAX 0x1
#define R_PAR0_STATUS__ack__MAX 0x1
#define R_PAR0_STATUS__busy__MAX 0x1
#define R_PAR0_STATUS__fault__MAX 0x1
#define R_PAR0_STATUS__sel__MAX 0x1
#define R_PAR0_STATUS__ext_mode__MAX 0x1
#define R_PAR0_STATUS__ecp_16__MAX 0x1
#define R_PAR0_STATUS__tr_rdy__MAX 0x1
#define R_PAR0_STATUS__dav__MAX 0x1

#define R_PAR0_STATUS__mode__MIN 0
#define R_PAR0_STATUS__perr__MIN 0
#define R_PAR0_STATUS__ack__MIN 0
#define R_PAR0_STATUS__busy__MIN 0
#define R_PAR0_STATUS__fault__MIN 0
#define R_PAR0_STATUS__sel__MIN 0
#define R_PAR0_STATUS__ext_mode__MIN 0
#define R_PAR0_STATUS__ecp_16__MIN 0
#define R_PAR0_STATUS__tr_rdy__MIN 0
#define R_PAR0_STATUS__dav__MIN 0

#define R_PAR0_STATUS__mode__BITNR 13
#define R_PAR0_STATUS__perr__BITNR 12
#define R_PAR0_STATUS__ack__BITNR 11
#define R_PAR0_STATUS__busy__BITNR 10
#define R_PAR0_STATUS__fault__BITNR 9
#define R_PAR0_STATUS__sel__BITNR 8
#define R_PAR0_STATUS__ext_mode__BITNR 7
#define R_PAR0_STATUS__ecp_16__BITNR 6
#define R_PAR0_STATUS__tr_rdy__BITNR 1
#define R_PAR0_STATUS__dav__BITNR 0

#define R_PAR0_STATUS__mode__mode__VAL REG_VAL_ENUM
#define R_PAR0_STATUS__perr__perr__VAL REG_VAL_ENUM
#define R_PAR0_STATUS__ack__ack__VAL REG_VAL_ENUM
#define R_PAR0_STATUS__busy__busy__VAL REG_VAL_ENUM
#define R_PAR0_STATUS__fault__fault__VAL REG_VAL_ENUM
#define R_PAR0_STATUS__sel__sel__VAL REG_VAL_ENUM
#define R_PAR0_STATUS__ext_mode__ext_mode__VAL REG_VAL_ENUM
#define R_PAR0_STATUS__ecp_16__ecp_16__VAL REG_VAL_ENUM
#define R_PAR0_STATUS__tr_rdy__tr_rdy__VAL REG_VAL_ENUM
#define R_PAR0_STATUS__dav__dav__VAL REG_VAL_ENUM

#define R_PAR0_STATUS__mode__mode__byte 4
#define R_PAR0_STATUS__mode__mode__centronics 1
#define R_PAR0_STATUS__mode__mode__ecp_fwd 5
#define R_PAR0_STATUS__mode__mode__ecp_rev 6
#define R_PAR0_STATUS__mode__mode__epp_rd 0
#define R_PAR0_STATUS__mode__mode__epp_wr1 5
#define R_PAR0_STATUS__mode__mode__epp_wr2 6
#define R_PAR0_STATUS__mode__mode__epp_wr3 7
#define R_PAR0_STATUS__mode__mode__fastbyte 2
#define R_PAR0_STATUS__mode__mode__manual 0
#define R_PAR0_STATUS__mode__mode__nibble 3
#define R_PAR0_STATUS__mode__mode__off 7
#define R_PAR0_STATUS__perr__perr__active 1
#define R_PAR0_STATUS__perr__perr__inactive 0
#define R_PAR0_STATUS__ack__ack__active 0
#define R_PAR0_STATUS__ack__ack__inactive 1
#define R_PAR0_STATUS__busy__busy__active 1
#define R_PAR0_STATUS__busy__busy__inactive 0
#define R_PAR0_STATUS__fault__fault__active 0
#define R_PAR0_STATUS__fault__fault__inactive 1
#define R_PAR0_STATUS__sel__sel__active 1
#define R_PAR0_STATUS__sel__sel__inactive 0
#define R_PAR0_STATUS__ext_mode__ext_mode__disable 0
#define R_PAR0_STATUS__ext_mode__ext_mode__enable 1
#define R_PAR0_STATUS__ecp_16__ecp_16__active 1
#define R_PAR0_STATUS__ecp_16__ecp_16__inactive 0
#define R_PAR0_STATUS__tr_rdy__tr_rdy__busy 0
#define R_PAR0_STATUS__tr_rdy__tr_rdy__ready 1
#define R_PAR0_STATUS__dav__dav__data 1
#define R_PAR0_STATUS__dav__dav__nodata 0

#endif

/*
 *  R_PAR0_STATUS_DATA
 *  - type:  RO
 *  - addr:  0xb0000040
 *  - group: Parallel printer port registers
 */

#if USE_GROUP__Parallel_printer_port_registers

#define R_PAR0_STATUS_DATA__ADDR      (REG_TYPECAST_UDWORD  0xb0000040)
#define R_PAR0_STATUS_DATA__SVAL      REG_SVAL_SHADOW
#define R_PAR0_STATUS_DATA__SVAL_I    REG_SVAL_I_SHADOW
#define R_PAR0_STATUS_DATA__TYPECAST  REG_TYPECAST_UDWORD
#define R_PAR0_STATUS_DATA__TYPE      (REG_UDWORD)
#define R_PAR0_STATUS_DATA__GET       REG_GET_RO
#define R_PAR0_STATUS_DATA__IGET      REG_IGET_RO
#define R_PAR0_STATUS_DATA__SET       REG_SET_RO
#define R_PAR0_STATUS_DATA__ISET      REG_ISET_RO
#define R_PAR0_STATUS_DATA__SET_VAL   REG_SET_VAL_RO
#define R_PAR0_STATUS_DATA__EQL       REG_EQL_RO
#define R_PAR0_STATUS_DATA__IEQL      REG_IEQL_RO
#define R_PAR0_STATUS_DATA__RD        REG_RD_RO
#define R_PAR0_STATUS_DATA__IRD       REG_IRD_RO
#define R_PAR0_STATUS_DATA__WR        REG_WR_RO
#define R_PAR0_STATUS_DATA__IWR       REG_IWR_RO

#define R_PAR0_STATUS_DATA__READ(addr) \
  (*(addr))

/* From control-file '/n/asic/projects/etrax_ng/include//hwregs.ctrl' */
#define R_PAR0_STATUS_DATA__FIRST 0
#define R_PAR0_STATUS_DATA__LAST 1
#define R_PAR0_STATUS_DATA__OFFSET 16
/* end */

#define R_PAR0_STATUS_DATA__mode__mode__MASK 0xe0000000U
#define R_PAR0_STATUS_DATA__perr__perr__MASK 0x10000000U
#define R_PAR0_STATUS_DATA__ack__ack__MASK 0x08000000U
#define R_PAR0_STATUS_DATA__busy__busy__MASK 0x04000000U
#define R_PAR0_STATUS_DATA__fault__fault__MASK 0x02000000U
#define R_PAR0_STATUS_DATA__sel__sel__MASK 0x01000000U
#define R_PAR0_STATUS_DATA__ext_mode__ext_mode__MASK 0x00800000U
#define R_PAR0_STATUS_DATA__ecp_16__ecp_16__MASK 0x00400000U
#define R_PAR0_STATUS_DATA__tr_rdy__tr_rdy__MASK 0x00020000U
#define R_PAR0_STATUS_DATA__dav__dav__MASK 0x00010000U
#define R_PAR0_STATUS_DATA__ecp_cmd__ecp_cmd__MASK 0x00000100U
#define R_PAR0_STATUS_DATA__data__data__MASK 0x000000ffU

#define R_PAR0_STATUS_DATA__mode__MAX 0x7
#define R_PAR0_STATUS_DATA__perr__MAX 0x1
#define R_PAR0_STATUS_DATA__ack__MAX 0x1
#define R_PAR0_STATUS_DATA__busy__MAX 0x1
#define R_PAR0_STATUS_DATA__fault__MAX 0x1
#define R_PAR0_STATUS_DATA__sel__MAX 0x1
#define R_PAR0_STATUS_DATA__ext_mode__MAX 0x1
#define R_PAR0_STATUS_DATA__ecp_16__MAX 0x1
#define R_PAR0_STATUS_DATA__tr_rdy__MAX 0x1
#define R_PAR0_STATUS_DATA__dav__MAX 0x1
#define R_PAR0_STATUS_DATA__ecp_cmd__MAX 0x1
#define R_PAR0_STATUS_DATA__data__MAX 0xff

#define R_PAR0_STATUS_DATA__mode__MIN 0
#define R_PAR0_STATUS_DATA__perr__MIN 0
#define R_PAR0_STATUS_DATA__ack__MIN 0
#define R_PAR0_STATUS_DATA__busy__MIN 0
#define R_PAR0_STATUS_DATA__fault__MIN 0
#define R_PAR0_STATUS_DATA__sel__MIN 0
#define R_PAR0_STATUS_DATA__ext_mode__MIN 0
#define R_PAR0_STATUS_DATA__ecp_16__MIN 0
#define R_PAR0_STATUS_DATA__tr_rdy__MIN 0
#define R_PAR0_STATUS_DATA__dav__MIN 0
#define R_PAR0_STATUS_DATA__ecp_cmd__MIN 0
#define R_PAR0_STATUS_DATA__data__MIN 0

#define R_PAR0_STATUS_DATA__mode__BITNR 29
#define R_PAR0_STATUS_DATA__perr__BITNR 28
#define R_PAR0_STATUS_DATA__ack__BITNR 27
#define R_PAR0_STATUS_DATA__busy__BITNR 26
#define R_PAR0_STATUS_DATA__fault__BITNR 25
#define R_PAR0_STATUS_DATA__sel__BITNR 24
#define R_PAR0_STATUS_DATA__ext_mode__BITNR 23
#define R_PAR0_STATUS_DATA__ecp_16__BITNR 22
#define R_PAR0_STATUS_DATA__tr_rdy__BITNR 17
#define R_PAR0_STATUS_DATA__dav__BITNR 16
#define R_PAR0_STATUS_DATA__ecp_cmd__BITNR 8
#define R_PAR0_STATUS_DATA__data__BITNR 0

#define R_PAR0_STATUS_DATA__mode__mode__VAL REG_VAL_ENUM
#define R_PAR0_STATUS_DATA__perr__perr__VAL REG_VAL_ENUM
#define R_PAR0_STATUS_DATA__ack__ack__VAL REG_VAL_ENUM
#define R_PAR0_STATUS_DATA__busy__busy__VAL REG_VAL_ENUM
#define R_PAR0_STATUS_DATA__fault__fault__VAL REG_VAL_ENUM
#define R_PAR0_STATUS_DATA__sel__sel__VAL REG_VAL_ENUM
#define R_PAR0_STATUS_DATA__ext_mode__ext_mode__VAL REG_VAL_ENUM
#define R_PAR0_STATUS_DATA__ecp_16__ecp_16__VAL REG_VAL_ENUM
#define R_PAR0_STATUS_DATA__tr_rdy__tr_rdy__VAL REG_VAL_ENUM
#define R_PAR0_STATUS_DATA__dav__dav__VAL REG_VAL_ENUM
#define R_PAR0_STATUS_DATA__ecp_cmd__ecp_cmd__VAL REG_VAL_ENUM
#define R_PAR0_STATUS_DATA__data__data__VAL REG_VAL_VAL

#define R_PAR0_STATUS_DATA__mode__mode__byte 4
#define R_PAR0_STATUS_DATA__mode__mode__centronics 1
#define R_PAR0_STATUS_DATA__mode__mode__ecp_fwd 5
#define R_PAR0_STATUS_DATA__mode__mode__ecp_rev 6
#define R_PAR0_STATUS_DATA__mode__mode__epp_rd 0
#define R_PAR0_STATUS_DATA__mode__mode__epp_wr1 5
#define R_PAR0_STATUS_DATA__mode__mode__epp_wr2 6
#define R_PAR0_STATUS_DATA__mode__mode__epp_wr3 7
#define R_PAR0_STATUS_DATA__mode__mode__fastbyte 2
#define R_PAR0_STATUS_DATA__mode__mode__manual 0
#define R_PAR0_STATUS_DATA__mode__mode__nibble 3
#define R_PAR0_STATUS_DATA__mode__mode__off 7
#define R_PAR0_STATUS_DATA__perr__perr__active 1
#define R_PAR0_STATUS_DATA__perr__perr__inactive 0
#define R_PAR0_STATUS_DATA__ack__ack__active 0
#define R_PAR0_STATUS_DATA__ack__ack__inactive 1
#define R_PAR0_STATUS_DATA__busy__busy__active 1
#define R_PAR0_STATUS_DATA__busy__busy__inactive 0
#define R_PAR0_STATUS_DATA__fault__fault__active 0
#define R_PAR0_STATUS_DATA__fault__fault__inactive 1
#define R_PAR0_STATUS_DATA__sel__sel__active 1
#define R_PAR0_STATUS_DATA__sel__sel__inactive 0
#define R_PAR0_STATUS_DATA__ext_mode__ext_mode__disable 0
#define R_PAR0_STATUS_DATA__ext_mode__ext_mode__enable 1
#define R_PAR0_STATUS_DATA__ecp_16__ecp_16__active 1
#define R_PAR0_STATUS_DATA__ecp_16__ecp_16__inactive 0
#define R_PAR0_STATUS_DATA__tr_rdy__tr_rdy__busy 0
#define R_PAR0_STATUS_DATA__tr_rdy__tr_rdy__ready 1
#define R_PAR0_STATUS_DATA__dav__dav__data 1
#define R_PAR0_STATUS_DATA__dav__dav__nodata 0
#define R_PAR0_STATUS_DATA__ecp_cmd__ecp_cmd__command 1
#define R_PAR0_STATUS_DATA__ecp_cmd__ecp_cmd__data 0

#endif

/*
 *  R_PAR1_CONFIG
 *  - type:  WO
 *  - addr:  0xb0000054
 *  - group: Parallel printer port registers
 */

#if USE_GROUP__Parallel_printer_port_registers

#define R_PAR1_CONFIG__ADDR      (REG_TYPECAST_UDWORD  0xb0000054)

#ifndef REG_NO_SHADOW
#define R_PAR1_CONFIG__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_PAR1_CONFIG + 0))
#define R_PAR1_CONFIG__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_PAR1_CONFIG + 0))
#else /* REG_NO_SHADOW */
#define R_PAR1_CONFIG__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_PAR1_CONFIG__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_PAR1_CONFIG__STYPECAST REG_STYPECAST_UDWORD
#define R_PAR1_CONFIG__SVAL      REG_SVAL_SHADOW
#define R_PAR1_CONFIG__SVAL_I    REG_SVAL_I_SHADOW
#define R_PAR1_CONFIG__TYPECAST  REG_TYPECAST_UDWORD
#define R_PAR1_CONFIG__TYPE      (REG_UDWORD)
#define R_PAR1_CONFIG__GET       REG_GET_WO
#define R_PAR1_CONFIG__IGET      REG_IGET_WO
#define R_PAR1_CONFIG__SET       REG_SET_WO
#define R_PAR1_CONFIG__ISET      REG_ISET_WO
#define R_PAR1_CONFIG__SET_VAL   REG_SET_VAL_WO
#define R_PAR1_CONFIG__EQL       REG_EQL_WO
#define R_PAR1_CONFIG__IEQL      REG_IEQL_WO
#define R_PAR1_CONFIG__RD        REG_RD_WO
#define R_PAR1_CONFIG__IRD       REG_IRD_WO
#define R_PAR1_CONFIG__WR        REG_WR_WO
#define R_PAR1_CONFIG__IWR       REG_IWR_WO

#define R_PAR1_CONFIG__WRITE(addr,value) \
  (*(addr) = (value))

#define R_PAR1_CONFIG__ioe__ioe__MASK 0x02000000U
#define R_PAR1_CONFIG__iseli__iseli__MASK 0x01000000U
#define R_PAR1_CONFIG__iautofd__iautofd__MASK 0x00800000U
#define R_PAR1_CONFIG__istrb__istrb__MASK 0x00400000U
#define R_PAR1_CONFIG__iinit__iinit__MASK 0x00200000U
#define R_PAR1_CONFIG__iperr__iperr__MASK 0x00100000U
#define R_PAR1_CONFIG__iack__iack__MASK 0x00080000U
#define R_PAR1_CONFIG__ibusy__ibusy__MASK 0x00040000U
#define R_PAR1_CONFIG__ifault__ifault__MASK 0x00020000U
#define R_PAR1_CONFIG__isel__isel__MASK 0x00010000U
#define R_PAR1_CONFIG__ext_mode__ext_mode__MASK 0x00000800U
#define R_PAR1_CONFIG__dma__dma__MASK 0x00000200U
#define R_PAR1_CONFIG__rle_in__rle_in__MASK 0x00000100U
#define R_PAR1_CONFIG__rle_out__rle_out__MASK 0x00000080U
#define R_PAR1_CONFIG__enable__enable__MASK 0x00000040U
#define R_PAR1_CONFIG__force__force__MASK 0x00000020U
#define R_PAR1_CONFIG__ign_ack__ign_ack__MASK 0x00000010U
#define R_PAR1_CONFIG__oe_ack__oe_ack__MASK 0x00000008U
#define R_PAR1_CONFIG__epp_addr_data__epp_addr_data__MASK 0x00000008U
#define R_PAR1_CONFIG__oe_ack__epp_addr_data__MASK 0x00000008U
#define R_PAR1_CONFIG__mode__mode__MASK 0x00000007U

#define R_PAR1_CONFIG__ioe__MAX 0x1
#define R_PAR1_CONFIG__iseli__MAX 0x1
#define R_PAR1_CONFIG__iautofd__MAX 0x1
#define R_PAR1_CONFIG__istrb__MAX 0x1
#define R_PAR1_CONFIG__iinit__MAX 0x1
#define R_PAR1_CONFIG__iperr__MAX 0x1
#define R_PAR1_CONFIG__iack__MAX 0x1
#define R_PAR1_CONFIG__ibusy__MAX 0x1
#define R_PAR1_CONFIG__ifault__MAX 0x1
#define R_PAR1_CONFIG__isel__MAX 0x1
#define R_PAR1_CONFIG__ext_mode__MAX 0x1
#define R_PAR1_CONFIG__dma__MAX 0x1
#define R_PAR1_CONFIG__rle_in__MAX 0x1
#define R_PAR1_CONFIG__rle_out__MAX 0x1
#define R_PAR1_CONFIG__enable__MAX 0x1
#define R_PAR1_CONFIG__force__MAX 0x1
#define R_PAR1_CONFIG__ign_ack__MAX 0x1
#define R_PAR1_CONFIG__oe_ack__MAX 0x1
#define R_PAR1_CONFIG__epp_addr_data__MAX 0x1
#define R_PAR1_CONFIG__mode__MAX 0x7

#define R_PAR1_CONFIG__ioe__MIN 0
#define R_PAR1_CONFIG__iseli__MIN 0
#define R_PAR1_CONFIG__iautofd__MIN 0
#define R_PAR1_CONFIG__istrb__MIN 0
#define R_PAR1_CONFIG__iinit__MIN 0
#define R_PAR1_CONFIG__iperr__MIN 0
#define R_PAR1_CONFIG__iack__MIN 0
#define R_PAR1_CONFIG__ibusy__MIN 0
#define R_PAR1_CONFIG__ifault__MIN 0
#define R_PAR1_CONFIG__isel__MIN 0
#define R_PAR1_CONFIG__ext_mode__MIN 0
#define R_PAR1_CONFIG__dma__MIN 0
#define R_PAR1_CONFIG__rle_in__MIN 0
#define R_PAR1_CONFIG__rle_out__MIN 0
#define R_PAR1_CONFIG__enable__MIN 0
#define R_PAR1_CONFIG__force__MIN 0
#define R_PAR1_CONFIG__ign_ack__MIN 0
#define R_PAR1_CONFIG__oe_ack__MIN 0
#define R_PAR1_CONFIG__epp_addr_data__MIN 0
#define R_PAR1_CONFIG__mode__MIN 0

#define R_PAR1_CONFIG__ioe__BITNR 25
#define R_PAR1_CONFIG__iseli__BITNR 24
#define R_PAR1_CONFIG__iautofd__BITNR 23
#define R_PAR1_CONFIG__istrb__BITNR 22
#define R_PAR1_CONFIG__iinit__BITNR 21
#define R_PAR1_CONFIG__iperr__BITNR 20
#define R_PAR1_CONFIG__iack__BITNR 19
#define R_PAR1_CONFIG__ibusy__BITNR 18
#define R_PAR1_CONFIG__ifault__BITNR 17
#define R_PAR1_CONFIG__isel__BITNR 16
#define R_PAR1_CONFIG__ext_mode__BITNR 11
#define R_PAR1_CONFIG__dma__BITNR 9
#define R_PAR1_CONFIG__rle_in__BITNR 8
#define R_PAR1_CONFIG__rle_out__BITNR 7
#define R_PAR1_CONFIG__enable__BITNR 6
#define R_PAR1_CONFIG__force__BITNR 5
#define R_PAR1_CONFIG__ign_ack__BITNR 4
#define R_PAR1_CONFIG__oe_ack__BITNR 3
#define R_PAR1_CONFIG__epp_addr_data__BITNR 3
#define R_PAR1_CONFIG__mode__BITNR 0

#define R_PAR1_CONFIG__ioe__ioe__VAL REG_VAL_ENUM
#define R_PAR1_CONFIG__iseli__iseli__VAL REG_VAL_ENUM
#define R_PAR1_CONFIG__iautofd__iautofd__VAL REG_VAL_ENUM
#define R_PAR1_CONFIG__istrb__istrb__VAL REG_VAL_ENUM
#define R_PAR1_CONFIG__iinit__iinit__VAL REG_VAL_ENUM
#define R_PAR1_CONFIG__iperr__iperr__VAL REG_VAL_ENUM
#define R_PAR1_CONFIG__iack__iack__VAL REG_VAL_ENUM
#define R_PAR1_CONFIG__ibusy__ibusy__VAL REG_VAL_ENUM
#define R_PAR1_CONFIG__ifault__ifault__VAL REG_VAL_ENUM
#define R_PAR1_CONFIG__isel__isel__VAL REG_VAL_ENUM
#define R_PAR1_CONFIG__ext_mode__ext_mode__VAL REG_VAL_ENUM
#define R_PAR1_CONFIG__dma__dma__VAL REG_VAL_ENUM
#define R_PAR1_CONFIG__rle_in__rle_in__VAL REG_VAL_ENUM
#define R_PAR1_CONFIG__rle_out__rle_out__VAL REG_VAL_ENUM
#define R_PAR1_CONFIG__enable__enable__VAL REG_VAL_ENUM
#define R_PAR1_CONFIG__force__force__VAL REG_VAL_ENUM
#define R_PAR1_CONFIG__ign_ack__ign_ack__VAL REG_VAL_ENUM
#define R_PAR1_CONFIG__oe_ack__oe_ack__VAL REG_VAL_ENUM
#define R_PAR1_CONFIG__epp_addr_data__epp_addr_data__VAL REG_VAL_ENUM
#define R_PAR1_CONFIG__oe_ack__epp_addr_data__VAL REG_VAL_ENUM
#define R_PAR1_CONFIG__mode__mode__VAL REG_VAL_ENUM

#define R_PAR1_CONFIG__ioe__ioe__inv 1
#define R_PAR1_CONFIG__ioe__ioe__noninv 0
#define R_PAR1_CONFIG__iseli__iseli__inv 1
#define R_PAR1_CONFIG__iseli__iseli__noninv 0
#define R_PAR1_CONFIG__iautofd__iautofd__inv 1
#define R_PAR1_CONFIG__iautofd__iautofd__noninv 0
#define R_PAR1_CONFIG__istrb__istrb__inv 1
#define R_PAR1_CONFIG__istrb__istrb__noninv 0
#define R_PAR1_CONFIG__iinit__iinit__inv 1
#define R_PAR1_CONFIG__iinit__iinit__noninv 0
#define R_PAR1_CONFIG__iperr__iperr__inv 1
#define R_PAR1_CONFIG__iperr__iperr__noninv 0
#define R_PAR1_CONFIG__iack__iack__inv 1
#define R_PAR1_CONFIG__iack__iack__noninv 0
#define R_PAR1_CONFIG__ibusy__ibusy__inv 1
#define R_PAR1_CONFIG__ibusy__ibusy__noninv 0
#define R_PAR1_CONFIG__ifault__ifault__inv 1
#define R_PAR1_CONFIG__ifault__ifault__noninv 0
#define R_PAR1_CONFIG__isel__isel__inv 1
#define R_PAR1_CONFIG__isel__isel__noninv 0
#define R_PAR1_CONFIG__ext_mode__ext_mode__disable 0
#define R_PAR1_CONFIG__ext_mode__ext_mode__enable 1
#define R_PAR1_CONFIG__dma__dma__disable 0
#define R_PAR1_CONFIG__dma__dma__enable 1
#define R_PAR1_CONFIG__rle_in__rle_in__disable 0
#define R_PAR1_CONFIG__rle_in__rle_in__enable 1
#define R_PAR1_CONFIG__rle_out__rle_out__disable 0
#define R_PAR1_CONFIG__rle_out__rle_out__enable 1
#define R_PAR1_CONFIG__enable__enable__on 1
#define R_PAR1_CONFIG__enable__enable__reset 0
#define R_PAR1_CONFIG__force__force__off 0
#define R_PAR1_CONFIG__force__force__on 1
#define R_PAR1_CONFIG__ign_ack__ign_ack__ignore 1
#define R_PAR1_CONFIG__ign_ack__ign_ack__wait 0
#define R_PAR1_CONFIG__oe_ack__oe_ack__dont_wait 0
#define R_PAR1_CONFIG__oe_ack__oe_ack__epp_addr 1
#define R_PAR1_CONFIG__oe_ack__oe_ack__epp_data 0
#define R_PAR1_CONFIG__oe_ack__oe_ack__wait_oe 1
#define R_PAR1_CONFIG__epp_addr_data__epp_addr_data__dont_wait 0
#define R_PAR1_CONFIG__epp_addr_data__epp_addr_data__epp_addr 1
#define R_PAR1_CONFIG__epp_addr_data__epp_addr_data__epp_data 0
#define R_PAR1_CONFIG__epp_addr_data__epp_addr_data__wait_oe 1
#define R_PAR1_CONFIG__mode__mode__byte 4
#define R_PAR1_CONFIG__mode__mode__centronics 1
#define R_PAR1_CONFIG__mode__mode__ecp_fwd 5
#define R_PAR1_CONFIG__mode__mode__ecp_rev 6
#define R_PAR1_CONFIG__mode__mode__epp_rd 0
#define R_PAR1_CONFIG__mode__mode__epp_wr1 5
#define R_PAR1_CONFIG__mode__mode__epp_wr2 6
#define R_PAR1_CONFIG__mode__mode__epp_wr3 7
#define R_PAR1_CONFIG__mode__mode__fastbyte 2
#define R_PAR1_CONFIG__mode__mode__manual 0
#define R_PAR1_CONFIG__mode__mode__nibble 3
#define R_PAR1_CONFIG__mode__mode__off 7

#endif

/*
 *  R_PAR1_CTRL
 *  - type:  WO
 *  - addr:  0xb0000052
 *  - group: Parallel printer port registers
 */

#if USE_GROUP__Parallel_printer_port_registers

#define R_PAR1_CTRL__ADDR      (REG_TYPECAST_BYTE  0xb0000052)

#ifndef REG_NO_SHADOW
#define R_PAR1_CTRL__SADDR     (REG_STYPECAST_BYTE (reg_shadow__hwregs.R_PAR1_CTRL_DATA + 2))
#define R_PAR1_CTRL__IADDR     (REG_STYPECAST_BYTE (reg_initiated__hwregs.R_PAR1_CTRL_DATA + 2))
#else /* REG_NO_SHADOW */
#define R_PAR1_CTRL__SADDR     (REG_STYPECAST_BYTE (&reg_shadow__hwregs))
#define R_PAR1_CTRL__IADDR     (REG_STYPECAST_BYTE (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_PAR1_CTRL__STYPECAST REG_STYPECAST_BYTE
#define R_PAR1_CTRL__SVAL      REG_SVAL_SHADOW
#define R_PAR1_CTRL__SVAL_I    REG_SVAL_I_SHADOW
#define R_PAR1_CTRL__TYPECAST  REG_TYPECAST_BYTE
#define R_PAR1_CTRL__TYPE      (REG_BYTE)
#define R_PAR1_CTRL__GET       REG_GET_WO
#define R_PAR1_CTRL__IGET      REG_IGET_WO
#define R_PAR1_CTRL__SET       REG_SET_WO
#define R_PAR1_CTRL__ISET      REG_ISET_WO
#define R_PAR1_CTRL__SET_VAL   REG_SET_VAL_WO
#define R_PAR1_CTRL__EQL       REG_EQL_WO
#define R_PAR1_CTRL__IEQL      REG_IEQL_WO
#define R_PAR1_CTRL__RD        REG_RD_WO
#define R_PAR1_CTRL__IRD       REG_IRD_WO
#define R_PAR1_CTRL__WR        REG_WR_WO
#define R_PAR1_CTRL__IWR       REG_IWR_WO

#define R_PAR1_CTRL__WRITE(addr,value) \
  (*(addr) = (value))

#define R_PAR1_CTRL__ctrl__ctrl__MASK 0x0000001fU

#define R_PAR1_CTRL__ctrl__MAX 31

#define R_PAR1_CTRL__ctrl__MIN 0

#define R_PAR1_CTRL__ctrl__BITNR 0

#define R_PAR1_CTRL__ctrl__ctrl__VAL REG_VAL_VAL


#endif

/*
 *  R_PAR1_CTRL_DATA
 *  - type:  WO
 *  - addr:  0xb0000050
 *  - group: Parallel printer port registers
 */

#if USE_GROUP__Parallel_printer_port_registers

#define R_PAR1_CTRL_DATA__ADDR      (REG_TYPECAST_UDWORD  0xb0000050)

#ifndef REG_NO_SHADOW
#define R_PAR1_CTRL_DATA__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_PAR1_CTRL_DATA + 0))
#define R_PAR1_CTRL_DATA__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_PAR1_CTRL_DATA + 0))
#else /* REG_NO_SHADOW */
#define R_PAR1_CTRL_DATA__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_PAR1_CTRL_DATA__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_PAR1_CTRL_DATA__STYPECAST REG_STYPECAST_UDWORD
#define R_PAR1_CTRL_DATA__SVAL      REG_SVAL_SHADOW
#define R_PAR1_CTRL_DATA__SVAL_I    REG_SVAL_I_SHADOW
#define R_PAR1_CTRL_DATA__TYPECAST  REG_TYPECAST_UDWORD
#define R_PAR1_CTRL_DATA__TYPE      (REG_UDWORD)
#define R_PAR1_CTRL_DATA__GET       REG_GET_WO
#define R_PAR1_CTRL_DATA__IGET      REG_IGET_WO
#define R_PAR1_CTRL_DATA__SET       REG_SET_WO
#define R_PAR1_CTRL_DATA__ISET      REG_ISET_WO
#define R_PAR1_CTRL_DATA__SET_VAL   REG_SET_VAL_WO
#define R_PAR1_CTRL_DATA__EQL       REG_EQL_WO
#define R_PAR1_CTRL_DATA__IEQL      REG_IEQL_WO
#define R_PAR1_CTRL_DATA__RD        REG_RD_WO
#define R_PAR1_CTRL_DATA__IRD       REG_IRD_WO
#define R_PAR1_CTRL_DATA__WR        REG_WR_WO
#define R_PAR1_CTRL_DATA__IWR       REG_IWR_WO

#define R_PAR1_CTRL_DATA__WRITE(addr,value) \
  (*(addr) = (value))

#define R_PAR1_CTRL_DATA__peri_int__peri_int__MASK 0x01000000U
#define R_PAR1_CTRL_DATA__oe__oe__MASK 0x00100000U
#define R_PAR1_CTRL_DATA__seli__seli__MASK 0x00080000U
#define R_PAR1_CTRL_DATA__autofd__autofd__MASK 0x00040000U
#define R_PAR1_CTRL_DATA__strb__strb__MASK 0x00020000U
#define R_PAR1_CTRL_DATA__init__init__MASK 0x00010000U
#define R_PAR1_CTRL_DATA__ecp_cmd__ecp_cmd__MASK 0x00000100U
#define R_PAR1_CTRL_DATA__data__data__MASK 0x000000ffU

#define R_PAR1_CTRL_DATA__peri_int__MAX 0x1
#define R_PAR1_CTRL_DATA__oe__MAX 0x1
#define R_PAR1_CTRL_DATA__seli__MAX 0x1
#define R_PAR1_CTRL_DATA__autofd__MAX 0x1
#define R_PAR1_CTRL_DATA__strb__MAX 0x1
#define R_PAR1_CTRL_DATA__init__MAX 0x1
#define R_PAR1_CTRL_DATA__ecp_cmd__MAX 0x1
#define R_PAR1_CTRL_DATA__data__MAX 0xff

#define R_PAR1_CTRL_DATA__peri_int__MIN 0
#define R_PAR1_CTRL_DATA__oe__MIN 0
#define R_PAR1_CTRL_DATA__seli__MIN 0
#define R_PAR1_CTRL_DATA__autofd__MIN 0
#define R_PAR1_CTRL_DATA__strb__MIN 0
#define R_PAR1_CTRL_DATA__init__MIN 0
#define R_PAR1_CTRL_DATA__ecp_cmd__MIN 0
#define R_PAR1_CTRL_DATA__data__MIN 0

#define R_PAR1_CTRL_DATA__peri_int__BITNR 24
#define R_PAR1_CTRL_DATA__oe__BITNR 20
#define R_PAR1_CTRL_DATA__seli__BITNR 19
#define R_PAR1_CTRL_DATA__autofd__BITNR 18
#define R_PAR1_CTRL_DATA__strb__BITNR 17
#define R_PAR1_CTRL_DATA__init__BITNR 16
#define R_PAR1_CTRL_DATA__ecp_cmd__BITNR 8
#define R_PAR1_CTRL_DATA__data__BITNR 0

#define R_PAR1_CTRL_DATA__peri_int__peri_int__VAL REG_VAL_ENUM
#define R_PAR1_CTRL_DATA__oe__oe__VAL REG_VAL_ENUM
#define R_PAR1_CTRL_DATA__seli__seli__VAL REG_VAL_ENUM
#define R_PAR1_CTRL_DATA__autofd__autofd__VAL REG_VAL_ENUM
#define R_PAR1_CTRL_DATA__strb__strb__VAL REG_VAL_ENUM
#define R_PAR1_CTRL_DATA__init__init__VAL REG_VAL_ENUM
#define R_PAR1_CTRL_DATA__ecp_cmd__ecp_cmd__VAL REG_VAL_ENUM
#define R_PAR1_CTRL_DATA__data__data__VAL REG_VAL_VAL

#define R_PAR1_CTRL_DATA__peri_int__peri_int__ack 1
#define R_PAR1_CTRL_DATA__peri_int__peri_int__nop 0
#define R_PAR1_CTRL_DATA__oe__oe__disable 0
#define R_PAR1_CTRL_DATA__oe__oe__enable 1
#define R_PAR1_CTRL_DATA__seli__seli__active 1
#define R_PAR1_CTRL_DATA__seli__seli__inactive 0
#define R_PAR1_CTRL_DATA__autofd__autofd__active 1
#define R_PAR1_CTRL_DATA__autofd__autofd__inactive 0
#define R_PAR1_CTRL_DATA__strb__strb__active 1
#define R_PAR1_CTRL_DATA__strb__strb__inactive 0
#define R_PAR1_CTRL_DATA__init__init__active 1
#define R_PAR1_CTRL_DATA__init__init__inactive 0
#define R_PAR1_CTRL_DATA__ecp_cmd__ecp_cmd__command 1
#define R_PAR1_CTRL_DATA__ecp_cmd__ecp_cmd__data 0

#endif

/*
 *  R_PAR1_DELAY
 *  - type:  WO
 *  - addr:  0xb0000058
 *  - group: Parallel printer port registers
 */

#if USE_GROUP__Parallel_printer_port_registers

#define R_PAR1_DELAY__ADDR      (REG_TYPECAST_UDWORD  0xb0000058)

#ifndef REG_NO_SHADOW
#define R_PAR1_DELAY__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_PAR1_DELAY + 0))
#define R_PAR1_DELAY__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_PAR1_DELAY + 0))
#else /* REG_NO_SHADOW */
#define R_PAR1_DELAY__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_PAR1_DELAY__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_PAR1_DELAY__STYPECAST REG_STYPECAST_UDWORD
#define R_PAR1_DELAY__SVAL      REG_SVAL_SHADOW
#define R_PAR1_DELAY__SVAL_I    REG_SVAL_I_SHADOW
#define R_PAR1_DELAY__TYPECAST  REG_TYPECAST_UDWORD
#define R_PAR1_DELAY__TYPE      (REG_UDWORD)
#define R_PAR1_DELAY__GET       REG_GET_WO
#define R_PAR1_DELAY__IGET      REG_IGET_WO
#define R_PAR1_DELAY__SET       REG_SET_WO
#define R_PAR1_DELAY__ISET      REG_ISET_WO
#define R_PAR1_DELAY__SET_VAL   REG_SET_VAL_WO
#define R_PAR1_DELAY__EQL       REG_EQL_WO
#define R_PAR1_DELAY__IEQL      REG_IEQL_WO
#define R_PAR1_DELAY__RD        REG_RD_WO
#define R_PAR1_DELAY__IRD       REG_IRD_WO
#define R_PAR1_DELAY__WR        REG_WR_WO
#define R_PAR1_DELAY__IWR       REG_IWR_WO

#define R_PAR1_DELAY__WRITE(addr,value) \
  (*(addr) = (value))

#define R_PAR1_DELAY__fine_hold__fine_hold__MASK 0x00e00000U
#define R_PAR1_DELAY__hold__hold__MASK 0x001f0000U
#define R_PAR1_DELAY__fine_strb__fine_strb__MASK 0x0000e000U
#define R_PAR1_DELAY__strobe__strobe__MASK 0x00001f00U
#define R_PAR1_DELAY__fine_setup__fine_setup__MASK 0x000000e0U
#define R_PAR1_DELAY__setup__setup__MASK 0x0000001fU

#define R_PAR1_DELAY__fine_hold__MAX 0x7
#define R_PAR1_DELAY__hold__MAX 0x1f
#define R_PAR1_DELAY__fine_strb__MAX 0x7
#define R_PAR1_DELAY__strobe__MAX 0x1f
#define R_PAR1_DELAY__fine_setup__MAX 0x7
#define R_PAR1_DELAY__setup__MAX 0x1f

#define R_PAR1_DELAY__fine_hold__MIN 0
#define R_PAR1_DELAY__hold__MIN 0
#define R_PAR1_DELAY__fine_strb__MIN 0
#define R_PAR1_DELAY__strobe__MIN 0
#define R_PAR1_DELAY__fine_setup__MIN 0
#define R_PAR1_DELAY__setup__MIN 0

#define R_PAR1_DELAY__fine_hold__BITNR 21
#define R_PAR1_DELAY__hold__BITNR 16
#define R_PAR1_DELAY__fine_strb__BITNR 13
#define R_PAR1_DELAY__strobe__BITNR 8
#define R_PAR1_DELAY__fine_setup__BITNR 5
#define R_PAR1_DELAY__setup__BITNR 0

#define R_PAR1_DELAY__fine_hold__fine_hold__VAL REG_VAL_VAL
#define R_PAR1_DELAY__hold__hold__VAL REG_VAL_VAL
#define R_PAR1_DELAY__fine_strb__fine_strb__VAL REG_VAL_VAL
#define R_PAR1_DELAY__strobe__strobe__VAL REG_VAL_VAL
#define R_PAR1_DELAY__fine_setup__fine_setup__VAL REG_VAL_VAL
#define R_PAR1_DELAY__setup__setup__VAL REG_VAL_VAL


#endif

/*
 *  R_PAR1_STATUS
 *  - type:  RO
 *  - addr:  0xb0000052
 *  - group: Parallel printer port registers
 */

#if USE_GROUP__Parallel_printer_port_registers

#define R_PAR1_STATUS__ADDR      (REG_TYPECAST_UWORD  0xb0000052)
#define R_PAR1_STATUS__SVAL      REG_SVAL_SHADOW
#define R_PAR1_STATUS__SVAL_I    REG_SVAL_I_SHADOW
#define R_PAR1_STATUS__TYPECAST  REG_TYPECAST_UWORD
#define R_PAR1_STATUS__TYPE      (REG_UWORD)
#define R_PAR1_STATUS__GET       REG_GET_RO
#define R_PAR1_STATUS__IGET      REG_IGET_RO
#define R_PAR1_STATUS__SET       REG_SET_RO
#define R_PAR1_STATUS__ISET      REG_ISET_RO
#define R_PAR1_STATUS__SET_VAL   REG_SET_VAL_RO
#define R_PAR1_STATUS__EQL       REG_EQL_RO
#define R_PAR1_STATUS__IEQL      REG_IEQL_RO
#define R_PAR1_STATUS__RD        REG_RD_RO
#define R_PAR1_STATUS__IRD       REG_IRD_RO
#define R_PAR1_STATUS__WR        REG_WR_RO
#define R_PAR1_STATUS__IWR       REG_IWR_RO

#define R_PAR1_STATUS__READ(addr) \
  (*(addr))

#define R_PAR1_STATUS__mode__mode__MASK 0x0000e000U
#define R_PAR1_STATUS__perr__perr__MASK 0x00001000U
#define R_PAR1_STATUS__ack__ack__MASK 0x00000800U
#define R_PAR1_STATUS__busy__busy__MASK 0x00000400U
#define R_PAR1_STATUS__fault__fault__MASK 0x00000200U
#define R_PAR1_STATUS__sel__sel__MASK 0x00000100U
#define R_PAR1_STATUS__ext_mode__ext_mode__MASK 0x00000080U
#define R_PAR1_STATUS__tr_rdy__tr_rdy__MASK 0x00000002U
#define R_PAR1_STATUS__dav__dav__MASK 0x00000001U

#define R_PAR1_STATUS__mode__MAX 0x7
#define R_PAR1_STATUS__perr__MAX 0x1
#define R_PAR1_STATUS__ack__MAX 0x1
#define R_PAR1_STATUS__busy__MAX 0x1
#define R_PAR1_STATUS__fault__MAX 0x1
#define R_PAR1_STATUS__sel__MAX 0x1
#define R_PAR1_STATUS__ext_mode__MAX 0x1
#define R_PAR1_STATUS__tr_rdy__MAX 0x1
#define R_PAR1_STATUS__dav__MAX 0x1

#define R_PAR1_STATUS__mode__MIN 0
#define R_PAR1_STATUS__perr__MIN 0
#define R_PAR1_STATUS__ack__MIN 0
#define R_PAR1_STATUS__busy__MIN 0
#define R_PAR1_STATUS__fault__MIN 0
#define R_PAR1_STATUS__sel__MIN 0
#define R_PAR1_STATUS__ext_mode__MIN 0
#define R_PAR1_STATUS__tr_rdy__MIN 0
#define R_PAR1_STATUS__dav__MIN 0

#define R_PAR1_STATUS__mode__BITNR 13
#define R_PAR1_STATUS__perr__BITNR 12
#define R_PAR1_STATUS__ack__BITNR 11
#define R_PAR1_STATUS__busy__BITNR 10
#define R_PAR1_STATUS__fault__BITNR 9
#define R_PAR1_STATUS__sel__BITNR 8
#define R_PAR1_STATUS__ext_mode__BITNR 7
#define R_PAR1_STATUS__tr_rdy__BITNR 1
#define R_PAR1_STATUS__dav__BITNR 0

#define R_PAR1_STATUS__mode__mode__VAL REG_VAL_ENUM
#define R_PAR1_STATUS__perr__perr__VAL REG_VAL_ENUM
#define R_PAR1_STATUS__ack__ack__VAL REG_VAL_ENUM
#define R_PAR1_STATUS__busy__busy__VAL REG_VAL_ENUM
#define R_PAR1_STATUS__fault__fault__VAL REG_VAL_ENUM
#define R_PAR1_STATUS__sel__sel__VAL REG_VAL_ENUM
#define R_PAR1_STATUS__ext_mode__ext_mode__VAL REG_VAL_ENUM
#define R_PAR1_STATUS__tr_rdy__tr_rdy__VAL REG_VAL_ENUM
#define R_PAR1_STATUS__dav__dav__VAL REG_VAL_ENUM

#define R_PAR1_STATUS__mode__mode__byte 4
#define R_PAR1_STATUS__mode__mode__centronics 1
#define R_PAR1_STATUS__mode__mode__ecp_fwd 5
#define R_PAR1_STATUS__mode__mode__ecp_rev 6
#define R_PAR1_STATUS__mode__mode__epp_rd 0
#define R_PAR1_STATUS__mode__mode__epp_wr1 5
#define R_PAR1_STATUS__mode__mode__epp_wr2 6
#define R_PAR1_STATUS__mode__mode__epp_wr3 7
#define R_PAR1_STATUS__mode__mode__fastbyte 2
#define R_PAR1_STATUS__mode__mode__manual 0
#define R_PAR1_STATUS__mode__mode__nibble 3
#define R_PAR1_STATUS__mode__mode__off 7
#define R_PAR1_STATUS__perr__perr__active 1
#define R_PAR1_STATUS__perr__perr__inactive 0
#define R_PAR1_STATUS__ack__ack__active 0
#define R_PAR1_STATUS__ack__ack__inactive 1
#define R_PAR1_STATUS__busy__busy__active 1
#define R_PAR1_STATUS__busy__busy__inactive 0
#define R_PAR1_STATUS__fault__fault__active 0
#define R_PAR1_STATUS__fault__fault__inactive 1
#define R_PAR1_STATUS__sel__sel__active 1
#define R_PAR1_STATUS__sel__sel__inactive 0
#define R_PAR1_STATUS__ext_mode__ext_mode__disable 0
#define R_PAR1_STATUS__ext_mode__ext_mode__enable 1
#define R_PAR1_STATUS__tr_rdy__tr_rdy__busy 0
#define R_PAR1_STATUS__tr_rdy__tr_rdy__ready 1
#define R_PAR1_STATUS__dav__dav__data 1
#define R_PAR1_STATUS__dav__dav__nodata 0

#endif

/*
 *  R_PAR1_STATUS_DATA
 *  - type:  RO
 *  - addr:  0xb0000050
 *  - group: Parallel printer port registers
 */

#if USE_GROUP__Parallel_printer_port_registers

#define R_PAR1_STATUS_DATA__ADDR      (REG_TYPECAST_UDWORD  0xb0000050)
#define R_PAR1_STATUS_DATA__SVAL      REG_SVAL_SHADOW
#define R_PAR1_STATUS_DATA__SVAL_I    REG_SVAL_I_SHADOW
#define R_PAR1_STATUS_DATA__TYPECAST  REG_TYPECAST_UDWORD
#define R_PAR1_STATUS_DATA__TYPE      (REG_UDWORD)
#define R_PAR1_STATUS_DATA__GET       REG_GET_RO
#define R_PAR1_STATUS_DATA__IGET      REG_IGET_RO
#define R_PAR1_STATUS_DATA__SET       REG_SET_RO
#define R_PAR1_STATUS_DATA__ISET      REG_ISET_RO
#define R_PAR1_STATUS_DATA__SET_VAL   REG_SET_VAL_RO
#define R_PAR1_STATUS_DATA__EQL       REG_EQL_RO
#define R_PAR1_STATUS_DATA__IEQL      REG_IEQL_RO
#define R_PAR1_STATUS_DATA__RD        REG_RD_RO
#define R_PAR1_STATUS_DATA__IRD       REG_IRD_RO
#define R_PAR1_STATUS_DATA__WR        REG_WR_RO
#define R_PAR1_STATUS_DATA__IWR       REG_IWR_RO

#define R_PAR1_STATUS_DATA__READ(addr) \
  (*(addr))

#define R_PAR1_STATUS_DATA__mode__mode__MASK 0xe0000000U
#define R_PAR1_STATUS_DATA__perr__perr__MASK 0x10000000U
#define R_PAR1_STATUS_DATA__ack__ack__MASK 0x08000000U
#define R_PAR1_STATUS_DATA__busy__busy__MASK 0x04000000U
#define R_PAR1_STATUS_DATA__fault__fault__MASK 0x02000000U
#define R_PAR1_STATUS_DATA__sel__sel__MASK 0x01000000U
#define R_PAR1_STATUS_DATA__ext_mode__ext_mode__MASK 0x00800000U
#define R_PAR1_STATUS_DATA__tr_rdy__tr_rdy__MASK 0x00020000U
#define R_PAR1_STATUS_DATA__dav__dav__MASK 0x00010000U
#define R_PAR1_STATUS_DATA__ecp_cmd__ecp_cmd__MASK 0x00000100U
#define R_PAR1_STATUS_DATA__data__data__MASK 0x000000ffU

#define R_PAR1_STATUS_DATA__mode__MAX 0x7
#define R_PAR1_STATUS_DATA__perr__MAX 0x1
#define R_PAR1_STATUS_DATA__ack__MAX 0x1
#define R_PAR1_STATUS_DATA__busy__MAX 0x1
#define R_PAR1_STATUS_DATA__fault__MAX 0x1
#define R_PAR1_STATUS_DATA__sel__MAX 0x1
#define R_PAR1_STATUS_DATA__ext_mode__MAX 0x1
#define R_PAR1_STATUS_DATA__tr_rdy__MAX 0x1
#define R_PAR1_STATUS_DATA__dav__MAX 0x1
#define R_PAR1_STATUS_DATA__ecp_cmd__MAX 0x1
#define R_PAR1_STATUS_DATA__data__MAX 0xff

#define R_PAR1_STATUS_DATA__mode__MIN 0
#define R_PAR1_STATUS_DATA__perr__MIN 0
#define R_PAR1_STATUS_DATA__ack__MIN 0
#define R_PAR1_STATUS_DATA__busy__MIN 0
#define R_PAR1_STATUS_DATA__fault__MIN 0
#define R_PAR1_STATUS_DATA__sel__MIN 0
#define R_PAR1_STATUS_DATA__ext_mode__MIN 0
#define R_PAR1_STATUS_DATA__tr_rdy__MIN 0
#define R_PAR1_STATUS_DATA__dav__MIN 0
#define R_PAR1_STATUS_DATA__ecp_cmd__MIN 0
#define R_PAR1_STATUS_DATA__data__MIN 0

#define R_PAR1_STATUS_DATA__mode__BITNR 29
#define R_PAR1_STATUS_DATA__perr__BITNR 28
#define R_PAR1_STATUS_DATA__ack__BITNR 27
#define R_PAR1_STATUS_DATA__busy__BITNR 26
#define R_PAR1_STATUS_DATA__fault__BITNR 25
#define R_PAR1_STATUS_DATA__sel__BITNR 24
#define R_PAR1_STATUS_DATA__ext_mode__BITNR 23
#define R_PAR1_STATUS_DATA__tr_rdy__BITNR 17
#define R_PAR1_STATUS_DATA__dav__BITNR 16
#define R_PAR1_STATUS_DATA__ecp_cmd__BITNR 8
#define R_PAR1_STATUS_DATA__data__BITNR 0

#define R_PAR1_STATUS_DATA__mode__mode__VAL REG_VAL_ENUM
#define R_PAR1_STATUS_DATA__perr__perr__VAL REG_VAL_ENUM
#define R_PAR1_STATUS_DATA__ack__ack__VAL REG_VAL_ENUM
#define R_PAR1_STATUS_DATA__busy__busy__VAL REG_VAL_ENUM
#define R_PAR1_STATUS_DATA__fault__fault__VAL REG_VAL_ENUM
#define R_PAR1_STATUS_DATA__sel__sel__VAL REG_VAL_ENUM
#define R_PAR1_STATUS_DATA__ext_mode__ext_mode__VAL REG_VAL_ENUM
#define R_PAR1_STATUS_DATA__tr_rdy__tr_rdy__VAL REG_VAL_ENUM
#define R_PAR1_STATUS_DATA__dav__dav__VAL REG_VAL_ENUM
#define R_PAR1_STATUS_DATA__ecp_cmd__ecp_cmd__VAL REG_VAL_ENUM
#define R_PAR1_STATUS_DATA__data__data__VAL REG_VAL_VAL

#define R_PAR1_STATUS_DATA__mode__mode__byte 4
#define R_PAR1_STATUS_DATA__mode__mode__centronics 1
#define R_PAR1_STATUS_DATA__mode__mode__ecp_fwd 5
#define R_PAR1_STATUS_DATA__mode__mode__ecp_rev 6
#define R_PAR1_STATUS_DATA__mode__mode__epp_rd 0
#define R_PAR1_STATUS_DATA__mode__mode__epp_wr1 5
#define R_PAR1_STATUS_DATA__mode__mode__epp_wr2 6
#define R_PAR1_STATUS_DATA__mode__mode__epp_wr3 7
#define R_PAR1_STATUS_DATA__mode__mode__fastbyte 2
#define R_PAR1_STATUS_DATA__mode__mode__manual 0
#define R_PAR1_STATUS_DATA__mode__mode__nibble 3
#define R_PAR1_STATUS_DATA__mode__mode__off 7
#define R_PAR1_STATUS_DATA__perr__perr__active 1
#define R_PAR1_STATUS_DATA__perr__perr__inactive 0
#define R_PAR1_STATUS_DATA__ack__ack__active 0
#define R_PAR1_STATUS_DATA__ack__ack__inactive 1
#define R_PAR1_STATUS_DATA__busy__busy__active 1
#define R_PAR1_STATUS_DATA__busy__busy__inactive 0
#define R_PAR1_STATUS_DATA__fault__fault__active 0
#define R_PAR1_STATUS_DATA__fault__fault__inactive 1
#define R_PAR1_STATUS_DATA__sel__sel__active 1
#define R_PAR1_STATUS_DATA__sel__sel__inactive 0
#define R_PAR1_STATUS_DATA__ext_mode__ext_mode__disable 0
#define R_PAR1_STATUS_DATA__ext_mode__ext_mode__enable 1
#define R_PAR1_STATUS_DATA__tr_rdy__tr_rdy__busy 0
#define R_PAR1_STATUS_DATA__tr_rdy__tr_rdy__ready 1
#define R_PAR1_STATUS_DATA__dav__dav__data 1
#define R_PAR1_STATUS_DATA__dav__dav__nodata 0
#define R_PAR1_STATUS_DATA__ecp_cmd__ecp_cmd__command 1
#define R_PAR1_STATUS_DATA__ecp_cmd__ecp_cmd__data 0

#endif

/*
 *  R_PAR_ECP16_DATA
 *  - type:  RW
 *  - addr:  0xb0000040
 *  - group: Parallel printer port registers
 */

#if USE_GROUP__Parallel_printer_port_registers

#define R_PAR_ECP16_DATA__ADDR      (REG_TYPECAST_UWORD  0xb0000040)
#define R_PAR_ECP16_DATA__SVAL      REG_SVAL_SHADOW
#define R_PAR_ECP16_DATA__SVAL_I    REG_SVAL_I_SHADOW
#define R_PAR_ECP16_DATA__TYPECAST  REG_TYPECAST_UWORD
#define R_PAR_ECP16_DATA__TYPE      (REG_UWORD)
#define R_PAR_ECP16_DATA__GET       REG_GET_RW
#define R_PAR_ECP16_DATA__IGET      REG_IGET_RW
#define R_PAR_ECP16_DATA__SET       REG_SET_RW
#define R_PAR_ECP16_DATA__ISET      REG_ISET_RW
#define R_PAR_ECP16_DATA__SET_VAL   REG_SET_VAL_RW
#define R_PAR_ECP16_DATA__EQL       REG_EQL_RW
#define R_PAR_ECP16_DATA__IEQL      REG_IEQL_RW
#define R_PAR_ECP16_DATA__RD        REG_RD_RW
#define R_PAR_ECP16_DATA__IRD       REG_IRD_RW
#define R_PAR_ECP16_DATA__WR        REG_WR_RW
#define R_PAR_ECP16_DATA__IWR       REG_IWR_RW

#define R_PAR_ECP16_DATA__WRITE(addr,value) \
  (*(addr) = (value))
#define R_PAR_ECP16_DATA__READ(addr) \
  (*(addr))

#define R_PAR_ECP16_DATA__data__data__MASK 0x0000ffffU

#define R_PAR_ECP16_DATA__data__MAX 0xffff

#define R_PAR_ECP16_DATA__data__MIN 0

#define R_PAR_ECP16_DATA__data__BITNR 0

#define R_PAR_ECP16_DATA__data__data__VAL REG_VAL_VAL


#endif

/*
 *  R_PHY_COUNTERS
 *  - type:  RO
 *  - addr:  0xb00000ac
 *  - group: Network interface registers
 */

#if USE_GROUP__Network_interface_registers

#define R_PHY_COUNTERS__ADDR      (REG_TYPECAST_UDWORD  0xb00000ac)
#define R_PHY_COUNTERS__SVAL      REG_SVAL_SHADOW
#define R_PHY_COUNTERS__SVAL_I    REG_SVAL_I_SHADOW
#define R_PHY_COUNTERS__TYPECAST  REG_TYPECAST_UDWORD
#define R_PHY_COUNTERS__TYPE      (REG_UDWORD)
#define R_PHY_COUNTERS__GET       REG_GET_RO
#define R_PHY_COUNTERS__IGET      REG_IGET_RO
#define R_PHY_COUNTERS__SET       REG_SET_RO
#define R_PHY_COUNTERS__ISET      REG_ISET_RO
#define R_PHY_COUNTERS__SET_VAL   REG_SET_VAL_RO
#define R_PHY_COUNTERS__EQL       REG_EQL_RO
#define R_PHY_COUNTERS__IEQL      REG_IEQL_RO
#define R_PHY_COUNTERS__RD        REG_RD_RO
#define R_PHY_COUNTERS__IRD       REG_IRD_RO
#define R_PHY_COUNTERS__WR        REG_WR_RO
#define R_PHY_COUNTERS__IWR       REG_IWR_RO

#define R_PHY_COUNTERS__READ(addr) \
  (*(addr))

#define R_PHY_COUNTERS__sqe_test_error__sqe_test_error__MASK 0x0000ff00U
#define R_PHY_COUNTERS__carrier_loss__carrier_loss__MASK 0x000000ffU

#define R_PHY_COUNTERS__sqe_test_error__MAX 0xff
#define R_PHY_COUNTERS__carrier_loss__MAX 0xff

#define R_PHY_COUNTERS__sqe_test_error__MIN 0
#define R_PHY_COUNTERS__carrier_loss__MIN 0

#define R_PHY_COUNTERS__sqe_test_error__BITNR 8
#define R_PHY_COUNTERS__carrier_loss__BITNR 0

#define R_PHY_COUNTERS__sqe_test_error__sqe_test_error__VAL REG_VAL_VAL
#define R_PHY_COUNTERS__carrier_loss__carrier_loss__VAL REG_VAL_VAL


#endif

/*
 *  R_PORT_G_DATA
 *  - type:  RW
 *  - addr:  0xb0000028
 *  - group: General config registers
 */

#if USE_GROUP__General_config_registers

#define R_PORT_G_DATA__ADDR      (REG_TYPECAST_UDWORD  0xb0000028)
#define R_PORT_G_DATA__SVAL      REG_SVAL_SHADOW
#define R_PORT_G_DATA__SVAL_I    REG_SVAL_I_SHADOW
#define R_PORT_G_DATA__TYPECAST  REG_TYPECAST_UDWORD
#define R_PORT_G_DATA__TYPE      (REG_UDWORD)
#define R_PORT_G_DATA__GET       REG_GET_RW
#define R_PORT_G_DATA__IGET      REG_IGET_RW
#define R_PORT_G_DATA__SET       REG_SET_RW
#define R_PORT_G_DATA__ISET      REG_ISET_RW
#define R_PORT_G_DATA__SET_VAL   REG_SET_VAL_RW
#define R_PORT_G_DATA__EQL       REG_EQL_RW
#define R_PORT_G_DATA__IEQL      REG_IEQL_RW
#define R_PORT_G_DATA__RD        REG_RD_RW
#define R_PORT_G_DATA__IRD       REG_IRD_RW
#define R_PORT_G_DATA__WR        REG_WR_RW
#define R_PORT_G_DATA__IWR       REG_IWR_RW

#define R_PORT_G_DATA__WRITE(addr,value) \
  (*(addr) = (value))
#define R_PORT_G_DATA__READ(addr) \
  (*(addr))

#define R_PORT_G_DATA__data__data__MASK 0xffffffffU

#define R_PORT_G_DATA__data__MAX 0xffffffff

#define R_PORT_G_DATA__data__MIN 0

#define R_PORT_G_DATA__data__BITNR 0

#define R_PORT_G_DATA__data__data__VAL REG_VAL_VAL


#endif

/*
 *  R_PORT_PA_DATA
 *  - type:  WO
 *  - addr:  0xb0000030
 *  - group: General port configuration registers
 */

#if USE_GROUP__General_port_configuration_registers

#define R_PORT_PA_DATA__ADDR      (REG_TYPECAST_BYTE  0xb0000030)

#ifndef REG_NO_SHADOW
#define R_PORT_PA_DATA__SADDR     (REG_STYPECAST_BYTE (reg_shadow__hwregs.R_PORT_PA_SET + 0))
#define R_PORT_PA_DATA__IADDR     (REG_STYPECAST_BYTE (reg_initiated__hwregs.R_PORT_PA_SET + 0))
#else /* REG_NO_SHADOW */
#define R_PORT_PA_DATA__SADDR     (REG_STYPECAST_BYTE (&reg_shadow__hwregs))
#define R_PORT_PA_DATA__IADDR     (REG_STYPECAST_BYTE (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_PORT_PA_DATA__STYPECAST REG_STYPECAST_BYTE
#define R_PORT_PA_DATA__SVAL      REG_SVAL_SHADOW
#define R_PORT_PA_DATA__SVAL_I    REG_SVAL_I_SHADOW
#define R_PORT_PA_DATA__TYPECAST  REG_TYPECAST_BYTE
#define R_PORT_PA_DATA__TYPE      (REG_BYTE)
#define R_PORT_PA_DATA__GET       REG_GET_WO
#define R_PORT_PA_DATA__IGET      REG_IGET_WO
#define R_PORT_PA_DATA__SET       REG_SET_WO
#define R_PORT_PA_DATA__ISET      REG_ISET_WO
#define R_PORT_PA_DATA__SET_VAL   REG_SET_VAL_WO
#define R_PORT_PA_DATA__EQL       REG_EQL_WO
#define R_PORT_PA_DATA__IEQL      REG_IEQL_WO
#define R_PORT_PA_DATA__RD        REG_RD_WO
#define R_PORT_PA_DATA__IRD       REG_IRD_WO
#define R_PORT_PA_DATA__WR        REG_WR_WO
#define R_PORT_PA_DATA__IWR       REG_IWR_WO

#define R_PORT_PA_DATA__WRITE(addr,value) \
  (*(addr) = (value))

#define R_PORT_PA_DATA__data_out__data_out__MASK 0x000000ffU

#define R_PORT_PA_DATA__data_out__MAX 255

#define R_PORT_PA_DATA__data_out__MIN 0

#define R_PORT_PA_DATA__data_out__BITNR 0

#define R_PORT_PA_DATA__data_out__data_out__VAL REG_VAL_VAL


#endif

/*
 *  R_PORT_PA_DIR
 *  - type:  WO
 *  - addr:  0xb0000031
 *  - group: General port configuration registers
 */

#if USE_GROUP__General_port_configuration_registers

#define R_PORT_PA_DIR__ADDR      (REG_TYPECAST_BYTE  0xb0000031)

#ifndef REG_NO_SHADOW
#define R_PORT_PA_DIR__SADDR     (REG_STYPECAST_BYTE (reg_shadow__hwregs.R_PORT_PA_SET + 1))
#define R_PORT_PA_DIR__IADDR     (REG_STYPECAST_BYTE (reg_initiated__hwregs.R_PORT_PA_SET + 1))
#else /* REG_NO_SHADOW */
#define R_PORT_PA_DIR__SADDR     (REG_STYPECAST_BYTE (&reg_shadow__hwregs))
#define R_PORT_PA_DIR__IADDR     (REG_STYPECAST_BYTE (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_PORT_PA_DIR__STYPECAST REG_STYPECAST_BYTE
#define R_PORT_PA_DIR__SVAL      REG_SVAL_SHADOW
#define R_PORT_PA_DIR__SVAL_I    REG_SVAL_I_SHADOW
#define R_PORT_PA_DIR__TYPECAST  REG_TYPECAST_BYTE
#define R_PORT_PA_DIR__TYPE      (REG_BYTE)
#define R_PORT_PA_DIR__GET       REG_GET_WO
#define R_PORT_PA_DIR__IGET      REG_IGET_WO
#define R_PORT_PA_DIR__SET       REG_SET_WO
#define R_PORT_PA_DIR__ISET      REG_ISET_WO
#define R_PORT_PA_DIR__SET_VAL   REG_SET_VAL_WO
#define R_PORT_PA_DIR__EQL       REG_EQL_WO
#define R_PORT_PA_DIR__IEQL      REG_IEQL_WO
#define R_PORT_PA_DIR__RD        REG_RD_WO
#define R_PORT_PA_DIR__IRD       REG_IRD_WO
#define R_PORT_PA_DIR__WR        REG_WR_WO
#define R_PORT_PA_DIR__IWR       REG_IWR_WO

#define R_PORT_PA_DIR__WRITE(addr,value) \
  (*(addr) = (value))

#define R_PORT_PA_DIR__dir7__dir7__MASK 0x00000080U
#define R_PORT_PA_DIR__dir6__dir6__MASK 0x00000040U
#define R_PORT_PA_DIR__dir5__dir5__MASK 0x00000020U
#define R_PORT_PA_DIR__dir4__dir4__MASK 0x00000010U
#define R_PORT_PA_DIR__dir3__dir3__MASK 0x00000008U
#define R_PORT_PA_DIR__dir2__dir2__MASK 0x00000004U
#define R_PORT_PA_DIR__dir1__dir1__MASK 0x00000002U
#define R_PORT_PA_DIR__dir0__dir0__MASK 0x00000001U

#define R_PORT_PA_DIR__dir7__MAX 0x1
#define R_PORT_PA_DIR__dir6__MAX 0x1
#define R_PORT_PA_DIR__dir5__MAX 0x1
#define R_PORT_PA_DIR__dir4__MAX 0x1
#define R_PORT_PA_DIR__dir3__MAX 0x1
#define R_PORT_PA_DIR__dir2__MAX 0x1
#define R_PORT_PA_DIR__dir1__MAX 0x1
#define R_PORT_PA_DIR__dir0__MAX 0x1

#define R_PORT_PA_DIR__dir7__MIN 0
#define R_PORT_PA_DIR__dir6__MIN 0
#define R_PORT_PA_DIR__dir5__MIN 0
#define R_PORT_PA_DIR__dir4__MIN 0
#define R_PORT_PA_DIR__dir3__MIN 0
#define R_PORT_PA_DIR__dir2__MIN 0
#define R_PORT_PA_DIR__dir1__MIN 0
#define R_PORT_PA_DIR__dir0__MIN 0

#define R_PORT_PA_DIR__dir7__BITNR 7
#define R_PORT_PA_DIR__dir6__BITNR 6
#define R_PORT_PA_DIR__dir5__BITNR 5
#define R_PORT_PA_DIR__dir4__BITNR 4
#define R_PORT_PA_DIR__dir3__BITNR 3
#define R_PORT_PA_DIR__dir2__BITNR 2
#define R_PORT_PA_DIR__dir1__BITNR 1
#define R_PORT_PA_DIR__dir0__BITNR 0

#define R_PORT_PA_DIR__dir7__dir7__VAL REG_VAL_ENUM
#define R_PORT_PA_DIR__dir6__dir6__VAL REG_VAL_ENUM
#define R_PORT_PA_DIR__dir5__dir5__VAL REG_VAL_ENUM
#define R_PORT_PA_DIR__dir4__dir4__VAL REG_VAL_ENUM
#define R_PORT_PA_DIR__dir3__dir3__VAL REG_VAL_ENUM
#define R_PORT_PA_DIR__dir2__dir2__VAL REG_VAL_ENUM
#define R_PORT_PA_DIR__dir1__dir1__VAL REG_VAL_ENUM
#define R_PORT_PA_DIR__dir0__dir0__VAL REG_VAL_ENUM

#define R_PORT_PA_DIR__dir7__dir7__input 0
#define R_PORT_PA_DIR__dir7__dir7__output 1
#define R_PORT_PA_DIR__dir6__dir6__input 0
#define R_PORT_PA_DIR__dir6__dir6__output 1
#define R_PORT_PA_DIR__dir5__dir5__input 0
#define R_PORT_PA_DIR__dir5__dir5__output 1
#define R_PORT_PA_DIR__dir4__dir4__input 0
#define R_PORT_PA_DIR__dir4__dir4__output 1
#define R_PORT_PA_DIR__dir3__dir3__input 0
#define R_PORT_PA_DIR__dir3__dir3__output 1
#define R_PORT_PA_DIR__dir2__dir2__input 0
#define R_PORT_PA_DIR__dir2__dir2__output 1
#define R_PORT_PA_DIR__dir1__dir1__input 0
#define R_PORT_PA_DIR__dir1__dir1__output 1
#define R_PORT_PA_DIR__dir0__dir0__input 0
#define R_PORT_PA_DIR__dir0__dir0__output 1

#endif

/*
 *  R_PORT_PA_READ
 *  - type:  RO
 *  - addr:  0xb0000030
 *  - group: General port configuration registers
 */

#if USE_GROUP__General_port_configuration_registers

#define R_PORT_PA_READ__ADDR      (REG_TYPECAST_UDWORD  0xb0000030)
#define R_PORT_PA_READ__SVAL      REG_SVAL_SHADOW
#define R_PORT_PA_READ__SVAL_I    REG_SVAL_I_SHADOW
#define R_PORT_PA_READ__TYPECAST  REG_TYPECAST_UDWORD
#define R_PORT_PA_READ__TYPE      (REG_UDWORD)
#define R_PORT_PA_READ__GET       REG_GET_RO
#define R_PORT_PA_READ__IGET      REG_IGET_RO
#define R_PORT_PA_READ__SET       REG_SET_RO
#define R_PORT_PA_READ__ISET      REG_ISET_RO
#define R_PORT_PA_READ__SET_VAL   REG_SET_VAL_RO
#define R_PORT_PA_READ__EQL       REG_EQL_RO
#define R_PORT_PA_READ__IEQL      REG_IEQL_RO
#define R_PORT_PA_READ__RD        REG_RD_RO
#define R_PORT_PA_READ__IRD       REG_IRD_RO
#define R_PORT_PA_READ__WR        REG_WR_RO
#define R_PORT_PA_READ__IWR       REG_IWR_RO

#define R_PORT_PA_READ__READ(addr) \
  (*(addr))

#define R_PORT_PA_READ__data_in__data_in__MASK 0x000000ffU

#define R_PORT_PA_READ__data_in__MAX 255

#define R_PORT_PA_READ__data_in__MIN 0

#define R_PORT_PA_READ__data_in__BITNR 0

#define R_PORT_PA_READ__data_in__data_in__VAL REG_VAL_VAL


#endif

/*
 *  R_PORT_PA_SET
 *  - type:  WO
 *  - addr:  0xb0000030
 *  - group: General port configuration registers
 */

#if USE_GROUP__General_port_configuration_registers

#define R_PORT_PA_SET__ADDR      (REG_TYPECAST_UDWORD  0xb0000030)

#ifndef REG_NO_SHADOW
#define R_PORT_PA_SET__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_PORT_PA_SET + 0))
#define R_PORT_PA_SET__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_PORT_PA_SET + 0))
#else /* REG_NO_SHADOW */
#define R_PORT_PA_SET__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_PORT_PA_SET__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_PORT_PA_SET__STYPECAST REG_STYPECAST_UDWORD
#define R_PORT_PA_SET__SVAL      REG_SVAL_SHADOW
#define R_PORT_PA_SET__SVAL_I    REG_SVAL_I_SHADOW
#define R_PORT_PA_SET__TYPECAST  REG_TYPECAST_UDWORD
#define R_PORT_PA_SET__TYPE      (REG_UDWORD)
#define R_PORT_PA_SET__GET       REG_GET_WO
#define R_PORT_PA_SET__IGET      REG_IGET_WO
#define R_PORT_PA_SET__SET       REG_SET_WO
#define R_PORT_PA_SET__ISET      REG_ISET_WO
#define R_PORT_PA_SET__SET_VAL   REG_SET_VAL_WO
#define R_PORT_PA_SET__EQL       REG_EQL_WO
#define R_PORT_PA_SET__IEQL      REG_IEQL_WO
#define R_PORT_PA_SET__RD        REG_RD_WO
#define R_PORT_PA_SET__IRD       REG_IRD_WO
#define R_PORT_PA_SET__WR        REG_WR_WO
#define R_PORT_PA_SET__IWR       REG_IWR_WO

#define R_PORT_PA_SET__WRITE(addr,value) \
  (*(addr) = (value))

#define R_PORT_PA_SET__dir7__dir7__MASK 0x00008000U
#define R_PORT_PA_SET__dir6__dir6__MASK 0x00004000U
#define R_PORT_PA_SET__dir5__dir5__MASK 0x00002000U
#define R_PORT_PA_SET__dir4__dir4__MASK 0x00001000U
#define R_PORT_PA_SET__dir3__dir3__MASK 0x00000800U
#define R_PORT_PA_SET__dir2__dir2__MASK 0x00000400U
#define R_PORT_PA_SET__dir1__dir1__MASK 0x00000200U
#define R_PORT_PA_SET__dir0__dir0__MASK 0x00000100U
#define R_PORT_PA_SET__data_out__data_out__MASK 0x000000ffU

#define R_PORT_PA_SET__dir7__MAX 0x1
#define R_PORT_PA_SET__dir6__MAX 0x1
#define R_PORT_PA_SET__dir5__MAX 0x1
#define R_PORT_PA_SET__dir4__MAX 0x1
#define R_PORT_PA_SET__dir3__MAX 0x1
#define R_PORT_PA_SET__dir2__MAX 0x1
#define R_PORT_PA_SET__dir1__MAX 0x1
#define R_PORT_PA_SET__dir0__MAX 0x1
#define R_PORT_PA_SET__data_out__MAX 255

#define R_PORT_PA_SET__dir7__MIN 0
#define R_PORT_PA_SET__dir6__MIN 0
#define R_PORT_PA_SET__dir5__MIN 0
#define R_PORT_PA_SET__dir4__MIN 0
#define R_PORT_PA_SET__dir3__MIN 0
#define R_PORT_PA_SET__dir2__MIN 0
#define R_PORT_PA_SET__dir1__MIN 0
#define R_PORT_PA_SET__dir0__MIN 0
#define R_PORT_PA_SET__data_out__MIN 0

#define R_PORT_PA_SET__dir7__BITNR 15
#define R_PORT_PA_SET__dir6__BITNR 14
#define R_PORT_PA_SET__dir5__BITNR 13
#define R_PORT_PA_SET__dir4__BITNR 12
#define R_PORT_PA_SET__dir3__BITNR 11
#define R_PORT_PA_SET__dir2__BITNR 10
#define R_PORT_PA_SET__dir1__BITNR 9
#define R_PORT_PA_SET__dir0__BITNR 8
#define R_PORT_PA_SET__data_out__BITNR 0

#define R_PORT_PA_SET__dir7__dir7__VAL REG_VAL_ENUM
#define R_PORT_PA_SET__dir6__dir6__VAL REG_VAL_ENUM
#define R_PORT_PA_SET__dir5__dir5__VAL REG_VAL_ENUM
#define R_PORT_PA_SET__dir4__dir4__VAL REG_VAL_ENUM
#define R_PORT_PA_SET__dir3__dir3__VAL REG_VAL_ENUM
#define R_PORT_PA_SET__dir2__dir2__VAL REG_VAL_ENUM
#define R_PORT_PA_SET__dir1__dir1__VAL REG_VAL_ENUM
#define R_PORT_PA_SET__dir0__dir0__VAL REG_VAL_ENUM
#define R_PORT_PA_SET__data_out__data_out__VAL REG_VAL_VAL

#define R_PORT_PA_SET__dir7__dir7__input 0
#define R_PORT_PA_SET__dir7__dir7__output 1
#define R_PORT_PA_SET__dir6__dir6__input 0
#define R_PORT_PA_SET__dir6__dir6__output 1
#define R_PORT_PA_SET__dir5__dir5__input 0
#define R_PORT_PA_SET__dir5__dir5__output 1
#define R_PORT_PA_SET__dir4__dir4__input 0
#define R_PORT_PA_SET__dir4__dir4__output 1
#define R_PORT_PA_SET__dir3__dir3__input 0
#define R_PORT_PA_SET__dir3__dir3__output 1
#define R_PORT_PA_SET__dir2__dir2__input 0
#define R_PORT_PA_SET__dir2__dir2__output 1
#define R_PORT_PA_SET__dir1__dir1__input 0
#define R_PORT_PA_SET__dir1__dir1__output 1
#define R_PORT_PA_SET__dir0__dir0__input 0
#define R_PORT_PA_SET__dir0__dir0__output 1

#endif

/*
 *  R_PORT_PB_CONFIG
 *  - type:  WO
 *  - addr:  0xb000003a
 *  - group: General port configuration registers
 */

#if USE_GROUP__General_port_configuration_registers

#define R_PORT_PB_CONFIG__ADDR      (REG_TYPECAST_BYTE  0xb000003a)

#ifndef REG_NO_SHADOW
#define R_PORT_PB_CONFIG__SADDR     (REG_STYPECAST_BYTE (reg_shadow__hwregs.R_PORT_PB_SET + 2))
#define R_PORT_PB_CONFIG__IADDR     (REG_STYPECAST_BYTE (reg_initiated__hwregs.R_PORT_PB_SET + 2))
#else /* REG_NO_SHADOW */
#define R_PORT_PB_CONFIG__SADDR     (REG_STYPECAST_BYTE (&reg_shadow__hwregs))
#define R_PORT_PB_CONFIG__IADDR     (REG_STYPECAST_BYTE (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_PORT_PB_CONFIG__STYPECAST REG_STYPECAST_BYTE
#define R_PORT_PB_CONFIG__SVAL      REG_SVAL_SHADOW
#define R_PORT_PB_CONFIG__SVAL_I    REG_SVAL_I_SHADOW
#define R_PORT_PB_CONFIG__TYPECAST  REG_TYPECAST_BYTE
#define R_PORT_PB_CONFIG__TYPE      (REG_BYTE)
#define R_PORT_PB_CONFIG__GET       REG_GET_WO
#define R_PORT_PB_CONFIG__IGET      REG_IGET_WO
#define R_PORT_PB_CONFIG__SET       REG_SET_WO
#define R_PORT_PB_CONFIG__ISET      REG_ISET_WO
#define R_PORT_PB_CONFIG__SET_VAL   REG_SET_VAL_WO
#define R_PORT_PB_CONFIG__EQL       REG_EQL_WO
#define R_PORT_PB_CONFIG__IEQL      REG_IEQL_WO
#define R_PORT_PB_CONFIG__RD        REG_RD_WO
#define R_PORT_PB_CONFIG__IRD       REG_IRD_WO
#define R_PORT_PB_CONFIG__WR        REG_WR_WO
#define R_PORT_PB_CONFIG__IWR       REG_IWR_WO

#define R_PORT_PB_CONFIG__WRITE(addr,value) \
  (*(addr) = (value))

#define R_PORT_PB_CONFIG__cs7__cs7__MASK 0x00000080U
#define R_PORT_PB_CONFIG__cs6__cs6__MASK 0x00000040U
#define R_PORT_PB_CONFIG__cs5__cs5__MASK 0x00000020U
#define R_PORT_PB_CONFIG__cs4__cs4__MASK 0x00000010U
#define R_PORT_PB_CONFIG__cs3__cs3__MASK 0x00000008U
#define R_PORT_PB_CONFIG__cs2__cs2__MASK 0x00000004U
#define R_PORT_PB_CONFIG__scsi1__scsi1__MASK 0x00000002U
#define R_PORT_PB_CONFIG__scsi0__scsi0__MASK 0x00000001U

#define R_PORT_PB_CONFIG__cs7__MAX 0x1
#define R_PORT_PB_CONFIG__cs6__MAX 0x1
#define R_PORT_PB_CONFIG__cs5__MAX 0x1
#define R_PORT_PB_CONFIG__cs4__MAX 0x1
#define R_PORT_PB_CONFIG__cs3__MAX 0x1
#define R_PORT_PB_CONFIG__cs2__MAX 0x1
#define R_PORT_PB_CONFIG__scsi1__MAX 0x1
#define R_PORT_PB_CONFIG__scsi0__MAX 0x1

#define R_PORT_PB_CONFIG__cs7__MIN 0
#define R_PORT_PB_CONFIG__cs6__MIN 0
#define R_PORT_PB_CONFIG__cs5__MIN 0
#define R_PORT_PB_CONFIG__cs4__MIN 0
#define R_PORT_PB_CONFIG__cs3__MIN 0
#define R_PORT_PB_CONFIG__cs2__MIN 0
#define R_PORT_PB_CONFIG__scsi1__MIN 0
#define R_PORT_PB_CONFIG__scsi0__MIN 0

#define R_PORT_PB_CONFIG__cs7__BITNR 7
#define R_PORT_PB_CONFIG__cs6__BITNR 6
#define R_PORT_PB_CONFIG__cs5__BITNR 5
#define R_PORT_PB_CONFIG__cs4__BITNR 4
#define R_PORT_PB_CONFIG__cs3__BITNR 3
#define R_PORT_PB_CONFIG__cs2__BITNR 2
#define R_PORT_PB_CONFIG__scsi1__BITNR 1
#define R_PORT_PB_CONFIG__scsi0__BITNR 0

#define R_PORT_PB_CONFIG__cs7__cs7__VAL REG_VAL_ENUM
#define R_PORT_PB_CONFIG__cs6__cs6__VAL REG_VAL_ENUM
#define R_PORT_PB_CONFIG__cs5__cs5__VAL REG_VAL_ENUM
#define R_PORT_PB_CONFIG__cs4__cs4__VAL REG_VAL_ENUM
#define R_PORT_PB_CONFIG__cs3__cs3__VAL REG_VAL_ENUM
#define R_PORT_PB_CONFIG__cs2__cs2__VAL REG_VAL_ENUM
#define R_PORT_PB_CONFIG__scsi1__scsi1__VAL REG_VAL_ENUM
#define R_PORT_PB_CONFIG__scsi0__scsi0__VAL REG_VAL_ENUM

#define R_PORT_PB_CONFIG__cs7__cs7__cs 1
#define R_PORT_PB_CONFIG__cs7__cs7__port 0
#define R_PORT_PB_CONFIG__cs6__cs6__cs 1
#define R_PORT_PB_CONFIG__cs6__cs6__port 0
#define R_PORT_PB_CONFIG__cs5__cs5__cs 1
#define R_PORT_PB_CONFIG__cs5__cs5__port 0
#define R_PORT_PB_CONFIG__cs4__cs4__cs 1
#define R_PORT_PB_CONFIG__cs4__cs4__port 0
#define R_PORT_PB_CONFIG__cs3__cs3__cs 1
#define R_PORT_PB_CONFIG__cs3__cs3__port 0
#define R_PORT_PB_CONFIG__cs2__cs2__cs 1
#define R_PORT_PB_CONFIG__cs2__cs2__port 0
#define R_PORT_PB_CONFIG__scsi1__scsi1__enph 1
#define R_PORT_PB_CONFIG__scsi1__scsi1__port_cs 0
#define R_PORT_PB_CONFIG__scsi0__scsi0__enph 1
#define R_PORT_PB_CONFIG__scsi0__scsi0__port_cs 0

#endif

/*
 *  R_PORT_PB_DATA
 *  - type:  WO
 *  - addr:  0xb0000038
 *  - group: General port configuration registers
 */

#if USE_GROUP__General_port_configuration_registers

#define R_PORT_PB_DATA__ADDR      (REG_TYPECAST_BYTE  0xb0000038)

#ifndef REG_NO_SHADOW
#define R_PORT_PB_DATA__SADDR     (REG_STYPECAST_BYTE (reg_shadow__hwregs.R_PORT_PB_SET + 0))
#define R_PORT_PB_DATA__IADDR     (REG_STYPECAST_BYTE (reg_initiated__hwregs.R_PORT_PB_SET + 0))
#else /* REG_NO_SHADOW */
#define R_PORT_PB_DATA__SADDR     (REG_STYPECAST_BYTE (&reg_shadow__hwregs))
#define R_PORT_PB_DATA__IADDR     (REG_STYPECAST_BYTE (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_PORT_PB_DATA__STYPECAST REG_STYPECAST_BYTE
#define R_PORT_PB_DATA__SVAL      REG_SVAL_SHADOW
#define R_PORT_PB_DATA__SVAL_I    REG_SVAL_I_SHADOW
#define R_PORT_PB_DATA__TYPECAST  REG_TYPECAST_BYTE
#define R_PORT_PB_DATA__TYPE      (REG_BYTE)
#define R_PORT_PB_DATA__GET       REG_GET_WO
#define R_PORT_PB_DATA__IGET      REG_IGET_WO
#define R_PORT_PB_DATA__SET       REG_SET_WO
#define R_PORT_PB_DATA__ISET      REG_ISET_WO
#define R_PORT_PB_DATA__SET_VAL   REG_SET_VAL_WO
#define R_PORT_PB_DATA__EQL       REG_EQL_WO
#define R_PORT_PB_DATA__IEQL      REG_IEQL_WO
#define R_PORT_PB_DATA__RD        REG_RD_WO
#define R_PORT_PB_DATA__IRD       REG_IRD_WO
#define R_PORT_PB_DATA__WR        REG_WR_WO
#define R_PORT_PB_DATA__IWR       REG_IWR_WO

#define R_PORT_PB_DATA__WRITE(addr,value) \
  (*(addr) = (value))

#define R_PORT_PB_DATA__data_out__data_out__MASK 0x000000ffU

#define R_PORT_PB_DATA__data_out__MAX 255

#define R_PORT_PB_DATA__data_out__MIN 0

#define R_PORT_PB_DATA__data_out__BITNR 0

#define R_PORT_PB_DATA__data_out__data_out__VAL REG_VAL_VAL


#endif

/*
 *  R_PORT_PB_DIR
 *  - type:  WO
 *  - addr:  0xb0000039
 *  - group: General port configuration registers
 */

#if USE_GROUP__General_port_configuration_registers

#define R_PORT_PB_DIR__ADDR      (REG_TYPECAST_BYTE  0xb0000039)

#ifndef REG_NO_SHADOW
#define R_PORT_PB_DIR__SADDR     (REG_STYPECAST_BYTE (reg_shadow__hwregs.R_PORT_PB_SET + 1))
#define R_PORT_PB_DIR__IADDR     (REG_STYPECAST_BYTE (reg_initiated__hwregs.R_PORT_PB_SET + 1))
#else /* REG_NO_SHADOW */
#define R_PORT_PB_DIR__SADDR     (REG_STYPECAST_BYTE (&reg_shadow__hwregs))
#define R_PORT_PB_DIR__IADDR     (REG_STYPECAST_BYTE (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_PORT_PB_DIR__STYPECAST REG_STYPECAST_BYTE
#define R_PORT_PB_DIR__SVAL      REG_SVAL_SHADOW
#define R_PORT_PB_DIR__SVAL_I    REG_SVAL_I_SHADOW
#define R_PORT_PB_DIR__TYPECAST  REG_TYPECAST_BYTE
#define R_PORT_PB_DIR__TYPE      (REG_BYTE)
#define R_PORT_PB_DIR__GET       REG_GET_WO
#define R_PORT_PB_DIR__IGET      REG_IGET_WO
#define R_PORT_PB_DIR__SET       REG_SET_WO
#define R_PORT_PB_DIR__ISET      REG_ISET_WO
#define R_PORT_PB_DIR__SET_VAL   REG_SET_VAL_WO
#define R_PORT_PB_DIR__EQL       REG_EQL_WO
#define R_PORT_PB_DIR__IEQL      REG_IEQL_WO
#define R_PORT_PB_DIR__RD        REG_RD_WO
#define R_PORT_PB_DIR__IRD       REG_IRD_WO
#define R_PORT_PB_DIR__WR        REG_WR_WO
#define R_PORT_PB_DIR__IWR       REG_IWR_WO

#define R_PORT_PB_DIR__WRITE(addr,value) \
  (*(addr) = (value))

#define R_PORT_PB_DIR__dir7__dir7__MASK 0x00000080U
#define R_PORT_PB_DIR__dir6__dir6__MASK 0x00000040U
#define R_PORT_PB_DIR__dir5__dir5__MASK 0x00000020U
#define R_PORT_PB_DIR__dir4__dir4__MASK 0x00000010U
#define R_PORT_PB_DIR__dir3__dir3__MASK 0x00000008U
#define R_PORT_PB_DIR__dir2__dir2__MASK 0x00000004U
#define R_PORT_PB_DIR__dir1__dir1__MASK 0x00000002U
#define R_PORT_PB_DIR__dir0__dir0__MASK 0x00000001U

#define R_PORT_PB_DIR__dir7__MAX 0x1
#define R_PORT_PB_DIR__dir6__MAX 0x1
#define R_PORT_PB_DIR__dir5__MAX 0x1
#define R_PORT_PB_DIR__dir4__MAX 0x1
#define R_PORT_PB_DIR__dir3__MAX 0x1
#define R_PORT_PB_DIR__dir2__MAX 0x1
#define R_PORT_PB_DIR__dir1__MAX 0x1
#define R_PORT_PB_DIR__dir0__MAX 0x1

#define R_PORT_PB_DIR__dir7__MIN 0
#define R_PORT_PB_DIR__dir6__MIN 0
#define R_PORT_PB_DIR__dir5__MIN 0
#define R_PORT_PB_DIR__dir4__MIN 0
#define R_PORT_PB_DIR__dir3__MIN 0
#define R_PORT_PB_DIR__dir2__MIN 0
#define R_PORT_PB_DIR__dir1__MIN 0
#define R_PORT_PB_DIR__dir0__MIN 0

#define R_PORT_PB_DIR__dir7__BITNR 7
#define R_PORT_PB_DIR__dir6__BITNR 6
#define R_PORT_PB_DIR__dir5__BITNR 5
#define R_PORT_PB_DIR__dir4__BITNR 4
#define R_PORT_PB_DIR__dir3__BITNR 3
#define R_PORT_PB_DIR__dir2__BITNR 2
#define R_PORT_PB_DIR__dir1__BITNR 1
#define R_PORT_PB_DIR__dir0__BITNR 0

#define R_PORT_PB_DIR__dir7__dir7__VAL REG_VAL_ENUM
#define R_PORT_PB_DIR__dir6__dir6__VAL REG_VAL_ENUM
#define R_PORT_PB_DIR__dir5__dir5__VAL REG_VAL_ENUM
#define R_PORT_PB_DIR__dir4__dir4__VAL REG_VAL_ENUM
#define R_PORT_PB_DIR__dir3__dir3__VAL REG_VAL_ENUM
#define R_PORT_PB_DIR__dir2__dir2__VAL REG_VAL_ENUM
#define R_PORT_PB_DIR__dir1__dir1__VAL REG_VAL_ENUM
#define R_PORT_PB_DIR__dir0__dir0__VAL REG_VAL_ENUM

#define R_PORT_PB_DIR__dir7__dir7__input 0
#define R_PORT_PB_DIR__dir7__dir7__output 1
#define R_PORT_PB_DIR__dir6__dir6__input 0
#define R_PORT_PB_DIR__dir6__dir6__output 1
#define R_PORT_PB_DIR__dir5__dir5__input 0
#define R_PORT_PB_DIR__dir5__dir5__output 1
#define R_PORT_PB_DIR__dir4__dir4__input 0
#define R_PORT_PB_DIR__dir4__dir4__output 1
#define R_PORT_PB_DIR__dir3__dir3__input 0
#define R_PORT_PB_DIR__dir3__dir3__output 1
#define R_PORT_PB_DIR__dir2__dir2__input 0
#define R_PORT_PB_DIR__dir2__dir2__output 1
#define R_PORT_PB_DIR__dir1__dir1__input 0
#define R_PORT_PB_DIR__dir1__dir1__output 1
#define R_PORT_PB_DIR__dir0__dir0__input 0
#define R_PORT_PB_DIR__dir0__dir0__output 1

#endif

/*
 *  R_PORT_PB_I2C
 *  - type:  WO
 *  - addr:  0xb000003b
 *  - group: General port configuration registers
 */

#if USE_GROUP__General_port_configuration_registers

#define R_PORT_PB_I2C__ADDR      (REG_TYPECAST_BYTE  0xb000003b)

#ifndef REG_NO_SHADOW
#define R_PORT_PB_I2C__SADDR     (REG_STYPECAST_BYTE (reg_shadow__hwregs.R_PORT_PB_SET + 3))
#define R_PORT_PB_I2C__IADDR     (REG_STYPECAST_BYTE (reg_initiated__hwregs.R_PORT_PB_SET + 3))
#else /* REG_NO_SHADOW */
#define R_PORT_PB_I2C__SADDR     (REG_STYPECAST_BYTE (&reg_shadow__hwregs))
#define R_PORT_PB_I2C__IADDR     (REG_STYPECAST_BYTE (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_PORT_PB_I2C__STYPECAST REG_STYPECAST_BYTE
#define R_PORT_PB_I2C__SVAL      REG_SVAL_SHADOW
#define R_PORT_PB_I2C__SVAL_I    REG_SVAL_I_SHADOW
#define R_PORT_PB_I2C__TYPECAST  REG_TYPECAST_BYTE
#define R_PORT_PB_I2C__TYPE      (REG_BYTE)
#define R_PORT_PB_I2C__GET       REG_GET_WO
#define R_PORT_PB_I2C__IGET      REG_IGET_WO
#define R_PORT_PB_I2C__SET       REG_SET_WO
#define R_PORT_PB_I2C__ISET      REG_ISET_WO
#define R_PORT_PB_I2C__SET_VAL   REG_SET_VAL_WO
#define R_PORT_PB_I2C__EQL       REG_EQL_WO
#define R_PORT_PB_I2C__IEQL      REG_IEQL_WO
#define R_PORT_PB_I2C__RD        REG_RD_WO
#define R_PORT_PB_I2C__IRD       REG_IRD_WO
#define R_PORT_PB_I2C__WR        REG_WR_WO
#define R_PORT_PB_I2C__IWR       REG_IWR_WO

#define R_PORT_PB_I2C__WRITE(addr,value) \
  (*(addr) = (value))

#define R_PORT_PB_I2C__syncser3__syncser3__MASK 0x00000020U
#define R_PORT_PB_I2C__syncser1__syncser1__MASK 0x00000010U
#define R_PORT_PB_I2C__i2c_en__i2c_en__MASK 0x00000008U
#define R_PORT_PB_I2C__i2c_d__i2c_d__MASK 0x00000004U
#define R_PORT_PB_I2C__i2c_clk__i2c_clk__MASK 0x00000002U
#define R_PORT_PB_I2C__i2c_oe___i2c_oe___MASK 0x00000001U

#define R_PORT_PB_I2C__syncser3__MAX 0x1
#define R_PORT_PB_I2C__syncser1__MAX 0x1
#define R_PORT_PB_I2C__i2c_en__MAX 0x1
#define R_PORT_PB_I2C__i2c_d__MAX 1
#define R_PORT_PB_I2C__i2c_clk__MAX 1
#define R_PORT_PB_I2C__i2c_oe___MAX 0x1

#define R_PORT_PB_I2C__syncser3__MIN 0
#define R_PORT_PB_I2C__syncser1__MIN 0
#define R_PORT_PB_I2C__i2c_en__MIN 0
#define R_PORT_PB_I2C__i2c_d__MIN 0
#define R_PORT_PB_I2C__i2c_clk__MIN 0
#define R_PORT_PB_I2C__i2c_oe___MIN 0

#define R_PORT_PB_I2C__syncser3__BITNR 5
#define R_PORT_PB_I2C__syncser1__BITNR 4
#define R_PORT_PB_I2C__i2c_en__BITNR 3
#define R_PORT_PB_I2C__i2c_d__BITNR 2
#define R_PORT_PB_I2C__i2c_clk__BITNR 1
#define R_PORT_PB_I2C__i2c_oe___BITNR 0

#define R_PORT_PB_I2C__syncser3__syncser3__VAL REG_VAL_ENUM
#define R_PORT_PB_I2C__syncser1__syncser1__VAL REG_VAL_ENUM
#define R_PORT_PB_I2C__i2c_en__i2c_en__VAL REG_VAL_ENUM
#define R_PORT_PB_I2C__i2c_d__i2c_d__VAL REG_VAL_VAL
#define R_PORT_PB_I2C__i2c_clk__i2c_clk__VAL REG_VAL_VAL
#define R_PORT_PB_I2C__i2c_oe___i2c_oe___VAL REG_VAL_ENUM

#define R_PORT_PB_I2C__syncser3__syncser3__port_cs 0
#define R_PORT_PB_I2C__syncser3__syncser3__ss3extra 1
#define R_PORT_PB_I2C__syncser1__syncser1__port_cs 0
#define R_PORT_PB_I2C__syncser1__syncser1__ss1extra 1
#define R_PORT_PB_I2C__i2c_en__i2c_en__off 0
#define R_PORT_PB_I2C__i2c_en__i2c_en__on 1
#define R_PORT_PB_I2C__i2c_oe___i2c_oe___disable 1
#define R_PORT_PB_I2C__i2c_oe___i2c_oe___enable 0

#endif

/*
 *  R_PORT_PB_READ
 *  - type:  RO
 *  - addr:  0xb0000038
 *  - group: General port configuration registers
 */

#if USE_GROUP__General_port_configuration_registers

#define R_PORT_PB_READ__ADDR      (REG_TYPECAST_UDWORD  0xb0000038)
#define R_PORT_PB_READ__SVAL      REG_SVAL_SHADOW
#define R_PORT_PB_READ__SVAL_I    REG_SVAL_I_SHADOW
#define R_PORT_PB_READ__TYPECAST  REG_TYPECAST_UDWORD
#define R_PORT_PB_READ__TYPE      (REG_UDWORD)
#define R_PORT_PB_READ__GET       REG_GET_RO
#define R_PORT_PB_READ__IGET      REG_IGET_RO
#define R_PORT_PB_READ__SET       REG_SET_RO
#define R_PORT_PB_READ__ISET      REG_ISET_RO
#define R_PORT_PB_READ__SET_VAL   REG_SET_VAL_RO
#define R_PORT_PB_READ__EQL       REG_EQL_RO
#define R_PORT_PB_READ__IEQL      REG_IEQL_RO
#define R_PORT_PB_READ__RD        REG_RD_RO
#define R_PORT_PB_READ__IRD       REG_IRD_RO
#define R_PORT_PB_READ__WR        REG_WR_RO
#define R_PORT_PB_READ__IWR       REG_IWR_RO

#define R_PORT_PB_READ__READ(addr) \
  (*(addr))

#define R_PORT_PB_READ__data_in__data_in__MASK 0x000000ffU

#define R_PORT_PB_READ__data_in__MAX 255

#define R_PORT_PB_READ__data_in__MIN 0

#define R_PORT_PB_READ__data_in__BITNR 0

#define R_PORT_PB_READ__data_in__data_in__VAL REG_VAL_VAL


#endif

/*
 *  R_PORT_PB_SET
 *  - type:  WO
 *  - addr:  0xb0000038
 *  - group: General port configuration registers
 */

#if USE_GROUP__General_port_configuration_registers

#define R_PORT_PB_SET__ADDR      (REG_TYPECAST_UDWORD  0xb0000038)

#ifndef REG_NO_SHADOW
#define R_PORT_PB_SET__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_PORT_PB_SET + 0))
#define R_PORT_PB_SET__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_PORT_PB_SET + 0))
#else /* REG_NO_SHADOW */
#define R_PORT_PB_SET__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_PORT_PB_SET__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_PORT_PB_SET__STYPECAST REG_STYPECAST_UDWORD
#define R_PORT_PB_SET__SVAL      REG_SVAL_SHADOW
#define R_PORT_PB_SET__SVAL_I    REG_SVAL_I_SHADOW
#define R_PORT_PB_SET__TYPECAST  REG_TYPECAST_UDWORD
#define R_PORT_PB_SET__TYPE      (REG_UDWORD)
#define R_PORT_PB_SET__GET       REG_GET_WO
#define R_PORT_PB_SET__IGET      REG_IGET_WO
#define R_PORT_PB_SET__SET       REG_SET_WO
#define R_PORT_PB_SET__ISET      REG_ISET_WO
#define R_PORT_PB_SET__SET_VAL   REG_SET_VAL_WO
#define R_PORT_PB_SET__EQL       REG_EQL_WO
#define R_PORT_PB_SET__IEQL      REG_IEQL_WO
#define R_PORT_PB_SET__RD        REG_RD_WO
#define R_PORT_PB_SET__IRD       REG_IRD_WO
#define R_PORT_PB_SET__WR        REG_WR_WO
#define R_PORT_PB_SET__IWR       REG_IWR_WO

#define R_PORT_PB_SET__WRITE(addr,value) \
  (*(addr) = (value))

#define R_PORT_PB_SET__syncser3__syncser3__MASK 0x20000000U
#define R_PORT_PB_SET__syncser1__syncser1__MASK 0x10000000U
#define R_PORT_PB_SET__i2c_en__i2c_en__MASK 0x08000000U
#define R_PORT_PB_SET__i2c_d__i2c_d__MASK 0x04000000U
#define R_PORT_PB_SET__i2c_clk__i2c_clk__MASK 0x02000000U
#define R_PORT_PB_SET__i2c_oe___i2c_oe___MASK 0x01000000U
#define R_PORT_PB_SET__cs7__cs7__MASK 0x00800000U
#define R_PORT_PB_SET__cs6__cs6__MASK 0x00400000U
#define R_PORT_PB_SET__cs5__cs5__MASK 0x00200000U
#define R_PORT_PB_SET__cs4__cs4__MASK 0x00100000U
#define R_PORT_PB_SET__cs3__cs3__MASK 0x00080000U
#define R_PORT_PB_SET__cs2__cs2__MASK 0x00040000U
#define R_PORT_PB_SET__scsi1__scsi1__MASK 0x00020000U
#define R_PORT_PB_SET__scsi0__scsi0__MASK 0x00010000U
#define R_PORT_PB_SET__dir7__dir7__MASK 0x00008000U
#define R_PORT_PB_SET__dir6__dir6__MASK 0x00004000U
#define R_PORT_PB_SET__dir5__dir5__MASK 0x00002000U
#define R_PORT_PB_SET__dir4__dir4__MASK 0x00001000U
#define R_PORT_PB_SET__dir3__dir3__MASK 0x00000800U
#define R_PORT_PB_SET__dir2__dir2__MASK 0x00000400U
#define R_PORT_PB_SET__dir1__dir1__MASK 0x00000200U
#define R_PORT_PB_SET__dir0__dir0__MASK 0x00000100U
#define R_PORT_PB_SET__data_out__data_out__MASK 0x000000ffU

#define R_PORT_PB_SET__syncser3__MAX 0x1
#define R_PORT_PB_SET__syncser1__MAX 0x1
#define R_PORT_PB_SET__i2c_en__MAX 0x1
#define R_PORT_PB_SET__i2c_d__MAX 1
#define R_PORT_PB_SET__i2c_clk__MAX 1
#define R_PORT_PB_SET__i2c_oe___MAX 0x1
#define R_PORT_PB_SET__cs7__MAX 0x1
#define R_PORT_PB_SET__cs6__MAX 0x1
#define R_PORT_PB_SET__cs5__MAX 0x1
#define R_PORT_PB_SET__cs4__MAX 0x1
#define R_PORT_PB_SET__cs3__MAX 0x1
#define R_PORT_PB_SET__cs2__MAX 0x1
#define R_PORT_PB_SET__scsi1__MAX 0x1
#define R_PORT_PB_SET__scsi0__MAX 0x1
#define R_PORT_PB_SET__dir7__MAX 0x1
#define R_PORT_PB_SET__dir6__MAX 0x1
#define R_PORT_PB_SET__dir5__MAX 0x1
#define R_PORT_PB_SET__dir4__MAX 0x1
#define R_PORT_PB_SET__dir3__MAX 0x1
#define R_PORT_PB_SET__dir2__MAX 0x1
#define R_PORT_PB_SET__dir1__MAX 0x1
#define R_PORT_PB_SET__dir0__MAX 0x1
#define R_PORT_PB_SET__data_out__MAX 255

#define R_PORT_PB_SET__syncser3__MIN 0
#define R_PORT_PB_SET__syncser1__MIN 0
#define R_PORT_PB_SET__i2c_en__MIN 0
#define R_PORT_PB_SET__i2c_d__MIN 0
#define R_PORT_PB_SET__i2c_clk__MIN 0
#define R_PORT_PB_SET__i2c_oe___MIN 0
#define R_PORT_PB_SET__cs7__MIN 0
#define R_PORT_PB_SET__cs6__MIN 0
#define R_PORT_PB_SET__cs5__MIN 0
#define R_PORT_PB_SET__cs4__MIN 0
#define R_PORT_PB_SET__cs3__MIN 0
#define R_PORT_PB_SET__cs2__MIN 0
#define R_PORT_PB_SET__scsi1__MIN 0
#define R_PORT_PB_SET__scsi0__MIN 0
#define R_PORT_PB_SET__dir7__MIN 0
#define R_PORT_PB_SET__dir6__MIN 0
#define R_PORT_PB_SET__dir5__MIN 0
#define R_PORT_PB_SET__dir4__MIN 0
#define R_PORT_PB_SET__dir3__MIN 0
#define R_PORT_PB_SET__dir2__MIN 0
#define R_PORT_PB_SET__dir1__MIN 0
#define R_PORT_PB_SET__dir0__MIN 0
#define R_PORT_PB_SET__data_out__MIN 0

#define R_PORT_PB_SET__syncser3__BITNR 29
#define R_PORT_PB_SET__syncser1__BITNR 28
#define R_PORT_PB_SET__i2c_en__BITNR 27
#define R_PORT_PB_SET__i2c_d__BITNR 26
#define R_PORT_PB_SET__i2c_clk__BITNR 25
#define R_PORT_PB_SET__i2c_oe___BITNR 24
#define R_PORT_PB_SET__cs7__BITNR 23
#define R_PORT_PB_SET__cs6__BITNR 22
#define R_PORT_PB_SET__cs5__BITNR 21
#define R_PORT_PB_SET__cs4__BITNR 20
#define R_PORT_PB_SET__cs3__BITNR 19
#define R_PORT_PB_SET__cs2__BITNR 18
#define R_PORT_PB_SET__scsi1__BITNR 17
#define R_PORT_PB_SET__scsi0__BITNR 16
#define R_PORT_PB_SET__dir7__BITNR 15
#define R_PORT_PB_SET__dir6__BITNR 14
#define R_PORT_PB_SET__dir5__BITNR 13
#define R_PORT_PB_SET__dir4__BITNR 12
#define R_PORT_PB_SET__dir3__BITNR 11
#define R_PORT_PB_SET__dir2__BITNR 10
#define R_PORT_PB_SET__dir1__BITNR 9
#define R_PORT_PB_SET__dir0__BITNR 8
#define R_PORT_PB_SET__data_out__BITNR 0

#define R_PORT_PB_SET__syncser3__syncser3__VAL REG_VAL_ENUM
#define R_PORT_PB_SET__syncser1__syncser1__VAL REG_VAL_ENUM
#define R_PORT_PB_SET__i2c_en__i2c_en__VAL REG_VAL_ENUM
#define R_PORT_PB_SET__i2c_d__i2c_d__VAL REG_VAL_VAL
#define R_PORT_PB_SET__i2c_clk__i2c_clk__VAL REG_VAL_VAL
#define R_PORT_PB_SET__i2c_oe___i2c_oe___VAL REG_VAL_ENUM
#define R_PORT_PB_SET__cs7__cs7__VAL REG_VAL_ENUM
#define R_PORT_PB_SET__cs6__cs6__VAL REG_VAL_ENUM
#define R_PORT_PB_SET__cs5__cs5__VAL REG_VAL_ENUM
#define R_PORT_PB_SET__cs4__cs4__VAL REG_VAL_ENUM
#define R_PORT_PB_SET__cs3__cs3__VAL REG_VAL_ENUM
#define R_PORT_PB_SET__cs2__cs2__VAL REG_VAL_ENUM
#define R_PORT_PB_SET__scsi1__scsi1__VAL REG_VAL_ENUM
#define R_PORT_PB_SET__scsi0__scsi0__VAL REG_VAL_ENUM
#define R_PORT_PB_SET__dir7__dir7__VAL REG_VAL_ENUM
#define R_PORT_PB_SET__dir6__dir6__VAL REG_VAL_ENUM
#define R_PORT_PB_SET__dir5__dir5__VAL REG_VAL_ENUM
#define R_PORT_PB_SET__dir4__dir4__VAL REG_VAL_ENUM
#define R_PORT_PB_SET__dir3__dir3__VAL REG_VAL_ENUM
#define R_PORT_PB_SET__dir2__dir2__VAL REG_VAL_ENUM
#define R_PORT_PB_SET__dir1__dir1__VAL REG_VAL_ENUM
#define R_PORT_PB_SET__dir0__dir0__VAL REG_VAL_ENUM
#define R_PORT_PB_SET__data_out__data_out__VAL REG_VAL_VAL

#define R_PORT_PB_SET__syncser3__syncser3__port_cs 0
#define R_PORT_PB_SET__syncser3__syncser3__ss3extra 1
#define R_PORT_PB_SET__syncser1__syncser1__port_cs 0
#define R_PORT_PB_SET__syncser1__syncser1__ss1extra 1
#define R_PORT_PB_SET__i2c_en__i2c_en__off 0
#define R_PORT_PB_SET__i2c_en__i2c_en__on 1
#define R_PORT_PB_SET__i2c_oe___i2c_oe___disable 1
#define R_PORT_PB_SET__i2c_oe___i2c_oe___enable 0
#define R_PORT_PB_SET__cs7__cs7__cs 1
#define R_PORT_PB_SET__cs7__cs7__port 0
#define R_PORT_PB_SET__cs6__cs6__cs 1
#define R_PORT_PB_SET__cs6__cs6__port 0
#define R_PORT_PB_SET__cs5__cs5__cs 1
#define R_PORT_PB_SET__cs5__cs5__port 0
#define R_PORT_PB_SET__cs4__cs4__cs 1
#define R_PORT_PB_SET__cs4__cs4__port 0
#define R_PORT_PB_SET__cs3__cs3__cs 1
#define R_PORT_PB_SET__cs3__cs3__port 0
#define R_PORT_PB_SET__cs2__cs2__cs 1
#define R_PORT_PB_SET__cs2__cs2__port 0
#define R_PORT_PB_SET__scsi1__scsi1__enph 1
#define R_PORT_PB_SET__scsi1__scsi1__port_cs 0
#define R_PORT_PB_SET__scsi0__scsi0__enph 1
#define R_PORT_PB_SET__scsi0__scsi0__port_cs 0
#define R_PORT_PB_SET__dir7__dir7__input 0
#define R_PORT_PB_SET__dir7__dir7__output 1
#define R_PORT_PB_SET__dir6__dir6__input 0
#define R_PORT_PB_SET__dir6__dir6__output 1
#define R_PORT_PB_SET__dir5__dir5__input 0
#define R_PORT_PB_SET__dir5__dir5__output 1
#define R_PORT_PB_SET__dir4__dir4__input 0
#define R_PORT_PB_SET__dir4__dir4__output 1
#define R_PORT_PB_SET__dir3__dir3__input 0
#define R_PORT_PB_SET__dir3__dir3__output 1
#define R_PORT_PB_SET__dir2__dir2__input 0
#define R_PORT_PB_SET__dir2__dir2__output 1
#define R_PORT_PB_SET__dir1__dir1__input 0
#define R_PORT_PB_SET__dir1__dir1__output 1
#define R_PORT_PB_SET__dir0__dir0__input 0
#define R_PORT_PB_SET__dir0__dir0__output 1

#endif

/*
 *  R_PRESCALE_STATUS
 *  - type:  RO
 *  - addr:  0xb00000f0
 *  - group: Timer registers
 */

#if USE_GROUP__Timer_registers

#define R_PRESCALE_STATUS__ADDR      (REG_TYPECAST_UDWORD  0xb00000f0)
#define R_PRESCALE_STATUS__SVAL      REG_SVAL_SHADOW
#define R_PRESCALE_STATUS__SVAL_I    REG_SVAL_I_SHADOW
#define R_PRESCALE_STATUS__TYPECAST  REG_TYPECAST_UDWORD
#define R_PRESCALE_STATUS__TYPE      (REG_UDWORD)
#define R_PRESCALE_STATUS__GET       REG_GET_RO
#define R_PRESCALE_STATUS__IGET      REG_IGET_RO
#define R_PRESCALE_STATUS__SET       REG_SET_RO
#define R_PRESCALE_STATUS__ISET      REG_ISET_RO
#define R_PRESCALE_STATUS__SET_VAL   REG_SET_VAL_RO
#define R_PRESCALE_STATUS__EQL       REG_EQL_RO
#define R_PRESCALE_STATUS__IEQL      REG_IEQL_RO
#define R_PRESCALE_STATUS__RD        REG_RD_RO
#define R_PRESCALE_STATUS__IRD       REG_IRD_RO
#define R_PRESCALE_STATUS__WR        REG_WR_RO
#define R_PRESCALE_STATUS__IWR       REG_IWR_RO

#define R_PRESCALE_STATUS__READ(addr) \
  (*(addr))

#define R_PRESCALE_STATUS__ser_status__ser_status__MASK 0xffff0000U
#define R_PRESCALE_STATUS__tim_status__tim_status__MASK 0x0000ffffU

#define R_PRESCALE_STATUS__ser_status__MAX 0xffff
#define R_PRESCALE_STATUS__tim_status__MAX 0xffff

#define R_PRESCALE_STATUS__ser_status__MIN 0
#define R_PRESCALE_STATUS__tim_status__MIN 0

#define R_PRESCALE_STATUS__ser_status__BITNR 16
#define R_PRESCALE_STATUS__tim_status__BITNR 0

#define R_PRESCALE_STATUS__ser_status__ser_status__VAL REG_VAL_VAL
#define R_PRESCALE_STATUS__tim_status__tim_status__VAL REG_VAL_VAL


#endif

/*
 *  R_REC_COUNTERS
 *  - type:  RO
 *  - addr:  0xb00000a4
 *  - group: Network interface registers
 */

#if USE_GROUP__Network_interface_registers

#define R_REC_COUNTERS__ADDR      (REG_TYPECAST_UDWORD  0xb00000a4)
#define R_REC_COUNTERS__SVAL      REG_SVAL_SHADOW
#define R_REC_COUNTERS__SVAL_I    REG_SVAL_I_SHADOW
#define R_REC_COUNTERS__TYPECAST  REG_TYPECAST_UDWORD
#define R_REC_COUNTERS__TYPE      (REG_UDWORD)
#define R_REC_COUNTERS__GET       REG_GET_RO
#define R_REC_COUNTERS__IGET      REG_IGET_RO
#define R_REC_COUNTERS__SET       REG_SET_RO
#define R_REC_COUNTERS__ISET      REG_ISET_RO
#define R_REC_COUNTERS__SET_VAL   REG_SET_VAL_RO
#define R_REC_COUNTERS__EQL       REG_EQL_RO
#define R_REC_COUNTERS__IEQL      REG_IEQL_RO
#define R_REC_COUNTERS__RD        REG_RD_RO
#define R_REC_COUNTERS__IRD       REG_IRD_RO
#define R_REC_COUNTERS__WR        REG_WR_RO
#define R_REC_COUNTERS__IWR       REG_IWR_RO

#define R_REC_COUNTERS__READ(addr) \
  (*(addr))

#define R_REC_COUNTERS__congestion__congestion__MASK 0xff000000U
#define R_REC_COUNTERS__oversize__oversize__MASK 0x00ff0000U
#define R_REC_COUNTERS__alignment_error__alignment_error__MASK 0x0000ff00U
#define R_REC_COUNTERS__crc_error__crc_error__MASK 0x000000ffU

#define R_REC_COUNTERS__congestion__MAX 0xff
#define R_REC_COUNTERS__oversize__MAX 0xff
#define R_REC_COUNTERS__alignment_error__MAX 0xff
#define R_REC_COUNTERS__crc_error__MAX 0xff

#define R_REC_COUNTERS__congestion__MIN 0
#define R_REC_COUNTERS__oversize__MIN 0
#define R_REC_COUNTERS__alignment_error__MIN 0
#define R_REC_COUNTERS__crc_error__MIN 0

#define R_REC_COUNTERS__congestion__BITNR 24
#define R_REC_COUNTERS__oversize__BITNR 16
#define R_REC_COUNTERS__alignment_error__BITNR 8
#define R_REC_COUNTERS__crc_error__BITNR 0

#define R_REC_COUNTERS__congestion__congestion__VAL REG_VAL_VAL
#define R_REC_COUNTERS__oversize__oversize__VAL REG_VAL_VAL
#define R_REC_COUNTERS__alignment_error__alignment_error__VAL REG_VAL_VAL
#define R_REC_COUNTERS__crc_error__crc_error__VAL REG_VAL_VAL


#endif

/*
 *  R_SCSI0_CMD
 *  - type:  WO
 *  - addr:  0xb0000042
 *  - group: SCSI registers
 */

#if USE_GROUP__SCSI_registers

#define R_SCSI0_CMD__ADDR      (REG_TYPECAST_BYTE  0xb0000042)

#ifndef REG_NO_SHADOW
#define R_SCSI0_CMD__SADDR     (REG_STYPECAST_BYTE (reg_shadow__hwregs.R_ATA_CTRL_DATA + 2))
#define R_SCSI0_CMD__IADDR     (REG_STYPECAST_BYTE (reg_initiated__hwregs.R_ATA_CTRL_DATA + 2))
#else /* REG_NO_SHADOW */
#define R_SCSI0_CMD__SADDR     (REG_STYPECAST_BYTE (&reg_shadow__hwregs))
#define R_SCSI0_CMD__IADDR     (REG_STYPECAST_BYTE (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_SCSI0_CMD__STYPECAST REG_STYPECAST_BYTE
#define R_SCSI0_CMD__SVAL      REG_SVAL_SHADOW
#define R_SCSI0_CMD__SVAL_I    REG_SVAL_I_SHADOW
#define R_SCSI0_CMD__TYPECAST  REG_TYPECAST_BYTE
#define R_SCSI0_CMD__TYPE      (REG_BYTE)
#define R_SCSI0_CMD__GET       REG_GET_WO
#define R_SCSI0_CMD__IGET      REG_IGET_WO
#define R_SCSI0_CMD__SET       REG_SET_WO
#define R_SCSI0_CMD__ISET      REG_ISET_WO
#define R_SCSI0_CMD__SET_VAL   REG_SET_VAL_WO
#define R_SCSI0_CMD__EQL       REG_EQL_WO
#define R_SCSI0_CMD__IEQL      REG_IEQL_WO
#define R_SCSI0_CMD__RD        REG_RD_WO
#define R_SCSI0_CMD__IRD       REG_IRD_WO
#define R_SCSI0_CMD__WR        REG_WR_WO
#define R_SCSI0_CMD__IWR       REG_IWR_WO

#define R_SCSI0_CMD__WRITE(addr,value) \
  (*(addr) = (value))

/* From control-file '/n/asic/projects/etrax_ng/include//hwregs.ctrl' */
#define R_SCSI0_CMD__FIRST 0
#define R_SCSI0_CMD__IOFFSET 12
#define R_SCSI0_CMD__LAST 1
#define R_SCSI0_CMD__OFFSET 16
#define R_SCSI0_CMD__SOFFSET 12
/* end */

#define R_SCSI0_CMD__asynch_setup__asynch_setup__MASK 0x000000f0U
#define R_SCSI0_CMD__command__command__MASK 0x0000000fU

#define R_SCSI0_CMD__asynch_setup__MAX 0xf
#define R_SCSI0_CMD__command__MAX 0xf

#define R_SCSI0_CMD__asynch_setup__MIN 0
#define R_SCSI0_CMD__command__MIN 0

#define R_SCSI0_CMD__asynch_setup__BITNR 4
#define R_SCSI0_CMD__command__BITNR 0

#define R_SCSI0_CMD__asynch_setup__asynch_setup__VAL REG_VAL_VAL
#define R_SCSI0_CMD__command__command__VAL REG_VAL_ENUM

#define R_SCSI0_CMD__command__command__arb_only 6
#define R_SCSI0_CMD__command__command__full_din_1 0
#define R_SCSI0_CMD__command__command__full_din_3 8
#define R_SCSI0_CMD__command__command__full_dout_1 1
#define R_SCSI0_CMD__command__command__full_dout_3 9
#define R_SCSI0_CMD__command__command__full_stat_1 2
#define R_SCSI0_CMD__command__command__full_stat_3 10
#define R_SCSI0_CMD__command__command__man_data_in 11
#define R_SCSI0_CMD__command__command__man_data_out 12
#define R_SCSI0_CMD__command__command__man_rat 13
#define R_SCSI0_CMD__command__command__resel_din 3
#define R_SCSI0_CMD__command__command__resel_dout 4
#define R_SCSI0_CMD__command__command__resel_stat 5

#endif

/*
 *  R_SCSI0_CMD_DATA
 *  - type:  WO
 *  - addr:  0xb0000040
 *  - group: SCSI registers
 */

#if USE_GROUP__SCSI_registers

#define R_SCSI0_CMD_DATA__ADDR      (REG_TYPECAST_UDWORD  0xb0000040)

#ifndef REG_NO_SHADOW
#define R_SCSI0_CMD_DATA__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_ATA_CTRL_DATA + 0))
#define R_SCSI0_CMD_DATA__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_ATA_CTRL_DATA + 0))
#else /* REG_NO_SHADOW */
#define R_SCSI0_CMD_DATA__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_SCSI0_CMD_DATA__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_SCSI0_CMD_DATA__STYPECAST REG_STYPECAST_UDWORD
#define R_SCSI0_CMD_DATA__SVAL      REG_SVAL_SHADOW
#define R_SCSI0_CMD_DATA__SVAL_I    REG_SVAL_I_SHADOW
#define R_SCSI0_CMD_DATA__TYPECAST  REG_TYPECAST_UDWORD
#define R_SCSI0_CMD_DATA__TYPE      (REG_UDWORD)
#define R_SCSI0_CMD_DATA__GET       REG_GET_WO
#define R_SCSI0_CMD_DATA__IGET      REG_IGET_WO
#define R_SCSI0_CMD_DATA__SET       REG_SET_WO
#define R_SCSI0_CMD_DATA__ISET      REG_ISET_WO
#define R_SCSI0_CMD_DATA__SET_VAL   REG_SET_VAL_WO
#define R_SCSI0_CMD_DATA__EQL       REG_EQL_WO
#define R_SCSI0_CMD_DATA__IEQL      REG_IEQL_WO
#define R_SCSI0_CMD_DATA__RD        REG_RD_WO
#define R_SCSI0_CMD_DATA__IRD       REG_IRD_WO
#define R_SCSI0_CMD_DATA__WR        REG_WR_WO
#define R_SCSI0_CMD_DATA__IWR       REG_IWR_WO

#define R_SCSI0_CMD_DATA__WRITE(addr,value) \
  (*(addr) = (value))

/* From control-file '/n/asic/projects/etrax_ng/include//hwregs.ctrl' */
#define R_SCSI0_CMD_DATA__FIRST 0
#define R_SCSI0_CMD_DATA__IOFFSET 12
#define R_SCSI0_CMD_DATA__LAST 1
#define R_SCSI0_CMD_DATA__OFFSET 16
#define R_SCSI0_CMD_DATA__SOFFSET 12
/* end */

#define R_SCSI0_CMD_DATA__parity_in__parity_in__MASK 0x04000000U
#define R_SCSI0_CMD_DATA__skip__skip__MASK 0x02000000U
#define R_SCSI0_CMD_DATA__clr_status__clr_status__MASK 0x01000000U
#define R_SCSI0_CMD_DATA__asynch_setup__asynch_setup__MASK 0x00f00000U
#define R_SCSI0_CMD_DATA__command__command__MASK 0x000f0000U
#define R_SCSI0_CMD_DATA__data_out__data_out__MASK 0x0000ffffU

#define R_SCSI0_CMD_DATA__parity_in__MAX 0x1
#define R_SCSI0_CMD_DATA__skip__MAX 0x1
#define R_SCSI0_CMD_DATA__clr_status__MAX 0x1
#define R_SCSI0_CMD_DATA__asynch_setup__MAX 0xf
#define R_SCSI0_CMD_DATA__command__MAX 0xf
#define R_SCSI0_CMD_DATA__data_out__MAX 0xffff

#define R_SCSI0_CMD_DATA__parity_in__MIN 0
#define R_SCSI0_CMD_DATA__skip__MIN 0
#define R_SCSI0_CMD_DATA__clr_status__MIN 0
#define R_SCSI0_CMD_DATA__asynch_setup__MIN 0
#define R_SCSI0_CMD_DATA__command__MIN 0
#define R_SCSI0_CMD_DATA__data_out__MIN 0

#define R_SCSI0_CMD_DATA__parity_in__BITNR 26
#define R_SCSI0_CMD_DATA__skip__BITNR 25
#define R_SCSI0_CMD_DATA__clr_status__BITNR 24
#define R_SCSI0_CMD_DATA__asynch_setup__BITNR 20
#define R_SCSI0_CMD_DATA__command__BITNR 16
#define R_SCSI0_CMD_DATA__data_out__BITNR 0

#define R_SCSI0_CMD_DATA__parity_in__parity_in__VAL REG_VAL_ENUM
#define R_SCSI0_CMD_DATA__skip__skip__VAL REG_VAL_ENUM
#define R_SCSI0_CMD_DATA__clr_status__clr_status__VAL REG_VAL_ENUM
#define R_SCSI0_CMD_DATA__asynch_setup__asynch_setup__VAL REG_VAL_VAL
#define R_SCSI0_CMD_DATA__command__command__VAL REG_VAL_ENUM
#define R_SCSI0_CMD_DATA__data_out__data_out__VAL REG_VAL_VAL

#define R_SCSI0_CMD_DATA__parity_in__parity_in__off 1
#define R_SCSI0_CMD_DATA__parity_in__parity_in__on 0
#define R_SCSI0_CMD_DATA__skip__skip__off 0
#define R_SCSI0_CMD_DATA__skip__skip__on 1
#define R_SCSI0_CMD_DATA__clr_status__clr_status__nop 0
#define R_SCSI0_CMD_DATA__clr_status__clr_status__yes 1
#define R_SCSI0_CMD_DATA__command__command__arb_only 6
#define R_SCSI0_CMD_DATA__command__command__full_din_1 0
#define R_SCSI0_CMD_DATA__command__command__full_din_3 8
#define R_SCSI0_CMD_DATA__command__command__full_dout_1 1
#define R_SCSI0_CMD_DATA__command__command__full_dout_3 9
#define R_SCSI0_CMD_DATA__command__command__full_stat_1 2
#define R_SCSI0_CMD_DATA__command__command__full_stat_3 10
#define R_SCSI0_CMD_DATA__command__command__man_data_in 11
#define R_SCSI0_CMD_DATA__command__command__man_data_out 12
#define R_SCSI0_CMD_DATA__command__command__man_rat 13
#define R_SCSI0_CMD_DATA__command__command__resel_din 3
#define R_SCSI0_CMD_DATA__command__command__resel_dout 4
#define R_SCSI0_CMD_DATA__command__command__resel_stat 5

#endif

/*
 *  R_SCSI0_CTRL
 *  - type:  WO
 *  - addr:  0xb0000044
 *  - group: SCSI registers
 */

#if USE_GROUP__SCSI_registers

#define R_SCSI0_CTRL__ADDR      (REG_TYPECAST_UDWORD  0xb0000044)

#ifndef REG_NO_SHADOW
#define R_SCSI0_CTRL__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_ATA_CONFIG + 0))
#define R_SCSI0_CTRL__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_ATA_CONFIG + 0))
#else /* REG_NO_SHADOW */
#define R_SCSI0_CTRL__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_SCSI0_CTRL__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_SCSI0_CTRL__STYPECAST REG_STYPECAST_UDWORD
#define R_SCSI0_CTRL__SVAL      REG_SVAL_SHADOW
#define R_SCSI0_CTRL__SVAL_I    REG_SVAL_I_SHADOW
#define R_SCSI0_CTRL__TYPECAST  REG_TYPECAST_UDWORD
#define R_SCSI0_CTRL__TYPE      (REG_UDWORD)
#define R_SCSI0_CTRL__GET       REG_GET_WO
#define R_SCSI0_CTRL__IGET      REG_IGET_WO
#define R_SCSI0_CTRL__SET       REG_SET_WO
#define R_SCSI0_CTRL__ISET      REG_ISET_WO
#define R_SCSI0_CTRL__SET_VAL   REG_SET_VAL_WO
#define R_SCSI0_CTRL__EQL       REG_EQL_WO
#define R_SCSI0_CTRL__IEQL      REG_IEQL_WO
#define R_SCSI0_CTRL__RD        REG_RD_WO
#define R_SCSI0_CTRL__IRD       REG_IRD_WO
#define R_SCSI0_CTRL__WR        REG_WR_WO
#define R_SCSI0_CTRL__IWR       REG_IWR_WO

#define R_SCSI0_CTRL__WRITE(addr,value) \
  (*(addr) = (value))

/* From control-file '/n/asic/projects/etrax_ng/include//hwregs.ctrl' */
#define R_SCSI0_CTRL__FIRST 0
#define R_SCSI0_CTRL__IOFFSET 12
#define R_SCSI0_CTRL__LAST 1
#define R_SCSI0_CTRL__OFFSET 16
#define R_SCSI0_CTRL__SOFFSET 12
/* end */

#define R_SCSI0_CTRL__id_type__id_type__MASK 0x80000000U
#define R_SCSI0_CTRL__sel_timeout__sel_timeout__MASK 0x7f000000U
#define R_SCSI0_CTRL__synch_per__synch_per__MASK 0x00ff0000U
#define R_SCSI0_CTRL__rst__rst__MASK 0x00008000U
#define R_SCSI0_CTRL__atn__atn__MASK 0x00004000U
#define R_SCSI0_CTRL__my_id__my_id__MASK 0x00001e00U
#define R_SCSI0_CTRL__target_id__target_id__MASK 0x000000f0U
#define R_SCSI0_CTRL__fast_20__fast_20__MASK 0x00000008U
#define R_SCSI0_CTRL__bus_width__bus_width__MASK 0x00000004U
#define R_SCSI0_CTRL__synch__synch__MASK 0x00000002U
#define R_SCSI0_CTRL__enable__enable__MASK 0x00000001U

#define R_SCSI0_CTRL__id_type__MAX 0x1
#define R_SCSI0_CTRL__sel_timeout__MAX 0x7f
#define R_SCSI0_CTRL__synch_per__MAX 0xff
#define R_SCSI0_CTRL__rst__MAX 0x1
#define R_SCSI0_CTRL__atn__MAX 0x1
#define R_SCSI0_CTRL__my_id__MAX 0xf
#define R_SCSI0_CTRL__target_id__MAX 0xf
#define R_SCSI0_CTRL__fast_20__MAX 0x1
#define R_SCSI0_CTRL__bus_width__MAX 0x1
#define R_SCSI0_CTRL__synch__MAX 0x1
#define R_SCSI0_CTRL__enable__MAX 0x1

#define R_SCSI0_CTRL__id_type__MIN 0
#define R_SCSI0_CTRL__sel_timeout__MIN 0
#define R_SCSI0_CTRL__synch_per__MIN 0
#define R_SCSI0_CTRL__rst__MIN 0
#define R_SCSI0_CTRL__atn__MIN 0
#define R_SCSI0_CTRL__my_id__MIN 0
#define R_SCSI0_CTRL__target_id__MIN 0
#define R_SCSI0_CTRL__fast_20__MIN 0
#define R_SCSI0_CTRL__bus_width__MIN 0
#define R_SCSI0_CTRL__synch__MIN 0
#define R_SCSI0_CTRL__enable__MIN 0

#define R_SCSI0_CTRL__id_type__BITNR 31
#define R_SCSI0_CTRL__sel_timeout__BITNR 24
#define R_SCSI0_CTRL__synch_per__BITNR 16
#define R_SCSI0_CTRL__rst__BITNR 15
#define R_SCSI0_CTRL__atn__BITNR 14
#define R_SCSI0_CTRL__my_id__BITNR 9
#define R_SCSI0_CTRL__target_id__BITNR 4
#define R_SCSI0_CTRL__fast_20__BITNR 3
#define R_SCSI0_CTRL__bus_width__BITNR 2
#define R_SCSI0_CTRL__synch__BITNR 1
#define R_SCSI0_CTRL__enable__BITNR 0

#define R_SCSI0_CTRL__id_type__id_type__VAL REG_VAL_ENUM
#define R_SCSI0_CTRL__sel_timeout__sel_timeout__VAL REG_VAL_VAL
#define R_SCSI0_CTRL__synch_per__synch_per__VAL REG_VAL_VAL
#define R_SCSI0_CTRL__rst__rst__VAL REG_VAL_ENUM
#define R_SCSI0_CTRL__atn__atn__VAL REG_VAL_ENUM
#define R_SCSI0_CTRL__my_id__my_id__VAL REG_VAL_VAL
#define R_SCSI0_CTRL__target_id__target_id__VAL REG_VAL_VAL
#define R_SCSI0_CTRL__fast_20__fast_20__VAL REG_VAL_ENUM
#define R_SCSI0_CTRL__bus_width__bus_width__VAL REG_VAL_ENUM
#define R_SCSI0_CTRL__synch__synch__VAL REG_VAL_ENUM
#define R_SCSI0_CTRL__enable__enable__VAL REG_VAL_ENUM

#define R_SCSI0_CTRL__id_type__id_type__hardware 0
#define R_SCSI0_CTRL__id_type__id_type__software 1
#define R_SCSI0_CTRL__rst__rst__no 0
#define R_SCSI0_CTRL__rst__rst__yes 1
#define R_SCSI0_CTRL__atn__atn__no 0
#define R_SCSI0_CTRL__atn__atn__yes 1
#define R_SCSI0_CTRL__fast_20__fast_20__no 0
#define R_SCSI0_CTRL__fast_20__fast_20__yes 1
#define R_SCSI0_CTRL__bus_width__bus_width__narrow 0
#define R_SCSI0_CTRL__bus_width__bus_width__wide 1
#define R_SCSI0_CTRL__synch__synch__asynch 0
#define R_SCSI0_CTRL__synch__synch__synch 1
#define R_SCSI0_CTRL__enable__enable__off 0
#define R_SCSI0_CTRL__enable__enable__on 1

#endif

/*
 *  R_SCSI0_DATA
 *  - type:  WO
 *  - addr:  0xb0000040
 *  - group: SCSI registers
 */

#if USE_GROUP__SCSI_registers

#define R_SCSI0_DATA__ADDR      (REG_TYPECAST_UWORD  0xb0000040)

#ifndef REG_NO_SHADOW
#define R_SCSI0_DATA__SADDR     (REG_STYPECAST_UWORD (reg_shadow__hwregs.R_ATA_CTRL_DATA + 0))
#define R_SCSI0_DATA__IADDR     (REG_STYPECAST_UWORD (reg_initiated__hwregs.R_ATA_CTRL_DATA + 0))
#else /* REG_NO_SHADOW */
#define R_SCSI0_DATA__SADDR     (REG_STYPECAST_UWORD (&reg_shadow__hwregs))
#define R_SCSI0_DATA__IADDR     (REG_STYPECAST_UWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_SCSI0_DATA__STYPECAST REG_STYPECAST_UWORD
#define R_SCSI0_DATA__SVAL      REG_SVAL_SHADOW
#define R_SCSI0_DATA__SVAL_I    REG_SVAL_I_SHADOW
#define R_SCSI0_DATA__TYPECAST  REG_TYPECAST_UWORD
#define R_SCSI0_DATA__TYPE      (REG_UWORD)
#define R_SCSI0_DATA__GET       REG_GET_WO
#define R_SCSI0_DATA__IGET      REG_IGET_WO
#define R_SCSI0_DATA__SET       REG_SET_WO
#define R_SCSI0_DATA__ISET      REG_ISET_WO
#define R_SCSI0_DATA__SET_VAL   REG_SET_VAL_WO
#define R_SCSI0_DATA__EQL       REG_EQL_WO
#define R_SCSI0_DATA__IEQL      REG_IEQL_WO
#define R_SCSI0_DATA__RD        REG_RD_WO
#define R_SCSI0_DATA__IRD       REG_IRD_WO
#define R_SCSI0_DATA__WR        REG_WR_WO
#define R_SCSI0_DATA__IWR       REG_IWR_WO

#define R_SCSI0_DATA__WRITE(addr,value) \
  (*(addr) = (value))

/* From control-file '/n/asic/projects/etrax_ng/include//hwregs.ctrl' */
#define R_SCSI0_DATA__FIRST 0
#define R_SCSI0_DATA__IOFFSET 12
#define R_SCSI0_DATA__LAST 1
#define R_SCSI0_DATA__OFFSET 16
#define R_SCSI0_DATA__SOFFSET 12
/* end */

#define R_SCSI0_DATA__data_out__data_out__MASK 0x0000ffffU

#define R_SCSI0_DATA__data_out__MAX 0xffff

#define R_SCSI0_DATA__data_out__MIN 0

#define R_SCSI0_DATA__data_out__BITNR 0

#define R_SCSI0_DATA__data_out__data_out__VAL REG_VAL_VAL


#endif

/*
 *  R_SCSI0_DATA_IN
 *  - type:  RO
 *  - addr:  0xb0000040
 *  - group: SCSI registers
 */

#if USE_GROUP__SCSI_registers

#define R_SCSI0_DATA_IN__ADDR      (REG_TYPECAST_UWORD  0xb0000040)
#define R_SCSI0_DATA_IN__SVAL      REG_SVAL_SHADOW
#define R_SCSI0_DATA_IN__SVAL_I    REG_SVAL_I_SHADOW
#define R_SCSI0_DATA_IN__TYPECAST  REG_TYPECAST_UWORD
#define R_SCSI0_DATA_IN__TYPE      (REG_UWORD)
#define R_SCSI0_DATA_IN__GET       REG_GET_RO
#define R_SCSI0_DATA_IN__IGET      REG_IGET_RO
#define R_SCSI0_DATA_IN__SET       REG_SET_RO
#define R_SCSI0_DATA_IN__ISET      REG_ISET_RO
#define R_SCSI0_DATA_IN__SET_VAL   REG_SET_VAL_RO
#define R_SCSI0_DATA_IN__EQL       REG_EQL_RO
#define R_SCSI0_DATA_IN__IEQL      REG_IEQL_RO
#define R_SCSI0_DATA_IN__RD        REG_RD_RO
#define R_SCSI0_DATA_IN__IRD       REG_IRD_RO
#define R_SCSI0_DATA_IN__WR        REG_WR_RO
#define R_SCSI0_DATA_IN__IWR       REG_IWR_RO

#define R_SCSI0_DATA_IN__READ(addr) \
  (*(addr))

/* From control-file '/n/asic/projects/etrax_ng/include//hwregs.ctrl' */
#define R_SCSI0_DATA_IN__FIRST 0
#define R_SCSI0_DATA_IN__LAST 1
#define R_SCSI0_DATA_IN__OFFSET 16
/* end */

#define R_SCSI0_DATA_IN__data_in__data_in__MASK 0x0000ffffU

#define R_SCSI0_DATA_IN__data_in__MAX 0xffff

#define R_SCSI0_DATA_IN__data_in__MIN 0

#define R_SCSI0_DATA_IN__data_in__BITNR 0

#define R_SCSI0_DATA_IN__data_in__data_in__VAL REG_VAL_VAL


#endif

/*
 *  R_SCSI0_STATUS
 *  - type:  RO
 *  - addr:  0xb0000048
 *  - group: SCSI registers
 */

#if USE_GROUP__SCSI_registers

#define R_SCSI0_STATUS__ADDR      (REG_TYPECAST_UDWORD  0xb0000048)
#define R_SCSI0_STATUS__SVAL      REG_SVAL_SHADOW
#define R_SCSI0_STATUS__SVAL_I    REG_SVAL_I_SHADOW
#define R_SCSI0_STATUS__TYPECAST  REG_TYPECAST_UDWORD
#define R_SCSI0_STATUS__TYPE      (REG_UDWORD)
#define R_SCSI0_STATUS__GET       REG_GET_RO
#define R_SCSI0_STATUS__IGET      REG_IGET_RO
#define R_SCSI0_STATUS__SET       REG_SET_RO
#define R_SCSI0_STATUS__ISET      REG_ISET_RO
#define R_SCSI0_STATUS__SET_VAL   REG_SET_VAL_RO
#define R_SCSI0_STATUS__EQL       REG_EQL_RO
#define R_SCSI0_STATUS__IEQL      REG_IEQL_RO
#define R_SCSI0_STATUS__RD        REG_RD_RO
#define R_SCSI0_STATUS__IRD       REG_IRD_RO
#define R_SCSI0_STATUS__WR        REG_WR_RO
#define R_SCSI0_STATUS__IWR       REG_IWR_RO

#define R_SCSI0_STATUS__READ(addr) \
  (*(addr))

/* From control-file '/n/asic/projects/etrax_ng/include//hwregs.ctrl' */
#define R_SCSI0_STATUS__FIRST 0
#define R_SCSI0_STATUS__LAST 1
#define R_SCSI0_STATUS__OFFSET 16
/* end */

#define R_SCSI0_STATUS__tst_arb_won__tst_arb_won__MASK 0x00800000U
#define R_SCSI0_STATUS__tst_resel__tst_resel__MASK 0x00400000U
#define R_SCSI0_STATUS__parity_error__parity_error__MASK 0x00200000U
#define R_SCSI0_STATUS__bus_reset__bus_reset__MASK 0x00100000U
#define R_SCSI0_STATUS__resel_target__resel_target__MASK 0x00078000U
#define R_SCSI0_STATUS__resel__resel__MASK 0x00004000U
#define R_SCSI0_STATUS__curr_phase__curr_phase__MASK 0x00003800U
#define R_SCSI0_STATUS__last_seq_step__last_seq_step__MASK 0x000007c0U
#define R_SCSI0_STATUS__valid_status__valid_status__MASK 0x00000020U
#define R_SCSI0_STATUS__seq_status__seq_status__MASK 0x0000001fU

#define R_SCSI0_STATUS__tst_arb_won__MAX 0x1
#define R_SCSI0_STATUS__tst_resel__MAX 0x1
#define R_SCSI0_STATUS__parity_error__MAX 0x1
#define R_SCSI0_STATUS__bus_reset__MAX 0x1
#define R_SCSI0_STATUS__resel_target__MAX 0xf
#define R_SCSI0_STATUS__resel__MAX 0x1
#define R_SCSI0_STATUS__curr_phase__MAX 0x7
#define R_SCSI0_STATUS__last_seq_step__MAX 0x1f
#define R_SCSI0_STATUS__valid_status__MAX 0x1
#define R_SCSI0_STATUS__seq_status__MAX 0x1f

#define R_SCSI0_STATUS__tst_arb_won__MIN 0
#define R_SCSI0_STATUS__tst_resel__MIN 0
#define R_SCSI0_STATUS__parity_error__MIN 0
#define R_SCSI0_STATUS__bus_reset__MIN 0
#define R_SCSI0_STATUS__resel_target__MIN 0
#define R_SCSI0_STATUS__resel__MIN 0
#define R_SCSI0_STATUS__curr_phase__MIN 0
#define R_SCSI0_STATUS__last_seq_step__MIN 0
#define R_SCSI0_STATUS__valid_status__MIN 0
#define R_SCSI0_STATUS__seq_status__MIN 0

#define R_SCSI0_STATUS__tst_arb_won__BITNR 23
#define R_SCSI0_STATUS__tst_resel__BITNR 22
#define R_SCSI0_STATUS__parity_error__BITNR 21
#define R_SCSI0_STATUS__bus_reset__BITNR 20
#define R_SCSI0_STATUS__resel_target__BITNR 15
#define R_SCSI0_STATUS__resel__BITNR 14
#define R_SCSI0_STATUS__curr_phase__BITNR 11
#define R_SCSI0_STATUS__last_seq_step__BITNR 6
#define R_SCSI0_STATUS__valid_status__BITNR 5
#define R_SCSI0_STATUS__seq_status__BITNR 0

#define R_SCSI0_STATUS__tst_arb_won__tst_arb_won__VAL REG_VAL_VAL
#define R_SCSI0_STATUS__tst_resel__tst_resel__VAL REG_VAL_VAL
#define R_SCSI0_STATUS__parity_error__parity_error__VAL REG_VAL_VAL
#define R_SCSI0_STATUS__bus_reset__bus_reset__VAL REG_VAL_ENUM
#define R_SCSI0_STATUS__resel_target__resel_target__VAL REG_VAL_VAL
#define R_SCSI0_STATUS__resel__resel__VAL REG_VAL_ENUM
#define R_SCSI0_STATUS__curr_phase__curr_phase__VAL REG_VAL_ENUM
#define R_SCSI0_STATUS__last_seq_step__last_seq_step__VAL REG_VAL_ENUM
#define R_SCSI0_STATUS__valid_status__valid_status__VAL REG_VAL_ENUM
#define R_SCSI0_STATUS__seq_status__seq_status__VAL REG_VAL_ENUM

#define R_SCSI0_STATUS__bus_reset__bus_reset__no 0
#define R_SCSI0_STATUS__bus_reset__bus_reset__yes 1
#define R_SCSI0_STATUS__resel__resel__no 0
#define R_SCSI0_STATUS__resel__resel__yes 1
#define R_SCSI0_STATUS__curr_phase__curr_phase__ph_command 2
#define R_SCSI0_STATUS__curr_phase__curr_phase__ph_data_in 5
#define R_SCSI0_STATUS__curr_phase__curr_phase__ph_data_out 4
#define R_SCSI0_STATUS__curr_phase__curr_phase__ph_msg_in 7
#define R_SCSI0_STATUS__curr_phase__curr_phase__ph_msg_out 6
#define R_SCSI0_STATUS__curr_phase__curr_phase__ph_resel 1
#define R_SCSI0_STATUS__curr_phase__curr_phase__ph_status 3
#define R_SCSI0_STATUS__curr_phase__curr_phase__ph_undef 0
#define R_SCSI0_STATUS__last_seq_step__last_seq_step__st_answer 3
#define R_SCSI0_STATUS__last_seq_step__last_seq_step__st_arbitrate 8
#define R_SCSI0_STATUS__last_seq_step__last_seq_step__st_asynch_din 9
#define R_SCSI0_STATUS__last_seq_step__last_seq_step__st_asynch_dout 25
#define R_SCSI0_STATUS__last_seq_step__last_seq_step__st_asynch_dout_end 11
#define R_SCSI0_STATUS__last_seq_step__last_seq_step__st_bus_free 24
#define R_SCSI0_STATUS__last_seq_step__last_seq_step__st_cc 31
#define R_SCSI0_STATUS__last_seq_step__last_seq_step__st_iwr 27
#define R_SCSI0_STATUS__last_seq_step__last_seq_step__st_iwr_cc 23
#define R_SCSI0_STATUS__last_seq_step__last_seq_step__st_iwr_good 14
#define R_SCSI0_STATUS__last_seq_step__last_seq_step__st_manual 28
#define R_SCSI0_STATUS__last_seq_step__last_seq_step__st_manual_din_prot 18
#define R_SCSI0_STATUS__last_seq_step__last_seq_step__st_manual_req 10
#define R_SCSI0_STATUS__last_seq_step__last_seq_step__st_msg_1 2
#define R_SCSI0_STATUS__last_seq_step__last_seq_step__st_msg_2 6
#define R_SCSI0_STATUS__last_seq_step__last_seq_step__st_msg_3 22
#define R_SCSI0_STATUS__last_seq_step__last_seq_step__st_resel_req 29
#define R_SCSI0_STATUS__last_seq_step__last_seq_step__st_sdp_disc 7
#define R_SCSI0_STATUS__last_seq_step__last_seq_step__st_synch_din 13
#define R_SCSI0_STATUS__last_seq_step__last_seq_step__st_synch_din_ack 12
#define R_SCSI0_STATUS__last_seq_step__last_seq_step__st_synch_din_ack_perr 5
#define R_SCSI0_STATUS__last_seq_step__last_seq_step__st_synch_din_perr 1
#define R_SCSI0_STATUS__last_seq_step__last_seq_step__st_synch_dout 0
#define R_SCSI0_STATUS__last_seq_step__last_seq_step__st_synch_dout_ack 4
#define R_SCSI0_STATUS__last_seq_step__last_seq_step__st_transf_cmd 30
#define R_SCSI0_STATUS__last_seq_step__last_seq_step__st_transfer_done 15
#define R_SCSI0_STATUS__last_seq_step__last_seq_step__st_wait_free_cc 20
#define R_SCSI0_STATUS__last_seq_step__last_seq_step__st_wait_free_disc 21
#define R_SCSI0_STATUS__last_seq_step__last_seq_step__st_wait_free_iwr_cc 17
#define R_SCSI0_STATUS__last_seq_step__last_seq_step__st_wait_free_sdp_disc 16
#define R_SCSI0_STATUS__valid_status__valid_status__no 0
#define R_SCSI0_STATUS__valid_status__valid_status__yes 1
#define R_SCSI0_STATUS__seq_status__seq_status__info_arb_lost 4
#define R_SCSI0_STATUS__seq_status__seq_status__info_bus_free 13
#define R_SCSI0_STATUS__seq_status__seq_status__info_bus_reset 11
#define R_SCSI0_STATUS__seq_status__seq_status__info_illegal_bf 12
#define R_SCSI0_STATUS__seq_status__seq_status__info_illegal_op 7
#define R_SCSI0_STATUS__seq_status__seq_status__info_parity_error 1
#define R_SCSI0_STATUS__seq_status__seq_status__info_rec_recvd 8
#define R_SCSI0_STATUS__seq_status__seq_status__info_reselected 9
#define R_SCSI0_STATUS__seq_status__seq_status__info_sel_timeout 5
#define R_SCSI0_STATUS__seq_status__seq_status__info_seq_complete 0
#define R_SCSI0_STATUS__seq_status__seq_status__info_unexp_bf 6
#define R_SCSI0_STATUS__seq_status__seq_status__info_unexp_ph_change 3
#define R_SCSI0_STATUS__seq_status__seq_status__info_unhandled_msg_in 2
#define R_SCSI0_STATUS__seq_status__seq_status__info_unhandled_status 10

#endif

/*
 *  R_SCSI0_STATUS_CTRL
 *  - type:  WO
 *  - addr:  0xb0000043
 *  - group: SCSI registers
 */

#if USE_GROUP__SCSI_registers

#define R_SCSI0_STATUS_CTRL__ADDR      (REG_TYPECAST_BYTE  0xb0000043)

#ifndef REG_NO_SHADOW
#define R_SCSI0_STATUS_CTRL__SADDR     (REG_STYPECAST_BYTE (reg_shadow__hwregs.R_ATA_CTRL_DATA + 3))
#define R_SCSI0_STATUS_CTRL__IADDR     (REG_STYPECAST_BYTE (reg_initiated__hwregs.R_ATA_CTRL_DATA + 3))
#else /* REG_NO_SHADOW */
#define R_SCSI0_STATUS_CTRL__SADDR     (REG_STYPECAST_BYTE (&reg_shadow__hwregs))
#define R_SCSI0_STATUS_CTRL__IADDR     (REG_STYPECAST_BYTE (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_SCSI0_STATUS_CTRL__STYPECAST REG_STYPECAST_BYTE
#define R_SCSI0_STATUS_CTRL__SVAL      REG_SVAL_SHADOW
#define R_SCSI0_STATUS_CTRL__SVAL_I    REG_SVAL_I_SHADOW
#define R_SCSI0_STATUS_CTRL__TYPECAST  REG_TYPECAST_BYTE
#define R_SCSI0_STATUS_CTRL__TYPE      (REG_BYTE)
#define R_SCSI0_STATUS_CTRL__GET       REG_GET_WO
#define R_SCSI0_STATUS_CTRL__IGET      REG_IGET_WO
#define R_SCSI0_STATUS_CTRL__SET       REG_SET_WO
#define R_SCSI0_STATUS_CTRL__ISET      REG_ISET_WO
#define R_SCSI0_STATUS_CTRL__SET_VAL   REG_SET_VAL_WO
#define R_SCSI0_STATUS_CTRL__EQL       REG_EQL_WO
#define R_SCSI0_STATUS_CTRL__IEQL      REG_IEQL_WO
#define R_SCSI0_STATUS_CTRL__RD        REG_RD_WO
#define R_SCSI0_STATUS_CTRL__IRD       REG_IRD_WO
#define R_SCSI0_STATUS_CTRL__WR        REG_WR_WO
#define R_SCSI0_STATUS_CTRL__IWR       REG_IWR_WO

#define R_SCSI0_STATUS_CTRL__WRITE(addr,value) \
  (*(addr) = (value))

/* From control-file '/n/asic/projects/etrax_ng/include//hwregs.ctrl' */
#define R_SCSI0_STATUS_CTRL__FIRST 0
#define R_SCSI0_STATUS_CTRL__IOFFSET 12
#define R_SCSI0_STATUS_CTRL__LAST 1
#define R_SCSI0_STATUS_CTRL__OFFSET 16
#define R_SCSI0_STATUS_CTRL__SOFFSET 12
/* end */

#define R_SCSI0_STATUS_CTRL__parity_in__parity_in__MASK 0x00000004U
#define R_SCSI0_STATUS_CTRL__skip__skip__MASK 0x00000002U
#define R_SCSI0_STATUS_CTRL__clr_status__clr_status__MASK 0x00000001U

#define R_SCSI0_STATUS_CTRL__parity_in__MAX 0x1
#define R_SCSI0_STATUS_CTRL__skip__MAX 0x1
#define R_SCSI0_STATUS_CTRL__clr_status__MAX 0x1

#define R_SCSI0_STATUS_CTRL__parity_in__MIN 0
#define R_SCSI0_STATUS_CTRL__skip__MIN 0
#define R_SCSI0_STATUS_CTRL__clr_status__MIN 0

#define R_SCSI0_STATUS_CTRL__parity_in__BITNR 2
#define R_SCSI0_STATUS_CTRL__skip__BITNR 1
#define R_SCSI0_STATUS_CTRL__clr_status__BITNR 0

#define R_SCSI0_STATUS_CTRL__parity_in__parity_in__VAL REG_VAL_ENUM
#define R_SCSI0_STATUS_CTRL__skip__skip__VAL REG_VAL_ENUM
#define R_SCSI0_STATUS_CTRL__clr_status__clr_status__VAL REG_VAL_ENUM

#define R_SCSI0_STATUS_CTRL__parity_in__parity_in__off 1
#define R_SCSI0_STATUS_CTRL__parity_in__parity_in__on 0
#define R_SCSI0_STATUS_CTRL__skip__skip__off 0
#define R_SCSI0_STATUS_CTRL__skip__skip__on 1
#define R_SCSI0_STATUS_CTRL__clr_status__clr_status__nop 0
#define R_SCSI0_STATUS_CTRL__clr_status__clr_status__yes 1

#endif

/*
 *  R_SCSI1_CMD
 *  - type:  WO
 *  - addr:  0xb0000052
 *  - group: SCSI registers
 */

#if USE_GROUP__SCSI_registers

#define R_SCSI1_CMD__ADDR      (REG_TYPECAST_BYTE  0xb0000052)

#ifndef REG_NO_SHADOW
#define R_SCSI1_CMD__SADDR     (REG_STYPECAST_BYTE (reg_shadow__hwregs.R_PAR1_CTRL_DATA + 2))
#define R_SCSI1_CMD__IADDR     (REG_STYPECAST_BYTE (reg_initiated__hwregs.R_PAR1_CTRL_DATA + 2))
#else /* REG_NO_SHADOW */
#define R_SCSI1_CMD__SADDR     (REG_STYPECAST_BYTE (&reg_shadow__hwregs))
#define R_SCSI1_CMD__IADDR     (REG_STYPECAST_BYTE (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_SCSI1_CMD__STYPECAST REG_STYPECAST_BYTE
#define R_SCSI1_CMD__SVAL      REG_SVAL_SHADOW
#define R_SCSI1_CMD__SVAL_I    REG_SVAL_I_SHADOW
#define R_SCSI1_CMD__TYPECAST  REG_TYPECAST_BYTE
#define R_SCSI1_CMD__TYPE      (REG_BYTE)
#define R_SCSI1_CMD__GET       REG_GET_WO
#define R_SCSI1_CMD__IGET      REG_IGET_WO
#define R_SCSI1_CMD__SET       REG_SET_WO
#define R_SCSI1_CMD__ISET      REG_ISET_WO
#define R_SCSI1_CMD__SET_VAL   REG_SET_VAL_WO
#define R_SCSI1_CMD__EQL       REG_EQL_WO
#define R_SCSI1_CMD__IEQL      REG_IEQL_WO
#define R_SCSI1_CMD__RD        REG_RD_WO
#define R_SCSI1_CMD__IRD       REG_IRD_WO
#define R_SCSI1_CMD__WR        REG_WR_WO
#define R_SCSI1_CMD__IWR       REG_IWR_WO

#define R_SCSI1_CMD__WRITE(addr,value) \
  (*(addr) = (value))

#define R_SCSI1_CMD__asynch_setup__asynch_setup__MASK 0x000000f0U
#define R_SCSI1_CMD__command__command__MASK 0x0000000fU

#define R_SCSI1_CMD__asynch_setup__MAX 0xf
#define R_SCSI1_CMD__command__MAX 0xf

#define R_SCSI1_CMD__asynch_setup__MIN 0
#define R_SCSI1_CMD__command__MIN 0

#define R_SCSI1_CMD__asynch_setup__BITNR 4
#define R_SCSI1_CMD__command__BITNR 0

#define R_SCSI1_CMD__asynch_setup__asynch_setup__VAL REG_VAL_VAL
#define R_SCSI1_CMD__command__command__VAL REG_VAL_ENUM

#define R_SCSI1_CMD__command__command__arb_only 6
#define R_SCSI1_CMD__command__command__full_din_1 0
#define R_SCSI1_CMD__command__command__full_din_3 8
#define R_SCSI1_CMD__command__command__full_dout_1 1
#define R_SCSI1_CMD__command__command__full_dout_3 9
#define R_SCSI1_CMD__command__command__full_stat_1 2
#define R_SCSI1_CMD__command__command__full_stat_3 10
#define R_SCSI1_CMD__command__command__man_data_in 11
#define R_SCSI1_CMD__command__command__man_data_out 12
#define R_SCSI1_CMD__command__command__man_rat 13
#define R_SCSI1_CMD__command__command__resel_din 3
#define R_SCSI1_CMD__command__command__resel_dout 4
#define R_SCSI1_CMD__command__command__resel_stat 5

#endif

/*
 *  R_SCSI1_CMD_DATA
 *  - type:  WO
 *  - addr:  0xb0000050
 *  - group: SCSI registers
 */

#if USE_GROUP__SCSI_registers

#define R_SCSI1_CMD_DATA__ADDR      (REG_TYPECAST_UDWORD  0xb0000050)

#ifndef REG_NO_SHADOW
#define R_SCSI1_CMD_DATA__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_PAR1_CTRL_DATA + 0))
#define R_SCSI1_CMD_DATA__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_PAR1_CTRL_DATA + 0))
#else /* REG_NO_SHADOW */
#define R_SCSI1_CMD_DATA__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_SCSI1_CMD_DATA__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_SCSI1_CMD_DATA__STYPECAST REG_STYPECAST_UDWORD
#define R_SCSI1_CMD_DATA__SVAL      REG_SVAL_SHADOW
#define R_SCSI1_CMD_DATA__SVAL_I    REG_SVAL_I_SHADOW
#define R_SCSI1_CMD_DATA__TYPECAST  REG_TYPECAST_UDWORD
#define R_SCSI1_CMD_DATA__TYPE      (REG_UDWORD)
#define R_SCSI1_CMD_DATA__GET       REG_GET_WO
#define R_SCSI1_CMD_DATA__IGET      REG_IGET_WO
#define R_SCSI1_CMD_DATA__SET       REG_SET_WO
#define R_SCSI1_CMD_DATA__ISET      REG_ISET_WO
#define R_SCSI1_CMD_DATA__SET_VAL   REG_SET_VAL_WO
#define R_SCSI1_CMD_DATA__EQL       REG_EQL_WO
#define R_SCSI1_CMD_DATA__IEQL      REG_IEQL_WO
#define R_SCSI1_CMD_DATA__RD        REG_RD_WO
#define R_SCSI1_CMD_DATA__IRD       REG_IRD_WO
#define R_SCSI1_CMD_DATA__WR        REG_WR_WO
#define R_SCSI1_CMD_DATA__IWR       REG_IWR_WO

#define R_SCSI1_CMD_DATA__WRITE(addr,value) \
  (*(addr) = (value))

#define R_SCSI1_CMD_DATA__parity_in__parity_in__MASK 0x04000000U
#define R_SCSI1_CMD_DATA__skip__skip__MASK 0x02000000U
#define R_SCSI1_CMD_DATA__clr_status__clr_status__MASK 0x01000000U
#define R_SCSI1_CMD_DATA__asynch_setup__asynch_setup__MASK 0x00f00000U
#define R_SCSI1_CMD_DATA__command__command__MASK 0x000f0000U
#define R_SCSI1_CMD_DATA__data_out__data_out__MASK 0x0000ffffU

#define R_SCSI1_CMD_DATA__parity_in__MAX 0x1
#define R_SCSI1_CMD_DATA__skip__MAX 0x1
#define R_SCSI1_CMD_DATA__clr_status__MAX 0x1
#define R_SCSI1_CMD_DATA__asynch_setup__MAX 0xf
#define R_SCSI1_CMD_DATA__command__MAX 0xf
#define R_SCSI1_CMD_DATA__data_out__MAX 0xffff

#define R_SCSI1_CMD_DATA__parity_in__MIN 0
#define R_SCSI1_CMD_DATA__skip__MIN 0
#define R_SCSI1_CMD_DATA__clr_status__MIN 0
#define R_SCSI1_CMD_DATA__asynch_setup__MIN 0
#define R_SCSI1_CMD_DATA__command__MIN 0
#define R_SCSI1_CMD_DATA__data_out__MIN 0

#define R_SCSI1_CMD_DATA__parity_in__BITNR 26
#define R_SCSI1_CMD_DATA__skip__BITNR 25
#define R_SCSI1_CMD_DATA__clr_status__BITNR 24
#define R_SCSI1_CMD_DATA__asynch_setup__BITNR 20
#define R_SCSI1_CMD_DATA__command__BITNR 16
#define R_SCSI1_CMD_DATA__data_out__BITNR 0

#define R_SCSI1_CMD_DATA__parity_in__parity_in__VAL REG_VAL_ENUM
#define R_SCSI1_CMD_DATA__skip__skip__VAL REG_VAL_ENUM
#define R_SCSI1_CMD_DATA__clr_status__clr_status__VAL REG_VAL_ENUM
#define R_SCSI1_CMD_DATA__asynch_setup__asynch_setup__VAL REG_VAL_VAL
#define R_SCSI1_CMD_DATA__command__command__VAL REG_VAL_ENUM
#define R_SCSI1_CMD_DATA__data_out__data_out__VAL REG_VAL_VAL

#define R_SCSI1_CMD_DATA__parity_in__parity_in__off 1
#define R_SCSI1_CMD_DATA__parity_in__parity_in__on 0
#define R_SCSI1_CMD_DATA__skip__skip__off 0
#define R_SCSI1_CMD_DATA__skip__skip__on 1
#define R_SCSI1_CMD_DATA__clr_status__clr_status__nop 0
#define R_SCSI1_CMD_DATA__clr_status__clr_status__yes 1
#define R_SCSI1_CMD_DATA__command__command__arb_only 6
#define R_SCSI1_CMD_DATA__command__command__full_din_1 0
#define R_SCSI1_CMD_DATA__command__command__full_din_3 8
#define R_SCSI1_CMD_DATA__command__command__full_dout_1 1
#define R_SCSI1_CMD_DATA__command__command__full_dout_3 9
#define R_SCSI1_CMD_DATA__command__command__full_stat_1 2
#define R_SCSI1_CMD_DATA__command__command__full_stat_3 10
#define R_SCSI1_CMD_DATA__command__command__man_data_in 11
#define R_SCSI1_CMD_DATA__command__command__man_data_out 12
#define R_SCSI1_CMD_DATA__command__command__man_rat 13
#define R_SCSI1_CMD_DATA__command__command__resel_din 3
#define R_SCSI1_CMD_DATA__command__command__resel_dout 4
#define R_SCSI1_CMD_DATA__command__command__resel_stat 5

#endif

/*
 *  R_SCSI1_CTRL
 *  - type:  WO
 *  - addr:  0xb0000054
 *  - group: SCSI registers
 */

#if USE_GROUP__SCSI_registers

#define R_SCSI1_CTRL__ADDR      (REG_TYPECAST_UDWORD  0xb0000054)

#ifndef REG_NO_SHADOW
#define R_SCSI1_CTRL__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_PAR1_CONFIG + 0))
#define R_SCSI1_CTRL__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_PAR1_CONFIG + 0))
#else /* REG_NO_SHADOW */
#define R_SCSI1_CTRL__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_SCSI1_CTRL__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_SCSI1_CTRL__STYPECAST REG_STYPECAST_UDWORD
#define R_SCSI1_CTRL__SVAL      REG_SVAL_SHADOW
#define R_SCSI1_CTRL__SVAL_I    REG_SVAL_I_SHADOW
#define R_SCSI1_CTRL__TYPECAST  REG_TYPECAST_UDWORD
#define R_SCSI1_CTRL__TYPE      (REG_UDWORD)
#define R_SCSI1_CTRL__GET       REG_GET_WO
#define R_SCSI1_CTRL__IGET      REG_IGET_WO
#define R_SCSI1_CTRL__SET       REG_SET_WO
#define R_SCSI1_CTRL__ISET      REG_ISET_WO
#define R_SCSI1_CTRL__SET_VAL   REG_SET_VAL_WO
#define R_SCSI1_CTRL__EQL       REG_EQL_WO
#define R_SCSI1_CTRL__IEQL      REG_IEQL_WO
#define R_SCSI1_CTRL__RD        REG_RD_WO
#define R_SCSI1_CTRL__IRD       REG_IRD_WO
#define R_SCSI1_CTRL__WR        REG_WR_WO
#define R_SCSI1_CTRL__IWR       REG_IWR_WO

#define R_SCSI1_CTRL__WRITE(addr,value) \
  (*(addr) = (value))

#define R_SCSI1_CTRL__id_type__id_type__MASK 0x80000000U
#define R_SCSI1_CTRL__sel_timeout__sel_timeout__MASK 0x7f000000U
#define R_SCSI1_CTRL__synch_per__synch_per__MASK 0x00ff0000U
#define R_SCSI1_CTRL__rst__rst__MASK 0x00008000U
#define R_SCSI1_CTRL__atn__atn__MASK 0x00004000U
#define R_SCSI1_CTRL__my_id__my_id__MASK 0x00001e00U
#define R_SCSI1_CTRL__target_id__target_id__MASK 0x000000f0U
#define R_SCSI1_CTRL__fast_20__fast_20__MASK 0x00000008U
#define R_SCSI1_CTRL__bus_width__bus_width__MASK 0x00000004U
#define R_SCSI1_CTRL__synch__synch__MASK 0x00000002U
#define R_SCSI1_CTRL__enable__enable__MASK 0x00000001U

#define R_SCSI1_CTRL__id_type__MAX 0x1
#define R_SCSI1_CTRL__sel_timeout__MAX 0x7f
#define R_SCSI1_CTRL__synch_per__MAX 0xff
#define R_SCSI1_CTRL__rst__MAX 0x1
#define R_SCSI1_CTRL__atn__MAX 0x1
#define R_SCSI1_CTRL__my_id__MAX 0xf
#define R_SCSI1_CTRL__target_id__MAX 0xf
#define R_SCSI1_CTRL__fast_20__MAX 0x1
#define R_SCSI1_CTRL__bus_width__MAX 0x1
#define R_SCSI1_CTRL__synch__MAX 0x1
#define R_SCSI1_CTRL__enable__MAX 0x1

#define R_SCSI1_CTRL__id_type__MIN 0
#define R_SCSI1_CTRL__sel_timeout__MIN 0
#define R_SCSI1_CTRL__synch_per__MIN 0
#define R_SCSI1_CTRL__rst__MIN 0
#define R_SCSI1_CTRL__atn__MIN 0
#define R_SCSI1_CTRL__my_id__MIN 0
#define R_SCSI1_CTRL__target_id__MIN 0
#define R_SCSI1_CTRL__fast_20__MIN 0
#define R_SCSI1_CTRL__bus_width__MIN 0
#define R_SCSI1_CTRL__synch__MIN 0
#define R_SCSI1_CTRL__enable__MIN 0

#define R_SCSI1_CTRL__id_type__BITNR 31
#define R_SCSI1_CTRL__sel_timeout__BITNR 24
#define R_SCSI1_CTRL__synch_per__BITNR 16
#define R_SCSI1_CTRL__rst__BITNR 15
#define R_SCSI1_CTRL__atn__BITNR 14
#define R_SCSI1_CTRL__my_id__BITNR 9
#define R_SCSI1_CTRL__target_id__BITNR 4
#define R_SCSI1_CTRL__fast_20__BITNR 3
#define R_SCSI1_CTRL__bus_width__BITNR 2
#define R_SCSI1_CTRL__synch__BITNR 1
#define R_SCSI1_CTRL__enable__BITNR 0

#define R_SCSI1_CTRL__id_type__id_type__VAL REG_VAL_ENUM
#define R_SCSI1_CTRL__sel_timeout__sel_timeout__VAL REG_VAL_VAL
#define R_SCSI1_CTRL__synch_per__synch_per__VAL REG_VAL_VAL
#define R_SCSI1_CTRL__rst__rst__VAL REG_VAL_ENUM
#define R_SCSI1_CTRL__atn__atn__VAL REG_VAL_ENUM
#define R_SCSI1_CTRL__my_id__my_id__VAL REG_VAL_VAL
#define R_SCSI1_CTRL__target_id__target_id__VAL REG_VAL_VAL
#define R_SCSI1_CTRL__fast_20__fast_20__VAL REG_VAL_ENUM
#define R_SCSI1_CTRL__bus_width__bus_width__VAL REG_VAL_ENUM
#define R_SCSI1_CTRL__synch__synch__VAL REG_VAL_ENUM
#define R_SCSI1_CTRL__enable__enable__VAL REG_VAL_ENUM

#define R_SCSI1_CTRL__id_type__id_type__hardware 0
#define R_SCSI1_CTRL__id_type__id_type__software 1
#define R_SCSI1_CTRL__rst__rst__no 0
#define R_SCSI1_CTRL__rst__rst__yes 1
#define R_SCSI1_CTRL__atn__atn__no 0
#define R_SCSI1_CTRL__atn__atn__yes 1
#define R_SCSI1_CTRL__fast_20__fast_20__no 0
#define R_SCSI1_CTRL__fast_20__fast_20__yes 1
#define R_SCSI1_CTRL__bus_width__bus_width__narrow 0
#define R_SCSI1_CTRL__bus_width__bus_width__wide 1
#define R_SCSI1_CTRL__synch__synch__asynch 0
#define R_SCSI1_CTRL__synch__synch__synch 1
#define R_SCSI1_CTRL__enable__enable__off 0
#define R_SCSI1_CTRL__enable__enable__on 1

#endif

/*
 *  R_SCSI1_DATA
 *  - type:  WO
 *  - addr:  0xb0000050
 *  - group: SCSI registers
 */

#if USE_GROUP__SCSI_registers

#define R_SCSI1_DATA__ADDR      (REG_TYPECAST_UWORD  0xb0000050)

#ifndef REG_NO_SHADOW
#define R_SCSI1_DATA__SADDR     (REG_STYPECAST_UWORD (reg_shadow__hwregs.R_PAR1_CTRL_DATA + 0))
#define R_SCSI1_DATA__IADDR     (REG_STYPECAST_UWORD (reg_initiated__hwregs.R_PAR1_CTRL_DATA + 0))
#else /* REG_NO_SHADOW */
#define R_SCSI1_DATA__SADDR     (REG_STYPECAST_UWORD (&reg_shadow__hwregs))
#define R_SCSI1_DATA__IADDR     (REG_STYPECAST_UWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_SCSI1_DATA__STYPECAST REG_STYPECAST_UWORD
#define R_SCSI1_DATA__SVAL      REG_SVAL_SHADOW
#define R_SCSI1_DATA__SVAL_I    REG_SVAL_I_SHADOW
#define R_SCSI1_DATA__TYPECAST  REG_TYPECAST_UWORD
#define R_SCSI1_DATA__TYPE      (REG_UWORD)
#define R_SCSI1_DATA__GET       REG_GET_WO
#define R_SCSI1_DATA__IGET      REG_IGET_WO
#define R_SCSI1_DATA__SET       REG_SET_WO
#define R_SCSI1_DATA__ISET      REG_ISET_WO
#define R_SCSI1_DATA__SET_VAL   REG_SET_VAL_WO
#define R_SCSI1_DATA__EQL       REG_EQL_WO
#define R_SCSI1_DATA__IEQL      REG_IEQL_WO
#define R_SCSI1_DATA__RD        REG_RD_WO
#define R_SCSI1_DATA__IRD       REG_IRD_WO
#define R_SCSI1_DATA__WR        REG_WR_WO
#define R_SCSI1_DATA__IWR       REG_IWR_WO

#define R_SCSI1_DATA__WRITE(addr,value) \
  (*(addr) = (value))

#define R_SCSI1_DATA__data_out__data_out__MASK 0x0000ffffU

#define R_SCSI1_DATA__data_out__MAX 0xffff

#define R_SCSI1_DATA__data_out__MIN 0

#define R_SCSI1_DATA__data_out__BITNR 0

#define R_SCSI1_DATA__data_out__data_out__VAL REG_VAL_VAL


#endif

/*
 *  R_SCSI1_DATA_IN
 *  - type:  RO
 *  - addr:  0xb0000050
 *  - group: SCSI registers
 */

#if USE_GROUP__SCSI_registers

#define R_SCSI1_DATA_IN__ADDR      (REG_TYPECAST_UWORD  0xb0000050)
#define R_SCSI1_DATA_IN__SVAL      REG_SVAL_SHADOW
#define R_SCSI1_DATA_IN__SVAL_I    REG_SVAL_I_SHADOW
#define R_SCSI1_DATA_IN__TYPECAST  REG_TYPECAST_UWORD
#define R_SCSI1_DATA_IN__TYPE      (REG_UWORD)
#define R_SCSI1_DATA_IN__GET       REG_GET_RO
#define R_SCSI1_DATA_IN__IGET      REG_IGET_RO
#define R_SCSI1_DATA_IN__SET       REG_SET_RO
#define R_SCSI1_DATA_IN__ISET      REG_ISET_RO
#define R_SCSI1_DATA_IN__SET_VAL   REG_SET_VAL_RO
#define R_SCSI1_DATA_IN__EQL       REG_EQL_RO
#define R_SCSI1_DATA_IN__IEQL      REG_IEQL_RO
#define R_SCSI1_DATA_IN__RD        REG_RD_RO
#define R_SCSI1_DATA_IN__IRD       REG_IRD_RO
#define R_SCSI1_DATA_IN__WR        REG_WR_RO
#define R_SCSI1_DATA_IN__IWR       REG_IWR_RO

#define R_SCSI1_DATA_IN__READ(addr) \
  (*(addr))

#define R_SCSI1_DATA_IN__data_in__data_in__MASK 0x0000ffffU

#define R_SCSI1_DATA_IN__data_in__MAX 0xffff

#define R_SCSI1_DATA_IN__data_in__MIN 0

#define R_SCSI1_DATA_IN__data_in__BITNR 0

#define R_SCSI1_DATA_IN__data_in__data_in__VAL REG_VAL_VAL


#endif

/*
 *  R_SCSI1_STATUS
 *  - type:  RO
 *  - addr:  0xb0000058
 *  - group: SCSI registers
 */

#if USE_GROUP__SCSI_registers

#define R_SCSI1_STATUS__ADDR      (REG_TYPECAST_UDWORD  0xb0000058)
#define R_SCSI1_STATUS__SVAL      REG_SVAL_SHADOW
#define R_SCSI1_STATUS__SVAL_I    REG_SVAL_I_SHADOW
#define R_SCSI1_STATUS__TYPECAST  REG_TYPECAST_UDWORD
#define R_SCSI1_STATUS__TYPE      (REG_UDWORD)
#define R_SCSI1_STATUS__GET       REG_GET_RO
#define R_SCSI1_STATUS__IGET      REG_IGET_RO
#define R_SCSI1_STATUS__SET       REG_SET_RO
#define R_SCSI1_STATUS__ISET      REG_ISET_RO
#define R_SCSI1_STATUS__SET_VAL   REG_SET_VAL_RO
#define R_SCSI1_STATUS__EQL       REG_EQL_RO
#define R_SCSI1_STATUS__IEQL      REG_IEQL_RO
#define R_SCSI1_STATUS__RD        REG_RD_RO
#define R_SCSI1_STATUS__IRD       REG_IRD_RO
#define R_SCSI1_STATUS__WR        REG_WR_RO
#define R_SCSI1_STATUS__IWR       REG_IWR_RO

#define R_SCSI1_STATUS__READ(addr) \
  (*(addr))

#define R_SCSI1_STATUS__tst_arb_won__tst_arb_won__MASK 0x00800000U
#define R_SCSI1_STATUS__tst_resel__tst_resel__MASK 0x00400000U
#define R_SCSI1_STATUS__parity_error__parity_error__MASK 0x00200000U
#define R_SCSI1_STATUS__bus_reset__bus_reset__MASK 0x00100000U
#define R_SCSI1_STATUS__resel_target__resel_target__MASK 0x00078000U
#define R_SCSI1_STATUS__resel__resel__MASK 0x00004000U
#define R_SCSI1_STATUS__curr_phase__curr_phase__MASK 0x00003800U
#define R_SCSI1_STATUS__last_seq_step__last_seq_step__MASK 0x000007c0U
#define R_SCSI1_STATUS__valid_status__valid_status__MASK 0x00000020U
#define R_SCSI1_STATUS__seq_status__seq_status__MASK 0x0000001fU

#define R_SCSI1_STATUS__tst_arb_won__MAX 0x1
#define R_SCSI1_STATUS__tst_resel__MAX 0x1
#define R_SCSI1_STATUS__parity_error__MAX 0x1
#define R_SCSI1_STATUS__bus_reset__MAX 0x1
#define R_SCSI1_STATUS__resel_target__MAX 0xf
#define R_SCSI1_STATUS__resel__MAX 0x1
#define R_SCSI1_STATUS__curr_phase__MAX 0x7
#define R_SCSI1_STATUS__last_seq_step__MAX 0x1f
#define R_SCSI1_STATUS__valid_status__MAX 0x1
#define R_SCSI1_STATUS__seq_status__MAX 0x1f

#define R_SCSI1_STATUS__tst_arb_won__MIN 0
#define R_SCSI1_STATUS__tst_resel__MIN 0
#define R_SCSI1_STATUS__parity_error__MIN 0
#define R_SCSI1_STATUS__bus_reset__MIN 0
#define R_SCSI1_STATUS__resel_target__MIN 0
#define R_SCSI1_STATUS__resel__MIN 0
#define R_SCSI1_STATUS__curr_phase__MIN 0
#define R_SCSI1_STATUS__last_seq_step__MIN 0
#define R_SCSI1_STATUS__valid_status__MIN 0
#define R_SCSI1_STATUS__seq_status__MIN 0

#define R_SCSI1_STATUS__tst_arb_won__BITNR 23
#define R_SCSI1_STATUS__tst_resel__BITNR 22
#define R_SCSI1_STATUS__parity_error__BITNR 21
#define R_SCSI1_STATUS__bus_reset__BITNR 20
#define R_SCSI1_STATUS__resel_target__BITNR 15
#define R_SCSI1_STATUS__resel__BITNR 14
#define R_SCSI1_STATUS__curr_phase__BITNR 11
#define R_SCSI1_STATUS__last_seq_step__BITNR 6
#define R_SCSI1_STATUS__valid_status__BITNR 5
#define R_SCSI1_STATUS__seq_status__BITNR 0

#define R_SCSI1_STATUS__tst_arb_won__tst_arb_won__VAL REG_VAL_VAL
#define R_SCSI1_STATUS__tst_resel__tst_resel__VAL REG_VAL_VAL
#define R_SCSI1_STATUS__parity_error__parity_error__VAL REG_VAL_VAL
#define R_SCSI1_STATUS__bus_reset__bus_reset__VAL REG_VAL_ENUM
#define R_SCSI1_STATUS__resel_target__resel_target__VAL REG_VAL_VAL
#define R_SCSI1_STATUS__resel__resel__VAL REG_VAL_ENUM
#define R_SCSI1_STATUS__curr_phase__curr_phase__VAL REG_VAL_ENUM
#define R_SCSI1_STATUS__last_seq_step__last_seq_step__VAL REG_VAL_ENUM
#define R_SCSI1_STATUS__valid_status__valid_status__VAL REG_VAL_ENUM
#define R_SCSI1_STATUS__seq_status__seq_status__VAL REG_VAL_ENUM

#define R_SCSI1_STATUS__bus_reset__bus_reset__no 0
#define R_SCSI1_STATUS__bus_reset__bus_reset__yes 1
#define R_SCSI1_STATUS__resel__resel__no 0
#define R_SCSI1_STATUS__resel__resel__yes 1
#define R_SCSI1_STATUS__curr_phase__curr_phase__ph_command 2
#define R_SCSI1_STATUS__curr_phase__curr_phase__ph_data_in 5
#define R_SCSI1_STATUS__curr_phase__curr_phase__ph_data_out 4
#define R_SCSI1_STATUS__curr_phase__curr_phase__ph_msg_in 7
#define R_SCSI1_STATUS__curr_phase__curr_phase__ph_msg_out 6
#define R_SCSI1_STATUS__curr_phase__curr_phase__ph_resel 1
#define R_SCSI1_STATUS__curr_phase__curr_phase__ph_status 3
#define R_SCSI1_STATUS__curr_phase__curr_phase__ph_undef 0
#define R_SCSI1_STATUS__last_seq_step__last_seq_step__st_answer 3
#define R_SCSI1_STATUS__last_seq_step__last_seq_step__st_arbitrate 8
#define R_SCSI1_STATUS__last_seq_step__last_seq_step__st_asynch_din 9
#define R_SCSI1_STATUS__last_seq_step__last_seq_step__st_asynch_dout 25
#define R_SCSI1_STATUS__last_seq_step__last_seq_step__st_asynch_dout_end 11
#define R_SCSI1_STATUS__last_seq_step__last_seq_step__st_bus_free 24
#define R_SCSI1_STATUS__last_seq_step__last_seq_step__st_cc 31
#define R_SCSI1_STATUS__last_seq_step__last_seq_step__st_iwr 27
#define R_SCSI1_STATUS__last_seq_step__last_seq_step__st_iwr_cc 23
#define R_SCSI1_STATUS__last_seq_step__last_seq_step__st_iwr_good 14
#define R_SCSI1_STATUS__last_seq_step__last_seq_step__st_manual 28
#define R_SCSI1_STATUS__last_seq_step__last_seq_step__st_manual_din_prot 18
#define R_SCSI1_STATUS__last_seq_step__last_seq_step__st_manual_req 10
#define R_SCSI1_STATUS__last_seq_step__last_seq_step__st_msg_1 2
#define R_SCSI1_STATUS__last_seq_step__last_seq_step__st_msg_2 6
#define R_SCSI1_STATUS__last_seq_step__last_seq_step__st_msg_3 22
#define R_SCSI1_STATUS__last_seq_step__last_seq_step__st_resel_req 29
#define R_SCSI1_STATUS__last_seq_step__last_seq_step__st_sdp_disc 7
#define R_SCSI1_STATUS__last_seq_step__last_seq_step__st_synch_din 13
#define R_SCSI1_STATUS__last_seq_step__last_seq_step__st_synch_din_ack 12
#define R_SCSI1_STATUS__last_seq_step__last_seq_step__st_synch_din_ack_perr 5
#define R_SCSI1_STATUS__last_seq_step__last_seq_step__st_synch_din_perr 1
#define R_SCSI1_STATUS__last_seq_step__last_seq_step__st_synch_dout 0
#define R_SCSI1_STATUS__last_seq_step__last_seq_step__st_synch_dout_ack 4
#define R_SCSI1_STATUS__last_seq_step__last_seq_step__st_transf_cmd 30
#define R_SCSI1_STATUS__last_seq_step__last_seq_step__st_transfer_done 15
#define R_SCSI1_STATUS__last_seq_step__last_seq_step__st_wait_free_cc 20
#define R_SCSI1_STATUS__last_seq_step__last_seq_step__st_wait_free_disc 21
#define R_SCSI1_STATUS__last_seq_step__last_seq_step__st_wait_free_iwr_cc 17
#define R_SCSI1_STATUS__last_seq_step__last_seq_step__st_wait_free_sdp_disc 16
#define R_SCSI1_STATUS__valid_status__valid_status__no 0
#define R_SCSI1_STATUS__valid_status__valid_status__yes 1
#define R_SCSI1_STATUS__seq_status__seq_status__info_arb_lost 4
#define R_SCSI1_STATUS__seq_status__seq_status__info_bus_free 13
#define R_SCSI1_STATUS__seq_status__seq_status__info_bus_reset 11
#define R_SCSI1_STATUS__seq_status__seq_status__info_illegal_bf 12
#define R_SCSI1_STATUS__seq_status__seq_status__info_illegal_op 7
#define R_SCSI1_STATUS__seq_status__seq_status__info_parity_error 1
#define R_SCSI1_STATUS__seq_status__seq_status__info_rec_recvd 8
#define R_SCSI1_STATUS__seq_status__seq_status__info_reselected 9
#define R_SCSI1_STATUS__seq_status__seq_status__info_sel_timeout 5
#define R_SCSI1_STATUS__seq_status__seq_status__info_seq_complete 0
#define R_SCSI1_STATUS__seq_status__seq_status__info_unexp_bf 6
#define R_SCSI1_STATUS__seq_status__seq_status__info_unexp_ph_change 3
#define R_SCSI1_STATUS__seq_status__seq_status__info_unhandled_msg_in 2
#define R_SCSI1_STATUS__seq_status__seq_status__info_unhandled_status 10

#endif

/*
 *  R_SCSI1_STATUS_CTRL
 *  - type:  WO
 *  - addr:  0xb0000053
 *  - group: SCSI registers
 */

#if USE_GROUP__SCSI_registers

#define R_SCSI1_STATUS_CTRL__ADDR      (REG_TYPECAST_BYTE  0xb0000053)

#ifndef REG_NO_SHADOW
#define R_SCSI1_STATUS_CTRL__SADDR     (REG_STYPECAST_BYTE (reg_shadow__hwregs.R_PAR1_CTRL_DATA + 3))
#define R_SCSI1_STATUS_CTRL__IADDR     (REG_STYPECAST_BYTE (reg_initiated__hwregs.R_PAR1_CTRL_DATA + 3))
#else /* REG_NO_SHADOW */
#define R_SCSI1_STATUS_CTRL__SADDR     (REG_STYPECAST_BYTE (&reg_shadow__hwregs))
#define R_SCSI1_STATUS_CTRL__IADDR     (REG_STYPECAST_BYTE (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_SCSI1_STATUS_CTRL__STYPECAST REG_STYPECAST_BYTE
#define R_SCSI1_STATUS_CTRL__SVAL      REG_SVAL_SHADOW
#define R_SCSI1_STATUS_CTRL__SVAL_I    REG_SVAL_I_SHADOW
#define R_SCSI1_STATUS_CTRL__TYPECAST  REG_TYPECAST_BYTE
#define R_SCSI1_STATUS_CTRL__TYPE      (REG_BYTE)
#define R_SCSI1_STATUS_CTRL__GET       REG_GET_WO
#define R_SCSI1_STATUS_CTRL__IGET      REG_IGET_WO
#define R_SCSI1_STATUS_CTRL__SET       REG_SET_WO
#define R_SCSI1_STATUS_CTRL__ISET      REG_ISET_WO
#define R_SCSI1_STATUS_CTRL__SET_VAL   REG_SET_VAL_WO
#define R_SCSI1_STATUS_CTRL__EQL       REG_EQL_WO
#define R_SCSI1_STATUS_CTRL__IEQL      REG_IEQL_WO
#define R_SCSI1_STATUS_CTRL__RD        REG_RD_WO
#define R_SCSI1_STATUS_CTRL__IRD       REG_IRD_WO
#define R_SCSI1_STATUS_CTRL__WR        REG_WR_WO
#define R_SCSI1_STATUS_CTRL__IWR       REG_IWR_WO

#define R_SCSI1_STATUS_CTRL__WRITE(addr,value) \
  (*(addr) = (value))

#define R_SCSI1_STATUS_CTRL__parity_in__parity_in__MASK 0x00000004U
#define R_SCSI1_STATUS_CTRL__skip__skip__MASK 0x00000002U
#define R_SCSI1_STATUS_CTRL__clr_status__clr_status__MASK 0x00000001U

#define R_SCSI1_STATUS_CTRL__parity_in__MAX 0x1
#define R_SCSI1_STATUS_CTRL__skip__MAX 0x1
#define R_SCSI1_STATUS_CTRL__clr_status__MAX 0x1

#define R_SCSI1_STATUS_CTRL__parity_in__MIN 0
#define R_SCSI1_STATUS_CTRL__skip__MIN 0
#define R_SCSI1_STATUS_CTRL__clr_status__MIN 0

#define R_SCSI1_STATUS_CTRL__parity_in__BITNR 2
#define R_SCSI1_STATUS_CTRL__skip__BITNR 1
#define R_SCSI1_STATUS_CTRL__clr_status__BITNR 0

#define R_SCSI1_STATUS_CTRL__parity_in__parity_in__VAL REG_VAL_ENUM
#define R_SCSI1_STATUS_CTRL__skip__skip__VAL REG_VAL_ENUM
#define R_SCSI1_STATUS_CTRL__clr_status__clr_status__VAL REG_VAL_ENUM

#define R_SCSI1_STATUS_CTRL__parity_in__parity_in__off 1
#define R_SCSI1_STATUS_CTRL__parity_in__parity_in__on 0
#define R_SCSI1_STATUS_CTRL__skip__skip__off 0
#define R_SCSI1_STATUS_CTRL__skip__skip__on 1
#define R_SCSI1_STATUS_CTRL__clr_status__clr_status__nop 0
#define R_SCSI1_STATUS_CTRL__clr_status__clr_status__yes 1

#endif

/*
 *  R_SDRAM_CONFIG
 *  - type:  WO
 *  - addr:  0xb000000c
 *  - group: Bus interface configuration registers
 */

#if USE_GROUP__Bus_interface_configuration_registers

#define R_SDRAM_CONFIG__ADDR      (REG_TYPECAST_UDWORD  0xb000000c)

#ifndef REG_NO_SHADOW
#define R_SDRAM_CONFIG__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_DRAM_CONFIG + 0))
#define R_SDRAM_CONFIG__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_DRAM_CONFIG + 0))
#else /* REG_NO_SHADOW */
#define R_SDRAM_CONFIG__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_SDRAM_CONFIG__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_SDRAM_CONFIG__STYPECAST REG_STYPECAST_UDWORD
#define R_SDRAM_CONFIG__SVAL      REG_SVAL_SHADOW
#define R_SDRAM_CONFIG__SVAL_I    REG_SVAL_I_SHADOW
#define R_SDRAM_CONFIG__TYPECAST  REG_TYPECAST_UDWORD
#define R_SDRAM_CONFIG__TYPE      (REG_UDWORD)
#define R_SDRAM_CONFIG__GET       REG_GET_WO
#define R_SDRAM_CONFIG__IGET      REG_IGET_WO
#define R_SDRAM_CONFIG__SET       REG_SET_WO
#define R_SDRAM_CONFIG__ISET      REG_ISET_WO
#define R_SDRAM_CONFIG__SET_VAL   REG_SET_VAL_WO
#define R_SDRAM_CONFIG__EQL       REG_EQL_WO
#define R_SDRAM_CONFIG__IEQL      REG_IEQL_WO
#define R_SDRAM_CONFIG__RD        REG_RD_WO
#define R_SDRAM_CONFIG__IRD       REG_IRD_WO
#define R_SDRAM_CONFIG__WR        REG_WR_WO
#define R_SDRAM_CONFIG__IWR       REG_IWR_WO

#define R_SDRAM_CONFIG__WRITE(addr,value) \
  (*(addr) = (value))

#define R_SDRAM_CONFIG__wmm1__wmm1__MASK 0x80000000U
#define R_SDRAM_CONFIG__wmm0__wmm0__MASK 0x40000000U
#define R_SDRAM_CONFIG__sh1__sh1__MASK 0x38000000U
#define R_SDRAM_CONFIG__sh0__sh0__MASK 0x07000000U
#define R_SDRAM_CONFIG__w__w__MASK 0x00800000U
#define R_SDRAM_CONFIG__type1__type1__MASK 0x00400000U
#define R_SDRAM_CONFIG__type0__type0__MASK 0x00200000U
#define R_SDRAM_CONFIG__group_sel__group_sel__MASK 0x001f0000U
#define R_SDRAM_CONFIG__ca1__ca1__MASK 0x0000e000U
#define R_SDRAM_CONFIG__bank_sel1__bank_sel1__MASK 0x00001f00U
#define R_SDRAM_CONFIG__ca0__ca0__MASK 0x000000e0U
#define R_SDRAM_CONFIG__bank_sel0__bank_sel0__MASK 0x0000001fU

#define R_SDRAM_CONFIG__wmm1__MAX 0x1
#define R_SDRAM_CONFIG__wmm0__MAX 0x1
#define R_SDRAM_CONFIG__sh1__MAX 7
#define R_SDRAM_CONFIG__sh0__MAX 7
#define R_SDRAM_CONFIG__w__MAX 0x1
#define R_SDRAM_CONFIG__type1__MAX 0x1
#define R_SDRAM_CONFIG__type0__MAX 0x1
#define R_SDRAM_CONFIG__group_sel__MAX 0x1f
#define R_SDRAM_CONFIG__ca1__MAX 7
#define R_SDRAM_CONFIG__bank_sel1__MAX 0x1f
#define R_SDRAM_CONFIG__ca0__MAX 7
#define R_SDRAM_CONFIG__bank_sel0__MAX 0x1f

#define R_SDRAM_CONFIG__wmm1__MIN 0
#define R_SDRAM_CONFIG__wmm0__MIN 0
#define R_SDRAM_CONFIG__sh1__MIN 0
#define R_SDRAM_CONFIG__sh0__MIN 0
#define R_SDRAM_CONFIG__w__MIN 0
#define R_SDRAM_CONFIG__type1__MIN 0
#define R_SDRAM_CONFIG__type0__MIN 0
#define R_SDRAM_CONFIG__group_sel__MIN 0
#define R_SDRAM_CONFIG__ca1__MIN 0
#define R_SDRAM_CONFIG__bank_sel1__MIN 0
#define R_SDRAM_CONFIG__ca0__MIN 0
#define R_SDRAM_CONFIG__bank_sel0__MIN 0

#define R_SDRAM_CONFIG__wmm1__BITNR 31
#define R_SDRAM_CONFIG__wmm0__BITNR 30
#define R_SDRAM_CONFIG__sh1__BITNR 27
#define R_SDRAM_CONFIG__sh0__BITNR 24
#define R_SDRAM_CONFIG__w__BITNR 23
#define R_SDRAM_CONFIG__type1__BITNR 22
#define R_SDRAM_CONFIG__type0__BITNR 21
#define R_SDRAM_CONFIG__group_sel__BITNR 16
#define R_SDRAM_CONFIG__ca1__BITNR 13
#define R_SDRAM_CONFIG__bank_sel1__BITNR 8
#define R_SDRAM_CONFIG__ca0__BITNR 5
#define R_SDRAM_CONFIG__bank_sel0__BITNR 0

#define R_SDRAM_CONFIG__wmm1__wmm1__VAL REG_VAL_ENUM
#define R_SDRAM_CONFIG__wmm0__wmm0__VAL REG_VAL_ENUM
#define R_SDRAM_CONFIG__sh1__sh1__VAL REG_VAL_VAL
#define R_SDRAM_CONFIG__sh0__sh0__VAL REG_VAL_VAL
#define R_SDRAM_CONFIG__w__w__VAL REG_VAL_ENUM
#define R_SDRAM_CONFIG__type1__type1__VAL REG_VAL_ENUM
#define R_SDRAM_CONFIG__type0__type0__VAL REG_VAL_ENUM
#define R_SDRAM_CONFIG__group_sel__group_sel__VAL REG_VAL_ENUM
#define R_SDRAM_CONFIG__ca1__ca1__VAL REG_VAL_VAL
#define R_SDRAM_CONFIG__bank_sel1__bank_sel1__VAL REG_VAL_ENUM
#define R_SDRAM_CONFIG__ca0__ca0__VAL REG_VAL_VAL
#define R_SDRAM_CONFIG__bank_sel0__bank_sel0__VAL REG_VAL_ENUM

#define R_SDRAM_CONFIG__wmm1__wmm1__norm 0
#define R_SDRAM_CONFIG__wmm1__wmm1__wmm 1
#define R_SDRAM_CONFIG__wmm0__wmm0__norm 0
#define R_SDRAM_CONFIG__wmm0__wmm0__wmm 1
#define R_SDRAM_CONFIG__w__w__bw16 0
#define R_SDRAM_CONFIG__w__w__bw32 1
#define R_SDRAM_CONFIG__type1__type1__bank2 0
#define R_SDRAM_CONFIG__type1__type1__bank4 1
#define R_SDRAM_CONFIG__type0__type0__bank2 0
#define R_SDRAM_CONFIG__type0__type0__bank4 1
#define R_SDRAM_CONFIG__group_sel__group_sel__bit10 10
#define R_SDRAM_CONFIG__group_sel__group_sel__bit11 11
#define R_SDRAM_CONFIG__group_sel__group_sel__bit12 12
#define R_SDRAM_CONFIG__group_sel__group_sel__bit13 13
#define R_SDRAM_CONFIG__group_sel__group_sel__bit14 14
#define R_SDRAM_CONFIG__group_sel__group_sel__bit15 15
#define R_SDRAM_CONFIG__group_sel__group_sel__bit16 16
#define R_SDRAM_CONFIG__group_sel__group_sel__bit17 17
#define R_SDRAM_CONFIG__group_sel__group_sel__bit18 18
#define R_SDRAM_CONFIG__group_sel__group_sel__bit19 19
#define R_SDRAM_CONFIG__group_sel__group_sel__bit20 20
#define R_SDRAM_CONFIG__group_sel__group_sel__bit21 21
#define R_SDRAM_CONFIG__group_sel__group_sel__bit22 22
#define R_SDRAM_CONFIG__group_sel__group_sel__bit23 23
#define R_SDRAM_CONFIG__group_sel__group_sel__bit24 24
#define R_SDRAM_CONFIG__group_sel__group_sel__bit25 25
#define R_SDRAM_CONFIG__group_sel__group_sel__bit26 26
#define R_SDRAM_CONFIG__group_sel__group_sel__bit27 27
#define R_SDRAM_CONFIG__group_sel__group_sel__bit28 28
#define R_SDRAM_CONFIG__group_sel__group_sel__bit29 29
#define R_SDRAM_CONFIG__group_sel__group_sel__bit9 9
#define R_SDRAM_CONFIG__group_sel__group_sel__grp0 0
#define R_SDRAM_CONFIG__group_sel__group_sel__grp1 1
#define R_SDRAM_CONFIG__bank_sel1__bank_sel1__bit10 10
#define R_SDRAM_CONFIG__bank_sel1__bank_sel1__bit11 11
#define R_SDRAM_CONFIG__bank_sel1__bank_sel1__bit12 12
#define R_SDRAM_CONFIG__bank_sel1__bank_sel1__bit13 13
#define R_SDRAM_CONFIG__bank_sel1__bank_sel1__bit14 14
#define R_SDRAM_CONFIG__bank_sel1__bank_sel1__bit15 15
#define R_SDRAM_CONFIG__bank_sel1__bank_sel1__bit16 16
#define R_SDRAM_CONFIG__bank_sel1__bank_sel1__bit17 17
#define R_SDRAM_CONFIG__bank_sel1__bank_sel1__bit18 18
#define R_SDRAM_CONFIG__bank_sel1__bank_sel1__bit19 19
#define R_SDRAM_CONFIG__bank_sel1__bank_sel1__bit20 20
#define R_SDRAM_CONFIG__bank_sel1__bank_sel1__bit21 21
#define R_SDRAM_CONFIG__bank_sel1__bank_sel1__bit22 22
#define R_SDRAM_CONFIG__bank_sel1__bank_sel1__bit23 23
#define R_SDRAM_CONFIG__bank_sel1__bank_sel1__bit24 24
#define R_SDRAM_CONFIG__bank_sel1__bank_sel1__bit25 25
#define R_SDRAM_CONFIG__bank_sel1__bank_sel1__bit26 26
#define R_SDRAM_CONFIG__bank_sel1__bank_sel1__bit27 27
#define R_SDRAM_CONFIG__bank_sel1__bank_sel1__bit28 28
#define R_SDRAM_CONFIG__bank_sel1__bank_sel1__bit29 29
#define R_SDRAM_CONFIG__bank_sel1__bank_sel1__bit9 9
#define R_SDRAM_CONFIG__bank_sel0__bank_sel0__bit10 10
#define R_SDRAM_CONFIG__bank_sel0__bank_sel0__bit11 11
#define R_SDRAM_CONFIG__bank_sel0__bank_sel0__bit12 12
#define R_SDRAM_CONFIG__bank_sel0__bank_sel0__bit13 13
#define R_SDRAM_CONFIG__bank_sel0__bank_sel0__bit14 14
#define R_SDRAM_CONFIG__bank_sel0__bank_sel0__bit15 15
#define R_SDRAM_CONFIG__bank_sel0__bank_sel0__bit16 16
#define R_SDRAM_CONFIG__bank_sel0__bank_sel0__bit17 17
#define R_SDRAM_CONFIG__bank_sel0__bank_sel0__bit18 18
#define R_SDRAM_CONFIG__bank_sel0__bank_sel0__bit19 19
#define R_SDRAM_CONFIG__bank_sel0__bank_sel0__bit20 20
#define R_SDRAM_CONFIG__bank_sel0__bank_sel0__bit21 21
#define R_SDRAM_CONFIG__bank_sel0__bank_sel0__bit22 22
#define R_SDRAM_CONFIG__bank_sel0__bank_sel0__bit23 23
#define R_SDRAM_CONFIG__bank_sel0__bank_sel0__bit24 24
#define R_SDRAM_CONFIG__bank_sel0__bank_sel0__bit25 25
#define R_SDRAM_CONFIG__bank_sel0__bank_sel0__bit26 26
#define R_SDRAM_CONFIG__bank_sel0__bank_sel0__bit27 27
#define R_SDRAM_CONFIG__bank_sel0__bank_sel0__bit28 28
#define R_SDRAM_CONFIG__bank_sel0__bank_sel0__bit29 29
#define R_SDRAM_CONFIG__bank_sel0__bank_sel0__bit9 9

#endif

/*
 *  R_SDRAM_TIMING
 *  - type:  WO
 *  - addr:  0xb0000008
 *  - group: Bus interface configuration registers
 */

#if USE_GROUP__Bus_interface_configuration_registers

#define R_SDRAM_TIMING__ADDR      (REG_TYPECAST_UDWORD  0xb0000008)

#ifndef REG_NO_SHADOW
#define R_SDRAM_TIMING__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_DRAM_TIMING + 0))
#define R_SDRAM_TIMING__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_DRAM_TIMING + 0))
#else /* REG_NO_SHADOW */
#define R_SDRAM_TIMING__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_SDRAM_TIMING__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_SDRAM_TIMING__STYPECAST REG_STYPECAST_UDWORD
#define R_SDRAM_TIMING__SVAL      REG_SVAL_SHADOW
#define R_SDRAM_TIMING__SVAL_I    REG_SVAL_I_SHADOW
#define R_SDRAM_TIMING__TYPECAST  REG_TYPECAST_UDWORD
#define R_SDRAM_TIMING__TYPE      (REG_UDWORD)
#define R_SDRAM_TIMING__GET       REG_GET_WO
#define R_SDRAM_TIMING__IGET      REG_IGET_WO
#define R_SDRAM_TIMING__SET       REG_SET_WO
#define R_SDRAM_TIMING__ISET      REG_ISET_WO
#define R_SDRAM_TIMING__SET_VAL   REG_SET_VAL_WO
#define R_SDRAM_TIMING__EQL       REG_EQL_WO
#define R_SDRAM_TIMING__IEQL      REG_IEQL_WO
#define R_SDRAM_TIMING__RD        REG_RD_WO
#define R_SDRAM_TIMING__IRD       REG_IRD_WO
#define R_SDRAM_TIMING__WR        REG_WR_WO
#define R_SDRAM_TIMING__IWR       REG_IWR_WO

#define R_SDRAM_TIMING__WRITE(addr,value) \
  (*(addr) = (value))

#define R_SDRAM_TIMING__sdram__sdram__MASK 0x80000000U
#define R_SDRAM_TIMING__mrs_data__mrs_data__MASK 0x7fff0000U
#define R_SDRAM_TIMING__ref__ref__MASK 0x0000c000U
#define R_SDRAM_TIMING__ddr__ddr__MASK 0x00002000U
#define R_SDRAM_TIMING__clk100__clk100__MASK 0x00001000U
#define R_SDRAM_TIMING__ps__ps__MASK 0x00000800U
#define R_SDRAM_TIMING__cmd__cmd__MASK 0x00000600U
#define R_SDRAM_TIMING__pde__pde__MASK 0x00000100U
#define R_SDRAM_TIMING__rc__rc__MASK 0x000000c0U
#define R_SDRAM_TIMING__rp__rp__MASK 0x00000030U
#define R_SDRAM_TIMING__rcd__rcd__MASK 0x0000000cU
#define R_SDRAM_TIMING__cl__cl__MASK 0x00000003U

#define R_SDRAM_TIMING__sdram__MAX 0x1
#define R_SDRAM_TIMING__mrs_data__MAX 0x7fff
#define R_SDRAM_TIMING__ref__MAX 0x3
#define R_SDRAM_TIMING__ddr__MAX 0x1
#define R_SDRAM_TIMING__clk100__MAX 0x1
#define R_SDRAM_TIMING__ps__MAX 0x1
#define R_SDRAM_TIMING__cmd__MAX 0x3
#define R_SDRAM_TIMING__pde__MAX 1
#define R_SDRAM_TIMING__rc__MAX 3
#define R_SDRAM_TIMING__rp__MAX 3
#define R_SDRAM_TIMING__rcd__MAX 3
#define R_SDRAM_TIMING__cl__MAX 2

#define R_SDRAM_TIMING__sdram__MIN 0
#define R_SDRAM_TIMING__mrs_data__MIN 0
#define R_SDRAM_TIMING__ref__MIN 0
#define R_SDRAM_TIMING__ddr__MIN 0
#define R_SDRAM_TIMING__clk100__MIN 0
#define R_SDRAM_TIMING__ps__MIN 0
#define R_SDRAM_TIMING__cmd__MIN 0
#define R_SDRAM_TIMING__pde__MIN 0
#define R_SDRAM_TIMING__rc__MIN 0
#define R_SDRAM_TIMING__rp__MIN 0
#define R_SDRAM_TIMING__rcd__MIN 0
#define R_SDRAM_TIMING__cl__MIN 0

#define R_SDRAM_TIMING__sdram__BITNR 31
#define R_SDRAM_TIMING__mrs_data__BITNR 16
#define R_SDRAM_TIMING__ref__BITNR 14
#define R_SDRAM_TIMING__ddr__BITNR 13
#define R_SDRAM_TIMING__clk100__BITNR 12
#define R_SDRAM_TIMING__ps__BITNR 11
#define R_SDRAM_TIMING__cmd__BITNR 9
#define R_SDRAM_TIMING__pde__BITNR 8
#define R_SDRAM_TIMING__rc__BITNR 6
#define R_SDRAM_TIMING__rp__BITNR 4
#define R_SDRAM_TIMING__rcd__BITNR 2
#define R_SDRAM_TIMING__cl__BITNR 0

#define R_SDRAM_TIMING__sdram__sdram__VAL REG_VAL_ENUM
#define R_SDRAM_TIMING__mrs_data__mrs_data__VAL REG_VAL_VAL
#define R_SDRAM_TIMING__ref__ref__VAL REG_VAL_ENUM
#define R_SDRAM_TIMING__ddr__ddr__VAL REG_VAL_ENUM
#define R_SDRAM_TIMING__clk100__clk100__VAL REG_VAL_ENUM
#define R_SDRAM_TIMING__ps__ps__VAL REG_VAL_ENUM
#define R_SDRAM_TIMING__cmd__cmd__VAL REG_VAL_ENUM
#define R_SDRAM_TIMING__pde__pde__VAL REG_VAL_VAL
#define R_SDRAM_TIMING__rc__rc__VAL REG_VAL_VAL
#define R_SDRAM_TIMING__rp__rp__VAL REG_VAL_VAL
#define R_SDRAM_TIMING__rcd__rcd__VAL REG_VAL_VAL
#define R_SDRAM_TIMING__cl__cl__VAL REG_VAL_VAL

#define R_SDRAM_TIMING__sdram__sdram__disable 0
#define R_SDRAM_TIMING__sdram__sdram__enable 1
#define R_SDRAM_TIMING__ref__ref__disable 3
#define R_SDRAM_TIMING__ref__ref__e13us 1
#define R_SDRAM_TIMING__ref__ref__e52us 0
#define R_SDRAM_TIMING__ref__ref__e6500ns 2
#define R_SDRAM_TIMING__ddr__ddr__off 0
#define R_SDRAM_TIMING__ddr__ddr__on 1
#define R_SDRAM_TIMING__clk100__clk100__off 0
#define R_SDRAM_TIMING__clk100__clk100__on 1
#define R_SDRAM_TIMING__ps__ps__off 0
#define R_SDRAM_TIMING__ps__ps__on 1
#define R_SDRAM_TIMING__cmd__cmd__mrs 1
#define R_SDRAM_TIMING__cmd__cmd__nop 0
#define R_SDRAM_TIMING__cmd__cmd__pre 3
#define R_SDRAM_TIMING__cmd__cmd__ref 2

#endif

/*
 *  R_SERIAL0_BAUD
 *  - type:  WO
 *  - addr:  0xb0000063
 *  - group: Serial port registers
 */

#if USE_GROUP__Serial_port_registers

#define R_SERIAL0_BAUD__ADDR      (REG_TYPECAST_BYTE  0xb0000063)

#ifndef REG_NO_SHADOW
#define R_SERIAL0_BAUD__SADDR     (REG_STYPECAST_BYTE (reg_shadow__hwregs.R_SERIAL0_CTRL + 3))
#define R_SERIAL0_BAUD__IADDR     (REG_STYPECAST_BYTE (reg_initiated__hwregs.R_SERIAL0_CTRL + 3))
#else /* REG_NO_SHADOW */
#define R_SERIAL0_BAUD__SADDR     (REG_STYPECAST_BYTE (&reg_shadow__hwregs))
#define R_SERIAL0_BAUD__IADDR     (REG_STYPECAST_BYTE (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_SERIAL0_BAUD__STYPECAST REG_STYPECAST_BYTE
#define R_SERIAL0_BAUD__SVAL      REG_SVAL_SHADOW
#define R_SERIAL0_BAUD__SVAL_I    REG_SVAL_I_SHADOW
#define R_SERIAL0_BAUD__TYPECAST  REG_TYPECAST_BYTE
#define R_SERIAL0_BAUD__TYPE      (REG_BYTE)
#define R_SERIAL0_BAUD__GET       REG_GET_WO
#define R_SERIAL0_BAUD__IGET      REG_IGET_WO
#define R_SERIAL0_BAUD__SET       REG_SET_WO
#define R_SERIAL0_BAUD__ISET      REG_ISET_WO
#define R_SERIAL0_BAUD__SET_VAL   REG_SET_VAL_WO
#define R_SERIAL0_BAUD__EQL       REG_EQL_WO
#define R_SERIAL0_BAUD__IEQL      REG_IEQL_WO
#define R_SERIAL0_BAUD__RD        REG_RD_WO
#define R_SERIAL0_BAUD__IRD       REG_IRD_WO
#define R_SERIAL0_BAUD__WR        REG_WR_WO
#define R_SERIAL0_BAUD__IWR       REG_IWR_WO

#define R_SERIAL0_BAUD__WRITE(addr,value) \
  (*(addr) = (value))

/* From control-file '/n/asic/projects/etrax_ng/include//hwregs.ctrl' */
#define R_SERIAL0_BAUD__FIRST 0
#define R_SERIAL0_BAUD__IOFFSET 8
#define R_SERIAL0_BAUD__LAST 3
#define R_SERIAL0_BAUD__OFFSET 8
#define R_SERIAL0_BAUD__SOFFSET 8
/* end */

#define R_SERIAL0_BAUD__tr_baud__tr_baud__MASK 0x000000f0U
#define R_SERIAL0_BAUD__rec_baud__rec_baud__MASK 0x0000000fU

#define R_SERIAL0_BAUD__tr_baud__MAX 0xf
#define R_SERIAL0_BAUD__rec_baud__MAX 0xf

#define R_SERIAL0_BAUD__tr_baud__MIN 0
#define R_SERIAL0_BAUD__rec_baud__MIN 0

#define R_SERIAL0_BAUD__tr_baud__BITNR 4
#define R_SERIAL0_BAUD__rec_baud__BITNR 0

#define R_SERIAL0_BAUD__tr_baud__tr_baud__VAL REG_VAL_ENUM
#define R_SERIAL0_BAUD__rec_baud__rec_baud__VAL REG_VAL_ENUM

#define R_SERIAL0_BAUD__tr_baud__tr_baud__c115k2Hz 9
#define R_SERIAL0_BAUD__tr_baud__tr_baud__c1200Hz 2
#define R_SERIAL0_BAUD__tr_baud__tr_baud__c1843k2Hz 13
#define R_SERIAL0_BAUD__tr_baud__tr_baud__c19k2Hz 6
#define R_SERIAL0_BAUD__tr_baud__tr_baud__c230k4Hz 10
#define R_SERIAL0_BAUD__tr_baud__tr_baud__c2400Hz 3
#define R_SERIAL0_BAUD__tr_baud__tr_baud__c300Hz 0
#define R_SERIAL0_BAUD__tr_baud__tr_baud__c38k4Hz 7
#define R_SERIAL0_BAUD__tr_baud__tr_baud__c460k8Hz 11
#define R_SERIAL0_BAUD__tr_baud__tr_baud__c4800Hz 4
#define R_SERIAL0_BAUD__tr_baud__tr_baud__c57k6Hz 8
#define R_SERIAL0_BAUD__tr_baud__tr_baud__c600Hz 1
#define R_SERIAL0_BAUD__tr_baud__tr_baud__c6250kHz 14
#define R_SERIAL0_BAUD__tr_baud__tr_baud__c921k6Hz 12
#define R_SERIAL0_BAUD__tr_baud__tr_baud__c9600Hz 5
#define R_SERIAL0_BAUD__rec_baud__rec_baud__c115k2Hz 9
#define R_SERIAL0_BAUD__rec_baud__rec_baud__c1200Hz 2
#define R_SERIAL0_BAUD__rec_baud__rec_baud__c1843k2Hz 13
#define R_SERIAL0_BAUD__rec_baud__rec_baud__c19k2Hz 6
#define R_SERIAL0_BAUD__rec_baud__rec_baud__c230k4Hz 10
#define R_SERIAL0_BAUD__rec_baud__rec_baud__c2400Hz 3
#define R_SERIAL0_BAUD__rec_baud__rec_baud__c300Hz 0
#define R_SERIAL0_BAUD__rec_baud__rec_baud__c38k4Hz 7
#define R_SERIAL0_BAUD__rec_baud__rec_baud__c460k8Hz 11
#define R_SERIAL0_BAUD__rec_baud__rec_baud__c4800Hz 4
#define R_SERIAL0_BAUD__rec_baud__rec_baud__c57k6Hz 8
#define R_SERIAL0_BAUD__rec_baud__rec_baud__c600Hz 1
#define R_SERIAL0_BAUD__rec_baud__rec_baud__c6250kHz 14
#define R_SERIAL0_BAUD__rec_baud__rec_baud__c921k6Hz 12
#define R_SERIAL0_BAUD__rec_baud__rec_baud__c9600Hz 5

#endif

/*
 *  R_SERIAL0_CTRL
 *  - type:  WO
 *  - addr:  0xb0000060
 *  - group: Serial port registers
 */

#if USE_GROUP__Serial_port_registers

#define R_SERIAL0_CTRL__ADDR      (REG_TYPECAST_UDWORD  0xb0000060)

#ifndef REG_NO_SHADOW
#define R_SERIAL0_CTRL__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_SERIAL0_CTRL + 0))
#define R_SERIAL0_CTRL__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_SERIAL0_CTRL + 0))
#else /* REG_NO_SHADOW */
#define R_SERIAL0_CTRL__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_SERIAL0_CTRL__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_SERIAL0_CTRL__STYPECAST REG_STYPECAST_UDWORD
#define R_SERIAL0_CTRL__SVAL      REG_SVAL_SHADOW
#define R_SERIAL0_CTRL__SVAL_I    REG_SVAL_I_SHADOW
#define R_SERIAL0_CTRL__TYPECAST  REG_TYPECAST_UDWORD
#define R_SERIAL0_CTRL__TYPE      (REG_UDWORD)
#define R_SERIAL0_CTRL__GET       REG_GET_WO
#define R_SERIAL0_CTRL__IGET      REG_IGET_WO
#define R_SERIAL0_CTRL__SET       REG_SET_WO
#define R_SERIAL0_CTRL__ISET      REG_ISET_WO
#define R_SERIAL0_CTRL__SET_VAL   REG_SET_VAL_WO
#define R_SERIAL0_CTRL__EQL       REG_EQL_WO
#define R_SERIAL0_CTRL__IEQL      REG_IEQL_WO
#define R_SERIAL0_CTRL__RD        REG_RD_WO
#define R_SERIAL0_CTRL__IRD       REG_IRD_WO
#define R_SERIAL0_CTRL__WR        REG_WR_WO
#define R_SERIAL0_CTRL__IWR       REG_IWR_WO

#define R_SERIAL0_CTRL__WRITE(addr,value) \
  (*(addr) = (value))

/* From control-file '/n/asic/projects/etrax_ng/include//hwregs.ctrl' */
#define R_SERIAL0_CTRL__FIRST 0
#define R_SERIAL0_CTRL__IOFFSET 8
#define R_SERIAL0_CTRL__LAST 3
#define R_SERIAL0_CTRL__OFFSET 8
#define R_SERIAL0_CTRL__SOFFSET 8
/* end */

#define R_SERIAL0_CTRL__tr_baud__tr_baud__MASK 0xf0000000U
#define R_SERIAL0_CTRL__rec_baud__rec_baud__MASK 0x0f000000U
#define R_SERIAL0_CTRL__dma_err__dma_err__MASK 0x00800000U
#define R_SERIAL0_CTRL__rec_enable__rec_enable__MASK 0x00400000U
#define R_SERIAL0_CTRL__rts___rts___MASK 0x00200000U
#define R_SERIAL0_CTRL__sampling__sampling__MASK 0x00100000U
#define R_SERIAL0_CTRL__rec_stick_par__rec_stick_par__MASK 0x00080000U
#define R_SERIAL0_CTRL__rec_par__rec_par__MASK 0x00040000U
#define R_SERIAL0_CTRL__rec_par_en__rec_par_en__MASK 0x00020000U
#define R_SERIAL0_CTRL__rec_bitnr__rec_bitnr__MASK 0x00010000U
#define R_SERIAL0_CTRL__txd__txd__MASK 0x00008000U
#define R_SERIAL0_CTRL__tr_enable__tr_enable__MASK 0x00004000U
#define R_SERIAL0_CTRL__auto_cts__auto_cts__MASK 0x00002000U
#define R_SERIAL0_CTRL__stop_bits__stop_bits__MASK 0x00001000U
#define R_SERIAL0_CTRL__tr_stick_par__tr_stick_par__MASK 0x00000800U
#define R_SERIAL0_CTRL__tr_par__tr_par__MASK 0x00000400U
#define R_SERIAL0_CTRL__tr_par_en__tr_par_en__MASK 0x00000200U
#define R_SERIAL0_CTRL__tr_bitnr__tr_bitnr__MASK 0x00000100U
#define R_SERIAL0_CTRL__data_out__data_out__MASK 0x000000ffU

#define R_SERIAL0_CTRL__tr_baud__MAX 0xf
#define R_SERIAL0_CTRL__rec_baud__MAX 0xf
#define R_SERIAL0_CTRL__dma_err__MAX 0x1
#define R_SERIAL0_CTRL__rec_enable__MAX 0x1
#define R_SERIAL0_CTRL__rts___MAX 0x1
#define R_SERIAL0_CTRL__sampling__MAX 0x1
#define R_SERIAL0_CTRL__rec_stick_par__MAX 0x1
#define R_SERIAL0_CTRL__rec_par__MAX 0x1
#define R_SERIAL0_CTRL__rec_par_en__MAX 0x1
#define R_SERIAL0_CTRL__rec_bitnr__MAX 0x1
#define R_SERIAL0_CTRL__txd__MAX 0x1
#define R_SERIAL0_CTRL__tr_enable__MAX 0x1
#define R_SERIAL0_CTRL__auto_cts__MAX 0x1
#define R_SERIAL0_CTRL__stop_bits__MAX 0x1
#define R_SERIAL0_CTRL__tr_stick_par__MAX 0x1
#define R_SERIAL0_CTRL__tr_par__MAX 0x1
#define R_SERIAL0_CTRL__tr_par_en__MAX 0x1
#define R_SERIAL0_CTRL__tr_bitnr__MAX 0x1
#define R_SERIAL0_CTRL__data_out__MAX 0xff

#define R_SERIAL0_CTRL__tr_baud__MIN 0
#define R_SERIAL0_CTRL__rec_baud__MIN 0
#define R_SERIAL0_CTRL__dma_err__MIN 0
#define R_SERIAL0_CTRL__rec_enable__MIN 0
#define R_SERIAL0_CTRL__rts___MIN 0
#define R_SERIAL0_CTRL__sampling__MIN 0
#define R_SERIAL0_CTRL__rec_stick_par__MIN 0
#define R_SERIAL0_CTRL__rec_par__MIN 0
#define R_SERIAL0_CTRL__rec_par_en__MIN 0
#define R_SERIAL0_CTRL__rec_bitnr__MIN 0
#define R_SERIAL0_CTRL__txd__MIN 0
#define R_SERIAL0_CTRL__tr_enable__MIN 0
#define R_SERIAL0_CTRL__auto_cts__MIN 0
#define R_SERIAL0_CTRL__stop_bits__MIN 0
#define R_SERIAL0_CTRL__tr_stick_par__MIN 0
#define R_SERIAL0_CTRL__tr_par__MIN 0
#define R_SERIAL0_CTRL__tr_par_en__MIN 0
#define R_SERIAL0_CTRL__tr_bitnr__MIN 0
#define R_SERIAL0_CTRL__data_out__MIN 0

#define R_SERIAL0_CTRL__tr_baud__BITNR 28
#define R_SERIAL0_CTRL__rec_baud__BITNR 24
#define R_SERIAL0_CTRL__dma_err__BITNR 23
#define R_SERIAL0_CTRL__rec_enable__BITNR 22
#define R_SERIAL0_CTRL__rts___BITNR 21
#define R_SERIAL0_CTRL__sampling__BITNR 20
#define R_SERIAL0_CTRL__rec_stick_par__BITNR 19
#define R_SERIAL0_CTRL__rec_par__BITNR 18
#define R_SERIAL0_CTRL__rec_par_en__BITNR 17
#define R_SERIAL0_CTRL__rec_bitnr__BITNR 16
#define R_SERIAL0_CTRL__txd__BITNR 15
#define R_SERIAL0_CTRL__tr_enable__BITNR 14
#define R_SERIAL0_CTRL__auto_cts__BITNR 13
#define R_SERIAL0_CTRL__stop_bits__BITNR 12
#define R_SERIAL0_CTRL__tr_stick_par__BITNR 11
#define R_SERIAL0_CTRL__tr_par__BITNR 10
#define R_SERIAL0_CTRL__tr_par_en__BITNR 9
#define R_SERIAL0_CTRL__tr_bitnr__BITNR 8
#define R_SERIAL0_CTRL__data_out__BITNR 0

#define R_SERIAL0_CTRL__tr_baud__tr_baud__VAL REG_VAL_ENUM
#define R_SERIAL0_CTRL__rec_baud__rec_baud__VAL REG_VAL_ENUM
#define R_SERIAL0_CTRL__dma_err__dma_err__VAL REG_VAL_ENUM
#define R_SERIAL0_CTRL__rec_enable__rec_enable__VAL REG_VAL_ENUM
#define R_SERIAL0_CTRL__rts___rts___VAL REG_VAL_ENUM
#define R_SERIAL0_CTRL__sampling__sampling__VAL REG_VAL_ENUM
#define R_SERIAL0_CTRL__rec_stick_par__rec_stick_par__VAL REG_VAL_ENUM
#define R_SERIAL0_CTRL__rec_par__rec_par__VAL REG_VAL_ENUM
#define R_SERIAL0_CTRL__rec_par_en__rec_par_en__VAL REG_VAL_ENUM
#define R_SERIAL0_CTRL__rec_bitnr__rec_bitnr__VAL REG_VAL_ENUM
#define R_SERIAL0_CTRL__txd__txd__VAL REG_VAL_VAL
#define R_SERIAL0_CTRL__tr_enable__tr_enable__VAL REG_VAL_ENUM
#define R_SERIAL0_CTRL__auto_cts__auto_cts__VAL REG_VAL_ENUM
#define R_SERIAL0_CTRL__stop_bits__stop_bits__VAL REG_VAL_ENUM
#define R_SERIAL0_CTRL__tr_stick_par__tr_stick_par__VAL REG_VAL_ENUM
#define R_SERIAL0_CTRL__tr_par__tr_par__VAL REG_VAL_ENUM
#define R_SERIAL0_CTRL__tr_par_en__tr_par_en__VAL REG_VAL_ENUM
#define R_SERIAL0_CTRL__tr_bitnr__tr_bitnr__VAL REG_VAL_ENUM
#define R_SERIAL0_CTRL__data_out__data_out__VAL REG_VAL_VAL

#define R_SERIAL0_CTRL__tr_baud__tr_baud__c115k2Hz 9
#define R_SERIAL0_CTRL__tr_baud__tr_baud__c1200Hz 2
#define R_SERIAL0_CTRL__tr_baud__tr_baud__c1843k2Hz 13
#define R_SERIAL0_CTRL__tr_baud__tr_baud__c19k2Hz 6
#define R_SERIAL0_CTRL__tr_baud__tr_baud__c230k4Hz 10
#define R_SERIAL0_CTRL__tr_baud__tr_baud__c2400Hz 3
#define R_SERIAL0_CTRL__tr_baud__tr_baud__c300Hz 0
#define R_SERIAL0_CTRL__tr_baud__tr_baud__c38k4Hz 7
#define R_SERIAL0_CTRL__tr_baud__tr_baud__c460k8Hz 11
#define R_SERIAL0_CTRL__tr_baud__tr_baud__c4800Hz 4
#define R_SERIAL0_CTRL__tr_baud__tr_baud__c57k6Hz 8
#define R_SERIAL0_CTRL__tr_baud__tr_baud__c600Hz 1
#define R_SERIAL0_CTRL__tr_baud__tr_baud__c6250kHz 14
#define R_SERIAL0_CTRL__tr_baud__tr_baud__c921k6Hz 12
#define R_SERIAL0_CTRL__tr_baud__tr_baud__c9600Hz 5
#define R_SERIAL0_CTRL__rec_baud__rec_baud__c115k2Hz 9
#define R_SERIAL0_CTRL__rec_baud__rec_baud__c1200Hz 2
#define R_SERIAL0_CTRL__rec_baud__rec_baud__c1843k2Hz 13
#define R_SERIAL0_CTRL__rec_baud__rec_baud__c19k2Hz 6
#define R_SERIAL0_CTRL__rec_baud__rec_baud__c230k4Hz 10
#define R_SERIAL0_CTRL__rec_baud__rec_baud__c2400Hz 3
#define R_SERIAL0_CTRL__rec_baud__rec_baud__c300Hz 0
#define R_SERIAL0_CTRL__rec_baud__rec_baud__c38k4Hz 7
#define R_SERIAL0_CTRL__rec_baud__rec_baud__c460k8Hz 11
#define R_SERIAL0_CTRL__rec_baud__rec_baud__c4800Hz 4
#define R_SERIAL0_CTRL__rec_baud__rec_baud__c57k6Hz 8
#define R_SERIAL0_CTRL__rec_baud__rec_baud__c600Hz 1
#define R_SERIAL0_CTRL__rec_baud__rec_baud__c6250kHz 14
#define R_SERIAL0_CTRL__rec_baud__rec_baud__c921k6Hz 12
#define R_SERIAL0_CTRL__rec_baud__rec_baud__c9600Hz 5
#define R_SERIAL0_CTRL__dma_err__dma_err__ignore 1
#define R_SERIAL0_CTRL__dma_err__dma_err__stop 0
#define R_SERIAL0_CTRL__rec_enable__rec_enable__disable 0
#define R_SERIAL0_CTRL__rec_enable__rec_enable__enable 1
#define R_SERIAL0_CTRL__rts___rts___active 0
#define R_SERIAL0_CTRL__rts___rts___inactive 1
#define R_SERIAL0_CTRL__sampling__sampling__majority 1
#define R_SERIAL0_CTRL__sampling__sampling__middle 0
#define R_SERIAL0_CTRL__rec_stick_par__rec_stick_par__normal 0
#define R_SERIAL0_CTRL__rec_stick_par__rec_stick_par__stick 1
#define R_SERIAL0_CTRL__rec_par__rec_par__even 0
#define R_SERIAL0_CTRL__rec_par__rec_par__odd 1
#define R_SERIAL0_CTRL__rec_par_en__rec_par_en__disable 0
#define R_SERIAL0_CTRL__rec_par_en__rec_par_en__enable 1
#define R_SERIAL0_CTRL__rec_bitnr__rec_bitnr__rec_7bit 1
#define R_SERIAL0_CTRL__rec_bitnr__rec_bitnr__rec_8bit 0
#define R_SERIAL0_CTRL__tr_enable__tr_enable__disable 0
#define R_SERIAL0_CTRL__tr_enable__tr_enable__enable 1
#define R_SERIAL0_CTRL__auto_cts__auto_cts__active 1
#define R_SERIAL0_CTRL__auto_cts__auto_cts__disabled 0
#define R_SERIAL0_CTRL__stop_bits__stop_bits__one_bit 0
#define R_SERIAL0_CTRL__stop_bits__stop_bits__two_bits 1
#define R_SERIAL0_CTRL__tr_stick_par__tr_stick_par__normal 0
#define R_SERIAL0_CTRL__tr_stick_par__tr_stick_par__stick 1
#define R_SERIAL0_CTRL__tr_par__tr_par__even 0
#define R_SERIAL0_CTRL__tr_par__tr_par__odd 1
#define R_SERIAL0_CTRL__tr_par_en__tr_par_en__disable 0
#define R_SERIAL0_CTRL__tr_par_en__tr_par_en__enable 1
#define R_SERIAL0_CTRL__tr_bitnr__tr_bitnr__tr_7bit 1
#define R_SERIAL0_CTRL__tr_bitnr__tr_bitnr__tr_8bit 0

#endif

/*
 *  R_SERIAL0_READ
 *  - type:  RO
 *  - addr:  0xb0000060
 *  - group: Serial port registers
 */

#if USE_GROUP__Serial_port_registers

#define R_SERIAL0_READ__ADDR      (REG_TYPECAST_UDWORD  0xb0000060)
#define R_SERIAL0_READ__SVAL      REG_SVAL_SHADOW
#define R_SERIAL0_READ__SVAL_I    REG_SVAL_I_SHADOW
#define R_SERIAL0_READ__TYPECAST  REG_TYPECAST_UDWORD
#define R_SERIAL0_READ__TYPE      (REG_UDWORD)
#define R_SERIAL0_READ__GET       REG_GET_RO
#define R_SERIAL0_READ__IGET      REG_IGET_RO
#define R_SERIAL0_READ__SET       REG_SET_RO
#define R_SERIAL0_READ__ISET      REG_ISET_RO
#define R_SERIAL0_READ__SET_VAL   REG_SET_VAL_RO
#define R_SERIAL0_READ__EQL       REG_EQL_RO
#define R_SERIAL0_READ__IEQL      REG_IEQL_RO
#define R_SERIAL0_READ__RD        REG_RD_RO
#define R_SERIAL0_READ__IRD       REG_IRD_RO
#define R_SERIAL0_READ__WR        REG_WR_RO
#define R_SERIAL0_READ__IWR       REG_IWR_RO

#define R_SERIAL0_READ__READ(addr) \
  (*(addr))

/* From control-file '/n/asic/projects/etrax_ng/include//hwregs.ctrl' */
#define R_SERIAL0_READ__FIRST 0
#define R_SERIAL0_READ__LAST 3
#define R_SERIAL0_READ__OFFSET 8
/* end */

#define R_SERIAL0_READ__xoff_detect__xoff_detect__MASK 0x00008000U
#define R_SERIAL0_READ__cts___cts___MASK 0x00004000U
#define R_SERIAL0_READ__tr_ready__tr_ready__MASK 0x00002000U
#define R_SERIAL0_READ__rxd__rxd__MASK 0x00001000U
#define R_SERIAL0_READ__overrun__overrun__MASK 0x00000800U
#define R_SERIAL0_READ__par_err__par_err__MASK 0x00000400U
#define R_SERIAL0_READ__framing_err__framing_err__MASK 0x00000200U
#define R_SERIAL0_READ__data_avail__data_avail__MASK 0x00000100U
#define R_SERIAL0_READ__data_in__data_in__MASK 0x000000ffU

#define R_SERIAL0_READ__xoff_detect__MAX 0x1
#define R_SERIAL0_READ__cts___MAX 0x1
#define R_SERIAL0_READ__tr_ready__MAX 0x1
#define R_SERIAL0_READ__rxd__MAX 0x1
#define R_SERIAL0_READ__overrun__MAX 0x1
#define R_SERIAL0_READ__par_err__MAX 0x1
#define R_SERIAL0_READ__framing_err__MAX 0x1
#define R_SERIAL0_READ__data_avail__MAX 0x1
#define R_SERIAL0_READ__data_in__MAX 0xff

#define R_SERIAL0_READ__xoff_detect__MIN 0
#define R_SERIAL0_READ__cts___MIN 0
#define R_SERIAL0_READ__tr_ready__MIN 0
#define R_SERIAL0_READ__rxd__MIN 0
#define R_SERIAL0_READ__overrun__MIN 0
#define R_SERIAL0_READ__par_err__MIN 0
#define R_SERIAL0_READ__framing_err__MIN 0
#define R_SERIAL0_READ__data_avail__MIN 0
#define R_SERIAL0_READ__data_in__MIN 0

#define R_SERIAL0_READ__xoff_detect__BITNR 15
#define R_SERIAL0_READ__cts___BITNR 14
#define R_SERIAL0_READ__tr_ready__BITNR 13
#define R_SERIAL0_READ__rxd__BITNR 12
#define R_SERIAL0_READ__overrun__BITNR 11
#define R_SERIAL0_READ__par_err__BITNR 10
#define R_SERIAL0_READ__framing_err__BITNR 9
#define R_SERIAL0_READ__data_avail__BITNR 8
#define R_SERIAL0_READ__data_in__BITNR 0

#define R_SERIAL0_READ__xoff_detect__xoff_detect__VAL REG_VAL_ENUM
#define R_SERIAL0_READ__cts___cts___VAL REG_VAL_ENUM
#define R_SERIAL0_READ__tr_ready__tr_ready__VAL REG_VAL_ENUM
#define R_SERIAL0_READ__rxd__rxd__VAL REG_VAL_VAL
#define R_SERIAL0_READ__overrun__overrun__VAL REG_VAL_ENUM
#define R_SERIAL0_READ__par_err__par_err__VAL REG_VAL_ENUM
#define R_SERIAL0_READ__framing_err__framing_err__VAL REG_VAL_ENUM
#define R_SERIAL0_READ__data_avail__data_avail__VAL REG_VAL_ENUM
#define R_SERIAL0_READ__data_in__data_in__VAL REG_VAL_VAL

#define R_SERIAL0_READ__xoff_detect__xoff_detect__no_xoff 0
#define R_SERIAL0_READ__xoff_detect__xoff_detect__xoff 1
#define R_SERIAL0_READ__cts___cts___active 0
#define R_SERIAL0_READ__cts___cts___inactive 1
#define R_SERIAL0_READ__tr_ready__tr_ready__full 0
#define R_SERIAL0_READ__tr_ready__tr_ready__ready 1
#define R_SERIAL0_READ__overrun__overrun__no 0
#define R_SERIAL0_READ__overrun__overrun__yes 1
#define R_SERIAL0_READ__par_err__par_err__no 0
#define R_SERIAL0_READ__par_err__par_err__yes 1
#define R_SERIAL0_READ__framing_err__framing_err__no 0
#define R_SERIAL0_READ__framing_err__framing_err__yes 1
#define R_SERIAL0_READ__data_avail__data_avail__no 0
#define R_SERIAL0_READ__data_avail__data_avail__yes 1

#endif

/*
 *  R_SERIAL0_REC_CTRL
 *  - type:  WO
 *  - addr:  0xb0000062
 *  - group: Serial port registers
 */

#if USE_GROUP__Serial_port_registers

#define R_SERIAL0_REC_CTRL__ADDR      (REG_TYPECAST_BYTE  0xb0000062)

#ifndef REG_NO_SHADOW
#define R_SERIAL0_REC_CTRL__SADDR     (REG_STYPECAST_BYTE (reg_shadow__hwregs.R_SERIAL0_CTRL + 2))
#define R_SERIAL0_REC_CTRL__IADDR     (REG_STYPECAST_BYTE (reg_initiated__hwregs.R_SERIAL0_CTRL + 2))
#else /* REG_NO_SHADOW */
#define R_SERIAL0_REC_CTRL__SADDR     (REG_STYPECAST_BYTE (&reg_shadow__hwregs))
#define R_SERIAL0_REC_CTRL__IADDR     (REG_STYPECAST_BYTE (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_SERIAL0_REC_CTRL__STYPECAST REG_STYPECAST_BYTE
#define R_SERIAL0_REC_CTRL__SVAL      REG_SVAL_SHADOW
#define R_SERIAL0_REC_CTRL__SVAL_I    REG_SVAL_I_SHADOW
#define R_SERIAL0_REC_CTRL__TYPECAST  REG_TYPECAST_BYTE
#define R_SERIAL0_REC_CTRL__TYPE      (REG_BYTE)
#define R_SERIAL0_REC_CTRL__GET       REG_GET_WO
#define R_SERIAL0_REC_CTRL__IGET      REG_IGET_WO
#define R_SERIAL0_REC_CTRL__SET       REG_SET_WO
#define R_SERIAL0_REC_CTRL__ISET      REG_ISET_WO
#define R_SERIAL0_REC_CTRL__SET_VAL   REG_SET_VAL_WO
#define R_SERIAL0_REC_CTRL__EQL       REG_EQL_WO
#define R_SERIAL0_REC_CTRL__IEQL      REG_IEQL_WO
#define R_SERIAL0_REC_CTRL__RD        REG_RD_WO
#define R_SERIAL0_REC_CTRL__IRD       REG_IRD_WO
#define R_SERIAL0_REC_CTRL__WR        REG_WR_WO
#define R_SERIAL0_REC_CTRL__IWR       REG_IWR_WO

#define R_SERIAL0_REC_CTRL__WRITE(addr,value) \
  (*(addr) = (value))

/* From control-file '/n/asic/projects/etrax_ng/include//hwregs.ctrl' */
#define R_SERIAL0_REC_CTRL__FIRST 0
#define R_SERIAL0_REC_CTRL__IOFFSET 8
#define R_SERIAL0_REC_CTRL__LAST 3
#define R_SERIAL0_REC_CTRL__OFFSET 8
#define R_SERIAL0_REC_CTRL__SOFFSET 8
/* end */

#define R_SERIAL0_REC_CTRL__dma_err__dma_err__MASK 0x00000080U
#define R_SERIAL0_REC_CTRL__rec_enable__rec_enable__MASK 0x00000040U
#define R_SERIAL0_REC_CTRL__rts___rts___MASK 0x00000020U
#define R_SERIAL0_REC_CTRL__sampling__sampling__MASK 0x00000010U
#define R_SERIAL0_REC_CTRL__rec_stick_par__rec_stick_par__MASK 0x00000008U
#define R_SERIAL0_REC_CTRL__rec_par__rec_par__MASK 0x00000004U
#define R_SERIAL0_REC_CTRL__rec_par_en__rec_par_en__MASK 0x00000002U
#define R_SERIAL0_REC_CTRL__rec_bitnr__rec_bitnr__MASK 0x00000001U

#define R_SERIAL0_REC_CTRL__dma_err__MAX 0x1
#define R_SERIAL0_REC_CTRL__rec_enable__MAX 0x1
#define R_SERIAL0_REC_CTRL__rts___MAX 0x1
#define R_SERIAL0_REC_CTRL__sampling__MAX 0x1
#define R_SERIAL0_REC_CTRL__rec_stick_par__MAX 0x1
#define R_SERIAL0_REC_CTRL__rec_par__MAX 0x1
#define R_SERIAL0_REC_CTRL__rec_par_en__MAX 0x1
#define R_SERIAL0_REC_CTRL__rec_bitnr__MAX 0x1

#define R_SERIAL0_REC_CTRL__dma_err__MIN 0
#define R_SERIAL0_REC_CTRL__rec_enable__MIN 0
#define R_SERIAL0_REC_CTRL__rts___MIN 0
#define R_SERIAL0_REC_CTRL__sampling__MIN 0
#define R_SERIAL0_REC_CTRL__rec_stick_par__MIN 0
#define R_SERIAL0_REC_CTRL__rec_par__MIN 0
#define R_SERIAL0_REC_CTRL__rec_par_en__MIN 0
#define R_SERIAL0_REC_CTRL__rec_bitnr__MIN 0

#define R_SERIAL0_REC_CTRL__dma_err__BITNR 7
#define R_SERIAL0_REC_CTRL__rec_enable__BITNR 6
#define R_SERIAL0_REC_CTRL__rts___BITNR 5
#define R_SERIAL0_REC_CTRL__sampling__BITNR 4
#define R_SERIAL0_REC_CTRL__rec_stick_par__BITNR 3
#define R_SERIAL0_REC_CTRL__rec_par__BITNR 2
#define R_SERIAL0_REC_CTRL__rec_par_en__BITNR 1
#define R_SERIAL0_REC_CTRL__rec_bitnr__BITNR 0

#define R_SERIAL0_REC_CTRL__dma_err__dma_err__VAL REG_VAL_ENUM
#define R_SERIAL0_REC_CTRL__rec_enable__rec_enable__VAL REG_VAL_ENUM
#define R_SERIAL0_REC_CTRL__rts___rts___VAL REG_VAL_ENUM
#define R_SERIAL0_REC_CTRL__sampling__sampling__VAL REG_VAL_ENUM
#define R_SERIAL0_REC_CTRL__rec_stick_par__rec_stick_par__VAL REG_VAL_ENUM
#define R_SERIAL0_REC_CTRL__rec_par__rec_par__VAL REG_VAL_ENUM
#define R_SERIAL0_REC_CTRL__rec_par_en__rec_par_en__VAL REG_VAL_ENUM
#define R_SERIAL0_REC_CTRL__rec_bitnr__rec_bitnr__VAL REG_VAL_ENUM

#define R_SERIAL0_REC_CTRL__dma_err__dma_err__ignore 1
#define R_SERIAL0_REC_CTRL__dma_err__dma_err__stop 0
#define R_SERIAL0_REC_CTRL__rec_enable__rec_enable__disable 0
#define R_SERIAL0_REC_CTRL__rec_enable__rec_enable__enable 1
#define R_SERIAL0_REC_CTRL__rts___rts___active 0
#define R_SERIAL0_REC_CTRL__rts___rts___inactive 1
#define R_SERIAL0_REC_CTRL__sampling__sampling__majority 1
#define R_SERIAL0_REC_CTRL__sampling__sampling__middle 0
#define R_SERIAL0_REC_CTRL__rec_stick_par__rec_stick_par__normal 0
#define R_SERIAL0_REC_CTRL__rec_stick_par__rec_stick_par__stick 1
#define R_SERIAL0_REC_CTRL__rec_par__rec_par__even 0
#define R_SERIAL0_REC_CTRL__rec_par__rec_par__odd 1
#define R_SERIAL0_REC_CTRL__rec_par_en__rec_par_en__disable 0
#define R_SERIAL0_REC_CTRL__rec_par_en__rec_par_en__enable 1
#define R_SERIAL0_REC_CTRL__rec_bitnr__rec_bitnr__rec_7bit 1
#define R_SERIAL0_REC_CTRL__rec_bitnr__rec_bitnr__rec_8bit 0

#endif

/*
 *  R_SERIAL0_REC_DATA
 *  - type:  RO
 *  - addr:  0xb0000060
 *  - group: Serial port registers
 */

#if USE_GROUP__Serial_port_registers

#define R_SERIAL0_REC_DATA__ADDR      (REG_TYPECAST_BYTE  0xb0000060)
#define R_SERIAL0_REC_DATA__SVAL      REG_SVAL_SHADOW
#define R_SERIAL0_REC_DATA__SVAL_I    REG_SVAL_I_SHADOW
#define R_SERIAL0_REC_DATA__TYPECAST  REG_TYPECAST_BYTE
#define R_SERIAL0_REC_DATA__TYPE      (REG_BYTE)
#define R_SERIAL0_REC_DATA__GET       REG_GET_RO
#define R_SERIAL0_REC_DATA__IGET      REG_IGET_RO
#define R_SERIAL0_REC_DATA__SET       REG_SET_RO
#define R_SERIAL0_REC_DATA__ISET      REG_ISET_RO
#define R_SERIAL0_REC_DATA__SET_VAL   REG_SET_VAL_RO
#define R_SERIAL0_REC_DATA__EQL       REG_EQL_RO
#define R_SERIAL0_REC_DATA__IEQL      REG_IEQL_RO
#define R_SERIAL0_REC_DATA__RD        REG_RD_RO
#define R_SERIAL0_REC_DATA__IRD       REG_IRD_RO
#define R_SERIAL0_REC_DATA__WR        REG_WR_RO
#define R_SERIAL0_REC_DATA__IWR       REG_IWR_RO

#define R_SERIAL0_REC_DATA__READ(addr) \
  (*(addr))

/* From control-file '/n/asic/projects/etrax_ng/include//hwregs.ctrl' */
#define R_SERIAL0_REC_DATA__FIRST 0
#define R_SERIAL0_REC_DATA__LAST 3
#define R_SERIAL0_REC_DATA__OFFSET 8
/* end */

#define R_SERIAL0_REC_DATA__data_in__data_in__MASK 0x000000ffU

#define R_SERIAL0_REC_DATA__data_in__MAX 0xff

#define R_SERIAL0_REC_DATA__data_in__MIN 0

#define R_SERIAL0_REC_DATA__data_in__BITNR 0

#define R_SERIAL0_REC_DATA__data_in__data_in__VAL REG_VAL_VAL


#endif

/*
 *  R_SERIAL0_STATUS
 *  - type:  RO
 *  - addr:  0xb0000061
 *  - group: Serial port registers
 */

#if USE_GROUP__Serial_port_registers

#define R_SERIAL0_STATUS__ADDR      (REG_TYPECAST_BYTE  0xb0000061)
#define R_SERIAL0_STATUS__SVAL      REG_SVAL_SHADOW
#define R_SERIAL0_STATUS__SVAL_I    REG_SVAL_I_SHADOW
#define R_SERIAL0_STATUS__TYPECAST  REG_TYPECAST_BYTE
#define R_SERIAL0_STATUS__TYPE      (REG_BYTE)
#define R_SERIAL0_STATUS__GET       REG_GET_RO
#define R_SERIAL0_STATUS__IGET      REG_IGET_RO
#define R_SERIAL0_STATUS__SET       REG_SET_RO
#define R_SERIAL0_STATUS__ISET      REG_ISET_RO
#define R_SERIAL0_STATUS__SET_VAL   REG_SET_VAL_RO
#define R_SERIAL0_STATUS__EQL       REG_EQL_RO
#define R_SERIAL0_STATUS__IEQL      REG_IEQL_RO
#define R_SERIAL0_STATUS__RD        REG_RD_RO
#define R_SERIAL0_STATUS__IRD       REG_IRD_RO
#define R_SERIAL0_STATUS__WR        REG_WR_RO
#define R_SERIAL0_STATUS__IWR       REG_IWR_RO

#define R_SERIAL0_STATUS__READ(addr) \
  (*(addr))

/* From control-file '/n/asic/projects/etrax_ng/include//hwregs.ctrl' */
#define R_SERIAL0_STATUS__FIRST 0
#define R_SERIAL0_STATUS__LAST 3
#define R_SERIAL0_STATUS__OFFSET 8
/* end */

#define R_SERIAL0_STATUS__xoff_detect__xoff_detect__MASK 0x00000080U
#define R_SERIAL0_STATUS__cts___cts___MASK 0x00000040U
#define R_SERIAL0_STATUS__tr_ready__tr_ready__MASK 0x00000020U
#define R_SERIAL0_STATUS__rxd__rxd__MASK 0x00000010U
#define R_SERIAL0_STATUS__overrun__overrun__MASK 0x00000008U
#define R_SERIAL0_STATUS__par_err__par_err__MASK 0x00000004U
#define R_SERIAL0_STATUS__framing_err__framing_err__MASK 0x00000002U
#define R_SERIAL0_STATUS__data_avail__data_avail__MASK 0x00000001U

#define R_SERIAL0_STATUS__xoff_detect__MAX 0x1
#define R_SERIAL0_STATUS__cts___MAX 0x1
#define R_SERIAL0_STATUS__tr_ready__MAX 0x1
#define R_SERIAL0_STATUS__rxd__MAX 0x1
#define R_SERIAL0_STATUS__overrun__MAX 0x1
#define R_SERIAL0_STATUS__par_err__MAX 0x1
#define R_SERIAL0_STATUS__framing_err__MAX 0x1
#define R_SERIAL0_STATUS__data_avail__MAX 0x1

#define R_SERIAL0_STATUS__xoff_detect__MIN 0
#define R_SERIAL0_STATUS__cts___MIN 0
#define R_SERIAL0_STATUS__tr_ready__MIN 0
#define R_SERIAL0_STATUS__rxd__MIN 0
#define R_SERIAL0_STATUS__overrun__MIN 0
#define R_SERIAL0_STATUS__par_err__MIN 0
#define R_SERIAL0_STATUS__framing_err__MIN 0
#define R_SERIAL0_STATUS__data_avail__MIN 0

#define R_SERIAL0_STATUS__xoff_detect__BITNR 7
#define R_SERIAL0_STATUS__cts___BITNR 6
#define R_SERIAL0_STATUS__tr_ready__BITNR 5
#define R_SERIAL0_STATUS__rxd__BITNR 4
#define R_SERIAL0_STATUS__overrun__BITNR 3
#define R_SERIAL0_STATUS__par_err__BITNR 2
#define R_SERIAL0_STATUS__framing_err__BITNR 1
#define R_SERIAL0_STATUS__data_avail__BITNR 0

#define R_SERIAL0_STATUS__xoff_detect__xoff_detect__VAL REG_VAL_ENUM
#define R_SERIAL0_STATUS__cts___cts___VAL REG_VAL_ENUM
#define R_SERIAL0_STATUS__tr_ready__tr_ready__VAL REG_VAL_ENUM
#define R_SERIAL0_STATUS__rxd__rxd__VAL REG_VAL_VAL
#define R_SERIAL0_STATUS__overrun__overrun__VAL REG_VAL_ENUM
#define R_SERIAL0_STATUS__par_err__par_err__VAL REG_VAL_ENUM
#define R_SERIAL0_STATUS__framing_err__framing_err__VAL REG_VAL_ENUM
#define R_SERIAL0_STATUS__data_avail__data_avail__VAL REG_VAL_ENUM

#define R_SERIAL0_STATUS__xoff_detect__xoff_detect__no_xoff 0
#define R_SERIAL0_STATUS__xoff_detect__xoff_detect__xoff 1
#define R_SERIAL0_STATUS__cts___cts___active 0
#define R_SERIAL0_STATUS__cts___cts___inactive 1
#define R_SERIAL0_STATUS__tr_ready__tr_ready__full 0
#define R_SERIAL0_STATUS__tr_ready__tr_ready__ready 1
#define R_SERIAL0_STATUS__overrun__overrun__no 0
#define R_SERIAL0_STATUS__overrun__overrun__yes 1
#define R_SERIAL0_STATUS__par_err__par_err__no 0
#define R_SERIAL0_STATUS__par_err__par_err__yes 1
#define R_SERIAL0_STATUS__framing_err__framing_err__no 0
#define R_SERIAL0_STATUS__framing_err__framing_err__yes 1
#define R_SERIAL0_STATUS__data_avail__data_avail__no 0
#define R_SERIAL0_STATUS__data_avail__data_avail__yes 1

#endif

/*
 *  R_SERIAL0_TR_CTRL
 *  - type:  WO
 *  - addr:  0xb0000061
 *  - group: Serial port registers
 */

#if USE_GROUP__Serial_port_registers

#define R_SERIAL0_TR_CTRL__ADDR      (REG_TYPECAST_BYTE  0xb0000061)

#ifndef REG_NO_SHADOW
#define R_SERIAL0_TR_CTRL__SADDR     (REG_STYPECAST_BYTE (reg_shadow__hwregs.R_SERIAL0_CTRL + 1))
#define R_SERIAL0_TR_CTRL__IADDR     (REG_STYPECAST_BYTE (reg_initiated__hwregs.R_SERIAL0_CTRL + 1))
#else /* REG_NO_SHADOW */
#define R_SERIAL0_TR_CTRL__SADDR     (REG_STYPECAST_BYTE (&reg_shadow__hwregs))
#define R_SERIAL0_TR_CTRL__IADDR     (REG_STYPECAST_BYTE (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_SERIAL0_TR_CTRL__STYPECAST REG_STYPECAST_BYTE
#define R_SERIAL0_TR_CTRL__SVAL      REG_SVAL_SHADOW
#define R_SERIAL0_TR_CTRL__SVAL_I    REG_SVAL_I_SHADOW
#define R_SERIAL0_TR_CTRL__TYPECAST  REG_TYPECAST_BYTE
#define R_SERIAL0_TR_CTRL__TYPE      (REG_BYTE)
#define R_SERIAL0_TR_CTRL__GET       REG_GET_WO
#define R_SERIAL0_TR_CTRL__IGET      REG_IGET_WO
#define R_SERIAL0_TR_CTRL__SET       REG_SET_WO
#define R_SERIAL0_TR_CTRL__ISET      REG_ISET_WO
#define R_SERIAL0_TR_CTRL__SET_VAL   REG_SET_VAL_WO
#define R_SERIAL0_TR_CTRL__EQL       REG_EQL_WO
#define R_SERIAL0_TR_CTRL__IEQL      REG_IEQL_WO
#define R_SERIAL0_TR_CTRL__RD        REG_RD_WO
#define R_SERIAL0_TR_CTRL__IRD       REG_IRD_WO
#define R_SERIAL0_TR_CTRL__WR        REG_WR_WO
#define R_SERIAL0_TR_CTRL__IWR       REG_IWR_WO

#define R_SERIAL0_TR_CTRL__WRITE(addr,value) \
  (*(addr) = (value))

/* From control-file '/n/asic/projects/etrax_ng/include//hwregs.ctrl' */
#define R_SERIAL0_TR_CTRL__FIRST 0
#define R_SERIAL0_TR_CTRL__IOFFSET 8
#define R_SERIAL0_TR_CTRL__LAST 3
#define R_SERIAL0_TR_CTRL__OFFSET 8
#define R_SERIAL0_TR_CTRL__SOFFSET 8
/* end */

#define R_SERIAL0_TR_CTRL__txd__txd__MASK 0x00000080U
#define R_SERIAL0_TR_CTRL__tr_enable__tr_enable__MASK 0x00000040U
#define R_SERIAL0_TR_CTRL__auto_cts__auto_cts__MASK 0x00000020U
#define R_SERIAL0_TR_CTRL__stop_bits__stop_bits__MASK 0x00000010U
#define R_SERIAL0_TR_CTRL__tr_stick_par__tr_stick_par__MASK 0x00000008U
#define R_SERIAL0_TR_CTRL__tr_par__tr_par__MASK 0x00000004U
#define R_SERIAL0_TR_CTRL__tr_par_en__tr_par_en__MASK 0x00000002U
#define R_SERIAL0_TR_CTRL__tr_bitnr__tr_bitnr__MASK 0x00000001U

#define R_SERIAL0_TR_CTRL__txd__MAX 0x1
#define R_SERIAL0_TR_CTRL__tr_enable__MAX 0x1
#define R_SERIAL0_TR_CTRL__auto_cts__MAX 0x1
#define R_SERIAL0_TR_CTRL__stop_bits__MAX 0x1
#define R_SERIAL0_TR_CTRL__tr_stick_par__MAX 0x1
#define R_SERIAL0_TR_CTRL__tr_par__MAX 0x1
#define R_SERIAL0_TR_CTRL__tr_par_en__MAX 0x1
#define R_SERIAL0_TR_CTRL__tr_bitnr__MAX 0x1

#define R_SERIAL0_TR_CTRL__txd__MIN 0
#define R_SERIAL0_TR_CTRL__tr_enable__MIN 0
#define R_SERIAL0_TR_CTRL__auto_cts__MIN 0
#define R_SERIAL0_TR_CTRL__stop_bits__MIN 0
#define R_SERIAL0_TR_CTRL__tr_stick_par__MIN 0
#define R_SERIAL0_TR_CTRL__tr_par__MIN 0
#define R_SERIAL0_TR_CTRL__tr_par_en__MIN 0
#define R_SERIAL0_TR_CTRL__tr_bitnr__MIN 0

#define R_SERIAL0_TR_CTRL__txd__BITNR 7
#define R_SERIAL0_TR_CTRL__tr_enable__BITNR 6
#define R_SERIAL0_TR_CTRL__auto_cts__BITNR 5
#define R_SERIAL0_TR_CTRL__stop_bits__BITNR 4
#define R_SERIAL0_TR_CTRL__tr_stick_par__BITNR 3
#define R_SERIAL0_TR_CTRL__tr_par__BITNR 2
#define R_SERIAL0_TR_CTRL__tr_par_en__BITNR 1
#define R_SERIAL0_TR_CTRL__tr_bitnr__BITNR 0

#define R_SERIAL0_TR_CTRL__txd__txd__VAL REG_VAL_VAL
#define R_SERIAL0_TR_CTRL__tr_enable__tr_enable__VAL REG_VAL_ENUM
#define R_SERIAL0_TR_CTRL__auto_cts__auto_cts__VAL REG_VAL_ENUM
#define R_SERIAL0_TR_CTRL__stop_bits__stop_bits__VAL REG_VAL_ENUM
#define R_SERIAL0_TR_CTRL__tr_stick_par__tr_stick_par__VAL REG_VAL_ENUM
#define R_SERIAL0_TR_CTRL__tr_par__tr_par__VAL REG_VAL_ENUM
#define R_SERIAL0_TR_CTRL__tr_par_en__tr_par_en__VAL REG_VAL_ENUM
#define R_SERIAL0_TR_CTRL__tr_bitnr__tr_bitnr__VAL REG_VAL_ENUM

#define R_SERIAL0_TR_CTRL__tr_enable__tr_enable__disable 0
#define R_SERIAL0_TR_CTRL__tr_enable__tr_enable__enable 1
#define R_SERIAL0_TR_CTRL__auto_cts__auto_cts__active 1
#define R_SERIAL0_TR_CTRL__auto_cts__auto_cts__disabled 0
#define R_SERIAL0_TR_CTRL__stop_bits__stop_bits__one_bit 0
#define R_SERIAL0_TR_CTRL__stop_bits__stop_bits__two_bits 1
#define R_SERIAL0_TR_CTRL__tr_stick_par__tr_stick_par__normal 0
#define R_SERIAL0_TR_CTRL__tr_stick_par__tr_stick_par__stick 1
#define R_SERIAL0_TR_CTRL__tr_par__tr_par__even 0
#define R_SERIAL0_TR_CTRL__tr_par__tr_par__odd 1
#define R_SERIAL0_TR_CTRL__tr_par_en__tr_par_en__disable 0
#define R_SERIAL0_TR_CTRL__tr_par_en__tr_par_en__enable 1
#define R_SERIAL0_TR_CTRL__tr_bitnr__tr_bitnr__tr_7bit 1
#define R_SERIAL0_TR_CTRL__tr_bitnr__tr_bitnr__tr_8bit 0

#endif

/*
 *  R_SERIAL0_TR_DATA
 *  - type:  WO
 *  - addr:  0xb0000060
 *  - group: Serial port registers
 */

#if USE_GROUP__Serial_port_registers

#define R_SERIAL0_TR_DATA__ADDR      (REG_TYPECAST_BYTE  0xb0000060)

#ifndef REG_NO_SHADOW
#define R_SERIAL0_TR_DATA__SADDR     (REG_STYPECAST_BYTE (reg_shadow__hwregs.R_SERIAL0_CTRL + 0))
#define R_SERIAL0_TR_DATA__IADDR     (REG_STYPECAST_BYTE (reg_initiated__hwregs.R_SERIAL0_CTRL + 0))
#else /* REG_NO_SHADOW */
#define R_SERIAL0_TR_DATA__SADDR     (REG_STYPECAST_BYTE (&reg_shadow__hwregs))
#define R_SERIAL0_TR_DATA__IADDR     (REG_STYPECAST_BYTE (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_SERIAL0_TR_DATA__STYPECAST REG_STYPECAST_BYTE
#define R_SERIAL0_TR_DATA__SVAL      REG_SVAL_SHADOW
#define R_SERIAL0_TR_DATA__SVAL_I    REG_SVAL_I_SHADOW
#define R_SERIAL0_TR_DATA__TYPECAST  REG_TYPECAST_BYTE
#define R_SERIAL0_TR_DATA__TYPE      (REG_BYTE)
#define R_SERIAL0_TR_DATA__GET       REG_GET_WO
#define R_SERIAL0_TR_DATA__IGET      REG_IGET_WO
#define R_SERIAL0_TR_DATA__SET       REG_SET_WO
#define R_SERIAL0_TR_DATA__ISET      REG_ISET_WO
#define R_SERIAL0_TR_DATA__SET_VAL   REG_SET_VAL_WO
#define R_SERIAL0_TR_DATA__EQL       REG_EQL_WO
#define R_SERIAL0_TR_DATA__IEQL      REG_IEQL_WO
#define R_SERIAL0_TR_DATA__RD        REG_RD_WO
#define R_SERIAL0_TR_DATA__IRD       REG_IRD_WO
#define R_SERIAL0_TR_DATA__WR        REG_WR_WO
#define R_SERIAL0_TR_DATA__IWR       REG_IWR_WO

#define R_SERIAL0_TR_DATA__WRITE(addr,value) \
  (*(addr) = (value))

/* From control-file '/n/asic/projects/etrax_ng/include//hwregs.ctrl' */
#define R_SERIAL0_TR_DATA__FIRST 0
#define R_SERIAL0_TR_DATA__IOFFSET 8
#define R_SERIAL0_TR_DATA__LAST 3
#define R_SERIAL0_TR_DATA__OFFSET 8
#define R_SERIAL0_TR_DATA__SOFFSET 8
/* end */

#define R_SERIAL0_TR_DATA__data_out__data_out__MASK 0x000000ffU

#define R_SERIAL0_TR_DATA__data_out__MAX 0xff

#define R_SERIAL0_TR_DATA__data_out__MIN 0

#define R_SERIAL0_TR_DATA__data_out__BITNR 0

#define R_SERIAL0_TR_DATA__data_out__data_out__VAL REG_VAL_VAL


#endif

/*
 *  R_SERIAL0_XOFF
 *  - type:  WO
 *  - addr:  0xb0000064
 *  - group: Serial port registers
 */

#if USE_GROUP__Serial_port_registers

#define R_SERIAL0_XOFF__ADDR      (REG_TYPECAST_UDWORD  0xb0000064)

#ifndef REG_NO_SHADOW
#define R_SERIAL0_XOFF__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_SERIAL0_XOFF + 0))
#define R_SERIAL0_XOFF__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_SERIAL0_XOFF + 0))
#else /* REG_NO_SHADOW */
#define R_SERIAL0_XOFF__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_SERIAL0_XOFF__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_SERIAL0_XOFF__STYPECAST REG_STYPECAST_UDWORD
#define R_SERIAL0_XOFF__SVAL      REG_SVAL_SHADOW
#define R_SERIAL0_XOFF__SVAL_I    REG_SVAL_I_SHADOW
#define R_SERIAL0_XOFF__TYPECAST  REG_TYPECAST_UDWORD
#define R_SERIAL0_XOFF__TYPE      (REG_UDWORD)
#define R_SERIAL0_XOFF__GET       REG_GET_WO
#define R_SERIAL0_XOFF__IGET      REG_IGET_WO
#define R_SERIAL0_XOFF__SET       REG_SET_WO
#define R_SERIAL0_XOFF__ISET      REG_ISET_WO
#define R_SERIAL0_XOFF__SET_VAL   REG_SET_VAL_WO
#define R_SERIAL0_XOFF__EQL       REG_EQL_WO
#define R_SERIAL0_XOFF__IEQL      REG_IEQL_WO
#define R_SERIAL0_XOFF__RD        REG_RD_WO
#define R_SERIAL0_XOFF__IRD       REG_IRD_WO
#define R_SERIAL0_XOFF__WR        REG_WR_WO
#define R_SERIAL0_XOFF__IWR       REG_IWR_WO

#define R_SERIAL0_XOFF__WRITE(addr,value) \
  (*(addr) = (value))

/* From control-file '/n/asic/projects/etrax_ng/include//hwregs.ctrl' */
#define R_SERIAL0_XOFF__FIRST 0
#define R_SERIAL0_XOFF__IOFFSET 8
#define R_SERIAL0_XOFF__LAST 3
#define R_SERIAL0_XOFF__OFFSET 8
#define R_SERIAL0_XOFF__SOFFSET 8
/* end */

#define R_SERIAL0_XOFF__tx_stop__tx_stop__MASK 0x00000200U
#define R_SERIAL0_XOFF__auto_xoff__auto_xoff__MASK 0x00000100U
#define R_SERIAL0_XOFF__xoff_char__xoff_char__MASK 0x000000ffU

#define R_SERIAL0_XOFF__tx_stop__MAX 0x1
#define R_SERIAL0_XOFF__auto_xoff__MAX 0x1
#define R_SERIAL0_XOFF__xoff_char__MAX 0xff

#define R_SERIAL0_XOFF__tx_stop__MIN 0
#define R_SERIAL0_XOFF__auto_xoff__MIN 0
#define R_SERIAL0_XOFF__xoff_char__MIN 0

#define R_SERIAL0_XOFF__tx_stop__BITNR 9
#define R_SERIAL0_XOFF__auto_xoff__BITNR 8
#define R_SERIAL0_XOFF__xoff_char__BITNR 0

#define R_SERIAL0_XOFF__tx_stop__tx_stop__VAL REG_VAL_ENUM
#define R_SERIAL0_XOFF__auto_xoff__auto_xoff__VAL REG_VAL_ENUM
#define R_SERIAL0_XOFF__xoff_char__xoff_char__VAL REG_VAL_VAL

#define R_SERIAL0_XOFF__tx_stop__tx_stop__enable 0
#define R_SERIAL0_XOFF__tx_stop__tx_stop__stop 1
#define R_SERIAL0_XOFF__auto_xoff__auto_xoff__disable 0
#define R_SERIAL0_XOFF__auto_xoff__auto_xoff__enable 1

#endif

/*
 *  R_SERIAL1_BAUD
 *  - type:  WO
 *  - addr:  0xb000006b
 *  - group: Serial port registers
 */

#if USE_GROUP__Serial_port_registers

#define R_SERIAL1_BAUD__ADDR      (REG_TYPECAST_BYTE  0xb000006b)

#ifndef REG_NO_SHADOW
#define R_SERIAL1_BAUD__SADDR     (REG_STYPECAST_BYTE (reg_shadow__hwregs.R_SERIAL1_CTRL + 3))
#define R_SERIAL1_BAUD__IADDR     (REG_STYPECAST_BYTE (reg_initiated__hwregs.R_SERIAL1_CTRL + 3))
#else /* REG_NO_SHADOW */
#define R_SERIAL1_BAUD__SADDR     (REG_STYPECAST_BYTE (&reg_shadow__hwregs))
#define R_SERIAL1_BAUD__IADDR     (REG_STYPECAST_BYTE (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_SERIAL1_BAUD__STYPECAST REG_STYPECAST_BYTE
#define R_SERIAL1_BAUD__SVAL      REG_SVAL_SHADOW
#define R_SERIAL1_BAUD__SVAL_I    REG_SVAL_I_SHADOW
#define R_SERIAL1_BAUD__TYPECAST  REG_TYPECAST_BYTE
#define R_SERIAL1_BAUD__TYPE      (REG_BYTE)
#define R_SERIAL1_BAUD__GET       REG_GET_WO
#define R_SERIAL1_BAUD__IGET      REG_IGET_WO
#define R_SERIAL1_BAUD__SET       REG_SET_WO
#define R_SERIAL1_BAUD__ISET      REG_ISET_WO
#define R_SERIAL1_BAUD__SET_VAL   REG_SET_VAL_WO
#define R_SERIAL1_BAUD__EQL       REG_EQL_WO
#define R_SERIAL1_BAUD__IEQL      REG_IEQL_WO
#define R_SERIAL1_BAUD__RD        REG_RD_WO
#define R_SERIAL1_BAUD__IRD       REG_IRD_WO
#define R_SERIAL1_BAUD__WR        REG_WR_WO
#define R_SERIAL1_BAUD__IWR       REG_IWR_WO

#define R_SERIAL1_BAUD__WRITE(addr,value) \
  (*(addr) = (value))

#define R_SERIAL1_BAUD__tr_baud__tr_baud__MASK 0x000000f0U
#define R_SERIAL1_BAUD__rec_baud__rec_baud__MASK 0x0000000fU

#define R_SERIAL1_BAUD__tr_baud__MAX 0xf
#define R_SERIAL1_BAUD__rec_baud__MAX 0xf

#define R_SERIAL1_BAUD__tr_baud__MIN 0
#define R_SERIAL1_BAUD__rec_baud__MIN 0

#define R_SERIAL1_BAUD__tr_baud__BITNR 4
#define R_SERIAL1_BAUD__rec_baud__BITNR 0

#define R_SERIAL1_BAUD__tr_baud__tr_baud__VAL REG_VAL_ENUM
#define R_SERIAL1_BAUD__rec_baud__rec_baud__VAL REG_VAL_ENUM

#define R_SERIAL1_BAUD__tr_baud__tr_baud__c115k2Hz 9
#define R_SERIAL1_BAUD__tr_baud__tr_baud__c1200Hz 2
#define R_SERIAL1_BAUD__tr_baud__tr_baud__c1843k2Hz 13
#define R_SERIAL1_BAUD__tr_baud__tr_baud__c19k2Hz 6
#define R_SERIAL1_BAUD__tr_baud__tr_baud__c230k4Hz 10
#define R_SERIAL1_BAUD__tr_baud__tr_baud__c2400Hz 3
#define R_SERIAL1_BAUD__tr_baud__tr_baud__c300Hz 0
#define R_SERIAL1_BAUD__tr_baud__tr_baud__c38k4Hz 7
#define R_SERIAL1_BAUD__tr_baud__tr_baud__c460k8Hz 11
#define R_SERIAL1_BAUD__tr_baud__tr_baud__c4800Hz 4
#define R_SERIAL1_BAUD__tr_baud__tr_baud__c57k6Hz 8
#define R_SERIAL1_BAUD__tr_baud__tr_baud__c600Hz 1
#define R_SERIAL1_BAUD__tr_baud__tr_baud__c6250kHz 14
#define R_SERIAL1_BAUD__tr_baud__tr_baud__c921k6Hz 12
#define R_SERIAL1_BAUD__tr_baud__tr_baud__c9600Hz 5
#define R_SERIAL1_BAUD__rec_baud__rec_baud__c115k2Hz 9
#define R_SERIAL1_BAUD__rec_baud__rec_baud__c1200Hz 2
#define R_SERIAL1_BAUD__rec_baud__rec_baud__c1843k2Hz 13
#define R_SERIAL1_BAUD__rec_baud__rec_baud__c19k2Hz 6
#define R_SERIAL1_BAUD__rec_baud__rec_baud__c230k4Hz 10
#define R_SERIAL1_BAUD__rec_baud__rec_baud__c2400Hz 3
#define R_SERIAL1_BAUD__rec_baud__rec_baud__c300Hz 0
#define R_SERIAL1_BAUD__rec_baud__rec_baud__c38k4Hz 7
#define R_SERIAL1_BAUD__rec_baud__rec_baud__c460k8Hz 11
#define R_SERIAL1_BAUD__rec_baud__rec_baud__c4800Hz 4
#define R_SERIAL1_BAUD__rec_baud__rec_baud__c57k6Hz 8
#define R_SERIAL1_BAUD__rec_baud__rec_baud__c600Hz 1
#define R_SERIAL1_BAUD__rec_baud__rec_baud__c6250kHz 14
#define R_SERIAL1_BAUD__rec_baud__rec_baud__c921k6Hz 12
#define R_SERIAL1_BAUD__rec_baud__rec_baud__c9600Hz 5

#endif

/*
 *  R_SERIAL1_CTRL
 *  - type:  WO
 *  - addr:  0xb0000068
 *  - group: Serial port registers
 */

#if USE_GROUP__Serial_port_registers

#define R_SERIAL1_CTRL__ADDR      (REG_TYPECAST_UDWORD  0xb0000068)

#ifndef REG_NO_SHADOW
#define R_SERIAL1_CTRL__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_SERIAL1_CTRL + 0))
#define R_SERIAL1_CTRL__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_SERIAL1_CTRL + 0))
#else /* REG_NO_SHADOW */
#define R_SERIAL1_CTRL__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_SERIAL1_CTRL__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_SERIAL1_CTRL__STYPECAST REG_STYPECAST_UDWORD
#define R_SERIAL1_CTRL__SVAL      REG_SVAL_SHADOW
#define R_SERIAL1_CTRL__SVAL_I    REG_SVAL_I_SHADOW
#define R_SERIAL1_CTRL__TYPECAST  REG_TYPECAST_UDWORD
#define R_SERIAL1_CTRL__TYPE      (REG_UDWORD)
#define R_SERIAL1_CTRL__GET       REG_GET_WO
#define R_SERIAL1_CTRL__IGET      REG_IGET_WO
#define R_SERIAL1_CTRL__SET       REG_SET_WO
#define R_SERIAL1_CTRL__ISET      REG_ISET_WO
#define R_SERIAL1_CTRL__SET_VAL   REG_SET_VAL_WO
#define R_SERIAL1_CTRL__EQL       REG_EQL_WO
#define R_SERIAL1_CTRL__IEQL      REG_IEQL_WO
#define R_SERIAL1_CTRL__RD        REG_RD_WO
#define R_SERIAL1_CTRL__IRD       REG_IRD_WO
#define R_SERIAL1_CTRL__WR        REG_WR_WO
#define R_SERIAL1_CTRL__IWR       REG_IWR_WO

#define R_SERIAL1_CTRL__WRITE(addr,value) \
  (*(addr) = (value))

#define R_SERIAL1_CTRL__tr_baud__tr_baud__MASK 0xf0000000U
#define R_SERIAL1_CTRL__rec_baud__rec_baud__MASK 0x0f000000U
#define R_SERIAL1_CTRL__dma_err__dma_err__MASK 0x00800000U
#define R_SERIAL1_CTRL__rec_enable__rec_enable__MASK 0x00400000U
#define R_SERIAL1_CTRL__rts___rts___MASK 0x00200000U
#define R_SERIAL1_CTRL__sampling__sampling__MASK 0x00100000U
#define R_SERIAL1_CTRL__rec_stick_par__rec_stick_par__MASK 0x00080000U
#define R_SERIAL1_CTRL__rec_par__rec_par__MASK 0x00040000U
#define R_SERIAL1_CTRL__rec_par_en__rec_par_en__MASK 0x00020000U
#define R_SERIAL1_CTRL__rec_bitnr__rec_bitnr__MASK 0x00010000U
#define R_SERIAL1_CTRL__txd__txd__MASK 0x00008000U
#define R_SERIAL1_CTRL__tr_enable__tr_enable__MASK 0x00004000U
#define R_SERIAL1_CTRL__auto_cts__auto_cts__MASK 0x00002000U
#define R_SERIAL1_CTRL__stop_bits__stop_bits__MASK 0x00001000U
#define R_SERIAL1_CTRL__tr_stick_par__tr_stick_par__MASK 0x00000800U
#define R_SERIAL1_CTRL__tr_par__tr_par__MASK 0x00000400U
#define R_SERIAL1_CTRL__tr_par_en__tr_par_en__MASK 0x00000200U
#define R_SERIAL1_CTRL__tr_bitnr__tr_bitnr__MASK 0x00000100U
#define R_SERIAL1_CTRL__data_out__data_out__MASK 0x000000ffU

#define R_SERIAL1_CTRL__tr_baud__MAX 0xf
#define R_SERIAL1_CTRL__rec_baud__MAX 0xf
#define R_SERIAL1_CTRL__dma_err__MAX 0x1
#define R_SERIAL1_CTRL__rec_enable__MAX 0x1
#define R_SERIAL1_CTRL__rts___MAX 0x1
#define R_SERIAL1_CTRL__sampling__MAX 0x1
#define R_SERIAL1_CTRL__rec_stick_par__MAX 0x1
#define R_SERIAL1_CTRL__rec_par__MAX 0x1
#define R_SERIAL1_CTRL__rec_par_en__MAX 0x1
#define R_SERIAL1_CTRL__rec_bitnr__MAX 0x1
#define R_SERIAL1_CTRL__txd__MAX 0x1
#define R_SERIAL1_CTRL__tr_enable__MAX 0x1
#define R_SERIAL1_CTRL__auto_cts__MAX 0x1
#define R_SERIAL1_CTRL__stop_bits__MAX 0x1
#define R_SERIAL1_CTRL__tr_stick_par__MAX 0x1
#define R_SERIAL1_CTRL__tr_par__MAX 0x1
#define R_SERIAL1_CTRL__tr_par_en__MAX 0x1
#define R_SERIAL1_CTRL__tr_bitnr__MAX 0x1
#define R_SERIAL1_CTRL__data_out__MAX 0xff

#define R_SERIAL1_CTRL__tr_baud__MIN 0
#define R_SERIAL1_CTRL__rec_baud__MIN 0
#define R_SERIAL1_CTRL__dma_err__MIN 0
#define R_SERIAL1_CTRL__rec_enable__MIN 0
#define R_SERIAL1_CTRL__rts___MIN 0
#define R_SERIAL1_CTRL__sampling__MIN 0
#define R_SERIAL1_CTRL__rec_stick_par__MIN 0
#define R_SERIAL1_CTRL__rec_par__MIN 0
#define R_SERIAL1_CTRL__rec_par_en__MIN 0
#define R_SERIAL1_CTRL__rec_bitnr__MIN 0
#define R_SERIAL1_CTRL__txd__MIN 0
#define R_SERIAL1_CTRL__tr_enable__MIN 0
#define R_SERIAL1_CTRL__auto_cts__MIN 0
#define R_SERIAL1_CTRL__stop_bits__MIN 0
#define R_SERIAL1_CTRL__tr_stick_par__MIN 0
#define R_SERIAL1_CTRL__tr_par__MIN 0
#define R_SERIAL1_CTRL__tr_par_en__MIN 0
#define R_SERIAL1_CTRL__tr_bitnr__MIN 0
#define R_SERIAL1_CTRL__data_out__MIN 0

#define R_SERIAL1_CTRL__tr_baud__BITNR 28
#define R_SERIAL1_CTRL__rec_baud__BITNR 24
#define R_SERIAL1_CTRL__dma_err__BITNR 23
#define R_SERIAL1_CTRL__rec_enable__BITNR 22
#define R_SERIAL1_CTRL__rts___BITNR 21
#define R_SERIAL1_CTRL__sampling__BITNR 20
#define R_SERIAL1_CTRL__rec_stick_par__BITNR 19
#define R_SERIAL1_CTRL__rec_par__BITNR 18
#define R_SERIAL1_CTRL__rec_par_en__BITNR 17
#define R_SERIAL1_CTRL__rec_bitnr__BITNR 16
#define R_SERIAL1_CTRL__txd__BITNR 15
#define R_SERIAL1_CTRL__tr_enable__BITNR 14
#define R_SERIAL1_CTRL__auto_cts__BITNR 13
#define R_SERIAL1_CTRL__stop_bits__BITNR 12
#define R_SERIAL1_CTRL__tr_stick_par__BITNR 11
#define R_SERIAL1_CTRL__tr_par__BITNR 10
#define R_SERIAL1_CTRL__tr_par_en__BITNR 9
#define R_SERIAL1_CTRL__tr_bitnr__BITNR 8
#define R_SERIAL1_CTRL__data_out__BITNR 0

#define R_SERIAL1_CTRL__tr_baud__tr_baud__VAL REG_VAL_ENUM
#define R_SERIAL1_CTRL__rec_baud__rec_baud__VAL REG_VAL_ENUM
#define R_SERIAL1_CTRL__dma_err__dma_err__VAL REG_VAL_ENUM
#define R_SERIAL1_CTRL__rec_enable__rec_enable__VAL REG_VAL_ENUM
#define R_SERIAL1_CTRL__rts___rts___VAL REG_VAL_ENUM
#define R_SERIAL1_CTRL__sampling__sampling__VAL REG_VAL_ENUM
#define R_SERIAL1_CTRL__rec_stick_par__rec_stick_par__VAL REG_VAL_ENUM
#define R_SERIAL1_CTRL__rec_par__rec_par__VAL REG_VAL_ENUM
#define R_SERIAL1_CTRL__rec_par_en__rec_par_en__VAL REG_VAL_ENUM
#define R_SERIAL1_CTRL__rec_bitnr__rec_bitnr__VAL REG_VAL_ENUM
#define R_SERIAL1_CTRL__txd__txd__VAL REG_VAL_VAL
#define R_SERIAL1_CTRL__tr_enable__tr_enable__VAL REG_VAL_ENUM
#define R_SERIAL1_CTRL__auto_cts__auto_cts__VAL REG_VAL_ENUM
#define R_SERIAL1_CTRL__stop_bits__stop_bits__VAL REG_VAL_ENUM
#define R_SERIAL1_CTRL__tr_stick_par__tr_stick_par__VAL REG_VAL_ENUM
#define R_SERIAL1_CTRL__tr_par__tr_par__VAL REG_VAL_ENUM
#define R_SERIAL1_CTRL__tr_par_en__tr_par_en__VAL REG_VAL_ENUM
#define R_SERIAL1_CTRL__tr_bitnr__tr_bitnr__VAL REG_VAL_ENUM
#define R_SERIAL1_CTRL__data_out__data_out__VAL REG_VAL_VAL

#define R_SERIAL1_CTRL__tr_baud__tr_baud__c115k2Hz 9
#define R_SERIAL1_CTRL__tr_baud__tr_baud__c1200Hz 2
#define R_SERIAL1_CTRL__tr_baud__tr_baud__c1843k2Hz 13
#define R_SERIAL1_CTRL__tr_baud__tr_baud__c19k2Hz 6
#define R_SERIAL1_CTRL__tr_baud__tr_baud__c230k4Hz 10
#define R_SERIAL1_CTRL__tr_baud__tr_baud__c2400Hz 3
#define R_SERIAL1_CTRL__tr_baud__tr_baud__c300Hz 0
#define R_SERIAL1_CTRL__tr_baud__tr_baud__c38k4Hz 7
#define R_SERIAL1_CTRL__tr_baud__tr_baud__c460k8Hz 11
#define R_SERIAL1_CTRL__tr_baud__tr_baud__c4800Hz 4
#define R_SERIAL1_CTRL__tr_baud__tr_baud__c57k6Hz 8
#define R_SERIAL1_CTRL__tr_baud__tr_baud__c600Hz 1
#define R_SERIAL1_CTRL__tr_baud__tr_baud__c6250kHz 14
#define R_SERIAL1_CTRL__tr_baud__tr_baud__c921k6Hz 12
#define R_SERIAL1_CTRL__tr_baud__tr_baud__c9600Hz 5
#define R_SERIAL1_CTRL__rec_baud__rec_baud__c115k2Hz 9
#define R_SERIAL1_CTRL__rec_baud__rec_baud__c1200Hz 2
#define R_SERIAL1_CTRL__rec_baud__rec_baud__c1843k2Hz 13
#define R_SERIAL1_CTRL__rec_baud__rec_baud__c19k2Hz 6
#define R_SERIAL1_CTRL__rec_baud__rec_baud__c230k4Hz 10
#define R_SERIAL1_CTRL__rec_baud__rec_baud__c2400Hz 3
#define R_SERIAL1_CTRL__rec_baud__rec_baud__c300Hz 0
#define R_SERIAL1_CTRL__rec_baud__rec_baud__c38k4Hz 7
#define R_SERIAL1_CTRL__rec_baud__rec_baud__c460k8Hz 11
#define R_SERIAL1_CTRL__rec_baud__rec_baud__c4800Hz 4
#define R_SERIAL1_CTRL__rec_baud__rec_baud__c57k6Hz 8
#define R_SERIAL1_CTRL__rec_baud__rec_baud__c600Hz 1
#define R_SERIAL1_CTRL__rec_baud__rec_baud__c6250kHz 14
#define R_SERIAL1_CTRL__rec_baud__rec_baud__c921k6Hz 12
#define R_SERIAL1_CTRL__rec_baud__rec_baud__c9600Hz 5
#define R_SERIAL1_CTRL__dma_err__dma_err__ignore 1
#define R_SERIAL1_CTRL__dma_err__dma_err__stop 0
#define R_SERIAL1_CTRL__rec_enable__rec_enable__disable 0
#define R_SERIAL1_CTRL__rec_enable__rec_enable__enable 1
#define R_SERIAL1_CTRL__rts___rts___active 0
#define R_SERIAL1_CTRL__rts___rts___inactive 1
#define R_SERIAL1_CTRL__sampling__sampling__majority 1
#define R_SERIAL1_CTRL__sampling__sampling__middle 0
#define R_SERIAL1_CTRL__rec_stick_par__rec_stick_par__normal 0
#define R_SERIAL1_CTRL__rec_stick_par__rec_stick_par__stick 1
#define R_SERIAL1_CTRL__rec_par__rec_par__even 0
#define R_SERIAL1_CTRL__rec_par__rec_par__odd 1
#define R_SERIAL1_CTRL__rec_par_en__rec_par_en__disable 0
#define R_SERIAL1_CTRL__rec_par_en__rec_par_en__enable 1
#define R_SERIAL1_CTRL__rec_bitnr__rec_bitnr__rec_7bit 1
#define R_SERIAL1_CTRL__rec_bitnr__rec_bitnr__rec_8bit 0
#define R_SERIAL1_CTRL__tr_enable__tr_enable__disable 0
#define R_SERIAL1_CTRL__tr_enable__tr_enable__enable 1
#define R_SERIAL1_CTRL__auto_cts__auto_cts__active 1
#define R_SERIAL1_CTRL__auto_cts__auto_cts__disabled 0
#define R_SERIAL1_CTRL__stop_bits__stop_bits__one_bit 0
#define R_SERIAL1_CTRL__stop_bits__stop_bits__two_bits 1
#define R_SERIAL1_CTRL__tr_stick_par__tr_stick_par__normal 0
#define R_SERIAL1_CTRL__tr_stick_par__tr_stick_par__stick 1
#define R_SERIAL1_CTRL__tr_par__tr_par__even 0
#define R_SERIAL1_CTRL__tr_par__tr_par__odd 1
#define R_SERIAL1_CTRL__tr_par_en__tr_par_en__disable 0
#define R_SERIAL1_CTRL__tr_par_en__tr_par_en__enable 1
#define R_SERIAL1_CTRL__tr_bitnr__tr_bitnr__tr_7bit 1
#define R_SERIAL1_CTRL__tr_bitnr__tr_bitnr__tr_8bit 0

#endif

/*
 *  R_SERIAL1_READ
 *  - type:  RO
 *  - addr:  0xb0000068
 *  - group: Serial port registers
 */

#if USE_GROUP__Serial_port_registers

#define R_SERIAL1_READ__ADDR      (REG_TYPECAST_UDWORD  0xb0000068)
#define R_SERIAL1_READ__SVAL      REG_SVAL_SHADOW
#define R_SERIAL1_READ__SVAL_I    REG_SVAL_I_SHADOW
#define R_SERIAL1_READ__TYPECAST  REG_TYPECAST_UDWORD
#define R_SERIAL1_READ__TYPE      (REG_UDWORD)
#define R_SERIAL1_READ__GET       REG_GET_RO
#define R_SERIAL1_READ__IGET      REG_IGET_RO
#define R_SERIAL1_READ__SET       REG_SET_RO
#define R_SERIAL1_READ__ISET      REG_ISET_RO
#define R_SERIAL1_READ__SET_VAL   REG_SET_VAL_RO
#define R_SERIAL1_READ__EQL       REG_EQL_RO
#define R_SERIAL1_READ__IEQL      REG_IEQL_RO
#define R_SERIAL1_READ__RD        REG_RD_RO
#define R_SERIAL1_READ__IRD       REG_IRD_RO
#define R_SERIAL1_READ__WR        REG_WR_RO
#define R_SERIAL1_READ__IWR       REG_IWR_RO

#define R_SERIAL1_READ__READ(addr) \
  (*(addr))

#define R_SERIAL1_READ__xoff_detect__xoff_detect__MASK 0x00008000U
#define R_SERIAL1_READ__cts___cts___MASK 0x00004000U
#define R_SERIAL1_READ__tr_ready__tr_ready__MASK 0x00002000U
#define R_SERIAL1_READ__rxd__rxd__MASK 0x00001000U
#define R_SERIAL1_READ__overrun__overrun__MASK 0x00000800U
#define R_SERIAL1_READ__par_err__par_err__MASK 0x00000400U
#define R_SERIAL1_READ__framing_err__framing_err__MASK 0x00000200U
#define R_SERIAL1_READ__data_avail__data_avail__MASK 0x00000100U
#define R_SERIAL1_READ__data_in__data_in__MASK 0x000000ffU

#define R_SERIAL1_READ__xoff_detect__MAX 0x1
#define R_SERIAL1_READ__cts___MAX 0x1
#define R_SERIAL1_READ__tr_ready__MAX 0x1
#define R_SERIAL1_READ__rxd__MAX 0x1
#define R_SERIAL1_READ__overrun__MAX 0x1
#define R_SERIAL1_READ__par_err__MAX 0x1
#define R_SERIAL1_READ__framing_err__MAX 0x1
#define R_SERIAL1_READ__data_avail__MAX 0x1
#define R_SERIAL1_READ__data_in__MAX 0xff

#define R_SERIAL1_READ__xoff_detect__MIN 0
#define R_SERIAL1_READ__cts___MIN 0
#define R_SERIAL1_READ__tr_ready__MIN 0
#define R_SERIAL1_READ__rxd__MIN 0
#define R_SERIAL1_READ__overrun__MIN 0
#define R_SERIAL1_READ__par_err__MIN 0
#define R_SERIAL1_READ__framing_err__MIN 0
#define R_SERIAL1_READ__data_avail__MIN 0
#define R_SERIAL1_READ__data_in__MIN 0

#define R_SERIAL1_READ__xoff_detect__BITNR 15
#define R_SERIAL1_READ__cts___BITNR 14
#define R_SERIAL1_READ__tr_ready__BITNR 13
#define R_SERIAL1_READ__rxd__BITNR 12
#define R_SERIAL1_READ__overrun__BITNR 11
#define R_SERIAL1_READ__par_err__BITNR 10
#define R_SERIAL1_READ__framing_err__BITNR 9
#define R_SERIAL1_READ__data_avail__BITNR 8
#define R_SERIAL1_READ__data_in__BITNR 0

#define R_SERIAL1_READ__xoff_detect__xoff_detect__VAL REG_VAL_ENUM
#define R_SERIAL1_READ__cts___cts___VAL REG_VAL_ENUM
#define R_SERIAL1_READ__tr_ready__tr_ready__VAL REG_VAL_ENUM
#define R_SERIAL1_READ__rxd__rxd__VAL REG_VAL_VAL
#define R_SERIAL1_READ__overrun__overrun__VAL REG_VAL_ENUM
#define R_SERIAL1_READ__par_err__par_err__VAL REG_VAL_ENUM
#define R_SERIAL1_READ__framing_err__framing_err__VAL REG_VAL_ENUM
#define R_SERIAL1_READ__data_avail__data_avail__VAL REG_VAL_ENUM
#define R_SERIAL1_READ__data_in__data_in__VAL REG_VAL_VAL

#define R_SERIAL1_READ__xoff_detect__xoff_detect__no_xoff 0
#define R_SERIAL1_READ__xoff_detect__xoff_detect__xoff 1
#define R_SERIAL1_READ__cts___cts___active 0
#define R_SERIAL1_READ__cts___cts___inactive 1
#define R_SERIAL1_READ__tr_ready__tr_ready__full 0
#define R_SERIAL1_READ__tr_ready__tr_ready__ready 1
#define R_SERIAL1_READ__overrun__overrun__no 0
#define R_SERIAL1_READ__overrun__overrun__yes 1
#define R_SERIAL1_READ__par_err__par_err__no 0
#define R_SERIAL1_READ__par_err__par_err__yes 1
#define R_SERIAL1_READ__framing_err__framing_err__no 0
#define R_SERIAL1_READ__framing_err__framing_err__yes 1
#define R_SERIAL1_READ__data_avail__data_avail__no 0
#define R_SERIAL1_READ__data_avail__data_avail__yes 1

#endif

/*
 *  R_SERIAL1_REC_CTRL
 *  - type:  WO
 *  - addr:  0xb000006a
 *  - group: Serial port registers
 */

#if USE_GROUP__Serial_port_registers

#define R_SERIAL1_REC_CTRL__ADDR      (REG_TYPECAST_BYTE  0xb000006a)

#ifndef REG_NO_SHADOW
#define R_SERIAL1_REC_CTRL__SADDR     (REG_STYPECAST_BYTE (reg_shadow__hwregs.R_SERIAL1_CTRL + 2))
#define R_SERIAL1_REC_CTRL__IADDR     (REG_STYPECAST_BYTE (reg_initiated__hwregs.R_SERIAL1_CTRL + 2))
#else /* REG_NO_SHADOW */
#define R_SERIAL1_REC_CTRL__SADDR     (REG_STYPECAST_BYTE (&reg_shadow__hwregs))
#define R_SERIAL1_REC_CTRL__IADDR     (REG_STYPECAST_BYTE (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_SERIAL1_REC_CTRL__STYPECAST REG_STYPECAST_BYTE
#define R_SERIAL1_REC_CTRL__SVAL      REG_SVAL_SHADOW
#define R_SERIAL1_REC_CTRL__SVAL_I    REG_SVAL_I_SHADOW
#define R_SERIAL1_REC_CTRL__TYPECAST  REG_TYPECAST_BYTE
#define R_SERIAL1_REC_CTRL__TYPE      (REG_BYTE)
#define R_SERIAL1_REC_CTRL__GET       REG_GET_WO
#define R_SERIAL1_REC_CTRL__IGET      REG_IGET_WO
#define R_SERIAL1_REC_CTRL__SET       REG_SET_WO
#define R_SERIAL1_REC_CTRL__ISET      REG_ISET_WO
#define R_SERIAL1_REC_CTRL__SET_VAL   REG_SET_VAL_WO
#define R_SERIAL1_REC_CTRL__EQL       REG_EQL_WO
#define R_SERIAL1_REC_CTRL__IEQL      REG_IEQL_WO
#define R_SERIAL1_REC_CTRL__RD        REG_RD_WO
#define R_SERIAL1_REC_CTRL__IRD       REG_IRD_WO
#define R_SERIAL1_REC_CTRL__WR        REG_WR_WO
#define R_SERIAL1_REC_CTRL__IWR       REG_IWR_WO

#define R_SERIAL1_REC_CTRL__WRITE(addr,value) \
  (*(addr) = (value))

#define R_SERIAL1_REC_CTRL__dma_err__dma_err__MASK 0x00000080U
#define R_SERIAL1_REC_CTRL__rec_enable__rec_enable__MASK 0x00000040U
#define R_SERIAL1_REC_CTRL__rts___rts___MASK 0x00000020U
#define R_SERIAL1_REC_CTRL__sampling__sampling__MASK 0x00000010U
#define R_SERIAL1_REC_CTRL__rec_stick_par__rec_stick_par__MASK 0x00000008U
#define R_SERIAL1_REC_CTRL__rec_par__rec_par__MASK 0x00000004U
#define R_SERIAL1_REC_CTRL__rec_par_en__rec_par_en__MASK 0x00000002U
#define R_SERIAL1_REC_CTRL__rec_bitnr__rec_bitnr__MASK 0x00000001U

#define R_SERIAL1_REC_CTRL__dma_err__MAX 0x1
#define R_SERIAL1_REC_CTRL__rec_enable__MAX 0x1
#define R_SERIAL1_REC_CTRL__rts___MAX 0x1
#define R_SERIAL1_REC_CTRL__sampling__MAX 0x1
#define R_SERIAL1_REC_CTRL__rec_stick_par__MAX 0x1
#define R_SERIAL1_REC_CTRL__rec_par__MAX 0x1
#define R_SERIAL1_REC_CTRL__rec_par_en__MAX 0x1
#define R_SERIAL1_REC_CTRL__rec_bitnr__MAX 0x1

#define R_SERIAL1_REC_CTRL__dma_err__MIN 0
#define R_SERIAL1_REC_CTRL__rec_enable__MIN 0
#define R_SERIAL1_REC_CTRL__rts___MIN 0
#define R_SERIAL1_REC_CTRL__sampling__MIN 0
#define R_SERIAL1_REC_CTRL__rec_stick_par__MIN 0
#define R_SERIAL1_REC_CTRL__rec_par__MIN 0
#define R_SERIAL1_REC_CTRL__rec_par_en__MIN 0
#define R_SERIAL1_REC_CTRL__rec_bitnr__MIN 0

#define R_SERIAL1_REC_CTRL__dma_err__BITNR 7
#define R_SERIAL1_REC_CTRL__rec_enable__BITNR 6
#define R_SERIAL1_REC_CTRL__rts___BITNR 5
#define R_SERIAL1_REC_CTRL__sampling__BITNR 4
#define R_SERIAL1_REC_CTRL__rec_stick_par__BITNR 3
#define R_SERIAL1_REC_CTRL__rec_par__BITNR 2
#define R_SERIAL1_REC_CTRL__rec_par_en__BITNR 1
#define R_SERIAL1_REC_CTRL__rec_bitnr__BITNR 0

#define R_SERIAL1_REC_CTRL__dma_err__dma_err__VAL REG_VAL_ENUM
#define R_SERIAL1_REC_CTRL__rec_enable__rec_enable__VAL REG_VAL_ENUM
#define R_SERIAL1_REC_CTRL__rts___rts___VAL REG_VAL_ENUM
#define R_SERIAL1_REC_CTRL__sampling__sampling__VAL REG_VAL_ENUM
#define R_SERIAL1_REC_CTRL__rec_stick_par__rec_stick_par__VAL REG_VAL_ENUM
#define R_SERIAL1_REC_CTRL__rec_par__rec_par__VAL REG_VAL_ENUM
#define R_SERIAL1_REC_CTRL__rec_par_en__rec_par_en__VAL REG_VAL_ENUM
#define R_SERIAL1_REC_CTRL__rec_bitnr__rec_bitnr__VAL REG_VAL_ENUM

#define R_SERIAL1_REC_CTRL__dma_err__dma_err__ignore 1
#define R_SERIAL1_REC_CTRL__dma_err__dma_err__stop 0
#define R_SERIAL1_REC_CTRL__rec_enable__rec_enable__disable 0
#define R_SERIAL1_REC_CTRL__rec_enable__rec_enable__enable 1
#define R_SERIAL1_REC_CTRL__rts___rts___active 0
#define R_SERIAL1_REC_CTRL__rts___rts___inactive 1
#define R_SERIAL1_REC_CTRL__sampling__sampling__majority 1
#define R_SERIAL1_REC_CTRL__sampling__sampling__middle 0
#define R_SERIAL1_REC_CTRL__rec_stick_par__rec_stick_par__normal 0
#define R_SERIAL1_REC_CTRL__rec_stick_par__rec_stick_par__stick 1
#define R_SERIAL1_REC_CTRL__rec_par__rec_par__even 0
#define R_SERIAL1_REC_CTRL__rec_par__rec_par__odd 1
#define R_SERIAL1_REC_CTRL__rec_par_en__rec_par_en__disable 0
#define R_SERIAL1_REC_CTRL__rec_par_en__rec_par_en__enable 1
#define R_SERIAL1_REC_CTRL__rec_bitnr__rec_bitnr__rec_7bit 1
#define R_SERIAL1_REC_CTRL__rec_bitnr__rec_bitnr__rec_8bit 0

#endif

/*
 *  R_SERIAL1_REC_DATA
 *  - type:  RO
 *  - addr:  0xb0000068
 *  - group: Serial port registers
 */

#if USE_GROUP__Serial_port_registers

#define R_SERIAL1_REC_DATA__ADDR      (REG_TYPECAST_BYTE  0xb0000068)
#define R_SERIAL1_REC_DATA__SVAL      REG_SVAL_SHADOW
#define R_SERIAL1_REC_DATA__SVAL_I    REG_SVAL_I_SHADOW
#define R_SERIAL1_REC_DATA__TYPECAST  REG_TYPECAST_BYTE
#define R_SERIAL1_REC_DATA__TYPE      (REG_BYTE)
#define R_SERIAL1_REC_DATA__GET       REG_GET_RO
#define R_SERIAL1_REC_DATA__IGET      REG_IGET_RO
#define R_SERIAL1_REC_DATA__SET       REG_SET_RO
#define R_SERIAL1_REC_DATA__ISET      REG_ISET_RO
#define R_SERIAL1_REC_DATA__SET_VAL   REG_SET_VAL_RO
#define R_SERIAL1_REC_DATA__EQL       REG_EQL_RO
#define R_SERIAL1_REC_DATA__IEQL      REG_IEQL_RO
#define R_SERIAL1_REC_DATA__RD        REG_RD_RO
#define R_SERIAL1_REC_DATA__IRD       REG_IRD_RO
#define R_SERIAL1_REC_DATA__WR        REG_WR_RO
#define R_SERIAL1_REC_DATA__IWR       REG_IWR_RO

#define R_SERIAL1_REC_DATA__READ(addr) \
  (*(addr))

#define R_SERIAL1_REC_DATA__data_in__data_in__MASK 0x000000ffU

#define R_SERIAL1_REC_DATA__data_in__MAX 0xff

#define R_SERIAL1_REC_DATA__data_in__MIN 0

#define R_SERIAL1_REC_DATA__data_in__BITNR 0

#define R_SERIAL1_REC_DATA__data_in__data_in__VAL REG_VAL_VAL


#endif

/*
 *  R_SERIAL1_STATUS
 *  - type:  RO
 *  - addr:  0xb0000069
 *  - group: Serial port registers
 */

#if USE_GROUP__Serial_port_registers

#define R_SERIAL1_STATUS__ADDR      (REG_TYPECAST_BYTE  0xb0000069)
#define R_SERIAL1_STATUS__SVAL      REG_SVAL_SHADOW
#define R_SERIAL1_STATUS__SVAL_I    REG_SVAL_I_SHADOW
#define R_SERIAL1_STATUS__TYPECAST  REG_TYPECAST_BYTE
#define R_SERIAL1_STATUS__TYPE      (REG_BYTE)
#define R_SERIAL1_STATUS__GET       REG_GET_RO
#define R_SERIAL1_STATUS__IGET      REG_IGET_RO
#define R_SERIAL1_STATUS__SET       REG_SET_RO
#define R_SERIAL1_STATUS__ISET      REG_ISET_RO
#define R_SERIAL1_STATUS__SET_VAL   REG_SET_VAL_RO
#define R_SERIAL1_STATUS__EQL       REG_EQL_RO
#define R_SERIAL1_STATUS__IEQL      REG_IEQL_RO
#define R_SERIAL1_STATUS__RD        REG_RD_RO
#define R_SERIAL1_STATUS__IRD       REG_IRD_RO
#define R_SERIAL1_STATUS__WR        REG_WR_RO
#define R_SERIAL1_STATUS__IWR       REG_IWR_RO

#define R_SERIAL1_STATUS__READ(addr) \
  (*(addr))

#define R_SERIAL1_STATUS__xoff_detect__xoff_detect__MASK 0x00000080U
#define R_SERIAL1_STATUS__cts___cts___MASK 0x00000040U
#define R_SERIAL1_STATUS__tr_ready__tr_ready__MASK 0x00000020U
#define R_SERIAL1_STATUS__rxd__rxd__MASK 0x00000010U
#define R_SERIAL1_STATUS__overrun__overrun__MASK 0x00000008U
#define R_SERIAL1_STATUS__par_err__par_err__MASK 0x00000004U
#define R_SERIAL1_STATUS__framing_err__framing_err__MASK 0x00000002U
#define R_SERIAL1_STATUS__data_avail__data_avail__MASK 0x00000001U

#define R_SERIAL1_STATUS__xoff_detect__MAX 0x1
#define R_SERIAL1_STATUS__cts___MAX 0x1
#define R_SERIAL1_STATUS__tr_ready__MAX 0x1
#define R_SERIAL1_STATUS__rxd__MAX 0x1
#define R_SERIAL1_STATUS__overrun__MAX 0x1
#define R_SERIAL1_STATUS__par_err__MAX 0x1
#define R_SERIAL1_STATUS__framing_err__MAX 0x1
#define R_SERIAL1_STATUS__data_avail__MAX 0x1

#define R_SERIAL1_STATUS__xoff_detect__MIN 0
#define R_SERIAL1_STATUS__cts___MIN 0
#define R_SERIAL1_STATUS__tr_ready__MIN 0
#define R_SERIAL1_STATUS__rxd__MIN 0
#define R_SERIAL1_STATUS__overrun__MIN 0
#define R_SERIAL1_STATUS__par_err__MIN 0
#define R_SERIAL1_STATUS__framing_err__MIN 0
#define R_SERIAL1_STATUS__data_avail__MIN 0

#define R_SERIAL1_STATUS__xoff_detect__BITNR 7
#define R_SERIAL1_STATUS__cts___BITNR 6
#define R_SERIAL1_STATUS__tr_ready__BITNR 5
#define R_SERIAL1_STATUS__rxd__BITNR 4
#define R_SERIAL1_STATUS__overrun__BITNR 3
#define R_SERIAL1_STATUS__par_err__BITNR 2
#define R_SERIAL1_STATUS__framing_err__BITNR 1
#define R_SERIAL1_STATUS__data_avail__BITNR 0

#define R_SERIAL1_STATUS__xoff_detect__xoff_detect__VAL REG_VAL_ENUM
#define R_SERIAL1_STATUS__cts___cts___VAL REG_VAL_ENUM
#define R_SERIAL1_STATUS__tr_ready__tr_ready__VAL REG_VAL_ENUM
#define R_SERIAL1_STATUS__rxd__rxd__VAL REG_VAL_VAL
#define R_SERIAL1_STATUS__overrun__overrun__VAL REG_VAL_ENUM
#define R_SERIAL1_STATUS__par_err__par_err__VAL REG_VAL_ENUM
#define R_SERIAL1_STATUS__framing_err__framing_err__VAL REG_VAL_ENUM
#define R_SERIAL1_STATUS__data_avail__data_avail__VAL REG_VAL_ENUM

#define R_SERIAL1_STATUS__xoff_detect__xoff_detect__no_xoff 0
#define R_SERIAL1_STATUS__xoff_detect__xoff_detect__xoff 1
#define R_SERIAL1_STATUS__cts___cts___active 0
#define R_SERIAL1_STATUS__cts___cts___inactive 1
#define R_SERIAL1_STATUS__tr_ready__tr_ready__full 0
#define R_SERIAL1_STATUS__tr_ready__tr_ready__ready 1
#define R_SERIAL1_STATUS__overrun__overrun__no 0
#define R_SERIAL1_STATUS__overrun__overrun__yes 1
#define R_SERIAL1_STATUS__par_err__par_err__no 0
#define R_SERIAL1_STATUS__par_err__par_err__yes 1
#define R_SERIAL1_STATUS__framing_err__framing_err__no 0
#define R_SERIAL1_STATUS__framing_err__framing_err__yes 1
#define R_SERIAL1_STATUS__data_avail__data_avail__no 0
#define R_SERIAL1_STATUS__data_avail__data_avail__yes 1

#endif

/*
 *  R_SERIAL1_TR_CTRL
 *  - type:  WO
 *  - addr:  0xb0000069
 *  - group: Serial port registers
 */

#if USE_GROUP__Serial_port_registers

#define R_SERIAL1_TR_CTRL__ADDR      (REG_TYPECAST_BYTE  0xb0000069)

#ifndef REG_NO_SHADOW
#define R_SERIAL1_TR_CTRL__SADDR     (REG_STYPECAST_BYTE (reg_shadow__hwregs.R_SERIAL1_CTRL + 1))
#define R_SERIAL1_TR_CTRL__IADDR     (REG_STYPECAST_BYTE (reg_initiated__hwregs.R_SERIAL1_CTRL + 1))
#else /* REG_NO_SHADOW */
#define R_SERIAL1_TR_CTRL__SADDR     (REG_STYPECAST_BYTE (&reg_shadow__hwregs))
#define R_SERIAL1_TR_CTRL__IADDR     (REG_STYPECAST_BYTE (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_SERIAL1_TR_CTRL__STYPECAST REG_STYPECAST_BYTE
#define R_SERIAL1_TR_CTRL__SVAL      REG_SVAL_SHADOW
#define R_SERIAL1_TR_CTRL__SVAL_I    REG_SVAL_I_SHADOW
#define R_SERIAL1_TR_CTRL__TYPECAST  REG_TYPECAST_BYTE
#define R_SERIAL1_TR_CTRL__TYPE      (REG_BYTE)
#define R_SERIAL1_TR_CTRL__GET       REG_GET_WO
#define R_SERIAL1_TR_CTRL__IGET      REG_IGET_WO
#define R_SERIAL1_TR_CTRL__SET       REG_SET_WO
#define R_SERIAL1_TR_CTRL__ISET      REG_ISET_WO
#define R_SERIAL1_TR_CTRL__SET_VAL   REG_SET_VAL_WO
#define R_SERIAL1_TR_CTRL__EQL       REG_EQL_WO
#define R_SERIAL1_TR_CTRL__IEQL      REG_IEQL_WO
#define R_SERIAL1_TR_CTRL__RD        REG_RD_WO
#define R_SERIAL1_TR_CTRL__IRD       REG_IRD_WO
#define R_SERIAL1_TR_CTRL__WR        REG_WR_WO
#define R_SERIAL1_TR_CTRL__IWR       REG_IWR_WO

#define R_SERIAL1_TR_CTRL__WRITE(addr,value) \
  (*(addr) = (value))

#define R_SERIAL1_TR_CTRL__txd__txd__MASK 0x00000080U
#define R_SERIAL1_TR_CTRL__tr_enable__tr_enable__MASK 0x00000040U
#define R_SERIAL1_TR_CTRL__auto_cts__auto_cts__MASK 0x00000020U
#define R_SERIAL1_TR_CTRL__stop_bits__stop_bits__MASK 0x00000010U
#define R_SERIAL1_TR_CTRL__tr_stick_par__tr_stick_par__MASK 0x00000008U
#define R_SERIAL1_TR_CTRL__tr_par__tr_par__MASK 0x00000004U
#define R_SERIAL1_TR_CTRL__tr_par_en__tr_par_en__MASK 0x00000002U
#define R_SERIAL1_TR_CTRL__tr_bitnr__tr_bitnr__MASK 0x00000001U

#define R_SERIAL1_TR_CTRL__txd__MAX 0x1
#define R_SERIAL1_TR_CTRL__tr_enable__MAX 0x1
#define R_SERIAL1_TR_CTRL__auto_cts__MAX 0x1
#define R_SERIAL1_TR_CTRL__stop_bits__MAX 0x1
#define R_SERIAL1_TR_CTRL__tr_stick_par__MAX 0x1
#define R_SERIAL1_TR_CTRL__tr_par__MAX 0x1
#define R_SERIAL1_TR_CTRL__tr_par_en__MAX 0x1
#define R_SERIAL1_TR_CTRL__tr_bitnr__MAX 0x1

#define R_SERIAL1_TR_CTRL__txd__MIN 0
#define R_SERIAL1_TR_CTRL__tr_enable__MIN 0
#define R_SERIAL1_TR_CTRL__auto_cts__MIN 0
#define R_SERIAL1_TR_CTRL__stop_bits__MIN 0
#define R_SERIAL1_TR_CTRL__tr_stick_par__MIN 0
#define R_SERIAL1_TR_CTRL__tr_par__MIN 0
#define R_SERIAL1_TR_CTRL__tr_par_en__MIN 0
#define R_SERIAL1_TR_CTRL__tr_bitnr__MIN 0

#define R_SERIAL1_TR_CTRL__txd__BITNR 7
#define R_SERIAL1_TR_CTRL__tr_enable__BITNR 6
#define R_SERIAL1_TR_CTRL__auto_cts__BITNR 5
#define R_SERIAL1_TR_CTRL__stop_bits__BITNR 4
#define R_SERIAL1_TR_CTRL__tr_stick_par__BITNR 3
#define R_SERIAL1_TR_CTRL__tr_par__BITNR 2
#define R_SERIAL1_TR_CTRL__tr_par_en__BITNR 1
#define R_SERIAL1_TR_CTRL__tr_bitnr__BITNR 0

#define R_SERIAL1_TR_CTRL__txd__txd__VAL REG_VAL_VAL
#define R_SERIAL1_TR_CTRL__tr_enable__tr_enable__VAL REG_VAL_ENUM
#define R_SERIAL1_TR_CTRL__auto_cts__auto_cts__VAL REG_VAL_ENUM
#define R_SERIAL1_TR_CTRL__stop_bits__stop_bits__VAL REG_VAL_ENUM
#define R_SERIAL1_TR_CTRL__tr_stick_par__tr_stick_par__VAL REG_VAL_ENUM
#define R_SERIAL1_TR_CTRL__tr_par__tr_par__VAL REG_VAL_ENUM
#define R_SERIAL1_TR_CTRL__tr_par_en__tr_par_en__VAL REG_VAL_ENUM
#define R_SERIAL1_TR_CTRL__tr_bitnr__tr_bitnr__VAL REG_VAL_ENUM

#define R_SERIAL1_TR_CTRL__tr_enable__tr_enable__disable 0
#define R_SERIAL1_TR_CTRL__tr_enable__tr_enable__enable 1
#define R_SERIAL1_TR_CTRL__auto_cts__auto_cts__active 1
#define R_SERIAL1_TR_CTRL__auto_cts__auto_cts__disabled 0
#define R_SERIAL1_TR_CTRL__stop_bits__stop_bits__one_bit 0
#define R_SERIAL1_TR_CTRL__stop_bits__stop_bits__two_bits 1
#define R_SERIAL1_TR_CTRL__tr_stick_par__tr_stick_par__normal 0
#define R_SERIAL1_TR_CTRL__tr_stick_par__tr_stick_par__stick 1
#define R_SERIAL1_TR_CTRL__tr_par__tr_par__even 0
#define R_SERIAL1_TR_CTRL__tr_par__tr_par__odd 1
#define R_SERIAL1_TR_CTRL__tr_par_en__tr_par_en__disable 0
#define R_SERIAL1_TR_CTRL__tr_par_en__tr_par_en__enable 1
#define R_SERIAL1_TR_CTRL__tr_bitnr__tr_bitnr__tr_7bit 1
#define R_SERIAL1_TR_CTRL__tr_bitnr__tr_bitnr__tr_8bit 0

#endif

/*
 *  R_SERIAL1_TR_DATA
 *  - type:  WO
 *  - addr:  0xb0000068
 *  - group: Serial port registers
 */

#if USE_GROUP__Serial_port_registers

#define R_SERIAL1_TR_DATA__ADDR      (REG_TYPECAST_BYTE  0xb0000068)

#ifndef REG_NO_SHADOW
#define R_SERIAL1_TR_DATA__SADDR     (REG_STYPECAST_BYTE (reg_shadow__hwregs.R_SERIAL1_CTRL + 0))
#define R_SERIAL1_TR_DATA__IADDR     (REG_STYPECAST_BYTE (reg_initiated__hwregs.R_SERIAL1_CTRL + 0))
#else /* REG_NO_SHADOW */
#define R_SERIAL1_TR_DATA__SADDR     (REG_STYPECAST_BYTE (&reg_shadow__hwregs))
#define R_SERIAL1_TR_DATA__IADDR     (REG_STYPECAST_BYTE (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_SERIAL1_TR_DATA__STYPECAST REG_STYPECAST_BYTE
#define R_SERIAL1_TR_DATA__SVAL      REG_SVAL_SHADOW
#define R_SERIAL1_TR_DATA__SVAL_I    REG_SVAL_I_SHADOW
#define R_SERIAL1_TR_DATA__TYPECAST  REG_TYPECAST_BYTE
#define R_SERIAL1_TR_DATA__TYPE      (REG_BYTE)
#define R_SERIAL1_TR_DATA__GET       REG_GET_WO
#define R_SERIAL1_TR_DATA__IGET      REG_IGET_WO
#define R_SERIAL1_TR_DATA__SET       REG_SET_WO
#define R_SERIAL1_TR_DATA__ISET      REG_ISET_WO
#define R_SERIAL1_TR_DATA__SET_VAL   REG_SET_VAL_WO
#define R_SERIAL1_TR_DATA__EQL       REG_EQL_WO
#define R_SERIAL1_TR_DATA__IEQL      REG_IEQL_WO
#define R_SERIAL1_TR_DATA__RD        REG_RD_WO
#define R_SERIAL1_TR_DATA__IRD       REG_IRD_WO
#define R_SERIAL1_TR_DATA__WR        REG_WR_WO
#define R_SERIAL1_TR_DATA__IWR       REG_IWR_WO

#define R_SERIAL1_TR_DATA__WRITE(addr,value) \
  (*(addr) = (value))

#define R_SERIAL1_TR_DATA__data_out__data_out__MASK 0x000000ffU

#define R_SERIAL1_TR_DATA__data_out__MAX 0xff

#define R_SERIAL1_TR_DATA__data_out__MIN 0

#define R_SERIAL1_TR_DATA__data_out__BITNR 0

#define R_SERIAL1_TR_DATA__data_out__data_out__VAL REG_VAL_VAL


#endif

/*
 *  R_SERIAL1_XOFF
 *  - type:  WO
 *  - addr:  0xb000006c
 *  - group: Serial port registers
 */

#if USE_GROUP__Serial_port_registers

#define R_SERIAL1_XOFF__ADDR      (REG_TYPECAST_UDWORD  0xb000006c)

#ifndef REG_NO_SHADOW
#define R_SERIAL1_XOFF__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_SERIAL1_XOFF + 0))
#define R_SERIAL1_XOFF__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_SERIAL1_XOFF + 0))
#else /* REG_NO_SHADOW */
#define R_SERIAL1_XOFF__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_SERIAL1_XOFF__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_SERIAL1_XOFF__STYPECAST REG_STYPECAST_UDWORD
#define R_SERIAL1_XOFF__SVAL      REG_SVAL_SHADOW
#define R_SERIAL1_XOFF__SVAL_I    REG_SVAL_I_SHADOW
#define R_SERIAL1_XOFF__TYPECAST  REG_TYPECAST_UDWORD
#define R_SERIAL1_XOFF__TYPE      (REG_UDWORD)
#define R_SERIAL1_XOFF__GET       REG_GET_WO
#define R_SERIAL1_XOFF__IGET      REG_IGET_WO
#define R_SERIAL1_XOFF__SET       REG_SET_WO
#define R_SERIAL1_XOFF__ISET      REG_ISET_WO
#define R_SERIAL1_XOFF__SET_VAL   REG_SET_VAL_WO
#define R_SERIAL1_XOFF__EQL       REG_EQL_WO
#define R_SERIAL1_XOFF__IEQL      REG_IEQL_WO
#define R_SERIAL1_XOFF__RD        REG_RD_WO
#define R_SERIAL1_XOFF__IRD       REG_IRD_WO
#define R_SERIAL1_XOFF__WR        REG_WR_WO
#define R_SERIAL1_XOFF__IWR       REG_IWR_WO

#define R_SERIAL1_XOFF__WRITE(addr,value) \
  (*(addr) = (value))

#define R_SERIAL1_XOFF__tx_stop__tx_stop__MASK 0x00000200U
#define R_SERIAL1_XOFF__auto_xoff__auto_xoff__MASK 0x00000100U
#define R_SERIAL1_XOFF__xoff_char__xoff_char__MASK 0x000000ffU

#define R_SERIAL1_XOFF__tx_stop__MAX 0x1
#define R_SERIAL1_XOFF__auto_xoff__MAX 0x1
#define R_SERIAL1_XOFF__xoff_char__MAX 0xff

#define R_SERIAL1_XOFF__tx_stop__MIN 0
#define R_SERIAL1_XOFF__auto_xoff__MIN 0
#define R_SERIAL1_XOFF__xoff_char__MIN 0

#define R_SERIAL1_XOFF__tx_stop__BITNR 9
#define R_SERIAL1_XOFF__auto_xoff__BITNR 8
#define R_SERIAL1_XOFF__xoff_char__BITNR 0

#define R_SERIAL1_XOFF__tx_stop__tx_stop__VAL REG_VAL_ENUM
#define R_SERIAL1_XOFF__auto_xoff__auto_xoff__VAL REG_VAL_ENUM
#define R_SERIAL1_XOFF__xoff_char__xoff_char__VAL REG_VAL_VAL

#define R_SERIAL1_XOFF__tx_stop__tx_stop__enable 0
#define R_SERIAL1_XOFF__tx_stop__tx_stop__stop 1
#define R_SERIAL1_XOFF__auto_xoff__auto_xoff__disable 0
#define R_SERIAL1_XOFF__auto_xoff__auto_xoff__enable 1

#endif

/*
 *  R_SERIAL2_BAUD
 *  - type:  WO
 *  - addr:  0xb0000073
 *  - group: Serial port registers
 */

#if USE_GROUP__Serial_port_registers

#define R_SERIAL2_BAUD__ADDR      (REG_TYPECAST_BYTE  0xb0000073)

#ifndef REG_NO_SHADOW
#define R_SERIAL2_BAUD__SADDR     (REG_STYPECAST_BYTE (reg_shadow__hwregs.R_SERIAL2_CTRL + 3))
#define R_SERIAL2_BAUD__IADDR     (REG_STYPECAST_BYTE (reg_initiated__hwregs.R_SERIAL2_CTRL + 3))
#else /* REG_NO_SHADOW */
#define R_SERIAL2_BAUD__SADDR     (REG_STYPECAST_BYTE (&reg_shadow__hwregs))
#define R_SERIAL2_BAUD__IADDR     (REG_STYPECAST_BYTE (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_SERIAL2_BAUD__STYPECAST REG_STYPECAST_BYTE
#define R_SERIAL2_BAUD__SVAL      REG_SVAL_SHADOW
#define R_SERIAL2_BAUD__SVAL_I    REG_SVAL_I_SHADOW
#define R_SERIAL2_BAUD__TYPECAST  REG_TYPECAST_BYTE
#define R_SERIAL2_BAUD__TYPE      (REG_BYTE)
#define R_SERIAL2_BAUD__GET       REG_GET_WO
#define R_SERIAL2_BAUD__IGET      REG_IGET_WO
#define R_SERIAL2_BAUD__SET       REG_SET_WO
#define R_SERIAL2_BAUD__ISET      REG_ISET_WO
#define R_SERIAL2_BAUD__SET_VAL   REG_SET_VAL_WO
#define R_SERIAL2_BAUD__EQL       REG_EQL_WO
#define R_SERIAL2_BAUD__IEQL      REG_IEQL_WO
#define R_SERIAL2_BAUD__RD        REG_RD_WO
#define R_SERIAL2_BAUD__IRD       REG_IRD_WO
#define R_SERIAL2_BAUD__WR        REG_WR_WO
#define R_SERIAL2_BAUD__IWR       REG_IWR_WO

#define R_SERIAL2_BAUD__WRITE(addr,value) \
  (*(addr) = (value))

#define R_SERIAL2_BAUD__tr_baud__tr_baud__MASK 0x000000f0U
#define R_SERIAL2_BAUD__rec_baud__rec_baud__MASK 0x0000000fU

#define R_SERIAL2_BAUD__tr_baud__MAX 0xf
#define R_SERIAL2_BAUD__rec_baud__MAX 0xf

#define R_SERIAL2_BAUD__tr_baud__MIN 0
#define R_SERIAL2_BAUD__rec_baud__MIN 0

#define R_SERIAL2_BAUD__tr_baud__BITNR 4
#define R_SERIAL2_BAUD__rec_baud__BITNR 0

#define R_SERIAL2_BAUD__tr_baud__tr_baud__VAL REG_VAL_ENUM
#define R_SERIAL2_BAUD__rec_baud__rec_baud__VAL REG_VAL_ENUM

#define R_SERIAL2_BAUD__tr_baud__tr_baud__c115k2Hz 9
#define R_SERIAL2_BAUD__tr_baud__tr_baud__c1200Hz 2
#define R_SERIAL2_BAUD__tr_baud__tr_baud__c1843k2Hz 13
#define R_SERIAL2_BAUD__tr_baud__tr_baud__c19k2Hz 6
#define R_SERIAL2_BAUD__tr_baud__tr_baud__c230k4Hz 10
#define R_SERIAL2_BAUD__tr_baud__tr_baud__c2400Hz 3
#define R_SERIAL2_BAUD__tr_baud__tr_baud__c300Hz 0
#define R_SERIAL2_BAUD__tr_baud__tr_baud__c38k4Hz 7
#define R_SERIAL2_BAUD__tr_baud__tr_baud__c460k8Hz 11
#define R_SERIAL2_BAUD__tr_baud__tr_baud__c4800Hz 4
#define R_SERIAL2_BAUD__tr_baud__tr_baud__c57k6Hz 8
#define R_SERIAL2_BAUD__tr_baud__tr_baud__c600Hz 1
#define R_SERIAL2_BAUD__tr_baud__tr_baud__c6250kHz 14
#define R_SERIAL2_BAUD__tr_baud__tr_baud__c921k6Hz 12
#define R_SERIAL2_BAUD__tr_baud__tr_baud__c9600Hz 5
#define R_SERIAL2_BAUD__rec_baud__rec_baud__c115k2Hz 9
#define R_SERIAL2_BAUD__rec_baud__rec_baud__c1200Hz 2
#define R_SERIAL2_BAUD__rec_baud__rec_baud__c1843k2Hz 13
#define R_SERIAL2_BAUD__rec_baud__rec_baud__c19k2Hz 6
#define R_SERIAL2_BAUD__rec_baud__rec_baud__c230k4Hz 10
#define R_SERIAL2_BAUD__rec_baud__rec_baud__c2400Hz 3
#define R_SERIAL2_BAUD__rec_baud__rec_baud__c300Hz 0
#define R_SERIAL2_BAUD__rec_baud__rec_baud__c38k4Hz 7
#define R_SERIAL2_BAUD__rec_baud__rec_baud__c460k8Hz 11
#define R_SERIAL2_BAUD__rec_baud__rec_baud__c4800Hz 4
#define R_SERIAL2_BAUD__rec_baud__rec_baud__c57k6Hz 8
#define R_SERIAL2_BAUD__rec_baud__rec_baud__c600Hz 1
#define R_SERIAL2_BAUD__rec_baud__rec_baud__c6250kHz 14
#define R_SERIAL2_BAUD__rec_baud__rec_baud__c921k6Hz 12
#define R_SERIAL2_BAUD__rec_baud__rec_baud__c9600Hz 5

#endif

/*
 *  R_SERIAL2_CTRL
 *  - type:  WO
 *  - addr:  0xb0000070
 *  - group: Serial port registers
 */

#if USE_GROUP__Serial_port_registers

#define R_SERIAL2_CTRL__ADDR      (REG_TYPECAST_UDWORD  0xb0000070)

#ifndef REG_NO_SHADOW
#define R_SERIAL2_CTRL__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_SERIAL2_CTRL + 0))
#define R_SERIAL2_CTRL__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_SERIAL2_CTRL + 0))
#else /* REG_NO_SHADOW */
#define R_SERIAL2_CTRL__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_SERIAL2_CTRL__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_SERIAL2_CTRL__STYPECAST REG_STYPECAST_UDWORD
#define R_SERIAL2_CTRL__SVAL      REG_SVAL_SHADOW
#define R_SERIAL2_CTRL__SVAL_I    REG_SVAL_I_SHADOW
#define R_SERIAL2_CTRL__TYPECAST  REG_TYPECAST_UDWORD
#define R_SERIAL2_CTRL__TYPE      (REG_UDWORD)
#define R_SERIAL2_CTRL__GET       REG_GET_WO
#define R_SERIAL2_CTRL__IGET      REG_IGET_WO
#define R_SERIAL2_CTRL__SET       REG_SET_WO
#define R_SERIAL2_CTRL__ISET      REG_ISET_WO
#define R_SERIAL2_CTRL__SET_VAL   REG_SET_VAL_WO
#define R_SERIAL2_CTRL__EQL       REG_EQL_WO
#define R_SERIAL2_CTRL__IEQL      REG_IEQL_WO
#define R_SERIAL2_CTRL__RD        REG_RD_WO
#define R_SERIAL2_CTRL__IRD       REG_IRD_WO
#define R_SERIAL2_CTRL__WR        REG_WR_WO
#define R_SERIAL2_CTRL__IWR       REG_IWR_WO

#define R_SERIAL2_CTRL__WRITE(addr,value) \
  (*(addr) = (value))

#define R_SERIAL2_CTRL__tr_baud__tr_baud__MASK 0xf0000000U
#define R_SERIAL2_CTRL__rec_baud__rec_baud__MASK 0x0f000000U
#define R_SERIAL2_CTRL__dma_err__dma_err__MASK 0x00800000U
#define R_SERIAL2_CTRL__rec_enable__rec_enable__MASK 0x00400000U
#define R_SERIAL2_CTRL__rts___rts___MASK 0x00200000U
#define R_SERIAL2_CTRL__sampling__sampling__MASK 0x00100000U
#define R_SERIAL2_CTRL__rec_stick_par__rec_stick_par__MASK 0x00080000U
#define R_SERIAL2_CTRL__rec_par__rec_par__MASK 0x00040000U
#define R_SERIAL2_CTRL__rec_par_en__rec_par_en__MASK 0x00020000U
#define R_SERIAL2_CTRL__rec_bitnr__rec_bitnr__MASK 0x00010000U
#define R_SERIAL2_CTRL__txd__txd__MASK 0x00008000U
#define R_SERIAL2_CTRL__tr_enable__tr_enable__MASK 0x00004000U
#define R_SERIAL2_CTRL__auto_cts__auto_cts__MASK 0x00002000U
#define R_SERIAL2_CTRL__stop_bits__stop_bits__MASK 0x00001000U
#define R_SERIAL2_CTRL__tr_stick_par__tr_stick_par__MASK 0x00000800U
#define R_SERIAL2_CTRL__tr_par__tr_par__MASK 0x00000400U
#define R_SERIAL2_CTRL__tr_par_en__tr_par_en__MASK 0x00000200U
#define R_SERIAL2_CTRL__tr_bitnr__tr_bitnr__MASK 0x00000100U
#define R_SERIAL2_CTRL__data_out__data_out__MASK 0x000000ffU

#define R_SERIAL2_CTRL__tr_baud__MAX 0xf
#define R_SERIAL2_CTRL__rec_baud__MAX 0xf
#define R_SERIAL2_CTRL__dma_err__MAX 0x1
#define R_SERIAL2_CTRL__rec_enable__MAX 0x1
#define R_SERIAL2_CTRL__rts___MAX 0x1
#define R_SERIAL2_CTRL__sampling__MAX 0x1
#define R_SERIAL2_CTRL__rec_stick_par__MAX 0x1
#define R_SERIAL2_CTRL__rec_par__MAX 0x1
#define R_SERIAL2_CTRL__rec_par_en__MAX 0x1
#define R_SERIAL2_CTRL__rec_bitnr__MAX 0x1
#define R_SERIAL2_CTRL__txd__MAX 0x1
#define R_SERIAL2_CTRL__tr_enable__MAX 0x1
#define R_SERIAL2_CTRL__auto_cts__MAX 0x1
#define R_SERIAL2_CTRL__stop_bits__MAX 0x1
#define R_SERIAL2_CTRL__tr_stick_par__MAX 0x1
#define R_SERIAL2_CTRL__tr_par__MAX 0x1
#define R_SERIAL2_CTRL__tr_par_en__MAX 0x1
#define R_SERIAL2_CTRL__tr_bitnr__MAX 0x1
#define R_SERIAL2_CTRL__data_out__MAX 0xff

#define R_SERIAL2_CTRL__tr_baud__MIN 0
#define R_SERIAL2_CTRL__rec_baud__MIN 0
#define R_SERIAL2_CTRL__dma_err__MIN 0
#define R_SERIAL2_CTRL__rec_enable__MIN 0
#define R_SERIAL2_CTRL__rts___MIN 0
#define R_SERIAL2_CTRL__sampling__MIN 0
#define R_SERIAL2_CTRL__rec_stick_par__MIN 0
#define R_SERIAL2_CTRL__rec_par__MIN 0
#define R_SERIAL2_CTRL__rec_par_en__MIN 0
#define R_SERIAL2_CTRL__rec_bitnr__MIN 0
#define R_SERIAL2_CTRL__txd__MIN 0
#define R_SERIAL2_CTRL__tr_enable__MIN 0
#define R_SERIAL2_CTRL__auto_cts__MIN 0
#define R_SERIAL2_CTRL__stop_bits__MIN 0
#define R_SERIAL2_CTRL__tr_stick_par__MIN 0
#define R_SERIAL2_CTRL__tr_par__MIN 0
#define R_SERIAL2_CTRL__tr_par_en__MIN 0
#define R_SERIAL2_CTRL__tr_bitnr__MIN 0
#define R_SERIAL2_CTRL__data_out__MIN 0

#define R_SERIAL2_CTRL__tr_baud__BITNR 28
#define R_SERIAL2_CTRL__rec_baud__BITNR 24
#define R_SERIAL2_CTRL__dma_err__BITNR 23
#define R_SERIAL2_CTRL__rec_enable__BITNR 22
#define R_SERIAL2_CTRL__rts___BITNR 21
#define R_SERIAL2_CTRL__sampling__BITNR 20
#define R_SERIAL2_CTRL__rec_stick_par__BITNR 19
#define R_SERIAL2_CTRL__rec_par__BITNR 18
#define R_SERIAL2_CTRL__rec_par_en__BITNR 17
#define R_SERIAL2_CTRL__rec_bitnr__BITNR 16
#define R_SERIAL2_CTRL__txd__BITNR 15
#define R_SERIAL2_CTRL__tr_enable__BITNR 14
#define R_SERIAL2_CTRL__auto_cts__BITNR 13
#define R_SERIAL2_CTRL__stop_bits__BITNR 12
#define R_SERIAL2_CTRL__tr_stick_par__BITNR 11
#define R_SERIAL2_CTRL__tr_par__BITNR 10
#define R_SERIAL2_CTRL__tr_par_en__BITNR 9
#define R_SERIAL2_CTRL__tr_bitnr__BITNR 8
#define R_SERIAL2_CTRL__data_out__BITNR 0

#define R_SERIAL2_CTRL__tr_baud__tr_baud__VAL REG_VAL_ENUM
#define R_SERIAL2_CTRL__rec_baud__rec_baud__VAL REG_VAL_ENUM
#define R_SERIAL2_CTRL__dma_err__dma_err__VAL REG_VAL_ENUM
#define R_SERIAL2_CTRL__rec_enable__rec_enable__VAL REG_VAL_ENUM
#define R_SERIAL2_CTRL__rts___rts___VAL REG_VAL_ENUM
#define R_SERIAL2_CTRL__sampling__sampling__VAL REG_VAL_ENUM
#define R_SERIAL2_CTRL__rec_stick_par__rec_stick_par__VAL REG_VAL_ENUM
#define R_SERIAL2_CTRL__rec_par__rec_par__VAL REG_VAL_ENUM
#define R_SERIAL2_CTRL__rec_par_en__rec_par_en__VAL REG_VAL_ENUM
#define R_SERIAL2_CTRL__rec_bitnr__rec_bitnr__VAL REG_VAL_ENUM
#define R_SERIAL2_CTRL__txd__txd__VAL REG_VAL_VAL
#define R_SERIAL2_CTRL__tr_enable__tr_enable__VAL REG_VAL_ENUM
#define R_SERIAL2_CTRL__auto_cts__auto_cts__VAL REG_VAL_ENUM
#define R_SERIAL2_CTRL__stop_bits__stop_bits__VAL REG_VAL_ENUM
#define R_SERIAL2_CTRL__tr_stick_par__tr_stick_par__VAL REG_VAL_ENUM
#define R_SERIAL2_CTRL__tr_par__tr_par__VAL REG_VAL_ENUM
#define R_SERIAL2_CTRL__tr_par_en__tr_par_en__VAL REG_VAL_ENUM
#define R_SERIAL2_CTRL__tr_bitnr__tr_bitnr__VAL REG_VAL_ENUM
#define R_SERIAL2_CTRL__data_out__data_out__VAL REG_VAL_VAL

#define R_SERIAL2_CTRL__tr_baud__tr_baud__c115k2Hz 9
#define R_SERIAL2_CTRL__tr_baud__tr_baud__c1200Hz 2
#define R_SERIAL2_CTRL__tr_baud__tr_baud__c1843k2Hz 13
#define R_SERIAL2_CTRL__tr_baud__tr_baud__c19k2Hz 6
#define R_SERIAL2_CTRL__tr_baud__tr_baud__c230k4Hz 10
#define R_SERIAL2_CTRL__tr_baud__tr_baud__c2400Hz 3
#define R_SERIAL2_CTRL__tr_baud__tr_baud__c300Hz 0
#define R_SERIAL2_CTRL__tr_baud__tr_baud__c38k4Hz 7
#define R_SERIAL2_CTRL__tr_baud__tr_baud__c460k8Hz 11
#define R_SERIAL2_CTRL__tr_baud__tr_baud__c4800Hz 4
#define R_SERIAL2_CTRL__tr_baud__tr_baud__c57k6Hz 8
#define R_SERIAL2_CTRL__tr_baud__tr_baud__c600Hz 1
#define R_SERIAL2_CTRL__tr_baud__tr_baud__c6250kHz 14
#define R_SERIAL2_CTRL__tr_baud__tr_baud__c921k6Hz 12
#define R_SERIAL2_CTRL__tr_baud__tr_baud__c9600Hz 5
#define R_SERIAL2_CTRL__rec_baud__rec_baud__c115k2Hz 9
#define R_SERIAL2_CTRL__rec_baud__rec_baud__c1200Hz 2
#define R_SERIAL2_CTRL__rec_baud__rec_baud__c1843k2Hz 13
#define R_SERIAL2_CTRL__rec_baud__rec_baud__c19k2Hz 6
#define R_SERIAL2_CTRL__rec_baud__rec_baud__c230k4Hz 10
#define R_SERIAL2_CTRL__rec_baud__rec_baud__c2400Hz 3
#define R_SERIAL2_CTRL__rec_baud__rec_baud__c300Hz 0
#define R_SERIAL2_CTRL__rec_baud__rec_baud__c38k4Hz 7
#define R_SERIAL2_CTRL__rec_baud__rec_baud__c460k8Hz 11
#define R_SERIAL2_CTRL__rec_baud__rec_baud__c4800Hz 4
#define R_SERIAL2_CTRL__rec_baud__rec_baud__c57k6Hz 8
#define R_SERIAL2_CTRL__rec_baud__rec_baud__c600Hz 1
#define R_SERIAL2_CTRL__rec_baud__rec_baud__c6250kHz 14
#define R_SERIAL2_CTRL__rec_baud__rec_baud__c921k6Hz 12
#define R_SERIAL2_CTRL__rec_baud__rec_baud__c9600Hz 5
#define R_SERIAL2_CTRL__dma_err__dma_err__ignore 1
#define R_SERIAL2_CTRL__dma_err__dma_err__stop 0
#define R_SERIAL2_CTRL__rec_enable__rec_enable__disable 0
#define R_SERIAL2_CTRL__rec_enable__rec_enable__enable 1
#define R_SERIAL2_CTRL__rts___rts___active 0
#define R_SERIAL2_CTRL__rts___rts___inactive 1
#define R_SERIAL2_CTRL__sampling__sampling__majority 1
#define R_SERIAL2_CTRL__sampling__sampling__middle 0
#define R_SERIAL2_CTRL__rec_stick_par__rec_stick_par__normal 0
#define R_SERIAL2_CTRL__rec_stick_par__rec_stick_par__stick 1
#define R_SERIAL2_CTRL__rec_par__rec_par__even 0
#define R_SERIAL2_CTRL__rec_par__rec_par__odd 1
#define R_SERIAL2_CTRL__rec_par_en__rec_par_en__disable 0
#define R_SERIAL2_CTRL__rec_par_en__rec_par_en__enable 1
#define R_SERIAL2_CTRL__rec_bitnr__rec_bitnr__rec_7bit 1
#define R_SERIAL2_CTRL__rec_bitnr__rec_bitnr__rec_8bit 0
#define R_SERIAL2_CTRL__tr_enable__tr_enable__disable 0
#define R_SERIAL2_CTRL__tr_enable__tr_enable__enable 1
#define R_SERIAL2_CTRL__auto_cts__auto_cts__active 1
#define R_SERIAL2_CTRL__auto_cts__auto_cts__disabled 0
#define R_SERIAL2_CTRL__stop_bits__stop_bits__one_bit 0
#define R_SERIAL2_CTRL__stop_bits__stop_bits__two_bits 1
#define R_SERIAL2_CTRL__tr_stick_par__tr_stick_par__normal 0
#define R_SERIAL2_CTRL__tr_stick_par__tr_stick_par__stick 1
#define R_SERIAL2_CTRL__tr_par__tr_par__even 0
#define R_SERIAL2_CTRL__tr_par__tr_par__odd 1
#define R_SERIAL2_CTRL__tr_par_en__tr_par_en__disable 0
#define R_SERIAL2_CTRL__tr_par_en__tr_par_en__enable 1
#define R_SERIAL2_CTRL__tr_bitnr__tr_bitnr__tr_7bit 1
#define R_SERIAL2_CTRL__tr_bitnr__tr_bitnr__tr_8bit 0

#endif

/*
 *  R_SERIAL2_READ
 *  - type:  RO
 *  - addr:  0xb0000070
 *  - group: Serial port registers
 */

#if USE_GROUP__Serial_port_registers

#define R_SERIAL2_READ__ADDR      (REG_TYPECAST_UDWORD  0xb0000070)
#define R_SERIAL2_READ__SVAL      REG_SVAL_SHADOW
#define R_SERIAL2_READ__SVAL_I    REG_SVAL_I_SHADOW
#define R_SERIAL2_READ__TYPECAST  REG_TYPECAST_UDWORD
#define R_SERIAL2_READ__TYPE      (REG_UDWORD)
#define R_SERIAL2_READ__GET       REG_GET_RO
#define R_SERIAL2_READ__IGET      REG_IGET_RO
#define R_SERIAL2_READ__SET       REG_SET_RO
#define R_SERIAL2_READ__ISET      REG_ISET_RO
#define R_SERIAL2_READ__SET_VAL   REG_SET_VAL_RO
#define R_SERIAL2_READ__EQL       REG_EQL_RO
#define R_SERIAL2_READ__IEQL      REG_IEQL_RO
#define R_SERIAL2_READ__RD        REG_RD_RO
#define R_SERIAL2_READ__IRD       REG_IRD_RO
#define R_SERIAL2_READ__WR        REG_WR_RO
#define R_SERIAL2_READ__IWR       REG_IWR_RO

#define R_SERIAL2_READ__READ(addr) \
  (*(addr))

#define R_SERIAL2_READ__xoff_detect__xoff_detect__MASK 0x00008000U
#define R_SERIAL2_READ__cts___cts___MASK 0x00004000U
#define R_SERIAL2_READ__tr_ready__tr_ready__MASK 0x00002000U
#define R_SERIAL2_READ__rxd__rxd__MASK 0x00001000U
#define R_SERIAL2_READ__overrun__overrun__MASK 0x00000800U
#define R_SERIAL2_READ__par_err__par_err__MASK 0x00000400U
#define R_SERIAL2_READ__framing_err__framing_err__MASK 0x00000200U
#define R_SERIAL2_READ__data_avail__data_avail__MASK 0x00000100U
#define R_SERIAL2_READ__data_in__data_in__MASK 0x000000ffU

#define R_SERIAL2_READ__xoff_detect__MAX 0x1
#define R_SERIAL2_READ__cts___MAX 0x1
#define R_SERIAL2_READ__tr_ready__MAX 0x1
#define R_SERIAL2_READ__rxd__MAX 0x1
#define R_SERIAL2_READ__overrun__MAX 0x1
#define R_SERIAL2_READ__par_err__MAX 0x1
#define R_SERIAL2_READ__framing_err__MAX 0x1
#define R_SERIAL2_READ__data_avail__MAX 0x1
#define R_SERIAL2_READ__data_in__MAX 0xff

#define R_SERIAL2_READ__xoff_detect__MIN 0
#define R_SERIAL2_READ__cts___MIN 0
#define R_SERIAL2_READ__tr_ready__MIN 0
#define R_SERIAL2_READ__rxd__MIN 0
#define R_SERIAL2_READ__overrun__MIN 0
#define R_SERIAL2_READ__par_err__MIN 0
#define R_SERIAL2_READ__framing_err__MIN 0
#define R_SERIAL2_READ__data_avail__MIN 0
#define R_SERIAL2_READ__data_in__MIN 0

#define R_SERIAL2_READ__xoff_detect__BITNR 15
#define R_SERIAL2_READ__cts___BITNR 14
#define R_SERIAL2_READ__tr_ready__BITNR 13
#define R_SERIAL2_READ__rxd__BITNR 12
#define R_SERIAL2_READ__overrun__BITNR 11
#define R_SERIAL2_READ__par_err__BITNR 10
#define R_SERIAL2_READ__framing_err__BITNR 9
#define R_SERIAL2_READ__data_avail__BITNR 8
#define R_SERIAL2_READ__data_in__BITNR 0

#define R_SERIAL2_READ__xoff_detect__xoff_detect__VAL REG_VAL_ENUM
#define R_SERIAL2_READ__cts___cts___VAL REG_VAL_ENUM
#define R_SERIAL2_READ__tr_ready__tr_ready__VAL REG_VAL_ENUM
#define R_SERIAL2_READ__rxd__rxd__VAL REG_VAL_VAL
#define R_SERIAL2_READ__overrun__overrun__VAL REG_VAL_ENUM
#define R_SERIAL2_READ__par_err__par_err__VAL REG_VAL_ENUM
#define R_SERIAL2_READ__framing_err__framing_err__VAL REG_VAL_ENUM
#define R_SERIAL2_READ__data_avail__data_avail__VAL REG_VAL_ENUM
#define R_SERIAL2_READ__data_in__data_in__VAL REG_VAL_VAL

#define R_SERIAL2_READ__xoff_detect__xoff_detect__no_xoff 0
#define R_SERIAL2_READ__xoff_detect__xoff_detect__xoff 1
#define R_SERIAL2_READ__cts___cts___active 0
#define R_SERIAL2_READ__cts___cts___inactive 1
#define R_SERIAL2_READ__tr_ready__tr_ready__full 0
#define R_SERIAL2_READ__tr_ready__tr_ready__ready 1
#define R_SERIAL2_READ__overrun__overrun__no 0
#define R_SERIAL2_READ__overrun__overrun__yes 1
#define R_SERIAL2_READ__par_err__par_err__no 0
#define R_SERIAL2_READ__par_err__par_err__yes 1
#define R_SERIAL2_READ__framing_err__framing_err__no 0
#define R_SERIAL2_READ__framing_err__framing_err__yes 1
#define R_SERIAL2_READ__data_avail__data_avail__no 0
#define R_SERIAL2_READ__data_avail__data_avail__yes 1

#endif

/*
 *  R_SERIAL2_REC_CTRL
 *  - type:  WO
 *  - addr:  0xb0000072
 *  - group: Serial port registers
 */

#if USE_GROUP__Serial_port_registers

#define R_SERIAL2_REC_CTRL__ADDR      (REG_TYPECAST_BYTE  0xb0000072)

#ifndef REG_NO_SHADOW
#define R_SERIAL2_REC_CTRL__SADDR     (REG_STYPECAST_BYTE (reg_shadow__hwregs.R_SERIAL2_CTRL + 2))
#define R_SERIAL2_REC_CTRL__IADDR     (REG_STYPECAST_BYTE (reg_initiated__hwregs.R_SERIAL2_CTRL + 2))
#else /* REG_NO_SHADOW */
#define R_SERIAL2_REC_CTRL__SADDR     (REG_STYPECAST_BYTE (&reg_shadow__hwregs))
#define R_SERIAL2_REC_CTRL__IADDR     (REG_STYPECAST_BYTE (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_SERIAL2_REC_CTRL__STYPECAST REG_STYPECAST_BYTE
#define R_SERIAL2_REC_CTRL__SVAL      REG_SVAL_SHADOW
#define R_SERIAL2_REC_CTRL__SVAL_I    REG_SVAL_I_SHADOW
#define R_SERIAL2_REC_CTRL__TYPECAST  REG_TYPECAST_BYTE
#define R_SERIAL2_REC_CTRL__TYPE      (REG_BYTE)
#define R_SERIAL2_REC_CTRL__GET       REG_GET_WO
#define R_SERIAL2_REC_CTRL__IGET      REG_IGET_WO
#define R_SERIAL2_REC_CTRL__SET       REG_SET_WO
#define R_SERIAL2_REC_CTRL__ISET      REG_ISET_WO
#define R_SERIAL2_REC_CTRL__SET_VAL   REG_SET_VAL_WO
#define R_SERIAL2_REC_CTRL__EQL       REG_EQL_WO
#define R_SERIAL2_REC_CTRL__IEQL      REG_IEQL_WO
#define R_SERIAL2_REC_CTRL__RD        REG_RD_WO
#define R_SERIAL2_REC_CTRL__IRD       REG_IRD_WO
#define R_SERIAL2_REC_CTRL__WR        REG_WR_WO
#define R_SERIAL2_REC_CTRL__IWR       REG_IWR_WO

#define R_SERIAL2_REC_CTRL__WRITE(addr,value) \
  (*(addr) = (value))

#define R_SERIAL2_REC_CTRL__dma_err__dma_err__MASK 0x00000080U
#define R_SERIAL2_REC_CTRL__rec_enable__rec_enable__MASK 0x00000040U
#define R_SERIAL2_REC_CTRL__rts___rts___MASK 0x00000020U
#define R_SERIAL2_REC_CTRL__sampling__sampling__MASK 0x00000010U
#define R_SERIAL2_REC_CTRL__rec_stick_par__rec_stick_par__MASK 0x00000008U
#define R_SERIAL2_REC_CTRL__rec_par__rec_par__MASK 0x00000004U
#define R_SERIAL2_REC_CTRL__rec_par_en__rec_par_en__MASK 0x00000002U
#define R_SERIAL2_REC_CTRL__rec_bitnr__rec_bitnr__MASK 0x00000001U

#define R_SERIAL2_REC_CTRL__dma_err__MAX 0x1
#define R_SERIAL2_REC_CTRL__rec_enable__MAX 0x1
#define R_SERIAL2_REC_CTRL__rts___MAX 0x1
#define R_SERIAL2_REC_CTRL__sampling__MAX 0x1
#define R_SERIAL2_REC_CTRL__rec_stick_par__MAX 0x1
#define R_SERIAL2_REC_CTRL__rec_par__MAX 0x1
#define R_SERIAL2_REC_CTRL__rec_par_en__MAX 0x1
#define R_SERIAL2_REC_CTRL__rec_bitnr__MAX 0x1

#define R_SERIAL2_REC_CTRL__dma_err__MIN 0
#define R_SERIAL2_REC_CTRL__rec_enable__MIN 0
#define R_SERIAL2_REC_CTRL__rts___MIN 0
#define R_SERIAL2_REC_CTRL__sampling__MIN 0
#define R_SERIAL2_REC_CTRL__rec_stick_par__MIN 0
#define R_SERIAL2_REC_CTRL__rec_par__MIN 0
#define R_SERIAL2_REC_CTRL__rec_par_en__MIN 0
#define R_SERIAL2_REC_CTRL__rec_bitnr__MIN 0

#define R_SERIAL2_REC_CTRL__dma_err__BITNR 7
#define R_SERIAL2_REC_CTRL__rec_enable__BITNR 6
#define R_SERIAL2_REC_CTRL__rts___BITNR 5
#define R_SERIAL2_REC_CTRL__sampling__BITNR 4
#define R_SERIAL2_REC_CTRL__rec_stick_par__BITNR 3
#define R_SERIAL2_REC_CTRL__rec_par__BITNR 2
#define R_SERIAL2_REC_CTRL__rec_par_en__BITNR 1
#define R_SERIAL2_REC_CTRL__rec_bitnr__BITNR 0

#define R_SERIAL2_REC_CTRL__dma_err__dma_err__VAL REG_VAL_ENUM
#define R_SERIAL2_REC_CTRL__rec_enable__rec_enable__VAL REG_VAL_ENUM
#define R_SERIAL2_REC_CTRL__rts___rts___VAL REG_VAL_ENUM
#define R_SERIAL2_REC_CTRL__sampling__sampling__VAL REG_VAL_ENUM
#define R_SERIAL2_REC_CTRL__rec_stick_par__rec_stick_par__VAL REG_VAL_ENUM
#define R_SERIAL2_REC_CTRL__rec_par__rec_par__VAL REG_VAL_ENUM
#define R_SERIAL2_REC_CTRL__rec_par_en__rec_par_en__VAL REG_VAL_ENUM
#define R_SERIAL2_REC_CTRL__rec_bitnr__rec_bitnr__VAL REG_VAL_ENUM

#define R_SERIAL2_REC_CTRL__dma_err__dma_err__ignore 1
#define R_SERIAL2_REC_CTRL__dma_err__dma_err__stop 0
#define R_SERIAL2_REC_CTRL__rec_enable__rec_enable__disable 0
#define R_SERIAL2_REC_CTRL__rec_enable__rec_enable__enable 1
#define R_SERIAL2_REC_CTRL__rts___rts___active 0
#define R_SERIAL2_REC_CTRL__rts___rts___inactive 1
#define R_SERIAL2_REC_CTRL__sampling__sampling__majority 1
#define R_SERIAL2_REC_CTRL__sampling__sampling__middle 0
#define R_SERIAL2_REC_CTRL__rec_stick_par__rec_stick_par__normal 0
#define R_SERIAL2_REC_CTRL__rec_stick_par__rec_stick_par__stick 1
#define R_SERIAL2_REC_CTRL__rec_par__rec_par__even 0
#define R_SERIAL2_REC_CTRL__rec_par__rec_par__odd 1
#define R_SERIAL2_REC_CTRL__rec_par_en__rec_par_en__disable 0
#define R_SERIAL2_REC_CTRL__rec_par_en__rec_par_en__enable 1
#define R_SERIAL2_REC_CTRL__rec_bitnr__rec_bitnr__rec_7bit 1
#define R_SERIAL2_REC_CTRL__rec_bitnr__rec_bitnr__rec_8bit 0

#endif

/*
 *  R_SERIAL2_REC_DATA
 *  - type:  RO
 *  - addr:  0xb0000070
 *  - group: Serial port registers
 */

#if USE_GROUP__Serial_port_registers

#define R_SERIAL2_REC_DATA__ADDR      (REG_TYPECAST_BYTE  0xb0000070)
#define R_SERIAL2_REC_DATA__SVAL      REG_SVAL_SHADOW
#define R_SERIAL2_REC_DATA__SVAL_I    REG_SVAL_I_SHADOW
#define R_SERIAL2_REC_DATA__TYPECAST  REG_TYPECAST_BYTE
#define R_SERIAL2_REC_DATA__TYPE      (REG_BYTE)
#define R_SERIAL2_REC_DATA__GET       REG_GET_RO
#define R_SERIAL2_REC_DATA__IGET      REG_IGET_RO
#define R_SERIAL2_REC_DATA__SET       REG_SET_RO
#define R_SERIAL2_REC_DATA__ISET      REG_ISET_RO
#define R_SERIAL2_REC_DATA__SET_VAL   REG_SET_VAL_RO
#define R_SERIAL2_REC_DATA__EQL       REG_EQL_RO
#define R_SERIAL2_REC_DATA__IEQL      REG_IEQL_RO
#define R_SERIAL2_REC_DATA__RD        REG_RD_RO
#define R_SERIAL2_REC_DATA__IRD       REG_IRD_RO
#define R_SERIAL2_REC_DATA__WR        REG_WR_RO
#define R_SERIAL2_REC_DATA__IWR       REG_IWR_RO

#define R_SERIAL2_REC_DATA__READ(addr) \
  (*(addr))

#define R_SERIAL2_REC_DATA__data_in__data_in__MASK 0x000000ffU

#define R_SERIAL2_REC_DATA__data_in__MAX 0xff

#define R_SERIAL2_REC_DATA__data_in__MIN 0

#define R_SERIAL2_REC_DATA__data_in__BITNR 0

#define R_SERIAL2_REC_DATA__data_in__data_in__VAL REG_VAL_VAL


#endif

/*
 *  R_SERIAL2_STATUS
 *  - type:  RO
 *  - addr:  0xb0000071
 *  - group: Serial port registers
 */

#if USE_GROUP__Serial_port_registers

#define R_SERIAL2_STATUS__ADDR      (REG_TYPECAST_BYTE  0xb0000071)
#define R_SERIAL2_STATUS__SVAL      REG_SVAL_SHADOW
#define R_SERIAL2_STATUS__SVAL_I    REG_SVAL_I_SHADOW
#define R_SERIAL2_STATUS__TYPECAST  REG_TYPECAST_BYTE
#define R_SERIAL2_STATUS__TYPE      (REG_BYTE)
#define R_SERIAL2_STATUS__GET       REG_GET_RO
#define R_SERIAL2_STATUS__IGET      REG_IGET_RO
#define R_SERIAL2_STATUS__SET       REG_SET_RO
#define R_SERIAL2_STATUS__ISET      REG_ISET_RO
#define R_SERIAL2_STATUS__SET_VAL   REG_SET_VAL_RO
#define R_SERIAL2_STATUS__EQL       REG_EQL_RO
#define R_SERIAL2_STATUS__IEQL      REG_IEQL_RO
#define R_SERIAL2_STATUS__RD        REG_RD_RO
#define R_SERIAL2_STATUS__IRD       REG_IRD_RO
#define R_SERIAL2_STATUS__WR        REG_WR_RO
#define R_SERIAL2_STATUS__IWR       REG_IWR_RO

#define R_SERIAL2_STATUS__READ(addr) \
  (*(addr))

#define R_SERIAL2_STATUS__xoff_detect__xoff_detect__MASK 0x00000080U
#define R_SERIAL2_STATUS__cts___cts___MASK 0x00000040U
#define R_SERIAL2_STATUS__tr_ready__tr_ready__MASK 0x00000020U
#define R_SERIAL2_STATUS__rxd__rxd__MASK 0x00000010U
#define R_SERIAL2_STATUS__overrun__overrun__MASK 0x00000008U
#define R_SERIAL2_STATUS__par_err__par_err__MASK 0x00000004U
#define R_SERIAL2_STATUS__framing_err__framing_err__MASK 0x00000002U
#define R_SERIAL2_STATUS__data_avail__data_avail__MASK 0x00000001U

#define R_SERIAL2_STATUS__xoff_detect__MAX 0x1
#define R_SERIAL2_STATUS__cts___MAX 0x1
#define R_SERIAL2_STATUS__tr_ready__MAX 0x1
#define R_SERIAL2_STATUS__rxd__MAX 0x1
#define R_SERIAL2_STATUS__overrun__MAX 0x1
#define R_SERIAL2_STATUS__par_err__MAX 0x1
#define R_SERIAL2_STATUS__framing_err__MAX 0x1
#define R_SERIAL2_STATUS__data_avail__MAX 0x1

#define R_SERIAL2_STATUS__xoff_detect__MIN 0
#define R_SERIAL2_STATUS__cts___MIN 0
#define R_SERIAL2_STATUS__tr_ready__MIN 0
#define R_SERIAL2_STATUS__rxd__MIN 0
#define R_SERIAL2_STATUS__overrun__MIN 0
#define R_SERIAL2_STATUS__par_err__MIN 0
#define R_SERIAL2_STATUS__framing_err__MIN 0
#define R_SERIAL2_STATUS__data_avail__MIN 0

#define R_SERIAL2_STATUS__xoff_detect__BITNR 7
#define R_SERIAL2_STATUS__cts___BITNR 6
#define R_SERIAL2_STATUS__tr_ready__BITNR 5
#define R_SERIAL2_STATUS__rxd__BITNR 4
#define R_SERIAL2_STATUS__overrun__BITNR 3
#define R_SERIAL2_STATUS__par_err__BITNR 2
#define R_SERIAL2_STATUS__framing_err__BITNR 1
#define R_SERIAL2_STATUS__data_avail__BITNR 0

#define R_SERIAL2_STATUS__xoff_detect__xoff_detect__VAL REG_VAL_ENUM
#define R_SERIAL2_STATUS__cts___cts___VAL REG_VAL_ENUM
#define R_SERIAL2_STATUS__tr_ready__tr_ready__VAL REG_VAL_ENUM
#define R_SERIAL2_STATUS__rxd__rxd__VAL REG_VAL_VAL
#define R_SERIAL2_STATUS__overrun__overrun__VAL REG_VAL_ENUM
#define R_SERIAL2_STATUS__par_err__par_err__VAL REG_VAL_ENUM
#define R_SERIAL2_STATUS__framing_err__framing_err__VAL REG_VAL_ENUM
#define R_SERIAL2_STATUS__data_avail__data_avail__VAL REG_VAL_ENUM

#define R_SERIAL2_STATUS__xoff_detect__xoff_detect__no_xoff 0
#define R_SERIAL2_STATUS__xoff_detect__xoff_detect__xoff 1
#define R_SERIAL2_STATUS__cts___cts___active 0
#define R_SERIAL2_STATUS__cts___cts___inactive 1
#define R_SERIAL2_STATUS__tr_ready__tr_ready__full 0
#define R_SERIAL2_STATUS__tr_ready__tr_ready__ready 1
#define R_SERIAL2_STATUS__overrun__overrun__no 0
#define R_SERIAL2_STATUS__overrun__overrun__yes 1
#define R_SERIAL2_STATUS__par_err__par_err__no 0
#define R_SERIAL2_STATUS__par_err__par_err__yes 1
#define R_SERIAL2_STATUS__framing_err__framing_err__no 0
#define R_SERIAL2_STATUS__framing_err__framing_err__yes 1
#define R_SERIAL2_STATUS__data_avail__data_avail__no 0
#define R_SERIAL2_STATUS__data_avail__data_avail__yes 1

#endif

/*
 *  R_SERIAL2_TR_CTRL
 *  - type:  WO
 *  - addr:  0xb0000071
 *  - group: Serial port registers
 */

#if USE_GROUP__Serial_port_registers

#define R_SERIAL2_TR_CTRL__ADDR      (REG_TYPECAST_BYTE  0xb0000071)

#ifndef REG_NO_SHADOW
#define R_SERIAL2_TR_CTRL__SADDR     (REG_STYPECAST_BYTE (reg_shadow__hwregs.R_SERIAL2_CTRL + 1))
#define R_SERIAL2_TR_CTRL__IADDR     (REG_STYPECAST_BYTE (reg_initiated__hwregs.R_SERIAL2_CTRL + 1))
#else /* REG_NO_SHADOW */
#define R_SERIAL2_TR_CTRL__SADDR     (REG_STYPECAST_BYTE (&reg_shadow__hwregs))
#define R_SERIAL2_TR_CTRL__IADDR     (REG_STYPECAST_BYTE (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_SERIAL2_TR_CTRL__STYPECAST REG_STYPECAST_BYTE
#define R_SERIAL2_TR_CTRL__SVAL      REG_SVAL_SHADOW
#define R_SERIAL2_TR_CTRL__SVAL_I    REG_SVAL_I_SHADOW
#define R_SERIAL2_TR_CTRL__TYPECAST  REG_TYPECAST_BYTE
#define R_SERIAL2_TR_CTRL__TYPE      (REG_BYTE)
#define R_SERIAL2_TR_CTRL__GET       REG_GET_WO
#define R_SERIAL2_TR_CTRL__IGET      REG_IGET_WO
#define R_SERIAL2_TR_CTRL__SET       REG_SET_WO
#define R_SERIAL2_TR_CTRL__ISET      REG_ISET_WO
#define R_SERIAL2_TR_CTRL__SET_VAL   REG_SET_VAL_WO
#define R_SERIAL2_TR_CTRL__EQL       REG_EQL_WO
#define R_SERIAL2_TR_CTRL__IEQL      REG_IEQL_WO
#define R_SERIAL2_TR_CTRL__RD        REG_RD_WO
#define R_SERIAL2_TR_CTRL__IRD       REG_IRD_WO
#define R_SERIAL2_TR_CTRL__WR        REG_WR_WO
#define R_SERIAL2_TR_CTRL__IWR       REG_IWR_WO

#define R_SERIAL2_TR_CTRL__WRITE(addr,value) \
  (*(addr) = (value))

#define R_SERIAL2_TR_CTRL__txd__txd__MASK 0x00000080U
#define R_SERIAL2_TR_CTRL__tr_enable__tr_enable__MASK 0x00000040U
#define R_SERIAL2_TR_CTRL__auto_cts__auto_cts__MASK 0x00000020U
#define R_SERIAL2_TR_CTRL__stop_bits__stop_bits__MASK 0x00000010U
#define R_SERIAL2_TR_CTRL__tr_stick_par__tr_stick_par__MASK 0x00000008U
#define R_SERIAL2_TR_CTRL__tr_par__tr_par__MASK 0x00000004U
#define R_SERIAL2_TR_CTRL__tr_par_en__tr_par_en__MASK 0x00000002U
#define R_SERIAL2_TR_CTRL__tr_bitnr__tr_bitnr__MASK 0x00000001U

#define R_SERIAL2_TR_CTRL__txd__MAX 0x1
#define R_SERIAL2_TR_CTRL__tr_enable__MAX 0x1
#define R_SERIAL2_TR_CTRL__auto_cts__MAX 0x1
#define R_SERIAL2_TR_CTRL__stop_bits__MAX 0x1
#define R_SERIAL2_TR_CTRL__tr_stick_par__MAX 0x1
#define R_SERIAL2_TR_CTRL__tr_par__MAX 0x1
#define R_SERIAL2_TR_CTRL__tr_par_en__MAX 0x1
#define R_SERIAL2_TR_CTRL__tr_bitnr__MAX 0x1

#define R_SERIAL2_TR_CTRL__txd__MIN 0
#define R_SERIAL2_TR_CTRL__tr_enable__MIN 0
#define R_SERIAL2_TR_CTRL__auto_cts__MIN 0
#define R_SERIAL2_TR_CTRL__stop_bits__MIN 0
#define R_SERIAL2_TR_CTRL__tr_stick_par__MIN 0
#define R_SERIAL2_TR_CTRL__tr_par__MIN 0
#define R_SERIAL2_TR_CTRL__tr_par_en__MIN 0
#define R_SERIAL2_TR_CTRL__tr_bitnr__MIN 0

#define R_SERIAL2_TR_CTRL__txd__BITNR 7
#define R_SERIAL2_TR_CTRL__tr_enable__BITNR 6
#define R_SERIAL2_TR_CTRL__auto_cts__BITNR 5
#define R_SERIAL2_TR_CTRL__stop_bits__BITNR 4
#define R_SERIAL2_TR_CTRL__tr_stick_par__BITNR 3
#define R_SERIAL2_TR_CTRL__tr_par__BITNR 2
#define R_SERIAL2_TR_CTRL__tr_par_en__BITNR 1
#define R_SERIAL2_TR_CTRL__tr_bitnr__BITNR 0

#define R_SERIAL2_TR_CTRL__txd__txd__VAL REG_VAL_VAL
#define R_SERIAL2_TR_CTRL__tr_enable__tr_enable__VAL REG_VAL_ENUM
#define R_SERIAL2_TR_CTRL__auto_cts__auto_cts__VAL REG_VAL_ENUM
#define R_SERIAL2_TR_CTRL__stop_bits__stop_bits__VAL REG_VAL_ENUM
#define R_SERIAL2_TR_CTRL__tr_stick_par__tr_stick_par__VAL REG_VAL_ENUM
#define R_SERIAL2_TR_CTRL__tr_par__tr_par__VAL REG_VAL_ENUM
#define R_SERIAL2_TR_CTRL__tr_par_en__tr_par_en__VAL REG_VAL_ENUM
#define R_SERIAL2_TR_CTRL__tr_bitnr__tr_bitnr__VAL REG_VAL_ENUM

#define R_SERIAL2_TR_CTRL__tr_enable__tr_enable__disable 0
#define R_SERIAL2_TR_CTRL__tr_enable__tr_enable__enable 1
#define R_SERIAL2_TR_CTRL__auto_cts__auto_cts__active 1
#define R_SERIAL2_TR_CTRL__auto_cts__auto_cts__disabled 0
#define R_SERIAL2_TR_CTRL__stop_bits__stop_bits__one_bit 0
#define R_SERIAL2_TR_CTRL__stop_bits__stop_bits__two_bits 1
#define R_SERIAL2_TR_CTRL__tr_stick_par__tr_stick_par__normal 0
#define R_SERIAL2_TR_CTRL__tr_stick_par__tr_stick_par__stick 1
#define R_SERIAL2_TR_CTRL__tr_par__tr_par__even 0
#define R_SERIAL2_TR_CTRL__tr_par__tr_par__odd 1
#define R_SERIAL2_TR_CTRL__tr_par_en__tr_par_en__disable 0
#define R_SERIAL2_TR_CTRL__tr_par_en__tr_par_en__enable 1
#define R_SERIAL2_TR_CTRL__tr_bitnr__tr_bitnr__tr_7bit 1
#define R_SERIAL2_TR_CTRL__tr_bitnr__tr_bitnr__tr_8bit 0

#endif

/*
 *  R_SERIAL2_TR_DATA
 *  - type:  WO
 *  - addr:  0xb0000070
 *  - group: Serial port registers
 */

#if USE_GROUP__Serial_port_registers

#define R_SERIAL2_TR_DATA__ADDR      (REG_TYPECAST_BYTE  0xb0000070)

#ifndef REG_NO_SHADOW
#define R_SERIAL2_TR_DATA__SADDR     (REG_STYPECAST_BYTE (reg_shadow__hwregs.R_SERIAL2_CTRL + 0))
#define R_SERIAL2_TR_DATA__IADDR     (REG_STYPECAST_BYTE (reg_initiated__hwregs.R_SERIAL2_CTRL + 0))
#else /* REG_NO_SHADOW */
#define R_SERIAL2_TR_DATA__SADDR     (REG_STYPECAST_BYTE (&reg_shadow__hwregs))
#define R_SERIAL2_TR_DATA__IADDR     (REG_STYPECAST_BYTE (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_SERIAL2_TR_DATA__STYPECAST REG_STYPECAST_BYTE
#define R_SERIAL2_TR_DATA__SVAL      REG_SVAL_SHADOW
#define R_SERIAL2_TR_DATA__SVAL_I    REG_SVAL_I_SHADOW
#define R_SERIAL2_TR_DATA__TYPECAST  REG_TYPECAST_BYTE
#define R_SERIAL2_TR_DATA__TYPE      (REG_BYTE)
#define R_SERIAL2_TR_DATA__GET       REG_GET_WO
#define R_SERIAL2_TR_DATA__IGET      REG_IGET_WO
#define R_SERIAL2_TR_DATA__SET       REG_SET_WO
#define R_SERIAL2_TR_DATA__ISET      REG_ISET_WO
#define R_SERIAL2_TR_DATA__SET_VAL   REG_SET_VAL_WO
#define R_SERIAL2_TR_DATA__EQL       REG_EQL_WO
#define R_SERIAL2_TR_DATA__IEQL      REG_IEQL_WO
#define R_SERIAL2_TR_DATA__RD        REG_RD_WO
#define R_SERIAL2_TR_DATA__IRD       REG_IRD_WO
#define R_SERIAL2_TR_DATA__WR        REG_WR_WO
#define R_SERIAL2_TR_DATA__IWR       REG_IWR_WO

#define R_SERIAL2_TR_DATA__WRITE(addr,value) \
  (*(addr) = (value))

#define R_SERIAL2_TR_DATA__data_out__data_out__MASK 0x000000ffU

#define R_SERIAL2_TR_DATA__data_out__MAX 0xff

#define R_SERIAL2_TR_DATA__data_out__MIN 0

#define R_SERIAL2_TR_DATA__data_out__BITNR 0

#define R_SERIAL2_TR_DATA__data_out__data_out__VAL REG_VAL_VAL


#endif

/*
 *  R_SERIAL2_XOFF
 *  - type:  WO
 *  - addr:  0xb0000074
 *  - group: Serial port registers
 */

#if USE_GROUP__Serial_port_registers

#define R_SERIAL2_XOFF__ADDR      (REG_TYPECAST_UDWORD  0xb0000074)

#ifndef REG_NO_SHADOW
#define R_SERIAL2_XOFF__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_SERIAL2_XOFF + 0))
#define R_SERIAL2_XOFF__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_SERIAL2_XOFF + 0))
#else /* REG_NO_SHADOW */
#define R_SERIAL2_XOFF__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_SERIAL2_XOFF__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_SERIAL2_XOFF__STYPECAST REG_STYPECAST_UDWORD
#define R_SERIAL2_XOFF__SVAL      REG_SVAL_SHADOW
#define R_SERIAL2_XOFF__SVAL_I    REG_SVAL_I_SHADOW
#define R_SERIAL2_XOFF__TYPECAST  REG_TYPECAST_UDWORD
#define R_SERIAL2_XOFF__TYPE      (REG_UDWORD)
#define R_SERIAL2_XOFF__GET       REG_GET_WO
#define R_SERIAL2_XOFF__IGET      REG_IGET_WO
#define R_SERIAL2_XOFF__SET       REG_SET_WO
#define R_SERIAL2_XOFF__ISET      REG_ISET_WO
#define R_SERIAL2_XOFF__SET_VAL   REG_SET_VAL_WO
#define R_SERIAL2_XOFF__EQL       REG_EQL_WO
#define R_SERIAL2_XOFF__IEQL      REG_IEQL_WO
#define R_SERIAL2_XOFF__RD        REG_RD_WO
#define R_SERIAL2_XOFF__IRD       REG_IRD_WO
#define R_SERIAL2_XOFF__WR        REG_WR_WO
#define R_SERIAL2_XOFF__IWR       REG_IWR_WO

#define R_SERIAL2_XOFF__WRITE(addr,value) \
  (*(addr) = (value))

#define R_SERIAL2_XOFF__tx_stop__tx_stop__MASK 0x00000200U
#define R_SERIAL2_XOFF__auto_xoff__auto_xoff__MASK 0x00000100U
#define R_SERIAL2_XOFF__xoff_char__xoff_char__MASK 0x000000ffU

#define R_SERIAL2_XOFF__tx_stop__MAX 0x1
#define R_SERIAL2_XOFF__auto_xoff__MAX 0x1
#define R_SERIAL2_XOFF__xoff_char__MAX 0xff

#define R_SERIAL2_XOFF__tx_stop__MIN 0
#define R_SERIAL2_XOFF__auto_xoff__MIN 0
#define R_SERIAL2_XOFF__xoff_char__MIN 0

#define R_SERIAL2_XOFF__tx_stop__BITNR 9
#define R_SERIAL2_XOFF__auto_xoff__BITNR 8
#define R_SERIAL2_XOFF__xoff_char__BITNR 0

#define R_SERIAL2_XOFF__tx_stop__tx_stop__VAL REG_VAL_ENUM
#define R_SERIAL2_XOFF__auto_xoff__auto_xoff__VAL REG_VAL_ENUM
#define R_SERIAL2_XOFF__xoff_char__xoff_char__VAL REG_VAL_VAL

#define R_SERIAL2_XOFF__tx_stop__tx_stop__enable 0
#define R_SERIAL2_XOFF__tx_stop__tx_stop__stop 1
#define R_SERIAL2_XOFF__auto_xoff__auto_xoff__disable 0
#define R_SERIAL2_XOFF__auto_xoff__auto_xoff__enable 1

#endif

/*
 *  R_SERIAL3_BAUD
 *  - type:  WO
 *  - addr:  0xb000007b
 *  - group: Serial port registers
 */

#if USE_GROUP__Serial_port_registers

#define R_SERIAL3_BAUD__ADDR      (REG_TYPECAST_BYTE  0xb000007b)

#ifndef REG_NO_SHADOW
#define R_SERIAL3_BAUD__SADDR     (REG_STYPECAST_BYTE (reg_shadow__hwregs.R_SERIAL3_CTRL + 3))
#define R_SERIAL3_BAUD__IADDR     (REG_STYPECAST_BYTE (reg_initiated__hwregs.R_SERIAL3_CTRL + 3))
#else /* REG_NO_SHADOW */
#define R_SERIAL3_BAUD__SADDR     (REG_STYPECAST_BYTE (&reg_shadow__hwregs))
#define R_SERIAL3_BAUD__IADDR     (REG_STYPECAST_BYTE (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_SERIAL3_BAUD__STYPECAST REG_STYPECAST_BYTE
#define R_SERIAL3_BAUD__SVAL      REG_SVAL_SHADOW
#define R_SERIAL3_BAUD__SVAL_I    REG_SVAL_I_SHADOW
#define R_SERIAL3_BAUD__TYPECAST  REG_TYPECAST_BYTE
#define R_SERIAL3_BAUD__TYPE      (REG_BYTE)
#define R_SERIAL3_BAUD__GET       REG_GET_WO
#define R_SERIAL3_BAUD__IGET      REG_IGET_WO
#define R_SERIAL3_BAUD__SET       REG_SET_WO
#define R_SERIAL3_BAUD__ISET      REG_ISET_WO
#define R_SERIAL3_BAUD__SET_VAL   REG_SET_VAL_WO
#define R_SERIAL3_BAUD__EQL       REG_EQL_WO
#define R_SERIAL3_BAUD__IEQL      REG_IEQL_WO
#define R_SERIAL3_BAUD__RD        REG_RD_WO
#define R_SERIAL3_BAUD__IRD       REG_IRD_WO
#define R_SERIAL3_BAUD__WR        REG_WR_WO
#define R_SERIAL3_BAUD__IWR       REG_IWR_WO

#define R_SERIAL3_BAUD__WRITE(addr,value) \
  (*(addr) = (value))

#define R_SERIAL3_BAUD__tr_baud__tr_baud__MASK 0x000000f0U
#define R_SERIAL3_BAUD__rec_baud__rec_baud__MASK 0x0000000fU

#define R_SERIAL3_BAUD__tr_baud__MAX 0xf
#define R_SERIAL3_BAUD__rec_baud__MAX 0xf

#define R_SERIAL3_BAUD__tr_baud__MIN 0
#define R_SERIAL3_BAUD__rec_baud__MIN 0

#define R_SERIAL3_BAUD__tr_baud__BITNR 4
#define R_SERIAL3_BAUD__rec_baud__BITNR 0

#define R_SERIAL3_BAUD__tr_baud__tr_baud__VAL REG_VAL_ENUM
#define R_SERIAL3_BAUD__rec_baud__rec_baud__VAL REG_VAL_ENUM

#define R_SERIAL3_BAUD__tr_baud__tr_baud__c115k2Hz 9
#define R_SERIAL3_BAUD__tr_baud__tr_baud__c1200Hz 2
#define R_SERIAL3_BAUD__tr_baud__tr_baud__c1843k2Hz 13
#define R_SERIAL3_BAUD__tr_baud__tr_baud__c19k2Hz 6
#define R_SERIAL3_BAUD__tr_baud__tr_baud__c230k4Hz 10
#define R_SERIAL3_BAUD__tr_baud__tr_baud__c2400Hz 3
#define R_SERIAL3_BAUD__tr_baud__tr_baud__c300Hz 0
#define R_SERIAL3_BAUD__tr_baud__tr_baud__c38k4Hz 7
#define R_SERIAL3_BAUD__tr_baud__tr_baud__c460k8Hz 11
#define R_SERIAL3_BAUD__tr_baud__tr_baud__c4800Hz 4
#define R_SERIAL3_BAUD__tr_baud__tr_baud__c57k6Hz 8
#define R_SERIAL3_BAUD__tr_baud__tr_baud__c600Hz 1
#define R_SERIAL3_BAUD__tr_baud__tr_baud__c6250kHz 14
#define R_SERIAL3_BAUD__tr_baud__tr_baud__c921k6Hz 12
#define R_SERIAL3_BAUD__tr_baud__tr_baud__c9600Hz 5
#define R_SERIAL3_BAUD__rec_baud__rec_baud__c115k2Hz 9
#define R_SERIAL3_BAUD__rec_baud__rec_baud__c1200Hz 2
#define R_SERIAL3_BAUD__rec_baud__rec_baud__c1843k2Hz 13
#define R_SERIAL3_BAUD__rec_baud__rec_baud__c19k2Hz 6
#define R_SERIAL3_BAUD__rec_baud__rec_baud__c230k4Hz 10
#define R_SERIAL3_BAUD__rec_baud__rec_baud__c2400Hz 3
#define R_SERIAL3_BAUD__rec_baud__rec_baud__c300Hz 0
#define R_SERIAL3_BAUD__rec_baud__rec_baud__c38k4Hz 7
#define R_SERIAL3_BAUD__rec_baud__rec_baud__c460k8Hz 11
#define R_SERIAL3_BAUD__rec_baud__rec_baud__c4800Hz 4
#define R_SERIAL3_BAUD__rec_baud__rec_baud__c57k6Hz 8
#define R_SERIAL3_BAUD__rec_baud__rec_baud__c600Hz 1
#define R_SERIAL3_BAUD__rec_baud__rec_baud__c6250kHz 14
#define R_SERIAL3_BAUD__rec_baud__rec_baud__c921k6Hz 12
#define R_SERIAL3_BAUD__rec_baud__rec_baud__c9600Hz 5

#endif

/*
 *  R_SERIAL3_CTRL
 *  - type:  WO
 *  - addr:  0xb0000078
 *  - group: Serial port registers
 */

#if USE_GROUP__Serial_port_registers

#define R_SERIAL3_CTRL__ADDR      (REG_TYPECAST_UDWORD  0xb0000078)

#ifndef REG_NO_SHADOW
#define R_SERIAL3_CTRL__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_SERIAL3_CTRL + 0))
#define R_SERIAL3_CTRL__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_SERIAL3_CTRL + 0))
#else /* REG_NO_SHADOW */
#define R_SERIAL3_CTRL__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_SERIAL3_CTRL__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_SERIAL3_CTRL__STYPECAST REG_STYPECAST_UDWORD
#define R_SERIAL3_CTRL__SVAL      REG_SVAL_SHADOW
#define R_SERIAL3_CTRL__SVAL_I    REG_SVAL_I_SHADOW
#define R_SERIAL3_CTRL__TYPECAST  REG_TYPECAST_UDWORD
#define R_SERIAL3_CTRL__TYPE      (REG_UDWORD)
#define R_SERIAL3_CTRL__GET       REG_GET_WO
#define R_SERIAL3_CTRL__IGET      REG_IGET_WO
#define R_SERIAL3_CTRL__SET       REG_SET_WO
#define R_SERIAL3_CTRL__ISET      REG_ISET_WO
#define R_SERIAL3_CTRL__SET_VAL   REG_SET_VAL_WO
#define R_SERIAL3_CTRL__EQL       REG_EQL_WO
#define R_SERIAL3_CTRL__IEQL      REG_IEQL_WO
#define R_SERIAL3_CTRL__RD        REG_RD_WO
#define R_SERIAL3_CTRL__IRD       REG_IRD_WO
#define R_SERIAL3_CTRL__WR        REG_WR_WO
#define R_SERIAL3_CTRL__IWR       REG_IWR_WO

#define R_SERIAL3_CTRL__WRITE(addr,value) \
  (*(addr) = (value))

#define R_SERIAL3_CTRL__tr_baud__tr_baud__MASK 0xf0000000U
#define R_SERIAL3_CTRL__rec_baud__rec_baud__MASK 0x0f000000U
#define R_SERIAL3_CTRL__dma_err__dma_err__MASK 0x00800000U
#define R_SERIAL3_CTRL__rec_enable__rec_enable__MASK 0x00400000U
#define R_SERIAL3_CTRL__rts___rts___MASK 0x00200000U
#define R_SERIAL3_CTRL__sampling__sampling__MASK 0x00100000U
#define R_SERIAL3_CTRL__rec_stick_par__rec_stick_par__MASK 0x00080000U
#define R_SERIAL3_CTRL__rec_par__rec_par__MASK 0x00040000U
#define R_SERIAL3_CTRL__rec_par_en__rec_par_en__MASK 0x00020000U
#define R_SERIAL3_CTRL__rec_bitnr__rec_bitnr__MASK 0x00010000U
#define R_SERIAL3_CTRL__txd__txd__MASK 0x00008000U
#define R_SERIAL3_CTRL__tr_enable__tr_enable__MASK 0x00004000U
#define R_SERIAL3_CTRL__auto_cts__auto_cts__MASK 0x00002000U
#define R_SERIAL3_CTRL__stop_bits__stop_bits__MASK 0x00001000U
#define R_SERIAL3_CTRL__tr_stick_par__tr_stick_par__MASK 0x00000800U
#define R_SERIAL3_CTRL__tr_par__tr_par__MASK 0x00000400U
#define R_SERIAL3_CTRL__tr_par_en__tr_par_en__MASK 0x00000200U
#define R_SERIAL3_CTRL__tr_bitnr__tr_bitnr__MASK 0x00000100U
#define R_SERIAL3_CTRL__data_out__data_out__MASK 0x000000ffU

#define R_SERIAL3_CTRL__tr_baud__MAX 0xf
#define R_SERIAL3_CTRL__rec_baud__MAX 0xf
#define R_SERIAL3_CTRL__dma_err__MAX 0x1
#define R_SERIAL3_CTRL__rec_enable__MAX 0x1
#define R_SERIAL3_CTRL__rts___MAX 0x1
#define R_SERIAL3_CTRL__sampling__MAX 0x1
#define R_SERIAL3_CTRL__rec_stick_par__MAX 0x1
#define R_SERIAL3_CTRL__rec_par__MAX 0x1
#define R_SERIAL3_CTRL__rec_par_en__MAX 0x1
#define R_SERIAL3_CTRL__rec_bitnr__MAX 0x1
#define R_SERIAL3_CTRL__txd__MAX 0x1
#define R_SERIAL3_CTRL__tr_enable__MAX 0x1
#define R_SERIAL3_CTRL__auto_cts__MAX 0x1
#define R_SERIAL3_CTRL__stop_bits__MAX 0x1
#define R_SERIAL3_CTRL__tr_stick_par__MAX 0x1
#define R_SERIAL3_CTRL__tr_par__MAX 0x1
#define R_SERIAL3_CTRL__tr_par_en__MAX 0x1
#define R_SERIAL3_CTRL__tr_bitnr__MAX 0x1
#define R_SERIAL3_CTRL__data_out__MAX 0xff

#define R_SERIAL3_CTRL__tr_baud__MIN 0
#define R_SERIAL3_CTRL__rec_baud__MIN 0
#define R_SERIAL3_CTRL__dma_err__MIN 0
#define R_SERIAL3_CTRL__rec_enable__MIN 0
#define R_SERIAL3_CTRL__rts___MIN 0
#define R_SERIAL3_CTRL__sampling__MIN 0
#define R_SERIAL3_CTRL__rec_stick_par__MIN 0
#define R_SERIAL3_CTRL__rec_par__MIN 0
#define R_SERIAL3_CTRL__rec_par_en__MIN 0
#define R_SERIAL3_CTRL__rec_bitnr__MIN 0
#define R_SERIAL3_CTRL__txd__MIN 0
#define R_SERIAL3_CTRL__tr_enable__MIN 0
#define R_SERIAL3_CTRL__auto_cts__MIN 0
#define R_SERIAL3_CTRL__stop_bits__MIN 0
#define R_SERIAL3_CTRL__tr_stick_par__MIN 0
#define R_SERIAL3_CTRL__tr_par__MIN 0
#define R_SERIAL3_CTRL__tr_par_en__MIN 0
#define R_SERIAL3_CTRL__tr_bitnr__MIN 0
#define R_SERIAL3_CTRL__data_out__MIN 0

#define R_SERIAL3_CTRL__tr_baud__BITNR 28
#define R_SERIAL3_CTRL__rec_baud__BITNR 24
#define R_SERIAL3_CTRL__dma_err__BITNR 23
#define R_SERIAL3_CTRL__rec_enable__BITNR 22
#define R_SERIAL3_CTRL__rts___BITNR 21
#define R_SERIAL3_CTRL__sampling__BITNR 20
#define R_SERIAL3_CTRL__rec_stick_par__BITNR 19
#define R_SERIAL3_CTRL__rec_par__BITNR 18
#define R_SERIAL3_CTRL__rec_par_en__BITNR 17
#define R_SERIAL3_CTRL__rec_bitnr__BITNR 16
#define R_SERIAL3_CTRL__txd__BITNR 15
#define R_SERIAL3_CTRL__tr_enable__BITNR 14
#define R_SERIAL3_CTRL__auto_cts__BITNR 13
#define R_SERIAL3_CTRL__stop_bits__BITNR 12
#define R_SERIAL3_CTRL__tr_stick_par__BITNR 11
#define R_SERIAL3_CTRL__tr_par__BITNR 10
#define R_SERIAL3_CTRL__tr_par_en__BITNR 9
#define R_SERIAL3_CTRL__tr_bitnr__BITNR 8
#define R_SERIAL3_CTRL__data_out__BITNR 0

#define R_SERIAL3_CTRL__tr_baud__tr_baud__VAL REG_VAL_ENUM
#define R_SERIAL3_CTRL__rec_baud__rec_baud__VAL REG_VAL_ENUM
#define R_SERIAL3_CTRL__dma_err__dma_err__VAL REG_VAL_ENUM
#define R_SERIAL3_CTRL__rec_enable__rec_enable__VAL REG_VAL_ENUM
#define R_SERIAL3_CTRL__rts___rts___VAL REG_VAL_ENUM
#define R_SERIAL3_CTRL__sampling__sampling__VAL REG_VAL_ENUM
#define R_SERIAL3_CTRL__rec_stick_par__rec_stick_par__VAL REG_VAL_ENUM
#define R_SERIAL3_CTRL__rec_par__rec_par__VAL REG_VAL_ENUM
#define R_SERIAL3_CTRL__rec_par_en__rec_par_en__VAL REG_VAL_ENUM
#define R_SERIAL3_CTRL__rec_bitnr__rec_bitnr__VAL REG_VAL_ENUM
#define R_SERIAL3_CTRL__txd__txd__VAL REG_VAL_VAL
#define R_SERIAL3_CTRL__tr_enable__tr_enable__VAL REG_VAL_ENUM
#define R_SERIAL3_CTRL__auto_cts__auto_cts__VAL REG_VAL_ENUM
#define R_SERIAL3_CTRL__stop_bits__stop_bits__VAL REG_VAL_ENUM
#define R_SERIAL3_CTRL__tr_stick_par__tr_stick_par__VAL REG_VAL_ENUM
#define R_SERIAL3_CTRL__tr_par__tr_par__VAL REG_VAL_ENUM
#define R_SERIAL3_CTRL__tr_par_en__tr_par_en__VAL REG_VAL_ENUM
#define R_SERIAL3_CTRL__tr_bitnr__tr_bitnr__VAL REG_VAL_ENUM
#define R_SERIAL3_CTRL__data_out__data_out__VAL REG_VAL_VAL

#define R_SERIAL3_CTRL__tr_baud__tr_baud__c115k2Hz 9
#define R_SERIAL3_CTRL__tr_baud__tr_baud__c1200Hz 2
#define R_SERIAL3_CTRL__tr_baud__tr_baud__c1843k2Hz 13
#define R_SERIAL3_CTRL__tr_baud__tr_baud__c19k2Hz 6
#define R_SERIAL3_CTRL__tr_baud__tr_baud__c230k4Hz 10
#define R_SERIAL3_CTRL__tr_baud__tr_baud__c2400Hz 3
#define R_SERIAL3_CTRL__tr_baud__tr_baud__c300Hz 0
#define R_SERIAL3_CTRL__tr_baud__tr_baud__c38k4Hz 7
#define R_SERIAL3_CTRL__tr_baud__tr_baud__c460k8Hz 11
#define R_SERIAL3_CTRL__tr_baud__tr_baud__c4800Hz 4
#define R_SERIAL3_CTRL__tr_baud__tr_baud__c57k6Hz 8
#define R_SERIAL3_CTRL__tr_baud__tr_baud__c600Hz 1
#define R_SERIAL3_CTRL__tr_baud__tr_baud__c6250kHz 14
#define R_SERIAL3_CTRL__tr_baud__tr_baud__c921k6Hz 12
#define R_SERIAL3_CTRL__tr_baud__tr_baud__c9600Hz 5
#define R_SERIAL3_CTRL__rec_baud__rec_baud__c115k2Hz 9
#define R_SERIAL3_CTRL__rec_baud__rec_baud__c1200Hz 2
#define R_SERIAL3_CTRL__rec_baud__rec_baud__c1843k2Hz 13
#define R_SERIAL3_CTRL__rec_baud__rec_baud__c19k2Hz 6
#define R_SERIAL3_CTRL__rec_baud__rec_baud__c230k4Hz 10
#define R_SERIAL3_CTRL__rec_baud__rec_baud__c2400Hz 3
#define R_SERIAL3_CTRL__rec_baud__rec_baud__c300Hz 0
#define R_SERIAL3_CTRL__rec_baud__rec_baud__c38k4Hz 7
#define R_SERIAL3_CTRL__rec_baud__rec_baud__c460k8Hz 11
#define R_SERIAL3_CTRL__rec_baud__rec_baud__c4800Hz 4
#define R_SERIAL3_CTRL__rec_baud__rec_baud__c57k6Hz 8
#define R_SERIAL3_CTRL__rec_baud__rec_baud__c600Hz 1
#define R_SERIAL3_CTRL__rec_baud__rec_baud__c6250kHz 14
#define R_SERIAL3_CTRL__rec_baud__rec_baud__c921k6Hz 12
#define R_SERIAL3_CTRL__rec_baud__rec_baud__c9600Hz 5
#define R_SERIAL3_CTRL__dma_err__dma_err__ignore 1
#define R_SERIAL3_CTRL__dma_err__dma_err__stop 0
#define R_SERIAL3_CTRL__rec_enable__rec_enable__disable 0
#define R_SERIAL3_CTRL__rec_enable__rec_enable__enable 1
#define R_SERIAL3_CTRL__rts___rts___active 0
#define R_SERIAL3_CTRL__rts___rts___inactive 1
#define R_SERIAL3_CTRL__sampling__sampling__majority 1
#define R_SERIAL3_CTRL__sampling__sampling__middle 0
#define R_SERIAL3_CTRL__rec_stick_par__rec_stick_par__normal 0
#define R_SERIAL3_CTRL__rec_stick_par__rec_stick_par__stick 1
#define R_SERIAL3_CTRL__rec_par__rec_par__even 0
#define R_SERIAL3_CTRL__rec_par__rec_par__odd 1
#define R_SERIAL3_CTRL__rec_par_en__rec_par_en__disable 0
#define R_SERIAL3_CTRL__rec_par_en__rec_par_en__enable 1
#define R_SERIAL3_CTRL__rec_bitnr__rec_bitnr__rec_7bit 1
#define R_SERIAL3_CTRL__rec_bitnr__rec_bitnr__rec_8bit 0
#define R_SERIAL3_CTRL__tr_enable__tr_enable__disable 0
#define R_SERIAL3_CTRL__tr_enable__tr_enable__enable 1
#define R_SERIAL3_CTRL__auto_cts__auto_cts__active 1
#define R_SERIAL3_CTRL__auto_cts__auto_cts__disabled 0
#define R_SERIAL3_CTRL__stop_bits__stop_bits__one_bit 0
#define R_SERIAL3_CTRL__stop_bits__stop_bits__two_bits 1
#define R_SERIAL3_CTRL__tr_stick_par__tr_stick_par__normal 0
#define R_SERIAL3_CTRL__tr_stick_par__tr_stick_par__stick 1
#define R_SERIAL3_CTRL__tr_par__tr_par__even 0
#define R_SERIAL3_CTRL__tr_par__tr_par__odd 1
#define R_SERIAL3_CTRL__tr_par_en__tr_par_en__disable 0
#define R_SERIAL3_CTRL__tr_par_en__tr_par_en__enable 1
#define R_SERIAL3_CTRL__tr_bitnr__tr_bitnr__tr_7bit 1
#define R_SERIAL3_CTRL__tr_bitnr__tr_bitnr__tr_8bit 0

#endif

/*
 *  R_SERIAL3_READ
 *  - type:  RO
 *  - addr:  0xb0000078
 *  - group: Serial port registers
 */

#if USE_GROUP__Serial_port_registers

#define R_SERIAL3_READ__ADDR      (REG_TYPECAST_UDWORD  0xb0000078)
#define R_SERIAL3_READ__SVAL      REG_SVAL_SHADOW
#define R_SERIAL3_READ__SVAL_I    REG_SVAL_I_SHADOW
#define R_SERIAL3_READ__TYPECAST  REG_TYPECAST_UDWORD
#define R_SERIAL3_READ__TYPE      (REG_UDWORD)
#define R_SERIAL3_READ__GET       REG_GET_RO
#define R_SERIAL3_READ__IGET      REG_IGET_RO
#define R_SERIAL3_READ__SET       REG_SET_RO
#define R_SERIAL3_READ__ISET      REG_ISET_RO
#define R_SERIAL3_READ__SET_VAL   REG_SET_VAL_RO
#define R_SERIAL3_READ__EQL       REG_EQL_RO
#define R_SERIAL3_READ__IEQL      REG_IEQL_RO
#define R_SERIAL3_READ__RD        REG_RD_RO
#define R_SERIAL3_READ__IRD       REG_IRD_RO
#define R_SERIAL3_READ__WR        REG_WR_RO
#define R_SERIAL3_READ__IWR       REG_IWR_RO

#define R_SERIAL3_READ__READ(addr) \
  (*(addr))

#define R_SERIAL3_READ__xoff_detect__xoff_detect__MASK 0x00008000U
#define R_SERIAL3_READ__cts___cts___MASK 0x00004000U
#define R_SERIAL3_READ__tr_ready__tr_ready__MASK 0x00002000U
#define R_SERIAL3_READ__rxd__rxd__MASK 0x00001000U
#define R_SERIAL3_READ__overrun__overrun__MASK 0x00000800U
#define R_SERIAL3_READ__par_err__par_err__MASK 0x00000400U
#define R_SERIAL3_READ__framing_err__framing_err__MASK 0x00000200U
#define R_SERIAL3_READ__data_avail__data_avail__MASK 0x00000100U
#define R_SERIAL3_READ__data_in__data_in__MASK 0x000000ffU

#define R_SERIAL3_READ__xoff_detect__MAX 0x1
#define R_SERIAL3_READ__cts___MAX 0x1
#define R_SERIAL3_READ__tr_ready__MAX 0x1
#define R_SERIAL3_READ__rxd__MAX 0x1
#define R_SERIAL3_READ__overrun__MAX 0x1
#define R_SERIAL3_READ__par_err__MAX 0x1
#define R_SERIAL3_READ__framing_err__MAX 0x1
#define R_SERIAL3_READ__data_avail__MAX 0x1
#define R_SERIAL3_READ__data_in__MAX 0xff

#define R_SERIAL3_READ__xoff_detect__MIN 0
#define R_SERIAL3_READ__cts___MIN 0
#define R_SERIAL3_READ__tr_ready__MIN 0
#define R_SERIAL3_READ__rxd__MIN 0
#define R_SERIAL3_READ__overrun__MIN 0
#define R_SERIAL3_READ__par_err__MIN 0
#define R_SERIAL3_READ__framing_err__MIN 0
#define R_SERIAL3_READ__data_avail__MIN 0
#define R_SERIAL3_READ__data_in__MIN 0

#define R_SERIAL3_READ__xoff_detect__BITNR 15
#define R_SERIAL3_READ__cts___BITNR 14
#define R_SERIAL3_READ__tr_ready__BITNR 13
#define R_SERIAL3_READ__rxd__BITNR 12
#define R_SERIAL3_READ__overrun__BITNR 11
#define R_SERIAL3_READ__par_err__BITNR 10
#define R_SERIAL3_READ__framing_err__BITNR 9
#define R_SERIAL3_READ__data_avail__BITNR 8
#define R_SERIAL3_READ__data_in__BITNR 0

#define R_SERIAL3_READ__xoff_detect__xoff_detect__VAL REG_VAL_ENUM
#define R_SERIAL3_READ__cts___cts___VAL REG_VAL_ENUM
#define R_SERIAL3_READ__tr_ready__tr_ready__VAL REG_VAL_ENUM
#define R_SERIAL3_READ__rxd__rxd__VAL REG_VAL_VAL
#define R_SERIAL3_READ__overrun__overrun__VAL REG_VAL_ENUM
#define R_SERIAL3_READ__par_err__par_err__VAL REG_VAL_ENUM
#define R_SERIAL3_READ__framing_err__framing_err__VAL REG_VAL_ENUM
#define R_SERIAL3_READ__data_avail__data_avail__VAL REG_VAL_ENUM
#define R_SERIAL3_READ__data_in__data_in__VAL REG_VAL_VAL

#define R_SERIAL3_READ__xoff_detect__xoff_detect__no_xoff 0
#define R_SERIAL3_READ__xoff_detect__xoff_detect__xoff 1
#define R_SERIAL3_READ__cts___cts___active 0
#define R_SERIAL3_READ__cts___cts___inactive 1
#define R_SERIAL3_READ__tr_ready__tr_ready__full 0
#define R_SERIAL3_READ__tr_ready__tr_ready__ready 1
#define R_SERIAL3_READ__overrun__overrun__no 0
#define R_SERIAL3_READ__overrun__overrun__yes 1
#define R_SERIAL3_READ__par_err__par_err__no 0
#define R_SERIAL3_READ__par_err__par_err__yes 1
#define R_SERIAL3_READ__framing_err__framing_err__no 0
#define R_SERIAL3_READ__framing_err__framing_err__yes 1
#define R_SERIAL3_READ__data_avail__data_avail__no 0
#define R_SERIAL3_READ__data_avail__data_avail__yes 1

#endif

/*
 *  R_SERIAL3_REC_CTRL
 *  - type:  WO
 *  - addr:  0xb000007a
 *  - group: Serial port registers
 */

#if USE_GROUP__Serial_port_registers

#define R_SERIAL3_REC_CTRL__ADDR      (REG_TYPECAST_BYTE  0xb000007a)

#ifndef REG_NO_SHADOW
#define R_SERIAL3_REC_CTRL__SADDR     (REG_STYPECAST_BYTE (reg_shadow__hwregs.R_SERIAL3_CTRL + 2))
#define R_SERIAL3_REC_CTRL__IADDR     (REG_STYPECAST_BYTE (reg_initiated__hwregs.R_SERIAL3_CTRL + 2))
#else /* REG_NO_SHADOW */
#define R_SERIAL3_REC_CTRL__SADDR     (REG_STYPECAST_BYTE (&reg_shadow__hwregs))
#define R_SERIAL3_REC_CTRL__IADDR     (REG_STYPECAST_BYTE (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_SERIAL3_REC_CTRL__STYPECAST REG_STYPECAST_BYTE
#define R_SERIAL3_REC_CTRL__SVAL      REG_SVAL_SHADOW
#define R_SERIAL3_REC_CTRL__SVAL_I    REG_SVAL_I_SHADOW
#define R_SERIAL3_REC_CTRL__TYPECAST  REG_TYPECAST_BYTE
#define R_SERIAL3_REC_CTRL__TYPE      (REG_BYTE)
#define R_SERIAL3_REC_CTRL__GET       REG_GET_WO
#define R_SERIAL3_REC_CTRL__IGET      REG_IGET_WO
#define R_SERIAL3_REC_CTRL__SET       REG_SET_WO
#define R_SERIAL3_REC_CTRL__ISET      REG_ISET_WO
#define R_SERIAL3_REC_CTRL__SET_VAL   REG_SET_VAL_WO
#define R_SERIAL3_REC_CTRL__EQL       REG_EQL_WO
#define R_SERIAL3_REC_CTRL__IEQL      REG_IEQL_WO
#define R_SERIAL3_REC_CTRL__RD        REG_RD_WO
#define R_SERIAL3_REC_CTRL__IRD       REG_IRD_WO
#define R_SERIAL3_REC_CTRL__WR        REG_WR_WO
#define R_SERIAL3_REC_CTRL__IWR       REG_IWR_WO

#define R_SERIAL3_REC_CTRL__WRITE(addr,value) \
  (*(addr) = (value))

#define R_SERIAL3_REC_CTRL__dma_err__dma_err__MASK 0x00000080U
#define R_SERIAL3_REC_CTRL__rec_enable__rec_enable__MASK 0x00000040U
#define R_SERIAL3_REC_CTRL__rts___rts___MASK 0x00000020U
#define R_SERIAL3_REC_CTRL__sampling__sampling__MASK 0x00000010U
#define R_SERIAL3_REC_CTRL__rec_stick_par__rec_stick_par__MASK 0x00000008U
#define R_SERIAL3_REC_CTRL__rec_par__rec_par__MASK 0x00000004U
#define R_SERIAL3_REC_CTRL__rec_par_en__rec_par_en__MASK 0x00000002U
#define R_SERIAL3_REC_CTRL__rec_bitnr__rec_bitnr__MASK 0x00000001U

#define R_SERIAL3_REC_CTRL__dma_err__MAX 0x1
#define R_SERIAL3_REC_CTRL__rec_enable__MAX 0x1
#define R_SERIAL3_REC_CTRL__rts___MAX 0x1
#define R_SERIAL3_REC_CTRL__sampling__MAX 0x1
#define R_SERIAL3_REC_CTRL__rec_stick_par__MAX 0x1
#define R_SERIAL3_REC_CTRL__rec_par__MAX 0x1
#define R_SERIAL3_REC_CTRL__rec_par_en__MAX 0x1
#define R_SERIAL3_REC_CTRL__rec_bitnr__MAX 0x1

#define R_SERIAL3_REC_CTRL__dma_err__MIN 0
#define R_SERIAL3_REC_CTRL__rec_enable__MIN 0
#define R_SERIAL3_REC_CTRL__rts___MIN 0
#define R_SERIAL3_REC_CTRL__sampling__MIN 0
#define R_SERIAL3_REC_CTRL__rec_stick_par__MIN 0
#define R_SERIAL3_REC_CTRL__rec_par__MIN 0
#define R_SERIAL3_REC_CTRL__rec_par_en__MIN 0
#define R_SERIAL3_REC_CTRL__rec_bitnr__MIN 0

#define R_SERIAL3_REC_CTRL__dma_err__BITNR 7
#define R_SERIAL3_REC_CTRL__rec_enable__BITNR 6
#define R_SERIAL3_REC_CTRL__rts___BITNR 5
#define R_SERIAL3_REC_CTRL__sampling__BITNR 4
#define R_SERIAL3_REC_CTRL__rec_stick_par__BITNR 3
#define R_SERIAL3_REC_CTRL__rec_par__BITNR 2
#define R_SERIAL3_REC_CTRL__rec_par_en__BITNR 1
#define R_SERIAL3_REC_CTRL__rec_bitnr__BITNR 0

#define R_SERIAL3_REC_CTRL__dma_err__dma_err__VAL REG_VAL_ENUM
#define R_SERIAL3_REC_CTRL__rec_enable__rec_enable__VAL REG_VAL_ENUM
#define R_SERIAL3_REC_CTRL__rts___rts___VAL REG_VAL_ENUM
#define R_SERIAL3_REC_CTRL__sampling__sampling__VAL REG_VAL_ENUM
#define R_SERIAL3_REC_CTRL__rec_stick_par__rec_stick_par__VAL REG_VAL_ENUM
#define R_SERIAL3_REC_CTRL__rec_par__rec_par__VAL REG_VAL_ENUM
#define R_SERIAL3_REC_CTRL__rec_par_en__rec_par_en__VAL REG_VAL_ENUM
#define R_SERIAL3_REC_CTRL__rec_bitnr__rec_bitnr__VAL REG_VAL_ENUM

#define R_SERIAL3_REC_CTRL__dma_err__dma_err__ignore 1
#define R_SERIAL3_REC_CTRL__dma_err__dma_err__stop 0
#define R_SERIAL3_REC_CTRL__rec_enable__rec_enable__disable 0
#define R_SERIAL3_REC_CTRL__rec_enable__rec_enable__enable 1
#define R_SERIAL3_REC_CTRL__rts___rts___active 0
#define R_SERIAL3_REC_CTRL__rts___rts___inactive 1
#define R_SERIAL3_REC_CTRL__sampling__sampling__majority 1
#define R_SERIAL3_REC_CTRL__sampling__sampling__middle 0
#define R_SERIAL3_REC_CTRL__rec_stick_par__rec_stick_par__normal 0
#define R_SERIAL3_REC_CTRL__rec_stick_par__rec_stick_par__stick 1
#define R_SERIAL3_REC_CTRL__rec_par__rec_par__even 0
#define R_SERIAL3_REC_CTRL__rec_par__rec_par__odd 1
#define R_SERIAL3_REC_CTRL__rec_par_en__rec_par_en__disable 0
#define R_SERIAL3_REC_CTRL__rec_par_en__rec_par_en__enable 1
#define R_SERIAL3_REC_CTRL__rec_bitnr__rec_bitnr__rec_7bit 1
#define R_SERIAL3_REC_CTRL__rec_bitnr__rec_bitnr__rec_8bit 0

#endif

/*
 *  R_SERIAL3_REC_DATA
 *  - type:  RO
 *  - addr:  0xb0000078
 *  - group: Serial port registers
 */

#if USE_GROUP__Serial_port_registers

#define R_SERIAL3_REC_DATA__ADDR      (REG_TYPECAST_BYTE  0xb0000078)
#define R_SERIAL3_REC_DATA__SVAL      REG_SVAL_SHADOW
#define R_SERIAL3_REC_DATA__SVAL_I    REG_SVAL_I_SHADOW
#define R_SERIAL3_REC_DATA__TYPECAST  REG_TYPECAST_BYTE
#define R_SERIAL3_REC_DATA__TYPE      (REG_BYTE)
#define R_SERIAL3_REC_DATA__GET       REG_GET_RO
#define R_SERIAL3_REC_DATA__IGET      REG_IGET_RO
#define R_SERIAL3_REC_DATA__SET       REG_SET_RO
#define R_SERIAL3_REC_DATA__ISET      REG_ISET_RO
#define R_SERIAL3_REC_DATA__SET_VAL   REG_SET_VAL_RO
#define R_SERIAL3_REC_DATA__EQL       REG_EQL_RO
#define R_SERIAL3_REC_DATA__IEQL      REG_IEQL_RO
#define R_SERIAL3_REC_DATA__RD        REG_RD_RO
#define R_SERIAL3_REC_DATA__IRD       REG_IRD_RO
#define R_SERIAL3_REC_DATA__WR        REG_WR_RO
#define R_SERIAL3_REC_DATA__IWR       REG_IWR_RO

#define R_SERIAL3_REC_DATA__READ(addr) \
  (*(addr))

#define R_SERIAL3_REC_DATA__data_in__data_in__MASK 0x000000ffU

#define R_SERIAL3_REC_DATA__data_in__MAX 0xff

#define R_SERIAL3_REC_DATA__data_in__MIN 0

#define R_SERIAL3_REC_DATA__data_in__BITNR 0

#define R_SERIAL3_REC_DATA__data_in__data_in__VAL REG_VAL_VAL


#endif

/*
 *  R_SERIAL3_STATUS
 *  - type:  RO
 *  - addr:  0xb0000079
 *  - group: Serial port registers
 */

#if USE_GROUP__Serial_port_registers

#define R_SERIAL3_STATUS__ADDR      (REG_TYPECAST_BYTE  0xb0000079)
#define R_SERIAL3_STATUS__SVAL      REG_SVAL_SHADOW
#define R_SERIAL3_STATUS__SVAL_I    REG_SVAL_I_SHADOW
#define R_SERIAL3_STATUS__TYPECAST  REG_TYPECAST_BYTE
#define R_SERIAL3_STATUS__TYPE      (REG_BYTE)
#define R_SERIAL3_STATUS__GET       REG_GET_RO
#define R_SERIAL3_STATUS__IGET      REG_IGET_RO
#define R_SERIAL3_STATUS__SET       REG_SET_RO
#define R_SERIAL3_STATUS__ISET      REG_ISET_RO
#define R_SERIAL3_STATUS__SET_VAL   REG_SET_VAL_RO
#define R_SERIAL3_STATUS__EQL       REG_EQL_RO
#define R_SERIAL3_STATUS__IEQL      REG_IEQL_RO
#define R_SERIAL3_STATUS__RD        REG_RD_RO
#define R_SERIAL3_STATUS__IRD       REG_IRD_RO
#define R_SERIAL3_STATUS__WR        REG_WR_RO
#define R_SERIAL3_STATUS__IWR       REG_IWR_RO

#define R_SERIAL3_STATUS__READ(addr) \
  (*(addr))

#define R_SERIAL3_STATUS__xoff_detect__xoff_detect__MASK 0x00000080U
#define R_SERIAL3_STATUS__cts___cts___MASK 0x00000040U
#define R_SERIAL3_STATUS__tr_ready__tr_ready__MASK 0x00000020U
#define R_SERIAL3_STATUS__rxd__rxd__MASK 0x00000010U
#define R_SERIAL3_STATUS__overrun__overrun__MASK 0x00000008U
#define R_SERIAL3_STATUS__par_err__par_err__MASK 0x00000004U
#define R_SERIAL3_STATUS__framing_err__framing_err__MASK 0x00000002U
#define R_SERIAL3_STATUS__data_avail__data_avail__MASK 0x00000001U

#define R_SERIAL3_STATUS__xoff_detect__MAX 0x1
#define R_SERIAL3_STATUS__cts___MAX 0x1
#define R_SERIAL3_STATUS__tr_ready__MAX 0x1
#define R_SERIAL3_STATUS__rxd__MAX 0x1
#define R_SERIAL3_STATUS__overrun__MAX 0x1
#define R_SERIAL3_STATUS__par_err__MAX 0x1
#define R_SERIAL3_STATUS__framing_err__MAX 0x1
#define R_SERIAL3_STATUS__data_avail__MAX 0x1

#define R_SERIAL3_STATUS__xoff_detect__MIN 0
#define R_SERIAL3_STATUS__cts___MIN 0
#define R_SERIAL3_STATUS__tr_ready__MIN 0
#define R_SERIAL3_STATUS__rxd__MIN 0
#define R_SERIAL3_STATUS__overrun__MIN 0
#define R_SERIAL3_STATUS__par_err__MIN 0
#define R_SERIAL3_STATUS__framing_err__MIN 0
#define R_SERIAL3_STATUS__data_avail__MIN 0

#define R_SERIAL3_STATUS__xoff_detect__BITNR 7
#define R_SERIAL3_STATUS__cts___BITNR 6
#define R_SERIAL3_STATUS__tr_ready__BITNR 5
#define R_SERIAL3_STATUS__rxd__BITNR 4
#define R_SERIAL3_STATUS__overrun__BITNR 3
#define R_SERIAL3_STATUS__par_err__BITNR 2
#define R_SERIAL3_STATUS__framing_err__BITNR 1
#define R_SERIAL3_STATUS__data_avail__BITNR 0

#define R_SERIAL3_STATUS__xoff_detect__xoff_detect__VAL REG_VAL_ENUM
#define R_SERIAL3_STATUS__cts___cts___VAL REG_VAL_ENUM
#define R_SERIAL3_STATUS__tr_ready__tr_ready__VAL REG_VAL_ENUM
#define R_SERIAL3_STATUS__rxd__rxd__VAL REG_VAL_VAL
#define R_SERIAL3_STATUS__overrun__overrun__VAL REG_VAL_ENUM
#define R_SERIAL3_STATUS__par_err__par_err__VAL REG_VAL_ENUM
#define R_SERIAL3_STATUS__framing_err__framing_err__VAL REG_VAL_ENUM
#define R_SERIAL3_STATUS__data_avail__data_avail__VAL REG_VAL_ENUM

#define R_SERIAL3_STATUS__xoff_detect__xoff_detect__no_xoff 0
#define R_SERIAL3_STATUS__xoff_detect__xoff_detect__xoff 1
#define R_SERIAL3_STATUS__cts___cts___active 0
#define R_SERIAL3_STATUS__cts___cts___inactive 1
#define R_SERIAL3_STATUS__tr_ready__tr_ready__full 0
#define R_SERIAL3_STATUS__tr_ready__tr_ready__ready 1
#define R_SERIAL3_STATUS__overrun__overrun__no 0
#define R_SERIAL3_STATUS__overrun__overrun__yes 1
#define R_SERIAL3_STATUS__par_err__par_err__no 0
#define R_SERIAL3_STATUS__par_err__par_err__yes 1
#define R_SERIAL3_STATUS__framing_err__framing_err__no 0
#define R_SERIAL3_STATUS__framing_err__framing_err__yes 1
#define R_SERIAL3_STATUS__data_avail__data_avail__no 0
#define R_SERIAL3_STATUS__data_avail__data_avail__yes 1

#endif

/*
 *  R_SERIAL3_TR_CTRL
 *  - type:  WO
 *  - addr:  0xb0000079
 *  - group: Serial port registers
 */

#if USE_GROUP__Serial_port_registers

#define R_SERIAL3_TR_CTRL__ADDR      (REG_TYPECAST_BYTE  0xb0000079)

#ifndef REG_NO_SHADOW
#define R_SERIAL3_TR_CTRL__SADDR     (REG_STYPECAST_BYTE (reg_shadow__hwregs.R_SERIAL3_CTRL + 1))
#define R_SERIAL3_TR_CTRL__IADDR     (REG_STYPECAST_BYTE (reg_initiated__hwregs.R_SERIAL3_CTRL + 1))
#else /* REG_NO_SHADOW */
#define R_SERIAL3_TR_CTRL__SADDR     (REG_STYPECAST_BYTE (&reg_shadow__hwregs))
#define R_SERIAL3_TR_CTRL__IADDR     (REG_STYPECAST_BYTE (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_SERIAL3_TR_CTRL__STYPECAST REG_STYPECAST_BYTE
#define R_SERIAL3_TR_CTRL__SVAL      REG_SVAL_SHADOW
#define R_SERIAL3_TR_CTRL__SVAL_I    REG_SVAL_I_SHADOW
#define R_SERIAL3_TR_CTRL__TYPECAST  REG_TYPECAST_BYTE
#define R_SERIAL3_TR_CTRL__TYPE      (REG_BYTE)
#define R_SERIAL3_TR_CTRL__GET       REG_GET_WO
#define R_SERIAL3_TR_CTRL__IGET      REG_IGET_WO
#define R_SERIAL3_TR_CTRL__SET       REG_SET_WO
#define R_SERIAL3_TR_CTRL__ISET      REG_ISET_WO
#define R_SERIAL3_TR_CTRL__SET_VAL   REG_SET_VAL_WO
#define R_SERIAL3_TR_CTRL__EQL       REG_EQL_WO
#define R_SERIAL3_TR_CTRL__IEQL      REG_IEQL_WO
#define R_SERIAL3_TR_CTRL__RD        REG_RD_WO
#define R_SERIAL3_TR_CTRL__IRD       REG_IRD_WO
#define R_SERIAL3_TR_CTRL__WR        REG_WR_WO
#define R_SERIAL3_TR_CTRL__IWR       REG_IWR_WO

#define R_SERIAL3_TR_CTRL__WRITE(addr,value) \
  (*(addr) = (value))

#define R_SERIAL3_TR_CTRL__txd__txd__MASK 0x00000080U
#define R_SERIAL3_TR_CTRL__tr_enable__tr_enable__MASK 0x00000040U
#define R_SERIAL3_TR_CTRL__auto_cts__auto_cts__MASK 0x00000020U
#define R_SERIAL3_TR_CTRL__stop_bits__stop_bits__MASK 0x00000010U
#define R_SERIAL3_TR_CTRL__tr_stick_par__tr_stick_par__MASK 0x00000008U
#define R_SERIAL3_TR_CTRL__tr_par__tr_par__MASK 0x00000004U
#define R_SERIAL3_TR_CTRL__tr_par_en__tr_par_en__MASK 0x00000002U
#define R_SERIAL3_TR_CTRL__tr_bitnr__tr_bitnr__MASK 0x00000001U

#define R_SERIAL3_TR_CTRL__txd__MAX 0x1
#define R_SERIAL3_TR_CTRL__tr_enable__MAX 0x1
#define R_SERIAL3_TR_CTRL__auto_cts__MAX 0x1
#define R_SERIAL3_TR_CTRL__stop_bits__MAX 0x1
#define R_SERIAL3_TR_CTRL__tr_stick_par__MAX 0x1
#define R_SERIAL3_TR_CTRL__tr_par__MAX 0x1
#define R_SERIAL3_TR_CTRL__tr_par_en__MAX 0x1
#define R_SERIAL3_TR_CTRL__tr_bitnr__MAX 0x1

#define R_SERIAL3_TR_CTRL__txd__MIN 0
#define R_SERIAL3_TR_CTRL__tr_enable__MIN 0
#define R_SERIAL3_TR_CTRL__auto_cts__MIN 0
#define R_SERIAL3_TR_CTRL__stop_bits__MIN 0
#define R_SERIAL3_TR_CTRL__tr_stick_par__MIN 0
#define R_SERIAL3_TR_CTRL__tr_par__MIN 0
#define R_SERIAL3_TR_CTRL__tr_par_en__MIN 0
#define R_SERIAL3_TR_CTRL__tr_bitnr__MIN 0

#define R_SERIAL3_TR_CTRL__txd__BITNR 7
#define R_SERIAL3_TR_CTRL__tr_enable__BITNR 6
#define R_SERIAL3_TR_CTRL__auto_cts__BITNR 5
#define R_SERIAL3_TR_CTRL__stop_bits__BITNR 4
#define R_SERIAL3_TR_CTRL__tr_stick_par__BITNR 3
#define R_SERIAL3_TR_CTRL__tr_par__BITNR 2
#define R_SERIAL3_TR_CTRL__tr_par_en__BITNR 1
#define R_SERIAL3_TR_CTRL__tr_bitnr__BITNR 0

#define R_SERIAL3_TR_CTRL__txd__txd__VAL REG_VAL_VAL
#define R_SERIAL3_TR_CTRL__tr_enable__tr_enable__VAL REG_VAL_ENUM
#define R_SERIAL3_TR_CTRL__auto_cts__auto_cts__VAL REG_VAL_ENUM
#define R_SERIAL3_TR_CTRL__stop_bits__stop_bits__VAL REG_VAL_ENUM
#define R_SERIAL3_TR_CTRL__tr_stick_par__tr_stick_par__VAL REG_VAL_ENUM
#define R_SERIAL3_TR_CTRL__tr_par__tr_par__VAL REG_VAL_ENUM
#define R_SERIAL3_TR_CTRL__tr_par_en__tr_par_en__VAL REG_VAL_ENUM
#define R_SERIAL3_TR_CTRL__tr_bitnr__tr_bitnr__VAL REG_VAL_ENUM

#define R_SERIAL3_TR_CTRL__tr_enable__tr_enable__disable 0
#define R_SERIAL3_TR_CTRL__tr_enable__tr_enable__enable 1
#define R_SERIAL3_TR_CTRL__auto_cts__auto_cts__active 1
#define R_SERIAL3_TR_CTRL__auto_cts__auto_cts__disabled 0
#define R_SERIAL3_TR_CTRL__stop_bits__stop_bits__one_bit 0
#define R_SERIAL3_TR_CTRL__stop_bits__stop_bits__two_bits 1
#define R_SERIAL3_TR_CTRL__tr_stick_par__tr_stick_par__normal 0
#define R_SERIAL3_TR_CTRL__tr_stick_par__tr_stick_par__stick 1
#define R_SERIAL3_TR_CTRL__tr_par__tr_par__even 0
#define R_SERIAL3_TR_CTRL__tr_par__tr_par__odd 1
#define R_SERIAL3_TR_CTRL__tr_par_en__tr_par_en__disable 0
#define R_SERIAL3_TR_CTRL__tr_par_en__tr_par_en__enable 1
#define R_SERIAL3_TR_CTRL__tr_bitnr__tr_bitnr__tr_7bit 1
#define R_SERIAL3_TR_CTRL__tr_bitnr__tr_bitnr__tr_8bit 0

#endif

/*
 *  R_SERIAL3_TR_DATA
 *  - type:  WO
 *  - addr:  0xb0000078
 *  - group: Serial port registers
 */

#if USE_GROUP__Serial_port_registers

#define R_SERIAL3_TR_DATA__ADDR      (REG_TYPECAST_BYTE  0xb0000078)

#ifndef REG_NO_SHADOW
#define R_SERIAL3_TR_DATA__SADDR     (REG_STYPECAST_BYTE (reg_shadow__hwregs.R_SERIAL3_CTRL + 0))
#define R_SERIAL3_TR_DATA__IADDR     (REG_STYPECAST_BYTE (reg_initiated__hwregs.R_SERIAL3_CTRL + 0))
#else /* REG_NO_SHADOW */
#define R_SERIAL3_TR_DATA__SADDR     (REG_STYPECAST_BYTE (&reg_shadow__hwregs))
#define R_SERIAL3_TR_DATA__IADDR     (REG_STYPECAST_BYTE (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_SERIAL3_TR_DATA__STYPECAST REG_STYPECAST_BYTE
#define R_SERIAL3_TR_DATA__SVAL      REG_SVAL_SHADOW
#define R_SERIAL3_TR_DATA__SVAL_I    REG_SVAL_I_SHADOW
#define R_SERIAL3_TR_DATA__TYPECAST  REG_TYPECAST_BYTE
#define R_SERIAL3_TR_DATA__TYPE      (REG_BYTE)
#define R_SERIAL3_TR_DATA__GET       REG_GET_WO
#define R_SERIAL3_TR_DATA__IGET      REG_IGET_WO
#define R_SERIAL3_TR_DATA__SET       REG_SET_WO
#define R_SERIAL3_TR_DATA__ISET      REG_ISET_WO
#define R_SERIAL3_TR_DATA__SET_VAL   REG_SET_VAL_WO
#define R_SERIAL3_TR_DATA__EQL       REG_EQL_WO
#define R_SERIAL3_TR_DATA__IEQL      REG_IEQL_WO
#define R_SERIAL3_TR_DATA__RD        REG_RD_WO
#define R_SERIAL3_TR_DATA__IRD       REG_IRD_WO
#define R_SERIAL3_TR_DATA__WR        REG_WR_WO
#define R_SERIAL3_TR_DATA__IWR       REG_IWR_WO

#define R_SERIAL3_TR_DATA__WRITE(addr,value) \
  (*(addr) = (value))

#define R_SERIAL3_TR_DATA__data_out__data_out__MASK 0x000000ffU

#define R_SERIAL3_TR_DATA__data_out__MAX 0xff

#define R_SERIAL3_TR_DATA__data_out__MIN 0

#define R_SERIAL3_TR_DATA__data_out__BITNR 0

#define R_SERIAL3_TR_DATA__data_out__data_out__VAL REG_VAL_VAL


#endif

/*
 *  R_SERIAL3_XOFF
 *  - type:  WO
 *  - addr:  0xb000007c
 *  - group: Serial port registers
 */

#if USE_GROUP__Serial_port_registers

#define R_SERIAL3_XOFF__ADDR      (REG_TYPECAST_UDWORD  0xb000007c)

#ifndef REG_NO_SHADOW
#define R_SERIAL3_XOFF__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_SERIAL3_XOFF + 0))
#define R_SERIAL3_XOFF__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_SERIAL3_XOFF + 0))
#else /* REG_NO_SHADOW */
#define R_SERIAL3_XOFF__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_SERIAL3_XOFF__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_SERIAL3_XOFF__STYPECAST REG_STYPECAST_UDWORD
#define R_SERIAL3_XOFF__SVAL      REG_SVAL_SHADOW
#define R_SERIAL3_XOFF__SVAL_I    REG_SVAL_I_SHADOW
#define R_SERIAL3_XOFF__TYPECAST  REG_TYPECAST_UDWORD
#define R_SERIAL3_XOFF__TYPE      (REG_UDWORD)
#define R_SERIAL3_XOFF__GET       REG_GET_WO
#define R_SERIAL3_XOFF__IGET      REG_IGET_WO
#define R_SERIAL3_XOFF__SET       REG_SET_WO
#define R_SERIAL3_XOFF__ISET      REG_ISET_WO
#define R_SERIAL3_XOFF__SET_VAL   REG_SET_VAL_WO
#define R_SERIAL3_XOFF__EQL       REG_EQL_WO
#define R_SERIAL3_XOFF__IEQL      REG_IEQL_WO
#define R_SERIAL3_XOFF__RD        REG_RD_WO
#define R_SERIAL3_XOFF__IRD       REG_IRD_WO
#define R_SERIAL3_XOFF__WR        REG_WR_WO
#define R_SERIAL3_XOFF__IWR       REG_IWR_WO

#define R_SERIAL3_XOFF__WRITE(addr,value) \
  (*(addr) = (value))

#define R_SERIAL3_XOFF__tx_stop__tx_stop__MASK 0x00000200U
#define R_SERIAL3_XOFF__auto_xoff__auto_xoff__MASK 0x00000100U
#define R_SERIAL3_XOFF__xoff_char__xoff_char__MASK 0x000000ffU

#define R_SERIAL3_XOFF__tx_stop__MAX 0x1
#define R_SERIAL3_XOFF__auto_xoff__MAX 0x1
#define R_SERIAL3_XOFF__xoff_char__MAX 0xff

#define R_SERIAL3_XOFF__tx_stop__MIN 0
#define R_SERIAL3_XOFF__auto_xoff__MIN 0
#define R_SERIAL3_XOFF__xoff_char__MIN 0

#define R_SERIAL3_XOFF__tx_stop__BITNR 9
#define R_SERIAL3_XOFF__auto_xoff__BITNR 8
#define R_SERIAL3_XOFF__xoff_char__BITNR 0

#define R_SERIAL3_XOFF__tx_stop__tx_stop__VAL REG_VAL_ENUM
#define R_SERIAL3_XOFF__auto_xoff__auto_xoff__VAL REG_VAL_ENUM
#define R_SERIAL3_XOFF__xoff_char__xoff_char__VAL REG_VAL_VAL

#define R_SERIAL3_XOFF__tx_stop__tx_stop__enable 0
#define R_SERIAL3_XOFF__tx_stop__tx_stop__stop 1
#define R_SERIAL3_XOFF__auto_xoff__auto_xoff__disable 0
#define R_SERIAL3_XOFF__auto_xoff__auto_xoff__enable 1

#endif

/*
 *  R_SERIAL_PRESCALE
 *  - type:  WO
 *  - addr:  0xb00000f2
 *  - group: Timer registers
 */

#if USE_GROUP__Timer_registers

#define R_SERIAL_PRESCALE__ADDR      (REG_TYPECAST_UWORD  0xb00000f2)

#ifndef REG_NO_SHADOW
#define R_SERIAL_PRESCALE__SADDR     (REG_STYPECAST_UWORD (reg_shadow__hwregs.R_CLOCK_PRESCALE + 2))
#define R_SERIAL_PRESCALE__IADDR     (REG_STYPECAST_UWORD (reg_initiated__hwregs.R_CLOCK_PRESCALE + 2))
#else /* REG_NO_SHADOW */
#define R_SERIAL_PRESCALE__SADDR     (REG_STYPECAST_UWORD (&reg_shadow__hwregs))
#define R_SERIAL_PRESCALE__IADDR     (REG_STYPECAST_UWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_SERIAL_PRESCALE__STYPECAST REG_STYPECAST_UWORD
#define R_SERIAL_PRESCALE__SVAL      REG_SVAL_SHADOW
#define R_SERIAL_PRESCALE__SVAL_I    REG_SVAL_I_SHADOW
#define R_SERIAL_PRESCALE__TYPECAST  REG_TYPECAST_UWORD
#define R_SERIAL_PRESCALE__TYPE      (REG_UWORD)
#define R_SERIAL_PRESCALE__GET       REG_GET_WO
#define R_SERIAL_PRESCALE__IGET      REG_IGET_WO
#define R_SERIAL_PRESCALE__SET       REG_SET_WO
#define R_SERIAL_PRESCALE__ISET      REG_ISET_WO
#define R_SERIAL_PRESCALE__SET_VAL   REG_SET_VAL_WO
#define R_SERIAL_PRESCALE__EQL       REG_EQL_WO
#define R_SERIAL_PRESCALE__IEQL      REG_IEQL_WO
#define R_SERIAL_PRESCALE__RD        REG_RD_WO
#define R_SERIAL_PRESCALE__IRD       REG_IRD_WO
#define R_SERIAL_PRESCALE__WR        REG_WR_WO
#define R_SERIAL_PRESCALE__IWR       REG_IWR_WO

#define R_SERIAL_PRESCALE__WRITE(addr,value) \
  (*(addr) = (value))

#define R_SERIAL_PRESCALE__ser_presc__ser_presc__MASK 0x0000ffffU

#define R_SERIAL_PRESCALE__ser_presc__MAX 0xffff

#define R_SERIAL_PRESCALE__ser_presc__MIN 0

#define R_SERIAL_PRESCALE__ser_presc__BITNR 0

#define R_SERIAL_PRESCALE__ser_presc__ser_presc__VAL REG_VAL_VAL


#endif

/*
 *  R_SER_PRESC_STATUS
 *  - type:  RO
 *  - addr:  0xb00000f2
 *  - group: Timer registers
 */

#if USE_GROUP__Timer_registers

#define R_SER_PRESC_STATUS__ADDR      (REG_TYPECAST_UWORD  0xb00000f2)
#define R_SER_PRESC_STATUS__SVAL      REG_SVAL_SHADOW
#define R_SER_PRESC_STATUS__SVAL_I    REG_SVAL_I_SHADOW
#define R_SER_PRESC_STATUS__TYPECAST  REG_TYPECAST_UWORD
#define R_SER_PRESC_STATUS__TYPE      (REG_UWORD)
#define R_SER_PRESC_STATUS__GET       REG_GET_RO
#define R_SER_PRESC_STATUS__IGET      REG_IGET_RO
#define R_SER_PRESC_STATUS__SET       REG_SET_RO
#define R_SER_PRESC_STATUS__ISET      REG_ISET_RO
#define R_SER_PRESC_STATUS__SET_VAL   REG_SET_VAL_RO
#define R_SER_PRESC_STATUS__EQL       REG_EQL_RO
#define R_SER_PRESC_STATUS__IEQL      REG_IEQL_RO
#define R_SER_PRESC_STATUS__RD        REG_RD_RO
#define R_SER_PRESC_STATUS__IRD       REG_IRD_RO
#define R_SER_PRESC_STATUS__WR        REG_WR_RO
#define R_SER_PRESC_STATUS__IWR       REG_IWR_RO

#define R_SER_PRESC_STATUS__READ(addr) \
  (*(addr))

#define R_SER_PRESC_STATUS__ser_status__ser_status__MASK 0x0000ffffU

#define R_SER_PRESC_STATUS__ser_status__MAX 0xffff

#define R_SER_PRESC_STATUS__ser_status__MIN 0

#define R_SER_PRESC_STATUS__ser_status__BITNR 0

#define R_SER_PRESC_STATUS__ser_status__ser_status__VAL REG_VAL_VAL


#endif

/*
 *  R_SET_EOP
 *  - type:  WO
 *  - addr:  0xb000003c
 *  - group: DMA registers
 */

#if USE_GROUP__DMA_registers

#define R_SET_EOP__ADDR      (REG_TYPECAST_UDWORD  0xb000003c)

#ifndef REG_NO_SHADOW
#define R_SET_EOP__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_SET_EOP + 0))
#define R_SET_EOP__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_SET_EOP + 0))
#else /* REG_NO_SHADOW */
#define R_SET_EOP__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_SET_EOP__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_SET_EOP__STYPECAST REG_STYPECAST_UDWORD
#define R_SET_EOP__SVAL REG_SVAL_ZERO
#define R_SET_EOP__SVAL_I REG_SVAL_I_ZERO
#define R_SET_EOP__TYPECAST  REG_TYPECAST_UDWORD
#define R_SET_EOP__TYPE      (REG_UDWORD)
#define R_SET_EOP__GET       REG_GET_WO
#define R_SET_EOP__IGET      REG_IGET_WO
#define R_SET_EOP__SET       REG_SET_WO
#define R_SET_EOP__ISET      REG_ISET_WO
#define R_SET_EOP__SET_VAL   REG_SET_VAL_WO
#define R_SET_EOP__EQL       REG_EQL_WO
#define R_SET_EOP__IEQL      REG_IEQL_WO
#define R_SET_EOP__RD        REG_RD_WO
#define R_SET_EOP__IRD       REG_IRD_WO
#define R_SET_EOP__WR        REG_WR_WO
#define R_SET_EOP__IWR       REG_IWR_WO

#define R_SET_EOP__WRITE(addr,value) \
  (*(addr) = (value))

#define R_SET_EOP__ch9_eop__ch9_eop__MASK 0x00000008U
#define R_SET_EOP__ch7_eop__ch7_eop__MASK 0x00000004U
#define R_SET_EOP__ch5_eop__ch5_eop__MASK 0x00000002U
#define R_SET_EOP__ch3_eop__ch3_eop__MASK 0x00000001U

#define R_SET_EOP__ch9_eop__MAX 0x1
#define R_SET_EOP__ch7_eop__MAX 0x1
#define R_SET_EOP__ch5_eop__MAX 0x1
#define R_SET_EOP__ch3_eop__MAX 0x1

#define R_SET_EOP__ch9_eop__MIN 0
#define R_SET_EOP__ch7_eop__MIN 0
#define R_SET_EOP__ch5_eop__MIN 0
#define R_SET_EOP__ch3_eop__MIN 0

#define R_SET_EOP__ch9_eop__BITNR 3
#define R_SET_EOP__ch7_eop__BITNR 2
#define R_SET_EOP__ch5_eop__BITNR 1
#define R_SET_EOP__ch3_eop__BITNR 0

#define R_SET_EOP__ch9_eop__ch9_eop__VAL REG_VAL_ENUM
#define R_SET_EOP__ch7_eop__ch7_eop__VAL REG_VAL_ENUM
#define R_SET_EOP__ch5_eop__ch5_eop__VAL REG_VAL_ENUM
#define R_SET_EOP__ch3_eop__ch3_eop__VAL REG_VAL_ENUM

#define R_SET_EOP__ch9_eop__ch9_eop__nop 0
#define R_SET_EOP__ch9_eop__ch9_eop__set 1
#define R_SET_EOP__ch7_eop__ch7_eop__nop 0
#define R_SET_EOP__ch7_eop__ch7_eop__set 1
#define R_SET_EOP__ch5_eop__ch5_eop__nop 0
#define R_SET_EOP__ch5_eop__ch5_eop__set 1
#define R_SET_EOP__ch3_eop__ch3_eop__nop 0
#define R_SET_EOP__ch3_eop__ch3_eop__set 1

#endif

/*
 *  R_SHARED_RAM_ADDR
 *  - type:  WO
 *  - addr:  0xb0000044
 *  - group: Shared RAM interface registers
 */

#if USE_GROUP__Shared_RAM_interface_registers

#define R_SHARED_RAM_ADDR__ADDR      (REG_TYPECAST_UDWORD  0xb0000044)

#ifndef REG_NO_SHADOW
#define R_SHARED_RAM_ADDR__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_ATA_CONFIG + 0))
#define R_SHARED_RAM_ADDR__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_ATA_CONFIG + 0))
#else /* REG_NO_SHADOW */
#define R_SHARED_RAM_ADDR__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_SHARED_RAM_ADDR__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_SHARED_RAM_ADDR__STYPECAST REG_STYPECAST_UDWORD
#define R_SHARED_RAM_ADDR__SVAL      REG_SVAL_SHADOW
#define R_SHARED_RAM_ADDR__SVAL_I    REG_SVAL_I_SHADOW
#define R_SHARED_RAM_ADDR__TYPECAST  REG_TYPECAST_UDWORD
#define R_SHARED_RAM_ADDR__TYPE      (REG_UDWORD)
#define R_SHARED_RAM_ADDR__GET       REG_GET_WO
#define R_SHARED_RAM_ADDR__IGET      REG_IGET_WO
#define R_SHARED_RAM_ADDR__SET       REG_SET_WO
#define R_SHARED_RAM_ADDR__ISET      REG_ISET_WO
#define R_SHARED_RAM_ADDR__SET_VAL   REG_SET_VAL_WO
#define R_SHARED_RAM_ADDR__EQL       REG_EQL_WO
#define R_SHARED_RAM_ADDR__IEQL      REG_IEQL_WO
#define R_SHARED_RAM_ADDR__RD        REG_RD_WO
#define R_SHARED_RAM_ADDR__IRD       REG_IRD_WO
#define R_SHARED_RAM_ADDR__WR        REG_WR_WO
#define R_SHARED_RAM_ADDR__IWR       REG_IWR_WO

#define R_SHARED_RAM_ADDR__WRITE(addr,value) \
  (*(addr) = (value))

#define R_SHARED_RAM_ADDR__base_addr__base_addr__MASK 0x3fffff00U

#define R_SHARED_RAM_ADDR__base_addr__MAX 0x3fffff

#define R_SHARED_RAM_ADDR__base_addr__MIN 0

#define R_SHARED_RAM_ADDR__base_addr__BITNR 8

#define R_SHARED_RAM_ADDR__base_addr__base_addr__VAL REG_VAL_VAL


#endif

/*
 *  R_SHARED_RAM_CONFIG
 *  - type:  WO
 *  - addr:  0xb0000040
 *  - group: Shared RAM interface registers
 */

#if USE_GROUP__Shared_RAM_interface_registers

#define R_SHARED_RAM_CONFIG__ADDR      (REG_TYPECAST_UDWORD  0xb0000040)

#ifndef REG_NO_SHADOW
#define R_SHARED_RAM_CONFIG__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_ATA_CTRL_DATA + 0))
#define R_SHARED_RAM_CONFIG__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_ATA_CTRL_DATA + 0))
#else /* REG_NO_SHADOW */
#define R_SHARED_RAM_CONFIG__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_SHARED_RAM_CONFIG__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_SHARED_RAM_CONFIG__STYPECAST REG_STYPECAST_UDWORD
#define R_SHARED_RAM_CONFIG__SVAL      REG_SVAL_SHADOW
#define R_SHARED_RAM_CONFIG__SVAL_I    REG_SVAL_I_SHADOW
#define R_SHARED_RAM_CONFIG__TYPECAST  REG_TYPECAST_UDWORD
#define R_SHARED_RAM_CONFIG__TYPE      (REG_UDWORD)
#define R_SHARED_RAM_CONFIG__GET       REG_GET_WO
#define R_SHARED_RAM_CONFIG__IGET      REG_IGET_WO
#define R_SHARED_RAM_CONFIG__SET       REG_SET_WO
#define R_SHARED_RAM_CONFIG__ISET      REG_ISET_WO
#define R_SHARED_RAM_CONFIG__SET_VAL   REG_SET_VAL_WO
#define R_SHARED_RAM_CONFIG__EQL       REG_EQL_WO
#define R_SHARED_RAM_CONFIG__IEQL      REG_IEQL_WO
#define R_SHARED_RAM_CONFIG__RD        REG_RD_WO
#define R_SHARED_RAM_CONFIG__IRD       REG_IRD_WO
#define R_SHARED_RAM_CONFIG__WR        REG_WR_WO
#define R_SHARED_RAM_CONFIG__IWR       REG_IWR_WO

#define R_SHARED_RAM_CONFIG__WRITE(addr,value) \
  (*(addr) = (value))

#define R_SHARED_RAM_CONFIG__width__width__MASK 0x00000008U
#define R_SHARED_RAM_CONFIG__enable__enable__MASK 0x00000004U
#define R_SHARED_RAM_CONFIG__pint__pint__MASK 0x00000002U
#define R_SHARED_RAM_CONFIG__clri__clri__MASK 0x00000001U

#define R_SHARED_RAM_CONFIG__width__MAX 0x1
#define R_SHARED_RAM_CONFIG__enable__MAX 0x1
#define R_SHARED_RAM_CONFIG__pint__MAX 0x1
#define R_SHARED_RAM_CONFIG__clri__MAX 0x1

#define R_SHARED_RAM_CONFIG__width__MIN 0
#define R_SHARED_RAM_CONFIG__enable__MIN 0
#define R_SHARED_RAM_CONFIG__pint__MIN 0
#define R_SHARED_RAM_CONFIG__clri__MIN 0

#define R_SHARED_RAM_CONFIG__width__BITNR 3
#define R_SHARED_RAM_CONFIG__enable__BITNR 2
#define R_SHARED_RAM_CONFIG__pint__BITNR 1
#define R_SHARED_RAM_CONFIG__clri__BITNR 0

#define R_SHARED_RAM_CONFIG__width__width__VAL REG_VAL_ENUM
#define R_SHARED_RAM_CONFIG__enable__enable__VAL REG_VAL_ENUM
#define R_SHARED_RAM_CONFIG__pint__pint__VAL REG_VAL_ENUM
#define R_SHARED_RAM_CONFIG__clri__clri__VAL REG_VAL_ENUM

#define R_SHARED_RAM_CONFIG__width__width__byte 0
#define R_SHARED_RAM_CONFIG__width__width__word 1
#define R_SHARED_RAM_CONFIG__enable__enable__no 0
#define R_SHARED_RAM_CONFIG__enable__enable__yes 1
#define R_SHARED_RAM_CONFIG__pint__pint__int 1
#define R_SHARED_RAM_CONFIG__pint__pint__nop 0
#define R_SHARED_RAM_CONFIG__clri__clri__clr 1
#define R_SHARED_RAM_CONFIG__clri__clri__nop 0

#endif

/*
 *  R_SINGLE_STEP
 *  - type:  WO
 *  - addr:  0xb00000fe
 *  - group: Test mode registers
 */

#if USE_GROUP__Test_mode_registers

#define R_SINGLE_STEP__ADDR      (REG_TYPECAST_BYTE  0xb00000fe)

#ifndef REG_NO_SHADOW
#define R_SINGLE_STEP__SADDR     (REG_STYPECAST_BYTE (reg_shadow__hwregs.R_TEST_MODE + 2))
#define R_SINGLE_STEP__IADDR     (REG_STYPECAST_BYTE (reg_initiated__hwregs.R_TEST_MODE + 2))
#else /* REG_NO_SHADOW */
#define R_SINGLE_STEP__SADDR     (REG_STYPECAST_BYTE (&reg_shadow__hwregs))
#define R_SINGLE_STEP__IADDR     (REG_STYPECAST_BYTE (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_SINGLE_STEP__STYPECAST REG_STYPECAST_BYTE
#define R_SINGLE_STEP__SVAL      REG_SVAL_SHADOW
#define R_SINGLE_STEP__SVAL_I    REG_SVAL_I_SHADOW
#define R_SINGLE_STEP__TYPECAST  REG_TYPECAST_BYTE
#define R_SINGLE_STEP__TYPE      (REG_BYTE)
#define R_SINGLE_STEP__GET       REG_GET_WO
#define R_SINGLE_STEP__IGET      REG_IGET_WO
#define R_SINGLE_STEP__SET       REG_SET_WO
#define R_SINGLE_STEP__ISET      REG_ISET_WO
#define R_SINGLE_STEP__SET_VAL   REG_SET_VAL_WO
#define R_SINGLE_STEP__EQL       REG_EQL_WO
#define R_SINGLE_STEP__IEQL      REG_IEQL_WO
#define R_SINGLE_STEP__RD        REG_RD_WO
#define R_SINGLE_STEP__IRD       REG_IRD_WO
#define R_SINGLE_STEP__WR        REG_WR_WO
#define R_SINGLE_STEP__IWR       REG_IWR_WO

#define R_SINGLE_STEP__WRITE(addr,value) \
  (*(addr) = (value))

#define R_SINGLE_STEP__single_step__single_step__MASK 0x00000008U
#define R_SINGLE_STEP__step_wr__step_wr__MASK 0x00000004U
#define R_SINGLE_STEP__step_rd__step_rd__MASK 0x00000002U
#define R_SINGLE_STEP__step_fetch__step_fetch__MASK 0x00000001U

#define R_SINGLE_STEP__single_step__MAX 0x1
#define R_SINGLE_STEP__step_wr__MAX 0x1
#define R_SINGLE_STEP__step_rd__MAX 0x1
#define R_SINGLE_STEP__step_fetch__MAX 0x1

#define R_SINGLE_STEP__single_step__MIN 0
#define R_SINGLE_STEP__step_wr__MIN 0
#define R_SINGLE_STEP__step_rd__MIN 0
#define R_SINGLE_STEP__step_fetch__MIN 0

#define R_SINGLE_STEP__single_step__BITNR 3
#define R_SINGLE_STEP__step_wr__BITNR 2
#define R_SINGLE_STEP__step_rd__BITNR 1
#define R_SINGLE_STEP__step_fetch__BITNR 0

#define R_SINGLE_STEP__single_step__single_step__VAL REG_VAL_ENUM
#define R_SINGLE_STEP__step_wr__step_wr__VAL REG_VAL_ENUM
#define R_SINGLE_STEP__step_rd__step_rd__VAL REG_VAL_ENUM
#define R_SINGLE_STEP__step_fetch__step_fetch__VAL REG_VAL_ENUM

#define R_SINGLE_STEP__single_step__single_step__off 0
#define R_SINGLE_STEP__single_step__single_step__on 1
#define R_SINGLE_STEP__step_wr__step_wr__off 0
#define R_SINGLE_STEP__step_wr__step_wr__on 1
#define R_SINGLE_STEP__step_rd__step_rd__off 0
#define R_SINGLE_STEP__step_rd__step_rd__on 1
#define R_SINGLE_STEP__step_fetch__step_fetch__off 0
#define R_SINGLE_STEP__step_fetch__step_fetch__on 1

#endif

/*
 *  R_SYNC_SERIAL1_CTRL
 *  - type:  WO
 *  - addr:  0xb0000068
 *  - group: Syncrounous serial port registers
 */

#if USE_GROUP__Syncrounous_serial_port_registers

#define R_SYNC_SERIAL1_CTRL__ADDR      (REG_TYPECAST_UDWORD  0xb0000068)

#ifndef REG_NO_SHADOW
#define R_SYNC_SERIAL1_CTRL__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_SERIAL1_CTRL + 0))
#define R_SYNC_SERIAL1_CTRL__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_SERIAL1_CTRL + 0))
#else /* REG_NO_SHADOW */
#define R_SYNC_SERIAL1_CTRL__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_SYNC_SERIAL1_CTRL__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_SYNC_SERIAL1_CTRL__STYPECAST REG_STYPECAST_UDWORD
#define R_SYNC_SERIAL1_CTRL__SVAL      REG_SVAL_SHADOW
#define R_SYNC_SERIAL1_CTRL__SVAL_I    REG_SVAL_I_SHADOW
#define R_SYNC_SERIAL1_CTRL__TYPECAST  REG_TYPECAST_UDWORD
#define R_SYNC_SERIAL1_CTRL__TYPE      (REG_UDWORD)
#define R_SYNC_SERIAL1_CTRL__GET       REG_GET_WO
#define R_SYNC_SERIAL1_CTRL__IGET      REG_IGET_WO
#define R_SYNC_SERIAL1_CTRL__SET       REG_SET_WO
#define R_SYNC_SERIAL1_CTRL__ISET      REG_ISET_WO
#define R_SYNC_SERIAL1_CTRL__SET_VAL   REG_SET_VAL_WO
#define R_SYNC_SERIAL1_CTRL__EQL       REG_EQL_WO
#define R_SYNC_SERIAL1_CTRL__IEQL      REG_IEQL_WO
#define R_SYNC_SERIAL1_CTRL__RD        REG_RD_WO
#define R_SYNC_SERIAL1_CTRL__IRD       REG_IRD_WO
#define R_SYNC_SERIAL1_CTRL__WR        REG_WR_WO
#define R_SYNC_SERIAL1_CTRL__IWR       REG_IWR_WO

#define R_SYNC_SERIAL1_CTRL__WRITE(addr,value) \
  (*(addr) = (value))

#define R_SYNC_SERIAL1_CTRL__tr_baud__tr_baud__MASK 0xf0000000U
#define R_SYNC_SERIAL1_CTRL__dma_enable__dma_enable__MASK 0x08000000U
#define R_SYNC_SERIAL1_CTRL__mode__mode__MASK 0x07000000U
#define R_SYNC_SERIAL1_CTRL__error__error__MASK 0x00800000U
#define R_SYNC_SERIAL1_CTRL__rec_enable__rec_enable__MASK 0x00400000U
#define R_SYNC_SERIAL1_CTRL__f_synctype__f_synctype__MASK 0x00200000U
#define R_SYNC_SERIAL1_CTRL__f_syncsize__f_syncsize__MASK 0x00180000U
#define R_SYNC_SERIAL1_CTRL__f_sync__f_sync__MASK 0x00040000U
#define R_SYNC_SERIAL1_CTRL__clk_mode__clk_mode__MASK 0x00020000U
#define R_SYNC_SERIAL1_CTRL__clk_halt__clk_halt__MASK 0x00010000U
#define R_SYNC_SERIAL1_CTRL__bitorder__bitorder__MASK 0x00008000U
#define R_SYNC_SERIAL1_CTRL__tr_enable__tr_enable__MASK 0x00004000U
#define R_SYNC_SERIAL1_CTRL__wordsize__wordsize__MASK 0x00003800U
#define R_SYNC_SERIAL1_CTRL__buf_empty__buf_empty__MASK 0x00000400U
#define R_SYNC_SERIAL1_CTRL__buf_full__buf_full__MASK 0x00000200U
#define R_SYNC_SERIAL1_CTRL__flow_ctrl__flow_ctrl__MASK 0x00000100U
#define R_SYNC_SERIAL1_CTRL__clk_polarity__clk_polarity__MASK 0x00000040U
#define R_SYNC_SERIAL1_CTRL__frame_polarity__frame_polarity__MASK 0x00000020U
#define R_SYNC_SERIAL1_CTRL__status_polarity__status_polarity__MASK 0x00000010U
#define R_SYNC_SERIAL1_CTRL__clk_driver__clk_driver__MASK 0x00000008U
#define R_SYNC_SERIAL1_CTRL__frame_driver__frame_driver__MASK 0x00000004U
#define R_SYNC_SERIAL1_CTRL__status_driver__status_driver__MASK 0x00000002U
#define R_SYNC_SERIAL1_CTRL__def_out0__def_out0__MASK 0x00000001U

#define R_SYNC_SERIAL1_CTRL__tr_baud__MAX 0xf
#define R_SYNC_SERIAL1_CTRL__dma_enable__MAX 0x1
#define R_SYNC_SERIAL1_CTRL__mode__MAX 0x7
#define R_SYNC_SERIAL1_CTRL__error__MAX 0x1
#define R_SYNC_SERIAL1_CTRL__rec_enable__MAX 0x1
#define R_SYNC_SERIAL1_CTRL__f_synctype__MAX 0x1
#define R_SYNC_SERIAL1_CTRL__f_syncsize__MAX 0x3
#define R_SYNC_SERIAL1_CTRL__f_sync__MAX 0x1
#define R_SYNC_SERIAL1_CTRL__clk_mode__MAX 0x1
#define R_SYNC_SERIAL1_CTRL__clk_halt__MAX 0x1
#define R_SYNC_SERIAL1_CTRL__bitorder__MAX 0x1
#define R_SYNC_SERIAL1_CTRL__tr_enable__MAX 0x1
#define R_SYNC_SERIAL1_CTRL__wordsize__MAX 0x7
#define R_SYNC_SERIAL1_CTRL__buf_empty__MAX 0x1
#define R_SYNC_SERIAL1_CTRL__buf_full__MAX 0x1
#define R_SYNC_SERIAL1_CTRL__flow_ctrl__MAX 0x1
#define R_SYNC_SERIAL1_CTRL__clk_polarity__MAX 0x1
#define R_SYNC_SERIAL1_CTRL__frame_polarity__MAX 0x1
#define R_SYNC_SERIAL1_CTRL__status_polarity__MAX 0x1
#define R_SYNC_SERIAL1_CTRL__clk_driver__MAX 0x1
#define R_SYNC_SERIAL1_CTRL__frame_driver__MAX 0x1
#define R_SYNC_SERIAL1_CTRL__status_driver__MAX 0x1
#define R_SYNC_SERIAL1_CTRL__def_out0__MAX 0x1

#define R_SYNC_SERIAL1_CTRL__tr_baud__MIN 0
#define R_SYNC_SERIAL1_CTRL__dma_enable__MIN 0
#define R_SYNC_SERIAL1_CTRL__mode__MIN 0
#define R_SYNC_SERIAL1_CTRL__error__MIN 0
#define R_SYNC_SERIAL1_CTRL__rec_enable__MIN 0
#define R_SYNC_SERIAL1_CTRL__f_synctype__MIN 0
#define R_SYNC_SERIAL1_CTRL__f_syncsize__MIN 0
#define R_SYNC_SERIAL1_CTRL__f_sync__MIN 0
#define R_SYNC_SERIAL1_CTRL__clk_mode__MIN 0
#define R_SYNC_SERIAL1_CTRL__clk_halt__MIN 0
#define R_SYNC_SERIAL1_CTRL__bitorder__MIN 0
#define R_SYNC_SERIAL1_CTRL__tr_enable__MIN 0
#define R_SYNC_SERIAL1_CTRL__wordsize__MIN 0
#define R_SYNC_SERIAL1_CTRL__buf_empty__MIN 0
#define R_SYNC_SERIAL1_CTRL__buf_full__MIN 0
#define R_SYNC_SERIAL1_CTRL__flow_ctrl__MIN 0
#define R_SYNC_SERIAL1_CTRL__clk_polarity__MIN 0
#define R_SYNC_SERIAL1_CTRL__frame_polarity__MIN 0
#define R_SYNC_SERIAL1_CTRL__status_polarity__MIN 0
#define R_SYNC_SERIAL1_CTRL__clk_driver__MIN 0
#define R_SYNC_SERIAL1_CTRL__frame_driver__MIN 0
#define R_SYNC_SERIAL1_CTRL__status_driver__MIN 0
#define R_SYNC_SERIAL1_CTRL__def_out0__MIN 0

#define R_SYNC_SERIAL1_CTRL__tr_baud__BITNR 28
#define R_SYNC_SERIAL1_CTRL__dma_enable__BITNR 27
#define R_SYNC_SERIAL1_CTRL__mode__BITNR 24
#define R_SYNC_SERIAL1_CTRL__error__BITNR 23
#define R_SYNC_SERIAL1_CTRL__rec_enable__BITNR 22
#define R_SYNC_SERIAL1_CTRL__f_synctype__BITNR 21
#define R_SYNC_SERIAL1_CTRL__f_syncsize__BITNR 19
#define R_SYNC_SERIAL1_CTRL__f_sync__BITNR 18
#define R_SYNC_SERIAL1_CTRL__clk_mode__BITNR 17
#define R_SYNC_SERIAL1_CTRL__clk_halt__BITNR 16
#define R_SYNC_SERIAL1_CTRL__bitorder__BITNR 15
#define R_SYNC_SERIAL1_CTRL__tr_enable__BITNR 14
#define R_SYNC_SERIAL1_CTRL__wordsize__BITNR 11
#define R_SYNC_SERIAL1_CTRL__buf_empty__BITNR 10
#define R_SYNC_SERIAL1_CTRL__buf_full__BITNR 9
#define R_SYNC_SERIAL1_CTRL__flow_ctrl__BITNR 8
#define R_SYNC_SERIAL1_CTRL__clk_polarity__BITNR 6
#define R_SYNC_SERIAL1_CTRL__frame_polarity__BITNR 5
#define R_SYNC_SERIAL1_CTRL__status_polarity__BITNR 4
#define R_SYNC_SERIAL1_CTRL__clk_driver__BITNR 3
#define R_SYNC_SERIAL1_CTRL__frame_driver__BITNR 2
#define R_SYNC_SERIAL1_CTRL__status_driver__BITNR 1
#define R_SYNC_SERIAL1_CTRL__def_out0__BITNR 0

#define R_SYNC_SERIAL1_CTRL__tr_baud__tr_baud__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL1_CTRL__dma_enable__dma_enable__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL1_CTRL__mode__mode__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL1_CTRL__error__error__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL1_CTRL__rec_enable__rec_enable__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL1_CTRL__f_synctype__f_synctype__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL1_CTRL__f_syncsize__f_syncsize__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL1_CTRL__f_sync__f_sync__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL1_CTRL__clk_mode__clk_mode__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL1_CTRL__clk_halt__clk_halt__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL1_CTRL__bitorder__bitorder__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL1_CTRL__tr_enable__tr_enable__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL1_CTRL__wordsize__wordsize__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL1_CTRL__buf_empty__buf_empty__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL1_CTRL__buf_full__buf_full__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL1_CTRL__flow_ctrl__flow_ctrl__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL1_CTRL__clk_polarity__clk_polarity__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL1_CTRL__frame_polarity__frame_polarity__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL1_CTRL__status_polarity__status_polarity__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL1_CTRL__clk_driver__clk_driver__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL1_CTRL__frame_driver__frame_driver__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL1_CTRL__status_driver__status_driver__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL1_CTRL__def_out0__def_out0__VAL REG_VAL_ENUM

#define R_SYNC_SERIAL1_CTRL__tr_baud__tr_baud__c115k2Hz 10
#define R_SYNC_SERIAL1_CTRL__tr_baud__tr_baud__c1200Hz 3
#define R_SYNC_SERIAL1_CTRL__tr_baud__tr_baud__c150Hz 0
#define R_SYNC_SERIAL1_CTRL__tr_baud__tr_baud__c19k2Hz 7
#define R_SYNC_SERIAL1_CTRL__tr_baud__tr_baud__c230k4Hz 11
#define R_SYNC_SERIAL1_CTRL__tr_baud__tr_baud__c2400Hz 4
#define R_SYNC_SERIAL1_CTRL__tr_baud__tr_baud__c28k8Hz 8
#define R_SYNC_SERIAL1_CTRL__tr_baud__tr_baud__c300Hz 1
#define R_SYNC_SERIAL1_CTRL__tr_baud__tr_baud__c3125kHz 14
#define R_SYNC_SERIAL1_CTRL__tr_baud__tr_baud__c460k8Hz 12
#define R_SYNC_SERIAL1_CTRL__tr_baud__tr_baud__c4800Hz 5
#define R_SYNC_SERIAL1_CTRL__tr_baud__tr_baud__c57k6Hz 9
#define R_SYNC_SERIAL1_CTRL__tr_baud__tr_baud__c600Hz 2
#define R_SYNC_SERIAL1_CTRL__tr_baud__tr_baud__c921k6Hz 13
#define R_SYNC_SERIAL1_CTRL__tr_baud__tr_baud__c9600Hz 6
#define R_SYNC_SERIAL1_CTRL__dma_enable__dma_enable__off 0
#define R_SYNC_SERIAL1_CTRL__dma_enable__dma_enable__on 1
#define R_SYNC_SERIAL1_CTRL__mode__mode__master_bidir 4
#define R_SYNC_SERIAL1_CTRL__mode__mode__master_input 2
#define R_SYNC_SERIAL1_CTRL__mode__mode__master_output 0
#define R_SYNC_SERIAL1_CTRL__mode__mode__slave_bidir 5
#define R_SYNC_SERIAL1_CTRL__mode__mode__slave_input 3
#define R_SYNC_SERIAL1_CTRL__mode__mode__slave_output 1
#define R_SYNC_SERIAL1_CTRL__error__error__ignore 1
#define R_SYNC_SERIAL1_CTRL__error__error__normal 0
#define R_SYNC_SERIAL1_CTRL__rec_enable__rec_enable__disable 0
#define R_SYNC_SERIAL1_CTRL__rec_enable__rec_enable__enable 1
#define R_SYNC_SERIAL1_CTRL__f_synctype__f_synctype__early 1
#define R_SYNC_SERIAL1_CTRL__f_synctype__f_synctype__normal 0
#define R_SYNC_SERIAL1_CTRL__f_syncsize__f_syncsize__bit 0
#define R_SYNC_SERIAL1_CTRL__f_syncsize__f_syncsize__extended 2
#define R_SYNC_SERIAL1_CTRL__f_syncsize__f_syncsize__word 1
#define R_SYNC_SERIAL1_CTRL__f_sync__f_sync__off 1
#define R_SYNC_SERIAL1_CTRL__f_sync__f_sync__on 0
#define R_SYNC_SERIAL1_CTRL__clk_mode__clk_mode__gated 1
#define R_SYNC_SERIAL1_CTRL__clk_mode__clk_mode__normal 0
#define R_SYNC_SERIAL1_CTRL__clk_halt__clk_halt__running 0
#define R_SYNC_SERIAL1_CTRL__clk_halt__clk_halt__stopped 1
#define R_SYNC_SERIAL1_CTRL__bitorder__bitorder__lsb 0
#define R_SYNC_SERIAL1_CTRL__bitorder__bitorder__msb 1
#define R_SYNC_SERIAL1_CTRL__tr_enable__tr_enable__disable 0
#define R_SYNC_SERIAL1_CTRL__tr_enable__tr_enable__enable 1
#define R_SYNC_SERIAL1_CTRL__wordsize__wordsize__size12bit 1
#define R_SYNC_SERIAL1_CTRL__wordsize__wordsize__size16bit 2
#define R_SYNC_SERIAL1_CTRL__wordsize__wordsize__size24bit 3
#define R_SYNC_SERIAL1_CTRL__wordsize__wordsize__size32bit 4
#define R_SYNC_SERIAL1_CTRL__wordsize__wordsize__size8bit 0
#define R_SYNC_SERIAL1_CTRL__buf_empty__buf_empty__lmt_0 1
#define R_SYNC_SERIAL1_CTRL__buf_empty__buf_empty__lmt_8 0
#define R_SYNC_SERIAL1_CTRL__buf_full__buf_full__lmt_32 0
#define R_SYNC_SERIAL1_CTRL__buf_full__buf_full__lmt_8 1
#define R_SYNC_SERIAL1_CTRL__flow_ctrl__flow_ctrl__disabled 0
#define R_SYNC_SERIAL1_CTRL__flow_ctrl__flow_ctrl__enabled 1
#define R_SYNC_SERIAL1_CTRL__clk_polarity__clk_polarity__neg 1
#define R_SYNC_SERIAL1_CTRL__clk_polarity__clk_polarity__pos 0
#define R_SYNC_SERIAL1_CTRL__frame_polarity__frame_polarity__inverted 1
#define R_SYNC_SERIAL1_CTRL__frame_polarity__frame_polarity__normal 0
#define R_SYNC_SERIAL1_CTRL__status_polarity__status_polarity__inverted 1
#define R_SYNC_SERIAL1_CTRL__status_polarity__status_polarity__normal 0
#define R_SYNC_SERIAL1_CTRL__clk_driver__clk_driver__inverted 1
#define R_SYNC_SERIAL1_CTRL__clk_driver__clk_driver__normal 0
#define R_SYNC_SERIAL1_CTRL__frame_driver__frame_driver__inverted 1
#define R_SYNC_SERIAL1_CTRL__frame_driver__frame_driver__normal 0
#define R_SYNC_SERIAL1_CTRL__status_driver__status_driver__inverted 1
#define R_SYNC_SERIAL1_CTRL__status_driver__status_driver__normal 0
#define R_SYNC_SERIAL1_CTRL__def_out0__def_out0__high 1
#define R_SYNC_SERIAL1_CTRL__def_out0__def_out0__low 0

#endif

/*
 *  R_SYNC_SERIAL1_REC_BYTE
 *  - type:  RO
 *  - addr:  0xb000006c
 *  - group: Syncrounous serial port registers
 */

#if USE_GROUP__Syncrounous_serial_port_registers

#define R_SYNC_SERIAL1_REC_BYTE__ADDR      (REG_TYPECAST_BYTE  0xb000006c)
#define R_SYNC_SERIAL1_REC_BYTE__SVAL      REG_SVAL_SHADOW
#define R_SYNC_SERIAL1_REC_BYTE__SVAL_I    REG_SVAL_I_SHADOW
#define R_SYNC_SERIAL1_REC_BYTE__TYPECAST  REG_TYPECAST_BYTE
#define R_SYNC_SERIAL1_REC_BYTE__TYPE      (REG_BYTE)
#define R_SYNC_SERIAL1_REC_BYTE__GET       REG_GET_RO
#define R_SYNC_SERIAL1_REC_BYTE__IGET      REG_IGET_RO
#define R_SYNC_SERIAL1_REC_BYTE__SET       REG_SET_RO
#define R_SYNC_SERIAL1_REC_BYTE__ISET      REG_ISET_RO
#define R_SYNC_SERIAL1_REC_BYTE__SET_VAL   REG_SET_VAL_RO
#define R_SYNC_SERIAL1_REC_BYTE__EQL       REG_EQL_RO
#define R_SYNC_SERIAL1_REC_BYTE__IEQL      REG_IEQL_RO
#define R_SYNC_SERIAL1_REC_BYTE__RD        REG_RD_RO
#define R_SYNC_SERIAL1_REC_BYTE__IRD       REG_IRD_RO
#define R_SYNC_SERIAL1_REC_BYTE__WR        REG_WR_RO
#define R_SYNC_SERIAL1_REC_BYTE__IWR       REG_IWR_RO

#define R_SYNC_SERIAL1_REC_BYTE__READ(addr) \
  (*(addr))

#define R_SYNC_SERIAL1_REC_BYTE__data_in__data_in__MASK 0x000000ffU

#define R_SYNC_SERIAL1_REC_BYTE__data_in__MAX 0xff

#define R_SYNC_SERIAL1_REC_BYTE__data_in__MIN 0

#define R_SYNC_SERIAL1_REC_BYTE__data_in__BITNR 0

#define R_SYNC_SERIAL1_REC_BYTE__data_in__data_in__VAL REG_VAL_VAL


#endif

/*
 *  R_SYNC_SERIAL1_REC_DATA
 *  - type:  RO
 *  - addr:  0xb000006c
 *  - group: Syncrounous serial port registers
 */

#if USE_GROUP__Syncrounous_serial_port_registers

#define R_SYNC_SERIAL1_REC_DATA__ADDR      (REG_TYPECAST_UDWORD  0xb000006c)
#define R_SYNC_SERIAL1_REC_DATA__SVAL      REG_SVAL_SHADOW
#define R_SYNC_SERIAL1_REC_DATA__SVAL_I    REG_SVAL_I_SHADOW
#define R_SYNC_SERIAL1_REC_DATA__TYPECAST  REG_TYPECAST_UDWORD
#define R_SYNC_SERIAL1_REC_DATA__TYPE      (REG_UDWORD)
#define R_SYNC_SERIAL1_REC_DATA__GET       REG_GET_RO
#define R_SYNC_SERIAL1_REC_DATA__IGET      REG_IGET_RO
#define R_SYNC_SERIAL1_REC_DATA__SET       REG_SET_RO
#define R_SYNC_SERIAL1_REC_DATA__ISET      REG_ISET_RO
#define R_SYNC_SERIAL1_REC_DATA__SET_VAL   REG_SET_VAL_RO
#define R_SYNC_SERIAL1_REC_DATA__EQL       REG_EQL_RO
#define R_SYNC_SERIAL1_REC_DATA__IEQL      REG_IEQL_RO
#define R_SYNC_SERIAL1_REC_DATA__RD        REG_RD_RO
#define R_SYNC_SERIAL1_REC_DATA__IRD       REG_IRD_RO
#define R_SYNC_SERIAL1_REC_DATA__WR        REG_WR_RO
#define R_SYNC_SERIAL1_REC_DATA__IWR       REG_IWR_RO

#define R_SYNC_SERIAL1_REC_DATA__READ(addr) \
  (*(addr))

#define R_SYNC_SERIAL1_REC_DATA__data_in__data_in__MASK 0xffffffffU

#define R_SYNC_SERIAL1_REC_DATA__data_in__MAX 0xffffffff

#define R_SYNC_SERIAL1_REC_DATA__data_in__MIN 0

#define R_SYNC_SERIAL1_REC_DATA__data_in__BITNR 0

#define R_SYNC_SERIAL1_REC_DATA__data_in__data_in__VAL REG_VAL_VAL


#endif

/*
 *  R_SYNC_SERIAL1_REC_WORD
 *  - type:  RO
 *  - addr:  0xb000006c
 *  - group: Syncrounous serial port registers
 */

#if USE_GROUP__Syncrounous_serial_port_registers

#define R_SYNC_SERIAL1_REC_WORD__ADDR      (REG_TYPECAST_UWORD  0xb000006c)
#define R_SYNC_SERIAL1_REC_WORD__SVAL      REG_SVAL_SHADOW
#define R_SYNC_SERIAL1_REC_WORD__SVAL_I    REG_SVAL_I_SHADOW
#define R_SYNC_SERIAL1_REC_WORD__TYPECAST  REG_TYPECAST_UWORD
#define R_SYNC_SERIAL1_REC_WORD__TYPE      (REG_UWORD)
#define R_SYNC_SERIAL1_REC_WORD__GET       REG_GET_RO
#define R_SYNC_SERIAL1_REC_WORD__IGET      REG_IGET_RO
#define R_SYNC_SERIAL1_REC_WORD__SET       REG_SET_RO
#define R_SYNC_SERIAL1_REC_WORD__ISET      REG_ISET_RO
#define R_SYNC_SERIAL1_REC_WORD__SET_VAL   REG_SET_VAL_RO
#define R_SYNC_SERIAL1_REC_WORD__EQL       REG_EQL_RO
#define R_SYNC_SERIAL1_REC_WORD__IEQL      REG_IEQL_RO
#define R_SYNC_SERIAL1_REC_WORD__RD        REG_RD_RO
#define R_SYNC_SERIAL1_REC_WORD__IRD       REG_IRD_RO
#define R_SYNC_SERIAL1_REC_WORD__WR        REG_WR_RO
#define R_SYNC_SERIAL1_REC_WORD__IWR       REG_IWR_RO

#define R_SYNC_SERIAL1_REC_WORD__READ(addr) \
  (*(addr))

#define R_SYNC_SERIAL1_REC_WORD__data_in__data_in__MASK 0x0000ffffU

#define R_SYNC_SERIAL1_REC_WORD__data_in__MAX 0xffff

#define R_SYNC_SERIAL1_REC_WORD__data_in__MIN 0

#define R_SYNC_SERIAL1_REC_WORD__data_in__BITNR 0

#define R_SYNC_SERIAL1_REC_WORD__data_in__data_in__VAL REG_VAL_VAL


#endif

/*
 *  R_SYNC_SERIAL1_STATUS
 *  - type:  RO
 *  - addr:  0xb0000068
 *  - group: Syncrounous serial port registers
 */

#if USE_GROUP__Syncrounous_serial_port_registers

#define R_SYNC_SERIAL1_STATUS__ADDR      (REG_TYPECAST_UDWORD  0xb0000068)
#define R_SYNC_SERIAL1_STATUS__SVAL      REG_SVAL_SHADOW
#define R_SYNC_SERIAL1_STATUS__SVAL_I    REG_SVAL_I_SHADOW
#define R_SYNC_SERIAL1_STATUS__TYPECAST  REG_TYPECAST_UDWORD
#define R_SYNC_SERIAL1_STATUS__TYPE      (REG_UDWORD)
#define R_SYNC_SERIAL1_STATUS__GET       REG_GET_RO
#define R_SYNC_SERIAL1_STATUS__IGET      REG_IGET_RO
#define R_SYNC_SERIAL1_STATUS__SET       REG_SET_RO
#define R_SYNC_SERIAL1_STATUS__ISET      REG_ISET_RO
#define R_SYNC_SERIAL1_STATUS__SET_VAL   REG_SET_VAL_RO
#define R_SYNC_SERIAL1_STATUS__EQL       REG_EQL_RO
#define R_SYNC_SERIAL1_STATUS__IEQL      REG_IEQL_RO
#define R_SYNC_SERIAL1_STATUS__RD        REG_RD_RO
#define R_SYNC_SERIAL1_STATUS__IRD       REG_IRD_RO
#define R_SYNC_SERIAL1_STATUS__WR        REG_WR_RO
#define R_SYNC_SERIAL1_STATUS__IWR       REG_IWR_RO

#define R_SYNC_SERIAL1_STATUS__READ(addr) \
  (*(addr))

#define R_SYNC_SERIAL1_STATUS__rec_status__rec_status__MASK 0x00008000U
#define R_SYNC_SERIAL1_STATUS__tr_empty__tr_empty__MASK 0x00004000U
#define R_SYNC_SERIAL1_STATUS__tr_ready__tr_ready__MASK 0x00002000U
#define R_SYNC_SERIAL1_STATUS__pin_1__pin_1__MASK 0x00001000U
#define R_SYNC_SERIAL1_STATUS__pin_0__pin_0__MASK 0x00000800U
#define R_SYNC_SERIAL1_STATUS__underflow__underflow__MASK 0x00000400U
#define R_SYNC_SERIAL1_STATUS__overrun__overrun__MASK 0x00000200U
#define R_SYNC_SERIAL1_STATUS__data_avail__data_avail__MASK 0x00000100U
#define R_SYNC_SERIAL1_STATUS__data__data__MASK 0x000000ffU

#define R_SYNC_SERIAL1_STATUS__rec_status__MAX 0x1
#define R_SYNC_SERIAL1_STATUS__tr_empty__MAX 0x1
#define R_SYNC_SERIAL1_STATUS__tr_ready__MAX 0x1
#define R_SYNC_SERIAL1_STATUS__pin_1__MAX 0x1
#define R_SYNC_SERIAL1_STATUS__pin_0__MAX 0x1
#define R_SYNC_SERIAL1_STATUS__underflow__MAX 0x1
#define R_SYNC_SERIAL1_STATUS__overrun__MAX 0x1
#define R_SYNC_SERIAL1_STATUS__data_avail__MAX 0x1
#define R_SYNC_SERIAL1_STATUS__data__MAX 0xff

#define R_SYNC_SERIAL1_STATUS__rec_status__MIN 0
#define R_SYNC_SERIAL1_STATUS__tr_empty__MIN 0
#define R_SYNC_SERIAL1_STATUS__tr_ready__MIN 0
#define R_SYNC_SERIAL1_STATUS__pin_1__MIN 0
#define R_SYNC_SERIAL1_STATUS__pin_0__MIN 0
#define R_SYNC_SERIAL1_STATUS__underflow__MIN 0
#define R_SYNC_SERIAL1_STATUS__overrun__MIN 0
#define R_SYNC_SERIAL1_STATUS__data_avail__MIN 0
#define R_SYNC_SERIAL1_STATUS__data__MIN 0

#define R_SYNC_SERIAL1_STATUS__rec_status__BITNR 15
#define R_SYNC_SERIAL1_STATUS__tr_empty__BITNR 14
#define R_SYNC_SERIAL1_STATUS__tr_ready__BITNR 13
#define R_SYNC_SERIAL1_STATUS__pin_1__BITNR 12
#define R_SYNC_SERIAL1_STATUS__pin_0__BITNR 11
#define R_SYNC_SERIAL1_STATUS__underflow__BITNR 10
#define R_SYNC_SERIAL1_STATUS__overrun__BITNR 9
#define R_SYNC_SERIAL1_STATUS__data_avail__BITNR 8
#define R_SYNC_SERIAL1_STATUS__data__BITNR 0

#define R_SYNC_SERIAL1_STATUS__rec_status__rec_status__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL1_STATUS__tr_empty__tr_empty__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL1_STATUS__tr_ready__tr_ready__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL1_STATUS__pin_1__pin_1__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL1_STATUS__pin_0__pin_0__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL1_STATUS__underflow__underflow__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL1_STATUS__overrun__overrun__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL1_STATUS__data_avail__data_avail__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL1_STATUS__data__data__VAL REG_VAL_VAL

#define R_SYNC_SERIAL1_STATUS__rec_status__rec_status__idle 1
#define R_SYNC_SERIAL1_STATUS__rec_status__rec_status__running 0
#define R_SYNC_SERIAL1_STATUS__tr_empty__tr_empty__empty 1
#define R_SYNC_SERIAL1_STATUS__tr_empty__tr_empty__not_empty 0
#define R_SYNC_SERIAL1_STATUS__tr_ready__tr_ready__full 0
#define R_SYNC_SERIAL1_STATUS__tr_ready__tr_ready__ready 1
#define R_SYNC_SERIAL1_STATUS__pin_1__pin_1__high 1
#define R_SYNC_SERIAL1_STATUS__pin_1__pin_1__low 0
#define R_SYNC_SERIAL1_STATUS__pin_0__pin_0__high 1
#define R_SYNC_SERIAL1_STATUS__pin_0__pin_0__low 0
#define R_SYNC_SERIAL1_STATUS__underflow__underflow__no 0
#define R_SYNC_SERIAL1_STATUS__underflow__underflow__yes 1
#define R_SYNC_SERIAL1_STATUS__overrun__overrun__no 0
#define R_SYNC_SERIAL1_STATUS__overrun__overrun__yes 1
#define R_SYNC_SERIAL1_STATUS__data_avail__data_avail__no 0
#define R_SYNC_SERIAL1_STATUS__data_avail__data_avail__yes 1

#endif

/*
 *  R_SYNC_SERIAL1_TR_BYTE
 *  - type:  WO
 *  - addr:  0xb000006c
 *  - group: Syncrounous serial port registers
 */

#if USE_GROUP__Syncrounous_serial_port_registers

#define R_SYNC_SERIAL1_TR_BYTE__ADDR      (REG_TYPECAST_BYTE  0xb000006c)

#ifndef REG_NO_SHADOW
#define R_SYNC_SERIAL1_TR_BYTE__SADDR     (REG_STYPECAST_BYTE (reg_shadow__hwregs.R_SERIAL1_XOFF + 0))
#define R_SYNC_SERIAL1_TR_BYTE__IADDR     (REG_STYPECAST_BYTE (reg_initiated__hwregs.R_SERIAL1_XOFF + 0))
#else /* REG_NO_SHADOW */
#define R_SYNC_SERIAL1_TR_BYTE__SADDR     (REG_STYPECAST_BYTE (&reg_shadow__hwregs))
#define R_SYNC_SERIAL1_TR_BYTE__IADDR     (REG_STYPECAST_BYTE (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_SYNC_SERIAL1_TR_BYTE__STYPECAST REG_STYPECAST_BYTE
#define R_SYNC_SERIAL1_TR_BYTE__SVAL      REG_SVAL_SHADOW
#define R_SYNC_SERIAL1_TR_BYTE__SVAL_I    REG_SVAL_I_SHADOW
#define R_SYNC_SERIAL1_TR_BYTE__TYPECAST  REG_TYPECAST_BYTE
#define R_SYNC_SERIAL1_TR_BYTE__TYPE      (REG_BYTE)
#define R_SYNC_SERIAL1_TR_BYTE__GET       REG_GET_WO
#define R_SYNC_SERIAL1_TR_BYTE__IGET      REG_IGET_WO
#define R_SYNC_SERIAL1_TR_BYTE__SET       REG_SET_WO
#define R_SYNC_SERIAL1_TR_BYTE__ISET      REG_ISET_WO
#define R_SYNC_SERIAL1_TR_BYTE__SET_VAL   REG_SET_VAL_WO
#define R_SYNC_SERIAL1_TR_BYTE__EQL       REG_EQL_WO
#define R_SYNC_SERIAL1_TR_BYTE__IEQL      REG_IEQL_WO
#define R_SYNC_SERIAL1_TR_BYTE__RD        REG_RD_WO
#define R_SYNC_SERIAL1_TR_BYTE__IRD       REG_IRD_WO
#define R_SYNC_SERIAL1_TR_BYTE__WR        REG_WR_WO
#define R_SYNC_SERIAL1_TR_BYTE__IWR       REG_IWR_WO

#define R_SYNC_SERIAL1_TR_BYTE__WRITE(addr,value) \
  (*(addr) = (value))

#define R_SYNC_SERIAL1_TR_BYTE__data_out__data_out__MASK 0x000000ffU

#define R_SYNC_SERIAL1_TR_BYTE__data_out__MAX 0xff

#define R_SYNC_SERIAL1_TR_BYTE__data_out__MIN 0

#define R_SYNC_SERIAL1_TR_BYTE__data_out__BITNR 0

#define R_SYNC_SERIAL1_TR_BYTE__data_out__data_out__VAL REG_VAL_VAL


#endif

/*
 *  R_SYNC_SERIAL1_TR_DATA
 *  - type:  WO
 *  - addr:  0xb000006c
 *  - group: Syncrounous serial port registers
 */

#if USE_GROUP__Syncrounous_serial_port_registers

#define R_SYNC_SERIAL1_TR_DATA__ADDR      (REG_TYPECAST_UDWORD  0xb000006c)

#ifndef REG_NO_SHADOW
#define R_SYNC_SERIAL1_TR_DATA__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_SERIAL1_XOFF + 0))
#define R_SYNC_SERIAL1_TR_DATA__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_SERIAL1_XOFF + 0))
#else /* REG_NO_SHADOW */
#define R_SYNC_SERIAL1_TR_DATA__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_SYNC_SERIAL1_TR_DATA__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_SYNC_SERIAL1_TR_DATA__STYPECAST REG_STYPECAST_UDWORD
#define R_SYNC_SERIAL1_TR_DATA__SVAL      REG_SVAL_SHADOW
#define R_SYNC_SERIAL1_TR_DATA__SVAL_I    REG_SVAL_I_SHADOW
#define R_SYNC_SERIAL1_TR_DATA__TYPECAST  REG_TYPECAST_UDWORD
#define R_SYNC_SERIAL1_TR_DATA__TYPE      (REG_UDWORD)
#define R_SYNC_SERIAL1_TR_DATA__GET       REG_GET_WO
#define R_SYNC_SERIAL1_TR_DATA__IGET      REG_IGET_WO
#define R_SYNC_SERIAL1_TR_DATA__SET       REG_SET_WO
#define R_SYNC_SERIAL1_TR_DATA__ISET      REG_ISET_WO
#define R_SYNC_SERIAL1_TR_DATA__SET_VAL   REG_SET_VAL_WO
#define R_SYNC_SERIAL1_TR_DATA__EQL       REG_EQL_WO
#define R_SYNC_SERIAL1_TR_DATA__IEQL      REG_IEQL_WO
#define R_SYNC_SERIAL1_TR_DATA__RD        REG_RD_WO
#define R_SYNC_SERIAL1_TR_DATA__IRD       REG_IRD_WO
#define R_SYNC_SERIAL1_TR_DATA__WR        REG_WR_WO
#define R_SYNC_SERIAL1_TR_DATA__IWR       REG_IWR_WO

#define R_SYNC_SERIAL1_TR_DATA__WRITE(addr,value) \
  (*(addr) = (value))

#define R_SYNC_SERIAL1_TR_DATA__data_out__data_out__MASK 0xffffffffU

#define R_SYNC_SERIAL1_TR_DATA__data_out__MAX 0xffffffff

#define R_SYNC_SERIAL1_TR_DATA__data_out__MIN 0

#define R_SYNC_SERIAL1_TR_DATA__data_out__BITNR 0

#define R_SYNC_SERIAL1_TR_DATA__data_out__data_out__VAL REG_VAL_VAL


#endif

/*
 *  R_SYNC_SERIAL1_TR_WORD
 *  - type:  WO
 *  - addr:  0xb000006c
 *  - group: Syncrounous serial port registers
 */

#if USE_GROUP__Syncrounous_serial_port_registers

#define R_SYNC_SERIAL1_TR_WORD__ADDR      (REG_TYPECAST_UWORD  0xb000006c)

#ifndef REG_NO_SHADOW
#define R_SYNC_SERIAL1_TR_WORD__SADDR     (REG_STYPECAST_UWORD (reg_shadow__hwregs.R_SERIAL1_XOFF + 0))
#define R_SYNC_SERIAL1_TR_WORD__IADDR     (REG_STYPECAST_UWORD (reg_initiated__hwregs.R_SERIAL1_XOFF + 0))
#else /* REG_NO_SHADOW */
#define R_SYNC_SERIAL1_TR_WORD__SADDR     (REG_STYPECAST_UWORD (&reg_shadow__hwregs))
#define R_SYNC_SERIAL1_TR_WORD__IADDR     (REG_STYPECAST_UWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_SYNC_SERIAL1_TR_WORD__STYPECAST REG_STYPECAST_UWORD
#define R_SYNC_SERIAL1_TR_WORD__SVAL      REG_SVAL_SHADOW
#define R_SYNC_SERIAL1_TR_WORD__SVAL_I    REG_SVAL_I_SHADOW
#define R_SYNC_SERIAL1_TR_WORD__TYPECAST  REG_TYPECAST_UWORD
#define R_SYNC_SERIAL1_TR_WORD__TYPE      (REG_UWORD)
#define R_SYNC_SERIAL1_TR_WORD__GET       REG_GET_WO
#define R_SYNC_SERIAL1_TR_WORD__IGET      REG_IGET_WO
#define R_SYNC_SERIAL1_TR_WORD__SET       REG_SET_WO
#define R_SYNC_SERIAL1_TR_WORD__ISET      REG_ISET_WO
#define R_SYNC_SERIAL1_TR_WORD__SET_VAL   REG_SET_VAL_WO
#define R_SYNC_SERIAL1_TR_WORD__EQL       REG_EQL_WO
#define R_SYNC_SERIAL1_TR_WORD__IEQL      REG_IEQL_WO
#define R_SYNC_SERIAL1_TR_WORD__RD        REG_RD_WO
#define R_SYNC_SERIAL1_TR_WORD__IRD       REG_IRD_WO
#define R_SYNC_SERIAL1_TR_WORD__WR        REG_WR_WO
#define R_SYNC_SERIAL1_TR_WORD__IWR       REG_IWR_WO

#define R_SYNC_SERIAL1_TR_WORD__WRITE(addr,value) \
  (*(addr) = (value))

#define R_SYNC_SERIAL1_TR_WORD__data_out__data_out__MASK 0x0000ffffU

#define R_SYNC_SERIAL1_TR_WORD__data_out__MAX 0xffff

#define R_SYNC_SERIAL1_TR_WORD__data_out__MIN 0

#define R_SYNC_SERIAL1_TR_WORD__data_out__BITNR 0

#define R_SYNC_SERIAL1_TR_WORD__data_out__data_out__VAL REG_VAL_VAL


#endif

/*
 *  R_SYNC_SERIAL3_CTRL
 *  - type:  WO
 *  - addr:  0xb0000078
 *  - group: Syncrounous serial port registers
 */

#if USE_GROUP__Syncrounous_serial_port_registers

#define R_SYNC_SERIAL3_CTRL__ADDR      (REG_TYPECAST_UDWORD  0xb0000078)

#ifndef REG_NO_SHADOW
#define R_SYNC_SERIAL3_CTRL__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_SERIAL3_CTRL + 0))
#define R_SYNC_SERIAL3_CTRL__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_SERIAL3_CTRL + 0))
#else /* REG_NO_SHADOW */
#define R_SYNC_SERIAL3_CTRL__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_SYNC_SERIAL3_CTRL__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_SYNC_SERIAL3_CTRL__STYPECAST REG_STYPECAST_UDWORD
#define R_SYNC_SERIAL3_CTRL__SVAL      REG_SVAL_SHADOW
#define R_SYNC_SERIAL3_CTRL__SVAL_I    REG_SVAL_I_SHADOW
#define R_SYNC_SERIAL3_CTRL__TYPECAST  REG_TYPECAST_UDWORD
#define R_SYNC_SERIAL3_CTRL__TYPE      (REG_UDWORD)
#define R_SYNC_SERIAL3_CTRL__GET       REG_GET_WO
#define R_SYNC_SERIAL3_CTRL__IGET      REG_IGET_WO
#define R_SYNC_SERIAL3_CTRL__SET       REG_SET_WO
#define R_SYNC_SERIAL3_CTRL__ISET      REG_ISET_WO
#define R_SYNC_SERIAL3_CTRL__SET_VAL   REG_SET_VAL_WO
#define R_SYNC_SERIAL3_CTRL__EQL       REG_EQL_WO
#define R_SYNC_SERIAL3_CTRL__IEQL      REG_IEQL_WO
#define R_SYNC_SERIAL3_CTRL__RD        REG_RD_WO
#define R_SYNC_SERIAL3_CTRL__IRD       REG_IRD_WO
#define R_SYNC_SERIAL3_CTRL__WR        REG_WR_WO
#define R_SYNC_SERIAL3_CTRL__IWR       REG_IWR_WO

#define R_SYNC_SERIAL3_CTRL__WRITE(addr,value) \
  (*(addr) = (value))

#define R_SYNC_SERIAL3_CTRL__tr_baud__tr_baud__MASK 0xf0000000U
#define R_SYNC_SERIAL3_CTRL__dma_enable__dma_enable__MASK 0x08000000U
#define R_SYNC_SERIAL3_CTRL__mode__mode__MASK 0x07000000U
#define R_SYNC_SERIAL3_CTRL__error__error__MASK 0x00800000U
#define R_SYNC_SERIAL3_CTRL__rec_enable__rec_enable__MASK 0x00400000U
#define R_SYNC_SERIAL3_CTRL__f_synctype__f_synctype__MASK 0x00200000U
#define R_SYNC_SERIAL3_CTRL__f_syncsize__f_syncsize__MASK 0x00180000U
#define R_SYNC_SERIAL3_CTRL__f_sync__f_sync__MASK 0x00040000U
#define R_SYNC_SERIAL3_CTRL__clk_mode__clk_mode__MASK 0x00020000U
#define R_SYNC_SERIAL3_CTRL__clk_halt__clk_halt__MASK 0x00010000U
#define R_SYNC_SERIAL3_CTRL__bitorder__bitorder__MASK 0x00008000U
#define R_SYNC_SERIAL3_CTRL__tr_enable__tr_enable__MASK 0x00004000U
#define R_SYNC_SERIAL3_CTRL__wordsize__wordsize__MASK 0x00003800U
#define R_SYNC_SERIAL3_CTRL__buf_empty__buf_empty__MASK 0x00000400U
#define R_SYNC_SERIAL3_CTRL__buf_full__buf_full__MASK 0x00000200U
#define R_SYNC_SERIAL3_CTRL__flow_ctrl__flow_ctrl__MASK 0x00000100U
#define R_SYNC_SERIAL3_CTRL__clk_polarity__clk_polarity__MASK 0x00000040U
#define R_SYNC_SERIAL3_CTRL__frame_polarity__frame_polarity__MASK 0x00000020U
#define R_SYNC_SERIAL3_CTRL__status_polarity__status_polarity__MASK 0x00000010U
#define R_SYNC_SERIAL3_CTRL__clk_driver__clk_driver__MASK 0x00000008U
#define R_SYNC_SERIAL3_CTRL__frame_driver__frame_driver__MASK 0x00000004U
#define R_SYNC_SERIAL3_CTRL__status_driver__status_driver__MASK 0x00000002U
#define R_SYNC_SERIAL3_CTRL__def_out0__def_out0__MASK 0x00000001U

#define R_SYNC_SERIAL3_CTRL__tr_baud__MAX 0xf
#define R_SYNC_SERIAL3_CTRL__dma_enable__MAX 0x1
#define R_SYNC_SERIAL3_CTRL__mode__MAX 0x7
#define R_SYNC_SERIAL3_CTRL__error__MAX 0x1
#define R_SYNC_SERIAL3_CTRL__rec_enable__MAX 0x1
#define R_SYNC_SERIAL3_CTRL__f_synctype__MAX 0x1
#define R_SYNC_SERIAL3_CTRL__f_syncsize__MAX 0x3
#define R_SYNC_SERIAL3_CTRL__f_sync__MAX 0x1
#define R_SYNC_SERIAL3_CTRL__clk_mode__MAX 0x1
#define R_SYNC_SERIAL3_CTRL__clk_halt__MAX 0x1
#define R_SYNC_SERIAL3_CTRL__bitorder__MAX 0x1
#define R_SYNC_SERIAL3_CTRL__tr_enable__MAX 0x1
#define R_SYNC_SERIAL3_CTRL__wordsize__MAX 0x7
#define R_SYNC_SERIAL3_CTRL__buf_empty__MAX 0x1
#define R_SYNC_SERIAL3_CTRL__buf_full__MAX 0x1
#define R_SYNC_SERIAL3_CTRL__flow_ctrl__MAX 0x1
#define R_SYNC_SERIAL3_CTRL__clk_polarity__MAX 0x1
#define R_SYNC_SERIAL3_CTRL__frame_polarity__MAX 0x1
#define R_SYNC_SERIAL3_CTRL__status_polarity__MAX 0x1
#define R_SYNC_SERIAL3_CTRL__clk_driver__MAX 0x1
#define R_SYNC_SERIAL3_CTRL__frame_driver__MAX 0x1
#define R_SYNC_SERIAL3_CTRL__status_driver__MAX 0x1
#define R_SYNC_SERIAL3_CTRL__def_out0__MAX 0x1

#define R_SYNC_SERIAL3_CTRL__tr_baud__MIN 0
#define R_SYNC_SERIAL3_CTRL__dma_enable__MIN 0
#define R_SYNC_SERIAL3_CTRL__mode__MIN 0
#define R_SYNC_SERIAL3_CTRL__error__MIN 0
#define R_SYNC_SERIAL3_CTRL__rec_enable__MIN 0
#define R_SYNC_SERIAL3_CTRL__f_synctype__MIN 0
#define R_SYNC_SERIAL3_CTRL__f_syncsize__MIN 0
#define R_SYNC_SERIAL3_CTRL__f_sync__MIN 0
#define R_SYNC_SERIAL3_CTRL__clk_mode__MIN 0
#define R_SYNC_SERIAL3_CTRL__clk_halt__MIN 0
#define R_SYNC_SERIAL3_CTRL__bitorder__MIN 0
#define R_SYNC_SERIAL3_CTRL__tr_enable__MIN 0
#define R_SYNC_SERIAL3_CTRL__wordsize__MIN 0
#define R_SYNC_SERIAL3_CTRL__buf_empty__MIN 0
#define R_SYNC_SERIAL3_CTRL__buf_full__MIN 0
#define R_SYNC_SERIAL3_CTRL__flow_ctrl__MIN 0
#define R_SYNC_SERIAL3_CTRL__clk_polarity__MIN 0
#define R_SYNC_SERIAL3_CTRL__frame_polarity__MIN 0
#define R_SYNC_SERIAL3_CTRL__status_polarity__MIN 0
#define R_SYNC_SERIAL3_CTRL__clk_driver__MIN 0
#define R_SYNC_SERIAL3_CTRL__frame_driver__MIN 0
#define R_SYNC_SERIAL3_CTRL__status_driver__MIN 0
#define R_SYNC_SERIAL3_CTRL__def_out0__MIN 0

#define R_SYNC_SERIAL3_CTRL__tr_baud__BITNR 28
#define R_SYNC_SERIAL3_CTRL__dma_enable__BITNR 27
#define R_SYNC_SERIAL3_CTRL__mode__BITNR 24
#define R_SYNC_SERIAL3_CTRL__error__BITNR 23
#define R_SYNC_SERIAL3_CTRL__rec_enable__BITNR 22
#define R_SYNC_SERIAL3_CTRL__f_synctype__BITNR 21
#define R_SYNC_SERIAL3_CTRL__f_syncsize__BITNR 19
#define R_SYNC_SERIAL3_CTRL__f_sync__BITNR 18
#define R_SYNC_SERIAL3_CTRL__clk_mode__BITNR 17
#define R_SYNC_SERIAL3_CTRL__clk_halt__BITNR 16
#define R_SYNC_SERIAL3_CTRL__bitorder__BITNR 15
#define R_SYNC_SERIAL3_CTRL__tr_enable__BITNR 14
#define R_SYNC_SERIAL3_CTRL__wordsize__BITNR 11
#define R_SYNC_SERIAL3_CTRL__buf_empty__BITNR 10
#define R_SYNC_SERIAL3_CTRL__buf_full__BITNR 9
#define R_SYNC_SERIAL3_CTRL__flow_ctrl__BITNR 8
#define R_SYNC_SERIAL3_CTRL__clk_polarity__BITNR 6
#define R_SYNC_SERIAL3_CTRL__frame_polarity__BITNR 5
#define R_SYNC_SERIAL3_CTRL__status_polarity__BITNR 4
#define R_SYNC_SERIAL3_CTRL__clk_driver__BITNR 3
#define R_SYNC_SERIAL3_CTRL__frame_driver__BITNR 2
#define R_SYNC_SERIAL3_CTRL__status_driver__BITNR 1
#define R_SYNC_SERIAL3_CTRL__def_out0__BITNR 0

#define R_SYNC_SERIAL3_CTRL__tr_baud__tr_baud__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL3_CTRL__dma_enable__dma_enable__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL3_CTRL__mode__mode__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL3_CTRL__error__error__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL3_CTRL__rec_enable__rec_enable__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL3_CTRL__f_synctype__f_synctype__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL3_CTRL__f_syncsize__f_syncsize__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL3_CTRL__f_sync__f_sync__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL3_CTRL__clk_mode__clk_mode__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL3_CTRL__clk_halt__clk_halt__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL3_CTRL__bitorder__bitorder__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL3_CTRL__tr_enable__tr_enable__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL3_CTRL__wordsize__wordsize__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL3_CTRL__buf_empty__buf_empty__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL3_CTRL__buf_full__buf_full__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL3_CTRL__flow_ctrl__flow_ctrl__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL3_CTRL__clk_polarity__clk_polarity__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL3_CTRL__frame_polarity__frame_polarity__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL3_CTRL__status_polarity__status_polarity__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL3_CTRL__clk_driver__clk_driver__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL3_CTRL__frame_driver__frame_driver__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL3_CTRL__status_driver__status_driver__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL3_CTRL__def_out0__def_out0__VAL REG_VAL_ENUM

#define R_SYNC_SERIAL3_CTRL__tr_baud__tr_baud__c115k2Hz 10
#define R_SYNC_SERIAL3_CTRL__tr_baud__tr_baud__c1200Hz 3
#define R_SYNC_SERIAL3_CTRL__tr_baud__tr_baud__c150Hz 0
#define R_SYNC_SERIAL3_CTRL__tr_baud__tr_baud__c19k2Hz 7
#define R_SYNC_SERIAL3_CTRL__tr_baud__tr_baud__c230k4Hz 11
#define R_SYNC_SERIAL3_CTRL__tr_baud__tr_baud__c2400Hz 4
#define R_SYNC_SERIAL3_CTRL__tr_baud__tr_baud__c28k8Hz 8
#define R_SYNC_SERIAL3_CTRL__tr_baud__tr_baud__c300Hz 1
#define R_SYNC_SERIAL3_CTRL__tr_baud__tr_baud__c3125kHz 14
#define R_SYNC_SERIAL3_CTRL__tr_baud__tr_baud__c460k8Hz 12
#define R_SYNC_SERIAL3_CTRL__tr_baud__tr_baud__c4800Hz 5
#define R_SYNC_SERIAL3_CTRL__tr_baud__tr_baud__c57k6Hz 9
#define R_SYNC_SERIAL3_CTRL__tr_baud__tr_baud__c600Hz 2
#define R_SYNC_SERIAL3_CTRL__tr_baud__tr_baud__c921k6Hz 13
#define R_SYNC_SERIAL3_CTRL__tr_baud__tr_baud__c9600Hz 6
#define R_SYNC_SERIAL3_CTRL__dma_enable__dma_enable__off 0
#define R_SYNC_SERIAL3_CTRL__dma_enable__dma_enable__on 1
#define R_SYNC_SERIAL3_CTRL__mode__mode__master_bidir 4
#define R_SYNC_SERIAL3_CTRL__mode__mode__master_input 2
#define R_SYNC_SERIAL3_CTRL__mode__mode__master_output 0
#define R_SYNC_SERIAL3_CTRL__mode__mode__slave_bidir 5
#define R_SYNC_SERIAL3_CTRL__mode__mode__slave_input 3
#define R_SYNC_SERIAL3_CTRL__mode__mode__slave_output 1
#define R_SYNC_SERIAL3_CTRL__error__error__ignore 1
#define R_SYNC_SERIAL3_CTRL__error__error__normal 0
#define R_SYNC_SERIAL3_CTRL__rec_enable__rec_enable__disable 0
#define R_SYNC_SERIAL3_CTRL__rec_enable__rec_enable__enable 1
#define R_SYNC_SERIAL3_CTRL__f_synctype__f_synctype__early 1
#define R_SYNC_SERIAL3_CTRL__f_synctype__f_synctype__normal 0
#define R_SYNC_SERIAL3_CTRL__f_syncsize__f_syncsize__bit 0
#define R_SYNC_SERIAL3_CTRL__f_syncsize__f_syncsize__extended 2
#define R_SYNC_SERIAL3_CTRL__f_syncsize__f_syncsize__word 1
#define R_SYNC_SERIAL3_CTRL__f_sync__f_sync__off 1
#define R_SYNC_SERIAL3_CTRL__f_sync__f_sync__on 0
#define R_SYNC_SERIAL3_CTRL__clk_mode__clk_mode__gated 1
#define R_SYNC_SERIAL3_CTRL__clk_mode__clk_mode__normal 0
#define R_SYNC_SERIAL3_CTRL__clk_halt__clk_halt__running 0
#define R_SYNC_SERIAL3_CTRL__clk_halt__clk_halt__stopped 1
#define R_SYNC_SERIAL3_CTRL__bitorder__bitorder__lsb 0
#define R_SYNC_SERIAL3_CTRL__bitorder__bitorder__msb 1
#define R_SYNC_SERIAL3_CTRL__tr_enable__tr_enable__disable 0
#define R_SYNC_SERIAL3_CTRL__tr_enable__tr_enable__enable 1
#define R_SYNC_SERIAL3_CTRL__wordsize__wordsize__size12bit 1
#define R_SYNC_SERIAL3_CTRL__wordsize__wordsize__size16bit 2
#define R_SYNC_SERIAL3_CTRL__wordsize__wordsize__size24bit 3
#define R_SYNC_SERIAL3_CTRL__wordsize__wordsize__size32bit 4
#define R_SYNC_SERIAL3_CTRL__wordsize__wordsize__size8bit 0
#define R_SYNC_SERIAL3_CTRL__buf_empty__buf_empty__lmt_0 1
#define R_SYNC_SERIAL3_CTRL__buf_empty__buf_empty__lmt_8 0
#define R_SYNC_SERIAL3_CTRL__buf_full__buf_full__lmt_32 0
#define R_SYNC_SERIAL3_CTRL__buf_full__buf_full__lmt_8 1
#define R_SYNC_SERIAL3_CTRL__flow_ctrl__flow_ctrl__disabled 0
#define R_SYNC_SERIAL3_CTRL__flow_ctrl__flow_ctrl__enabled 1
#define R_SYNC_SERIAL3_CTRL__clk_polarity__clk_polarity__neg 1
#define R_SYNC_SERIAL3_CTRL__clk_polarity__clk_polarity__pos 0
#define R_SYNC_SERIAL3_CTRL__frame_polarity__frame_polarity__inverted 1
#define R_SYNC_SERIAL3_CTRL__frame_polarity__frame_polarity__normal 0
#define R_SYNC_SERIAL3_CTRL__status_polarity__status_polarity__inverted 1
#define R_SYNC_SERIAL3_CTRL__status_polarity__status_polarity__normal 0
#define R_SYNC_SERIAL3_CTRL__clk_driver__clk_driver__inverted 1
#define R_SYNC_SERIAL3_CTRL__clk_driver__clk_driver__normal 0
#define R_SYNC_SERIAL3_CTRL__frame_driver__frame_driver__inverted 1
#define R_SYNC_SERIAL3_CTRL__frame_driver__frame_driver__normal 0
#define R_SYNC_SERIAL3_CTRL__status_driver__status_driver__inverted 1
#define R_SYNC_SERIAL3_CTRL__status_driver__status_driver__normal 0
#define R_SYNC_SERIAL3_CTRL__def_out0__def_out0__high 1
#define R_SYNC_SERIAL3_CTRL__def_out0__def_out0__low 0

#endif

/*
 *  R_SYNC_SERIAL3_REC_BYTE
 *  - type:  RO
 *  - addr:  0xb000007c
 *  - group: Syncrounous serial port registers
 */

#if USE_GROUP__Syncrounous_serial_port_registers

#define R_SYNC_SERIAL3_REC_BYTE__ADDR      (REG_TYPECAST_BYTE  0xb000007c)
#define R_SYNC_SERIAL3_REC_BYTE__SVAL      REG_SVAL_SHADOW
#define R_SYNC_SERIAL3_REC_BYTE__SVAL_I    REG_SVAL_I_SHADOW
#define R_SYNC_SERIAL3_REC_BYTE__TYPECAST  REG_TYPECAST_BYTE
#define R_SYNC_SERIAL3_REC_BYTE__TYPE      (REG_BYTE)
#define R_SYNC_SERIAL3_REC_BYTE__GET       REG_GET_RO
#define R_SYNC_SERIAL3_REC_BYTE__IGET      REG_IGET_RO
#define R_SYNC_SERIAL3_REC_BYTE__SET       REG_SET_RO
#define R_SYNC_SERIAL3_REC_BYTE__ISET      REG_ISET_RO
#define R_SYNC_SERIAL3_REC_BYTE__SET_VAL   REG_SET_VAL_RO
#define R_SYNC_SERIAL3_REC_BYTE__EQL       REG_EQL_RO
#define R_SYNC_SERIAL3_REC_BYTE__IEQL      REG_IEQL_RO
#define R_SYNC_SERIAL3_REC_BYTE__RD        REG_RD_RO
#define R_SYNC_SERIAL3_REC_BYTE__IRD       REG_IRD_RO
#define R_SYNC_SERIAL3_REC_BYTE__WR        REG_WR_RO
#define R_SYNC_SERIAL3_REC_BYTE__IWR       REG_IWR_RO

#define R_SYNC_SERIAL3_REC_BYTE__READ(addr) \
  (*(addr))

#define R_SYNC_SERIAL3_REC_BYTE__data_in__data_in__MASK 0x000000ffU

#define R_SYNC_SERIAL3_REC_BYTE__data_in__MAX 0xff

#define R_SYNC_SERIAL3_REC_BYTE__data_in__MIN 0

#define R_SYNC_SERIAL3_REC_BYTE__data_in__BITNR 0

#define R_SYNC_SERIAL3_REC_BYTE__data_in__data_in__VAL REG_VAL_VAL


#endif

/*
 *  R_SYNC_SERIAL3_REC_DATA
 *  - type:  RO
 *  - addr:  0xb000007c
 *  - group: Syncrounous serial port registers
 */

#if USE_GROUP__Syncrounous_serial_port_registers

#define R_SYNC_SERIAL3_REC_DATA__ADDR      (REG_TYPECAST_UDWORD  0xb000007c)
#define R_SYNC_SERIAL3_REC_DATA__SVAL      REG_SVAL_SHADOW
#define R_SYNC_SERIAL3_REC_DATA__SVAL_I    REG_SVAL_I_SHADOW
#define R_SYNC_SERIAL3_REC_DATA__TYPECAST  REG_TYPECAST_UDWORD
#define R_SYNC_SERIAL3_REC_DATA__TYPE      (REG_UDWORD)
#define R_SYNC_SERIAL3_REC_DATA__GET       REG_GET_RO
#define R_SYNC_SERIAL3_REC_DATA__IGET      REG_IGET_RO
#define R_SYNC_SERIAL3_REC_DATA__SET       REG_SET_RO
#define R_SYNC_SERIAL3_REC_DATA__ISET      REG_ISET_RO
#define R_SYNC_SERIAL3_REC_DATA__SET_VAL   REG_SET_VAL_RO
#define R_SYNC_SERIAL3_REC_DATA__EQL       REG_EQL_RO
#define R_SYNC_SERIAL3_REC_DATA__IEQL      REG_IEQL_RO
#define R_SYNC_SERIAL3_REC_DATA__RD        REG_RD_RO
#define R_SYNC_SERIAL3_REC_DATA__IRD       REG_IRD_RO
#define R_SYNC_SERIAL3_REC_DATA__WR        REG_WR_RO
#define R_SYNC_SERIAL3_REC_DATA__IWR       REG_IWR_RO

#define R_SYNC_SERIAL3_REC_DATA__READ(addr) \
  (*(addr))

#define R_SYNC_SERIAL3_REC_DATA__data_in__data_in__MASK 0xffffffffU

#define R_SYNC_SERIAL3_REC_DATA__data_in__MAX 0xffffffff

#define R_SYNC_SERIAL3_REC_DATA__data_in__MIN 0

#define R_SYNC_SERIAL3_REC_DATA__data_in__BITNR 0

#define R_SYNC_SERIAL3_REC_DATA__data_in__data_in__VAL REG_VAL_VAL


#endif

/*
 *  R_SYNC_SERIAL3_REC_WORD
 *  - type:  RO
 *  - addr:  0xb000007c
 *  - group: Syncrounous serial port registers
 */

#if USE_GROUP__Syncrounous_serial_port_registers

#define R_SYNC_SERIAL3_REC_WORD__ADDR      (REG_TYPECAST_UWORD  0xb000007c)
#define R_SYNC_SERIAL3_REC_WORD__SVAL      REG_SVAL_SHADOW
#define R_SYNC_SERIAL3_REC_WORD__SVAL_I    REG_SVAL_I_SHADOW
#define R_SYNC_SERIAL3_REC_WORD__TYPECAST  REG_TYPECAST_UWORD
#define R_SYNC_SERIAL3_REC_WORD__TYPE      (REG_UWORD)
#define R_SYNC_SERIAL3_REC_WORD__GET       REG_GET_RO
#define R_SYNC_SERIAL3_REC_WORD__IGET      REG_IGET_RO
#define R_SYNC_SERIAL3_REC_WORD__SET       REG_SET_RO
#define R_SYNC_SERIAL3_REC_WORD__ISET      REG_ISET_RO
#define R_SYNC_SERIAL3_REC_WORD__SET_VAL   REG_SET_VAL_RO
#define R_SYNC_SERIAL3_REC_WORD__EQL       REG_EQL_RO
#define R_SYNC_SERIAL3_REC_WORD__IEQL      REG_IEQL_RO
#define R_SYNC_SERIAL3_REC_WORD__RD        REG_RD_RO
#define R_SYNC_SERIAL3_REC_WORD__IRD       REG_IRD_RO
#define R_SYNC_SERIAL3_REC_WORD__WR        REG_WR_RO
#define R_SYNC_SERIAL3_REC_WORD__IWR       REG_IWR_RO

#define R_SYNC_SERIAL3_REC_WORD__READ(addr) \
  (*(addr))

#define R_SYNC_SERIAL3_REC_WORD__data_in__data_in__MASK 0x0000ffffU

#define R_SYNC_SERIAL3_REC_WORD__data_in__MAX 0xffff

#define R_SYNC_SERIAL3_REC_WORD__data_in__MIN 0

#define R_SYNC_SERIAL3_REC_WORD__data_in__BITNR 0

#define R_SYNC_SERIAL3_REC_WORD__data_in__data_in__VAL REG_VAL_VAL


#endif

/*
 *  R_SYNC_SERIAL3_STATUS
 *  - type:  RO
 *  - addr:  0xb0000078
 *  - group: Syncrounous serial port registers
 */

#if USE_GROUP__Syncrounous_serial_port_registers

#define R_SYNC_SERIAL3_STATUS__ADDR      (REG_TYPECAST_UDWORD  0xb0000078)
#define R_SYNC_SERIAL3_STATUS__SVAL      REG_SVAL_SHADOW
#define R_SYNC_SERIAL3_STATUS__SVAL_I    REG_SVAL_I_SHADOW
#define R_SYNC_SERIAL3_STATUS__TYPECAST  REG_TYPECAST_UDWORD
#define R_SYNC_SERIAL3_STATUS__TYPE      (REG_UDWORD)
#define R_SYNC_SERIAL3_STATUS__GET       REG_GET_RO
#define R_SYNC_SERIAL3_STATUS__IGET      REG_IGET_RO
#define R_SYNC_SERIAL3_STATUS__SET       REG_SET_RO
#define R_SYNC_SERIAL3_STATUS__ISET      REG_ISET_RO
#define R_SYNC_SERIAL3_STATUS__SET_VAL   REG_SET_VAL_RO
#define R_SYNC_SERIAL3_STATUS__EQL       REG_EQL_RO
#define R_SYNC_SERIAL3_STATUS__IEQL      REG_IEQL_RO
#define R_SYNC_SERIAL3_STATUS__RD        REG_RD_RO
#define R_SYNC_SERIAL3_STATUS__IRD       REG_IRD_RO
#define R_SYNC_SERIAL3_STATUS__WR        REG_WR_RO
#define R_SYNC_SERIAL3_STATUS__IWR       REG_IWR_RO

#define R_SYNC_SERIAL3_STATUS__READ(addr) \
  (*(addr))

#define R_SYNC_SERIAL3_STATUS__rec_status__rec_status__MASK 0x00008000U
#define R_SYNC_SERIAL3_STATUS__tr_empty__tr_empty__MASK 0x00004000U
#define R_SYNC_SERIAL3_STATUS__tr_ready__tr_ready__MASK 0x00002000U
#define R_SYNC_SERIAL3_STATUS__pin_1__pin_1__MASK 0x00001000U
#define R_SYNC_SERIAL3_STATUS__pin_0__pin_0__MASK 0x00000800U
#define R_SYNC_SERIAL3_STATUS__underflow__underflow__MASK 0x00000400U
#define R_SYNC_SERIAL3_STATUS__overrun__overrun__MASK 0x00000200U
#define R_SYNC_SERIAL3_STATUS__data_avail__data_avail__MASK 0x00000100U
#define R_SYNC_SERIAL3_STATUS__data__data__MASK 0x000000ffU

#define R_SYNC_SERIAL3_STATUS__rec_status__MAX 0x1
#define R_SYNC_SERIAL3_STATUS__tr_empty__MAX 0x1
#define R_SYNC_SERIAL3_STATUS__tr_ready__MAX 0x1
#define R_SYNC_SERIAL3_STATUS__pin_1__MAX 0x1
#define R_SYNC_SERIAL3_STATUS__pin_0__MAX 0x1
#define R_SYNC_SERIAL3_STATUS__underflow__MAX 0x1
#define R_SYNC_SERIAL3_STATUS__overrun__MAX 0x1
#define R_SYNC_SERIAL3_STATUS__data_avail__MAX 0x1
#define R_SYNC_SERIAL3_STATUS__data__MAX 0xff

#define R_SYNC_SERIAL3_STATUS__rec_status__MIN 0
#define R_SYNC_SERIAL3_STATUS__tr_empty__MIN 0
#define R_SYNC_SERIAL3_STATUS__tr_ready__MIN 0
#define R_SYNC_SERIAL3_STATUS__pin_1__MIN 0
#define R_SYNC_SERIAL3_STATUS__pin_0__MIN 0
#define R_SYNC_SERIAL3_STATUS__underflow__MIN 0
#define R_SYNC_SERIAL3_STATUS__overrun__MIN 0
#define R_SYNC_SERIAL3_STATUS__data_avail__MIN 0
#define R_SYNC_SERIAL3_STATUS__data__MIN 0

#define R_SYNC_SERIAL3_STATUS__rec_status__BITNR 15
#define R_SYNC_SERIAL3_STATUS__tr_empty__BITNR 14
#define R_SYNC_SERIAL3_STATUS__tr_ready__BITNR 13
#define R_SYNC_SERIAL3_STATUS__pin_1__BITNR 12
#define R_SYNC_SERIAL3_STATUS__pin_0__BITNR 11
#define R_SYNC_SERIAL3_STATUS__underflow__BITNR 10
#define R_SYNC_SERIAL3_STATUS__overrun__BITNR 9
#define R_SYNC_SERIAL3_STATUS__data_avail__BITNR 8
#define R_SYNC_SERIAL3_STATUS__data__BITNR 0

#define R_SYNC_SERIAL3_STATUS__rec_status__rec_status__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL3_STATUS__tr_empty__tr_empty__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL3_STATUS__tr_ready__tr_ready__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL3_STATUS__pin_1__pin_1__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL3_STATUS__pin_0__pin_0__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL3_STATUS__underflow__underflow__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL3_STATUS__overrun__overrun__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL3_STATUS__data_avail__data_avail__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL3_STATUS__data__data__VAL REG_VAL_VAL

#define R_SYNC_SERIAL3_STATUS__rec_status__rec_status__idle 1
#define R_SYNC_SERIAL3_STATUS__rec_status__rec_status__running 0
#define R_SYNC_SERIAL3_STATUS__tr_empty__tr_empty__empty 1
#define R_SYNC_SERIAL3_STATUS__tr_empty__tr_empty__not_empty 0
#define R_SYNC_SERIAL3_STATUS__tr_ready__tr_ready__full 0
#define R_SYNC_SERIAL3_STATUS__tr_ready__tr_ready__ready 1
#define R_SYNC_SERIAL3_STATUS__pin_1__pin_1__high 1
#define R_SYNC_SERIAL3_STATUS__pin_1__pin_1__low 0
#define R_SYNC_SERIAL3_STATUS__pin_0__pin_0__high 1
#define R_SYNC_SERIAL3_STATUS__pin_0__pin_0__low 0
#define R_SYNC_SERIAL3_STATUS__underflow__underflow__no 0
#define R_SYNC_SERIAL3_STATUS__underflow__underflow__yes 1
#define R_SYNC_SERIAL3_STATUS__overrun__overrun__no 0
#define R_SYNC_SERIAL3_STATUS__overrun__overrun__yes 1
#define R_SYNC_SERIAL3_STATUS__data_avail__data_avail__no 0
#define R_SYNC_SERIAL3_STATUS__data_avail__data_avail__yes 1

#endif

/*
 *  R_SYNC_SERIAL3_TR_BYTE
 *  - type:  WO
 *  - addr:  0xb000007c
 *  - group: Syncrounous serial port registers
 */

#if USE_GROUP__Syncrounous_serial_port_registers

#define R_SYNC_SERIAL3_TR_BYTE__ADDR      (REG_TYPECAST_BYTE  0xb000007c)

#ifndef REG_NO_SHADOW
#define R_SYNC_SERIAL3_TR_BYTE__SADDR     (REG_STYPECAST_BYTE (reg_shadow__hwregs.R_SERIAL3_XOFF + 0))
#define R_SYNC_SERIAL3_TR_BYTE__IADDR     (REG_STYPECAST_BYTE (reg_initiated__hwregs.R_SERIAL3_XOFF + 0))
#else /* REG_NO_SHADOW */
#define R_SYNC_SERIAL3_TR_BYTE__SADDR     (REG_STYPECAST_BYTE (&reg_shadow__hwregs))
#define R_SYNC_SERIAL3_TR_BYTE__IADDR     (REG_STYPECAST_BYTE (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_SYNC_SERIAL3_TR_BYTE__STYPECAST REG_STYPECAST_BYTE
#define R_SYNC_SERIAL3_TR_BYTE__SVAL      REG_SVAL_SHADOW
#define R_SYNC_SERIAL3_TR_BYTE__SVAL_I    REG_SVAL_I_SHADOW
#define R_SYNC_SERIAL3_TR_BYTE__TYPECAST  REG_TYPECAST_BYTE
#define R_SYNC_SERIAL3_TR_BYTE__TYPE      (REG_BYTE)
#define R_SYNC_SERIAL3_TR_BYTE__GET       REG_GET_WO
#define R_SYNC_SERIAL3_TR_BYTE__IGET      REG_IGET_WO
#define R_SYNC_SERIAL3_TR_BYTE__SET       REG_SET_WO
#define R_SYNC_SERIAL3_TR_BYTE__ISET      REG_ISET_WO
#define R_SYNC_SERIAL3_TR_BYTE__SET_VAL   REG_SET_VAL_WO
#define R_SYNC_SERIAL3_TR_BYTE__EQL       REG_EQL_WO
#define R_SYNC_SERIAL3_TR_BYTE__IEQL      REG_IEQL_WO
#define R_SYNC_SERIAL3_TR_BYTE__RD        REG_RD_WO
#define R_SYNC_SERIAL3_TR_BYTE__IRD       REG_IRD_WO
#define R_SYNC_SERIAL3_TR_BYTE__WR        REG_WR_WO
#define R_SYNC_SERIAL3_TR_BYTE__IWR       REG_IWR_WO

#define R_SYNC_SERIAL3_TR_BYTE__WRITE(addr,value) \
  (*(addr) = (value))

#define R_SYNC_SERIAL3_TR_BYTE__data_out__data_out__MASK 0x000000ffU

#define R_SYNC_SERIAL3_TR_BYTE__data_out__MAX 0xff

#define R_SYNC_SERIAL3_TR_BYTE__data_out__MIN 0

#define R_SYNC_SERIAL3_TR_BYTE__data_out__BITNR 0

#define R_SYNC_SERIAL3_TR_BYTE__data_out__data_out__VAL REG_VAL_VAL


#endif

/*
 *  R_SYNC_SERIAL3_TR_DATA
 *  - type:  WO
 *  - addr:  0xb000007c
 *  - group: Syncrounous serial port registers
 */

#if USE_GROUP__Syncrounous_serial_port_registers

#define R_SYNC_SERIAL3_TR_DATA__ADDR      (REG_TYPECAST_UDWORD  0xb000007c)

#ifndef REG_NO_SHADOW
#define R_SYNC_SERIAL3_TR_DATA__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_SERIAL3_XOFF + 0))
#define R_SYNC_SERIAL3_TR_DATA__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_SERIAL3_XOFF + 0))
#else /* REG_NO_SHADOW */
#define R_SYNC_SERIAL3_TR_DATA__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_SYNC_SERIAL3_TR_DATA__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_SYNC_SERIAL3_TR_DATA__STYPECAST REG_STYPECAST_UDWORD
#define R_SYNC_SERIAL3_TR_DATA__SVAL      REG_SVAL_SHADOW
#define R_SYNC_SERIAL3_TR_DATA__SVAL_I    REG_SVAL_I_SHADOW
#define R_SYNC_SERIAL3_TR_DATA__TYPECAST  REG_TYPECAST_UDWORD
#define R_SYNC_SERIAL3_TR_DATA__TYPE      (REG_UDWORD)
#define R_SYNC_SERIAL3_TR_DATA__GET       REG_GET_WO
#define R_SYNC_SERIAL3_TR_DATA__IGET      REG_IGET_WO
#define R_SYNC_SERIAL3_TR_DATA__SET       REG_SET_WO
#define R_SYNC_SERIAL3_TR_DATA__ISET      REG_ISET_WO
#define R_SYNC_SERIAL3_TR_DATA__SET_VAL   REG_SET_VAL_WO
#define R_SYNC_SERIAL3_TR_DATA__EQL       REG_EQL_WO
#define R_SYNC_SERIAL3_TR_DATA__IEQL      REG_IEQL_WO
#define R_SYNC_SERIAL3_TR_DATA__RD        REG_RD_WO
#define R_SYNC_SERIAL3_TR_DATA__IRD       REG_IRD_WO
#define R_SYNC_SERIAL3_TR_DATA__WR        REG_WR_WO
#define R_SYNC_SERIAL3_TR_DATA__IWR       REG_IWR_WO

#define R_SYNC_SERIAL3_TR_DATA__WRITE(addr,value) \
  (*(addr) = (value))

#define R_SYNC_SERIAL3_TR_DATA__data_out__data_out__MASK 0xffffffffU

#define R_SYNC_SERIAL3_TR_DATA__data_out__MAX 0xffffffff

#define R_SYNC_SERIAL3_TR_DATA__data_out__MIN 0

#define R_SYNC_SERIAL3_TR_DATA__data_out__BITNR 0

#define R_SYNC_SERIAL3_TR_DATA__data_out__data_out__VAL REG_VAL_VAL


#endif

/*
 *  R_SYNC_SERIAL3_TR_WORD
 *  - type:  WO
 *  - addr:  0xb000007c
 *  - group: Syncrounous serial port registers
 */

#if USE_GROUP__Syncrounous_serial_port_registers

#define R_SYNC_SERIAL3_TR_WORD__ADDR      (REG_TYPECAST_UWORD  0xb000007c)

#ifndef REG_NO_SHADOW
#define R_SYNC_SERIAL3_TR_WORD__SADDR     (REG_STYPECAST_UWORD (reg_shadow__hwregs.R_SERIAL3_XOFF + 0))
#define R_SYNC_SERIAL3_TR_WORD__IADDR     (REG_STYPECAST_UWORD (reg_initiated__hwregs.R_SERIAL3_XOFF + 0))
#else /* REG_NO_SHADOW */
#define R_SYNC_SERIAL3_TR_WORD__SADDR     (REG_STYPECAST_UWORD (&reg_shadow__hwregs))
#define R_SYNC_SERIAL3_TR_WORD__IADDR     (REG_STYPECAST_UWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_SYNC_SERIAL3_TR_WORD__STYPECAST REG_STYPECAST_UWORD
#define R_SYNC_SERIAL3_TR_WORD__SVAL      REG_SVAL_SHADOW
#define R_SYNC_SERIAL3_TR_WORD__SVAL_I    REG_SVAL_I_SHADOW
#define R_SYNC_SERIAL3_TR_WORD__TYPECAST  REG_TYPECAST_UWORD
#define R_SYNC_SERIAL3_TR_WORD__TYPE      (REG_UWORD)
#define R_SYNC_SERIAL3_TR_WORD__GET       REG_GET_WO
#define R_SYNC_SERIAL3_TR_WORD__IGET      REG_IGET_WO
#define R_SYNC_SERIAL3_TR_WORD__SET       REG_SET_WO
#define R_SYNC_SERIAL3_TR_WORD__ISET      REG_ISET_WO
#define R_SYNC_SERIAL3_TR_WORD__SET_VAL   REG_SET_VAL_WO
#define R_SYNC_SERIAL3_TR_WORD__EQL       REG_EQL_WO
#define R_SYNC_SERIAL3_TR_WORD__IEQL      REG_IEQL_WO
#define R_SYNC_SERIAL3_TR_WORD__RD        REG_RD_WO
#define R_SYNC_SERIAL3_TR_WORD__IRD       REG_IRD_WO
#define R_SYNC_SERIAL3_TR_WORD__WR        REG_WR_WO
#define R_SYNC_SERIAL3_TR_WORD__IWR       REG_IWR_WO

#define R_SYNC_SERIAL3_TR_WORD__WRITE(addr,value) \
  (*(addr) = (value))

#define R_SYNC_SERIAL3_TR_WORD__data_out__data_out__MASK 0x0000ffffU

#define R_SYNC_SERIAL3_TR_WORD__data_out__MAX 0xffff

#define R_SYNC_SERIAL3_TR_WORD__data_out__MIN 0

#define R_SYNC_SERIAL3_TR_WORD__data_out__BITNR 0

#define R_SYNC_SERIAL3_TR_WORD__data_out__data_out__VAL REG_VAL_VAL


#endif

/*
 *  R_SYNC_SERIAL_PRESCALE
 *  - type:  WO
 *  - addr:  0xb00000f4
 *  - group: Timer registers
 */

#if USE_GROUP__Timer_registers

#define R_SYNC_SERIAL_PRESCALE__ADDR      (REG_TYPECAST_UDWORD  0xb00000f4)

#ifndef REG_NO_SHADOW
#define R_SYNC_SERIAL_PRESCALE__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_SYNC_SERIAL_PRESCALE + 0))
#define R_SYNC_SERIAL_PRESCALE__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_SYNC_SERIAL_PRESCALE + 0))
#else /* REG_NO_SHADOW */
#define R_SYNC_SERIAL_PRESCALE__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_SYNC_SERIAL_PRESCALE__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_SYNC_SERIAL_PRESCALE__STYPECAST REG_STYPECAST_UDWORD
#define R_SYNC_SERIAL_PRESCALE__SVAL      REG_SVAL_SHADOW
#define R_SYNC_SERIAL_PRESCALE__SVAL_I    REG_SVAL_I_SHADOW
#define R_SYNC_SERIAL_PRESCALE__TYPECAST  REG_TYPECAST_UDWORD
#define R_SYNC_SERIAL_PRESCALE__TYPE      (REG_UDWORD)
#define R_SYNC_SERIAL_PRESCALE__GET       REG_GET_WO
#define R_SYNC_SERIAL_PRESCALE__IGET      REG_IGET_WO
#define R_SYNC_SERIAL_PRESCALE__SET       REG_SET_WO
#define R_SYNC_SERIAL_PRESCALE__ISET      REG_ISET_WO
#define R_SYNC_SERIAL_PRESCALE__SET_VAL   REG_SET_VAL_WO
#define R_SYNC_SERIAL_PRESCALE__EQL       REG_EQL_WO
#define R_SYNC_SERIAL_PRESCALE__IEQL      REG_IEQL_WO
#define R_SYNC_SERIAL_PRESCALE__RD        REG_RD_WO
#define R_SYNC_SERIAL_PRESCALE__IRD       REG_IRD_WO
#define R_SYNC_SERIAL_PRESCALE__WR        REG_WR_WO
#define R_SYNC_SERIAL_PRESCALE__IWR       REG_IWR_WO

#define R_SYNC_SERIAL_PRESCALE__WRITE(addr,value) \
  (*(addr) = (value))

#define R_SYNC_SERIAL_PRESCALE__clk_sel_u3__clk_sel_u3__MASK 0x00800000U
#define R_SYNC_SERIAL_PRESCALE__word_stb_sel_u3__word_stb_sel_u3__MASK 0x00400000U
#define R_SYNC_SERIAL_PRESCALE__clk_sel_u1__clk_sel_u1__MASK 0x00200000U
#define R_SYNC_SERIAL_PRESCALE__word_stb_sel_u1__word_stb_sel_u1__MASK 0x00100000U
#define R_SYNC_SERIAL_PRESCALE__prescaler__prescaler__MASK 0x00070000U
#define R_SYNC_SERIAL_PRESCALE__warp_mode__warp_mode__MASK 0x00008000U
#define R_SYNC_SERIAL_PRESCALE__frame_rate__frame_rate__MASK 0x00007800U
#define R_SYNC_SERIAL_PRESCALE__word_rate__word_rate__MASK 0x000003ffU

#define R_SYNC_SERIAL_PRESCALE__clk_sel_u3__MAX 0x1
#define R_SYNC_SERIAL_PRESCALE__word_stb_sel_u3__MAX 0x1
#define R_SYNC_SERIAL_PRESCALE__clk_sel_u1__MAX 0x1
#define R_SYNC_SERIAL_PRESCALE__word_stb_sel_u1__MAX 0x1
#define R_SYNC_SERIAL_PRESCALE__prescaler__MAX 0x7
#define R_SYNC_SERIAL_PRESCALE__warp_mode__MAX 0x1
#define R_SYNC_SERIAL_PRESCALE__frame_rate__MAX 0xf
#define R_SYNC_SERIAL_PRESCALE__word_rate__MAX 0x3ff

#define R_SYNC_SERIAL_PRESCALE__clk_sel_u3__MIN 0
#define R_SYNC_SERIAL_PRESCALE__word_stb_sel_u3__MIN 0
#define R_SYNC_SERIAL_PRESCALE__clk_sel_u1__MIN 0
#define R_SYNC_SERIAL_PRESCALE__word_stb_sel_u1__MIN 0
#define R_SYNC_SERIAL_PRESCALE__prescaler__MIN 0
#define R_SYNC_SERIAL_PRESCALE__warp_mode__MIN 0
#define R_SYNC_SERIAL_PRESCALE__frame_rate__MIN 0
#define R_SYNC_SERIAL_PRESCALE__word_rate__MIN 0

#define R_SYNC_SERIAL_PRESCALE__clk_sel_u3__BITNR 23
#define R_SYNC_SERIAL_PRESCALE__word_stb_sel_u3__BITNR 22
#define R_SYNC_SERIAL_PRESCALE__clk_sel_u1__BITNR 21
#define R_SYNC_SERIAL_PRESCALE__word_stb_sel_u1__BITNR 20
#define R_SYNC_SERIAL_PRESCALE__prescaler__BITNR 16
#define R_SYNC_SERIAL_PRESCALE__warp_mode__BITNR 15
#define R_SYNC_SERIAL_PRESCALE__frame_rate__BITNR 11
#define R_SYNC_SERIAL_PRESCALE__word_rate__BITNR 0

#define R_SYNC_SERIAL_PRESCALE__clk_sel_u3__clk_sel_u3__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL_PRESCALE__word_stb_sel_u3__word_stb_sel_u3__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL_PRESCALE__clk_sel_u1__clk_sel_u1__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL_PRESCALE__word_stb_sel_u1__word_stb_sel_u1__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL_PRESCALE__prescaler__prescaler__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL_PRESCALE__warp_mode__warp_mode__VAL REG_VAL_ENUM
#define R_SYNC_SERIAL_PRESCALE__frame_rate__frame_rate__VAL REG_VAL_VAL
#define R_SYNC_SERIAL_PRESCALE__word_rate__word_rate__VAL REG_VAL_VAL

#define R_SYNC_SERIAL_PRESCALE__clk_sel_u3__clk_sel_u3__baudrate 1
#define R_SYNC_SERIAL_PRESCALE__clk_sel_u3__clk_sel_u3__codec 0
#define R_SYNC_SERIAL_PRESCALE__word_stb_sel_u3__word_stb_sel_u3__external 0
#define R_SYNC_SERIAL_PRESCALE__word_stb_sel_u3__word_stb_sel_u3__internal 1
#define R_SYNC_SERIAL_PRESCALE__clk_sel_u1__clk_sel_u1__baudrate 1
#define R_SYNC_SERIAL_PRESCALE__clk_sel_u1__clk_sel_u1__codec 0
#define R_SYNC_SERIAL_PRESCALE__word_stb_sel_u1__word_stb_sel_u1__external 0
#define R_SYNC_SERIAL_PRESCALE__word_stb_sel_u1__word_stb_sel_u1__internal 1
#define R_SYNC_SERIAL_PRESCALE__prescaler__prescaler__div1 0
#define R_SYNC_SERIAL_PRESCALE__prescaler__prescaler__div128 7
#define R_SYNC_SERIAL_PRESCALE__prescaler__prescaler__div16 4
#define R_SYNC_SERIAL_PRESCALE__prescaler__prescaler__div2 1
#define R_SYNC_SERIAL_PRESCALE__prescaler__prescaler__div32 5
#define R_SYNC_SERIAL_PRESCALE__prescaler__prescaler__div4 2
#define R_SYNC_SERIAL_PRESCALE__prescaler__prescaler__div64 6
#define R_SYNC_SERIAL_PRESCALE__prescaler__prescaler__div8 3
#define R_SYNC_SERIAL_PRESCALE__warp_mode__warp_mode__enabled 1
#define R_SYNC_SERIAL_PRESCALE__warp_mode__warp_mode__normal 0

#endif

/*
 *  R_TEST_MODE
 *  - type:  WO
 *  - addr:  0xb00000fc
 *  - group: Test mode registers
 */

#if USE_GROUP__Test_mode_registers

#define R_TEST_MODE__ADDR      (REG_TYPECAST_UDWORD  0xb00000fc)

#ifndef REG_NO_SHADOW
#define R_TEST_MODE__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_TEST_MODE + 0))
#define R_TEST_MODE__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_TEST_MODE + 0))
#else /* REG_NO_SHADOW */
#define R_TEST_MODE__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_TEST_MODE__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_TEST_MODE__STYPECAST REG_STYPECAST_UDWORD
#define R_TEST_MODE__SVAL      REG_SVAL_SHADOW
#define R_TEST_MODE__SVAL_I    REG_SVAL_I_SHADOW
#define R_TEST_MODE__TYPECAST  REG_TYPECAST_UDWORD
#define R_TEST_MODE__TYPE      (REG_UDWORD)
#define R_TEST_MODE__GET       REG_GET_WO
#define R_TEST_MODE__IGET      REG_IGET_WO
#define R_TEST_MODE__SET       REG_SET_WO
#define R_TEST_MODE__ISET      REG_ISET_WO
#define R_TEST_MODE__SET_VAL   REG_SET_VAL_WO
#define R_TEST_MODE__EQL       REG_EQL_WO
#define R_TEST_MODE__IEQL      REG_IEQL_WO
#define R_TEST_MODE__RD        REG_RD_WO
#define R_TEST_MODE__IRD       REG_IRD_WO
#define R_TEST_MODE__WR        REG_WR_WO
#define R_TEST_MODE__IWR       REG_IWR_WO

#define R_TEST_MODE__WRITE(addr,value) \
  (*(addr) = (value))

#define R_TEST_MODE__single_step__single_step__MASK 0x00080000U
#define R_TEST_MODE__step_wr__step_wr__MASK 0x00040000U
#define R_TEST_MODE__step_rd__step_rd__MASK 0x00020000U
#define R_TEST_MODE__step_fetch__step_fetch__MASK 0x00010000U
#define R_TEST_MODE__mmu_test__mmu_test__MASK 0x00001000U
#define R_TEST_MODE__usb_test__usb_test__MASK 0x00000800U
#define R_TEST_MODE__scsi_timer_test__scsi_timer_test__MASK 0x00000400U
#define R_TEST_MODE__backoff__backoff__MASK 0x00000200U
#define R_TEST_MODE__snmp_test__snmp_test__MASK 0x00000100U
#define R_TEST_MODE__snmp_inc__snmp_inc__MASK 0x00000080U
#define R_TEST_MODE__ser_loop__ser_loop__MASK 0x00000040U
#define R_TEST_MODE__baudrate__baudrate__MASK 0x00000020U
#define R_TEST_MODE__timer__timer__MASK 0x00000018U
#define R_TEST_MODE__cache_test__cache_test__MASK 0x00000004U
#define R_TEST_MODE__tag_test__tag_test__MASK 0x00000002U
#define R_TEST_MODE__cache_enable__cache_enable__MASK 0x00000001U

#define R_TEST_MODE__single_step__MAX 0x1
#define R_TEST_MODE__step_wr__MAX 0x1
#define R_TEST_MODE__step_rd__MAX 0x1
#define R_TEST_MODE__step_fetch__MAX 0x1
#define R_TEST_MODE__mmu_test__MAX 0x1
#define R_TEST_MODE__usb_test__MAX 0x1
#define R_TEST_MODE__scsi_timer_test__MAX 0x1
#define R_TEST_MODE__backoff__MAX 0x1
#define R_TEST_MODE__snmp_test__MAX 0x1
#define R_TEST_MODE__snmp_inc__MAX 0x1
#define R_TEST_MODE__ser_loop__MAX 0x1
#define R_TEST_MODE__baudrate__MAX 0x1
#define R_TEST_MODE__timer__MAX 0x3
#define R_TEST_MODE__cache_test__MAX 0x1
#define R_TEST_MODE__tag_test__MAX 0x1
#define R_TEST_MODE__cache_enable__MAX 0x1

#define R_TEST_MODE__single_step__MIN 0
#define R_TEST_MODE__step_wr__MIN 0
#define R_TEST_MODE__step_rd__MIN 0
#define R_TEST_MODE__step_fetch__MIN 0
#define R_TEST_MODE__mmu_test__MIN 0
#define R_TEST_MODE__usb_test__MIN 0
#define R_TEST_MODE__scsi_timer_test__MIN 0
#define R_TEST_MODE__backoff__MIN 0
#define R_TEST_MODE__snmp_test__MIN 0
#define R_TEST_MODE__snmp_inc__MIN 0
#define R_TEST_MODE__ser_loop__MIN 0
#define R_TEST_MODE__baudrate__MIN 0
#define R_TEST_MODE__timer__MIN 0
#define R_TEST_MODE__cache_test__MIN 0
#define R_TEST_MODE__tag_test__MIN 0
#define R_TEST_MODE__cache_enable__MIN 0

#define R_TEST_MODE__single_step__BITNR 19
#define R_TEST_MODE__step_wr__BITNR 18
#define R_TEST_MODE__step_rd__BITNR 17
#define R_TEST_MODE__step_fetch__BITNR 16
#define R_TEST_MODE__mmu_test__BITNR 12
#define R_TEST_MODE__usb_test__BITNR 11
#define R_TEST_MODE__scsi_timer_test__BITNR 10
#define R_TEST_MODE__backoff__BITNR 9
#define R_TEST_MODE__snmp_test__BITNR 8
#define R_TEST_MODE__snmp_inc__BITNR 7
#define R_TEST_MODE__ser_loop__BITNR 6
#define R_TEST_MODE__baudrate__BITNR 5
#define R_TEST_MODE__timer__BITNR 3
#define R_TEST_MODE__cache_test__BITNR 2
#define R_TEST_MODE__tag_test__BITNR 1
#define R_TEST_MODE__cache_enable__BITNR 0

#define R_TEST_MODE__single_step__single_step__VAL REG_VAL_ENUM
#define R_TEST_MODE__step_wr__step_wr__VAL REG_VAL_ENUM
#define R_TEST_MODE__step_rd__step_rd__VAL REG_VAL_ENUM
#define R_TEST_MODE__step_fetch__step_fetch__VAL REG_VAL_ENUM
#define R_TEST_MODE__mmu_test__mmu_test__VAL REG_VAL_ENUM
#define R_TEST_MODE__usb_test__usb_test__VAL REG_VAL_ENUM
#define R_TEST_MODE__scsi_timer_test__scsi_timer_test__VAL REG_VAL_ENUM
#define R_TEST_MODE__backoff__backoff__VAL REG_VAL_ENUM
#define R_TEST_MODE__snmp_test__snmp_test__VAL REG_VAL_ENUM
#define R_TEST_MODE__snmp_inc__snmp_inc__VAL REG_VAL_ENUM
#define R_TEST_MODE__ser_loop__ser_loop__VAL REG_VAL_ENUM
#define R_TEST_MODE__baudrate__baudrate__VAL REG_VAL_ENUM
#define R_TEST_MODE__timer__timer__VAL REG_VAL_ENUM
#define R_TEST_MODE__cache_test__cache_test__VAL REG_VAL_ENUM
#define R_TEST_MODE__tag_test__tag_test__VAL REG_VAL_ENUM
#define R_TEST_MODE__cache_enable__cache_enable__VAL REG_VAL_ENUM

#define R_TEST_MODE__single_step__single_step__off 0
#define R_TEST_MODE__single_step__single_step__on 1
#define R_TEST_MODE__step_wr__step_wr__off 0
#define R_TEST_MODE__step_wr__step_wr__on 1
#define R_TEST_MODE__step_rd__step_rd__off 0
#define R_TEST_MODE__step_rd__step_rd__on 1
#define R_TEST_MODE__step_fetch__step_fetch__off 0
#define R_TEST_MODE__step_fetch__step_fetch__on 1
#define R_TEST_MODE__mmu_test__mmu_test__off 0
#define R_TEST_MODE__mmu_test__mmu_test__on 1
#define R_TEST_MODE__usb_test__usb_test__off 0
#define R_TEST_MODE__usb_test__usb_test__on 1
#define R_TEST_MODE__scsi_timer_test__scsi_timer_test__off 0
#define R_TEST_MODE__scsi_timer_test__scsi_timer_test__on 1
#define R_TEST_MODE__backoff__backoff__off 0
#define R_TEST_MODE__backoff__backoff__on 1
#define R_TEST_MODE__snmp_test__snmp_test__off 0
#define R_TEST_MODE__snmp_test__snmp_test__on 1
#define R_TEST_MODE__snmp_inc__snmp_inc__do 1
#define R_TEST_MODE__snmp_inc__snmp_inc__dont 0
#define R_TEST_MODE__ser_loop__ser_loop__off 0
#define R_TEST_MODE__ser_loop__ser_loop__on 1
#define R_TEST_MODE__baudrate__baudrate__off 0
#define R_TEST_MODE__baudrate__baudrate__on 1
#define R_TEST_MODE__timer__timer__all 3
#define R_TEST_MODE__timer__timer__even 1
#define R_TEST_MODE__timer__timer__odd 2
#define R_TEST_MODE__timer__timer__off 0
#define R_TEST_MODE__cache_test__cache_test__normal 0
#define R_TEST_MODE__cache_test__cache_test__test 1
#define R_TEST_MODE__tag_test__tag_test__normal 0
#define R_TEST_MODE__tag_test__tag_test__test 1
#define R_TEST_MODE__cache_enable__cache_enable__disable 0
#define R_TEST_MODE__cache_enable__cache_enable__enable 1

#endif

/*
 *  R_TIMER01_DATA
 *  - type:  RO
 *  - addr:  0xb0000022
 *  - group: Timer registers
 */

#if USE_GROUP__Timer_registers

#define R_TIMER01_DATA__ADDR      (REG_TYPECAST_UWORD  0xb0000022)
#define R_TIMER01_DATA__SVAL      REG_SVAL_SHADOW
#define R_TIMER01_DATA__SVAL_I    REG_SVAL_I_SHADOW
#define R_TIMER01_DATA__TYPECAST  REG_TYPECAST_UWORD
#define R_TIMER01_DATA__TYPE      (REG_UWORD)
#define R_TIMER01_DATA__GET       REG_GET_RO
#define R_TIMER01_DATA__IGET      REG_IGET_RO
#define R_TIMER01_DATA__SET       REG_SET_RO
#define R_TIMER01_DATA__ISET      REG_ISET_RO
#define R_TIMER01_DATA__SET_VAL   REG_SET_VAL_RO
#define R_TIMER01_DATA__EQL       REG_EQL_RO
#define R_TIMER01_DATA__IEQL      REG_IEQL_RO
#define R_TIMER01_DATA__RD        REG_RD_RO
#define R_TIMER01_DATA__IRD       REG_IRD_RO
#define R_TIMER01_DATA__WR        REG_WR_RO
#define R_TIMER01_DATA__IWR       REG_IWR_RO

#define R_TIMER01_DATA__READ(addr) \
  (*(addr))

#define R_TIMER01_DATA__count__count__MASK 0x0000ffffU

#define R_TIMER01_DATA__count__MAX 0xffff

#define R_TIMER01_DATA__count__MIN 0

#define R_TIMER01_DATA__count__BITNR 0

#define R_TIMER01_DATA__count__count__VAL REG_VAL_VAL


#endif

/*
 *  R_TIMER0_DATA
 *  - type:  RO
 *  - addr:  0xb0000022
 *  - group: Timer registers
 */

#if USE_GROUP__Timer_registers

#define R_TIMER0_DATA__ADDR      (REG_TYPECAST_BYTE  0xb0000022)
#define R_TIMER0_DATA__SVAL      REG_SVAL_SHADOW
#define R_TIMER0_DATA__SVAL_I    REG_SVAL_I_SHADOW
#define R_TIMER0_DATA__TYPECAST  REG_TYPECAST_BYTE
#define R_TIMER0_DATA__TYPE      (REG_BYTE)
#define R_TIMER0_DATA__GET       REG_GET_RO
#define R_TIMER0_DATA__IGET      REG_IGET_RO
#define R_TIMER0_DATA__SET       REG_SET_RO
#define R_TIMER0_DATA__ISET      REG_ISET_RO
#define R_TIMER0_DATA__SET_VAL   REG_SET_VAL_RO
#define R_TIMER0_DATA__EQL       REG_EQL_RO
#define R_TIMER0_DATA__IEQL      REG_IEQL_RO
#define R_TIMER0_DATA__RD        REG_RD_RO
#define R_TIMER0_DATA__IRD       REG_IRD_RO
#define R_TIMER0_DATA__WR        REG_WR_RO
#define R_TIMER0_DATA__IWR       REG_IWR_RO

#define R_TIMER0_DATA__READ(addr) \
  (*(addr))

#define R_TIMER0_DATA__count__count__MASK 0x000000ffU

#define R_TIMER0_DATA__count__MAX 0xff

#define R_TIMER0_DATA__count__MIN 0

#define R_TIMER0_DATA__count__BITNR 0

#define R_TIMER0_DATA__count__count__VAL REG_VAL_VAL


#endif

/*
 *  R_TIMER1_DATA
 *  - type:  RO
 *  - addr:  0xb0000023
 *  - group: Timer registers
 */

#if USE_GROUP__Timer_registers

#define R_TIMER1_DATA__ADDR      (REG_TYPECAST_BYTE  0xb0000023)
#define R_TIMER1_DATA__SVAL      REG_SVAL_SHADOW
#define R_TIMER1_DATA__SVAL_I    REG_SVAL_I_SHADOW
#define R_TIMER1_DATA__TYPECAST  REG_TYPECAST_BYTE
#define R_TIMER1_DATA__TYPE      (REG_BYTE)
#define R_TIMER1_DATA__GET       REG_GET_RO
#define R_TIMER1_DATA__IGET      REG_IGET_RO
#define R_TIMER1_DATA__SET       REG_SET_RO
#define R_TIMER1_DATA__ISET      REG_ISET_RO
#define R_TIMER1_DATA__SET_VAL   REG_SET_VAL_RO
#define R_TIMER1_DATA__EQL       REG_EQL_RO
#define R_TIMER1_DATA__IEQL      REG_IEQL_RO
#define R_TIMER1_DATA__RD        REG_RD_RO
#define R_TIMER1_DATA__IRD       REG_IRD_RO
#define R_TIMER1_DATA__WR        REG_WR_RO
#define R_TIMER1_DATA__IWR       REG_IWR_RO

#define R_TIMER1_DATA__READ(addr) \
  (*(addr))

#define R_TIMER1_DATA__count__count__MASK 0x000000ffU

#define R_TIMER1_DATA__count__MAX 0xff

#define R_TIMER1_DATA__count__MIN 0

#define R_TIMER1_DATA__count__BITNR 0

#define R_TIMER1_DATA__count__count__VAL REG_VAL_VAL


#endif

/*
 *  R_TIMER_CTRL
 *  - type:  WO
 *  - addr:  0xb0000020
 *  - group: Timer registers
 */

#if USE_GROUP__Timer_registers

#define R_TIMER_CTRL__ADDR      (REG_TYPECAST_UDWORD  0xb0000020)

#ifndef REG_NO_SHADOW
#define R_TIMER_CTRL__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_TIMER_CTRL + 0))
#define R_TIMER_CTRL__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_TIMER_CTRL + 0))
#else /* REG_NO_SHADOW */
#define R_TIMER_CTRL__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_TIMER_CTRL__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_TIMER_CTRL__STYPECAST REG_STYPECAST_UDWORD
#define R_TIMER_CTRL__SVAL      REG_SVAL_SHADOW
#define R_TIMER_CTRL__SVAL_I    REG_SVAL_I_SHADOW
#define R_TIMER_CTRL__TYPECAST  REG_TYPECAST_UDWORD
#define R_TIMER_CTRL__TYPE      (REG_UDWORD)
#define R_TIMER_CTRL__GET       REG_GET_WO
#define R_TIMER_CTRL__IGET      REG_IGET_WO
#define R_TIMER_CTRL__SET       REG_SET_WO
#define R_TIMER_CTRL__ISET      REG_ISET_WO
#define R_TIMER_CTRL__SET_VAL   REG_SET_VAL_WO
#define R_TIMER_CTRL__EQL       REG_EQL_WO
#define R_TIMER_CTRL__IEQL      REG_IEQL_WO
#define R_TIMER_CTRL__RD        REG_RD_WO
#define R_TIMER_CTRL__IRD       REG_IRD_WO
#define R_TIMER_CTRL__WR        REG_WR_WO
#define R_TIMER_CTRL__IWR       REG_IWR_WO

#define R_TIMER_CTRL__WRITE(addr,value) \
  (*(addr) = (value))

#define R_TIMER_CTRL__timerdiv1__timerdiv1__MASK 0xff000000U
#define R_TIMER_CTRL__timerdiv0__timerdiv0__MASK 0x00ff0000U
#define R_TIMER_CTRL__presc_timer1__presc_timer1__MASK 0x00008000U
#define R_TIMER_CTRL__i1__i1__MASK 0x00004000U
#define R_TIMER_CTRL__tm1__tm1__MASK 0x00003000U
#define R_TIMER_CTRL__clksel1__clksel1__MASK 0x00000f00U
#define R_TIMER_CTRL__presc_ext__presc_ext__MASK 0x00000080U
#define R_TIMER_CTRL__i0__i0__MASK 0x00000040U
#define R_TIMER_CTRL__tm0__tm0__MASK 0x00000030U
#define R_TIMER_CTRL__clksel0__clksel0__MASK 0x0000000fU

#define R_TIMER_CTRL__timerdiv1__MAX 0xff
#define R_TIMER_CTRL__timerdiv0__MAX 0xff
#define R_TIMER_CTRL__presc_timer1__MAX 0x1
#define R_TIMER_CTRL__i1__MAX 0x1
#define R_TIMER_CTRL__tm1__MAX 0x3
#define R_TIMER_CTRL__clksel1__MAX 0xf
#define R_TIMER_CTRL__presc_ext__MAX 0x1
#define R_TIMER_CTRL__i0__MAX 0x1
#define R_TIMER_CTRL__tm0__MAX 0x3
#define R_TIMER_CTRL__clksel0__MAX 0xf

#define R_TIMER_CTRL__timerdiv1__MIN 0
#define R_TIMER_CTRL__timerdiv0__MIN 0
#define R_TIMER_CTRL__presc_timer1__MIN 0
#define R_TIMER_CTRL__i1__MIN 0
#define R_TIMER_CTRL__tm1__MIN 0
#define R_TIMER_CTRL__clksel1__MIN 0
#define R_TIMER_CTRL__presc_ext__MIN 0
#define R_TIMER_CTRL__i0__MIN 0
#define R_TIMER_CTRL__tm0__MIN 0
#define R_TIMER_CTRL__clksel0__MIN 0

#define R_TIMER_CTRL__timerdiv1__BITNR 24
#define R_TIMER_CTRL__timerdiv0__BITNR 16
#define R_TIMER_CTRL__presc_timer1__BITNR 15
#define R_TIMER_CTRL__i1__BITNR 14
#define R_TIMER_CTRL__tm1__BITNR 12
#define R_TIMER_CTRL__clksel1__BITNR 8
#define R_TIMER_CTRL__presc_ext__BITNR 7
#define R_TIMER_CTRL__i0__BITNR 6
#define R_TIMER_CTRL__tm0__BITNR 4
#define R_TIMER_CTRL__clksel0__BITNR 0

#define R_TIMER_CTRL__timerdiv1__timerdiv1__VAL REG_VAL_VAL
#define R_TIMER_CTRL__timerdiv0__timerdiv0__VAL REG_VAL_VAL
#define R_TIMER_CTRL__presc_timer1__presc_timer1__VAL REG_VAL_ENUM
#define R_TIMER_CTRL__i1__i1__VAL REG_VAL_ENUM
#define R_TIMER_CTRL__tm1__tm1__VAL REG_VAL_ENUM
#define R_TIMER_CTRL__clksel1__clksel1__VAL REG_VAL_ENUM
#define R_TIMER_CTRL__presc_ext__presc_ext__VAL REG_VAL_ENUM
#define R_TIMER_CTRL__i0__i0__VAL REG_VAL_ENUM
#define R_TIMER_CTRL__tm0__tm0__VAL REG_VAL_ENUM
#define R_TIMER_CTRL__clksel0__clksel0__VAL REG_VAL_ENUM

#define R_TIMER_CTRL__presc_timer1__presc_timer1__normal 0
#define R_TIMER_CTRL__presc_timer1__presc_timer1__prescale 1
#define R_TIMER_CTRL__i1__i1__clr 1
#define R_TIMER_CTRL__i1__i1__nop 0
#define R_TIMER_CTRL__tm1__tm1__freeze 1
#define R_TIMER_CTRL__tm1__tm1__run 2
#define R_TIMER_CTRL__tm1__tm1__stop_ld 0
#define R_TIMER_CTRL__clksel1__clksel1__c115k2Hz 9
#define R_TIMER_CTRL__clksel1__clksel1__c1200Hz 2
#define R_TIMER_CTRL__clksel1__clksel1__c1843k2Hz 13
#define R_TIMER_CTRL__clksel1__clksel1__c19k2Hz 6
#define R_TIMER_CTRL__clksel1__clksel1__c230k4Hz 10
#define R_TIMER_CTRL__clksel1__clksel1__c2400Hz 3
#define R_TIMER_CTRL__clksel1__clksel1__c300Hz 0
#define R_TIMER_CTRL__clksel1__clksel1__c38k4Hz 7
#define R_TIMER_CTRL__clksel1__clksel1__c460k8Hz 11
#define R_TIMER_CTRL__clksel1__clksel1__c4800Hz 4
#define R_TIMER_CTRL__clksel1__clksel1__c57k6Hz 8
#define R_TIMER_CTRL__clksel1__clksel1__c600Hz 1
#define R_TIMER_CTRL__clksel1__clksel1__c6250kHz 14
#define R_TIMER_CTRL__clksel1__clksel1__c921k6Hz 12
#define R_TIMER_CTRL__clksel1__clksel1__c9600Hz 5
#define R_TIMER_CTRL__clksel1__clksel1__cascade0 15
#define R_TIMER_CTRL__presc_ext__presc_ext__external 1
#define R_TIMER_CTRL__presc_ext__presc_ext__prescale 0
#define R_TIMER_CTRL__i0__i0__clr 1
#define R_TIMER_CTRL__i0__i0__nop 0
#define R_TIMER_CTRL__tm0__tm0__freeze 1
#define R_TIMER_CTRL__tm0__tm0__run 2
#define R_TIMER_CTRL__tm0__tm0__stop_ld 0
#define R_TIMER_CTRL__clksel0__clksel0__c115k2Hz 9
#define R_TIMER_CTRL__clksel0__clksel0__c1200Hz 2
#define R_TIMER_CTRL__clksel0__clksel0__c1843k2Hz 13
#define R_TIMER_CTRL__clksel0__clksel0__c19k2Hz 6
#define R_TIMER_CTRL__clksel0__clksel0__c230k4Hz 10
#define R_TIMER_CTRL__clksel0__clksel0__c2400Hz 3
#define R_TIMER_CTRL__clksel0__clksel0__c300Hz 0
#define R_TIMER_CTRL__clksel0__clksel0__c38k4Hz 7
#define R_TIMER_CTRL__clksel0__clksel0__c460k8Hz 11
#define R_TIMER_CTRL__clksel0__clksel0__c4800Hz 4
#define R_TIMER_CTRL__clksel0__clksel0__c57k6Hz 8
#define R_TIMER_CTRL__clksel0__clksel0__c600Hz 1
#define R_TIMER_CTRL__clksel0__clksel0__c6250kHz 14
#define R_TIMER_CTRL__clksel0__clksel0__c921k6Hz 12
#define R_TIMER_CTRL__clksel0__clksel0__c9600Hz 5
#define R_TIMER_CTRL__clksel0__clksel0__flexible 15

#endif

/*
 *  R_TIMER_DATA
 *  - type:  RO
 *  - addr:  0xb0000020
 *  - group: Timer registers
 */

#if USE_GROUP__Timer_registers

#define R_TIMER_DATA__ADDR      (REG_TYPECAST_UDWORD  0xb0000020)
#define R_TIMER_DATA__SVAL      REG_SVAL_SHADOW
#define R_TIMER_DATA__SVAL_I    REG_SVAL_I_SHADOW
#define R_TIMER_DATA__TYPECAST  REG_TYPECAST_UDWORD
#define R_TIMER_DATA__TYPE      (REG_UDWORD)
#define R_TIMER_DATA__GET       REG_GET_RO
#define R_TIMER_DATA__IGET      REG_IGET_RO
#define R_TIMER_DATA__SET       REG_SET_RO
#define R_TIMER_DATA__ISET      REG_ISET_RO
#define R_TIMER_DATA__SET_VAL   REG_SET_VAL_RO
#define R_TIMER_DATA__EQL       REG_EQL_RO
#define R_TIMER_DATA__IEQL      REG_IEQL_RO
#define R_TIMER_DATA__RD        REG_RD_RO
#define R_TIMER_DATA__IRD       REG_IRD_RO
#define R_TIMER_DATA__WR        REG_WR_RO
#define R_TIMER_DATA__IWR       REG_IWR_RO

#define R_TIMER_DATA__READ(addr) \
  (*(addr))

#define R_TIMER_DATA__timer1__timer1__MASK 0xff000000U
#define R_TIMER_DATA__timer0__timer0__MASK 0x00ff0000U
#define R_TIMER_DATA__clkdiv_high__clkdiv_high__MASK 0x0000ff00U
#define R_TIMER_DATA__clkdiv_low__clkdiv_low__MASK 0x000000ffU

#define R_TIMER_DATA__timer1__MAX 0xff
#define R_TIMER_DATA__timer0__MAX 0xff
#define R_TIMER_DATA__clkdiv_high__MAX 0xff
#define R_TIMER_DATA__clkdiv_low__MAX 0xff

#define R_TIMER_DATA__timer1__MIN 0
#define R_TIMER_DATA__timer0__MIN 0
#define R_TIMER_DATA__clkdiv_high__MIN 0
#define R_TIMER_DATA__clkdiv_low__MIN 0

#define R_TIMER_DATA__timer1__BITNR 24
#define R_TIMER_DATA__timer0__BITNR 16
#define R_TIMER_DATA__clkdiv_high__BITNR 8
#define R_TIMER_DATA__clkdiv_low__BITNR 0

#define R_TIMER_DATA__timer1__timer1__VAL REG_VAL_VAL
#define R_TIMER_DATA__timer0__timer0__VAL REG_VAL_VAL
#define R_TIMER_DATA__clkdiv_high__clkdiv_high__VAL REG_VAL_VAL
#define R_TIMER_DATA__clkdiv_low__clkdiv_low__VAL REG_VAL_VAL


#endif

/*
 *  R_TIMER_PRESCALE
 *  - type:  WO
 *  - addr:  0xb00000f0
 *  - group: Timer registers
 */

#if USE_GROUP__Timer_registers

#define R_TIMER_PRESCALE__ADDR      (REG_TYPECAST_UWORD  0xb00000f0)

#ifndef REG_NO_SHADOW
#define R_TIMER_PRESCALE__SADDR     (REG_STYPECAST_UWORD (reg_shadow__hwregs.R_CLOCK_PRESCALE + 0))
#define R_TIMER_PRESCALE__IADDR     (REG_STYPECAST_UWORD (reg_initiated__hwregs.R_CLOCK_PRESCALE + 0))
#else /* REG_NO_SHADOW */
#define R_TIMER_PRESCALE__SADDR     (REG_STYPECAST_UWORD (&reg_shadow__hwregs))
#define R_TIMER_PRESCALE__IADDR     (REG_STYPECAST_UWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_TIMER_PRESCALE__STYPECAST REG_STYPECAST_UWORD
#define R_TIMER_PRESCALE__SVAL      REG_SVAL_SHADOW
#define R_TIMER_PRESCALE__SVAL_I    REG_SVAL_I_SHADOW
#define R_TIMER_PRESCALE__TYPECAST  REG_TYPECAST_UWORD
#define R_TIMER_PRESCALE__TYPE      (REG_UWORD)
#define R_TIMER_PRESCALE__GET       REG_GET_WO
#define R_TIMER_PRESCALE__IGET      REG_IGET_WO
#define R_TIMER_PRESCALE__SET       REG_SET_WO
#define R_TIMER_PRESCALE__ISET      REG_ISET_WO
#define R_TIMER_PRESCALE__SET_VAL   REG_SET_VAL_WO
#define R_TIMER_PRESCALE__EQL       REG_EQL_WO
#define R_TIMER_PRESCALE__IEQL      REG_IEQL_WO
#define R_TIMER_PRESCALE__RD        REG_RD_WO
#define R_TIMER_PRESCALE__IRD       REG_IRD_WO
#define R_TIMER_PRESCALE__WR        REG_WR_WO
#define R_TIMER_PRESCALE__IWR       REG_IWR_WO

#define R_TIMER_PRESCALE__WRITE(addr,value) \
  (*(addr) = (value))

#define R_TIMER_PRESCALE__tim_presc__tim_presc__MASK 0x0000ffffU

#define R_TIMER_PRESCALE__tim_presc__MAX 0xffff

#define R_TIMER_PRESCALE__tim_presc__MIN 0

#define R_TIMER_PRESCALE__tim_presc__BITNR 0

#define R_TIMER_PRESCALE__tim_presc__tim_presc__VAL REG_VAL_VAL


#endif

/*
 *  R_TIM_PRESC_STATUS
 *  - type:  RO
 *  - addr:  0xb00000f0
 *  - group: Timer registers
 */

#if USE_GROUP__Timer_registers

#define R_TIM_PRESC_STATUS__ADDR      (REG_TYPECAST_UWORD  0xb00000f0)
#define R_TIM_PRESC_STATUS__SVAL      REG_SVAL_SHADOW
#define R_TIM_PRESC_STATUS__SVAL_I    REG_SVAL_I_SHADOW
#define R_TIM_PRESC_STATUS__TYPECAST  REG_TYPECAST_UWORD
#define R_TIM_PRESC_STATUS__TYPE      (REG_UWORD)
#define R_TIM_PRESC_STATUS__GET       REG_GET_RO
#define R_TIM_PRESC_STATUS__IGET      REG_IGET_RO
#define R_TIM_PRESC_STATUS__SET       REG_SET_RO
#define R_TIM_PRESC_STATUS__ISET      REG_ISET_RO
#define R_TIM_PRESC_STATUS__SET_VAL   REG_SET_VAL_RO
#define R_TIM_PRESC_STATUS__EQL       REG_EQL_RO
#define R_TIM_PRESC_STATUS__IEQL      REG_IEQL_RO
#define R_TIM_PRESC_STATUS__RD        REG_RD_RO
#define R_TIM_PRESC_STATUS__IRD       REG_IRD_RO
#define R_TIM_PRESC_STATUS__WR        REG_WR_RO
#define R_TIM_PRESC_STATUS__IWR       REG_IWR_RO

#define R_TIM_PRESC_STATUS__READ(addr) \
  (*(addr))

#define R_TIM_PRESC_STATUS__tim_status__tim_status__MASK 0x0000ffffU

#define R_TIM_PRESC_STATUS__tim_status__MAX 0xffff

#define R_TIM_PRESC_STATUS__tim_status__MIN 0

#define R_TIM_PRESC_STATUS__tim_status__BITNR 0

#define R_TIM_PRESC_STATUS__tim_status__tim_status__VAL REG_VAL_VAL


#endif

/*
 *  R_TLB_HI
 *  - type:  RW
 *  - addr:  0xb000025c
 *  - group: MMU registers
 */

#if USE_GROUP__MMU_registers

#define R_TLB_HI__ADDR      (REG_TYPECAST_UDWORD  0xb000025c)
#define R_TLB_HI__SVAL      REG_SVAL_SHADOW
#define R_TLB_HI__SVAL_I    REG_SVAL_I_SHADOW
#define R_TLB_HI__TYPECAST  REG_TYPECAST_UDWORD
#define R_TLB_HI__TYPE      (REG_UDWORD)
#define R_TLB_HI__GET       REG_GET_RW
#define R_TLB_HI__IGET      REG_IGET_RW
#define R_TLB_HI__SET       REG_SET_RW
#define R_TLB_HI__ISET      REG_ISET_RW
#define R_TLB_HI__SET_VAL   REG_SET_VAL_RW
#define R_TLB_HI__EQL       REG_EQL_RW
#define R_TLB_HI__IEQL      REG_IEQL_RW
#define R_TLB_HI__RD        REG_RD_RW
#define R_TLB_HI__IRD       REG_IRD_RW
#define R_TLB_HI__WR        REG_WR_RW
#define R_TLB_HI__IWR       REG_IWR_RW

#define R_TLB_HI__WRITE(addr,value) \
  (*(addr) = (value))
#define R_TLB_HI__READ(addr) \
  (*(addr))

#define R_TLB_HI__vpn__vpn__MASK 0xffffe000U
#define R_TLB_HI__page_id__page_id__MASK 0x0000003fU

#define R_TLB_HI__vpn__MAX 0x7ffff
#define R_TLB_HI__page_id__MAX 63

#define R_TLB_HI__vpn__MIN 0
#define R_TLB_HI__page_id__MIN 0

#define R_TLB_HI__vpn__BITNR 13
#define R_TLB_HI__page_id__BITNR 0

#define R_TLB_HI__vpn__vpn__VAL REG_VAL_VAL
#define R_TLB_HI__page_id__page_id__VAL REG_VAL_VAL


#endif

/*
 *  R_TLB_LO
 *  - type:  RW
 *  - addr:  0xb0000258
 *  - group: MMU registers
 */

#if USE_GROUP__MMU_registers

#define R_TLB_LO__ADDR      (REG_TYPECAST_UDWORD  0xb0000258)
#define R_TLB_LO__SVAL      REG_SVAL_SHADOW
#define R_TLB_LO__SVAL_I    REG_SVAL_I_SHADOW
#define R_TLB_LO__TYPECAST  REG_TYPECAST_UDWORD
#define R_TLB_LO__TYPE      (REG_UDWORD)
#define R_TLB_LO__GET       REG_GET_RW
#define R_TLB_LO__IGET      REG_IGET_RW
#define R_TLB_LO__SET       REG_SET_RW
#define R_TLB_LO__ISET      REG_ISET_RW
#define R_TLB_LO__SET_VAL   REG_SET_VAL_RW
#define R_TLB_LO__EQL       REG_EQL_RW
#define R_TLB_LO__IEQL      REG_IEQL_RW
#define R_TLB_LO__RD        REG_RD_RW
#define R_TLB_LO__IRD       REG_IRD_RW
#define R_TLB_LO__WR        REG_WR_RW
#define R_TLB_LO__IWR       REG_IWR_RW

#define R_TLB_LO__WRITE(addr,value) \
  (*(addr) = (value))
#define R_TLB_LO__READ(addr) \
  (*(addr))

#define R_TLB_LO__pfn__pfn__MASK 0xffffe000U
#define R_TLB_LO__global__global__MASK 0x00000008U
#define R_TLB_LO__valid__valid__MASK 0x00000004U
#define R_TLB_LO__kernel__kernel__MASK 0x00000002U
#define R_TLB_LO__we__we__MASK 0x00000001U

#define R_TLB_LO__pfn__MAX 0x7ffff
#define R_TLB_LO__global__MAX 0x1
#define R_TLB_LO__valid__MAX 0x1
#define R_TLB_LO__kernel__MAX 0x1
#define R_TLB_LO__we__MAX 0x1

#define R_TLB_LO__pfn__MIN 0
#define R_TLB_LO__global__MIN 0
#define R_TLB_LO__valid__MIN 0
#define R_TLB_LO__kernel__MIN 0
#define R_TLB_LO__we__MIN 0

#define R_TLB_LO__pfn__BITNR 13
#define R_TLB_LO__global__BITNR 3
#define R_TLB_LO__valid__BITNR 2
#define R_TLB_LO__kernel__BITNR 1
#define R_TLB_LO__we__BITNR 0

#define R_TLB_LO__pfn__pfn__VAL REG_VAL_VAL
#define R_TLB_LO__global__global__VAL REG_VAL_ENUM
#define R_TLB_LO__valid__valid__VAL REG_VAL_ENUM
#define R_TLB_LO__kernel__kernel__VAL REG_VAL_ENUM
#define R_TLB_LO__we__we__VAL REG_VAL_ENUM

#define R_TLB_LO__global__global__no 0
#define R_TLB_LO__global__global__yes 1
#define R_TLB_LO__valid__valid__no 0
#define R_TLB_LO__valid__valid__yes 1
#define R_TLB_LO__kernel__kernel__no 0
#define R_TLB_LO__kernel__kernel__yes 1
#define R_TLB_LO__we__we__no 0
#define R_TLB_LO__we__we__yes 1

#endif

/*
 *  R_TLB_SELECT
 *  - type:  RW
 *  - addr:  0xb0000254
 *  - group: MMU registers
 */

#if USE_GROUP__MMU_registers

#define R_TLB_SELECT__ADDR      (REG_TYPECAST_BYTE  0xb0000254)
#define R_TLB_SELECT__SVAL      REG_SVAL_SHADOW
#define R_TLB_SELECT__SVAL_I    REG_SVAL_I_SHADOW
#define R_TLB_SELECT__TYPECAST  REG_TYPECAST_BYTE
#define R_TLB_SELECT__TYPE      (REG_BYTE)
#define R_TLB_SELECT__GET       REG_GET_RW
#define R_TLB_SELECT__IGET      REG_IGET_RW
#define R_TLB_SELECT__SET       REG_SET_RW
#define R_TLB_SELECT__ISET      REG_ISET_RW
#define R_TLB_SELECT__SET_VAL   REG_SET_VAL_RW
#define R_TLB_SELECT__EQL       REG_EQL_RW
#define R_TLB_SELECT__IEQL      REG_IEQL_RW
#define R_TLB_SELECT__RD        REG_RD_RW
#define R_TLB_SELECT__IRD       REG_IRD_RW
#define R_TLB_SELECT__WR        REG_WR_RW
#define R_TLB_SELECT__IWR       REG_IWR_RW

#define R_TLB_SELECT__WRITE(addr,value) \
  (*(addr) = (value))
#define R_TLB_SELECT__READ(addr) \
  (*(addr))

#define R_TLB_SELECT__index__index__MASK 0x0000003fU

#define R_TLB_SELECT__index__MAX 63

#define R_TLB_SELECT__index__MIN 0

#define R_TLB_SELECT__index__BITNR 0

#define R_TLB_SELECT__index__index__VAL REG_VAL_VAL


#endif

/*
 *  R_TR_COUNTERS
 *  - type:  RO
 *  - addr:  0xb00000a8
 *  - group: Network interface registers
 */

#if USE_GROUP__Network_interface_registers

#define R_TR_COUNTERS__ADDR      (REG_TYPECAST_UDWORD  0xb00000a8)
#define R_TR_COUNTERS__SVAL      REG_SVAL_SHADOW
#define R_TR_COUNTERS__SVAL_I    REG_SVAL_I_SHADOW
#define R_TR_COUNTERS__TYPECAST  REG_TYPECAST_UDWORD
#define R_TR_COUNTERS__TYPE      (REG_UDWORD)
#define R_TR_COUNTERS__GET       REG_GET_RO
#define R_TR_COUNTERS__IGET      REG_IGET_RO
#define R_TR_COUNTERS__SET       REG_SET_RO
#define R_TR_COUNTERS__ISET      REG_ISET_RO
#define R_TR_COUNTERS__SET_VAL   REG_SET_VAL_RO
#define R_TR_COUNTERS__EQL       REG_EQL_RO
#define R_TR_COUNTERS__IEQL      REG_IEQL_RO
#define R_TR_COUNTERS__RD        REG_RD_RO
#define R_TR_COUNTERS__IRD       REG_IRD_RO
#define R_TR_COUNTERS__WR        REG_WR_RO
#define R_TR_COUNTERS__IWR       REG_IWR_RO

#define R_TR_COUNTERS__READ(addr) \
  (*(addr))

#define R_TR_COUNTERS__deferred__deferred__MASK 0xff000000U
#define R_TR_COUNTERS__late_col__late_col__MASK 0x00ff0000U
#define R_TR_COUNTERS__multiple_col__multiple_col__MASK 0x0000ff00U
#define R_TR_COUNTERS__single_col__single_col__MASK 0x000000ffU

#define R_TR_COUNTERS__deferred__MAX 0xff
#define R_TR_COUNTERS__late_col__MAX 0xff
#define R_TR_COUNTERS__multiple_col__MAX 0xff
#define R_TR_COUNTERS__single_col__MAX 0xff

#define R_TR_COUNTERS__deferred__MIN 0
#define R_TR_COUNTERS__late_col__MIN 0
#define R_TR_COUNTERS__multiple_col__MIN 0
#define R_TR_COUNTERS__single_col__MIN 0

#define R_TR_COUNTERS__deferred__BITNR 24
#define R_TR_COUNTERS__late_col__BITNR 16
#define R_TR_COUNTERS__multiple_col__BITNR 8
#define R_TR_COUNTERS__single_col__BITNR 0

#define R_TR_COUNTERS__deferred__deferred__VAL REG_VAL_VAL
#define R_TR_COUNTERS__late_col__late_col__VAL REG_VAL_VAL
#define R_TR_COUNTERS__multiple_col__multiple_col__VAL REG_VAL_VAL
#define R_TR_COUNTERS__single_col__single_col__VAL REG_VAL_VAL


#endif

/*
 *  R_USB_COMMAND
 *  - type:  RW
 *  - addr:  0xb0000201
 *  - group: USB interface control registers
 */

#if USE_GROUP__USB_interface_control_registers

#define R_USB_COMMAND__ADDR      (REG_TYPECAST_BYTE  0xb0000201)
#define R_USB_COMMAND__SVAL      REG_SVAL_SHADOW
#define R_USB_COMMAND__SVAL_I    REG_SVAL_I_SHADOW
#define R_USB_COMMAND__TYPECAST  REG_TYPECAST_BYTE
#define R_USB_COMMAND__TYPE      (REG_BYTE)
#define R_USB_COMMAND__GET       REG_GET_RW
#define R_USB_COMMAND__IGET      REG_IGET_RW
#define R_USB_COMMAND__SET       REG_SET_RW
#define R_USB_COMMAND__ISET      REG_ISET_RW
#define R_USB_COMMAND__SET_VAL   REG_SET_VAL_RW
#define R_USB_COMMAND__EQL       REG_EQL_RW
#define R_USB_COMMAND__IEQL      REG_IEQL_RW
#define R_USB_COMMAND__RD        REG_RD_RW
#define R_USB_COMMAND__IRD       REG_IRD_RW
#define R_USB_COMMAND__WR        REG_WR_RW
#define R_USB_COMMAND__IWR       REG_IWR_RW

#define R_USB_COMMAND__WRITE(addr,value) \
  (*(addr) = (value))
#define R_USB_COMMAND__READ(addr) \
  (*(addr))

#define R_USB_COMMAND__port_sel__port_sel__MASK 0x000000c0U
#define R_USB_COMMAND__port_cmd__port_cmd__MASK 0x00000030U
#define R_USB_COMMAND__busy__busy__MASK 0x00000008U
#define R_USB_COMMAND__ctrl_cmd__ctrl_cmd__MASK 0x00000007U

#define R_USB_COMMAND__port_sel__MAX 0x3
#define R_USB_COMMAND__port_cmd__MAX 0x3
#define R_USB_COMMAND__busy__MAX 0x1
#define R_USB_COMMAND__ctrl_cmd__MAX 0x7

#define R_USB_COMMAND__port_sel__MIN 0
#define R_USB_COMMAND__port_cmd__MIN 0
#define R_USB_COMMAND__busy__MIN 0
#define R_USB_COMMAND__ctrl_cmd__MIN 0

#define R_USB_COMMAND__port_sel__BITNR 6
#define R_USB_COMMAND__port_cmd__BITNR 4
#define R_USB_COMMAND__busy__BITNR 3
#define R_USB_COMMAND__ctrl_cmd__BITNR 0

#define R_USB_COMMAND__port_sel__port_sel__VAL REG_VAL_ENUM
#define R_USB_COMMAND__port_cmd__port_cmd__VAL REG_VAL_ENUM
#define R_USB_COMMAND__busy__busy__VAL REG_VAL_ENUM
#define R_USB_COMMAND__ctrl_cmd__ctrl_cmd__VAL REG_VAL_ENUM

#define R_USB_COMMAND__port_sel__port_sel__both 3
#define R_USB_COMMAND__port_sel__port_sel__nop 0
#define R_USB_COMMAND__port_sel__port_sel__port1 1
#define R_USB_COMMAND__port_sel__port_sel__port2 2
#define R_USB_COMMAND__port_cmd__port_cmd__disable 1
#define R_USB_COMMAND__port_cmd__port_cmd__reset 0
#define R_USB_COMMAND__port_cmd__port_cmd__resume 3
#define R_USB_COMMAND__port_cmd__port_cmd__suspend 2
#define R_USB_COMMAND__busy__busy__no 0
#define R_USB_COMMAND__busy__busy__yes 1
#define R_USB_COMMAND__ctrl_cmd__ctrl_cmd__deconfig 2
#define R_USB_COMMAND__ctrl_cmd__ctrl_cmd__dev_config 4
#define R_USB_COMMAND__ctrl_cmd__ctrl_cmd__host_config 3
#define R_USB_COMMAND__ctrl_cmd__ctrl_cmd__host_nop 5
#define R_USB_COMMAND__ctrl_cmd__ctrl_cmd__host_run 6
#define R_USB_COMMAND__ctrl_cmd__ctrl_cmd__host_stop 7
#define R_USB_COMMAND__ctrl_cmd__ctrl_cmd__nop 0
#define R_USB_COMMAND__ctrl_cmd__ctrl_cmd__reset 1

#endif

/*
 *  R_USB_COMMAND_DEV
 *  - type:  RW
 *  - addr:  0xb0000201
 *  - group: USB interface control registers
 */

#if USE_GROUP__USB_interface_control_registers

#define R_USB_COMMAND_DEV__ADDR      (REG_TYPECAST_BYTE  0xb0000201)
#define R_USB_COMMAND_DEV__SVAL      REG_SVAL_SHADOW
#define R_USB_COMMAND_DEV__SVAL_I    REG_SVAL_I_SHADOW
#define R_USB_COMMAND_DEV__TYPECAST  REG_TYPECAST_BYTE
#define R_USB_COMMAND_DEV__TYPE      (REG_BYTE)
#define R_USB_COMMAND_DEV__GET       REG_GET_RW
#define R_USB_COMMAND_DEV__IGET      REG_IGET_RW
#define R_USB_COMMAND_DEV__SET       REG_SET_RW
#define R_USB_COMMAND_DEV__ISET      REG_ISET_RW
#define R_USB_COMMAND_DEV__SET_VAL   REG_SET_VAL_RW
#define R_USB_COMMAND_DEV__EQL       REG_EQL_RW
#define R_USB_COMMAND_DEV__IEQL      REG_IEQL_RW
#define R_USB_COMMAND_DEV__RD        REG_RD_RW
#define R_USB_COMMAND_DEV__IRD       REG_IRD_RW
#define R_USB_COMMAND_DEV__WR        REG_WR_RW
#define R_USB_COMMAND_DEV__IWR       REG_IWR_RW

#define R_USB_COMMAND_DEV__WRITE(addr,value) \
  (*(addr) = (value))
#define R_USB_COMMAND_DEV__READ(addr) \
  (*(addr))

#define R_USB_COMMAND_DEV__port_sel__port_sel__MASK 0x000000c0U
#define R_USB_COMMAND_DEV__port_cmd__port_cmd__MASK 0x00000030U
#define R_USB_COMMAND_DEV__busy__busy__MASK 0x00000008U
#define R_USB_COMMAND_DEV__ctrl_cmd__ctrl_cmd__MASK 0x00000007U

#define R_USB_COMMAND_DEV__port_sel__MAX 0x3
#define R_USB_COMMAND_DEV__port_cmd__MAX 0x3
#define R_USB_COMMAND_DEV__busy__MAX 0x1
#define R_USB_COMMAND_DEV__ctrl_cmd__MAX 0x7

#define R_USB_COMMAND_DEV__port_sel__MIN 0
#define R_USB_COMMAND_DEV__port_cmd__MIN 0
#define R_USB_COMMAND_DEV__busy__MIN 0
#define R_USB_COMMAND_DEV__ctrl_cmd__MIN 0

#define R_USB_COMMAND_DEV__port_sel__BITNR 6
#define R_USB_COMMAND_DEV__port_cmd__BITNR 4
#define R_USB_COMMAND_DEV__busy__BITNR 3
#define R_USB_COMMAND_DEV__ctrl_cmd__BITNR 0

#define R_USB_COMMAND_DEV__port_sel__port_sel__VAL REG_VAL_ENUM
#define R_USB_COMMAND_DEV__port_cmd__port_cmd__VAL REG_VAL_ENUM
#define R_USB_COMMAND_DEV__busy__busy__VAL REG_VAL_ENUM
#define R_USB_COMMAND_DEV__ctrl_cmd__ctrl_cmd__VAL REG_VAL_ENUM

#define R_USB_COMMAND_DEV__port_sel__port_sel__any 3
#define R_USB_COMMAND_DEV__port_sel__port_sel__dummy1 1
#define R_USB_COMMAND_DEV__port_sel__port_sel__dummy2 2
#define R_USB_COMMAND_DEV__port_sel__port_sel__nop 0
#define R_USB_COMMAND_DEV__port_cmd__port_cmd__active 0
#define R_USB_COMMAND_DEV__port_cmd__port_cmd__nop 2
#define R_USB_COMMAND_DEV__port_cmd__port_cmd__passive 1
#define R_USB_COMMAND_DEV__port_cmd__port_cmd__wakeup 3
#define R_USB_COMMAND_DEV__busy__busy__no 0
#define R_USB_COMMAND_DEV__busy__busy__yes 1
#define R_USB_COMMAND_DEV__ctrl_cmd__ctrl_cmd__deconfig 2
#define R_USB_COMMAND_DEV__ctrl_cmd__ctrl_cmd__dev_config 4
#define R_USB_COMMAND_DEV__ctrl_cmd__ctrl_cmd__dev_nop 1
#define R_USB_COMMAND_DEV__ctrl_cmd__ctrl_cmd__dev_nop2 5
#define R_USB_COMMAND_DEV__ctrl_cmd__ctrl_cmd__dev_nop3 6
#define R_USB_COMMAND_DEV__ctrl_cmd__ctrl_cmd__dev_nop4 7
#define R_USB_COMMAND_DEV__ctrl_cmd__ctrl_cmd__host_config 3
#define R_USB_COMMAND_DEV__ctrl_cmd__ctrl_cmd__nop 0

#endif

/*
 *  R_USB_EPID_ATTN
 *  - type:  RO
 *  - addr:  0xb0000224
 *  - group: USB interface control registers
 */

#if USE_GROUP__USB_interface_control_registers

#define R_USB_EPID_ATTN__ADDR      (REG_TYPECAST_UDWORD  0xb0000224)
#define R_USB_EPID_ATTN__SVAL      REG_SVAL_SHADOW
#define R_USB_EPID_ATTN__SVAL_I    REG_SVAL_I_SHADOW
#define R_USB_EPID_ATTN__TYPECAST  REG_TYPECAST_UDWORD
#define R_USB_EPID_ATTN__TYPE      (REG_UDWORD)
#define R_USB_EPID_ATTN__GET       REG_GET_RO
#define R_USB_EPID_ATTN__IGET      REG_IGET_RO
#define R_USB_EPID_ATTN__SET       REG_SET_RO
#define R_USB_EPID_ATTN__ISET      REG_ISET_RO
#define R_USB_EPID_ATTN__SET_VAL   REG_SET_VAL_RO
#define R_USB_EPID_ATTN__EQL       REG_EQL_RO
#define R_USB_EPID_ATTN__IEQL      REG_IEQL_RO
#define R_USB_EPID_ATTN__RD        REG_RD_RO
#define R_USB_EPID_ATTN__IRD       REG_IRD_RO
#define R_USB_EPID_ATTN__WR        REG_WR_RO
#define R_USB_EPID_ATTN__IWR       REG_IWR_RO

#define R_USB_EPID_ATTN__READ(addr) \
  (*(addr))

#define R_USB_EPID_ATTN__value__value__MASK 0xffffffffU

#define R_USB_EPID_ATTN__value__MAX 0xffffffff

#define R_USB_EPID_ATTN__value__MIN 0

#define R_USB_EPID_ATTN__value__BITNR 0

#define R_USB_EPID_ATTN__value__value__VAL REG_VAL_VAL


#endif

/*
 *  R_USB_EPT_DATA
 *  - type:  RW
 *  - addr:  0xb000021c
 *  - group: USB interface control registers
 */

#if USE_GROUP__USB_interface_control_registers

#define R_USB_EPT_DATA__ADDR      (REG_TYPECAST_UDWORD  0xb000021c)
#define R_USB_EPT_DATA__SVAL      REG_SVAL_SHADOW
#define R_USB_EPT_DATA__SVAL_I    REG_SVAL_I_SHADOW
#define R_USB_EPT_DATA__TYPECAST  REG_TYPECAST_UDWORD
#define R_USB_EPT_DATA__TYPE      (REG_UDWORD)
#define R_USB_EPT_DATA__GET       REG_GET_RW
#define R_USB_EPT_DATA__IGET      REG_IGET_RW
#define R_USB_EPT_DATA__SET       REG_SET_RW
#define R_USB_EPT_DATA__ISET      REG_ISET_RW
#define R_USB_EPT_DATA__SET_VAL   REG_SET_VAL_RW
#define R_USB_EPT_DATA__EQL       REG_EQL_RW
#define R_USB_EPT_DATA__IEQL      REG_IEQL_RW
#define R_USB_EPT_DATA__RD        REG_RD_RW
#define R_USB_EPT_DATA__IRD       REG_IRD_RW
#define R_USB_EPT_DATA__WR        REG_WR_RW
#define R_USB_EPT_DATA__IWR       REG_IWR_RW

#define R_USB_EPT_DATA__WRITE(addr,value) \
  (*(addr) = (value))
#define R_USB_EPT_DATA__READ(addr) \
  (*(addr))

#define R_USB_EPT_DATA__valid__valid__MASK 0x80000000U
#define R_USB_EPT_DATA__hold__hold__MASK 0x40000000U
#define R_USB_EPT_DATA__error_count_in__error_count_in__MASK 0x30000000U
#define R_USB_EPT_DATA__t_in__t_in__MASK 0x08000000U
#define R_USB_EPT_DATA__low_speed__low_speed__MASK 0x04000000U
#define R_USB_EPT_DATA__port__port__MASK 0x03000000U
#define R_USB_EPT_DATA__error_code__error_code__MASK 0x00c00000U
#define R_USB_EPT_DATA__t_out__t_out__MASK 0x00200000U
#define R_USB_EPT_DATA__error_count_out__error_count_out__MASK 0x00180000U
#define R_USB_EPT_DATA__max_len__max_len__MASK 0x0003f800U
#define R_USB_EPT_DATA__ep__ep__MASK 0x00000780U
#define R_USB_EPT_DATA__dev__dev__MASK 0x0000007fU

#define R_USB_EPT_DATA__valid__MAX 0x1
#define R_USB_EPT_DATA__hold__MAX 0x1
#define R_USB_EPT_DATA__error_count_in__MAX 3
#define R_USB_EPT_DATA__t_in__MAX 1
#define R_USB_EPT_DATA__low_speed__MAX 0x1
#define R_USB_EPT_DATA__port__MAX 0x3
#define R_USB_EPT_DATA__error_code__MAX 0x3
#define R_USB_EPT_DATA__t_out__MAX 1
#define R_USB_EPT_DATA__error_count_out__MAX 3
#define R_USB_EPT_DATA__max_len__MAX 64
#define R_USB_EPT_DATA__ep__MAX 0xf
#define R_USB_EPT_DATA__dev__MAX 0x7f

#define R_USB_EPT_DATA__valid__MIN 0
#define R_USB_EPT_DATA__hold__MIN 0
#define R_USB_EPT_DATA__error_count_in__MIN 0
#define R_USB_EPT_DATA__t_in__MIN 0
#define R_USB_EPT_DATA__low_speed__MIN 0
#define R_USB_EPT_DATA__port__MIN 0
#define R_USB_EPT_DATA__error_code__MIN 0
#define R_USB_EPT_DATA__t_out__MIN 0
#define R_USB_EPT_DATA__error_count_out__MIN 0
#define R_USB_EPT_DATA__max_len__MIN 1
#define R_USB_EPT_DATA__ep__MIN 0
#define R_USB_EPT_DATA__dev__MIN 0

#define R_USB_EPT_DATA__valid__BITNR 31
#define R_USB_EPT_DATA__hold__BITNR 30
#define R_USB_EPT_DATA__error_count_in__BITNR 28
#define R_USB_EPT_DATA__t_in__BITNR 27
#define R_USB_EPT_DATA__low_speed__BITNR 26
#define R_USB_EPT_DATA__port__BITNR 24
#define R_USB_EPT_DATA__error_code__BITNR 22
#define R_USB_EPT_DATA__t_out__BITNR 21
#define R_USB_EPT_DATA__error_count_out__BITNR 19
#define R_USB_EPT_DATA__max_len__BITNR 11
#define R_USB_EPT_DATA__ep__BITNR 7
#define R_USB_EPT_DATA__dev__BITNR 0

#define R_USB_EPT_DATA__valid__valid__VAL REG_VAL_ENUM
#define R_USB_EPT_DATA__hold__hold__VAL REG_VAL_ENUM
#define R_USB_EPT_DATA__error_count_in__error_count_in__VAL REG_VAL_VAL
#define R_USB_EPT_DATA__t_in__t_in__VAL REG_VAL_VAL
#define R_USB_EPT_DATA__low_speed__low_speed__VAL REG_VAL_ENUM
#define R_USB_EPT_DATA__port__port__VAL REG_VAL_ENUM
#define R_USB_EPT_DATA__error_code__error_code__VAL REG_VAL_ENUM
#define R_USB_EPT_DATA__t_out__t_out__VAL REG_VAL_VAL
#define R_USB_EPT_DATA__error_count_out__error_count_out__VAL REG_VAL_VAL
#define R_USB_EPT_DATA__max_len__max_len__VAL REG_VAL_VAL
#define R_USB_EPT_DATA__ep__ep__VAL REG_VAL_VAL
#define R_USB_EPT_DATA__dev__dev__VAL REG_VAL_VAL

#define R_USB_EPT_DATA__valid__valid__no 0
#define R_USB_EPT_DATA__valid__valid__yes 1
#define R_USB_EPT_DATA__hold__hold__no 0
#define R_USB_EPT_DATA__hold__hold__yes 1
#define R_USB_EPT_DATA__low_speed__low_speed__no 0
#define R_USB_EPT_DATA__low_speed__low_speed__yes 1
#define R_USB_EPT_DATA__port__port__any 0
#define R_USB_EPT_DATA__port__port__p1 1
#define R_USB_EPT_DATA__port__port__p2 2
#define R_USB_EPT_DATA__port__port__undef 3
#define R_USB_EPT_DATA__error_code__error_code__buffer_error 3
#define R_USB_EPT_DATA__error_code__error_code__bus_error 2
#define R_USB_EPT_DATA__error_code__error_code__no_error 0
#define R_USB_EPT_DATA__error_code__error_code__stall 1

#endif

/*
 *  R_USB_EPT_DATA_DEV
 *  - type:  RW
 *  - addr:  0xb000021c
 *  - group: USB interface control registers
 */

#if USE_GROUP__USB_interface_control_registers

#define R_USB_EPT_DATA_DEV__ADDR      (REG_TYPECAST_UDWORD  0xb000021c)
#define R_USB_EPT_DATA_DEV__SVAL      REG_SVAL_SHADOW
#define R_USB_EPT_DATA_DEV__SVAL_I    REG_SVAL_I_SHADOW
#define R_USB_EPT_DATA_DEV__TYPECAST  REG_TYPECAST_UDWORD
#define R_USB_EPT_DATA_DEV__TYPE      (REG_UDWORD)
#define R_USB_EPT_DATA_DEV__GET       REG_GET_RW
#define R_USB_EPT_DATA_DEV__IGET      REG_IGET_RW
#define R_USB_EPT_DATA_DEV__SET       REG_SET_RW
#define R_USB_EPT_DATA_DEV__ISET      REG_ISET_RW
#define R_USB_EPT_DATA_DEV__SET_VAL   REG_SET_VAL_RW
#define R_USB_EPT_DATA_DEV__EQL       REG_EQL_RW
#define R_USB_EPT_DATA_DEV__IEQL      REG_IEQL_RW
#define R_USB_EPT_DATA_DEV__RD        REG_RD_RW
#define R_USB_EPT_DATA_DEV__IRD       REG_IRD_RW
#define R_USB_EPT_DATA_DEV__WR        REG_WR_RW
#define R_USB_EPT_DATA_DEV__IWR       REG_IWR_RW

#define R_USB_EPT_DATA_DEV__WRITE(addr,value) \
  (*(addr) = (value))
#define R_USB_EPT_DATA_DEV__READ(addr) \
  (*(addr))

#define R_USB_EPT_DATA_DEV__valid__valid__MASK 0x80000000U
#define R_USB_EPT_DATA_DEV__hold__hold__MASK 0x40000000U
#define R_USB_EPT_DATA_DEV__stall__stall__MASK 0x20000000U
#define R_USB_EPT_DATA_DEV__iso_resp__iso_resp__MASK 0x10000000U
#define R_USB_EPT_DATA_DEV__ctrl__ctrl__MASK 0x08000000U
#define R_USB_EPT_DATA_DEV__iso__iso__MASK 0x04000000U
#define R_USB_EPT_DATA_DEV__port__port__MASK 0x03000000U
#define R_USB_EPT_DATA_DEV__control_phase__control_phase__MASK 0x00400000U
#define R_USB_EPT_DATA_DEV__t__t__MASK 0x00200000U
#define R_USB_EPT_DATA_DEV__max_len__max_len__MASK 0x001ff800U
#define R_USB_EPT_DATA_DEV__ep__ep__MASK 0x00000780U
#define R_USB_EPT_DATA_DEV__dev__dev__MASK 0x0000007fU

#define R_USB_EPT_DATA_DEV__valid__MAX 0x1
#define R_USB_EPT_DATA_DEV__hold__MAX 0x1
#define R_USB_EPT_DATA_DEV__stall__MAX 0x1
#define R_USB_EPT_DATA_DEV__iso_resp__MAX 0x1
#define R_USB_EPT_DATA_DEV__ctrl__MAX 0x1
#define R_USB_EPT_DATA_DEV__iso__MAX 0x1
#define R_USB_EPT_DATA_DEV__port__MAX 0x3
#define R_USB_EPT_DATA_DEV__control_phase__MAX 0x1
#define R_USB_EPT_DATA_DEV__t__MAX 1
#define R_USB_EPT_DATA_DEV__max_len__MAX 1023
#define R_USB_EPT_DATA_DEV__ep__MAX 15
#define R_USB_EPT_DATA_DEV__dev__MAX 127

#define R_USB_EPT_DATA_DEV__valid__MIN 0
#define R_USB_EPT_DATA_DEV__hold__MIN 0
#define R_USB_EPT_DATA_DEV__stall__MIN 0
#define R_USB_EPT_DATA_DEV__iso_resp__MIN 0
#define R_USB_EPT_DATA_DEV__ctrl__MIN 0
#define R_USB_EPT_DATA_DEV__iso__MIN 0
#define R_USB_EPT_DATA_DEV__port__MIN 0
#define R_USB_EPT_DATA_DEV__control_phase__MIN 0
#define R_USB_EPT_DATA_DEV__t__MIN 0
#define R_USB_EPT_DATA_DEV__max_len__MIN 1
#define R_USB_EPT_DATA_DEV__ep__MIN 0
#define R_USB_EPT_DATA_DEV__dev__MIN 0

#define R_USB_EPT_DATA_DEV__valid__BITNR 31
#define R_USB_EPT_DATA_DEV__hold__BITNR 30
#define R_USB_EPT_DATA_DEV__stall__BITNR 29
#define R_USB_EPT_DATA_DEV__iso_resp__BITNR 28
#define R_USB_EPT_DATA_DEV__ctrl__BITNR 27
#define R_USB_EPT_DATA_DEV__iso__BITNR 26
#define R_USB_EPT_DATA_DEV__port__BITNR 24
#define R_USB_EPT_DATA_DEV__control_phase__BITNR 22
#define R_USB_EPT_DATA_DEV__t__BITNR 21
#define R_USB_EPT_DATA_DEV__max_len__BITNR 11
#define R_USB_EPT_DATA_DEV__ep__BITNR 7
#define R_USB_EPT_DATA_DEV__dev__BITNR 0

#define R_USB_EPT_DATA_DEV__valid__valid__VAL REG_VAL_ENUM
#define R_USB_EPT_DATA_DEV__hold__hold__VAL REG_VAL_ENUM
#define R_USB_EPT_DATA_DEV__stall__stall__VAL REG_VAL_ENUM
#define R_USB_EPT_DATA_DEV__iso_resp__iso_resp__VAL REG_VAL_ENUM
#define R_USB_EPT_DATA_DEV__ctrl__ctrl__VAL REG_VAL_ENUM
#define R_USB_EPT_DATA_DEV__iso__iso__VAL REG_VAL_ENUM
#define R_USB_EPT_DATA_DEV__port__port__VAL REG_VAL_VAL
#define R_USB_EPT_DATA_DEV__control_phase__control_phase__VAL REG_VAL_VAL
#define R_USB_EPT_DATA_DEV__t__t__VAL REG_VAL_VAL
#define R_USB_EPT_DATA_DEV__max_len__max_len__VAL REG_VAL_VAL
#define R_USB_EPT_DATA_DEV__ep__ep__VAL REG_VAL_VAL
#define R_USB_EPT_DATA_DEV__dev__dev__VAL REG_VAL_VAL

#define R_USB_EPT_DATA_DEV__valid__valid__no 0
#define R_USB_EPT_DATA_DEV__valid__valid__yes 1
#define R_USB_EPT_DATA_DEV__hold__hold__no 0
#define R_USB_EPT_DATA_DEV__hold__hold__yes 1
#define R_USB_EPT_DATA_DEV__stall__stall__no 0
#define R_USB_EPT_DATA_DEV__stall__stall__yes 1
#define R_USB_EPT_DATA_DEV__iso_resp__iso_resp__quiet 0
#define R_USB_EPT_DATA_DEV__iso_resp__iso_resp__yes 1
#define R_USB_EPT_DATA_DEV__ctrl__ctrl__no 0
#define R_USB_EPT_DATA_DEV__ctrl__ctrl__yes 1
#define R_USB_EPT_DATA_DEV__iso__iso__no 0
#define R_USB_EPT_DATA_DEV__iso__iso__yes 1

#endif

/*
 *  R_USB_EPT_DATA_ISO
 *  - type:  RW
 *  - addr:  0xb000021c
 *  - group: USB interface control registers
 */

#if USE_GROUP__USB_interface_control_registers

#define R_USB_EPT_DATA_ISO__ADDR      (REG_TYPECAST_UDWORD  0xb000021c)
#define R_USB_EPT_DATA_ISO__SVAL      REG_SVAL_SHADOW
#define R_USB_EPT_DATA_ISO__SVAL_I    REG_SVAL_I_SHADOW
#define R_USB_EPT_DATA_ISO__TYPECAST  REG_TYPECAST_UDWORD
#define R_USB_EPT_DATA_ISO__TYPE      (REG_UDWORD)
#define R_USB_EPT_DATA_ISO__GET       REG_GET_RW
#define R_USB_EPT_DATA_ISO__IGET      REG_IGET_RW
#define R_USB_EPT_DATA_ISO__SET       REG_SET_RW
#define R_USB_EPT_DATA_ISO__ISET      REG_ISET_RW
#define R_USB_EPT_DATA_ISO__SET_VAL   REG_SET_VAL_RW
#define R_USB_EPT_DATA_ISO__EQL       REG_EQL_RW
#define R_USB_EPT_DATA_ISO__IEQL      REG_IEQL_RW
#define R_USB_EPT_DATA_ISO__RD        REG_RD_RW
#define R_USB_EPT_DATA_ISO__IRD       REG_IRD_RW
#define R_USB_EPT_DATA_ISO__WR        REG_WR_RW
#define R_USB_EPT_DATA_ISO__IWR       REG_IWR_RW

#define R_USB_EPT_DATA_ISO__WRITE(addr,value) \
  (*(addr) = (value))
#define R_USB_EPT_DATA_ISO__READ(addr) \
  (*(addr))

#define R_USB_EPT_DATA_ISO__valid__valid__MASK 0x80000000U
#define R_USB_EPT_DATA_ISO__port__port__MASK 0x03000000U
#define R_USB_EPT_DATA_ISO__error_code__error_code__MASK 0x00c00000U
#define R_USB_EPT_DATA_ISO__max_len__max_len__MASK 0x001ff800U
#define R_USB_EPT_DATA_ISO__ep__ep__MASK 0x00000780U
#define R_USB_EPT_DATA_ISO__dev__dev__MASK 0x0000007fU

#define R_USB_EPT_DATA_ISO__valid__MAX 0x1
#define R_USB_EPT_DATA_ISO__port__MAX 0x3
#define R_USB_EPT_DATA_ISO__error_code__MAX 0x3
#define R_USB_EPT_DATA_ISO__max_len__MAX 1023
#define R_USB_EPT_DATA_ISO__ep__MAX 0xf
#define R_USB_EPT_DATA_ISO__dev__MAX 0x7f

#define R_USB_EPT_DATA_ISO__valid__MIN 0
#define R_USB_EPT_DATA_ISO__port__MIN 0
#define R_USB_EPT_DATA_ISO__error_code__MIN 0
#define R_USB_EPT_DATA_ISO__max_len__MIN 1
#define R_USB_EPT_DATA_ISO__ep__MIN 0
#define R_USB_EPT_DATA_ISO__dev__MIN 0

#define R_USB_EPT_DATA_ISO__valid__BITNR 31
#define R_USB_EPT_DATA_ISO__port__BITNR 24
#define R_USB_EPT_DATA_ISO__error_code__BITNR 22
#define R_USB_EPT_DATA_ISO__max_len__BITNR 11
#define R_USB_EPT_DATA_ISO__ep__BITNR 7
#define R_USB_EPT_DATA_ISO__dev__BITNR 0

#define R_USB_EPT_DATA_ISO__valid__valid__VAL REG_VAL_ENUM
#define R_USB_EPT_DATA_ISO__port__port__VAL REG_VAL_ENUM
#define R_USB_EPT_DATA_ISO__error_code__error_code__VAL REG_VAL_ENUM
#define R_USB_EPT_DATA_ISO__max_len__max_len__VAL REG_VAL_VAL
#define R_USB_EPT_DATA_ISO__ep__ep__VAL REG_VAL_VAL
#define R_USB_EPT_DATA_ISO__dev__dev__VAL REG_VAL_VAL

#define R_USB_EPT_DATA_ISO__valid__valid__no 0
#define R_USB_EPT_DATA_ISO__valid__valid__yes 1
#define R_USB_EPT_DATA_ISO__port__port__any 0
#define R_USB_EPT_DATA_ISO__port__port__p1 1
#define R_USB_EPT_DATA_ISO__port__port__p2 2
#define R_USB_EPT_DATA_ISO__port__port__undef 3
#define R_USB_EPT_DATA_ISO__error_code__error_code__TBD3 3
#define R_USB_EPT_DATA_ISO__error_code__error_code__bus_error 2
#define R_USB_EPT_DATA_ISO__error_code__error_code__no_error 0
#define R_USB_EPT_DATA_ISO__error_code__error_code__stall 1

#endif

/*
 *  R_USB_EPT_INDEX
 *  - type:  RW
 *  - addr:  0xb0000208
 *  - group: USB interface control registers
 */

#if USE_GROUP__USB_interface_control_registers

#define R_USB_EPT_INDEX__ADDR      (REG_TYPECAST_BYTE  0xb0000208)
#define R_USB_EPT_INDEX__SVAL      REG_SVAL_SHADOW
#define R_USB_EPT_INDEX__SVAL_I    REG_SVAL_I_SHADOW
#define R_USB_EPT_INDEX__TYPECAST  REG_TYPECAST_BYTE
#define R_USB_EPT_INDEX__TYPE      (REG_BYTE)
#define R_USB_EPT_INDEX__GET       REG_GET_RW
#define R_USB_EPT_INDEX__IGET      REG_IGET_RW
#define R_USB_EPT_INDEX__SET       REG_SET_RW
#define R_USB_EPT_INDEX__ISET      REG_ISET_RW
#define R_USB_EPT_INDEX__SET_VAL   REG_SET_VAL_RW
#define R_USB_EPT_INDEX__EQL       REG_EQL_RW
#define R_USB_EPT_INDEX__IEQL      REG_IEQL_RW
#define R_USB_EPT_INDEX__RD        REG_RD_RW
#define R_USB_EPT_INDEX__IRD       REG_IRD_RW
#define R_USB_EPT_INDEX__WR        REG_WR_RW
#define R_USB_EPT_INDEX__IWR       REG_IWR_RW

#define R_USB_EPT_INDEX__WRITE(addr,value) \
  (*(addr) = (value))
#define R_USB_EPT_INDEX__READ(addr) \
  (*(addr))

#define R_USB_EPT_INDEX__value__value__MASK 0x0000001fU

#define R_USB_EPT_INDEX__value__MAX 31

#define R_USB_EPT_INDEX__value__MIN 0

#define R_USB_EPT_INDEX__value__BITNR 0

#define R_USB_EPT_INDEX__value__value__VAL REG_VAL_VAL


#endif

/*
 *  R_USB_FM_INTERVAL
 *  - type:  RW
 *  - addr:  0xb0000210
 *  - group: USB interface control registers
 */

#if USE_GROUP__USB_interface_control_registers

#define R_USB_FM_INTERVAL__ADDR      (REG_TYPECAST_UWORD  0xb0000210)
#define R_USB_FM_INTERVAL__SVAL      REG_SVAL_SHADOW
#define R_USB_FM_INTERVAL__SVAL_I    REG_SVAL_I_SHADOW
#define R_USB_FM_INTERVAL__TYPECAST  REG_TYPECAST_UWORD
#define R_USB_FM_INTERVAL__TYPE      (REG_UWORD)
#define R_USB_FM_INTERVAL__GET       REG_GET_RW
#define R_USB_FM_INTERVAL__IGET      REG_IGET_RW
#define R_USB_FM_INTERVAL__SET       REG_SET_RW
#define R_USB_FM_INTERVAL__ISET      REG_ISET_RW
#define R_USB_FM_INTERVAL__SET_VAL   REG_SET_VAL_RW
#define R_USB_FM_INTERVAL__EQL       REG_EQL_RW
#define R_USB_FM_INTERVAL__IEQL      REG_IEQL_RW
#define R_USB_FM_INTERVAL__RD        REG_RD_RW
#define R_USB_FM_INTERVAL__IRD       REG_IRD_RW
#define R_USB_FM_INTERVAL__WR        REG_WR_RW
#define R_USB_FM_INTERVAL__IWR       REG_IWR_RW

#define R_USB_FM_INTERVAL__WRITE(addr,value) \
  (*(addr) = (value))
#define R_USB_FM_INTERVAL__READ(addr) \
  (*(addr))

#define R_USB_FM_INTERVAL__fixed__fixed__MASK 0x00003fc0U
#define R_USB_FM_INTERVAL__adj__adj__MASK 0x0000003fU

#define R_USB_FM_INTERVAL__fixed__MAX 0xff
#define R_USB_FM_INTERVAL__adj__MAX 63

#define R_USB_FM_INTERVAL__fixed__MIN 0
#define R_USB_FM_INTERVAL__adj__MIN 0

#define R_USB_FM_INTERVAL__fixed__BITNR 6
#define R_USB_FM_INTERVAL__adj__BITNR 0

#define R_USB_FM_INTERVAL__fixed__fixed__VAL REG_VAL_VAL
#define R_USB_FM_INTERVAL__adj__adj__VAL REG_VAL_VAL


#endif

/*
 *  R_USB_FM_NUMBER
 *  - type:  RW
 *  - addr:  0xb000020c
 *  - group: USB interface control registers
 */

#if USE_GROUP__USB_interface_control_registers

#define R_USB_FM_NUMBER__ADDR      (REG_TYPECAST_UDWORD  0xb000020c)
#define R_USB_FM_NUMBER__SVAL      REG_SVAL_SHADOW
#define R_USB_FM_NUMBER__SVAL_I    REG_SVAL_I_SHADOW
#define R_USB_FM_NUMBER__TYPECAST  REG_TYPECAST_UDWORD
#define R_USB_FM_NUMBER__TYPE      (REG_UDWORD)
#define R_USB_FM_NUMBER__GET       REG_GET_RW
#define R_USB_FM_NUMBER__IGET      REG_IGET_RW
#define R_USB_FM_NUMBER__SET       REG_SET_RW
#define R_USB_FM_NUMBER__ISET      REG_ISET_RW
#define R_USB_FM_NUMBER__SET_VAL   REG_SET_VAL_RW
#define R_USB_FM_NUMBER__EQL       REG_EQL_RW
#define R_USB_FM_NUMBER__IEQL      REG_IEQL_RW
#define R_USB_FM_NUMBER__RD        REG_RD_RW
#define R_USB_FM_NUMBER__IRD       REG_IRD_RW
#define R_USB_FM_NUMBER__WR        REG_WR_RW
#define R_USB_FM_NUMBER__IWR       REG_IWR_RW

#define R_USB_FM_NUMBER__WRITE(addr,value) \
  (*(addr) = (value))
#define R_USB_FM_NUMBER__READ(addr) \
  (*(addr))

#define R_USB_FM_NUMBER__value__value__MASK 0xffffffffU

#define R_USB_FM_NUMBER__value__MAX 0xffffffff

#define R_USB_FM_NUMBER__value__MIN 0

#define R_USB_FM_NUMBER__value__BITNR 0

#define R_USB_FM_NUMBER__value__value__VAL REG_VAL_VAL


#endif

/*
 *  R_USB_FM_NUMBER_DEV
 *  - type:  RW
 *  - addr:  0xb000020c
 *  - group: USB interface control registers
 */

#if USE_GROUP__USB_interface_control_registers

#define R_USB_FM_NUMBER_DEV__ADDR      (REG_TYPECAST_UDWORD  0xb000020c)
#define R_USB_FM_NUMBER_DEV__SVAL      REG_SVAL_SHADOW
#define R_USB_FM_NUMBER_DEV__SVAL_I    REG_SVAL_I_SHADOW
#define R_USB_FM_NUMBER_DEV__TYPECAST  REG_TYPECAST_UDWORD
#define R_USB_FM_NUMBER_DEV__TYPE      (REG_UDWORD)
#define R_USB_FM_NUMBER_DEV__GET       REG_GET_RW
#define R_USB_FM_NUMBER_DEV__IGET      REG_IGET_RW
#define R_USB_FM_NUMBER_DEV__SET       REG_SET_RW
#define R_USB_FM_NUMBER_DEV__ISET      REG_ISET_RW
#define R_USB_FM_NUMBER_DEV__SET_VAL   REG_SET_VAL_RW
#define R_USB_FM_NUMBER_DEV__EQL       REG_EQL_RW
#define R_USB_FM_NUMBER_DEV__IEQL      REG_IEQL_RW
#define R_USB_FM_NUMBER_DEV__RD        REG_RD_RW
#define R_USB_FM_NUMBER_DEV__IRD       REG_IRD_RW
#define R_USB_FM_NUMBER_DEV__WR        REG_WR_RW
#define R_USB_FM_NUMBER_DEV__IWR       REG_IWR_RW

#define R_USB_FM_NUMBER_DEV__WRITE(addr,value) \
  (*(addr) = (value))
#define R_USB_FM_NUMBER_DEV__READ(addr) \
  (*(addr))

#define R_USB_FM_NUMBER_DEV__sign__sign__MASK 0x80000000U
#define R_USB_FM_NUMBER_DEV__deviation__deviation__MASK 0x7f000000U
#define R_USB_FM_NUMBER_DEV__fm_number__fm_number__MASK 0x000007ffU

#define R_USB_FM_NUMBER_DEV__sign__MAX 0x1
#define R_USB_FM_NUMBER_DEV__deviation__MAX 127
#define R_USB_FM_NUMBER_DEV__fm_number__MAX 0x7ff

#define R_USB_FM_NUMBER_DEV__sign__MIN 0
#define R_USB_FM_NUMBER_DEV__deviation__MIN 0
#define R_USB_FM_NUMBER_DEV__fm_number__MIN 0

#define R_USB_FM_NUMBER_DEV__sign__BITNR 31
#define R_USB_FM_NUMBER_DEV__deviation__BITNR 24
#define R_USB_FM_NUMBER_DEV__fm_number__BITNR 0

#define R_USB_FM_NUMBER_DEV__sign__sign__VAL REG_VAL_ENUM
#define R_USB_FM_NUMBER_DEV__deviation__deviation__VAL REG_VAL_VAL
#define R_USB_FM_NUMBER_DEV__fm_number__fm_number__VAL REG_VAL_VAL

#define R_USB_FM_NUMBER_DEV__sign__sign__early 0
#define R_USB_FM_NUMBER_DEV__sign__sign__late 1

#endif

/*
 *  R_USB_FM_PSTART
 *  - type:  RW
 *  - addr:  0xb0000214
 *  - group: USB interface control registers
 */

#if USE_GROUP__USB_interface_control_registers

#define R_USB_FM_PSTART__ADDR      (REG_TYPECAST_UWORD  0xb0000214)
#define R_USB_FM_PSTART__SVAL      REG_SVAL_SHADOW
#define R_USB_FM_PSTART__SVAL_I    REG_SVAL_I_SHADOW
#define R_USB_FM_PSTART__TYPECAST  REG_TYPECAST_UWORD
#define R_USB_FM_PSTART__TYPE      (REG_UWORD)
#define R_USB_FM_PSTART__GET       REG_GET_RW
#define R_USB_FM_PSTART__IGET      REG_IGET_RW
#define R_USB_FM_PSTART__SET       REG_SET_RW
#define R_USB_FM_PSTART__ISET      REG_ISET_RW
#define R_USB_FM_PSTART__SET_VAL   REG_SET_VAL_RW
#define R_USB_FM_PSTART__EQL       REG_EQL_RW
#define R_USB_FM_PSTART__IEQL      REG_IEQL_RW
#define R_USB_FM_PSTART__RD        REG_RD_RW
#define R_USB_FM_PSTART__IRD       REG_IRD_RW
#define R_USB_FM_PSTART__WR        REG_WR_RW
#define R_USB_FM_PSTART__IWR       REG_IWR_RW

#define R_USB_FM_PSTART__WRITE(addr,value) \
  (*(addr) = (value))
#define R_USB_FM_PSTART__READ(addr) \
  (*(addr))

#define R_USB_FM_PSTART__value__value__MASK 0x00003fffU

#define R_USB_FM_PSTART__value__MAX 0x3fff

#define R_USB_FM_PSTART__value__MIN 0

#define R_USB_FM_PSTART__value__BITNR 0

#define R_USB_FM_PSTART__value__value__VAL REG_VAL_VAL


#endif

/*
 *  R_USB_FM_REMAINING
 *  - type:  RO
 *  - addr:  0xb0000212
 *  - group: USB interface control registers
 */

#if USE_GROUP__USB_interface_control_registers

#define R_USB_FM_REMAINING__ADDR      (REG_TYPECAST_UWORD  0xb0000212)
#define R_USB_FM_REMAINING__SVAL      REG_SVAL_SHADOW
#define R_USB_FM_REMAINING__SVAL_I    REG_SVAL_I_SHADOW
#define R_USB_FM_REMAINING__TYPECAST  REG_TYPECAST_UWORD
#define R_USB_FM_REMAINING__TYPE      (REG_UWORD)
#define R_USB_FM_REMAINING__GET       REG_GET_RO
#define R_USB_FM_REMAINING__IGET      REG_IGET_RO
#define R_USB_FM_REMAINING__SET       REG_SET_RO
#define R_USB_FM_REMAINING__ISET      REG_ISET_RO
#define R_USB_FM_REMAINING__SET_VAL   REG_SET_VAL_RO
#define R_USB_FM_REMAINING__EQL       REG_EQL_RO
#define R_USB_FM_REMAINING__IEQL      REG_IEQL_RO
#define R_USB_FM_REMAINING__RD        REG_RD_RO
#define R_USB_FM_REMAINING__IRD       REG_IRD_RO
#define R_USB_FM_REMAINING__WR        REG_WR_RO
#define R_USB_FM_REMAINING__IWR       REG_IWR_RO

#define R_USB_FM_REMAINING__READ(addr) \
  (*(addr))

#define R_USB_FM_REMAINING__value__value__MASK 0x00003fffU

#define R_USB_FM_REMAINING__value__MAX 0x3fff

#define R_USB_FM_REMAINING__value__MIN 0

#define R_USB_FM_REMAINING__value__BITNR 0

#define R_USB_FM_REMAINING__value__value__VAL REG_VAL_VAL


#endif

/*
 *  R_USB_IRQ_MASK_CLR
 *  - type:  WO
 *  - addr:  0xb0000206
 *  - group: USB interface control registers
 */

#if USE_GROUP__USB_interface_control_registers

#define R_USB_IRQ_MASK_CLR__ADDR      (REG_TYPECAST_UWORD  0xb0000206)

#ifndef REG_NO_SHADOW
#define R_USB_IRQ_MASK_CLR__SADDR     (REG_STYPECAST_UWORD (reg_shadow__hwregs.R_USB_IRQ_MASK_CLR + 0))
#define R_USB_IRQ_MASK_CLR__IADDR     (REG_STYPECAST_UWORD (reg_initiated__hwregs.R_USB_IRQ_MASK_CLR + 0))
#else /* REG_NO_SHADOW */
#define R_USB_IRQ_MASK_CLR__SADDR     (REG_STYPECAST_UWORD (&reg_shadow__hwregs))
#define R_USB_IRQ_MASK_CLR__IADDR     (REG_STYPECAST_UWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_USB_IRQ_MASK_CLR__STYPECAST REG_STYPECAST_UWORD
#define R_USB_IRQ_MASK_CLR__SVAL REG_SVAL_ZERO
#define R_USB_IRQ_MASK_CLR__SVAL_I REG_SVAL_I_ZERO
#define R_USB_IRQ_MASK_CLR__TYPECAST  REG_TYPECAST_UWORD
#define R_USB_IRQ_MASK_CLR__TYPE      (REG_UWORD)
#define R_USB_IRQ_MASK_CLR__GET       REG_GET_WO
#define R_USB_IRQ_MASK_CLR__IGET      REG_IGET_WO
#define R_USB_IRQ_MASK_CLR__SET       REG_SET_WO
#define R_USB_IRQ_MASK_CLR__ISET      REG_ISET_WO
#define R_USB_IRQ_MASK_CLR__SET_VAL   REG_SET_VAL_WO
#define R_USB_IRQ_MASK_CLR__EQL       REG_EQL_WO
#define R_USB_IRQ_MASK_CLR__IEQL      REG_IEQL_WO
#define R_USB_IRQ_MASK_CLR__RD        REG_RD_WO
#define R_USB_IRQ_MASK_CLR__IRD       REG_IRD_WO
#define R_USB_IRQ_MASK_CLR__WR        REG_WR_WO
#define R_USB_IRQ_MASK_CLR__IWR       REG_IWR_WO

#define R_USB_IRQ_MASK_CLR__WRITE(addr,value) \
  (*(addr) = (value))

#define R_USB_IRQ_MASK_CLR__iso_eof__iso_eof__MASK 0x00002000U
#define R_USB_IRQ_MASK_CLR__intr_eof__intr_eof__MASK 0x00001000U
#define R_USB_IRQ_MASK_CLR__iso_eot__iso_eot__MASK 0x00000800U
#define R_USB_IRQ_MASK_CLR__intr_eot__intr_eot__MASK 0x00000400U
#define R_USB_IRQ_MASK_CLR__ctl_eot__ctl_eot__MASK 0x00000200U
#define R_USB_IRQ_MASK_CLR__bulk_eot__bulk_eot__MASK 0x00000100U
#define R_USB_IRQ_MASK_CLR__epid_attn__epid_attn__MASK 0x00000008U
#define R_USB_IRQ_MASK_CLR__sof__sof__MASK 0x00000004U
#define R_USB_IRQ_MASK_CLR__port_status__port_status__MASK 0x00000002U
#define R_USB_IRQ_MASK_CLR__ctl_status__ctl_status__MASK 0x00000001U

#define R_USB_IRQ_MASK_CLR__iso_eof__MAX 0x1
#define R_USB_IRQ_MASK_CLR__intr_eof__MAX 0x1
#define R_USB_IRQ_MASK_CLR__iso_eot__MAX 0x1
#define R_USB_IRQ_MASK_CLR__intr_eot__MAX 0x1
#define R_USB_IRQ_MASK_CLR__ctl_eot__MAX 0x1
#define R_USB_IRQ_MASK_CLR__bulk_eot__MAX 0x1
#define R_USB_IRQ_MASK_CLR__epid_attn__MAX 0x1
#define R_USB_IRQ_MASK_CLR__sof__MAX 0x1
#define R_USB_IRQ_MASK_CLR__port_status__MAX 0x1
#define R_USB_IRQ_MASK_CLR__ctl_status__MAX 0x1

#define R_USB_IRQ_MASK_CLR__iso_eof__MIN 0
#define R_USB_IRQ_MASK_CLR__intr_eof__MIN 0
#define R_USB_IRQ_MASK_CLR__iso_eot__MIN 0
#define R_USB_IRQ_MASK_CLR__intr_eot__MIN 0
#define R_USB_IRQ_MASK_CLR__ctl_eot__MIN 0
#define R_USB_IRQ_MASK_CLR__bulk_eot__MIN 0
#define R_USB_IRQ_MASK_CLR__epid_attn__MIN 0
#define R_USB_IRQ_MASK_CLR__sof__MIN 0
#define R_USB_IRQ_MASK_CLR__port_status__MIN 0
#define R_USB_IRQ_MASK_CLR__ctl_status__MIN 0

#define R_USB_IRQ_MASK_CLR__iso_eof__BITNR 13
#define R_USB_IRQ_MASK_CLR__intr_eof__BITNR 12
#define R_USB_IRQ_MASK_CLR__iso_eot__BITNR 11
#define R_USB_IRQ_MASK_CLR__intr_eot__BITNR 10
#define R_USB_IRQ_MASK_CLR__ctl_eot__BITNR 9
#define R_USB_IRQ_MASK_CLR__bulk_eot__BITNR 8
#define R_USB_IRQ_MASK_CLR__epid_attn__BITNR 3
#define R_USB_IRQ_MASK_CLR__sof__BITNR 2
#define R_USB_IRQ_MASK_CLR__port_status__BITNR 1
#define R_USB_IRQ_MASK_CLR__ctl_status__BITNR 0

#define R_USB_IRQ_MASK_CLR__iso_eof__iso_eof__VAL REG_VAL_ENUM
#define R_USB_IRQ_MASK_CLR__intr_eof__intr_eof__VAL REG_VAL_ENUM
#define R_USB_IRQ_MASK_CLR__iso_eot__iso_eot__VAL REG_VAL_ENUM
#define R_USB_IRQ_MASK_CLR__intr_eot__intr_eot__VAL REG_VAL_ENUM
#define R_USB_IRQ_MASK_CLR__ctl_eot__ctl_eot__VAL REG_VAL_ENUM
#define R_USB_IRQ_MASK_CLR__bulk_eot__bulk_eot__VAL REG_VAL_ENUM
#define R_USB_IRQ_MASK_CLR__epid_attn__epid_attn__VAL REG_VAL_ENUM
#define R_USB_IRQ_MASK_CLR__sof__sof__VAL REG_VAL_ENUM
#define R_USB_IRQ_MASK_CLR__port_status__port_status__VAL REG_VAL_ENUM
#define R_USB_IRQ_MASK_CLR__ctl_status__ctl_status__VAL REG_VAL_ENUM

#define R_USB_IRQ_MASK_CLR__iso_eof__iso_eof__clr 1
#define R_USB_IRQ_MASK_CLR__iso_eof__iso_eof__nop 0
#define R_USB_IRQ_MASK_CLR__intr_eof__intr_eof__clr 1
#define R_USB_IRQ_MASK_CLR__intr_eof__intr_eof__nop 0
#define R_USB_IRQ_MASK_CLR__iso_eot__iso_eot__clr 1
#define R_USB_IRQ_MASK_CLR__iso_eot__iso_eot__nop 0
#define R_USB_IRQ_MASK_CLR__intr_eot__intr_eot__clr 1
#define R_USB_IRQ_MASK_CLR__intr_eot__intr_eot__nop 0
#define R_USB_IRQ_MASK_CLR__ctl_eot__ctl_eot__clr 1
#define R_USB_IRQ_MASK_CLR__ctl_eot__ctl_eot__nop 0
#define R_USB_IRQ_MASK_CLR__bulk_eot__bulk_eot__clr 1
#define R_USB_IRQ_MASK_CLR__bulk_eot__bulk_eot__nop 0
#define R_USB_IRQ_MASK_CLR__epid_attn__epid_attn__clr 1
#define R_USB_IRQ_MASK_CLR__epid_attn__epid_attn__nop 0
#define R_USB_IRQ_MASK_CLR__sof__sof__clr 1
#define R_USB_IRQ_MASK_CLR__sof__sof__nop 0
#define R_USB_IRQ_MASK_CLR__port_status__port_status__clr 1
#define R_USB_IRQ_MASK_CLR__port_status__port_status__nop 0
#define R_USB_IRQ_MASK_CLR__ctl_status__ctl_status__clr 1
#define R_USB_IRQ_MASK_CLR__ctl_status__ctl_status__nop 0

#endif

/*
 *  R_USB_IRQ_MASK_CLR_DEV
 *  - type:  WO
 *  - addr:  0xb0000206
 *  - group: USB interface control registers
 */

#if USE_GROUP__USB_interface_control_registers

#define R_USB_IRQ_MASK_CLR_DEV__ADDR      (REG_TYPECAST_UWORD  0xb0000206)

#ifndef REG_NO_SHADOW
#define R_USB_IRQ_MASK_CLR_DEV__SADDR     (REG_STYPECAST_UWORD (reg_shadow__hwregs.R_USB_IRQ_MASK_CLR + 0))
#define R_USB_IRQ_MASK_CLR_DEV__IADDR     (REG_STYPECAST_UWORD (reg_initiated__hwregs.R_USB_IRQ_MASK_CLR + 0))
#else /* REG_NO_SHADOW */
#define R_USB_IRQ_MASK_CLR_DEV__SADDR     (REG_STYPECAST_UWORD (&reg_shadow__hwregs))
#define R_USB_IRQ_MASK_CLR_DEV__IADDR     (REG_STYPECAST_UWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_USB_IRQ_MASK_CLR_DEV__STYPECAST REG_STYPECAST_UWORD
#define R_USB_IRQ_MASK_CLR_DEV__SVAL      REG_SVAL_SHADOW
#define R_USB_IRQ_MASK_CLR_DEV__SVAL_I    REG_SVAL_I_SHADOW
#define R_USB_IRQ_MASK_CLR_DEV__TYPECAST  REG_TYPECAST_UWORD
#define R_USB_IRQ_MASK_CLR_DEV__TYPE      (REG_UWORD)
#define R_USB_IRQ_MASK_CLR_DEV__GET       REG_GET_WO
#define R_USB_IRQ_MASK_CLR_DEV__IGET      REG_IGET_WO
#define R_USB_IRQ_MASK_CLR_DEV__SET       REG_SET_WO
#define R_USB_IRQ_MASK_CLR_DEV__ISET      REG_ISET_WO
#define R_USB_IRQ_MASK_CLR_DEV__SET_VAL   REG_SET_VAL_WO
#define R_USB_IRQ_MASK_CLR_DEV__EQL       REG_EQL_WO
#define R_USB_IRQ_MASK_CLR_DEV__IEQL      REG_IEQL_WO
#define R_USB_IRQ_MASK_CLR_DEV__RD        REG_RD_WO
#define R_USB_IRQ_MASK_CLR_DEV__IRD       REG_IRD_WO
#define R_USB_IRQ_MASK_CLR_DEV__WR        REG_WR_WO
#define R_USB_IRQ_MASK_CLR_DEV__IWR       REG_IWR_WO

#define R_USB_IRQ_MASK_CLR_DEV__WRITE(addr,value) \
  (*(addr) = (value))

#define R_USB_IRQ_MASK_CLR_DEV__out_eot__out_eot__MASK 0x00001000U
#define R_USB_IRQ_MASK_CLR_DEV__ep3_in_eot__ep3_in_eot__MASK 0x00000800U
#define R_USB_IRQ_MASK_CLR_DEV__ep2_in_eot__ep2_in_eot__MASK 0x00000400U
#define R_USB_IRQ_MASK_CLR_DEV__ep1_in_eot__ep1_in_eot__MASK 0x00000200U
#define R_USB_IRQ_MASK_CLR_DEV__ep0_in_eot__ep0_in_eot__MASK 0x00000100U
#define R_USB_IRQ_MASK_CLR_DEV__epid_attn__epid_attn__MASK 0x00000008U
#define R_USB_IRQ_MASK_CLR_DEV__sof__sof__MASK 0x00000004U
#define R_USB_IRQ_MASK_CLR_DEV__port_status__port_status__MASK 0x00000002U
#define R_USB_IRQ_MASK_CLR_DEV__ctl_status__ctl_status__MASK 0x00000001U

#define R_USB_IRQ_MASK_CLR_DEV__out_eot__MAX 0x1
#define R_USB_IRQ_MASK_CLR_DEV__ep3_in_eot__MAX 0x1
#define R_USB_IRQ_MASK_CLR_DEV__ep2_in_eot__MAX 0x1
#define R_USB_IRQ_MASK_CLR_DEV__ep1_in_eot__MAX 0x1
#define R_USB_IRQ_MASK_CLR_DEV__ep0_in_eot__MAX 0x1
#define R_USB_IRQ_MASK_CLR_DEV__epid_attn__MAX 0x1
#define R_USB_IRQ_MASK_CLR_DEV__sof__MAX 0x1
#define R_USB_IRQ_MASK_CLR_DEV__port_status__MAX 0x1
#define R_USB_IRQ_MASK_CLR_DEV__ctl_status__MAX 0x1

#define R_USB_IRQ_MASK_CLR_DEV__out_eot__MIN 0
#define R_USB_IRQ_MASK_CLR_DEV__ep3_in_eot__MIN 0
#define R_USB_IRQ_MASK_CLR_DEV__ep2_in_eot__MIN 0
#define R_USB_IRQ_MASK_CLR_DEV__ep1_in_eot__MIN 0
#define R_USB_IRQ_MASK_CLR_DEV__ep0_in_eot__MIN 0
#define R_USB_IRQ_MASK_CLR_DEV__epid_attn__MIN 0
#define R_USB_IRQ_MASK_CLR_DEV__sof__MIN 0
#define R_USB_IRQ_MASK_CLR_DEV__port_status__MIN 0
#define R_USB_IRQ_MASK_CLR_DEV__ctl_status__MIN 0

#define R_USB_IRQ_MASK_CLR_DEV__out_eot__BITNR 12
#define R_USB_IRQ_MASK_CLR_DEV__ep3_in_eot__BITNR 11
#define R_USB_IRQ_MASK_CLR_DEV__ep2_in_eot__BITNR 10
#define R_USB_IRQ_MASK_CLR_DEV__ep1_in_eot__BITNR 9
#define R_USB_IRQ_MASK_CLR_DEV__ep0_in_eot__BITNR 8
#define R_USB_IRQ_MASK_CLR_DEV__epid_attn__BITNR 3
#define R_USB_IRQ_MASK_CLR_DEV__sof__BITNR 2
#define R_USB_IRQ_MASK_CLR_DEV__port_status__BITNR 1
#define R_USB_IRQ_MASK_CLR_DEV__ctl_status__BITNR 0

#define R_USB_IRQ_MASK_CLR_DEV__out_eot__out_eot__VAL REG_VAL_ENUM
#define R_USB_IRQ_MASK_CLR_DEV__ep3_in_eot__ep3_in_eot__VAL REG_VAL_ENUM
#define R_USB_IRQ_MASK_CLR_DEV__ep2_in_eot__ep2_in_eot__VAL REG_VAL_ENUM
#define R_USB_IRQ_MASK_CLR_DEV__ep1_in_eot__ep1_in_eot__VAL REG_VAL_ENUM
#define R_USB_IRQ_MASK_CLR_DEV__ep0_in_eot__ep0_in_eot__VAL REG_VAL_ENUM
#define R_USB_IRQ_MASK_CLR_DEV__epid_attn__epid_attn__VAL REG_VAL_ENUM
#define R_USB_IRQ_MASK_CLR_DEV__sof__sof__VAL REG_VAL_ENUM
#define R_USB_IRQ_MASK_CLR_DEV__port_status__port_status__VAL REG_VAL_ENUM
#define R_USB_IRQ_MASK_CLR_DEV__ctl_status__ctl_status__VAL REG_VAL_ENUM

#define R_USB_IRQ_MASK_CLR_DEV__out_eot__out_eot__clr 1
#define R_USB_IRQ_MASK_CLR_DEV__out_eot__out_eot__nop 0
#define R_USB_IRQ_MASK_CLR_DEV__ep3_in_eot__ep3_in_eot__clr 1
#define R_USB_IRQ_MASK_CLR_DEV__ep3_in_eot__ep3_in_eot__nop 0
#define R_USB_IRQ_MASK_CLR_DEV__ep2_in_eot__ep2_in_eot__clr 1
#define R_USB_IRQ_MASK_CLR_DEV__ep2_in_eot__ep2_in_eot__nop 0
#define R_USB_IRQ_MASK_CLR_DEV__ep1_in_eot__ep1_in_eot__clr 1
#define R_USB_IRQ_MASK_CLR_DEV__ep1_in_eot__ep1_in_eot__nop 0
#define R_USB_IRQ_MASK_CLR_DEV__ep0_in_eot__ep0_in_eot__clr 1
#define R_USB_IRQ_MASK_CLR_DEV__ep0_in_eot__ep0_in_eot__nop 0
#define R_USB_IRQ_MASK_CLR_DEV__epid_attn__epid_attn__clr 1
#define R_USB_IRQ_MASK_CLR_DEV__epid_attn__epid_attn__nop 0
#define R_USB_IRQ_MASK_CLR_DEV__sof__sof__clr 1
#define R_USB_IRQ_MASK_CLR_DEV__sof__sof__nop 0
#define R_USB_IRQ_MASK_CLR_DEV__port_status__port_status__clr 1
#define R_USB_IRQ_MASK_CLR_DEV__port_status__port_status__nop 0
#define R_USB_IRQ_MASK_CLR_DEV__ctl_status__ctl_status__clr 1
#define R_USB_IRQ_MASK_CLR_DEV__ctl_status__ctl_status__nop 0

#endif

/*
 *  R_USB_IRQ_MASK_READ
 *  - type:  RO
 *  - addr:  0xb0000204
 *  - group: USB interface control registers
 */

#if USE_GROUP__USB_interface_control_registers

#define R_USB_IRQ_MASK_READ__ADDR      (REG_TYPECAST_UWORD  0xb0000204)
#define R_USB_IRQ_MASK_READ__SVAL      REG_SVAL_SHADOW
#define R_USB_IRQ_MASK_READ__SVAL_I    REG_SVAL_I_SHADOW
#define R_USB_IRQ_MASK_READ__TYPECAST  REG_TYPECAST_UWORD
#define R_USB_IRQ_MASK_READ__TYPE      (REG_UWORD)
#define R_USB_IRQ_MASK_READ__GET       REG_GET_RO
#define R_USB_IRQ_MASK_READ__IGET      REG_IGET_RO
#define R_USB_IRQ_MASK_READ__SET       REG_SET_RO
#define R_USB_IRQ_MASK_READ__ISET      REG_ISET_RO
#define R_USB_IRQ_MASK_READ__SET_VAL   REG_SET_VAL_RO
#define R_USB_IRQ_MASK_READ__EQL       REG_EQL_RO
#define R_USB_IRQ_MASK_READ__IEQL      REG_IEQL_RO
#define R_USB_IRQ_MASK_READ__RD        REG_RD_RO
#define R_USB_IRQ_MASK_READ__IRD       REG_IRD_RO
#define R_USB_IRQ_MASK_READ__WR        REG_WR_RO
#define R_USB_IRQ_MASK_READ__IWR       REG_IWR_RO

#define R_USB_IRQ_MASK_READ__READ(addr) \
  (*(addr))

#define R_USB_IRQ_MASK_READ__iso_eof__iso_eof__MASK 0x00002000U
#define R_USB_IRQ_MASK_READ__intr_eof__intr_eof__MASK 0x00001000U
#define R_USB_IRQ_MASK_READ__iso_eot__iso_eot__MASK 0x00000800U
#define R_USB_IRQ_MASK_READ__intr_eot__intr_eot__MASK 0x00000400U
#define R_USB_IRQ_MASK_READ__ctl_eot__ctl_eot__MASK 0x00000200U
#define R_USB_IRQ_MASK_READ__bulk_eot__bulk_eot__MASK 0x00000100U
#define R_USB_IRQ_MASK_READ__epid_attn__epid_attn__MASK 0x00000008U
#define R_USB_IRQ_MASK_READ__sof__sof__MASK 0x00000004U
#define R_USB_IRQ_MASK_READ__port_status__port_status__MASK 0x00000002U
#define R_USB_IRQ_MASK_READ__ctl_status__ctl_status__MASK 0x00000001U

#define R_USB_IRQ_MASK_READ__iso_eof__MAX 0x1
#define R_USB_IRQ_MASK_READ__intr_eof__MAX 0x1
#define R_USB_IRQ_MASK_READ__iso_eot__MAX 0x1
#define R_USB_IRQ_MASK_READ__intr_eot__MAX 0x1
#define R_USB_IRQ_MASK_READ__ctl_eot__MAX 0x1
#define R_USB_IRQ_MASK_READ__bulk_eot__MAX 0x1
#define R_USB_IRQ_MASK_READ__epid_attn__MAX 0x1
#define R_USB_IRQ_MASK_READ__sof__MAX 0x1
#define R_USB_IRQ_MASK_READ__port_status__MAX 0x1
#define R_USB_IRQ_MASK_READ__ctl_status__MAX 0x1

#define R_USB_IRQ_MASK_READ__iso_eof__MIN 0
#define R_USB_IRQ_MASK_READ__intr_eof__MIN 0
#define R_USB_IRQ_MASK_READ__iso_eot__MIN 0
#define R_USB_IRQ_MASK_READ__intr_eot__MIN 0
#define R_USB_IRQ_MASK_READ__ctl_eot__MIN 0
#define R_USB_IRQ_MASK_READ__bulk_eot__MIN 0
#define R_USB_IRQ_MASK_READ__epid_attn__MIN 0
#define R_USB_IRQ_MASK_READ__sof__MIN 0
#define R_USB_IRQ_MASK_READ__port_status__MIN 0
#define R_USB_IRQ_MASK_READ__ctl_status__MIN 0

#define R_USB_IRQ_MASK_READ__iso_eof__BITNR 13
#define R_USB_IRQ_MASK_READ__intr_eof__BITNR 12
#define R_USB_IRQ_MASK_READ__iso_eot__BITNR 11
#define R_USB_IRQ_MASK_READ__intr_eot__BITNR 10
#define R_USB_IRQ_MASK_READ__ctl_eot__BITNR 9
#define R_USB_IRQ_MASK_READ__bulk_eot__BITNR 8
#define R_USB_IRQ_MASK_READ__epid_attn__BITNR 3
#define R_USB_IRQ_MASK_READ__sof__BITNR 2
#define R_USB_IRQ_MASK_READ__port_status__BITNR 1
#define R_USB_IRQ_MASK_READ__ctl_status__BITNR 0

#define R_USB_IRQ_MASK_READ__iso_eof__iso_eof__VAL REG_VAL_ENUM
#define R_USB_IRQ_MASK_READ__intr_eof__intr_eof__VAL REG_VAL_ENUM
#define R_USB_IRQ_MASK_READ__iso_eot__iso_eot__VAL REG_VAL_ENUM
#define R_USB_IRQ_MASK_READ__intr_eot__intr_eot__VAL REG_VAL_ENUM
#define R_USB_IRQ_MASK_READ__ctl_eot__ctl_eot__VAL REG_VAL_ENUM
#define R_USB_IRQ_MASK_READ__bulk_eot__bulk_eot__VAL REG_VAL_ENUM
#define R_USB_IRQ_MASK_READ__epid_attn__epid_attn__VAL REG_VAL_ENUM
#define R_USB_IRQ_MASK_READ__sof__sof__VAL REG_VAL_ENUM
#define R_USB_IRQ_MASK_READ__port_status__port_status__VAL REG_VAL_ENUM
#define R_USB_IRQ_MASK_READ__ctl_status__ctl_status__VAL REG_VAL_ENUM

#define R_USB_IRQ_MASK_READ__iso_eof__iso_eof__no_pend 0
#define R_USB_IRQ_MASK_READ__iso_eof__iso_eof__pend 1
#define R_USB_IRQ_MASK_READ__intr_eof__intr_eof__no_pend 0
#define R_USB_IRQ_MASK_READ__intr_eof__intr_eof__pend 1
#define R_USB_IRQ_MASK_READ__iso_eot__iso_eot__no_pend 0
#define R_USB_IRQ_MASK_READ__iso_eot__iso_eot__pend 1
#define R_USB_IRQ_MASK_READ__intr_eot__intr_eot__no_pend 0
#define R_USB_IRQ_MASK_READ__intr_eot__intr_eot__pend 1
#define R_USB_IRQ_MASK_READ__ctl_eot__ctl_eot__no_pend 0
#define R_USB_IRQ_MASK_READ__ctl_eot__ctl_eot__pend 1
#define R_USB_IRQ_MASK_READ__bulk_eot__bulk_eot__no_pend 0
#define R_USB_IRQ_MASK_READ__bulk_eot__bulk_eot__pend 1
#define R_USB_IRQ_MASK_READ__epid_attn__epid_attn__no_pend 0
#define R_USB_IRQ_MASK_READ__epid_attn__epid_attn__pend 1
#define R_USB_IRQ_MASK_READ__sof__sof__no_pend 0
#define R_USB_IRQ_MASK_READ__sof__sof__pend 1
#define R_USB_IRQ_MASK_READ__port_status__port_status__no_pend 0
#define R_USB_IRQ_MASK_READ__port_status__port_status__pend 1
#define R_USB_IRQ_MASK_READ__ctl_status__ctl_status__no_pend 0
#define R_USB_IRQ_MASK_READ__ctl_status__ctl_status__pend 1

#endif

/*
 *  R_USB_IRQ_MASK_READ_DEV
 *  - type:  RO
 *  - addr:  0xb0000204
 *  - group: USB interface control registers
 */

#if USE_GROUP__USB_interface_control_registers

#define R_USB_IRQ_MASK_READ_DEV__ADDR      (REG_TYPECAST_UWORD  0xb0000204)
#define R_USB_IRQ_MASK_READ_DEV__SVAL      REG_SVAL_SHADOW
#define R_USB_IRQ_MASK_READ_DEV__SVAL_I    REG_SVAL_I_SHADOW
#define R_USB_IRQ_MASK_READ_DEV__TYPECAST  REG_TYPECAST_UWORD
#define R_USB_IRQ_MASK_READ_DEV__TYPE      (REG_UWORD)
#define R_USB_IRQ_MASK_READ_DEV__GET       REG_GET_RO
#define R_USB_IRQ_MASK_READ_DEV__IGET      REG_IGET_RO
#define R_USB_IRQ_MASK_READ_DEV__SET       REG_SET_RO
#define R_USB_IRQ_MASK_READ_DEV__ISET      REG_ISET_RO
#define R_USB_IRQ_MASK_READ_DEV__SET_VAL   REG_SET_VAL_RO
#define R_USB_IRQ_MASK_READ_DEV__EQL       REG_EQL_RO
#define R_USB_IRQ_MASK_READ_DEV__IEQL      REG_IEQL_RO
#define R_USB_IRQ_MASK_READ_DEV__RD        REG_RD_RO
#define R_USB_IRQ_MASK_READ_DEV__IRD       REG_IRD_RO
#define R_USB_IRQ_MASK_READ_DEV__WR        REG_WR_RO
#define R_USB_IRQ_MASK_READ_DEV__IWR       REG_IWR_RO

#define R_USB_IRQ_MASK_READ_DEV__READ(addr) \
  (*(addr))

#define R_USB_IRQ_MASK_READ_DEV__out_eot__out_eot__MASK 0x00001000U
#define R_USB_IRQ_MASK_READ_DEV__ep3_in_eot__ep3_in_eot__MASK 0x00000800U
#define R_USB_IRQ_MASK_READ_DEV__ep2_in_eot__ep2_in_eot__MASK 0x00000400U
#define R_USB_IRQ_MASK_READ_DEV__ep1_in_eot__ep1_in_eot__MASK 0x00000200U
#define R_USB_IRQ_MASK_READ_DEV__ep0_in_eot__ep0_in_eot__MASK 0x00000100U
#define R_USB_IRQ_MASK_READ_DEV__epid_attn__epid_attn__MASK 0x00000008U
#define R_USB_IRQ_MASK_READ_DEV__sof__sof__MASK 0x00000004U
#define R_USB_IRQ_MASK_READ_DEV__port_status__port_status__MASK 0x00000002U
#define R_USB_IRQ_MASK_READ_DEV__ctl_status__ctl_status__MASK 0x00000001U

#define R_USB_IRQ_MASK_READ_DEV__out_eot__MAX 0x1
#define R_USB_IRQ_MASK_READ_DEV__ep3_in_eot__MAX 0x1
#define R_USB_IRQ_MASK_READ_DEV__ep2_in_eot__MAX 0x1
#define R_USB_IRQ_MASK_READ_DEV__ep1_in_eot__MAX 0x1
#define R_USB_IRQ_MASK_READ_DEV__ep0_in_eot__MAX 0x1
#define R_USB_IRQ_MASK_READ_DEV__epid_attn__MAX 0x1
#define R_USB_IRQ_MASK_READ_DEV__sof__MAX 0x1
#define R_USB_IRQ_MASK_READ_DEV__port_status__MAX 0x1
#define R_USB_IRQ_MASK_READ_DEV__ctl_status__MAX 0x1

#define R_USB_IRQ_MASK_READ_DEV__out_eot__MIN 0
#define R_USB_IRQ_MASK_READ_DEV__ep3_in_eot__MIN 0
#define R_USB_IRQ_MASK_READ_DEV__ep2_in_eot__MIN 0
#define R_USB_IRQ_MASK_READ_DEV__ep1_in_eot__MIN 0
#define R_USB_IRQ_MASK_READ_DEV__ep0_in_eot__MIN 0
#define R_USB_IRQ_MASK_READ_DEV__epid_attn__MIN 0
#define R_USB_IRQ_MASK_READ_DEV__sof__MIN 0
#define R_USB_IRQ_MASK_READ_DEV__port_status__MIN 0
#define R_USB_IRQ_MASK_READ_DEV__ctl_status__MIN 0

#define R_USB_IRQ_MASK_READ_DEV__out_eot__BITNR 12
#define R_USB_IRQ_MASK_READ_DEV__ep3_in_eot__BITNR 11
#define R_USB_IRQ_MASK_READ_DEV__ep2_in_eot__BITNR 10
#define R_USB_IRQ_MASK_READ_DEV__ep1_in_eot__BITNR 9
#define R_USB_IRQ_MASK_READ_DEV__ep0_in_eot__BITNR 8
#define R_USB_IRQ_MASK_READ_DEV__epid_attn__BITNR 3
#define R_USB_IRQ_MASK_READ_DEV__sof__BITNR 2
#define R_USB_IRQ_MASK_READ_DEV__port_status__BITNR 1
#define R_USB_IRQ_MASK_READ_DEV__ctl_status__BITNR 0

#define R_USB_IRQ_MASK_READ_DEV__out_eot__out_eot__VAL REG_VAL_ENUM
#define R_USB_IRQ_MASK_READ_DEV__ep3_in_eot__ep3_in_eot__VAL REG_VAL_ENUM
#define R_USB_IRQ_MASK_READ_DEV__ep2_in_eot__ep2_in_eot__VAL REG_VAL_ENUM
#define R_USB_IRQ_MASK_READ_DEV__ep1_in_eot__ep1_in_eot__VAL REG_VAL_ENUM
#define R_USB_IRQ_MASK_READ_DEV__ep0_in_eot__ep0_in_eot__VAL REG_VAL_ENUM
#define R_USB_IRQ_MASK_READ_DEV__epid_attn__epid_attn__VAL REG_VAL_ENUM
#define R_USB_IRQ_MASK_READ_DEV__sof__sof__VAL REG_VAL_ENUM
#define R_USB_IRQ_MASK_READ_DEV__port_status__port_status__VAL REG_VAL_ENUM
#define R_USB_IRQ_MASK_READ_DEV__ctl_status__ctl_status__VAL REG_VAL_ENUM

#define R_USB_IRQ_MASK_READ_DEV__out_eot__out_eot__no_pend 0
#define R_USB_IRQ_MASK_READ_DEV__out_eot__out_eot__pend 1
#define R_USB_IRQ_MASK_READ_DEV__ep3_in_eot__ep3_in_eot__no_pend 0
#define R_USB_IRQ_MASK_READ_DEV__ep3_in_eot__ep3_in_eot__pend 1
#define R_USB_IRQ_MASK_READ_DEV__ep2_in_eot__ep2_in_eot__no_pend 0
#define R_USB_IRQ_MASK_READ_DEV__ep2_in_eot__ep2_in_eot__pend 1
#define R_USB_IRQ_MASK_READ_DEV__ep1_in_eot__ep1_in_eot__no_pend 0
#define R_USB_IRQ_MASK_READ_DEV__ep1_in_eot__ep1_in_eot__pend 1
#define R_USB_IRQ_MASK_READ_DEV__ep0_in_eot__ep0_in_eot__no_pend 0
#define R_USB_IRQ_MASK_READ_DEV__ep0_in_eot__ep0_in_eot__pend 1
#define R_USB_IRQ_MASK_READ_DEV__epid_attn__epid_attn__no_pend 0
#define R_USB_IRQ_MASK_READ_DEV__epid_attn__epid_attn__pend 1
#define R_USB_IRQ_MASK_READ_DEV__sof__sof__no_pend 0
#define R_USB_IRQ_MASK_READ_DEV__sof__sof__pend 1
#define R_USB_IRQ_MASK_READ_DEV__port_status__port_status__no_pend 0
#define R_USB_IRQ_MASK_READ_DEV__port_status__port_status__pend 1
#define R_USB_IRQ_MASK_READ_DEV__ctl_status__ctl_status__no_pend 0
#define R_USB_IRQ_MASK_READ_DEV__ctl_status__ctl_status__pend 1

#endif

/*
 *  R_USB_IRQ_MASK_SET
 *  - type:  WO
 *  - addr:  0xb0000204
 *  - group: USB interface control registers
 */

#if USE_GROUP__USB_interface_control_registers

#define R_USB_IRQ_MASK_SET__ADDR      (REG_TYPECAST_UWORD  0xb0000204)

#ifndef REG_NO_SHADOW
#define R_USB_IRQ_MASK_SET__SADDR     (REG_STYPECAST_UWORD (reg_shadow__hwregs.R_USB_IRQ_MASK_SET + 0))
#define R_USB_IRQ_MASK_SET__IADDR     (REG_STYPECAST_UWORD (reg_initiated__hwregs.R_USB_IRQ_MASK_SET + 0))
#else /* REG_NO_SHADOW */
#define R_USB_IRQ_MASK_SET__SADDR     (REG_STYPECAST_UWORD (&reg_shadow__hwregs))
#define R_USB_IRQ_MASK_SET__IADDR     (REG_STYPECAST_UWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_USB_IRQ_MASK_SET__STYPECAST REG_STYPECAST_UWORD
#define R_USB_IRQ_MASK_SET__SVAL REG_SVAL_ZERO
#define R_USB_IRQ_MASK_SET__SVAL_I REG_SVAL_I_ZERO
#define R_USB_IRQ_MASK_SET__TYPECAST  REG_TYPECAST_UWORD
#define R_USB_IRQ_MASK_SET__TYPE      (REG_UWORD)
#define R_USB_IRQ_MASK_SET__GET       REG_GET_WO
#define R_USB_IRQ_MASK_SET__IGET      REG_IGET_WO
#define R_USB_IRQ_MASK_SET__SET       REG_SET_WO
#define R_USB_IRQ_MASK_SET__ISET      REG_ISET_WO
#define R_USB_IRQ_MASK_SET__SET_VAL   REG_SET_VAL_WO
#define R_USB_IRQ_MASK_SET__EQL       REG_EQL_WO
#define R_USB_IRQ_MASK_SET__IEQL      REG_IEQL_WO
#define R_USB_IRQ_MASK_SET__RD        REG_RD_WO
#define R_USB_IRQ_MASK_SET__IRD       REG_IRD_WO
#define R_USB_IRQ_MASK_SET__WR        REG_WR_WO
#define R_USB_IRQ_MASK_SET__IWR       REG_IWR_WO

#define R_USB_IRQ_MASK_SET__WRITE(addr,value) \
  (*(addr) = (value))

#define R_USB_IRQ_MASK_SET__iso_eof__iso_eof__MASK 0x00002000U
#define R_USB_IRQ_MASK_SET__intr_eof__intr_eof__MASK 0x00001000U
#define R_USB_IRQ_MASK_SET__iso_eot__iso_eot__MASK 0x00000800U
#define R_USB_IRQ_MASK_SET__intr_eot__intr_eot__MASK 0x00000400U
#define R_USB_IRQ_MASK_SET__ctl_eot__ctl_eot__MASK 0x00000200U
#define R_USB_IRQ_MASK_SET__bulk_eot__bulk_eot__MASK 0x00000100U
#define R_USB_IRQ_MASK_SET__epid_attn__epid_attn__MASK 0x00000008U
#define R_USB_IRQ_MASK_SET__sof__sof__MASK 0x00000004U
#define R_USB_IRQ_MASK_SET__port_status__port_status__MASK 0x00000002U
#define R_USB_IRQ_MASK_SET__ctl_status__ctl_status__MASK 0x00000001U

#define R_USB_IRQ_MASK_SET__iso_eof__MAX 0x1
#define R_USB_IRQ_MASK_SET__intr_eof__MAX 0x1
#define R_USB_IRQ_MASK_SET__iso_eot__MAX 0x1
#define R_USB_IRQ_MASK_SET__intr_eot__MAX 0x1
#define R_USB_IRQ_MASK_SET__ctl_eot__MAX 0x1
#define R_USB_IRQ_MASK_SET__bulk_eot__MAX 0x1
#define R_USB_IRQ_MASK_SET__epid_attn__MAX 0x1
#define R_USB_IRQ_MASK_SET__sof__MAX 0x1
#define R_USB_IRQ_MASK_SET__port_status__MAX 0x1
#define R_USB_IRQ_MASK_SET__ctl_status__MAX 0x1

#define R_USB_IRQ_MASK_SET__iso_eof__MIN 0
#define R_USB_IRQ_MASK_SET__intr_eof__MIN 0
#define R_USB_IRQ_MASK_SET__iso_eot__MIN 0
#define R_USB_IRQ_MASK_SET__intr_eot__MIN 0
#define R_USB_IRQ_MASK_SET__ctl_eot__MIN 0
#define R_USB_IRQ_MASK_SET__bulk_eot__MIN 0
#define R_USB_IRQ_MASK_SET__epid_attn__MIN 0
#define R_USB_IRQ_MASK_SET__sof__MIN 0
#define R_USB_IRQ_MASK_SET__port_status__MIN 0
#define R_USB_IRQ_MASK_SET__ctl_status__MIN 0

#define R_USB_IRQ_MASK_SET__iso_eof__BITNR 13
#define R_USB_IRQ_MASK_SET__intr_eof__BITNR 12
#define R_USB_IRQ_MASK_SET__iso_eot__BITNR 11
#define R_USB_IRQ_MASK_SET__intr_eot__BITNR 10
#define R_USB_IRQ_MASK_SET__ctl_eot__BITNR 9
#define R_USB_IRQ_MASK_SET__bulk_eot__BITNR 8
#define R_USB_IRQ_MASK_SET__epid_attn__BITNR 3
#define R_USB_IRQ_MASK_SET__sof__BITNR 2
#define R_USB_IRQ_MASK_SET__port_status__BITNR 1
#define R_USB_IRQ_MASK_SET__ctl_status__BITNR 0

#define R_USB_IRQ_MASK_SET__iso_eof__iso_eof__VAL REG_VAL_ENUM
#define R_USB_IRQ_MASK_SET__intr_eof__intr_eof__VAL REG_VAL_ENUM
#define R_USB_IRQ_MASK_SET__iso_eot__iso_eot__VAL REG_VAL_ENUM
#define R_USB_IRQ_MASK_SET__intr_eot__intr_eot__VAL REG_VAL_ENUM
#define R_USB_IRQ_MASK_SET__ctl_eot__ctl_eot__VAL REG_VAL_ENUM
#define R_USB_IRQ_MASK_SET__bulk_eot__bulk_eot__VAL REG_VAL_ENUM
#define R_USB_IRQ_MASK_SET__epid_attn__epid_attn__VAL REG_VAL_ENUM
#define R_USB_IRQ_MASK_SET__sof__sof__VAL REG_VAL_ENUM
#define R_USB_IRQ_MASK_SET__port_status__port_status__VAL REG_VAL_ENUM
#define R_USB_IRQ_MASK_SET__ctl_status__ctl_status__VAL REG_VAL_ENUM

#define R_USB_IRQ_MASK_SET__iso_eof__iso_eof__nop 0
#define R_USB_IRQ_MASK_SET__iso_eof__iso_eof__set 1
#define R_USB_IRQ_MASK_SET__intr_eof__intr_eof__nop 0
#define R_USB_IRQ_MASK_SET__intr_eof__intr_eof__set 1
#define R_USB_IRQ_MASK_SET__iso_eot__iso_eot__nop 0
#define R_USB_IRQ_MASK_SET__iso_eot__iso_eot__set 1
#define R_USB_IRQ_MASK_SET__intr_eot__intr_eot__nop 0
#define R_USB_IRQ_MASK_SET__intr_eot__intr_eot__set 1
#define R_USB_IRQ_MASK_SET__ctl_eot__ctl_eot__nop 0
#define R_USB_IRQ_MASK_SET__ctl_eot__ctl_eot__set 1
#define R_USB_IRQ_MASK_SET__bulk_eot__bulk_eot__nop 0
#define R_USB_IRQ_MASK_SET__bulk_eot__bulk_eot__set 1
#define R_USB_IRQ_MASK_SET__epid_attn__epid_attn__nop 0
#define R_USB_IRQ_MASK_SET__epid_attn__epid_attn__set 1
#define R_USB_IRQ_MASK_SET__sof__sof__nop 0
#define R_USB_IRQ_MASK_SET__sof__sof__set 1
#define R_USB_IRQ_MASK_SET__port_status__port_status__nop 0
#define R_USB_IRQ_MASK_SET__port_status__port_status__set 1
#define R_USB_IRQ_MASK_SET__ctl_status__ctl_status__nop 0
#define R_USB_IRQ_MASK_SET__ctl_status__ctl_status__set 1

#endif

/*
 *  R_USB_IRQ_MASK_SET_DEV
 *  - type:  WO
 *  - addr:  0xb0000204
 *  - group: USB interface control registers
 */

#if USE_GROUP__USB_interface_control_registers

#define R_USB_IRQ_MASK_SET_DEV__ADDR      (REG_TYPECAST_UWORD  0xb0000204)

#ifndef REG_NO_SHADOW
#define R_USB_IRQ_MASK_SET_DEV__SADDR     (REG_STYPECAST_UWORD (reg_shadow__hwregs.R_USB_IRQ_MASK_SET + 0))
#define R_USB_IRQ_MASK_SET_DEV__IADDR     (REG_STYPECAST_UWORD (reg_initiated__hwregs.R_USB_IRQ_MASK_SET + 0))
#else /* REG_NO_SHADOW */
#define R_USB_IRQ_MASK_SET_DEV__SADDR     (REG_STYPECAST_UWORD (&reg_shadow__hwregs))
#define R_USB_IRQ_MASK_SET_DEV__IADDR     (REG_STYPECAST_UWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_USB_IRQ_MASK_SET_DEV__STYPECAST REG_STYPECAST_UWORD
#define R_USB_IRQ_MASK_SET_DEV__SVAL      REG_SVAL_SHADOW
#define R_USB_IRQ_MASK_SET_DEV__SVAL_I    REG_SVAL_I_SHADOW
#define R_USB_IRQ_MASK_SET_DEV__TYPECAST  REG_TYPECAST_UWORD
#define R_USB_IRQ_MASK_SET_DEV__TYPE      (REG_UWORD)
#define R_USB_IRQ_MASK_SET_DEV__GET       REG_GET_WO
#define R_USB_IRQ_MASK_SET_DEV__IGET      REG_IGET_WO
#define R_USB_IRQ_MASK_SET_DEV__SET       REG_SET_WO
#define R_USB_IRQ_MASK_SET_DEV__ISET      REG_ISET_WO
#define R_USB_IRQ_MASK_SET_DEV__SET_VAL   REG_SET_VAL_WO
#define R_USB_IRQ_MASK_SET_DEV__EQL       REG_EQL_WO
#define R_USB_IRQ_MASK_SET_DEV__IEQL      REG_IEQL_WO
#define R_USB_IRQ_MASK_SET_DEV__RD        REG_RD_WO
#define R_USB_IRQ_MASK_SET_DEV__IRD       REG_IRD_WO
#define R_USB_IRQ_MASK_SET_DEV__WR        REG_WR_WO
#define R_USB_IRQ_MASK_SET_DEV__IWR       REG_IWR_WO

#define R_USB_IRQ_MASK_SET_DEV__WRITE(addr,value) \
  (*(addr) = (value))

#define R_USB_IRQ_MASK_SET_DEV__out_eot__out_eot__MASK 0x00001000U
#define R_USB_IRQ_MASK_SET_DEV__ep3_in_eot__ep3_in_eot__MASK 0x00000800U
#define R_USB_IRQ_MASK_SET_DEV__ep2_in_eot__ep2_in_eot__MASK 0x00000400U
#define R_USB_IRQ_MASK_SET_DEV__ep1_in_eot__ep1_in_eot__MASK 0x00000200U
#define R_USB_IRQ_MASK_SET_DEV__ep0_in_eot__ep0_in_eot__MASK 0x00000100U
#define R_USB_IRQ_MASK_SET_DEV__epid_attn__epid_attn__MASK 0x00000008U
#define R_USB_IRQ_MASK_SET_DEV__sof__sof__MASK 0x00000004U
#define R_USB_IRQ_MASK_SET_DEV__port_status__port_status__MASK 0x00000002U
#define R_USB_IRQ_MASK_SET_DEV__ctl_status__ctl_status__MASK 0x00000001U

#define R_USB_IRQ_MASK_SET_DEV__out_eot__MAX 0x1
#define R_USB_IRQ_MASK_SET_DEV__ep3_in_eot__MAX 0x1
#define R_USB_IRQ_MASK_SET_DEV__ep2_in_eot__MAX 0x1
#define R_USB_IRQ_MASK_SET_DEV__ep1_in_eot__MAX 0x1
#define R_USB_IRQ_MASK_SET_DEV__ep0_in_eot__MAX 0x1
#define R_USB_IRQ_MASK_SET_DEV__epid_attn__MAX 0x1
#define R_USB_IRQ_MASK_SET_DEV__sof__MAX 0x1
#define R_USB_IRQ_MASK_SET_DEV__port_status__MAX 0x1
#define R_USB_IRQ_MASK_SET_DEV__ctl_status__MAX 0x1

#define R_USB_IRQ_MASK_SET_DEV__out_eot__MIN 0
#define R_USB_IRQ_MASK_SET_DEV__ep3_in_eot__MIN 0
#define R_USB_IRQ_MASK_SET_DEV__ep2_in_eot__MIN 0
#define R_USB_IRQ_MASK_SET_DEV__ep1_in_eot__MIN 0
#define R_USB_IRQ_MASK_SET_DEV__ep0_in_eot__MIN 0
#define R_USB_IRQ_MASK_SET_DEV__epid_attn__MIN 0
#define R_USB_IRQ_MASK_SET_DEV__sof__MIN 0
#define R_USB_IRQ_MASK_SET_DEV__port_status__MIN 0
#define R_USB_IRQ_MASK_SET_DEV__ctl_status__MIN 0

#define R_USB_IRQ_MASK_SET_DEV__out_eot__BITNR 12
#define R_USB_IRQ_MASK_SET_DEV__ep3_in_eot__BITNR 11
#define R_USB_IRQ_MASK_SET_DEV__ep2_in_eot__BITNR 10
#define R_USB_IRQ_MASK_SET_DEV__ep1_in_eot__BITNR 9
#define R_USB_IRQ_MASK_SET_DEV__ep0_in_eot__BITNR 8
#define R_USB_IRQ_MASK_SET_DEV__epid_attn__BITNR 3
#define R_USB_IRQ_MASK_SET_DEV__sof__BITNR 2
#define R_USB_IRQ_MASK_SET_DEV__port_status__BITNR 1
#define R_USB_IRQ_MASK_SET_DEV__ctl_status__BITNR 0

#define R_USB_IRQ_MASK_SET_DEV__out_eot__out_eot__VAL REG_VAL_ENUM
#define R_USB_IRQ_MASK_SET_DEV__ep3_in_eot__ep3_in_eot__VAL REG_VAL_ENUM
#define R_USB_IRQ_MASK_SET_DEV__ep2_in_eot__ep2_in_eot__VAL REG_VAL_ENUM
#define R_USB_IRQ_MASK_SET_DEV__ep1_in_eot__ep1_in_eot__VAL REG_VAL_ENUM
#define R_USB_IRQ_MASK_SET_DEV__ep0_in_eot__ep0_in_eot__VAL REG_VAL_ENUM
#define R_USB_IRQ_MASK_SET_DEV__epid_attn__epid_attn__VAL REG_VAL_ENUM
#define R_USB_IRQ_MASK_SET_DEV__sof__sof__VAL REG_VAL_ENUM
#define R_USB_IRQ_MASK_SET_DEV__port_status__port_status__VAL REG_VAL_ENUM
#define R_USB_IRQ_MASK_SET_DEV__ctl_status__ctl_status__VAL REG_VAL_ENUM

#define R_USB_IRQ_MASK_SET_DEV__out_eot__out_eot__nop 0
#define R_USB_IRQ_MASK_SET_DEV__out_eot__out_eot__set 1
#define R_USB_IRQ_MASK_SET_DEV__ep3_in_eot__ep3_in_eot__nop 0
#define R_USB_IRQ_MASK_SET_DEV__ep3_in_eot__ep3_in_eot__set 1
#define R_USB_IRQ_MASK_SET_DEV__ep2_in_eot__ep2_in_eot__nop 0
#define R_USB_IRQ_MASK_SET_DEV__ep2_in_eot__ep2_in_eot__set 1
#define R_USB_IRQ_MASK_SET_DEV__ep1_in_eot__ep1_in_eot__nop 0
#define R_USB_IRQ_MASK_SET_DEV__ep1_in_eot__ep1_in_eot__set 1
#define R_USB_IRQ_MASK_SET_DEV__ep0_in_eot__ep0_in_eot__nop 0
#define R_USB_IRQ_MASK_SET_DEV__ep0_in_eot__ep0_in_eot__set 1
#define R_USB_IRQ_MASK_SET_DEV__epid_attn__epid_attn__nop 0
#define R_USB_IRQ_MASK_SET_DEV__epid_attn__epid_attn__set 1
#define R_USB_IRQ_MASK_SET_DEV__sof__sof__nop 0
#define R_USB_IRQ_MASK_SET_DEV__sof__sof__set 1
#define R_USB_IRQ_MASK_SET_DEV__port_status__port_status__nop 0
#define R_USB_IRQ_MASK_SET_DEV__port_status__port_status__set 1
#define R_USB_IRQ_MASK_SET_DEV__ctl_status__ctl_status__nop 0
#define R_USB_IRQ_MASK_SET_DEV__ctl_status__ctl_status__set 1

#endif

/*
 *  R_USB_IRQ_READ
 *  - type:  RO
 *  - addr:  0xb0000206
 *  - group: USB interface control registers
 */

#if USE_GROUP__USB_interface_control_registers

#define R_USB_IRQ_READ__ADDR      (REG_TYPECAST_UWORD  0xb0000206)
#define R_USB_IRQ_READ__SVAL      REG_SVAL_SHADOW
#define R_USB_IRQ_READ__SVAL_I    REG_SVAL_I_SHADOW
#define R_USB_IRQ_READ__TYPECAST  REG_TYPECAST_UWORD
#define R_USB_IRQ_READ__TYPE      (REG_UWORD)
#define R_USB_IRQ_READ__GET       REG_GET_RO
#define R_USB_IRQ_READ__IGET      REG_IGET_RO
#define R_USB_IRQ_READ__SET       REG_SET_RO
#define R_USB_IRQ_READ__ISET      REG_ISET_RO
#define R_USB_IRQ_READ__SET_VAL   REG_SET_VAL_RO
#define R_USB_IRQ_READ__EQL       REG_EQL_RO
#define R_USB_IRQ_READ__IEQL      REG_IEQL_RO
#define R_USB_IRQ_READ__RD        REG_RD_RO
#define R_USB_IRQ_READ__IRD       REG_IRD_RO
#define R_USB_IRQ_READ__WR        REG_WR_RO
#define R_USB_IRQ_READ__IWR       REG_IWR_RO

#define R_USB_IRQ_READ__READ(addr) \
  (*(addr))

#define R_USB_IRQ_READ__iso_eof__iso_eof__MASK 0x00002000U
#define R_USB_IRQ_READ__intr_eof__intr_eof__MASK 0x00001000U
#define R_USB_IRQ_READ__iso_eot__iso_eot__MASK 0x00000800U
#define R_USB_IRQ_READ__intr_eot__intr_eot__MASK 0x00000400U
#define R_USB_IRQ_READ__ctl_eot__ctl_eot__MASK 0x00000200U
#define R_USB_IRQ_READ__bulk_eot__bulk_eot__MASK 0x00000100U
#define R_USB_IRQ_READ__epid_attn__epid_attn__MASK 0x00000008U
#define R_USB_IRQ_READ__sof__sof__MASK 0x00000004U
#define R_USB_IRQ_READ__port_status__port_status__MASK 0x00000002U
#define R_USB_IRQ_READ__ctl_status__ctl_status__MASK 0x00000001U

#define R_USB_IRQ_READ__iso_eof__MAX 0x1
#define R_USB_IRQ_READ__intr_eof__MAX 0x1
#define R_USB_IRQ_READ__iso_eot__MAX 0x1
#define R_USB_IRQ_READ__intr_eot__MAX 0x1
#define R_USB_IRQ_READ__ctl_eot__MAX 0x1
#define R_USB_IRQ_READ__bulk_eot__MAX 0x1
#define R_USB_IRQ_READ__epid_attn__MAX 0x1
#define R_USB_IRQ_READ__sof__MAX 0x1
#define R_USB_IRQ_READ__port_status__MAX 0x1
#define R_USB_IRQ_READ__ctl_status__MAX 0x1

#define R_USB_IRQ_READ__iso_eof__MIN 0
#define R_USB_IRQ_READ__intr_eof__MIN 0
#define R_USB_IRQ_READ__iso_eot__MIN 0
#define R_USB_IRQ_READ__intr_eot__MIN 0
#define R_USB_IRQ_READ__ctl_eot__MIN 0
#define R_USB_IRQ_READ__bulk_eot__MIN 0
#define R_USB_IRQ_READ__epid_attn__MIN 0
#define R_USB_IRQ_READ__sof__MIN 0
#define R_USB_IRQ_READ__port_status__MIN 0
#define R_USB_IRQ_READ__ctl_status__MIN 0

#define R_USB_IRQ_READ__iso_eof__BITNR 13
#define R_USB_IRQ_READ__intr_eof__BITNR 12
#define R_USB_IRQ_READ__iso_eot__BITNR 11
#define R_USB_IRQ_READ__intr_eot__BITNR 10
#define R_USB_IRQ_READ__ctl_eot__BITNR 9
#define R_USB_IRQ_READ__bulk_eot__BITNR 8
#define R_USB_IRQ_READ__epid_attn__BITNR 3
#define R_USB_IRQ_READ__sof__BITNR 2
#define R_USB_IRQ_READ__port_status__BITNR 1
#define R_USB_IRQ_READ__ctl_status__BITNR 0

#define R_USB_IRQ_READ__iso_eof__iso_eof__VAL REG_VAL_ENUM
#define R_USB_IRQ_READ__intr_eof__intr_eof__VAL REG_VAL_ENUM
#define R_USB_IRQ_READ__iso_eot__iso_eot__VAL REG_VAL_ENUM
#define R_USB_IRQ_READ__intr_eot__intr_eot__VAL REG_VAL_ENUM
#define R_USB_IRQ_READ__ctl_eot__ctl_eot__VAL REG_VAL_ENUM
#define R_USB_IRQ_READ__bulk_eot__bulk_eot__VAL REG_VAL_ENUM
#define R_USB_IRQ_READ__epid_attn__epid_attn__VAL REG_VAL_ENUM
#define R_USB_IRQ_READ__sof__sof__VAL REG_VAL_ENUM
#define R_USB_IRQ_READ__port_status__port_status__VAL REG_VAL_ENUM
#define R_USB_IRQ_READ__ctl_status__ctl_status__VAL REG_VAL_ENUM

#define R_USB_IRQ_READ__iso_eof__iso_eof__no_pend 0
#define R_USB_IRQ_READ__iso_eof__iso_eof__pend 1
#define R_USB_IRQ_READ__intr_eof__intr_eof__no_pend 0
#define R_USB_IRQ_READ__intr_eof__intr_eof__pend 1
#define R_USB_IRQ_READ__iso_eot__iso_eot__no_pend 0
#define R_USB_IRQ_READ__iso_eot__iso_eot__pend 1
#define R_USB_IRQ_READ__intr_eot__intr_eot__no_pend 0
#define R_USB_IRQ_READ__intr_eot__intr_eot__pend 1
#define R_USB_IRQ_READ__ctl_eot__ctl_eot__no_pend 0
#define R_USB_IRQ_READ__ctl_eot__ctl_eot__pend 1
#define R_USB_IRQ_READ__bulk_eot__bulk_eot__no_pend 0
#define R_USB_IRQ_READ__bulk_eot__bulk_eot__pend 1
#define R_USB_IRQ_READ__epid_attn__epid_attn__no_pend 0
#define R_USB_IRQ_READ__epid_attn__epid_attn__pend 1
#define R_USB_IRQ_READ__sof__sof__no_pend 0
#define R_USB_IRQ_READ__sof__sof__pend 1
#define R_USB_IRQ_READ__port_status__port_status__no_pend 0
#define R_USB_IRQ_READ__port_status__port_status__pend 1
#define R_USB_IRQ_READ__ctl_status__ctl_status__no_pend 0
#define R_USB_IRQ_READ__ctl_status__ctl_status__pend 1

#endif

/*
 *  R_USB_IRQ_READ_DEV
 *  - type:  RO
 *  - addr:  0xb0000206
 *  - group: USB interface control registers
 */

#if USE_GROUP__USB_interface_control_registers

#define R_USB_IRQ_READ_DEV__ADDR      (REG_TYPECAST_UWORD  0xb0000206)
#define R_USB_IRQ_READ_DEV__SVAL      REG_SVAL_SHADOW
#define R_USB_IRQ_READ_DEV__SVAL_I    REG_SVAL_I_SHADOW
#define R_USB_IRQ_READ_DEV__TYPECAST  REG_TYPECAST_UWORD
#define R_USB_IRQ_READ_DEV__TYPE      (REG_UWORD)
#define R_USB_IRQ_READ_DEV__GET       REG_GET_RO
#define R_USB_IRQ_READ_DEV__IGET      REG_IGET_RO
#define R_USB_IRQ_READ_DEV__SET       REG_SET_RO
#define R_USB_IRQ_READ_DEV__ISET      REG_ISET_RO
#define R_USB_IRQ_READ_DEV__SET_VAL   REG_SET_VAL_RO
#define R_USB_IRQ_READ_DEV__EQL       REG_EQL_RO
#define R_USB_IRQ_READ_DEV__IEQL      REG_IEQL_RO
#define R_USB_IRQ_READ_DEV__RD        REG_RD_RO
#define R_USB_IRQ_READ_DEV__IRD       REG_IRD_RO
#define R_USB_IRQ_READ_DEV__WR        REG_WR_RO
#define R_USB_IRQ_READ_DEV__IWR       REG_IWR_RO

#define R_USB_IRQ_READ_DEV__READ(addr) \
  (*(addr))

#define R_USB_IRQ_READ_DEV__out_eot__out_eot__MASK 0x00001000U
#define R_USB_IRQ_READ_DEV__ep3_in_eot__ep3_in_eot__MASK 0x00000800U
#define R_USB_IRQ_READ_DEV__ep2_in_eot__ep2_in_eot__MASK 0x00000400U
#define R_USB_IRQ_READ_DEV__ep1_in_eot__ep1_in_eot__MASK 0x00000200U
#define R_USB_IRQ_READ_DEV__ep0_in_eot__ep0_in_eot__MASK 0x00000100U
#define R_USB_IRQ_READ_DEV__epid_attn__epid_attn__MASK 0x00000008U
#define R_USB_IRQ_READ_DEV__sof__sof__MASK 0x00000004U
#define R_USB_IRQ_READ_DEV__port_status__port_status__MASK 0x00000002U
#define R_USB_IRQ_READ_DEV__ctl_status__ctl_status__MASK 0x00000001U

#define R_USB_IRQ_READ_DEV__out_eot__MAX 0x1
#define R_USB_IRQ_READ_DEV__ep3_in_eot__MAX 0x1
#define R_USB_IRQ_READ_DEV__ep2_in_eot__MAX 0x1
#define R_USB_IRQ_READ_DEV__ep1_in_eot__MAX 0x1
#define R_USB_IRQ_READ_DEV__ep0_in_eot__MAX 0x1
#define R_USB_IRQ_READ_DEV__epid_attn__MAX 0x1
#define R_USB_IRQ_READ_DEV__sof__MAX 0x1
#define R_USB_IRQ_READ_DEV__port_status__MAX 0x1
#define R_USB_IRQ_READ_DEV__ctl_status__MAX 0x1

#define R_USB_IRQ_READ_DEV__out_eot__MIN 0
#define R_USB_IRQ_READ_DEV__ep3_in_eot__MIN 0
#define R_USB_IRQ_READ_DEV__ep2_in_eot__MIN 0
#define R_USB_IRQ_READ_DEV__ep1_in_eot__MIN 0
#define R_USB_IRQ_READ_DEV__ep0_in_eot__MIN 0
#define R_USB_IRQ_READ_DEV__epid_attn__MIN 0
#define R_USB_IRQ_READ_DEV__sof__MIN 0
#define R_USB_IRQ_READ_DEV__port_status__MIN 0
#define R_USB_IRQ_READ_DEV__ctl_status__MIN 0

#define R_USB_IRQ_READ_DEV__out_eot__BITNR 12
#define R_USB_IRQ_READ_DEV__ep3_in_eot__BITNR 11
#define R_USB_IRQ_READ_DEV__ep2_in_eot__BITNR 10
#define R_USB_IRQ_READ_DEV__ep1_in_eot__BITNR 9
#define R_USB_IRQ_READ_DEV__ep0_in_eot__BITNR 8
#define R_USB_IRQ_READ_DEV__epid_attn__BITNR 3
#define R_USB_IRQ_READ_DEV__sof__BITNR 2
#define R_USB_IRQ_READ_DEV__port_status__BITNR 1
#define R_USB_IRQ_READ_DEV__ctl_status__BITNR 0

#define R_USB_IRQ_READ_DEV__out_eot__out_eot__VAL REG_VAL_ENUM
#define R_USB_IRQ_READ_DEV__ep3_in_eot__ep3_in_eot__VAL REG_VAL_ENUM
#define R_USB_IRQ_READ_DEV__ep2_in_eot__ep2_in_eot__VAL REG_VAL_ENUM
#define R_USB_IRQ_READ_DEV__ep1_in_eot__ep1_in_eot__VAL REG_VAL_ENUM
#define R_USB_IRQ_READ_DEV__ep0_in_eot__ep0_in_eot__VAL REG_VAL_ENUM
#define R_USB_IRQ_READ_DEV__epid_attn__epid_attn__VAL REG_VAL_ENUM
#define R_USB_IRQ_READ_DEV__sof__sof__VAL REG_VAL_ENUM
#define R_USB_IRQ_READ_DEV__port_status__port_status__VAL REG_VAL_ENUM
#define R_USB_IRQ_READ_DEV__ctl_status__ctl_status__VAL REG_VAL_ENUM

#define R_USB_IRQ_READ_DEV__out_eot__out_eot__no_pend 0
#define R_USB_IRQ_READ_DEV__out_eot__out_eot__pend 1
#define R_USB_IRQ_READ_DEV__ep3_in_eot__ep3_in_eot__no_pend 0
#define R_USB_IRQ_READ_DEV__ep3_in_eot__ep3_in_eot__pend 1
#define R_USB_IRQ_READ_DEV__ep2_in_eot__ep2_in_eot__no_pend 0
#define R_USB_IRQ_READ_DEV__ep2_in_eot__ep2_in_eot__pend 1
#define R_USB_IRQ_READ_DEV__ep1_in_eot__ep1_in_eot__no_pend 0
#define R_USB_IRQ_READ_DEV__ep1_in_eot__ep1_in_eot__pend 1
#define R_USB_IRQ_READ_DEV__ep0_in_eot__ep0_in_eot__no_pend 0
#define R_USB_IRQ_READ_DEV__ep0_in_eot__ep0_in_eot__pend 1
#define R_USB_IRQ_READ_DEV__epid_attn__epid_attn__no_pend 0
#define R_USB_IRQ_READ_DEV__epid_attn__epid_attn__pend 1
#define R_USB_IRQ_READ_DEV__sof__sof__no_pend 0
#define R_USB_IRQ_READ_DEV__sof__sof__pend 1
#define R_USB_IRQ_READ_DEV__port_status__port_status__no_pend 0
#define R_USB_IRQ_READ_DEV__port_status__port_status__pend 1
#define R_USB_IRQ_READ_DEV__ctl_status__ctl_status__no_pend 0
#define R_USB_IRQ_READ_DEV__ctl_status__ctl_status__pend 1

#endif

/*
 *  R_USB_PORT1_DISABLE
 *  - type:  WO
 *  - addr:  0xb000006a
 *  - group: USB interface control registers
 */

#if USE_GROUP__USB_interface_control_registers

#define R_USB_PORT1_DISABLE__ADDR      (REG_TYPECAST_BYTE  0xb000006a)

#ifndef REG_NO_SHADOW
#define R_USB_PORT1_DISABLE__SADDR     (REG_STYPECAST_BYTE (reg_shadow__hwregs.R_SERIAL1_CTRL + 2))
#define R_USB_PORT1_DISABLE__IADDR     (REG_STYPECAST_BYTE (reg_initiated__hwregs.R_SERIAL1_CTRL + 2))
#else /* REG_NO_SHADOW */
#define R_USB_PORT1_DISABLE__SADDR     (REG_STYPECAST_BYTE (&reg_shadow__hwregs))
#define R_USB_PORT1_DISABLE__IADDR     (REG_STYPECAST_BYTE (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_USB_PORT1_DISABLE__STYPECAST REG_STYPECAST_BYTE
#define R_USB_PORT1_DISABLE__SVAL      REG_SVAL_SHADOW
#define R_USB_PORT1_DISABLE__SVAL_I    REG_SVAL_I_SHADOW
#define R_USB_PORT1_DISABLE__TYPECAST  REG_TYPECAST_BYTE
#define R_USB_PORT1_DISABLE__TYPE      (REG_BYTE)
#define R_USB_PORT1_DISABLE__GET       REG_GET_WO
#define R_USB_PORT1_DISABLE__IGET      REG_IGET_WO
#define R_USB_PORT1_DISABLE__SET       REG_SET_WO
#define R_USB_PORT1_DISABLE__ISET      REG_ISET_WO
#define R_USB_PORT1_DISABLE__SET_VAL   REG_SET_VAL_WO
#define R_USB_PORT1_DISABLE__EQL       REG_EQL_WO
#define R_USB_PORT1_DISABLE__IEQL      REG_IEQL_WO
#define R_USB_PORT1_DISABLE__RD        REG_RD_WO
#define R_USB_PORT1_DISABLE__IRD       REG_IRD_WO
#define R_USB_PORT1_DISABLE__WR        REG_WR_WO
#define R_USB_PORT1_DISABLE__IWR       REG_IWR_WO

#define R_USB_PORT1_DISABLE__WRITE(addr,value) \
  (*(addr) = (value))

#define R_USB_PORT1_DISABLE__disable__disable__MASK 0x00000001U

#define R_USB_PORT1_DISABLE__disable__MAX 0x1

#define R_USB_PORT1_DISABLE__disable__MIN 0

#define R_USB_PORT1_DISABLE__disable__BITNR 0

#define R_USB_PORT1_DISABLE__disable__disable__VAL REG_VAL_ENUM

#define R_USB_PORT1_DISABLE__disable__disable__no 1
#define R_USB_PORT1_DISABLE__disable__disable__yes 0

#endif

/*
 *  R_USB_PORT2_DISABLE
 *  - type:  WO
 *  - addr:  0xb0000052
 *  - group: USB interface control registers
 */

#if USE_GROUP__USB_interface_control_registers

#define R_USB_PORT2_DISABLE__ADDR      (REG_TYPECAST_BYTE  0xb0000052)

#ifndef REG_NO_SHADOW
#define R_USB_PORT2_DISABLE__SADDR     (REG_STYPECAST_BYTE (reg_shadow__hwregs.R_PAR1_CTRL_DATA + 2))
#define R_USB_PORT2_DISABLE__IADDR     (REG_STYPECAST_BYTE (reg_initiated__hwregs.R_PAR1_CTRL_DATA + 2))
#else /* REG_NO_SHADOW */
#define R_USB_PORT2_DISABLE__SADDR     (REG_STYPECAST_BYTE (&reg_shadow__hwregs))
#define R_USB_PORT2_DISABLE__IADDR     (REG_STYPECAST_BYTE (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_USB_PORT2_DISABLE__STYPECAST REG_STYPECAST_BYTE
#define R_USB_PORT2_DISABLE__SVAL      REG_SVAL_SHADOW
#define R_USB_PORT2_DISABLE__SVAL_I    REG_SVAL_I_SHADOW
#define R_USB_PORT2_DISABLE__TYPECAST  REG_TYPECAST_BYTE
#define R_USB_PORT2_DISABLE__TYPE      (REG_BYTE)
#define R_USB_PORT2_DISABLE__GET       REG_GET_WO
#define R_USB_PORT2_DISABLE__IGET      REG_IGET_WO
#define R_USB_PORT2_DISABLE__SET       REG_SET_WO
#define R_USB_PORT2_DISABLE__ISET      REG_ISET_WO
#define R_USB_PORT2_DISABLE__SET_VAL   REG_SET_VAL_WO
#define R_USB_PORT2_DISABLE__EQL       REG_EQL_WO
#define R_USB_PORT2_DISABLE__IEQL      REG_IEQL_WO
#define R_USB_PORT2_DISABLE__RD        REG_RD_WO
#define R_USB_PORT2_DISABLE__IRD       REG_IRD_WO
#define R_USB_PORT2_DISABLE__WR        REG_WR_WO
#define R_USB_PORT2_DISABLE__IWR       REG_IWR_WO

#define R_USB_PORT2_DISABLE__WRITE(addr,value) \
  (*(addr) = (value))

#define R_USB_PORT2_DISABLE__disable__disable__MASK 0x00000001U

#define R_USB_PORT2_DISABLE__disable__MAX 0x1

#define R_USB_PORT2_DISABLE__disable__MIN 0

#define R_USB_PORT2_DISABLE__disable__BITNR 0

#define R_USB_PORT2_DISABLE__disable__disable__VAL REG_VAL_ENUM

#define R_USB_PORT2_DISABLE__disable__disable__no 1
#define R_USB_PORT2_DISABLE__disable__disable__yes 0

#endif

/*
 *  R_USB_REVISION
 *  - type:  RO
 *  - addr:  0xb0000200
 *  - group: USB interface control registers
 */

#if USE_GROUP__USB_interface_control_registers

#define R_USB_REVISION__ADDR      (REG_TYPECAST_BYTE  0xb0000200)
#define R_USB_REVISION__SVAL      REG_SVAL_SHADOW
#define R_USB_REVISION__SVAL_I    REG_SVAL_I_SHADOW
#define R_USB_REVISION__TYPECAST  REG_TYPECAST_BYTE
#define R_USB_REVISION__TYPE      (REG_BYTE)
#define R_USB_REVISION__GET       REG_GET_RO
#define R_USB_REVISION__IGET      REG_IGET_RO
#define R_USB_REVISION__SET       REG_SET_RO
#define R_USB_REVISION__ISET      REG_ISET_RO
#define R_USB_REVISION__SET_VAL   REG_SET_VAL_RO
#define R_USB_REVISION__EQL       REG_EQL_RO
#define R_USB_REVISION__IEQL      REG_IEQL_RO
#define R_USB_REVISION__RD        REG_RD_RO
#define R_USB_REVISION__IRD       REG_IRD_RO
#define R_USB_REVISION__WR        REG_WR_RO
#define R_USB_REVISION__IWR       REG_IWR_RO

#define R_USB_REVISION__READ(addr) \
  (*(addr))

#define R_USB_REVISION__major__major__MASK 0x000000f0U
#define R_USB_REVISION__minor__minor__MASK 0x0000000fU

#define R_USB_REVISION__major__MAX 0xf
#define R_USB_REVISION__minor__MAX 0xf

#define R_USB_REVISION__major__MIN 0
#define R_USB_REVISION__minor__MIN 0

#define R_USB_REVISION__major__BITNR 4
#define R_USB_REVISION__minor__BITNR 0

#define R_USB_REVISION__major__major__VAL REG_VAL_VAL
#define R_USB_REVISION__minor__minor__VAL REG_VAL_ENUM

#define R_USB_REVISION__minor__minor__v1_v2 1
#define R_USB_REVISION__minor__minor__v3 0

#endif

/*
 *  R_USB_RH_PORT_STATUS_1
 *  - type:  RO
 *  - addr:  0xb0000218
 *  - group: USB interface control registers
 */

#if USE_GROUP__USB_interface_control_registers

#define R_USB_RH_PORT_STATUS_1__ADDR      (REG_TYPECAST_UWORD  0xb0000218)
#define R_USB_RH_PORT_STATUS_1__SVAL      REG_SVAL_SHADOW
#define R_USB_RH_PORT_STATUS_1__SVAL_I    REG_SVAL_I_SHADOW
#define R_USB_RH_PORT_STATUS_1__TYPECAST  REG_TYPECAST_UWORD
#define R_USB_RH_PORT_STATUS_1__TYPE      (REG_UWORD)
#define R_USB_RH_PORT_STATUS_1__GET       REG_GET_RO
#define R_USB_RH_PORT_STATUS_1__IGET      REG_IGET_RO
#define R_USB_RH_PORT_STATUS_1__SET       REG_SET_RO
#define R_USB_RH_PORT_STATUS_1__ISET      REG_ISET_RO
#define R_USB_RH_PORT_STATUS_1__SET_VAL   REG_SET_VAL_RO
#define R_USB_RH_PORT_STATUS_1__EQL       REG_EQL_RO
#define R_USB_RH_PORT_STATUS_1__IEQL      REG_IEQL_RO
#define R_USB_RH_PORT_STATUS_1__RD        REG_RD_RO
#define R_USB_RH_PORT_STATUS_1__IRD       REG_IRD_RO
#define R_USB_RH_PORT_STATUS_1__WR        REG_WR_RO
#define R_USB_RH_PORT_STATUS_1__IWR       REG_IWR_RO

#define R_USB_RH_PORT_STATUS_1__READ(addr) \
  (*(addr))

#define R_USB_RH_PORT_STATUS_1__speed__speed__MASK 0x00000200U
#define R_USB_RH_PORT_STATUS_1__power__power__MASK 0x00000100U
#define R_USB_RH_PORT_STATUS_1__reset__reset__MASK 0x00000010U
#define R_USB_RH_PORT_STATUS_1__overcurrent__overcurrent__MASK 0x00000008U
#define R_USB_RH_PORT_STATUS_1__suspended__suspended__MASK 0x00000004U
#define R_USB_RH_PORT_STATUS_1__enabled__enabled__MASK 0x00000002U
#define R_USB_RH_PORT_STATUS_1__connected__connected__MASK 0x00000001U

#define R_USB_RH_PORT_STATUS_1__speed__MAX 0x1
#define R_USB_RH_PORT_STATUS_1__power__MAX 0x1
#define R_USB_RH_PORT_STATUS_1__reset__MAX 0x1
#define R_USB_RH_PORT_STATUS_1__overcurrent__MAX 0x1
#define R_USB_RH_PORT_STATUS_1__suspended__MAX 0x1
#define R_USB_RH_PORT_STATUS_1__enabled__MAX 0x1
#define R_USB_RH_PORT_STATUS_1__connected__MAX 0x1

#define R_USB_RH_PORT_STATUS_1__speed__MIN 0
#define R_USB_RH_PORT_STATUS_1__power__MIN 0
#define R_USB_RH_PORT_STATUS_1__reset__MIN 0
#define R_USB_RH_PORT_STATUS_1__overcurrent__MIN 0
#define R_USB_RH_PORT_STATUS_1__suspended__MIN 0
#define R_USB_RH_PORT_STATUS_1__enabled__MIN 0
#define R_USB_RH_PORT_STATUS_1__connected__MIN 0

#define R_USB_RH_PORT_STATUS_1__speed__BITNR 9
#define R_USB_RH_PORT_STATUS_1__power__BITNR 8
#define R_USB_RH_PORT_STATUS_1__reset__BITNR 4
#define R_USB_RH_PORT_STATUS_1__overcurrent__BITNR 3
#define R_USB_RH_PORT_STATUS_1__suspended__BITNR 2
#define R_USB_RH_PORT_STATUS_1__enabled__BITNR 1
#define R_USB_RH_PORT_STATUS_1__connected__BITNR 0

#define R_USB_RH_PORT_STATUS_1__speed__speed__VAL REG_VAL_ENUM
#define R_USB_RH_PORT_STATUS_1__power__power__VAL REG_VAL_VAL
#define R_USB_RH_PORT_STATUS_1__reset__reset__VAL REG_VAL_ENUM
#define R_USB_RH_PORT_STATUS_1__overcurrent__overcurrent__VAL REG_VAL_ENUM
#define R_USB_RH_PORT_STATUS_1__suspended__suspended__VAL REG_VAL_ENUM
#define R_USB_RH_PORT_STATUS_1__enabled__enabled__VAL REG_VAL_ENUM
#define R_USB_RH_PORT_STATUS_1__connected__connected__VAL REG_VAL_ENUM

#define R_USB_RH_PORT_STATUS_1__speed__speed__full 0
#define R_USB_RH_PORT_STATUS_1__speed__speed__low 1
#define R_USB_RH_PORT_STATUS_1__reset__reset__no 0
#define R_USB_RH_PORT_STATUS_1__reset__reset__yes 1
#define R_USB_RH_PORT_STATUS_1__overcurrent__overcurrent__no 0
#define R_USB_RH_PORT_STATUS_1__overcurrent__overcurrent__yes 1
#define R_USB_RH_PORT_STATUS_1__suspended__suspended__no 0
#define R_USB_RH_PORT_STATUS_1__suspended__suspended__yes 1
#define R_USB_RH_PORT_STATUS_1__enabled__enabled__no 0
#define R_USB_RH_PORT_STATUS_1__enabled__enabled__yes 1
#define R_USB_RH_PORT_STATUS_1__connected__connected__no 0
#define R_USB_RH_PORT_STATUS_1__connected__connected__yes 1

#endif

/*
 *  R_USB_RH_PORT_STATUS_2
 *  - type:  RO
 *  - addr:  0xb000021a
 *  - group: USB interface control registers
 */

#if USE_GROUP__USB_interface_control_registers

#define R_USB_RH_PORT_STATUS_2__ADDR      (REG_TYPECAST_UWORD  0xb000021a)
#define R_USB_RH_PORT_STATUS_2__SVAL      REG_SVAL_SHADOW
#define R_USB_RH_PORT_STATUS_2__SVAL_I    REG_SVAL_I_SHADOW
#define R_USB_RH_PORT_STATUS_2__TYPECAST  REG_TYPECAST_UWORD
#define R_USB_RH_PORT_STATUS_2__TYPE      (REG_UWORD)
#define R_USB_RH_PORT_STATUS_2__GET       REG_GET_RO
#define R_USB_RH_PORT_STATUS_2__IGET      REG_IGET_RO
#define R_USB_RH_PORT_STATUS_2__SET       REG_SET_RO
#define R_USB_RH_PORT_STATUS_2__ISET      REG_ISET_RO
#define R_USB_RH_PORT_STATUS_2__SET_VAL   REG_SET_VAL_RO
#define R_USB_RH_PORT_STATUS_2__EQL       REG_EQL_RO
#define R_USB_RH_PORT_STATUS_2__IEQL      REG_IEQL_RO
#define R_USB_RH_PORT_STATUS_2__RD        REG_RD_RO
#define R_USB_RH_PORT_STATUS_2__IRD       REG_IRD_RO
#define R_USB_RH_PORT_STATUS_2__WR        REG_WR_RO
#define R_USB_RH_PORT_STATUS_2__IWR       REG_IWR_RO

#define R_USB_RH_PORT_STATUS_2__READ(addr) \
  (*(addr))

#define R_USB_RH_PORT_STATUS_2__speed__speed__MASK 0x00000200U
#define R_USB_RH_PORT_STATUS_2__power__power__MASK 0x00000100U
#define R_USB_RH_PORT_STATUS_2__reset__reset__MASK 0x00000010U
#define R_USB_RH_PORT_STATUS_2__overcurrent__overcurrent__MASK 0x00000008U
#define R_USB_RH_PORT_STATUS_2__suspended__suspended__MASK 0x00000004U
#define R_USB_RH_PORT_STATUS_2__enabled__enabled__MASK 0x00000002U
#define R_USB_RH_PORT_STATUS_2__connected__connected__MASK 0x00000001U

#define R_USB_RH_PORT_STATUS_2__speed__MAX 0x1
#define R_USB_RH_PORT_STATUS_2__power__MAX 0x1
#define R_USB_RH_PORT_STATUS_2__reset__MAX 0x1
#define R_USB_RH_PORT_STATUS_2__overcurrent__MAX 0x1
#define R_USB_RH_PORT_STATUS_2__suspended__MAX 0x1
#define R_USB_RH_PORT_STATUS_2__enabled__MAX 0x1
#define R_USB_RH_PORT_STATUS_2__connected__MAX 0x1

#define R_USB_RH_PORT_STATUS_2__speed__MIN 0
#define R_USB_RH_PORT_STATUS_2__power__MIN 0
#define R_USB_RH_PORT_STATUS_2__reset__MIN 0
#define R_USB_RH_PORT_STATUS_2__overcurrent__MIN 0
#define R_USB_RH_PORT_STATUS_2__suspended__MIN 0
#define R_USB_RH_PORT_STATUS_2__enabled__MIN 0
#define R_USB_RH_PORT_STATUS_2__connected__MIN 0

#define R_USB_RH_PORT_STATUS_2__speed__BITNR 9
#define R_USB_RH_PORT_STATUS_2__power__BITNR 8
#define R_USB_RH_PORT_STATUS_2__reset__BITNR 4
#define R_USB_RH_PORT_STATUS_2__overcurrent__BITNR 3
#define R_USB_RH_PORT_STATUS_2__suspended__BITNR 2
#define R_USB_RH_PORT_STATUS_2__enabled__BITNR 1
#define R_USB_RH_PORT_STATUS_2__connected__BITNR 0

#define R_USB_RH_PORT_STATUS_2__speed__speed__VAL REG_VAL_ENUM
#define R_USB_RH_PORT_STATUS_2__power__power__VAL REG_VAL_VAL
#define R_USB_RH_PORT_STATUS_2__reset__reset__VAL REG_VAL_ENUM
#define R_USB_RH_PORT_STATUS_2__overcurrent__overcurrent__VAL REG_VAL_ENUM
#define R_USB_RH_PORT_STATUS_2__suspended__suspended__VAL REG_VAL_ENUM
#define R_USB_RH_PORT_STATUS_2__enabled__enabled__VAL REG_VAL_ENUM
#define R_USB_RH_PORT_STATUS_2__connected__connected__VAL REG_VAL_ENUM

#define R_USB_RH_PORT_STATUS_2__speed__speed__full 0
#define R_USB_RH_PORT_STATUS_2__speed__speed__low 1
#define R_USB_RH_PORT_STATUS_2__reset__reset__no 0
#define R_USB_RH_PORT_STATUS_2__reset__reset__yes 1
#define R_USB_RH_PORT_STATUS_2__overcurrent__overcurrent__no 0
#define R_USB_RH_PORT_STATUS_2__overcurrent__overcurrent__yes 1
#define R_USB_RH_PORT_STATUS_2__suspended__suspended__no 0
#define R_USB_RH_PORT_STATUS_2__suspended__suspended__yes 1
#define R_USB_RH_PORT_STATUS_2__enabled__enabled__no 0
#define R_USB_RH_PORT_STATUS_2__enabled__enabled__yes 1
#define R_USB_RH_PORT_STATUS_2__connected__connected__no 0
#define R_USB_RH_PORT_STATUS_2__connected__connected__yes 1

#endif

/*
 *  R_USB_RH_STATUS
 *  - type:  RO
 *  - addr:  0xb0000203
 *  - group: USB interface control registers
 */

#if USE_GROUP__USB_interface_control_registers

#define R_USB_RH_STATUS__ADDR      (REG_TYPECAST_BYTE  0xb0000203)
#define R_USB_RH_STATUS__SVAL      REG_SVAL_SHADOW
#define R_USB_RH_STATUS__SVAL_I    REG_SVAL_I_SHADOW
#define R_USB_RH_STATUS__TYPECAST  REG_TYPECAST_BYTE
#define R_USB_RH_STATUS__TYPE      (REG_BYTE)
#define R_USB_RH_STATUS__GET       REG_GET_RO
#define R_USB_RH_STATUS__IGET      REG_IGET_RO
#define R_USB_RH_STATUS__SET       REG_SET_RO
#define R_USB_RH_STATUS__ISET      REG_ISET_RO
#define R_USB_RH_STATUS__SET_VAL   REG_SET_VAL_RO
#define R_USB_RH_STATUS__EQL       REG_EQL_RO
#define R_USB_RH_STATUS__IEQL      REG_IEQL_RO
#define R_USB_RH_STATUS__RD        REG_RD_RO
#define R_USB_RH_STATUS__IRD       REG_IRD_RO
#define R_USB_RH_STATUS__WR        REG_WR_RO
#define R_USB_RH_STATUS__IWR       REG_IWR_RO

#define R_USB_RH_STATUS__READ(addr) \
  (*(addr))

#define R_USB_RH_STATUS__babble2__babble2__MASK 0x00000080U
#define R_USB_RH_STATUS__babble1__babble1__MASK 0x00000040U
#define R_USB_RH_STATUS__bus1__bus1__MASK 0x00000030U
#define R_USB_RH_STATUS__bus2__bus2__MASK 0x0000000cU
#define R_USB_RH_STATUS__nports__nports__MASK 0x00000003U

#define R_USB_RH_STATUS__babble2__MAX 0x1
#define R_USB_RH_STATUS__babble1__MAX 0x1
#define R_USB_RH_STATUS__bus1__MAX 0x3
#define R_USB_RH_STATUS__bus2__MAX 0x3
#define R_USB_RH_STATUS__nports__MAX 3

#define R_USB_RH_STATUS__babble2__MIN 0
#define R_USB_RH_STATUS__babble1__MIN 0
#define R_USB_RH_STATUS__bus1__MIN 0
#define R_USB_RH_STATUS__bus2__MIN 0
#define R_USB_RH_STATUS__nports__MIN 0

#define R_USB_RH_STATUS__babble2__BITNR 7
#define R_USB_RH_STATUS__babble1__BITNR 6
#define R_USB_RH_STATUS__bus1__BITNR 4
#define R_USB_RH_STATUS__bus2__BITNR 2
#define R_USB_RH_STATUS__nports__BITNR 0

#define R_USB_RH_STATUS__babble2__babble2__VAL REG_VAL_ENUM
#define R_USB_RH_STATUS__babble1__babble1__VAL REG_VAL_ENUM
#define R_USB_RH_STATUS__bus1__bus1__VAL REG_VAL_ENUM
#define R_USB_RH_STATUS__bus2__bus2__VAL REG_VAL_ENUM
#define R_USB_RH_STATUS__nports__nports__VAL REG_VAL_VAL

#define R_USB_RH_STATUS__babble2__babble2__no 0
#define R_USB_RH_STATUS__babble2__babble2__yes 1
#define R_USB_RH_STATUS__babble1__babble1__no 0
#define R_USB_RH_STATUS__babble1__babble1__yes 1
#define R_USB_RH_STATUS__bus1__bus1__Diff0 1
#define R_USB_RH_STATUS__bus1__bus1__Diff1 2
#define R_USB_RH_STATUS__bus1__bus1__SE0 0
#define R_USB_RH_STATUS__bus1__bus1__SE1 3
#define R_USB_RH_STATUS__bus2__bus2__Diff0 1
#define R_USB_RH_STATUS__bus2__bus2__Diff1 2
#define R_USB_RH_STATUS__bus2__bus2__SE0 0
#define R_USB_RH_STATUS__bus2__bus2__SE1 3

#endif

/*
 *  R_USB_SNMP_TERROR
 *  - type:  RW
 *  - addr:  0xb0000220
 *  - group: USB interface control registers
 */

#if USE_GROUP__USB_interface_control_registers

#define R_USB_SNMP_TERROR__ADDR      (REG_TYPECAST_UDWORD  0xb0000220)
#define R_USB_SNMP_TERROR__SVAL      REG_SVAL_SHADOW
#define R_USB_SNMP_TERROR__SVAL_I    REG_SVAL_I_SHADOW
#define R_USB_SNMP_TERROR__TYPECAST  REG_TYPECAST_UDWORD
#define R_USB_SNMP_TERROR__TYPE      (REG_UDWORD)
#define R_USB_SNMP_TERROR__GET       REG_GET_RW
#define R_USB_SNMP_TERROR__IGET      REG_IGET_RW
#define R_USB_SNMP_TERROR__SET       REG_SET_RW
#define R_USB_SNMP_TERROR__ISET      REG_ISET_RW
#define R_USB_SNMP_TERROR__SET_VAL   REG_SET_VAL_RW
#define R_USB_SNMP_TERROR__EQL       REG_EQL_RW
#define R_USB_SNMP_TERROR__IEQL      REG_IEQL_RW
#define R_USB_SNMP_TERROR__RD        REG_RD_RW
#define R_USB_SNMP_TERROR__IRD       REG_IRD_RW
#define R_USB_SNMP_TERROR__WR        REG_WR_RW
#define R_USB_SNMP_TERROR__IWR       REG_IWR_RW

#define R_USB_SNMP_TERROR__WRITE(addr,value) \
  (*(addr) = (value))
#define R_USB_SNMP_TERROR__READ(addr) \
  (*(addr))

#define R_USB_SNMP_TERROR__value__value__MASK 0xffffffffU

#define R_USB_SNMP_TERROR__value__MAX 0xffffffff

#define R_USB_SNMP_TERROR__value__MIN 0

#define R_USB_SNMP_TERROR__value__BITNR 0

#define R_USB_SNMP_TERROR__value__value__VAL REG_VAL_VAL


#endif

/*
 *  R_USB_STATUS
 *  - type:  RO
 *  - addr:  0xb0000202
 *  - group: USB interface control registers
 */

#if USE_GROUP__USB_interface_control_registers

#define R_USB_STATUS__ADDR      (REG_TYPECAST_BYTE  0xb0000202)
#define R_USB_STATUS__SVAL      REG_SVAL_SHADOW
#define R_USB_STATUS__SVAL_I    REG_SVAL_I_SHADOW
#define R_USB_STATUS__TYPECAST  REG_TYPECAST_BYTE
#define R_USB_STATUS__TYPE      (REG_BYTE)
#define R_USB_STATUS__GET       REG_GET_RO
#define R_USB_STATUS__IGET      REG_IGET_RO
#define R_USB_STATUS__SET       REG_SET_RO
#define R_USB_STATUS__ISET      REG_ISET_RO
#define R_USB_STATUS__SET_VAL   REG_SET_VAL_RO
#define R_USB_STATUS__EQL       REG_EQL_RO
#define R_USB_STATUS__IEQL      REG_IEQL_RO
#define R_USB_STATUS__RD        REG_RD_RO
#define R_USB_STATUS__IRD       REG_IRD_RO
#define R_USB_STATUS__WR        REG_WR_RO
#define R_USB_STATUS__IWR       REG_IWR_RO

#define R_USB_STATUS__READ(addr) \
  (*(addr))

#define R_USB_STATUS__ourun__ourun__MASK 0x00000020U
#define R_USB_STATUS__perror__perror__MASK 0x00000010U
#define R_USB_STATUS__device_mode__device_mode__MASK 0x00000008U
#define R_USB_STATUS__host_mode__host_mode__MASK 0x00000004U
#define R_USB_STATUS__started__started__MASK 0x00000002U
#define R_USB_STATUS__running__running__MASK 0x00000001U

#define R_USB_STATUS__ourun__MAX 0x1
#define R_USB_STATUS__perror__MAX 0x1
#define R_USB_STATUS__device_mode__MAX 0x1
#define R_USB_STATUS__host_mode__MAX 0x1
#define R_USB_STATUS__started__MAX 0x1
#define R_USB_STATUS__running__MAX 0x1

#define R_USB_STATUS__ourun__MIN 0
#define R_USB_STATUS__perror__MIN 0
#define R_USB_STATUS__device_mode__MIN 0
#define R_USB_STATUS__host_mode__MIN 0
#define R_USB_STATUS__started__MIN 0
#define R_USB_STATUS__running__MIN 0

#define R_USB_STATUS__ourun__BITNR 5
#define R_USB_STATUS__perror__BITNR 4
#define R_USB_STATUS__device_mode__BITNR 3
#define R_USB_STATUS__host_mode__BITNR 2
#define R_USB_STATUS__started__BITNR 1
#define R_USB_STATUS__running__BITNR 0

#define R_USB_STATUS__ourun__ourun__VAL REG_VAL_ENUM
#define R_USB_STATUS__perror__perror__VAL REG_VAL_ENUM
#define R_USB_STATUS__device_mode__device_mode__VAL REG_VAL_ENUM
#define R_USB_STATUS__host_mode__host_mode__VAL REG_VAL_ENUM
#define R_USB_STATUS__started__started__VAL REG_VAL_ENUM
#define R_USB_STATUS__running__running__VAL REG_VAL_ENUM

#define R_USB_STATUS__ourun__ourun__no 0
#define R_USB_STATUS__ourun__ourun__yes 1
#define R_USB_STATUS__perror__perror__no 0
#define R_USB_STATUS__perror__perror__yes 1
#define R_USB_STATUS__device_mode__device_mode__no 0
#define R_USB_STATUS__device_mode__device_mode__yes 1
#define R_USB_STATUS__host_mode__host_mode__no 0
#define R_USB_STATUS__host_mode__host_mode__yes 1
#define R_USB_STATUS__started__started__no 0
#define R_USB_STATUS__started__started__yes 1
#define R_USB_STATUS__running__running__no 0
#define R_USB_STATUS__running__running__yes 1

#endif

/*
 *  R_VECT_MASK_CLR
 *  - type:  WO
 *  - addr:  0xb00000d8
 *  - group: Interrupt mask and status registers
 */

#if USE_GROUP__Interrupt_mask_and_status_registers

#define R_VECT_MASK_CLR__ADDR      (REG_TYPECAST_UDWORD  0xb00000d8)

#ifndef REG_NO_SHADOW
#define R_VECT_MASK_CLR__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_VECT_MASK_CLR + 0))
#define R_VECT_MASK_CLR__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_VECT_MASK_CLR + 0))
#else /* REG_NO_SHADOW */
#define R_VECT_MASK_CLR__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_VECT_MASK_CLR__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_VECT_MASK_CLR__STYPECAST REG_STYPECAST_UDWORD
#define R_VECT_MASK_CLR__SVAL REG_SVAL_ZERO
#define R_VECT_MASK_CLR__SVAL_I REG_SVAL_I_ZERO
#define R_VECT_MASK_CLR__TYPECAST  REG_TYPECAST_UDWORD
#define R_VECT_MASK_CLR__TYPE      (REG_UDWORD)
#define R_VECT_MASK_CLR__GET       REG_GET_WO
#define R_VECT_MASK_CLR__IGET      REG_IGET_WO
#define R_VECT_MASK_CLR__SET       REG_SET_WO
#define R_VECT_MASK_CLR__ISET      REG_ISET_WO
#define R_VECT_MASK_CLR__SET_VAL   REG_SET_VAL_WO
#define R_VECT_MASK_CLR__EQL       REG_EQL_WO
#define R_VECT_MASK_CLR__IEQL      REG_IEQL_WO
#define R_VECT_MASK_CLR__RD        REG_RD_WO
#define R_VECT_MASK_CLR__IRD       REG_IRD_WO
#define R_VECT_MASK_CLR__WR        REG_WR_WO
#define R_VECT_MASK_CLR__IWR       REG_IWR_WO

#define R_VECT_MASK_CLR__WRITE(addr,value) \
  (*(addr) = (value))

#define R_VECT_MASK_CLR__usb__usb__MASK 0x80000000U
#define R_VECT_MASK_CLR__dma9__dma9__MASK 0x02000000U
#define R_VECT_MASK_CLR__dma8__dma8__MASK 0x01000000U
#define R_VECT_MASK_CLR__dma7__dma7__MASK 0x00800000U
#define R_VECT_MASK_CLR__dma6__dma6__MASK 0x00400000U
#define R_VECT_MASK_CLR__dma5__dma5__MASK 0x00200000U
#define R_VECT_MASK_CLR__dma4__dma4__MASK 0x00100000U
#define R_VECT_MASK_CLR__dma3__dma3__MASK 0x00080000U
#define R_VECT_MASK_CLR__dma2__dma2__MASK 0x00040000U
#define R_VECT_MASK_CLR__dma1__dma1__MASK 0x00020000U
#define R_VECT_MASK_CLR__dma0__dma0__MASK 0x00010000U
#define R_VECT_MASK_CLR__ext_dma1__ext_dma1__MASK 0x00002000U
#define R_VECT_MASK_CLR__ext_dma0__ext_dma0__MASK 0x00001000U
#define R_VECT_MASK_CLR__pa__pa__MASK 0x00000800U
#define R_VECT_MASK_CLR__irq_intnr__irq_intnr__MASK 0x00000400U
#define R_VECT_MASK_CLR__sw__sw__MASK 0x00000200U
#define R_VECT_MASK_CLR__serial__serial__MASK 0x00000100U
#define R_VECT_MASK_CLR__snmp__snmp__MASK 0x00000080U
#define R_VECT_MASK_CLR__network__network__MASK 0x00000040U
#define R_VECT_MASK_CLR__scsi1__scsi1__MASK 0x00000020U
#define R_VECT_MASK_CLR__par1__par1__MASK 0x00000020U
#define R_VECT_MASK_CLR__scsi1__par1__MASK 0x00000020U
#define R_VECT_MASK_CLR__scsi0__scsi0__MASK 0x00000010U
#define R_VECT_MASK_CLR__par0__par0__MASK 0x00000010U
#define R_VECT_MASK_CLR__scsi0__par0__MASK 0x00000010U
#define R_VECT_MASK_CLR__ata__ata__MASK 0x00000010U
#define R_VECT_MASK_CLR__scsi0__ata__MASK 0x00000010U
#define R_VECT_MASK_CLR__mio__mio__MASK 0x00000010U
#define R_VECT_MASK_CLR__scsi0__mio__MASK 0x00000010U
#define R_VECT_MASK_CLR__timer1__timer1__MASK 0x00000008U
#define R_VECT_MASK_CLR__timer0__timer0__MASK 0x00000004U
#define R_VECT_MASK_CLR__nmi__nmi__MASK 0x00000002U
#define R_VECT_MASK_CLR__some__some__MASK 0x00000001U

#define R_VECT_MASK_CLR__usb__MAX 0x1
#define R_VECT_MASK_CLR__dma9__MAX 0x1
#define R_VECT_MASK_CLR__dma8__MAX 0x1
#define R_VECT_MASK_CLR__dma7__MAX 0x1
#define R_VECT_MASK_CLR__dma6__MAX 0x1
#define R_VECT_MASK_CLR__dma5__MAX 0x1
#define R_VECT_MASK_CLR__dma4__MAX 0x1
#define R_VECT_MASK_CLR__dma3__MAX 0x1
#define R_VECT_MASK_CLR__dma2__MAX 0x1
#define R_VECT_MASK_CLR__dma1__MAX 0x1
#define R_VECT_MASK_CLR__dma0__MAX 0x1
#define R_VECT_MASK_CLR__ext_dma1__MAX 0x1
#define R_VECT_MASK_CLR__ext_dma0__MAX 0x1
#define R_VECT_MASK_CLR__pa__MAX 0x1
#define R_VECT_MASK_CLR__irq_intnr__MAX 0x1
#define R_VECT_MASK_CLR__sw__MAX 0x1
#define R_VECT_MASK_CLR__serial__MAX 0x1
#define R_VECT_MASK_CLR__snmp__MAX 0x1
#define R_VECT_MASK_CLR__network__MAX 0x1
#define R_VECT_MASK_CLR__scsi1__MAX 0x1
#define R_VECT_MASK_CLR__par1__MAX 0x1
#define R_VECT_MASK_CLR__scsi0__MAX 0x1
#define R_VECT_MASK_CLR__par0__MAX 0x1
#define R_VECT_MASK_CLR__ata__MAX 0x1
#define R_VECT_MASK_CLR__mio__MAX 0x1
#define R_VECT_MASK_CLR__timer1__MAX 0x1
#define R_VECT_MASK_CLR__timer0__MAX 0x1
#define R_VECT_MASK_CLR__nmi__MAX 0x1
#define R_VECT_MASK_CLR__some__MAX 0x1

#define R_VECT_MASK_CLR__usb__MIN 0
#define R_VECT_MASK_CLR__dma9__MIN 0
#define R_VECT_MASK_CLR__dma8__MIN 0
#define R_VECT_MASK_CLR__dma7__MIN 0
#define R_VECT_MASK_CLR__dma6__MIN 0
#define R_VECT_MASK_CLR__dma5__MIN 0
#define R_VECT_MASK_CLR__dma4__MIN 0
#define R_VECT_MASK_CLR__dma3__MIN 0
#define R_VECT_MASK_CLR__dma2__MIN 0
#define R_VECT_MASK_CLR__dma1__MIN 0
#define R_VECT_MASK_CLR__dma0__MIN 0
#define R_VECT_MASK_CLR__ext_dma1__MIN 0
#define R_VECT_MASK_CLR__ext_dma0__MIN 0
#define R_VECT_MASK_CLR__pa__MIN 0
#define R_VECT_MASK_CLR__irq_intnr__MIN 0
#define R_VECT_MASK_CLR__sw__MIN 0
#define R_VECT_MASK_CLR__serial__MIN 0
#define R_VECT_MASK_CLR__snmp__MIN 0
#define R_VECT_MASK_CLR__network__MIN 0
#define R_VECT_MASK_CLR__scsi1__MIN 0
#define R_VECT_MASK_CLR__par1__MIN 0
#define R_VECT_MASK_CLR__scsi0__MIN 0
#define R_VECT_MASK_CLR__par0__MIN 0
#define R_VECT_MASK_CLR__ata__MIN 0
#define R_VECT_MASK_CLR__mio__MIN 0
#define R_VECT_MASK_CLR__timer1__MIN 0
#define R_VECT_MASK_CLR__timer0__MIN 0
#define R_VECT_MASK_CLR__nmi__MIN 0
#define R_VECT_MASK_CLR__some__MIN 0

#define R_VECT_MASK_CLR__usb__BITNR 31
#define R_VECT_MASK_CLR__dma9__BITNR 25
#define R_VECT_MASK_CLR__dma8__BITNR 24
#define R_VECT_MASK_CLR__dma7__BITNR 23
#define R_VECT_MASK_CLR__dma6__BITNR 22
#define R_VECT_MASK_CLR__dma5__BITNR 21
#define R_VECT_MASK_CLR__dma4__BITNR 20
#define R_VECT_MASK_CLR__dma3__BITNR 19
#define R_VECT_MASK_CLR__dma2__BITNR 18
#define R_VECT_MASK_CLR__dma1__BITNR 17
#define R_VECT_MASK_CLR__dma0__BITNR 16
#define R_VECT_MASK_CLR__ext_dma1__BITNR 13
#define R_VECT_MASK_CLR__ext_dma0__BITNR 12
#define R_VECT_MASK_CLR__pa__BITNR 11
#define R_VECT_MASK_CLR__irq_intnr__BITNR 10
#define R_VECT_MASK_CLR__sw__BITNR 9
#define R_VECT_MASK_CLR__serial__BITNR 8
#define R_VECT_MASK_CLR__snmp__BITNR 7
#define R_VECT_MASK_CLR__network__BITNR 6
#define R_VECT_MASK_CLR__scsi1__BITNR 5
#define R_VECT_MASK_CLR__par1__BITNR 5
#define R_VECT_MASK_CLR__scsi0__BITNR 4
#define R_VECT_MASK_CLR__par0__BITNR 4
#define R_VECT_MASK_CLR__ata__BITNR 4
#define R_VECT_MASK_CLR__mio__BITNR 4
#define R_VECT_MASK_CLR__timer1__BITNR 3
#define R_VECT_MASK_CLR__timer0__BITNR 2
#define R_VECT_MASK_CLR__nmi__BITNR 1
#define R_VECT_MASK_CLR__some__BITNR 0

#define R_VECT_MASK_CLR__usb__usb__VAL REG_VAL_ENUM
#define R_VECT_MASK_CLR__dma9__dma9__VAL REG_VAL_ENUM
#define R_VECT_MASK_CLR__dma8__dma8__VAL REG_VAL_ENUM
#define R_VECT_MASK_CLR__dma7__dma7__VAL REG_VAL_ENUM
#define R_VECT_MASK_CLR__dma6__dma6__VAL REG_VAL_ENUM
#define R_VECT_MASK_CLR__dma5__dma5__VAL REG_VAL_ENUM
#define R_VECT_MASK_CLR__dma4__dma4__VAL REG_VAL_ENUM
#define R_VECT_MASK_CLR__dma3__dma3__VAL REG_VAL_ENUM
#define R_VECT_MASK_CLR__dma2__dma2__VAL REG_VAL_ENUM
#define R_VECT_MASK_CLR__dma1__dma1__VAL REG_VAL_ENUM
#define R_VECT_MASK_CLR__dma0__dma0__VAL REG_VAL_ENUM
#define R_VECT_MASK_CLR__ext_dma1__ext_dma1__VAL REG_VAL_ENUM
#define R_VECT_MASK_CLR__ext_dma0__ext_dma0__VAL REG_VAL_ENUM
#define R_VECT_MASK_CLR__pa__pa__VAL REG_VAL_ENUM
#define R_VECT_MASK_CLR__irq_intnr__irq_intnr__VAL REG_VAL_ENUM
#define R_VECT_MASK_CLR__sw__sw__VAL REG_VAL_ENUM
#define R_VECT_MASK_CLR__serial__serial__VAL REG_VAL_ENUM
#define R_VECT_MASK_CLR__snmp__snmp__VAL REG_VAL_ENUM
#define R_VECT_MASK_CLR__network__network__VAL REG_VAL_ENUM
#define R_VECT_MASK_CLR__scsi1__scsi1__VAL REG_VAL_ENUM
#define R_VECT_MASK_CLR__par1__par1__VAL REG_VAL_ENUM
#define R_VECT_MASK_CLR__scsi1__par1__VAL REG_VAL_ENUM
#define R_VECT_MASK_CLR__scsi0__scsi0__VAL REG_VAL_ENUM
#define R_VECT_MASK_CLR__par0__par0__VAL REG_VAL_ENUM
#define R_VECT_MASK_CLR__scsi0__par0__VAL REG_VAL_ENUM
#define R_VECT_MASK_CLR__ata__ata__VAL REG_VAL_ENUM
#define R_VECT_MASK_CLR__scsi0__ata__VAL REG_VAL_ENUM
#define R_VECT_MASK_CLR__mio__mio__VAL REG_VAL_ENUM
#define R_VECT_MASK_CLR__scsi0__mio__VAL REG_VAL_ENUM
#define R_VECT_MASK_CLR__timer1__timer1__VAL REG_VAL_ENUM
#define R_VECT_MASK_CLR__timer0__timer0__VAL REG_VAL_ENUM
#define R_VECT_MASK_CLR__nmi__nmi__VAL REG_VAL_ENUM
#define R_VECT_MASK_CLR__some__some__VAL REG_VAL_ENUM

#define R_VECT_MASK_CLR__usb__usb__clr 1
#define R_VECT_MASK_CLR__usb__usb__nop 0
#define R_VECT_MASK_CLR__dma9__dma9__clr 1
#define R_VECT_MASK_CLR__dma9__dma9__nop 0
#define R_VECT_MASK_CLR__dma8__dma8__clr 1
#define R_VECT_MASK_CLR__dma8__dma8__nop 0
#define R_VECT_MASK_CLR__dma7__dma7__clr 1
#define R_VECT_MASK_CLR__dma7__dma7__nop 0
#define R_VECT_MASK_CLR__dma6__dma6__clr 1
#define R_VECT_MASK_CLR__dma6__dma6__nop 0
#define R_VECT_MASK_CLR__dma5__dma5__clr 1
#define R_VECT_MASK_CLR__dma5__dma5__nop 0
#define R_VECT_MASK_CLR__dma4__dma4__clr 1
#define R_VECT_MASK_CLR__dma4__dma4__nop 0
#define R_VECT_MASK_CLR__dma3__dma3__clr 1
#define R_VECT_MASK_CLR__dma3__dma3__nop 0
#define R_VECT_MASK_CLR__dma2__dma2__clr 1
#define R_VECT_MASK_CLR__dma2__dma2__nop 0
#define R_VECT_MASK_CLR__dma1__dma1__clr 1
#define R_VECT_MASK_CLR__dma1__dma1__nop 0
#define R_VECT_MASK_CLR__dma0__dma0__clr 1
#define R_VECT_MASK_CLR__dma0__dma0__nop 0
#define R_VECT_MASK_CLR__ext_dma1__ext_dma1__clr 1
#define R_VECT_MASK_CLR__ext_dma1__ext_dma1__nop 0
#define R_VECT_MASK_CLR__ext_dma0__ext_dma0__clr 1
#define R_VECT_MASK_CLR__ext_dma0__ext_dma0__nop 0
#define R_VECT_MASK_CLR__pa__pa__clr 1
#define R_VECT_MASK_CLR__pa__pa__nop 0
#define R_VECT_MASK_CLR__irq_intnr__irq_intnr__clr 1
#define R_VECT_MASK_CLR__irq_intnr__irq_intnr__nop 0
#define R_VECT_MASK_CLR__sw__sw__clr 1
#define R_VECT_MASK_CLR__sw__sw__nop 0
#define R_VECT_MASK_CLR__serial__serial__clr 1
#define R_VECT_MASK_CLR__serial__serial__nop 0
#define R_VECT_MASK_CLR__snmp__snmp__clr 1
#define R_VECT_MASK_CLR__snmp__snmp__nop 0
#define R_VECT_MASK_CLR__network__network__clr 1
#define R_VECT_MASK_CLR__network__network__nop 0
#define R_VECT_MASK_CLR__scsi1__scsi1__clr 1
#define R_VECT_MASK_CLR__scsi1__scsi1__nop 0
#define R_VECT_MASK_CLR__par1__par1__clr 1
#define R_VECT_MASK_CLR__par1__par1__nop 0
#define R_VECT_MASK_CLR__scsi0__scsi0__clr 1
#define R_VECT_MASK_CLR__scsi0__scsi0__nop 0
#define R_VECT_MASK_CLR__par0__par0__clr 1
#define R_VECT_MASK_CLR__par0__par0__nop 0
#define R_VECT_MASK_CLR__ata__ata__clr 1
#define R_VECT_MASK_CLR__ata__ata__nop 0
#define R_VECT_MASK_CLR__mio__mio__clr 1
#define R_VECT_MASK_CLR__mio__mio__nop 0
#define R_VECT_MASK_CLR__timer1__timer1__clr 1
#define R_VECT_MASK_CLR__timer1__timer1__nop 0
#define R_VECT_MASK_CLR__timer0__timer0__clr 1
#define R_VECT_MASK_CLR__timer0__timer0__nop 0
#define R_VECT_MASK_CLR__nmi__nmi__clr 1
#define R_VECT_MASK_CLR__nmi__nmi__nop 0
#define R_VECT_MASK_CLR__some__some__clr 1
#define R_VECT_MASK_CLR__some__some__nop 0

#endif

/*
 *  R_VECT_MASK_RD
 *  - type:  RO
 *  - addr:  0xb00000d8
 *  - group: Interrupt mask and status registers
 */

#if USE_GROUP__Interrupt_mask_and_status_registers

#define R_VECT_MASK_RD__ADDR      (REG_TYPECAST_UDWORD  0xb00000d8)
#define R_VECT_MASK_RD__SVAL      REG_SVAL_SHADOW
#define R_VECT_MASK_RD__SVAL_I    REG_SVAL_I_SHADOW
#define R_VECT_MASK_RD__TYPECAST  REG_TYPECAST_UDWORD
#define R_VECT_MASK_RD__TYPE      (REG_UDWORD)
#define R_VECT_MASK_RD__GET       REG_GET_RO
#define R_VECT_MASK_RD__IGET      REG_IGET_RO
#define R_VECT_MASK_RD__SET       REG_SET_RO
#define R_VECT_MASK_RD__ISET      REG_ISET_RO
#define R_VECT_MASK_RD__SET_VAL   REG_SET_VAL_RO
#define R_VECT_MASK_RD__EQL       REG_EQL_RO
#define R_VECT_MASK_RD__IEQL      REG_IEQL_RO
#define R_VECT_MASK_RD__RD        REG_RD_RO
#define R_VECT_MASK_RD__IRD       REG_IRD_RO
#define R_VECT_MASK_RD__WR        REG_WR_RO
#define R_VECT_MASK_RD__IWR       REG_IWR_RO

#define R_VECT_MASK_RD__READ(addr) \
  (*(addr))

#define R_VECT_MASK_RD__usb__usb__MASK 0x80000000U
#define R_VECT_MASK_RD__dma9__dma9__MASK 0x02000000U
#define R_VECT_MASK_RD__dma8__dma8__MASK 0x01000000U
#define R_VECT_MASK_RD__dma7__dma7__MASK 0x00800000U
#define R_VECT_MASK_RD__dma6__dma6__MASK 0x00400000U
#define R_VECT_MASK_RD__dma5__dma5__MASK 0x00200000U
#define R_VECT_MASK_RD__dma4__dma4__MASK 0x00100000U
#define R_VECT_MASK_RD__dma3__dma3__MASK 0x00080000U
#define R_VECT_MASK_RD__dma2__dma2__MASK 0x00040000U
#define R_VECT_MASK_RD__dma1__dma1__MASK 0x00020000U
#define R_VECT_MASK_RD__dma0__dma0__MASK 0x00010000U
#define R_VECT_MASK_RD__ext_dma1__ext_dma1__MASK 0x00002000U
#define R_VECT_MASK_RD__ext_dma0__ext_dma0__MASK 0x00001000U
#define R_VECT_MASK_RD__pa__pa__MASK 0x00000800U
#define R_VECT_MASK_RD__irq_intnr__irq_intnr__MASK 0x00000400U
#define R_VECT_MASK_RD__sw__sw__MASK 0x00000200U
#define R_VECT_MASK_RD__serial__serial__MASK 0x00000100U
#define R_VECT_MASK_RD__snmp__snmp__MASK 0x00000080U
#define R_VECT_MASK_RD__network__network__MASK 0x00000040U
#define R_VECT_MASK_RD__scsi1__scsi1__MASK 0x00000020U
#define R_VECT_MASK_RD__par1__par1__MASK 0x00000020U
#define R_VECT_MASK_RD__scsi1__par1__MASK 0x00000020U
#define R_VECT_MASK_RD__scsi0__scsi0__MASK 0x00000010U
#define R_VECT_MASK_RD__par0__par0__MASK 0x00000010U
#define R_VECT_MASK_RD__scsi0__par0__MASK 0x00000010U
#define R_VECT_MASK_RD__ata__ata__MASK 0x00000010U
#define R_VECT_MASK_RD__scsi0__ata__MASK 0x00000010U
#define R_VECT_MASK_RD__mio__mio__MASK 0x00000010U
#define R_VECT_MASK_RD__scsi0__mio__MASK 0x00000010U
#define R_VECT_MASK_RD__timer1__timer1__MASK 0x00000008U
#define R_VECT_MASK_RD__timer0__timer0__MASK 0x00000004U
#define R_VECT_MASK_RD__nmi__nmi__MASK 0x00000002U
#define R_VECT_MASK_RD__some__some__MASK 0x00000001U

#define R_VECT_MASK_RD__usb__MAX 0x1
#define R_VECT_MASK_RD__dma9__MAX 0x1
#define R_VECT_MASK_RD__dma8__MAX 0x1
#define R_VECT_MASK_RD__dma7__MAX 0x1
#define R_VECT_MASK_RD__dma6__MAX 0x1
#define R_VECT_MASK_RD__dma5__MAX 0x1
#define R_VECT_MASK_RD__dma4__MAX 0x1
#define R_VECT_MASK_RD__dma3__MAX 0x1
#define R_VECT_MASK_RD__dma2__MAX 0x1
#define R_VECT_MASK_RD__dma1__MAX 0x1
#define R_VECT_MASK_RD__dma0__MAX 0x1
#define R_VECT_MASK_RD__ext_dma1__MAX 0x1
#define R_VECT_MASK_RD__ext_dma0__MAX 0x1
#define R_VECT_MASK_RD__pa__MAX 0x1
#define R_VECT_MASK_RD__irq_intnr__MAX 0x1
#define R_VECT_MASK_RD__sw__MAX 0x1
#define R_VECT_MASK_RD__serial__MAX 0x1
#define R_VECT_MASK_RD__snmp__MAX 0x1
#define R_VECT_MASK_RD__network__MAX 0x1
#define R_VECT_MASK_RD__scsi1__MAX 0x1
#define R_VECT_MASK_RD__par1__MAX 0x1
#define R_VECT_MASK_RD__scsi0__MAX 0x1
#define R_VECT_MASK_RD__par0__MAX 0x1
#define R_VECT_MASK_RD__ata__MAX 0x1
#define R_VECT_MASK_RD__mio__MAX 0x1
#define R_VECT_MASK_RD__timer1__MAX 0x1
#define R_VECT_MASK_RD__timer0__MAX 0x1
#define R_VECT_MASK_RD__nmi__MAX 0x1
#define R_VECT_MASK_RD__some__MAX 0x1

#define R_VECT_MASK_RD__usb__MIN 0
#define R_VECT_MASK_RD__dma9__MIN 0
#define R_VECT_MASK_RD__dma8__MIN 0
#define R_VECT_MASK_RD__dma7__MIN 0
#define R_VECT_MASK_RD__dma6__MIN 0
#define R_VECT_MASK_RD__dma5__MIN 0
#define R_VECT_MASK_RD__dma4__MIN 0
#define R_VECT_MASK_RD__dma3__MIN 0
#define R_VECT_MASK_RD__dma2__MIN 0
#define R_VECT_MASK_RD__dma1__MIN 0
#define R_VECT_MASK_RD__dma0__MIN 0
#define R_VECT_MASK_RD__ext_dma1__MIN 0
#define R_VECT_MASK_RD__ext_dma0__MIN 0
#define R_VECT_MASK_RD__pa__MIN 0
#define R_VECT_MASK_RD__irq_intnr__MIN 0
#define R_VECT_MASK_RD__sw__MIN 0
#define R_VECT_MASK_RD__serial__MIN 0
#define R_VECT_MASK_RD__snmp__MIN 0
#define R_VECT_MASK_RD__network__MIN 0
#define R_VECT_MASK_RD__scsi1__MIN 0
#define R_VECT_MASK_RD__par1__MIN 0
#define R_VECT_MASK_RD__scsi0__MIN 0
#define R_VECT_MASK_RD__par0__MIN 0
#define R_VECT_MASK_RD__ata__MIN 0
#define R_VECT_MASK_RD__mio__MIN 0
#define R_VECT_MASK_RD__timer1__MIN 0
#define R_VECT_MASK_RD__timer0__MIN 0
#define R_VECT_MASK_RD__nmi__MIN 0
#define R_VECT_MASK_RD__some__MIN 0

#define R_VECT_MASK_RD__usb__BITNR 31
#define R_VECT_MASK_RD__dma9__BITNR 25
#define R_VECT_MASK_RD__dma8__BITNR 24
#define R_VECT_MASK_RD__dma7__BITNR 23
#define R_VECT_MASK_RD__dma6__BITNR 22
#define R_VECT_MASK_RD__dma5__BITNR 21
#define R_VECT_MASK_RD__dma4__BITNR 20
#define R_VECT_MASK_RD__dma3__BITNR 19
#define R_VECT_MASK_RD__dma2__BITNR 18
#define R_VECT_MASK_RD__dma1__BITNR 17
#define R_VECT_MASK_RD__dma0__BITNR 16
#define R_VECT_MASK_RD__ext_dma1__BITNR 13
#define R_VECT_MASK_RD__ext_dma0__BITNR 12
#define R_VECT_MASK_RD__pa__BITNR 11
#define R_VECT_MASK_RD__irq_intnr__BITNR 10
#define R_VECT_MASK_RD__sw__BITNR 9
#define R_VECT_MASK_RD__serial__BITNR 8
#define R_VECT_MASK_RD__snmp__BITNR 7
#define R_VECT_MASK_RD__network__BITNR 6
#define R_VECT_MASK_RD__scsi1__BITNR 5
#define R_VECT_MASK_RD__par1__BITNR 5
#define R_VECT_MASK_RD__scsi0__BITNR 4
#define R_VECT_MASK_RD__par0__BITNR 4
#define R_VECT_MASK_RD__ata__BITNR 4
#define R_VECT_MASK_RD__mio__BITNR 4
#define R_VECT_MASK_RD__timer1__BITNR 3
#define R_VECT_MASK_RD__timer0__BITNR 2
#define R_VECT_MASK_RD__nmi__BITNR 1
#define R_VECT_MASK_RD__some__BITNR 0

#define R_VECT_MASK_RD__usb__usb__VAL REG_VAL_ENUM
#define R_VECT_MASK_RD__dma9__dma9__VAL REG_VAL_ENUM
#define R_VECT_MASK_RD__dma8__dma8__VAL REG_VAL_ENUM
#define R_VECT_MASK_RD__dma7__dma7__VAL REG_VAL_ENUM
#define R_VECT_MASK_RD__dma6__dma6__VAL REG_VAL_ENUM
#define R_VECT_MASK_RD__dma5__dma5__VAL REG_VAL_ENUM
#define R_VECT_MASK_RD__dma4__dma4__VAL REG_VAL_ENUM
#define R_VECT_MASK_RD__dma3__dma3__VAL REG_VAL_ENUM
#define R_VECT_MASK_RD__dma2__dma2__VAL REG_VAL_ENUM
#define R_VECT_MASK_RD__dma1__dma1__VAL REG_VAL_ENUM
#define R_VECT_MASK_RD__dma0__dma0__VAL REG_VAL_ENUM
#define R_VECT_MASK_RD__ext_dma1__ext_dma1__VAL REG_VAL_ENUM
#define R_VECT_MASK_RD__ext_dma0__ext_dma0__VAL REG_VAL_ENUM
#define R_VECT_MASK_RD__pa__pa__VAL REG_VAL_ENUM
#define R_VECT_MASK_RD__irq_intnr__irq_intnr__VAL REG_VAL_ENUM
#define R_VECT_MASK_RD__sw__sw__VAL REG_VAL_ENUM
#define R_VECT_MASK_RD__serial__serial__VAL REG_VAL_ENUM
#define R_VECT_MASK_RD__snmp__snmp__VAL REG_VAL_ENUM
#define R_VECT_MASK_RD__network__network__VAL REG_VAL_ENUM
#define R_VECT_MASK_RD__scsi1__scsi1__VAL REG_VAL_ENUM
#define R_VECT_MASK_RD__par1__par1__VAL REG_VAL_ENUM
#define R_VECT_MASK_RD__scsi1__par1__VAL REG_VAL_ENUM
#define R_VECT_MASK_RD__scsi0__scsi0__VAL REG_VAL_ENUM
#define R_VECT_MASK_RD__par0__par0__VAL REG_VAL_ENUM
#define R_VECT_MASK_RD__scsi0__par0__VAL REG_VAL_ENUM
#define R_VECT_MASK_RD__ata__ata__VAL REG_VAL_ENUM
#define R_VECT_MASK_RD__scsi0__ata__VAL REG_VAL_ENUM
#define R_VECT_MASK_RD__mio__mio__VAL REG_VAL_ENUM
#define R_VECT_MASK_RD__scsi0__mio__VAL REG_VAL_ENUM
#define R_VECT_MASK_RD__timer1__timer1__VAL REG_VAL_ENUM
#define R_VECT_MASK_RD__timer0__timer0__VAL REG_VAL_ENUM
#define R_VECT_MASK_RD__nmi__nmi__VAL REG_VAL_ENUM
#define R_VECT_MASK_RD__some__some__VAL REG_VAL_ENUM

#define R_VECT_MASK_RD__usb__usb__active 1
#define R_VECT_MASK_RD__usb__usb__inactive 0
#define R_VECT_MASK_RD__dma9__dma9__active 1
#define R_VECT_MASK_RD__dma9__dma9__inactive 0
#define R_VECT_MASK_RD__dma8__dma8__active 1
#define R_VECT_MASK_RD__dma8__dma8__inactive 0
#define R_VECT_MASK_RD__dma7__dma7__active 1
#define R_VECT_MASK_RD__dma7__dma7__inactive 0
#define R_VECT_MASK_RD__dma6__dma6__active 1
#define R_VECT_MASK_RD__dma6__dma6__inactive 0
#define R_VECT_MASK_RD__dma5__dma5__active 1
#define R_VECT_MASK_RD__dma5__dma5__inactive 0
#define R_VECT_MASK_RD__dma4__dma4__active 1
#define R_VECT_MASK_RD__dma4__dma4__inactive 0
#define R_VECT_MASK_RD__dma3__dma3__active 1
#define R_VECT_MASK_RD__dma3__dma3__inactive 0
#define R_VECT_MASK_RD__dma2__dma2__active 1
#define R_VECT_MASK_RD__dma2__dma2__inactive 0
#define R_VECT_MASK_RD__dma1__dma1__active 1
#define R_VECT_MASK_RD__dma1__dma1__inactive 0
#define R_VECT_MASK_RD__dma0__dma0__active 1
#define R_VECT_MASK_RD__dma0__dma0__inactive 0
#define R_VECT_MASK_RD__ext_dma1__ext_dma1__active 1
#define R_VECT_MASK_RD__ext_dma1__ext_dma1__inactive 0
#define R_VECT_MASK_RD__ext_dma0__ext_dma0__active 1
#define R_VECT_MASK_RD__ext_dma0__ext_dma0__inactive 0
#define R_VECT_MASK_RD__pa__pa__active 1
#define R_VECT_MASK_RD__pa__pa__inactive 0
#define R_VECT_MASK_RD__irq_intnr__irq_intnr__active 1
#define R_VECT_MASK_RD__irq_intnr__irq_intnr__inactive 0
#define R_VECT_MASK_RD__sw__sw__active 1
#define R_VECT_MASK_RD__sw__sw__inactive 0
#define R_VECT_MASK_RD__serial__serial__active 1
#define R_VECT_MASK_RD__serial__serial__inactive 0
#define R_VECT_MASK_RD__snmp__snmp__active 1
#define R_VECT_MASK_RD__snmp__snmp__inactive 0
#define R_VECT_MASK_RD__network__network__active 1
#define R_VECT_MASK_RD__network__network__inactive 0
#define R_VECT_MASK_RD__scsi1__scsi1__active 1
#define R_VECT_MASK_RD__scsi1__scsi1__inactive 0
#define R_VECT_MASK_RD__par1__par1__active 1
#define R_VECT_MASK_RD__par1__par1__inactive 0
#define R_VECT_MASK_RD__scsi0__scsi0__active 1
#define R_VECT_MASK_RD__scsi0__scsi0__inactive 0
#define R_VECT_MASK_RD__par0__par0__active 1
#define R_VECT_MASK_RD__par0__par0__inactive 0
#define R_VECT_MASK_RD__ata__ata__active 1
#define R_VECT_MASK_RD__ata__ata__inactive 0
#define R_VECT_MASK_RD__mio__mio__active 1
#define R_VECT_MASK_RD__mio__mio__inactive 0
#define R_VECT_MASK_RD__timer1__timer1__active 1
#define R_VECT_MASK_RD__timer1__timer1__inactive 0
#define R_VECT_MASK_RD__timer0__timer0__active 1
#define R_VECT_MASK_RD__timer0__timer0__inactive 0
#define R_VECT_MASK_RD__nmi__nmi__active 1
#define R_VECT_MASK_RD__nmi__nmi__inactive 0
#define R_VECT_MASK_RD__some__some__active 1
#define R_VECT_MASK_RD__some__some__inactive 0

#endif

/*
 *  R_VECT_MASK_SET
 *  - type:  WO
 *  - addr:  0xb00000dc
 *  - group: Interrupt mask and status registers
 */

#if USE_GROUP__Interrupt_mask_and_status_registers

#define R_VECT_MASK_SET__ADDR      (REG_TYPECAST_UDWORD  0xb00000dc)

#ifndef REG_NO_SHADOW
#define R_VECT_MASK_SET__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_VECT_MASK_SET + 0))
#define R_VECT_MASK_SET__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_VECT_MASK_SET + 0))
#else /* REG_NO_SHADOW */
#define R_VECT_MASK_SET__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_VECT_MASK_SET__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_VECT_MASK_SET__STYPECAST REG_STYPECAST_UDWORD
#define R_VECT_MASK_SET__SVAL REG_SVAL_ZERO
#define R_VECT_MASK_SET__SVAL_I REG_SVAL_I_ZERO
#define R_VECT_MASK_SET__TYPECAST  REG_TYPECAST_UDWORD
#define R_VECT_MASK_SET__TYPE      (REG_UDWORD)
#define R_VECT_MASK_SET__GET       REG_GET_WO
#define R_VECT_MASK_SET__IGET      REG_IGET_WO
#define R_VECT_MASK_SET__SET       REG_SET_WO
#define R_VECT_MASK_SET__ISET      REG_ISET_WO
#define R_VECT_MASK_SET__SET_VAL   REG_SET_VAL_WO
#define R_VECT_MASK_SET__EQL       REG_EQL_WO
#define R_VECT_MASK_SET__IEQL      REG_IEQL_WO
#define R_VECT_MASK_SET__RD        REG_RD_WO
#define R_VECT_MASK_SET__IRD       REG_IRD_WO
#define R_VECT_MASK_SET__WR        REG_WR_WO
#define R_VECT_MASK_SET__IWR       REG_IWR_WO

#define R_VECT_MASK_SET__WRITE(addr,value) \
  (*(addr) = (value))

#define R_VECT_MASK_SET__usb__usb__MASK 0x80000000U
#define R_VECT_MASK_SET__dma9__dma9__MASK 0x02000000U
#define R_VECT_MASK_SET__dma8__dma8__MASK 0x01000000U
#define R_VECT_MASK_SET__dma7__dma7__MASK 0x00800000U
#define R_VECT_MASK_SET__dma6__dma6__MASK 0x00400000U
#define R_VECT_MASK_SET__dma5__dma5__MASK 0x00200000U
#define R_VECT_MASK_SET__dma4__dma4__MASK 0x00100000U
#define R_VECT_MASK_SET__dma3__dma3__MASK 0x00080000U
#define R_VECT_MASK_SET__dma2__dma2__MASK 0x00040000U
#define R_VECT_MASK_SET__dma1__dma1__MASK 0x00020000U
#define R_VECT_MASK_SET__dma0__dma0__MASK 0x00010000U
#define R_VECT_MASK_SET__ext_dma1__ext_dma1__MASK 0x00002000U
#define R_VECT_MASK_SET__ext_dma0__ext_dma0__MASK 0x00001000U
#define R_VECT_MASK_SET__pa__pa__MASK 0x00000800U
#define R_VECT_MASK_SET__irq_intnr__irq_intnr__MASK 0x00000400U
#define R_VECT_MASK_SET__sw__sw__MASK 0x00000200U
#define R_VECT_MASK_SET__serial__serial__MASK 0x00000100U
#define R_VECT_MASK_SET__snmp__snmp__MASK 0x00000080U
#define R_VECT_MASK_SET__network__network__MASK 0x00000040U
#define R_VECT_MASK_SET__scsi1__scsi1__MASK 0x00000020U
#define R_VECT_MASK_SET__par1__par1__MASK 0x00000020U
#define R_VECT_MASK_SET__scsi1__par1__MASK 0x00000020U
#define R_VECT_MASK_SET__scsi0__scsi0__MASK 0x00000010U
#define R_VECT_MASK_SET__par0__par0__MASK 0x00000010U
#define R_VECT_MASK_SET__scsi0__par0__MASK 0x00000010U
#define R_VECT_MASK_SET__ata__ata__MASK 0x00000010U
#define R_VECT_MASK_SET__scsi0__ata__MASK 0x00000010U
#define R_VECT_MASK_SET__mio__mio__MASK 0x00000010U
#define R_VECT_MASK_SET__scsi0__mio__MASK 0x00000010U
#define R_VECT_MASK_SET__timer1__timer1__MASK 0x00000008U
#define R_VECT_MASK_SET__timer0__timer0__MASK 0x00000004U
#define R_VECT_MASK_SET__nmi__nmi__MASK 0x00000002U
#define R_VECT_MASK_SET__some__some__MASK 0x00000001U

#define R_VECT_MASK_SET__usb__MAX 0x1
#define R_VECT_MASK_SET__dma9__MAX 0x1
#define R_VECT_MASK_SET__dma8__MAX 0x1
#define R_VECT_MASK_SET__dma7__MAX 0x1
#define R_VECT_MASK_SET__dma6__MAX 0x1
#define R_VECT_MASK_SET__dma5__MAX 0x1
#define R_VECT_MASK_SET__dma4__MAX 0x1
#define R_VECT_MASK_SET__dma3__MAX 0x1
#define R_VECT_MASK_SET__dma2__MAX 0x1
#define R_VECT_MASK_SET__dma1__MAX 0x1
#define R_VECT_MASK_SET__dma0__MAX 0x1
#define R_VECT_MASK_SET__ext_dma1__MAX 0x1
#define R_VECT_MASK_SET__ext_dma0__MAX 0x1
#define R_VECT_MASK_SET__pa__MAX 0x1
#define R_VECT_MASK_SET__irq_intnr__MAX 0x1
#define R_VECT_MASK_SET__sw__MAX 0x1
#define R_VECT_MASK_SET__serial__MAX 0x1
#define R_VECT_MASK_SET__snmp__MAX 0x1
#define R_VECT_MASK_SET__network__MAX 0x1
#define R_VECT_MASK_SET__scsi1__MAX 0x1
#define R_VECT_MASK_SET__par1__MAX 0x1
#define R_VECT_MASK_SET__scsi0__MAX 0x1
#define R_VECT_MASK_SET__par0__MAX 0x1
#define R_VECT_MASK_SET__ata__MAX 0x1
#define R_VECT_MASK_SET__mio__MAX 0x1
#define R_VECT_MASK_SET__timer1__MAX 0x1
#define R_VECT_MASK_SET__timer0__MAX 0x1
#define R_VECT_MASK_SET__nmi__MAX 0x1
#define R_VECT_MASK_SET__some__MAX 0x1

#define R_VECT_MASK_SET__usb__MIN 0
#define R_VECT_MASK_SET__dma9__MIN 0
#define R_VECT_MASK_SET__dma8__MIN 0
#define R_VECT_MASK_SET__dma7__MIN 0
#define R_VECT_MASK_SET__dma6__MIN 0
#define R_VECT_MASK_SET__dma5__MIN 0
#define R_VECT_MASK_SET__dma4__MIN 0
#define R_VECT_MASK_SET__dma3__MIN 0
#define R_VECT_MASK_SET__dma2__MIN 0
#define R_VECT_MASK_SET__dma1__MIN 0
#define R_VECT_MASK_SET__dma0__MIN 0
#define R_VECT_MASK_SET__ext_dma1__MIN 0
#define R_VECT_MASK_SET__ext_dma0__MIN 0
#define R_VECT_MASK_SET__pa__MIN 0
#define R_VECT_MASK_SET__irq_intnr__MIN 0
#define R_VECT_MASK_SET__sw__MIN 0
#define R_VECT_MASK_SET__serial__MIN 0
#define R_VECT_MASK_SET__snmp__MIN 0
#define R_VECT_MASK_SET__network__MIN 0
#define R_VECT_MASK_SET__scsi1__MIN 0
#define R_VECT_MASK_SET__par1__MIN 0
#define R_VECT_MASK_SET__scsi0__MIN 0
#define R_VECT_MASK_SET__par0__MIN 0
#define R_VECT_MASK_SET__ata__MIN 0
#define R_VECT_MASK_SET__mio__MIN 0
#define R_VECT_MASK_SET__timer1__MIN 0
#define R_VECT_MASK_SET__timer0__MIN 0
#define R_VECT_MASK_SET__nmi__MIN 0
#define R_VECT_MASK_SET__some__MIN 0

#define R_VECT_MASK_SET__usb__BITNR 31
#define R_VECT_MASK_SET__dma9__BITNR 25
#define R_VECT_MASK_SET__dma8__BITNR 24
#define R_VECT_MASK_SET__dma7__BITNR 23
#define R_VECT_MASK_SET__dma6__BITNR 22
#define R_VECT_MASK_SET__dma5__BITNR 21
#define R_VECT_MASK_SET__dma4__BITNR 20
#define R_VECT_MASK_SET__dma3__BITNR 19
#define R_VECT_MASK_SET__dma2__BITNR 18
#define R_VECT_MASK_SET__dma1__BITNR 17
#define R_VECT_MASK_SET__dma0__BITNR 16
#define R_VECT_MASK_SET__ext_dma1__BITNR 13
#define R_VECT_MASK_SET__ext_dma0__BITNR 12
#define R_VECT_MASK_SET__pa__BITNR 11
#define R_VECT_MASK_SET__irq_intnr__BITNR 10
#define R_VECT_MASK_SET__sw__BITNR 9
#define R_VECT_MASK_SET__serial__BITNR 8
#define R_VECT_MASK_SET__snmp__BITNR 7
#define R_VECT_MASK_SET__network__BITNR 6
#define R_VECT_MASK_SET__scsi1__BITNR 5
#define R_VECT_MASK_SET__par1__BITNR 5
#define R_VECT_MASK_SET__scsi0__BITNR 4
#define R_VECT_MASK_SET__par0__BITNR 4
#define R_VECT_MASK_SET__ata__BITNR 4
#define R_VECT_MASK_SET__mio__BITNR 4
#define R_VECT_MASK_SET__timer1__BITNR 3
#define R_VECT_MASK_SET__timer0__BITNR 2
#define R_VECT_MASK_SET__nmi__BITNR 1
#define R_VECT_MASK_SET__some__BITNR 0

#define R_VECT_MASK_SET__usb__usb__VAL REG_VAL_ENUM
#define R_VECT_MASK_SET__dma9__dma9__VAL REG_VAL_ENUM
#define R_VECT_MASK_SET__dma8__dma8__VAL REG_VAL_ENUM
#define R_VECT_MASK_SET__dma7__dma7__VAL REG_VAL_ENUM
#define R_VECT_MASK_SET__dma6__dma6__VAL REG_VAL_ENUM
#define R_VECT_MASK_SET__dma5__dma5__VAL REG_VAL_ENUM
#define R_VECT_MASK_SET__dma4__dma4__VAL REG_VAL_ENUM
#define R_VECT_MASK_SET__dma3__dma3__VAL REG_VAL_ENUM
#define R_VECT_MASK_SET__dma2__dma2__VAL REG_VAL_ENUM
#define R_VECT_MASK_SET__dma1__dma1__VAL REG_VAL_ENUM
#define R_VECT_MASK_SET__dma0__dma0__VAL REG_VAL_ENUM
#define R_VECT_MASK_SET__ext_dma1__ext_dma1__VAL REG_VAL_ENUM
#define R_VECT_MASK_SET__ext_dma0__ext_dma0__VAL REG_VAL_ENUM
#define R_VECT_MASK_SET__pa__pa__VAL REG_VAL_ENUM
#define R_VECT_MASK_SET__irq_intnr__irq_intnr__VAL REG_VAL_ENUM
#define R_VECT_MASK_SET__sw__sw__VAL REG_VAL_ENUM
#define R_VECT_MASK_SET__serial__serial__VAL REG_VAL_ENUM
#define R_VECT_MASK_SET__snmp__snmp__VAL REG_VAL_ENUM
#define R_VECT_MASK_SET__network__network__VAL REG_VAL_ENUM
#define R_VECT_MASK_SET__scsi1__scsi1__VAL REG_VAL_ENUM
#define R_VECT_MASK_SET__par1__par1__VAL REG_VAL_ENUM
#define R_VECT_MASK_SET__scsi1__par1__VAL REG_VAL_ENUM
#define R_VECT_MASK_SET__scsi0__scsi0__VAL REG_VAL_ENUM
#define R_VECT_MASK_SET__par0__par0__VAL REG_VAL_ENUM
#define R_VECT_MASK_SET__scsi0__par0__VAL REG_VAL_ENUM
#define R_VECT_MASK_SET__ata__ata__VAL REG_VAL_ENUM
#define R_VECT_MASK_SET__scsi0__ata__VAL REG_VAL_ENUM
#define R_VECT_MASK_SET__mio__mio__VAL REG_VAL_ENUM
#define R_VECT_MASK_SET__scsi0__mio__VAL REG_VAL_ENUM
#define R_VECT_MASK_SET__timer1__timer1__VAL REG_VAL_ENUM
#define R_VECT_MASK_SET__timer0__timer0__VAL REG_VAL_ENUM
#define R_VECT_MASK_SET__nmi__nmi__VAL REG_VAL_ENUM
#define R_VECT_MASK_SET__some__some__VAL REG_VAL_ENUM

#define R_VECT_MASK_SET__usb__usb__nop 0
#define R_VECT_MASK_SET__usb__usb__set 1
#define R_VECT_MASK_SET__dma9__dma9__nop 0
#define R_VECT_MASK_SET__dma9__dma9__set 1
#define R_VECT_MASK_SET__dma8__dma8__nop 0
#define R_VECT_MASK_SET__dma8__dma8__set 1
#define R_VECT_MASK_SET__dma7__dma7__nop 0
#define R_VECT_MASK_SET__dma7__dma7__set 1
#define R_VECT_MASK_SET__dma6__dma6__nop 0
#define R_VECT_MASK_SET__dma6__dma6__set 1
#define R_VECT_MASK_SET__dma5__dma5__nop 0
#define R_VECT_MASK_SET__dma5__dma5__set 1
#define R_VECT_MASK_SET__dma4__dma4__nop 0
#define R_VECT_MASK_SET__dma4__dma4__set 1
#define R_VECT_MASK_SET__dma3__dma3__nop 0
#define R_VECT_MASK_SET__dma3__dma3__set 1
#define R_VECT_MASK_SET__dma2__dma2__nop 0
#define R_VECT_MASK_SET__dma2__dma2__set 1
#define R_VECT_MASK_SET__dma1__dma1__nop 0
#define R_VECT_MASK_SET__dma1__dma1__set 1
#define R_VECT_MASK_SET__dma0__dma0__nop 0
#define R_VECT_MASK_SET__dma0__dma0__set 1
#define R_VECT_MASK_SET__ext_dma1__ext_dma1__nop 0
#define R_VECT_MASK_SET__ext_dma1__ext_dma1__set 1
#define R_VECT_MASK_SET__ext_dma0__ext_dma0__nop 0
#define R_VECT_MASK_SET__ext_dma0__ext_dma0__set 1
#define R_VECT_MASK_SET__pa__pa__nop 0
#define R_VECT_MASK_SET__pa__pa__set 1
#define R_VECT_MASK_SET__irq_intnr__irq_intnr__nop 0
#define R_VECT_MASK_SET__irq_intnr__irq_intnr__set 1
#define R_VECT_MASK_SET__sw__sw__nop 0
#define R_VECT_MASK_SET__sw__sw__set 1
#define R_VECT_MASK_SET__serial__serial__nop 0
#define R_VECT_MASK_SET__serial__serial__set 1
#define R_VECT_MASK_SET__snmp__snmp__nop 0
#define R_VECT_MASK_SET__snmp__snmp__set 1
#define R_VECT_MASK_SET__network__network__nop 0
#define R_VECT_MASK_SET__network__network__set 1
#define R_VECT_MASK_SET__scsi1__scsi1__nop 0
#define R_VECT_MASK_SET__scsi1__scsi1__set 1
#define R_VECT_MASK_SET__par1__par1__nop 0
#define R_VECT_MASK_SET__par1__par1__set 1
#define R_VECT_MASK_SET__scsi0__scsi0__nop 0
#define R_VECT_MASK_SET__scsi0__scsi0__set 1
#define R_VECT_MASK_SET__par0__par0__nop 0
#define R_VECT_MASK_SET__par0__par0__set 1
#define R_VECT_MASK_SET__ata__ata__nop 0
#define R_VECT_MASK_SET__ata__ata__set 1
#define R_VECT_MASK_SET__mio__mio__nop 0
#define R_VECT_MASK_SET__mio__mio__set 1
#define R_VECT_MASK_SET__timer1__timer1__nop 0
#define R_VECT_MASK_SET__timer1__timer1__set 1
#define R_VECT_MASK_SET__timer0__timer0__nop 0
#define R_VECT_MASK_SET__timer0__timer0__set 1
#define R_VECT_MASK_SET__nmi__nmi__nop 0
#define R_VECT_MASK_SET__nmi__nmi__set 1
#define R_VECT_MASK_SET__some__some__nop 0
#define R_VECT_MASK_SET__some__some__set 1

#endif

/*
 *  R_VECT_READ
 *  - type:  RO
 *  - addr:  0xb00000dc
 *  - group: Interrupt mask and status registers
 */

#if USE_GROUP__Interrupt_mask_and_status_registers

#define R_VECT_READ__ADDR      (REG_TYPECAST_UDWORD  0xb00000dc)
#define R_VECT_READ__SVAL      REG_SVAL_SHADOW
#define R_VECT_READ__SVAL_I    REG_SVAL_I_SHADOW
#define R_VECT_READ__TYPECAST  REG_TYPECAST_UDWORD
#define R_VECT_READ__TYPE      (REG_UDWORD)
#define R_VECT_READ__GET       REG_GET_RO
#define R_VECT_READ__IGET      REG_IGET_RO
#define R_VECT_READ__SET       REG_SET_RO
#define R_VECT_READ__ISET      REG_ISET_RO
#define R_VECT_READ__SET_VAL   REG_SET_VAL_RO
#define R_VECT_READ__EQL       REG_EQL_RO
#define R_VECT_READ__IEQL      REG_IEQL_RO
#define R_VECT_READ__RD        REG_RD_RO
#define R_VECT_READ__IRD       REG_IRD_RO
#define R_VECT_READ__WR        REG_WR_RO
#define R_VECT_READ__IWR       REG_IWR_RO

#define R_VECT_READ__READ(addr) \
  (*(addr))

#define R_VECT_READ__usb__usb__MASK 0x80000000U
#define R_VECT_READ__dma9__dma9__MASK 0x02000000U
#define R_VECT_READ__dma8__dma8__MASK 0x01000000U
#define R_VECT_READ__dma7__dma7__MASK 0x00800000U
#define R_VECT_READ__dma6__dma6__MASK 0x00400000U
#define R_VECT_READ__dma5__dma5__MASK 0x00200000U
#define R_VECT_READ__dma4__dma4__MASK 0x00100000U
#define R_VECT_READ__dma3__dma3__MASK 0x00080000U
#define R_VECT_READ__dma2__dma2__MASK 0x00040000U
#define R_VECT_READ__dma1__dma1__MASK 0x00020000U
#define R_VECT_READ__dma0__dma0__MASK 0x00010000U
#define R_VECT_READ__ext_dma1__ext_dma1__MASK 0x00002000U
#define R_VECT_READ__ext_dma0__ext_dma0__MASK 0x00001000U
#define R_VECT_READ__pa__pa__MASK 0x00000800U
#define R_VECT_READ__irq_intnr__irq_intnr__MASK 0x00000400U
#define R_VECT_READ__sw__sw__MASK 0x00000200U
#define R_VECT_READ__serial__serial__MASK 0x00000100U
#define R_VECT_READ__snmp__snmp__MASK 0x00000080U
#define R_VECT_READ__network__network__MASK 0x00000040U
#define R_VECT_READ__scsi1__scsi1__MASK 0x00000020U
#define R_VECT_READ__par1__par1__MASK 0x00000020U
#define R_VECT_READ__scsi1__par1__MASK 0x00000020U
#define R_VECT_READ__scsi0__scsi0__MASK 0x00000010U
#define R_VECT_READ__par0__par0__MASK 0x00000010U
#define R_VECT_READ__scsi0__par0__MASK 0x00000010U
#define R_VECT_READ__ata__ata__MASK 0x00000010U
#define R_VECT_READ__scsi0__ata__MASK 0x00000010U
#define R_VECT_READ__mio__mio__MASK 0x00000010U
#define R_VECT_READ__scsi0__mio__MASK 0x00000010U
#define R_VECT_READ__timer1__timer1__MASK 0x00000008U
#define R_VECT_READ__timer0__timer0__MASK 0x00000004U
#define R_VECT_READ__nmi__nmi__MASK 0x00000002U
#define R_VECT_READ__some__some__MASK 0x00000001U

#define R_VECT_READ__usb__MAX 0x1
#define R_VECT_READ__dma9__MAX 0x1
#define R_VECT_READ__dma8__MAX 0x1
#define R_VECT_READ__dma7__MAX 0x1
#define R_VECT_READ__dma6__MAX 0x1
#define R_VECT_READ__dma5__MAX 0x1
#define R_VECT_READ__dma4__MAX 0x1
#define R_VECT_READ__dma3__MAX 0x1
#define R_VECT_READ__dma2__MAX 0x1
#define R_VECT_READ__dma1__MAX 0x1
#define R_VECT_READ__dma0__MAX 0x1
#define R_VECT_READ__ext_dma1__MAX 0x1
#define R_VECT_READ__ext_dma0__MAX 0x1
#define R_VECT_READ__pa__MAX 0x1
#define R_VECT_READ__irq_intnr__MAX 0x1
#define R_VECT_READ__sw__MAX 0x1
#define R_VECT_READ__serial__MAX 0x1
#define R_VECT_READ__snmp__MAX 0x1
#define R_VECT_READ__network__MAX 0x1
#define R_VECT_READ__scsi1__MAX 0x1
#define R_VECT_READ__par1__MAX 0x1
#define R_VECT_READ__scsi0__MAX 0x1
#define R_VECT_READ__par0__MAX 0x1
#define R_VECT_READ__ata__MAX 0x1
#define R_VECT_READ__mio__MAX 0x1
#define R_VECT_READ__timer1__MAX 0x1
#define R_VECT_READ__timer0__MAX 0x1
#define R_VECT_READ__nmi__MAX 0x1
#define R_VECT_READ__some__MAX 0x1

#define R_VECT_READ__usb__MIN 0
#define R_VECT_READ__dma9__MIN 0
#define R_VECT_READ__dma8__MIN 0
#define R_VECT_READ__dma7__MIN 0
#define R_VECT_READ__dma6__MIN 0
#define R_VECT_READ__dma5__MIN 0
#define R_VECT_READ__dma4__MIN 0
#define R_VECT_READ__dma3__MIN 0
#define R_VECT_READ__dma2__MIN 0
#define R_VECT_READ__dma1__MIN 0
#define R_VECT_READ__dma0__MIN 0
#define R_VECT_READ__ext_dma1__MIN 0
#define R_VECT_READ__ext_dma0__MIN 0
#define R_VECT_READ__pa__MIN 0
#define R_VECT_READ__irq_intnr__MIN 0
#define R_VECT_READ__sw__MIN 0
#define R_VECT_READ__serial__MIN 0
#define R_VECT_READ__snmp__MIN 0
#define R_VECT_READ__network__MIN 0
#define R_VECT_READ__scsi1__MIN 0
#define R_VECT_READ__par1__MIN 0
#define R_VECT_READ__scsi0__MIN 0
#define R_VECT_READ__par0__MIN 0
#define R_VECT_READ__ata__MIN 0
#define R_VECT_READ__mio__MIN 0
#define R_VECT_READ__timer1__MIN 0
#define R_VECT_READ__timer0__MIN 0
#define R_VECT_READ__nmi__MIN 0
#define R_VECT_READ__some__MIN 0

#define R_VECT_READ__usb__BITNR 31
#define R_VECT_READ__dma9__BITNR 25
#define R_VECT_READ__dma8__BITNR 24
#define R_VECT_READ__dma7__BITNR 23
#define R_VECT_READ__dma6__BITNR 22
#define R_VECT_READ__dma5__BITNR 21
#define R_VECT_READ__dma4__BITNR 20
#define R_VECT_READ__dma3__BITNR 19
#define R_VECT_READ__dma2__BITNR 18
#define R_VECT_READ__dma1__BITNR 17
#define R_VECT_READ__dma0__BITNR 16
#define R_VECT_READ__ext_dma1__BITNR 13
#define R_VECT_READ__ext_dma0__BITNR 12
#define R_VECT_READ__pa__BITNR 11
#define R_VECT_READ__irq_intnr__BITNR 10
#define R_VECT_READ__sw__BITNR 9
#define R_VECT_READ__serial__BITNR 8
#define R_VECT_READ__snmp__BITNR 7
#define R_VECT_READ__network__BITNR 6
#define R_VECT_READ__scsi1__BITNR 5
#define R_VECT_READ__par1__BITNR 5
#define R_VECT_READ__scsi0__BITNR 4
#define R_VECT_READ__par0__BITNR 4
#define R_VECT_READ__ata__BITNR 4
#define R_VECT_READ__mio__BITNR 4
#define R_VECT_READ__timer1__BITNR 3
#define R_VECT_READ__timer0__BITNR 2
#define R_VECT_READ__nmi__BITNR 1
#define R_VECT_READ__some__BITNR 0

#define R_VECT_READ__usb__usb__VAL REG_VAL_ENUM
#define R_VECT_READ__dma9__dma9__VAL REG_VAL_ENUM
#define R_VECT_READ__dma8__dma8__VAL REG_VAL_ENUM
#define R_VECT_READ__dma7__dma7__VAL REG_VAL_ENUM
#define R_VECT_READ__dma6__dma6__VAL REG_VAL_ENUM
#define R_VECT_READ__dma5__dma5__VAL REG_VAL_ENUM
#define R_VECT_READ__dma4__dma4__VAL REG_VAL_ENUM
#define R_VECT_READ__dma3__dma3__VAL REG_VAL_ENUM
#define R_VECT_READ__dma2__dma2__VAL REG_VAL_ENUM
#define R_VECT_READ__dma1__dma1__VAL REG_VAL_ENUM
#define R_VECT_READ__dma0__dma0__VAL REG_VAL_ENUM
#define R_VECT_READ__ext_dma1__ext_dma1__VAL REG_VAL_ENUM
#define R_VECT_READ__ext_dma0__ext_dma0__VAL REG_VAL_ENUM
#define R_VECT_READ__pa__pa__VAL REG_VAL_ENUM
#define R_VECT_READ__irq_intnr__irq_intnr__VAL REG_VAL_ENUM
#define R_VECT_READ__sw__sw__VAL REG_VAL_ENUM
#define R_VECT_READ__serial__serial__VAL REG_VAL_ENUM
#define R_VECT_READ__snmp__snmp__VAL REG_VAL_ENUM
#define R_VECT_READ__network__network__VAL REG_VAL_ENUM
#define R_VECT_READ__scsi1__scsi1__VAL REG_VAL_ENUM
#define R_VECT_READ__par1__par1__VAL REG_VAL_ENUM
#define R_VECT_READ__scsi1__par1__VAL REG_VAL_ENUM
#define R_VECT_READ__scsi0__scsi0__VAL REG_VAL_ENUM
#define R_VECT_READ__par0__par0__VAL REG_VAL_ENUM
#define R_VECT_READ__scsi0__par0__VAL REG_VAL_ENUM
#define R_VECT_READ__ata__ata__VAL REG_VAL_ENUM
#define R_VECT_READ__scsi0__ata__VAL REG_VAL_ENUM
#define R_VECT_READ__mio__mio__VAL REG_VAL_ENUM
#define R_VECT_READ__scsi0__mio__VAL REG_VAL_ENUM
#define R_VECT_READ__timer1__timer1__VAL REG_VAL_ENUM
#define R_VECT_READ__timer0__timer0__VAL REG_VAL_ENUM
#define R_VECT_READ__nmi__nmi__VAL REG_VAL_ENUM
#define R_VECT_READ__some__some__VAL REG_VAL_ENUM

#define R_VECT_READ__usb__usb__active 1
#define R_VECT_READ__usb__usb__inactive 0
#define R_VECT_READ__dma9__dma9__active 1
#define R_VECT_READ__dma9__dma9__inactive 0
#define R_VECT_READ__dma8__dma8__active 1
#define R_VECT_READ__dma8__dma8__inactive 0
#define R_VECT_READ__dma7__dma7__active 1
#define R_VECT_READ__dma7__dma7__inactive 0
#define R_VECT_READ__dma6__dma6__active 1
#define R_VECT_READ__dma6__dma6__inactive 0
#define R_VECT_READ__dma5__dma5__active 1
#define R_VECT_READ__dma5__dma5__inactive 0
#define R_VECT_READ__dma4__dma4__active 1
#define R_VECT_READ__dma4__dma4__inactive 0
#define R_VECT_READ__dma3__dma3__active 1
#define R_VECT_READ__dma3__dma3__inactive 0
#define R_VECT_READ__dma2__dma2__active 1
#define R_VECT_READ__dma2__dma2__inactive 0
#define R_VECT_READ__dma1__dma1__active 1
#define R_VECT_READ__dma1__dma1__inactive 0
#define R_VECT_READ__dma0__dma0__active 1
#define R_VECT_READ__dma0__dma0__inactive 0
#define R_VECT_READ__ext_dma1__ext_dma1__active 1
#define R_VECT_READ__ext_dma1__ext_dma1__inactive 0
#define R_VECT_READ__ext_dma0__ext_dma0__active 1
#define R_VECT_READ__ext_dma0__ext_dma0__inactive 0
#define R_VECT_READ__pa__pa__active 1
#define R_VECT_READ__pa__pa__inactive 0
#define R_VECT_READ__irq_intnr__irq_intnr__active 1
#define R_VECT_READ__irq_intnr__irq_intnr__inactive 0
#define R_VECT_READ__sw__sw__active 1
#define R_VECT_READ__sw__sw__inactive 0
#define R_VECT_READ__serial__serial__active 1
#define R_VECT_READ__serial__serial__inactive 0
#define R_VECT_READ__snmp__snmp__active 1
#define R_VECT_READ__snmp__snmp__inactive 0
#define R_VECT_READ__network__network__active 1
#define R_VECT_READ__network__network__inactive 0
#define R_VECT_READ__scsi1__scsi1__active 1
#define R_VECT_READ__scsi1__scsi1__inactive 0
#define R_VECT_READ__par1__par1__active 1
#define R_VECT_READ__par1__par1__inactive 0
#define R_VECT_READ__scsi0__scsi0__active 1
#define R_VECT_READ__scsi0__scsi0__inactive 0
#define R_VECT_READ__par0__par0__active 1
#define R_VECT_READ__par0__par0__inactive 0
#define R_VECT_READ__ata__ata__active 1
#define R_VECT_READ__ata__ata__inactive 0
#define R_VECT_READ__mio__mio__active 1
#define R_VECT_READ__mio__mio__inactive 0
#define R_VECT_READ__timer1__timer1__active 1
#define R_VECT_READ__timer1__timer1__inactive 0
#define R_VECT_READ__timer0__timer0__active 1
#define R_VECT_READ__timer0__timer0__inactive 0
#define R_VECT_READ__nmi__nmi__active 1
#define R_VECT_READ__nmi__nmi__inactive 0
#define R_VECT_READ__some__some__active 1
#define R_VECT_READ__some__some__inactive 0

#endif

/*
 *  R_WAITSTATES
 *  - type:  WO
 *  - addr:  0xb0000000
 *  - group: Bus interface configuration registers
 */

#if USE_GROUP__Bus_interface_configuration_registers

#define R_WAITSTATES__ADDR      (REG_TYPECAST_UDWORD  0xb0000000)

#ifndef REG_NO_SHADOW
#define R_WAITSTATES__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_WAITSTATES + 0))
#define R_WAITSTATES__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_WAITSTATES + 0))
#else /* REG_NO_SHADOW */
#define R_WAITSTATES__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_WAITSTATES__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_WAITSTATES__STYPECAST REG_STYPECAST_UDWORD
#define R_WAITSTATES__SVAL      REG_SVAL_SHADOW
#define R_WAITSTATES__SVAL_I    REG_SVAL_I_SHADOW
#define R_WAITSTATES__TYPECAST  REG_TYPECAST_UDWORD
#define R_WAITSTATES__TYPE      (REG_UDWORD)
#define R_WAITSTATES__GET       REG_GET_WO
#define R_WAITSTATES__IGET      REG_IGET_WO
#define R_WAITSTATES__SET       REG_SET_WO
#define R_WAITSTATES__ISET      REG_ISET_WO
#define R_WAITSTATES__SET_VAL   REG_SET_VAL_WO
#define R_WAITSTATES__EQL       REG_EQL_WO
#define R_WAITSTATES__IEQL      REG_IEQL_WO
#define R_WAITSTATES__RD        REG_RD_WO
#define R_WAITSTATES__IRD       REG_IRD_WO
#define R_WAITSTATES__WR        REG_WR_WO
#define R_WAITSTATES__IWR       REG_IWR_WO

#define R_WAITSTATES__WRITE(addr,value) \
  (*(addr) = (value))

#define R_WAITSTATES__pcs4_7_zw__pcs4_7_zw__MASK 0xc0000000U
#define R_WAITSTATES__pcs4_7_ew__pcs4_7_ew__MASK 0x30000000U
#define R_WAITSTATES__pcs4_7_lw__pcs4_7_lw__MASK 0x0f000000U
#define R_WAITSTATES__pcs0_3_zw__pcs0_3_zw__MASK 0x00c00000U
#define R_WAITSTATES__pcs0_3_ew__pcs0_3_ew__MASK 0x00300000U
#define R_WAITSTATES__pcs0_3_lw__pcs0_3_lw__MASK 0x000f0000U
#define R_WAITSTATES__sram_zw__sram_zw__MASK 0x0000c000U
#define R_WAITSTATES__sram_ew__sram_ew__MASK 0x00003000U
#define R_WAITSTATES__sram_lw__sram_lw__MASK 0x00000f00U
#define R_WAITSTATES__flash_zw__flash_zw__MASK 0x000000c0U
#define R_WAITSTATES__flash_ew__flash_ew__MASK 0x00000030U
#define R_WAITSTATES__flash_lw__flash_lw__MASK 0x0000000fU

#define R_WAITSTATES__pcs4_7_zw__MAX 3
#define R_WAITSTATES__pcs4_7_ew__MAX 3
#define R_WAITSTATES__pcs4_7_lw__MAX 15
#define R_WAITSTATES__pcs0_3_zw__MAX 3
#define R_WAITSTATES__pcs0_3_ew__MAX 3
#define R_WAITSTATES__pcs0_3_lw__MAX 15
#define R_WAITSTATES__sram_zw__MAX 3
#define R_WAITSTATES__sram_ew__MAX 3
#define R_WAITSTATES__sram_lw__MAX 15
#define R_WAITSTATES__flash_zw__MAX 3
#define R_WAITSTATES__flash_ew__MAX 3
#define R_WAITSTATES__flash_lw__MAX 15

#define R_WAITSTATES__pcs4_7_zw__MIN 0
#define R_WAITSTATES__pcs4_7_ew__MIN 0
#define R_WAITSTATES__pcs4_7_lw__MIN 0
#define R_WAITSTATES__pcs0_3_zw__MIN 0
#define R_WAITSTATES__pcs0_3_ew__MIN 0
#define R_WAITSTATES__pcs0_3_lw__MIN 0
#define R_WAITSTATES__sram_zw__MIN 0
#define R_WAITSTATES__sram_ew__MIN 0
#define R_WAITSTATES__sram_lw__MIN 0
#define R_WAITSTATES__flash_zw__MIN 0
#define R_WAITSTATES__flash_ew__MIN 0
#define R_WAITSTATES__flash_lw__MIN 0

#define R_WAITSTATES__pcs4_7_zw__BITNR 30
#define R_WAITSTATES__pcs4_7_ew__BITNR 28
#define R_WAITSTATES__pcs4_7_lw__BITNR 24
#define R_WAITSTATES__pcs0_3_zw__BITNR 22
#define R_WAITSTATES__pcs0_3_ew__BITNR 20
#define R_WAITSTATES__pcs0_3_lw__BITNR 16
#define R_WAITSTATES__sram_zw__BITNR 14
#define R_WAITSTATES__sram_ew__BITNR 12
#define R_WAITSTATES__sram_lw__BITNR 8
#define R_WAITSTATES__flash_zw__BITNR 6
#define R_WAITSTATES__flash_ew__BITNR 4
#define R_WAITSTATES__flash_lw__BITNR 0

#define R_WAITSTATES__pcs4_7_zw__pcs4_7_zw__VAL REG_VAL_VAL
#define R_WAITSTATES__pcs4_7_ew__pcs4_7_ew__VAL REG_VAL_VAL
#define R_WAITSTATES__pcs4_7_lw__pcs4_7_lw__VAL REG_VAL_VAL
#define R_WAITSTATES__pcs0_3_zw__pcs0_3_zw__VAL REG_VAL_VAL
#define R_WAITSTATES__pcs0_3_ew__pcs0_3_ew__VAL REG_VAL_VAL
#define R_WAITSTATES__pcs0_3_lw__pcs0_3_lw__VAL REG_VAL_VAL
#define R_WAITSTATES__sram_zw__sram_zw__VAL REG_VAL_VAL
#define R_WAITSTATES__sram_ew__sram_ew__VAL REG_VAL_VAL
#define R_WAITSTATES__sram_lw__sram_lw__VAL REG_VAL_VAL
#define R_WAITSTATES__flash_zw__flash_zw__VAL REG_VAL_VAL
#define R_WAITSTATES__flash_ew__flash_ew__VAL REG_VAL_VAL
#define R_WAITSTATES__flash_lw__flash_lw__VAL REG_VAL_VAL


#endif

/*
 *  R_WATCHDOG
 *  - type:  WO
 *  - addr:  0xb0000024
 *  - group: Timer registers
 */

#if USE_GROUP__Timer_registers

#define R_WATCHDOG__ADDR      (REG_TYPECAST_UDWORD  0xb0000024)

#ifndef REG_NO_SHADOW
#define R_WATCHDOG__SADDR     (REG_STYPECAST_UDWORD (reg_shadow__hwregs.R_WATCHDOG + 0))
#define R_WATCHDOG__IADDR     (REG_STYPECAST_UDWORD (reg_initiated__hwregs.R_WATCHDOG + 0))
#else /* REG_NO_SHADOW */
#define R_WATCHDOG__SADDR     (REG_STYPECAST_UDWORD (&reg_shadow__hwregs))
#define R_WATCHDOG__IADDR     (REG_STYPECAST_UDWORD (&reg_initiated__hwregs))
#endif /* REG_NO_SHADOW */

#define R_WATCHDOG__STYPECAST REG_STYPECAST_UDWORD
#define R_WATCHDOG__SVAL      REG_SVAL_SHADOW
#define R_WATCHDOG__SVAL_I    REG_SVAL_I_SHADOW
#define R_WATCHDOG__TYPECAST  REG_TYPECAST_UDWORD
#define R_WATCHDOG__TYPE      (REG_UDWORD)
#define R_WATCHDOG__GET       REG_GET_WO
#define R_WATCHDOG__IGET      REG_IGET_WO
#define R_WATCHDOG__SET       REG_SET_WO
#define R_WATCHDOG__ISET      REG_ISET_WO
#define R_WATCHDOG__SET_VAL   REG_SET_VAL_WO
#define R_WATCHDOG__EQL       REG_EQL_WO
#define R_WATCHDOG__IEQL      REG_IEQL_WO
#define R_WATCHDOG__RD        REG_RD_WO
#define R_WATCHDOG__IRD       REG_IRD_WO
#define R_WATCHDOG__WR        REG_WR_WO
#define R_WATCHDOG__IWR       REG_IWR_WO

#define R_WATCHDOG__WRITE(addr,value) \
  (*(addr) = (value))

#define R_WATCHDOG__key__key__MASK 0x0000000eU
#define R_WATCHDOG__enable__enable__MASK 0x00000001U

#define R_WATCHDOG__key__MAX 7
#define R_WATCHDOG__enable__MAX 0x1

#define R_WATCHDOG__key__MIN 0
#define R_WATCHDOG__enable__MIN 0

#define R_WATCHDOG__key__BITNR 1
#define R_WATCHDOG__enable__BITNR 0

#define R_WATCHDOG__key__key__VAL REG_VAL_VAL
#define R_WATCHDOG__enable__enable__VAL REG_VAL_ENUM

#define R_WATCHDOG__enable__enable__start 1
#define R_WATCHDOG__enable__enable__stop 0

#endif

#endif
