# This file is part of the OpenADK project. OpenADK is copyrighted
# material, please see the LICENCE file in the top-level directory.
#
# On the various kernel version variables:
#
# KERNEL_FILE_VER: version numbering used for tarball and contained top level
#                  directory (e.g. linux-4.1.2.tar.bz2 -> linux-4.1.2) (not
#                  necessary equal to kernel's version, e.g. linux-3.19
#                  contains kernel version 3.19.0)
# KERNEL_RELEASE:  OpenADK internal versioning
# KERNEL_VERSION:  final kernel version how we want to identify a specific kernel

ifeq ($(ADK_TARGET_LINUX_KERNEL_VERSION_GIT),y)
KERNEL_FILE_VER:=	$(ADK_TARGET_LINUX_KERNEL_GIT)
KERNEL_RELEASE:=	1
KERNEL_VERSION:=	$(ADK_TARGET_LINUX_KERNEL_GIT_VER)-$(KERNEL_RELEASE)
endif
ifeq ($(ADK_TARGET_LINUX_KERNEL_VERSION_6_13),y)
KERNEL_FILE_VER:=	6.13.9
KERNEL_RELEASE:=	1
KERNEL_VERSION:=	$(KERNEL_FILE_VER)-$(KERNEL_RELEASE)
KERNEL_HASH:=		53e7a3f028b6119ba499245bde0fa10275752817408a4a36b5a34ad74a4727b2
endif
ifeq ($(ADK_TARGET_LINUX_KERNEL_VERSION_6_12),y)
KERNEL_FILE_VER:=	6.12.18
KERNEL_RELEASE:=	1
KERNEL_VERSION:=	$(KERNEL_FILE_VER)-$(KERNEL_RELEASE)
KERNEL_HASH:=		beb902a5f69d9e57710112203db38111dad6d30556ea8ce389284c8077fe944d
endif
ifeq ($(ADK_TARGET_LINUX_KERNEL_VERSION_6_6),y)
KERNEL_FILE_VER:=	6.6.82
KERNEL_RELEASE:=	1
KERNEL_VERSION:=	$(KERNEL_FILE_VER)-$(KERNEL_RELEASE)
KERNEL_HASH:=		f3c2389b8c23cabe747f104a3e434201ca6e7725bbbfb3a8c59a063ac4820e41
endif
ifeq ($(ADK_TARGET_LINUX_KERNEL_VERSION_6_1),y)
KERNEL_FILE_VER:=	6.1.130
KERNEL_RELEASE:=	1
KERNEL_VERSION:=	$(KERNEL_FILE_VER)-$(KERNEL_RELEASE)
KERNEL_HASH:=		9416b2c2d448ec7f54bb0ce5713fb34c32dae4a4edf1abd8cf7a8995cbac66fd
endif
ifeq ($(ADK_TARGET_LINUX_KERNEL_VERSION_5_15),y)
KERNEL_FILE_VER:=	5.15.178
KERNEL_RELEASE:=	1
KERNEL_VERSION:=	$(KERNEL_FILE_VER)-$(KERNEL_RELEASE)
KERNEL_HASH:=		efe9f7eb5ea4d26cec6290689343e1804eb3b4a88ff5a60497a696fc08157c42
endif
ifeq ($(ADK_TARGET_LINUX_KERNEL_VERSION_5_10),y)
KERNEL_FILE_VER:=	5.10.234
KERNEL_RELEASE:=	1
KERNEL_VERSION:=	$(KERNEL_FILE_VER)-$(KERNEL_RELEASE)
KERNEL_HASH:=		9597c4fee2f1ce452acfec516f4325ad342155872052fd5f0d9ce2ddcc26ebe5
endif
ifeq ($(ADK_TARGET_LINUX_KERNEL_VERSION_5_4),y)
KERNEL_FILE_VER:=	5.4.289
KERNEL_RELEASE:=	1
KERNEL_VERSION:=	$(KERNEL_FILE_VER)-$(KERNEL_RELEASE)
KERNEL_HASH:=		1e3e5fc052c8e15f8eaa37d30bf4f0b3eef7430dd234d9fed0d0005852a06d10
endif
ifeq ($(ADK_TARGET_LINUX_KERNEL_VERSION_4_19),y)
KERNEL_FILE_VER:=	4.19.320
KERNEL_RELEASE:=	1
KERNEL_VERSION:=	$(KERNEL_FILE_VER)-$(KERNEL_RELEASE)
KERNEL_HASH:=		9d671a12b00301b7ce63022d4e4afa3e40aa318f8f7f25a1147e602fdb1047a1
endif
ifeq ($(ADK_TARGET_LINUX_KERNEL_VERSION_4_14),y)
KERNEL_FILE_VER:=	4.14.334
KERNEL_RELEASE:=	1
KERNEL_VERSION:=	$(KERNEL_FILE_VER)-$(KERNEL_RELEASE)
KERNEL_HASH:=		8a1d520cfa71e9faebae9d8c24101f5bffe48fcb897dede4cecad5af67c34a45
endif
ifeq ($(ADK_TARGET_LINUX_KERNEL_VERSION_4_9),y)
KERNEL_FILE_VER:=	4.9.287
KERNEL_RELEASE:=	1
KERNEL_VERSION:=	$(KERNEL_FILE_VER)-$(KERNEL_RELEASE)
KERNEL_HASH:=		d44128674702529dd26214d6cd1c19542c37c5cc516f352bebbb78f0a9ed97c2
endif
ifeq ($(ADK_TARGET_LINUX_KERNEL_VERSION_4_4),y)
KERNEL_FILE_VER:=	4.4.302
KERNEL_RELEASE:=	1
KERNEL_VERSION:=	$(KERNEL_FILE_VER)-$(KERNEL_RELEASE)
KERNEL_HASH:=		35017bb40b604e0b577fc2b87e727632b46608a2ba3a4f5858b9177f58f376b3
endif
ifeq ($(ADK_TARGET_LINUX_KERNEL_VERSION_3_16),y)
KERNEL_FILE_VER:=	3.16.85
KERNEL_RELEASE:=	1
KERNEL_VERSION:=	$(KERNEL_FILE_VER)-$(KERNEL_RELEASE)
KERNEL_HASH:=		80b1598d389c94e83fdf15d99c7da452aeb3093fbf8ed7c91584c06c09fc1fa6
endif
ifeq ($(ADK_TARGET_LINUX_KERNEL_VERSION_3_4),y)
KERNEL_FILE_VER:=	3.4.112
KERNEL_RELEASE:=	1
KERNEL_VERSION:=	$(KERNEL_FILE_VER)-$(KERNEL_RELEASE)
KERNEL_HASH:=		29c8370c4c6e639ad5e38e6eb052058d5f45add3167f2aa4cc08e6569f024181
endif
ifeq ($(ADK_TARGET_LINUX_KERNEL_VERSION_2_6_32),y)
KERNEL_FILE_VER:=	2.6.32.70
KERNEL_RELEASE:=	1
KERNEL_VERSION:=	$(KERNEL_FILE_VER)-$(KERNEL_RELEASE)
KERNEL_HASH:=		d7d0ee4588711d4f85ed67b65d447b4bbbe215e600a771fb87a62524b6341c43
endif
